# Get common_TARGET_OPTS_STR
string(APPEND CMAKE_ASM_FLAGS_INIT " -x assembler-with-cpp")
include(${CMAKE_CURRENT_LIST_DIR}/common_arm_cortex_m7.cmake)
string(APPEND CMAKE_ASM_FLAGS_INIT " ${common_TARGET_OPTS_STR}")
string(PREPEND CMAKE_ASM_FLAGS_INIT " --specs=nosys.specs")

# Depending on the content of CMAKE_C_FLAGS_INIT, the following switches aimed at the linker may appear 
# multiple times on the final command-line, since for SEGGER the same compiler driver is used for compilation as well as for linking.
# Furthermore, it depends on the project setup, whether CMAKE_C_FLAGS or CMAKE_CXX_FLAGS or CMAKE_ASM_FLAGS get passed to the compiler driver for the link stage.
# Cmake appears to consider the settings in this order of decreasin preference CMAKE_C_FLAGS, CMAKE_CXX_FLAGS, CMAKE_ASM_FLAGS. If the project language settings
# define C, then CMake will use the driver as a "C" linker etc.
if(NOT CMAKE_EXE_LINKER_FLAGS_INIT MATCHES " -mcpu=cortex-m7")
  string(APPEND CMAKE_EXE_LINKER_FLAGS_INIT " -mcpu=cortex-m7")
endif()
unset(common_TARGET_OPTS_STR)
