/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2017 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak GPIOA_IRQHandler
  .thumb_set GPIOA_IRQHandler,Dummy_Handler

  .weak GPIOB_IRQHandler
  .thumb_set GPIOB_IRQHandler,Dummy_Handler

  .weak GPIOC_IRQHandler
  .thumb_set GPIOC_IRQHandler,Dummy_Handler

  .weak GPIOD_IRQHandler
  .thumb_set GPIOD_IRQHandler,Dummy_Handler

  .weak GPIOE_IRQHandler
  .thumb_set GPIOE_IRQHandler,Dummy_Handler

  .weak UART0_IRQHandler
  .thumb_set UART0_IRQHandler,Dummy_Handler

  .weak UART1_IRQHandler
  .thumb_set UART1_IRQHandler,Dummy_Handler

  .weak SSI0_IRQHandler
  .thumb_set SSI0_IRQHandler,Dummy_Handler

  .weak I2C0_IRQHandler
  .thumb_set I2C0_IRQHandler,Dummy_Handler

  .weak PWM0_FAULT_IRQHandler
  .thumb_set PWM0_FAULT_IRQHandler,Dummy_Handler

  .weak PWM0_0_IRQHandler
  .thumb_set PWM0_0_IRQHandler,Dummy_Handler

  .weak PWM0_1_IRQHandler
  .thumb_set PWM0_1_IRQHandler,Dummy_Handler

  .weak PWM0_2_IRQHandler
  .thumb_set PWM0_2_IRQHandler,Dummy_Handler

  .weak QEI0_IRQHandler
  .thumb_set QEI0_IRQHandler,Dummy_Handler

  .weak ADC0SS0_IRQHandler
  .thumb_set ADC0SS0_IRQHandler,Dummy_Handler

  .weak ADC0SS1_IRQHandler
  .thumb_set ADC0SS1_IRQHandler,Dummy_Handler

  .weak ADC0SS2_IRQHandler
  .thumb_set ADC0SS2_IRQHandler,Dummy_Handler

  .weak ADC0SS3_IRQHandler
  .thumb_set ADC0SS3_IRQHandler,Dummy_Handler

  .weak WATCHDOG0_IRQHandler
  .thumb_set WATCHDOG0_IRQHandler,Dummy_Handler

  .weak TIMER0A_IRQHandler
  .thumb_set TIMER0A_IRQHandler,Dummy_Handler

  .weak TIMER0B_IRQHandler
  .thumb_set TIMER0B_IRQHandler,Dummy_Handler

  .weak TIMER1A_IRQHandler
  .thumb_set TIMER1A_IRQHandler,Dummy_Handler

  .weak TIMER1B_IRQHandler
  .thumb_set TIMER1B_IRQHandler,Dummy_Handler

  .weak TIMER2A_IRQHandler
  .thumb_set TIMER2A_IRQHandler,Dummy_Handler

  .weak TIMER2B_IRQHandler
  .thumb_set TIMER2B_IRQHandler,Dummy_Handler

  .weak COMP0_IRQHandler
  .thumb_set COMP0_IRQHandler,Dummy_Handler

  .weak COMP1_IRQHandler
  .thumb_set COMP1_IRQHandler,Dummy_Handler

  .weak COMP2_IRQHandler
  .thumb_set COMP2_IRQHandler,Dummy_Handler

  .weak SYSCTL_IRQHandler
  .thumb_set SYSCTL_IRQHandler,Dummy_Handler

  .weak FLASH_CTRL_IRQHandler
  .thumb_set FLASH_CTRL_IRQHandler,Dummy_Handler

  .weak GPIOF_IRQHandler
  .thumb_set GPIOF_IRQHandler,Dummy_Handler

  .weak GPIOG_IRQHandler
  .thumb_set GPIOG_IRQHandler,Dummy_Handler

  .weak GPIOH_IRQHandler
  .thumb_set GPIOH_IRQHandler,Dummy_Handler

  .weak UART2_IRQHandler
  .thumb_set UART2_IRQHandler,Dummy_Handler

  .weak SSI1_IRQHandler
  .thumb_set SSI1_IRQHandler,Dummy_Handler

  .weak TIMER3A_IRQHandler
  .thumb_set TIMER3A_IRQHandler,Dummy_Handler

  .weak TIMER3B_IRQHandler
  .thumb_set TIMER3B_IRQHandler,Dummy_Handler

  .weak I2C1_IRQHandler
  .thumb_set I2C1_IRQHandler,Dummy_Handler

  .weak CAN0_IRQHandler
  .thumb_set CAN0_IRQHandler,Dummy_Handler

  .weak CAN1_IRQHandler
  .thumb_set CAN1_IRQHandler,Dummy_Handler

  .weak EMAC0_IRQHandler
  .thumb_set EMAC0_IRQHandler,Dummy_Handler

  .weak HIB_IRQHandler
  .thumb_set HIB_IRQHandler,Dummy_Handler

  .weak USB0_IRQHandler
  .thumb_set USB0_IRQHandler,Dummy_Handler

  .weak PWM0_3_IRQHandler
  .thumb_set PWM0_3_IRQHandler,Dummy_Handler

  .weak UDMA_IRQHandler
  .thumb_set UDMA_IRQHandler,Dummy_Handler

  .weak UDMAERR_IRQHandler
  .thumb_set UDMAERR_IRQHandler,Dummy_Handler

  .weak ADC1SS0_IRQHandler
  .thumb_set ADC1SS0_IRQHandler,Dummy_Handler

  .weak ADC1SS1_IRQHandler
  .thumb_set ADC1SS1_IRQHandler,Dummy_Handler

  .weak ADC1SS2_IRQHandler
  .thumb_set ADC1SS2_IRQHandler,Dummy_Handler

  .weak ADC1SS3_IRQHandler
  .thumb_set ADC1SS3_IRQHandler,Dummy_Handler

  .weak EPI0_IRQHandler
  .thumb_set EPI0_IRQHandler,Dummy_Handler

  .weak GPIOJ_IRQHandler
  .thumb_set GPIOJ_IRQHandler,Dummy_Handler

  .weak GPIOK_IRQHandler
  .thumb_set GPIOK_IRQHandler,Dummy_Handler

  .weak GPIOL_IRQHandler
  .thumb_set GPIOL_IRQHandler,Dummy_Handler

  .weak SSI2_IRQHandler
  .thumb_set SSI2_IRQHandler,Dummy_Handler

  .weak SSI3_IRQHandler
  .thumb_set SSI3_IRQHandler,Dummy_Handler

  .weak UART3_IRQHandler
  .thumb_set UART3_IRQHandler,Dummy_Handler

  .weak UART4_IRQHandler
  .thumb_set UART4_IRQHandler,Dummy_Handler

  .weak UART5_IRQHandler
  .thumb_set UART5_IRQHandler,Dummy_Handler

  .weak UART6_IRQHandler
  .thumb_set UART6_IRQHandler,Dummy_Handler

  .weak UART7_IRQHandler
  .thumb_set UART7_IRQHandler,Dummy_Handler

  .weak I2C2_IRQHandler
  .thumb_set I2C2_IRQHandler,Dummy_Handler

  .weak I2C3_IRQHandler
  .thumb_set I2C3_IRQHandler,Dummy_Handler

  .weak TIMER4A_IRQHandler
  .thumb_set TIMER4A_IRQHandler,Dummy_Handler

  .weak TIMER4B_IRQHandler
  .thumb_set TIMER4B_IRQHandler,Dummy_Handler

  .weak TIMER5A_IRQHandler
  .thumb_set TIMER5A_IRQHandler,Dummy_Handler

  .weak TIMER5B_IRQHandler
  .thumb_set TIMER5B_IRQHandler,Dummy_Handler

  .weak SYSEXC_IRQHandler
  .thumb_set SYSEXC_IRQHandler,Dummy_Handler

  .weak I2C4_IRQHandler
  .thumb_set I2C4_IRQHandler,Dummy_Handler

  .weak I2C5_IRQHandler
  .thumb_set I2C5_IRQHandler,Dummy_Handler

  .weak GPIOM_IRQHandler
  .thumb_set GPIOM_IRQHandler,Dummy_Handler

  .weak GPION_IRQHandler
  .thumb_set GPION_IRQHandler,Dummy_Handler

  .weak GPIOP0_IRQHandler
  .thumb_set GPIOP0_IRQHandler,Dummy_Handler

  .weak GPIOP1_IRQHandler
  .thumb_set GPIOP1_IRQHandler,Dummy_Handler

  .weak GPIOP2_IRQHandler
  .thumb_set GPIOP2_IRQHandler,Dummy_Handler

  .weak GPIOP3_IRQHandler
  .thumb_set GPIOP3_IRQHandler,Dummy_Handler

  .weak GPIOP4_IRQHandler
  .thumb_set GPIOP4_IRQHandler,Dummy_Handler

  .weak GPIOP5_IRQHandler
  .thumb_set GPIOP5_IRQHandler,Dummy_Handler

  .weak GPIOP6_IRQHandler
  .thumb_set GPIOP6_IRQHandler,Dummy_Handler

  .weak GPIOP7_IRQHandler
  .thumb_set GPIOP7_IRQHandler,Dummy_Handler

  .weak GPIOQ0_IRQHandler
  .thumb_set GPIOQ0_IRQHandler,Dummy_Handler

  .weak GPIOQ1_IRQHandler
  .thumb_set GPIOQ1_IRQHandler,Dummy_Handler

  .weak GPIOQ2_IRQHandler
  .thumb_set GPIOQ2_IRQHandler,Dummy_Handler

  .weak GPIOQ3_IRQHandler
  .thumb_set GPIOQ3_IRQHandler,Dummy_Handler

  .weak GPIOQ4_IRQHandler
  .thumb_set GPIOQ4_IRQHandler,Dummy_Handler

  .weak GPIOQ5_IRQHandler
  .thumb_set GPIOQ5_IRQHandler,Dummy_Handler

  .weak GPIOQ6_IRQHandler
  .thumb_set GPIOQ6_IRQHandler,Dummy_Handler

  .weak GPIOQ7_IRQHandler
  .thumb_set GPIOQ7_IRQHandler,Dummy_Handler

  .weak TIMER6A_IRQHandler
  .thumb_set TIMER6A_IRQHandler,Dummy_Handler

  .weak TIMER6B_IRQHandler
  .thumb_set TIMER6B_IRQHandler,Dummy_Handler

  .weak TIMER7A_IRQHandler
  .thumb_set TIMER7A_IRQHandler,Dummy_Handler

  .weak TIMER7B_IRQHandler
  .thumb_set TIMER7B_IRQHandler,Dummy_Handler

  .weak I2C6_IRQHandler
  .thumb_set I2C6_IRQHandler,Dummy_Handler

  .weak I2C7_IRQHandler
  .thumb_set I2C7_IRQHandler,Dummy_Handler

  .weak I2C8_IRQHandler
  .thumb_set I2C8_IRQHandler,Dummy_Handler

  .weak I2C9_IRQHandler
  .thumb_set I2C9_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak GPIOA_IRQHandler
GPIOA_IRQHandler:
  b .

  .thumb_func
  .weak GPIOB_IRQHandler
GPIOB_IRQHandler:
  b .

  .thumb_func
  .weak GPIOC_IRQHandler
GPIOC_IRQHandler:
  b .

  .thumb_func
  .weak GPIOD_IRQHandler
GPIOD_IRQHandler:
  b .

  .thumb_func
  .weak GPIOE_IRQHandler
GPIOE_IRQHandler:
  b .

  .thumb_func
  .weak UART0_IRQHandler
UART0_IRQHandler:
  b .

  .thumb_func
  .weak UART1_IRQHandler
UART1_IRQHandler:
  b .

  .thumb_func
  .weak SSI0_IRQHandler
SSI0_IRQHandler:
  b .

  .thumb_func
  .weak I2C0_IRQHandler
I2C0_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_FAULT_IRQHandler
PWM0_FAULT_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_0_IRQHandler
PWM0_0_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_1_IRQHandler
PWM0_1_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_2_IRQHandler
PWM0_2_IRQHandler:
  b .

  .thumb_func
  .weak QEI0_IRQHandler
QEI0_IRQHandler:
  b .

  .thumb_func
  .weak ADC0SS0_IRQHandler
ADC0SS0_IRQHandler:
  b .

  .thumb_func
  .weak ADC0SS1_IRQHandler
ADC0SS1_IRQHandler:
  b .

  .thumb_func
  .weak ADC0SS2_IRQHandler
ADC0SS2_IRQHandler:
  b .

  .thumb_func
  .weak ADC0SS3_IRQHandler
ADC0SS3_IRQHandler:
  b .

  .thumb_func
  .weak WATCHDOG0_IRQHandler
WATCHDOG0_IRQHandler:
  b .

  .thumb_func
  .weak TIMER0A_IRQHandler
TIMER0A_IRQHandler:
  b .

  .thumb_func
  .weak TIMER0B_IRQHandler
TIMER0B_IRQHandler:
  b .

  .thumb_func
  .weak TIMER1A_IRQHandler
TIMER1A_IRQHandler:
  b .

  .thumb_func
  .weak TIMER1B_IRQHandler
TIMER1B_IRQHandler:
  b .

  .thumb_func
  .weak TIMER2A_IRQHandler
TIMER2A_IRQHandler:
  b .

  .thumb_func
  .weak TIMER2B_IRQHandler
TIMER2B_IRQHandler:
  b .

  .thumb_func
  .weak COMP0_IRQHandler
COMP0_IRQHandler:
  b .

  .thumb_func
  .weak COMP1_IRQHandler
COMP1_IRQHandler:
  b .

  .thumb_func
  .weak COMP2_IRQHandler
COMP2_IRQHandler:
  b .

  .thumb_func
  .weak SYSCTL_IRQHandler
SYSCTL_IRQHandler:
  b .

  .thumb_func
  .weak FLASH_CTRL_IRQHandler
FLASH_CTRL_IRQHandler:
  b .

  .thumb_func
  .weak GPIOF_IRQHandler
GPIOF_IRQHandler:
  b .

  .thumb_func
  .weak GPIOG_IRQHandler
GPIOG_IRQHandler:
  b .

  .thumb_func
  .weak GPIOH_IRQHandler
GPIOH_IRQHandler:
  b .

  .thumb_func
  .weak UART2_IRQHandler
UART2_IRQHandler:
  b .

  .thumb_func
  .weak SSI1_IRQHandler
SSI1_IRQHandler:
  b .

  .thumb_func
  .weak TIMER3A_IRQHandler
TIMER3A_IRQHandler:
  b .

  .thumb_func
  .weak TIMER3B_IRQHandler
TIMER3B_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_IRQHandler
I2C1_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_IRQHandler
CAN0_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_IRQHandler
CAN1_IRQHandler:
  b .

  .thumb_func
  .weak EMAC0_IRQHandler
EMAC0_IRQHandler:
  b .

  .thumb_func
  .weak HIB_IRQHandler
HIB_IRQHandler:
  b .

  .thumb_func
  .weak USB0_IRQHandler
USB0_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_3_IRQHandler
PWM0_3_IRQHandler:
  b .

  .thumb_func
  .weak UDMA_IRQHandler
UDMA_IRQHandler:
  b .

  .thumb_func
  .weak UDMAERR_IRQHandler
UDMAERR_IRQHandler:
  b .

  .thumb_func
  .weak ADC1SS0_IRQHandler
ADC1SS0_IRQHandler:
  b .

  .thumb_func
  .weak ADC1SS1_IRQHandler
ADC1SS1_IRQHandler:
  b .

  .thumb_func
  .weak ADC1SS2_IRQHandler
ADC1SS2_IRQHandler:
  b .

  .thumb_func
  .weak ADC1SS3_IRQHandler
ADC1SS3_IRQHandler:
  b .

  .thumb_func
  .weak EPI0_IRQHandler
EPI0_IRQHandler:
  b .

  .thumb_func
  .weak GPIOJ_IRQHandler
GPIOJ_IRQHandler:
  b .

  .thumb_func
  .weak GPIOK_IRQHandler
GPIOK_IRQHandler:
  b .

  .thumb_func
  .weak GPIOL_IRQHandler
GPIOL_IRQHandler:
  b .

  .thumb_func
  .weak SSI2_IRQHandler
SSI2_IRQHandler:
  b .

  .thumb_func
  .weak SSI3_IRQHandler
SSI3_IRQHandler:
  b .

  .thumb_func
  .weak UART3_IRQHandler
UART3_IRQHandler:
  b .

  .thumb_func
  .weak UART4_IRQHandler
UART4_IRQHandler:
  b .

  .thumb_func
  .weak UART5_IRQHandler
UART5_IRQHandler:
  b .

  .thumb_func
  .weak UART6_IRQHandler
UART6_IRQHandler:
  b .

  .thumb_func
  .weak UART7_IRQHandler
UART7_IRQHandler:
  b .

  .thumb_func
  .weak I2C2_IRQHandler
I2C2_IRQHandler:
  b .

  .thumb_func
  .weak I2C3_IRQHandler
I2C3_IRQHandler:
  b .

  .thumb_func
  .weak TIMER4A_IRQHandler
TIMER4A_IRQHandler:
  b .

  .thumb_func
  .weak TIMER4B_IRQHandler
TIMER4B_IRQHandler:
  b .

  .thumb_func
  .weak TIMER5A_IRQHandler
TIMER5A_IRQHandler:
  b .

  .thumb_func
  .weak TIMER5B_IRQHandler
TIMER5B_IRQHandler:
  b .

  .thumb_func
  .weak SYSEXC_IRQHandler
SYSEXC_IRQHandler:
  b .

  .thumb_func
  .weak I2C4_IRQHandler
I2C4_IRQHandler:
  b .

  .thumb_func
  .weak I2C5_IRQHandler
I2C5_IRQHandler:
  b .

  .thumb_func
  .weak GPIOM_IRQHandler
GPIOM_IRQHandler:
  b .

  .thumb_func
  .weak GPION_IRQHandler
GPION_IRQHandler:
  b .

  .thumb_func
  .weak GPIOP0_IRQHandler
GPIOP0_IRQHandler:
  b .

  .thumb_func
  .weak GPIOP1_IRQHandler
GPIOP1_IRQHandler:
  b .

  .thumb_func
  .weak GPIOP2_IRQHandler
GPIOP2_IRQHandler:
  b .

  .thumb_func
  .weak GPIOP3_IRQHandler
GPIOP3_IRQHandler:
  b .

  .thumb_func
  .weak GPIOP4_IRQHandler
GPIOP4_IRQHandler:
  b .

  .thumb_func
  .weak GPIOP5_IRQHandler
GPIOP5_IRQHandler:
  b .

  .thumb_func
  .weak GPIOP6_IRQHandler
GPIOP6_IRQHandler:
  b .

  .thumb_func
  .weak GPIOP7_IRQHandler
GPIOP7_IRQHandler:
  b .

  .thumb_func
  .weak GPIOQ0_IRQHandler
GPIOQ0_IRQHandler:
  b .

  .thumb_func
  .weak GPIOQ1_IRQHandler
GPIOQ1_IRQHandler:
  b .

  .thumb_func
  .weak GPIOQ2_IRQHandler
GPIOQ2_IRQHandler:
  b .

  .thumb_func
  .weak GPIOQ3_IRQHandler
GPIOQ3_IRQHandler:
  b .

  .thumb_func
  .weak GPIOQ4_IRQHandler
GPIOQ4_IRQHandler:
  b .

  .thumb_func
  .weak GPIOQ5_IRQHandler
GPIOQ5_IRQHandler:
  b .

  .thumb_func
  .weak GPIOQ6_IRQHandler
GPIOQ6_IRQHandler:
  b .

  .thumb_func
  .weak GPIOQ7_IRQHandler
GPIOQ7_IRQHandler:
  b .

  .thumb_func
  .weak TIMER6A_IRQHandler
TIMER6A_IRQHandler:
  b .

  .thumb_func
  .weak TIMER6B_IRQHandler
TIMER6B_IRQHandler:
  b .

  .thumb_func
  .weak TIMER7A_IRQHandler
TIMER7A_IRQHandler:
  b .

  .thumb_func
  .weak TIMER7B_IRQHandler
TIMER7B_IRQHandler:
  b .

  .thumb_func
  .weak I2C6_IRQHandler
I2C6_IRQHandler:
  b .

  .thumb_func
  .weak I2C7_IRQHandler
I2C7_IRQHandler:
  b .

  .thumb_func
  .weak I2C8_IRQHandler
I2C8_IRQHandler:
  b .

  .thumb_func
  .weak I2C9_IRQHandler
I2C9_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word GPIOA_IRQHandler
  .word GPIOB_IRQHandler
  .word GPIOC_IRQHandler
  .word GPIOD_IRQHandler
  .word GPIOE_IRQHandler
  .word UART0_IRQHandler
  .word UART1_IRQHandler
  .word SSI0_IRQHandler
  .word I2C0_IRQHandler
  .word PWM0_FAULT_IRQHandler
  .word PWM0_0_IRQHandler
  .word PWM0_1_IRQHandler
  .word PWM0_2_IRQHandler
  .word QEI0_IRQHandler
  .word ADC0SS0_IRQHandler
  .word ADC0SS1_IRQHandler
  .word ADC0SS2_IRQHandler
  .word ADC0SS3_IRQHandler
  .word WATCHDOG0_IRQHandler
  .word TIMER0A_IRQHandler
  .word TIMER0B_IRQHandler
  .word TIMER1A_IRQHandler
  .word TIMER1B_IRQHandler
  .word TIMER2A_IRQHandler
  .word TIMER2B_IRQHandler
  .word COMP0_IRQHandler
  .word COMP1_IRQHandler
  .word COMP2_IRQHandler
  .word SYSCTL_IRQHandler
  .word FLASH_CTRL_IRQHandler
  .word GPIOF_IRQHandler
  .word GPIOG_IRQHandler
  .word GPIOH_IRQHandler
  .word UART2_IRQHandler
  .word SSI1_IRQHandler
  .word TIMER3A_IRQHandler
  .word TIMER3B_IRQHandler
  .word I2C1_IRQHandler
  .word CAN0_IRQHandler
  .word CAN1_IRQHandler
  .word EMAC0_IRQHandler
  .word HIB_IRQHandler
  .word USB0_IRQHandler
  .word PWM0_3_IRQHandler
  .word UDMA_IRQHandler
  .word UDMAERR_IRQHandler
  .word ADC1SS0_IRQHandler
  .word ADC1SS1_IRQHandler
  .word ADC1SS2_IRQHandler
  .word ADC1SS3_IRQHandler
  .word EPI0_IRQHandler
  .word GPIOJ_IRQHandler
  .word GPIOK_IRQHandler
  .word GPIOL_IRQHandler
  .word SSI2_IRQHandler
  .word SSI3_IRQHandler
  .word UART3_IRQHandler
  .word UART4_IRQHandler
  .word UART5_IRQHandler
  .word UART6_IRQHandler
  .word UART7_IRQHandler
  .word I2C2_IRQHandler
  .word I2C3_IRQHandler
  .word TIMER4A_IRQHandler
  .word TIMER4B_IRQHandler
  .word TIMER5A_IRQHandler
  .word TIMER5B_IRQHandler
  .word SYSEXC_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word I2C4_IRQHandler
  .word I2C5_IRQHandler
  .word GPIOM_IRQHandler
  .word GPION_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word GPIOP0_IRQHandler
  .word GPIOP1_IRQHandler
  .word GPIOP2_IRQHandler
  .word GPIOP3_IRQHandler
  .word GPIOP4_IRQHandler
  .word GPIOP5_IRQHandler
  .word GPIOP6_IRQHandler
  .word GPIOP7_IRQHandler
  .word GPIOQ0_IRQHandler
  .word GPIOQ1_IRQHandler
  .word GPIOQ2_IRQHandler
  .word GPIOQ3_IRQHandler
  .word GPIOQ4_IRQHandler
  .word GPIOQ5_IRQHandler
  .word GPIOQ6_IRQHandler
  .word GPIOQ7_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word TIMER6A_IRQHandler
  .word TIMER6B_IRQHandler
  .word TIMER7A_IRQHandler
  .word TIMER7B_IRQHandler
  .word I2C6_IRQHandler
  .word I2C7_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word I2C8_IRQHandler
  .word I2C9_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
