/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2018 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak WDT_BOD_IRQHandler
  .thumb_set WDT_BOD_IRQHandler,Dummy_Handler

  .weak DMA0_IRQHandler
  .thumb_set DMA0_IRQHandler,Dummy_Handler

  .weak GINT0_IRQHandler
  .thumb_set GINT0_IRQHandler,Dummy_Handler

  .weak GINT1_IRQHandler
  .thumb_set GINT1_IRQHandler,Dummy_Handler

  .weak PIN_INT0_IRQHandler
  .thumb_set PIN_INT0_IRQHandler,Dummy_Handler

  .weak PIN_INT1_IRQHandler
  .thumb_set PIN_INT1_IRQHandler,Dummy_Handler

  .weak PIN_INT2_IRQHandler
  .thumb_set PIN_INT2_IRQHandler,Dummy_Handler

  .weak PIN_INT3_IRQHandler
  .thumb_set PIN_INT3_IRQHandler,Dummy_Handler

  .weak UTICK0_IRQHandler
  .thumb_set UTICK0_IRQHandler,Dummy_Handler

  .weak MRT0_IRQHandler
  .thumb_set MRT0_IRQHandler,Dummy_Handler

  .weak CTIMER0_IRQHandler
  .thumb_set CTIMER0_IRQHandler,Dummy_Handler

  .weak CTIMER1_IRQHandler
  .thumb_set CTIMER1_IRQHandler,Dummy_Handler

  .weak SCT0_IRQHandler
  .thumb_set SCT0_IRQHandler,Dummy_Handler

  .weak CTIMER3_IRQHandler
  .thumb_set CTIMER3_IRQHandler,Dummy_Handler

  .weak FLEXCOMM0_IRQHandler
  .thumb_set FLEXCOMM0_IRQHandler,Dummy_Handler

  .weak FLEXCOMM1_IRQHandler
  .thumb_set FLEXCOMM1_IRQHandler,Dummy_Handler

  .weak FLEXCOMM2_IRQHandler
  .thumb_set FLEXCOMM2_IRQHandler,Dummy_Handler

  .weak FLEXCOMM3_IRQHandler
  .thumb_set FLEXCOMM3_IRQHandler,Dummy_Handler

  .weak FLEXCOMM4_IRQHandler
  .thumb_set FLEXCOMM4_IRQHandler,Dummy_Handler

  .weak FLEXCOMM5_IRQHandler
  .thumb_set FLEXCOMM5_IRQHandler,Dummy_Handler

  .weak FLEXCOMM6_IRQHandler
  .thumb_set FLEXCOMM6_IRQHandler,Dummy_Handler

  .weak FLEXCOMM7_IRQHandler
  .thumb_set FLEXCOMM7_IRQHandler,Dummy_Handler

  .weak ADC0_SEQA_IRQHandler
  .thumb_set ADC0_SEQA_IRQHandler,Dummy_Handler

  .weak ADC0_SEQB_IRQHandler
  .thumb_set ADC0_SEQB_IRQHandler,Dummy_Handler

  .weak ADC0_THCMP_IRQHandler
  .thumb_set ADC0_THCMP_IRQHandler,Dummy_Handler

  .weak DMIC0_IRQHandler
  .thumb_set DMIC0_IRQHandler,Dummy_Handler

  .weak HWVAD0_IRQHandler
  .thumb_set HWVAD0_IRQHandler,Dummy_Handler

  .weak USB0_NEEDCLK_IRQHandler
  .thumb_set USB0_NEEDCLK_IRQHandler,Dummy_Handler

  .weak USB0_IRQHandler
  .thumb_set USB0_IRQHandler,Dummy_Handler

  .weak RTC_IRQHandler
  .thumb_set RTC_IRQHandler,Dummy_Handler

  .weak PIN_INT4_IRQHandler
  .thumb_set PIN_INT4_IRQHandler,Dummy_Handler

  .weak PIN_INT5_IRQHandler
  .thumb_set PIN_INT5_IRQHandler,Dummy_Handler

  .weak PIN_INT6_IRQHandler
  .thumb_set PIN_INT6_IRQHandler,Dummy_Handler

  .weak PIN_INT7_IRQHandler
  .thumb_set PIN_INT7_IRQHandler,Dummy_Handler

  .weak CTIMER2_IRQHandler
  .thumb_set CTIMER2_IRQHandler,Dummy_Handler

  .weak CTIMER4_IRQHandler
  .thumb_set CTIMER4_IRQHandler,Dummy_Handler

  .weak RIT_IRQHandler
  .thumb_set RIT_IRQHandler,Dummy_Handler

  .weak SPIFI0_IRQHandler
  .thumb_set SPIFI0_IRQHandler,Dummy_Handler

  .weak FLEXCOMM8_IRQHandler
  .thumb_set FLEXCOMM8_IRQHandler,Dummy_Handler

  .weak FLEXCOMM9_IRQHandler
  .thumb_set FLEXCOMM9_IRQHandler,Dummy_Handler

  .weak SDIO_IRQHandler
  .thumb_set SDIO_IRQHandler,Dummy_Handler

  .weak CAN0_IRQ0_IRQHandler
  .thumb_set CAN0_IRQ0_IRQHandler,Dummy_Handler

  .weak CAN0_IRQ1_IRQHandler
  .thumb_set CAN0_IRQ1_IRQHandler,Dummy_Handler

  .weak CAN1_IRQ0_IRQHandler
  .thumb_set CAN1_IRQ0_IRQHandler,Dummy_Handler

  .weak CAN1_IRQ1_IRQHandler
  .thumb_set CAN1_IRQ1_IRQHandler,Dummy_Handler

  .weak USB1_IRQHandler
  .thumb_set USB1_IRQHandler,Dummy_Handler

  .weak USB1_NEEDCLK_IRQHandler
  .thumb_set USB1_NEEDCLK_IRQHandler,Dummy_Handler

  .weak ETHERNET_IRQHandler
  .thumb_set ETHERNET_IRQHandler,Dummy_Handler

  .weak ETHERNET_PMT_IRQHandler
  .thumb_set ETHERNET_PMT_IRQHandler,Dummy_Handler

  .weak ETHERNET_MACLP_IRQHandler
  .thumb_set ETHERNET_MACLP_IRQHandler,Dummy_Handler

  .weak EEPROM_IRQHandler
  .thumb_set EEPROM_IRQHandler,Dummy_Handler

  .weak LCD_IRQHandler
  .thumb_set LCD_IRQHandler,Dummy_Handler

  .weak SMARTCARD0_IRQHandler
  .thumb_set SMARTCARD0_IRQHandler,Dummy_Handler

  .weak SMARTCARD1_IRQHandler
  .thumb_set SMARTCARD1_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak WDT_BOD_IRQHandler
WDT_BOD_IRQHandler:
  b .

  .thumb_func
  .weak DMA0_IRQHandler
DMA0_IRQHandler:
  b .

  .thumb_func
  .weak GINT0_IRQHandler
GINT0_IRQHandler:
  b .

  .thumb_func
  .weak GINT1_IRQHandler
GINT1_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT0_IRQHandler
PIN_INT0_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT1_IRQHandler
PIN_INT1_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT2_IRQHandler
PIN_INT2_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT3_IRQHandler
PIN_INT3_IRQHandler:
  b .

  .thumb_func
  .weak UTICK0_IRQHandler
UTICK0_IRQHandler:
  b .

  .thumb_func
  .weak MRT0_IRQHandler
MRT0_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER0_IRQHandler
CTIMER0_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER1_IRQHandler
CTIMER1_IRQHandler:
  b .

  .thumb_func
  .weak SCT0_IRQHandler
SCT0_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER3_IRQHandler
CTIMER3_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM0_IRQHandler
FLEXCOMM0_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM1_IRQHandler
FLEXCOMM1_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM2_IRQHandler
FLEXCOMM2_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM3_IRQHandler
FLEXCOMM3_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM4_IRQHandler
FLEXCOMM4_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM5_IRQHandler
FLEXCOMM5_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM6_IRQHandler
FLEXCOMM6_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM7_IRQHandler
FLEXCOMM7_IRQHandler:
  b .

  .thumb_func
  .weak ADC0_SEQA_IRQHandler
ADC0_SEQA_IRQHandler:
  b .

  .thumb_func
  .weak ADC0_SEQB_IRQHandler
ADC0_SEQB_IRQHandler:
  b .

  .thumb_func
  .weak ADC0_THCMP_IRQHandler
ADC0_THCMP_IRQHandler:
  b .

  .thumb_func
  .weak DMIC0_IRQHandler
DMIC0_IRQHandler:
  b .

  .thumb_func
  .weak HWVAD0_IRQHandler
HWVAD0_IRQHandler:
  b .

  .thumb_func
  .weak USB0_NEEDCLK_IRQHandler
USB0_NEEDCLK_IRQHandler:
  b .

  .thumb_func
  .weak USB0_IRQHandler
USB0_IRQHandler:
  b .

  .thumb_func
  .weak RTC_IRQHandler
RTC_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT4_IRQHandler
PIN_INT4_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT5_IRQHandler
PIN_INT5_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT6_IRQHandler
PIN_INT6_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT7_IRQHandler
PIN_INT7_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER2_IRQHandler
CTIMER2_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER4_IRQHandler
CTIMER4_IRQHandler:
  b .

  .thumb_func
  .weak RIT_IRQHandler
RIT_IRQHandler:
  b .

  .thumb_func
  .weak SPIFI0_IRQHandler
SPIFI0_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM8_IRQHandler
FLEXCOMM8_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM9_IRQHandler
FLEXCOMM9_IRQHandler:
  b .

  .thumb_func
  .weak SDIO_IRQHandler
SDIO_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_IRQ0_IRQHandler
CAN0_IRQ0_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_IRQ1_IRQHandler
CAN0_IRQ1_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_IRQ0_IRQHandler
CAN1_IRQ0_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_IRQ1_IRQHandler
CAN1_IRQ1_IRQHandler:
  b .

  .thumb_func
  .weak USB1_IRQHandler
USB1_IRQHandler:
  b .

  .thumb_func
  .weak USB1_NEEDCLK_IRQHandler
USB1_NEEDCLK_IRQHandler:
  b .

  .thumb_func
  .weak ETHERNET_IRQHandler
ETHERNET_IRQHandler:
  b .

  .thumb_func
  .weak ETHERNET_PMT_IRQHandler
ETHERNET_PMT_IRQHandler:
  b .

  .thumb_func
  .weak ETHERNET_MACLP_IRQHandler
ETHERNET_MACLP_IRQHandler:
  b .

  .thumb_func
  .weak EEPROM_IRQHandler
EEPROM_IRQHandler:
  b .

  .thumb_func
  .weak LCD_IRQHandler
LCD_IRQHandler:
  b .

  .thumb_func
  .weak SMARTCARD0_IRQHandler
SMARTCARD0_IRQHandler:
  b .

  .thumb_func
  .weak SMARTCARD1_IRQHandler
SMARTCARD1_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word WDT_BOD_IRQHandler
  .word DMA0_IRQHandler
  .word GINT0_IRQHandler
  .word GINT1_IRQHandler
  .word PIN_INT0_IRQHandler
  .word PIN_INT1_IRQHandler
  .word PIN_INT2_IRQHandler
  .word PIN_INT3_IRQHandler
  .word UTICK0_IRQHandler
  .word MRT0_IRQHandler
  .word CTIMER0_IRQHandler
  .word CTIMER1_IRQHandler
  .word SCT0_IRQHandler
  .word CTIMER3_IRQHandler
  .word FLEXCOMM0_IRQHandler
  .word FLEXCOMM1_IRQHandler
  .word FLEXCOMM2_IRQHandler
  .word FLEXCOMM3_IRQHandler
  .word FLEXCOMM4_IRQHandler
  .word FLEXCOMM5_IRQHandler
  .word FLEXCOMM6_IRQHandler
  .word FLEXCOMM7_IRQHandler
  .word ADC0_SEQA_IRQHandler
  .word ADC0_SEQB_IRQHandler
  .word ADC0_THCMP_IRQHandler
  .word DMIC0_IRQHandler
  .word HWVAD0_IRQHandler
  .word USB0_NEEDCLK_IRQHandler
  .word USB0_IRQHandler
  .word RTC_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word PIN_INT4_IRQHandler
  .word PIN_INT5_IRQHandler
  .word PIN_INT6_IRQHandler
  .word PIN_INT7_IRQHandler
  .word CTIMER2_IRQHandler
  .word CTIMER4_IRQHandler
  .word RIT_IRQHandler
  .word SPIFI0_IRQHandler
  .word FLEXCOMM8_IRQHandler
  .word FLEXCOMM9_IRQHandler
  .word SDIO_IRQHandler
  .word CAN0_IRQ0_IRQHandler
  .word CAN0_IRQ1_IRQHandler
  .word CAN1_IRQ0_IRQHandler
  .word CAN1_IRQ1_IRQHandler
  .word USB1_IRQHandler
  .word USB1_NEEDCLK_IRQHandler
  .word ETHERNET_IRQHandler
  .word ETHERNET_PMT_IRQHandler
  .word ETHERNET_MACLP_IRQHandler
  .word EEPROM_IRQHandler
  .word LCD_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word SMARTCARD0_IRQHandler
  .word SMARTCARD1_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
