/*********************************************************************
*                     SEGGER Microcontroller GmbH                    *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*       (c) 1995 - 2021 SEGGER Microcontroller GmbH                  *
*                                                                    *
*       Internet: segger.com  Support: support_embos@segger.com      *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS * Real time operating system for microcontrollers      *
*                                                                    *
*       Please note:                                                 *
*                                                                    *
*       Knowledge of this file may under no circumstances            *
*       be used to write a similar product or a real-time            *
*       operating system for in-house use.                           *
*                                                                    *
*       Thank you for your fairness !                                *
*                                                                    *
**********************************************************************
*                                                                    *
*       OS version: V5.14.0.0                                        *
*                                                                    *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------
File    : OS_Bootloader.c
Purpose : embOS sample program for bootloader
*/

#include "RTOS.h"
#include "MK66F18.h"  // Device specific header file, contains CMSIS

#define THUMB_BIT         (1u)
#define APP_START_ADDR    (0x00100000)
#define APP_STACK_PTR     (*(volatile OS_U32*)(APP_START_ADDR + 0x00))
#define APP_RESET_PTR     (*(volatile OS_U32*)(APP_START_ADDR + 0x04))

void (*AppPtr)(void);

static OS_STACKPTR int StackHP[128], StackLP[128];  // Task stacks
static OS_TASK         TCBHP, TCBLP;                // Task control blocks

static void DeInitializeAllInterrupts(void) {
  //
  // De-initialize all interrupts to avoid any undesired interrupts to occur after the application was started.
  //
}

static void HPTask(void) {
  while (1) {
    //
    // Start the application
    //
    OS_INT_Disable();
    DeInitializeAllInterrupts();
    AppPtr    = (void (*)(void))(APP_RESET_PTR | THUMB_BIT);
    SCB->VTOR = APP_START_ADDR;
    __set_MSP(APP_STACK_PTR);  // Set main stack pointer to application initial stack value
    __set_CONTROL(0);          // Use MSP and Privileged in thread mode
    AppPtr();                  // Start the application, we will not return from this function
  }
}

static void LPTask(void) {
  while (1) {
    OS_TASK_Delay(200);
  }
}

/*********************************************************************
*
*       main()
*/
int main(void) {
  OS_Init();    // Initialize embOS
  OS_InitHW();  // Initialize required hardware
  OS_TASK_CREATE(&TCBHP, "HP Task", 100, HPTask, StackHP);
  OS_TASK_CREATE(&TCBLP, "LP Task",  50, LPTask, StackLP);
  OS_Start();   // Start embOS
  return 0;
}

/*************************** End of file ****************************/
