/******************************************************************************
 * @file:    TMPM380.h
 * @purpose: CMSIS Cortex-M3 Core Peripheral Access Layer Header File for the 
 *           TOSHIBA 'TMPM380' Device Series 
 * @version: V2.0.2.4
 * @date:    2010/03/10
 * 
 * THE SOURCE CODE AND ITS RELATED DOCUMENTATION IS PROVIDED "AS IS". TOSHIBA
 * CORPORATION MAKES NO OTHER WARRANTY OF ANY KIND, WHETHER EXPRESS, IMPLIED OR,
 * STATUTORY AND DISCLAIMS ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * SATISFACTORY QUALITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * THE SOURCE CODE AND DOCUMENTATION MAY INCLUDE ERRORS. TOSHIBA CORPORATION
 * RESERVES THE RIGHT TO INCORPORATE MODIFICATIONS TO THE SOURCE CODE IN LATER
 * REVISIONS OF IT, AND TO MAKE IMPROVEMENTS OR CHANGES IN THE DOCUMENTATION OR
 * THE PRODUCTS OR TECHNOLOGIES DESCRIBED THEREIN AT ANY TIME.
 * 
 * TOSHIBA CORPORATION SHALL NOT BE LIABLE FOR ANY DIRECT, INDIRECT OR
 * CONSEQUENTIAL DAMAGE OR LIABILITY ARISING FROM YOUR USE OF THE SOURCE CODE OR
 * ANY DOCUMENTATION, INCLUDING BUT NOT LIMITED TO, LOST REVENUES, DATA OR
 * PROFITS, DAMAGES OF ANY SPECIAL, INCIDENTAL OR CONSEQUENTIAL NATURE, PUNITIVE
 * DAMAGES, LOSS OF PROPERTY OR LOSS OF PROFITS ARISING OUT OF OR IN CONNECTION
 * WITH THIS AGREEMENT, OR BEING UNUSABLE, EVEN IF ADVISED OF THE POSSIBILITY OR
 * PROBABILITY OF SUCH DAMAGES AND WHETHER A CLAIM FOR SUCH DAMAGE IS BASED UPON
 * WARRANTY, CONTRACT, TORT, NEGLIGENCE OR OTHERWISE.
 * 
 * (C)Copyright TOSHIBA CORPORATION 2010 All rights reserved
 ******************************************************************************/

/** @addtogroup TOSHIBA_TX03_MICROCONTROLLER
  * @{
  */

/** @addtogroup TMPM380
  * @{
  */

#ifndef __TMPM380_H__
#define __TMPM380_H__

#ifdef __cplusplus
extern "C" {
#endif 

/** @addtogroup Configuration_of_CMSIS
  * @{
  */

/** Interrupt Number Definition */
typedef enum IRQn
{
/******  Cortex-M3 Processor Exceptions Numbers ****************************************************/
  NonMaskableInt_IRQn           = -14,      /*!< 2 Non Maskable Interrupt                          */
  HardFault_IRQn                = -13,      /*!< 3 Cortex-M3 Hard Fault Interrupt                  */
  MemoryManagement_IRQn         = -12,      /*!< 4 Cortex-M3 Memory Management Interrupt           */
  BusFault_IRQn                 = -11,      /*!< 5 Cortex-M3 Bus Fault Interrupt                   */
  UsageFault_IRQn               = -10,      /*!< 6 Cortex-M3 Usage Fault Interrupt                 */
  SVCall_IRQn                   = -5,       /*!< 11 Cortex-M3 SV Call Interrupt                    */
  DebugMonitor_IRQn             = -4,       /*!< 12 Cortex-M3 Debug Monitor Interrupt              */
  PendSV_IRQn                   = -2,       /*!< 14 Cortex-M3 Pend SV Interrupt                    */
  SysTick_IRQn                  = -1,       /*!< 15 Cortex-M3 System Tick Interrupt                */

/******  TMPM380 Specific Interrupt Numbers ********************************************************/
  INT0_IRQn                     = 0,        /*!< Interrupt pin (PJ0)                               */
  INT1_IRQn                     = 1,        /*!< Interrupt pin (PJ1)                               */
  INT2_IRQn                     = 2,        /*!< Interrupt pin (PJ2)                               */
  INT3_IRQn                     = 3,        /*!< Interrupt pin (PJ3)                               */
  INT4_IRQn                     = 4,        /*!< Interrupt pin (PJ4)                               */
  INT5_IRQn                     = 5,        /*!< Interrupt pin (PJ5)                               */
  INTRX0_IRQn                   = 6,        /*!< Serial reception (channel.0)                      */
  INTTX0_IRQn                   = 7,        /*!< Serial transmission (channel.0)                   */
  INTRX1_IRQn                   = 8,        /*!< Serial reception (channel.1)                      */
  INTTX1_IRQn                   = 9,        /*!< Serial transmission (channel.1)                   */
  INTSSP0_IRQn                  = 10,       /*!< Syncronous Serial Port 0                          */
  INTSSP1_IRQn                  = 11,       /*!< Syncronous Serial Port 1                          */
  INTEMG0_IRQn                  = 12,       /*!< PMD0 EMG interrupt (MPT0)                         */
  INTEMG1_IRQn                  = 13,       /*!< PMD1 EMG interrupt (MPT1)                         */
  INTSBI0_IRQn                  = 14,       /*!< Serial Bus Interface 0 interrupt                  */
  INTSBI1_IRQn                  = 15,       /*!< Serial Bus Interface 1 interrupt                  */
  INTADPD0_IRQn                 = 16,       /*!< ADC conversion triggered by PMD0 is finished      */
  INTRTC_IRQn                   = 17,       /*!< Realtime clock interrupt                          */
  INTADPD1_IRQn                 = 18,       /*!< ADC conversion triggered by PMD1 is finished      */
  INTRMCRX_IRQn                 = 19,       /*!< Remote Controller reception interrupt             */
  INTTB00_IRQn                  = 20,       /*!< 16bit TMRB0 compare match detection 0             */
  INTTB01_IRQn                  = 21,       /*!< 16bit TMRB0 compare match detection 1             */
  INTTB10_IRQn                  = 22,       /*!< 16bit TMRB1 compare match detection 0             */
  INTTB11_IRQn                  = 23,       /*!< 16bit TMRB1 compare match detection 1             */
  INTTB40_IRQn                  = 24,       /*!< 16bit TMRB4 compare match detection 0             */
  INTTB41_IRQn                  = 25,       /*!< 16bit TMRB4 compare match detection 1             */
  INTTB50_IRQn                  = 26,       /*!< 16bit TMRB5 compare match detection 0             */
  INTTB51_IRQn                  = 27,       /*!< 16bit TMRB5 compare match detection 1             */
  INTPMD0_IRQn                  = 28,       /*!< PMD0 PWM interrupt (MPT0)                         */
  INTPMD1_IRQn                  = 29,       /*!< PMD1 PWM interrupt (MPT1)                         */
  INTCAP00_IRQn                 = 30,       /*!< 16bit TMRB0 input capture 0                       */
  INTCAP01_IRQn                 = 31,       /*!< 16bit TMRB0 input capture 1                       */
  INTCAP10_IRQn                 = 32,       /*!< 16bit TMRB1 input capture 0                       */
  INTCAP11_IRQn                 = 33,       /*!< 16bit TMRB1 input capture 1                       */
  INTCAP40_IRQn                 = 34,       /*!< 16bit TMRB4 input capture 0                       */
  INTCAP41_IRQn                 = 35,       /*!< 16bit TMRB4 input capture 1                       */
  INTCAP50_IRQn                 = 36,       /*!< 16bit TMRB5 input capture 0                       */
  INTCAP51_IRQn                 = 37,       /*!< 16bit TMRB5 input capture 1                       */
  INT6_IRQn                     = 38,       /*!< Interrupt Pin (PE6/TB3IN/INT6)                    */
  INT7_IRQn                     = 39,       /*!< Interrupt Pin (PE7/TB3OUT/INT7)                   */
  INTRX2_IRQn                   = 40,       /*!< Serial reception (channel.2)                      */
  INTTX2_IRQn                   = 41,       /*!< Serial transmit (channel.2)                       */
  INTADCP0_IRQn                 = 42,       /*!< ADC conversion monitoring function interrupt 0    */
  INTADCP1_IRQn                 = 43,       /*!< ADC conversion monitoring function interrupt 1    */
  INTRX4_IRQn                   = 44,       /*!< Serial reception (channel.4)                      */
  INTTX4_IRQn                   = 45,       /*!< Serial transmit (channel.4)                       */
  INTTB20_IRQn                  = 46,       /*!< 16bit TMRB2 compare match detection 0             */
  INTTB21_IRQn                  = 47,       /*!< 16bit TMRB2 compare match detection 1             */
  INTTB30_IRQn                  = 48,       /*!< 16bit TMRB3 compare match detection 0             */
  INTTB31_IRQn                  = 49,       /*!< 16bit TMRB3 compare match detection 1             */
  INTCAP20_IRQn                 = 50,       /*!< 16bit TMRB2 input capture 0                       */
  INTCAP21_IRQn                 = 51,       /*!< 16bit TMRB2 input capture 1                       */
  INTCAP30_IRQn                 = 52,       /*!< 16bit TMRB3 input capture 0                       */
  INTCAP31_IRQn                 = 53,       /*!< 16bit TMRB3 input capture 1                       */
  INTADSFT_IRQn                 = 54,       /*!< ADC conversion started by software is finished    */
  INTADTMR_IRQn                 = 56,       /*!< ADC conversion triggered by timer is finished     */
  INT8_IRQn                     = 58,       /*!< Interrupt Pin (PA7/TB4IN/INT8)                    */
  INT9_IRQn                     = 59,       /*!< Interrupt Pin (PD3/INT9)                          */
  INTA_IRQn                     = 60,       /*!< Interrupt Pin (PJ6/AIN6/INTA)                     */
  INTB_IRQn                     = 61,       /*!< Interrupt Pin (PJ7/AIN7/INTB)                     */
  INTENC0_IRQn                  = 62,       /*!< Encoder input0 interrupt                          */
  INTENC1_IRQn                  = 63,       /*!< Encoder input1 interrupt                          */
  INTRX3_IRQn                   = 64,       /*!< Serial reception (channel.3)                      */
  INTTX3_IRQn                   = 65,       /*!< Serial transmit (channel.3)                       */
  INTTB60_IRQn                  = 66,       /*!< 16bit TMRB6 compare match detection 0             */
  INTTB61_IRQn                  = 67,       /*!< 16bit TMRB6 compare match detection 1             */
  INTTB70_IRQn                  = 68,       /*!< 16bit TMRB7 compare match detection 0             */
  INTTB71_IRQn                  = 69,       /*!< 16bit TMRB7 compare match detection 1             */
  INTCAP60_IRQn                 = 70,       /*!< 16bit TMRB6 input capture 0                       */
  INTCAP61_IRQn                 = 71,       /*!< 16bit TMRB6 input capture 1                       */
  INTCAP70_IRQn                 = 72,       /*!< 16bit TMRB7 input capture 0                       */
  INTCAP71_IRQn                 = 73,       /*!< 16bit TMRB7 input capture 1                       */
  INTC_IRQn                     = 74,       /*!< Interrupt Pin (PD0/ENCA0/TB5IN/INTC)              */
  INTD_IRQn                     = 75,       /*!< Interrupt Pin (PD2/ENCZ0/INTD)                    */
  INTE_IRQn                     = 76,       /*!< Interrupt Pin (PN7/MT2IN/INTE)                    */
  INTF_IRQn                     = 77,       /*!< Interrupt Pin (PL2/INTF)                          */
  INTDMACERR_IRQn               = 78,       /*!< DMA transfer error                                */
  INTDMACTC_IRQn                = 79,       /*!< DMA end of transfer                               */
  INTMTTB00_IRQn                = 80,       /*!< 16-bit MPT0 IGBT period/ compare match detection 0*/
  INTMTTB01_IRQn                = 81,       /*!< 16-bit MPT0 IGBT trigger/ compare match detection 1           */
  INTMTTB10_IRQn                = 82,       /*!< 16-bit MPT1 IGBT period/ compare match detection 0/Over flow  */
  INTMTTB11_IRQn                = 83,       /*!< 16-bit MPT1 IGBT trigger/ compare match detection 1           */
  INTMTTB20_IRQn                = 84,       /*!< 16-bit MPT2 IGBT period/ compare match detection 0/Over flow  */
  INTMTTB21_IRQn                = 85,       /*!< 16-bit MPT2 IGBT trigger/ compare match detection 1           */
  INTMTCAP00_IRQn               = 86,       /*!< 16-bit MPT0 input capture 0                                   */
  INTMTCAP01_IRQn               = 87,       /*!< 16-bit MPT0 input capture 1                                   */
  INTMTCAP10_IRQn               = 88,       /*!< 16-bit MPT1 input capture 0                                   */
  INTMTCAP11_IRQn               = 89,       /*!< 16-bit MPT1 input capture 1                                   */
  INTMTCAP20_IRQn               = 90,       /*!< 16-bit MPT2 input capture 0                                   */
  INTMTCAP21_IRQn               = 91,       /*!< 16-bit MPT2 input capture 1                                   */
  INTMTEMG0_IRQn                = 92,       /*!< 16-bit MPT0 IGBT EMG interrupt                                */
  INTMTEMG1_IRQn                = 93,       /*!< 16-bit MPT1 IGBT EMG interrupt                                */
  INTMTEMG2_IRQn                = 94,       /*!< 16-bit MPT2 IGBT EMG interrupt                                */
} IRQn_Type;


/** Processor and Core Peripheral Section */

/* Configuration of the Cortex-M3 Processor and Core Peripherals */
#define __MPU_PRESENT             0         /*!< MPU present or not                                */
#define __NVIC_PRIO_BITS          3         /*!< Number of Bits used for Priority Levels           */
#define __Vendor_SysTickConfig    0         /*!< Set to 1 if different SysTick Config is used      */

/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm3.h"                       /* Cortex-M3 processor and core peripherals            */
#include "system_TMPM380.h"                 /* TMPM380 System                                      */

/** @addtogroup Device_Peripheral_registers
  * @{
  */

/** Device Specific Peripheral registers structures */

/**
  * @brief General Purpose Input/Output Port (PA)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PA Register                     */
  __IO uint32_t CR;             /*!< PA Control Register             */
  __IO uint32_t FR1;            /*!< PA Function Register 1          */
  __IO uint32_t FR2;            /*!< PA Function Register 1          */
       uint32_t RESERVED0[6];                                        
  __IO uint32_t OD;             /*!<  PA open drain Control register */
  __IO uint32_t PUP;            /*!< PA Pull-up Control Register     */
  __IO uint32_t PDN;            /*!< PA Pull-down Control Register   */
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PA Input Enable Control Register*/
} TSB_PA_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PB)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PB Register                      */
  __IO uint32_t CR;             /*!< PB Control Register              */
  __IO uint32_t FR1;            /*!< PB Function Register 1           */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;             /*!< PB open drain Control register   */
  __IO uint32_t PUP;            /*!< PB Pull-Up Control Register      */
  __IO uint32_t PDN;            /*!< PB pull-down control register    */
       uint32_t RESERVED1; 
  __IO uint32_t IE;             /*!< PB Input Enable Control Register */
} TSB_PB_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PC)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PC Register                      */
  __IO uint32_t CR;             /*!< PC control register              */
  __IO uint32_t FR1;            /*!< PC function register 1           */
  __IO uint32_t FR2;            /*!< PC function register 2           */
  __IO uint32_t FR3;            /*!< PC function register 3           */
  __IO uint32_t FR4;            /*!< PC function register 4           */
  __IO uint32_t FR5;            /*!< PC function register 5           */
       uint32_t RESERVED0[3];
  __IO uint32_t OD;             /*!< PC open drain Control register   */
  __IO uint32_t PUP;            /*!< PC Pull-Up Control Register      */
  __IO uint32_t PDN;            /*!< PC pull-down control register    */
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PC Input Enable Control Register */
} TSB_PC_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PD)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PD Register                      */
  __IO uint32_t CR;             /*!< PD control register              */
  __IO uint32_t FR1;            /*!< PD Function Register 1           */
  __IO uint32_t FR2;            /*!< PD Function Register 2           */
  __IO uint32_t FR3;            /*!< PD Function Register 3           */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;             /*!< PD open drain control register   */
  __IO uint32_t PUP;            /*!< PD Pull-Up Control Register      */
  __IO uint32_t PDN;            /*!< PD pull-down control register    */
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PD Input Enable Control Register */
} TSB_PD_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PE)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PE Register                      */
  __IO uint32_t CR;             /*!< PE Control Register              */
  __IO uint32_t FR1;            /*!< PE Function Register 1           */
  __IO uint32_t FR2;            /*!< PE Function Register 2           */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;             /*!< PE Open Drain Control Register   */
  __IO uint32_t PUP;            /*!< PE Pull-Up Control Register      */
  __IO uint32_t PDN;            /*!< PE pull-down control register    */
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PE Input Enable Control Register */
} TSB_PE_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PF)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PF Register                      */
  __IO uint32_t CR;             /*!< PF Control Register              */
  __IO uint32_t FR1;            /*!< PF Function Register 1           */
  __IO uint32_t FR2;            /*!< PF Function Register 2           */
  __IO uint32_t FR3;            /*!< PF Function Register 3           */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;             /*!< PF Open Drain Control Register   */
  __IO uint32_t PUP;            /*!< PF Pull-Up Control Register      */
  __IO uint32_t PDN;            /*!< PF pull-down control register    */
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PF Input Enable Control Register */
} TSB_PF_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PG)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PG Register                      */
  __IO uint32_t CR;             /*!< PG Control Register              */
  __IO uint32_t FR1;            /*!< PG Function Register 1           */
  __IO uint32_t FR2;            /*!< PG Function Register 2           */
  __IO uint32_t FR3;            /*!< PG Function Register 3           */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;             /*!< PG Open Drain Control Register   */
  __IO uint32_t PUP;            /*!< PG Pull-Up Control Register      */
  __IO uint32_t PDN;
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PG Input Enable Control Register */
} TSB_PG_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PH)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PH Register                      */
  __IO uint32_t CR;             /*!< PH Control Register              */
  __IO uint32_t FR1;            /*!< PH Function Register 1           */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;
  __IO uint32_t PUP;            /*!< PH Pull-Up Control Register      */
  __IO uint32_t PDN;
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PH Input Enable Control Register */
} TSB_PH_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PI)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PI Register                      */
  __IO uint32_t CR;             /*!< PI Control Register              */
       uint32_t RESERVED0[8];
  __IO uint32_t OD;
  __IO uint32_t PUP;            /*!< PI Pull-Up Control Register      */
  __IO uint32_t PDN;
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PI Input Enable Control Register */
} TSB_PI_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PJ)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PJ Register                      */
  __IO uint32_t CR;             /*!< PJ Control Register              */
  __IO uint32_t FR1;            /*!< PJ Function Register 1           */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;
  __IO uint32_t PUP;            /*!< PJ Pull-Up Control Register      */
  __IO uint32_t PDN;
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PJ Input Enable Control Register */
} TSB_PJ_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PL)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PL Register                      */
  __IO uint32_t CR;             /*!< PL Control Register              */
  __IO uint32_t FR1;            /*!< PL Function Register 1           */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;
  __IO uint32_t PUP;            /*!< PL Pull-Up Control Register      */
  __IO uint32_t PDN;
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PL Input Enable Control Register */
} TSB_PL_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PM)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PM Register                      */
  __IO uint32_t CR;             /*!< PM Control Register              */
       uint32_t RESERVED0[8];
  __IO uint32_t OD;
  __IO uint32_t PUP;            /*!< PM Pull-Up Control Register      */
  __IO uint32_t PDN;
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PM Input Enable Control Register */
} TSB_PM_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PN)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PN Register                      */
  __IO uint32_t CR;             /*!< PN Control Register              */
  __IO uint32_t FR1;            /*!< PN Function Register 1           */
  __IO uint32_t FR2;            /*!< PN Function Register 2           */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;
  __IO uint32_t PUP;            /*!< PN Pull-Up Control Register      */
  __IO uint32_t PDN;
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PN Input Enable Control Register */
} TSB_PN_TypeDef;

/**
  * @brief General Purpose Input/Output Port (PP)
  */
typedef struct
{
  __IO uint32_t DATA;           /*!< PP Register                      */
  __IO uint32_t CR;             /*!< PP Control Register              */
       uint32_t RESERVED0[8];
  __IO uint32_t OD;
  __IO uint32_t PUP;            /*!< PP Pull-Up Control Register      */
  __IO uint32_t PDN;
       uint32_t RESERVED1;
  __IO uint32_t IE;             /*!< PP Input Enable Control Register */
} TSB_PP_TypeDef;

/**
  * @brief 16-bit Timer/Event Counter (TB)
  */
typedef struct
{
  __IO uint32_t EN;             /*!< TB Enable Register            */
  __IO uint32_t RUN;            /*!< TB RUN Register               */
  __IO uint32_t CR;             /*!< TB Control Register           */
  __IO uint32_t MOD;            /*!< TB Mode Register              */
  __IO uint32_t FFCR;           /*!< TB Flip-Flop Control Register */
  __I  uint32_t ST;             /*!< TB Status Register            */
  __IO uint32_t IM;             /*!< TB Interrupt Mask Register    */
  __I  uint32_t UC;             /*!< TB Read Capture Register      */
  __IO uint32_t RG0;            /*!< TB RG0 Timer Register         */
  __IO uint32_t RG1;            /*!< TB RG1 Timer Register         */
  __I  uint32_t CP0;            /*!< TB CP0 Capture Register       */
  __I  uint32_t CP1;            /*!< TB CP1 Capture Register       */
} TSB_TB_TypeDef;

/**
  * @brief Encoder input (ENC)
  */
typedef struct
{
  __IO uint32_t TNCR;           /*!< Encoder  Input Control Register    */
  __IO uint32_t RELOAD;         /*!< Encoder  Counter Reload Register   */
  __IO uint32_t INT;            /*!< Encoder  Compare Register          */
  __IO uint32_t CNT;            /*!< Encoder  Counter Register          */
} TSB_EN_TypeDef;

#if defined ( __CC_ARM   )          /* RealView Compiler */
#pragma anon_unions 
#elif (defined (__ICCARM__))        /*  ICC Compiler     */
#pragma language=extended
#endif

/**
  * @brief Serial Bus Interface (SBI)
  */
typedef struct
{
  __IO uint32_t CR0;            /*!< SBI Control Register 0       */
  __IO uint32_t CR1;            /*!< SBI Control Register 1       */
  __IO uint32_t DBR;            /*!< SBI Data Buffer Register     */
  __IO uint32_t I2CAR;          /*!< SBI I2C Bus Address Register */
  union {
  __O  uint32_t CR2;            /*!< SBI Control Register 2       */
  __I  uint32_t SR;             /*!< SBI Status Register          */
  };
  __IO uint32_t BR0;            /*!< SBI Baud Rate Register 0     */
} TSB_SBI_TypeDef;

/**
  * @brief Serial Channel (SC)
  */
typedef struct
{
  __IO uint32_t EN;             /*!< SC Enable Register                        */
  __IO uint32_t BUF;            /*!< SC Buffer Register                        */
  __IO uint32_t CR;             /*!< SC Control Register                       */
  __IO uint32_t MOD0;           /*!< SC Mode Control Register 0                */
  __IO uint32_t BRCR;           /*!< SC Baud Rate Generator Control Register   */
  __IO uint32_t BRADD;          /*!< SC Baud Rate Generator Control Register 2 */
  __IO uint32_t MOD1;           /*!< SC Mode Control Register 1                */
  __IO uint32_t MOD2;           /*!< SC Mode Control Register 2                */
  __IO uint32_t RFC;            /*!< SC RX FIFO Configuration Register         */
  __IO uint32_t TFC;            /*!< SC TX FIFO Configuration Register         */
  __I  uint32_t RST;            /*!< SC RX FIFO Status Register                */
  __I  uint32_t TST;            /*!< SC TX FIFO Status Register                */
  __IO uint32_t FCNF;           /*!< SC FIFO Configuration Register            */
} TSB_SC_TypeDef;

/**
  * @brief Analog-to-Digital Converter (AD)
  */
typedef struct
{
  __IO uint32_t CLK;            /*!< AD Conversion Clock Setting Register          */
  __IO uint32_t MOD0;           /*!< AD Mode Setting Register 0                    */
  __IO uint32_t MOD1;           /*!< AD Mode Setting Register 1                    */
  __I  uint32_t MOD2;           /*!< AD Mode Setting Register 2                    */
  __IO uint32_t CMPCR0;         /*!< AD Monitoring Setting Register 0              */
  __IO uint32_t CMPCR1;         /*!< AD Monitoring Setting Register 1              */
  __IO uint32_t CMP0;           /*!< AD Conversion Result Comparison Register 0    */
  __IO uint32_t CMP1;           /*!< AD Conversion Result Comparison Register 1    */
  __I  uint32_t REG0;           /*!< AD Conversion Result Register 0               */
  __I  uint32_t REG1;           /*!< AD Conversion Result Register 1               */
  __I  uint32_t REG2;           /*!< AD Conversion Result Register 2               */
  __I  uint32_t REG3;           /*!< AD Conversion Result Register 3               */
  __I  uint32_t REG4;           /*!< AD Conversion Result Register 4               */
  __I  uint32_t REG5;           /*!< AD Conversion Result Register 5               */
  __I  uint32_t REG6;           /*!< AD Conversion Result Register 6               */
  __I  uint32_t REG7;           /*!< AD Conversion Result Register 7               */
  __I  uint32_t REG8;           /*!< AD Conversion Result Register 8               */
  __I  uint32_t REG9;           /*!< AD Conversion Result Register 9               */
  __I  uint32_t REG10;          /*!< AD Conversion Result Register 10              */
  __I  uint32_t REG11;          /*!< AD Conversion Result Register 11              */
  __IO uint32_t PSEL0;          /*!< PMD Trigger Program Number Select Register 0  */
  __IO uint32_t PSEL1;          /*!< PMD Trigger Program Number Select Register 1  */
  __IO uint32_t PSEL2;          /*!< PMD Trigger Program Number Select Register 2  */
  __IO uint32_t PSEL3;          /*!< PMD Trigger Program Number Select Register 3  */
       uint32_t RESERVED0[8];
  __IO uint32_t PINTS0;         /*!< PMD Trigger Interrupt Select Register 0       */
  __IO uint32_t PINTS1;         /*!< PMD Trigger Interrupt Select Register 1       */
  __IO uint32_t PINTS2;         /*!< PMD Trigger Interrupt Select Register 2       */
  __IO uint32_t PINTS3;         /*!< PMD Trigger Interrupt Select Register 3       */
  __IO uint32_t PINTS4;         /*!< PMD Trigger Interrupt Select Register 4       */
  __IO uint32_t PINTS5;         /*!< PMD Trigger Interrupt Select Register 5       */
  __IO uint8_t  PSET00;         /*!< PMD Trigger Program Register 00               */
  __IO uint8_t  PSET01;         /*!< PMD Trigger Program Register 01               */
  __IO uint8_t  PSET02;         /*!< PMD Trigger Program Register 02               */
  __IO uint8_t  PSET03;         /*!< PMD Trigger Program Register 03               */
  __IO uint8_t  PSET10;         /*!< PMD Trigger Program Register 10               */
  __IO uint8_t  PSET11;         /*!< PMD Trigger Program Register 11               */
  __IO uint8_t  PSET12;         /*!< PMD Trigger Program Register 12               */
  __IO uint8_t  PSET13;         /*!< PMD Trigger Program Register 13               */
  __IO uint8_t  PSET20;         /*!< PMD Trigger Program Register 20               */
  __IO uint8_t  PSET21;         /*!< PMD Trigger Program Register 21               */
  __IO uint8_t  PSET22;         /*!< PMD Trigger Program Register 22               */
  __IO uint8_t  PSET23;         /*!< PMD Trigger Program Register 23               */
  __IO uint8_t  PSET30;         /*!< PMD Trigger Program Register 30               */
  __IO uint8_t  PSET31;         /*!< PMD Trigger Program Register 31               */
  __IO uint8_t  PSET32;         /*!< PMD Trigger Program Register 32               */
  __IO uint8_t  PSET33;         /*!< PMD Trigger Program Register 33               */
  __IO uint8_t  PSET40;         /*!< PMD Trigger Program Register 40               */
  __IO uint8_t  PSET41;         /*!< PMD Trigger Program Register 41               */
  __IO uint8_t  PSET42;         /*!< PMD Trigger Program Register 42               */
  __IO uint8_t  PSET43;         /*!< PMD Trigger Program Register 43               */
  __IO uint8_t  PSET50;         /*!< PMD Trigger Program Register 50               */
  __IO uint8_t  PSET51;         /*!< PMD Trigger Program Register 51               */
  __IO uint8_t  PSET52;         /*!< PMD Trigger Program Register 52               */
  __IO uint8_t  PSET53;         /*!< PMD Trigger Program Register 53               */
  __IO uint8_t  TSET0;          /*!< Timer Trigger Program Register 0              */
  __IO uint8_t  TSET1;          /*!< Timer Trigger Program Register 1              */
  __IO uint8_t  TSET2;          /*!< Timer Trigger Program Register 2              */
  __IO uint8_t  TSET3;          /*!< Timer Trigger Program Register 3              */
  __IO uint8_t  TSET4;          /*!< Timer Trigger Program Register 4              */
  __IO uint8_t  TSET5;          /*!< Timer Trigger Program Register 5              */
  __IO uint8_t  TSET6;          /*!< Timer Trigger Program Register 6              */
  __IO uint8_t  TSET7;          /*!< Timer Trigger Program Register 7              */
  __IO uint8_t  TSET8;          /*!< Timer Trigger Program Register 8              */
  __IO uint8_t  TSET9;          /*!< Timer Trigger Program Register 9              */
  __IO uint8_t  TSET10;         /*!< Timer Trigger Program Register 10             */
  __IO uint8_t  TSET11;         /*!< Timer Trigger Program Register 11             */
  __IO uint8_t  SSET0;          /*!< Software Trigger Program Register 0           */
  __IO uint8_t  SSET1;          /*!< Software Trigger Program Register 1           */
  __IO uint8_t  SSET2;          /*!< Software Trigger Program Register 2           */
  __IO uint8_t  SSET3;          /*!< Software Trigger Program Register 3           */
  __IO uint8_t  SSET4;          /*!< Software Trigger Program Register 4           */
  __IO uint8_t  SSET5;          /*!< Software Trigger Program Register 5           */
  __IO uint8_t  SSET6;          /*!< Software Trigger Program Register 6           */
  __IO uint8_t  SSET7;          /*!< Software Trigger Program Register 7           */
  __IO uint8_t  SSET8;          /*!< Software Trigger Program Register 8           */
  __IO uint8_t  SSET9;          /*!< Software Trigger Program Register 9           */
  __IO uint8_t  SSET10;         /*!< Software Trigger Program Register 10          */
  __IO uint8_t  SSET11;         /*!< Software Trigger Program Register 11          */
  __IO uint8_t  ASET0;          /*!< Constant Trigger Program Register 0           */
  __IO uint8_t  ASET1;          /*!< Constant Trigger Program Register 1           */
  __IO uint8_t  ASET2;          /*!< Constant Trigger Program Register 2           */
  __IO uint8_t  ASET3;          /*!< Constant Trigger Program Register 3           */
  __IO uint8_t  ASET4;          /*!< Constant Trigger Program Register 4           */
  __IO uint8_t  ASET5;          /*!< Constant Trigger Program Register 5           */
  __IO uint8_t  ASET6;          /*!< Constant Trigger Program Register 6           */
  __IO uint8_t  ASET7;          /*!< Constant Trigger Program Register 7           */
  __IO uint8_t  ASET8;          /*!< Constant Trigger Program Register 8           */
  __IO uint8_t  ASET9;          /*!< Constant Trigger Program Register 9           */
  __IO uint8_t  ASET10;         /*!< Constant Trigger Program Register 10          */
  __IO uint8_t  ASET11;         /*!< Constant Trigger Program Register 11          */
  __IO uint32_t MOD3;           /*!< ADC Mode Setting Register 3                   */
} TSB_AD_TypeDef;

/**
  * @brief Watchdog Timer (WD)
  */
typedef struct
{
  __IO uint32_t MOD;            /*!< WD Mode Register    */
  __O  uint32_t CR;             /*!< WD Control Register */
} TSB_WD_TypeDef;


/**
  * @brief Real Time Clock (RTC)
  */
typedef struct
{
  __IO uint8_t SECR;            /*!< RTC Second Column Register          */
  __IO uint8_t MINR;            /*!< RTC Minute Column Register          */
  __IO uint8_t HOURR;           /*!< RTC Hour Column Register            */
       uint8_t RESERVED0;
  __IO uint8_t DAYR;            /*!< RTC Day of the Week Column Register */
  __IO uint8_t DATER;           /*!< RTC Day Column Register             */
  __IO uint8_t MONTHR;          /*!< RTC Month Column Register           */
  __IO uint8_t YEARR;           /*!< RTC Year Column Register            */
  __IO uint8_t PAGER;           /*!< RTC PAGE Register                   */
       uint8_t RESERVED1[3];
  __IO uint8_t RESTR;           /*!< RTC Reset Register                  */
} TSB_RTC_TypeDef;

/**
  * @brief Clock Generator (CG)
  */
typedef struct
{
  __IO uint32_t SYSCR;          /*!< System Control Register              */
  __IO uint32_t OSCCR;          /*!< Oscillation Control Register         */
  __IO uint32_t STBYCR;         /*!< Standby Control Register             */
  __IO uint32_t PLLSEL;         /*!< PLL Selection Register               */
  __IO uint32_t CKSEL;          /*!< System Clock Selection Register      */
  __IO uint32_t ICRCG;          /*!< CG Interrupt Request Clear Register  */
  __I  uint32_t NMIFLG;         /*!< NMI Flag Register                    */
  __IO uint32_t RSTFLG;         /*!< Reset Flag Register                  */
  __IO uint32_t IMCGA;          /*!< CG Interrupt Mode Control Register A */
  __IO uint32_t IMCGB;          /*!< CG Interrupt Mode Control Register B */
  __IO uint32_t IMCGC;          /*!< CG Interrupt Mode Control Register C */
  __IO uint32_t IMCGD;          /*!< CG Interrupt Mode Control Register D */
  __IO uint32_t IMCGE;          /*!< CG Interrupt Mode Control Register E */
} TSB_CG_TypeDef;

/**
  * @brief Remote Control Signal Preprocessor (RMC)
  */
typedef struct
{
  __IO uint32_t EN;             /*!< RMC Enable Register                */
  __IO uint32_t REN;            /*!< RMC Receive Enable Register        */
  __I  uint32_t RBUF1;          /*!< RMC Receive Data Buffer Register 1 */
  __I  uint32_t RBUF2;          /*!< RMC Receive Data Buffer Register 2 */
  __I  uint32_t RBUF3;          /*!< RMC Receive Data Buffer Register 3 */
  __IO uint32_t RCR1;           /*!< RMC Receive Control Register 1     */
  __IO uint32_t RCR2;           /*!< RMC Receive Control Register 2     */
  __O  uint32_t RCR3;           /*!< RMC Receive Control Register 3     */
  __IO uint32_t RCR4;           /*!< RMC Receive Control Register 4     */
  __I  uint32_t RSTAT;          /*!< RMC Receive Status Register        */
       uint32_t RESERVED0[3];
  __IO uint32_t FSSEL;          /*!< RMC Source Clock Select Register   */
} TSB_RMC_TypeDef;


/**
  * @brief Oscillation Frequency Detector (OFD)
  */
typedef struct
{
  __IO uint32_t CR1;            /*!< OFD Control Register 1            */
  __IO uint32_t CR2;            /*!< OFD Control Register 2            */
  __IO uint32_t MN;             /*!< OFD MIN Value setting Register    */
       uint32_t RESERVED0;
  __IO uint32_t MX;             /*!< OFD MAX Value setting Register    */
       uint32_t RESERVED1;
  __IO uint32_t RST;
  __I  uint32_t STAT;
} TSB_OFD_TypeDef;

/**
  * @brief Power on reset (POR), Voltage detecting circuit (VLTD)
  */
typedef struct
{
  __IO uint32_t CR;             /*!< VD Control Register              */
  __I  uint32_t SR;             /*!<Voltage detection status register */
} TSB_VD_TypeDef; 
  
/**
  * @brief Multi purpose timer (PMD)
  */
typedef struct
{
  __IO uint32_t MDEN;               /*!<PMD Enable Register                     */
  __IO uint32_t PORTMD;             /*!<Port Output Mode Register               */
  __IO uint32_t MDCR;               /*!<PMD Control Register                    */
  __I  uint32_t CNTSTA;             /*!<PWM Counter Status Register             */
  __I  uint32_t MDCNT;              /*!<PWM Counter Register                    */
  __IO uint32_t MDPRD;              /*!<PWM Period Register                     */
  __IO uint32_t CMPU;               /*!<PWM Compare Registers                   */
  __IO uint32_t CMPV;               /*!<PWM Compare Registers                   */
  __IO uint32_t CMPW;               /*!<PWM Compare Registers                   */
       uint32_t RESERVED0;          
  __IO uint32_t MDOUT;              /*!<PMD Output Control Register             */
  __IO uint32_t MDPOT;              /*!<PMD Output Setting Register             */
  __O  uint32_t EMGREL;             /*!<EMG Release Register                    */
  __IO uint32_t EMGCR;              /*!<EMG Control Register                    */
  __I  uint32_t EMGST;              /*!<EMG Status Register                     */
       uint32_t RESERVED1[2];                                  
  __IO uint32_t DTR;                /*!<Dead Time Register                      */
  __IO uint32_t TRGCMP0;            /*!<Trigger Compare Registers 0             */
  __IO uint32_t TRGCMP1;            /*!<Trigger Compare Registers 1             */
       uint32_t RESERVED2[2];
  __IO uint32_t TRGCR;              /*!<Trigger Control Register                */
  __IO uint32_t TRGMD;              /*!<Trigger Output Mode Setting Register    */
} TSB_MTPD_TypeDef;

/**
  * @brief Multi purpose timer (TMR/IGBT)
  */
typedef struct
{
  __IO uint32_t EN;                /*!<MPT enable register            */
  __IO uint32_t RUN;               /*!<MPT RUN register               */
  __IO uint32_t TBCR;              /*!<MPT control register           */
  __IO uint32_t TBMOD;             /*!<MPT mode register              */
  __IO uint32_t TBFFCR;            /*!<MPT flip-flop control register */
  __I  uint32_t TBST;              /*!<MPT status register            */
  __IO uint32_t TBIM;              /*!<MPT interrupt mask register    */
  __I  uint32_t TBUC;              /*!<MPT read capture register      */
  __IO uint32_t RG0;               /*!<MPT timer register 0           */
  __IO uint32_t RG1;               /*!<MPT timer register 1           */
  __I  uint32_t CP0;               /*!<MPT capture register 0         */
  __I  uint32_t CP1;               /*!<MPT capture register 1         */
  __IO uint32_t IGCR;              /*!<IGBT control register          */
  __O  uint32_t IGRESTA;           /*!<IGBT timer restart register    */
  __I  uint32_t IGST;              /*!<IGBT timer status register     */
  __IO uint32_t IGICR;             /*!<IGBT input control register    */
  __IO uint32_t IGOCR;             /*!<IGBT output control register   */
  __IO uint32_t IGRG2;             /*!<IGBT timer register2           */
  __I  uint32_t IGRG3;             /*!<IGBT timer register3           */
  __I  uint32_t IGRG4;             /*!<IGBT timer register4           */
  __IO uint32_t IGEMGCR;           /*!<IGBT EMG control register      */
  __I  uint32_t IGEMGST;           /*!<IGBT EMG status register       */
} TSB_MT_TypeDef;

/**
  * @brief DMA controller (DMAC)
  */
typedef struct
{
  __I  uint32_t INTSTATUS;             /*!< DMAC Interrupt Status Register                    */
  __I  uint32_t INTTCSTATUS;           /*!< DMAC Interrupt Terminal Count Status Register     */
  __O  uint32_t INTTCCLEAR;            /*!< DMAC Interrupt Terminal Count Clear Register      */
  __I  uint32_t INTERRORSTATUS;        /*!< DMAC Interrupt Error Status Register              */
  __O  uint32_t INTERRCLR;             /*!< DMAC Interrupt Error Clear Register               */
  __I  uint32_t RAWINTTCSTATUS;        /*!< DMAC Raw Interrupt Terminal Count Status Register */
  __I  uint32_t RAWINTERRORSTATUS;     /*!< DMAC Raw Error Interrupt Status Register          */
  __I  uint32_t ENBLDCHNS;             /*!< DMAC Enabled Channel Register                     */
  __IO uint32_t SOFTBREQ;              /*!< DMAC Software Burst Request Register              */
  __IO uint32_t SOFTSREQ;              /*!< DMAC Software Single Request Register             */
       uint32_t RESERVED0[2];                                                          
  __IO uint32_t CONFIGURATION;         /*!< DMAC Configuration Register                       */
       uint32_t RESERVED1[51];                                                         
  __IO uint32_t C0SRCADDR;             /*!< DMAC Channel0 Source Address Register             */
  __IO uint32_t C0DESTADDR;            /*!< DMAC Channel0 Destination Address Register        */
  __IO uint32_t C0LLI;                 /*!< DMAC Channel0 Linked List Item Register           */
  __IO uint32_t C0CONTROL;             /*!< DMAC Channel0 Control Register                    */
  __IO uint32_t C0CONFIGURATION;       /*!< DMAC Channel0 Configuration Register              */
       uint32_t RESERVED3[3];                                                          
  __IO uint32_t C1SRCADDR;             /*!< DMAC Channel1 Source Address Register             */
  __IO uint32_t C1DESTADDR;            /*!< DMAC Channel1 Destination Address Register        */
  __IO uint32_t C1LLI;                 /*!< DMAC Channel1 Linked List Item Register           */
  __IO uint32_t C1CONTROL;             /*!< DMAC Channel1 Control Register                    */
  __IO uint32_t C1CONFIGURATION;       /*!< DMAC Channel1 Configuration Register              */
} TSB_DMAC_TypeDef;


/**
  * @brief Synchronous Serial Port (SSP)
  */
typedef struct
{
  __IO uint32_t CR0;             /*!< SSP Control Register 0                   */
  __IO uint32_t CR1;             /*!< SSP Control Register 1                   */
  __IO uint32_t DR;              /*!< SSP Data Register                        */
  __I  uint32_t SR;              /*!< SSP Status Register                      */
  __IO uint32_t CPSR;            /*!< SSP Clock Prescale Register              */
  __IO uint32_t IMSC;            /*!< SSP Interrupt Mask Set And Clear Register*/
  __I  uint32_t RIS;             /*!< SSP Raw Interrupt Status Register        */
  __I  uint32_t MIS;             /*!< SSP Masked Interrupt Status Register     */
  __O  uint32_t ICR;             /*!< SSP Interrupt Clear Register             */
  __IO uint32_t DMACR;           /*!< SSP DMA control register                 */
} TSB_SSP_TypeDef;

/**
  * @brief Flash Control (FC)
  */
typedef struct
{
  __IO uint32_t SECBIT;          /*!< FC Security Bit Register  */
       uint32_t RESERVED0[3];
  __I  uint32_t FLCS;            /*!< FC Flash Control Register */
} TSB_FC_TypeDef;


/* Memory map */
#define FLASH_BASE            (0x00000000UL)
#define RAM_BASE              (0x20000000UL)
#define PERI_BASE             (0x40000000UL)


#define TSB_PA_BASE               (PERI_BASE  + 0x0000000UL)
#define TSB_PB_BASE               (PERI_BASE  + 0x0000040UL)
#define TSB_PC_BASE               (PERI_BASE  + 0x0000080UL)
#define TSB_PD_BASE               (PERI_BASE  + 0x00000C0UL)
#define TSB_PE_BASE               (PERI_BASE  + 0x0000100UL)
#define TSB_PF_BASE               (PERI_BASE  + 0x0000140UL)
#define TSB_PG_BASE               (PERI_BASE  + 0x0000180UL)
#define TSB_PH_BASE               (PERI_BASE  + 0x00001C0UL)
#define TSB_PI_BASE               (PERI_BASE  + 0x0000200UL)
#define TSB_PJ_BASE               (PERI_BASE  + 0x0000240UL)
#define TSB_PL_BASE               (PERI_BASE  + 0x00002C0UL)
#define TSB_PM_BASE               (PERI_BASE  + 0x0000300UL)
#define TSB_PN_BASE               (PERI_BASE  + 0x0000340UL)
#define TSB_PP_BASE               (PERI_BASE  + 0x0000380UL)

#define TSB_TB0_BASE              (PERI_BASE  + 0x0010000UL)
#define TSB_TB1_BASE              (PERI_BASE  + 0x0010040UL)
#define TSB_TB2_BASE              (PERI_BASE  + 0x0010080UL)
#define TSB_TB3_BASE              (PERI_BASE  + 0x00100C0UL)
#define TSB_TB4_BASE              (PERI_BASE  + 0x0010100UL)
#define TSB_TB5_BASE              (PERI_BASE  + 0x0010140UL)
#define TSB_TB6_BASE              (PERI_BASE  + 0x0010180UL)
#define TSB_TB7_BASE              (PERI_BASE  + 0x00101C0UL)

#define TSB_EN0_BASE              (PERI_BASE  + 0x0010400UL)
#define TSB_EN1_BASE              (PERI_BASE  + 0x0010500UL)

#define TSB_SBI0_BASE             (PERI_BASE  + 0x0020000UL)
#define TSB_SBI1_BASE             (PERI_BASE  + 0x0020020UL)

#define TSB_SC0_BASE              (PERI_BASE  + 0x0020080UL)
#define TSB_SC1_BASE              (PERI_BASE  + 0x00200C0UL)
#define TSB_SC2_BASE              (PERI_BASE  + 0x0020100UL)
#define TSB_SC3_BASE              (PERI_BASE  + 0x0020140UL)
#define TSB_SC4_BASE              (PERI_BASE  + 0x0020180UL)

#define TSB_AD_BASE               (PERI_BASE  + 0x0030000UL)
#define TSB_WD_BASE               (PERI_BASE  + 0x0040000UL)
#define TSB_RTC_BASE              (PERI_BASE  + 0x0040100UL)
#define TSB_CG_BASE               (PERI_BASE  + 0x0040200UL)
#define TSB_RMC_BASE              (PERI_BASE  + 0x0040400UL)
#define TSB_OFD_BASE              (PERI_BASE  + 0x0040800UL)
#define TSB_VD_BASE               (PERI_BASE  + 0x0040900UL)
#define TSB_MTPD0_BASE            (PERI_BASE  + 0x0050400UL)
#define TSB_MTPD1_BASE            (PERI_BASE  + 0x0050480UL)
#define TSB_MT0_BASE              (PERI_BASE  + 0x0050800UL)
#define TSB_MT1_BASE              (PERI_BASE  + 0x0050880UL)
#define TSB_MT2_BASE              (PERI_BASE  + 0x0050900UL)

#define TSB_DMAC_BASE             (PERI_BASE  + 0x0080000UL)

#define TSB_SSP0_BASE             (PERI_BASE  + 0x00C0000UL)
#define TSB_SSP1_BASE             (PERI_BASE  + 0x00C0100UL)
#define TSB_FC_BASE               (PERI_BASE  + 0x1FFF010UL)


/* Peripheral declaration */                     
#define TSB_PA                ((     TSB_PA_TypeDef *)    TSB_PA_BASE)
#define TSB_PB                ((     TSB_PB_TypeDef *)    TSB_PB_BASE)
#define TSB_PC                ((     TSB_PC_TypeDef *)    TSB_PC_BASE)
#define TSB_PD                ((     TSB_PD_TypeDef *)    TSB_PD_BASE)
#define TSB_PE                ((     TSB_PE_TypeDef *)    TSB_PE_BASE)
#define TSB_PF                ((     TSB_PF_TypeDef *)    TSB_PF_BASE)
#define TSB_PG                ((     TSB_PG_TypeDef *)    TSB_PG_BASE)
#define TSB_PH                ((     TSB_PH_TypeDef *)    TSB_PH_BASE)
#define TSB_PI                ((     TSB_PI_TypeDef *)    TSB_PI_BASE)
#define TSB_PJ                ((     TSB_PJ_TypeDef *)    TSB_PJ_BASE)
#define TSB_PL                ((     TSB_PL_TypeDef *)    TSB_PL_BASE)
#define TSB_PM                ((     TSB_PM_TypeDef *)    TSB_PM_BASE)
#define TSB_PN                ((     TSB_PN_TypeDef *)    TSB_PN_BASE)
#define TSB_PP                ((     TSB_PP_TypeDef *)    TSB_PP_BASE)

#define TSB_TB0               ((     TSB_TB_TypeDef *)   TSB_TB0_BASE)
#define TSB_TB1               ((     TSB_TB_TypeDef *)   TSB_TB1_BASE)
#define TSB_TB2               ((     TSB_TB_TypeDef *)   TSB_TB2_BASE)
#define TSB_TB3               ((     TSB_TB_TypeDef *)   TSB_TB3_BASE)
#define TSB_TB4               ((     TSB_TB_TypeDef *)   TSB_TB4_BASE)
#define TSB_TB5               ((     TSB_TB_TypeDef *)   TSB_TB5_BASE)
#define TSB_TB6               ((     TSB_TB_TypeDef *)   TSB_TB6_BASE)
#define TSB_TB7               ((     TSB_TB_TypeDef *)   TSB_TB7_BASE)

#define TSB_EN0               ((     TSB_EN_TypeDef *)   TSB_EN0_BASE)
#define TSB_EN1               ((     TSB_EN_TypeDef *)   TSB_EN1_BASE)
#define TSB_SBI0              ((     TSB_SBI_TypeDef*)  TSB_SBI0_BASE)
#define TSB_SBI1              ((     TSB_SBI_TypeDef*)  TSB_SBI1_BASE)
#define TSB_SC0               ((     TSB_SC_TypeDef *)   TSB_SC0_BASE)
#define TSB_SC1               ((     TSB_SC_TypeDef *)   TSB_SC1_BASE)
#define TSB_SC2               ((     TSB_SC_TypeDef *)   TSB_SC2_BASE)
#define TSB_SC3               ((     TSB_SC_TypeDef *)   TSB_SC3_BASE)
#define TSB_SC4               ((     TSB_SC_TypeDef *)   TSB_SC4_BASE)
#define TSB_AD                ((     TSB_AD_TypeDef *)    TSB_AD_BASE)
#define TSB_WD                ((     TSB_WD_TypeDef *)    TSB_WD_BASE)
#define TSB_RTC               ((    TSB_RTC_TypeDef *)   TSB_RTC_BASE)
#define TSB_CG                ((     TSB_CG_TypeDef *)    TSB_CG_BASE)
#define TSB_RMC               ((    TSB_RMC_TypeDef *)   TSB_RMC_BASE)
#define TSB_OFD               ((    TSB_OFD_TypeDef *)   TSB_OFD_BASE)
#define TSB_VD                ((     TSB_VD_TypeDef *)    TSB_VD_BASE)
#define TSB_MTPD0             ((   TSB_MTPD_TypeDef *) TSB_MTPD0_BASE)
#define TSB_MTPD1             ((   TSB_MTPD_TypeDef *) TSB_MTPD1_BASE)
#define TSB_MT0               ((     TSB_MT_TypeDef *)   TSB_MT0_BASE)
#define TSB_MT1               ((     TSB_MT_TypeDef *)   TSB_MT1_BASE)
#define TSB_MT2               ((     TSB_MT_TypeDef *)   TSB_MT2_BASE)
#define TSB_DMAC              ((    TSB_DMAC_TypeDef*)  TSB_DMAC_BASE)
#define TSB_SSP0              ((    TSB_SSP_TypeDef *)  TSB_SSP0_BASE)
#define TSB_SSP1              ((    TSB_SSP_TypeDef *)  TSB_SSP1_BASE)
#define TSB_FC                ((     TSB_FC_TypeDef *)    TSB_FC_BASE)


/* Bit-Band for Device Specific Peripheral Registers */
#define BITBAND_OFFSET (0x02000000UL)
#define BITBAND_PERI_BASE (PERI_BASE + BITBAND_OFFSET)
#define BITBAND_PERI(addr, bitnum) (BITBAND_PERI_BASE + (((uint32_t)(addr) - PERI_BASE) << 5) + ((uint32_t)(bitnum) << 2))


/* General Purpose Input/Output Port (PA) */
#define TSB_PA_DATA_PA0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,0)))
#define TSB_PA_DATA_PA1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,1)))
#define TSB_PA_DATA_PA2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,2)))
#define TSB_PA_DATA_PA3                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,3)))
#define TSB_PA_DATA_PA4                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,4)))
#define TSB_PA_DATA_PA5                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,5)))
#define TSB_PA_DATA_PA6                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,6)))
#define TSB_PA_DATA_PA7                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,7)))
#define TSB_PA_CR_PA0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,0)))
#define TSB_PA_CR_PA1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,1)))
#define TSB_PA_CR_PA2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,2)))
#define TSB_PA_CR_PA3C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,3)))
#define TSB_PA_CR_PA4C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,4)))
#define TSB_PA_CR_PA5C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,5)))
#define TSB_PA_CR_PA6C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,6)))
#define TSB_PA_CR_PA7C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,7)))
#define TSB_PA_FR1_PA0F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,0)))
#define TSB_PA_FR1_PA1F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,1)))
#define TSB_PA_FR1_PA2F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,2)))
#define TSB_PA_FR1_PA3F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,3)))
#define TSB_PA_FR1_PA4F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,4)))
#define TSB_PA_FR1_PA5F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,5)))
#define TSB_PA_FR1_PA6F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,6)))
#define TSB_PA_FR1_PA7F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,7)))
#define TSB_PA_FR2_PA0F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,0)))
#define TSB_PA_FR2_PA1F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,1)))
#define TSB_PA_FR2_PA2F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,2)))
#define TSB_PA_FR2_PA3F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,3)))
#define TSB_PA_FR2_PA4F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,4)))
#define TSB_PA_FR2_PA5F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,5)))
#define TSB_PA_FR2_PA6F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,6)))
#define TSB_PA_FR2_PA7F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,7)))
#define TSB_PA_OD_PA0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,0)))
#define TSB_PA_OD_PA1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,1)))
#define TSB_PA_OD_PA2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,2)))
#define TSB_PA_OD_PA3OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,3)))
#define TSB_PA_OD_PA4OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,4)))
#define TSB_PA_OD_PA5OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,5)))
#define TSB_PA_OD_PA6OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,6)))
#define TSB_PA_OD_PA7OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,7)))
#define TSB_PA_PUP_PA0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,0)))
#define TSB_PA_PUP_PA1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,1)))
#define TSB_PA_PUP_PA2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,2)))
#define TSB_PA_PUP_PA3UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,3)))
#define TSB_PA_PUP_PA4UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,4)))
#define TSB_PA_PUP_PA5UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,5)))
#define TSB_PA_PUP_PA6UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,6)))
#define TSB_PA_PUP_PA7UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,7)))
#define TSB_PA_PDN_PA0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PDN,0)))
#define TSB_PA_PDN_PA1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PDN,1)))
#define TSB_PA_PDN_PA2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PDN,2)))
#define TSB_PA_PDN_PA3DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PDN,3)))
#define TSB_PA_PDN_PA4DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PDN,4)))
#define TSB_PA_PDN_PA5DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PDN,5)))
#define TSB_PA_PDN_PA6DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PDN,6)))
#define TSB_PA_PDN_PA7DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PDN,7)))
#define TSB_PA_IE_PA0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,0)))
#define TSB_PA_IE_PA1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,1)))
#define TSB_PA_IE_PA2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,2)))
#define TSB_PA_IE_PA3IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,3)))
#define TSB_PA_IE_PA4IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,4)))
#define TSB_PA_IE_PA5IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,5)))
#define TSB_PA_IE_PA6IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,6)))
#define TSB_PA_IE_PA7IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,7)))

/* General Purpose Input/Output Port (PB) */
#define TSB_PB_DATA_PB0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,0)))
#define TSB_PB_DATA_PB1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,1)))
#define TSB_PB_DATA_PB2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,2)))
#define TSB_PB_DATA_PB3                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,3)))
#define TSB_PB_DATA_PB4                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,4)))
#define TSB_PB_DATA_PB5                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,5)))
#define TSB_PB_DATA_PB6                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,6)))
#define TSB_PB_DATA_PB7                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,7)))
#define TSB_PB_CR_PB0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,0)))
#define TSB_PB_CR_PB1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,1)))
#define TSB_PB_CR_PB2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,2)))
#define TSB_PB_CR_PB3C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,3)))
#define TSB_PB_CR_PB4C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,4)))
#define TSB_PB_CR_PB5C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,5)))
#define TSB_PB_CR_PB6C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,6)))
#define TSB_PB_CR_PB7C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,7)))
#define TSB_PB_FR1_PB0F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,0)))
#define TSB_PB_FR1_PB1F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,1)))
#define TSB_PB_FR1_PB2F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,2)))
#define TSB_PB_FR1_PB3F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,3)))
#define TSB_PB_FR1_PB4F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,4)))
#define TSB_PB_FR1_PB5F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,5)))
#define TSB_PB_FR1_PB6F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,6)))
#define TSB_PB_FR1_PB7F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,7)))
#define TSB_PB_OD_PB0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,0)))
#define TSB_PB_OD_PB1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,1)))
#define TSB_PB_OD_PB2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,2)))
#define TSB_PB_OD_PB3OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,3)))
#define TSB_PB_OD_PB4OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,4)))
#define TSB_PB_OD_PB5OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,5)))
#define TSB_PB_OD_PB6OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,6)))
#define TSB_PB_OD_PB7OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,7)))
#define TSB_PB_PUP_PB0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,0)))
#define TSB_PB_PUP_PB1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,1)))
#define TSB_PB_PUP_PB2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,2)))
#define TSB_PB_PUP_PB3UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,3)))
#define TSB_PB_PUP_PB4UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,4)))
#define TSB_PB_PUP_PB5UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,5)))
#define TSB_PB_PUP_PB6UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,6)))
#define TSB_PB_PUP_PB7UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,7)))
#define TSB_PB_PDN_PB0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PDN,0)))
#define TSB_PB_PDN_PB1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PDN,1)))
#define TSB_PB_PDN_PB2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PDN,2)))
#define TSB_PB_PDN_PB3DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PDN,3)))
#define TSB_PB_PDN_PB4DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PDN,4)))
#define TSB_PB_PDN_PB5DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PDN,5)))
#define TSB_PB_PDN_PB6DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PDN,6)))
#define TSB_PB_PDN_PB7DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PDN,7)))
#define TSB_PB_IE_PB0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,0)))
#define TSB_PB_IE_PB1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,1)))
#define TSB_PB_IE_PB2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,2)))
#define TSB_PB_IE_PB3IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,3)))
#define TSB_PB_IE_PB4IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,4)))
#define TSB_PB_IE_PB5IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,5)))
#define TSB_PB_IE_PB6IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,6)))
#define TSB_PB_IE_PB7IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,7)))

/* General Purpose Input/Output Port (PC) */
#define TSB_PC_DATA_PC0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,0)))
#define TSB_PC_DATA_PC1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,1)))
#define TSB_PC_DATA_PC2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,2)))
#define TSB_PC_DATA_PC3                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,3)))
#define TSB_PC_DATA_PC4                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,4)))
#define TSB_PC_DATA_PC5                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,5)))
#define TSB_PC_DATA_PC6                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,6)))
#define TSB_PC_DATA_PC7                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,7)))
#define TSB_PC_CR_PC0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,0)))
#define TSB_PC_CR_PC1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,1)))
#define TSB_PC_CR_PC2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,2)))
#define TSB_PC_CR_PC3C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,3)))
#define TSB_PC_CR_PC4C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,4)))
#define TSB_PC_CR_PC5C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,5)))
#define TSB_PC_CR_PC6C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,6)))
#define TSB_PC_CR_PC7C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,7)))
#define TSB_PC_FR1_PC0F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,0)))
#define TSB_PC_FR1_PC1F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,1)))
#define TSB_PC_FR1_PC2F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,2)))
#define TSB_PC_FR1_PC3F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,3)))
#define TSB_PC_FR1_PC4F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,4)))
#define TSB_PC_FR1_PC5F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,5)))
#define TSB_PC_FR1_PC6F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,6)))
#define TSB_PC_FR2_PC0F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,0)))
#define TSB_PC_FR2_PC1F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,1)))
#define TSB_PC_FR2_PC2F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,2)))
#define TSB_PC_FR2_PC3F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,3)))
#define TSB_PC_FR2_PC4F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,4)))
#define TSB_PC_FR2_PC5F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,5)))
#define TSB_PC_FR2_PC6F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,6)))
#define TSB_PC_FR2_PC7F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,7)))
#define TSB_PC_FR3_PC0F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,0)))
#define TSB_PC_FR3_PC1F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,1)))
#define TSB_PC_FR3_PC2F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,2)))
#define TSB_PC_FR3_PC4F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,4)))
#define TSB_PC_FR3_PC5F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,5)))
#define TSB_PC_FR4_PC5F4                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR4,5)))
#define TSB_PC_FR4_PC6F4                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR4,6)))
#define TSB_PC_FR4_PC7F4                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR4,7)))
#define TSB_PC_FR5_PC5F5                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR5,5)))
#define TSB_PC_OD_PC0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,0)))
#define TSB_PC_OD_PC1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,1)))
#define TSB_PC_OD_PC2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,2)))
#define TSB_PC_OD_PC3OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,3)))
#define TSB_PC_OD_PC4OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,4)))
#define TSB_PC_OD_PC5OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,5)))
#define TSB_PC_OD_PC6OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,6)))
#define TSB_PC_OD_PC7OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,7)))
#define TSB_PC_PUP_PC0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,0)))
#define TSB_PC_PUP_PC1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,1)))
#define TSB_PC_PUP_PC2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,2)))
#define TSB_PC_PUP_PC3UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,3)))
#define TSB_PC_PUP_PC4UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,4)))
#define TSB_PC_PUP_PC5UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,5)))
#define TSB_PC_PUP_PC6UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,6)))
#define TSB_PC_PUP_PC7UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,7)))
#define TSB_PC_PDN_PC0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PDN,0)))
#define TSB_PC_PDN_PC1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PDN,1)))
#define TSB_PC_PDN_PC2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PDN,2)))
#define TSB_PC_PDN_PC3DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PDN,3)))
#define TSB_PC_PDN_PC4DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PDN,4)))
#define TSB_PC_PDN_PC5DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PDN,5)))
#define TSB_PC_PDN_PC6DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PDN,6)))
#define TSB_PC_PDN_PC7DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PDN,7)))
#define TSB_PC_IE_PC0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,0)))
#define TSB_PC_IE_PC1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,1)))
#define TSB_PC_IE_PC2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,2)))
#define TSB_PC_IE_PC3IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,3)))
#define TSB_PC_IE_PC4IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,4)))
#define TSB_PC_IE_PC5IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,5)))
#define TSB_PC_IE_PC6IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,6)))
#define TSB_PC_IE_PC7IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,7)))

/* General Purpose Input/Output Port (PD) */
#define TSB_PD_DATA_PD0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,0)))
#define TSB_PD_DATA_PD1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,1)))
#define TSB_PD_DATA_PD2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,2)))
#define TSB_PD_DATA_PD3                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,3)))
#define TSB_PD_DATA_PD4                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,4)))
#define TSB_PD_DATA_PD5                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,5)))
#define TSB_PD_DATA_PD6                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,6)))
#define TSB_PD_CR_PD0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,0)))
#define TSB_PD_CR_PD1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,1)))
#define TSB_PD_CR_PD2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,2)))
#define TSB_PD_CR_PD3C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,3)))
#define TSB_PD_CR_PD4C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,4)))
#define TSB_PD_CR_PD5C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,5)))
#define TSB_PD_CR_PD6C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,6)))
#define TSB_PD_FR1_PD0F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,0)))
#define TSB_PD_FR1_PD1F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,1)))
#define TSB_PD_FR1_PD2F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,2)))
#define TSB_PD_FR1_PD3F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,3)))
#define TSB_PD_FR1_PD4F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,4)))
#define TSB_PD_FR1_PD5F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,5)))
#define TSB_PD_FR1_PD6F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,6)))
#define TSB_PD_FR2_PD0F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,0)))
#define TSB_PD_FR2_PD1F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,1)))
#define TSB_PD_FR2_PD4F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,4)))
#define TSB_PD_FR3_PD0F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR3,0)))
#define TSB_PD_FR3_PD2F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR3,2)))
#define TSB_PD_OD_PD0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,0)))
#define TSB_PD_OD_PD1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,1)))
#define TSB_PD_OD_PD2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,2)))
#define TSB_PD_OD_PD3OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,3)))
#define TSB_PD_OD_PD4OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,4)))
#define TSB_PD_OD_PD5OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,5)))
#define TSB_PD_OD_PD6OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,6)))
#define TSB_PD_PUP_PD0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,0)))
#define TSB_PD_PUP_PD1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,1)))
#define TSB_PD_PUP_PD2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,2)))
#define TSB_PD_PUP_PD3UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,3)))
#define TSB_PD_PUP_PD4UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,4)))
#define TSB_PD_PUP_PD5UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,5)))
#define TSB_PD_PUP_PD6UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,6)))
#define TSB_PD_PDN_PD0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PDN,0)))
#define TSB_PD_PDN_PD1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PDN,1)))
#define TSB_PD_PDN_PD2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PDN,2)))
#define TSB_PD_PDN_PD3DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PDN,3)))
#define TSB_PD_PDN_PD4DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PDN,4)))
#define TSB_PD_PDN_PD5DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PDN,5)))
#define TSB_PD_PDN_PD6DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PDN,6)))
#define TSB_PD_IE_PD0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,0)))
#define TSB_PD_IE_PD1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,1)))
#define TSB_PD_IE_PD2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,2)))
#define TSB_PD_IE_PD3IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,3)))
#define TSB_PD_IE_PD4IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,4)))
#define TSB_PD_IE_PD5IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,5)))
#define TSB_PD_IE_PD6IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,6)))

/* General Purpose Input/Output Port (PE) */
#define TSB_PE_DATA_PE0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,0)))
#define TSB_PE_DATA_PE1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,1)))
#define TSB_PE_DATA_PE2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,2)))
#define TSB_PE_DATA_PE3                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,3)))
#define TSB_PE_DATA_PE4                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,4)))
#define TSB_PE_DATA_PE5                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,5)))
#define TSB_PE_DATA_PE6                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,6)))
#define TSB_PE_DATA_PE7                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,7)))
#define TSB_PE_CR_PE0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,0)))
#define TSB_PE_CR_PE1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,1)))
#define TSB_PE_CR_PE2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,2)))
#define TSB_PE_CR_PE3C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,3)))
#define TSB_PE_CR_PE4C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,4)))
#define TSB_PE_CR_PE5C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,5)))
#define TSB_PE_CR_PE6C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,6)))
#define TSB_PE_CR_PE7C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,7)))
#define TSB_PE_FR1_PE0F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,0)))
#define TSB_PE_FR1_PE1F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,1)))
#define TSB_PE_FR1_PE2F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,2)))
#define TSB_PE_FR1_PE3F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,3)))
#define TSB_PE_FR1_PE4F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,4)))
#define TSB_PE_FR1_PE5F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,5)))
#define TSB_PE_FR1_PE6F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,6)))
#define TSB_PE_FR1_PE7F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,7)))
#define TSB_PE_FR2_PE2F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,2)))
#define TSB_PE_FR2_PE4F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,4)))
#define TSB_PE_FR2_PE6F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,6)))
#define TSB_PE_FR2_PE7F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,7)))
#define TSB_PE_OD_PE0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,0)))
#define TSB_PE_OD_PE1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,1)))
#define TSB_PE_OD_PE2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,2)))
#define TSB_PE_OD_PE3OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,3)))
#define TSB_PE_OD_PE4OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,4)))
#define TSB_PE_OD_PE5OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,5)))
#define TSB_PE_OD_PE6OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,6)))
#define TSB_PE_OD_PE7OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,7)))
#define TSB_PE_PUP_PE0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,0)))
#define TSB_PE_PUP_PE1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,1)))
#define TSB_PE_PUP_PE2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,2)))
#define TSB_PE_PUP_PE3UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,3)))
#define TSB_PE_PUP_PE4UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,4)))
#define TSB_PE_PUP_PE5UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,5)))
#define TSB_PE_PUP_PE6UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,6)))
#define TSB_PE_PUP_PE7UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,7)))
#define TSB_PE_PDN_PE0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PDN,0)))
#define TSB_PE_PDN_PE1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PDN,1)))
#define TSB_PE_PDN_PE2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PDN,2)))
#define TSB_PE_PDN_PE3DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PDN,3)))
#define TSB_PE_PDN_PE4DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PDN,4)))
#define TSB_PE_PDN_PE5DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PDN,5)))
#define TSB_PE_PDN_PE6DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PDN,6)))
#define TSB_PE_PDN_PE7DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PDN,7)))
#define TSB_PE_IE_PE0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,0)))
#define TSB_PE_IE_PE1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,1)))
#define TSB_PE_IE_PE2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,2)))
#define TSB_PE_IE_PE3IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,3)))
#define TSB_PE_IE_PE4IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,4)))
#define TSB_PE_IE_PE5IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,5)))
#define TSB_PE_IE_PE6IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,6)))
#define TSB_PE_IE_PE7IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,7)))

/* General Purpose Input/Output Port (PF) */
#define TSB_PF_DATA_PF0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,0)))
#define TSB_PF_DATA_PF1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,1)))
#define TSB_PF_DATA_PF2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,2)))
#define TSB_PF_DATA_PF3                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,3)))
#define TSB_PF_DATA_PF4                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,4)))
#define TSB_PF_CR_PF0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,0)))
#define TSB_PF_CR_PF1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,1)))
#define TSB_PF_CR_PF2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,2)))
#define TSB_PF_CR_PF3C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,3)))
#define TSB_PF_CR_PF4C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,4)))
#define TSB_PF_FR1_PF0F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,0)))
#define TSB_PF_FR1_PF1F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,1)))
#define TSB_PF_FR1_PF2F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,2)))
#define TSB_PF_FR1_PF3F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,3)))
#define TSB_PF_FR1_PF4F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,4)))
#define TSB_PF_FR2_PF1F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,1)))
#define TSB_PF_FR2_PF2F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,2)))
#define TSB_PF_FR2_PF3F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,3)))
#define TSB_PF_FR2_PF4F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,4)))
#define TSB_PF_FR3_PF2F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR3,2)))
#define TSB_PF_OD_PF0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,0)))
#define TSB_PF_OD_PF1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,1)))
#define TSB_PF_OD_PF2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,2)))
#define TSB_PF_OD_PF3OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,3)))
#define TSB_PF_OD_PF4OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,4)))
#define TSB_PF_PUP_PF0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,0)))
#define TSB_PF_PUP_PF1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,1)))
#define TSB_PF_PUP_PF2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,2)))
#define TSB_PF_PUP_PF3UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,3)))
#define TSB_PF_PUP_PF4UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,4)))
#define TSB_PF_PDN_PF0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PDN,0)))
#define TSB_PF_PDN_PF1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PDN,1)))
#define TSB_PF_PDN_PF2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PDN,2)))
#define TSB_PF_PDN_PF3DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PDN,3)))
#define TSB_PF_PDN_PF4DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PDN,4)))
#define TSB_PF_IE_PF0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,0)))
#define TSB_PF_IE_PF1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,1)))
#define TSB_PF_IE_PF2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,2)))
#define TSB_PF_IE_PF3IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,3)))
#define TSB_PF_IE_PF4IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,4)))

/* General Purpose Input/Output Port (PG) */
#define TSB_PG_DATA_PG0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,0)))
#define TSB_PG_DATA_PG1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,1)))
#define TSB_PG_DATA_PG2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,2)))
#define TSB_PG_DATA_PG3                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,3)))
#define TSB_PG_DATA_PG4                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,4)))
#define TSB_PG_DATA_PG5                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,5)))
#define TSB_PG_DATA_PG6                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,6)))
#define TSB_PG_DATA_PG7                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,7)))
#define TSB_PG_CR_PG0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,0)))
#define TSB_PG_CR_PG1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,1)))
#define TSB_PG_CR_PG2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,2)))
#define TSB_PG_CR_PG3C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,3)))
#define TSB_PG_CR_PG4C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,4)))
#define TSB_PG_CR_PG5C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,5)))
#define TSB_PG_CR_PG6C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,6)))
#define TSB_PG_CR_PG7C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,7)))
#define TSB_PG_FR1_PG0F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,0)))
#define TSB_PG_FR1_PG1F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,1)))
#define TSB_PG_FR1_PG2F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,2)))
#define TSB_PG_FR1_PG3F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,3)))
#define TSB_PG_FR1_PG4F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,4)))
#define TSB_PG_FR1_PG5F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,5)))
#define TSB_PG_FR1_PG6F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,6)))
#define TSB_PG_FR2_PG4F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR2,4)))
#define TSB_PG_FR2_PG5F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR2,5)))
#define TSB_PG_FR2_PG6F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR2,6)))
#define TSB_PG_FR2_PG7F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR2,7)))
#define TSB_PG_FR3_PG0F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR3,0)))
#define TSB_PG_FR3_PG1F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR3,1)))
#define TSB_PG_FR3_PG2F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR3,2)))
#define TSB_PG_FR3_PG4F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR3,4)))
#define TSB_PG_FR3_PG5F3                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR3,5)))
#define TSB_PG_OD_PG0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,0)))
#define TSB_PG_OD_PG1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,1)))
#define TSB_PG_OD_PG2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,2)))
#define TSB_PG_OD_PG3OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,3)))
#define TSB_PG_OD_PG4OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,4)))
#define TSB_PG_OD_PG5OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,5)))
#define TSB_PG_OD_PG6OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,6)))
#define TSB_PG_OD_PG7OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,7)))
#define TSB_PG_PUP_PG0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,0)))
#define TSB_PG_PUP_PG1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,1)))
#define TSB_PG_PUP_PG2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,2)))
#define TSB_PG_PUP_PG3UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,3)))
#define TSB_PG_PUP_PG4UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,4)))
#define TSB_PG_PUP_PG5UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,5)))
#define TSB_PG_PUP_PG6UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,6)))
#define TSB_PG_PUP_PG7UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,7)))
#define TSB_PG_PDN_PG0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,0)))
#define TSB_PG_PDN_PG1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,1)))
#define TSB_PG_PDN_PG2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,2)))
#define TSB_PG_PDN_PG3DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,3)))
#define TSB_PG_PDN_PG4DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,4)))
#define TSB_PG_PDN_PG5DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,5)))
#define TSB_PG_PDN_PG6DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,6)))
#define TSB_PG_PDN_PG7DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,7)))
#define TSB_PG_IE_PG0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,0)))
#define TSB_PG_IE_PG1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,1)))
#define TSB_PG_IE_PG2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,2)))
#define TSB_PG_IE_PG3IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,3)))
#define TSB_PG_IE_PG4IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,4)))
#define TSB_PG_IE_PG5IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,5)))
#define TSB_PG_IE_PG6IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,6)))
#define TSB_PG_IE_PG7IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,7)))

/* General Purpose Input/Output Port (PH) */
#define TSB_PH_DATA_PH0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,0)))
#define TSB_PH_DATA_PH1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,1)))
#define TSB_PH_DATA_PH2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,2)))
#define TSB_PH_DATA_PH3                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,3)))
#define TSB_PH_DATA_PH4                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,4)))
#define TSB_PH_DATA_PH5                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,5)))
#define TSB_PH_DATA_PH6                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,6)))
#define TSB_PH_DATA_PH7                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,7)))
#define TSB_PH_CR_PH0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,0)))
#define TSB_PH_CR_PH1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,1)))
#define TSB_PH_CR_PH2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,2)))
#define TSB_PH_CR_PH3C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,3)))
#define TSB_PH_CR_PH4C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,4)))
#define TSB_PH_CR_PH5C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,5)))
#define TSB_PH_CR_PH6C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,6)))
#define TSB_PH_CR_PH7C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,7)))
#define TSB_PH_FR1_PH0F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,0)))
#define TSB_PH_FR1_PH1F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,1)))
#define TSB_PH_FR1_PH2F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,2)))
#define TSB_PH_OD_PH0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,0)))
#define TSB_PH_OD_PH1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,1)))
#define TSB_PH_OD_PH2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,2)))
#define TSB_PH_OD_PH3OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,3)))
#define TSB_PH_OD_PH4OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,4)))
#define TSB_PH_OD_PH5OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,5)))
#define TSB_PH_OD_PH6OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,6)))
#define TSB_PH_OD_PH7OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,7)))
#define TSB_PH_PUP_PH0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,0)))
#define TSB_PH_PUP_PH1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,1)))
#define TSB_PH_PUP_PH2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,2)))
#define TSB_PH_PUP_PH3UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,3)))
#define TSB_PH_PUP_PH4UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,4)))
#define TSB_PH_PUP_PH5UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,5)))
#define TSB_PH_PUP_PH6UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,6)))
#define TSB_PH_PUP_PH7UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,7)))
#define TSB_PH_PDN_PH0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PDN,0)))
#define TSB_PH_PDN_PH1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PDN,1)))
#define TSB_PH_PDN_PH2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PDN,2)))
#define TSB_PH_PDN_PH3DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PDN,3)))
#define TSB_PH_PDN_PH4DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PDN,4)))
#define TSB_PH_PDN_PH5DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PDN,5)))
#define TSB_PH_PDN_PH6DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PDN,6)))
#define TSB_PH_PDN_PH7DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PDN,7)))
#define TSB_PH_IE_PH0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,0)))
#define TSB_PH_IE_PH1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,1)))
#define TSB_PH_IE_PH2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,2)))
#define TSB_PH_IE_PH3IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,3)))
#define TSB_PH_IE_PH4IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,4)))
#define TSB_PH_IE_PH5IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,5)))
#define TSB_PH_IE_PH6IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,6)))
#define TSB_PH_IE_PH7IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,7)))

/* General Purpose Input/Output Port (PI) */
#define TSB_PI_DATA_PI0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->DATA,0)))
#define TSB_PI_DATA_PI1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->DATA,1)))
#define TSB_PI_CR_PI0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->CR,0)))
#define TSB_PI_CR_PI1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->CR,1)))
#define TSB_PI_OD_PI0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->OD,0)))
#define TSB_PI_OD_PI1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->OD,1)))
#define TSB_PI_PUP_PI0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->PUP,0)))
#define TSB_PI_PUP_PI1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->PUP,1)))
#define TSB_PI_PDN_PI0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->PDN,0)))
#define TSB_PI_PDN_PI1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->PDN,1)))
#define TSB_PI_IE_PI0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->IE,0)))
#define TSB_PI_IE_PI1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PI->IE,1)))

/* General Purpose Input/Output Port (PJ) */
#define TSB_PJ_DATA_PJ0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,0)))
#define TSB_PJ_DATA_PJ1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,1)))
#define TSB_PJ_DATA_PJ2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,2)))
#define TSB_PJ_DATA_PJ3                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,3)))
#define TSB_PJ_DATA_PJ4                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,4)))
#define TSB_PJ_DATA_PJ5                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,5)))
#define TSB_PJ_DATA_PJ6                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,6)))
#define TSB_PJ_DATA_PJ7                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,7)))
#define TSB_PJ_CR_PJ0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,0)))
#define TSB_PJ_CR_PJ1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,1)))
#define TSB_PJ_CR_PJ2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,2)))
#define TSB_PJ_CR_PJ3C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,3)))
#define TSB_PJ_CR_PJ4C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,4)))
#define TSB_PJ_CR_PJ5C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,5)))
#define TSB_PJ_CR_PJ6C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,6)))
#define TSB_PJ_CR_PJ7C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,7)))
#define TSB_PJ_FR1_PJ6F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,6)))
#define TSB_PJ_FR1_PJ7F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,7)))
#define TSB_PJ_OD_PJ0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,0)))
#define TSB_PJ_OD_PJ1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,1)))
#define TSB_PJ_OD_PJ2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,2)))
#define TSB_PJ_OD_PJ3OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,3)))
#define TSB_PJ_OD_PJ4OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,4)))
#define TSB_PJ_OD_PJ5OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,5)))
#define TSB_PJ_OD_PJ6OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,6)))
#define TSB_PJ_OD_PJ7OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,7)))
#define TSB_PJ_PUP_PJ0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,0)))
#define TSB_PJ_PUP_PJ1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,1)))
#define TSB_PJ_PUP_PJ2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,2)))
#define TSB_PJ_PUP_PJ3UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,3)))
#define TSB_PJ_PUP_PJ4UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,4)))
#define TSB_PJ_PUP_PJ5UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,5)))
#define TSB_PJ_PUP_PJ6UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,6)))
#define TSB_PJ_PUP_PJ7UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,7)))
#define TSB_PJ_PDN_PJ0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PDN,0)))
#define TSB_PJ_PDN_PJ1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PDN,1)))
#define TSB_PJ_PDN_PJ2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PDN,2)))
#define TSB_PJ_PDN_PJ3DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PDN,3)))
#define TSB_PJ_PDN_PJ4DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PDN,4)))
#define TSB_PJ_PDN_PJ5DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PDN,5)))
#define TSB_PJ_PDN_PJ6DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PDN,6)))
#define TSB_PJ_PDN_PJ7DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PDN,7)))
#define TSB_PJ_IE_PJ0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,0)))
#define TSB_PJ_IE_PJ1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,1)))
#define TSB_PJ_IE_PJ2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,2)))
#define TSB_PJ_IE_PJ3IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,3)))
#define TSB_PJ_IE_PJ4IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,4)))
#define TSB_PJ_IE_PJ5IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,5)))
#define TSB_PJ_IE_PJ6IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,6)))
#define TSB_PJ_IE_PJ7IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,7)))

/* General Purpose Input/Output Port (PL) */
#define TSB_PL_DATA_PL0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,0)))
#define TSB_PL_DATA_PL2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,2)))
#define TSB_PL_CR_PL0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,0)))
#define TSB_PL_CR_PL2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,2)))
#define TSB_PL_FR1_PL2F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,2)))
#define TSB_PL_OD_PL0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,0)))
#define TSB_PL_OD_PL2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,2)))
#define TSB_PL_PUP_PL0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,0)))
#define TSB_PL_PUP_PL2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,2)))
#define TSB_PL_PDN_PL0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PDN,0)))
#define TSB_PL_PDN_PL2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PDN,2)))
#define TSB_PL_IE_PL2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,2)))

/* General Purpose Input/Output Port (PM) */
#define TSB_PM_DATA_PM0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,0)))
#define TSB_PM_DATA_PM1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,1)))
#define TSB_PM_CR_PM0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,0)))
#define TSB_PM_CR_PM1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,1)))
#define TSB_PM_OD_PM0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,0)))
#define TSB_PM_OD_PM1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,1)))
#define TSB_PM_PUP_PM0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,0)))
#define TSB_PM_PUP_PM1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,1)))
#define TSB_PM_PDN_PM0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PDN,0)))
#define TSB_PM_PDN_PM1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PDN,1)))
#define TSB_PM_IE_PM0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,0)))
#define TSB_PM_IE_PM1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,1)))

/* General Purpose Input/Output Port (PN) */
#define TSB_PN_DATA_PN0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,0)))
#define TSB_PN_DATA_PN1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,1)))
#define TSB_PN_DATA_PN2                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,2)))
#define TSB_PN_DATA_PN3                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,3)))
#define TSB_PN_DATA_PN4                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,4)))
#define TSB_PN_DATA_PN5                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,5)))
#define TSB_PN_DATA_PN6                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,6)))
#define TSB_PN_DATA_PN7                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,7)))
#define TSB_PN_CR_PN0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,0)))
#define TSB_PN_CR_PN1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,1)))
#define TSB_PN_CR_PN2C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,2)))
#define TSB_PN_CR_PN3C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,3)))
#define TSB_PN_CR_PN4C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,4)))
#define TSB_PN_CR_PN5C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,5)))
#define TSB_PN_CR_PN6C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,6)))
#define TSB_PN_CR_PN7C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,7)))
#define TSB_PN_FR1_PN0F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,0)))
#define TSB_PN_FR1_PN1F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,1)))
#define TSB_PN_FR1_PN2F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,2)))
#define TSB_PN_FR1_PN3F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,3)))
#define TSB_PN_FR1_PN4F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,4)))
#define TSB_PN_FR1_PN5F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,5)))
#define TSB_PN_FR1_PN6F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,6)))
#define TSB_PN_FR1_PN7F1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,7)))
#define TSB_PN_FR2_PN4F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR2,4)))
#define TSB_PN_FR2_PN5F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR2,5)))
#define TSB_PN_FR2_PN7F2                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR2,7)))
#define TSB_PN_OD_PN0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,0)))
#define TSB_PN_OD_PN1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,1)))
#define TSB_PN_OD_PN2OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,2)))
#define TSB_PN_OD_PN3OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,3)))
#define TSB_PN_OD_PN4OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,4)))
#define TSB_PN_OD_PN5OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,5)))
#define TSB_PN_OD_PN6OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,6)))
#define TSB_PN_OD_PN7OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,7)))
#define TSB_PN_PUP_PN0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,0)))
#define TSB_PN_PUP_PN1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,1)))
#define TSB_PN_PUP_PN2UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,2)))
#define TSB_PN_PUP_PN3UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,3)))
#define TSB_PN_PUP_PN4UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,4)))
#define TSB_PN_PUP_PN5UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,5)))
#define TSB_PN_PUP_PN6UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,6)))
#define TSB_PN_PUP_PN7UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,7)))
#define TSB_PN_PDN_PN0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PDN,0)))
#define TSB_PN_PDN_PN1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PDN,1)))
#define TSB_PN_PDN_PN2DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PDN,2)))
#define TSB_PN_PDN_PN3DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PDN,3)))
#define TSB_PN_PDN_PN4DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PDN,4)))
#define TSB_PN_PDN_PN5DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PDN,5)))
#define TSB_PN_PDN_PN6DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PDN,6)))
#define TSB_PN_PDN_PN7DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PDN,7)))
#define TSB_PN_IE_PN0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,0)))
#define TSB_PN_IE_PN1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,1)))
#define TSB_PN_IE_PN2IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,2)))
#define TSB_PN_IE_PN3IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,3)))
#define TSB_PN_IE_PN4IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,4)))
#define TSB_PN_IE_PN5IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,5)))
#define TSB_PN_IE_PN6IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,6)))
#define TSB_PN_IE_PN7IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,7)))

/* General Purpose Input/Output Port (PP) */
#define TSB_PP_DATA_PP0                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->DATA,0)))
#define TSB_PP_DATA_PP1                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->DATA,1)))
#define TSB_PP_CR_PP0C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->CR,0)))
#define TSB_PP_CR_PP1C                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->CR,1)))
#define TSB_PP_OD_PP0OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->OD,0)))
#define TSB_PP_OD_PP1OD                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->OD,1)))
#define TSB_PP_PUP_PP0UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PUP,0)))
#define TSB_PP_PUP_PP1UP                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PUP,1)))
#define TSB_PP_PDN_PP0DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PDN,0)))
#define TSB_PP_PDN_PP1DN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PDN,1)))
#define TSB_PP_IE_PP0IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->IE,0)))
#define TSB_PP_IE_PP1IE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->IE,1)))


/* 16-bit Timer/Event Counter (TB) */
#define TSB_TB0_EN_TBEN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->EN,7)))
#define TSB_TB0_RUN_TBRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->RUN,0)))
#define TSB_TB0_RUN_TBPRUN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->RUN,2)))
#define TSB_TB0_CR_CSSEL                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,0)))
#define TSB_TB0_CR_TRGSEL               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,1)))
#define TSB_TB0_CR_I2TB                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,3)))
#define TSB_TB0_CR_TBSYNC               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,5)))
#define TSB_TB0_CR_TBWBF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,7)))
#define TSB_TB0_MOD_TBCLE               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->MOD,2)))
#define TSB_TB0_MOD_TBCP                (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB0->MOD,5)))
#define TSB_TB0_MOD_TBRSWR              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->MOD,6)))
#define TSB_TB0_FFCR_TBE0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,2)))
#define TSB_TB0_FFCR_TBE1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,3)))
#define TSB_TB0_FFCR_TBC0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,4)))
#define TSB_TB0_FFCR_TBC1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,5)))
#define TSB_TB0_IM_TBIM0                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,0)))
#define TSB_TB0_IM_TBIM1                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,1)))
#define TSB_TB0_IM_TBIMOF               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,2)))

#define TSB_TB1_EN_TBEN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->EN,7)))
#define TSB_TB1_RUN_TBRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->RUN,0)))
#define TSB_TB1_RUN_TBPRUN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->RUN,2)))
#define TSB_TB1_CR_CSSEL                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,0)))
#define TSB_TB1_CR_TRGSEL               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,1)))
#define TSB_TB1_CR_I2TB                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,3)))
#define TSB_TB1_CR_TBSYNC               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,5)))
#define TSB_TB1_CR_TBWBF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,7)))
#define TSB_TB1_MOD_TBCLE               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->MOD,2)))
#define TSB_TB1_MOD_TBCP                (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB1->MOD,5)))
#define TSB_TB1_MOD_TBRSWR              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->MOD,6)))
#define TSB_TB1_FFCR_TBE0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,2)))
#define TSB_TB1_FFCR_TBE1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,3)))
#define TSB_TB1_FFCR_TBC0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,4)))
#define TSB_TB1_FFCR_TBC1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,5)))
#define TSB_TB1_IM_TBIM0                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,0)))
#define TSB_TB1_IM_TBIM1                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,1)))
#define TSB_TB1_IM_TBIMOF               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,2)))

#define TSB_TB2_EN_TBEN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->EN,7)))
#define TSB_TB2_RUN_TBRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->RUN,0)))
#define TSB_TB2_RUN_TBPRUN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->RUN,2)))
#define TSB_TB2_CR_CSSEL                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,0)))
#define TSB_TB2_CR_TRGSEL               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,1)))
#define TSB_TB2_CR_I2TB                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,3)))
#define TSB_TB2_CR_TBSYNC               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,5)))
#define TSB_TB2_CR_TBWBF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,7)))
#define TSB_TB2_MOD_TBCLE               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->MOD,2)))
#define TSB_TB2_MOD_TBCP                (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB2->MOD,5)))
#define TSB_TB2_MOD_TBRSWR              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->MOD,6)))
#define TSB_TB2_FFCR_TBE0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,2)))
#define TSB_TB2_FFCR_TBE1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,3)))
#define TSB_TB2_FFCR_TBC0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,4)))
#define TSB_TB2_FFCR_TBC1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,5)))
#define TSB_TB2_IM_TBIM0                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,0)))
#define TSB_TB2_IM_TBIM1                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,1)))
#define TSB_TB2_IM_TBIMOF               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,2)))

#define TSB_TB3_EN_TBEN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->EN,7)))
#define TSB_TB3_RUN_TBRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->RUN,0)))
#define TSB_TB3_RUN_TBPRUN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->RUN,2)))
#define TSB_TB3_CR_CSSEL                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,0)))
#define TSB_TB3_CR_TRGSEL               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,1)))
#define TSB_TB3_CR_I2TB                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,3)))
#define TSB_TB3_CR_TBSYNC               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,5)))
#define TSB_TB3_CR_TBWBF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,7)))
#define TSB_TB3_MOD_TBCLE               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->MOD,2)))
#define TSB_TB3_MOD_TBCP                (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB3->MOD,5)))
#define TSB_TB3_MOD_TBRSWR              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->MOD,6)))
#define TSB_TB3_FFCR_TBE0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,2)))
#define TSB_TB3_FFCR_TBE1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,3)))
#define TSB_TB3_FFCR_TBC0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,4)))
#define TSB_TB3_FFCR_TBC1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,5)))
#define TSB_TB3_IM_TBIM0                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,0)))
#define TSB_TB3_IM_TBIM1                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,1)))
#define TSB_TB3_IM_TBIMOF               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,2)))

#define TSB_TB4_EN_TBEN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->EN,7)))
#define TSB_TB4_RUN_TBRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->RUN,0)))
#define TSB_TB4_RUN_TBPRUN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->RUN,2)))
#define TSB_TB4_CR_CSSEL                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,0)))
#define TSB_TB4_CR_TRGSEL               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,1)))
#define TSB_TB4_CR_I2TB                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,3)))
#define TSB_TB4_CR_TBSYNC               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,5)))
#define TSB_TB4_CR_TBWBF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,7)))
#define TSB_TB4_MOD_TBCLE               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->MOD,2)))
#define TSB_TB4_MOD_TBCP                (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB4->MOD,5)))
#define TSB_TB4_MOD_TBRSWR              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->MOD,6)))
#define TSB_TB4_FFCR_TBE0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,2)))
#define TSB_TB4_FFCR_TBE1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,3)))
#define TSB_TB4_FFCR_TBC0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,4)))
#define TSB_TB4_FFCR_TBC1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,5)))
#define TSB_TB4_IM_TBIM0                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,0)))
#define TSB_TB4_IM_TBIM1                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,1)))
#define TSB_TB4_IM_TBIMOF               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,2)))

#define TSB_TB5_EN_TBEN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->EN,7)))
#define TSB_TB5_RUN_TBRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->RUN,0)))
#define TSB_TB5_RUN_TBPRUN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->RUN,2)))
#define TSB_TB5_CR_CSSEL                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,0)))
#define TSB_TB5_CR_TRGSEL               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,1)))
#define TSB_TB5_CR_I2TB                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,3)))
#define TSB_TB5_CR_TBSYNC               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,5)))
#define TSB_TB5_CR_TBWBF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,7)))
#define TSB_TB5_MOD_TBCLE               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->MOD,2)))
#define TSB_TB5_MOD_TBCP                (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB5->MOD,5)))
#define TSB_TB5_MOD_TBRSWR              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->MOD,6)))
#define TSB_TB5_FFCR_TBE0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,2)))
#define TSB_TB5_FFCR_TBE1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,3)))
#define TSB_TB5_FFCR_TBC0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,4)))
#define TSB_TB5_FFCR_TBC1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,5)))
#define TSB_TB5_IM_TBIM0                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->IM,0)))
#define TSB_TB5_IM_TBIM1                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->IM,1)))
#define TSB_TB5_IM_TBIMOF               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->IM,2)))

#define TSB_TB6_EN_TBEN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->EN,7)))
#define TSB_TB6_RUN_TBRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->RUN,0)))
#define TSB_TB6_RUN_TBPRUN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->RUN,2)))
#define TSB_TB6_CR_CSSEL                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,0)))
#define TSB_TB6_CR_TRGSEL               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,1)))
#define TSB_TB6_CR_I2TB                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,3)))
#define TSB_TB6_CR_TBSYNC               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,5)))
#define TSB_TB6_CR_TBWBF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,7)))
#define TSB_TB6_MOD_TBCLE               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->MOD,2)))
#define TSB_TB6_MOD_TBCP                (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB6->MOD,5)))
#define TSB_TB6_MOD_TBRSWR              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->MOD,6)))
#define TSB_TB6_FFCR_TBE0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,2)))
#define TSB_TB6_FFCR_TBE1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,3)))
#define TSB_TB6_FFCR_TBC0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,4)))
#define TSB_TB6_FFCR_TBC1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,5)))
#define TSB_TB6_IM_TBIM0                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->IM,0)))
#define TSB_TB6_IM_TBIM1                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->IM,1)))
#define TSB_TB6_IM_TBIMOF               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->IM,2)))

#define TSB_TB7_EN_TBEN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->EN,7)))
#define TSB_TB7_RUN_TBRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->RUN,0)))
#define TSB_TB7_RUN_TBPRUN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->RUN,2)))
#define TSB_TB7_CR_CSSEL                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,0)))
#define TSB_TB7_CR_TRGSEL               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,1)))
#define TSB_TB7_CR_I2TB                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,3)))
#define TSB_TB7_CR_TBSYNC               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,5)))
#define TSB_TB7_CR_TBWBF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,7)))
#define TSB_TB7_MOD_TBCLE               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->MOD,2)))
#define TSB_TB7_MOD_TBCP                (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB7->MOD,5)))
#define TSB_TB7_MOD_TBRSWR              (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->MOD,6)))
#define TSB_TB7_FFCR_TBE0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,2)))
#define TSB_TB7_FFCR_TBE1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,3)))
#define TSB_TB7_FFCR_TBC0T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,4)))
#define TSB_TB7_FFCR_TBC1T1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,5)))
#define TSB_TB7_IM_TBIM0                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->IM,0)))
#define TSB_TB7_IM_TBIM1                (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->IM,1)))
#define TSB_TB7_IM_TBIMOF               (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->IM,2)))


/* Encoder Input Circuit (ENC) */

/* Serial Bus Interface (SBI0) */
#define TSB_SBI0_CR0_SBIEN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI0->CR0,7)))
#define TSB_SBI0_CR1_SWRMON              (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->CR1,0)))
#define TSB_SBI0_I2CAR_ALS               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI0->I2CAR,0)))
#define TSB_SBI0_SR_SEF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->SR,2)))
#define TSB_SBI0_SR_SIOF                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->SR,3)))
#define TSB_SBI0_SR_LRB                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->SR,0)))
#define TSB_SBI0_SR_ADO                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->SR,1)))
#define TSB_SBI0_SR_AAS                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->SR,2)))
#define TSB_SBI0_SR_AL                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->SR,3)))
#define TSB_SBI0_SR_PIN                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->SR,4)))
#define TSB_SBI0_SR_BB                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->SR,5)))
#define TSB_SBI0_SR_TRX                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->SR,6)))
#define TSB_SBI0_SR_MST                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI0->SR,7)))
#define TSB_SBI0_BR0_I2SBI               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI0->BR0,6)))

/* Serial Bus Interface (SBI1) */
#define TSB_SBI1_CR0_SBIEN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI1->CR0,7)))
#define TSB_SBI1_CR1_SWRMON              (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->CR1,0)))
#define TSB_SBI1_I2CAR_ALS               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI1->I2CAR,0)))
#define TSB_SBI1_SR_SEF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->SR,2)))
#define TSB_SBI1_SR_SIOF                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->SR,3)))
#define TSB_SBI1_SR_LRB                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->SR,0)))
#define TSB_SBI1_SR_ADO                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->SR,1)))
#define TSB_SBI1_SR_AAS                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->SR,2)))
#define TSB_SBI1_SR_AL                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->SR,3)))
#define TSB_SBI1_SR_PIN                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->SR,4)))
#define TSB_SBI1_SR_BB                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->SR,5)))
#define TSB_SBI1_SR_TRX                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->SR,6)))
#define TSB_SBI1_SR_MST                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI1->SR,7)))
#define TSB_SBI1_BR0_I2SBI               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI1->BR0,6)))

/* Serial Channel (SC) */                
#define TSB_SC0_EN_SIOE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->EN,0)))
#define TSB_SC0_MOD0_WU                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,4)))
#define TSB_SC0_MOD0_RXE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,5)))
#define TSB_SC0_MOD0_CTSE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,6)))
#define TSB_SC0_MOD0_TB8                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,7)))
#define TSB_SC0_BRCR_BRADDE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->BRCR,6)))
#define TSB_SC0_MOD1_TXE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD1,4)))
#define TSB_SC0_MOD1_I2SC                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD1,7)))
#define TSB_SC0_MOD2_WBUF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,2)))
#define TSB_SC0_MOD2_DRCHG               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,3)))
#define TSB_SC0_MOD2_SBLEN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,4)))
#define TSB_SC0_MOD2_TXRUN               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,5)))
#define TSB_SC0_MOD2_RBFLL               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,6)))
#define TSB_SC0_MOD2_TBEMP               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,7)))
#define TSB_SC0_RFC_RFIS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->RFC,6)))
#define TSB_SC0_RFC_RFCS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC0->RFC,7)))
#define TSB_SC0_TFC_TFIS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->TFC,6)))
#define TSB_SC0_TFC_TFCS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC0->TFC,7)))
#define TSB_SC0_RST_ROR                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->RST,7)))
#define TSB_SC0_TST_TUR                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->TST,7)))
#define TSB_SC0_FCNF_CNFG                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,0)))
#define TSB_SC0_FCNF_RXTXCNT             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,1)))
#define TSB_SC0_FCNF_RFIE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,2)))
#define TSB_SC0_FCNF_TFIE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,3)))
#define TSB_SC0_FCNF_RFST                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,4)))

#define TSB_SC1_EN_SIOE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->EN,0)))
#define TSB_SC1_MOD0_WU                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,4)))
#define TSB_SC1_MOD0_RXE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,5)))
#define TSB_SC1_MOD0_CTSE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,6)))
#define TSB_SC1_MOD0_TB8                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,7)))
#define TSB_SC1_BRCR_BRADDE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->BRCR,6)))
#define TSB_SC1_MOD1_TXE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD1,4)))
#define TSB_SC1_MOD1_I2SC                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD1,7)))
#define TSB_SC1_MOD2_WBUF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,2)))
#define TSB_SC1_MOD2_DRCHG               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,3)))
#define TSB_SC1_MOD2_SBLEN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,4)))
#define TSB_SC1_MOD2_TXRUN               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,5)))
#define TSB_SC1_MOD2_RBFLL               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,6)))
#define TSB_SC1_MOD2_TBEMP               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,7)))
#define TSB_SC1_RFC_RFIS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->RFC,6)))
#define TSB_SC1_RFC_RFCS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC1->RFC,7)))
#define TSB_SC1_TFC_TFIS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->TFC,6)))
#define TSB_SC1_TFC_TFCS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC1->TFC,7)))
#define TSB_SC1_RST_ROR                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->RST,7)))
#define TSB_SC1_TST_TUR                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->TST,7)))
#define TSB_SC1_FCNF_CNFG                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,0)))
#define TSB_SC1_FCNF_RXTXCNT             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,1)))
#define TSB_SC1_FCNF_RFIE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,2)))
#define TSB_SC1_FCNF_TFIE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,3)))
#define TSB_SC1_FCNF_RFST                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,4)))
     
#define TSB_SC2_EN_SIOE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->EN,0)))
#define TSB_SC2_MOD0_WU                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,4)))
#define TSB_SC2_MOD0_RXE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,5)))
#define TSB_SC2_MOD0_CTSE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,6)))
#define TSB_SC2_MOD0_TB8                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,7)))
#define TSB_SC2_BRCR_BRADDE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->BRCR,6)))
#define TSB_SC2_MOD1_TXE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD1,4)))
#define TSB_SC2_MOD1_I2SC                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD1,7)))
#define TSB_SC2_MOD2_WBUF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,2)))
#define TSB_SC2_MOD2_DRCHG               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,3)))
#define TSB_SC2_MOD2_SBLEN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,4)))
#define TSB_SC2_MOD2_TXRUN               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,5)))
#define TSB_SC2_MOD2_RBFLL               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,6)))
#define TSB_SC2_MOD2_TBEMP               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,7)))
#define TSB_SC2_RFC_RFIS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->RFC,6)))
#define TSB_SC2_RFC_RFCS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC2->RFC,7)))
#define TSB_SC2_TFC_TFIS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->TFC,6)))
#define TSB_SC2_TFC_TFCS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC2->TFC,7)))
#define TSB_SC2_RST_ROR                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->RST,7)))
#define TSB_SC2_TST_TUR                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->TST,7)))
#define TSB_SC2_FCNF_CNFG                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,0)))
#define TSB_SC2_FCNF_RXTXCNT             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,1)))
#define TSB_SC2_FCNF_RFIE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,2)))
#define TSB_SC2_FCNF_TFIE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,3)))
#define TSB_SC2_FCNF_RFST                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,4)))

#define TSB_SC3_EN_SIOE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->EN,0)))
#define TSB_SC3_MOD0_WU                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,4)))
#define TSB_SC3_MOD0_RXE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,5)))
#define TSB_SC3_MOD0_CTSE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,6)))
#define TSB_SC3_MOD0_TB8                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,7)))
#define TSB_SC3_BRCR_BRADDE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->BRCR,6)))
#define TSB_SC3_MOD1_TXE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD1,4)))
#define TSB_SC3_MOD1_I2SC                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD1,7)))
#define TSB_SC3_MOD2_WBUF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,2)))
#define TSB_SC3_MOD2_DRCHG               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,3)))
#define TSB_SC3_MOD2_SBLEN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,4)))
#define TSB_SC3_MOD2_TXRUN               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,5)))
#define TSB_SC3_MOD2_RBFLL               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,6)))
#define TSB_SC3_MOD2_TBEMP               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,7)))
#define TSB_SC3_RFC_RFIS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->RFC,6)))
#define TSB_SC3_RFC_RFCS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC3->RFC,7)))
#define TSB_SC3_TFC_TFIS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->TFC,6)))
#define TSB_SC3_TFC_TFCS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC3->TFC,7)))
#define TSB_SC3_RST_ROR                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->RST,7)))
#define TSB_SC3_TST_TUR                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->TST,7)))
#define TSB_SC3_FCNF_CNFG                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,0)))
#define TSB_SC3_FCNF_RXTXCNT             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,1)))
#define TSB_SC3_FCNF_RFIE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,2)))
#define TSB_SC3_FCNF_TFIE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,3)))
#define TSB_SC3_FCNF_RFST                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,4)))

#define TSB_SC4_EN_SIOE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->EN,0)))
#define TSB_SC4_MOD0_WU                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,4)))
#define TSB_SC4_MOD0_RXE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,5)))
#define TSB_SC4_MOD0_CTSE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,6)))
#define TSB_SC4_MOD0_TB8                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,7)))
#define TSB_SC4_BRCR_BRADDE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->BRCR,6)))
#define TSB_SC4_MOD1_TXE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD1,4)))
#define TSB_SC4_MOD1_I2SC                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD1,7)))
#define TSB_SC4_MOD2_WBUF                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,2)))
#define TSB_SC4_MOD2_DRCHG               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,3)))
#define TSB_SC4_MOD2_SBLEN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,4)))
#define TSB_SC4_MOD2_TXRUN               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,5)))
#define TSB_SC4_MOD2_RBFLL               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,6)))
#define TSB_SC4_MOD2_TBEMP               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,7)))
#define TSB_SC4_RFC_RFIS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->RFC,6)))
#define TSB_SC4_RFC_RFCS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC4->RFC,7)))
#define TSB_SC4_TFC_TFIS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->TFC,6)))
#define TSB_SC4_TFC_TFCS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC4->TFC,7)))
#define TSB_SC4_RST_ROR                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->RST,7)))
#define TSB_SC4_TST_TUR                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->TST,7)))
#define TSB_SC4_FCNF_CNFG                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,0)))
#define TSB_SC4_FCNF_RXTXCNT             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,1)))
#define TSB_SC4_FCNF_RFIE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,2)))
#define TSB_SC4_FCNF_TFIE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,3)))
#define TSB_SC4_FCNF_RFST                (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,4)))

/* Analog-to-Digital Converter (AD) */
#define TSB_AD_MOD0_ADSS                 (*((__O  uint32_t *)BITBAND_PERI(&TSB_AD->MOD0,0)))
#define TSB_AD_MOD1_ADAS                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD1,0)))
#define TSB_AD_MOD1_ADEN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD1,7)))
#define TSB_AD_MOD2_ADBFN                (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->MOD2,0)))
#define TSB_AD_MOD2_ADSFN                (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->MOD2,1)))
#define TSB_AD_CMPCR0_ADBIG0             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->CMPCR0,4)))
#define TSB_AD_CMPCR0_CMP0EN             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->CMPCR0,7)))
#define TSB_AD_CMPCR1_ADBIG1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->CMPCR1,4)))
#define TSB_AD_CMPCR1_CMP1EN             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->CMPCR1,7)))
#define TSB_AD_REG0_ADR0RF               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG0,0)))
#define TSB_AD_REG0_OVR0                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG0,1)))
#define TSB_AD_REG1_ADR1RF               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG1,0)))
#define TSB_AD_REG1_OVR1                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG1,1)))
#define TSB_AD_REG2_ADR2RF               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG2,0)))
#define TSB_AD_REG2_OVR2                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG2,1)))
#define TSB_AD_REG3_ADR3RF               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG3,0)))
#define TSB_AD_REG3_OVR3                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG3,1)))
#define TSB_AD_REG4_ADR4RF               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG4,0)))
#define TSB_AD_REG4_OVR4                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG4,1)))
#define TSB_AD_REG5_ADR5RF               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG5,0)))
#define TSB_AD_REG5_OVR5                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG5,1)))
#define TSB_AD_REG6_ADR6RF               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG6,0)))
#define TSB_AD_REG6_OVR6                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG6,1)))
#define TSB_AD_REG7_ADR7RF               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG7,0)))
#define TSB_AD_REG7_OVR7                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG7,1)))
#define TSB_AD_REG8_ADR8RF               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG8,0)))
#define TSB_AD_REG8_OVR8                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG8,1)))
#define TSB_AD_REG9_ADR9RF               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG9,0)))
#define TSB_AD_REG9_OVR9                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG9,1)))
#define TSB_AD_REG10_ADR10RF             (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG10,0)))
#define TSB_AD_REG10_OVR10               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG10,1)))
#define TSB_AD_REG11_ADR11RF             (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG11,0)))
#define TSB_AD_REG11_OVR11               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->REG11,1)))
#define TSB_AD_PSEL0_PENS0               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSEL0,7)))
#define TSB_AD_PSEL1_PENS1               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSEL1,7)))
#define TSB_AD_PSEL2_PENS2               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSEL2,7)))
#define TSB_AD_PSEL3_PENS3               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSEL3,7)))
#define TSB_AD_PSET00_ENSP00             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET00,7)))
#define TSB_AD_PSET01_ENSP01             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET01,7)))
#define TSB_AD_PSET02_ENSP02             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET02,7)))
#define TSB_AD_PSET03_ENSP03             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET03,7)))
#define TSB_AD_PSET10_ENSP10             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET10,7)))
#define TSB_AD_PSET11_ENSP11             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET11,7)))
#define TSB_AD_PSET12_ENSP12             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET12,7)))
#define TSB_AD_PSET13_ENSP13             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET13,7)))
#define TSB_AD_PSET20_ENSP20             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET20,7)))
#define TSB_AD_PSET21_ENSP21             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET21,7)))
#define TSB_AD_PSET22_ENSP22             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET22,7)))
#define TSB_AD_PSET23_ENSP23             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET23,7)))
#define TSB_AD_PSET30_ENSP30             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET30,7)))
#define TSB_AD_PSET31_ENSP31             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET31,7)))
#define TSB_AD_PSET32_ENSP32             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET32,7)))
#define TSB_AD_PSET33_ENSP33             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET33,7)))
#define TSB_AD_PSET40_ENSP40             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET40,7)))
#define TSB_AD_PSET41_ENSP41             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET41,7)))
#define TSB_AD_PSET42_ENSP42             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET42,7)))
#define TSB_AD_PSET43_ENSP43             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET43,7)))
#define TSB_AD_PSET50_ENSP50             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET50,7)))
#define TSB_AD_PSET51_ENSP51             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET51,7)))
#define TSB_AD_PSET52_ENSP52             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET52,7)))
#define TSB_AD_PSET53_ENSP53             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->PSET53,7)))
#define TSB_AD_TSET0_ENST0               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET0,7)))
#define TSB_AD_TSET1_ENST1               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET1,7)))
#define TSB_AD_TSET2_ENST2               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET2,7)))
#define TSB_AD_TSET3_ENST3               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET3,7)))
#define TSB_AD_TSET4_ENST4               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET4,7)))
#define TSB_AD_TSET5_ENST5               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET5,7)))
#define TSB_AD_TSET6_ENST6               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET6,7)))
#define TSB_AD_TSET7_ENST7               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET7,7)))
#define TSB_AD_TSET8_ENST8               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET8,7)))
#define TSB_AD_TSET9_ENST9               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET9,7)))
#define TSB_AD_TSET10_ENST10             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET10,7)))
#define TSB_AD_TSET11_ENST11             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->TSET11,7)))
#define TSB_AD_SSET0_ENSS0               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET0,7)))
#define TSB_AD_SSET1_ENSS1               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET1,7)))
#define TSB_AD_SSET2_ENSS2               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET2,7)))
#define TSB_AD_SSET3_ENSS3               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET3,7)))
#define TSB_AD_SSET4_ENSS4               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET4,7)))
#define TSB_AD_SSET5_ENSS5               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET5,7)))
#define TSB_AD_SSET6_ENSS6               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET6,7)))
#define TSB_AD_SSET7_ENSS7               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET7,7)))
#define TSB_AD_SSET8_ENSS8               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET8,7)))
#define TSB_AD_SSET9_ENSS9               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET9,7)))
#define TSB_AD_SSET10_ENSS10             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET10,7)))
#define TSB_AD_SSET11_ENSS11             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->SSET11,7)))
#define TSB_AD_ASET0_ENSA0               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET0,7)))
#define TSB_AD_ASET1_ENSA1               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET1,7)))
#define TSB_AD_ASET2_ENSA2               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET2,7)))
#define TSB_AD_ASET3_ENSA3               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET3,7)))
#define TSB_AD_ASET4_ENSA4               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET4,7)))
#define TSB_AD_ASET5_ENSA5               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET5,7)))
#define TSB_AD_ASET6_ENSA6               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET6,7)))
#define TSB_AD_ASET7_ENSA7               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET7,7)))
#define TSB_AD_ASET8_ENSA8               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET8,7)))
#define TSB_AD_ASET9_ENSA9               (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET9,7)))
#define TSB_AD_ASET10_ENSA10             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET10,7)))
#define TSB_AD_ASET11_ENSA11             (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->ASET11,7)))
#define TSB_AD_MOD3_RCUT                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD3,8)))


/* Watchdog Timer (WD) */
#define TSB_WD_MOD_RESCR                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD->MOD,1)))
#define TSB_WD_MOD_I2WDT                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD->MOD,2)))
#define TSB_WD_MOD_WDTE                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD->MOD,7)))

/* Real Time Clock (RTC) */
#define TSB_RTC_MONTHR_MO0               (*((__IO uint32_t *)BITBAND_PERI(&TSB_RTC->MONTHR,0)))
       
/* Clock Generator (CG) */               
#define TSB_CG_SYSCR_FCSTOP              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->SYSCR,20)))
#define TSB_CG_OSCCR_WUEON               (*((__O  uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,0)))
#define TSB_CG_OSCCR_WUEF                (*((__I  uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,1)))
#define TSB_CG_OSCCR_PLLON               (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,2)))
#define TSB_CG_OSCCR_WUPSEL1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,3)))
#define TSB_CG_OSCCR_XEN1                (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,8)))
#define TSB_CG_OSCCR_XTEN                (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,9)))
#define TSB_CG_OSCCR_XEN2                (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,16)))
#define TSB_CG_OSCCR_OSCSEL              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,17)))
#define TSB_CG_OSCCR_HOSCON              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,18)))
#define TSB_CG_OSCCR_WUPSEL2             (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,19)))
#define TSB_CG_STBYCR_RXEN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->STBYCR,8)))
#define TSB_CG_STBYCR_RXTEN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->STBYCR,9)))
#define TSB_CG_STBYCR_DRVE               (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->STBYCR,16)))
#define TSB_CG_PLLSEL_PLLSEL             (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->PLLSEL,0)))
#define TSB_CG_CKSEL_SYSCKFLG            (*((__I  uint32_t *)BITBAND_PERI(&TSB_CG->CKSEL,0)))
#define TSB_CG_CKSEL_SYSCK               (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CKSEL,1)))
#define TSB_CG_RSTFLG_PONRSTF            (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,0)))
#define TSB_CG_RSTFLG_PINRSTF            (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,1)))
#define TSB_CG_RSTFLG_WDTRSTF            (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,2)))
#define TSB_CG_RSTFLG_DBGRSTF            (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,4)))
#define TSB_CG_RSTFLG_OFDRSTF            (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,5)))
#define TSB_CG_IMCGA_INT0EN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGA,0)))
#define TSB_CG_IMCGA_INT1EN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGA,8)))
#define TSB_CG_IMCGA_INT2EN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGA,16)))
#define TSB_CG_IMCGA_INT3EN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGA,24)))
#define TSB_CG_IMCGB_INT4EN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGB,0)))
#define TSB_CG_IMCGB_INT5EN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGB,8)))
#define TSB_CG_IMCGB_INT6EN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGB,16)))
#define TSB_CG_IMCGB_INT7EN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGB,24)))
#define TSB_CG_IMCGC_INT8EN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGC,0)))
#define TSB_CG_IMCGC_INT9EN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGC,8)))
#define TSB_CG_IMCGC_INTAEN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGC,16)))
#define TSB_CG_IMCGC_INTBEN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGC,24)))
#define TSB_CG_IMCGD_INTCEN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGD,0)))
#define TSB_CG_IMCGD_INTDEN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGD,8)))
#define TSB_CG_IMCGD_INTEEN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGD,16)))
#define TSB_CG_IMCGD_INTFEN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGD,24)))
#define TSB_CG_IMCGE_INTRTCEN            (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGE,0)))
#define TSB_CG_IMCGE_INTRMCRXEN          (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGE,8)))

/* Remote Control Signal Preprocessor (RMC) */
#define TSB_RMC_EN_RMCEN                (*((__IO uint32_t *)BITBAND_PERI(&TSB_RMC->EN,0)))
#define TSB_RMC_EN_I2RMC                (*((__IO uint32_t *)BITBAND_PERI(&TSB_RMC->EN,1)))
#define TSB_RMC_REN_RMCREN              (*((__IO uint32_t *)BITBAND_PERI(&TSB_RMC->REN,0)))
#define TSB_RMC_RCR2_RMCPHM             (*((__IO uint32_t *)BITBAND_PERI(&TSB_RMC->RCR2,24)))
#define TSB_RMC_RCR2_RMCLD              (*((__IO uint32_t *)BITBAND_PERI(&TSB_RMC->RCR2,25)))
#define TSB_RMC_RCR2_RMCEDIEN           (*((__IO uint32_t *)BITBAND_PERI(&TSB_RMC->RCR2,30)))
#define TSB_RMC_RCR2_RMCLIEN            (*((__IO uint32_t *)BITBAND_PERI(&TSB_RMC->RCR2,31)))
#define TSB_RMC_RCR4_RMCPO              (*((__IO uint32_t *)BITBAND_PERI(&TSB_RMC->RCR4,7)))
#define TSB_RMC_RSTAT_RMCRLDR           (*((__I  uint32_t *)BITBAND_PERI(&TSB_RMC->RSTAT,7)))
#define TSB_RMC_RSTAT_RMCEDIF           (*((__I  uint32_t *)BITBAND_PERI(&TSB_RMC->RSTAT,12)))
#define TSB_RMC_RSTAT_RMCDMAXIF         (*((__I  uint32_t *)BITBAND_PERI(&TSB_RMC->RSTAT,13)))
#define TSB_RMC_RSTAT_RMCLOIF           (*((__I  uint32_t *)BITBAND_PERI(&TSB_RMC->RSTAT,14)))
#define TSB_RMC_RSTAT_RMCRLIF           (*((__I  uint32_t *)BITBAND_PERI(&TSB_RMC->RSTAT,15)))
#define TSB_RMC_FSSEL_RMCCLK            (*((__IO uint32_t *)BITBAND_PERI(&TSB_RMC->FSSEL,0)))

/* Ocsillation Frequency Detector (OFD) */
#define TSB_OFD_RST_OFDRSTEN             (*((__IO uint32_t *)BITBAND_PERI(&TSB_OFD->RST,0)))
#define TSB_OFD_STAT_FRQERR              (*((__I  uint32_t *)BITBAND_PERI(&TSB_OFD->STAT,0)))
#define TSB_OFD_STAT_OFDBUSY             (*((__I  uint32_t *)BITBAND_PERI(&TSB_OFD->STAT,1)))

/* Voltage Detection Circuit (VLTD) */
#define TSB_VD_CR_VDEN                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_VD->CR,0)))
#define TSB_VD_CR_VDLVL0                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_VD->CR,1)))
#define TSB_VD_CR_VDLVL1                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_VD->CR,2)))
#define TSB_VD_SR_VDSR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_VD->SR,0)))

/* 16-bit Multi-purpose Timers (MTPs) */
#define TSB_MTPD0_MDEN_PWMEN             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDEN,0)))
#define TSB_MTPD0_PORTMD_PORTMD          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->PORTMD,0)))
#define TSB_MTPD0_MDCR_PWMMD             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDCR,0)))
#define TSB_MTPD0_MDCR_PINT              (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDCR,3)))
#define TSB_MTPD0_MDCR_DTYMD             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDCR,4)))
#define TSB_MTPD0_MDCR_SYNTMD            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDCR,5)))
#define TSB_MTPD0_MDCR_PWMCK             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDCR,6)))
#define TSB_MTPD0_CNTSTA_UPDWN           (*((__I  uint32_t *)BITBAND_PERI(&TSB_MTPD0->CNTSTA,0)))
#define TSB_MTPD0_MDOUT_UPWM             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDOUT,8)))
#define TSB_MTPD0_MDOUT_VPWM             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDOUT,9)))
#define TSB_MTPD0_MDOUT_WPWM             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDOUT,10)))
#define TSB_MTPD0_MDPOT_POLL             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDPOT,2)))
#define TSB_MTPD0_MDPOT_POLH             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->MDPOT,3)))
#define TSB_MTPD0_EMGCR_EMGEN            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->EMGCR,0)))
#define TSB_MTPD0_EMGCR_EMGRS            (*((__O  uint32_t *)BITBAND_PERI(&TSB_MTPD0->EMGCR,1)))
#define TSB_MTPD0_EMGCR_INHEN            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->EMGCR,5)))
#define TSB_MTPD0_EMGST_EMGST            (*((__I  uint32_t *)BITBAND_PERI(&TSB_MTPD0->EMGST,0)))
#define TSB_MTPD0_EMGST_EMGI             (*((__I  uint32_t *)BITBAND_PERI(&TSB_MTPD0->EMGST,1)))
#define TSB_MTPD0_TRGCR_TRG0BE           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->TRGCR,3)))
#define TSB_MTPD0_TRGCR_TRG1BE           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->TRGCR,7)))
#define TSB_MTPD0_TRGMD_EMGTGE           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD0->TRGMD,0)))

#define TSB_MTPD1_MDEN_PWMEN             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDEN,0)))
#define TSB_MTPD1_PORTMD_PORTMD          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->PORTMD,0)))
#define TSB_MTPD1_MDCR_PWMMD             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDCR,0)))
#define TSB_MTPD1_MDCR_PINT              (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDCR,3)))
#define TSB_MTPD1_MDCR_DTYMD             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDCR,4)))
#define TSB_MTPD1_MDCR_SYNTMD            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDCR,5)))
#define TSB_MTPD1_MDCR_PWMCK             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDCR,6)))
#define TSB_MTPD1_CNTSTA_UPDWN           (*((__I  uint32_t *)BITBAND_PERI(&TSB_MTPD1->CNTSTA,0)))
#define TSB_MTPD1_MDOUT_UPWM             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDOUT,8)))
#define TSB_MTPD1_MDOUT_VPWM             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDOUT,9)))
#define TSB_MTPD1_MDOUT_WPWM             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDOUT,10)))
#define TSB_MTPD1_MDPOT_POLL             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDPOT,2)))
#define TSB_MTPD1_MDPOT_POLH             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->MDPOT,3)))
#define TSB_MTPD1_EMGCR_EMGEN            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->EMGCR,0)))
#define TSB_MTPD1_EMGCR_EMGRS            (*((__O  uint32_t *)BITBAND_PERI(&TSB_MTPD1->EMGCR,1)))
#define TSB_MTPD1_EMGCR_INHEN            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->EMGCR,5)))
#define TSB_MTPD1_EMGST_EMGST            (*((__I  uint32_t *)BITBAND_PERI(&TSB_MTPD1->EMGST,0)))
#define TSB_MTPD1_EMGST_EMGI             (*((__I  uint32_t *)BITBAND_PERI(&TSB_MTPD1->EMGST,1)))
#define TSB_MTPD1_TRGCR_TRG0BE           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->TRGCR,3)))
#define TSB_MTPD1_TRGCR_TRG1BE           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->TRGCR,7)))
#define TSB_MTPD1_TRGMD_EMGTGE           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MTPD1->TRGMD,0)))

#define TSB_MT0_EN_MTMODE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->EN,0)))
#define TSB_MT0_EN_MTHALT                (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->EN,6)))
#define TSB_MT0_EN_MTEN                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->EN,7)))
#define TSB_MT0_RUN_MTRUN                (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->RUN,0)))
#define TSB_MT0_RUN_MTPRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->RUN,2)))
#define TSB_MT0_TBCR_MTTBCSSEL           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBCR,0)))
#define TSB_MT0_TBCR_MTTBTRGSEL          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBCR,1)))
#define TSB_MT0_TBCR_MTI2TB              (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBCR,3)))
#define TSB_MT0_TBCR_MTTBWBF             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBCR,7)))
#define TSB_MT0_TBMOD_MTTBCLE            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBMOD,2)))
#define TSB_MT0_TBMOD_MTTBCP             (*((__O  uint32_t *)BITBAND_PERI(&TSB_MT0->TBMOD,5)))
#define TSB_MT0_TBMOD_MTTBRSWR           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBMOD,6)))
#define TSB_MT0_TBFFCR_MTTBE0T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBFFCR,2)))
#define TSB_MT0_TBFFCR_MTTBE1T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBFFCR,3)))
#define TSB_MT0_TBFFCR_MTTBC0T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBFFCR,4)))
#define TSB_MT0_TBFFCR_MTTBC1T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBFFCR,5)))
#define TSB_MT0_TBIM_MTTBIM0             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBIM,0)))
#define TSB_MT0_TBIM_MTTBIM1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBIM,1)))
#define TSB_MT0_TBIM_MTTBIMOF            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->TBIM,2)))
#define TSB_MT0_IGCR_IGSNGL              (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->IGCR,6)))
#define TSB_MT0_IGCR_IGIDIS              (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT0->IGCR,10)))
#define TSB_MT0_IGRESTA_IGRESTA          (*((__O  uint32_t *)BITBAND_PERI(&TSB_MT0->IGRESTA,0)))
#define TSB_MT0_IGST_IGST                (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT0->IGST,0)))
#define TSB_MT0_IGICR_IGTRGSEL           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->IGICR,6)))
#define TSB_MT0_IGICR_IGTRGM             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->IGICR,7)))
#define TSB_MT0_IGOCR_IGOEN0             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->IGOCR,0)))
#define TSB_MT0_IGOCR_IGOEN1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->IGOCR,1)))
#define TSB_MT0_IGOCR_IGPOL0             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->IGOCR,4)))
#define TSB_MT0_IGOCR_IGPOL1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->IGOCR,5)))
#define TSB_MT0_IGEMGCR_IGEMGEN          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->IGEMGCR,0)))
#define TSB_MT0_IGEMGCR_IGEMGOC          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT0->IGEMGCR,1)))
#define TSB_MT0_IGEMGCR_IGEMGRS          (*((__O  uint32_t *)BITBAND_PERI(&TSB_MT0->IGEMGCR,2)))
#define TSB_MT0_IGEMGST_IGEMGST          (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT0->IGEMGST,0)))
#define TSB_MT0_IGEMGST_IGEMGIN          (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT0->IGEMGST,1)))

#define TSB_MT1_EN_MTMODE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->EN,0)))
#define TSB_MT1_EN_MTHALT                (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->EN,6)))
#define TSB_MT1_EN_MTEN                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->EN,7)))
#define TSB_MT1_RUN_MTRUN                (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->RUN,0)))
#define TSB_MT1_RUN_MTPRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->RUN,2)))
#define TSB_MT1_TBCR_MTTBCSSEL           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBCR,0)))
#define TSB_MT1_TBCR_MTTBTRGSEL          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBCR,1)))
#define TSB_MT1_TBCR_MTI2TB              (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBCR,3)))
#define TSB_MT1_TBCR_MTTBWBF             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBCR,7)))
#define TSB_MT1_TBMOD_MTTBCLE            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBMOD,2)))
#define TSB_MT1_TBMOD_MTTBCP             (*((__O  uint32_t *)BITBAND_PERI(&TSB_MT1->TBMOD,5)))
#define TSB_MT1_TBMOD_MTTBRSWR           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBMOD,6)))
#define TSB_MT1_TBFFCR_MTTBE0T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBFFCR,2)))
#define TSB_MT1_TBFFCR_MTTBE1T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBFFCR,3)))
#define TSB_MT1_TBFFCR_MTTBC0T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBFFCR,4)))
#define TSB_MT1_TBFFCR_MTTBC1T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBFFCR,5)))
#define TSB_MT1_TBIM_MTTBIM0             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBIM,0)))
#define TSB_MT1_TBIM_MTTBIM1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBIM,1)))
#define TSB_MT1_TBIM_MTTBIMOF            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->TBIM,2)))
#define TSB_MT1_IGCR_IGSNGL              (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->IGCR,6)))
#define TSB_MT1_IGCR_IGIDIS              (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT1->IGCR,10)))
#define TSB_MT1_IGRESTA_IGRESTA          (*((__O  uint32_t *)BITBAND_PERI(&TSB_MT1->IGRESTA,0)))
#define TSB_MT1_IGST_IGST                (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT1->IGST,0)))
#define TSB_MT1_IGICR_IGTRGSEL           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->IGICR,6)))
#define TSB_MT1_IGICR_IGTRGM             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->IGICR,7)))
#define TSB_MT1_IGOCR_IGOEN0             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->IGOCR,0)))
#define TSB_MT1_IGOCR_IGOEN1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->IGOCR,1)))
#define TSB_MT1_IGOCR_IGPOL0             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->IGOCR,4)))
#define TSB_MT1_IGOCR_IGPOL1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->IGOCR,5)))
#define TSB_MT1_IGEMGCR_IGEMGEN          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->IGEMGCR,0)))
#define TSB_MT1_IGEMGCR_IGEMGOC          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT1->IGEMGCR,1)))
#define TSB_MT1_IGEMGCR_IGEMGRS          (*((__O  uint32_t *)BITBAND_PERI(&TSB_MT1->IGEMGCR,2)))
#define TSB_MT1_IGEMGST_IGEMGST          (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT1->IGEMGST,0)))
#define TSB_MT1_IGEMGST_IGEMGIN          (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT1->IGEMGST,1)))

#define TSB_MT2_EN_MTMODE                (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->EN,0)))
#define TSB_MT2_EN_MTHALT                (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->EN,6)))
#define TSB_MT2_EN_MTEN                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->EN,7)))
#define TSB_MT2_RUN_MTRUN                (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->RUN,0)))
#define TSB_MT2_RUN_MTPRUN               (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->RUN,2)))
#define TSB_MT2_TBCR_MTTBCSSEL           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBCR,0)))
#define TSB_MT2_TBCR_MTTBTRGSEL          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBCR,1)))
#define TSB_MT2_TBCR_MTI2TB              (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBCR,3)))
#define TSB_MT2_TBCR_MTTBWBF             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBCR,7)))
#define TSB_MT2_TBMOD_MTTBCLE            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBMOD,2)))
#define TSB_MT2_TBMOD_MTTBCP             (*((__O  uint32_t *)BITBAND_PERI(&TSB_MT2->TBMOD,5)))
#define TSB_MT2_TBMOD_MTTBRSWR           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBMOD,6)))
#define TSB_MT2_TBFFCR_MTTBE0T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBFFCR,2)))
#define TSB_MT2_TBFFCR_MTTBE1T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBFFCR,3)))
#define TSB_MT2_TBFFCR_MTTBC0T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBFFCR,4)))
#define TSB_MT2_TBFFCR_MTTBC1T1          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBFFCR,5)))
#define TSB_MT2_TBIM_MTTBIM0             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBIM,0)))
#define TSB_MT2_TBIM_MTTBIM1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBIM,1)))
#define TSB_MT2_TBIM_MTTBIMOF            (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->TBIM,2)))
#define TSB_MT2_IGCR_IGSNGL              (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->IGCR,6)))
#define TSB_MT2_IGCR_IGIDIS              (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT2->IGCR,10)))
#define TSB_MT2_IGRESTA_IGRESTA          (*((__O  uint32_t *)BITBAND_PERI(&TSB_MT2->IGRESTA,0)))
#define TSB_MT2_IGST_IGST                (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT2->IGST,0)))
#define TSB_MT2_IGICR_IGTRGSEL           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->IGICR,6)))
#define TSB_MT2_IGICR_IGTRGM             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->IGICR,7)))
#define TSB_MT2_IGOCR_IGOEN0             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->IGOCR,0)))
#define TSB_MT2_IGOCR_IGOEN1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->IGOCR,1)))
#define TSB_MT2_IGOCR_IGPOL0             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->IGOCR,4)))
#define TSB_MT2_IGOCR_IGPOL1             (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->IGOCR,5)))
#define TSB_MT2_IGEMGCR_IGEMGEN          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->IGEMGCR,0)))
#define TSB_MT2_IGEMGCR_IGEMGOC          (*((__IO uint32_t *)BITBAND_PERI(&TSB_MT2->IGEMGCR,1)))
#define TSB_MT2_IGEMGCR_IGEMGRS          (*((__O  uint32_t *)BITBAND_PERI(&TSB_MT2->IGEMGCR,2)))
#define TSB_MT2_IGEMGST_IGEMGST          (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT2->IGEMGST,0)))
#define TSB_MT2_IGEMGST_IGEMGIN          (*((__I  uint32_t *)BITBAND_PERI(&TSB_MT2->IGEMGST,1)))


/* DMA Controller (DMAC) */
#define TSB_DMAC_INTSTATUS_INTSTATUS0      (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->INTSTATUS,0)))
#define TSB_DMAC_INTSTATUS_INTSTATUS1      (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->INTSTATUS,1)))
#define TSB_DMAC_INTTCSTATUS_INTTCSTATUS0  (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->INTTCSTATUS,0)))
#define TSB_DMAC_INTTCSTATUS_INTTCSTATUS1  (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->INTTCSTATUS,1)))
#define TSB_DMAC_INTERRORSTATUS_INTERRSTATUS0  (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->INTERRORSTATUS,0)))
#define TSB_DMAC_INTERRORSTATUS_INTERRSTATUS1  (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->INTERRORSTATUS,1)))
#define TSB_DMAC_RAWINTTCSTATUS_RAWINTTCS0 (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->RAWINTTCSTATUS,0)))
#define TSB_DMAC_RAWINTTCSTATUS_RAWINTTCS1 (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->RAWINTTCSTATUS,1)))
#define TSB_DMAC_RAWINTERRORSTATUS_RAWINTERRS0 (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->RAWINTERRORSTATUS,0)))
#define TSB_DMAC_RAWINTERRORSTATUS_RAWINTERRS1 (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->RAWINTERRORSTATUS,1)))
#define TSB_DMAC_ENBLDCHNS_ENABLEDCH0      (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->ENBLDCHNS,0)))
#define TSB_DMAC_ENBLDCHNS_ENABLEDCH1      (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->ENBLDCHNS,1)))
#define TSB_DMAC_SOFTBREQ_SOFTBREQ0        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTBREQ,0)))
#define TSB_DMAC_SOFTBREQ_SOFTBREQ1        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTBREQ,1)))
#define TSB_DMAC_SOFTBREQ_SOFTBREQ2        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTBREQ,2)))
#define TSB_DMAC_SOFTBREQ_SOFTBREQ3        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTBREQ,3)))
#define TSB_DMAC_SOFTBREQ_SOFTBREQ4        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTBREQ,4)))
#define TSB_DMAC_SOFTBREQ_SOFTBREQ5        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTBREQ,5)))
#define TSB_DMAC_SOFTBREQ_SOFTBREQ6        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTBREQ,6)))
#define TSB_DMAC_SOFTBREQ_SOFTBREQ7        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTBREQ,7)))
#define TSB_DMAC_SOFTBREQ_SOFTBREQ8        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTBREQ,8)))
#define TSB_DMAC_SOFTSREQ_SOFTSREQ6        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTSREQ,6)))
#define TSB_DMAC_SOFTSREQ_SOFTSREQ8        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->SOFTSREQ,8)))
#define TSB_DMAC_CONFIGURATION_E           (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->CONFIGURATION,0)))
#define TSB_DMAC_CONFIGURATION_M           (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->CONFIGURATION,1)))
#define TSB_DMAC_C0CONTROL_SI              (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C0CONTROL,26)))
#define TSB_DMAC_C0CONTROL_DI              (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C0CONTROL,27)))
#define TSB_DMAC_C0CONTROL_I               (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C0CONTROL,31)))
#define TSB_DMAC_C0CONFIGURATION_E         (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C0CONFIGURATION,0)))
#define TSB_DMAC_C0CONFIGURATION_IE        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C0CONFIGURATION,14)))
#define TSB_DMAC_C0CONFIGURATION_ITC       (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C0CONFIGURATION,15)))
#define TSB_DMAC_C0CONFIGURATION_LOCK      (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C0CONFIGURATION,16)))
#define TSB_DMAC_C0CONFIGURATION_ACTIVE    (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->C0CONFIGURATION,17)))
#define TSB_DMAC_C0CONFIGURATION_HALT      (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C0CONFIGURATION,18)))
#define TSB_DMAC_C1CONTROL_SI              (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C1CONTROL,26)))
#define TSB_DMAC_C1CONTROL_DI              (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C1CONTROL,27)))
#define TSB_DMAC_C1CONTROL_I               (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C1CONTROL,31)))
#define TSB_DMAC_C1CONFIGURATION_E         (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C1CONFIGURATION,0)))
#define TSB_DMAC_C1CONFIGURATION_IE        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C1CONFIGURATION,14)))
#define TSB_DMAC_C1CONFIGURATION_ITC       (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C1CONFIGURATION,15)))
#define TSB_DMAC_C1CONFIGURATION_LOCK      (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C1CONFIGURATION,16)))
#define TSB_DMAC_C1CONFIGURATION_ACTIVE    (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->C1CONFIGURATION,17)))
#define TSB_DMAC_C1CONFIGURATION_HALT      (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->C1CONFIGURATION,18)))

/* Synchronous Serial Port (SSP)*/
#define TSB_SSP0_CR0_SPO                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR0,6)))
#define TSB_SSP0_CR0_SPH                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR0,7)))
#define TSB_SSP0_CR1_LBM                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,0)))
#define TSB_SSP0_CR1_SSE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,1)))
#define TSB_SSP0_CR1_MS                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,2)))
#define TSB_SSP0_CR1_SOD                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,3)))
#define TSB_SSP0_SR_TFE                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR ,0)))
#define TSB_SSP0_SR_TNF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR ,1)))
#define TSB_SSP0_SR_RNE                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR ,2)))
#define TSB_SSP0_SR_RFF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR ,3)))
#define TSB_SSP0_SR_BSY                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR ,4)))
#define TSB_SSP0_IMSC_RORIM              (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,0)))
#define TSB_SSP0_IMSC_RTIM               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,1)))
#define TSB_SSP0_IMSC_RXIM               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,2)))
#define TSB_SSP0_IMSC_TXIM               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,3)))
#define TSB_SSP0_RIS_RORRIS              (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,0)))
#define TSB_SSP0_RIS_RTRIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,1)))
#define TSB_SSP0_RIS_RXRIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,2)))
#define TSB_SSP0_RIS_TXRIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,3)))
#define TSB_SSP0_MIS_RORMIS              (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,0)))
#define TSB_SSP0_MIS_RTMIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,1)))
#define TSB_SSP0_MIS_RXMIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,2)))
#define TSB_SSP0_MIS_TXMIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,3)))
#define TSB_SSP0_DMACR_RXDMAE            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->DMACR,0)))
#define TSB_SSP0_DMACR_TXDMAE            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->DMACR,1)))

#define TSB_SSP1_CR0_SPO                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR0,6)))
#define TSB_SSP1_CR0_SPH                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR0,7)))
#define TSB_SSP1_CR1_LBM                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,0)))
#define TSB_SSP1_CR1_SSE                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,1)))
#define TSB_SSP1_CR1_MS                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,2)))
#define TSB_SSP1_CR1_SOD                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,3)))
#define TSB_SSP1_SR_TFE                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR ,0)))
#define TSB_SSP1_SR_TNF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR ,1)))
#define TSB_SSP1_SR_RNE                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR ,2)))
#define TSB_SSP1_SR_RFF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR ,3)))
#define TSB_SSP1_SR_BSY                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR ,4)))
#define TSB_SSP1_IMSC_RORIM              (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,0)))
#define TSB_SSP1_IMSC_RTIM               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,1)))
#define TSB_SSP1_IMSC_RXIM               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,2)))
#define TSB_SSP1_IMSC_TXIM               (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,3)))
#define TSB_SSP1_RIS_RORRIS              (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,0)))
#define TSB_SSP1_RIS_RTRIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,1)))
#define TSB_SSP1_RIS_RXRIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,2)))
#define TSB_SSP1_RIS_TXRIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,3)))
#define TSB_SSP1_MIS_RORMIS              (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,0)))
#define TSB_SSP1_MIS_RTMIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,1)))
#define TSB_SSP1_MIS_RXMIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,2)))
#define TSB_SSP1_MIS_TXMIS               (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,3)))
#define TSB_SSP1_DMACR_RXDMAE            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->DMACR,0)))
#define TSB_SSP1_DMACR_TXDMAE            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->DMACR,1)))


/** @} */ /* End of group Device_Peripheral_registers */

#ifdef __cplusplus
}
#endif

#endif  /* __TMPM380_H__ */

/** @} */ /* End of group TMPM380 */
/** @} */ /* End of group TOSHIBA_TX03_MICROCONTROLLER */
