/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2017 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak INT0_IRQHandler
  .thumb_set INT0_IRQHandler,Dummy_Handler

  .weak INT1_IRQHandler
  .thumb_set INT1_IRQHandler,Dummy_Handler

  .weak INT2_IRQHandler
  .thumb_set INT2_IRQHandler,Dummy_Handler

  .weak INT3_IRQHandler
  .thumb_set INT3_IRQHandler,Dummy_Handler

  .weak INT4_IRQHandler
  .thumb_set INT4_IRQHandler,Dummy_Handler

  .weak INT5_IRQHandler
  .thumb_set INT5_IRQHandler,Dummy_Handler

  .weak INTRX0_IRQHandler
  .thumb_set INTRX0_IRQHandler,Dummy_Handler

  .weak INTTX0_IRQHandler
  .thumb_set INTTX0_IRQHandler,Dummy_Handler

  .weak INTRX1_IRQHandler
  .thumb_set INTRX1_IRQHandler,Dummy_Handler

  .weak INTTX1_IRQHandler
  .thumb_set INTTX1_IRQHandler,Dummy_Handler

  .weak INTVCNA_IRQHandler
  .thumb_set INTVCNA_IRQHandler,Dummy_Handler

  .weak INTVCNB_IRQHandler
  .thumb_set INTVCNB_IRQHandler,Dummy_Handler

  .weak INTEMG0_IRQHandler
  .thumb_set INTEMG0_IRQHandler,Dummy_Handler

  .weak INTEMG1_IRQHandler
  .thumb_set INTEMG1_IRQHandler,Dummy_Handler

  .weak INTOVV0_IRQHandler
  .thumb_set INTOVV0_IRQHandler,Dummy_Handler

  .weak INTOVV1_IRQHandler
  .thumb_set INTOVV1_IRQHandler,Dummy_Handler

  .weak INTADAPDA_IRQHandler
  .thumb_set INTADAPDA_IRQHandler,Dummy_Handler

  .weak INTADBPDA_IRQHandler
  .thumb_set INTADBPDA_IRQHandler,Dummy_Handler

  .weak INTADAPDB_IRQHandler
  .thumb_set INTADAPDB_IRQHandler,Dummy_Handler

  .weak INTADBPDB_IRQHandler
  .thumb_set INTADBPDB_IRQHandler,Dummy_Handler

  .weak INTTB00_IRQHandler
  .thumb_set INTTB00_IRQHandler,Dummy_Handler

  .weak INTTB01_IRQHandler
  .thumb_set INTTB01_IRQHandler,Dummy_Handler

  .weak INTTB10_IRQHandler
  .thumb_set INTTB10_IRQHandler,Dummy_Handler

  .weak INTTB11_IRQHandler
  .thumb_set INTTB11_IRQHandler,Dummy_Handler

  .weak INTTB40_IRQHandler
  .thumb_set INTTB40_IRQHandler,Dummy_Handler

  .weak INTTB41_IRQHandler
  .thumb_set INTTB41_IRQHandler,Dummy_Handler

  .weak INTTB50_IRQHandler
  .thumb_set INTTB50_IRQHandler,Dummy_Handler

  .weak INTTB51_IRQHandler
  .thumb_set INTTB51_IRQHandler,Dummy_Handler

  .weak INTPMD0_IRQHandler
  .thumb_set INTPMD0_IRQHandler,Dummy_Handler

  .weak INTPMD1_IRQHandler
  .thumb_set INTPMD1_IRQHandler,Dummy_Handler

  .weak INTCAP00_IRQHandler
  .thumb_set INTCAP00_IRQHandler,Dummy_Handler

  .weak INTCAP01_IRQHandler
  .thumb_set INTCAP01_IRQHandler,Dummy_Handler

  .weak INTCAP10_IRQHandler
  .thumb_set INTCAP10_IRQHandler,Dummy_Handler

  .weak INTCAP11_IRQHandler
  .thumb_set INTCAP11_IRQHandler,Dummy_Handler

  .weak INTCAP40_IRQHandler
  .thumb_set INTCAP40_IRQHandler,Dummy_Handler

  .weak INTCAP41_IRQHandler
  .thumb_set INTCAP41_IRQHandler,Dummy_Handler

  .weak INTCAP50_IRQHandler
  .thumb_set INTCAP50_IRQHandler,Dummy_Handler

  .weak INTCAP51_IRQHandler
  .thumb_set INTCAP51_IRQHandler,Dummy_Handler

  .weak INT6_IRQHandler
  .thumb_set INT6_IRQHandler,Dummy_Handler

  .weak INT7_IRQHandler
  .thumb_set INT7_IRQHandler,Dummy_Handler

  .weak INTRX2_IRQHandler
  .thumb_set INTRX2_IRQHandler,Dummy_Handler

  .weak INTTX2_IRQHandler
  .thumb_set INTTX2_IRQHandler,Dummy_Handler

  .weak INTADACPA_IRQHandler
  .thumb_set INTADACPA_IRQHandler,Dummy_Handler

  .weak INTADBCPA_IRQHandler
  .thumb_set INTADBCPA_IRQHandler,Dummy_Handler

  .weak INTADACPB_IRQHandler
  .thumb_set INTADACPB_IRQHandler,Dummy_Handler

  .weak INTADBCPB_IRQHandler
  .thumb_set INTADBCPB_IRQHandler,Dummy_Handler

  .weak INTTB20_IRQHandler
  .thumb_set INTTB20_IRQHandler,Dummy_Handler

  .weak INTTB21_IRQHandler
  .thumb_set INTTB21_IRQHandler,Dummy_Handler

  .weak INTTB30_IRQHandler
  .thumb_set INTTB30_IRQHandler,Dummy_Handler

  .weak INTTB31_IRQHandler
  .thumb_set INTTB31_IRQHandler,Dummy_Handler

  .weak INTCAP20_IRQHandler
  .thumb_set INTCAP20_IRQHandler,Dummy_Handler

  .weak INTCAP21_IRQHandler
  .thumb_set INTCAP21_IRQHandler,Dummy_Handler

  .weak INTCAP30_IRQHandler
  .thumb_set INTCAP30_IRQHandler,Dummy_Handler

  .weak INTCAP31_IRQHandler
  .thumb_set INTCAP31_IRQHandler,Dummy_Handler

  .weak INTADASFT_IRQHandler
  .thumb_set INTADASFT_IRQHandler,Dummy_Handler

  .weak INTADBSFT_IRQHandler
  .thumb_set INTADBSFT_IRQHandler,Dummy_Handler

  .weak INTADATMR_IRQHandler
  .thumb_set INTADATMR_IRQHandler,Dummy_Handler

  .weak INTADBTMR_IRQHandler
  .thumb_set INTADBTMR_IRQHandler,Dummy_Handler

  .weak INT8_IRQHandler
  .thumb_set INT8_IRQHandler,Dummy_Handler

  .weak INT9_IRQHandler
  .thumb_set INT9_IRQHandler,Dummy_Handler

  .weak INTA_IRQHandler
  .thumb_set INTA_IRQHandler,Dummy_Handler

  .weak INTB_IRQHandler
  .thumb_set INTB_IRQHandler,Dummy_Handler

  .weak INTENC0_IRQHandler
  .thumb_set INTENC0_IRQHandler,Dummy_Handler

  .weak INTENC1_IRQHandler
  .thumb_set INTENC1_IRQHandler,Dummy_Handler

  .weak INTRX3_IRQHandler
  .thumb_set INTRX3_IRQHandler,Dummy_Handler

  .weak INTTX3_IRQHandler
  .thumb_set INTTX3_IRQHandler,Dummy_Handler

  .weak INTTB60_IRQHandler
  .thumb_set INTTB60_IRQHandler,Dummy_Handler

  .weak INTTB61_IRQHandler
  .thumb_set INTTB61_IRQHandler,Dummy_Handler

  .weak INTTB70_IRQHandler
  .thumb_set INTTB70_IRQHandler,Dummy_Handler

  .weak INTTB71_IRQHandler
  .thumb_set INTTB71_IRQHandler,Dummy_Handler

  .weak INTCAP60_IRQHandler
  .thumb_set INTCAP60_IRQHandler,Dummy_Handler

  .weak INTCAP61_IRQHandler
  .thumb_set INTCAP61_IRQHandler,Dummy_Handler

  .weak INTCAP70_IRQHandler
  .thumb_set INTCAP70_IRQHandler,Dummy_Handler

  .weak INTCAP71_IRQHandler
  .thumb_set INTCAP71_IRQHandler,Dummy_Handler

  .weak INTC_IRQHandler
  .thumb_set INTC_IRQHandler,Dummy_Handler

  .weak INTD_IRQHandler
  .thumb_set INTD_IRQHandler,Dummy_Handler

  .weak INTE_IRQHandler
  .thumb_set INTE_IRQHandler,Dummy_Handler

  .weak INTF_IRQHandler
  .thumb_set INTF_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak INT0_IRQHandler
INT0_IRQHandler:
  b .

  .thumb_func
  .weak INT1_IRQHandler
INT1_IRQHandler:
  b .

  .thumb_func
  .weak INT2_IRQHandler
INT2_IRQHandler:
  b .

  .thumb_func
  .weak INT3_IRQHandler
INT3_IRQHandler:
  b .

  .thumb_func
  .weak INT4_IRQHandler
INT4_IRQHandler:
  b .

  .thumb_func
  .weak INT5_IRQHandler
INT5_IRQHandler:
  b .

  .thumb_func
  .weak INTRX0_IRQHandler
INTRX0_IRQHandler:
  b .

  .thumb_func
  .weak INTTX0_IRQHandler
INTTX0_IRQHandler:
  b .

  .thumb_func
  .weak INTRX1_IRQHandler
INTRX1_IRQHandler:
  b .

  .thumb_func
  .weak INTTX1_IRQHandler
INTTX1_IRQHandler:
  b .

  .thumb_func
  .weak INTVCNA_IRQHandler
INTVCNA_IRQHandler:
  b .

  .thumb_func
  .weak INTVCNB_IRQHandler
INTVCNB_IRQHandler:
  b .

  .thumb_func
  .weak INTEMG0_IRQHandler
INTEMG0_IRQHandler:
  b .

  .thumb_func
  .weak INTEMG1_IRQHandler
INTEMG1_IRQHandler:
  b .

  .thumb_func
  .weak INTOVV0_IRQHandler
INTOVV0_IRQHandler:
  b .

  .thumb_func
  .weak INTOVV1_IRQHandler
INTOVV1_IRQHandler:
  b .

  .thumb_func
  .weak INTADAPDA_IRQHandler
INTADAPDA_IRQHandler:
  b .

  .thumb_func
  .weak INTADBPDA_IRQHandler
INTADBPDA_IRQHandler:
  b .

  .thumb_func
  .weak INTADAPDB_IRQHandler
INTADAPDB_IRQHandler:
  b .

  .thumb_func
  .weak INTADBPDB_IRQHandler
INTADBPDB_IRQHandler:
  b .

  .thumb_func
  .weak INTTB00_IRQHandler
INTTB00_IRQHandler:
  b .

  .thumb_func
  .weak INTTB01_IRQHandler
INTTB01_IRQHandler:
  b .

  .thumb_func
  .weak INTTB10_IRQHandler
INTTB10_IRQHandler:
  b .

  .thumb_func
  .weak INTTB11_IRQHandler
INTTB11_IRQHandler:
  b .

  .thumb_func
  .weak INTTB40_IRQHandler
INTTB40_IRQHandler:
  b .

  .thumb_func
  .weak INTTB41_IRQHandler
INTTB41_IRQHandler:
  b .

  .thumb_func
  .weak INTTB50_IRQHandler
INTTB50_IRQHandler:
  b .

  .thumb_func
  .weak INTTB51_IRQHandler
INTTB51_IRQHandler:
  b .

  .thumb_func
  .weak INTPMD0_IRQHandler
INTPMD0_IRQHandler:
  b .

  .thumb_func
  .weak INTPMD1_IRQHandler
INTPMD1_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP00_IRQHandler
INTCAP00_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP01_IRQHandler
INTCAP01_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP10_IRQHandler
INTCAP10_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP11_IRQHandler
INTCAP11_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP40_IRQHandler
INTCAP40_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP41_IRQHandler
INTCAP41_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP50_IRQHandler
INTCAP50_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP51_IRQHandler
INTCAP51_IRQHandler:
  b .

  .thumb_func
  .weak INT6_IRQHandler
INT6_IRQHandler:
  b .

  .thumb_func
  .weak INT7_IRQHandler
INT7_IRQHandler:
  b .

  .thumb_func
  .weak INTRX2_IRQHandler
INTRX2_IRQHandler:
  b .

  .thumb_func
  .weak INTTX2_IRQHandler
INTTX2_IRQHandler:
  b .

  .thumb_func
  .weak INTADACPA_IRQHandler
INTADACPA_IRQHandler:
  b .

  .thumb_func
  .weak INTADBCPA_IRQHandler
INTADBCPA_IRQHandler:
  b .

  .thumb_func
  .weak INTADACPB_IRQHandler
INTADACPB_IRQHandler:
  b .

  .thumb_func
  .weak INTADBCPB_IRQHandler
INTADBCPB_IRQHandler:
  b .

  .thumb_func
  .weak INTTB20_IRQHandler
INTTB20_IRQHandler:
  b .

  .thumb_func
  .weak INTTB21_IRQHandler
INTTB21_IRQHandler:
  b .

  .thumb_func
  .weak INTTB30_IRQHandler
INTTB30_IRQHandler:
  b .

  .thumb_func
  .weak INTTB31_IRQHandler
INTTB31_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP20_IRQHandler
INTCAP20_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP21_IRQHandler
INTCAP21_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP30_IRQHandler
INTCAP30_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP31_IRQHandler
INTCAP31_IRQHandler:
  b .

  .thumb_func
  .weak INTADASFT_IRQHandler
INTADASFT_IRQHandler:
  b .

  .thumb_func
  .weak INTADBSFT_IRQHandler
INTADBSFT_IRQHandler:
  b .

  .thumb_func
  .weak INTADATMR_IRQHandler
INTADATMR_IRQHandler:
  b .

  .thumb_func
  .weak INTADBTMR_IRQHandler
INTADBTMR_IRQHandler:
  b .

  .thumb_func
  .weak INT8_IRQHandler
INT8_IRQHandler:
  b .

  .thumb_func
  .weak INT9_IRQHandler
INT9_IRQHandler:
  b .

  .thumb_func
  .weak INTA_IRQHandler
INTA_IRQHandler:
  b .

  .thumb_func
  .weak INTB_IRQHandler
INTB_IRQHandler:
  b .

  .thumb_func
  .weak INTENC0_IRQHandler
INTENC0_IRQHandler:
  b .

  .thumb_func
  .weak INTENC1_IRQHandler
INTENC1_IRQHandler:
  b .

  .thumb_func
  .weak INTRX3_IRQHandler
INTRX3_IRQHandler:
  b .

  .thumb_func
  .weak INTTX3_IRQHandler
INTTX3_IRQHandler:
  b .

  .thumb_func
  .weak INTTB60_IRQHandler
INTTB60_IRQHandler:
  b .

  .thumb_func
  .weak INTTB61_IRQHandler
INTTB61_IRQHandler:
  b .

  .thumb_func
  .weak INTTB70_IRQHandler
INTTB70_IRQHandler:
  b .

  .thumb_func
  .weak INTTB71_IRQHandler
INTTB71_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP60_IRQHandler
INTCAP60_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP61_IRQHandler
INTCAP61_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP70_IRQHandler
INTCAP70_IRQHandler:
  b .

  .thumb_func
  .weak INTCAP71_IRQHandler
INTCAP71_IRQHandler:
  b .

  .thumb_func
  .weak INTC_IRQHandler
INTC_IRQHandler:
  b .

  .thumb_func
  .weak INTD_IRQHandler
INTD_IRQHandler:
  b .

  .thumb_func
  .weak INTE_IRQHandler
INTE_IRQHandler:
  b .

  .thumb_func
  .weak INTF_IRQHandler
INTF_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word INT0_IRQHandler
  .word INT1_IRQHandler
  .word INT2_IRQHandler
  .word INT3_IRQHandler
  .word INT4_IRQHandler
  .word INT5_IRQHandler
  .word INTRX0_IRQHandler
  .word INTTX0_IRQHandler
  .word INTRX1_IRQHandler
  .word INTTX1_IRQHandler
  .word INTVCNA_IRQHandler
  .word INTVCNB_IRQHandler
  .word INTEMG0_IRQHandler
  .word INTEMG1_IRQHandler
  .word INTOVV0_IRQHandler
  .word INTOVV1_IRQHandler
  .word INTADAPDA_IRQHandler
  .word INTADBPDA_IRQHandler
  .word INTADAPDB_IRQHandler
  .word INTADBPDB_IRQHandler
  .word INTTB00_IRQHandler
  .word INTTB01_IRQHandler
  .word INTTB10_IRQHandler
  .word INTTB11_IRQHandler
  .word INTTB40_IRQHandler
  .word INTTB41_IRQHandler
  .word INTTB50_IRQHandler
  .word INTTB51_IRQHandler
  .word INTPMD0_IRQHandler
  .word INTPMD1_IRQHandler
  .word INTCAP00_IRQHandler
  .word INTCAP01_IRQHandler
  .word INTCAP10_IRQHandler
  .word INTCAP11_IRQHandler
  .word INTCAP40_IRQHandler
  .word INTCAP41_IRQHandler
  .word INTCAP50_IRQHandler
  .word INTCAP51_IRQHandler
  .word INT6_IRQHandler
  .word INT7_IRQHandler
  .word INTRX2_IRQHandler
  .word INTTX2_IRQHandler
  .word INTADACPA_IRQHandler
  .word INTADBCPA_IRQHandler
  .word INTADACPB_IRQHandler
  .word INTADBCPB_IRQHandler
  .word INTTB20_IRQHandler
  .word INTTB21_IRQHandler
  .word INTTB30_IRQHandler
  .word INTTB31_IRQHandler
  .word INTCAP20_IRQHandler
  .word INTCAP21_IRQHandler
  .word INTCAP30_IRQHandler
  .word INTCAP31_IRQHandler
  .word INTADASFT_IRQHandler
  .word INTADBSFT_IRQHandler
  .word INTADATMR_IRQHandler
  .word INTADBTMR_IRQHandler
  .word INT8_IRQHandler
  .word INT9_IRQHandler
  .word INTA_IRQHandler
  .word INTB_IRQHandler
  .word INTENC0_IRQHandler
  .word INTENC1_IRQHandler
  .word INTRX3_IRQHandler
  .word INTTX3_IRQHandler
  .word INTTB60_IRQHandler
  .word INTTB61_IRQHandler
  .word INTTB70_IRQHandler
  .word INTTB71_IRQHandler
  .word INTCAP60_IRQHandler
  .word INTCAP61_IRQHandler
  .word INTCAP70_IRQHandler
  .word INTCAP71_IRQHandler
  .word INTC_IRQHandler
  .word INTD_IRQHandler
  .word INTE_IRQHandler
  .word INTF_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
