/*********************************************************************
*                    SEGGER Microcontroller GmbH                     *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*            (c) 2014 - 2020 SEGGER Microcontroller GmbH             *
*                                                                    *
*           www.segger.com     Support: support@segger.com           *
*                                                                    *
**********************************************************************
*                                                                    *
* All rights reserved.                                               *
*                                                                    *
* Redistribution and use in source and binary forms, with or         *
* without modification, are permitted provided that the following    *
* conditions are met:                                                *
*                                                                    *
* - Redistributions of source code must retain the above copyright   *
*   notice, this list of conditions and the following disclaimer.    *
*                                                                    *
* - Neither the name of SEGGER Microcontroller GmbH                  *
*   nor the names of its contributors may be used to endorse or      *
*   promote products derived from this software without specific     *
*   prior written permission.                                        *
*                                                                    *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND             *
* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,        *
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF           *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE           *
* DISCLAIMED.                                                        *
* IN NO EVENT SHALL SEGGER Microcontroller GmbH BE LIABLE FOR        *
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR           *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT  *
* OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;    *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      *
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT          *
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE  *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
* DAMAGE.                                                            *
*                                                                    *
*********************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 2

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)
  
  .weak SUPC_IRQHandler
  .thumb_set SUPC_IRQHandler,Dummy_Handler

  .weak RSTC_IRQHandler
  .thumb_set RSTC_IRQHandler,Dummy_Handler

  .weak RTC_IRQHandler
  .thumb_set RTC_IRQHandler,Dummy_Handler

  .weak RTT_IRQHandler
  .thumb_set RTT_IRQHandler,Dummy_Handler

  .weak WDT_IRQHandler
  .thumb_set WDT_IRQHandler,Dummy_Handler
  
  .weak PMC_IRQHandler
  .thumb_set PMC_IRQHandler,Dummy_Handler

  .weak EFC0_IRQHandler
  .thumb_set EFC0_IRQHandler,Dummy_Handler

  .weak EFC1_IRQHandler
  .thumb_set EFC1_IRQHandler,Dummy_Handler

  .weak UART_IRQHandler
  .thumb_set UART_IRQHandler,Dummy_Handler

  .weak SMC_IRQHandler
  .thumb_set SMC_IRQHandler,Dummy_Handler

  .weak SDRAMC_IRQHandler
  .thumb_set SDRAMC_IRQHandler,Dummy_Handler

  .weak PIOA_IRQHandler
  .thumb_set PIOA_IRQHandler,Dummy_Handler

  .weak PIOB_IRQHandler
  .thumb_set PIOB_IRQHandler,Dummy_Handler

  .weak PIOC_IRQHandler
  .thumb_set PIOC_IRQHandler,Dummy_Handler

  .weak PIOD_IRQHandler
  .thumb_set PIOD_IRQHandler,Dummy_Handler

  .weak PIOE_IRQHandler
  .thumb_set PIOE_IRQHandler,Dummy_Handler

  .weak PIOF_IRQHandler
  .thumb_set PIOF_IRQHandler,Dummy_Handler

  .weak USART0_IRQHandler
  .thumb_set USART0_IRQHandler,Dummy_Handler

  .weak USART1_IRQHandler
  .thumb_set USART1_IRQHandler,Dummy_Handler

  .weak USART2_IRQHandler
  .thumb_set USART2_IRQHandler,Dummy_Handler

  .weak USART3_IRQHandler
  .thumb_set USART3_IRQHandler,Dummy_Handler

  .weak HSMCI_IRQHandler
  .thumb_set HSMCI_IRQHandler,Dummy_Handler

  .weak TWI0_IRQHandler
  .thumb_set TWI0_IRQHandler,Dummy_Handler

  .weak TWI1_IRQHandler
  .thumb_set TWI1_IRQHandler,Dummy_Handler

  .weak SPI0_IRQHandler
  .thumb_set SPI0_IRQHandler,Dummy_Handler

  .weak SPI1_IRQHandler
  .thumb_set SPI1_IRQHandler,Dummy_Handler

  .weak SSC_IRQHandler
  .thumb_set SSC_IRQHandler,Dummy_Handler

  .weak TC0_IRQHandler
  .thumb_set TC0_IRQHandler,Dummy_Handler

  .weak TC1_IRQHandler
  .thumb_set TC1_IRQHandler,Dummy_Handler

  .weak TC2_IRQHandler
  .thumb_set TC2_IRQHandler,Dummy_Handler

  .weak TC3_IRQHandler
  .thumb_set TC3_IRQHandler,Dummy_Handler

  .weak TC4_IRQHandler
  .thumb_set TC4_IRQHandler,Dummy_Handler

  .weak TC5_IRQHandler
  .thumb_set TC5_IRQHandler,Dummy_Handler

  .weak TC6_IRQHandler
  .thumb_set TC6_IRQHandler,Dummy_Handler

  .weak TC7_IRQHandler
  .thumb_set TC7_IRQHandler,Dummy_Handler

  .weak TC8_IRQHandler
  .thumb_set TC8_IRQHandler,Dummy_Handler

  .weak PWM_IRQHandler
  .thumb_set PWM_IRQHandler,Dummy_Handler

  .weak ADC_IRQHandler
  .thumb_set ADC_IRQHandler,Dummy_Handler

  .weak DACC_IRQHandler
  .thumb_set DACC_IRQHandler,Dummy_Handler

  .weak DMAC_IRQHandler
  .thumb_set DMAC_IRQHandler,Dummy_Handler

  .weak UOTGHS_IRQHandler
  .thumb_set UOTGHS_IRQHandler,Dummy_Handler

  .weak TRNG_IRQHandler
  .thumb_set TRNG_IRQHandler,Dummy_Handler

  .weak EMAC_IRQHandler
  .thumb_set EMAC_IRQHandler,Dummy_Handler

  .weak CAN0_IRQHandler
  .thumb_set CAN0_IRQHandler,Dummy_Handler

  .weak CAN1_IRQHandler
  .thumb_set CAN1_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak SUPC_IRQHandler
SUPC_IRQHandler:
  b .

  .thumb_func
  .weak RSTC_IRQHandler
RSTC_IRQHandler:
  b .

  .thumb_func
  .weak RTC_IRQHandler
RTC_IRQHandler:
  b .

  .thumb_func
  .weak RTT_IRQHandler
RTT_IRQHandler:
  b .

  .thumb_func
  .weak WDT_IRQHandler
WDT_IRQHandler:
  b .

  .thumb_func
  .weak PMC_IRQHandler
PMC_IRQHandler:
  b .

  .thumb_func
  .weak EFC0_IRQHandler
EFC0_IRQHandler:
  b .

  .thumb_func
  .weak EFC1_IRQHandler
EFC1_IRQHandler:
  b .

  .thumb_func
  .weak UART_IRQHandler
UART_IRQHandler:
  b .

  .thumb_func
  .weak SMC_IRQHandler
SMC_IRQHandler:
  b .

  .thumb_func
  .weak SDRAMC_IRQHandler
SDRAMC_IRQHandler:
  b .

  .thumb_func
  .weak PIOA_IRQHandler
PIOA_IRQHandler:
  b .

  .thumb_func
  .weak PIOB_IRQHandler
PIOB_IRQHandler:
  b .

  .thumb_func
  .weak PIOC_IRQHandler
PIOC_IRQHandler:
  b .

  .thumb_func
  .weak PIOD_IRQHandler
PIOD_IRQHandler:
  b .

  .thumb_func
  .weak PIOE_IRQHandler
PIOE_IRQHandler:
  b .

  .thumb_func
  .weak PIOF_IRQHandler
PIOF_IRQHandler:
  b .

  .thumb_func
  .weak USART0_IRQHandler
USART0_IRQHandler:
  b .

  .thumb_func
  .weak USART1_IRQHandler
USART1_IRQHandler:
  b .

  .thumb_func
  .weak USART2_IRQHandler
USART2_IRQHandler:
  b .

  .thumb_func
  .weak USART3_IRQHandler
USART3_IRQHandler:
  b .

  .thumb_func
  .weak HSMCI_IRQHandler
HSMCI_IRQHandler:
  b .

  .thumb_func
  .weak TWI0_IRQHandler
TWI0_IRQHandler:
  b .

  .thumb_func
  .weak TWI1_IRQHandler
TWI1_IRQHandler:
  b .

  .thumb_func
  .weak SPI0_IRQHandler
SPI0_IRQHandler:
  b .

  .thumb_func
  .weak SPI1_IRQHandler
SPI1_IRQHandler:
  b .

  .thumb_func
  .weak SSC_IRQHandler
SSC_IRQHandler:
  b .

  .thumb_func
  .weak TC0_IRQHandler
TC0_IRQHandler:
  b .

  .thumb_func
  .weak TC1_IRQHandler
TC1_IRQHandler:
  b .

  .thumb_func
  .weak TC2_IRQHandler
TC2_IRQHandler:
  b .

  .thumb_func
  .weak TC3_IRQHandler
TC3_IRQHandler:
  b .

  .thumb_func
  .weak TC4_IRQHandler
TC4_IRQHandler:
  b .

  .thumb_func
  .weak TC5_IRQHandler
TC5_IRQHandler:
  b .

  .thumb_func
  .weak TC6_IRQHandler
TC6_IRQHandler:
  b .

  .thumb_func
  .weak TC7_IRQHandler
TC7_IRQHandler:
  b .

  .thumb_func
  .weak TC8_IRQHandler
TC8_IRQHandler:
  b .

  .thumb_func
  .weak PWM_IRQHandler
PWM_IRQHandler:
  b .

  .thumb_func
  .weak ADC_IRQHandler
ADC_IRQHandler:
  b .

  .thumb_func
  .weak DACC_IRQHandler
DACC_IRQHandler:
  b .

  .thumb_func
  .weak DMAC_IRQHandler
DMAC_IRQHandler:
  b .

  .thumb_func
  .weak UOTGHS_IRQHandler
UOTGHS_IRQHandler:
  b .

  .thumb_func
  .weak TRNG_IRQHandler
TRNG_IRQHandler:
  b .

  .thumb_func
  .weak EMAC_IRQHandler
EMAC_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_IRQHandler
CAN0_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_IRQHandler
CAN1_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .balign 256
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word SUPC_IRQHandler
  .word RSTC_IRQHandler
  .word RTC_IRQHandler 
  .word RTT_IRQHandler 
  .word WDT_IRQHandler 
  .word PMC_IRQHandler
  .word EFC0_IRQHandler
  .word EFC1_IRQHandler
  .word UART_IRQHandler
  .word SMC_IRQHandler 
  .word SDRAMC_IRQHandler
  .word PIOA_IRQHandler
  .word PIOB_IRQHandler
  .word PIOC_IRQHandler
  .word PIOD_IRQHandler
  .word PIOE_IRQHandler
  .word PIOF_IRQHandler
  .word USART0_IRQHandler
  .word USART1_IRQHandler
  .word USART2_IRQHandler
  .word USART3_IRQHandler
  .word HSMCI_IRQHandler
  .word TWI0_IRQHandler
  .word TWI1_IRQHandler
  .word SPI0_IRQHandler
  .word SPI1_IRQHandler
  .word SSC_IRQHandler
  .word TC0_IRQHandler
  .word TC1_IRQHandler
  .word TC2_IRQHandler
  .word TC3_IRQHandler
  .word TC4_IRQHandler
  .word TC5_IRQHandler
  .word TC6_IRQHandler
  .word TC7_IRQHandler
  .word TC8_IRQHandler
  .word PWM_IRQHandler
  .word ADC_IRQHandler
  .word DACC_IRQHandler
  .word DMAC_IRQHandler
  .word UOTGHS_IRQHandler
  .word TRNG_IRQHandler
  .word EMAC_IRQHandler
  .word CAN0_IRQHandler
  .word CAN1_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .balign 256
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
