/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2017 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak DMA0_DMA4_IRQHandler
  .thumb_set DMA0_DMA4_IRQHandler,Dummy_Handler

  .weak DMA1_DMA5_IRQHandler
  .thumb_set DMA1_DMA5_IRQHandler,Dummy_Handler

  .weak DMA2_DMA6_IRQHandler
  .thumb_set DMA2_DMA6_IRQHandler,Dummy_Handler

  .weak DMA3_DMA7_IRQHandler
  .thumb_set DMA3_DMA7_IRQHandler,Dummy_Handler

  .weak DMA_Error_IRQHandler
  .thumb_set DMA_Error_IRQHandler,Dummy_Handler

  .weak FLEXIO0_IRQHandler
  .thumb_set FLEXIO0_IRQHandler,Dummy_Handler

  .weak TPM0_IRQHandler
  .thumb_set TPM0_IRQHandler,Dummy_Handler

  .weak TPM1_IRQHandler
  .thumb_set TPM1_IRQHandler,Dummy_Handler

  .weak TPM2_IRQHandler
  .thumb_set TPM2_IRQHandler,Dummy_Handler

  .weak PIT0_IRQHandler
  .thumb_set PIT0_IRQHandler,Dummy_Handler

  .weak SPI0_IRQHandler
  .thumb_set SPI0_IRQHandler,Dummy_Handler

  .weak EMVSIM0_IRQHandler
  .thumb_set EMVSIM0_IRQHandler,Dummy_Handler

  .weak LPUART0_IRQHandler
  .thumb_set LPUART0_IRQHandler,Dummy_Handler

  .weak LPUART1_IRQHandler
  .thumb_set LPUART1_IRQHandler,Dummy_Handler

  .weak I2C0_IRQHandler
  .thumb_set I2C0_IRQHandler,Dummy_Handler

  .weak QSPI0_IRQHandler
  .thumb_set QSPI0_IRQHandler,Dummy_Handler

  .weak PORTA_IRQHandler
  .thumb_set PORTA_IRQHandler,Dummy_Handler

  .weak PORTB_IRQHandler
  .thumb_set PORTB_IRQHandler,Dummy_Handler

  .weak PORTC_IRQHandler
  .thumb_set PORTC_IRQHandler,Dummy_Handler

  .weak PORTD_IRQHandler
  .thumb_set PORTD_IRQHandler,Dummy_Handler

  .weak PORTE_IRQHandler
  .thumb_set PORTE_IRQHandler,Dummy_Handler

  .weak LLWU_IRQHandler
  .thumb_set LLWU_IRQHandler,Dummy_Handler

  .weak LTC0_IRQHandler
  .thumb_set LTC0_IRQHandler,Dummy_Handler

  .weak USB0_IRQHandler
  .thumb_set USB0_IRQHandler,Dummy_Handler

  .weak ADC0_IRQHandler
  .thumb_set ADC0_IRQHandler,Dummy_Handler

  .weak LPTMR0_IRQHandler
  .thumb_set LPTMR0_IRQHandler,Dummy_Handler

  .weak RTC_Seconds_IRQHandler
  .thumb_set RTC_Seconds_IRQHandler,Dummy_Handler

  .weak INTMUX0_0_IRQHandler
  .thumb_set INTMUX0_0_IRQHandler,Dummy_Handler

  .weak INTMUX0_1_IRQHandler
  .thumb_set INTMUX0_1_IRQHandler,Dummy_Handler

  .weak INTMUX0_2_IRQHandler
  .thumb_set INTMUX0_2_IRQHandler,Dummy_Handler

  .weak INTMUX0_3_IRQHandler
  .thumb_set INTMUX0_3_IRQHandler,Dummy_Handler

  .weak LPTMR1_IRQHandler
  .thumb_set LPTMR1_IRQHandler,Dummy_Handler

  .weak SPI1_IRQHandler
  .thumb_set SPI1_IRQHandler,Dummy_Handler

  .weak LPUART2_IRQHandler
  .thumb_set LPUART2_IRQHandler,Dummy_Handler

  .weak EMVSIM1_IRQHandler
  .thumb_set EMVSIM1_IRQHandler,Dummy_Handler

  .weak I2C1_IRQHandler
  .thumb_set I2C1_IRQHandler,Dummy_Handler

  .weak TSI0_IRQHandler
  .thumb_set TSI0_IRQHandler,Dummy_Handler

  .weak PMC_IRQHandler
  .thumb_set PMC_IRQHandler,Dummy_Handler

  .weak FTFA_IRQHandler
  .thumb_set FTFA_IRQHandler,Dummy_Handler

  .weak MCG_IRQHandler
  .thumb_set MCG_IRQHandler,Dummy_Handler

  .weak WDOG_EWM_IRQHandler
  .thumb_set WDOG_EWM_IRQHandler,Dummy_Handler

  .weak DAC0_IRQHandler
  .thumb_set DAC0_IRQHandler,Dummy_Handler

  .weak TRNG0_IRQHandler
  .thumb_set TRNG0_IRQHandler,Dummy_Handler

  .weak CMP0_IRQHandler
  .thumb_set CMP0_IRQHandler,Dummy_Handler

  .weak RTC_Alarm_IRQHandler
  .thumb_set RTC_Alarm_IRQHandler,Dummy_Handler

  .weak DMA4_IRQHandler
  .thumb_set DMA4_IRQHandler,Dummy_Handler

  .weak DMA5_IRQHandler
  .thumb_set DMA5_IRQHandler,Dummy_Handler

  .weak DMA6_IRQHandler
  .thumb_set DMA6_IRQHandler,Dummy_Handler

  .weak DMA7_IRQHandler
  .thumb_set DMA7_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak DMA0_DMA4_IRQHandler
DMA0_DMA4_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_DMA5_IRQHandler
DMA1_DMA5_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_DMA6_IRQHandler
DMA2_DMA6_IRQHandler:
  b .

  .thumb_func
  .weak DMA3_DMA7_IRQHandler
DMA3_DMA7_IRQHandler:
  b .

  .thumb_func
  .weak DMA_Error_IRQHandler
DMA_Error_IRQHandler:
  b .

  .thumb_func
  .weak FLEXIO0_IRQHandler
FLEXIO0_IRQHandler:
  b .

  .thumb_func
  .weak TPM0_IRQHandler
TPM0_IRQHandler:
  b .

  .thumb_func
  .weak TPM1_IRQHandler
TPM1_IRQHandler:
  b .

  .thumb_func
  .weak TPM2_IRQHandler
TPM2_IRQHandler:
  b .

  .thumb_func
  .weak PIT0_IRQHandler
PIT0_IRQHandler:
  b .

  .thumb_func
  .weak SPI0_IRQHandler
SPI0_IRQHandler:
  b .

  .thumb_func
  .weak EMVSIM0_IRQHandler
EMVSIM0_IRQHandler:
  b .

  .thumb_func
  .weak LPUART0_IRQHandler
LPUART0_IRQHandler:
  b .

  .thumb_func
  .weak LPUART1_IRQHandler
LPUART1_IRQHandler:
  b .

  .thumb_func
  .weak I2C0_IRQHandler
I2C0_IRQHandler:
  b .

  .thumb_func
  .weak QSPI0_IRQHandler
QSPI0_IRQHandler:
  b .

  .thumb_func
  .weak PORTA_IRQHandler
PORTA_IRQHandler:
  b .

  .thumb_func
  .weak PORTB_IRQHandler
PORTB_IRQHandler:
  b .

  .thumb_func
  .weak PORTC_IRQHandler
PORTC_IRQHandler:
  b .

  .thumb_func
  .weak PORTD_IRQHandler
PORTD_IRQHandler:
  b .

  .thumb_func
  .weak PORTE_IRQHandler
PORTE_IRQHandler:
  b .

  .thumb_func
  .weak LLWU_IRQHandler
LLWU_IRQHandler:
  b .

  .thumb_func
  .weak LTC0_IRQHandler
LTC0_IRQHandler:
  b .

  .thumb_func
  .weak USB0_IRQHandler
USB0_IRQHandler:
  b .

  .thumb_func
  .weak ADC0_IRQHandler
ADC0_IRQHandler:
  b .

  .thumb_func
  .weak LPTMR0_IRQHandler
LPTMR0_IRQHandler:
  b .

  .thumb_func
  .weak RTC_Seconds_IRQHandler
RTC_Seconds_IRQHandler:
  b .

  .thumb_func
  .weak INTMUX0_0_IRQHandler
INTMUX0_0_IRQHandler:
  b .

  .thumb_func
  .weak INTMUX0_1_IRQHandler
INTMUX0_1_IRQHandler:
  b .

  .thumb_func
  .weak INTMUX0_2_IRQHandler
INTMUX0_2_IRQHandler:
  b .

  .thumb_func
  .weak INTMUX0_3_IRQHandler
INTMUX0_3_IRQHandler:
  b .

  .thumb_func
  .weak LPTMR1_IRQHandler
LPTMR1_IRQHandler:
  b .

  .thumb_func
  .weak SPI1_IRQHandler
SPI1_IRQHandler:
  b .

  .thumb_func
  .weak LPUART2_IRQHandler
LPUART2_IRQHandler:
  b .

  .thumb_func
  .weak EMVSIM1_IRQHandler
EMVSIM1_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_IRQHandler
I2C1_IRQHandler:
  b .

  .thumb_func
  .weak TSI0_IRQHandler
TSI0_IRQHandler:
  b .

  .thumb_func
  .weak PMC_IRQHandler
PMC_IRQHandler:
  b .

  .thumb_func
  .weak FTFA_IRQHandler
FTFA_IRQHandler:
  b .

  .thumb_func
  .weak MCG_IRQHandler
MCG_IRQHandler:
  b .

  .thumb_func
  .weak WDOG_EWM_IRQHandler
WDOG_EWM_IRQHandler:
  b .

  .thumb_func
  .weak DAC0_IRQHandler
DAC0_IRQHandler:
  b .

  .thumb_func
  .weak TRNG0_IRQHandler
TRNG0_IRQHandler:
  b .

  .thumb_func
  .weak CMP0_IRQHandler
CMP0_IRQHandler:
  b .

  .thumb_func
  .weak RTC_Alarm_IRQHandler
RTC_Alarm_IRQHandler:
  b .

  .thumb_func
  .weak DMA4_IRQHandler
DMA4_IRQHandler:
  b .

  .thumb_func
  .weak DMA5_IRQHandler
DMA5_IRQHandler:
  b .

  .thumb_func
  .weak DMA6_IRQHandler
DMA6_IRQHandler:
  b .

  .thumb_func
  .weak DMA7_IRQHandler
DMA7_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word DMA0_DMA4_IRQHandler
  .word DMA1_DMA5_IRQHandler
  .word DMA2_DMA6_IRQHandler
  .word DMA3_DMA7_IRQHandler
  .word DMA_Error_IRQHandler
  .word FLEXIO0_IRQHandler
  .word TPM0_IRQHandler
  .word TPM1_IRQHandler
  .word TPM2_IRQHandler
  .word PIT0_IRQHandler
  .word SPI0_IRQHandler
  .word EMVSIM0_IRQHandler
  .word LPUART0_IRQHandler
  .word LPUART1_IRQHandler
  .word I2C0_IRQHandler
  .word QSPI0_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word PORTA_IRQHandler
  .word PORTB_IRQHandler
  .word PORTC_IRQHandler
  .word PORTD_IRQHandler
  .word PORTE_IRQHandler
  .word LLWU_IRQHandler
  .word LTC0_IRQHandler
  .word USB0_IRQHandler
  .word ADC0_IRQHandler
  .word LPTMR0_IRQHandler
  .word RTC_Seconds_IRQHandler
  .word INTMUX0_0_IRQHandler
  .word INTMUX0_1_IRQHandler
  .word INTMUX0_2_IRQHandler
  .word INTMUX0_3_IRQHandler
  .word LPTMR1_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word SPI1_IRQHandler
  .word LPUART2_IRQHandler
  .word EMVSIM1_IRQHandler
  .word I2C1_IRQHandler
  .word TSI0_IRQHandler
  .word PMC_IRQHandler
  .word FTFA_IRQHandler
  .word MCG_IRQHandler
  .word WDOG_EWM_IRQHandler
  .word DAC0_IRQHandler
  .word TRNG0_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word CMP0_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word RTC_Alarm_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word DMA4_IRQHandler
  .word DMA5_IRQHandler
  .word DMA6_IRQHandler
  .word DMA7_IRQHandler
_vectors_end:

#if 1
  .section .vectors, "ax"
  // fill to 0x400 for the flash configuration field
  //.fill 0x400-(_vectors_end-_vectors), 1, 0xff
  .org 0x400, 0xFF
BackDoorKey:
  .byte 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
#if defined(E_SERIES)
RESERVED:
  .byte 0xff, 0xff, 0xff, 0xff
EEPROT:
  .byte 0xff
FPROT:
  .byte 0xff
FSEC:
  .byte 0xfe
FOPT:
  .byte 0xff
#else
FPROT:
  .byte 0xff, 0xff, 0xff, 0xff
FSEC:
  .byte 0xfe
FOPT:
#if defined(MKL03Z4) || defined(MKL17Z4) || defined(MKL17Z644) || defined(MKL27Z4)  || defined(MKL27Z644) || defined(MKL33Z4) || defined(MKL33Z644) || defined(MKL43Z4)
  .byte 0x3b
#else 
  .byte 0xff
#endif
FEPROT:
  .byte 0xff
FDPROT:
  .byte 0xff
#endif
#endif

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
