/*
** ###################################################################
**     Processors:          MKL82Z128VLH7
**                          MKL82Z128VLK7
**                          MKL82Z128VLL7
**                          MKL82Z128VMC7
**                          MKL82Z128VMP7
**
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          GNU C Compiler - CodeSourcery Sourcery G++
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    KL82P121M72SF0RM, Rev.1.2 September 2015
**     Version:             rev. 1.5, 2015-09-24
**     Build:               b151109
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MKL82Z7
**
**     Copyright (c) 1997 - 2015 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2015-04-18)
**         Initial version.
**     - rev. 1.1 (2015-05-04)
**         Update SIM, EVMSIM, QuadSPI, and I2C based on Rev0 document.
**     - rev. 1.2 (2015-08-11)
**         Correct clock configuration.
**     - rev. 1.3 (2015-08-20)
**         Align with RM Rev.1.
**     - rev. 1.4 (2015-08-28)
**         Update LPUART to add FIFO.
**     - rev. 1.5 (2015-09-24)
**         Update to align with RM Rev.1.2.
**
** ###################################################################
*/

/*!
 * @file MKL82Z7.h
 * @version 1.5
 * @date 2015-09-24
 * @brief CMSIS Peripheral Access Layer for MKL82Z7
 *
 * CMSIS Peripheral Access Layer for MKL82Z7
 */


/* ----------------------------------------------------------------------------
   -- MCU activation
   ---------------------------------------------------------------------------- */

/* Prevention from multiple including the same memory map */
#if !defined(MKL82Z7_H_)  /* Check if memory map has not been already included */
#define MKL82Z7_H_
#define MCU_MKL82Z7

/* Check if another memory map has not been also included */
#if (defined(MCU_ACTIVE))
  #error MKL82Z7 memory map: There is already included another memory map. Only one memory map can be included.
#endif /* (defined(MCU_ACTIVE)) */
#define MCU_ACTIVE

#include <stdint.h>

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100u
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0005u


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 80                 /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M0 SV Hard Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M0 SV Call Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M0 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M0 System Tick Interrupt */

  /* Device specific interrupts */
  DMA0_DMA4_IRQn               = 0,                /**< DMA channel 0, 4 transfer complete */
  DMA1_DMA5_IRQn               = 1,                /**< DMA channel 1, 5 transfer complete */
  DMA2_DMA6_IRQn               = 2,                /**< DMA channel 2, 6 transfer complete */
  DMA3_DMA7_IRQn               = 3,                /**< DMA channel 3, 7 transfer complete */
  DMA_Error_IRQn               = 4,                /**< DMA channel 0 - 7 error */
  FLEXIO0_IRQn                 = 5,                /**< Flexible IO */
  TPM0_IRQn                    = 6,                /**< Timer/PWM module 0 */
  TPM1_IRQn                    = 7,                /**< Timer/PWM module 1 */
  TPM2_IRQn                    = 8,                /**< Timer/PWM module 2 */
  PIT0_IRQn                    = 9,                /**< Periodic Interrupt Timer 0 */
  SPI0_IRQn                    = 10,               /**< Serial Peripheral Interface 0 */
  EMVSIM0_IRQn                 = 11,               /**< EMVSIM0 common interrupt */
  LPUART0_IRQn                 = 12,               /**< LPUART0 status and error */
  LPUART1_IRQn                 = 13,               /**< LPUART1 status and error */
  I2C0_IRQn                    = 14,               /**< Inter-Integrated Circuit 0 */
  QSPI0_IRQn                   = 15,               /**< QuadSPI0 interrupt */
  Reserved32_IRQn              = 16,               /**< DryIce tamper detect */
  PORTA_IRQn                   = 17,               /**< Pin detect Port A */
  PORTB_IRQn                   = 18,               /**< Pin detect Port B */
  PORTC_IRQn                   = 19,               /**< Pin detect Port C */
  PORTD_IRQn                   = 20,               /**< Pin detect Port D */
  PORTE_IRQn                   = 21,               /**< Pin detect Port E */
  LLWU_IRQn                    = 22,               /**< Low Leakage Wakeup */
  LTC0_IRQn                    = 23,               /**< Low power trusted cryptographic */
  USB0_IRQn                    = 24,               /**< USB OTG interrupt */
  ADC0_IRQn                    = 25,               /**< Analog-to-Digital Converter 0 */
  LPTMR0_IRQn                  = 26,               /**< Low-Power Timer 0 */
  RTC_Seconds_IRQn             = 27,               /**< RTC seconds */
  INTMUX0_0_IRQn               = 28,               /**< Selectable peripheral interrupt INTMUX0-0 */
  INTMUX0_1_IRQn               = 29,               /**< Selectable peripheral interrupt INTMUX0-1 */
  INTMUX0_2_IRQn               = 30,               /**< Selectable peripheral interrupt INTMUX0-2 */
  INTMUX0_3_IRQn               = 31,               /**< Selectable peripheral interrupt INTMUX0-3 */
  LPTMR1_IRQn                  = 32,               /**< Low-Power Timer 1 (INTMUX source IRQ0) */
  Reserved49_IRQn              = 33,               /**< Reserved interrupt (INTMUX source IRQ1) */
  Reserved50_IRQn              = 34,               /**< Reserved interrupt (INTMUX source IRQ2) */
  Reserved51_IRQn              = 35,               /**< Reserved interrupt (INTMUX source IRQ3) */
  SPI1_IRQn                    = 36,               /**< Serial Peripheral Interface 1 (INTMUX source IRQ4) */
  LPUART2_IRQn                 = 37,               /**< LPUART2 status and error (INTMUX source IRQ5) */
  EMVSIM1_IRQn                 = 38,               /**< EMVSIM1 common interrupt (INTMUX source IRQ6) */
  I2C1_IRQn                    = 39,               /**< Inter-Integrated Circuit 1 (INTMUX source IRQ7) */
  TSI0_IRQn                    = 40,               /**< Touch Sensing Input 0 (INTMUX source IRQ8) */
  PMC_IRQn                     = 41,               /**< PMC controller low-voltage detect, low-voltage warning (INTMUX source IRQ9) */
  FTFA_IRQn                    = 42,               /**< FTFA command complete/read collision (INTMUX source IRQ10) */
  MCG_IRQn                     = 43,               /**< Multipurpose clock generator (INTMUX source IRQ11) */
  WDOG_EWM_IRQn                = 44,               /**< Single interrupt vector for  WDOG and EWM (INTMUX source IRQ12) */
  DAC0_IRQn                    = 45,               /**< Digital-to-analog converter 0 (INTMUX source IRQ13) */
  TRNG0_IRQn                   = 46,               /**< True randon number generator (INTMUX source IRQ14) */
  Reserved63_IRQn              = 47,               /**< Reserved interrupt (INTMUX source IRQ15) */
  CMP0_IRQn                    = 48,               /**< Comparator 0 (INTMUX source IRQ16) */
  Reserved65_IRQn              = 49,               /**< Reserved interrupt (INTMUX source IRQ17) */
  RTC_Alarm_IRQn               = 50,               /**< Real time clock (INTMUX source IRQ18) */
  Reserved67_IRQn              = 51,               /**< Reserved interrupt (INTMUX source IRQ19) */
  Reserved68_IRQn              = 52,               /**< Reserved interrupt (INTMUX source IRQ20) */
  Reserved69_IRQn              = 53,               /**< Reserved interrupt (INTMUX source IRQ21) */
  Reserved70_IRQn              = 54,               /**< Reserved interrupt (INTMUX source IRQ22) */
  Reserved71_IRQn              = 55,               /**< Reserved interrupt (INTMUX source IRQ23) */
  DMA4_IRQn                    = 56,               /**< DMA channel 4 transfer complete (INTMUX source IRQ24) */
  DMA5_IRQn                    = 57,               /**< DMA channel 5 transfer complete (INTMUX source IRQ25) */
  DMA6_IRQn                    = 58,               /**< DMA channel 6 transfer complete (INTMUX source IRQ26) */
  DMA7_IRQn                    = 59,               /**< DMA channel 7 transfer complete (INTMUX source IRQ27) */
  Reserved76_IRQn              = 60,               /**< Reserved interrupt (INTMUX source IRQ28) */
  Reserved77_IRQn              = 61,               /**< Reserved interrupt (INTMUX source IRQ29) */
  Reserved78_IRQn              = 62,               /**< Reserved interrupt (INTMUX source IRQ30) */
  Reserved79_IRQn              = 63                /**< Reserved interrupt (INTMUX source IRQ31) */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M0 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M0 Core Configuration
 * @{
 */

#define __CM0PLUS_REV                  0x0000    /**< Core revision r0p0 */
#define __MPU_PRESENT                  0         /**< Defines if an MPU is present or not */
#define __VTOR_PRESENT                 1         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               2         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */

#include "core_cm0plus.h"              /* Core Peripheral Access Layer */
#include "system_MKL82Z7.h"            /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __IO uint32_t SC1[2];                            /**< ADC Status and Control Registers 1, array offset: 0x0, array step: 0x4 */
  __IO uint32_t CFG1;                              /**< ADC Configuration Register 1, offset: 0x8 */
  __IO uint32_t CFG2;                              /**< ADC Configuration Register 2, offset: 0xC */
  __I  uint32_t R[2];                              /**< ADC Data Result Register, array offset: 0x10, array step: 0x4 */
  __IO uint32_t CV1;                               /**< Compare Value Registers, offset: 0x18 */
  __IO uint32_t CV2;                               /**< Compare Value Registers, offset: 0x1C */
  __IO uint32_t SC2;                               /**< Status and Control Register 2, offset: 0x20 */
  __IO uint32_t SC3;                               /**< Status and Control Register 3, offset: 0x24 */
  __IO uint32_t OFS;                               /**< ADC Offset Correction Register, offset: 0x28 */
  __IO uint32_t PG;                                /**< ADC Plus-Side Gain Register, offset: 0x2C */
  __IO uint32_t MG;                                /**< ADC Minus-Side Gain Register, offset: 0x30 */
  __IO uint32_t CLPD;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x34 */
  __IO uint32_t CLPS;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x38 */
  __IO uint32_t CLP4;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x3C */
  __IO uint32_t CLP3;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x40 */
  __IO uint32_t CLP2;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x44 */
  __IO uint32_t CLP1;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x48 */
  __IO uint32_t CLP0;                              /**< ADC Plus-Side General Calibration Value Register, offset: 0x4C */
       uint8_t RESERVED_0[4];
  __IO uint32_t CLMD;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x54 */
  __IO uint32_t CLMS;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x58 */
  __IO uint32_t CLM4;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x5C */
  __IO uint32_t CLM3;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x60 */
  __IO uint32_t CLM2;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x64 */
  __IO uint32_t CLM1;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x68 */
  __IO uint32_t CLM0;                              /**< ADC Minus-Side General Calibration Value Register, offset: 0x6C */
} ADC_Type, *ADC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ADC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Accessor_Macros ADC - Register accessor macros
 * @{
 */


/* ADC - Register accessors */
#define ADC_SC1_REG(base,index)                  ((base)->SC1[index])
#define ADC_SC1_COUNT                            2
#define ADC_CFG1_REG(base)                       ((base)->CFG1)
#define ADC_CFG2_REG(base)                       ((base)->CFG2)
#define ADC_R_REG(base,index)                    ((base)->R[index])
#define ADC_R_COUNT                              2
#define ADC_CV1_REG(base)                        ((base)->CV1)
#define ADC_CV2_REG(base)                        ((base)->CV2)
#define ADC_SC2_REG(base)                        ((base)->SC2)
#define ADC_SC3_REG(base)                        ((base)->SC3)
#define ADC_OFS_REG(base)                        ((base)->OFS)
#define ADC_PG_REG(base)                         ((base)->PG)
#define ADC_MG_REG(base)                         ((base)->MG)
#define ADC_CLPD_REG(base)                       ((base)->CLPD)
#define ADC_CLPS_REG(base)                       ((base)->CLPS)
#define ADC_CLP4_REG(base)                       ((base)->CLP4)
#define ADC_CLP3_REG(base)                       ((base)->CLP3)
#define ADC_CLP2_REG(base)                       ((base)->CLP2)
#define ADC_CLP1_REG(base)                       ((base)->CLP1)
#define ADC_CLP0_REG(base)                       ((base)->CLP0)
#define ADC_CLMD_REG(base)                       ((base)->CLMD)
#define ADC_CLMS_REG(base)                       ((base)->CLMS)
#define ADC_CLM4_REG(base)                       ((base)->CLM4)
#define ADC_CLM3_REG(base)                       ((base)->CLM3)
#define ADC_CLM2_REG(base)                       ((base)->CLM2)
#define ADC_CLM1_REG(base)                       ((base)->CLM1)
#define ADC_CLM0_REG(base)                       ((base)->CLM0)

/*!
 * @}
 */ /* end of group ADC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/* SC1 Bit Fields */
#define ADC_SC1_ADCH_MASK                        0x1Fu
#define ADC_SC1_ADCH_SHIFT                       0
#define ADC_SC1_ADCH_WIDTH                       5
#define ADC_SC1_ADCH(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC1_ADCH_SHIFT))&ADC_SC1_ADCH_MASK)
#define ADC_SC1_DIFF_MASK                        0x20u
#define ADC_SC1_DIFF_SHIFT                       5
#define ADC_SC1_DIFF_WIDTH                       1
#define ADC_SC1_DIFF(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC1_DIFF_SHIFT))&ADC_SC1_DIFF_MASK)
#define ADC_SC1_AIEN_MASK                        0x40u
#define ADC_SC1_AIEN_SHIFT                       6
#define ADC_SC1_AIEN_WIDTH                       1
#define ADC_SC1_AIEN(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC1_AIEN_SHIFT))&ADC_SC1_AIEN_MASK)
#define ADC_SC1_COCO_MASK                        0x80u
#define ADC_SC1_COCO_SHIFT                       7
#define ADC_SC1_COCO_WIDTH                       1
#define ADC_SC1_COCO(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC1_COCO_SHIFT))&ADC_SC1_COCO_MASK)
/* CFG1 Bit Fields */
#define ADC_CFG1_ADICLK_MASK                     0x3u
#define ADC_CFG1_ADICLK_SHIFT                    0
#define ADC_CFG1_ADICLK_WIDTH                    2
#define ADC_CFG1_ADICLK(x)                       (((uint32_t)(((uint32_t)(x))<<ADC_CFG1_ADICLK_SHIFT))&ADC_CFG1_ADICLK_MASK)
#define ADC_CFG1_MODE_MASK                       0xCu
#define ADC_CFG1_MODE_SHIFT                      2
#define ADC_CFG1_MODE_WIDTH                      2
#define ADC_CFG1_MODE(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CFG1_MODE_SHIFT))&ADC_CFG1_MODE_MASK)
#define ADC_CFG1_ADLSMP_MASK                     0x10u
#define ADC_CFG1_ADLSMP_SHIFT                    4
#define ADC_CFG1_ADLSMP_WIDTH                    1
#define ADC_CFG1_ADLSMP(x)                       (((uint32_t)(((uint32_t)(x))<<ADC_CFG1_ADLSMP_SHIFT))&ADC_CFG1_ADLSMP_MASK)
#define ADC_CFG1_ADIV_MASK                       0x60u
#define ADC_CFG1_ADIV_SHIFT                      5
#define ADC_CFG1_ADIV_WIDTH                      2
#define ADC_CFG1_ADIV(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CFG1_ADIV_SHIFT))&ADC_CFG1_ADIV_MASK)
#define ADC_CFG1_ADLPC_MASK                      0x80u
#define ADC_CFG1_ADLPC_SHIFT                     7
#define ADC_CFG1_ADLPC_WIDTH                     1
#define ADC_CFG1_ADLPC(x)                        (((uint32_t)(((uint32_t)(x))<<ADC_CFG1_ADLPC_SHIFT))&ADC_CFG1_ADLPC_MASK)
/* CFG2 Bit Fields */
#define ADC_CFG2_ADLSTS_MASK                     0x3u
#define ADC_CFG2_ADLSTS_SHIFT                    0
#define ADC_CFG2_ADLSTS_WIDTH                    2
#define ADC_CFG2_ADLSTS(x)                       (((uint32_t)(((uint32_t)(x))<<ADC_CFG2_ADLSTS_SHIFT))&ADC_CFG2_ADLSTS_MASK)
#define ADC_CFG2_ADHSC_MASK                      0x4u
#define ADC_CFG2_ADHSC_SHIFT                     2
#define ADC_CFG2_ADHSC_WIDTH                     1
#define ADC_CFG2_ADHSC(x)                        (((uint32_t)(((uint32_t)(x))<<ADC_CFG2_ADHSC_SHIFT))&ADC_CFG2_ADHSC_MASK)
#define ADC_CFG2_ADACKEN_MASK                    0x8u
#define ADC_CFG2_ADACKEN_SHIFT                   3
#define ADC_CFG2_ADACKEN_WIDTH                   1
#define ADC_CFG2_ADACKEN(x)                      (((uint32_t)(((uint32_t)(x))<<ADC_CFG2_ADACKEN_SHIFT))&ADC_CFG2_ADACKEN_MASK)
#define ADC_CFG2_MUXSEL_MASK                     0x10u
#define ADC_CFG2_MUXSEL_SHIFT                    4
#define ADC_CFG2_MUXSEL_WIDTH                    1
#define ADC_CFG2_MUXSEL(x)                       (((uint32_t)(((uint32_t)(x))<<ADC_CFG2_MUXSEL_SHIFT))&ADC_CFG2_MUXSEL_MASK)
/* R Bit Fields */
#define ADC_R_D_MASK                             0xFFFFu
#define ADC_R_D_SHIFT                            0
#define ADC_R_D_WIDTH                            16
#define ADC_R_D(x)                               (((uint32_t)(((uint32_t)(x))<<ADC_R_D_SHIFT))&ADC_R_D_MASK)
/* CV1 Bit Fields */
#define ADC_CV1_CV_MASK                          0xFFFFu
#define ADC_CV1_CV_SHIFT                         0
#define ADC_CV1_CV_WIDTH                         16
#define ADC_CV1_CV(x)                            (((uint32_t)(((uint32_t)(x))<<ADC_CV1_CV_SHIFT))&ADC_CV1_CV_MASK)
/* CV2 Bit Fields */
#define ADC_CV2_CV_MASK                          0xFFFFu
#define ADC_CV2_CV_SHIFT                         0
#define ADC_CV2_CV_WIDTH                         16
#define ADC_CV2_CV(x)                            (((uint32_t)(((uint32_t)(x))<<ADC_CV2_CV_SHIFT))&ADC_CV2_CV_MASK)
/* SC2 Bit Fields */
#define ADC_SC2_REFSEL_MASK                      0x3u
#define ADC_SC2_REFSEL_SHIFT                     0
#define ADC_SC2_REFSEL_WIDTH                     2
#define ADC_SC2_REFSEL(x)                        (((uint32_t)(((uint32_t)(x))<<ADC_SC2_REFSEL_SHIFT))&ADC_SC2_REFSEL_MASK)
#define ADC_SC2_DMAEN_MASK                       0x4u
#define ADC_SC2_DMAEN_SHIFT                      2
#define ADC_SC2_DMAEN_WIDTH                      1
#define ADC_SC2_DMAEN(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_SC2_DMAEN_SHIFT))&ADC_SC2_DMAEN_MASK)
#define ADC_SC2_ACREN_MASK                       0x8u
#define ADC_SC2_ACREN_SHIFT                      3
#define ADC_SC2_ACREN_WIDTH                      1
#define ADC_SC2_ACREN(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_SC2_ACREN_SHIFT))&ADC_SC2_ACREN_MASK)
#define ADC_SC2_ACFGT_MASK                       0x10u
#define ADC_SC2_ACFGT_SHIFT                      4
#define ADC_SC2_ACFGT_WIDTH                      1
#define ADC_SC2_ACFGT(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_SC2_ACFGT_SHIFT))&ADC_SC2_ACFGT_MASK)
#define ADC_SC2_ACFE_MASK                        0x20u
#define ADC_SC2_ACFE_SHIFT                       5
#define ADC_SC2_ACFE_WIDTH                       1
#define ADC_SC2_ACFE(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC2_ACFE_SHIFT))&ADC_SC2_ACFE_MASK)
#define ADC_SC2_ADTRG_MASK                       0x40u
#define ADC_SC2_ADTRG_SHIFT                      6
#define ADC_SC2_ADTRG_WIDTH                      1
#define ADC_SC2_ADTRG(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_SC2_ADTRG_SHIFT))&ADC_SC2_ADTRG_MASK)
#define ADC_SC2_ADACT_MASK                       0x80u
#define ADC_SC2_ADACT_SHIFT                      7
#define ADC_SC2_ADACT_WIDTH                      1
#define ADC_SC2_ADACT(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_SC2_ADACT_SHIFT))&ADC_SC2_ADACT_MASK)
/* SC3 Bit Fields */
#define ADC_SC3_AVGS_MASK                        0x3u
#define ADC_SC3_AVGS_SHIFT                       0
#define ADC_SC3_AVGS_WIDTH                       2
#define ADC_SC3_AVGS(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC3_AVGS_SHIFT))&ADC_SC3_AVGS_MASK)
#define ADC_SC3_AVGE_MASK                        0x4u
#define ADC_SC3_AVGE_SHIFT                       2
#define ADC_SC3_AVGE_WIDTH                       1
#define ADC_SC3_AVGE(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC3_AVGE_SHIFT))&ADC_SC3_AVGE_MASK)
#define ADC_SC3_ADCO_MASK                        0x8u
#define ADC_SC3_ADCO_SHIFT                       3
#define ADC_SC3_ADCO_WIDTH                       1
#define ADC_SC3_ADCO(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC3_ADCO_SHIFT))&ADC_SC3_ADCO_MASK)
#define ADC_SC3_CALF_MASK                        0x40u
#define ADC_SC3_CALF_SHIFT                       6
#define ADC_SC3_CALF_WIDTH                       1
#define ADC_SC3_CALF(x)                          (((uint32_t)(((uint32_t)(x))<<ADC_SC3_CALF_SHIFT))&ADC_SC3_CALF_MASK)
#define ADC_SC3_CAL_MASK                         0x80u
#define ADC_SC3_CAL_SHIFT                        7
#define ADC_SC3_CAL_WIDTH                        1
#define ADC_SC3_CAL(x)                           (((uint32_t)(((uint32_t)(x))<<ADC_SC3_CAL_SHIFT))&ADC_SC3_CAL_MASK)
/* OFS Bit Fields */
#define ADC_OFS_OFS_MASK                         0xFFFFu
#define ADC_OFS_OFS_SHIFT                        0
#define ADC_OFS_OFS_WIDTH                        16
#define ADC_OFS_OFS(x)                           (((uint32_t)(((uint32_t)(x))<<ADC_OFS_OFS_SHIFT))&ADC_OFS_OFS_MASK)
/* PG Bit Fields */
#define ADC_PG_PG_MASK                           0xFFFFu
#define ADC_PG_PG_SHIFT                          0
#define ADC_PG_PG_WIDTH                          16
#define ADC_PG_PG(x)                             (((uint32_t)(((uint32_t)(x))<<ADC_PG_PG_SHIFT))&ADC_PG_PG_MASK)
/* MG Bit Fields */
#define ADC_MG_MG_MASK                           0xFFFFu
#define ADC_MG_MG_SHIFT                          0
#define ADC_MG_MG_WIDTH                          16
#define ADC_MG_MG(x)                             (((uint32_t)(((uint32_t)(x))<<ADC_MG_MG_SHIFT))&ADC_MG_MG_MASK)
/* CLPD Bit Fields */
#define ADC_CLPD_CLPD_MASK                       0x3Fu
#define ADC_CLPD_CLPD_SHIFT                      0
#define ADC_CLPD_CLPD_WIDTH                      6
#define ADC_CLPD_CLPD(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLPD_CLPD_SHIFT))&ADC_CLPD_CLPD_MASK)
/* CLPS Bit Fields */
#define ADC_CLPS_CLPS_MASK                       0x3Fu
#define ADC_CLPS_CLPS_SHIFT                      0
#define ADC_CLPS_CLPS_WIDTH                      6
#define ADC_CLPS_CLPS(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLPS_CLPS_SHIFT))&ADC_CLPS_CLPS_MASK)
/* CLP4 Bit Fields */
#define ADC_CLP4_CLP4_MASK                       0x3FFu
#define ADC_CLP4_CLP4_SHIFT                      0
#define ADC_CLP4_CLP4_WIDTH                      10
#define ADC_CLP4_CLP4(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLP4_CLP4_SHIFT))&ADC_CLP4_CLP4_MASK)
/* CLP3 Bit Fields */
#define ADC_CLP3_CLP3_MASK                       0x1FFu
#define ADC_CLP3_CLP3_SHIFT                      0
#define ADC_CLP3_CLP3_WIDTH                      9
#define ADC_CLP3_CLP3(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLP3_CLP3_SHIFT))&ADC_CLP3_CLP3_MASK)
/* CLP2 Bit Fields */
#define ADC_CLP2_CLP2_MASK                       0xFFu
#define ADC_CLP2_CLP2_SHIFT                      0
#define ADC_CLP2_CLP2_WIDTH                      8
#define ADC_CLP2_CLP2(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLP2_CLP2_SHIFT))&ADC_CLP2_CLP2_MASK)
/* CLP1 Bit Fields */
#define ADC_CLP1_CLP1_MASK                       0x7Fu
#define ADC_CLP1_CLP1_SHIFT                      0
#define ADC_CLP1_CLP1_WIDTH                      7
#define ADC_CLP1_CLP1(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLP1_CLP1_SHIFT))&ADC_CLP1_CLP1_MASK)
/* CLP0 Bit Fields */
#define ADC_CLP0_CLP0_MASK                       0x3Fu
#define ADC_CLP0_CLP0_SHIFT                      0
#define ADC_CLP0_CLP0_WIDTH                      6
#define ADC_CLP0_CLP0(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLP0_CLP0_SHIFT))&ADC_CLP0_CLP0_MASK)
/* CLMD Bit Fields */
#define ADC_CLMD_CLMD_MASK                       0x3Fu
#define ADC_CLMD_CLMD_SHIFT                      0
#define ADC_CLMD_CLMD_WIDTH                      6
#define ADC_CLMD_CLMD(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLMD_CLMD_SHIFT))&ADC_CLMD_CLMD_MASK)
/* CLMS Bit Fields */
#define ADC_CLMS_CLMS_MASK                       0x3Fu
#define ADC_CLMS_CLMS_SHIFT                      0
#define ADC_CLMS_CLMS_WIDTH                      6
#define ADC_CLMS_CLMS(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLMS_CLMS_SHIFT))&ADC_CLMS_CLMS_MASK)
/* CLM4 Bit Fields */
#define ADC_CLM4_CLM4_MASK                       0x3FFu
#define ADC_CLM4_CLM4_SHIFT                      0
#define ADC_CLM4_CLM4_WIDTH                      10
#define ADC_CLM4_CLM4(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLM4_CLM4_SHIFT))&ADC_CLM4_CLM4_MASK)
/* CLM3 Bit Fields */
#define ADC_CLM3_CLM3_MASK                       0x1FFu
#define ADC_CLM3_CLM3_SHIFT                      0
#define ADC_CLM3_CLM3_WIDTH                      9
#define ADC_CLM3_CLM3(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLM3_CLM3_SHIFT))&ADC_CLM3_CLM3_MASK)
/* CLM2 Bit Fields */
#define ADC_CLM2_CLM2_MASK                       0xFFu
#define ADC_CLM2_CLM2_SHIFT                      0
#define ADC_CLM2_CLM2_WIDTH                      8
#define ADC_CLM2_CLM2(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLM2_CLM2_SHIFT))&ADC_CLM2_CLM2_MASK)
/* CLM1 Bit Fields */
#define ADC_CLM1_CLM1_MASK                       0x7Fu
#define ADC_CLM1_CLM1_SHIFT                      0
#define ADC_CLM1_CLM1_WIDTH                      7
#define ADC_CLM1_CLM1(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLM1_CLM1_SHIFT))&ADC_CLM1_CLM1_MASK)
/* CLM0 Bit Fields */
#define ADC_CLM0_CLM0_MASK                       0x3Fu
#define ADC_CLM0_CLM0_SHIFT                      0
#define ADC_CLM0_CLM0_WIDTH                      6
#define ADC_CLM0_CLM0(x)                         (((uint32_t)(((uint32_t)(x))<<ADC_CLM0_CLM0_SHIFT))&ADC_CLM0_CLM0_MASK)

/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral ADC0 base address */
#define ADC0_BASE                                (0x4003B000u)
/** Peripheral ADC0 base pointer */
#define ADC0                                     ((ADC_Type *)ADC0_BASE)
#define ADC0_BASE_PTR                            (ADC0)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS                           { ADC0_BASE }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { ADC0 }

/* ----------------------------------------------------------------------------
   -- ADC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Accessor_Macros ADC - Register accessor macros
 * @{
 */


/* ADC - Register instance definitions */
/* ADC0 */
#define ADC0_SC1A                                ADC_SC1_REG(ADC0,0)
#define ADC0_SC1B                                ADC_SC1_REG(ADC0,1)
#define ADC0_CFG1                                ADC_CFG1_REG(ADC0)
#define ADC0_CFG2                                ADC_CFG2_REG(ADC0)
#define ADC0_RA                                  ADC_R_REG(ADC0,0)
#define ADC0_RB                                  ADC_R_REG(ADC0,1)
#define ADC0_CV1                                 ADC_CV1_REG(ADC0)
#define ADC0_CV2                                 ADC_CV2_REG(ADC0)
#define ADC0_SC2                                 ADC_SC2_REG(ADC0)
#define ADC0_SC3                                 ADC_SC3_REG(ADC0)
#define ADC0_OFS                                 ADC_OFS_REG(ADC0)
#define ADC0_PG                                  ADC_PG_REG(ADC0)
#define ADC0_MG                                  ADC_MG_REG(ADC0)
#define ADC0_CLPD                                ADC_CLPD_REG(ADC0)
#define ADC0_CLPS                                ADC_CLPS_REG(ADC0)
#define ADC0_CLP4                                ADC_CLP4_REG(ADC0)
#define ADC0_CLP3                                ADC_CLP3_REG(ADC0)
#define ADC0_CLP2                                ADC_CLP2_REG(ADC0)
#define ADC0_CLP1                                ADC_CLP1_REG(ADC0)
#define ADC0_CLP0                                ADC_CLP0_REG(ADC0)
#define ADC0_CLMD                                ADC_CLMD_REG(ADC0)
#define ADC0_CLMS                                ADC_CLMS_REG(ADC0)
#define ADC0_CLM4                                ADC_CLM4_REG(ADC0)
#define ADC0_CLM3                                ADC_CLM3_REG(ADC0)
#define ADC0_CLM2                                ADC_CLM2_REG(ADC0)
#define ADC0_CLM1                                ADC_CLM1_REG(ADC0)
#define ADC0_CLM0                                ADC_CLM0_REG(ADC0)

/* ADC - Register array accessors */
#define ADC0_SC1(index)                          ADC_SC1_REG(ADC0,index)
#define ADC0_R(index)                            ADC_R_REG(ADC0,index)

/*!
 * @}
 */ /* end of group ADC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AIPS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPS_Peripheral_Access_Layer AIPS Peripheral Access Layer
 * @{
 */

/** AIPS - Register Layout Typedef */
typedef struct {
  __IO uint32_t MPRA;                              /**< Master Privilege Register A, offset: 0x0 */
       uint8_t RESERVED_0[28];
  __IO uint32_t PACRA;                             /**< Peripheral Access Control Register, offset: 0x20 */
  __IO uint32_t PACRB;                             /**< Peripheral Access Control Register, offset: 0x24 */
  __IO uint32_t PACRC;                             /**< Peripheral Access Control Register, offset: 0x28 */
  __IO uint32_t PACRD;                             /**< Peripheral Access Control Register, offset: 0x2C */
       uint8_t RESERVED_1[16];
  __IO uint32_t PACRE;                             /**< Peripheral Access Control Register, offset: 0x40 */
  __IO uint32_t PACRF;                             /**< Peripheral Access Control Register, offset: 0x44 */
  __IO uint32_t PACRG;                             /**< Peripheral Access Control Register, offset: 0x48 */
  __IO uint32_t PACRH;                             /**< Peripheral Access Control Register, offset: 0x4C */
  __IO uint32_t PACRI;                             /**< Peripheral Access Control Register, offset: 0x50 */
  __IO uint32_t PACRJ;                             /**< Peripheral Access Control Register, offset: 0x54 */
  __IO uint32_t PACRK;                             /**< Peripheral Access Control Register, offset: 0x58 */
  __IO uint32_t PACRL;                             /**< Peripheral Access Control Register, offset: 0x5C */
  __IO uint32_t PACRM;                             /**< Peripheral Access Control Register, offset: 0x60 */
  __IO uint32_t PACRN;                             /**< Peripheral Access Control Register, offset: 0x64 */
  __IO uint32_t PACRO;                             /**< Peripheral Access Control Register, offset: 0x68 */
  __IO uint32_t PACRP;                             /**< Peripheral Access Control Register, offset: 0x6C */
} AIPS_Type, *AIPS_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- AIPS - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPS_Register_Accessor_Macros AIPS - Register accessor macros
 * @{
 */


/* AIPS - Register accessors */
#define AIPS_MPRA_REG(base)                      ((base)->MPRA)
#define AIPS_PACRA_REG(base)                     ((base)->PACRA)
#define AIPS_PACRB_REG(base)                     ((base)->PACRB)
#define AIPS_PACRC_REG(base)                     ((base)->PACRC)
#define AIPS_PACRD_REG(base)                     ((base)->PACRD)
#define AIPS_PACRE_REG(base)                     ((base)->PACRE)
#define AIPS_PACRF_REG(base)                     ((base)->PACRF)
#define AIPS_PACRG_REG(base)                     ((base)->PACRG)
#define AIPS_PACRH_REG(base)                     ((base)->PACRH)
#define AIPS_PACRI_REG(base)                     ((base)->PACRI)
#define AIPS_PACRJ_REG(base)                     ((base)->PACRJ)
#define AIPS_PACRK_REG(base)                     ((base)->PACRK)
#define AIPS_PACRL_REG(base)                     ((base)->PACRL)
#define AIPS_PACRM_REG(base)                     ((base)->PACRM)
#define AIPS_PACRN_REG(base)                     ((base)->PACRN)
#define AIPS_PACRO_REG(base)                     ((base)->PACRO)
#define AIPS_PACRP_REG(base)                     ((base)->PACRP)

/*!
 * @}
 */ /* end of group AIPS_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- AIPS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPS_Register_Masks AIPS Register Masks
 * @{
 */

/* MPRA Bit Fields */
#define AIPS_MPRA_MPL4_MASK                      0x1000u
#define AIPS_MPRA_MPL4_SHIFT                     12
#define AIPS_MPRA_MPL4_WIDTH                     1
#define AIPS_MPRA_MPL4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MPL4_SHIFT))&AIPS_MPRA_MPL4_MASK)
#define AIPS_MPRA_MTW4_MASK                      0x2000u
#define AIPS_MPRA_MTW4_SHIFT                     13
#define AIPS_MPRA_MTW4_WIDTH                     1
#define AIPS_MPRA_MTW4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTW4_SHIFT))&AIPS_MPRA_MTW4_MASK)
#define AIPS_MPRA_MTR4_MASK                      0x4000u
#define AIPS_MPRA_MTR4_SHIFT                     14
#define AIPS_MPRA_MTR4_WIDTH                     1
#define AIPS_MPRA_MTR4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTR4_SHIFT))&AIPS_MPRA_MTR4_MASK)
#define AIPS_MPRA_MPL3_MASK                      0x10000u
#define AIPS_MPRA_MPL3_SHIFT                     16
#define AIPS_MPRA_MPL3_WIDTH                     1
#define AIPS_MPRA_MPL3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MPL3_SHIFT))&AIPS_MPRA_MPL3_MASK)
#define AIPS_MPRA_MTW3_MASK                      0x20000u
#define AIPS_MPRA_MTW3_SHIFT                     17
#define AIPS_MPRA_MTW3_WIDTH                     1
#define AIPS_MPRA_MTW3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTW3_SHIFT))&AIPS_MPRA_MTW3_MASK)
#define AIPS_MPRA_MTR3_MASK                      0x40000u
#define AIPS_MPRA_MTR3_SHIFT                     18
#define AIPS_MPRA_MTR3_WIDTH                     1
#define AIPS_MPRA_MTR3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTR3_SHIFT))&AIPS_MPRA_MTR3_MASK)
#define AIPS_MPRA_MPL2_MASK                      0x100000u
#define AIPS_MPRA_MPL2_SHIFT                     20
#define AIPS_MPRA_MPL2_WIDTH                     1
#define AIPS_MPRA_MPL2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MPL2_SHIFT))&AIPS_MPRA_MPL2_MASK)
#define AIPS_MPRA_MTW2_MASK                      0x200000u
#define AIPS_MPRA_MTW2_SHIFT                     21
#define AIPS_MPRA_MTW2_WIDTH                     1
#define AIPS_MPRA_MTW2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTW2_SHIFT))&AIPS_MPRA_MTW2_MASK)
#define AIPS_MPRA_MTR2_MASK                      0x400000u
#define AIPS_MPRA_MTR2_SHIFT                     22
#define AIPS_MPRA_MTR2_WIDTH                     1
#define AIPS_MPRA_MTR2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTR2_SHIFT))&AIPS_MPRA_MTR2_MASK)
#define AIPS_MPRA_MPL1_MASK                      0x1000000u
#define AIPS_MPRA_MPL1_SHIFT                     24
#define AIPS_MPRA_MPL1_WIDTH                     1
#define AIPS_MPRA_MPL1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MPL1_SHIFT))&AIPS_MPRA_MPL1_MASK)
#define AIPS_MPRA_MTW1_MASK                      0x2000000u
#define AIPS_MPRA_MTW1_SHIFT                     25
#define AIPS_MPRA_MTW1_WIDTH                     1
#define AIPS_MPRA_MTW1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTW1_SHIFT))&AIPS_MPRA_MTW1_MASK)
#define AIPS_MPRA_MTR1_MASK                      0x4000000u
#define AIPS_MPRA_MTR1_SHIFT                     26
#define AIPS_MPRA_MTR1_WIDTH                     1
#define AIPS_MPRA_MTR1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTR1_SHIFT))&AIPS_MPRA_MTR1_MASK)
#define AIPS_MPRA_MPL0_MASK                      0x10000000u
#define AIPS_MPRA_MPL0_SHIFT                     28
#define AIPS_MPRA_MPL0_WIDTH                     1
#define AIPS_MPRA_MPL0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MPL0_SHIFT))&AIPS_MPRA_MPL0_MASK)
#define AIPS_MPRA_MTW0_MASK                      0x20000000u
#define AIPS_MPRA_MTW0_SHIFT                     29
#define AIPS_MPRA_MTW0_WIDTH                     1
#define AIPS_MPRA_MTW0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTW0_SHIFT))&AIPS_MPRA_MTW0_MASK)
#define AIPS_MPRA_MTR0_MASK                      0x40000000u
#define AIPS_MPRA_MTR0_SHIFT                     30
#define AIPS_MPRA_MTR0_WIDTH                     1
#define AIPS_MPRA_MTR0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_MPRA_MTR0_SHIFT))&AIPS_MPRA_MTR0_MASK)
/* PACRA Bit Fields */
#define AIPS_PACRA_TP7_MASK                      0x1u
#define AIPS_PACRA_TP7_SHIFT                     0
#define AIPS_PACRA_TP7_WIDTH                     1
#define AIPS_PACRA_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP7_SHIFT))&AIPS_PACRA_TP7_MASK)
#define AIPS_PACRA_WP7_MASK                      0x2u
#define AIPS_PACRA_WP7_SHIFT                     1
#define AIPS_PACRA_WP7_WIDTH                     1
#define AIPS_PACRA_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP7_SHIFT))&AIPS_PACRA_WP7_MASK)
#define AIPS_PACRA_SP7_MASK                      0x4u
#define AIPS_PACRA_SP7_SHIFT                     2
#define AIPS_PACRA_SP7_WIDTH                     1
#define AIPS_PACRA_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP7_SHIFT))&AIPS_PACRA_SP7_MASK)
#define AIPS_PACRA_TP6_MASK                      0x10u
#define AIPS_PACRA_TP6_SHIFT                     4
#define AIPS_PACRA_TP6_WIDTH                     1
#define AIPS_PACRA_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP6_SHIFT))&AIPS_PACRA_TP6_MASK)
#define AIPS_PACRA_WP6_MASK                      0x20u
#define AIPS_PACRA_WP6_SHIFT                     5
#define AIPS_PACRA_WP6_WIDTH                     1
#define AIPS_PACRA_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP6_SHIFT))&AIPS_PACRA_WP6_MASK)
#define AIPS_PACRA_SP6_MASK                      0x40u
#define AIPS_PACRA_SP6_SHIFT                     6
#define AIPS_PACRA_SP6_WIDTH                     1
#define AIPS_PACRA_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP6_SHIFT))&AIPS_PACRA_SP6_MASK)
#define AIPS_PACRA_TP5_MASK                      0x100u
#define AIPS_PACRA_TP5_SHIFT                     8
#define AIPS_PACRA_TP5_WIDTH                     1
#define AIPS_PACRA_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP5_SHIFT))&AIPS_PACRA_TP5_MASK)
#define AIPS_PACRA_WP5_MASK                      0x200u
#define AIPS_PACRA_WP5_SHIFT                     9
#define AIPS_PACRA_WP5_WIDTH                     1
#define AIPS_PACRA_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP5_SHIFT))&AIPS_PACRA_WP5_MASK)
#define AIPS_PACRA_SP5_MASK                      0x400u
#define AIPS_PACRA_SP5_SHIFT                     10
#define AIPS_PACRA_SP5_WIDTH                     1
#define AIPS_PACRA_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP5_SHIFT))&AIPS_PACRA_SP5_MASK)
#define AIPS_PACRA_TP4_MASK                      0x1000u
#define AIPS_PACRA_TP4_SHIFT                     12
#define AIPS_PACRA_TP4_WIDTH                     1
#define AIPS_PACRA_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP4_SHIFT))&AIPS_PACRA_TP4_MASK)
#define AIPS_PACRA_WP4_MASK                      0x2000u
#define AIPS_PACRA_WP4_SHIFT                     13
#define AIPS_PACRA_WP4_WIDTH                     1
#define AIPS_PACRA_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP4_SHIFT))&AIPS_PACRA_WP4_MASK)
#define AIPS_PACRA_SP4_MASK                      0x4000u
#define AIPS_PACRA_SP4_SHIFT                     14
#define AIPS_PACRA_SP4_WIDTH                     1
#define AIPS_PACRA_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP4_SHIFT))&AIPS_PACRA_SP4_MASK)
#define AIPS_PACRA_TP3_MASK                      0x10000u
#define AIPS_PACRA_TP3_SHIFT                     16
#define AIPS_PACRA_TP3_WIDTH                     1
#define AIPS_PACRA_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP3_SHIFT))&AIPS_PACRA_TP3_MASK)
#define AIPS_PACRA_WP3_MASK                      0x20000u
#define AIPS_PACRA_WP3_SHIFT                     17
#define AIPS_PACRA_WP3_WIDTH                     1
#define AIPS_PACRA_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP3_SHIFT))&AIPS_PACRA_WP3_MASK)
#define AIPS_PACRA_SP3_MASK                      0x40000u
#define AIPS_PACRA_SP3_SHIFT                     18
#define AIPS_PACRA_SP3_WIDTH                     1
#define AIPS_PACRA_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP3_SHIFT))&AIPS_PACRA_SP3_MASK)
#define AIPS_PACRA_TP2_MASK                      0x100000u
#define AIPS_PACRA_TP2_SHIFT                     20
#define AIPS_PACRA_TP2_WIDTH                     1
#define AIPS_PACRA_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP2_SHIFT))&AIPS_PACRA_TP2_MASK)
#define AIPS_PACRA_WP2_MASK                      0x200000u
#define AIPS_PACRA_WP2_SHIFT                     21
#define AIPS_PACRA_WP2_WIDTH                     1
#define AIPS_PACRA_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP2_SHIFT))&AIPS_PACRA_WP2_MASK)
#define AIPS_PACRA_SP2_MASK                      0x400000u
#define AIPS_PACRA_SP2_SHIFT                     22
#define AIPS_PACRA_SP2_WIDTH                     1
#define AIPS_PACRA_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP2_SHIFT))&AIPS_PACRA_SP2_MASK)
#define AIPS_PACRA_TP1_MASK                      0x1000000u
#define AIPS_PACRA_TP1_SHIFT                     24
#define AIPS_PACRA_TP1_WIDTH                     1
#define AIPS_PACRA_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP1_SHIFT))&AIPS_PACRA_TP1_MASK)
#define AIPS_PACRA_WP1_MASK                      0x2000000u
#define AIPS_PACRA_WP1_SHIFT                     25
#define AIPS_PACRA_WP1_WIDTH                     1
#define AIPS_PACRA_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP1_SHIFT))&AIPS_PACRA_WP1_MASK)
#define AIPS_PACRA_SP1_MASK                      0x4000000u
#define AIPS_PACRA_SP1_SHIFT                     26
#define AIPS_PACRA_SP1_WIDTH                     1
#define AIPS_PACRA_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP1_SHIFT))&AIPS_PACRA_SP1_MASK)
#define AIPS_PACRA_TP0_MASK                      0x10000000u
#define AIPS_PACRA_TP0_SHIFT                     28
#define AIPS_PACRA_TP0_WIDTH                     1
#define AIPS_PACRA_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_TP0_SHIFT))&AIPS_PACRA_TP0_MASK)
#define AIPS_PACRA_WP0_MASK                      0x20000000u
#define AIPS_PACRA_WP0_SHIFT                     29
#define AIPS_PACRA_WP0_WIDTH                     1
#define AIPS_PACRA_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_WP0_SHIFT))&AIPS_PACRA_WP0_MASK)
#define AIPS_PACRA_SP0_MASK                      0x40000000u
#define AIPS_PACRA_SP0_SHIFT                     30
#define AIPS_PACRA_SP0_WIDTH                     1
#define AIPS_PACRA_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRA_SP0_SHIFT))&AIPS_PACRA_SP0_MASK)
/* PACRB Bit Fields */
#define AIPS_PACRB_TP7_MASK                      0x1u
#define AIPS_PACRB_TP7_SHIFT                     0
#define AIPS_PACRB_TP7_WIDTH                     1
#define AIPS_PACRB_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP7_SHIFT))&AIPS_PACRB_TP7_MASK)
#define AIPS_PACRB_WP7_MASK                      0x2u
#define AIPS_PACRB_WP7_SHIFT                     1
#define AIPS_PACRB_WP7_WIDTH                     1
#define AIPS_PACRB_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP7_SHIFT))&AIPS_PACRB_WP7_MASK)
#define AIPS_PACRB_SP7_MASK                      0x4u
#define AIPS_PACRB_SP7_SHIFT                     2
#define AIPS_PACRB_SP7_WIDTH                     1
#define AIPS_PACRB_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP7_SHIFT))&AIPS_PACRB_SP7_MASK)
#define AIPS_PACRB_TP6_MASK                      0x10u
#define AIPS_PACRB_TP6_SHIFT                     4
#define AIPS_PACRB_TP6_WIDTH                     1
#define AIPS_PACRB_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP6_SHIFT))&AIPS_PACRB_TP6_MASK)
#define AIPS_PACRB_WP6_MASK                      0x20u
#define AIPS_PACRB_WP6_SHIFT                     5
#define AIPS_PACRB_WP6_WIDTH                     1
#define AIPS_PACRB_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP6_SHIFT))&AIPS_PACRB_WP6_MASK)
#define AIPS_PACRB_SP6_MASK                      0x40u
#define AIPS_PACRB_SP6_SHIFT                     6
#define AIPS_PACRB_SP6_WIDTH                     1
#define AIPS_PACRB_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP6_SHIFT))&AIPS_PACRB_SP6_MASK)
#define AIPS_PACRB_TP5_MASK                      0x100u
#define AIPS_PACRB_TP5_SHIFT                     8
#define AIPS_PACRB_TP5_WIDTH                     1
#define AIPS_PACRB_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP5_SHIFT))&AIPS_PACRB_TP5_MASK)
#define AIPS_PACRB_WP5_MASK                      0x200u
#define AIPS_PACRB_WP5_SHIFT                     9
#define AIPS_PACRB_WP5_WIDTH                     1
#define AIPS_PACRB_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP5_SHIFT))&AIPS_PACRB_WP5_MASK)
#define AIPS_PACRB_SP5_MASK                      0x400u
#define AIPS_PACRB_SP5_SHIFT                     10
#define AIPS_PACRB_SP5_WIDTH                     1
#define AIPS_PACRB_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP5_SHIFT))&AIPS_PACRB_SP5_MASK)
#define AIPS_PACRB_TP4_MASK                      0x1000u
#define AIPS_PACRB_TP4_SHIFT                     12
#define AIPS_PACRB_TP4_WIDTH                     1
#define AIPS_PACRB_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP4_SHIFT))&AIPS_PACRB_TP4_MASK)
#define AIPS_PACRB_WP4_MASK                      0x2000u
#define AIPS_PACRB_WP4_SHIFT                     13
#define AIPS_PACRB_WP4_WIDTH                     1
#define AIPS_PACRB_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP4_SHIFT))&AIPS_PACRB_WP4_MASK)
#define AIPS_PACRB_SP4_MASK                      0x4000u
#define AIPS_PACRB_SP4_SHIFT                     14
#define AIPS_PACRB_SP4_WIDTH                     1
#define AIPS_PACRB_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP4_SHIFT))&AIPS_PACRB_SP4_MASK)
#define AIPS_PACRB_TP3_MASK                      0x10000u
#define AIPS_PACRB_TP3_SHIFT                     16
#define AIPS_PACRB_TP3_WIDTH                     1
#define AIPS_PACRB_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP3_SHIFT))&AIPS_PACRB_TP3_MASK)
#define AIPS_PACRB_WP3_MASK                      0x20000u
#define AIPS_PACRB_WP3_SHIFT                     17
#define AIPS_PACRB_WP3_WIDTH                     1
#define AIPS_PACRB_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP3_SHIFT))&AIPS_PACRB_WP3_MASK)
#define AIPS_PACRB_SP3_MASK                      0x40000u
#define AIPS_PACRB_SP3_SHIFT                     18
#define AIPS_PACRB_SP3_WIDTH                     1
#define AIPS_PACRB_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP3_SHIFT))&AIPS_PACRB_SP3_MASK)
#define AIPS_PACRB_TP2_MASK                      0x100000u
#define AIPS_PACRB_TP2_SHIFT                     20
#define AIPS_PACRB_TP2_WIDTH                     1
#define AIPS_PACRB_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP2_SHIFT))&AIPS_PACRB_TP2_MASK)
#define AIPS_PACRB_WP2_MASK                      0x200000u
#define AIPS_PACRB_WP2_SHIFT                     21
#define AIPS_PACRB_WP2_WIDTH                     1
#define AIPS_PACRB_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP2_SHIFT))&AIPS_PACRB_WP2_MASK)
#define AIPS_PACRB_SP2_MASK                      0x400000u
#define AIPS_PACRB_SP2_SHIFT                     22
#define AIPS_PACRB_SP2_WIDTH                     1
#define AIPS_PACRB_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP2_SHIFT))&AIPS_PACRB_SP2_MASK)
#define AIPS_PACRB_TP1_MASK                      0x1000000u
#define AIPS_PACRB_TP1_SHIFT                     24
#define AIPS_PACRB_TP1_WIDTH                     1
#define AIPS_PACRB_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP1_SHIFT))&AIPS_PACRB_TP1_MASK)
#define AIPS_PACRB_WP1_MASK                      0x2000000u
#define AIPS_PACRB_WP1_SHIFT                     25
#define AIPS_PACRB_WP1_WIDTH                     1
#define AIPS_PACRB_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP1_SHIFT))&AIPS_PACRB_WP1_MASK)
#define AIPS_PACRB_SP1_MASK                      0x4000000u
#define AIPS_PACRB_SP1_SHIFT                     26
#define AIPS_PACRB_SP1_WIDTH                     1
#define AIPS_PACRB_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP1_SHIFT))&AIPS_PACRB_SP1_MASK)
#define AIPS_PACRB_TP0_MASK                      0x10000000u
#define AIPS_PACRB_TP0_SHIFT                     28
#define AIPS_PACRB_TP0_WIDTH                     1
#define AIPS_PACRB_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_TP0_SHIFT))&AIPS_PACRB_TP0_MASK)
#define AIPS_PACRB_WP0_MASK                      0x20000000u
#define AIPS_PACRB_WP0_SHIFT                     29
#define AIPS_PACRB_WP0_WIDTH                     1
#define AIPS_PACRB_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_WP0_SHIFT))&AIPS_PACRB_WP0_MASK)
#define AIPS_PACRB_SP0_MASK                      0x40000000u
#define AIPS_PACRB_SP0_SHIFT                     30
#define AIPS_PACRB_SP0_WIDTH                     1
#define AIPS_PACRB_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRB_SP0_SHIFT))&AIPS_PACRB_SP0_MASK)
/* PACRC Bit Fields */
#define AIPS_PACRC_TP7_MASK                      0x1u
#define AIPS_PACRC_TP7_SHIFT                     0
#define AIPS_PACRC_TP7_WIDTH                     1
#define AIPS_PACRC_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP7_SHIFT))&AIPS_PACRC_TP7_MASK)
#define AIPS_PACRC_WP7_MASK                      0x2u
#define AIPS_PACRC_WP7_SHIFT                     1
#define AIPS_PACRC_WP7_WIDTH                     1
#define AIPS_PACRC_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP7_SHIFT))&AIPS_PACRC_WP7_MASK)
#define AIPS_PACRC_SP7_MASK                      0x4u
#define AIPS_PACRC_SP7_SHIFT                     2
#define AIPS_PACRC_SP7_WIDTH                     1
#define AIPS_PACRC_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP7_SHIFT))&AIPS_PACRC_SP7_MASK)
#define AIPS_PACRC_TP6_MASK                      0x10u
#define AIPS_PACRC_TP6_SHIFT                     4
#define AIPS_PACRC_TP6_WIDTH                     1
#define AIPS_PACRC_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP6_SHIFT))&AIPS_PACRC_TP6_MASK)
#define AIPS_PACRC_WP6_MASK                      0x20u
#define AIPS_PACRC_WP6_SHIFT                     5
#define AIPS_PACRC_WP6_WIDTH                     1
#define AIPS_PACRC_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP6_SHIFT))&AIPS_PACRC_WP6_MASK)
#define AIPS_PACRC_SP6_MASK                      0x40u
#define AIPS_PACRC_SP6_SHIFT                     6
#define AIPS_PACRC_SP6_WIDTH                     1
#define AIPS_PACRC_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP6_SHIFT))&AIPS_PACRC_SP6_MASK)
#define AIPS_PACRC_TP5_MASK                      0x100u
#define AIPS_PACRC_TP5_SHIFT                     8
#define AIPS_PACRC_TP5_WIDTH                     1
#define AIPS_PACRC_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP5_SHIFT))&AIPS_PACRC_TP5_MASK)
#define AIPS_PACRC_WP5_MASK                      0x200u
#define AIPS_PACRC_WP5_SHIFT                     9
#define AIPS_PACRC_WP5_WIDTH                     1
#define AIPS_PACRC_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP5_SHIFT))&AIPS_PACRC_WP5_MASK)
#define AIPS_PACRC_SP5_MASK                      0x400u
#define AIPS_PACRC_SP5_SHIFT                     10
#define AIPS_PACRC_SP5_WIDTH                     1
#define AIPS_PACRC_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP5_SHIFT))&AIPS_PACRC_SP5_MASK)
#define AIPS_PACRC_TP4_MASK                      0x1000u
#define AIPS_PACRC_TP4_SHIFT                     12
#define AIPS_PACRC_TP4_WIDTH                     1
#define AIPS_PACRC_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP4_SHIFT))&AIPS_PACRC_TP4_MASK)
#define AIPS_PACRC_WP4_MASK                      0x2000u
#define AIPS_PACRC_WP4_SHIFT                     13
#define AIPS_PACRC_WP4_WIDTH                     1
#define AIPS_PACRC_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP4_SHIFT))&AIPS_PACRC_WP4_MASK)
#define AIPS_PACRC_SP4_MASK                      0x4000u
#define AIPS_PACRC_SP4_SHIFT                     14
#define AIPS_PACRC_SP4_WIDTH                     1
#define AIPS_PACRC_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP4_SHIFT))&AIPS_PACRC_SP4_MASK)
#define AIPS_PACRC_TP3_MASK                      0x10000u
#define AIPS_PACRC_TP3_SHIFT                     16
#define AIPS_PACRC_TP3_WIDTH                     1
#define AIPS_PACRC_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP3_SHIFT))&AIPS_PACRC_TP3_MASK)
#define AIPS_PACRC_WP3_MASK                      0x20000u
#define AIPS_PACRC_WP3_SHIFT                     17
#define AIPS_PACRC_WP3_WIDTH                     1
#define AIPS_PACRC_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP3_SHIFT))&AIPS_PACRC_WP3_MASK)
#define AIPS_PACRC_SP3_MASK                      0x40000u
#define AIPS_PACRC_SP3_SHIFT                     18
#define AIPS_PACRC_SP3_WIDTH                     1
#define AIPS_PACRC_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP3_SHIFT))&AIPS_PACRC_SP3_MASK)
#define AIPS_PACRC_TP2_MASK                      0x100000u
#define AIPS_PACRC_TP2_SHIFT                     20
#define AIPS_PACRC_TP2_WIDTH                     1
#define AIPS_PACRC_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP2_SHIFT))&AIPS_PACRC_TP2_MASK)
#define AIPS_PACRC_WP2_MASK                      0x200000u
#define AIPS_PACRC_WP2_SHIFT                     21
#define AIPS_PACRC_WP2_WIDTH                     1
#define AIPS_PACRC_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP2_SHIFT))&AIPS_PACRC_WP2_MASK)
#define AIPS_PACRC_SP2_MASK                      0x400000u
#define AIPS_PACRC_SP2_SHIFT                     22
#define AIPS_PACRC_SP2_WIDTH                     1
#define AIPS_PACRC_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP2_SHIFT))&AIPS_PACRC_SP2_MASK)
#define AIPS_PACRC_TP1_MASK                      0x1000000u
#define AIPS_PACRC_TP1_SHIFT                     24
#define AIPS_PACRC_TP1_WIDTH                     1
#define AIPS_PACRC_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP1_SHIFT))&AIPS_PACRC_TP1_MASK)
#define AIPS_PACRC_WP1_MASK                      0x2000000u
#define AIPS_PACRC_WP1_SHIFT                     25
#define AIPS_PACRC_WP1_WIDTH                     1
#define AIPS_PACRC_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP1_SHIFT))&AIPS_PACRC_WP1_MASK)
#define AIPS_PACRC_SP1_MASK                      0x4000000u
#define AIPS_PACRC_SP1_SHIFT                     26
#define AIPS_PACRC_SP1_WIDTH                     1
#define AIPS_PACRC_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP1_SHIFT))&AIPS_PACRC_SP1_MASK)
#define AIPS_PACRC_TP0_MASK                      0x10000000u
#define AIPS_PACRC_TP0_SHIFT                     28
#define AIPS_PACRC_TP0_WIDTH                     1
#define AIPS_PACRC_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_TP0_SHIFT))&AIPS_PACRC_TP0_MASK)
#define AIPS_PACRC_WP0_MASK                      0x20000000u
#define AIPS_PACRC_WP0_SHIFT                     29
#define AIPS_PACRC_WP0_WIDTH                     1
#define AIPS_PACRC_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_WP0_SHIFT))&AIPS_PACRC_WP0_MASK)
#define AIPS_PACRC_SP0_MASK                      0x40000000u
#define AIPS_PACRC_SP0_SHIFT                     30
#define AIPS_PACRC_SP0_WIDTH                     1
#define AIPS_PACRC_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRC_SP0_SHIFT))&AIPS_PACRC_SP0_MASK)
/* PACRD Bit Fields */
#define AIPS_PACRD_TP7_MASK                      0x1u
#define AIPS_PACRD_TP7_SHIFT                     0
#define AIPS_PACRD_TP7_WIDTH                     1
#define AIPS_PACRD_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP7_SHIFT))&AIPS_PACRD_TP7_MASK)
#define AIPS_PACRD_WP7_MASK                      0x2u
#define AIPS_PACRD_WP7_SHIFT                     1
#define AIPS_PACRD_WP7_WIDTH                     1
#define AIPS_PACRD_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP7_SHIFT))&AIPS_PACRD_WP7_MASK)
#define AIPS_PACRD_SP7_MASK                      0x4u
#define AIPS_PACRD_SP7_SHIFT                     2
#define AIPS_PACRD_SP7_WIDTH                     1
#define AIPS_PACRD_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP7_SHIFT))&AIPS_PACRD_SP7_MASK)
#define AIPS_PACRD_TP6_MASK                      0x10u
#define AIPS_PACRD_TP6_SHIFT                     4
#define AIPS_PACRD_TP6_WIDTH                     1
#define AIPS_PACRD_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP6_SHIFT))&AIPS_PACRD_TP6_MASK)
#define AIPS_PACRD_WP6_MASK                      0x20u
#define AIPS_PACRD_WP6_SHIFT                     5
#define AIPS_PACRD_WP6_WIDTH                     1
#define AIPS_PACRD_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP6_SHIFT))&AIPS_PACRD_WP6_MASK)
#define AIPS_PACRD_SP6_MASK                      0x40u
#define AIPS_PACRD_SP6_SHIFT                     6
#define AIPS_PACRD_SP6_WIDTH                     1
#define AIPS_PACRD_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP6_SHIFT))&AIPS_PACRD_SP6_MASK)
#define AIPS_PACRD_TP5_MASK                      0x100u
#define AIPS_PACRD_TP5_SHIFT                     8
#define AIPS_PACRD_TP5_WIDTH                     1
#define AIPS_PACRD_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP5_SHIFT))&AIPS_PACRD_TP5_MASK)
#define AIPS_PACRD_WP5_MASK                      0x200u
#define AIPS_PACRD_WP5_SHIFT                     9
#define AIPS_PACRD_WP5_WIDTH                     1
#define AIPS_PACRD_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP5_SHIFT))&AIPS_PACRD_WP5_MASK)
#define AIPS_PACRD_SP5_MASK                      0x400u
#define AIPS_PACRD_SP5_SHIFT                     10
#define AIPS_PACRD_SP5_WIDTH                     1
#define AIPS_PACRD_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP5_SHIFT))&AIPS_PACRD_SP5_MASK)
#define AIPS_PACRD_TP4_MASK                      0x1000u
#define AIPS_PACRD_TP4_SHIFT                     12
#define AIPS_PACRD_TP4_WIDTH                     1
#define AIPS_PACRD_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP4_SHIFT))&AIPS_PACRD_TP4_MASK)
#define AIPS_PACRD_WP4_MASK                      0x2000u
#define AIPS_PACRD_WP4_SHIFT                     13
#define AIPS_PACRD_WP4_WIDTH                     1
#define AIPS_PACRD_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP4_SHIFT))&AIPS_PACRD_WP4_MASK)
#define AIPS_PACRD_SP4_MASK                      0x4000u
#define AIPS_PACRD_SP4_SHIFT                     14
#define AIPS_PACRD_SP4_WIDTH                     1
#define AIPS_PACRD_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP4_SHIFT))&AIPS_PACRD_SP4_MASK)
#define AIPS_PACRD_TP3_MASK                      0x10000u
#define AIPS_PACRD_TP3_SHIFT                     16
#define AIPS_PACRD_TP3_WIDTH                     1
#define AIPS_PACRD_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP3_SHIFT))&AIPS_PACRD_TP3_MASK)
#define AIPS_PACRD_WP3_MASK                      0x20000u
#define AIPS_PACRD_WP3_SHIFT                     17
#define AIPS_PACRD_WP3_WIDTH                     1
#define AIPS_PACRD_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP3_SHIFT))&AIPS_PACRD_WP3_MASK)
#define AIPS_PACRD_SP3_MASK                      0x40000u
#define AIPS_PACRD_SP3_SHIFT                     18
#define AIPS_PACRD_SP3_WIDTH                     1
#define AIPS_PACRD_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP3_SHIFT))&AIPS_PACRD_SP3_MASK)
#define AIPS_PACRD_TP2_MASK                      0x100000u
#define AIPS_PACRD_TP2_SHIFT                     20
#define AIPS_PACRD_TP2_WIDTH                     1
#define AIPS_PACRD_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP2_SHIFT))&AIPS_PACRD_TP2_MASK)
#define AIPS_PACRD_WP2_MASK                      0x200000u
#define AIPS_PACRD_WP2_SHIFT                     21
#define AIPS_PACRD_WP2_WIDTH                     1
#define AIPS_PACRD_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP2_SHIFT))&AIPS_PACRD_WP2_MASK)
#define AIPS_PACRD_SP2_MASK                      0x400000u
#define AIPS_PACRD_SP2_SHIFT                     22
#define AIPS_PACRD_SP2_WIDTH                     1
#define AIPS_PACRD_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP2_SHIFT))&AIPS_PACRD_SP2_MASK)
#define AIPS_PACRD_TP1_MASK                      0x1000000u
#define AIPS_PACRD_TP1_SHIFT                     24
#define AIPS_PACRD_TP1_WIDTH                     1
#define AIPS_PACRD_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP1_SHIFT))&AIPS_PACRD_TP1_MASK)
#define AIPS_PACRD_WP1_MASK                      0x2000000u
#define AIPS_PACRD_WP1_SHIFT                     25
#define AIPS_PACRD_WP1_WIDTH                     1
#define AIPS_PACRD_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP1_SHIFT))&AIPS_PACRD_WP1_MASK)
#define AIPS_PACRD_SP1_MASK                      0x4000000u
#define AIPS_PACRD_SP1_SHIFT                     26
#define AIPS_PACRD_SP1_WIDTH                     1
#define AIPS_PACRD_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP1_SHIFT))&AIPS_PACRD_SP1_MASK)
#define AIPS_PACRD_TP0_MASK                      0x10000000u
#define AIPS_PACRD_TP0_SHIFT                     28
#define AIPS_PACRD_TP0_WIDTH                     1
#define AIPS_PACRD_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_TP0_SHIFT))&AIPS_PACRD_TP0_MASK)
#define AIPS_PACRD_WP0_MASK                      0x20000000u
#define AIPS_PACRD_WP0_SHIFT                     29
#define AIPS_PACRD_WP0_WIDTH                     1
#define AIPS_PACRD_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_WP0_SHIFT))&AIPS_PACRD_WP0_MASK)
#define AIPS_PACRD_SP0_MASK                      0x40000000u
#define AIPS_PACRD_SP0_SHIFT                     30
#define AIPS_PACRD_SP0_WIDTH                     1
#define AIPS_PACRD_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRD_SP0_SHIFT))&AIPS_PACRD_SP0_MASK)
/* PACRE Bit Fields */
#define AIPS_PACRE_TP7_MASK                      0x1u
#define AIPS_PACRE_TP7_SHIFT                     0
#define AIPS_PACRE_TP7_WIDTH                     1
#define AIPS_PACRE_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP7_SHIFT))&AIPS_PACRE_TP7_MASK)
#define AIPS_PACRE_WP7_MASK                      0x2u
#define AIPS_PACRE_WP7_SHIFT                     1
#define AIPS_PACRE_WP7_WIDTH                     1
#define AIPS_PACRE_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP7_SHIFT))&AIPS_PACRE_WP7_MASK)
#define AIPS_PACRE_SP7_MASK                      0x4u
#define AIPS_PACRE_SP7_SHIFT                     2
#define AIPS_PACRE_SP7_WIDTH                     1
#define AIPS_PACRE_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP7_SHIFT))&AIPS_PACRE_SP7_MASK)
#define AIPS_PACRE_TP6_MASK                      0x10u
#define AIPS_PACRE_TP6_SHIFT                     4
#define AIPS_PACRE_TP6_WIDTH                     1
#define AIPS_PACRE_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP6_SHIFT))&AIPS_PACRE_TP6_MASK)
#define AIPS_PACRE_WP6_MASK                      0x20u
#define AIPS_PACRE_WP6_SHIFT                     5
#define AIPS_PACRE_WP6_WIDTH                     1
#define AIPS_PACRE_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP6_SHIFT))&AIPS_PACRE_WP6_MASK)
#define AIPS_PACRE_SP6_MASK                      0x40u
#define AIPS_PACRE_SP6_SHIFT                     6
#define AIPS_PACRE_SP6_WIDTH                     1
#define AIPS_PACRE_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP6_SHIFT))&AIPS_PACRE_SP6_MASK)
#define AIPS_PACRE_TP5_MASK                      0x100u
#define AIPS_PACRE_TP5_SHIFT                     8
#define AIPS_PACRE_TP5_WIDTH                     1
#define AIPS_PACRE_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP5_SHIFT))&AIPS_PACRE_TP5_MASK)
#define AIPS_PACRE_WP5_MASK                      0x200u
#define AIPS_PACRE_WP5_SHIFT                     9
#define AIPS_PACRE_WP5_WIDTH                     1
#define AIPS_PACRE_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP5_SHIFT))&AIPS_PACRE_WP5_MASK)
#define AIPS_PACRE_SP5_MASK                      0x400u
#define AIPS_PACRE_SP5_SHIFT                     10
#define AIPS_PACRE_SP5_WIDTH                     1
#define AIPS_PACRE_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP5_SHIFT))&AIPS_PACRE_SP5_MASK)
#define AIPS_PACRE_TP4_MASK                      0x1000u
#define AIPS_PACRE_TP4_SHIFT                     12
#define AIPS_PACRE_TP4_WIDTH                     1
#define AIPS_PACRE_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP4_SHIFT))&AIPS_PACRE_TP4_MASK)
#define AIPS_PACRE_WP4_MASK                      0x2000u
#define AIPS_PACRE_WP4_SHIFT                     13
#define AIPS_PACRE_WP4_WIDTH                     1
#define AIPS_PACRE_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP4_SHIFT))&AIPS_PACRE_WP4_MASK)
#define AIPS_PACRE_SP4_MASK                      0x4000u
#define AIPS_PACRE_SP4_SHIFT                     14
#define AIPS_PACRE_SP4_WIDTH                     1
#define AIPS_PACRE_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP4_SHIFT))&AIPS_PACRE_SP4_MASK)
#define AIPS_PACRE_TP3_MASK                      0x10000u
#define AIPS_PACRE_TP3_SHIFT                     16
#define AIPS_PACRE_TP3_WIDTH                     1
#define AIPS_PACRE_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP3_SHIFT))&AIPS_PACRE_TP3_MASK)
#define AIPS_PACRE_WP3_MASK                      0x20000u
#define AIPS_PACRE_WP3_SHIFT                     17
#define AIPS_PACRE_WP3_WIDTH                     1
#define AIPS_PACRE_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP3_SHIFT))&AIPS_PACRE_WP3_MASK)
#define AIPS_PACRE_SP3_MASK                      0x40000u
#define AIPS_PACRE_SP3_SHIFT                     18
#define AIPS_PACRE_SP3_WIDTH                     1
#define AIPS_PACRE_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP3_SHIFT))&AIPS_PACRE_SP3_MASK)
#define AIPS_PACRE_TP2_MASK                      0x100000u
#define AIPS_PACRE_TP2_SHIFT                     20
#define AIPS_PACRE_TP2_WIDTH                     1
#define AIPS_PACRE_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP2_SHIFT))&AIPS_PACRE_TP2_MASK)
#define AIPS_PACRE_WP2_MASK                      0x200000u
#define AIPS_PACRE_WP2_SHIFT                     21
#define AIPS_PACRE_WP2_WIDTH                     1
#define AIPS_PACRE_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP2_SHIFT))&AIPS_PACRE_WP2_MASK)
#define AIPS_PACRE_SP2_MASK                      0x400000u
#define AIPS_PACRE_SP2_SHIFT                     22
#define AIPS_PACRE_SP2_WIDTH                     1
#define AIPS_PACRE_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP2_SHIFT))&AIPS_PACRE_SP2_MASK)
#define AIPS_PACRE_TP1_MASK                      0x1000000u
#define AIPS_PACRE_TP1_SHIFT                     24
#define AIPS_PACRE_TP1_WIDTH                     1
#define AIPS_PACRE_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP1_SHIFT))&AIPS_PACRE_TP1_MASK)
#define AIPS_PACRE_WP1_MASK                      0x2000000u
#define AIPS_PACRE_WP1_SHIFT                     25
#define AIPS_PACRE_WP1_WIDTH                     1
#define AIPS_PACRE_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP1_SHIFT))&AIPS_PACRE_WP1_MASK)
#define AIPS_PACRE_SP1_MASK                      0x4000000u
#define AIPS_PACRE_SP1_SHIFT                     26
#define AIPS_PACRE_SP1_WIDTH                     1
#define AIPS_PACRE_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP1_SHIFT))&AIPS_PACRE_SP1_MASK)
#define AIPS_PACRE_TP0_MASK                      0x10000000u
#define AIPS_PACRE_TP0_SHIFT                     28
#define AIPS_PACRE_TP0_WIDTH                     1
#define AIPS_PACRE_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_TP0_SHIFT))&AIPS_PACRE_TP0_MASK)
#define AIPS_PACRE_WP0_MASK                      0x20000000u
#define AIPS_PACRE_WP0_SHIFT                     29
#define AIPS_PACRE_WP0_WIDTH                     1
#define AIPS_PACRE_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_WP0_SHIFT))&AIPS_PACRE_WP0_MASK)
#define AIPS_PACRE_SP0_MASK                      0x40000000u
#define AIPS_PACRE_SP0_SHIFT                     30
#define AIPS_PACRE_SP0_WIDTH                     1
#define AIPS_PACRE_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRE_SP0_SHIFT))&AIPS_PACRE_SP0_MASK)
/* PACRF Bit Fields */
#define AIPS_PACRF_TP7_MASK                      0x1u
#define AIPS_PACRF_TP7_SHIFT                     0
#define AIPS_PACRF_TP7_WIDTH                     1
#define AIPS_PACRF_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP7_SHIFT))&AIPS_PACRF_TP7_MASK)
#define AIPS_PACRF_WP7_MASK                      0x2u
#define AIPS_PACRF_WP7_SHIFT                     1
#define AIPS_PACRF_WP7_WIDTH                     1
#define AIPS_PACRF_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP7_SHIFT))&AIPS_PACRF_WP7_MASK)
#define AIPS_PACRF_SP7_MASK                      0x4u
#define AIPS_PACRF_SP7_SHIFT                     2
#define AIPS_PACRF_SP7_WIDTH                     1
#define AIPS_PACRF_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP7_SHIFT))&AIPS_PACRF_SP7_MASK)
#define AIPS_PACRF_TP6_MASK                      0x10u
#define AIPS_PACRF_TP6_SHIFT                     4
#define AIPS_PACRF_TP6_WIDTH                     1
#define AIPS_PACRF_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP6_SHIFT))&AIPS_PACRF_TP6_MASK)
#define AIPS_PACRF_WP6_MASK                      0x20u
#define AIPS_PACRF_WP6_SHIFT                     5
#define AIPS_PACRF_WP6_WIDTH                     1
#define AIPS_PACRF_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP6_SHIFT))&AIPS_PACRF_WP6_MASK)
#define AIPS_PACRF_SP6_MASK                      0x40u
#define AIPS_PACRF_SP6_SHIFT                     6
#define AIPS_PACRF_SP6_WIDTH                     1
#define AIPS_PACRF_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP6_SHIFT))&AIPS_PACRF_SP6_MASK)
#define AIPS_PACRF_TP5_MASK                      0x100u
#define AIPS_PACRF_TP5_SHIFT                     8
#define AIPS_PACRF_TP5_WIDTH                     1
#define AIPS_PACRF_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP5_SHIFT))&AIPS_PACRF_TP5_MASK)
#define AIPS_PACRF_WP5_MASK                      0x200u
#define AIPS_PACRF_WP5_SHIFT                     9
#define AIPS_PACRF_WP5_WIDTH                     1
#define AIPS_PACRF_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP5_SHIFT))&AIPS_PACRF_WP5_MASK)
#define AIPS_PACRF_SP5_MASK                      0x400u
#define AIPS_PACRF_SP5_SHIFT                     10
#define AIPS_PACRF_SP5_WIDTH                     1
#define AIPS_PACRF_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP5_SHIFT))&AIPS_PACRF_SP5_MASK)
#define AIPS_PACRF_TP4_MASK                      0x1000u
#define AIPS_PACRF_TP4_SHIFT                     12
#define AIPS_PACRF_TP4_WIDTH                     1
#define AIPS_PACRF_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP4_SHIFT))&AIPS_PACRF_TP4_MASK)
#define AIPS_PACRF_WP4_MASK                      0x2000u
#define AIPS_PACRF_WP4_SHIFT                     13
#define AIPS_PACRF_WP4_WIDTH                     1
#define AIPS_PACRF_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP4_SHIFT))&AIPS_PACRF_WP4_MASK)
#define AIPS_PACRF_SP4_MASK                      0x4000u
#define AIPS_PACRF_SP4_SHIFT                     14
#define AIPS_PACRF_SP4_WIDTH                     1
#define AIPS_PACRF_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP4_SHIFT))&AIPS_PACRF_SP4_MASK)
#define AIPS_PACRF_TP3_MASK                      0x10000u
#define AIPS_PACRF_TP3_SHIFT                     16
#define AIPS_PACRF_TP3_WIDTH                     1
#define AIPS_PACRF_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP3_SHIFT))&AIPS_PACRF_TP3_MASK)
#define AIPS_PACRF_WP3_MASK                      0x20000u
#define AIPS_PACRF_WP3_SHIFT                     17
#define AIPS_PACRF_WP3_WIDTH                     1
#define AIPS_PACRF_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP3_SHIFT))&AIPS_PACRF_WP3_MASK)
#define AIPS_PACRF_SP3_MASK                      0x40000u
#define AIPS_PACRF_SP3_SHIFT                     18
#define AIPS_PACRF_SP3_WIDTH                     1
#define AIPS_PACRF_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP3_SHIFT))&AIPS_PACRF_SP3_MASK)
#define AIPS_PACRF_TP2_MASK                      0x100000u
#define AIPS_PACRF_TP2_SHIFT                     20
#define AIPS_PACRF_TP2_WIDTH                     1
#define AIPS_PACRF_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP2_SHIFT))&AIPS_PACRF_TP2_MASK)
#define AIPS_PACRF_WP2_MASK                      0x200000u
#define AIPS_PACRF_WP2_SHIFT                     21
#define AIPS_PACRF_WP2_WIDTH                     1
#define AIPS_PACRF_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP2_SHIFT))&AIPS_PACRF_WP2_MASK)
#define AIPS_PACRF_SP2_MASK                      0x400000u
#define AIPS_PACRF_SP2_SHIFT                     22
#define AIPS_PACRF_SP2_WIDTH                     1
#define AIPS_PACRF_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP2_SHIFT))&AIPS_PACRF_SP2_MASK)
#define AIPS_PACRF_TP1_MASK                      0x1000000u
#define AIPS_PACRF_TP1_SHIFT                     24
#define AIPS_PACRF_TP1_WIDTH                     1
#define AIPS_PACRF_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP1_SHIFT))&AIPS_PACRF_TP1_MASK)
#define AIPS_PACRF_WP1_MASK                      0x2000000u
#define AIPS_PACRF_WP1_SHIFT                     25
#define AIPS_PACRF_WP1_WIDTH                     1
#define AIPS_PACRF_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP1_SHIFT))&AIPS_PACRF_WP1_MASK)
#define AIPS_PACRF_SP1_MASK                      0x4000000u
#define AIPS_PACRF_SP1_SHIFT                     26
#define AIPS_PACRF_SP1_WIDTH                     1
#define AIPS_PACRF_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP1_SHIFT))&AIPS_PACRF_SP1_MASK)
#define AIPS_PACRF_TP0_MASK                      0x10000000u
#define AIPS_PACRF_TP0_SHIFT                     28
#define AIPS_PACRF_TP0_WIDTH                     1
#define AIPS_PACRF_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_TP0_SHIFT))&AIPS_PACRF_TP0_MASK)
#define AIPS_PACRF_WP0_MASK                      0x20000000u
#define AIPS_PACRF_WP0_SHIFT                     29
#define AIPS_PACRF_WP0_WIDTH                     1
#define AIPS_PACRF_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_WP0_SHIFT))&AIPS_PACRF_WP0_MASK)
#define AIPS_PACRF_SP0_MASK                      0x40000000u
#define AIPS_PACRF_SP0_SHIFT                     30
#define AIPS_PACRF_SP0_WIDTH                     1
#define AIPS_PACRF_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRF_SP0_SHIFT))&AIPS_PACRF_SP0_MASK)
/* PACRG Bit Fields */
#define AIPS_PACRG_TP7_MASK                      0x1u
#define AIPS_PACRG_TP7_SHIFT                     0
#define AIPS_PACRG_TP7_WIDTH                     1
#define AIPS_PACRG_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP7_SHIFT))&AIPS_PACRG_TP7_MASK)
#define AIPS_PACRG_WP7_MASK                      0x2u
#define AIPS_PACRG_WP7_SHIFT                     1
#define AIPS_PACRG_WP7_WIDTH                     1
#define AIPS_PACRG_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP7_SHIFT))&AIPS_PACRG_WP7_MASK)
#define AIPS_PACRG_SP7_MASK                      0x4u
#define AIPS_PACRG_SP7_SHIFT                     2
#define AIPS_PACRG_SP7_WIDTH                     1
#define AIPS_PACRG_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP7_SHIFT))&AIPS_PACRG_SP7_MASK)
#define AIPS_PACRG_TP6_MASK                      0x10u
#define AIPS_PACRG_TP6_SHIFT                     4
#define AIPS_PACRG_TP6_WIDTH                     1
#define AIPS_PACRG_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP6_SHIFT))&AIPS_PACRG_TP6_MASK)
#define AIPS_PACRG_WP6_MASK                      0x20u
#define AIPS_PACRG_WP6_SHIFT                     5
#define AIPS_PACRG_WP6_WIDTH                     1
#define AIPS_PACRG_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP6_SHIFT))&AIPS_PACRG_WP6_MASK)
#define AIPS_PACRG_SP6_MASK                      0x40u
#define AIPS_PACRG_SP6_SHIFT                     6
#define AIPS_PACRG_SP6_WIDTH                     1
#define AIPS_PACRG_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP6_SHIFT))&AIPS_PACRG_SP6_MASK)
#define AIPS_PACRG_TP5_MASK                      0x100u
#define AIPS_PACRG_TP5_SHIFT                     8
#define AIPS_PACRG_TP5_WIDTH                     1
#define AIPS_PACRG_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP5_SHIFT))&AIPS_PACRG_TP5_MASK)
#define AIPS_PACRG_WP5_MASK                      0x200u
#define AIPS_PACRG_WP5_SHIFT                     9
#define AIPS_PACRG_WP5_WIDTH                     1
#define AIPS_PACRG_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP5_SHIFT))&AIPS_PACRG_WP5_MASK)
#define AIPS_PACRG_SP5_MASK                      0x400u
#define AIPS_PACRG_SP5_SHIFT                     10
#define AIPS_PACRG_SP5_WIDTH                     1
#define AIPS_PACRG_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP5_SHIFT))&AIPS_PACRG_SP5_MASK)
#define AIPS_PACRG_TP4_MASK                      0x1000u
#define AIPS_PACRG_TP4_SHIFT                     12
#define AIPS_PACRG_TP4_WIDTH                     1
#define AIPS_PACRG_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP4_SHIFT))&AIPS_PACRG_TP4_MASK)
#define AIPS_PACRG_WP4_MASK                      0x2000u
#define AIPS_PACRG_WP4_SHIFT                     13
#define AIPS_PACRG_WP4_WIDTH                     1
#define AIPS_PACRG_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP4_SHIFT))&AIPS_PACRG_WP4_MASK)
#define AIPS_PACRG_SP4_MASK                      0x4000u
#define AIPS_PACRG_SP4_SHIFT                     14
#define AIPS_PACRG_SP4_WIDTH                     1
#define AIPS_PACRG_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP4_SHIFT))&AIPS_PACRG_SP4_MASK)
#define AIPS_PACRG_TP3_MASK                      0x10000u
#define AIPS_PACRG_TP3_SHIFT                     16
#define AIPS_PACRG_TP3_WIDTH                     1
#define AIPS_PACRG_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP3_SHIFT))&AIPS_PACRG_TP3_MASK)
#define AIPS_PACRG_WP3_MASK                      0x20000u
#define AIPS_PACRG_WP3_SHIFT                     17
#define AIPS_PACRG_WP3_WIDTH                     1
#define AIPS_PACRG_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP3_SHIFT))&AIPS_PACRG_WP3_MASK)
#define AIPS_PACRG_SP3_MASK                      0x40000u
#define AIPS_PACRG_SP3_SHIFT                     18
#define AIPS_PACRG_SP3_WIDTH                     1
#define AIPS_PACRG_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP3_SHIFT))&AIPS_PACRG_SP3_MASK)
#define AIPS_PACRG_TP2_MASK                      0x100000u
#define AIPS_PACRG_TP2_SHIFT                     20
#define AIPS_PACRG_TP2_WIDTH                     1
#define AIPS_PACRG_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP2_SHIFT))&AIPS_PACRG_TP2_MASK)
#define AIPS_PACRG_WP2_MASK                      0x200000u
#define AIPS_PACRG_WP2_SHIFT                     21
#define AIPS_PACRG_WP2_WIDTH                     1
#define AIPS_PACRG_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP2_SHIFT))&AIPS_PACRG_WP2_MASK)
#define AIPS_PACRG_SP2_MASK                      0x400000u
#define AIPS_PACRG_SP2_SHIFT                     22
#define AIPS_PACRG_SP2_WIDTH                     1
#define AIPS_PACRG_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP2_SHIFT))&AIPS_PACRG_SP2_MASK)
#define AIPS_PACRG_TP1_MASK                      0x1000000u
#define AIPS_PACRG_TP1_SHIFT                     24
#define AIPS_PACRG_TP1_WIDTH                     1
#define AIPS_PACRG_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP1_SHIFT))&AIPS_PACRG_TP1_MASK)
#define AIPS_PACRG_WP1_MASK                      0x2000000u
#define AIPS_PACRG_WP1_SHIFT                     25
#define AIPS_PACRG_WP1_WIDTH                     1
#define AIPS_PACRG_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP1_SHIFT))&AIPS_PACRG_WP1_MASK)
#define AIPS_PACRG_SP1_MASK                      0x4000000u
#define AIPS_PACRG_SP1_SHIFT                     26
#define AIPS_PACRG_SP1_WIDTH                     1
#define AIPS_PACRG_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP1_SHIFT))&AIPS_PACRG_SP1_MASK)
#define AIPS_PACRG_TP0_MASK                      0x10000000u
#define AIPS_PACRG_TP0_SHIFT                     28
#define AIPS_PACRG_TP0_WIDTH                     1
#define AIPS_PACRG_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_TP0_SHIFT))&AIPS_PACRG_TP0_MASK)
#define AIPS_PACRG_WP0_MASK                      0x20000000u
#define AIPS_PACRG_WP0_SHIFT                     29
#define AIPS_PACRG_WP0_WIDTH                     1
#define AIPS_PACRG_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_WP0_SHIFT))&AIPS_PACRG_WP0_MASK)
#define AIPS_PACRG_SP0_MASK                      0x40000000u
#define AIPS_PACRG_SP0_SHIFT                     30
#define AIPS_PACRG_SP0_WIDTH                     1
#define AIPS_PACRG_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRG_SP0_SHIFT))&AIPS_PACRG_SP0_MASK)
/* PACRH Bit Fields */
#define AIPS_PACRH_TP7_MASK                      0x1u
#define AIPS_PACRH_TP7_SHIFT                     0
#define AIPS_PACRH_TP7_WIDTH                     1
#define AIPS_PACRH_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP7_SHIFT))&AIPS_PACRH_TP7_MASK)
#define AIPS_PACRH_WP7_MASK                      0x2u
#define AIPS_PACRH_WP7_SHIFT                     1
#define AIPS_PACRH_WP7_WIDTH                     1
#define AIPS_PACRH_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP7_SHIFT))&AIPS_PACRH_WP7_MASK)
#define AIPS_PACRH_SP7_MASK                      0x4u
#define AIPS_PACRH_SP7_SHIFT                     2
#define AIPS_PACRH_SP7_WIDTH                     1
#define AIPS_PACRH_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP7_SHIFT))&AIPS_PACRH_SP7_MASK)
#define AIPS_PACRH_TP6_MASK                      0x10u
#define AIPS_PACRH_TP6_SHIFT                     4
#define AIPS_PACRH_TP6_WIDTH                     1
#define AIPS_PACRH_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP6_SHIFT))&AIPS_PACRH_TP6_MASK)
#define AIPS_PACRH_WP6_MASK                      0x20u
#define AIPS_PACRH_WP6_SHIFT                     5
#define AIPS_PACRH_WP6_WIDTH                     1
#define AIPS_PACRH_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP6_SHIFT))&AIPS_PACRH_WP6_MASK)
#define AIPS_PACRH_SP6_MASK                      0x40u
#define AIPS_PACRH_SP6_SHIFT                     6
#define AIPS_PACRH_SP6_WIDTH                     1
#define AIPS_PACRH_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP6_SHIFT))&AIPS_PACRH_SP6_MASK)
#define AIPS_PACRH_TP5_MASK                      0x100u
#define AIPS_PACRH_TP5_SHIFT                     8
#define AIPS_PACRH_TP5_WIDTH                     1
#define AIPS_PACRH_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP5_SHIFT))&AIPS_PACRH_TP5_MASK)
#define AIPS_PACRH_WP5_MASK                      0x200u
#define AIPS_PACRH_WP5_SHIFT                     9
#define AIPS_PACRH_WP5_WIDTH                     1
#define AIPS_PACRH_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP5_SHIFT))&AIPS_PACRH_WP5_MASK)
#define AIPS_PACRH_SP5_MASK                      0x400u
#define AIPS_PACRH_SP5_SHIFT                     10
#define AIPS_PACRH_SP5_WIDTH                     1
#define AIPS_PACRH_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP5_SHIFT))&AIPS_PACRH_SP5_MASK)
#define AIPS_PACRH_TP4_MASK                      0x1000u
#define AIPS_PACRH_TP4_SHIFT                     12
#define AIPS_PACRH_TP4_WIDTH                     1
#define AIPS_PACRH_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP4_SHIFT))&AIPS_PACRH_TP4_MASK)
#define AIPS_PACRH_WP4_MASK                      0x2000u
#define AIPS_PACRH_WP4_SHIFT                     13
#define AIPS_PACRH_WP4_WIDTH                     1
#define AIPS_PACRH_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP4_SHIFT))&AIPS_PACRH_WP4_MASK)
#define AIPS_PACRH_SP4_MASK                      0x4000u
#define AIPS_PACRH_SP4_SHIFT                     14
#define AIPS_PACRH_SP4_WIDTH                     1
#define AIPS_PACRH_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP4_SHIFT))&AIPS_PACRH_SP4_MASK)
#define AIPS_PACRH_TP3_MASK                      0x10000u
#define AIPS_PACRH_TP3_SHIFT                     16
#define AIPS_PACRH_TP3_WIDTH                     1
#define AIPS_PACRH_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP3_SHIFT))&AIPS_PACRH_TP3_MASK)
#define AIPS_PACRH_WP3_MASK                      0x20000u
#define AIPS_PACRH_WP3_SHIFT                     17
#define AIPS_PACRH_WP3_WIDTH                     1
#define AIPS_PACRH_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP3_SHIFT))&AIPS_PACRH_WP3_MASK)
#define AIPS_PACRH_SP3_MASK                      0x40000u
#define AIPS_PACRH_SP3_SHIFT                     18
#define AIPS_PACRH_SP3_WIDTH                     1
#define AIPS_PACRH_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP3_SHIFT))&AIPS_PACRH_SP3_MASK)
#define AIPS_PACRH_TP2_MASK                      0x100000u
#define AIPS_PACRH_TP2_SHIFT                     20
#define AIPS_PACRH_TP2_WIDTH                     1
#define AIPS_PACRH_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP2_SHIFT))&AIPS_PACRH_TP2_MASK)
#define AIPS_PACRH_WP2_MASK                      0x200000u
#define AIPS_PACRH_WP2_SHIFT                     21
#define AIPS_PACRH_WP2_WIDTH                     1
#define AIPS_PACRH_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP2_SHIFT))&AIPS_PACRH_WP2_MASK)
#define AIPS_PACRH_SP2_MASK                      0x400000u
#define AIPS_PACRH_SP2_SHIFT                     22
#define AIPS_PACRH_SP2_WIDTH                     1
#define AIPS_PACRH_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP2_SHIFT))&AIPS_PACRH_SP2_MASK)
#define AIPS_PACRH_TP1_MASK                      0x1000000u
#define AIPS_PACRH_TP1_SHIFT                     24
#define AIPS_PACRH_TP1_WIDTH                     1
#define AIPS_PACRH_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP1_SHIFT))&AIPS_PACRH_TP1_MASK)
#define AIPS_PACRH_WP1_MASK                      0x2000000u
#define AIPS_PACRH_WP1_SHIFT                     25
#define AIPS_PACRH_WP1_WIDTH                     1
#define AIPS_PACRH_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP1_SHIFT))&AIPS_PACRH_WP1_MASK)
#define AIPS_PACRH_SP1_MASK                      0x4000000u
#define AIPS_PACRH_SP1_SHIFT                     26
#define AIPS_PACRH_SP1_WIDTH                     1
#define AIPS_PACRH_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP1_SHIFT))&AIPS_PACRH_SP1_MASK)
#define AIPS_PACRH_TP0_MASK                      0x10000000u
#define AIPS_PACRH_TP0_SHIFT                     28
#define AIPS_PACRH_TP0_WIDTH                     1
#define AIPS_PACRH_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_TP0_SHIFT))&AIPS_PACRH_TP0_MASK)
#define AIPS_PACRH_WP0_MASK                      0x20000000u
#define AIPS_PACRH_WP0_SHIFT                     29
#define AIPS_PACRH_WP0_WIDTH                     1
#define AIPS_PACRH_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_WP0_SHIFT))&AIPS_PACRH_WP0_MASK)
#define AIPS_PACRH_SP0_MASK                      0x40000000u
#define AIPS_PACRH_SP0_SHIFT                     30
#define AIPS_PACRH_SP0_WIDTH                     1
#define AIPS_PACRH_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRH_SP0_SHIFT))&AIPS_PACRH_SP0_MASK)
/* PACRI Bit Fields */
#define AIPS_PACRI_TP7_MASK                      0x1u
#define AIPS_PACRI_TP7_SHIFT                     0
#define AIPS_PACRI_TP7_WIDTH                     1
#define AIPS_PACRI_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP7_SHIFT))&AIPS_PACRI_TP7_MASK)
#define AIPS_PACRI_WP7_MASK                      0x2u
#define AIPS_PACRI_WP7_SHIFT                     1
#define AIPS_PACRI_WP7_WIDTH                     1
#define AIPS_PACRI_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP7_SHIFT))&AIPS_PACRI_WP7_MASK)
#define AIPS_PACRI_SP7_MASK                      0x4u
#define AIPS_PACRI_SP7_SHIFT                     2
#define AIPS_PACRI_SP7_WIDTH                     1
#define AIPS_PACRI_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP7_SHIFT))&AIPS_PACRI_SP7_MASK)
#define AIPS_PACRI_TP6_MASK                      0x10u
#define AIPS_PACRI_TP6_SHIFT                     4
#define AIPS_PACRI_TP6_WIDTH                     1
#define AIPS_PACRI_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP6_SHIFT))&AIPS_PACRI_TP6_MASK)
#define AIPS_PACRI_WP6_MASK                      0x20u
#define AIPS_PACRI_WP6_SHIFT                     5
#define AIPS_PACRI_WP6_WIDTH                     1
#define AIPS_PACRI_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP6_SHIFT))&AIPS_PACRI_WP6_MASK)
#define AIPS_PACRI_SP6_MASK                      0x40u
#define AIPS_PACRI_SP6_SHIFT                     6
#define AIPS_PACRI_SP6_WIDTH                     1
#define AIPS_PACRI_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP6_SHIFT))&AIPS_PACRI_SP6_MASK)
#define AIPS_PACRI_TP5_MASK                      0x100u
#define AIPS_PACRI_TP5_SHIFT                     8
#define AIPS_PACRI_TP5_WIDTH                     1
#define AIPS_PACRI_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP5_SHIFT))&AIPS_PACRI_TP5_MASK)
#define AIPS_PACRI_WP5_MASK                      0x200u
#define AIPS_PACRI_WP5_SHIFT                     9
#define AIPS_PACRI_WP5_WIDTH                     1
#define AIPS_PACRI_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP5_SHIFT))&AIPS_PACRI_WP5_MASK)
#define AIPS_PACRI_SP5_MASK                      0x400u
#define AIPS_PACRI_SP5_SHIFT                     10
#define AIPS_PACRI_SP5_WIDTH                     1
#define AIPS_PACRI_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP5_SHIFT))&AIPS_PACRI_SP5_MASK)
#define AIPS_PACRI_TP4_MASK                      0x1000u
#define AIPS_PACRI_TP4_SHIFT                     12
#define AIPS_PACRI_TP4_WIDTH                     1
#define AIPS_PACRI_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP4_SHIFT))&AIPS_PACRI_TP4_MASK)
#define AIPS_PACRI_WP4_MASK                      0x2000u
#define AIPS_PACRI_WP4_SHIFT                     13
#define AIPS_PACRI_WP4_WIDTH                     1
#define AIPS_PACRI_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP4_SHIFT))&AIPS_PACRI_WP4_MASK)
#define AIPS_PACRI_SP4_MASK                      0x4000u
#define AIPS_PACRI_SP4_SHIFT                     14
#define AIPS_PACRI_SP4_WIDTH                     1
#define AIPS_PACRI_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP4_SHIFT))&AIPS_PACRI_SP4_MASK)
#define AIPS_PACRI_TP3_MASK                      0x10000u
#define AIPS_PACRI_TP3_SHIFT                     16
#define AIPS_PACRI_TP3_WIDTH                     1
#define AIPS_PACRI_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP3_SHIFT))&AIPS_PACRI_TP3_MASK)
#define AIPS_PACRI_WP3_MASK                      0x20000u
#define AIPS_PACRI_WP3_SHIFT                     17
#define AIPS_PACRI_WP3_WIDTH                     1
#define AIPS_PACRI_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP3_SHIFT))&AIPS_PACRI_WP3_MASK)
#define AIPS_PACRI_SP3_MASK                      0x40000u
#define AIPS_PACRI_SP3_SHIFT                     18
#define AIPS_PACRI_SP3_WIDTH                     1
#define AIPS_PACRI_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP3_SHIFT))&AIPS_PACRI_SP3_MASK)
#define AIPS_PACRI_TP2_MASK                      0x100000u
#define AIPS_PACRI_TP2_SHIFT                     20
#define AIPS_PACRI_TP2_WIDTH                     1
#define AIPS_PACRI_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP2_SHIFT))&AIPS_PACRI_TP2_MASK)
#define AIPS_PACRI_WP2_MASK                      0x200000u
#define AIPS_PACRI_WP2_SHIFT                     21
#define AIPS_PACRI_WP2_WIDTH                     1
#define AIPS_PACRI_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP2_SHIFT))&AIPS_PACRI_WP2_MASK)
#define AIPS_PACRI_SP2_MASK                      0x400000u
#define AIPS_PACRI_SP2_SHIFT                     22
#define AIPS_PACRI_SP2_WIDTH                     1
#define AIPS_PACRI_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP2_SHIFT))&AIPS_PACRI_SP2_MASK)
#define AIPS_PACRI_TP1_MASK                      0x1000000u
#define AIPS_PACRI_TP1_SHIFT                     24
#define AIPS_PACRI_TP1_WIDTH                     1
#define AIPS_PACRI_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP1_SHIFT))&AIPS_PACRI_TP1_MASK)
#define AIPS_PACRI_WP1_MASK                      0x2000000u
#define AIPS_PACRI_WP1_SHIFT                     25
#define AIPS_PACRI_WP1_WIDTH                     1
#define AIPS_PACRI_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP1_SHIFT))&AIPS_PACRI_WP1_MASK)
#define AIPS_PACRI_SP1_MASK                      0x4000000u
#define AIPS_PACRI_SP1_SHIFT                     26
#define AIPS_PACRI_SP1_WIDTH                     1
#define AIPS_PACRI_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP1_SHIFT))&AIPS_PACRI_SP1_MASK)
#define AIPS_PACRI_TP0_MASK                      0x10000000u
#define AIPS_PACRI_TP0_SHIFT                     28
#define AIPS_PACRI_TP0_WIDTH                     1
#define AIPS_PACRI_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_TP0_SHIFT))&AIPS_PACRI_TP0_MASK)
#define AIPS_PACRI_WP0_MASK                      0x20000000u
#define AIPS_PACRI_WP0_SHIFT                     29
#define AIPS_PACRI_WP0_WIDTH                     1
#define AIPS_PACRI_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_WP0_SHIFT))&AIPS_PACRI_WP0_MASK)
#define AIPS_PACRI_SP0_MASK                      0x40000000u
#define AIPS_PACRI_SP0_SHIFT                     30
#define AIPS_PACRI_SP0_WIDTH                     1
#define AIPS_PACRI_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRI_SP0_SHIFT))&AIPS_PACRI_SP0_MASK)
/* PACRJ Bit Fields */
#define AIPS_PACRJ_TP7_MASK                      0x1u
#define AIPS_PACRJ_TP7_SHIFT                     0
#define AIPS_PACRJ_TP7_WIDTH                     1
#define AIPS_PACRJ_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP7_SHIFT))&AIPS_PACRJ_TP7_MASK)
#define AIPS_PACRJ_WP7_MASK                      0x2u
#define AIPS_PACRJ_WP7_SHIFT                     1
#define AIPS_PACRJ_WP7_WIDTH                     1
#define AIPS_PACRJ_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP7_SHIFT))&AIPS_PACRJ_WP7_MASK)
#define AIPS_PACRJ_SP7_MASK                      0x4u
#define AIPS_PACRJ_SP7_SHIFT                     2
#define AIPS_PACRJ_SP7_WIDTH                     1
#define AIPS_PACRJ_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP7_SHIFT))&AIPS_PACRJ_SP7_MASK)
#define AIPS_PACRJ_TP6_MASK                      0x10u
#define AIPS_PACRJ_TP6_SHIFT                     4
#define AIPS_PACRJ_TP6_WIDTH                     1
#define AIPS_PACRJ_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP6_SHIFT))&AIPS_PACRJ_TP6_MASK)
#define AIPS_PACRJ_WP6_MASK                      0x20u
#define AIPS_PACRJ_WP6_SHIFT                     5
#define AIPS_PACRJ_WP6_WIDTH                     1
#define AIPS_PACRJ_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP6_SHIFT))&AIPS_PACRJ_WP6_MASK)
#define AIPS_PACRJ_SP6_MASK                      0x40u
#define AIPS_PACRJ_SP6_SHIFT                     6
#define AIPS_PACRJ_SP6_WIDTH                     1
#define AIPS_PACRJ_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP6_SHIFT))&AIPS_PACRJ_SP6_MASK)
#define AIPS_PACRJ_TP5_MASK                      0x100u
#define AIPS_PACRJ_TP5_SHIFT                     8
#define AIPS_PACRJ_TP5_WIDTH                     1
#define AIPS_PACRJ_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP5_SHIFT))&AIPS_PACRJ_TP5_MASK)
#define AIPS_PACRJ_WP5_MASK                      0x200u
#define AIPS_PACRJ_WP5_SHIFT                     9
#define AIPS_PACRJ_WP5_WIDTH                     1
#define AIPS_PACRJ_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP5_SHIFT))&AIPS_PACRJ_WP5_MASK)
#define AIPS_PACRJ_SP5_MASK                      0x400u
#define AIPS_PACRJ_SP5_SHIFT                     10
#define AIPS_PACRJ_SP5_WIDTH                     1
#define AIPS_PACRJ_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP5_SHIFT))&AIPS_PACRJ_SP5_MASK)
#define AIPS_PACRJ_TP4_MASK                      0x1000u
#define AIPS_PACRJ_TP4_SHIFT                     12
#define AIPS_PACRJ_TP4_WIDTH                     1
#define AIPS_PACRJ_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP4_SHIFT))&AIPS_PACRJ_TP4_MASK)
#define AIPS_PACRJ_WP4_MASK                      0x2000u
#define AIPS_PACRJ_WP4_SHIFT                     13
#define AIPS_PACRJ_WP4_WIDTH                     1
#define AIPS_PACRJ_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP4_SHIFT))&AIPS_PACRJ_WP4_MASK)
#define AIPS_PACRJ_SP4_MASK                      0x4000u
#define AIPS_PACRJ_SP4_SHIFT                     14
#define AIPS_PACRJ_SP4_WIDTH                     1
#define AIPS_PACRJ_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP4_SHIFT))&AIPS_PACRJ_SP4_MASK)
#define AIPS_PACRJ_TP3_MASK                      0x10000u
#define AIPS_PACRJ_TP3_SHIFT                     16
#define AIPS_PACRJ_TP3_WIDTH                     1
#define AIPS_PACRJ_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP3_SHIFT))&AIPS_PACRJ_TP3_MASK)
#define AIPS_PACRJ_WP3_MASK                      0x20000u
#define AIPS_PACRJ_WP3_SHIFT                     17
#define AIPS_PACRJ_WP3_WIDTH                     1
#define AIPS_PACRJ_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP3_SHIFT))&AIPS_PACRJ_WP3_MASK)
#define AIPS_PACRJ_SP3_MASK                      0x40000u
#define AIPS_PACRJ_SP3_SHIFT                     18
#define AIPS_PACRJ_SP3_WIDTH                     1
#define AIPS_PACRJ_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP3_SHIFT))&AIPS_PACRJ_SP3_MASK)
#define AIPS_PACRJ_TP2_MASK                      0x100000u
#define AIPS_PACRJ_TP2_SHIFT                     20
#define AIPS_PACRJ_TP2_WIDTH                     1
#define AIPS_PACRJ_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP2_SHIFT))&AIPS_PACRJ_TP2_MASK)
#define AIPS_PACRJ_WP2_MASK                      0x200000u
#define AIPS_PACRJ_WP2_SHIFT                     21
#define AIPS_PACRJ_WP2_WIDTH                     1
#define AIPS_PACRJ_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP2_SHIFT))&AIPS_PACRJ_WP2_MASK)
#define AIPS_PACRJ_SP2_MASK                      0x400000u
#define AIPS_PACRJ_SP2_SHIFT                     22
#define AIPS_PACRJ_SP2_WIDTH                     1
#define AIPS_PACRJ_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP2_SHIFT))&AIPS_PACRJ_SP2_MASK)
#define AIPS_PACRJ_TP1_MASK                      0x1000000u
#define AIPS_PACRJ_TP1_SHIFT                     24
#define AIPS_PACRJ_TP1_WIDTH                     1
#define AIPS_PACRJ_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP1_SHIFT))&AIPS_PACRJ_TP1_MASK)
#define AIPS_PACRJ_WP1_MASK                      0x2000000u
#define AIPS_PACRJ_WP1_SHIFT                     25
#define AIPS_PACRJ_WP1_WIDTH                     1
#define AIPS_PACRJ_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP1_SHIFT))&AIPS_PACRJ_WP1_MASK)
#define AIPS_PACRJ_SP1_MASK                      0x4000000u
#define AIPS_PACRJ_SP1_SHIFT                     26
#define AIPS_PACRJ_SP1_WIDTH                     1
#define AIPS_PACRJ_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP1_SHIFT))&AIPS_PACRJ_SP1_MASK)
#define AIPS_PACRJ_TP0_MASK                      0x10000000u
#define AIPS_PACRJ_TP0_SHIFT                     28
#define AIPS_PACRJ_TP0_WIDTH                     1
#define AIPS_PACRJ_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_TP0_SHIFT))&AIPS_PACRJ_TP0_MASK)
#define AIPS_PACRJ_WP0_MASK                      0x20000000u
#define AIPS_PACRJ_WP0_SHIFT                     29
#define AIPS_PACRJ_WP0_WIDTH                     1
#define AIPS_PACRJ_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_WP0_SHIFT))&AIPS_PACRJ_WP0_MASK)
#define AIPS_PACRJ_SP0_MASK                      0x40000000u
#define AIPS_PACRJ_SP0_SHIFT                     30
#define AIPS_PACRJ_SP0_WIDTH                     1
#define AIPS_PACRJ_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRJ_SP0_SHIFT))&AIPS_PACRJ_SP0_MASK)
/* PACRK Bit Fields */
#define AIPS_PACRK_TP7_MASK                      0x1u
#define AIPS_PACRK_TP7_SHIFT                     0
#define AIPS_PACRK_TP7_WIDTH                     1
#define AIPS_PACRK_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP7_SHIFT))&AIPS_PACRK_TP7_MASK)
#define AIPS_PACRK_WP7_MASK                      0x2u
#define AIPS_PACRK_WP7_SHIFT                     1
#define AIPS_PACRK_WP7_WIDTH                     1
#define AIPS_PACRK_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP7_SHIFT))&AIPS_PACRK_WP7_MASK)
#define AIPS_PACRK_SP7_MASK                      0x4u
#define AIPS_PACRK_SP7_SHIFT                     2
#define AIPS_PACRK_SP7_WIDTH                     1
#define AIPS_PACRK_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP7_SHIFT))&AIPS_PACRK_SP7_MASK)
#define AIPS_PACRK_TP6_MASK                      0x10u
#define AIPS_PACRK_TP6_SHIFT                     4
#define AIPS_PACRK_TP6_WIDTH                     1
#define AIPS_PACRK_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP6_SHIFT))&AIPS_PACRK_TP6_MASK)
#define AIPS_PACRK_WP6_MASK                      0x20u
#define AIPS_PACRK_WP6_SHIFT                     5
#define AIPS_PACRK_WP6_WIDTH                     1
#define AIPS_PACRK_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP6_SHIFT))&AIPS_PACRK_WP6_MASK)
#define AIPS_PACRK_SP6_MASK                      0x40u
#define AIPS_PACRK_SP6_SHIFT                     6
#define AIPS_PACRK_SP6_WIDTH                     1
#define AIPS_PACRK_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP6_SHIFT))&AIPS_PACRK_SP6_MASK)
#define AIPS_PACRK_TP5_MASK                      0x100u
#define AIPS_PACRK_TP5_SHIFT                     8
#define AIPS_PACRK_TP5_WIDTH                     1
#define AIPS_PACRK_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP5_SHIFT))&AIPS_PACRK_TP5_MASK)
#define AIPS_PACRK_WP5_MASK                      0x200u
#define AIPS_PACRK_WP5_SHIFT                     9
#define AIPS_PACRK_WP5_WIDTH                     1
#define AIPS_PACRK_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP5_SHIFT))&AIPS_PACRK_WP5_MASK)
#define AIPS_PACRK_SP5_MASK                      0x400u
#define AIPS_PACRK_SP5_SHIFT                     10
#define AIPS_PACRK_SP5_WIDTH                     1
#define AIPS_PACRK_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP5_SHIFT))&AIPS_PACRK_SP5_MASK)
#define AIPS_PACRK_TP4_MASK                      0x1000u
#define AIPS_PACRK_TP4_SHIFT                     12
#define AIPS_PACRK_TP4_WIDTH                     1
#define AIPS_PACRK_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP4_SHIFT))&AIPS_PACRK_TP4_MASK)
#define AIPS_PACRK_WP4_MASK                      0x2000u
#define AIPS_PACRK_WP4_SHIFT                     13
#define AIPS_PACRK_WP4_WIDTH                     1
#define AIPS_PACRK_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP4_SHIFT))&AIPS_PACRK_WP4_MASK)
#define AIPS_PACRK_SP4_MASK                      0x4000u
#define AIPS_PACRK_SP4_SHIFT                     14
#define AIPS_PACRK_SP4_WIDTH                     1
#define AIPS_PACRK_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP4_SHIFT))&AIPS_PACRK_SP4_MASK)
#define AIPS_PACRK_TP3_MASK                      0x10000u
#define AIPS_PACRK_TP3_SHIFT                     16
#define AIPS_PACRK_TP3_WIDTH                     1
#define AIPS_PACRK_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP3_SHIFT))&AIPS_PACRK_TP3_MASK)
#define AIPS_PACRK_WP3_MASK                      0x20000u
#define AIPS_PACRK_WP3_SHIFT                     17
#define AIPS_PACRK_WP3_WIDTH                     1
#define AIPS_PACRK_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP3_SHIFT))&AIPS_PACRK_WP3_MASK)
#define AIPS_PACRK_SP3_MASK                      0x40000u
#define AIPS_PACRK_SP3_SHIFT                     18
#define AIPS_PACRK_SP3_WIDTH                     1
#define AIPS_PACRK_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP3_SHIFT))&AIPS_PACRK_SP3_MASK)
#define AIPS_PACRK_TP2_MASK                      0x100000u
#define AIPS_PACRK_TP2_SHIFT                     20
#define AIPS_PACRK_TP2_WIDTH                     1
#define AIPS_PACRK_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP2_SHIFT))&AIPS_PACRK_TP2_MASK)
#define AIPS_PACRK_WP2_MASK                      0x200000u
#define AIPS_PACRK_WP2_SHIFT                     21
#define AIPS_PACRK_WP2_WIDTH                     1
#define AIPS_PACRK_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP2_SHIFT))&AIPS_PACRK_WP2_MASK)
#define AIPS_PACRK_SP2_MASK                      0x400000u
#define AIPS_PACRK_SP2_SHIFT                     22
#define AIPS_PACRK_SP2_WIDTH                     1
#define AIPS_PACRK_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP2_SHIFT))&AIPS_PACRK_SP2_MASK)
#define AIPS_PACRK_TP1_MASK                      0x1000000u
#define AIPS_PACRK_TP1_SHIFT                     24
#define AIPS_PACRK_TP1_WIDTH                     1
#define AIPS_PACRK_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP1_SHIFT))&AIPS_PACRK_TP1_MASK)
#define AIPS_PACRK_WP1_MASK                      0x2000000u
#define AIPS_PACRK_WP1_SHIFT                     25
#define AIPS_PACRK_WP1_WIDTH                     1
#define AIPS_PACRK_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP1_SHIFT))&AIPS_PACRK_WP1_MASK)
#define AIPS_PACRK_SP1_MASK                      0x4000000u
#define AIPS_PACRK_SP1_SHIFT                     26
#define AIPS_PACRK_SP1_WIDTH                     1
#define AIPS_PACRK_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP1_SHIFT))&AIPS_PACRK_SP1_MASK)
#define AIPS_PACRK_TP0_MASK                      0x10000000u
#define AIPS_PACRK_TP0_SHIFT                     28
#define AIPS_PACRK_TP0_WIDTH                     1
#define AIPS_PACRK_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_TP0_SHIFT))&AIPS_PACRK_TP0_MASK)
#define AIPS_PACRK_WP0_MASK                      0x20000000u
#define AIPS_PACRK_WP0_SHIFT                     29
#define AIPS_PACRK_WP0_WIDTH                     1
#define AIPS_PACRK_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_WP0_SHIFT))&AIPS_PACRK_WP0_MASK)
#define AIPS_PACRK_SP0_MASK                      0x40000000u
#define AIPS_PACRK_SP0_SHIFT                     30
#define AIPS_PACRK_SP0_WIDTH                     1
#define AIPS_PACRK_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRK_SP0_SHIFT))&AIPS_PACRK_SP0_MASK)
/* PACRL Bit Fields */
#define AIPS_PACRL_TP7_MASK                      0x1u
#define AIPS_PACRL_TP7_SHIFT                     0
#define AIPS_PACRL_TP7_WIDTH                     1
#define AIPS_PACRL_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP7_SHIFT))&AIPS_PACRL_TP7_MASK)
#define AIPS_PACRL_WP7_MASK                      0x2u
#define AIPS_PACRL_WP7_SHIFT                     1
#define AIPS_PACRL_WP7_WIDTH                     1
#define AIPS_PACRL_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP7_SHIFT))&AIPS_PACRL_WP7_MASK)
#define AIPS_PACRL_SP7_MASK                      0x4u
#define AIPS_PACRL_SP7_SHIFT                     2
#define AIPS_PACRL_SP7_WIDTH                     1
#define AIPS_PACRL_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP7_SHIFT))&AIPS_PACRL_SP7_MASK)
#define AIPS_PACRL_TP6_MASK                      0x10u
#define AIPS_PACRL_TP6_SHIFT                     4
#define AIPS_PACRL_TP6_WIDTH                     1
#define AIPS_PACRL_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP6_SHIFT))&AIPS_PACRL_TP6_MASK)
#define AIPS_PACRL_WP6_MASK                      0x20u
#define AIPS_PACRL_WP6_SHIFT                     5
#define AIPS_PACRL_WP6_WIDTH                     1
#define AIPS_PACRL_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP6_SHIFT))&AIPS_PACRL_WP6_MASK)
#define AIPS_PACRL_SP6_MASK                      0x40u
#define AIPS_PACRL_SP6_SHIFT                     6
#define AIPS_PACRL_SP6_WIDTH                     1
#define AIPS_PACRL_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP6_SHIFT))&AIPS_PACRL_SP6_MASK)
#define AIPS_PACRL_TP5_MASK                      0x100u
#define AIPS_PACRL_TP5_SHIFT                     8
#define AIPS_PACRL_TP5_WIDTH                     1
#define AIPS_PACRL_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP5_SHIFT))&AIPS_PACRL_TP5_MASK)
#define AIPS_PACRL_WP5_MASK                      0x200u
#define AIPS_PACRL_WP5_SHIFT                     9
#define AIPS_PACRL_WP5_WIDTH                     1
#define AIPS_PACRL_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP5_SHIFT))&AIPS_PACRL_WP5_MASK)
#define AIPS_PACRL_SP5_MASK                      0x400u
#define AIPS_PACRL_SP5_SHIFT                     10
#define AIPS_PACRL_SP5_WIDTH                     1
#define AIPS_PACRL_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP5_SHIFT))&AIPS_PACRL_SP5_MASK)
#define AIPS_PACRL_TP4_MASK                      0x1000u
#define AIPS_PACRL_TP4_SHIFT                     12
#define AIPS_PACRL_TP4_WIDTH                     1
#define AIPS_PACRL_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP4_SHIFT))&AIPS_PACRL_TP4_MASK)
#define AIPS_PACRL_WP4_MASK                      0x2000u
#define AIPS_PACRL_WP4_SHIFT                     13
#define AIPS_PACRL_WP4_WIDTH                     1
#define AIPS_PACRL_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP4_SHIFT))&AIPS_PACRL_WP4_MASK)
#define AIPS_PACRL_SP4_MASK                      0x4000u
#define AIPS_PACRL_SP4_SHIFT                     14
#define AIPS_PACRL_SP4_WIDTH                     1
#define AIPS_PACRL_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP4_SHIFT))&AIPS_PACRL_SP4_MASK)
#define AIPS_PACRL_TP3_MASK                      0x10000u
#define AIPS_PACRL_TP3_SHIFT                     16
#define AIPS_PACRL_TP3_WIDTH                     1
#define AIPS_PACRL_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP3_SHIFT))&AIPS_PACRL_TP3_MASK)
#define AIPS_PACRL_WP3_MASK                      0x20000u
#define AIPS_PACRL_WP3_SHIFT                     17
#define AIPS_PACRL_WP3_WIDTH                     1
#define AIPS_PACRL_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP3_SHIFT))&AIPS_PACRL_WP3_MASK)
#define AIPS_PACRL_SP3_MASK                      0x40000u
#define AIPS_PACRL_SP3_SHIFT                     18
#define AIPS_PACRL_SP3_WIDTH                     1
#define AIPS_PACRL_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP3_SHIFT))&AIPS_PACRL_SP3_MASK)
#define AIPS_PACRL_TP2_MASK                      0x100000u
#define AIPS_PACRL_TP2_SHIFT                     20
#define AIPS_PACRL_TP2_WIDTH                     1
#define AIPS_PACRL_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP2_SHIFT))&AIPS_PACRL_TP2_MASK)
#define AIPS_PACRL_WP2_MASK                      0x200000u
#define AIPS_PACRL_WP2_SHIFT                     21
#define AIPS_PACRL_WP2_WIDTH                     1
#define AIPS_PACRL_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP2_SHIFT))&AIPS_PACRL_WP2_MASK)
#define AIPS_PACRL_SP2_MASK                      0x400000u
#define AIPS_PACRL_SP2_SHIFT                     22
#define AIPS_PACRL_SP2_WIDTH                     1
#define AIPS_PACRL_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP2_SHIFT))&AIPS_PACRL_SP2_MASK)
#define AIPS_PACRL_TP1_MASK                      0x1000000u
#define AIPS_PACRL_TP1_SHIFT                     24
#define AIPS_PACRL_TP1_WIDTH                     1
#define AIPS_PACRL_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP1_SHIFT))&AIPS_PACRL_TP1_MASK)
#define AIPS_PACRL_WP1_MASK                      0x2000000u
#define AIPS_PACRL_WP1_SHIFT                     25
#define AIPS_PACRL_WP1_WIDTH                     1
#define AIPS_PACRL_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP1_SHIFT))&AIPS_PACRL_WP1_MASK)
#define AIPS_PACRL_SP1_MASK                      0x4000000u
#define AIPS_PACRL_SP1_SHIFT                     26
#define AIPS_PACRL_SP1_WIDTH                     1
#define AIPS_PACRL_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP1_SHIFT))&AIPS_PACRL_SP1_MASK)
#define AIPS_PACRL_TP0_MASK                      0x10000000u
#define AIPS_PACRL_TP0_SHIFT                     28
#define AIPS_PACRL_TP0_WIDTH                     1
#define AIPS_PACRL_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_TP0_SHIFT))&AIPS_PACRL_TP0_MASK)
#define AIPS_PACRL_WP0_MASK                      0x20000000u
#define AIPS_PACRL_WP0_SHIFT                     29
#define AIPS_PACRL_WP0_WIDTH                     1
#define AIPS_PACRL_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_WP0_SHIFT))&AIPS_PACRL_WP0_MASK)
#define AIPS_PACRL_SP0_MASK                      0x40000000u
#define AIPS_PACRL_SP0_SHIFT                     30
#define AIPS_PACRL_SP0_WIDTH                     1
#define AIPS_PACRL_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRL_SP0_SHIFT))&AIPS_PACRL_SP0_MASK)
/* PACRM Bit Fields */
#define AIPS_PACRM_TP7_MASK                      0x1u
#define AIPS_PACRM_TP7_SHIFT                     0
#define AIPS_PACRM_TP7_WIDTH                     1
#define AIPS_PACRM_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP7_SHIFT))&AIPS_PACRM_TP7_MASK)
#define AIPS_PACRM_WP7_MASK                      0x2u
#define AIPS_PACRM_WP7_SHIFT                     1
#define AIPS_PACRM_WP7_WIDTH                     1
#define AIPS_PACRM_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP7_SHIFT))&AIPS_PACRM_WP7_MASK)
#define AIPS_PACRM_SP7_MASK                      0x4u
#define AIPS_PACRM_SP7_SHIFT                     2
#define AIPS_PACRM_SP7_WIDTH                     1
#define AIPS_PACRM_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP7_SHIFT))&AIPS_PACRM_SP7_MASK)
#define AIPS_PACRM_TP6_MASK                      0x10u
#define AIPS_PACRM_TP6_SHIFT                     4
#define AIPS_PACRM_TP6_WIDTH                     1
#define AIPS_PACRM_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP6_SHIFT))&AIPS_PACRM_TP6_MASK)
#define AIPS_PACRM_WP6_MASK                      0x20u
#define AIPS_PACRM_WP6_SHIFT                     5
#define AIPS_PACRM_WP6_WIDTH                     1
#define AIPS_PACRM_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP6_SHIFT))&AIPS_PACRM_WP6_MASK)
#define AIPS_PACRM_SP6_MASK                      0x40u
#define AIPS_PACRM_SP6_SHIFT                     6
#define AIPS_PACRM_SP6_WIDTH                     1
#define AIPS_PACRM_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP6_SHIFT))&AIPS_PACRM_SP6_MASK)
#define AIPS_PACRM_TP5_MASK                      0x100u
#define AIPS_PACRM_TP5_SHIFT                     8
#define AIPS_PACRM_TP5_WIDTH                     1
#define AIPS_PACRM_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP5_SHIFT))&AIPS_PACRM_TP5_MASK)
#define AIPS_PACRM_WP5_MASK                      0x200u
#define AIPS_PACRM_WP5_SHIFT                     9
#define AIPS_PACRM_WP5_WIDTH                     1
#define AIPS_PACRM_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP5_SHIFT))&AIPS_PACRM_WP5_MASK)
#define AIPS_PACRM_SP5_MASK                      0x400u
#define AIPS_PACRM_SP5_SHIFT                     10
#define AIPS_PACRM_SP5_WIDTH                     1
#define AIPS_PACRM_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP5_SHIFT))&AIPS_PACRM_SP5_MASK)
#define AIPS_PACRM_TP4_MASK                      0x1000u
#define AIPS_PACRM_TP4_SHIFT                     12
#define AIPS_PACRM_TP4_WIDTH                     1
#define AIPS_PACRM_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP4_SHIFT))&AIPS_PACRM_TP4_MASK)
#define AIPS_PACRM_WP4_MASK                      0x2000u
#define AIPS_PACRM_WP4_SHIFT                     13
#define AIPS_PACRM_WP4_WIDTH                     1
#define AIPS_PACRM_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP4_SHIFT))&AIPS_PACRM_WP4_MASK)
#define AIPS_PACRM_SP4_MASK                      0x4000u
#define AIPS_PACRM_SP4_SHIFT                     14
#define AIPS_PACRM_SP4_WIDTH                     1
#define AIPS_PACRM_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP4_SHIFT))&AIPS_PACRM_SP4_MASK)
#define AIPS_PACRM_TP3_MASK                      0x10000u
#define AIPS_PACRM_TP3_SHIFT                     16
#define AIPS_PACRM_TP3_WIDTH                     1
#define AIPS_PACRM_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP3_SHIFT))&AIPS_PACRM_TP3_MASK)
#define AIPS_PACRM_WP3_MASK                      0x20000u
#define AIPS_PACRM_WP3_SHIFT                     17
#define AIPS_PACRM_WP3_WIDTH                     1
#define AIPS_PACRM_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP3_SHIFT))&AIPS_PACRM_WP3_MASK)
#define AIPS_PACRM_SP3_MASK                      0x40000u
#define AIPS_PACRM_SP3_SHIFT                     18
#define AIPS_PACRM_SP3_WIDTH                     1
#define AIPS_PACRM_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP3_SHIFT))&AIPS_PACRM_SP3_MASK)
#define AIPS_PACRM_TP2_MASK                      0x100000u
#define AIPS_PACRM_TP2_SHIFT                     20
#define AIPS_PACRM_TP2_WIDTH                     1
#define AIPS_PACRM_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP2_SHIFT))&AIPS_PACRM_TP2_MASK)
#define AIPS_PACRM_WP2_MASK                      0x200000u
#define AIPS_PACRM_WP2_SHIFT                     21
#define AIPS_PACRM_WP2_WIDTH                     1
#define AIPS_PACRM_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP2_SHIFT))&AIPS_PACRM_WP2_MASK)
#define AIPS_PACRM_SP2_MASK                      0x400000u
#define AIPS_PACRM_SP2_SHIFT                     22
#define AIPS_PACRM_SP2_WIDTH                     1
#define AIPS_PACRM_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP2_SHIFT))&AIPS_PACRM_SP2_MASK)
#define AIPS_PACRM_TP1_MASK                      0x1000000u
#define AIPS_PACRM_TP1_SHIFT                     24
#define AIPS_PACRM_TP1_WIDTH                     1
#define AIPS_PACRM_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP1_SHIFT))&AIPS_PACRM_TP1_MASK)
#define AIPS_PACRM_WP1_MASK                      0x2000000u
#define AIPS_PACRM_WP1_SHIFT                     25
#define AIPS_PACRM_WP1_WIDTH                     1
#define AIPS_PACRM_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP1_SHIFT))&AIPS_PACRM_WP1_MASK)
#define AIPS_PACRM_SP1_MASK                      0x4000000u
#define AIPS_PACRM_SP1_SHIFT                     26
#define AIPS_PACRM_SP1_WIDTH                     1
#define AIPS_PACRM_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP1_SHIFT))&AIPS_PACRM_SP1_MASK)
#define AIPS_PACRM_TP0_MASK                      0x10000000u
#define AIPS_PACRM_TP0_SHIFT                     28
#define AIPS_PACRM_TP0_WIDTH                     1
#define AIPS_PACRM_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_TP0_SHIFT))&AIPS_PACRM_TP0_MASK)
#define AIPS_PACRM_WP0_MASK                      0x20000000u
#define AIPS_PACRM_WP0_SHIFT                     29
#define AIPS_PACRM_WP0_WIDTH                     1
#define AIPS_PACRM_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_WP0_SHIFT))&AIPS_PACRM_WP0_MASK)
#define AIPS_PACRM_SP0_MASK                      0x40000000u
#define AIPS_PACRM_SP0_SHIFT                     30
#define AIPS_PACRM_SP0_WIDTH                     1
#define AIPS_PACRM_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRM_SP0_SHIFT))&AIPS_PACRM_SP0_MASK)
/* PACRN Bit Fields */
#define AIPS_PACRN_TP7_MASK                      0x1u
#define AIPS_PACRN_TP7_SHIFT                     0
#define AIPS_PACRN_TP7_WIDTH                     1
#define AIPS_PACRN_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP7_SHIFT))&AIPS_PACRN_TP7_MASK)
#define AIPS_PACRN_WP7_MASK                      0x2u
#define AIPS_PACRN_WP7_SHIFT                     1
#define AIPS_PACRN_WP7_WIDTH                     1
#define AIPS_PACRN_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP7_SHIFT))&AIPS_PACRN_WP7_MASK)
#define AIPS_PACRN_SP7_MASK                      0x4u
#define AIPS_PACRN_SP7_SHIFT                     2
#define AIPS_PACRN_SP7_WIDTH                     1
#define AIPS_PACRN_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP7_SHIFT))&AIPS_PACRN_SP7_MASK)
#define AIPS_PACRN_TP6_MASK                      0x10u
#define AIPS_PACRN_TP6_SHIFT                     4
#define AIPS_PACRN_TP6_WIDTH                     1
#define AIPS_PACRN_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP6_SHIFT))&AIPS_PACRN_TP6_MASK)
#define AIPS_PACRN_WP6_MASK                      0x20u
#define AIPS_PACRN_WP6_SHIFT                     5
#define AIPS_PACRN_WP6_WIDTH                     1
#define AIPS_PACRN_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP6_SHIFT))&AIPS_PACRN_WP6_MASK)
#define AIPS_PACRN_SP6_MASK                      0x40u
#define AIPS_PACRN_SP6_SHIFT                     6
#define AIPS_PACRN_SP6_WIDTH                     1
#define AIPS_PACRN_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP6_SHIFT))&AIPS_PACRN_SP6_MASK)
#define AIPS_PACRN_TP5_MASK                      0x100u
#define AIPS_PACRN_TP5_SHIFT                     8
#define AIPS_PACRN_TP5_WIDTH                     1
#define AIPS_PACRN_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP5_SHIFT))&AIPS_PACRN_TP5_MASK)
#define AIPS_PACRN_WP5_MASK                      0x200u
#define AIPS_PACRN_WP5_SHIFT                     9
#define AIPS_PACRN_WP5_WIDTH                     1
#define AIPS_PACRN_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP5_SHIFT))&AIPS_PACRN_WP5_MASK)
#define AIPS_PACRN_SP5_MASK                      0x400u
#define AIPS_PACRN_SP5_SHIFT                     10
#define AIPS_PACRN_SP5_WIDTH                     1
#define AIPS_PACRN_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP5_SHIFT))&AIPS_PACRN_SP5_MASK)
#define AIPS_PACRN_TP4_MASK                      0x1000u
#define AIPS_PACRN_TP4_SHIFT                     12
#define AIPS_PACRN_TP4_WIDTH                     1
#define AIPS_PACRN_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP4_SHIFT))&AIPS_PACRN_TP4_MASK)
#define AIPS_PACRN_WP4_MASK                      0x2000u
#define AIPS_PACRN_WP4_SHIFT                     13
#define AIPS_PACRN_WP4_WIDTH                     1
#define AIPS_PACRN_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP4_SHIFT))&AIPS_PACRN_WP4_MASK)
#define AIPS_PACRN_SP4_MASK                      0x4000u
#define AIPS_PACRN_SP4_SHIFT                     14
#define AIPS_PACRN_SP4_WIDTH                     1
#define AIPS_PACRN_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP4_SHIFT))&AIPS_PACRN_SP4_MASK)
#define AIPS_PACRN_TP3_MASK                      0x10000u
#define AIPS_PACRN_TP3_SHIFT                     16
#define AIPS_PACRN_TP3_WIDTH                     1
#define AIPS_PACRN_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP3_SHIFT))&AIPS_PACRN_TP3_MASK)
#define AIPS_PACRN_WP3_MASK                      0x20000u
#define AIPS_PACRN_WP3_SHIFT                     17
#define AIPS_PACRN_WP3_WIDTH                     1
#define AIPS_PACRN_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP3_SHIFT))&AIPS_PACRN_WP3_MASK)
#define AIPS_PACRN_SP3_MASK                      0x40000u
#define AIPS_PACRN_SP3_SHIFT                     18
#define AIPS_PACRN_SP3_WIDTH                     1
#define AIPS_PACRN_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP3_SHIFT))&AIPS_PACRN_SP3_MASK)
#define AIPS_PACRN_TP2_MASK                      0x100000u
#define AIPS_PACRN_TP2_SHIFT                     20
#define AIPS_PACRN_TP2_WIDTH                     1
#define AIPS_PACRN_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP2_SHIFT))&AIPS_PACRN_TP2_MASK)
#define AIPS_PACRN_WP2_MASK                      0x200000u
#define AIPS_PACRN_WP2_SHIFT                     21
#define AIPS_PACRN_WP2_WIDTH                     1
#define AIPS_PACRN_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP2_SHIFT))&AIPS_PACRN_WP2_MASK)
#define AIPS_PACRN_SP2_MASK                      0x400000u
#define AIPS_PACRN_SP2_SHIFT                     22
#define AIPS_PACRN_SP2_WIDTH                     1
#define AIPS_PACRN_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP2_SHIFT))&AIPS_PACRN_SP2_MASK)
#define AIPS_PACRN_TP1_MASK                      0x1000000u
#define AIPS_PACRN_TP1_SHIFT                     24
#define AIPS_PACRN_TP1_WIDTH                     1
#define AIPS_PACRN_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP1_SHIFT))&AIPS_PACRN_TP1_MASK)
#define AIPS_PACRN_WP1_MASK                      0x2000000u
#define AIPS_PACRN_WP1_SHIFT                     25
#define AIPS_PACRN_WP1_WIDTH                     1
#define AIPS_PACRN_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP1_SHIFT))&AIPS_PACRN_WP1_MASK)
#define AIPS_PACRN_SP1_MASK                      0x4000000u
#define AIPS_PACRN_SP1_SHIFT                     26
#define AIPS_PACRN_SP1_WIDTH                     1
#define AIPS_PACRN_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP1_SHIFT))&AIPS_PACRN_SP1_MASK)
#define AIPS_PACRN_TP0_MASK                      0x10000000u
#define AIPS_PACRN_TP0_SHIFT                     28
#define AIPS_PACRN_TP0_WIDTH                     1
#define AIPS_PACRN_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_TP0_SHIFT))&AIPS_PACRN_TP0_MASK)
#define AIPS_PACRN_WP0_MASK                      0x20000000u
#define AIPS_PACRN_WP0_SHIFT                     29
#define AIPS_PACRN_WP0_WIDTH                     1
#define AIPS_PACRN_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_WP0_SHIFT))&AIPS_PACRN_WP0_MASK)
#define AIPS_PACRN_SP0_MASK                      0x40000000u
#define AIPS_PACRN_SP0_SHIFT                     30
#define AIPS_PACRN_SP0_WIDTH                     1
#define AIPS_PACRN_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRN_SP0_SHIFT))&AIPS_PACRN_SP0_MASK)
/* PACRO Bit Fields */
#define AIPS_PACRO_TP7_MASK                      0x1u
#define AIPS_PACRO_TP7_SHIFT                     0
#define AIPS_PACRO_TP7_WIDTH                     1
#define AIPS_PACRO_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP7_SHIFT))&AIPS_PACRO_TP7_MASK)
#define AIPS_PACRO_WP7_MASK                      0x2u
#define AIPS_PACRO_WP7_SHIFT                     1
#define AIPS_PACRO_WP7_WIDTH                     1
#define AIPS_PACRO_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP7_SHIFT))&AIPS_PACRO_WP7_MASK)
#define AIPS_PACRO_SP7_MASK                      0x4u
#define AIPS_PACRO_SP7_SHIFT                     2
#define AIPS_PACRO_SP7_WIDTH                     1
#define AIPS_PACRO_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP7_SHIFT))&AIPS_PACRO_SP7_MASK)
#define AIPS_PACRO_TP6_MASK                      0x10u
#define AIPS_PACRO_TP6_SHIFT                     4
#define AIPS_PACRO_TP6_WIDTH                     1
#define AIPS_PACRO_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP6_SHIFT))&AIPS_PACRO_TP6_MASK)
#define AIPS_PACRO_WP6_MASK                      0x20u
#define AIPS_PACRO_WP6_SHIFT                     5
#define AIPS_PACRO_WP6_WIDTH                     1
#define AIPS_PACRO_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP6_SHIFT))&AIPS_PACRO_WP6_MASK)
#define AIPS_PACRO_SP6_MASK                      0x40u
#define AIPS_PACRO_SP6_SHIFT                     6
#define AIPS_PACRO_SP6_WIDTH                     1
#define AIPS_PACRO_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP6_SHIFT))&AIPS_PACRO_SP6_MASK)
#define AIPS_PACRO_TP5_MASK                      0x100u
#define AIPS_PACRO_TP5_SHIFT                     8
#define AIPS_PACRO_TP5_WIDTH                     1
#define AIPS_PACRO_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP5_SHIFT))&AIPS_PACRO_TP5_MASK)
#define AIPS_PACRO_WP5_MASK                      0x200u
#define AIPS_PACRO_WP5_SHIFT                     9
#define AIPS_PACRO_WP5_WIDTH                     1
#define AIPS_PACRO_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP5_SHIFT))&AIPS_PACRO_WP5_MASK)
#define AIPS_PACRO_SP5_MASK                      0x400u
#define AIPS_PACRO_SP5_SHIFT                     10
#define AIPS_PACRO_SP5_WIDTH                     1
#define AIPS_PACRO_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP5_SHIFT))&AIPS_PACRO_SP5_MASK)
#define AIPS_PACRO_TP4_MASK                      0x1000u
#define AIPS_PACRO_TP4_SHIFT                     12
#define AIPS_PACRO_TP4_WIDTH                     1
#define AIPS_PACRO_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP4_SHIFT))&AIPS_PACRO_TP4_MASK)
#define AIPS_PACRO_WP4_MASK                      0x2000u
#define AIPS_PACRO_WP4_SHIFT                     13
#define AIPS_PACRO_WP4_WIDTH                     1
#define AIPS_PACRO_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP4_SHIFT))&AIPS_PACRO_WP4_MASK)
#define AIPS_PACRO_SP4_MASK                      0x4000u
#define AIPS_PACRO_SP4_SHIFT                     14
#define AIPS_PACRO_SP4_WIDTH                     1
#define AIPS_PACRO_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP4_SHIFT))&AIPS_PACRO_SP4_MASK)
#define AIPS_PACRO_TP3_MASK                      0x10000u
#define AIPS_PACRO_TP3_SHIFT                     16
#define AIPS_PACRO_TP3_WIDTH                     1
#define AIPS_PACRO_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP3_SHIFT))&AIPS_PACRO_TP3_MASK)
#define AIPS_PACRO_WP3_MASK                      0x20000u
#define AIPS_PACRO_WP3_SHIFT                     17
#define AIPS_PACRO_WP3_WIDTH                     1
#define AIPS_PACRO_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP3_SHIFT))&AIPS_PACRO_WP3_MASK)
#define AIPS_PACRO_SP3_MASK                      0x40000u
#define AIPS_PACRO_SP3_SHIFT                     18
#define AIPS_PACRO_SP3_WIDTH                     1
#define AIPS_PACRO_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP3_SHIFT))&AIPS_PACRO_SP3_MASK)
#define AIPS_PACRO_TP2_MASK                      0x100000u
#define AIPS_PACRO_TP2_SHIFT                     20
#define AIPS_PACRO_TP2_WIDTH                     1
#define AIPS_PACRO_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP2_SHIFT))&AIPS_PACRO_TP2_MASK)
#define AIPS_PACRO_WP2_MASK                      0x200000u
#define AIPS_PACRO_WP2_SHIFT                     21
#define AIPS_PACRO_WP2_WIDTH                     1
#define AIPS_PACRO_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP2_SHIFT))&AIPS_PACRO_WP2_MASK)
#define AIPS_PACRO_SP2_MASK                      0x400000u
#define AIPS_PACRO_SP2_SHIFT                     22
#define AIPS_PACRO_SP2_WIDTH                     1
#define AIPS_PACRO_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP2_SHIFT))&AIPS_PACRO_SP2_MASK)
#define AIPS_PACRO_TP1_MASK                      0x1000000u
#define AIPS_PACRO_TP1_SHIFT                     24
#define AIPS_PACRO_TP1_WIDTH                     1
#define AIPS_PACRO_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP1_SHIFT))&AIPS_PACRO_TP1_MASK)
#define AIPS_PACRO_WP1_MASK                      0x2000000u
#define AIPS_PACRO_WP1_SHIFT                     25
#define AIPS_PACRO_WP1_WIDTH                     1
#define AIPS_PACRO_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP1_SHIFT))&AIPS_PACRO_WP1_MASK)
#define AIPS_PACRO_SP1_MASK                      0x4000000u
#define AIPS_PACRO_SP1_SHIFT                     26
#define AIPS_PACRO_SP1_WIDTH                     1
#define AIPS_PACRO_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP1_SHIFT))&AIPS_PACRO_SP1_MASK)
#define AIPS_PACRO_TP0_MASK                      0x10000000u
#define AIPS_PACRO_TP0_SHIFT                     28
#define AIPS_PACRO_TP0_WIDTH                     1
#define AIPS_PACRO_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_TP0_SHIFT))&AIPS_PACRO_TP0_MASK)
#define AIPS_PACRO_WP0_MASK                      0x20000000u
#define AIPS_PACRO_WP0_SHIFT                     29
#define AIPS_PACRO_WP0_WIDTH                     1
#define AIPS_PACRO_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_WP0_SHIFT))&AIPS_PACRO_WP0_MASK)
#define AIPS_PACRO_SP0_MASK                      0x40000000u
#define AIPS_PACRO_SP0_SHIFT                     30
#define AIPS_PACRO_SP0_WIDTH                     1
#define AIPS_PACRO_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRO_SP0_SHIFT))&AIPS_PACRO_SP0_MASK)
/* PACRP Bit Fields */
#define AIPS_PACRP_TP7_MASK                      0x1u
#define AIPS_PACRP_TP7_SHIFT                     0
#define AIPS_PACRP_TP7_WIDTH                     1
#define AIPS_PACRP_TP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP7_SHIFT))&AIPS_PACRP_TP7_MASK)
#define AIPS_PACRP_WP7_MASK                      0x2u
#define AIPS_PACRP_WP7_SHIFT                     1
#define AIPS_PACRP_WP7_WIDTH                     1
#define AIPS_PACRP_WP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP7_SHIFT))&AIPS_PACRP_WP7_MASK)
#define AIPS_PACRP_SP7_MASK                      0x4u
#define AIPS_PACRP_SP7_SHIFT                     2
#define AIPS_PACRP_SP7_WIDTH                     1
#define AIPS_PACRP_SP7(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP7_SHIFT))&AIPS_PACRP_SP7_MASK)
#define AIPS_PACRP_TP6_MASK                      0x10u
#define AIPS_PACRP_TP6_SHIFT                     4
#define AIPS_PACRP_TP6_WIDTH                     1
#define AIPS_PACRP_TP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP6_SHIFT))&AIPS_PACRP_TP6_MASK)
#define AIPS_PACRP_WP6_MASK                      0x20u
#define AIPS_PACRP_WP6_SHIFT                     5
#define AIPS_PACRP_WP6_WIDTH                     1
#define AIPS_PACRP_WP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP6_SHIFT))&AIPS_PACRP_WP6_MASK)
#define AIPS_PACRP_SP6_MASK                      0x40u
#define AIPS_PACRP_SP6_SHIFT                     6
#define AIPS_PACRP_SP6_WIDTH                     1
#define AIPS_PACRP_SP6(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP6_SHIFT))&AIPS_PACRP_SP6_MASK)
#define AIPS_PACRP_TP5_MASK                      0x100u
#define AIPS_PACRP_TP5_SHIFT                     8
#define AIPS_PACRP_TP5_WIDTH                     1
#define AIPS_PACRP_TP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP5_SHIFT))&AIPS_PACRP_TP5_MASK)
#define AIPS_PACRP_WP5_MASK                      0x200u
#define AIPS_PACRP_WP5_SHIFT                     9
#define AIPS_PACRP_WP5_WIDTH                     1
#define AIPS_PACRP_WP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP5_SHIFT))&AIPS_PACRP_WP5_MASK)
#define AIPS_PACRP_SP5_MASK                      0x400u
#define AIPS_PACRP_SP5_SHIFT                     10
#define AIPS_PACRP_SP5_WIDTH                     1
#define AIPS_PACRP_SP5(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP5_SHIFT))&AIPS_PACRP_SP5_MASK)
#define AIPS_PACRP_TP4_MASK                      0x1000u
#define AIPS_PACRP_TP4_SHIFT                     12
#define AIPS_PACRP_TP4_WIDTH                     1
#define AIPS_PACRP_TP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP4_SHIFT))&AIPS_PACRP_TP4_MASK)
#define AIPS_PACRP_WP4_MASK                      0x2000u
#define AIPS_PACRP_WP4_SHIFT                     13
#define AIPS_PACRP_WP4_WIDTH                     1
#define AIPS_PACRP_WP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP4_SHIFT))&AIPS_PACRP_WP4_MASK)
#define AIPS_PACRP_SP4_MASK                      0x4000u
#define AIPS_PACRP_SP4_SHIFT                     14
#define AIPS_PACRP_SP4_WIDTH                     1
#define AIPS_PACRP_SP4(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP4_SHIFT))&AIPS_PACRP_SP4_MASK)
#define AIPS_PACRP_TP3_MASK                      0x10000u
#define AIPS_PACRP_TP3_SHIFT                     16
#define AIPS_PACRP_TP3_WIDTH                     1
#define AIPS_PACRP_TP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP3_SHIFT))&AIPS_PACRP_TP3_MASK)
#define AIPS_PACRP_WP3_MASK                      0x20000u
#define AIPS_PACRP_WP3_SHIFT                     17
#define AIPS_PACRP_WP3_WIDTH                     1
#define AIPS_PACRP_WP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP3_SHIFT))&AIPS_PACRP_WP3_MASK)
#define AIPS_PACRP_SP3_MASK                      0x40000u
#define AIPS_PACRP_SP3_SHIFT                     18
#define AIPS_PACRP_SP3_WIDTH                     1
#define AIPS_PACRP_SP3(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP3_SHIFT))&AIPS_PACRP_SP3_MASK)
#define AIPS_PACRP_TP2_MASK                      0x100000u
#define AIPS_PACRP_TP2_SHIFT                     20
#define AIPS_PACRP_TP2_WIDTH                     1
#define AIPS_PACRP_TP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP2_SHIFT))&AIPS_PACRP_TP2_MASK)
#define AIPS_PACRP_WP2_MASK                      0x200000u
#define AIPS_PACRP_WP2_SHIFT                     21
#define AIPS_PACRP_WP2_WIDTH                     1
#define AIPS_PACRP_WP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP2_SHIFT))&AIPS_PACRP_WP2_MASK)
#define AIPS_PACRP_SP2_MASK                      0x400000u
#define AIPS_PACRP_SP2_SHIFT                     22
#define AIPS_PACRP_SP2_WIDTH                     1
#define AIPS_PACRP_SP2(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP2_SHIFT))&AIPS_PACRP_SP2_MASK)
#define AIPS_PACRP_TP1_MASK                      0x1000000u
#define AIPS_PACRP_TP1_SHIFT                     24
#define AIPS_PACRP_TP1_WIDTH                     1
#define AIPS_PACRP_TP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP1_SHIFT))&AIPS_PACRP_TP1_MASK)
#define AIPS_PACRP_WP1_MASK                      0x2000000u
#define AIPS_PACRP_WP1_SHIFT                     25
#define AIPS_PACRP_WP1_WIDTH                     1
#define AIPS_PACRP_WP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP1_SHIFT))&AIPS_PACRP_WP1_MASK)
#define AIPS_PACRP_SP1_MASK                      0x4000000u
#define AIPS_PACRP_SP1_SHIFT                     26
#define AIPS_PACRP_SP1_WIDTH                     1
#define AIPS_PACRP_SP1(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP1_SHIFT))&AIPS_PACRP_SP1_MASK)
#define AIPS_PACRP_TP0_MASK                      0x10000000u
#define AIPS_PACRP_TP0_SHIFT                     28
#define AIPS_PACRP_TP0_WIDTH                     1
#define AIPS_PACRP_TP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_TP0_SHIFT))&AIPS_PACRP_TP0_MASK)
#define AIPS_PACRP_WP0_MASK                      0x20000000u
#define AIPS_PACRP_WP0_SHIFT                     29
#define AIPS_PACRP_WP0_WIDTH                     1
#define AIPS_PACRP_WP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_WP0_SHIFT))&AIPS_PACRP_WP0_MASK)
#define AIPS_PACRP_SP0_MASK                      0x40000000u
#define AIPS_PACRP_SP0_SHIFT                     30
#define AIPS_PACRP_SP0_WIDTH                     1
#define AIPS_PACRP_SP0(x)                        (((uint32_t)(((uint32_t)(x))<<AIPS_PACRP_SP0_SHIFT))&AIPS_PACRP_SP0_MASK)

/*!
 * @}
 */ /* end of group AIPS_Register_Masks */


/* AIPS - Peripheral instance base addresses */
/** Peripheral AIPS base address */
#define AIPS_BASE                                (0x40000000u)
/** Peripheral AIPS base pointer */
#define AIPS                                     ((AIPS_Type *)AIPS_BASE)
#define AIPS_BASE_PTR                            (AIPS)
/** Array initializer of AIPS peripheral base addresses */
#define AIPS_BASE_ADDRS                          { AIPS_BASE }
/** Array initializer of AIPS peripheral base pointers */
#define AIPS_BASE_PTRS                           { AIPS }

/* ----------------------------------------------------------------------------
   -- AIPS - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPS_Register_Accessor_Macros AIPS - Register accessor macros
 * @{
 */


/* AIPS - Register instance definitions */
/* AIPS */
#define AIPS_MPRA                                AIPS_MPRA_REG(AIPS)
#define AIPS_PACRA                               AIPS_PACRA_REG(AIPS)
#define AIPS_PACRB                               AIPS_PACRB_REG(AIPS)
#define AIPS_PACRC                               AIPS_PACRC_REG(AIPS)
#define AIPS_PACRD                               AIPS_PACRD_REG(AIPS)
#define AIPS_PACRE                               AIPS_PACRE_REG(AIPS)
#define AIPS_PACRF                               AIPS_PACRF_REG(AIPS)
#define AIPS_PACRG                               AIPS_PACRG_REG(AIPS)
#define AIPS_PACRH                               AIPS_PACRH_REG(AIPS)
#define AIPS_PACRI                               AIPS_PACRI_REG(AIPS)
#define AIPS_PACRJ                               AIPS_PACRJ_REG(AIPS)
#define AIPS_PACRK                               AIPS_PACRK_REG(AIPS)
#define AIPS_PACRL                               AIPS_PACRL_REG(AIPS)
#define AIPS_PACRM                               AIPS_PACRM_REG(AIPS)
#define AIPS_PACRN                               AIPS_PACRN_REG(AIPS)
#define AIPS_PACRO                               AIPS_PACRO_REG(AIPS)
#define AIPS_PACRP                               AIPS_PACRP_REG(AIPS)

/*!
 * @}
 */ /* end of group AIPS_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group AIPS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CMP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Peripheral_Access_Layer CMP Peripheral Access Layer
 * @{
 */

/** CMP - Register Layout Typedef */
typedef struct {
  __IO uint8_t CR0;                                /**< CMP Control Register 0, offset: 0x0 */
  __IO uint8_t CR1;                                /**< CMP Control Register 1, offset: 0x1 */
  __IO uint8_t FPR;                                /**< CMP Filter Period Register, offset: 0x2 */
  __IO uint8_t SCR;                                /**< CMP Status and Control Register, offset: 0x3 */
  __IO uint8_t DACCR;                              /**< DAC Control Register, offset: 0x4 */
  __IO uint8_t MUXCR;                              /**< MUX Control Register, offset: 0x5 */
} CMP_Type, *CMP_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CMP - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Accessor_Macros CMP - Register accessor macros
 * @{
 */


/* CMP - Register accessors */
#define CMP_CR0_REG(base)                        ((base)->CR0)
#define CMP_CR1_REG(base)                        ((base)->CR1)
#define CMP_FPR_REG(base)                        ((base)->FPR)
#define CMP_SCR_REG(base)                        ((base)->SCR)
#define CMP_DACCR_REG(base)                      ((base)->DACCR)
#define CMP_MUXCR_REG(base)                      ((base)->MUXCR)

/*!
 * @}
 */ /* end of group CMP_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CMP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Masks CMP Register Masks
 * @{
 */

/* CR0 Bit Fields */
#define CMP_CR0_HYSTCTR_MASK                     0x3u
#define CMP_CR0_HYSTCTR_SHIFT                    0
#define CMP_CR0_HYSTCTR_WIDTH                    2
#define CMP_CR0_HYSTCTR(x)                       (((uint8_t)(((uint8_t)(x))<<CMP_CR0_HYSTCTR_SHIFT))&CMP_CR0_HYSTCTR_MASK)
#define CMP_CR0_FILTER_CNT_MASK                  0x70u
#define CMP_CR0_FILTER_CNT_SHIFT                 4
#define CMP_CR0_FILTER_CNT_WIDTH                 3
#define CMP_CR0_FILTER_CNT(x)                    (((uint8_t)(((uint8_t)(x))<<CMP_CR0_FILTER_CNT_SHIFT))&CMP_CR0_FILTER_CNT_MASK)
/* CR1 Bit Fields */
#define CMP_CR1_EN_MASK                          0x1u
#define CMP_CR1_EN_SHIFT                         0
#define CMP_CR1_EN_WIDTH                         1
#define CMP_CR1_EN(x)                            (((uint8_t)(((uint8_t)(x))<<CMP_CR1_EN_SHIFT))&CMP_CR1_EN_MASK)
#define CMP_CR1_OPE_MASK                         0x2u
#define CMP_CR1_OPE_SHIFT                        1
#define CMP_CR1_OPE_WIDTH                        1
#define CMP_CR1_OPE(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_CR1_OPE_SHIFT))&CMP_CR1_OPE_MASK)
#define CMP_CR1_COS_MASK                         0x4u
#define CMP_CR1_COS_SHIFT                        2
#define CMP_CR1_COS_WIDTH                        1
#define CMP_CR1_COS(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_CR1_COS_SHIFT))&CMP_CR1_COS_MASK)
#define CMP_CR1_INV_MASK                         0x8u
#define CMP_CR1_INV_SHIFT                        3
#define CMP_CR1_INV_WIDTH                        1
#define CMP_CR1_INV(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_CR1_INV_SHIFT))&CMP_CR1_INV_MASK)
#define CMP_CR1_PMODE_MASK                       0x10u
#define CMP_CR1_PMODE_SHIFT                      4
#define CMP_CR1_PMODE_WIDTH                      1
#define CMP_CR1_PMODE(x)                         (((uint8_t)(((uint8_t)(x))<<CMP_CR1_PMODE_SHIFT))&CMP_CR1_PMODE_MASK)
#define CMP_CR1_TRIGM_MASK                       0x20u
#define CMP_CR1_TRIGM_SHIFT                      5
#define CMP_CR1_TRIGM_WIDTH                      1
#define CMP_CR1_TRIGM(x)                         (((uint8_t)(((uint8_t)(x))<<CMP_CR1_TRIGM_SHIFT))&CMP_CR1_TRIGM_MASK)
#define CMP_CR1_WE_MASK                          0x40u
#define CMP_CR1_WE_SHIFT                         6
#define CMP_CR1_WE_WIDTH                         1
#define CMP_CR1_WE(x)                            (((uint8_t)(((uint8_t)(x))<<CMP_CR1_WE_SHIFT))&CMP_CR1_WE_MASK)
#define CMP_CR1_SE_MASK                          0x80u
#define CMP_CR1_SE_SHIFT                         7
#define CMP_CR1_SE_WIDTH                         1
#define CMP_CR1_SE(x)                            (((uint8_t)(((uint8_t)(x))<<CMP_CR1_SE_SHIFT))&CMP_CR1_SE_MASK)
/* FPR Bit Fields */
#define CMP_FPR_FILT_PER_MASK                    0xFFu
#define CMP_FPR_FILT_PER_SHIFT                   0
#define CMP_FPR_FILT_PER_WIDTH                   8
#define CMP_FPR_FILT_PER(x)                      (((uint8_t)(((uint8_t)(x))<<CMP_FPR_FILT_PER_SHIFT))&CMP_FPR_FILT_PER_MASK)
/* SCR Bit Fields */
#define CMP_SCR_COUT_MASK                        0x1u
#define CMP_SCR_COUT_SHIFT                       0
#define CMP_SCR_COUT_WIDTH                       1
#define CMP_SCR_COUT(x)                          (((uint8_t)(((uint8_t)(x))<<CMP_SCR_COUT_SHIFT))&CMP_SCR_COUT_MASK)
#define CMP_SCR_CFF_MASK                         0x2u
#define CMP_SCR_CFF_SHIFT                        1
#define CMP_SCR_CFF_WIDTH                        1
#define CMP_SCR_CFF(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_SCR_CFF_SHIFT))&CMP_SCR_CFF_MASK)
#define CMP_SCR_CFR_MASK                         0x4u
#define CMP_SCR_CFR_SHIFT                        2
#define CMP_SCR_CFR_WIDTH                        1
#define CMP_SCR_CFR(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_SCR_CFR_SHIFT))&CMP_SCR_CFR_MASK)
#define CMP_SCR_IEF_MASK                         0x8u
#define CMP_SCR_IEF_SHIFT                        3
#define CMP_SCR_IEF_WIDTH                        1
#define CMP_SCR_IEF(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_SCR_IEF_SHIFT))&CMP_SCR_IEF_MASK)
#define CMP_SCR_IER_MASK                         0x10u
#define CMP_SCR_IER_SHIFT                        4
#define CMP_SCR_IER_WIDTH                        1
#define CMP_SCR_IER(x)                           (((uint8_t)(((uint8_t)(x))<<CMP_SCR_IER_SHIFT))&CMP_SCR_IER_MASK)
#define CMP_SCR_DMAEN_MASK                       0x40u
#define CMP_SCR_DMAEN_SHIFT                      6
#define CMP_SCR_DMAEN_WIDTH                      1
#define CMP_SCR_DMAEN(x)                         (((uint8_t)(((uint8_t)(x))<<CMP_SCR_DMAEN_SHIFT))&CMP_SCR_DMAEN_MASK)
/* DACCR Bit Fields */
#define CMP_DACCR_VOSEL_MASK                     0x3Fu
#define CMP_DACCR_VOSEL_SHIFT                    0
#define CMP_DACCR_VOSEL_WIDTH                    6
#define CMP_DACCR_VOSEL(x)                       (((uint8_t)(((uint8_t)(x))<<CMP_DACCR_VOSEL_SHIFT))&CMP_DACCR_VOSEL_MASK)
#define CMP_DACCR_VRSEL_MASK                     0x40u
#define CMP_DACCR_VRSEL_SHIFT                    6
#define CMP_DACCR_VRSEL_WIDTH                    1
#define CMP_DACCR_VRSEL(x)                       (((uint8_t)(((uint8_t)(x))<<CMP_DACCR_VRSEL_SHIFT))&CMP_DACCR_VRSEL_MASK)
#define CMP_DACCR_DACEN_MASK                     0x80u
#define CMP_DACCR_DACEN_SHIFT                    7
#define CMP_DACCR_DACEN_WIDTH                    1
#define CMP_DACCR_DACEN(x)                       (((uint8_t)(((uint8_t)(x))<<CMP_DACCR_DACEN_SHIFT))&CMP_DACCR_DACEN_MASK)
/* MUXCR Bit Fields */
#define CMP_MUXCR_MSEL_MASK                      0x7u
#define CMP_MUXCR_MSEL_SHIFT                     0
#define CMP_MUXCR_MSEL_WIDTH                     3
#define CMP_MUXCR_MSEL(x)                        (((uint8_t)(((uint8_t)(x))<<CMP_MUXCR_MSEL_SHIFT))&CMP_MUXCR_MSEL_MASK)
#define CMP_MUXCR_PSEL_MASK                      0x38u
#define CMP_MUXCR_PSEL_SHIFT                     3
#define CMP_MUXCR_PSEL_WIDTH                     3
#define CMP_MUXCR_PSEL(x)                        (((uint8_t)(((uint8_t)(x))<<CMP_MUXCR_PSEL_SHIFT))&CMP_MUXCR_PSEL_MASK)

/*!
 * @}
 */ /* end of group CMP_Register_Masks */


/* CMP - Peripheral instance base addresses */
/** Peripheral CMP0 base address */
#define CMP0_BASE                                (0x40073000u)
/** Peripheral CMP0 base pointer */
#define CMP0                                     ((CMP_Type *)CMP0_BASE)
#define CMP0_BASE_PTR                            (CMP0)
/** Array initializer of CMP peripheral base addresses */
#define CMP_BASE_ADDRS                           { CMP0_BASE }
/** Array initializer of CMP peripheral base pointers */
#define CMP_BASE_PTRS                            { CMP0 }

/* ----------------------------------------------------------------------------
   -- CMP - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Accessor_Macros CMP - Register accessor macros
 * @{
 */


/* CMP - Register instance definitions */
/* CMP0 */
#define CMP0_CR0                                 CMP_CR0_REG(CMP0)
#define CMP0_CR1                                 CMP_CR1_REG(CMP0)
#define CMP0_FPR                                 CMP_FPR_REG(CMP0)
#define CMP0_SCR                                 CMP_SCR_REG(CMP0)
#define CMP0_DACCR                               CMP_DACCR_REG(CMP0)
#define CMP0_MUXCR                               CMP_MUXCR_REG(CMP0)

/*!
 * @}
 */ /* end of group CMP_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CMP_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    struct {                                         /* offset: 0x0 */
      __IO uint16_t DATAL;                             /**< CRC_DATAL register., offset: 0x0 */
      __IO uint16_t DATAH;                             /**< CRC_DATAH register., offset: 0x2 */
    } ACCESS16BIT;
    __IO uint32_t DATA;                              /**< CRC Data register, offset: 0x0 */
    struct {                                         /* offset: 0x0 */
      __IO uint8_t DATALL;                             /**< CRC_DATALL register., offset: 0x0 */
      __IO uint8_t DATALU;                             /**< CRC_DATALU register., offset: 0x1 */
      __IO uint8_t DATAHL;                             /**< CRC_DATAHL register., offset: 0x2 */
      __IO uint8_t DATAHU;                             /**< CRC_DATAHU register., offset: 0x3 */
    } ACCESS8BIT;
  };
  union {                                          /* offset: 0x4 */
    struct {                                         /* offset: 0x4 */
      __IO uint16_t GPOLYL;                            /**< CRC_GPOLYL register., offset: 0x4 */
      __IO uint16_t GPOLYH;                            /**< CRC_GPOLYH register., offset: 0x6 */
    } GPOLY_ACCESS16BIT;
    __IO uint32_t GPOLY;                             /**< CRC Polynomial register, offset: 0x4 */
    struct {                                         /* offset: 0x4 */
      __IO uint8_t GPOLYLL;                            /**< CRC_GPOLYLL register., offset: 0x4 */
      __IO uint8_t GPOLYLU;                            /**< CRC_GPOLYLU register., offset: 0x5 */
      __IO uint8_t GPOLYHL;                            /**< CRC_GPOLYHL register., offset: 0x6 */
      __IO uint8_t GPOLYHU;                            /**< CRC_GPOLYHU register., offset: 0x7 */
    } GPOLY_ACCESS8BIT;
  };
  union {                                          /* offset: 0x8 */
    __IO uint32_t CTRL;                              /**< CRC Control register, offset: 0x8 */
    struct {                                         /* offset: 0x8 */
           uint8_t RESERVED_0[3];
      __IO uint8_t CTRLHU;                             /**< CRC_CTRLHU register., offset: 0xB */
    } CTRL_ACCESS8BIT;
  };
} CRC_Type, *CRC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- CRC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Accessor_Macros CRC - Register accessor macros
 * @{
 */


/* CRC - Register accessors */
#define CRC_DATAL_REG(base)                      ((base)->ACCESS16BIT.DATAL)
#define CRC_DATAH_REG(base)                      ((base)->ACCESS16BIT.DATAH)
#define CRC_DATA_REG(base)                       ((base)->DATA)
#define CRC_DATALL_REG(base)                     ((base)->ACCESS8BIT.DATALL)
#define CRC_DATALU_REG(base)                     ((base)->ACCESS8BIT.DATALU)
#define CRC_DATAHL_REG(base)                     ((base)->ACCESS8BIT.DATAHL)
#define CRC_DATAHU_REG(base)                     ((base)->ACCESS8BIT.DATAHU)
#define CRC_GPOLYL_REG(base)                     ((base)->GPOLY_ACCESS16BIT.GPOLYL)
#define CRC_GPOLYH_REG(base)                     ((base)->GPOLY_ACCESS16BIT.GPOLYH)
#define CRC_GPOLY_REG(base)                      ((base)->GPOLY)
#define CRC_GPOLYLL_REG(base)                    ((base)->GPOLY_ACCESS8BIT.GPOLYLL)
#define CRC_GPOLYLU_REG(base)                    ((base)->GPOLY_ACCESS8BIT.GPOLYLU)
#define CRC_GPOLYHL_REG(base)                    ((base)->GPOLY_ACCESS8BIT.GPOLYHL)
#define CRC_GPOLYHU_REG(base)                    ((base)->GPOLY_ACCESS8BIT.GPOLYHU)
#define CRC_CTRL_REG(base)                       ((base)->CTRL)
#define CRC_CTRLHU_REG(base)                     ((base)->CTRL_ACCESS8BIT.CTRLHU)

/*!
 * @}
 */ /* end of group CRC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/* DATAL Bit Fields */
#define CRC_DATAL_DATAL_MASK                     0xFFFFu
#define CRC_DATAL_DATAL_SHIFT                    0
#define CRC_DATAL_DATAL_WIDTH                    16
#define CRC_DATAL_DATAL(x)                       (((uint16_t)(((uint16_t)(x))<<CRC_DATAL_DATAL_SHIFT))&CRC_DATAL_DATAL_MASK)
/* DATAH Bit Fields */
#define CRC_DATAH_DATAH_MASK                     0xFFFFu
#define CRC_DATAH_DATAH_SHIFT                    0
#define CRC_DATAH_DATAH_WIDTH                    16
#define CRC_DATAH_DATAH(x)                       (((uint16_t)(((uint16_t)(x))<<CRC_DATAH_DATAH_SHIFT))&CRC_DATAH_DATAH_MASK)
/* DATA Bit Fields */
#define CRC_DATA_LL_MASK                         0xFFu
#define CRC_DATA_LL_SHIFT                        0
#define CRC_DATA_LL_WIDTH                        8
#define CRC_DATA_LL(x)                           (((uint32_t)(((uint32_t)(x))<<CRC_DATA_LL_SHIFT))&CRC_DATA_LL_MASK)
#define CRC_DATA_LU_MASK                         0xFF00u
#define CRC_DATA_LU_SHIFT                        8
#define CRC_DATA_LU_WIDTH                        8
#define CRC_DATA_LU(x)                           (((uint32_t)(((uint32_t)(x))<<CRC_DATA_LU_SHIFT))&CRC_DATA_LU_MASK)
#define CRC_DATA_HL_MASK                         0xFF0000u
#define CRC_DATA_HL_SHIFT                        16
#define CRC_DATA_HL_WIDTH                        8
#define CRC_DATA_HL(x)                           (((uint32_t)(((uint32_t)(x))<<CRC_DATA_HL_SHIFT))&CRC_DATA_HL_MASK)
#define CRC_DATA_HU_MASK                         0xFF000000u
#define CRC_DATA_HU_SHIFT                        24
#define CRC_DATA_HU_WIDTH                        8
#define CRC_DATA_HU(x)                           (((uint32_t)(((uint32_t)(x))<<CRC_DATA_HU_SHIFT))&CRC_DATA_HU_MASK)
/* DATALL Bit Fields */
#define CRC_DATALL_DATALL_MASK                   0xFFu
#define CRC_DATALL_DATALL_SHIFT                  0
#define CRC_DATALL_DATALL_WIDTH                  8
#define CRC_DATALL_DATALL(x)                     (((uint8_t)(((uint8_t)(x))<<CRC_DATALL_DATALL_SHIFT))&CRC_DATALL_DATALL_MASK)
/* DATALU Bit Fields */
#define CRC_DATALU_DATALU_MASK                   0xFFu
#define CRC_DATALU_DATALU_SHIFT                  0
#define CRC_DATALU_DATALU_WIDTH                  8
#define CRC_DATALU_DATALU(x)                     (((uint8_t)(((uint8_t)(x))<<CRC_DATALU_DATALU_SHIFT))&CRC_DATALU_DATALU_MASK)
/* DATAHL Bit Fields */
#define CRC_DATAHL_DATAHL_MASK                   0xFFu
#define CRC_DATAHL_DATAHL_SHIFT                  0
#define CRC_DATAHL_DATAHL_WIDTH                  8
#define CRC_DATAHL_DATAHL(x)                     (((uint8_t)(((uint8_t)(x))<<CRC_DATAHL_DATAHL_SHIFT))&CRC_DATAHL_DATAHL_MASK)
/* DATAHU Bit Fields */
#define CRC_DATAHU_DATAHU_MASK                   0xFFu
#define CRC_DATAHU_DATAHU_SHIFT                  0
#define CRC_DATAHU_DATAHU_WIDTH                  8
#define CRC_DATAHU_DATAHU(x)                     (((uint8_t)(((uint8_t)(x))<<CRC_DATAHU_DATAHU_SHIFT))&CRC_DATAHU_DATAHU_MASK)
/* GPOLYL Bit Fields */
#define CRC_GPOLYL_GPOLYL_MASK                   0xFFFFu
#define CRC_GPOLYL_GPOLYL_SHIFT                  0
#define CRC_GPOLYL_GPOLYL_WIDTH                  16
#define CRC_GPOLYL_GPOLYL(x)                     (((uint16_t)(((uint16_t)(x))<<CRC_GPOLYL_GPOLYL_SHIFT))&CRC_GPOLYL_GPOLYL_MASK)
/* GPOLYH Bit Fields */
#define CRC_GPOLYH_GPOLYH_MASK                   0xFFFFu
#define CRC_GPOLYH_GPOLYH_SHIFT                  0
#define CRC_GPOLYH_GPOLYH_WIDTH                  16
#define CRC_GPOLYH_GPOLYH(x)                     (((uint16_t)(((uint16_t)(x))<<CRC_GPOLYH_GPOLYH_SHIFT))&CRC_GPOLYH_GPOLYH_MASK)
/* GPOLY Bit Fields */
#define CRC_GPOLY_LOW_MASK                       0xFFFFu
#define CRC_GPOLY_LOW_SHIFT                      0
#define CRC_GPOLY_LOW_WIDTH                      16
#define CRC_GPOLY_LOW(x)                         (((uint32_t)(((uint32_t)(x))<<CRC_GPOLY_LOW_SHIFT))&CRC_GPOLY_LOW_MASK)
#define CRC_GPOLY_HIGH_MASK                      0xFFFF0000u
#define CRC_GPOLY_HIGH_SHIFT                     16
#define CRC_GPOLY_HIGH_WIDTH                     16
#define CRC_GPOLY_HIGH(x)                        (((uint32_t)(((uint32_t)(x))<<CRC_GPOLY_HIGH_SHIFT))&CRC_GPOLY_HIGH_MASK)
/* GPOLYLL Bit Fields */
#define CRC_GPOLYLL_GPOLYLL_MASK                 0xFFu
#define CRC_GPOLYLL_GPOLYLL_SHIFT                0
#define CRC_GPOLYLL_GPOLYLL_WIDTH                8
#define CRC_GPOLYLL_GPOLYLL(x)                   (((uint8_t)(((uint8_t)(x))<<CRC_GPOLYLL_GPOLYLL_SHIFT))&CRC_GPOLYLL_GPOLYLL_MASK)
/* GPOLYLU Bit Fields */
#define CRC_GPOLYLU_GPOLYLU_MASK                 0xFFu
#define CRC_GPOLYLU_GPOLYLU_SHIFT                0
#define CRC_GPOLYLU_GPOLYLU_WIDTH                8
#define CRC_GPOLYLU_GPOLYLU(x)                   (((uint8_t)(((uint8_t)(x))<<CRC_GPOLYLU_GPOLYLU_SHIFT))&CRC_GPOLYLU_GPOLYLU_MASK)
/* GPOLYHL Bit Fields */
#define CRC_GPOLYHL_GPOLYHL_MASK                 0xFFu
#define CRC_GPOLYHL_GPOLYHL_SHIFT                0
#define CRC_GPOLYHL_GPOLYHL_WIDTH                8
#define CRC_GPOLYHL_GPOLYHL(x)                   (((uint8_t)(((uint8_t)(x))<<CRC_GPOLYHL_GPOLYHL_SHIFT))&CRC_GPOLYHL_GPOLYHL_MASK)
/* GPOLYHU Bit Fields */
#define CRC_GPOLYHU_GPOLYHU_MASK                 0xFFu
#define CRC_GPOLYHU_GPOLYHU_SHIFT                0
#define CRC_GPOLYHU_GPOLYHU_WIDTH                8
#define CRC_GPOLYHU_GPOLYHU(x)                   (((uint8_t)(((uint8_t)(x))<<CRC_GPOLYHU_GPOLYHU_SHIFT))&CRC_GPOLYHU_GPOLYHU_MASK)
/* CTRL Bit Fields */
#define CRC_CTRL_TCRC_MASK                       0x1000000u
#define CRC_CTRL_TCRC_SHIFT                      24
#define CRC_CTRL_TCRC_WIDTH                      1
#define CRC_CTRL_TCRC(x)                         (((uint32_t)(((uint32_t)(x))<<CRC_CTRL_TCRC_SHIFT))&CRC_CTRL_TCRC_MASK)
#define CRC_CTRL_WAS_MASK                        0x2000000u
#define CRC_CTRL_WAS_SHIFT                       25
#define CRC_CTRL_WAS_WIDTH                       1
#define CRC_CTRL_WAS(x)                          (((uint32_t)(((uint32_t)(x))<<CRC_CTRL_WAS_SHIFT))&CRC_CTRL_WAS_MASK)
#define CRC_CTRL_FXOR_MASK                       0x4000000u
#define CRC_CTRL_FXOR_SHIFT                      26
#define CRC_CTRL_FXOR_WIDTH                      1
#define CRC_CTRL_FXOR(x)                         (((uint32_t)(((uint32_t)(x))<<CRC_CTRL_FXOR_SHIFT))&CRC_CTRL_FXOR_MASK)
#define CRC_CTRL_TOTR_MASK                       0x30000000u
#define CRC_CTRL_TOTR_SHIFT                      28
#define CRC_CTRL_TOTR_WIDTH                      2
#define CRC_CTRL_TOTR(x)                         (((uint32_t)(((uint32_t)(x))<<CRC_CTRL_TOTR_SHIFT))&CRC_CTRL_TOTR_MASK)
#define CRC_CTRL_TOT_MASK                        0xC0000000u
#define CRC_CTRL_TOT_SHIFT                       30
#define CRC_CTRL_TOT_WIDTH                       2
#define CRC_CTRL_TOT(x)                          (((uint32_t)(((uint32_t)(x))<<CRC_CTRL_TOT_SHIFT))&CRC_CTRL_TOT_MASK)
/* CTRLHU Bit Fields */
#define CRC_CTRLHU_TCRC_MASK                     0x1u
#define CRC_CTRLHU_TCRC_SHIFT                    0
#define CRC_CTRLHU_TCRC_WIDTH                    1
#define CRC_CTRLHU_TCRC(x)                       (((uint8_t)(((uint8_t)(x))<<CRC_CTRLHU_TCRC_SHIFT))&CRC_CTRLHU_TCRC_MASK)
#define CRC_CTRLHU_WAS_MASK                      0x2u
#define CRC_CTRLHU_WAS_SHIFT                     1
#define CRC_CTRLHU_WAS_WIDTH                     1
#define CRC_CTRLHU_WAS(x)                        (((uint8_t)(((uint8_t)(x))<<CRC_CTRLHU_WAS_SHIFT))&CRC_CTRLHU_WAS_MASK)
#define CRC_CTRLHU_FXOR_MASK                     0x4u
#define CRC_CTRLHU_FXOR_SHIFT                    2
#define CRC_CTRLHU_FXOR_WIDTH                    1
#define CRC_CTRLHU_FXOR(x)                       (((uint8_t)(((uint8_t)(x))<<CRC_CTRLHU_FXOR_SHIFT))&CRC_CTRLHU_FXOR_MASK)
#define CRC_CTRLHU_TOTR_MASK                     0x30u
#define CRC_CTRLHU_TOTR_SHIFT                    4
#define CRC_CTRLHU_TOTR_WIDTH                    2
#define CRC_CTRLHU_TOTR(x)                       (((uint8_t)(((uint8_t)(x))<<CRC_CTRLHU_TOTR_SHIFT))&CRC_CTRLHU_TOTR_MASK)
#define CRC_CTRLHU_TOT_MASK                      0xC0u
#define CRC_CTRLHU_TOT_SHIFT                     6
#define CRC_CTRLHU_TOT_WIDTH                     2
#define CRC_CTRLHU_TOT(x)                        (((uint8_t)(((uint8_t)(x))<<CRC_CTRLHU_TOT_SHIFT))&CRC_CTRLHU_TOT_MASK)

/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
/** Peripheral CRC base address */
#define CRC_BASE                                 (0x40032000u)
/** Peripheral CRC base pointer */
#define CRC0                                     ((CRC_Type *)CRC_BASE)
#define CRC_BASE_PTR                             (CRC0)
/** Array initializer of CRC peripheral base addresses */
#define CRC_BASE_ADDRS                           { CRC_BASE }
/** Array initializer of CRC peripheral base pointers */
#define CRC_BASE_PTRS                            { CRC0 }

/* ----------------------------------------------------------------------------
   -- CRC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Accessor_Macros CRC - Register accessor macros
 * @{
 */


/* CRC - Register instance definitions */
/* CRC */
#define CRC_DATA                                 CRC_DATA_REG(CRC0)
#define CRC_DATAL                                CRC_DATAL_REG(CRC0)
#define CRC_DATALL                               CRC_DATALL_REG(CRC0)
#define CRC_DATALU                               CRC_DATALU_REG(CRC0)
#define CRC_DATAH                                CRC_DATAH_REG(CRC0)
#define CRC_DATAHL                               CRC_DATAHL_REG(CRC0)
#define CRC_DATAHU                               CRC_DATAHU_REG(CRC0)
#define CRC_GPOLY                                CRC_GPOLY_REG(CRC0)
#define CRC_GPOLYL                               CRC_GPOLYL_REG(CRC0)
#define CRC_GPOLYLL                              CRC_GPOLYLL_REG(CRC0)
#define CRC_GPOLYLU                              CRC_GPOLYLU_REG(CRC0)
#define CRC_GPOLYH                               CRC_GPOLYH_REG(CRC0)
#define CRC_GPOLYHL                              CRC_GPOLYHL_REG(CRC0)
#define CRC_GPOLYHU                              CRC_GPOLYHU_REG(CRC0)
#define CRC_CTRL                                 CRC_CTRL_REG(CRC0)
#define CRC_CTRLHU                               CRC_CTRLHU_REG(CRC0)

/*!
 * @}
 */ /* end of group CRC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DAC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Peripheral_Access_Layer DAC Peripheral Access Layer
 * @{
 */

/** DAC - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x2 */
    __IO uint8_t DATL;                               /**< DAC Data Low Register, array offset: 0x0, array step: 0x2 */
    __IO uint8_t DATH;                               /**< DAC Data High Register, array offset: 0x1, array step: 0x2 */
  } DAT[16];
  __IO uint8_t SR;                                 /**< DAC Status Register, offset: 0x20 */
  __IO uint8_t C0;                                 /**< DAC Control Register, offset: 0x21 */
  __IO uint8_t C1;                                 /**< DAC Control Register 1, offset: 0x22 */
  __IO uint8_t C2;                                 /**< DAC Control Register 2, offset: 0x23 */
} DAC_Type, *DAC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DAC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Register_Accessor_Macros DAC - Register accessor macros
 * @{
 */


/* DAC - Register accessors */
#define DAC_DATL_REG(base,index)                 ((base)->DAT[index].DATL)
#define DAC_DATL_COUNT                           16
#define DAC_DATH_REG(base,index)                 ((base)->DAT[index].DATH)
#define DAC_DATH_COUNT                           16
#define DAC_SR_REG(base)                         ((base)->SR)
#define DAC_C0_REG(base)                         ((base)->C0)
#define DAC_C1_REG(base)                         ((base)->C1)
#define DAC_C2_REG(base)                         ((base)->C2)

/*!
 * @}
 */ /* end of group DAC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DAC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Register_Masks DAC Register Masks
 * @{
 */

/* DATL Bit Fields */
#define DAC_DATL_DATA0_MASK                      0xFFu
#define DAC_DATL_DATA0_SHIFT                     0
#define DAC_DATL_DATA0_WIDTH                     8
#define DAC_DATL_DATA0(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_DATL_DATA0_SHIFT))&DAC_DATL_DATA0_MASK)
/* DATH Bit Fields */
#define DAC_DATH_DATA1_MASK                      0xFu
#define DAC_DATH_DATA1_SHIFT                     0
#define DAC_DATH_DATA1_WIDTH                     4
#define DAC_DATH_DATA1(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_DATH_DATA1_SHIFT))&DAC_DATH_DATA1_MASK)
/* SR Bit Fields */
#define DAC_SR_DACBFRPBF_MASK                    0x1u
#define DAC_SR_DACBFRPBF_SHIFT                   0
#define DAC_SR_DACBFRPBF_WIDTH                   1
#define DAC_SR_DACBFRPBF(x)                      (((uint8_t)(((uint8_t)(x))<<DAC_SR_DACBFRPBF_SHIFT))&DAC_SR_DACBFRPBF_MASK)
#define DAC_SR_DACBFRPTF_MASK                    0x2u
#define DAC_SR_DACBFRPTF_SHIFT                   1
#define DAC_SR_DACBFRPTF_WIDTH                   1
#define DAC_SR_DACBFRPTF(x)                      (((uint8_t)(((uint8_t)(x))<<DAC_SR_DACBFRPTF_SHIFT))&DAC_SR_DACBFRPTF_MASK)
#define DAC_SR_DACBFWMF_MASK                     0x4u
#define DAC_SR_DACBFWMF_SHIFT                    2
#define DAC_SR_DACBFWMF_WIDTH                    1
#define DAC_SR_DACBFWMF(x)                       (((uint8_t)(((uint8_t)(x))<<DAC_SR_DACBFWMF_SHIFT))&DAC_SR_DACBFWMF_MASK)
/* C0 Bit Fields */
#define DAC_C0_DACBBIEN_MASK                     0x1u
#define DAC_C0_DACBBIEN_SHIFT                    0
#define DAC_C0_DACBBIEN_WIDTH                    1
#define DAC_C0_DACBBIEN(x)                       (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACBBIEN_SHIFT))&DAC_C0_DACBBIEN_MASK)
#define DAC_C0_DACBTIEN_MASK                     0x2u
#define DAC_C0_DACBTIEN_SHIFT                    1
#define DAC_C0_DACBTIEN_WIDTH                    1
#define DAC_C0_DACBTIEN(x)                       (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACBTIEN_SHIFT))&DAC_C0_DACBTIEN_MASK)
#define DAC_C0_DACBWIEN_MASK                     0x4u
#define DAC_C0_DACBWIEN_SHIFT                    2
#define DAC_C0_DACBWIEN_WIDTH                    1
#define DAC_C0_DACBWIEN(x)                       (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACBWIEN_SHIFT))&DAC_C0_DACBWIEN_MASK)
#define DAC_C0_LPEN_MASK                         0x8u
#define DAC_C0_LPEN_SHIFT                        3
#define DAC_C0_LPEN_WIDTH                        1
#define DAC_C0_LPEN(x)                           (((uint8_t)(((uint8_t)(x))<<DAC_C0_LPEN_SHIFT))&DAC_C0_LPEN_MASK)
#define DAC_C0_DACSWTRG_MASK                     0x10u
#define DAC_C0_DACSWTRG_SHIFT                    4
#define DAC_C0_DACSWTRG_WIDTH                    1
#define DAC_C0_DACSWTRG(x)                       (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACSWTRG_SHIFT))&DAC_C0_DACSWTRG_MASK)
#define DAC_C0_DACTRGSEL_MASK                    0x20u
#define DAC_C0_DACTRGSEL_SHIFT                   5
#define DAC_C0_DACTRGSEL_WIDTH                   1
#define DAC_C0_DACTRGSEL(x)                      (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACTRGSEL_SHIFT))&DAC_C0_DACTRGSEL_MASK)
#define DAC_C0_DACRFS_MASK                       0x40u
#define DAC_C0_DACRFS_SHIFT                      6
#define DAC_C0_DACRFS_WIDTH                      1
#define DAC_C0_DACRFS(x)                         (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACRFS_SHIFT))&DAC_C0_DACRFS_MASK)
#define DAC_C0_DACEN_MASK                        0x80u
#define DAC_C0_DACEN_SHIFT                       7
#define DAC_C0_DACEN_WIDTH                       1
#define DAC_C0_DACEN(x)                          (((uint8_t)(((uint8_t)(x))<<DAC_C0_DACEN_SHIFT))&DAC_C0_DACEN_MASK)
/* C1 Bit Fields */
#define DAC_C1_DACBFEN_MASK                      0x1u
#define DAC_C1_DACBFEN_SHIFT                     0
#define DAC_C1_DACBFEN_WIDTH                     1
#define DAC_C1_DACBFEN(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_C1_DACBFEN_SHIFT))&DAC_C1_DACBFEN_MASK)
#define DAC_C1_DACBFMD_MASK                      0x6u
#define DAC_C1_DACBFMD_SHIFT                     1
#define DAC_C1_DACBFMD_WIDTH                     2
#define DAC_C1_DACBFMD(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_C1_DACBFMD_SHIFT))&DAC_C1_DACBFMD_MASK)
#define DAC_C1_DACBFWM_MASK                      0x18u
#define DAC_C1_DACBFWM_SHIFT                     3
#define DAC_C1_DACBFWM_WIDTH                     2
#define DAC_C1_DACBFWM(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_C1_DACBFWM_SHIFT))&DAC_C1_DACBFWM_MASK)
#define DAC_C1_DMAEN_MASK                        0x80u
#define DAC_C1_DMAEN_SHIFT                       7
#define DAC_C1_DMAEN_WIDTH                       1
#define DAC_C1_DMAEN(x)                          (((uint8_t)(((uint8_t)(x))<<DAC_C1_DMAEN_SHIFT))&DAC_C1_DMAEN_MASK)
/* C2 Bit Fields */
#define DAC_C2_DACBFUP_MASK                      0xFu
#define DAC_C2_DACBFUP_SHIFT                     0
#define DAC_C2_DACBFUP_WIDTH                     4
#define DAC_C2_DACBFUP(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_C2_DACBFUP_SHIFT))&DAC_C2_DACBFUP_MASK)
#define DAC_C2_DACBFRP_MASK                      0xF0u
#define DAC_C2_DACBFRP_SHIFT                     4
#define DAC_C2_DACBFRP_WIDTH                     4
#define DAC_C2_DACBFRP(x)                        (((uint8_t)(((uint8_t)(x))<<DAC_C2_DACBFRP_SHIFT))&DAC_C2_DACBFRP_MASK)

/*!
 * @}
 */ /* end of group DAC_Register_Masks */


/* DAC - Peripheral instance base addresses */
/** Peripheral DAC0 base address */
#define DAC0_BASE                                (0x4003F000u)
/** Peripheral DAC0 base pointer */
#define DAC0                                     ((DAC_Type *)DAC0_BASE)
#define DAC0_BASE_PTR                            (DAC0)
/** Array initializer of DAC peripheral base addresses */
#define DAC_BASE_ADDRS                           { DAC0_BASE }
/** Array initializer of DAC peripheral base pointers */
#define DAC_BASE_PTRS                            { DAC0 }

/* ----------------------------------------------------------------------------
   -- DAC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DAC_Register_Accessor_Macros DAC - Register accessor macros
 * @{
 */


/* DAC - Register instance definitions */
/* DAC0 */
#define DAC0_DAT0L                               DAC_DATL_REG(DAC0,0)
#define DAC0_DAT0H                               DAC_DATH_REG(DAC0,0)
#define DAC0_DAT1L                               DAC_DATL_REG(DAC0,1)
#define DAC0_DAT1H                               DAC_DATH_REG(DAC0,1)
#define DAC0_DAT2L                               DAC_DATL_REG(DAC0,2)
#define DAC0_DAT2H                               DAC_DATH_REG(DAC0,2)
#define DAC0_DAT3L                               DAC_DATL_REG(DAC0,3)
#define DAC0_DAT3H                               DAC_DATH_REG(DAC0,3)
#define DAC0_DAT4L                               DAC_DATL_REG(DAC0,4)
#define DAC0_DAT4H                               DAC_DATH_REG(DAC0,4)
#define DAC0_DAT5L                               DAC_DATL_REG(DAC0,5)
#define DAC0_DAT5H                               DAC_DATH_REG(DAC0,5)
#define DAC0_DAT6L                               DAC_DATL_REG(DAC0,6)
#define DAC0_DAT6H                               DAC_DATH_REG(DAC0,6)
#define DAC0_DAT7L                               DAC_DATL_REG(DAC0,7)
#define DAC0_DAT7H                               DAC_DATH_REG(DAC0,7)
#define DAC0_DAT8L                               DAC_DATL_REG(DAC0,8)
#define DAC0_DAT8H                               DAC_DATH_REG(DAC0,8)
#define DAC0_DAT9L                               DAC_DATL_REG(DAC0,9)
#define DAC0_DAT9H                               DAC_DATH_REG(DAC0,9)
#define DAC0_DAT10L                              DAC_DATL_REG(DAC0,10)
#define DAC0_DAT10H                              DAC_DATH_REG(DAC0,10)
#define DAC0_DAT11L                              DAC_DATL_REG(DAC0,11)
#define DAC0_DAT11H                              DAC_DATH_REG(DAC0,11)
#define DAC0_DAT12L                              DAC_DATL_REG(DAC0,12)
#define DAC0_DAT12H                              DAC_DATH_REG(DAC0,12)
#define DAC0_DAT13L                              DAC_DATL_REG(DAC0,13)
#define DAC0_DAT13H                              DAC_DATH_REG(DAC0,13)
#define DAC0_DAT14L                              DAC_DATL_REG(DAC0,14)
#define DAC0_DAT14H                              DAC_DATH_REG(DAC0,14)
#define DAC0_DAT15L                              DAC_DATL_REG(DAC0,15)
#define DAC0_DAT15H                              DAC_DATH_REG(DAC0,15)
#define DAC0_SR                                  DAC_SR_REG(DAC0)
#define DAC0_C0                                  DAC_C0_REG(DAC0)
#define DAC0_C1                                  DAC_C1_REG(DAC0)
#define DAC0_C2                                  DAC_C2_REG(DAC0)

/* DAC - Register array accessors */
#define DAC0_DATL(index)                         DAC_DATL_REG(DAC0,index)
#define DAC0_DATH(index)                         DAC_DATH_REG(DAC0,index)

/*!
 * @}
 */ /* end of group DAC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DAC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t CR;                                /**< Control Register, offset: 0x0 */
  __I  uint32_t ES;                                /**< Error Status Register, offset: 0x4 */
       uint8_t RESERVED_0[4];
  __IO uint32_t ERQ;                               /**< Enable Request Register, offset: 0xC */
       uint8_t RESERVED_1[4];
  __IO uint32_t EEI;                               /**< Enable Error Interrupt Register, offset: 0x14 */
  __O  uint8_t CEEI;                               /**< Clear Enable Error Interrupt Register, offset: 0x18 */
  __O  uint8_t SEEI;                               /**< Set Enable Error Interrupt Register, offset: 0x19 */
  __O  uint8_t CERQ;                               /**< Clear Enable Request Register, offset: 0x1A */
  __O  uint8_t SERQ;                               /**< Set Enable Request Register, offset: 0x1B */
  __O  uint8_t CDNE;                               /**< Clear DONE Status Bit Register, offset: 0x1C */
  __O  uint8_t SSRT;                               /**< Set START Bit Register, offset: 0x1D */
  __O  uint8_t CERR;                               /**< Clear Error Register, offset: 0x1E */
  __O  uint8_t CINT;                               /**< Clear Interrupt Request Register, offset: 0x1F */
       uint8_t RESERVED_2[4];
  __IO uint32_t INT;                               /**< Interrupt Request Register, offset: 0x24 */
       uint8_t RESERVED_3[4];
  __IO uint32_t ERR;                               /**< Error Register, offset: 0x2C */
       uint8_t RESERVED_4[4];
  __I  uint32_t HRS;                               /**< Hardware Request Status Register, offset: 0x34 */
       uint8_t RESERVED_5[12];
  __IO uint32_t EARS;                              /**< Enable Asynchronous Request in Stop Register, offset: 0x44 */
       uint8_t RESERVED_6[184];
  __IO uint8_t DCHPRI3;                            /**< Channel n Priority Register, offset: 0x100 */
  __IO uint8_t DCHPRI2;                            /**< Channel n Priority Register, offset: 0x101 */
  __IO uint8_t DCHPRI1;                            /**< Channel n Priority Register, offset: 0x102 */
  __IO uint8_t DCHPRI0;                            /**< Channel n Priority Register, offset: 0x103 */
  __IO uint8_t DCHPRI7;                            /**< Channel n Priority Register, offset: 0x104 */
  __IO uint8_t DCHPRI6;                            /**< Channel n Priority Register, offset: 0x105 */
  __IO uint8_t DCHPRI5;                            /**< Channel n Priority Register, offset: 0x106 */
  __IO uint8_t DCHPRI4;                            /**< Channel n Priority Register, offset: 0x107 */
       uint8_t RESERVED_7[3832];
  struct {                                         /* offset: 0x1000, array step: 0x20 */
    __IO uint32_t SADDR;                             /**< TCD Source Address, array offset: 0x1000, array step: 0x20 */
    __IO uint16_t SOFF;                              /**< TCD Signed Source Address Offset, array offset: 0x1004, array step: 0x20 */
    __IO uint16_t ATTR;                              /**< TCD Transfer Attributes, array offset: 0x1006, array step: 0x20 */
    union {                                          /* offset: 0x1008, array step: 0x20 */
      __IO uint32_t NBYTES_MLNO;                       /**< TCD Minor Byte Count (Minor Loop Mapping Disabled), array offset: 0x1008, array step: 0x20 */
      __IO uint32_t NBYTES_MLOFFNO;                    /**< TCD Signed Minor Loop Offset (Minor Loop Mapping Enabled and Offset Disabled), array offset: 0x1008, array step: 0x20 */
      __IO uint32_t NBYTES_MLOFFYES;                   /**< TCD Signed Minor Loop Offset (Minor Loop Mapping and Offset Enabled), array offset: 0x1008, array step: 0x20 */
    };
    __IO uint32_t SLAST;                             /**< TCD Last Source Address Adjustment, array offset: 0x100C, array step: 0x20 */
    __IO uint32_t DADDR;                             /**< TCD Destination Address, array offset: 0x1010, array step: 0x20 */
    __IO uint16_t DOFF;                              /**< TCD Signed Destination Address Offset, array offset: 0x1014, array step: 0x20 */
    union {                                          /* offset: 0x1016, array step: 0x20 */
      __IO uint16_t CITER_ELINKNO;                     /**< TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled), array offset: 0x1016, array step: 0x20 */
      __IO uint16_t CITER_ELINKYES;                    /**< TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled), array offset: 0x1016, array step: 0x20 */
    };
    __IO uint32_t DLAST_SGA;                         /**< TCD Last Destination Address Adjustment/Scatter Gather Address, array offset: 0x1018, array step: 0x20 */
    __IO uint16_t CSR;                               /**< TCD Control and Status, array offset: 0x101C, array step: 0x20 */
    union {                                          /* offset: 0x101E, array step: 0x20 */
      __IO uint16_t BITER_ELINKNO;                     /**< TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled), array offset: 0x101E, array step: 0x20 */
      __IO uint16_t BITER_ELINKYES;                    /**< TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled), array offset: 0x101E, array step: 0x20 */
    };
  } TCD[8];
} DMA_Type, *DMA_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DMA - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Accessor_Macros DMA - Register accessor macros
 * @{
 */


/* DMA - Register accessors */
#define DMA_CR_REG(base)                         ((base)->CR)
#define DMA_ES_REG(base)                         ((base)->ES)
#define DMA_ERQ_REG(base)                        ((base)->ERQ)
#define DMA_EEI_REG(base)                        ((base)->EEI)
#define DMA_CEEI_REG(base)                       ((base)->CEEI)
#define DMA_SEEI_REG(base)                       ((base)->SEEI)
#define DMA_CERQ_REG(base)                       ((base)->CERQ)
#define DMA_SERQ_REG(base)                       ((base)->SERQ)
#define DMA_CDNE_REG(base)                       ((base)->CDNE)
#define DMA_SSRT_REG(base)                       ((base)->SSRT)
#define DMA_CERR_REG(base)                       ((base)->CERR)
#define DMA_CINT_REG(base)                       ((base)->CINT)
#define DMA_INT_REG(base)                        ((base)->INT)
#define DMA_ERR_REG(base)                        ((base)->ERR)
#define DMA_HRS_REG(base)                        ((base)->HRS)
#define DMA_EARS_REG(base)                       ((base)->EARS)
#define DMA_DCHPRI3_REG(base)                    ((base)->DCHPRI3)
#define DMA_DCHPRI2_REG(base)                    ((base)->DCHPRI2)
#define DMA_DCHPRI1_REG(base)                    ((base)->DCHPRI1)
#define DMA_DCHPRI0_REG(base)                    ((base)->DCHPRI0)
#define DMA_DCHPRI7_REG(base)                    ((base)->DCHPRI7)
#define DMA_DCHPRI6_REG(base)                    ((base)->DCHPRI6)
#define DMA_DCHPRI5_REG(base)                    ((base)->DCHPRI5)
#define DMA_DCHPRI4_REG(base)                    ((base)->DCHPRI4)
#define DMA_SADDR_REG(base,index)                ((base)->TCD[index].SADDR)
#define DMA_SADDR_COUNT                          8
#define DMA_SOFF_REG(base,index)                 ((base)->TCD[index].SOFF)
#define DMA_SOFF_COUNT                           8
#define DMA_ATTR_REG(base,index)                 ((base)->TCD[index].ATTR)
#define DMA_ATTR_COUNT                           8
#define DMA_NBYTES_MLNO_REG(base,index)          ((base)->TCD[index].NBYTES_MLNO)
#define DMA_NBYTES_MLNO_COUNT                    8
#define DMA_NBYTES_MLOFFNO_REG(base,index)       ((base)->TCD[index].NBYTES_MLOFFNO)
#define DMA_NBYTES_MLOFFNO_COUNT                 8
#define DMA_NBYTES_MLOFFYES_REG(base,index)      ((base)->TCD[index].NBYTES_MLOFFYES)
#define DMA_NBYTES_MLOFFYES_COUNT                8
#define DMA_SLAST_REG(base,index)                ((base)->TCD[index].SLAST)
#define DMA_SLAST_COUNT                          8
#define DMA_DADDR_REG(base,index)                ((base)->TCD[index].DADDR)
#define DMA_DADDR_COUNT                          8
#define DMA_DOFF_REG(base,index)                 ((base)->TCD[index].DOFF)
#define DMA_DOFF_COUNT                           8
#define DMA_CITER_ELINKNO_REG(base,index)        ((base)->TCD[index].CITER_ELINKNO)
#define DMA_CITER_ELINKNO_COUNT                  8
#define DMA_CITER_ELINKYES_REG(base,index)       ((base)->TCD[index].CITER_ELINKYES)
#define DMA_CITER_ELINKYES_COUNT                 8
#define DMA_DLAST_SGA_REG(base,index)            ((base)->TCD[index].DLAST_SGA)
#define DMA_DLAST_SGA_COUNT                      8
#define DMA_CSR_REG(base,index)                  ((base)->TCD[index].CSR)
#define DMA_CSR_COUNT                            8
#define DMA_BITER_ELINKNO_REG(base,index)        ((base)->TCD[index].BITER_ELINKNO)
#define DMA_BITER_ELINKNO_COUNT                  8
#define DMA_BITER_ELINKYES_REG(base,index)       ((base)->TCD[index].BITER_ELINKYES)
#define DMA_BITER_ELINKYES_COUNT                 8

/*!
 * @}
 */ /* end of group DMA_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/* CR Bit Fields */
#define DMA_CR_EDBG_MASK                         0x2u
#define DMA_CR_EDBG_SHIFT                        1
#define DMA_CR_EDBG_WIDTH                        1
#define DMA_CR_EDBG(x)                           (((uint32_t)(((uint32_t)(x))<<DMA_CR_EDBG_SHIFT))&DMA_CR_EDBG_MASK)
#define DMA_CR_ERCA_MASK                         0x4u
#define DMA_CR_ERCA_SHIFT                        2
#define DMA_CR_ERCA_WIDTH                        1
#define DMA_CR_ERCA(x)                           (((uint32_t)(((uint32_t)(x))<<DMA_CR_ERCA_SHIFT))&DMA_CR_ERCA_MASK)
#define DMA_CR_HOE_MASK                          0x10u
#define DMA_CR_HOE_SHIFT                         4
#define DMA_CR_HOE_WIDTH                         1
#define DMA_CR_HOE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_CR_HOE_SHIFT))&DMA_CR_HOE_MASK)
#define DMA_CR_HALT_MASK                         0x20u
#define DMA_CR_HALT_SHIFT                        5
#define DMA_CR_HALT_WIDTH                        1
#define DMA_CR_HALT(x)                           (((uint32_t)(((uint32_t)(x))<<DMA_CR_HALT_SHIFT))&DMA_CR_HALT_MASK)
#define DMA_CR_CLM_MASK                          0x40u
#define DMA_CR_CLM_SHIFT                         6
#define DMA_CR_CLM_WIDTH                         1
#define DMA_CR_CLM(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_CR_CLM_SHIFT))&DMA_CR_CLM_MASK)
#define DMA_CR_EMLM_MASK                         0x80u
#define DMA_CR_EMLM_SHIFT                        7
#define DMA_CR_EMLM_WIDTH                        1
#define DMA_CR_EMLM(x)                           (((uint32_t)(((uint32_t)(x))<<DMA_CR_EMLM_SHIFT))&DMA_CR_EMLM_MASK)
#define DMA_CR_ECX_MASK                          0x10000u
#define DMA_CR_ECX_SHIFT                         16
#define DMA_CR_ECX_WIDTH                         1
#define DMA_CR_ECX(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_CR_ECX_SHIFT))&DMA_CR_ECX_MASK)
#define DMA_CR_CX_MASK                           0x20000u
#define DMA_CR_CX_SHIFT                          17
#define DMA_CR_CX_WIDTH                          1
#define DMA_CR_CX(x)                             (((uint32_t)(((uint32_t)(x))<<DMA_CR_CX_SHIFT))&DMA_CR_CX_MASK)
#define DMA_CR_ACTIVE_MASK                       0x80000000u
#define DMA_CR_ACTIVE_SHIFT                      31
#define DMA_CR_ACTIVE_WIDTH                      1
#define DMA_CR_ACTIVE(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_CR_ACTIVE_SHIFT))&DMA_CR_ACTIVE_MASK)
/* ES Bit Fields */
#define DMA_ES_DBE_MASK                          0x1u
#define DMA_ES_DBE_SHIFT                         0
#define DMA_ES_DBE_WIDTH                         1
#define DMA_ES_DBE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_DBE_SHIFT))&DMA_ES_DBE_MASK)
#define DMA_ES_SBE_MASK                          0x2u
#define DMA_ES_SBE_SHIFT                         1
#define DMA_ES_SBE_WIDTH                         1
#define DMA_ES_SBE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_SBE_SHIFT))&DMA_ES_SBE_MASK)
#define DMA_ES_SGE_MASK                          0x4u
#define DMA_ES_SGE_SHIFT                         2
#define DMA_ES_SGE_WIDTH                         1
#define DMA_ES_SGE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_SGE_SHIFT))&DMA_ES_SGE_MASK)
#define DMA_ES_NCE_MASK                          0x8u
#define DMA_ES_NCE_SHIFT                         3
#define DMA_ES_NCE_WIDTH                         1
#define DMA_ES_NCE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_NCE_SHIFT))&DMA_ES_NCE_MASK)
#define DMA_ES_DOE_MASK                          0x10u
#define DMA_ES_DOE_SHIFT                         4
#define DMA_ES_DOE_WIDTH                         1
#define DMA_ES_DOE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_DOE_SHIFT))&DMA_ES_DOE_MASK)
#define DMA_ES_DAE_MASK                          0x20u
#define DMA_ES_DAE_SHIFT                         5
#define DMA_ES_DAE_WIDTH                         1
#define DMA_ES_DAE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_DAE_SHIFT))&DMA_ES_DAE_MASK)
#define DMA_ES_SOE_MASK                          0x40u
#define DMA_ES_SOE_SHIFT                         6
#define DMA_ES_SOE_WIDTH                         1
#define DMA_ES_SOE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_SOE_SHIFT))&DMA_ES_SOE_MASK)
#define DMA_ES_SAE_MASK                          0x80u
#define DMA_ES_SAE_SHIFT                         7
#define DMA_ES_SAE_WIDTH                         1
#define DMA_ES_SAE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_SAE_SHIFT))&DMA_ES_SAE_MASK)
#define DMA_ES_ERRCHN_MASK                       0x700u
#define DMA_ES_ERRCHN_SHIFT                      8
#define DMA_ES_ERRCHN_WIDTH                      3
#define DMA_ES_ERRCHN(x)                         (((uint32_t)(((uint32_t)(x))<<DMA_ES_ERRCHN_SHIFT))&DMA_ES_ERRCHN_MASK)
#define DMA_ES_CPE_MASK                          0x4000u
#define DMA_ES_CPE_SHIFT                         14
#define DMA_ES_CPE_WIDTH                         1
#define DMA_ES_CPE(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_CPE_SHIFT))&DMA_ES_CPE_MASK)
#define DMA_ES_ECX_MASK                          0x10000u
#define DMA_ES_ECX_SHIFT                         16
#define DMA_ES_ECX_WIDTH                         1
#define DMA_ES_ECX(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_ECX_SHIFT))&DMA_ES_ECX_MASK)
#define DMA_ES_VLD_MASK                          0x80000000u
#define DMA_ES_VLD_SHIFT                         31
#define DMA_ES_VLD_WIDTH                         1
#define DMA_ES_VLD(x)                            (((uint32_t)(((uint32_t)(x))<<DMA_ES_VLD_SHIFT))&DMA_ES_VLD_MASK)
/* ERQ Bit Fields */
#define DMA_ERQ_ERQ0_MASK                        0x1u
#define DMA_ERQ_ERQ0_SHIFT                       0
#define DMA_ERQ_ERQ0_WIDTH                       1
#define DMA_ERQ_ERQ0(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ0_SHIFT))&DMA_ERQ_ERQ0_MASK)
#define DMA_ERQ_ERQ1_MASK                        0x2u
#define DMA_ERQ_ERQ1_SHIFT                       1
#define DMA_ERQ_ERQ1_WIDTH                       1
#define DMA_ERQ_ERQ1(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ1_SHIFT))&DMA_ERQ_ERQ1_MASK)
#define DMA_ERQ_ERQ2_MASK                        0x4u
#define DMA_ERQ_ERQ2_SHIFT                       2
#define DMA_ERQ_ERQ2_WIDTH                       1
#define DMA_ERQ_ERQ2(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ2_SHIFT))&DMA_ERQ_ERQ2_MASK)
#define DMA_ERQ_ERQ3_MASK                        0x8u
#define DMA_ERQ_ERQ3_SHIFT                       3
#define DMA_ERQ_ERQ3_WIDTH                       1
#define DMA_ERQ_ERQ3(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ3_SHIFT))&DMA_ERQ_ERQ3_MASK)
#define DMA_ERQ_ERQ4_MASK                        0x10u
#define DMA_ERQ_ERQ4_SHIFT                       4
#define DMA_ERQ_ERQ4_WIDTH                       1
#define DMA_ERQ_ERQ4(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ4_SHIFT))&DMA_ERQ_ERQ4_MASK)
#define DMA_ERQ_ERQ5_MASK                        0x20u
#define DMA_ERQ_ERQ5_SHIFT                       5
#define DMA_ERQ_ERQ5_WIDTH                       1
#define DMA_ERQ_ERQ5(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ5_SHIFT))&DMA_ERQ_ERQ5_MASK)
#define DMA_ERQ_ERQ6_MASK                        0x40u
#define DMA_ERQ_ERQ6_SHIFT                       6
#define DMA_ERQ_ERQ6_WIDTH                       1
#define DMA_ERQ_ERQ6(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ6_SHIFT))&DMA_ERQ_ERQ6_MASK)
#define DMA_ERQ_ERQ7_MASK                        0x80u
#define DMA_ERQ_ERQ7_SHIFT                       7
#define DMA_ERQ_ERQ7_WIDTH                       1
#define DMA_ERQ_ERQ7(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERQ_ERQ7_SHIFT))&DMA_ERQ_ERQ7_MASK)
/* EEI Bit Fields */
#define DMA_EEI_EEI0_MASK                        0x1u
#define DMA_EEI_EEI0_SHIFT                       0
#define DMA_EEI_EEI0_WIDTH                       1
#define DMA_EEI_EEI0(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI0_SHIFT))&DMA_EEI_EEI0_MASK)
#define DMA_EEI_EEI1_MASK                        0x2u
#define DMA_EEI_EEI1_SHIFT                       1
#define DMA_EEI_EEI1_WIDTH                       1
#define DMA_EEI_EEI1(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI1_SHIFT))&DMA_EEI_EEI1_MASK)
#define DMA_EEI_EEI2_MASK                        0x4u
#define DMA_EEI_EEI2_SHIFT                       2
#define DMA_EEI_EEI2_WIDTH                       1
#define DMA_EEI_EEI2(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI2_SHIFT))&DMA_EEI_EEI2_MASK)
#define DMA_EEI_EEI3_MASK                        0x8u
#define DMA_EEI_EEI3_SHIFT                       3
#define DMA_EEI_EEI3_WIDTH                       1
#define DMA_EEI_EEI3(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI3_SHIFT))&DMA_EEI_EEI3_MASK)
#define DMA_EEI_EEI4_MASK                        0x10u
#define DMA_EEI_EEI4_SHIFT                       4
#define DMA_EEI_EEI4_WIDTH                       1
#define DMA_EEI_EEI4(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI4_SHIFT))&DMA_EEI_EEI4_MASK)
#define DMA_EEI_EEI5_MASK                        0x20u
#define DMA_EEI_EEI5_SHIFT                       5
#define DMA_EEI_EEI5_WIDTH                       1
#define DMA_EEI_EEI5(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI5_SHIFT))&DMA_EEI_EEI5_MASK)
#define DMA_EEI_EEI6_MASK                        0x40u
#define DMA_EEI_EEI6_SHIFT                       6
#define DMA_EEI_EEI6_WIDTH                       1
#define DMA_EEI_EEI6(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI6_SHIFT))&DMA_EEI_EEI6_MASK)
#define DMA_EEI_EEI7_MASK                        0x80u
#define DMA_EEI_EEI7_SHIFT                       7
#define DMA_EEI_EEI7_WIDTH                       1
#define DMA_EEI_EEI7(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_EEI_EEI7_SHIFT))&DMA_EEI_EEI7_MASK)
/* CEEI Bit Fields */
#define DMA_CEEI_CEEI_MASK                       0x7u
#define DMA_CEEI_CEEI_SHIFT                      0
#define DMA_CEEI_CEEI_WIDTH                      3
#define DMA_CEEI_CEEI(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CEEI_CEEI_SHIFT))&DMA_CEEI_CEEI_MASK)
#define DMA_CEEI_CAEE_MASK                       0x40u
#define DMA_CEEI_CAEE_SHIFT                      6
#define DMA_CEEI_CAEE_WIDTH                      1
#define DMA_CEEI_CAEE(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CEEI_CAEE_SHIFT))&DMA_CEEI_CAEE_MASK)
#define DMA_CEEI_NOP_MASK                        0x80u
#define DMA_CEEI_NOP_SHIFT                       7
#define DMA_CEEI_NOP_WIDTH                       1
#define DMA_CEEI_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_CEEI_NOP_SHIFT))&DMA_CEEI_NOP_MASK)
/* SEEI Bit Fields */
#define DMA_SEEI_SEEI_MASK                       0x7u
#define DMA_SEEI_SEEI_SHIFT                      0
#define DMA_SEEI_SEEI_WIDTH                      3
#define DMA_SEEI_SEEI(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SEEI_SEEI_SHIFT))&DMA_SEEI_SEEI_MASK)
#define DMA_SEEI_SAEE_MASK                       0x40u
#define DMA_SEEI_SAEE_SHIFT                      6
#define DMA_SEEI_SAEE_WIDTH                      1
#define DMA_SEEI_SAEE(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SEEI_SAEE_SHIFT))&DMA_SEEI_SAEE_MASK)
#define DMA_SEEI_NOP_MASK                        0x80u
#define DMA_SEEI_NOP_SHIFT                       7
#define DMA_SEEI_NOP_WIDTH                       1
#define DMA_SEEI_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_SEEI_NOP_SHIFT))&DMA_SEEI_NOP_MASK)
/* CERQ Bit Fields */
#define DMA_CERQ_CERQ_MASK                       0x7u
#define DMA_CERQ_CERQ_SHIFT                      0
#define DMA_CERQ_CERQ_WIDTH                      3
#define DMA_CERQ_CERQ(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CERQ_CERQ_SHIFT))&DMA_CERQ_CERQ_MASK)
#define DMA_CERQ_CAER_MASK                       0x40u
#define DMA_CERQ_CAER_SHIFT                      6
#define DMA_CERQ_CAER_WIDTH                      1
#define DMA_CERQ_CAER(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CERQ_CAER_SHIFT))&DMA_CERQ_CAER_MASK)
#define DMA_CERQ_NOP_MASK                        0x80u
#define DMA_CERQ_NOP_SHIFT                       7
#define DMA_CERQ_NOP_WIDTH                       1
#define DMA_CERQ_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_CERQ_NOP_SHIFT))&DMA_CERQ_NOP_MASK)
/* SERQ Bit Fields */
#define DMA_SERQ_SERQ_MASK                       0x7u
#define DMA_SERQ_SERQ_SHIFT                      0
#define DMA_SERQ_SERQ_WIDTH                      3
#define DMA_SERQ_SERQ(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SERQ_SERQ_SHIFT))&DMA_SERQ_SERQ_MASK)
#define DMA_SERQ_SAER_MASK                       0x40u
#define DMA_SERQ_SAER_SHIFT                      6
#define DMA_SERQ_SAER_WIDTH                      1
#define DMA_SERQ_SAER(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SERQ_SAER_SHIFT))&DMA_SERQ_SAER_MASK)
#define DMA_SERQ_NOP_MASK                        0x80u
#define DMA_SERQ_NOP_SHIFT                       7
#define DMA_SERQ_NOP_WIDTH                       1
#define DMA_SERQ_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_SERQ_NOP_SHIFT))&DMA_SERQ_NOP_MASK)
/* CDNE Bit Fields */
#define DMA_CDNE_CDNE_MASK                       0x7u
#define DMA_CDNE_CDNE_SHIFT                      0
#define DMA_CDNE_CDNE_WIDTH                      3
#define DMA_CDNE_CDNE(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CDNE_CDNE_SHIFT))&DMA_CDNE_CDNE_MASK)
#define DMA_CDNE_CADN_MASK                       0x40u
#define DMA_CDNE_CADN_SHIFT                      6
#define DMA_CDNE_CADN_WIDTH                      1
#define DMA_CDNE_CADN(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CDNE_CADN_SHIFT))&DMA_CDNE_CADN_MASK)
#define DMA_CDNE_NOP_MASK                        0x80u
#define DMA_CDNE_NOP_SHIFT                       7
#define DMA_CDNE_NOP_WIDTH                       1
#define DMA_CDNE_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_CDNE_NOP_SHIFT))&DMA_CDNE_NOP_MASK)
/* SSRT Bit Fields */
#define DMA_SSRT_SSRT_MASK                       0x7u
#define DMA_SSRT_SSRT_SHIFT                      0
#define DMA_SSRT_SSRT_WIDTH                      3
#define DMA_SSRT_SSRT(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SSRT_SSRT_SHIFT))&DMA_SSRT_SSRT_MASK)
#define DMA_SSRT_SAST_MASK                       0x40u
#define DMA_SSRT_SAST_SHIFT                      6
#define DMA_SSRT_SAST_WIDTH                      1
#define DMA_SSRT_SAST(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_SSRT_SAST_SHIFT))&DMA_SSRT_SAST_MASK)
#define DMA_SSRT_NOP_MASK                        0x80u
#define DMA_SSRT_NOP_SHIFT                       7
#define DMA_SSRT_NOP_WIDTH                       1
#define DMA_SSRT_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_SSRT_NOP_SHIFT))&DMA_SSRT_NOP_MASK)
/* CERR Bit Fields */
#define DMA_CERR_CERR_MASK                       0x7u
#define DMA_CERR_CERR_SHIFT                      0
#define DMA_CERR_CERR_WIDTH                      3
#define DMA_CERR_CERR(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CERR_CERR_SHIFT))&DMA_CERR_CERR_MASK)
#define DMA_CERR_CAEI_MASK                       0x40u
#define DMA_CERR_CAEI_SHIFT                      6
#define DMA_CERR_CAEI_WIDTH                      1
#define DMA_CERR_CAEI(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CERR_CAEI_SHIFT))&DMA_CERR_CAEI_MASK)
#define DMA_CERR_NOP_MASK                        0x80u
#define DMA_CERR_NOP_SHIFT                       7
#define DMA_CERR_NOP_WIDTH                       1
#define DMA_CERR_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_CERR_NOP_SHIFT))&DMA_CERR_NOP_MASK)
/* CINT Bit Fields */
#define DMA_CINT_CINT_MASK                       0x7u
#define DMA_CINT_CINT_SHIFT                      0
#define DMA_CINT_CINT_WIDTH                      3
#define DMA_CINT_CINT(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CINT_CINT_SHIFT))&DMA_CINT_CINT_MASK)
#define DMA_CINT_CAIR_MASK                       0x40u
#define DMA_CINT_CAIR_SHIFT                      6
#define DMA_CINT_CAIR_WIDTH                      1
#define DMA_CINT_CAIR(x)                         (((uint8_t)(((uint8_t)(x))<<DMA_CINT_CAIR_SHIFT))&DMA_CINT_CAIR_MASK)
#define DMA_CINT_NOP_MASK                        0x80u
#define DMA_CINT_NOP_SHIFT                       7
#define DMA_CINT_NOP_WIDTH                       1
#define DMA_CINT_NOP(x)                          (((uint8_t)(((uint8_t)(x))<<DMA_CINT_NOP_SHIFT))&DMA_CINT_NOP_MASK)
/* INT Bit Fields */
#define DMA_INT_INT0_MASK                        0x1u
#define DMA_INT_INT0_SHIFT                       0
#define DMA_INT_INT0_WIDTH                       1
#define DMA_INT_INT0(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT0_SHIFT))&DMA_INT_INT0_MASK)
#define DMA_INT_INT1_MASK                        0x2u
#define DMA_INT_INT1_SHIFT                       1
#define DMA_INT_INT1_WIDTH                       1
#define DMA_INT_INT1(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT1_SHIFT))&DMA_INT_INT1_MASK)
#define DMA_INT_INT2_MASK                        0x4u
#define DMA_INT_INT2_SHIFT                       2
#define DMA_INT_INT2_WIDTH                       1
#define DMA_INT_INT2(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT2_SHIFT))&DMA_INT_INT2_MASK)
#define DMA_INT_INT3_MASK                        0x8u
#define DMA_INT_INT3_SHIFT                       3
#define DMA_INT_INT3_WIDTH                       1
#define DMA_INT_INT3(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT3_SHIFT))&DMA_INT_INT3_MASK)
#define DMA_INT_INT4_MASK                        0x10u
#define DMA_INT_INT4_SHIFT                       4
#define DMA_INT_INT4_WIDTH                       1
#define DMA_INT_INT4(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT4_SHIFT))&DMA_INT_INT4_MASK)
#define DMA_INT_INT5_MASK                        0x20u
#define DMA_INT_INT5_SHIFT                       5
#define DMA_INT_INT5_WIDTH                       1
#define DMA_INT_INT5(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT5_SHIFT))&DMA_INT_INT5_MASK)
#define DMA_INT_INT6_MASK                        0x40u
#define DMA_INT_INT6_SHIFT                       6
#define DMA_INT_INT6_WIDTH                       1
#define DMA_INT_INT6(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT6_SHIFT))&DMA_INT_INT6_MASK)
#define DMA_INT_INT7_MASK                        0x80u
#define DMA_INT_INT7_SHIFT                       7
#define DMA_INT_INT7_WIDTH                       1
#define DMA_INT_INT7(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_INT_INT7_SHIFT))&DMA_INT_INT7_MASK)
/* ERR Bit Fields */
#define DMA_ERR_ERR0_MASK                        0x1u
#define DMA_ERR_ERR0_SHIFT                       0
#define DMA_ERR_ERR0_WIDTH                       1
#define DMA_ERR_ERR0(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR0_SHIFT))&DMA_ERR_ERR0_MASK)
#define DMA_ERR_ERR1_MASK                        0x2u
#define DMA_ERR_ERR1_SHIFT                       1
#define DMA_ERR_ERR1_WIDTH                       1
#define DMA_ERR_ERR1(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR1_SHIFT))&DMA_ERR_ERR1_MASK)
#define DMA_ERR_ERR2_MASK                        0x4u
#define DMA_ERR_ERR2_SHIFT                       2
#define DMA_ERR_ERR2_WIDTH                       1
#define DMA_ERR_ERR2(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR2_SHIFT))&DMA_ERR_ERR2_MASK)
#define DMA_ERR_ERR3_MASK                        0x8u
#define DMA_ERR_ERR3_SHIFT                       3
#define DMA_ERR_ERR3_WIDTH                       1
#define DMA_ERR_ERR3(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR3_SHIFT))&DMA_ERR_ERR3_MASK)
#define DMA_ERR_ERR4_MASK                        0x10u
#define DMA_ERR_ERR4_SHIFT                       4
#define DMA_ERR_ERR4_WIDTH                       1
#define DMA_ERR_ERR4(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR4_SHIFT))&DMA_ERR_ERR4_MASK)
#define DMA_ERR_ERR5_MASK                        0x20u
#define DMA_ERR_ERR5_SHIFT                       5
#define DMA_ERR_ERR5_WIDTH                       1
#define DMA_ERR_ERR5(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR5_SHIFT))&DMA_ERR_ERR5_MASK)
#define DMA_ERR_ERR6_MASK                        0x40u
#define DMA_ERR_ERR6_SHIFT                       6
#define DMA_ERR_ERR6_WIDTH                       1
#define DMA_ERR_ERR6(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR6_SHIFT))&DMA_ERR_ERR6_MASK)
#define DMA_ERR_ERR7_MASK                        0x80u
#define DMA_ERR_ERR7_SHIFT                       7
#define DMA_ERR_ERR7_WIDTH                       1
#define DMA_ERR_ERR7(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_ERR_ERR7_SHIFT))&DMA_ERR_ERR7_MASK)
/* HRS Bit Fields */
#define DMA_HRS_HRS0_MASK                        0x1u
#define DMA_HRS_HRS0_SHIFT                       0
#define DMA_HRS_HRS0_WIDTH                       1
#define DMA_HRS_HRS0(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS0_SHIFT))&DMA_HRS_HRS0_MASK)
#define DMA_HRS_HRS1_MASK                        0x2u
#define DMA_HRS_HRS1_SHIFT                       1
#define DMA_HRS_HRS1_WIDTH                       1
#define DMA_HRS_HRS1(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS1_SHIFT))&DMA_HRS_HRS1_MASK)
#define DMA_HRS_HRS2_MASK                        0x4u
#define DMA_HRS_HRS2_SHIFT                       2
#define DMA_HRS_HRS2_WIDTH                       1
#define DMA_HRS_HRS2(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS2_SHIFT))&DMA_HRS_HRS2_MASK)
#define DMA_HRS_HRS3_MASK                        0x8u
#define DMA_HRS_HRS3_SHIFT                       3
#define DMA_HRS_HRS3_WIDTH                       1
#define DMA_HRS_HRS3(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS3_SHIFT))&DMA_HRS_HRS3_MASK)
#define DMA_HRS_HRS4_MASK                        0x10u
#define DMA_HRS_HRS4_SHIFT                       4
#define DMA_HRS_HRS4_WIDTH                       1
#define DMA_HRS_HRS4(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS4_SHIFT))&DMA_HRS_HRS4_MASK)
#define DMA_HRS_HRS5_MASK                        0x20u
#define DMA_HRS_HRS5_SHIFT                       5
#define DMA_HRS_HRS5_WIDTH                       1
#define DMA_HRS_HRS5(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS5_SHIFT))&DMA_HRS_HRS5_MASK)
#define DMA_HRS_HRS6_MASK                        0x40u
#define DMA_HRS_HRS6_SHIFT                       6
#define DMA_HRS_HRS6_WIDTH                       1
#define DMA_HRS_HRS6(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS6_SHIFT))&DMA_HRS_HRS6_MASK)
#define DMA_HRS_HRS7_MASK                        0x80u
#define DMA_HRS_HRS7_SHIFT                       7
#define DMA_HRS_HRS7_WIDTH                       1
#define DMA_HRS_HRS7(x)                          (((uint32_t)(((uint32_t)(x))<<DMA_HRS_HRS7_SHIFT))&DMA_HRS_HRS7_MASK)
/* EARS Bit Fields */
#define DMA_EARS_EDREQ_0_MASK                    0x1u
#define DMA_EARS_EDREQ_0_SHIFT                   0
#define DMA_EARS_EDREQ_0_WIDTH                   1
#define DMA_EARS_EDREQ_0(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_0_SHIFT))&DMA_EARS_EDREQ_0_MASK)
#define DMA_EARS_EDREQ_1_MASK                    0x2u
#define DMA_EARS_EDREQ_1_SHIFT                   1
#define DMA_EARS_EDREQ_1_WIDTH                   1
#define DMA_EARS_EDREQ_1(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_1_SHIFT))&DMA_EARS_EDREQ_1_MASK)
#define DMA_EARS_EDREQ_2_MASK                    0x4u
#define DMA_EARS_EDREQ_2_SHIFT                   2
#define DMA_EARS_EDREQ_2_WIDTH                   1
#define DMA_EARS_EDREQ_2(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_2_SHIFT))&DMA_EARS_EDREQ_2_MASK)
#define DMA_EARS_EDREQ_3_MASK                    0x8u
#define DMA_EARS_EDREQ_3_SHIFT                   3
#define DMA_EARS_EDREQ_3_WIDTH                   1
#define DMA_EARS_EDREQ_3(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_3_SHIFT))&DMA_EARS_EDREQ_3_MASK)
#define DMA_EARS_EDREQ_4_MASK                    0x10u
#define DMA_EARS_EDREQ_4_SHIFT                   4
#define DMA_EARS_EDREQ_4_WIDTH                   1
#define DMA_EARS_EDREQ_4(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_4_SHIFT))&DMA_EARS_EDREQ_4_MASK)
#define DMA_EARS_EDREQ_5_MASK                    0x20u
#define DMA_EARS_EDREQ_5_SHIFT                   5
#define DMA_EARS_EDREQ_5_WIDTH                   1
#define DMA_EARS_EDREQ_5(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_5_SHIFT))&DMA_EARS_EDREQ_5_MASK)
#define DMA_EARS_EDREQ_6_MASK                    0x40u
#define DMA_EARS_EDREQ_6_SHIFT                   6
#define DMA_EARS_EDREQ_6_WIDTH                   1
#define DMA_EARS_EDREQ_6(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_6_SHIFT))&DMA_EARS_EDREQ_6_MASK)
#define DMA_EARS_EDREQ_7_MASK                    0x80u
#define DMA_EARS_EDREQ_7_SHIFT                   7
#define DMA_EARS_EDREQ_7_WIDTH                   1
#define DMA_EARS_EDREQ_7(x)                      (((uint32_t)(((uint32_t)(x))<<DMA_EARS_EDREQ_7_SHIFT))&DMA_EARS_EDREQ_7_MASK)
/* DCHPRI3 Bit Fields */
#define DMA_DCHPRI3_CHPRI_MASK                   0x7u
#define DMA_DCHPRI3_CHPRI_SHIFT                  0
#define DMA_DCHPRI3_CHPRI_WIDTH                  3
#define DMA_DCHPRI3_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI3_CHPRI_SHIFT))&DMA_DCHPRI3_CHPRI_MASK)
#define DMA_DCHPRI3_DPA_MASK                     0x40u
#define DMA_DCHPRI3_DPA_SHIFT                    6
#define DMA_DCHPRI3_DPA_WIDTH                    1
#define DMA_DCHPRI3_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI3_DPA_SHIFT))&DMA_DCHPRI3_DPA_MASK)
#define DMA_DCHPRI3_ECP_MASK                     0x80u
#define DMA_DCHPRI3_ECP_SHIFT                    7
#define DMA_DCHPRI3_ECP_WIDTH                    1
#define DMA_DCHPRI3_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI3_ECP_SHIFT))&DMA_DCHPRI3_ECP_MASK)
/* DCHPRI2 Bit Fields */
#define DMA_DCHPRI2_CHPRI_MASK                   0x7u
#define DMA_DCHPRI2_CHPRI_SHIFT                  0
#define DMA_DCHPRI2_CHPRI_WIDTH                  3
#define DMA_DCHPRI2_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI2_CHPRI_SHIFT))&DMA_DCHPRI2_CHPRI_MASK)
#define DMA_DCHPRI2_DPA_MASK                     0x40u
#define DMA_DCHPRI2_DPA_SHIFT                    6
#define DMA_DCHPRI2_DPA_WIDTH                    1
#define DMA_DCHPRI2_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI2_DPA_SHIFT))&DMA_DCHPRI2_DPA_MASK)
#define DMA_DCHPRI2_ECP_MASK                     0x80u
#define DMA_DCHPRI2_ECP_SHIFT                    7
#define DMA_DCHPRI2_ECP_WIDTH                    1
#define DMA_DCHPRI2_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI2_ECP_SHIFT))&DMA_DCHPRI2_ECP_MASK)
/* DCHPRI1 Bit Fields */
#define DMA_DCHPRI1_CHPRI_MASK                   0x7u
#define DMA_DCHPRI1_CHPRI_SHIFT                  0
#define DMA_DCHPRI1_CHPRI_WIDTH                  3
#define DMA_DCHPRI1_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI1_CHPRI_SHIFT))&DMA_DCHPRI1_CHPRI_MASK)
#define DMA_DCHPRI1_DPA_MASK                     0x40u
#define DMA_DCHPRI1_DPA_SHIFT                    6
#define DMA_DCHPRI1_DPA_WIDTH                    1
#define DMA_DCHPRI1_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI1_DPA_SHIFT))&DMA_DCHPRI1_DPA_MASK)
#define DMA_DCHPRI1_ECP_MASK                     0x80u
#define DMA_DCHPRI1_ECP_SHIFT                    7
#define DMA_DCHPRI1_ECP_WIDTH                    1
#define DMA_DCHPRI1_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI1_ECP_SHIFT))&DMA_DCHPRI1_ECP_MASK)
/* DCHPRI0 Bit Fields */
#define DMA_DCHPRI0_CHPRI_MASK                   0x7u
#define DMA_DCHPRI0_CHPRI_SHIFT                  0
#define DMA_DCHPRI0_CHPRI_WIDTH                  3
#define DMA_DCHPRI0_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI0_CHPRI_SHIFT))&DMA_DCHPRI0_CHPRI_MASK)
#define DMA_DCHPRI0_DPA_MASK                     0x40u
#define DMA_DCHPRI0_DPA_SHIFT                    6
#define DMA_DCHPRI0_DPA_WIDTH                    1
#define DMA_DCHPRI0_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI0_DPA_SHIFT))&DMA_DCHPRI0_DPA_MASK)
#define DMA_DCHPRI0_ECP_MASK                     0x80u
#define DMA_DCHPRI0_ECP_SHIFT                    7
#define DMA_DCHPRI0_ECP_WIDTH                    1
#define DMA_DCHPRI0_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI0_ECP_SHIFT))&DMA_DCHPRI0_ECP_MASK)
/* DCHPRI7 Bit Fields */
#define DMA_DCHPRI7_CHPRI_MASK                   0x7u
#define DMA_DCHPRI7_CHPRI_SHIFT                  0
#define DMA_DCHPRI7_CHPRI_WIDTH                  3
#define DMA_DCHPRI7_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI7_CHPRI_SHIFT))&DMA_DCHPRI7_CHPRI_MASK)
#define DMA_DCHPRI7_DPA_MASK                     0x40u
#define DMA_DCHPRI7_DPA_SHIFT                    6
#define DMA_DCHPRI7_DPA_WIDTH                    1
#define DMA_DCHPRI7_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI7_DPA_SHIFT))&DMA_DCHPRI7_DPA_MASK)
#define DMA_DCHPRI7_ECP_MASK                     0x80u
#define DMA_DCHPRI7_ECP_SHIFT                    7
#define DMA_DCHPRI7_ECP_WIDTH                    1
#define DMA_DCHPRI7_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI7_ECP_SHIFT))&DMA_DCHPRI7_ECP_MASK)
/* DCHPRI6 Bit Fields */
#define DMA_DCHPRI6_CHPRI_MASK                   0x7u
#define DMA_DCHPRI6_CHPRI_SHIFT                  0
#define DMA_DCHPRI6_CHPRI_WIDTH                  3
#define DMA_DCHPRI6_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI6_CHPRI_SHIFT))&DMA_DCHPRI6_CHPRI_MASK)
#define DMA_DCHPRI6_DPA_MASK                     0x40u
#define DMA_DCHPRI6_DPA_SHIFT                    6
#define DMA_DCHPRI6_DPA_WIDTH                    1
#define DMA_DCHPRI6_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI6_DPA_SHIFT))&DMA_DCHPRI6_DPA_MASK)
#define DMA_DCHPRI6_ECP_MASK                     0x80u
#define DMA_DCHPRI6_ECP_SHIFT                    7
#define DMA_DCHPRI6_ECP_WIDTH                    1
#define DMA_DCHPRI6_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI6_ECP_SHIFT))&DMA_DCHPRI6_ECP_MASK)
/* DCHPRI5 Bit Fields */
#define DMA_DCHPRI5_CHPRI_MASK                   0x7u
#define DMA_DCHPRI5_CHPRI_SHIFT                  0
#define DMA_DCHPRI5_CHPRI_WIDTH                  3
#define DMA_DCHPRI5_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI5_CHPRI_SHIFT))&DMA_DCHPRI5_CHPRI_MASK)
#define DMA_DCHPRI5_DPA_MASK                     0x40u
#define DMA_DCHPRI5_DPA_SHIFT                    6
#define DMA_DCHPRI5_DPA_WIDTH                    1
#define DMA_DCHPRI5_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI5_DPA_SHIFT))&DMA_DCHPRI5_DPA_MASK)
#define DMA_DCHPRI5_ECP_MASK                     0x80u
#define DMA_DCHPRI5_ECP_SHIFT                    7
#define DMA_DCHPRI5_ECP_WIDTH                    1
#define DMA_DCHPRI5_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI5_ECP_SHIFT))&DMA_DCHPRI5_ECP_MASK)
/* DCHPRI4 Bit Fields */
#define DMA_DCHPRI4_CHPRI_MASK                   0x7u
#define DMA_DCHPRI4_CHPRI_SHIFT                  0
#define DMA_DCHPRI4_CHPRI_WIDTH                  3
#define DMA_DCHPRI4_CHPRI(x)                     (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI4_CHPRI_SHIFT))&DMA_DCHPRI4_CHPRI_MASK)
#define DMA_DCHPRI4_DPA_MASK                     0x40u
#define DMA_DCHPRI4_DPA_SHIFT                    6
#define DMA_DCHPRI4_DPA_WIDTH                    1
#define DMA_DCHPRI4_DPA(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI4_DPA_SHIFT))&DMA_DCHPRI4_DPA_MASK)
#define DMA_DCHPRI4_ECP_MASK                     0x80u
#define DMA_DCHPRI4_ECP_SHIFT                    7
#define DMA_DCHPRI4_ECP_WIDTH                    1
#define DMA_DCHPRI4_ECP(x)                       (((uint8_t)(((uint8_t)(x))<<DMA_DCHPRI4_ECP_SHIFT))&DMA_DCHPRI4_ECP_MASK)
/* SADDR Bit Fields */
#define DMA_SADDR_SADDR_MASK                     0xFFFFFFFFu
#define DMA_SADDR_SADDR_SHIFT                    0
#define DMA_SADDR_SADDR_WIDTH                    32
#define DMA_SADDR_SADDR(x)                       (((uint32_t)(((uint32_t)(x))<<DMA_SADDR_SADDR_SHIFT))&DMA_SADDR_SADDR_MASK)
/* SOFF Bit Fields */
#define DMA_SOFF_SOFF_MASK                       0xFFFFu
#define DMA_SOFF_SOFF_SHIFT                      0
#define DMA_SOFF_SOFF_WIDTH                      16
#define DMA_SOFF_SOFF(x)                         (((uint16_t)(((uint16_t)(x))<<DMA_SOFF_SOFF_SHIFT))&DMA_SOFF_SOFF_MASK)
/* ATTR Bit Fields */
#define DMA_ATTR_DSIZE_MASK                      0x7u
#define DMA_ATTR_DSIZE_SHIFT                     0
#define DMA_ATTR_DSIZE_WIDTH                     3
#define DMA_ATTR_DSIZE(x)                        (((uint16_t)(((uint16_t)(x))<<DMA_ATTR_DSIZE_SHIFT))&DMA_ATTR_DSIZE_MASK)
#define DMA_ATTR_DMOD_MASK                       0xF8u
#define DMA_ATTR_DMOD_SHIFT                      3
#define DMA_ATTR_DMOD_WIDTH                      5
#define DMA_ATTR_DMOD(x)                         (((uint16_t)(((uint16_t)(x))<<DMA_ATTR_DMOD_SHIFT))&DMA_ATTR_DMOD_MASK)
#define DMA_ATTR_SSIZE_MASK                      0x700u
#define DMA_ATTR_SSIZE_SHIFT                     8
#define DMA_ATTR_SSIZE_WIDTH                     3
#define DMA_ATTR_SSIZE(x)                        (((uint16_t)(((uint16_t)(x))<<DMA_ATTR_SSIZE_SHIFT))&DMA_ATTR_SSIZE_MASK)
#define DMA_ATTR_SMOD_MASK                       0xF800u
#define DMA_ATTR_SMOD_SHIFT                      11
#define DMA_ATTR_SMOD_WIDTH                      5
#define DMA_ATTR_SMOD(x)                         (((uint16_t)(((uint16_t)(x))<<DMA_ATTR_SMOD_SHIFT))&DMA_ATTR_SMOD_MASK)
/* NBYTES_MLNO Bit Fields */
#define DMA_NBYTES_MLNO_NBYTES_MASK              0xFFFFFFFFu
#define DMA_NBYTES_MLNO_NBYTES_SHIFT             0
#define DMA_NBYTES_MLNO_NBYTES_WIDTH             32
#define DMA_NBYTES_MLNO_NBYTES(x)                (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLNO_NBYTES_SHIFT))&DMA_NBYTES_MLNO_NBYTES_MASK)
/* NBYTES_MLOFFNO Bit Fields */
#define DMA_NBYTES_MLOFFNO_NBYTES_MASK           0x3FFFFFFFu
#define DMA_NBYTES_MLOFFNO_NBYTES_SHIFT          0
#define DMA_NBYTES_MLOFFNO_NBYTES_WIDTH          30
#define DMA_NBYTES_MLOFFNO_NBYTES(x)             (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFNO_NBYTES_SHIFT))&DMA_NBYTES_MLOFFNO_NBYTES_MASK)
#define DMA_NBYTES_MLOFFNO_DMLOE_MASK            0x40000000u
#define DMA_NBYTES_MLOFFNO_DMLOE_SHIFT           30
#define DMA_NBYTES_MLOFFNO_DMLOE_WIDTH           1
#define DMA_NBYTES_MLOFFNO_DMLOE(x)              (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFNO_DMLOE_SHIFT))&DMA_NBYTES_MLOFFNO_DMLOE_MASK)
#define DMA_NBYTES_MLOFFNO_SMLOE_MASK            0x80000000u
#define DMA_NBYTES_MLOFFNO_SMLOE_SHIFT           31
#define DMA_NBYTES_MLOFFNO_SMLOE_WIDTH           1
#define DMA_NBYTES_MLOFFNO_SMLOE(x)              (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFNO_SMLOE_SHIFT))&DMA_NBYTES_MLOFFNO_SMLOE_MASK)
/* NBYTES_MLOFFYES Bit Fields */
#define DMA_NBYTES_MLOFFYES_NBYTES_MASK          0x3FFu
#define DMA_NBYTES_MLOFFYES_NBYTES_SHIFT         0
#define DMA_NBYTES_MLOFFYES_NBYTES_WIDTH         10
#define DMA_NBYTES_MLOFFYES_NBYTES(x)            (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFYES_NBYTES_SHIFT))&DMA_NBYTES_MLOFFYES_NBYTES_MASK)
#define DMA_NBYTES_MLOFFYES_MLOFF_MASK           0x3FFFFC00u
#define DMA_NBYTES_MLOFFYES_MLOFF_SHIFT          10
#define DMA_NBYTES_MLOFFYES_MLOFF_WIDTH          20
#define DMA_NBYTES_MLOFFYES_MLOFF(x)             (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFYES_MLOFF_SHIFT))&DMA_NBYTES_MLOFFYES_MLOFF_MASK)
#define DMA_NBYTES_MLOFFYES_DMLOE_MASK           0x40000000u
#define DMA_NBYTES_MLOFFYES_DMLOE_SHIFT          30
#define DMA_NBYTES_MLOFFYES_DMLOE_WIDTH          1
#define DMA_NBYTES_MLOFFYES_DMLOE(x)             (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFYES_DMLOE_SHIFT))&DMA_NBYTES_MLOFFYES_DMLOE_MASK)
#define DMA_NBYTES_MLOFFYES_SMLOE_MASK           0x80000000u
#define DMA_NBYTES_MLOFFYES_SMLOE_SHIFT          31
#define DMA_NBYTES_MLOFFYES_SMLOE_WIDTH          1
#define DMA_NBYTES_MLOFFYES_SMLOE(x)             (((uint32_t)(((uint32_t)(x))<<DMA_NBYTES_MLOFFYES_SMLOE_SHIFT))&DMA_NBYTES_MLOFFYES_SMLOE_MASK)
/* SLAST Bit Fields */
#define DMA_SLAST_SLAST_MASK                     0xFFFFFFFFu
#define DMA_SLAST_SLAST_SHIFT                    0
#define DMA_SLAST_SLAST_WIDTH                    32
#define DMA_SLAST_SLAST(x)                       (((uint32_t)(((uint32_t)(x))<<DMA_SLAST_SLAST_SHIFT))&DMA_SLAST_SLAST_MASK)
/* DADDR Bit Fields */
#define DMA_DADDR_DADDR_MASK                     0xFFFFFFFFu
#define DMA_DADDR_DADDR_SHIFT                    0
#define DMA_DADDR_DADDR_WIDTH                    32
#define DMA_DADDR_DADDR(x)                       (((uint32_t)(((uint32_t)(x))<<DMA_DADDR_DADDR_SHIFT))&DMA_DADDR_DADDR_MASK)
/* DOFF Bit Fields */
#define DMA_DOFF_DOFF_MASK                       0xFFFFu
#define DMA_DOFF_DOFF_SHIFT                      0
#define DMA_DOFF_DOFF_WIDTH                      16
#define DMA_DOFF_DOFF(x)                         (((uint16_t)(((uint16_t)(x))<<DMA_DOFF_DOFF_SHIFT))&DMA_DOFF_DOFF_MASK)
/* CITER_ELINKNO Bit Fields */
#define DMA_CITER_ELINKNO_CITER_MASK             0x7FFFu
#define DMA_CITER_ELINKNO_CITER_SHIFT            0
#define DMA_CITER_ELINKNO_CITER_WIDTH            15
#define DMA_CITER_ELINKNO_CITER(x)               (((uint16_t)(((uint16_t)(x))<<DMA_CITER_ELINKNO_CITER_SHIFT))&DMA_CITER_ELINKNO_CITER_MASK)
#define DMA_CITER_ELINKNO_ELINK_MASK             0x8000u
#define DMA_CITER_ELINKNO_ELINK_SHIFT            15
#define DMA_CITER_ELINKNO_ELINK_WIDTH            1
#define DMA_CITER_ELINKNO_ELINK(x)               (((uint16_t)(((uint16_t)(x))<<DMA_CITER_ELINKNO_ELINK_SHIFT))&DMA_CITER_ELINKNO_ELINK_MASK)
/* CITER_ELINKYES Bit Fields */
#define DMA_CITER_ELINKYES_CITER_MASK            0x1FFu
#define DMA_CITER_ELINKYES_CITER_SHIFT           0
#define DMA_CITER_ELINKYES_CITER_WIDTH           9
#define DMA_CITER_ELINKYES_CITER(x)              (((uint16_t)(((uint16_t)(x))<<DMA_CITER_ELINKYES_CITER_SHIFT))&DMA_CITER_ELINKYES_CITER_MASK)
#define DMA_CITER_ELINKYES_LINKCH_MASK           0xE00u
#define DMA_CITER_ELINKYES_LINKCH_SHIFT          9
#define DMA_CITER_ELINKYES_LINKCH_WIDTH          3
#define DMA_CITER_ELINKYES_LINKCH(x)             (((uint16_t)(((uint16_t)(x))<<DMA_CITER_ELINKYES_LINKCH_SHIFT))&DMA_CITER_ELINKYES_LINKCH_MASK)
#define DMA_CITER_ELINKYES_ELINK_MASK            0x8000u
#define DMA_CITER_ELINKYES_ELINK_SHIFT           15
#define DMA_CITER_ELINKYES_ELINK_WIDTH           1
#define DMA_CITER_ELINKYES_ELINK(x)              (((uint16_t)(((uint16_t)(x))<<DMA_CITER_ELINKYES_ELINK_SHIFT))&DMA_CITER_ELINKYES_ELINK_MASK)
/* DLAST_SGA Bit Fields */
#define DMA_DLAST_SGA_DLASTSGA_MASK              0xFFFFFFFFu
#define DMA_DLAST_SGA_DLASTSGA_SHIFT             0
#define DMA_DLAST_SGA_DLASTSGA_WIDTH             32
#define DMA_DLAST_SGA_DLASTSGA(x)                (((uint32_t)(((uint32_t)(x))<<DMA_DLAST_SGA_DLASTSGA_SHIFT))&DMA_DLAST_SGA_DLASTSGA_MASK)
/* CSR Bit Fields */
#define DMA_CSR_START_MASK                       0x1u
#define DMA_CSR_START_SHIFT                      0
#define DMA_CSR_START_WIDTH                      1
#define DMA_CSR_START(x)                         (((uint16_t)(((uint16_t)(x))<<DMA_CSR_START_SHIFT))&DMA_CSR_START_MASK)
#define DMA_CSR_INTMAJOR_MASK                    0x2u
#define DMA_CSR_INTMAJOR_SHIFT                   1
#define DMA_CSR_INTMAJOR_WIDTH                   1
#define DMA_CSR_INTMAJOR(x)                      (((uint16_t)(((uint16_t)(x))<<DMA_CSR_INTMAJOR_SHIFT))&DMA_CSR_INTMAJOR_MASK)
#define DMA_CSR_INTHALF_MASK                     0x4u
#define DMA_CSR_INTHALF_SHIFT                    2
#define DMA_CSR_INTHALF_WIDTH                    1
#define DMA_CSR_INTHALF(x)                       (((uint16_t)(((uint16_t)(x))<<DMA_CSR_INTHALF_SHIFT))&DMA_CSR_INTHALF_MASK)
#define DMA_CSR_DREQ_MASK                        0x8u
#define DMA_CSR_DREQ_SHIFT                       3
#define DMA_CSR_DREQ_WIDTH                       1
#define DMA_CSR_DREQ(x)                          (((uint16_t)(((uint16_t)(x))<<DMA_CSR_DREQ_SHIFT))&DMA_CSR_DREQ_MASK)
#define DMA_CSR_ESG_MASK                         0x10u
#define DMA_CSR_ESG_SHIFT                        4
#define DMA_CSR_ESG_WIDTH                        1
#define DMA_CSR_ESG(x)                           (((uint16_t)(((uint16_t)(x))<<DMA_CSR_ESG_SHIFT))&DMA_CSR_ESG_MASK)
#define DMA_CSR_MAJORELINK_MASK                  0x20u
#define DMA_CSR_MAJORELINK_SHIFT                 5
#define DMA_CSR_MAJORELINK_WIDTH                 1
#define DMA_CSR_MAJORELINK(x)                    (((uint16_t)(((uint16_t)(x))<<DMA_CSR_MAJORELINK_SHIFT))&DMA_CSR_MAJORELINK_MASK)
#define DMA_CSR_ACTIVE_MASK                      0x40u
#define DMA_CSR_ACTIVE_SHIFT                     6
#define DMA_CSR_ACTIVE_WIDTH                     1
#define DMA_CSR_ACTIVE(x)                        (((uint16_t)(((uint16_t)(x))<<DMA_CSR_ACTIVE_SHIFT))&DMA_CSR_ACTIVE_MASK)
#define DMA_CSR_DONE_MASK                        0x80u
#define DMA_CSR_DONE_SHIFT                       7
#define DMA_CSR_DONE_WIDTH                       1
#define DMA_CSR_DONE(x)                          (((uint16_t)(((uint16_t)(x))<<DMA_CSR_DONE_SHIFT))&DMA_CSR_DONE_MASK)
#define DMA_CSR_MAJORLINKCH_MASK                 0x700u
#define DMA_CSR_MAJORLINKCH_SHIFT                8
#define DMA_CSR_MAJORLINKCH_WIDTH                3
#define DMA_CSR_MAJORLINKCH(x)                   (((uint16_t)(((uint16_t)(x))<<DMA_CSR_MAJORLINKCH_SHIFT))&DMA_CSR_MAJORLINKCH_MASK)
#define DMA_CSR_BWC_MASK                         0xC000u
#define DMA_CSR_BWC_SHIFT                        14
#define DMA_CSR_BWC_WIDTH                        2
#define DMA_CSR_BWC(x)                           (((uint16_t)(((uint16_t)(x))<<DMA_CSR_BWC_SHIFT))&DMA_CSR_BWC_MASK)
/* BITER_ELINKNO Bit Fields */
#define DMA_BITER_ELINKNO_BITER_MASK             0x7FFFu
#define DMA_BITER_ELINKNO_BITER_SHIFT            0
#define DMA_BITER_ELINKNO_BITER_WIDTH            15
#define DMA_BITER_ELINKNO_BITER(x)               (((uint16_t)(((uint16_t)(x))<<DMA_BITER_ELINKNO_BITER_SHIFT))&DMA_BITER_ELINKNO_BITER_MASK)
#define DMA_BITER_ELINKNO_ELINK_MASK             0x8000u
#define DMA_BITER_ELINKNO_ELINK_SHIFT            15
#define DMA_BITER_ELINKNO_ELINK_WIDTH            1
#define DMA_BITER_ELINKNO_ELINK(x)               (((uint16_t)(((uint16_t)(x))<<DMA_BITER_ELINKNO_ELINK_SHIFT))&DMA_BITER_ELINKNO_ELINK_MASK)
/* BITER_ELINKYES Bit Fields */
#define DMA_BITER_ELINKYES_BITER_MASK            0x1FFu
#define DMA_BITER_ELINKYES_BITER_SHIFT           0
#define DMA_BITER_ELINKYES_BITER_WIDTH           9
#define DMA_BITER_ELINKYES_BITER(x)              (((uint16_t)(((uint16_t)(x))<<DMA_BITER_ELINKYES_BITER_SHIFT))&DMA_BITER_ELINKYES_BITER_MASK)
#define DMA_BITER_ELINKYES_LINKCH_MASK           0xE00u
#define DMA_BITER_ELINKYES_LINKCH_SHIFT          9
#define DMA_BITER_ELINKYES_LINKCH_WIDTH          3
#define DMA_BITER_ELINKYES_LINKCH(x)             (((uint16_t)(((uint16_t)(x))<<DMA_BITER_ELINKYES_LINKCH_SHIFT))&DMA_BITER_ELINKYES_LINKCH_MASK)
#define DMA_BITER_ELINKYES_ELINK_MASK            0x8000u
#define DMA_BITER_ELINKYES_ELINK_SHIFT           15
#define DMA_BITER_ELINKYES_ELINK_WIDTH           1
#define DMA_BITER_ELINKYES_ELINK(x)              (((uint16_t)(((uint16_t)(x))<<DMA_BITER_ELINKYES_ELINK_SHIFT))&DMA_BITER_ELINKYES_ELINK_MASK)

/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
/** Peripheral DMA base address */
#define DMA_BASE                                 (0x40008000u)
/** Peripheral DMA base pointer */
#define DMA0                                     ((DMA_Type *)DMA_BASE)
#define DMA_BASE_PTR                             (DMA0)
/** Array initializer of DMA peripheral base addresses */
#define DMA_BASE_ADDRS                           { DMA_BASE }
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS                            { DMA0 }

/* ----------------------------------------------------------------------------
   -- DMA - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Accessor_Macros DMA - Register accessor macros
 * @{
 */


/* DMA - Register instance definitions */
/* DMA */
#define DMA_CR                                   DMA_CR_REG(DMA0)
#define DMA_ES                                   DMA_ES_REG(DMA0)
#define DMA_ERQ                                  DMA_ERQ_REG(DMA0)
#define DMA_EEI                                  DMA_EEI_REG(DMA0)
#define DMA_CEEI                                 DMA_CEEI_REG(DMA0)
#define DMA_SEEI                                 DMA_SEEI_REG(DMA0)
#define DMA_CERQ                                 DMA_CERQ_REG(DMA0)
#define DMA_SERQ                                 DMA_SERQ_REG(DMA0)
#define DMA_CDNE                                 DMA_CDNE_REG(DMA0)
#define DMA_SSRT                                 DMA_SSRT_REG(DMA0)
#define DMA_CERR                                 DMA_CERR_REG(DMA0)
#define DMA_CINT                                 DMA_CINT_REG(DMA0)
#define DMA_INT                                  DMA_INT_REG(DMA0)
#define DMA_ERR                                  DMA_ERR_REG(DMA0)
#define DMA_HRS                                  DMA_HRS_REG(DMA0)
#define DMA_EARS                                 DMA_EARS_REG(DMA0)
#define DMA_DCHPRI3                              DMA_DCHPRI3_REG(DMA0)
#define DMA_DCHPRI2                              DMA_DCHPRI2_REG(DMA0)
#define DMA_DCHPRI1                              DMA_DCHPRI1_REG(DMA0)
#define DMA_DCHPRI0                              DMA_DCHPRI0_REG(DMA0)
#define DMA_DCHPRI7                              DMA_DCHPRI7_REG(DMA0)
#define DMA_DCHPRI6                              DMA_DCHPRI6_REG(DMA0)
#define DMA_DCHPRI5                              DMA_DCHPRI5_REG(DMA0)
#define DMA_DCHPRI4                              DMA_DCHPRI4_REG(DMA0)
#define DMA_TCD0_SADDR                           DMA_SADDR_REG(DMA0,0)
#define DMA_TCD0_SOFF                            DMA_SOFF_REG(DMA0,0)
#define DMA_TCD0_ATTR                            DMA_ATTR_REG(DMA0,0)
#define DMA_TCD0_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,0)
#define DMA_TCD0_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,0)
#define DMA_TCD0_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,0)
#define DMA_TCD0_SLAST                           DMA_SLAST_REG(DMA0,0)
#define DMA_TCD0_DADDR                           DMA_DADDR_REG(DMA0,0)
#define DMA_TCD0_DOFF                            DMA_DOFF_REG(DMA0,0)
#define DMA_TCD0_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,0)
#define DMA_TCD0_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,0)
#define DMA_TCD0_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,0)
#define DMA_TCD0_CSR                             DMA_CSR_REG(DMA0,0)
#define DMA_TCD0_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,0)
#define DMA_TCD0_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,0)
#define DMA_TCD1_SADDR                           DMA_SADDR_REG(DMA0,1)
#define DMA_TCD1_SOFF                            DMA_SOFF_REG(DMA0,1)
#define DMA_TCD1_ATTR                            DMA_ATTR_REG(DMA0,1)
#define DMA_TCD1_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,1)
#define DMA_TCD1_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,1)
#define DMA_TCD1_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,1)
#define DMA_TCD1_SLAST                           DMA_SLAST_REG(DMA0,1)
#define DMA_TCD1_DADDR                           DMA_DADDR_REG(DMA0,1)
#define DMA_TCD1_DOFF                            DMA_DOFF_REG(DMA0,1)
#define DMA_TCD1_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,1)
#define DMA_TCD1_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,1)
#define DMA_TCD1_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,1)
#define DMA_TCD1_CSR                             DMA_CSR_REG(DMA0,1)
#define DMA_TCD1_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,1)
#define DMA_TCD1_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,1)
#define DMA_TCD2_SADDR                           DMA_SADDR_REG(DMA0,2)
#define DMA_TCD2_SOFF                            DMA_SOFF_REG(DMA0,2)
#define DMA_TCD2_ATTR                            DMA_ATTR_REG(DMA0,2)
#define DMA_TCD2_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,2)
#define DMA_TCD2_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,2)
#define DMA_TCD2_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,2)
#define DMA_TCD2_SLAST                           DMA_SLAST_REG(DMA0,2)
#define DMA_TCD2_DADDR                           DMA_DADDR_REG(DMA0,2)
#define DMA_TCD2_DOFF                            DMA_DOFF_REG(DMA0,2)
#define DMA_TCD2_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,2)
#define DMA_TCD2_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,2)
#define DMA_TCD2_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,2)
#define DMA_TCD2_CSR                             DMA_CSR_REG(DMA0,2)
#define DMA_TCD2_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,2)
#define DMA_TCD2_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,2)
#define DMA_TCD3_SADDR                           DMA_SADDR_REG(DMA0,3)
#define DMA_TCD3_SOFF                            DMA_SOFF_REG(DMA0,3)
#define DMA_TCD3_ATTR                            DMA_ATTR_REG(DMA0,3)
#define DMA_TCD3_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,3)
#define DMA_TCD3_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,3)
#define DMA_TCD3_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,3)
#define DMA_TCD3_SLAST                           DMA_SLAST_REG(DMA0,3)
#define DMA_TCD3_DADDR                           DMA_DADDR_REG(DMA0,3)
#define DMA_TCD3_DOFF                            DMA_DOFF_REG(DMA0,3)
#define DMA_TCD3_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,3)
#define DMA_TCD3_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,3)
#define DMA_TCD3_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,3)
#define DMA_TCD3_CSR                             DMA_CSR_REG(DMA0,3)
#define DMA_TCD3_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,3)
#define DMA_TCD3_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,3)
#define DMA_TCD4_SADDR                           DMA_SADDR_REG(DMA0,4)
#define DMA_TCD4_SOFF                            DMA_SOFF_REG(DMA0,4)
#define DMA_TCD4_ATTR                            DMA_ATTR_REG(DMA0,4)
#define DMA_TCD4_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,4)
#define DMA_TCD4_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,4)
#define DMA_TCD4_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,4)
#define DMA_TCD4_SLAST                           DMA_SLAST_REG(DMA0,4)
#define DMA_TCD4_DADDR                           DMA_DADDR_REG(DMA0,4)
#define DMA_TCD4_DOFF                            DMA_DOFF_REG(DMA0,4)
#define DMA_TCD4_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,4)
#define DMA_TCD4_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,4)
#define DMA_TCD4_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,4)
#define DMA_TCD4_CSR                             DMA_CSR_REG(DMA0,4)
#define DMA_TCD4_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,4)
#define DMA_TCD4_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,4)
#define DMA_TCD5_SADDR                           DMA_SADDR_REG(DMA0,5)
#define DMA_TCD5_SOFF                            DMA_SOFF_REG(DMA0,5)
#define DMA_TCD5_ATTR                            DMA_ATTR_REG(DMA0,5)
#define DMA_TCD5_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,5)
#define DMA_TCD5_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,5)
#define DMA_TCD5_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,5)
#define DMA_TCD5_SLAST                           DMA_SLAST_REG(DMA0,5)
#define DMA_TCD5_DADDR                           DMA_DADDR_REG(DMA0,5)
#define DMA_TCD5_DOFF                            DMA_DOFF_REG(DMA0,5)
#define DMA_TCD5_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,5)
#define DMA_TCD5_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,5)
#define DMA_TCD5_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,5)
#define DMA_TCD5_CSR                             DMA_CSR_REG(DMA0,5)
#define DMA_TCD5_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,5)
#define DMA_TCD5_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,5)
#define DMA_TCD6_SADDR                           DMA_SADDR_REG(DMA0,6)
#define DMA_TCD6_SOFF                            DMA_SOFF_REG(DMA0,6)
#define DMA_TCD6_ATTR                            DMA_ATTR_REG(DMA0,6)
#define DMA_TCD6_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,6)
#define DMA_TCD6_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,6)
#define DMA_TCD6_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,6)
#define DMA_TCD6_SLAST                           DMA_SLAST_REG(DMA0,6)
#define DMA_TCD6_DADDR                           DMA_DADDR_REG(DMA0,6)
#define DMA_TCD6_DOFF                            DMA_DOFF_REG(DMA0,6)
#define DMA_TCD6_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,6)
#define DMA_TCD6_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,6)
#define DMA_TCD6_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,6)
#define DMA_TCD6_CSR                             DMA_CSR_REG(DMA0,6)
#define DMA_TCD6_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,6)
#define DMA_TCD6_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,6)
#define DMA_TCD7_SADDR                           DMA_SADDR_REG(DMA0,7)
#define DMA_TCD7_SOFF                            DMA_SOFF_REG(DMA0,7)
#define DMA_TCD7_ATTR                            DMA_ATTR_REG(DMA0,7)
#define DMA_TCD7_NBYTES_MLNO                     DMA_NBYTES_MLNO_REG(DMA0,7)
#define DMA_TCD7_NBYTES_MLOFFNO                  DMA_NBYTES_MLOFFNO_REG(DMA0,7)
#define DMA_TCD7_NBYTES_MLOFFYES                 DMA_NBYTES_MLOFFYES_REG(DMA0,7)
#define DMA_TCD7_SLAST                           DMA_SLAST_REG(DMA0,7)
#define DMA_TCD7_DADDR                           DMA_DADDR_REG(DMA0,7)
#define DMA_TCD7_DOFF                            DMA_DOFF_REG(DMA0,7)
#define DMA_TCD7_CITER_ELINKNO                   DMA_CITER_ELINKNO_REG(DMA0,7)
#define DMA_TCD7_CITER_ELINKYES                  DMA_CITER_ELINKYES_REG(DMA0,7)
#define DMA_TCD7_DLASTSGA                        DMA_DLAST_SGA_REG(DMA0,7)
#define DMA_TCD7_CSR                             DMA_CSR_REG(DMA0,7)
#define DMA_TCD7_BITER_ELINKNO                   DMA_BITER_ELINKNO_REG(DMA0,7)
#define DMA_TCD7_BITER_ELINKYES                  DMA_BITER_ELINKYES_REG(DMA0,7)

/* DMA - Register array accessors */
#define DMA_SADDR(index)                         DMA_SADDR_REG(DMA0,index)
#define DMA_SOFF(index)                          DMA_SOFF_REG(DMA0,index)
#define DMA_ATTR(index)                          DMA_ATTR_REG(DMA0,index)
#define DMA_NBYTES_MLNO(index)                   DMA_NBYTES_MLNO_REG(DMA0,index)
#define DMA_NBYTES_MLOFFNO(index)                DMA_NBYTES_MLOFFNO_REG(DMA0,index)
#define DMA_NBYTES_MLOFFYES(index)               DMA_NBYTES_MLOFFYES_REG(DMA0,index)
#define DMA_SLAST(index)                         DMA_SLAST_REG(DMA0,index)
#define DMA_DADDR(index)                         DMA_DADDR_REG(DMA0,index)
#define DMA_DOFF(index)                          DMA_DOFF_REG(DMA0,index)
#define DMA_CITER_ELINKNO(index)                 DMA_CITER_ELINKNO_REG(DMA0,index)
#define DMA_CITER_ELINKYES(index)                DMA_CITER_ELINKYES_REG(DMA0,index)
#define DMA_DLAST_SGA(index)                     DMA_DLAST_SGA_REG(DMA0,index)
#define DMA_CSR(index)                           DMA_CSR_REG(DMA0,index)
#define DMA_BITER_ELINKNO(index)                 DMA_BITER_ELINKNO_REG(DMA0,index)
#define DMA_BITER_ELINKYES(index)                DMA_BITER_ELINKYES_REG(DMA0,index)

/*!
 * @}
 */ /* end of group DMA_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMAMUX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Peripheral_Access_Layer DMAMUX Peripheral Access Layer
 * @{
 */

/** DMAMUX - Register Layout Typedef */
typedef struct {
  __IO uint8_t CHCFG[8];                           /**< Channel Configuration register, array offset: 0x0, array step: 0x1 */
} DMAMUX_Type, *DMAMUX_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- DMAMUX - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Register_Accessor_Macros DMAMUX - Register accessor macros
 * @{
 */


/* DMAMUX - Register accessors */
#define DMAMUX_CHCFG_REG(base,index)             ((base)->CHCFG[index])
#define DMAMUX_CHCFG_COUNT                       8

/*!
 * @}
 */ /* end of group DMAMUX_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- DMAMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Register_Masks DMAMUX Register Masks
 * @{
 */

/* CHCFG Bit Fields */
#define DMAMUX_CHCFG_SOURCE_MASK                 0x3Fu
#define DMAMUX_CHCFG_SOURCE_SHIFT                0
#define DMAMUX_CHCFG_SOURCE_WIDTH                6
#define DMAMUX_CHCFG_SOURCE(x)                   (((uint8_t)(((uint8_t)(x))<<DMAMUX_CHCFG_SOURCE_SHIFT))&DMAMUX_CHCFG_SOURCE_MASK)
#define DMAMUX_CHCFG_TRIG_MASK                   0x40u
#define DMAMUX_CHCFG_TRIG_SHIFT                  6
#define DMAMUX_CHCFG_TRIG_WIDTH                  1
#define DMAMUX_CHCFG_TRIG(x)                     (((uint8_t)(((uint8_t)(x))<<DMAMUX_CHCFG_TRIG_SHIFT))&DMAMUX_CHCFG_TRIG_MASK)
#define DMAMUX_CHCFG_ENBL_MASK                   0x80u
#define DMAMUX_CHCFG_ENBL_SHIFT                  7
#define DMAMUX_CHCFG_ENBL_WIDTH                  1
#define DMAMUX_CHCFG_ENBL(x)                     (((uint8_t)(((uint8_t)(x))<<DMAMUX_CHCFG_ENBL_SHIFT))&DMAMUX_CHCFG_ENBL_MASK)

/*!
 * @}
 */ /* end of group DMAMUX_Register_Masks */


/* DMAMUX - Peripheral instance base addresses */
/** Peripheral DMAMUX base address */
#define DMAMUX_BASE                              (0x40021000u)
/** Peripheral DMAMUX base pointer */
#define DMAMUX                                   ((DMAMUX_Type *)DMAMUX_BASE)
#define DMAMUX_BASE_PTR                          (DMAMUX)
/** Array initializer of DMAMUX peripheral base addresses */
#define DMAMUX_BASE_ADDRS                        { DMAMUX_BASE }
/** Array initializer of DMAMUX peripheral base pointers */
#define DMAMUX_BASE_PTRS                         { DMAMUX }

/* ----------------------------------------------------------------------------
   -- DMAMUX - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMAMUX_Register_Accessor_Macros DMAMUX - Register accessor macros
 * @{
 */


/* DMAMUX - Register instance definitions */
/* DMAMUX */
#define DMAMUX_CHCFG0                            DMAMUX_CHCFG_REG(DMAMUX,0)
#define DMAMUX_CHCFG1                            DMAMUX_CHCFG_REG(DMAMUX,1)
#define DMAMUX_CHCFG2                            DMAMUX_CHCFG_REG(DMAMUX,2)
#define DMAMUX_CHCFG3                            DMAMUX_CHCFG_REG(DMAMUX,3)
#define DMAMUX_CHCFG4                            DMAMUX_CHCFG_REG(DMAMUX,4)
#define DMAMUX_CHCFG5                            DMAMUX_CHCFG_REG(DMAMUX,5)
#define DMAMUX_CHCFG6                            DMAMUX_CHCFG_REG(DMAMUX,6)
#define DMAMUX_CHCFG7                            DMAMUX_CHCFG_REG(DMAMUX,7)

/* DMAMUX - Register array accessors */
#define DMAMUX_CHCFG(index)                      DMAMUX_CHCFG_REG(DMAMUX,index)

/*!
 * @}
 */ /* end of group DMAMUX_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group DMAMUX_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EMVSIM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EMVSIM_Peripheral_Access_Layer EMVSIM Peripheral Access Layer
 * @{
 */

/** EMVSIM - Register Layout Typedef */
typedef struct {
  __I  uint32_t VER_ID;                            /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
  __IO uint32_t CLKCFG;                            /**< Clock Configuration Register, offset: 0x8 */
  __IO uint32_t DIVISOR;                           /**< Baud Rate Divisor Register, offset: 0xC */
  __IO uint32_t CTRL;                              /**< Control Register, offset: 0x10 */
  __IO uint32_t INT_MASK;                          /**< Interrupt Mask Register, offset: 0x14 */
  __IO uint32_t RX_THD;                            /**< Receiver Threshold Register, offset: 0x18 */
  __IO uint32_t TX_THD;                            /**< Transmitter Threshold Register, offset: 0x1C */
  __IO uint32_t RX_STATUS;                         /**< Receive Status Register, offset: 0x20 */
  __IO uint32_t TX_STATUS;                         /**< Transmitter Status Register, offset: 0x24 */
  __IO uint32_t PCSR;                              /**< Port Control and Status Register, offset: 0x28 */
  __I  uint32_t RX_BUF;                            /**< Receive Data Read Buffer, offset: 0x2C */
  __IO uint32_t TX_BUF;                            /**< Transmit Data Buffer, offset: 0x30 */
  __IO uint32_t TX_GETU;                           /**< Transmitter Guard ETU Value Register, offset: 0x34 */
  __IO uint32_t CWT_VAL;                           /**< Character Wait Time Value Register, offset: 0x38 */
  __IO uint32_t BWT_VAL;                           /**< Block Wait Time Value Register, offset: 0x3C */
  __IO uint32_t BGT_VAL;                           /**< Block Guard Time Value Register, offset: 0x40 */
  __IO uint32_t GPCNT0_VAL;                        /**< General Purpose Counter 0 Timeout Value Register, offset: 0x44 */
  __IO uint32_t GPCNT1_VAL;                        /**< General Purpose Counter 1 Timeout Value, offset: 0x48 */
} EMVSIM_Type, *EMVSIM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- EMVSIM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EMVSIM_Register_Accessor_Macros EMVSIM - Register accessor macros
 * @{
 */


/* EMVSIM - Register accessors */
#define EMVSIM_VER_ID_REG(base)                  ((base)->VER_ID)
#define EMVSIM_PARAM_REG(base)                   ((base)->PARAM)
#define EMVSIM_CLKCFG_REG(base)                  ((base)->CLKCFG)
#define EMVSIM_DIVISOR_REG(base)                 ((base)->DIVISOR)
#define EMVSIM_CTRL_REG(base)                    ((base)->CTRL)
#define EMVSIM_INT_MASK_REG(base)                ((base)->INT_MASK)
#define EMVSIM_RX_THD_REG(base)                  ((base)->RX_THD)
#define EMVSIM_TX_THD_REG(base)                  ((base)->TX_THD)
#define EMVSIM_RX_STATUS_REG(base)               ((base)->RX_STATUS)
#define EMVSIM_TX_STATUS_REG(base)               ((base)->TX_STATUS)
#define EMVSIM_PCSR_REG(base)                    ((base)->PCSR)
#define EMVSIM_RX_BUF_REG(base)                  ((base)->RX_BUF)
#define EMVSIM_TX_BUF_REG(base)                  ((base)->TX_BUF)
#define EMVSIM_TX_GETU_REG(base)                 ((base)->TX_GETU)
#define EMVSIM_CWT_VAL_REG(base)                 ((base)->CWT_VAL)
#define EMVSIM_BWT_VAL_REG(base)                 ((base)->BWT_VAL)
#define EMVSIM_BGT_VAL_REG(base)                 ((base)->BGT_VAL)
#define EMVSIM_GPCNT0_VAL_REG(base)              ((base)->GPCNT0_VAL)
#define EMVSIM_GPCNT1_VAL_REG(base)              ((base)->GPCNT1_VAL)

/*!
 * @}
 */ /* end of group EMVSIM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- EMVSIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EMVSIM_Register_Masks EMVSIM Register Masks
 * @{
 */

/* VER_ID Bit Fields */
#define EMVSIM_VER_ID_VER_MASK                   0xFFFFFFFFu
#define EMVSIM_VER_ID_VER_SHIFT                  0
#define EMVSIM_VER_ID_VER_WIDTH                  32
#define EMVSIM_VER_ID_VER(x)                     (((uint32_t)(((uint32_t)(x))<<EMVSIM_VER_ID_VER_SHIFT))&EMVSIM_VER_ID_VER_MASK)
/* PARAM Bit Fields */
#define EMVSIM_PARAM_RX_FIFO_DEPTH_MASK          0xFFu
#define EMVSIM_PARAM_RX_FIFO_DEPTH_SHIFT         0
#define EMVSIM_PARAM_RX_FIFO_DEPTH_WIDTH         8
#define EMVSIM_PARAM_RX_FIFO_DEPTH(x)            (((uint32_t)(((uint32_t)(x))<<EMVSIM_PARAM_RX_FIFO_DEPTH_SHIFT))&EMVSIM_PARAM_RX_FIFO_DEPTH_MASK)
#define EMVSIM_PARAM_TX_FIFO_DEPTH_MASK          0xFF00u
#define EMVSIM_PARAM_TX_FIFO_DEPTH_SHIFT         8
#define EMVSIM_PARAM_TX_FIFO_DEPTH_WIDTH         8
#define EMVSIM_PARAM_TX_FIFO_DEPTH(x)            (((uint32_t)(((uint32_t)(x))<<EMVSIM_PARAM_TX_FIFO_DEPTH_SHIFT))&EMVSIM_PARAM_TX_FIFO_DEPTH_MASK)
/* CLKCFG Bit Fields */
#define EMVSIM_CLKCFG_CLK_PRSC_MASK              0xFFu
#define EMVSIM_CLKCFG_CLK_PRSC_SHIFT             0
#define EMVSIM_CLKCFG_CLK_PRSC_WIDTH             8
#define EMVSIM_CLKCFG_CLK_PRSC(x)                (((uint32_t)(((uint32_t)(x))<<EMVSIM_CLKCFG_CLK_PRSC_SHIFT))&EMVSIM_CLKCFG_CLK_PRSC_MASK)
#define EMVSIM_CLKCFG_GPCNT1_CLK_SEL_MASK        0x300u
#define EMVSIM_CLKCFG_GPCNT1_CLK_SEL_SHIFT       8
#define EMVSIM_CLKCFG_GPCNT1_CLK_SEL_WIDTH       2
#define EMVSIM_CLKCFG_GPCNT1_CLK_SEL(x)          (((uint32_t)(((uint32_t)(x))<<EMVSIM_CLKCFG_GPCNT1_CLK_SEL_SHIFT))&EMVSIM_CLKCFG_GPCNT1_CLK_SEL_MASK)
#define EMVSIM_CLKCFG_GPCNT0_CLK_SEL_MASK        0xC00u
#define EMVSIM_CLKCFG_GPCNT0_CLK_SEL_SHIFT       10
#define EMVSIM_CLKCFG_GPCNT0_CLK_SEL_WIDTH       2
#define EMVSIM_CLKCFG_GPCNT0_CLK_SEL(x)          (((uint32_t)(((uint32_t)(x))<<EMVSIM_CLKCFG_GPCNT0_CLK_SEL_SHIFT))&EMVSIM_CLKCFG_GPCNT0_CLK_SEL_MASK)
/* DIVISOR Bit Fields */
#define EMVSIM_DIVISOR_DIVISOR_VALUE_MASK        0x1FFu
#define EMVSIM_DIVISOR_DIVISOR_VALUE_SHIFT       0
#define EMVSIM_DIVISOR_DIVISOR_VALUE_WIDTH       9
#define EMVSIM_DIVISOR_DIVISOR_VALUE(x)          (((uint32_t)(((uint32_t)(x))<<EMVSIM_DIVISOR_DIVISOR_VALUE_SHIFT))&EMVSIM_DIVISOR_DIVISOR_VALUE_MASK)
/* CTRL Bit Fields */
#define EMVSIM_CTRL_IC_MASK                      0x1u
#define EMVSIM_CTRL_IC_SHIFT                     0
#define EMVSIM_CTRL_IC_WIDTH                     1
#define EMVSIM_CTRL_IC(x)                        (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_IC_SHIFT))&EMVSIM_CTRL_IC_MASK)
#define EMVSIM_CTRL_ICM_MASK                     0x2u
#define EMVSIM_CTRL_ICM_SHIFT                    1
#define EMVSIM_CTRL_ICM_WIDTH                    1
#define EMVSIM_CTRL_ICM(x)                       (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_ICM_SHIFT))&EMVSIM_CTRL_ICM_MASK)
#define EMVSIM_CTRL_ANACK_MASK                   0x4u
#define EMVSIM_CTRL_ANACK_SHIFT                  2
#define EMVSIM_CTRL_ANACK_WIDTH                  1
#define EMVSIM_CTRL_ANACK(x)                     (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_ANACK_SHIFT))&EMVSIM_CTRL_ANACK_MASK)
#define EMVSIM_CTRL_ONACK_MASK                   0x8u
#define EMVSIM_CTRL_ONACK_SHIFT                  3
#define EMVSIM_CTRL_ONACK_WIDTH                  1
#define EMVSIM_CTRL_ONACK(x)                     (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_ONACK_SHIFT))&EMVSIM_CTRL_ONACK_MASK)
#define EMVSIM_CTRL_FLSH_RX_MASK                 0x100u
#define EMVSIM_CTRL_FLSH_RX_SHIFT                8
#define EMVSIM_CTRL_FLSH_RX_WIDTH                1
#define EMVSIM_CTRL_FLSH_RX(x)                   (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_FLSH_RX_SHIFT))&EMVSIM_CTRL_FLSH_RX_MASK)
#define EMVSIM_CTRL_FLSH_TX_MASK                 0x200u
#define EMVSIM_CTRL_FLSH_TX_SHIFT                9
#define EMVSIM_CTRL_FLSH_TX_WIDTH                1
#define EMVSIM_CTRL_FLSH_TX(x)                   (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_FLSH_TX_SHIFT))&EMVSIM_CTRL_FLSH_TX_MASK)
#define EMVSIM_CTRL_SW_RST_MASK                  0x400u
#define EMVSIM_CTRL_SW_RST_SHIFT                 10
#define EMVSIM_CTRL_SW_RST_WIDTH                 1
#define EMVSIM_CTRL_SW_RST(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_SW_RST_SHIFT))&EMVSIM_CTRL_SW_RST_MASK)
#define EMVSIM_CTRL_KILL_CLOCKS_MASK             0x800u
#define EMVSIM_CTRL_KILL_CLOCKS_SHIFT            11
#define EMVSIM_CTRL_KILL_CLOCKS_WIDTH            1
#define EMVSIM_CTRL_KILL_CLOCKS(x)               (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_KILL_CLOCKS_SHIFT))&EMVSIM_CTRL_KILL_CLOCKS_MASK)
#define EMVSIM_CTRL_DOZE_EN_MASK                 0x1000u
#define EMVSIM_CTRL_DOZE_EN_SHIFT                12
#define EMVSIM_CTRL_DOZE_EN_WIDTH                1
#define EMVSIM_CTRL_DOZE_EN(x)                   (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_DOZE_EN_SHIFT))&EMVSIM_CTRL_DOZE_EN_MASK)
#define EMVSIM_CTRL_STOP_EN_MASK                 0x2000u
#define EMVSIM_CTRL_STOP_EN_SHIFT                13
#define EMVSIM_CTRL_STOP_EN_WIDTH                1
#define EMVSIM_CTRL_STOP_EN(x)                   (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_STOP_EN_SHIFT))&EMVSIM_CTRL_STOP_EN_MASK)
#define EMVSIM_CTRL_RCV_EN_MASK                  0x10000u
#define EMVSIM_CTRL_RCV_EN_SHIFT                 16
#define EMVSIM_CTRL_RCV_EN_WIDTH                 1
#define EMVSIM_CTRL_RCV_EN(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_RCV_EN_SHIFT))&EMVSIM_CTRL_RCV_EN_MASK)
#define EMVSIM_CTRL_XMT_EN_MASK                  0x20000u
#define EMVSIM_CTRL_XMT_EN_SHIFT                 17
#define EMVSIM_CTRL_XMT_EN_WIDTH                 1
#define EMVSIM_CTRL_XMT_EN(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_XMT_EN_SHIFT))&EMVSIM_CTRL_XMT_EN_MASK)
#define EMVSIM_CTRL_RCVR_11_MASK                 0x40000u
#define EMVSIM_CTRL_RCVR_11_SHIFT                18
#define EMVSIM_CTRL_RCVR_11_WIDTH                1
#define EMVSIM_CTRL_RCVR_11(x)                   (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_RCVR_11_SHIFT))&EMVSIM_CTRL_RCVR_11_MASK)
#define EMVSIM_CTRL_RX_DMA_EN_MASK               0x80000u
#define EMVSIM_CTRL_RX_DMA_EN_SHIFT              19
#define EMVSIM_CTRL_RX_DMA_EN_WIDTH              1
#define EMVSIM_CTRL_RX_DMA_EN(x)                 (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_RX_DMA_EN_SHIFT))&EMVSIM_CTRL_RX_DMA_EN_MASK)
#define EMVSIM_CTRL_TX_DMA_EN_MASK               0x100000u
#define EMVSIM_CTRL_TX_DMA_EN_SHIFT              20
#define EMVSIM_CTRL_TX_DMA_EN_WIDTH              1
#define EMVSIM_CTRL_TX_DMA_EN(x)                 (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_TX_DMA_EN_SHIFT))&EMVSIM_CTRL_TX_DMA_EN_MASK)
#define EMVSIM_CTRL_INV_CRC_VAL_MASK             0x1000000u
#define EMVSIM_CTRL_INV_CRC_VAL_SHIFT            24
#define EMVSIM_CTRL_INV_CRC_VAL_WIDTH            1
#define EMVSIM_CTRL_INV_CRC_VAL(x)               (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_INV_CRC_VAL_SHIFT))&EMVSIM_CTRL_INV_CRC_VAL_MASK)
#define EMVSIM_CTRL_CRC_OUT_FLIP_MASK            0x2000000u
#define EMVSIM_CTRL_CRC_OUT_FLIP_SHIFT           25
#define EMVSIM_CTRL_CRC_OUT_FLIP_WIDTH           1
#define EMVSIM_CTRL_CRC_OUT_FLIP(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_CRC_OUT_FLIP_SHIFT))&EMVSIM_CTRL_CRC_OUT_FLIP_MASK)
#define EMVSIM_CTRL_CRC_IN_FLIP_MASK             0x4000000u
#define EMVSIM_CTRL_CRC_IN_FLIP_SHIFT            26
#define EMVSIM_CTRL_CRC_IN_FLIP_WIDTH            1
#define EMVSIM_CTRL_CRC_IN_FLIP(x)               (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_CRC_IN_FLIP_SHIFT))&EMVSIM_CTRL_CRC_IN_FLIP_MASK)
#define EMVSIM_CTRL_CWT_EN_MASK                  0x8000000u
#define EMVSIM_CTRL_CWT_EN_SHIFT                 27
#define EMVSIM_CTRL_CWT_EN_WIDTH                 1
#define EMVSIM_CTRL_CWT_EN(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_CWT_EN_SHIFT))&EMVSIM_CTRL_CWT_EN_MASK)
#define EMVSIM_CTRL_LRC_EN_MASK                  0x10000000u
#define EMVSIM_CTRL_LRC_EN_SHIFT                 28
#define EMVSIM_CTRL_LRC_EN_WIDTH                 1
#define EMVSIM_CTRL_LRC_EN(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_LRC_EN_SHIFT))&EMVSIM_CTRL_LRC_EN_MASK)
#define EMVSIM_CTRL_CRC_EN_MASK                  0x20000000u
#define EMVSIM_CTRL_CRC_EN_SHIFT                 29
#define EMVSIM_CTRL_CRC_EN_WIDTH                 1
#define EMVSIM_CTRL_CRC_EN(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_CRC_EN_SHIFT))&EMVSIM_CTRL_CRC_EN_MASK)
#define EMVSIM_CTRL_XMT_CRC_LRC_MASK             0x40000000u
#define EMVSIM_CTRL_XMT_CRC_LRC_SHIFT            30
#define EMVSIM_CTRL_XMT_CRC_LRC_WIDTH            1
#define EMVSIM_CTRL_XMT_CRC_LRC(x)               (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_XMT_CRC_LRC_SHIFT))&EMVSIM_CTRL_XMT_CRC_LRC_MASK)
#define EMVSIM_CTRL_BWT_EN_MASK                  0x80000000u
#define EMVSIM_CTRL_BWT_EN_SHIFT                 31
#define EMVSIM_CTRL_BWT_EN_WIDTH                 1
#define EMVSIM_CTRL_BWT_EN(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_CTRL_BWT_EN_SHIFT))&EMVSIM_CTRL_BWT_EN_MASK)
/* INT_MASK Bit Fields */
#define EMVSIM_INT_MASK_RDT_IM_MASK              0x1u
#define EMVSIM_INT_MASK_RDT_IM_SHIFT             0
#define EMVSIM_INT_MASK_RDT_IM_WIDTH             1
#define EMVSIM_INT_MASK_RDT_IM(x)                (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_RDT_IM_SHIFT))&EMVSIM_INT_MASK_RDT_IM_MASK)
#define EMVSIM_INT_MASK_TC_IM_MASK               0x2u
#define EMVSIM_INT_MASK_TC_IM_SHIFT              1
#define EMVSIM_INT_MASK_TC_IM_WIDTH              1
#define EMVSIM_INT_MASK_TC_IM(x)                 (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_TC_IM_SHIFT))&EMVSIM_INT_MASK_TC_IM_MASK)
#define EMVSIM_INT_MASK_RFO_IM_MASK              0x4u
#define EMVSIM_INT_MASK_RFO_IM_SHIFT             2
#define EMVSIM_INT_MASK_RFO_IM_WIDTH             1
#define EMVSIM_INT_MASK_RFO_IM(x)                (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_RFO_IM_SHIFT))&EMVSIM_INT_MASK_RFO_IM_MASK)
#define EMVSIM_INT_MASK_ETC_IM_MASK              0x8u
#define EMVSIM_INT_MASK_ETC_IM_SHIFT             3
#define EMVSIM_INT_MASK_ETC_IM_WIDTH             1
#define EMVSIM_INT_MASK_ETC_IM(x)                (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_ETC_IM_SHIFT))&EMVSIM_INT_MASK_ETC_IM_MASK)
#define EMVSIM_INT_MASK_TFE_IM_MASK              0x10u
#define EMVSIM_INT_MASK_TFE_IM_SHIFT             4
#define EMVSIM_INT_MASK_TFE_IM_WIDTH             1
#define EMVSIM_INT_MASK_TFE_IM(x)                (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_TFE_IM_SHIFT))&EMVSIM_INT_MASK_TFE_IM_MASK)
#define EMVSIM_INT_MASK_TNACK_IM_MASK            0x20u
#define EMVSIM_INT_MASK_TNACK_IM_SHIFT           5
#define EMVSIM_INT_MASK_TNACK_IM_WIDTH           1
#define EMVSIM_INT_MASK_TNACK_IM(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_TNACK_IM_SHIFT))&EMVSIM_INT_MASK_TNACK_IM_MASK)
#define EMVSIM_INT_MASK_TFF_IM_MASK              0x40u
#define EMVSIM_INT_MASK_TFF_IM_SHIFT             6
#define EMVSIM_INT_MASK_TFF_IM_WIDTH             1
#define EMVSIM_INT_MASK_TFF_IM(x)                (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_TFF_IM_SHIFT))&EMVSIM_INT_MASK_TFF_IM_MASK)
#define EMVSIM_INT_MASK_TDT_IM_MASK              0x80u
#define EMVSIM_INT_MASK_TDT_IM_SHIFT             7
#define EMVSIM_INT_MASK_TDT_IM_WIDTH             1
#define EMVSIM_INT_MASK_TDT_IM(x)                (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_TDT_IM_SHIFT))&EMVSIM_INT_MASK_TDT_IM_MASK)
#define EMVSIM_INT_MASK_GPCNT0_IM_MASK           0x100u
#define EMVSIM_INT_MASK_GPCNT0_IM_SHIFT          8
#define EMVSIM_INT_MASK_GPCNT0_IM_WIDTH          1
#define EMVSIM_INT_MASK_GPCNT0_IM(x)             (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_GPCNT0_IM_SHIFT))&EMVSIM_INT_MASK_GPCNT0_IM_MASK)
#define EMVSIM_INT_MASK_CWT_ERR_IM_MASK          0x200u
#define EMVSIM_INT_MASK_CWT_ERR_IM_SHIFT         9
#define EMVSIM_INT_MASK_CWT_ERR_IM_WIDTH         1
#define EMVSIM_INT_MASK_CWT_ERR_IM(x)            (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_CWT_ERR_IM_SHIFT))&EMVSIM_INT_MASK_CWT_ERR_IM_MASK)
#define EMVSIM_INT_MASK_RNACK_IM_MASK            0x400u
#define EMVSIM_INT_MASK_RNACK_IM_SHIFT           10
#define EMVSIM_INT_MASK_RNACK_IM_WIDTH           1
#define EMVSIM_INT_MASK_RNACK_IM(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_RNACK_IM_SHIFT))&EMVSIM_INT_MASK_RNACK_IM_MASK)
#define EMVSIM_INT_MASK_BWT_ERR_IM_MASK          0x800u
#define EMVSIM_INT_MASK_BWT_ERR_IM_SHIFT         11
#define EMVSIM_INT_MASK_BWT_ERR_IM_WIDTH         1
#define EMVSIM_INT_MASK_BWT_ERR_IM(x)            (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_BWT_ERR_IM_SHIFT))&EMVSIM_INT_MASK_BWT_ERR_IM_MASK)
#define EMVSIM_INT_MASK_BGT_ERR_IM_MASK          0x1000u
#define EMVSIM_INT_MASK_BGT_ERR_IM_SHIFT         12
#define EMVSIM_INT_MASK_BGT_ERR_IM_WIDTH         1
#define EMVSIM_INT_MASK_BGT_ERR_IM(x)            (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_BGT_ERR_IM_SHIFT))&EMVSIM_INT_MASK_BGT_ERR_IM_MASK)
#define EMVSIM_INT_MASK_GPCNT1_IM_MASK           0x2000u
#define EMVSIM_INT_MASK_GPCNT1_IM_SHIFT          13
#define EMVSIM_INT_MASK_GPCNT1_IM_WIDTH          1
#define EMVSIM_INT_MASK_GPCNT1_IM(x)             (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_GPCNT1_IM_SHIFT))&EMVSIM_INT_MASK_GPCNT1_IM_MASK)
#define EMVSIM_INT_MASK_RX_DATA_IM_MASK          0x4000u
#define EMVSIM_INT_MASK_RX_DATA_IM_SHIFT         14
#define EMVSIM_INT_MASK_RX_DATA_IM_WIDTH         1
#define EMVSIM_INT_MASK_RX_DATA_IM(x)            (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_RX_DATA_IM_SHIFT))&EMVSIM_INT_MASK_RX_DATA_IM_MASK)
#define EMVSIM_INT_MASK_PEF_IM_MASK              0x8000u
#define EMVSIM_INT_MASK_PEF_IM_SHIFT             15
#define EMVSIM_INT_MASK_PEF_IM_WIDTH             1
#define EMVSIM_INT_MASK_PEF_IM(x)                (((uint32_t)(((uint32_t)(x))<<EMVSIM_INT_MASK_PEF_IM_SHIFT))&EMVSIM_INT_MASK_PEF_IM_MASK)
/* RX_THD Bit Fields */
#define EMVSIM_RX_THD_RDT_MASK                   0xFu
#define EMVSIM_RX_THD_RDT_SHIFT                  0
#define EMVSIM_RX_THD_RDT_WIDTH                  4
#define EMVSIM_RX_THD_RDT(x)                     (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_THD_RDT_SHIFT))&EMVSIM_RX_THD_RDT_MASK)
#define EMVSIM_RX_THD_RNCK_THD_MASK              0xF00u
#define EMVSIM_RX_THD_RNCK_THD_SHIFT             8
#define EMVSIM_RX_THD_RNCK_THD_WIDTH             4
#define EMVSIM_RX_THD_RNCK_THD(x)                (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_THD_RNCK_THD_SHIFT))&EMVSIM_RX_THD_RNCK_THD_MASK)
/* TX_THD Bit Fields */
#define EMVSIM_TX_THD_TDT_MASK                   0xFu
#define EMVSIM_TX_THD_TDT_SHIFT                  0
#define EMVSIM_TX_THD_TDT_WIDTH                  4
#define EMVSIM_TX_THD_TDT(x)                     (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_THD_TDT_SHIFT))&EMVSIM_TX_THD_TDT_MASK)
#define EMVSIM_TX_THD_TNCK_THD_MASK              0xF00u
#define EMVSIM_TX_THD_TNCK_THD_SHIFT             8
#define EMVSIM_TX_THD_TNCK_THD_WIDTH             4
#define EMVSIM_TX_THD_TNCK_THD(x)                (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_THD_TNCK_THD_SHIFT))&EMVSIM_TX_THD_TNCK_THD_MASK)
/* RX_STATUS Bit Fields */
#define EMVSIM_RX_STATUS_RFO_MASK                0x1u
#define EMVSIM_RX_STATUS_RFO_SHIFT               0
#define EMVSIM_RX_STATUS_RFO_WIDTH               1
#define EMVSIM_RX_STATUS_RFO(x)                  (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_RFO_SHIFT))&EMVSIM_RX_STATUS_RFO_MASK)
#define EMVSIM_RX_STATUS_RX_DATA_MASK            0x10u
#define EMVSIM_RX_STATUS_RX_DATA_SHIFT           4
#define EMVSIM_RX_STATUS_RX_DATA_WIDTH           1
#define EMVSIM_RX_STATUS_RX_DATA(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_RX_DATA_SHIFT))&EMVSIM_RX_STATUS_RX_DATA_MASK)
#define EMVSIM_RX_STATUS_RDTF_MASK               0x20u
#define EMVSIM_RX_STATUS_RDTF_SHIFT              5
#define EMVSIM_RX_STATUS_RDTF_WIDTH              1
#define EMVSIM_RX_STATUS_RDTF(x)                 (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_RDTF_SHIFT))&EMVSIM_RX_STATUS_RDTF_MASK)
#define EMVSIM_RX_STATUS_LRC_OK_MASK             0x40u
#define EMVSIM_RX_STATUS_LRC_OK_SHIFT            6
#define EMVSIM_RX_STATUS_LRC_OK_WIDTH            1
#define EMVSIM_RX_STATUS_LRC_OK(x)               (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_LRC_OK_SHIFT))&EMVSIM_RX_STATUS_LRC_OK_MASK)
#define EMVSIM_RX_STATUS_CRC_OK_MASK             0x80u
#define EMVSIM_RX_STATUS_CRC_OK_SHIFT            7
#define EMVSIM_RX_STATUS_CRC_OK_WIDTH            1
#define EMVSIM_RX_STATUS_CRC_OK(x)               (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_CRC_OK_SHIFT))&EMVSIM_RX_STATUS_CRC_OK_MASK)
#define EMVSIM_RX_STATUS_CWT_ERR_MASK            0x100u
#define EMVSIM_RX_STATUS_CWT_ERR_SHIFT           8
#define EMVSIM_RX_STATUS_CWT_ERR_WIDTH           1
#define EMVSIM_RX_STATUS_CWT_ERR(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_CWT_ERR_SHIFT))&EMVSIM_RX_STATUS_CWT_ERR_MASK)
#define EMVSIM_RX_STATUS_RTE_MASK                0x200u
#define EMVSIM_RX_STATUS_RTE_SHIFT               9
#define EMVSIM_RX_STATUS_RTE_WIDTH               1
#define EMVSIM_RX_STATUS_RTE(x)                  (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_RTE_SHIFT))&EMVSIM_RX_STATUS_RTE_MASK)
#define EMVSIM_RX_STATUS_BWT_ERR_MASK            0x400u
#define EMVSIM_RX_STATUS_BWT_ERR_SHIFT           10
#define EMVSIM_RX_STATUS_BWT_ERR_WIDTH           1
#define EMVSIM_RX_STATUS_BWT_ERR(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_BWT_ERR_SHIFT))&EMVSIM_RX_STATUS_BWT_ERR_MASK)
#define EMVSIM_RX_STATUS_BGT_ERR_MASK            0x800u
#define EMVSIM_RX_STATUS_BGT_ERR_SHIFT           11
#define EMVSIM_RX_STATUS_BGT_ERR_WIDTH           1
#define EMVSIM_RX_STATUS_BGT_ERR(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_BGT_ERR_SHIFT))&EMVSIM_RX_STATUS_BGT_ERR_MASK)
#define EMVSIM_RX_STATUS_PEF_MASK                0x1000u
#define EMVSIM_RX_STATUS_PEF_SHIFT               12
#define EMVSIM_RX_STATUS_PEF_WIDTH               1
#define EMVSIM_RX_STATUS_PEF(x)                  (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_PEF_SHIFT))&EMVSIM_RX_STATUS_PEF_MASK)
#define EMVSIM_RX_STATUS_FEF_MASK                0x2000u
#define EMVSIM_RX_STATUS_FEF_SHIFT               13
#define EMVSIM_RX_STATUS_FEF_WIDTH               1
#define EMVSIM_RX_STATUS_FEF(x)                  (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_FEF_SHIFT))&EMVSIM_RX_STATUS_FEF_MASK)
#define EMVSIM_RX_STATUS_RX_WPTR_MASK            0xF0000u
#define EMVSIM_RX_STATUS_RX_WPTR_SHIFT           16
#define EMVSIM_RX_STATUS_RX_WPTR_WIDTH           4
#define EMVSIM_RX_STATUS_RX_WPTR(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_RX_WPTR_SHIFT))&EMVSIM_RX_STATUS_RX_WPTR_MASK)
#define EMVSIM_RX_STATUS_RX_CNT_MASK             0xFF000000u
#define EMVSIM_RX_STATUS_RX_CNT_SHIFT            24
#define EMVSIM_RX_STATUS_RX_CNT_WIDTH            8
#define EMVSIM_RX_STATUS_RX_CNT(x)               (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_STATUS_RX_CNT_SHIFT))&EMVSIM_RX_STATUS_RX_CNT_MASK)
/* TX_STATUS Bit Fields */
#define EMVSIM_TX_STATUS_TNTE_MASK               0x1u
#define EMVSIM_TX_STATUS_TNTE_SHIFT              0
#define EMVSIM_TX_STATUS_TNTE_WIDTH              1
#define EMVSIM_TX_STATUS_TNTE(x)                 (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_STATUS_TNTE_SHIFT))&EMVSIM_TX_STATUS_TNTE_MASK)
#define EMVSIM_TX_STATUS_TFE_MASK                0x8u
#define EMVSIM_TX_STATUS_TFE_SHIFT               3
#define EMVSIM_TX_STATUS_TFE_WIDTH               1
#define EMVSIM_TX_STATUS_TFE(x)                  (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_STATUS_TFE_SHIFT))&EMVSIM_TX_STATUS_TFE_MASK)
#define EMVSIM_TX_STATUS_ETCF_MASK               0x10u
#define EMVSIM_TX_STATUS_ETCF_SHIFT              4
#define EMVSIM_TX_STATUS_ETCF_WIDTH              1
#define EMVSIM_TX_STATUS_ETCF(x)                 (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_STATUS_ETCF_SHIFT))&EMVSIM_TX_STATUS_ETCF_MASK)
#define EMVSIM_TX_STATUS_TCF_MASK                0x20u
#define EMVSIM_TX_STATUS_TCF_SHIFT               5
#define EMVSIM_TX_STATUS_TCF_WIDTH               1
#define EMVSIM_TX_STATUS_TCF(x)                  (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_STATUS_TCF_SHIFT))&EMVSIM_TX_STATUS_TCF_MASK)
#define EMVSIM_TX_STATUS_TFF_MASK                0x40u
#define EMVSIM_TX_STATUS_TFF_SHIFT               6
#define EMVSIM_TX_STATUS_TFF_WIDTH               1
#define EMVSIM_TX_STATUS_TFF(x)                  (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_STATUS_TFF_SHIFT))&EMVSIM_TX_STATUS_TFF_MASK)
#define EMVSIM_TX_STATUS_TDTF_MASK               0x80u
#define EMVSIM_TX_STATUS_TDTF_SHIFT              7
#define EMVSIM_TX_STATUS_TDTF_WIDTH              1
#define EMVSIM_TX_STATUS_TDTF(x)                 (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_STATUS_TDTF_SHIFT))&EMVSIM_TX_STATUS_TDTF_MASK)
#define EMVSIM_TX_STATUS_GPCNT0_TO_MASK          0x100u
#define EMVSIM_TX_STATUS_GPCNT0_TO_SHIFT         8
#define EMVSIM_TX_STATUS_GPCNT0_TO_WIDTH         1
#define EMVSIM_TX_STATUS_GPCNT0_TO(x)            (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_STATUS_GPCNT0_TO_SHIFT))&EMVSIM_TX_STATUS_GPCNT0_TO_MASK)
#define EMVSIM_TX_STATUS_GPCNT1_TO_MASK          0x200u
#define EMVSIM_TX_STATUS_GPCNT1_TO_SHIFT         9
#define EMVSIM_TX_STATUS_GPCNT1_TO_WIDTH         1
#define EMVSIM_TX_STATUS_GPCNT1_TO(x)            (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_STATUS_GPCNT1_TO_SHIFT))&EMVSIM_TX_STATUS_GPCNT1_TO_MASK)
#define EMVSIM_TX_STATUS_TX_RPTR_MASK            0xF0000u
#define EMVSIM_TX_STATUS_TX_RPTR_SHIFT           16
#define EMVSIM_TX_STATUS_TX_RPTR_WIDTH           4
#define EMVSIM_TX_STATUS_TX_RPTR(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_STATUS_TX_RPTR_SHIFT))&EMVSIM_TX_STATUS_TX_RPTR_MASK)
#define EMVSIM_TX_STATUS_TX_CNT_MASK             0xFF000000u
#define EMVSIM_TX_STATUS_TX_CNT_SHIFT            24
#define EMVSIM_TX_STATUS_TX_CNT_WIDTH            8
#define EMVSIM_TX_STATUS_TX_CNT(x)               (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_STATUS_TX_CNT_SHIFT))&EMVSIM_TX_STATUS_TX_CNT_MASK)
/* PCSR Bit Fields */
#define EMVSIM_PCSR_SAPD_MASK                    0x1u
#define EMVSIM_PCSR_SAPD_SHIFT                   0
#define EMVSIM_PCSR_SAPD_WIDTH                   1
#define EMVSIM_PCSR_SAPD(x)                      (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_SAPD_SHIFT))&EMVSIM_PCSR_SAPD_MASK)
#define EMVSIM_PCSR_SVCC_EN_MASK                 0x2u
#define EMVSIM_PCSR_SVCC_EN_SHIFT                1
#define EMVSIM_PCSR_SVCC_EN_WIDTH                1
#define EMVSIM_PCSR_SVCC_EN(x)                   (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_SVCC_EN_SHIFT))&EMVSIM_PCSR_SVCC_EN_MASK)
#define EMVSIM_PCSR_VCCENP_MASK                  0x4u
#define EMVSIM_PCSR_VCCENP_SHIFT                 2
#define EMVSIM_PCSR_VCCENP_WIDTH                 1
#define EMVSIM_PCSR_VCCENP(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_VCCENP_SHIFT))&EMVSIM_PCSR_VCCENP_MASK)
#define EMVSIM_PCSR_SRST_MASK                    0x8u
#define EMVSIM_PCSR_SRST_SHIFT                   3
#define EMVSIM_PCSR_SRST_WIDTH                   1
#define EMVSIM_PCSR_SRST(x)                      (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_SRST_SHIFT))&EMVSIM_PCSR_SRST_MASK)
#define EMVSIM_PCSR_SCEN_MASK                    0x10u
#define EMVSIM_PCSR_SCEN_SHIFT                   4
#define EMVSIM_PCSR_SCEN_WIDTH                   1
#define EMVSIM_PCSR_SCEN(x)                      (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_SCEN_SHIFT))&EMVSIM_PCSR_SCEN_MASK)
#define EMVSIM_PCSR_SCSP_MASK                    0x20u
#define EMVSIM_PCSR_SCSP_SHIFT                   5
#define EMVSIM_PCSR_SCSP_WIDTH                   1
#define EMVSIM_PCSR_SCSP(x)                      (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_SCSP_SHIFT))&EMVSIM_PCSR_SCSP_MASK)
#define EMVSIM_PCSR_SPD_MASK                     0x80u
#define EMVSIM_PCSR_SPD_SHIFT                    7
#define EMVSIM_PCSR_SPD_WIDTH                    1
#define EMVSIM_PCSR_SPD(x)                       (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_SPD_SHIFT))&EMVSIM_PCSR_SPD_MASK)
#define EMVSIM_PCSR_SPDIM_MASK                   0x1000000u
#define EMVSIM_PCSR_SPDIM_SHIFT                  24
#define EMVSIM_PCSR_SPDIM_WIDTH                  1
#define EMVSIM_PCSR_SPDIM(x)                     (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_SPDIM_SHIFT))&EMVSIM_PCSR_SPDIM_MASK)
#define EMVSIM_PCSR_SPDIF_MASK                   0x2000000u
#define EMVSIM_PCSR_SPDIF_SHIFT                  25
#define EMVSIM_PCSR_SPDIF_WIDTH                  1
#define EMVSIM_PCSR_SPDIF(x)                     (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_SPDIF_SHIFT))&EMVSIM_PCSR_SPDIF_MASK)
#define EMVSIM_PCSR_SPDP_MASK                    0x4000000u
#define EMVSIM_PCSR_SPDP_SHIFT                   26
#define EMVSIM_PCSR_SPDP_WIDTH                   1
#define EMVSIM_PCSR_SPDP(x)                      (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_SPDP_SHIFT))&EMVSIM_PCSR_SPDP_MASK)
#define EMVSIM_PCSR_SPDES_MASK                   0x8000000u
#define EMVSIM_PCSR_SPDES_SHIFT                  27
#define EMVSIM_PCSR_SPDES_WIDTH                  1
#define EMVSIM_PCSR_SPDES(x)                     (((uint32_t)(((uint32_t)(x))<<EMVSIM_PCSR_SPDES_SHIFT))&EMVSIM_PCSR_SPDES_MASK)
/* RX_BUF Bit Fields */
#define EMVSIM_RX_BUF_RX_BYTE_MASK               0xFFu
#define EMVSIM_RX_BUF_RX_BYTE_SHIFT              0
#define EMVSIM_RX_BUF_RX_BYTE_WIDTH              8
#define EMVSIM_RX_BUF_RX_BYTE(x)                 (((uint32_t)(((uint32_t)(x))<<EMVSIM_RX_BUF_RX_BYTE_SHIFT))&EMVSIM_RX_BUF_RX_BYTE_MASK)
/* TX_BUF Bit Fields */
#define EMVSIM_TX_BUF_TX_BYTE_MASK               0xFFu
#define EMVSIM_TX_BUF_TX_BYTE_SHIFT              0
#define EMVSIM_TX_BUF_TX_BYTE_WIDTH              8
#define EMVSIM_TX_BUF_TX_BYTE(x)                 (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_BUF_TX_BYTE_SHIFT))&EMVSIM_TX_BUF_TX_BYTE_MASK)
/* TX_GETU Bit Fields */
#define EMVSIM_TX_GETU_GETU_MASK                 0xFFu
#define EMVSIM_TX_GETU_GETU_SHIFT                0
#define EMVSIM_TX_GETU_GETU_WIDTH                8
#define EMVSIM_TX_GETU_GETU(x)                   (((uint32_t)(((uint32_t)(x))<<EMVSIM_TX_GETU_GETU_SHIFT))&EMVSIM_TX_GETU_GETU_MASK)
/* CWT_VAL Bit Fields */
#define EMVSIM_CWT_VAL_CWT_MASK                  0xFFFFu
#define EMVSIM_CWT_VAL_CWT_SHIFT                 0
#define EMVSIM_CWT_VAL_CWT_WIDTH                 16
#define EMVSIM_CWT_VAL_CWT(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_CWT_VAL_CWT_SHIFT))&EMVSIM_CWT_VAL_CWT_MASK)
/* BWT_VAL Bit Fields */
#define EMVSIM_BWT_VAL_BWT_MASK                  0xFFFFFFFFu
#define EMVSIM_BWT_VAL_BWT_SHIFT                 0
#define EMVSIM_BWT_VAL_BWT_WIDTH                 32
#define EMVSIM_BWT_VAL_BWT(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_BWT_VAL_BWT_SHIFT))&EMVSIM_BWT_VAL_BWT_MASK)
/* BGT_VAL Bit Fields */
#define EMVSIM_BGT_VAL_BGT_MASK                  0xFFFFu
#define EMVSIM_BGT_VAL_BGT_SHIFT                 0
#define EMVSIM_BGT_VAL_BGT_WIDTH                 16
#define EMVSIM_BGT_VAL_BGT(x)                    (((uint32_t)(((uint32_t)(x))<<EMVSIM_BGT_VAL_BGT_SHIFT))&EMVSIM_BGT_VAL_BGT_MASK)
/* GPCNT0_VAL Bit Fields */
#define EMVSIM_GPCNT0_VAL_GPCNT0_MASK            0xFFFFu
#define EMVSIM_GPCNT0_VAL_GPCNT0_SHIFT           0
#define EMVSIM_GPCNT0_VAL_GPCNT0_WIDTH           16
#define EMVSIM_GPCNT0_VAL_GPCNT0(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_GPCNT0_VAL_GPCNT0_SHIFT))&EMVSIM_GPCNT0_VAL_GPCNT0_MASK)
/* GPCNT1_VAL Bit Fields */
#define EMVSIM_GPCNT1_VAL_GPCNT1_MASK            0xFFFFu
#define EMVSIM_GPCNT1_VAL_GPCNT1_SHIFT           0
#define EMVSIM_GPCNT1_VAL_GPCNT1_WIDTH           16
#define EMVSIM_GPCNT1_VAL_GPCNT1(x)              (((uint32_t)(((uint32_t)(x))<<EMVSIM_GPCNT1_VAL_GPCNT1_SHIFT))&EMVSIM_GPCNT1_VAL_GPCNT1_MASK)

/*!
 * @}
 */ /* end of group EMVSIM_Register_Masks */


/* EMVSIM - Peripheral instance base addresses */
/** Peripheral EMVSIM0 base address */
#define EMVSIM0_BASE                             (0x4004E000u)
/** Peripheral EMVSIM0 base pointer */
#define EMVSIM0                                  ((EMVSIM_Type *)EMVSIM0_BASE)
#define EMVSIM0_BASE_PTR                         (EMVSIM0)
/** Peripheral EMVSIM1 base address */
#define EMVSIM1_BASE                             (0x4004F000u)
/** Peripheral EMVSIM1 base pointer */
#define EMVSIM1                                  ((EMVSIM_Type *)EMVSIM1_BASE)
#define EMVSIM1_BASE_PTR                         (EMVSIM1)
/** Array initializer of EMVSIM peripheral base addresses */
#define EMVSIM_BASE_ADDRS                        { EMVSIM0_BASE, EMVSIM1_BASE }
/** Array initializer of EMVSIM peripheral base pointers */
#define EMVSIM_BASE_PTRS                         { EMVSIM0, EMVSIM1 }

/* ----------------------------------------------------------------------------
   -- EMVSIM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EMVSIM_Register_Accessor_Macros EMVSIM - Register accessor macros
 * @{
 */


/* EMVSIM - Register instance definitions */
/* EMVSIM0 */
#define EMVSIM0_VER_ID                           EMVSIM_VER_ID_REG(EMVSIM0)
#define EMVSIM0_PARAM                            EMVSIM_PARAM_REG(EMVSIM0)
#define EMVSIM0_CLKCFG                           EMVSIM_CLKCFG_REG(EMVSIM0)
#define EMVSIM0_DIVISOR                          EMVSIM_DIVISOR_REG(EMVSIM0)
#define EMVSIM0_CTRL                             EMVSIM_CTRL_REG(EMVSIM0)
#define EMVSIM0_INT_MASK                         EMVSIM_INT_MASK_REG(EMVSIM0)
#define EMVSIM0_RX_THD                           EMVSIM_RX_THD_REG(EMVSIM0)
#define EMVSIM0_TX_THD                           EMVSIM_TX_THD_REG(EMVSIM0)
#define EMVSIM0_RX_STATUS                        EMVSIM_RX_STATUS_REG(EMVSIM0)
#define EMVSIM0_TX_STATUS                        EMVSIM_TX_STATUS_REG(EMVSIM0)
#define EMVSIM0_PCSR                             EMVSIM_PCSR_REG(EMVSIM0)
#define EMVSIM0_RX_BUF                           EMVSIM_RX_BUF_REG(EMVSIM0)
#define EMVSIM0_TX_BUF                           EMVSIM_TX_BUF_REG(EMVSIM0)
#define EMVSIM0_TX_GETU                          EMVSIM_TX_GETU_REG(EMVSIM0)
#define EMVSIM0_CWT_VAL                          EMVSIM_CWT_VAL_REG(EMVSIM0)
#define EMVSIM0_BWT_VAL                          EMVSIM_BWT_VAL_REG(EMVSIM0)
#define EMVSIM0_BGT_VAL                          EMVSIM_BGT_VAL_REG(EMVSIM0)
#define EMVSIM0_GPCNT0_VAL                       EMVSIM_GPCNT0_VAL_REG(EMVSIM0)
#define EMVSIM0_GPCNT1_VAL                       EMVSIM_GPCNT1_VAL_REG(EMVSIM0)
/* EMVSIM1 */
#define EMVSIM1_VER_ID                           EMVSIM_VER_ID_REG(EMVSIM1)
#define EMVSIM1_PARAM                            EMVSIM_PARAM_REG(EMVSIM1)
#define EMVSIM1_CLKCFG                           EMVSIM_CLKCFG_REG(EMVSIM1)
#define EMVSIM1_DIVISOR                          EMVSIM_DIVISOR_REG(EMVSIM1)
#define EMVSIM1_CTRL                             EMVSIM_CTRL_REG(EMVSIM1)
#define EMVSIM1_INT_MASK                         EMVSIM_INT_MASK_REG(EMVSIM1)
#define EMVSIM1_RX_THD                           EMVSIM_RX_THD_REG(EMVSIM1)
#define EMVSIM1_TX_THD                           EMVSIM_TX_THD_REG(EMVSIM1)
#define EMVSIM1_RX_STATUS                        EMVSIM_RX_STATUS_REG(EMVSIM1)
#define EMVSIM1_TX_STATUS                        EMVSIM_TX_STATUS_REG(EMVSIM1)
#define EMVSIM1_PCSR                             EMVSIM_PCSR_REG(EMVSIM1)
#define EMVSIM1_RX_BUF                           EMVSIM_RX_BUF_REG(EMVSIM1)
#define EMVSIM1_TX_BUF                           EMVSIM_TX_BUF_REG(EMVSIM1)
#define EMVSIM1_TX_GETU                          EMVSIM_TX_GETU_REG(EMVSIM1)
#define EMVSIM1_CWT_VAL                          EMVSIM_CWT_VAL_REG(EMVSIM1)
#define EMVSIM1_BWT_VAL                          EMVSIM_BWT_VAL_REG(EMVSIM1)
#define EMVSIM1_BGT_VAL                          EMVSIM_BGT_VAL_REG(EMVSIM1)
#define EMVSIM1_GPCNT0_VAL                       EMVSIM_GPCNT0_VAL_REG(EMVSIM1)
#define EMVSIM1_GPCNT1_VAL                       EMVSIM_GPCNT1_VAL_REG(EMVSIM1)

/*!
 * @}
 */ /* end of group EMVSIM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group EMVSIM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EWM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Peripheral_Access_Layer EWM Peripheral Access Layer
 * @{
 */

/** EWM - Register Layout Typedef */
typedef struct {
  __IO uint8_t CTRL;                               /**< Control Register, offset: 0x0 */
  __O  uint8_t SERV;                               /**< Service Register, offset: 0x1 */
  __IO uint8_t CMPL;                               /**< Compare Low Register, offset: 0x2 */
  __IO uint8_t CMPH;                               /**< Compare High Register, offset: 0x3 */
       uint8_t RESERVED_0[1];
  __IO uint8_t CLKPRESCALER;                       /**< Clock Prescaler Register, offset: 0x5 */
} EWM_Type, *EWM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- EWM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Register_Accessor_Macros EWM - Register accessor macros
 * @{
 */


/* EWM - Register accessors */
#define EWM_CTRL_REG(base)                       ((base)->CTRL)
#define EWM_SERV_REG(base)                       ((base)->SERV)
#define EWM_CMPL_REG(base)                       ((base)->CMPL)
#define EWM_CMPH_REG(base)                       ((base)->CMPH)
#define EWM_CLKPRESCALER_REG(base)               ((base)->CLKPRESCALER)

/*!
 * @}
 */ /* end of group EWM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- EWM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Register_Masks EWM Register Masks
 * @{
 */

/* CTRL Bit Fields */
#define EWM_CTRL_EWMEN_MASK                      0x1u
#define EWM_CTRL_EWMEN_SHIFT                     0
#define EWM_CTRL_EWMEN_WIDTH                     1
#define EWM_CTRL_EWMEN(x)                        (((uint8_t)(((uint8_t)(x))<<EWM_CTRL_EWMEN_SHIFT))&EWM_CTRL_EWMEN_MASK)
#define EWM_CTRL_ASSIN_MASK                      0x2u
#define EWM_CTRL_ASSIN_SHIFT                     1
#define EWM_CTRL_ASSIN_WIDTH                     1
#define EWM_CTRL_ASSIN(x)                        (((uint8_t)(((uint8_t)(x))<<EWM_CTRL_ASSIN_SHIFT))&EWM_CTRL_ASSIN_MASK)
#define EWM_CTRL_INEN_MASK                       0x4u
#define EWM_CTRL_INEN_SHIFT                      2
#define EWM_CTRL_INEN_WIDTH                      1
#define EWM_CTRL_INEN(x)                         (((uint8_t)(((uint8_t)(x))<<EWM_CTRL_INEN_SHIFT))&EWM_CTRL_INEN_MASK)
#define EWM_CTRL_INTEN_MASK                      0x8u
#define EWM_CTRL_INTEN_SHIFT                     3
#define EWM_CTRL_INTEN_WIDTH                     1
#define EWM_CTRL_INTEN(x)                        (((uint8_t)(((uint8_t)(x))<<EWM_CTRL_INTEN_SHIFT))&EWM_CTRL_INTEN_MASK)
/* SERV Bit Fields */
#define EWM_SERV_SERVICE_MASK                    0xFFu
#define EWM_SERV_SERVICE_SHIFT                   0
#define EWM_SERV_SERVICE_WIDTH                   8
#define EWM_SERV_SERVICE(x)                      (((uint8_t)(((uint8_t)(x))<<EWM_SERV_SERVICE_SHIFT))&EWM_SERV_SERVICE_MASK)
/* CMPL Bit Fields */
#define EWM_CMPL_COMPAREL_MASK                   0xFFu
#define EWM_CMPL_COMPAREL_SHIFT                  0
#define EWM_CMPL_COMPAREL_WIDTH                  8
#define EWM_CMPL_COMPAREL(x)                     (((uint8_t)(((uint8_t)(x))<<EWM_CMPL_COMPAREL_SHIFT))&EWM_CMPL_COMPAREL_MASK)
/* CMPH Bit Fields */
#define EWM_CMPH_COMPAREH_MASK                   0xFFu
#define EWM_CMPH_COMPAREH_SHIFT                  0
#define EWM_CMPH_COMPAREH_WIDTH                  8
#define EWM_CMPH_COMPAREH(x)                     (((uint8_t)(((uint8_t)(x))<<EWM_CMPH_COMPAREH_SHIFT))&EWM_CMPH_COMPAREH_MASK)
/* CLKPRESCALER Bit Fields */
#define EWM_CLKPRESCALER_CLK_DIV_MASK            0xFFu
#define EWM_CLKPRESCALER_CLK_DIV_SHIFT           0
#define EWM_CLKPRESCALER_CLK_DIV_WIDTH           8
#define EWM_CLKPRESCALER_CLK_DIV(x)              (((uint8_t)(((uint8_t)(x))<<EWM_CLKPRESCALER_CLK_DIV_SHIFT))&EWM_CLKPRESCALER_CLK_DIV_MASK)

/*!
 * @}
 */ /* end of group EWM_Register_Masks */


/* EWM - Peripheral instance base addresses */
/** Peripheral EWM base address */
#define EWM_BASE                                 (0x40061000u)
/** Peripheral EWM base pointer */
#define EWM                                      ((EWM_Type *)EWM_BASE)
#define EWM_BASE_PTR                             (EWM)
/** Array initializer of EWM peripheral base addresses */
#define EWM_BASE_ADDRS                           { EWM_BASE }
/** Array initializer of EWM peripheral base pointers */
#define EWM_BASE_PTRS                            { EWM }

/* ----------------------------------------------------------------------------
   -- EWM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Register_Accessor_Macros EWM - Register accessor macros
 * @{
 */


/* EWM - Register instance definitions */
/* EWM */
#define EWM_CTRL                                 EWM_CTRL_REG(EWM)
#define EWM_SERV                                 EWM_SERV_REG(EWM)
#define EWM_CMPL                                 EWM_CMPL_REG(EWM)
#define EWM_CMPH                                 EWM_CMPH_REG(EWM)
#define EWM_CLKPRESCALER                         EWM_CLKPRESCALER_REG(EWM)

/*!
 * @}
 */ /* end of group EWM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group EWM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FGPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FGPIO_Peripheral_Access_Layer FGPIO Peripheral Access Layer
 * @{
 */

/** FGPIO - Register Layout Typedef */
typedef struct {
  __IO uint32_t PDOR;                              /**< Port Data Output Register, offset: 0x0 */
  __O  uint32_t PSOR;                              /**< Port Set Output Register, offset: 0x4 */
  __O  uint32_t PCOR;                              /**< Port Clear Output Register, offset: 0x8 */
  __O  uint32_t PTOR;                              /**< Port Toggle Output Register, offset: 0xC */
  __I  uint32_t PDIR;                              /**< Port Data Input Register, offset: 0x10 */
  __IO uint32_t PDDR;                              /**< Port Data Direction Register, offset: 0x14 */
} FGPIO_Type, *FGPIO_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- FGPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FGPIO_Register_Accessor_Macros FGPIO - Register accessor macros
 * @{
 */


/* FGPIO - Register accessors */
#define FGPIO_PDOR_REG(base)                     ((base)->PDOR)
#define FGPIO_PSOR_REG(base)                     ((base)->PSOR)
#define FGPIO_PCOR_REG(base)                     ((base)->PCOR)
#define FGPIO_PTOR_REG(base)                     ((base)->PTOR)
#define FGPIO_PDIR_REG(base)                     ((base)->PDIR)
#define FGPIO_PDDR_REG(base)                     ((base)->PDDR)

/*!
 * @}
 */ /* end of group FGPIO_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- FGPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FGPIO_Register_Masks FGPIO Register Masks
 * @{
 */

/* PDOR Bit Fields */
#define FGPIO_PDOR_PDO_MASK                      0xFFFFFFFFu
#define FGPIO_PDOR_PDO_SHIFT                     0
#define FGPIO_PDOR_PDO_WIDTH                     32
#define FGPIO_PDOR_PDO(x)                        (((uint32_t)(((uint32_t)(x))<<FGPIO_PDOR_PDO_SHIFT))&FGPIO_PDOR_PDO_MASK)
/* PSOR Bit Fields */
#define FGPIO_PSOR_PTSO_MASK                     0xFFFFFFFFu
#define FGPIO_PSOR_PTSO_SHIFT                    0
#define FGPIO_PSOR_PTSO_WIDTH                    32
#define FGPIO_PSOR_PTSO(x)                       (((uint32_t)(((uint32_t)(x))<<FGPIO_PSOR_PTSO_SHIFT))&FGPIO_PSOR_PTSO_MASK)
/* PCOR Bit Fields */
#define FGPIO_PCOR_PTCO_MASK                     0xFFFFFFFFu
#define FGPIO_PCOR_PTCO_SHIFT                    0
#define FGPIO_PCOR_PTCO_WIDTH                    32
#define FGPIO_PCOR_PTCO(x)                       (((uint32_t)(((uint32_t)(x))<<FGPIO_PCOR_PTCO_SHIFT))&FGPIO_PCOR_PTCO_MASK)
/* PTOR Bit Fields */
#define FGPIO_PTOR_PTTO_MASK                     0xFFFFFFFFu
#define FGPIO_PTOR_PTTO_SHIFT                    0
#define FGPIO_PTOR_PTTO_WIDTH                    32
#define FGPIO_PTOR_PTTO(x)                       (((uint32_t)(((uint32_t)(x))<<FGPIO_PTOR_PTTO_SHIFT))&FGPIO_PTOR_PTTO_MASK)
/* PDIR Bit Fields */
#define FGPIO_PDIR_PDI_MASK                      0xFFFFFFFFu
#define FGPIO_PDIR_PDI_SHIFT                     0
#define FGPIO_PDIR_PDI_WIDTH                     32
#define FGPIO_PDIR_PDI(x)                        (((uint32_t)(((uint32_t)(x))<<FGPIO_PDIR_PDI_SHIFT))&FGPIO_PDIR_PDI_MASK)
/* PDDR Bit Fields */
#define FGPIO_PDDR_PDD_MASK                      0xFFFFFFFFu
#define FGPIO_PDDR_PDD_SHIFT                     0
#define FGPIO_PDDR_PDD_WIDTH                     32
#define FGPIO_PDDR_PDD(x)                        (((uint32_t)(((uint32_t)(x))<<FGPIO_PDDR_PDD_SHIFT))&FGPIO_PDDR_PDD_MASK)

/*!
 * @}
 */ /* end of group FGPIO_Register_Masks */


/* FGPIO - Peripheral instance base addresses */
/** Peripheral FGPIOA base address */
#define FGPIOA_BASE                              (0xF8000000u)
/** Peripheral FGPIOA base pointer */
#define FGPIOA                                   ((FGPIO_Type *)FGPIOA_BASE)
#define FGPIOA_BASE_PTR                          (FGPIOA)
/** Peripheral FGPIOB base address */
#define FGPIOB_BASE                              (0xF8000040u)
/** Peripheral FGPIOB base pointer */
#define FGPIOB                                   ((FGPIO_Type *)FGPIOB_BASE)
#define FGPIOB_BASE_PTR                          (FGPIOB)
/** Peripheral FGPIOC base address */
#define FGPIOC_BASE                              (0xF8000080u)
/** Peripheral FGPIOC base pointer */
#define FGPIOC                                   ((FGPIO_Type *)FGPIOC_BASE)
#define FGPIOC_BASE_PTR                          (FGPIOC)
/** Peripheral FGPIOD base address */
#define FGPIOD_BASE                              (0xF80000C0u)
/** Peripheral FGPIOD base pointer */
#define FGPIOD                                   ((FGPIO_Type *)FGPIOD_BASE)
#define FGPIOD_BASE_PTR                          (FGPIOD)
/** Peripheral FGPIOE base address */
#define FGPIOE_BASE                              (0xF8000100u)
/** Peripheral FGPIOE base pointer */
#define FGPIOE                                   ((FGPIO_Type *)FGPIOE_BASE)
#define FGPIOE_BASE_PTR                          (FGPIOE)
/** Array initializer of FGPIO peripheral base addresses */
#define FGPIO_BASE_ADDRS                         { FGPIOA_BASE, FGPIOB_BASE, FGPIOC_BASE, FGPIOD_BASE, FGPIOE_BASE }
/** Array initializer of FGPIO peripheral base pointers */
#define FGPIO_BASE_PTRS                          { FGPIOA, FGPIOB, FGPIOC, FGPIOD, FGPIOE }

/* ----------------------------------------------------------------------------
   -- FGPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FGPIO_Register_Accessor_Macros FGPIO - Register accessor macros
 * @{
 */


/* FGPIO - Register instance definitions */
/* FGPIOA */
#define FGPIOA_PDOR                              FGPIO_PDOR_REG(FGPIOA)
#define FGPIOA_PSOR                              FGPIO_PSOR_REG(FGPIOA)
#define FGPIOA_PCOR                              FGPIO_PCOR_REG(FGPIOA)
#define FGPIOA_PTOR                              FGPIO_PTOR_REG(FGPIOA)
#define FGPIOA_PDIR                              FGPIO_PDIR_REG(FGPIOA)
#define FGPIOA_PDDR                              FGPIO_PDDR_REG(FGPIOA)
/* FGPIOB */
#define FGPIOB_PDOR                              FGPIO_PDOR_REG(FGPIOB)
#define FGPIOB_PSOR                              FGPIO_PSOR_REG(FGPIOB)
#define FGPIOB_PCOR                              FGPIO_PCOR_REG(FGPIOB)
#define FGPIOB_PTOR                              FGPIO_PTOR_REG(FGPIOB)
#define FGPIOB_PDIR                              FGPIO_PDIR_REG(FGPIOB)
#define FGPIOB_PDDR                              FGPIO_PDDR_REG(FGPIOB)
/* FGPIOC */
#define FGPIOC_PDOR                              FGPIO_PDOR_REG(FGPIOC)
#define FGPIOC_PSOR                              FGPIO_PSOR_REG(FGPIOC)
#define FGPIOC_PCOR                              FGPIO_PCOR_REG(FGPIOC)
#define FGPIOC_PTOR                              FGPIO_PTOR_REG(FGPIOC)
#define FGPIOC_PDIR                              FGPIO_PDIR_REG(FGPIOC)
#define FGPIOC_PDDR                              FGPIO_PDDR_REG(FGPIOC)
/* FGPIOD */
#define FGPIOD_PDOR                              FGPIO_PDOR_REG(FGPIOD)
#define FGPIOD_PSOR                              FGPIO_PSOR_REG(FGPIOD)
#define FGPIOD_PCOR                              FGPIO_PCOR_REG(FGPIOD)
#define FGPIOD_PTOR                              FGPIO_PTOR_REG(FGPIOD)
#define FGPIOD_PDIR                              FGPIO_PDIR_REG(FGPIOD)
#define FGPIOD_PDDR                              FGPIO_PDDR_REG(FGPIOD)
/* FGPIOE */
#define FGPIOE_PDOR                              FGPIO_PDOR_REG(FGPIOE)
#define FGPIOE_PSOR                              FGPIO_PSOR_REG(FGPIOE)
#define FGPIOE_PCOR                              FGPIO_PCOR_REG(FGPIOE)
#define FGPIOE_PTOR                              FGPIO_PTOR_REG(FGPIOE)
#define FGPIOE_PDIR                              FGPIO_PDIR_REG(FGPIOE)
#define FGPIOE_PDDR                              FGPIO_PDDR_REG(FGPIOE)

/*!
 * @}
 */ /* end of group FGPIO_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group FGPIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Peripheral_Access_Layer FLEXIO Peripheral Access Layer
 * @{
 */

/** FLEXIO - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
  __IO uint32_t CTRL;                              /**< FlexIO Control Register, offset: 0x8 */
  __I  uint32_t PIN;                               /**< Pin State Register, offset: 0xC */
  __IO uint32_t SHIFTSTAT;                         /**< Shifter Status Register, offset: 0x10 */
  __IO uint32_t SHIFTERR;                          /**< Shifter Error Register, offset: 0x14 */
  __IO uint32_t TIMSTAT;                           /**< Timer Status Register, offset: 0x18 */
       uint8_t RESERVED_0[4];
  __IO uint32_t SHIFTSIEN;                         /**< Shifter Status Interrupt Enable, offset: 0x20 */
  __IO uint32_t SHIFTEIEN;                         /**< Shifter Error Interrupt Enable, offset: 0x24 */
  __IO uint32_t TIMIEN;                            /**< Timer Interrupt Enable Register, offset: 0x28 */
       uint8_t RESERVED_1[4];
  __IO uint32_t SHIFTSDEN;                         /**< Shifter Status DMA Enable, offset: 0x30 */
       uint8_t RESERVED_2[12];
  __IO uint32_t SHIFTSTATE;                        /**< Shifter State Register, offset: 0x40 */
       uint8_t RESERVED_3[60];
  __IO uint32_t SHIFTCTL[8];                       /**< Shifter Control N Register, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_4[96];
  __IO uint32_t SHIFTCFG[8];                       /**< Shifter Configuration N Register, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_5[224];
  __IO uint32_t SHIFTBUF[8];                       /**< Shifter Buffer N Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_6[96];
  __IO uint32_t SHIFTBUFBIS[8];                    /**< Shifter Buffer N Bit Swapped Register, array offset: 0x280, array step: 0x4 */
       uint8_t RESERVED_7[96];
  __IO uint32_t SHIFTBUFBYS[8];                    /**< Shifter Buffer N Byte Swapped Register, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_8[96];
  __IO uint32_t SHIFTBUFBBS[8];                    /**< Shifter Buffer N Bit Byte Swapped Register, array offset: 0x380, array step: 0x4 */
       uint8_t RESERVED_9[96];
  __IO uint32_t TIMCTL[8];                         /**< Timer Control N Register, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_10[96];
  __IO uint32_t TIMCFG[8];                         /**< Timer Configuration N Register, array offset: 0x480, array step: 0x4 */
       uint8_t RESERVED_11[96];
  __IO uint32_t TIMCMP[8];                         /**< Timer Compare N Register, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_12[352];
  __IO uint32_t SHIFTBUFNBS[8];                    /**< Shifter Buffer N Nibble Byte Swapped Register, array offset: 0x680, array step: 0x4 */
       uint8_t RESERVED_13[96];
  __IO uint32_t SHIFTBUFHWS[8];                    /**< Shifter Buffer N Half Word Swapped Register, array offset: 0x700, array step: 0x4 */
       uint8_t RESERVED_14[96];
  __IO uint32_t SHIFTBUFNIS[8];                    /**< Shifter Buffer N Nibble Swapped Register, array offset: 0x780, array step: 0x4 */
} FLEXIO_Type, *FLEXIO_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- FLEXIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Register_Accessor_Macros FLEXIO - Register accessor macros
 * @{
 */


/* FLEXIO - Register accessors */
#define FLEXIO_VERID_REG(base)                   ((base)->VERID)
#define FLEXIO_PARAM_REG(base)                   ((base)->PARAM)
#define FLEXIO_CTRL_REG(base)                    ((base)->CTRL)
#define FLEXIO_PIN_REG(base)                     ((base)->PIN)
#define FLEXIO_SHIFTSTAT_REG(base)               ((base)->SHIFTSTAT)
#define FLEXIO_SHIFTERR_REG(base)                ((base)->SHIFTERR)
#define FLEXIO_TIMSTAT_REG(base)                 ((base)->TIMSTAT)
#define FLEXIO_SHIFTSIEN_REG(base)               ((base)->SHIFTSIEN)
#define FLEXIO_SHIFTEIEN_REG(base)               ((base)->SHIFTEIEN)
#define FLEXIO_TIMIEN_REG(base)                  ((base)->TIMIEN)
#define FLEXIO_SHIFTSDEN_REG(base)               ((base)->SHIFTSDEN)
#define FLEXIO_SHIFTSTATE_REG(base)              ((base)->SHIFTSTATE)
#define FLEXIO_SHIFTCTL_REG(base,index)          ((base)->SHIFTCTL[index])
#define FLEXIO_SHIFTCTL_COUNT                    8
#define FLEXIO_SHIFTCFG_REG(base,index)          ((base)->SHIFTCFG[index])
#define FLEXIO_SHIFTCFG_COUNT                    8
#define FLEXIO_SHIFTBUF_REG(base,index)          ((base)->SHIFTBUF[index])
#define FLEXIO_SHIFTBUF_COUNT                    8
#define FLEXIO_SHIFTBUFBIS_REG(base,index)       ((base)->SHIFTBUFBIS[index])
#define FLEXIO_SHIFTBUFBIS_COUNT                 8
#define FLEXIO_SHIFTBUFBYS_REG(base,index)       ((base)->SHIFTBUFBYS[index])
#define FLEXIO_SHIFTBUFBYS_COUNT                 8
#define FLEXIO_SHIFTBUFBBS_REG(base,index)       ((base)->SHIFTBUFBBS[index])
#define FLEXIO_SHIFTBUFBBS_COUNT                 8
#define FLEXIO_TIMCTL_REG(base,index)            ((base)->TIMCTL[index])
#define FLEXIO_TIMCTL_COUNT                      8
#define FLEXIO_TIMCFG_REG(base,index)            ((base)->TIMCFG[index])
#define FLEXIO_TIMCFG_COUNT                      8
#define FLEXIO_TIMCMP_REG(base,index)            ((base)->TIMCMP[index])
#define FLEXIO_TIMCMP_COUNT                      8
#define FLEXIO_SHIFTBUFNBS_REG(base,index)       ((base)->SHIFTBUFNBS[index])
#define FLEXIO_SHIFTBUFNBS_COUNT                 8
#define FLEXIO_SHIFTBUFHWS_REG(base,index)       ((base)->SHIFTBUFHWS[index])
#define FLEXIO_SHIFTBUFHWS_COUNT                 8
#define FLEXIO_SHIFTBUFNIS_REG(base,index)       ((base)->SHIFTBUFNIS[index])
#define FLEXIO_SHIFTBUFNIS_COUNT                 8

/*!
 * @}
 */ /* end of group FLEXIO_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- FLEXIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Register_Masks FLEXIO Register Masks
 * @{
 */

/* VERID Bit Fields */
#define FLEXIO_VERID_FEATURE_MASK                0xFFFFu
#define FLEXIO_VERID_FEATURE_SHIFT               0
#define FLEXIO_VERID_FEATURE_WIDTH               16
#define FLEXIO_VERID_FEATURE(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_VERID_FEATURE_SHIFT))&FLEXIO_VERID_FEATURE_MASK)
#define FLEXIO_VERID_MINOR_MASK                  0xFF0000u
#define FLEXIO_VERID_MINOR_SHIFT                 16
#define FLEXIO_VERID_MINOR_WIDTH                 8
#define FLEXIO_VERID_MINOR(x)                    (((uint32_t)(((uint32_t)(x))<<FLEXIO_VERID_MINOR_SHIFT))&FLEXIO_VERID_MINOR_MASK)
#define FLEXIO_VERID_MAJOR_MASK                  0xFF000000u
#define FLEXIO_VERID_MAJOR_SHIFT                 24
#define FLEXIO_VERID_MAJOR_WIDTH                 8
#define FLEXIO_VERID_MAJOR(x)                    (((uint32_t)(((uint32_t)(x))<<FLEXIO_VERID_MAJOR_SHIFT))&FLEXIO_VERID_MAJOR_MASK)
/* PARAM Bit Fields */
#define FLEXIO_PARAM_SHIFTER_MASK                0xFFu
#define FLEXIO_PARAM_SHIFTER_SHIFT               0
#define FLEXIO_PARAM_SHIFTER_WIDTH               8
#define FLEXIO_PARAM_SHIFTER(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_PARAM_SHIFTER_SHIFT))&FLEXIO_PARAM_SHIFTER_MASK)
#define FLEXIO_PARAM_TIMER_MASK                  0xFF00u
#define FLEXIO_PARAM_TIMER_SHIFT                 8
#define FLEXIO_PARAM_TIMER_WIDTH                 8
#define FLEXIO_PARAM_TIMER(x)                    (((uint32_t)(((uint32_t)(x))<<FLEXIO_PARAM_TIMER_SHIFT))&FLEXIO_PARAM_TIMER_MASK)
#define FLEXIO_PARAM_PIN_MASK                    0xFF0000u
#define FLEXIO_PARAM_PIN_SHIFT                   16
#define FLEXIO_PARAM_PIN_WIDTH                   8
#define FLEXIO_PARAM_PIN(x)                      (((uint32_t)(((uint32_t)(x))<<FLEXIO_PARAM_PIN_SHIFT))&FLEXIO_PARAM_PIN_MASK)
#define FLEXIO_PARAM_TRIGGER_MASK                0xFF000000u
#define FLEXIO_PARAM_TRIGGER_SHIFT               24
#define FLEXIO_PARAM_TRIGGER_WIDTH               8
#define FLEXIO_PARAM_TRIGGER(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_PARAM_TRIGGER_SHIFT))&FLEXIO_PARAM_TRIGGER_MASK)
/* CTRL Bit Fields */
#define FLEXIO_CTRL_FLEXEN_MASK                  0x1u
#define FLEXIO_CTRL_FLEXEN_SHIFT                 0
#define FLEXIO_CTRL_FLEXEN_WIDTH                 1
#define FLEXIO_CTRL_FLEXEN(x)                    (((uint32_t)(((uint32_t)(x))<<FLEXIO_CTRL_FLEXEN_SHIFT))&FLEXIO_CTRL_FLEXEN_MASK)
#define FLEXIO_CTRL_SWRST_MASK                   0x2u
#define FLEXIO_CTRL_SWRST_SHIFT                  1
#define FLEXIO_CTRL_SWRST_WIDTH                  1
#define FLEXIO_CTRL_SWRST(x)                     (((uint32_t)(((uint32_t)(x))<<FLEXIO_CTRL_SWRST_SHIFT))&FLEXIO_CTRL_SWRST_MASK)
#define FLEXIO_CTRL_FASTACC_MASK                 0x4u
#define FLEXIO_CTRL_FASTACC_SHIFT                2
#define FLEXIO_CTRL_FASTACC_WIDTH                1
#define FLEXIO_CTRL_FASTACC(x)                   (((uint32_t)(((uint32_t)(x))<<FLEXIO_CTRL_FASTACC_SHIFT))&FLEXIO_CTRL_FASTACC_MASK)
#define FLEXIO_CTRL_DBGE_MASK                    0x40000000u
#define FLEXIO_CTRL_DBGE_SHIFT                   30
#define FLEXIO_CTRL_DBGE_WIDTH                   1
#define FLEXIO_CTRL_DBGE(x)                      (((uint32_t)(((uint32_t)(x))<<FLEXIO_CTRL_DBGE_SHIFT))&FLEXIO_CTRL_DBGE_MASK)
#define FLEXIO_CTRL_DOZEN_MASK                   0x80000000u
#define FLEXIO_CTRL_DOZEN_SHIFT                  31
#define FLEXIO_CTRL_DOZEN_WIDTH                  1
#define FLEXIO_CTRL_DOZEN(x)                     (((uint32_t)(((uint32_t)(x))<<FLEXIO_CTRL_DOZEN_SHIFT))&FLEXIO_CTRL_DOZEN_MASK)
/* PIN Bit Fields */
#define FLEXIO_PIN_PDI_MASK                      0xFFFFFFFFu
#define FLEXIO_PIN_PDI_SHIFT                     0
#define FLEXIO_PIN_PDI_WIDTH                     32
#define FLEXIO_PIN_PDI(x)                        (((uint32_t)(((uint32_t)(x))<<FLEXIO_PIN_PDI_SHIFT))&FLEXIO_PIN_PDI_MASK)
/* SHIFTSTAT Bit Fields */
#define FLEXIO_SHIFTSTAT_SSF_MASK                0xFFu
#define FLEXIO_SHIFTSTAT_SSF_SHIFT               0
#define FLEXIO_SHIFTSTAT_SSF_WIDTH               8
#define FLEXIO_SHIFTSTAT_SSF(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTSTAT_SSF_SHIFT))&FLEXIO_SHIFTSTAT_SSF_MASK)
/* SHIFTERR Bit Fields */
#define FLEXIO_SHIFTERR_SEF_MASK                 0xFFu
#define FLEXIO_SHIFTERR_SEF_SHIFT                0
#define FLEXIO_SHIFTERR_SEF_WIDTH                8
#define FLEXIO_SHIFTERR_SEF(x)                   (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTERR_SEF_SHIFT))&FLEXIO_SHIFTERR_SEF_MASK)
/* TIMSTAT Bit Fields */
#define FLEXIO_TIMSTAT_TSF_MASK                  0xFFu
#define FLEXIO_TIMSTAT_TSF_SHIFT                 0
#define FLEXIO_TIMSTAT_TSF_WIDTH                 8
#define FLEXIO_TIMSTAT_TSF(x)                    (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMSTAT_TSF_SHIFT))&FLEXIO_TIMSTAT_TSF_MASK)
/* SHIFTSIEN Bit Fields */
#define FLEXIO_SHIFTSIEN_SSIE_MASK               0xFFu
#define FLEXIO_SHIFTSIEN_SSIE_SHIFT              0
#define FLEXIO_SHIFTSIEN_SSIE_WIDTH              8
#define FLEXIO_SHIFTSIEN_SSIE(x)                 (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTSIEN_SSIE_SHIFT))&FLEXIO_SHIFTSIEN_SSIE_MASK)
/* SHIFTEIEN Bit Fields */
#define FLEXIO_SHIFTEIEN_SEIE_MASK               0xFFu
#define FLEXIO_SHIFTEIEN_SEIE_SHIFT              0
#define FLEXIO_SHIFTEIEN_SEIE_WIDTH              8
#define FLEXIO_SHIFTEIEN_SEIE(x)                 (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTEIEN_SEIE_SHIFT))&FLEXIO_SHIFTEIEN_SEIE_MASK)
/* TIMIEN Bit Fields */
#define FLEXIO_TIMIEN_TEIE_MASK                  0xFFu
#define FLEXIO_TIMIEN_TEIE_SHIFT                 0
#define FLEXIO_TIMIEN_TEIE_WIDTH                 8
#define FLEXIO_TIMIEN_TEIE(x)                    (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMIEN_TEIE_SHIFT))&FLEXIO_TIMIEN_TEIE_MASK)
/* SHIFTSDEN Bit Fields */
#define FLEXIO_SHIFTSDEN_SSDE_MASK               0xFFu
#define FLEXIO_SHIFTSDEN_SSDE_SHIFT              0
#define FLEXIO_SHIFTSDEN_SSDE_WIDTH              8
#define FLEXIO_SHIFTSDEN_SSDE(x)                 (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTSDEN_SSDE_SHIFT))&FLEXIO_SHIFTSDEN_SSDE_MASK)
/* SHIFTSTATE Bit Fields */
#define FLEXIO_SHIFTSTATE_STATE_MASK             0x7u
#define FLEXIO_SHIFTSTATE_STATE_SHIFT            0
#define FLEXIO_SHIFTSTATE_STATE_WIDTH            3
#define FLEXIO_SHIFTSTATE_STATE(x)               (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTSTATE_STATE_SHIFT))&FLEXIO_SHIFTSTATE_STATE_MASK)
/* SHIFTCTL Bit Fields */
#define FLEXIO_SHIFTCTL_SMOD_MASK                0x7u
#define FLEXIO_SHIFTCTL_SMOD_SHIFT               0
#define FLEXIO_SHIFTCTL_SMOD_WIDTH               3
#define FLEXIO_SHIFTCTL_SMOD(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTCTL_SMOD_SHIFT))&FLEXIO_SHIFTCTL_SMOD_MASK)
#define FLEXIO_SHIFTCTL_PINPOL_MASK              0x80u
#define FLEXIO_SHIFTCTL_PINPOL_SHIFT             7
#define FLEXIO_SHIFTCTL_PINPOL_WIDTH             1
#define FLEXIO_SHIFTCTL_PINPOL(x)                (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTCTL_PINPOL_SHIFT))&FLEXIO_SHIFTCTL_PINPOL_MASK)
#define FLEXIO_SHIFTCTL_PINSEL_MASK              0x1F00u
#define FLEXIO_SHIFTCTL_PINSEL_SHIFT             8
#define FLEXIO_SHIFTCTL_PINSEL_WIDTH             5
#define FLEXIO_SHIFTCTL_PINSEL(x)                (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTCTL_PINSEL_SHIFT))&FLEXIO_SHIFTCTL_PINSEL_MASK)
#define FLEXIO_SHIFTCTL_PINCFG_MASK              0x30000u
#define FLEXIO_SHIFTCTL_PINCFG_SHIFT             16
#define FLEXIO_SHIFTCTL_PINCFG_WIDTH             2
#define FLEXIO_SHIFTCTL_PINCFG(x)                (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTCTL_PINCFG_SHIFT))&FLEXIO_SHIFTCTL_PINCFG_MASK)
#define FLEXIO_SHIFTCTL_TIMPOL_MASK              0x800000u
#define FLEXIO_SHIFTCTL_TIMPOL_SHIFT             23
#define FLEXIO_SHIFTCTL_TIMPOL_WIDTH             1
#define FLEXIO_SHIFTCTL_TIMPOL(x)                (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTCTL_TIMPOL_SHIFT))&FLEXIO_SHIFTCTL_TIMPOL_MASK)
#define FLEXIO_SHIFTCTL_TIMSEL_MASK              0x7000000u
#define FLEXIO_SHIFTCTL_TIMSEL_SHIFT             24
#define FLEXIO_SHIFTCTL_TIMSEL_WIDTH             3
#define FLEXIO_SHIFTCTL_TIMSEL(x)                (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTCTL_TIMSEL_SHIFT))&FLEXIO_SHIFTCTL_TIMSEL_MASK)
/* SHIFTCFG Bit Fields */
#define FLEXIO_SHIFTCFG_SSTART_MASK              0x3u
#define FLEXIO_SHIFTCFG_SSTART_SHIFT             0
#define FLEXIO_SHIFTCFG_SSTART_WIDTH             2
#define FLEXIO_SHIFTCFG_SSTART(x)                (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTCFG_SSTART_SHIFT))&FLEXIO_SHIFTCFG_SSTART_MASK)
#define FLEXIO_SHIFTCFG_SSTOP_MASK               0x30u
#define FLEXIO_SHIFTCFG_SSTOP_SHIFT              4
#define FLEXIO_SHIFTCFG_SSTOP_WIDTH              2
#define FLEXIO_SHIFTCFG_SSTOP(x)                 (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTCFG_SSTOP_SHIFT))&FLEXIO_SHIFTCFG_SSTOP_MASK)
#define FLEXIO_SHIFTCFG_INSRC_MASK               0x100u
#define FLEXIO_SHIFTCFG_INSRC_SHIFT              8
#define FLEXIO_SHIFTCFG_INSRC_WIDTH              1
#define FLEXIO_SHIFTCFG_INSRC(x)                 (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTCFG_INSRC_SHIFT))&FLEXIO_SHIFTCFG_INSRC_MASK)
#define FLEXIO_SHIFTCFG_PWIDTH_MASK              0x1F0000u
#define FLEXIO_SHIFTCFG_PWIDTH_SHIFT             16
#define FLEXIO_SHIFTCFG_PWIDTH_WIDTH             5
#define FLEXIO_SHIFTCFG_PWIDTH(x)                (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTCFG_PWIDTH_SHIFT))&FLEXIO_SHIFTCFG_PWIDTH_MASK)
/* SHIFTBUF Bit Fields */
#define FLEXIO_SHIFTBUF_SHIFTBUF_MASK            0xFFFFFFFFu
#define FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT           0
#define FLEXIO_SHIFTBUF_SHIFTBUF_WIDTH           32
#define FLEXIO_SHIFTBUF_SHIFTBUF(x)              (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT))&FLEXIO_SHIFTBUF_SHIFTBUF_MASK)
/* SHIFTBUFBIS Bit Fields */
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK      0xFFFFFFFFu
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT     0
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_WIDTH     32
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS(x)        (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT))&FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK)
/* SHIFTBUFBYS Bit Fields */
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK      0xFFFFFFFFu
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT     0
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_WIDTH     32
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS(x)        (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT))&FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK)
/* SHIFTBUFBBS Bit Fields */
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK      0xFFFFFFFFu
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT     0
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_WIDTH     32
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS(x)        (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT))&FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK)
/* TIMCTL Bit Fields */
#define FLEXIO_TIMCTL_TIMOD_MASK                 0x3u
#define FLEXIO_TIMCTL_TIMOD_SHIFT                0
#define FLEXIO_TIMCTL_TIMOD_WIDTH                2
#define FLEXIO_TIMCTL_TIMOD(x)                   (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCTL_TIMOD_SHIFT))&FLEXIO_TIMCTL_TIMOD_MASK)
#define FLEXIO_TIMCTL_PINPOL_MASK                0x80u
#define FLEXIO_TIMCTL_PINPOL_SHIFT               7
#define FLEXIO_TIMCTL_PINPOL_WIDTH               1
#define FLEXIO_TIMCTL_PINPOL(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCTL_PINPOL_SHIFT))&FLEXIO_TIMCTL_PINPOL_MASK)
#define FLEXIO_TIMCTL_PINSEL_MASK                0x1F00u
#define FLEXIO_TIMCTL_PINSEL_SHIFT               8
#define FLEXIO_TIMCTL_PINSEL_WIDTH               5
#define FLEXIO_TIMCTL_PINSEL(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCTL_PINSEL_SHIFT))&FLEXIO_TIMCTL_PINSEL_MASK)
#define FLEXIO_TIMCTL_PINCFG_MASK                0x30000u
#define FLEXIO_TIMCTL_PINCFG_SHIFT               16
#define FLEXIO_TIMCTL_PINCFG_WIDTH               2
#define FLEXIO_TIMCTL_PINCFG(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCTL_PINCFG_SHIFT))&FLEXIO_TIMCTL_PINCFG_MASK)
#define FLEXIO_TIMCTL_TRGSRC_MASK                0x400000u
#define FLEXIO_TIMCTL_TRGSRC_SHIFT               22
#define FLEXIO_TIMCTL_TRGSRC_WIDTH               1
#define FLEXIO_TIMCTL_TRGSRC(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCTL_TRGSRC_SHIFT))&FLEXIO_TIMCTL_TRGSRC_MASK)
#define FLEXIO_TIMCTL_TRGPOL_MASK                0x800000u
#define FLEXIO_TIMCTL_TRGPOL_SHIFT               23
#define FLEXIO_TIMCTL_TRGPOL_WIDTH               1
#define FLEXIO_TIMCTL_TRGPOL(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCTL_TRGPOL_SHIFT))&FLEXIO_TIMCTL_TRGPOL_MASK)
#define FLEXIO_TIMCTL_TRGSEL_MASK                0x3F000000u
#define FLEXIO_TIMCTL_TRGSEL_SHIFT               24
#define FLEXIO_TIMCTL_TRGSEL_WIDTH               6
#define FLEXIO_TIMCTL_TRGSEL(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCTL_TRGSEL_SHIFT))&FLEXIO_TIMCTL_TRGSEL_MASK)
/* TIMCFG Bit Fields */
#define FLEXIO_TIMCFG_TSTART_MASK                0x2u
#define FLEXIO_TIMCFG_TSTART_SHIFT               1
#define FLEXIO_TIMCFG_TSTART_WIDTH               1
#define FLEXIO_TIMCFG_TSTART(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCFG_TSTART_SHIFT))&FLEXIO_TIMCFG_TSTART_MASK)
#define FLEXIO_TIMCFG_TSTOP_MASK                 0x30u
#define FLEXIO_TIMCFG_TSTOP_SHIFT                4
#define FLEXIO_TIMCFG_TSTOP_WIDTH                2
#define FLEXIO_TIMCFG_TSTOP(x)                   (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCFG_TSTOP_SHIFT))&FLEXIO_TIMCFG_TSTOP_MASK)
#define FLEXIO_TIMCFG_TIMENA_MASK                0x700u
#define FLEXIO_TIMCFG_TIMENA_SHIFT               8
#define FLEXIO_TIMCFG_TIMENA_WIDTH               3
#define FLEXIO_TIMCFG_TIMENA(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCFG_TIMENA_SHIFT))&FLEXIO_TIMCFG_TIMENA_MASK)
#define FLEXIO_TIMCFG_TIMDIS_MASK                0x7000u
#define FLEXIO_TIMCFG_TIMDIS_SHIFT               12
#define FLEXIO_TIMCFG_TIMDIS_WIDTH               3
#define FLEXIO_TIMCFG_TIMDIS(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCFG_TIMDIS_SHIFT))&FLEXIO_TIMCFG_TIMDIS_MASK)
#define FLEXIO_TIMCFG_TIMRST_MASK                0x70000u
#define FLEXIO_TIMCFG_TIMRST_SHIFT               16
#define FLEXIO_TIMCFG_TIMRST_WIDTH               3
#define FLEXIO_TIMCFG_TIMRST(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCFG_TIMRST_SHIFT))&FLEXIO_TIMCFG_TIMRST_MASK)
#define FLEXIO_TIMCFG_TIMDEC_MASK                0x300000u
#define FLEXIO_TIMCFG_TIMDEC_SHIFT               20
#define FLEXIO_TIMCFG_TIMDEC_WIDTH               2
#define FLEXIO_TIMCFG_TIMDEC(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCFG_TIMDEC_SHIFT))&FLEXIO_TIMCFG_TIMDEC_MASK)
#define FLEXIO_TIMCFG_TIMOUT_MASK                0x3000000u
#define FLEXIO_TIMCFG_TIMOUT_SHIFT               24
#define FLEXIO_TIMCFG_TIMOUT_WIDTH               2
#define FLEXIO_TIMCFG_TIMOUT(x)                  (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCFG_TIMOUT_SHIFT))&FLEXIO_TIMCFG_TIMOUT_MASK)
/* TIMCMP Bit Fields */
#define FLEXIO_TIMCMP_CMP_MASK                   0xFFFFu
#define FLEXIO_TIMCMP_CMP_SHIFT                  0
#define FLEXIO_TIMCMP_CMP_WIDTH                  16
#define FLEXIO_TIMCMP_CMP(x)                     (((uint32_t)(((uint32_t)(x))<<FLEXIO_TIMCMP_CMP_SHIFT))&FLEXIO_TIMCMP_CMP_MASK)
/* SHIFTBUFNBS Bit Fields */
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK      0xFFFFFFFFu
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT     0
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_WIDTH     32
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS(x)        (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT))&FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK)
/* SHIFTBUFHWS Bit Fields */
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK      0xFFFFFFFFu
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT     0
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_WIDTH     32
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS(x)        (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT))&FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK)
/* SHIFTBUFNIS Bit Fields */
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK      0xFFFFFFFFu
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT     0
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_WIDTH     32
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS(x)        (((uint32_t)(((uint32_t)(x))<<FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT))&FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK)

/*!
 * @}
 */ /* end of group FLEXIO_Register_Masks */


/* FLEXIO - Peripheral instance base addresses */
/** Peripheral FLEXIO0 base address */
#define FLEXIO0_BASE                             (0x4005F000u)
/** Peripheral FLEXIO0 base pointer */
#define FLEXIO0                                  ((FLEXIO_Type *)FLEXIO0_BASE)
#define FLEXIO0_BASE_PTR                         (FLEXIO0)
/** Array initializer of FLEXIO peripheral base addresses */
#define FLEXIO_BASE_ADDRS                        { FLEXIO0_BASE }
/** Array initializer of FLEXIO peripheral base pointers */
#define FLEXIO_BASE_PTRS                         { FLEXIO0 }

/* ----------------------------------------------------------------------------
   -- FLEXIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Register_Accessor_Macros FLEXIO - Register accessor macros
 * @{
 */


/* FLEXIO - Register instance definitions */
/* FLEXIO0 */
#define FLEXIO0_VERID                            FLEXIO_VERID_REG(FLEXIO0)
#define FLEXIO0_PARAM                            FLEXIO_PARAM_REG(FLEXIO0)
#define FLEXIO0_CTRL                             FLEXIO_CTRL_REG(FLEXIO0)
#define FLEXIO0_PIN                              FLEXIO_PIN_REG(FLEXIO0)
#define FLEXIO0_SHIFTSTAT                        FLEXIO_SHIFTSTAT_REG(FLEXIO0)
#define FLEXIO0_SHIFTERR                         FLEXIO_SHIFTERR_REG(FLEXIO0)
#define FLEXIO0_TIMSTAT                          FLEXIO_TIMSTAT_REG(FLEXIO0)
#define FLEXIO0_SHIFTSIEN                        FLEXIO_SHIFTSIEN_REG(FLEXIO0)
#define FLEXIO0_SHIFTEIEN                        FLEXIO_SHIFTEIEN_REG(FLEXIO0)
#define FLEXIO0_TIMIEN                           FLEXIO_TIMIEN_REG(FLEXIO0)
#define FLEXIO0_SHIFTSDEN                        FLEXIO_SHIFTSDEN_REG(FLEXIO0)
#define FLEXIO0_SHIFTSTATE                       FLEXIO_SHIFTSTATE_REG(FLEXIO0)
#define FLEXIO0_SHIFTCTL0                        FLEXIO_SHIFTCTL_REG(FLEXIO0,0)
#define FLEXIO0_SHIFTCTL1                        FLEXIO_SHIFTCTL_REG(FLEXIO0,1)
#define FLEXIO0_SHIFTCTL2                        FLEXIO_SHIFTCTL_REG(FLEXIO0,2)
#define FLEXIO0_SHIFTCTL3                        FLEXIO_SHIFTCTL_REG(FLEXIO0,3)
#define FLEXIO0_SHIFTCTL4                        FLEXIO_SHIFTCTL_REG(FLEXIO0,4)
#define FLEXIO0_SHIFTCTL5                        FLEXIO_SHIFTCTL_REG(FLEXIO0,5)
#define FLEXIO0_SHIFTCTL6                        FLEXIO_SHIFTCTL_REG(FLEXIO0,6)
#define FLEXIO0_SHIFTCTL7                        FLEXIO_SHIFTCTL_REG(FLEXIO0,7)
#define FLEXIO0_SHIFTCFG0                        FLEXIO_SHIFTCFG_REG(FLEXIO0,0)
#define FLEXIO0_SHIFTCFG1                        FLEXIO_SHIFTCFG_REG(FLEXIO0,1)
#define FLEXIO0_SHIFTCFG2                        FLEXIO_SHIFTCFG_REG(FLEXIO0,2)
#define FLEXIO0_SHIFTCFG3                        FLEXIO_SHIFTCFG_REG(FLEXIO0,3)
#define FLEXIO0_SHIFTCFG4                        FLEXIO_SHIFTCFG_REG(FLEXIO0,4)
#define FLEXIO0_SHIFTCFG5                        FLEXIO_SHIFTCFG_REG(FLEXIO0,5)
#define FLEXIO0_SHIFTCFG6                        FLEXIO_SHIFTCFG_REG(FLEXIO0,6)
#define FLEXIO0_SHIFTCFG7                        FLEXIO_SHIFTCFG_REG(FLEXIO0,7)
#define FLEXIO0_SHIFTBUF0                        FLEXIO_SHIFTBUF_REG(FLEXIO0,0)
#define FLEXIO0_SHIFTBUF1                        FLEXIO_SHIFTBUF_REG(FLEXIO0,1)
#define FLEXIO0_SHIFTBUF2                        FLEXIO_SHIFTBUF_REG(FLEXIO0,2)
#define FLEXIO0_SHIFTBUF3                        FLEXIO_SHIFTBUF_REG(FLEXIO0,3)
#define FLEXIO0_SHIFTBUF4                        FLEXIO_SHIFTBUF_REG(FLEXIO0,4)
#define FLEXIO0_SHIFTBUF5                        FLEXIO_SHIFTBUF_REG(FLEXIO0,5)
#define FLEXIO0_SHIFTBUF6                        FLEXIO_SHIFTBUF_REG(FLEXIO0,6)
#define FLEXIO0_SHIFTBUF7                        FLEXIO_SHIFTBUF_REG(FLEXIO0,7)
#define FLEXIO0_SHIFTBUFBIS0                     FLEXIO_SHIFTBUFBIS_REG(FLEXIO0,0)
#define FLEXIO0_SHIFTBUFBIS1                     FLEXIO_SHIFTBUFBIS_REG(FLEXIO0,1)
#define FLEXIO0_SHIFTBUFBIS2                     FLEXIO_SHIFTBUFBIS_REG(FLEXIO0,2)
#define FLEXIO0_SHIFTBUFBIS3                     FLEXIO_SHIFTBUFBIS_REG(FLEXIO0,3)
#define FLEXIO0_SHIFTBUFBIS4                     FLEXIO_SHIFTBUFBIS_REG(FLEXIO0,4)
#define FLEXIO0_SHIFTBUFBIS5                     FLEXIO_SHIFTBUFBIS_REG(FLEXIO0,5)
#define FLEXIO0_SHIFTBUFBIS6                     FLEXIO_SHIFTBUFBIS_REG(FLEXIO0,6)
#define FLEXIO0_SHIFTBUFBIS7                     FLEXIO_SHIFTBUFBIS_REG(FLEXIO0,7)
#define FLEXIO0_SHIFTBUFBYS0                     FLEXIO_SHIFTBUFBYS_REG(FLEXIO0,0)
#define FLEXIO0_SHIFTBUFBYS1                     FLEXIO_SHIFTBUFBYS_REG(FLEXIO0,1)
#define FLEXIO0_SHIFTBUFBYS2                     FLEXIO_SHIFTBUFBYS_REG(FLEXIO0,2)
#define FLEXIO0_SHIFTBUFBYS3                     FLEXIO_SHIFTBUFBYS_REG(FLEXIO0,3)
#define FLEXIO0_SHIFTBUFBYS4                     FLEXIO_SHIFTBUFBYS_REG(FLEXIO0,4)
#define FLEXIO0_SHIFTBUFBYS5                     FLEXIO_SHIFTBUFBYS_REG(FLEXIO0,5)
#define FLEXIO0_SHIFTBUFBYS6                     FLEXIO_SHIFTBUFBYS_REG(FLEXIO0,6)
#define FLEXIO0_SHIFTBUFBYS7                     FLEXIO_SHIFTBUFBYS_REG(FLEXIO0,7)
#define FLEXIO0_SHIFTBUFBBS0                     FLEXIO_SHIFTBUFBBS_REG(FLEXIO0,0)
#define FLEXIO0_SHIFTBUFBBS1                     FLEXIO_SHIFTBUFBBS_REG(FLEXIO0,1)
#define FLEXIO0_SHIFTBUFBBS2                     FLEXIO_SHIFTBUFBBS_REG(FLEXIO0,2)
#define FLEXIO0_SHIFTBUFBBS3                     FLEXIO_SHIFTBUFBBS_REG(FLEXIO0,3)
#define FLEXIO0_SHIFTBUFBBS4                     FLEXIO_SHIFTBUFBBS_REG(FLEXIO0,4)
#define FLEXIO0_SHIFTBUFBBS5                     FLEXIO_SHIFTBUFBBS_REG(FLEXIO0,5)
#define FLEXIO0_SHIFTBUFBBS6                     FLEXIO_SHIFTBUFBBS_REG(FLEXIO0,6)
#define FLEXIO0_SHIFTBUFBBS7                     FLEXIO_SHIFTBUFBBS_REG(FLEXIO0,7)
#define FLEXIO0_TIMCTL0                          FLEXIO_TIMCTL_REG(FLEXIO0,0)
#define FLEXIO0_TIMCTL1                          FLEXIO_TIMCTL_REG(FLEXIO0,1)
#define FLEXIO0_TIMCTL2                          FLEXIO_TIMCTL_REG(FLEXIO0,2)
#define FLEXIO0_TIMCTL3                          FLEXIO_TIMCTL_REG(FLEXIO0,3)
#define FLEXIO0_TIMCTL4                          FLEXIO_TIMCTL_REG(FLEXIO0,4)
#define FLEXIO0_TIMCTL5                          FLEXIO_TIMCTL_REG(FLEXIO0,5)
#define FLEXIO0_TIMCTL6                          FLEXIO_TIMCTL_REG(FLEXIO0,6)
#define FLEXIO0_TIMCTL7                          FLEXIO_TIMCTL_REG(FLEXIO0,7)
#define FLEXIO0_TIMCFG0                          FLEXIO_TIMCFG_REG(FLEXIO0,0)
#define FLEXIO0_TIMCFG1                          FLEXIO_TIMCFG_REG(FLEXIO0,1)
#define FLEXIO0_TIMCFG2                          FLEXIO_TIMCFG_REG(FLEXIO0,2)
#define FLEXIO0_TIMCFG3                          FLEXIO_TIMCFG_REG(FLEXIO0,3)
#define FLEXIO0_TIMCFG4                          FLEXIO_TIMCFG_REG(FLEXIO0,4)
#define FLEXIO0_TIMCFG5                          FLEXIO_TIMCFG_REG(FLEXIO0,5)
#define FLEXIO0_TIMCFG6                          FLEXIO_TIMCFG_REG(FLEXIO0,6)
#define FLEXIO0_TIMCFG7                          FLEXIO_TIMCFG_REG(FLEXIO0,7)
#define FLEXIO0_TIMCMP0                          FLEXIO_TIMCMP_REG(FLEXIO0,0)
#define FLEXIO0_TIMCMP1                          FLEXIO_TIMCMP_REG(FLEXIO0,1)
#define FLEXIO0_TIMCMP2                          FLEXIO_TIMCMP_REG(FLEXIO0,2)
#define FLEXIO0_TIMCMP3                          FLEXIO_TIMCMP_REG(FLEXIO0,3)
#define FLEXIO0_TIMCMP4                          FLEXIO_TIMCMP_REG(FLEXIO0,4)
#define FLEXIO0_TIMCMP5                          FLEXIO_TIMCMP_REG(FLEXIO0,5)
#define FLEXIO0_TIMCMP6                          FLEXIO_TIMCMP_REG(FLEXIO0,6)
#define FLEXIO0_TIMCMP7                          FLEXIO_TIMCMP_REG(FLEXIO0,7)
#define FLEXIO0_SHIFTBUFNBS0                     FLEXIO_SHIFTBUFNBS_REG(FLEXIO0,0)
#define FLEXIO0_SHIFTBUFNBS1                     FLEXIO_SHIFTBUFNBS_REG(FLEXIO0,1)
#define FLEXIO0_SHIFTBUFNBS2                     FLEXIO_SHIFTBUFNBS_REG(FLEXIO0,2)
#define FLEXIO0_SHIFTBUFNBS3                     FLEXIO_SHIFTBUFNBS_REG(FLEXIO0,3)
#define FLEXIO0_SHIFTBUFNBS4                     FLEXIO_SHIFTBUFNBS_REG(FLEXIO0,4)
#define FLEXIO0_SHIFTBUFNBS5                     FLEXIO_SHIFTBUFNBS_REG(FLEXIO0,5)
#define FLEXIO0_SHIFTBUFNBS6                     FLEXIO_SHIFTBUFNBS_REG(FLEXIO0,6)
#define FLEXIO0_SHIFTBUFNBS7                     FLEXIO_SHIFTBUFNBS_REG(FLEXIO0,7)
#define FLEXIO0_SHIFTBUFHWS0                     FLEXIO_SHIFTBUFHWS_REG(FLEXIO0,0)
#define FLEXIO0_SHIFTBUFHWS1                     FLEXIO_SHIFTBUFHWS_REG(FLEXIO0,1)
#define FLEXIO0_SHIFTBUFHWS2                     FLEXIO_SHIFTBUFHWS_REG(FLEXIO0,2)
#define FLEXIO0_SHIFTBUFHWS3                     FLEXIO_SHIFTBUFHWS_REG(FLEXIO0,3)
#define FLEXIO0_SHIFTBUFHWS4                     FLEXIO_SHIFTBUFHWS_REG(FLEXIO0,4)
#define FLEXIO0_SHIFTBUFHWS5                     FLEXIO_SHIFTBUFHWS_REG(FLEXIO0,5)
#define FLEXIO0_SHIFTBUFHWS6                     FLEXIO_SHIFTBUFHWS_REG(FLEXIO0,6)
#define FLEXIO0_SHIFTBUFHWS7                     FLEXIO_SHIFTBUFHWS_REG(FLEXIO0,7)
#define FLEXIO0_SHIFTBUFNIS0                     FLEXIO_SHIFTBUFNIS_REG(FLEXIO0,0)
#define FLEXIO0_SHIFTBUFNIS1                     FLEXIO_SHIFTBUFNIS_REG(FLEXIO0,1)
#define FLEXIO0_SHIFTBUFNIS2                     FLEXIO_SHIFTBUFNIS_REG(FLEXIO0,2)
#define FLEXIO0_SHIFTBUFNIS3                     FLEXIO_SHIFTBUFNIS_REG(FLEXIO0,3)
#define FLEXIO0_SHIFTBUFNIS4                     FLEXIO_SHIFTBUFNIS_REG(FLEXIO0,4)
#define FLEXIO0_SHIFTBUFNIS5                     FLEXIO_SHIFTBUFNIS_REG(FLEXIO0,5)
#define FLEXIO0_SHIFTBUFNIS6                     FLEXIO_SHIFTBUFNIS_REG(FLEXIO0,6)
#define FLEXIO0_SHIFTBUFNIS7                     FLEXIO_SHIFTBUFNIS_REG(FLEXIO0,7)

/* FLEXIO - Register array accessors */
#define FLEXIO0_SHIFTCTL(index)                  FLEXIO_SHIFTCTL_REG(FLEXIO0,index)
#define FLEXIO0_SHIFTCFG(index)                  FLEXIO_SHIFTCFG_REG(FLEXIO0,index)
#define FLEXIO0_SHIFTBUF(index)                  FLEXIO_SHIFTBUF_REG(FLEXIO0,index)
#define FLEXIO0_SHIFTBUFBIS(index)               FLEXIO_SHIFTBUFBIS_REG(FLEXIO0,index)
#define FLEXIO0_SHIFTBUFBYS(index)               FLEXIO_SHIFTBUFBYS_REG(FLEXIO0,index)
#define FLEXIO0_SHIFTBUFBBS(index)               FLEXIO_SHIFTBUFBBS_REG(FLEXIO0,index)
#define FLEXIO0_TIMCTL(index)                    FLEXIO_TIMCTL_REG(FLEXIO0,index)
#define FLEXIO0_TIMCFG(index)                    FLEXIO_TIMCFG_REG(FLEXIO0,index)
#define FLEXIO0_TIMCMP(index)                    FLEXIO_TIMCMP_REG(FLEXIO0,index)
#define FLEXIO0_SHIFTBUFNBS(index)               FLEXIO_SHIFTBUFNBS_REG(FLEXIO0,index)
#define FLEXIO0_SHIFTBUFHWS(index)               FLEXIO_SHIFTBUFHWS_REG(FLEXIO0,index)
#define FLEXIO0_SHIFTBUFNIS(index)               FLEXIO_SHIFTBUFNIS_REG(FLEXIO0,index)

/*!
 * @}
 */ /* end of group FLEXIO_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group FLEXIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FTFA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFA_Peripheral_Access_Layer FTFA Peripheral Access Layer
 * @{
 */

/** FTFA - Register Layout Typedef */
typedef struct {
  __IO uint8_t FSTAT;                              /**< Flash Status Register, offset: 0x0 */
  __IO uint8_t FCNFG;                              /**< Flash Configuration Register, offset: 0x1 */
  __I  uint8_t FSEC;                               /**< Flash Security Register, offset: 0x2 */
  __I  uint8_t FOPT;                               /**< Flash Option Register, offset: 0x3 */
  __IO uint8_t FCCOB3;                             /**< Flash Common Command Object Registers, offset: 0x4 */
  __IO uint8_t FCCOB2;                             /**< Flash Common Command Object Registers, offset: 0x5 */
  __IO uint8_t FCCOB1;                             /**< Flash Common Command Object Registers, offset: 0x6 */
  __IO uint8_t FCCOB0;                             /**< Flash Common Command Object Registers, offset: 0x7 */
  __IO uint8_t FCCOB7;                             /**< Flash Common Command Object Registers, offset: 0x8 */
  __IO uint8_t FCCOB6;                             /**< Flash Common Command Object Registers, offset: 0x9 */
  __IO uint8_t FCCOB5;                             /**< Flash Common Command Object Registers, offset: 0xA */
  __IO uint8_t FCCOB4;                             /**< Flash Common Command Object Registers, offset: 0xB */
  __IO uint8_t FCCOBB;                             /**< Flash Common Command Object Registers, offset: 0xC */
  __IO uint8_t FCCOBA;                             /**< Flash Common Command Object Registers, offset: 0xD */
  __IO uint8_t FCCOB9;                             /**< Flash Common Command Object Registers, offset: 0xE */
  __IO uint8_t FCCOB8;                             /**< Flash Common Command Object Registers, offset: 0xF */
  __IO uint8_t FPROT3;                             /**< Program Flash Protection Registers, offset: 0x10 */
  __IO uint8_t FPROT2;                             /**< Program Flash Protection Registers, offset: 0x11 */
  __IO uint8_t FPROT1;                             /**< Program Flash Protection Registers, offset: 0x12 */
  __IO uint8_t FPROT0;                             /**< Program Flash Protection Registers, offset: 0x13 */
       uint8_t RESERVED_0[4];
  __I  uint8_t XACCH3;                             /**< Execute-only Access Registers, offset: 0x18 */
  __I  uint8_t XACCH2;                             /**< Execute-only Access Registers, offset: 0x19 */
  __I  uint8_t XACCH1;                             /**< Execute-only Access Registers, offset: 0x1A */
  __I  uint8_t XACCH0;                             /**< Execute-only Access Registers, offset: 0x1B */
  __I  uint8_t XACCL3;                             /**< Execute-only Access Registers, offset: 0x1C */
  __I  uint8_t XACCL2;                             /**< Execute-only Access Registers, offset: 0x1D */
  __I  uint8_t XACCL1;                             /**< Execute-only Access Registers, offset: 0x1E */
  __I  uint8_t XACCL0;                             /**< Execute-only Access Registers, offset: 0x1F */
  __I  uint8_t SACCH3;                             /**< Supervisor-only Access Registers, offset: 0x20 */
  __I  uint8_t SACCH2;                             /**< Supervisor-only Access Registers, offset: 0x21 */
  __I  uint8_t SACCH1;                             /**< Supervisor-only Access Registers, offset: 0x22 */
  __I  uint8_t SACCH0;                             /**< Supervisor-only Access Registers, offset: 0x23 */
  __I  uint8_t SACCL3;                             /**< Supervisor-only Access Registers, offset: 0x24 */
  __I  uint8_t SACCL2;                             /**< Supervisor-only Access Registers, offset: 0x25 */
  __I  uint8_t SACCL1;                             /**< Supervisor-only Access Registers, offset: 0x26 */
  __I  uint8_t SACCL0;                             /**< Supervisor-only Access Registers, offset: 0x27 */
  __I  uint8_t FACSS;                              /**< Flash Access Segment Size Register, offset: 0x28 */
       uint8_t RESERVED_1[2];
  __I  uint8_t FACSN;                              /**< Flash Access Segment Number Register, offset: 0x2B */
} FTFA_Type, *FTFA_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- FTFA - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFA_Register_Accessor_Macros FTFA - Register accessor macros
 * @{
 */


/* FTFA - Register accessors */
#define FTFA_FSTAT_REG(base)                     ((base)->FSTAT)
#define FTFA_FCNFG_REG(base)                     ((base)->FCNFG)
#define FTFA_FSEC_REG(base)                      ((base)->FSEC)
#define FTFA_FOPT_REG(base)                      ((base)->FOPT)
#define FTFA_FCCOB3_REG(base)                    ((base)->FCCOB3)
#define FTFA_FCCOB2_REG(base)                    ((base)->FCCOB2)
#define FTFA_FCCOB1_REG(base)                    ((base)->FCCOB1)
#define FTFA_FCCOB0_REG(base)                    ((base)->FCCOB0)
#define FTFA_FCCOB7_REG(base)                    ((base)->FCCOB7)
#define FTFA_FCCOB6_REG(base)                    ((base)->FCCOB6)
#define FTFA_FCCOB5_REG(base)                    ((base)->FCCOB5)
#define FTFA_FCCOB4_REG(base)                    ((base)->FCCOB4)
#define FTFA_FCCOBB_REG(base)                    ((base)->FCCOBB)
#define FTFA_FCCOBA_REG(base)                    ((base)->FCCOBA)
#define FTFA_FCCOB9_REG(base)                    ((base)->FCCOB9)
#define FTFA_FCCOB8_REG(base)                    ((base)->FCCOB8)
#define FTFA_FPROT3_REG(base)                    ((base)->FPROT3)
#define FTFA_FPROT2_REG(base)                    ((base)->FPROT2)
#define FTFA_FPROT1_REG(base)                    ((base)->FPROT1)
#define FTFA_FPROT0_REG(base)                    ((base)->FPROT0)
#define FTFA_XACCH3_REG(base)                    ((base)->XACCH3)
#define FTFA_XACCH2_REG(base)                    ((base)->XACCH2)
#define FTFA_XACCH1_REG(base)                    ((base)->XACCH1)
#define FTFA_XACCH0_REG(base)                    ((base)->XACCH0)
#define FTFA_XACCL3_REG(base)                    ((base)->XACCL3)
#define FTFA_XACCL2_REG(base)                    ((base)->XACCL2)
#define FTFA_XACCL1_REG(base)                    ((base)->XACCL1)
#define FTFA_XACCL0_REG(base)                    ((base)->XACCL0)
#define FTFA_SACCH3_REG(base)                    ((base)->SACCH3)
#define FTFA_SACCH2_REG(base)                    ((base)->SACCH2)
#define FTFA_SACCH1_REG(base)                    ((base)->SACCH1)
#define FTFA_SACCH0_REG(base)                    ((base)->SACCH0)
#define FTFA_SACCL3_REG(base)                    ((base)->SACCL3)
#define FTFA_SACCL2_REG(base)                    ((base)->SACCL2)
#define FTFA_SACCL1_REG(base)                    ((base)->SACCL1)
#define FTFA_SACCL0_REG(base)                    ((base)->SACCL0)
#define FTFA_FACSS_REG(base)                     ((base)->FACSS)
#define FTFA_FACSN_REG(base)                     ((base)->FACSN)

/*!
 * @}
 */ /* end of group FTFA_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- FTFA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFA_Register_Masks FTFA Register Masks
 * @{
 */

/* FSTAT Bit Fields */
#define FTFA_FSTAT_MGSTAT0_MASK                  0x1u
#define FTFA_FSTAT_MGSTAT0_SHIFT                 0
#define FTFA_FSTAT_MGSTAT0_WIDTH                 1
#define FTFA_FSTAT_MGSTAT0(x)                    (((uint8_t)(((uint8_t)(x))<<FTFA_FSTAT_MGSTAT0_SHIFT))&FTFA_FSTAT_MGSTAT0_MASK)
#define FTFA_FSTAT_FPVIOL_MASK                   0x10u
#define FTFA_FSTAT_FPVIOL_SHIFT                  4
#define FTFA_FSTAT_FPVIOL_WIDTH                  1
#define FTFA_FSTAT_FPVIOL(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FSTAT_FPVIOL_SHIFT))&FTFA_FSTAT_FPVIOL_MASK)
#define FTFA_FSTAT_ACCERR_MASK                   0x20u
#define FTFA_FSTAT_ACCERR_SHIFT                  5
#define FTFA_FSTAT_ACCERR_WIDTH                  1
#define FTFA_FSTAT_ACCERR(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FSTAT_ACCERR_SHIFT))&FTFA_FSTAT_ACCERR_MASK)
#define FTFA_FSTAT_RDCOLERR_MASK                 0x40u
#define FTFA_FSTAT_RDCOLERR_SHIFT                6
#define FTFA_FSTAT_RDCOLERR_WIDTH                1
#define FTFA_FSTAT_RDCOLERR(x)                   (((uint8_t)(((uint8_t)(x))<<FTFA_FSTAT_RDCOLERR_SHIFT))&FTFA_FSTAT_RDCOLERR_MASK)
#define FTFA_FSTAT_CCIF_MASK                     0x80u
#define FTFA_FSTAT_CCIF_SHIFT                    7
#define FTFA_FSTAT_CCIF_WIDTH                    1
#define FTFA_FSTAT_CCIF(x)                       (((uint8_t)(((uint8_t)(x))<<FTFA_FSTAT_CCIF_SHIFT))&FTFA_FSTAT_CCIF_MASK)
/* FCNFG Bit Fields */
#define FTFA_FCNFG_ERSSUSP_MASK                  0x10u
#define FTFA_FCNFG_ERSSUSP_SHIFT                 4
#define FTFA_FCNFG_ERSSUSP_WIDTH                 1
#define FTFA_FCNFG_ERSSUSP(x)                    (((uint8_t)(((uint8_t)(x))<<FTFA_FCNFG_ERSSUSP_SHIFT))&FTFA_FCNFG_ERSSUSP_MASK)
#define FTFA_FCNFG_ERSAREQ_MASK                  0x20u
#define FTFA_FCNFG_ERSAREQ_SHIFT                 5
#define FTFA_FCNFG_ERSAREQ_WIDTH                 1
#define FTFA_FCNFG_ERSAREQ(x)                    (((uint8_t)(((uint8_t)(x))<<FTFA_FCNFG_ERSAREQ_SHIFT))&FTFA_FCNFG_ERSAREQ_MASK)
#define FTFA_FCNFG_RDCOLLIE_MASK                 0x40u
#define FTFA_FCNFG_RDCOLLIE_SHIFT                6
#define FTFA_FCNFG_RDCOLLIE_WIDTH                1
#define FTFA_FCNFG_RDCOLLIE(x)                   (((uint8_t)(((uint8_t)(x))<<FTFA_FCNFG_RDCOLLIE_SHIFT))&FTFA_FCNFG_RDCOLLIE_MASK)
#define FTFA_FCNFG_CCIE_MASK                     0x80u
#define FTFA_FCNFG_CCIE_SHIFT                    7
#define FTFA_FCNFG_CCIE_WIDTH                    1
#define FTFA_FCNFG_CCIE(x)                       (((uint8_t)(((uint8_t)(x))<<FTFA_FCNFG_CCIE_SHIFT))&FTFA_FCNFG_CCIE_MASK)
/* FSEC Bit Fields */
#define FTFA_FSEC_SEC_MASK                       0x3u
#define FTFA_FSEC_SEC_SHIFT                      0
#define FTFA_FSEC_SEC_WIDTH                      2
#define FTFA_FSEC_SEC(x)                         (((uint8_t)(((uint8_t)(x))<<FTFA_FSEC_SEC_SHIFT))&FTFA_FSEC_SEC_MASK)
#define FTFA_FSEC_FSLACC_MASK                    0xCu
#define FTFA_FSEC_FSLACC_SHIFT                   2
#define FTFA_FSEC_FSLACC_WIDTH                   2
#define FTFA_FSEC_FSLACC(x)                      (((uint8_t)(((uint8_t)(x))<<FTFA_FSEC_FSLACC_SHIFT))&FTFA_FSEC_FSLACC_MASK)
#define FTFA_FSEC_MEEN_MASK                      0x30u
#define FTFA_FSEC_MEEN_SHIFT                     4
#define FTFA_FSEC_MEEN_WIDTH                     2
#define FTFA_FSEC_MEEN(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_FSEC_MEEN_SHIFT))&FTFA_FSEC_MEEN_MASK)
#define FTFA_FSEC_KEYEN_MASK                     0xC0u
#define FTFA_FSEC_KEYEN_SHIFT                    6
#define FTFA_FSEC_KEYEN_WIDTH                    2
#define FTFA_FSEC_KEYEN(x)                       (((uint8_t)(((uint8_t)(x))<<FTFA_FSEC_KEYEN_SHIFT))&FTFA_FSEC_KEYEN_MASK)
/* FOPT Bit Fields */
#define FTFA_FOPT_OPT_MASK                       0xFFu
#define FTFA_FOPT_OPT_SHIFT                      0
#define FTFA_FOPT_OPT_WIDTH                      8
#define FTFA_FOPT_OPT(x)                         (((uint8_t)(((uint8_t)(x))<<FTFA_FOPT_OPT_SHIFT))&FTFA_FOPT_OPT_MASK)
/* FCCOB3 Bit Fields */
#define FTFA_FCCOB3_CCOBn_MASK                   0xFFu
#define FTFA_FCCOB3_CCOBn_SHIFT                  0
#define FTFA_FCCOB3_CCOBn_WIDTH                  8
#define FTFA_FCCOB3_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOB3_CCOBn_SHIFT))&FTFA_FCCOB3_CCOBn_MASK)
/* FCCOB2 Bit Fields */
#define FTFA_FCCOB2_CCOBn_MASK                   0xFFu
#define FTFA_FCCOB2_CCOBn_SHIFT                  0
#define FTFA_FCCOB2_CCOBn_WIDTH                  8
#define FTFA_FCCOB2_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOB2_CCOBn_SHIFT))&FTFA_FCCOB2_CCOBn_MASK)
/* FCCOB1 Bit Fields */
#define FTFA_FCCOB1_CCOBn_MASK                   0xFFu
#define FTFA_FCCOB1_CCOBn_SHIFT                  0
#define FTFA_FCCOB1_CCOBn_WIDTH                  8
#define FTFA_FCCOB1_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOB1_CCOBn_SHIFT))&FTFA_FCCOB1_CCOBn_MASK)
/* FCCOB0 Bit Fields */
#define FTFA_FCCOB0_CCOBn_MASK                   0xFFu
#define FTFA_FCCOB0_CCOBn_SHIFT                  0
#define FTFA_FCCOB0_CCOBn_WIDTH                  8
#define FTFA_FCCOB0_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOB0_CCOBn_SHIFT))&FTFA_FCCOB0_CCOBn_MASK)
/* FCCOB7 Bit Fields */
#define FTFA_FCCOB7_CCOBn_MASK                   0xFFu
#define FTFA_FCCOB7_CCOBn_SHIFT                  0
#define FTFA_FCCOB7_CCOBn_WIDTH                  8
#define FTFA_FCCOB7_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOB7_CCOBn_SHIFT))&FTFA_FCCOB7_CCOBn_MASK)
/* FCCOB6 Bit Fields */
#define FTFA_FCCOB6_CCOBn_MASK                   0xFFu
#define FTFA_FCCOB6_CCOBn_SHIFT                  0
#define FTFA_FCCOB6_CCOBn_WIDTH                  8
#define FTFA_FCCOB6_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOB6_CCOBn_SHIFT))&FTFA_FCCOB6_CCOBn_MASK)
/* FCCOB5 Bit Fields */
#define FTFA_FCCOB5_CCOBn_MASK                   0xFFu
#define FTFA_FCCOB5_CCOBn_SHIFT                  0
#define FTFA_FCCOB5_CCOBn_WIDTH                  8
#define FTFA_FCCOB5_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOB5_CCOBn_SHIFT))&FTFA_FCCOB5_CCOBn_MASK)
/* FCCOB4 Bit Fields */
#define FTFA_FCCOB4_CCOBn_MASK                   0xFFu
#define FTFA_FCCOB4_CCOBn_SHIFT                  0
#define FTFA_FCCOB4_CCOBn_WIDTH                  8
#define FTFA_FCCOB4_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOB4_CCOBn_SHIFT))&FTFA_FCCOB4_CCOBn_MASK)
/* FCCOBB Bit Fields */
#define FTFA_FCCOBB_CCOBn_MASK                   0xFFu
#define FTFA_FCCOBB_CCOBn_SHIFT                  0
#define FTFA_FCCOBB_CCOBn_WIDTH                  8
#define FTFA_FCCOBB_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOBB_CCOBn_SHIFT))&FTFA_FCCOBB_CCOBn_MASK)
/* FCCOBA Bit Fields */
#define FTFA_FCCOBA_CCOBn_MASK                   0xFFu
#define FTFA_FCCOBA_CCOBn_SHIFT                  0
#define FTFA_FCCOBA_CCOBn_WIDTH                  8
#define FTFA_FCCOBA_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOBA_CCOBn_SHIFT))&FTFA_FCCOBA_CCOBn_MASK)
/* FCCOB9 Bit Fields */
#define FTFA_FCCOB9_CCOBn_MASK                   0xFFu
#define FTFA_FCCOB9_CCOBn_SHIFT                  0
#define FTFA_FCCOB9_CCOBn_WIDTH                  8
#define FTFA_FCCOB9_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOB9_CCOBn_SHIFT))&FTFA_FCCOB9_CCOBn_MASK)
/* FCCOB8 Bit Fields */
#define FTFA_FCCOB8_CCOBn_MASK                   0xFFu
#define FTFA_FCCOB8_CCOBn_SHIFT                  0
#define FTFA_FCCOB8_CCOBn_WIDTH                  8
#define FTFA_FCCOB8_CCOBn(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FCCOB8_CCOBn_SHIFT))&FTFA_FCCOB8_CCOBn_MASK)
/* FPROT3 Bit Fields */
#define FTFA_FPROT3_PROT_MASK                    0xFFu
#define FTFA_FPROT3_PROT_SHIFT                   0
#define FTFA_FPROT3_PROT_WIDTH                   8
#define FTFA_FPROT3_PROT(x)                      (((uint8_t)(((uint8_t)(x))<<FTFA_FPROT3_PROT_SHIFT))&FTFA_FPROT3_PROT_MASK)
/* FPROT2 Bit Fields */
#define FTFA_FPROT2_PROT_MASK                    0xFFu
#define FTFA_FPROT2_PROT_SHIFT                   0
#define FTFA_FPROT2_PROT_WIDTH                   8
#define FTFA_FPROT2_PROT(x)                      (((uint8_t)(((uint8_t)(x))<<FTFA_FPROT2_PROT_SHIFT))&FTFA_FPROT2_PROT_MASK)
/* FPROT1 Bit Fields */
#define FTFA_FPROT1_PROT_MASK                    0xFFu
#define FTFA_FPROT1_PROT_SHIFT                   0
#define FTFA_FPROT1_PROT_WIDTH                   8
#define FTFA_FPROT1_PROT(x)                      (((uint8_t)(((uint8_t)(x))<<FTFA_FPROT1_PROT_SHIFT))&FTFA_FPROT1_PROT_MASK)
/* FPROT0 Bit Fields */
#define FTFA_FPROT0_PROT_MASK                    0xFFu
#define FTFA_FPROT0_PROT_SHIFT                   0
#define FTFA_FPROT0_PROT_WIDTH                   8
#define FTFA_FPROT0_PROT(x)                      (((uint8_t)(((uint8_t)(x))<<FTFA_FPROT0_PROT_SHIFT))&FTFA_FPROT0_PROT_MASK)
/* XACCH3 Bit Fields */
#define FTFA_XACCH3_XA_MASK                      0xFFu
#define FTFA_XACCH3_XA_SHIFT                     0
#define FTFA_XACCH3_XA_WIDTH                     8
#define FTFA_XACCH3_XA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_XACCH3_XA_SHIFT))&FTFA_XACCH3_XA_MASK)
/* XACCH2 Bit Fields */
#define FTFA_XACCH2_XA_MASK                      0xFFu
#define FTFA_XACCH2_XA_SHIFT                     0
#define FTFA_XACCH2_XA_WIDTH                     8
#define FTFA_XACCH2_XA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_XACCH2_XA_SHIFT))&FTFA_XACCH2_XA_MASK)
/* XACCH1 Bit Fields */
#define FTFA_XACCH1_XA_MASK                      0xFFu
#define FTFA_XACCH1_XA_SHIFT                     0
#define FTFA_XACCH1_XA_WIDTH                     8
#define FTFA_XACCH1_XA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_XACCH1_XA_SHIFT))&FTFA_XACCH1_XA_MASK)
/* XACCH0 Bit Fields */
#define FTFA_XACCH0_XA_MASK                      0xFFu
#define FTFA_XACCH0_XA_SHIFT                     0
#define FTFA_XACCH0_XA_WIDTH                     8
#define FTFA_XACCH0_XA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_XACCH0_XA_SHIFT))&FTFA_XACCH0_XA_MASK)
/* XACCL3 Bit Fields */
#define FTFA_XACCL3_XA_MASK                      0xFFu
#define FTFA_XACCL3_XA_SHIFT                     0
#define FTFA_XACCL3_XA_WIDTH                     8
#define FTFA_XACCL3_XA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_XACCL3_XA_SHIFT))&FTFA_XACCL3_XA_MASK)
/* XACCL2 Bit Fields */
#define FTFA_XACCL2_XA_MASK                      0xFFu
#define FTFA_XACCL2_XA_SHIFT                     0
#define FTFA_XACCL2_XA_WIDTH                     8
#define FTFA_XACCL2_XA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_XACCL2_XA_SHIFT))&FTFA_XACCL2_XA_MASK)
/* XACCL1 Bit Fields */
#define FTFA_XACCL1_XA_MASK                      0xFFu
#define FTFA_XACCL1_XA_SHIFT                     0
#define FTFA_XACCL1_XA_WIDTH                     8
#define FTFA_XACCL1_XA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_XACCL1_XA_SHIFT))&FTFA_XACCL1_XA_MASK)
/* XACCL0 Bit Fields */
#define FTFA_XACCL0_XA_MASK                      0xFFu
#define FTFA_XACCL0_XA_SHIFT                     0
#define FTFA_XACCL0_XA_WIDTH                     8
#define FTFA_XACCL0_XA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_XACCL0_XA_SHIFT))&FTFA_XACCL0_XA_MASK)
/* SACCH3 Bit Fields */
#define FTFA_SACCH3_SA_MASK                      0xFFu
#define FTFA_SACCH3_SA_SHIFT                     0
#define FTFA_SACCH3_SA_WIDTH                     8
#define FTFA_SACCH3_SA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_SACCH3_SA_SHIFT))&FTFA_SACCH3_SA_MASK)
/* SACCH2 Bit Fields */
#define FTFA_SACCH2_SA_MASK                      0xFFu
#define FTFA_SACCH2_SA_SHIFT                     0
#define FTFA_SACCH2_SA_WIDTH                     8
#define FTFA_SACCH2_SA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_SACCH2_SA_SHIFT))&FTFA_SACCH2_SA_MASK)
/* SACCH1 Bit Fields */
#define FTFA_SACCH1_SA_MASK                      0xFFu
#define FTFA_SACCH1_SA_SHIFT                     0
#define FTFA_SACCH1_SA_WIDTH                     8
#define FTFA_SACCH1_SA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_SACCH1_SA_SHIFT))&FTFA_SACCH1_SA_MASK)
/* SACCH0 Bit Fields */
#define FTFA_SACCH0_SA_MASK                      0xFFu
#define FTFA_SACCH0_SA_SHIFT                     0
#define FTFA_SACCH0_SA_WIDTH                     8
#define FTFA_SACCH0_SA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_SACCH0_SA_SHIFT))&FTFA_SACCH0_SA_MASK)
/* SACCL3 Bit Fields */
#define FTFA_SACCL3_SA_MASK                      0xFFu
#define FTFA_SACCL3_SA_SHIFT                     0
#define FTFA_SACCL3_SA_WIDTH                     8
#define FTFA_SACCL3_SA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_SACCL3_SA_SHIFT))&FTFA_SACCL3_SA_MASK)
/* SACCL2 Bit Fields */
#define FTFA_SACCL2_SA_MASK                      0xFFu
#define FTFA_SACCL2_SA_SHIFT                     0
#define FTFA_SACCL2_SA_WIDTH                     8
#define FTFA_SACCL2_SA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_SACCL2_SA_SHIFT))&FTFA_SACCL2_SA_MASK)
/* SACCL1 Bit Fields */
#define FTFA_SACCL1_SA_MASK                      0xFFu
#define FTFA_SACCL1_SA_SHIFT                     0
#define FTFA_SACCL1_SA_WIDTH                     8
#define FTFA_SACCL1_SA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_SACCL1_SA_SHIFT))&FTFA_SACCL1_SA_MASK)
/* SACCL0 Bit Fields */
#define FTFA_SACCL0_SA_MASK                      0xFFu
#define FTFA_SACCL0_SA_SHIFT                     0
#define FTFA_SACCL0_SA_WIDTH                     8
#define FTFA_SACCL0_SA(x)                        (((uint8_t)(((uint8_t)(x))<<FTFA_SACCL0_SA_SHIFT))&FTFA_SACCL0_SA_MASK)
/* FACSS Bit Fields */
#define FTFA_FACSS_SGSIZE_MASK                   0xFFu
#define FTFA_FACSS_SGSIZE_SHIFT                  0
#define FTFA_FACSS_SGSIZE_WIDTH                  8
#define FTFA_FACSS_SGSIZE(x)                     (((uint8_t)(((uint8_t)(x))<<FTFA_FACSS_SGSIZE_SHIFT))&FTFA_FACSS_SGSIZE_MASK)
/* FACSN Bit Fields */
#define FTFA_FACSN_NUMSG_MASK                    0xFFu
#define FTFA_FACSN_NUMSG_SHIFT                   0
#define FTFA_FACSN_NUMSG_WIDTH                   8
#define FTFA_FACSN_NUMSG(x)                      (((uint8_t)(((uint8_t)(x))<<FTFA_FACSN_NUMSG_SHIFT))&FTFA_FACSN_NUMSG_MASK)

/*!
 * @}
 */ /* end of group FTFA_Register_Masks */


/* FTFA - Peripheral instance base addresses */
/** Peripheral FTFA base address */
#define FTFA_BASE                                (0x40020000u)
/** Peripheral FTFA base pointer */
#define FTFA                                     ((FTFA_Type *)FTFA_BASE)
#define FTFA_BASE_PTR                            (FTFA)
/** Array initializer of FTFA peripheral base addresses */
#define FTFA_BASE_ADDRS                          { FTFA_BASE }
/** Array initializer of FTFA peripheral base pointers */
#define FTFA_BASE_PTRS                           { FTFA }

/* ----------------------------------------------------------------------------
   -- FTFA - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FTFA_Register_Accessor_Macros FTFA - Register accessor macros
 * @{
 */


/* FTFA - Register instance definitions */
/* FTFA */
#define FTFA_FSTAT                               FTFA_FSTAT_REG(FTFA)
#define FTFA_FCNFG                               FTFA_FCNFG_REG(FTFA)
#define FTFA_FSEC                                FTFA_FSEC_REG(FTFA)
#define FTFA_FOPT                                FTFA_FOPT_REG(FTFA)
#define FTFA_FCCOB3                              FTFA_FCCOB3_REG(FTFA)
#define FTFA_FCCOB2                              FTFA_FCCOB2_REG(FTFA)
#define FTFA_FCCOB1                              FTFA_FCCOB1_REG(FTFA)
#define FTFA_FCCOB0                              FTFA_FCCOB0_REG(FTFA)
#define FTFA_FCCOB7                              FTFA_FCCOB7_REG(FTFA)
#define FTFA_FCCOB6                              FTFA_FCCOB6_REG(FTFA)
#define FTFA_FCCOB5                              FTFA_FCCOB5_REG(FTFA)
#define FTFA_FCCOB4                              FTFA_FCCOB4_REG(FTFA)
#define FTFA_FCCOBB                              FTFA_FCCOBB_REG(FTFA)
#define FTFA_FCCOBA                              FTFA_FCCOBA_REG(FTFA)
#define FTFA_FCCOB9                              FTFA_FCCOB9_REG(FTFA)
#define FTFA_FCCOB8                              FTFA_FCCOB8_REG(FTFA)
#define FTFA_FPROT3                              FTFA_FPROT3_REG(FTFA)
#define FTFA_FPROT2                              FTFA_FPROT2_REG(FTFA)
#define FTFA_FPROT1                              FTFA_FPROT1_REG(FTFA)
#define FTFA_FPROT0                              FTFA_FPROT0_REG(FTFA)
#define FTFA_XACCH3                              FTFA_XACCH3_REG(FTFA)
#define FTFA_XACCH2                              FTFA_XACCH2_REG(FTFA)
#define FTFA_XACCH1                              FTFA_XACCH1_REG(FTFA)
#define FTFA_XACCH0                              FTFA_XACCH0_REG(FTFA)
#define FTFA_XACCL3                              FTFA_XACCL3_REG(FTFA)
#define FTFA_XACCL2                              FTFA_XACCL2_REG(FTFA)
#define FTFA_XACCL1                              FTFA_XACCL1_REG(FTFA)
#define FTFA_XACCL0                              FTFA_XACCL0_REG(FTFA)
#define FTFA_SACCH3                              FTFA_SACCH3_REG(FTFA)
#define FTFA_SACCH2                              FTFA_SACCH2_REG(FTFA)
#define FTFA_SACCH1                              FTFA_SACCH1_REG(FTFA)
#define FTFA_SACCH0                              FTFA_SACCH0_REG(FTFA)
#define FTFA_SACCL3                              FTFA_SACCL3_REG(FTFA)
#define FTFA_SACCL2                              FTFA_SACCL2_REG(FTFA)
#define FTFA_SACCL1                              FTFA_SACCL1_REG(FTFA)
#define FTFA_SACCL0                              FTFA_SACCL0_REG(FTFA)
#define FTFA_FACSS                               FTFA_FACSS_REG(FTFA)
#define FTFA_FACSN                               FTFA_FACSN_REG(FTFA)

/*!
 * @}
 */ /* end of group FTFA_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group FTFA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral_Access_Layer GPIO Peripheral Access Layer
 * @{
 */

/** GPIO - Register Layout Typedef */
typedef struct {
  __IO uint32_t PDOR;                              /**< Port Data Output Register, offset: 0x0 */
  __O  uint32_t PSOR;                              /**< Port Set Output Register, offset: 0x4 */
  __O  uint32_t PCOR;                              /**< Port Clear Output Register, offset: 0x8 */
  __O  uint32_t PTOR;                              /**< Port Toggle Output Register, offset: 0xC */
  __I  uint32_t PDIR;                              /**< Port Data Input Register, offset: 0x10 */
  __IO uint32_t PDDR;                              /**< Port Data Direction Register, offset: 0x14 */
} GPIO_Type, *GPIO_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- GPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Accessor_Macros GPIO - Register accessor macros
 * @{
 */


/* GPIO - Register accessors */
#define GPIO_PDOR_REG(base)                      ((base)->PDOR)
#define GPIO_PSOR_REG(base)                      ((base)->PSOR)
#define GPIO_PCOR_REG(base)                      ((base)->PCOR)
#define GPIO_PTOR_REG(base)                      ((base)->PTOR)
#define GPIO_PDIR_REG(base)                      ((base)->PDIR)
#define GPIO_PDDR_REG(base)                      ((base)->PDDR)

/*!
 * @}
 */ /* end of group GPIO_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/* PDOR Bit Fields */
#define GPIO_PDOR_PDO_MASK                       0xFFFFFFFFu
#define GPIO_PDOR_PDO_SHIFT                      0
#define GPIO_PDOR_PDO_WIDTH                      32
#define GPIO_PDOR_PDO(x)                         (((uint32_t)(((uint32_t)(x))<<GPIO_PDOR_PDO_SHIFT))&GPIO_PDOR_PDO_MASK)
/* PSOR Bit Fields */
#define GPIO_PSOR_PTSO_MASK                      0xFFFFFFFFu
#define GPIO_PSOR_PTSO_SHIFT                     0
#define GPIO_PSOR_PTSO_WIDTH                     32
#define GPIO_PSOR_PTSO(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_PSOR_PTSO_SHIFT))&GPIO_PSOR_PTSO_MASK)
/* PCOR Bit Fields */
#define GPIO_PCOR_PTCO_MASK                      0xFFFFFFFFu
#define GPIO_PCOR_PTCO_SHIFT                     0
#define GPIO_PCOR_PTCO_WIDTH                     32
#define GPIO_PCOR_PTCO(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_PCOR_PTCO_SHIFT))&GPIO_PCOR_PTCO_MASK)
/* PTOR Bit Fields */
#define GPIO_PTOR_PTTO_MASK                      0xFFFFFFFFu
#define GPIO_PTOR_PTTO_SHIFT                     0
#define GPIO_PTOR_PTTO_WIDTH                     32
#define GPIO_PTOR_PTTO(x)                        (((uint32_t)(((uint32_t)(x))<<GPIO_PTOR_PTTO_SHIFT))&GPIO_PTOR_PTTO_MASK)
/* PDIR Bit Fields */
#define GPIO_PDIR_PDI_MASK                       0xFFFFFFFFu
#define GPIO_PDIR_PDI_SHIFT                      0
#define GPIO_PDIR_PDI_WIDTH                      32
#define GPIO_PDIR_PDI(x)                         (((uint32_t)(((uint32_t)(x))<<GPIO_PDIR_PDI_SHIFT))&GPIO_PDIR_PDI_MASK)
/* PDDR Bit Fields */
#define GPIO_PDDR_PDD_MASK                       0xFFFFFFFFu
#define GPIO_PDDR_PDD_SHIFT                      0
#define GPIO_PDDR_PDD_WIDTH                      32
#define GPIO_PDDR_PDD(x)                         (((uint32_t)(((uint32_t)(x))<<GPIO_PDDR_PDD_SHIFT))&GPIO_PDDR_PDD_MASK)

/*!
 * @}
 */ /* end of group GPIO_Register_Masks */


/* GPIO - Peripheral instance base addresses */
/** Peripheral GPIOA base address */
#define GPIOA_BASE                               (0x400FF000u)
/** Peripheral GPIOA base pointer */
#define GPIOA                                    ((GPIO_Type *)GPIOA_BASE)
#define GPIOA_BASE_PTR                           (GPIOA)
/** Peripheral GPIOB base address */
#define GPIOB_BASE                               (0x400FF040u)
/** Peripheral GPIOB base pointer */
#define GPIOB                                    ((GPIO_Type *)GPIOB_BASE)
#define GPIOB_BASE_PTR                           (GPIOB)
/** Peripheral GPIOC base address */
#define GPIOC_BASE                               (0x400FF080u)
/** Peripheral GPIOC base pointer */
#define GPIOC                                    ((GPIO_Type *)GPIOC_BASE)
#define GPIOC_BASE_PTR                           (GPIOC)
/** Peripheral GPIOD base address */
#define GPIOD_BASE                               (0x400FF0C0u)
/** Peripheral GPIOD base pointer */
#define GPIOD                                    ((GPIO_Type *)GPIOD_BASE)
#define GPIOD_BASE_PTR                           (GPIOD)
/** Peripheral GPIOE base address */
#define GPIOE_BASE                               (0x400FF100u)
/** Peripheral GPIOE base pointer */
#define GPIOE                                    ((GPIO_Type *)GPIOE_BASE)
#define GPIOE_BASE_PTR                           (GPIOE)
/** Array initializer of GPIO peripheral base addresses */
#define GPIO_BASE_ADDRS                          { GPIOA_BASE, GPIOB_BASE, GPIOC_BASE, GPIOD_BASE, GPIOE_BASE }
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS                           { GPIOA, GPIOB, GPIOC, GPIOD, GPIOE }

/* ----------------------------------------------------------------------------
   -- GPIO - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Accessor_Macros GPIO - Register accessor macros
 * @{
 */


/* GPIO - Register instance definitions */
/* GPIOA */
#define GPIOA_PDOR                               GPIO_PDOR_REG(GPIOA)
#define GPIOA_PSOR                               GPIO_PSOR_REG(GPIOA)
#define GPIOA_PCOR                               GPIO_PCOR_REG(GPIOA)
#define GPIOA_PTOR                               GPIO_PTOR_REG(GPIOA)
#define GPIOA_PDIR                               GPIO_PDIR_REG(GPIOA)
#define GPIOA_PDDR                               GPIO_PDDR_REG(GPIOA)
/* GPIOB */
#define GPIOB_PDOR                               GPIO_PDOR_REG(GPIOB)
#define GPIOB_PSOR                               GPIO_PSOR_REG(GPIOB)
#define GPIOB_PCOR                               GPIO_PCOR_REG(GPIOB)
#define GPIOB_PTOR                               GPIO_PTOR_REG(GPIOB)
#define GPIOB_PDIR                               GPIO_PDIR_REG(GPIOB)
#define GPIOB_PDDR                               GPIO_PDDR_REG(GPIOB)
/* GPIOC */
#define GPIOC_PDOR                               GPIO_PDOR_REG(GPIOC)
#define GPIOC_PSOR                               GPIO_PSOR_REG(GPIOC)
#define GPIOC_PCOR                               GPIO_PCOR_REG(GPIOC)
#define GPIOC_PTOR                               GPIO_PTOR_REG(GPIOC)
#define GPIOC_PDIR                               GPIO_PDIR_REG(GPIOC)
#define GPIOC_PDDR                               GPIO_PDDR_REG(GPIOC)
/* GPIOD */
#define GPIOD_PDOR                               GPIO_PDOR_REG(GPIOD)
#define GPIOD_PSOR                               GPIO_PSOR_REG(GPIOD)
#define GPIOD_PCOR                               GPIO_PCOR_REG(GPIOD)
#define GPIOD_PTOR                               GPIO_PTOR_REG(GPIOD)
#define GPIOD_PDIR                               GPIO_PDIR_REG(GPIOD)
#define GPIOD_PDDR                               GPIO_PDDR_REG(GPIOD)
/* GPIOE */
#define GPIOE_PDOR                               GPIO_PDOR_REG(GPIOE)
#define GPIOE_PSOR                               GPIO_PSOR_REG(GPIOE)
#define GPIOE_PCOR                               GPIO_PCOR_REG(GPIOE)
#define GPIOE_PTOR                               GPIO_PTOR_REG(GPIOE)
#define GPIOE_PDIR                               GPIO_PDIR_REG(GPIOE)
#define GPIOE_PDDR                               GPIO_PDDR_REG(GPIOE)

/*!
 * @}
 */ /* end of group GPIO_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group GPIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I2C Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Peripheral_Access_Layer I2C Peripheral Access Layer
 * @{
 */

/** I2C - Register Layout Typedef */
typedef struct {
  __IO uint8_t A1;                                 /**< I2C Address Register 1, offset: 0x0 */
  __IO uint8_t F;                                  /**< I2C Frequency Divider register, offset: 0x1 */
  __IO uint8_t C1;                                 /**< I2C Control Register 1, offset: 0x2 */
  __IO uint8_t S;                                  /**< I2C Status register, offset: 0x3 */
  __IO uint8_t D;                                  /**< I2C Data I/O register, offset: 0x4 */
  __IO uint8_t C2;                                 /**< I2C Control Register 2, offset: 0x5 */
  __IO uint8_t FLT;                                /**< I2C Programmable Input Glitch Filter Register, offset: 0x6 */
  __IO uint8_t RA;                                 /**< I2C Range Address register, offset: 0x7 */
  __IO uint8_t SMB;                                /**< I2C SMBus Control and Status register, offset: 0x8 */
  __IO uint8_t A2;                                 /**< I2C Address Register 2, offset: 0x9 */
  __IO uint8_t SLTH;                               /**< I2C SCL Low Timeout Register High, offset: 0xA */
  __IO uint8_t SLTL;                               /**< I2C SCL Low Timeout Register Low, offset: 0xB */
  __IO uint8_t S2;                                 /**< I2C Status register 2, offset: 0xC */
} I2C_Type, *I2C_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- I2C - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Accessor_Macros I2C - Register accessor macros
 * @{
 */


/* I2C - Register accessors */
#define I2C_A1_REG(base)                         ((base)->A1)
#define I2C_F_REG(base)                          ((base)->F)
#define I2C_C1_REG(base)                         ((base)->C1)
#define I2C_S_REG(base)                          ((base)->S)
#define I2C_D_REG(base)                          ((base)->D)
#define I2C_C2_REG(base)                         ((base)->C2)
#define I2C_FLT_REG(base)                        ((base)->FLT)
#define I2C_RA_REG(base)                         ((base)->RA)
#define I2C_SMB_REG(base)                        ((base)->SMB)
#define I2C_A2_REG(base)                         ((base)->A2)
#define I2C_SLTH_REG(base)                       ((base)->SLTH)
#define I2C_SLTL_REG(base)                       ((base)->SLTL)
#define I2C_S2_REG(base)                         ((base)->S2)

/*!
 * @}
 */ /* end of group I2C_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- I2C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Masks I2C Register Masks
 * @{
 */

/* A1 Bit Fields */
#define I2C_A1_AD_MASK                           0xFEu
#define I2C_A1_AD_SHIFT                          1
#define I2C_A1_AD_WIDTH                          7
#define I2C_A1_AD(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_A1_AD_SHIFT))&I2C_A1_AD_MASK)
/* F Bit Fields */
#define I2C_F_ICR_MASK                           0x3Fu
#define I2C_F_ICR_SHIFT                          0
#define I2C_F_ICR_WIDTH                          6
#define I2C_F_ICR(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_F_ICR_SHIFT))&I2C_F_ICR_MASK)
#define I2C_F_MULT_MASK                          0xC0u
#define I2C_F_MULT_SHIFT                         6
#define I2C_F_MULT_WIDTH                         2
#define I2C_F_MULT(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_F_MULT_SHIFT))&I2C_F_MULT_MASK)
/* C1 Bit Fields */
#define I2C_C1_DMAEN_MASK                        0x1u
#define I2C_C1_DMAEN_SHIFT                       0
#define I2C_C1_DMAEN_WIDTH                       1
#define I2C_C1_DMAEN(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_C1_DMAEN_SHIFT))&I2C_C1_DMAEN_MASK)
#define I2C_C1_WUEN_MASK                         0x2u
#define I2C_C1_WUEN_SHIFT                        1
#define I2C_C1_WUEN_WIDTH                        1
#define I2C_C1_WUEN(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C1_WUEN_SHIFT))&I2C_C1_WUEN_MASK)
#define I2C_C1_RSTA_MASK                         0x4u
#define I2C_C1_RSTA_SHIFT                        2
#define I2C_C1_RSTA_WIDTH                        1
#define I2C_C1_RSTA(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C1_RSTA_SHIFT))&I2C_C1_RSTA_MASK)
#define I2C_C1_TXAK_MASK                         0x8u
#define I2C_C1_TXAK_SHIFT                        3
#define I2C_C1_TXAK_WIDTH                        1
#define I2C_C1_TXAK(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C1_TXAK_SHIFT))&I2C_C1_TXAK_MASK)
#define I2C_C1_TX_MASK                           0x10u
#define I2C_C1_TX_SHIFT                          4
#define I2C_C1_TX_WIDTH                          1
#define I2C_C1_TX(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_C1_TX_SHIFT))&I2C_C1_TX_MASK)
#define I2C_C1_MST_MASK                          0x20u
#define I2C_C1_MST_SHIFT                         5
#define I2C_C1_MST_WIDTH                         1
#define I2C_C1_MST(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_C1_MST_SHIFT))&I2C_C1_MST_MASK)
#define I2C_C1_IICIE_MASK                        0x40u
#define I2C_C1_IICIE_SHIFT                       6
#define I2C_C1_IICIE_WIDTH                       1
#define I2C_C1_IICIE(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_C1_IICIE_SHIFT))&I2C_C1_IICIE_MASK)
#define I2C_C1_IICEN_MASK                        0x80u
#define I2C_C1_IICEN_SHIFT                       7
#define I2C_C1_IICEN_WIDTH                       1
#define I2C_C1_IICEN(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_C1_IICEN_SHIFT))&I2C_C1_IICEN_MASK)
/* S Bit Fields */
#define I2C_S_RXAK_MASK                          0x1u
#define I2C_S_RXAK_SHIFT                         0
#define I2C_S_RXAK_WIDTH                         1
#define I2C_S_RXAK(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_S_RXAK_SHIFT))&I2C_S_RXAK_MASK)
#define I2C_S_IICIF_MASK                         0x2u
#define I2C_S_IICIF_SHIFT                        1
#define I2C_S_IICIF_WIDTH                        1
#define I2C_S_IICIF(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_S_IICIF_SHIFT))&I2C_S_IICIF_MASK)
#define I2C_S_SRW_MASK                           0x4u
#define I2C_S_SRW_SHIFT                          2
#define I2C_S_SRW_WIDTH                          1
#define I2C_S_SRW(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_S_SRW_SHIFT))&I2C_S_SRW_MASK)
#define I2C_S_RAM_MASK                           0x8u
#define I2C_S_RAM_SHIFT                          3
#define I2C_S_RAM_WIDTH                          1
#define I2C_S_RAM(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_S_RAM_SHIFT))&I2C_S_RAM_MASK)
#define I2C_S_ARBL_MASK                          0x10u
#define I2C_S_ARBL_SHIFT                         4
#define I2C_S_ARBL_WIDTH                         1
#define I2C_S_ARBL(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_S_ARBL_SHIFT))&I2C_S_ARBL_MASK)
#define I2C_S_BUSY_MASK                          0x20u
#define I2C_S_BUSY_SHIFT                         5
#define I2C_S_BUSY_WIDTH                         1
#define I2C_S_BUSY(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_S_BUSY_SHIFT))&I2C_S_BUSY_MASK)
#define I2C_S_IAAS_MASK                          0x40u
#define I2C_S_IAAS_SHIFT                         6
#define I2C_S_IAAS_WIDTH                         1
#define I2C_S_IAAS(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_S_IAAS_SHIFT))&I2C_S_IAAS_MASK)
#define I2C_S_TCF_MASK                           0x80u
#define I2C_S_TCF_SHIFT                          7
#define I2C_S_TCF_WIDTH                          1
#define I2C_S_TCF(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_S_TCF_SHIFT))&I2C_S_TCF_MASK)
/* D Bit Fields */
#define I2C_D_DATA_MASK                          0xFFu
#define I2C_D_DATA_SHIFT                         0
#define I2C_D_DATA_WIDTH                         8
#define I2C_D_DATA(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_D_DATA_SHIFT))&I2C_D_DATA_MASK)
/* C2 Bit Fields */
#define I2C_C2_AD_MASK                           0x7u
#define I2C_C2_AD_SHIFT                          0
#define I2C_C2_AD_WIDTH                          3
#define I2C_C2_AD(x)                             (((uint8_t)(((uint8_t)(x))<<I2C_C2_AD_SHIFT))&I2C_C2_AD_MASK)
#define I2C_C2_RMEN_MASK                         0x8u
#define I2C_C2_RMEN_SHIFT                        3
#define I2C_C2_RMEN_WIDTH                        1
#define I2C_C2_RMEN(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C2_RMEN_SHIFT))&I2C_C2_RMEN_MASK)
#define I2C_C2_SBRC_MASK                         0x10u
#define I2C_C2_SBRC_SHIFT                        4
#define I2C_C2_SBRC_WIDTH                        1
#define I2C_C2_SBRC(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C2_SBRC_SHIFT))&I2C_C2_SBRC_MASK)
#define I2C_C2_HDRS_MASK                         0x20u
#define I2C_C2_HDRS_SHIFT                        5
#define I2C_C2_HDRS_WIDTH                        1
#define I2C_C2_HDRS(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_C2_HDRS_SHIFT))&I2C_C2_HDRS_MASK)
#define I2C_C2_ADEXT_MASK                        0x40u
#define I2C_C2_ADEXT_SHIFT                       6
#define I2C_C2_ADEXT_WIDTH                       1
#define I2C_C2_ADEXT(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_C2_ADEXT_SHIFT))&I2C_C2_ADEXT_MASK)
#define I2C_C2_GCAEN_MASK                        0x80u
#define I2C_C2_GCAEN_SHIFT                       7
#define I2C_C2_GCAEN_WIDTH                       1
#define I2C_C2_GCAEN(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_C2_GCAEN_SHIFT))&I2C_C2_GCAEN_MASK)
/* FLT Bit Fields */
#define I2C_FLT_FLT_MASK                         0xFu
#define I2C_FLT_FLT_SHIFT                        0
#define I2C_FLT_FLT_WIDTH                        4
#define I2C_FLT_FLT(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_FLT_FLT_SHIFT))&I2C_FLT_FLT_MASK)
#define I2C_FLT_STARTF_MASK                      0x10u
#define I2C_FLT_STARTF_SHIFT                     4
#define I2C_FLT_STARTF_WIDTH                     1
#define I2C_FLT_STARTF(x)                        (((uint8_t)(((uint8_t)(x))<<I2C_FLT_STARTF_SHIFT))&I2C_FLT_STARTF_MASK)
#define I2C_FLT_SSIE_MASK                        0x20u
#define I2C_FLT_SSIE_SHIFT                       5
#define I2C_FLT_SSIE_WIDTH                       1
#define I2C_FLT_SSIE(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_FLT_SSIE_SHIFT))&I2C_FLT_SSIE_MASK)
#define I2C_FLT_STOPF_MASK                       0x40u
#define I2C_FLT_STOPF_SHIFT                      6
#define I2C_FLT_STOPF_WIDTH                      1
#define I2C_FLT_STOPF(x)                         (((uint8_t)(((uint8_t)(x))<<I2C_FLT_STOPF_SHIFT))&I2C_FLT_STOPF_MASK)
#define I2C_FLT_SHEN_MASK                        0x80u
#define I2C_FLT_SHEN_SHIFT                       7
#define I2C_FLT_SHEN_WIDTH                       1
#define I2C_FLT_SHEN(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_FLT_SHEN_SHIFT))&I2C_FLT_SHEN_MASK)
/* RA Bit Fields */
#define I2C_RA_RAD_MASK                          0xFEu
#define I2C_RA_RAD_SHIFT                         1
#define I2C_RA_RAD_WIDTH                         7
#define I2C_RA_RAD(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_RA_RAD_SHIFT))&I2C_RA_RAD_MASK)
/* SMB Bit Fields */
#define I2C_SMB_SHTF2IE_MASK                     0x1u
#define I2C_SMB_SHTF2IE_SHIFT                    0
#define I2C_SMB_SHTF2IE_WIDTH                    1
#define I2C_SMB_SHTF2IE(x)                       (((uint8_t)(((uint8_t)(x))<<I2C_SMB_SHTF2IE_SHIFT))&I2C_SMB_SHTF2IE_MASK)
#define I2C_SMB_SHTF2_MASK                       0x2u
#define I2C_SMB_SHTF2_SHIFT                      1
#define I2C_SMB_SHTF2_WIDTH                      1
#define I2C_SMB_SHTF2(x)                         (((uint8_t)(((uint8_t)(x))<<I2C_SMB_SHTF2_SHIFT))&I2C_SMB_SHTF2_MASK)
#define I2C_SMB_SHTF1_MASK                       0x4u
#define I2C_SMB_SHTF1_SHIFT                      2
#define I2C_SMB_SHTF1_WIDTH                      1
#define I2C_SMB_SHTF1(x)                         (((uint8_t)(((uint8_t)(x))<<I2C_SMB_SHTF1_SHIFT))&I2C_SMB_SHTF1_MASK)
#define I2C_SMB_SLTF_MASK                        0x8u
#define I2C_SMB_SLTF_SHIFT                       3
#define I2C_SMB_SLTF_WIDTH                       1
#define I2C_SMB_SLTF(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_SMB_SLTF_SHIFT))&I2C_SMB_SLTF_MASK)
#define I2C_SMB_TCKSEL_MASK                      0x10u
#define I2C_SMB_TCKSEL_SHIFT                     4
#define I2C_SMB_TCKSEL_WIDTH                     1
#define I2C_SMB_TCKSEL(x)                        (((uint8_t)(((uint8_t)(x))<<I2C_SMB_TCKSEL_SHIFT))&I2C_SMB_TCKSEL_MASK)
#define I2C_SMB_SIICAEN_MASK                     0x20u
#define I2C_SMB_SIICAEN_SHIFT                    5
#define I2C_SMB_SIICAEN_WIDTH                    1
#define I2C_SMB_SIICAEN(x)                       (((uint8_t)(((uint8_t)(x))<<I2C_SMB_SIICAEN_SHIFT))&I2C_SMB_SIICAEN_MASK)
#define I2C_SMB_ALERTEN_MASK                     0x40u
#define I2C_SMB_ALERTEN_SHIFT                    6
#define I2C_SMB_ALERTEN_WIDTH                    1
#define I2C_SMB_ALERTEN(x)                       (((uint8_t)(((uint8_t)(x))<<I2C_SMB_ALERTEN_SHIFT))&I2C_SMB_ALERTEN_MASK)
#define I2C_SMB_FACK_MASK                        0x80u
#define I2C_SMB_FACK_SHIFT                       7
#define I2C_SMB_FACK_WIDTH                       1
#define I2C_SMB_FACK(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_SMB_FACK_SHIFT))&I2C_SMB_FACK_MASK)
/* A2 Bit Fields */
#define I2C_A2_SAD_MASK                          0xFEu
#define I2C_A2_SAD_SHIFT                         1
#define I2C_A2_SAD_WIDTH                         7
#define I2C_A2_SAD(x)                            (((uint8_t)(((uint8_t)(x))<<I2C_A2_SAD_SHIFT))&I2C_A2_SAD_MASK)
/* SLTH Bit Fields */
#define I2C_SLTH_SSLT_MASK                       0xFFu
#define I2C_SLTH_SSLT_SHIFT                      0
#define I2C_SLTH_SSLT_WIDTH                      8
#define I2C_SLTH_SSLT(x)                         (((uint8_t)(((uint8_t)(x))<<I2C_SLTH_SSLT_SHIFT))&I2C_SLTH_SSLT_MASK)
/* SLTL Bit Fields */
#define I2C_SLTL_SSLT_MASK                       0xFFu
#define I2C_SLTL_SSLT_SHIFT                      0
#define I2C_SLTL_SSLT_WIDTH                      8
#define I2C_SLTL_SSLT(x)                         (((uint8_t)(((uint8_t)(x))<<I2C_SLTL_SSLT_SHIFT))&I2C_SLTL_SSLT_MASK)
/* S2 Bit Fields */
#define I2C_S2_EMPTY_MASK                        0x1u
#define I2C_S2_EMPTY_SHIFT                       0
#define I2C_S2_EMPTY_WIDTH                       1
#define I2C_S2_EMPTY(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_S2_EMPTY_SHIFT))&I2C_S2_EMPTY_MASK)
#define I2C_S2_ERROR_MASK                        0x2u
#define I2C_S2_ERROR_SHIFT                       1
#define I2C_S2_ERROR_WIDTH                       1
#define I2C_S2_ERROR(x)                          (((uint8_t)(((uint8_t)(x))<<I2C_S2_ERROR_SHIFT))&I2C_S2_ERROR_MASK)
#define I2C_S2_DFEN_MASK                         0x4u
#define I2C_S2_DFEN_SHIFT                        2
#define I2C_S2_DFEN_WIDTH                        1
#define I2C_S2_DFEN(x)                           (((uint8_t)(((uint8_t)(x))<<I2C_S2_DFEN_SHIFT))&I2C_S2_DFEN_MASK)

/*!
 * @}
 */ /* end of group I2C_Register_Masks */


/* I2C - Peripheral instance base addresses */
/** Peripheral I2C0 base address */
#define I2C0_BASE                                (0x40066000u)
/** Peripheral I2C0 base pointer */
#define I2C0                                     ((I2C_Type *)I2C0_BASE)
#define I2C0_BASE_PTR                            (I2C0)
/** Peripheral I2C1 base address */
#define I2C1_BASE                                (0x40067000u)
/** Peripheral I2C1 base pointer */
#define I2C1                                     ((I2C_Type *)I2C1_BASE)
#define I2C1_BASE_PTR                            (I2C1)
/** Array initializer of I2C peripheral base addresses */
#define I2C_BASE_ADDRS                           { I2C0_BASE, I2C1_BASE }
/** Array initializer of I2C peripheral base pointers */
#define I2C_BASE_PTRS                            { I2C0, I2C1 }

/* ----------------------------------------------------------------------------
   -- I2C - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Accessor_Macros I2C - Register accessor macros
 * @{
 */


/* I2C - Register instance definitions */
/* I2C0 */
#define I2C0_A1                                  I2C_A1_REG(I2C0)
#define I2C0_F                                   I2C_F_REG(I2C0)
#define I2C0_C1                                  I2C_C1_REG(I2C0)
#define I2C0_S                                   I2C_S_REG(I2C0)
#define I2C0_D                                   I2C_D_REG(I2C0)
#define I2C0_C2                                  I2C_C2_REG(I2C0)
#define I2C0_FLT                                 I2C_FLT_REG(I2C0)
#define I2C0_RA                                  I2C_RA_REG(I2C0)
#define I2C0_SMB                                 I2C_SMB_REG(I2C0)
#define I2C0_A2                                  I2C_A2_REG(I2C0)
#define I2C0_SLTH                                I2C_SLTH_REG(I2C0)
#define I2C0_SLTL                                I2C_SLTL_REG(I2C0)
#define I2C0_S2                                  I2C_S2_REG(I2C0)
/* I2C1 */
#define I2C1_A1                                  I2C_A1_REG(I2C1)
#define I2C1_F                                   I2C_F_REG(I2C1)
#define I2C1_C1                                  I2C_C1_REG(I2C1)
#define I2C1_S                                   I2C_S_REG(I2C1)
#define I2C1_D                                   I2C_D_REG(I2C1)
#define I2C1_C2                                  I2C_C2_REG(I2C1)
#define I2C1_FLT                                 I2C_FLT_REG(I2C1)
#define I2C1_RA                                  I2C_RA_REG(I2C1)
#define I2C1_SMB                                 I2C_SMB_REG(I2C1)
#define I2C1_A2                                  I2C_A2_REG(I2C1)
#define I2C1_SLTH                                I2C_SLTH_REG(I2C1)
#define I2C1_SLTL                                I2C_SLTL_REG(I2C1)
#define I2C1_S2                                  I2C_S2_REG(I2C1)

/*!
 * @}
 */ /* end of group I2C_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group I2C_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- INTMUX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INTMUX_Peripheral_Access_Layer INTMUX Peripheral Access Layer
 * @{
 */

/** INTMUX - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x40 */
    __IO uint32_t CHn_CSR;                           /**< Channel n Control Status Register, array offset: 0x0, array step: 0x40 */
    __I  uint32_t CHn_VEC;                           /**< Channel n Vector Number Register, array offset: 0x4, array step: 0x40 */
         uint8_t RESERVED_0[8];
    __IO uint32_t CHn_IER_31_0;                      /**< Channel n Interrupt Enable Register, array offset: 0x10, array step: 0x40 */
         uint8_t RESERVED_1[12];
    __I  uint32_t CHn_IPR_31_0;                      /**< Channel n Interrupt Pending Register, array offset: 0x20, array step: 0x40 */
         uint8_t RESERVED_2[28];
  } CHANNEL[4];
} INTMUX_Type, *INTMUX_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- INTMUX - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INTMUX_Register_Accessor_Macros INTMUX - Register accessor macros
 * @{
 */


/* INTMUX - Register accessors */
#define INTMUX_CHn_CSR_REG(base,index)           ((base)->CHANNEL[index].CHn_CSR)
#define INTMUX_CHn_CSR_COUNT                     4
#define INTMUX_CHn_VEC_REG(base,index)           ((base)->CHANNEL[index].CHn_VEC)
#define INTMUX_CHn_VEC_COUNT                     4
#define INTMUX_CHn_IER_31_0_REG(base,index)      ((base)->CHANNEL[index].CHn_IER_31_0)
#define INTMUX_CHn_IER_31_0_COUNT                4
#define INTMUX_CHn_IPR_31_0_REG(base,index)      ((base)->CHANNEL[index].CHn_IPR_31_0)
#define INTMUX_CHn_IPR_31_0_COUNT                4

/*!
 * @}
 */ /* end of group INTMUX_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- INTMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INTMUX_Register_Masks INTMUX Register Masks
 * @{
 */

/* CHn_CSR Bit Fields */
#define INTMUX_CHn_CSR_RST_MASK                  0x1u
#define INTMUX_CHn_CSR_RST_SHIFT                 0
#define INTMUX_CHn_CSR_RST_WIDTH                 1
#define INTMUX_CHn_CSR_RST(x)                    (((uint32_t)(((uint32_t)(x))<<INTMUX_CHn_CSR_RST_SHIFT))&INTMUX_CHn_CSR_RST_MASK)
#define INTMUX_CHn_CSR_AND_MASK                  0x2u
#define INTMUX_CHn_CSR_AND_SHIFT                 1
#define INTMUX_CHn_CSR_AND_WIDTH                 1
#define INTMUX_CHn_CSR_AND(x)                    (((uint32_t)(((uint32_t)(x))<<INTMUX_CHn_CSR_AND_SHIFT))&INTMUX_CHn_CSR_AND_MASK)
#define INTMUX_CHn_CSR_IRQN_MASK                 0x30u
#define INTMUX_CHn_CSR_IRQN_SHIFT                4
#define INTMUX_CHn_CSR_IRQN_WIDTH                2
#define INTMUX_CHn_CSR_IRQN(x)                   (((uint32_t)(((uint32_t)(x))<<INTMUX_CHn_CSR_IRQN_SHIFT))&INTMUX_CHn_CSR_IRQN_MASK)
#define INTMUX_CHn_CSR_CHIN_MASK                 0xF00u
#define INTMUX_CHn_CSR_CHIN_SHIFT                8
#define INTMUX_CHn_CSR_CHIN_WIDTH                4
#define INTMUX_CHn_CSR_CHIN(x)                   (((uint32_t)(((uint32_t)(x))<<INTMUX_CHn_CSR_CHIN_SHIFT))&INTMUX_CHn_CSR_CHIN_MASK)
#define INTMUX_CHn_CSR_IRQP_MASK                 0x80000000u
#define INTMUX_CHn_CSR_IRQP_SHIFT                31
#define INTMUX_CHn_CSR_IRQP_WIDTH                1
#define INTMUX_CHn_CSR_IRQP(x)                   (((uint32_t)(((uint32_t)(x))<<INTMUX_CHn_CSR_IRQP_SHIFT))&INTMUX_CHn_CSR_IRQP_MASK)
/* CHn_VEC Bit Fields */
#define INTMUX_CHn_VEC_VECN_MASK                 0x3FFCu
#define INTMUX_CHn_VEC_VECN_SHIFT                2
#define INTMUX_CHn_VEC_VECN_WIDTH                12
#define INTMUX_CHn_VEC_VECN(x)                   (((uint32_t)(((uint32_t)(x))<<INTMUX_CHn_VEC_VECN_SHIFT))&INTMUX_CHn_VEC_VECN_MASK)
/* CHn_IER_31_0 Bit Fields */
#define INTMUX_CHn_IER_31_0_INTE_MASK            0xFFFFFFFFu
#define INTMUX_CHn_IER_31_0_INTE_SHIFT           0
#define INTMUX_CHn_IER_31_0_INTE_WIDTH           32
#define INTMUX_CHn_IER_31_0_INTE(x)              (((uint32_t)(((uint32_t)(x))<<INTMUX_CHn_IER_31_0_INTE_SHIFT))&INTMUX_CHn_IER_31_0_INTE_MASK)
/* CHn_IPR_31_0 Bit Fields */
#define INTMUX_CHn_IPR_31_0_INTP_MASK            0xFFFFFFFFu
#define INTMUX_CHn_IPR_31_0_INTP_SHIFT           0
#define INTMUX_CHn_IPR_31_0_INTP_WIDTH           32
#define INTMUX_CHn_IPR_31_0_INTP(x)              (((uint32_t)(((uint32_t)(x))<<INTMUX_CHn_IPR_31_0_INTP_SHIFT))&INTMUX_CHn_IPR_31_0_INTP_MASK)

/*!
 * @}
 */ /* end of group INTMUX_Register_Masks */


/* INTMUX - Peripheral instance base addresses */
/** Peripheral INTMUX0 base address */
#define INTMUX0_BASE                             (0x40024000u)
/** Peripheral INTMUX0 base pointer */
#define INTMUX0                                  ((INTMUX_Type *)INTMUX0_BASE)
#define INTMUX0_BASE_PTR                         (INTMUX0)
/** Array initializer of INTMUX peripheral base addresses */
#define INTMUX_BASE_ADDRS                        { INTMUX0_BASE }
/** Array initializer of INTMUX peripheral base pointers */
#define INTMUX_BASE_PTRS                         { INTMUX0 }

/* ----------------------------------------------------------------------------
   -- INTMUX - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INTMUX_Register_Accessor_Macros INTMUX - Register accessor macros
 * @{
 */


/* INTMUX - Register instance definitions */
/* INTMUX0 */
#define INTMUX0_CH0_CSR                          INTMUX_CHn_CSR_REG(INTMUX0,0)
#define INTMUX0_CH0_VEC                          INTMUX_CHn_VEC_REG(INTMUX0,0)
#define INTMUX0_CH0_IER_31_0                     INTMUX_CHn_IER_31_0_REG(INTMUX0,0)
#define INTMUX0_CH0_IPR_31_0                     INTMUX_CHn_IPR_31_0_REG(INTMUX0,0)
#define INTMUX0_CH1_CSR                          INTMUX_CHn_CSR_REG(INTMUX0,1)
#define INTMUX0_CH1_VEC                          INTMUX_CHn_VEC_REG(INTMUX0,1)
#define INTMUX0_CH1_IER_31_0                     INTMUX_CHn_IER_31_0_REG(INTMUX0,1)
#define INTMUX0_CH1_IPR_31_0                     INTMUX_CHn_IPR_31_0_REG(INTMUX0,1)
#define INTMUX0_CH2_CSR                          INTMUX_CHn_CSR_REG(INTMUX0,2)
#define INTMUX0_CH2_VEC                          INTMUX_CHn_VEC_REG(INTMUX0,2)
#define INTMUX0_CH2_IER_31_0                     INTMUX_CHn_IER_31_0_REG(INTMUX0,2)
#define INTMUX0_CH2_IPR_31_0                     INTMUX_CHn_IPR_31_0_REG(INTMUX0,2)
#define INTMUX0_CH3_CSR                          INTMUX_CHn_CSR_REG(INTMUX0,3)
#define INTMUX0_CH3_VEC                          INTMUX_CHn_VEC_REG(INTMUX0,3)
#define INTMUX0_CH3_IER_31_0                     INTMUX_CHn_IER_31_0_REG(INTMUX0,3)
#define INTMUX0_CH3_IPR_31_0                     INTMUX_CHn_IPR_31_0_REG(INTMUX0,3)

/* INTMUX - Register array accessors */
#define INTMUX0_CHn_CSR(index)                   INTMUX_CHn_CSR_REG(INTMUX0,index)
#define INTMUX0_CHn_VEC(index)                   INTMUX_CHn_VEC_REG(INTMUX0,index)
#define INTMUX0_CHn_IER_31_0(index)              INTMUX_CHn_IER_31_0_REG(INTMUX0,index)
#define INTMUX0_CHn_IPR_31_0(index)              INTMUX_CHn_IPR_31_0_REG(INTMUX0,index)

/*!
 * @}
 */ /* end of group INTMUX_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group INTMUX_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LLWU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Peripheral_Access_Layer LLWU Peripheral Access Layer
 * @{
 */

/** LLWU - Register Layout Typedef */
typedef struct {
  __IO uint8_t PE1;                                /**< LLWU Pin Enable 1 register, offset: 0x0 */
  __IO uint8_t PE2;                                /**< LLWU Pin Enable 2 register, offset: 0x1 */
  __IO uint8_t PE3;                                /**< LLWU Pin Enable 3 register, offset: 0x2 */
  __IO uint8_t PE4;                                /**< LLWU Pin Enable 4 register, offset: 0x3 */
  __IO uint8_t PE5;                                /**< LLWU Pin Enable 5 register, offset: 0x4 */
  __IO uint8_t PE6;                                /**< LLWU Pin Enable 6 register, offset: 0x5 */
  __IO uint8_t PE7;                                /**< LLWU Pin Enable 7 register, offset: 0x6 */
  __IO uint8_t PE8;                                /**< LLWU Pin Enable 8 register, offset: 0x7 */
  __IO uint8_t ME;                                 /**< LLWU Module Enable register, offset: 0x8 */
  __IO uint8_t PF1;                                /**< LLWU Pin Flag 1 register, offset: 0x9 */
  __IO uint8_t PF2;                                /**< LLWU Pin Flag 2 register, offset: 0xA */
  __IO uint8_t PF3;                                /**< LLWU Pin Flag 3 register, offset: 0xB */
  __IO uint8_t PF4;                                /**< LLWU Pin Flag 4 register, offset: 0xC */
  __I  uint8_t MF5;                                /**< LLWU Module Flag 5 register, offset: 0xD */
  __IO uint8_t FILT1;                              /**< LLWU Pin Filter 1 register, offset: 0xE */
  __IO uint8_t FILT2;                              /**< LLWU Pin Filter 2 register, offset: 0xF */
  __IO uint8_t FILT3;                              /**< LLWU Pin Filter 3 register, offset: 0x10 */
  __IO uint8_t FILT4;                              /**< LLWU Pin Filter 4 register, offset: 0x11 */
} LLWU_Type, *LLWU_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- LLWU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Register_Accessor_Macros LLWU - Register accessor macros
 * @{
 */


/* LLWU - Register accessors */
#define LLWU_PE1_REG(base)                       ((base)->PE1)
#define LLWU_PE2_REG(base)                       ((base)->PE2)
#define LLWU_PE3_REG(base)                       ((base)->PE3)
#define LLWU_PE4_REG(base)                       ((base)->PE4)
#define LLWU_PE5_REG(base)                       ((base)->PE5)
#define LLWU_PE6_REG(base)                       ((base)->PE6)
#define LLWU_PE7_REG(base)                       ((base)->PE7)
#define LLWU_PE8_REG(base)                       ((base)->PE8)
#define LLWU_ME_REG(base)                        ((base)->ME)
#define LLWU_PF1_REG(base)                       ((base)->PF1)
#define LLWU_PF2_REG(base)                       ((base)->PF2)
#define LLWU_PF3_REG(base)                       ((base)->PF3)
#define LLWU_PF4_REG(base)                       ((base)->PF4)
#define LLWU_MF5_REG(base)                       ((base)->MF5)
#define LLWU_FILT1_REG(base)                     ((base)->FILT1)
#define LLWU_FILT2_REG(base)                     ((base)->FILT2)
#define LLWU_FILT3_REG(base)                     ((base)->FILT3)
#define LLWU_FILT4_REG(base)                     ((base)->FILT4)

/*!
 * @}
 */ /* end of group LLWU_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- LLWU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Register_Masks LLWU Register Masks
 * @{
 */

/* PE1 Bit Fields */
#define LLWU_PE1_WUPE0_MASK                      0x3u
#define LLWU_PE1_WUPE0_SHIFT                     0
#define LLWU_PE1_WUPE0_WIDTH                     2
#define LLWU_PE1_WUPE0(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE1_WUPE0_SHIFT))&LLWU_PE1_WUPE0_MASK)
#define LLWU_PE1_WUPE1_MASK                      0xCu
#define LLWU_PE1_WUPE1_SHIFT                     2
#define LLWU_PE1_WUPE1_WIDTH                     2
#define LLWU_PE1_WUPE1(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE1_WUPE1_SHIFT))&LLWU_PE1_WUPE1_MASK)
#define LLWU_PE1_WUPE2_MASK                      0x30u
#define LLWU_PE1_WUPE2_SHIFT                     4
#define LLWU_PE1_WUPE2_WIDTH                     2
#define LLWU_PE1_WUPE2(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE1_WUPE2_SHIFT))&LLWU_PE1_WUPE2_MASK)
#define LLWU_PE1_WUPE3_MASK                      0xC0u
#define LLWU_PE1_WUPE3_SHIFT                     6
#define LLWU_PE1_WUPE3_WIDTH                     2
#define LLWU_PE1_WUPE3(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE1_WUPE3_SHIFT))&LLWU_PE1_WUPE3_MASK)
/* PE2 Bit Fields */
#define LLWU_PE2_WUPE4_MASK                      0x3u
#define LLWU_PE2_WUPE4_SHIFT                     0
#define LLWU_PE2_WUPE4_WIDTH                     2
#define LLWU_PE2_WUPE4(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE2_WUPE4_SHIFT))&LLWU_PE2_WUPE4_MASK)
#define LLWU_PE2_WUPE5_MASK                      0xCu
#define LLWU_PE2_WUPE5_SHIFT                     2
#define LLWU_PE2_WUPE5_WIDTH                     2
#define LLWU_PE2_WUPE5(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE2_WUPE5_SHIFT))&LLWU_PE2_WUPE5_MASK)
#define LLWU_PE2_WUPE6_MASK                      0x30u
#define LLWU_PE2_WUPE6_SHIFT                     4
#define LLWU_PE2_WUPE6_WIDTH                     2
#define LLWU_PE2_WUPE6(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE2_WUPE6_SHIFT))&LLWU_PE2_WUPE6_MASK)
#define LLWU_PE2_WUPE7_MASK                      0xC0u
#define LLWU_PE2_WUPE7_SHIFT                     6
#define LLWU_PE2_WUPE7_WIDTH                     2
#define LLWU_PE2_WUPE7(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE2_WUPE7_SHIFT))&LLWU_PE2_WUPE7_MASK)
/* PE3 Bit Fields */
#define LLWU_PE3_WUPE8_MASK                      0x3u
#define LLWU_PE3_WUPE8_SHIFT                     0
#define LLWU_PE3_WUPE8_WIDTH                     2
#define LLWU_PE3_WUPE8(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE3_WUPE8_SHIFT))&LLWU_PE3_WUPE8_MASK)
#define LLWU_PE3_WUPE9_MASK                      0xCu
#define LLWU_PE3_WUPE9_SHIFT                     2
#define LLWU_PE3_WUPE9_WIDTH                     2
#define LLWU_PE3_WUPE9(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PE3_WUPE9_SHIFT))&LLWU_PE3_WUPE9_MASK)
#define LLWU_PE3_WUPE10_MASK                     0x30u
#define LLWU_PE3_WUPE10_SHIFT                    4
#define LLWU_PE3_WUPE10_WIDTH                    2
#define LLWU_PE3_WUPE10(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE3_WUPE10_SHIFT))&LLWU_PE3_WUPE10_MASK)
#define LLWU_PE3_WUPE11_MASK                     0xC0u
#define LLWU_PE3_WUPE11_SHIFT                    6
#define LLWU_PE3_WUPE11_WIDTH                    2
#define LLWU_PE3_WUPE11(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE3_WUPE11_SHIFT))&LLWU_PE3_WUPE11_MASK)
/* PE4 Bit Fields */
#define LLWU_PE4_WUPE12_MASK                     0x3u
#define LLWU_PE4_WUPE12_SHIFT                    0
#define LLWU_PE4_WUPE12_WIDTH                    2
#define LLWU_PE4_WUPE12(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE4_WUPE12_SHIFT))&LLWU_PE4_WUPE12_MASK)
#define LLWU_PE4_WUPE13_MASK                     0xCu
#define LLWU_PE4_WUPE13_SHIFT                    2
#define LLWU_PE4_WUPE13_WIDTH                    2
#define LLWU_PE4_WUPE13(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE4_WUPE13_SHIFT))&LLWU_PE4_WUPE13_MASK)
#define LLWU_PE4_WUPE14_MASK                     0x30u
#define LLWU_PE4_WUPE14_SHIFT                    4
#define LLWU_PE4_WUPE14_WIDTH                    2
#define LLWU_PE4_WUPE14(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE4_WUPE14_SHIFT))&LLWU_PE4_WUPE14_MASK)
#define LLWU_PE4_WUPE15_MASK                     0xC0u
#define LLWU_PE4_WUPE15_SHIFT                    6
#define LLWU_PE4_WUPE15_WIDTH                    2
#define LLWU_PE4_WUPE15(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE4_WUPE15_SHIFT))&LLWU_PE4_WUPE15_MASK)
/* PE5 Bit Fields */
#define LLWU_PE5_WUPE16_MASK                     0x3u
#define LLWU_PE5_WUPE16_SHIFT                    0
#define LLWU_PE5_WUPE16_WIDTH                    2
#define LLWU_PE5_WUPE16(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE5_WUPE16_SHIFT))&LLWU_PE5_WUPE16_MASK)
#define LLWU_PE5_WUPE17_MASK                     0xCu
#define LLWU_PE5_WUPE17_SHIFT                    2
#define LLWU_PE5_WUPE17_WIDTH                    2
#define LLWU_PE5_WUPE17(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE5_WUPE17_SHIFT))&LLWU_PE5_WUPE17_MASK)
#define LLWU_PE5_WUPE18_MASK                     0x30u
#define LLWU_PE5_WUPE18_SHIFT                    4
#define LLWU_PE5_WUPE18_WIDTH                    2
#define LLWU_PE5_WUPE18(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE5_WUPE18_SHIFT))&LLWU_PE5_WUPE18_MASK)
#define LLWU_PE5_WUPE19_MASK                     0xC0u
#define LLWU_PE5_WUPE19_SHIFT                    6
#define LLWU_PE5_WUPE19_WIDTH                    2
#define LLWU_PE5_WUPE19(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE5_WUPE19_SHIFT))&LLWU_PE5_WUPE19_MASK)
/* PE6 Bit Fields */
#define LLWU_PE6_WUPE20_MASK                     0x3u
#define LLWU_PE6_WUPE20_SHIFT                    0
#define LLWU_PE6_WUPE20_WIDTH                    2
#define LLWU_PE6_WUPE20(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE6_WUPE20_SHIFT))&LLWU_PE6_WUPE20_MASK)
#define LLWU_PE6_WUPE21_MASK                     0xCu
#define LLWU_PE6_WUPE21_SHIFT                    2
#define LLWU_PE6_WUPE21_WIDTH                    2
#define LLWU_PE6_WUPE21(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE6_WUPE21_SHIFT))&LLWU_PE6_WUPE21_MASK)
#define LLWU_PE6_WUPE22_MASK                     0x30u
#define LLWU_PE6_WUPE22_SHIFT                    4
#define LLWU_PE6_WUPE22_WIDTH                    2
#define LLWU_PE6_WUPE22(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE6_WUPE22_SHIFT))&LLWU_PE6_WUPE22_MASK)
#define LLWU_PE6_WUPE23_MASK                     0xC0u
#define LLWU_PE6_WUPE23_SHIFT                    6
#define LLWU_PE6_WUPE23_WIDTH                    2
#define LLWU_PE6_WUPE23(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE6_WUPE23_SHIFT))&LLWU_PE6_WUPE23_MASK)
/* PE7 Bit Fields */
#define LLWU_PE7_WUPE24_MASK                     0x3u
#define LLWU_PE7_WUPE24_SHIFT                    0
#define LLWU_PE7_WUPE24_WIDTH                    2
#define LLWU_PE7_WUPE24(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE7_WUPE24_SHIFT))&LLWU_PE7_WUPE24_MASK)
#define LLWU_PE7_WUPE25_MASK                     0xCu
#define LLWU_PE7_WUPE25_SHIFT                    2
#define LLWU_PE7_WUPE25_WIDTH                    2
#define LLWU_PE7_WUPE25(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE7_WUPE25_SHIFT))&LLWU_PE7_WUPE25_MASK)
#define LLWU_PE7_WUPE26_MASK                     0x30u
#define LLWU_PE7_WUPE26_SHIFT                    4
#define LLWU_PE7_WUPE26_WIDTH                    2
#define LLWU_PE7_WUPE26(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE7_WUPE26_SHIFT))&LLWU_PE7_WUPE26_MASK)
#define LLWU_PE7_WUPE27_MASK                     0xC0u
#define LLWU_PE7_WUPE27_SHIFT                    6
#define LLWU_PE7_WUPE27_WIDTH                    2
#define LLWU_PE7_WUPE27(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE7_WUPE27_SHIFT))&LLWU_PE7_WUPE27_MASK)
/* PE8 Bit Fields */
#define LLWU_PE8_WUPE28_MASK                     0x3u
#define LLWU_PE8_WUPE28_SHIFT                    0
#define LLWU_PE8_WUPE28_WIDTH                    2
#define LLWU_PE8_WUPE28(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE8_WUPE28_SHIFT))&LLWU_PE8_WUPE28_MASK)
#define LLWU_PE8_WUPE29_MASK                     0xCu
#define LLWU_PE8_WUPE29_SHIFT                    2
#define LLWU_PE8_WUPE29_WIDTH                    2
#define LLWU_PE8_WUPE29(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE8_WUPE29_SHIFT))&LLWU_PE8_WUPE29_MASK)
#define LLWU_PE8_WUPE30_MASK                     0x30u
#define LLWU_PE8_WUPE30_SHIFT                    4
#define LLWU_PE8_WUPE30_WIDTH                    2
#define LLWU_PE8_WUPE30(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE8_WUPE30_SHIFT))&LLWU_PE8_WUPE30_MASK)
#define LLWU_PE8_WUPE31_MASK                     0xC0u
#define LLWU_PE8_WUPE31_SHIFT                    6
#define LLWU_PE8_WUPE31_WIDTH                    2
#define LLWU_PE8_WUPE31(x)                       (((uint8_t)(((uint8_t)(x))<<LLWU_PE8_WUPE31_SHIFT))&LLWU_PE8_WUPE31_MASK)
/* ME Bit Fields */
#define LLWU_ME_WUME0_MASK                       0x1u
#define LLWU_ME_WUME0_SHIFT                      0
#define LLWU_ME_WUME0_WIDTH                      1
#define LLWU_ME_WUME0(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME0_SHIFT))&LLWU_ME_WUME0_MASK)
#define LLWU_ME_WUME1_MASK                       0x2u
#define LLWU_ME_WUME1_SHIFT                      1
#define LLWU_ME_WUME1_WIDTH                      1
#define LLWU_ME_WUME1(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME1_SHIFT))&LLWU_ME_WUME1_MASK)
#define LLWU_ME_WUME2_MASK                       0x4u
#define LLWU_ME_WUME2_SHIFT                      2
#define LLWU_ME_WUME2_WIDTH                      1
#define LLWU_ME_WUME2(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME2_SHIFT))&LLWU_ME_WUME2_MASK)
#define LLWU_ME_WUME3_MASK                       0x8u
#define LLWU_ME_WUME3_SHIFT                      3
#define LLWU_ME_WUME3_WIDTH                      1
#define LLWU_ME_WUME3(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME3_SHIFT))&LLWU_ME_WUME3_MASK)
#define LLWU_ME_WUME4_MASK                       0x10u
#define LLWU_ME_WUME4_SHIFT                      4
#define LLWU_ME_WUME4_WIDTH                      1
#define LLWU_ME_WUME4(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME4_SHIFT))&LLWU_ME_WUME4_MASK)
#define LLWU_ME_WUME5_MASK                       0x20u
#define LLWU_ME_WUME5_SHIFT                      5
#define LLWU_ME_WUME5_WIDTH                      1
#define LLWU_ME_WUME5(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME5_SHIFT))&LLWU_ME_WUME5_MASK)
#define LLWU_ME_WUME6_MASK                       0x40u
#define LLWU_ME_WUME6_SHIFT                      6
#define LLWU_ME_WUME6_WIDTH                      1
#define LLWU_ME_WUME6(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME6_SHIFT))&LLWU_ME_WUME6_MASK)
#define LLWU_ME_WUME7_MASK                       0x80u
#define LLWU_ME_WUME7_SHIFT                      7
#define LLWU_ME_WUME7_WIDTH                      1
#define LLWU_ME_WUME7(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_ME_WUME7_SHIFT))&LLWU_ME_WUME7_MASK)
/* PF1 Bit Fields */
#define LLWU_PF1_WUF0_MASK                       0x1u
#define LLWU_PF1_WUF0_SHIFT                      0
#define LLWU_PF1_WUF0_WIDTH                      1
#define LLWU_PF1_WUF0(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF0_SHIFT))&LLWU_PF1_WUF0_MASK)
#define LLWU_PF1_WUF1_MASK                       0x2u
#define LLWU_PF1_WUF1_SHIFT                      1
#define LLWU_PF1_WUF1_WIDTH                      1
#define LLWU_PF1_WUF1(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF1_SHIFT))&LLWU_PF1_WUF1_MASK)
#define LLWU_PF1_WUF2_MASK                       0x4u
#define LLWU_PF1_WUF2_SHIFT                      2
#define LLWU_PF1_WUF2_WIDTH                      1
#define LLWU_PF1_WUF2(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF2_SHIFT))&LLWU_PF1_WUF2_MASK)
#define LLWU_PF1_WUF3_MASK                       0x8u
#define LLWU_PF1_WUF3_SHIFT                      3
#define LLWU_PF1_WUF3_WIDTH                      1
#define LLWU_PF1_WUF3(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF3_SHIFT))&LLWU_PF1_WUF3_MASK)
#define LLWU_PF1_WUF4_MASK                       0x10u
#define LLWU_PF1_WUF4_SHIFT                      4
#define LLWU_PF1_WUF4_WIDTH                      1
#define LLWU_PF1_WUF4(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF4_SHIFT))&LLWU_PF1_WUF4_MASK)
#define LLWU_PF1_WUF5_MASK                       0x20u
#define LLWU_PF1_WUF5_SHIFT                      5
#define LLWU_PF1_WUF5_WIDTH                      1
#define LLWU_PF1_WUF5(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF5_SHIFT))&LLWU_PF1_WUF5_MASK)
#define LLWU_PF1_WUF6_MASK                       0x40u
#define LLWU_PF1_WUF6_SHIFT                      6
#define LLWU_PF1_WUF6_WIDTH                      1
#define LLWU_PF1_WUF6(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF6_SHIFT))&LLWU_PF1_WUF6_MASK)
#define LLWU_PF1_WUF7_MASK                       0x80u
#define LLWU_PF1_WUF7_SHIFT                      7
#define LLWU_PF1_WUF7_WIDTH                      1
#define LLWU_PF1_WUF7(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF1_WUF7_SHIFT))&LLWU_PF1_WUF7_MASK)
/* PF2 Bit Fields */
#define LLWU_PF2_WUF8_MASK                       0x1u
#define LLWU_PF2_WUF8_SHIFT                      0
#define LLWU_PF2_WUF8_WIDTH                      1
#define LLWU_PF2_WUF8(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF8_SHIFT))&LLWU_PF2_WUF8_MASK)
#define LLWU_PF2_WUF9_MASK                       0x2u
#define LLWU_PF2_WUF9_SHIFT                      1
#define LLWU_PF2_WUF9_WIDTH                      1
#define LLWU_PF2_WUF9(x)                         (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF9_SHIFT))&LLWU_PF2_WUF9_MASK)
#define LLWU_PF2_WUF10_MASK                      0x4u
#define LLWU_PF2_WUF10_SHIFT                     2
#define LLWU_PF2_WUF10_WIDTH                     1
#define LLWU_PF2_WUF10(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF10_SHIFT))&LLWU_PF2_WUF10_MASK)
#define LLWU_PF2_WUF11_MASK                      0x8u
#define LLWU_PF2_WUF11_SHIFT                     3
#define LLWU_PF2_WUF11_WIDTH                     1
#define LLWU_PF2_WUF11(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF11_SHIFT))&LLWU_PF2_WUF11_MASK)
#define LLWU_PF2_WUF12_MASK                      0x10u
#define LLWU_PF2_WUF12_SHIFT                     4
#define LLWU_PF2_WUF12_WIDTH                     1
#define LLWU_PF2_WUF12(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF12_SHIFT))&LLWU_PF2_WUF12_MASK)
#define LLWU_PF2_WUF13_MASK                      0x20u
#define LLWU_PF2_WUF13_SHIFT                     5
#define LLWU_PF2_WUF13_WIDTH                     1
#define LLWU_PF2_WUF13(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF13_SHIFT))&LLWU_PF2_WUF13_MASK)
#define LLWU_PF2_WUF14_MASK                      0x40u
#define LLWU_PF2_WUF14_SHIFT                     6
#define LLWU_PF2_WUF14_WIDTH                     1
#define LLWU_PF2_WUF14(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF14_SHIFT))&LLWU_PF2_WUF14_MASK)
#define LLWU_PF2_WUF15_MASK                      0x80u
#define LLWU_PF2_WUF15_SHIFT                     7
#define LLWU_PF2_WUF15_WIDTH                     1
#define LLWU_PF2_WUF15(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF2_WUF15_SHIFT))&LLWU_PF2_WUF15_MASK)
/* PF3 Bit Fields */
#define LLWU_PF3_WUF16_MASK                      0x1u
#define LLWU_PF3_WUF16_SHIFT                     0
#define LLWU_PF3_WUF16_WIDTH                     1
#define LLWU_PF3_WUF16(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF16_SHIFT))&LLWU_PF3_WUF16_MASK)
#define LLWU_PF3_WUF17_MASK                      0x2u
#define LLWU_PF3_WUF17_SHIFT                     1
#define LLWU_PF3_WUF17_WIDTH                     1
#define LLWU_PF3_WUF17(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF17_SHIFT))&LLWU_PF3_WUF17_MASK)
#define LLWU_PF3_WUF18_MASK                      0x4u
#define LLWU_PF3_WUF18_SHIFT                     2
#define LLWU_PF3_WUF18_WIDTH                     1
#define LLWU_PF3_WUF18(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF18_SHIFT))&LLWU_PF3_WUF18_MASK)
#define LLWU_PF3_WUF19_MASK                      0x8u
#define LLWU_PF3_WUF19_SHIFT                     3
#define LLWU_PF3_WUF19_WIDTH                     1
#define LLWU_PF3_WUF19(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF19_SHIFT))&LLWU_PF3_WUF19_MASK)
#define LLWU_PF3_WUF20_MASK                      0x10u
#define LLWU_PF3_WUF20_SHIFT                     4
#define LLWU_PF3_WUF20_WIDTH                     1
#define LLWU_PF3_WUF20(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF20_SHIFT))&LLWU_PF3_WUF20_MASK)
#define LLWU_PF3_WUF21_MASK                      0x20u
#define LLWU_PF3_WUF21_SHIFT                     5
#define LLWU_PF3_WUF21_WIDTH                     1
#define LLWU_PF3_WUF21(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF21_SHIFT))&LLWU_PF3_WUF21_MASK)
#define LLWU_PF3_WUF22_MASK                      0x40u
#define LLWU_PF3_WUF22_SHIFT                     6
#define LLWU_PF3_WUF22_WIDTH                     1
#define LLWU_PF3_WUF22(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF22_SHIFT))&LLWU_PF3_WUF22_MASK)
#define LLWU_PF3_WUF23_MASK                      0x80u
#define LLWU_PF3_WUF23_SHIFT                     7
#define LLWU_PF3_WUF23_WIDTH                     1
#define LLWU_PF3_WUF23(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF3_WUF23_SHIFT))&LLWU_PF3_WUF23_MASK)
/* PF4 Bit Fields */
#define LLWU_PF4_WUF24_MASK                      0x1u
#define LLWU_PF4_WUF24_SHIFT                     0
#define LLWU_PF4_WUF24_WIDTH                     1
#define LLWU_PF4_WUF24(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF24_SHIFT))&LLWU_PF4_WUF24_MASK)
#define LLWU_PF4_WUF25_MASK                      0x2u
#define LLWU_PF4_WUF25_SHIFT                     1
#define LLWU_PF4_WUF25_WIDTH                     1
#define LLWU_PF4_WUF25(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF25_SHIFT))&LLWU_PF4_WUF25_MASK)
#define LLWU_PF4_WUF26_MASK                      0x4u
#define LLWU_PF4_WUF26_SHIFT                     2
#define LLWU_PF4_WUF26_WIDTH                     1
#define LLWU_PF4_WUF26(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF26_SHIFT))&LLWU_PF4_WUF26_MASK)
#define LLWU_PF4_WUF27_MASK                      0x8u
#define LLWU_PF4_WUF27_SHIFT                     3
#define LLWU_PF4_WUF27_WIDTH                     1
#define LLWU_PF4_WUF27(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF27_SHIFT))&LLWU_PF4_WUF27_MASK)
#define LLWU_PF4_WUF28_MASK                      0x10u
#define LLWU_PF4_WUF28_SHIFT                     4
#define LLWU_PF4_WUF28_WIDTH                     1
#define LLWU_PF4_WUF28(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF28_SHIFT))&LLWU_PF4_WUF28_MASK)
#define LLWU_PF4_WUF29_MASK                      0x20u
#define LLWU_PF4_WUF29_SHIFT                     5
#define LLWU_PF4_WUF29_WIDTH                     1
#define LLWU_PF4_WUF29(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF29_SHIFT))&LLWU_PF4_WUF29_MASK)
#define LLWU_PF4_WUF30_MASK                      0x40u
#define LLWU_PF4_WUF30_SHIFT                     6
#define LLWU_PF4_WUF30_WIDTH                     1
#define LLWU_PF4_WUF30(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF30_SHIFT))&LLWU_PF4_WUF30_MASK)
#define LLWU_PF4_WUF31_MASK                      0x80u
#define LLWU_PF4_WUF31_SHIFT                     7
#define LLWU_PF4_WUF31_WIDTH                     1
#define LLWU_PF4_WUF31(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_PF4_WUF31_SHIFT))&LLWU_PF4_WUF31_MASK)
/* MF5 Bit Fields */
#define LLWU_MF5_MWUF0_MASK                      0x1u
#define LLWU_MF5_MWUF0_SHIFT                     0
#define LLWU_MF5_MWUF0_WIDTH                     1
#define LLWU_MF5_MWUF0(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF0_SHIFT))&LLWU_MF5_MWUF0_MASK)
#define LLWU_MF5_MWUF1_MASK                      0x2u
#define LLWU_MF5_MWUF1_SHIFT                     1
#define LLWU_MF5_MWUF1_WIDTH                     1
#define LLWU_MF5_MWUF1(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF1_SHIFT))&LLWU_MF5_MWUF1_MASK)
#define LLWU_MF5_MWUF2_MASK                      0x4u
#define LLWU_MF5_MWUF2_SHIFT                     2
#define LLWU_MF5_MWUF2_WIDTH                     1
#define LLWU_MF5_MWUF2(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF2_SHIFT))&LLWU_MF5_MWUF2_MASK)
#define LLWU_MF5_MWUF3_MASK                      0x8u
#define LLWU_MF5_MWUF3_SHIFT                     3
#define LLWU_MF5_MWUF3_WIDTH                     1
#define LLWU_MF5_MWUF3(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF3_SHIFT))&LLWU_MF5_MWUF3_MASK)
#define LLWU_MF5_MWUF4_MASK                      0x10u
#define LLWU_MF5_MWUF4_SHIFT                     4
#define LLWU_MF5_MWUF4_WIDTH                     1
#define LLWU_MF5_MWUF4(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF4_SHIFT))&LLWU_MF5_MWUF4_MASK)
#define LLWU_MF5_MWUF5_MASK                      0x20u
#define LLWU_MF5_MWUF5_SHIFT                     5
#define LLWU_MF5_MWUF5_WIDTH                     1
#define LLWU_MF5_MWUF5(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF5_SHIFT))&LLWU_MF5_MWUF5_MASK)
#define LLWU_MF5_MWUF6_MASK                      0x40u
#define LLWU_MF5_MWUF6_SHIFT                     6
#define LLWU_MF5_MWUF6_WIDTH                     1
#define LLWU_MF5_MWUF6(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF6_SHIFT))&LLWU_MF5_MWUF6_MASK)
#define LLWU_MF5_MWUF7_MASK                      0x80u
#define LLWU_MF5_MWUF7_SHIFT                     7
#define LLWU_MF5_MWUF7_WIDTH                     1
#define LLWU_MF5_MWUF7(x)                        (((uint8_t)(((uint8_t)(x))<<LLWU_MF5_MWUF7_SHIFT))&LLWU_MF5_MWUF7_MASK)
/* FILT1 Bit Fields */
#define LLWU_FILT1_FILTSEL_MASK                  0x1Fu
#define LLWU_FILT1_FILTSEL_SHIFT                 0
#define LLWU_FILT1_FILTSEL_WIDTH                 5
#define LLWU_FILT1_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x))<<LLWU_FILT1_FILTSEL_SHIFT))&LLWU_FILT1_FILTSEL_MASK)
#define LLWU_FILT1_FILTE_MASK                    0x60u
#define LLWU_FILT1_FILTE_SHIFT                   5
#define LLWU_FILT1_FILTE_WIDTH                   2
#define LLWU_FILT1_FILTE(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT1_FILTE_SHIFT))&LLWU_FILT1_FILTE_MASK)
#define LLWU_FILT1_FILTF_MASK                    0x80u
#define LLWU_FILT1_FILTF_SHIFT                   7
#define LLWU_FILT1_FILTF_WIDTH                   1
#define LLWU_FILT1_FILTF(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT1_FILTF_SHIFT))&LLWU_FILT1_FILTF_MASK)
/* FILT2 Bit Fields */
#define LLWU_FILT2_FILTSEL_MASK                  0x1Fu
#define LLWU_FILT2_FILTSEL_SHIFT                 0
#define LLWU_FILT2_FILTSEL_WIDTH                 5
#define LLWU_FILT2_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x))<<LLWU_FILT2_FILTSEL_SHIFT))&LLWU_FILT2_FILTSEL_MASK)
#define LLWU_FILT2_FILTE_MASK                    0x60u
#define LLWU_FILT2_FILTE_SHIFT                   5
#define LLWU_FILT2_FILTE_WIDTH                   2
#define LLWU_FILT2_FILTE(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT2_FILTE_SHIFT))&LLWU_FILT2_FILTE_MASK)
#define LLWU_FILT2_FILTF_MASK                    0x80u
#define LLWU_FILT2_FILTF_SHIFT                   7
#define LLWU_FILT2_FILTF_WIDTH                   1
#define LLWU_FILT2_FILTF(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT2_FILTF_SHIFT))&LLWU_FILT2_FILTF_MASK)
/* FILT3 Bit Fields */
#define LLWU_FILT3_FILTSEL_MASK                  0x1Fu
#define LLWU_FILT3_FILTSEL_SHIFT                 0
#define LLWU_FILT3_FILTSEL_WIDTH                 5
#define LLWU_FILT3_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x))<<LLWU_FILT3_FILTSEL_SHIFT))&LLWU_FILT3_FILTSEL_MASK)
#define LLWU_FILT3_FILTE_MASK                    0x60u
#define LLWU_FILT3_FILTE_SHIFT                   5
#define LLWU_FILT3_FILTE_WIDTH                   2
#define LLWU_FILT3_FILTE(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT3_FILTE_SHIFT))&LLWU_FILT3_FILTE_MASK)
#define LLWU_FILT3_FILTF_MASK                    0x80u
#define LLWU_FILT3_FILTF_SHIFT                   7
#define LLWU_FILT3_FILTF_WIDTH                   1
#define LLWU_FILT3_FILTF(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT3_FILTF_SHIFT))&LLWU_FILT3_FILTF_MASK)
/* FILT4 Bit Fields */
#define LLWU_FILT4_FILTSEL_MASK                  0x1Fu
#define LLWU_FILT4_FILTSEL_SHIFT                 0
#define LLWU_FILT4_FILTSEL_WIDTH                 5
#define LLWU_FILT4_FILTSEL(x)                    (((uint8_t)(((uint8_t)(x))<<LLWU_FILT4_FILTSEL_SHIFT))&LLWU_FILT4_FILTSEL_MASK)
#define LLWU_FILT4_FILTE_MASK                    0x60u
#define LLWU_FILT4_FILTE_SHIFT                   5
#define LLWU_FILT4_FILTE_WIDTH                   2
#define LLWU_FILT4_FILTE(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT4_FILTE_SHIFT))&LLWU_FILT4_FILTE_MASK)
#define LLWU_FILT4_FILTF_MASK                    0x80u
#define LLWU_FILT4_FILTF_SHIFT                   7
#define LLWU_FILT4_FILTF_WIDTH                   1
#define LLWU_FILT4_FILTF(x)                      (((uint8_t)(((uint8_t)(x))<<LLWU_FILT4_FILTF_SHIFT))&LLWU_FILT4_FILTF_MASK)

/*!
 * @}
 */ /* end of group LLWU_Register_Masks */


/* LLWU - Peripheral instance base addresses */
/** Peripheral LLWU base address */
#define LLWU_BASE                                (0x4007C000u)
/** Peripheral LLWU base pointer */
#define LLWU                                     ((LLWU_Type *)LLWU_BASE)
#define LLWU_BASE_PTR                            (LLWU)
/** Array initializer of LLWU peripheral base addresses */
#define LLWU_BASE_ADDRS                          { LLWU_BASE }
/** Array initializer of LLWU peripheral base pointers */
#define LLWU_BASE_PTRS                           { LLWU }

/* ----------------------------------------------------------------------------
   -- LLWU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LLWU_Register_Accessor_Macros LLWU - Register accessor macros
 * @{
 */


/* LLWU - Register instance definitions */
/* LLWU */
#define LLWU_PE1                                 LLWU_PE1_REG(LLWU)
#define LLWU_PE2                                 LLWU_PE2_REG(LLWU)
#define LLWU_PE3                                 LLWU_PE3_REG(LLWU)
#define LLWU_PE4                                 LLWU_PE4_REG(LLWU)
#define LLWU_PE5                                 LLWU_PE5_REG(LLWU)
#define LLWU_PE6                                 LLWU_PE6_REG(LLWU)
#define LLWU_PE7                                 LLWU_PE7_REG(LLWU)
#define LLWU_PE8                                 LLWU_PE8_REG(LLWU)
#define LLWU_ME                                  LLWU_ME_REG(LLWU)
#define LLWU_PF1                                 LLWU_PF1_REG(LLWU)
#define LLWU_PF2                                 LLWU_PF2_REG(LLWU)
#define LLWU_PF3                                 LLWU_PF3_REG(LLWU)
#define LLWU_PF4                                 LLWU_PF4_REG(LLWU)
#define LLWU_MF5                                 LLWU_MF5_REG(LLWU)
#define LLWU_FILT1                               LLWU_FILT1_REG(LLWU)
#define LLWU_FILT2                               LLWU_FILT2_REG(LLWU)
#define LLWU_FILT3                               LLWU_FILT3_REG(LLWU)
#define LLWU_FILT4                               LLWU_FILT4_REG(LLWU)

/*!
 * @}
 */ /* end of group LLWU_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group LLWU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LPTMR Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Peripheral_Access_Layer LPTMR Peripheral Access Layer
 * @{
 */

/** LPTMR - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSR;                               /**< Low Power Timer Control Status Register, offset: 0x0 */
  __IO uint32_t PSR;                               /**< Low Power Timer Prescale Register, offset: 0x4 */
  __IO uint32_t CMR;                               /**< Low Power Timer Compare Register, offset: 0x8 */
  __IO uint32_t CNR;                               /**< Low Power Timer Counter Register, offset: 0xC */
} LPTMR_Type, *LPTMR_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- LPTMR - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Register_Accessor_Macros LPTMR - Register accessor macros
 * @{
 */


/* LPTMR - Register accessors */
#define LPTMR_CSR_REG(base)                      ((base)->CSR)
#define LPTMR_PSR_REG(base)                      ((base)->PSR)
#define LPTMR_CMR_REG(base)                      ((base)->CMR)
#define LPTMR_CNR_REG(base)                      ((base)->CNR)

/*!
 * @}
 */ /* end of group LPTMR_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- LPTMR Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Register_Masks LPTMR Register Masks
 * @{
 */

/* CSR Bit Fields */
#define LPTMR_CSR_TEN_MASK                       0x1u
#define LPTMR_CSR_TEN_SHIFT                      0
#define LPTMR_CSR_TEN_WIDTH                      1
#define LPTMR_CSR_TEN(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TEN_SHIFT))&LPTMR_CSR_TEN_MASK)
#define LPTMR_CSR_TMS_MASK                       0x2u
#define LPTMR_CSR_TMS_SHIFT                      1
#define LPTMR_CSR_TMS_WIDTH                      1
#define LPTMR_CSR_TMS(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TMS_SHIFT))&LPTMR_CSR_TMS_MASK)
#define LPTMR_CSR_TFC_MASK                       0x4u
#define LPTMR_CSR_TFC_SHIFT                      2
#define LPTMR_CSR_TFC_WIDTH                      1
#define LPTMR_CSR_TFC(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TFC_SHIFT))&LPTMR_CSR_TFC_MASK)
#define LPTMR_CSR_TPP_MASK                       0x8u
#define LPTMR_CSR_TPP_SHIFT                      3
#define LPTMR_CSR_TPP_WIDTH                      1
#define LPTMR_CSR_TPP(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TPP_SHIFT))&LPTMR_CSR_TPP_MASK)
#define LPTMR_CSR_TPS_MASK                       0x30u
#define LPTMR_CSR_TPS_SHIFT                      4
#define LPTMR_CSR_TPS_WIDTH                      2
#define LPTMR_CSR_TPS(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TPS_SHIFT))&LPTMR_CSR_TPS_MASK)
#define LPTMR_CSR_TIE_MASK                       0x40u
#define LPTMR_CSR_TIE_SHIFT                      6
#define LPTMR_CSR_TIE_WIDTH                      1
#define LPTMR_CSR_TIE(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TIE_SHIFT))&LPTMR_CSR_TIE_MASK)
#define LPTMR_CSR_TCF_MASK                       0x80u
#define LPTMR_CSR_TCF_SHIFT                      7
#define LPTMR_CSR_TCF_WIDTH                      1
#define LPTMR_CSR_TCF(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_CSR_TCF_SHIFT))&LPTMR_CSR_TCF_MASK)
/* PSR Bit Fields */
#define LPTMR_PSR_PCS_MASK                       0x3u
#define LPTMR_PSR_PCS_SHIFT                      0
#define LPTMR_PSR_PCS_WIDTH                      2
#define LPTMR_PSR_PCS(x)                         (((uint32_t)(((uint32_t)(x))<<LPTMR_PSR_PCS_SHIFT))&LPTMR_PSR_PCS_MASK)
#define LPTMR_PSR_PBYP_MASK                      0x4u
#define LPTMR_PSR_PBYP_SHIFT                     2
#define LPTMR_PSR_PBYP_WIDTH                     1
#define LPTMR_PSR_PBYP(x)                        (((uint32_t)(((uint32_t)(x))<<LPTMR_PSR_PBYP_SHIFT))&LPTMR_PSR_PBYP_MASK)
#define LPTMR_PSR_PRESCALE_MASK                  0x78u
#define LPTMR_PSR_PRESCALE_SHIFT                 3
#define LPTMR_PSR_PRESCALE_WIDTH                 4
#define LPTMR_PSR_PRESCALE(x)                    (((uint32_t)(((uint32_t)(x))<<LPTMR_PSR_PRESCALE_SHIFT))&LPTMR_PSR_PRESCALE_MASK)
/* CMR Bit Fields */
#define LPTMR_CMR_COMPARE_MASK                   0xFFFFu
#define LPTMR_CMR_COMPARE_SHIFT                  0
#define LPTMR_CMR_COMPARE_WIDTH                  16
#define LPTMR_CMR_COMPARE(x)                     (((uint32_t)(((uint32_t)(x))<<LPTMR_CMR_COMPARE_SHIFT))&LPTMR_CMR_COMPARE_MASK)
/* CNR Bit Fields */
#define LPTMR_CNR_COUNTER_MASK                   0xFFFFu
#define LPTMR_CNR_COUNTER_SHIFT                  0
#define LPTMR_CNR_COUNTER_WIDTH                  16
#define LPTMR_CNR_COUNTER(x)                     (((uint32_t)(((uint32_t)(x))<<LPTMR_CNR_COUNTER_SHIFT))&LPTMR_CNR_COUNTER_MASK)

/*!
 * @}
 */ /* end of group LPTMR_Register_Masks */


/* LPTMR - Peripheral instance base addresses */
/** Peripheral LPTMR0 base address */
#define LPTMR0_BASE                              (0x40040000u)
/** Peripheral LPTMR0 base pointer */
#define LPTMR0                                   ((LPTMR_Type *)LPTMR0_BASE)
#define LPTMR0_BASE_PTR                          (LPTMR0)
/** Peripheral LPTMR1 base address */
#define LPTMR1_BASE                              (0x40044000u)
/** Peripheral LPTMR1 base pointer */
#define LPTMR1                                   ((LPTMR_Type *)LPTMR1_BASE)
#define LPTMR1_BASE_PTR                          (LPTMR1)
/** Array initializer of LPTMR peripheral base addresses */
#define LPTMR_BASE_ADDRS                         { LPTMR0_BASE, LPTMR1_BASE }
/** Array initializer of LPTMR peripheral base pointers */
#define LPTMR_BASE_PTRS                          { LPTMR0, LPTMR1 }

/* ----------------------------------------------------------------------------
   -- LPTMR - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPTMR_Register_Accessor_Macros LPTMR - Register accessor macros
 * @{
 */


/* LPTMR - Register instance definitions */
/* LPTMR0 */
#define LPTMR0_CSR                               LPTMR_CSR_REG(LPTMR0)
#define LPTMR0_PSR                               LPTMR_PSR_REG(LPTMR0)
#define LPTMR0_CMR                               LPTMR_CMR_REG(LPTMR0)
#define LPTMR0_CNR                               LPTMR_CNR_REG(LPTMR0)
/* LPTMR1 */
#define LPTMR1_CSR                               LPTMR_CSR_REG(LPTMR1)
#define LPTMR1_PSR                               LPTMR_PSR_REG(LPTMR1)
#define LPTMR1_CMR                               LPTMR_CMR_REG(LPTMR1)
#define LPTMR1_CNR                               LPTMR_CNR_REG(LPTMR1)

/*!
 * @}
 */ /* end of group LPTMR_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group LPTMR_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LPUART Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPUART_Peripheral_Access_Layer LPUART Peripheral Access Layer
 * @{
 */

/** LPUART - Register Layout Typedef */
typedef struct {
  __IO uint32_t BAUD;                              /**< LPUART Baud Rate Register, offset: 0x0 */
  __IO uint32_t STAT;                              /**< LPUART Status Register, offset: 0x4 */
  __IO uint32_t CTRL;                              /**< LPUART Control Register, offset: 0x8 */
  __IO uint32_t DATA;                              /**< LPUART Data Register, offset: 0xC */
  __IO uint32_t MATCH;                             /**< LPUART Match Address Register, offset: 0x10 */
  __IO uint32_t MODIR;                             /**< LPUART Modem IrDA Register, offset: 0x14 */
  __IO uint32_t FIFO;                              /**< LPUART FIFO Register, offset: 0x18 */
  __IO uint32_t WATER;                             /**< LPUART Watermark Register, offset: 0x1C */
} LPUART_Type, *LPUART_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- LPUART - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPUART_Register_Accessor_Macros LPUART - Register accessor macros
 * @{
 */


/* LPUART - Register accessors */
#define LPUART_BAUD_REG(base)                    ((base)->BAUD)
#define LPUART_STAT_REG(base)                    ((base)->STAT)
#define LPUART_CTRL_REG(base)                    ((base)->CTRL)
#define LPUART_DATA_REG(base)                    ((base)->DATA)
#define LPUART_MATCH_REG(base)                   ((base)->MATCH)
#define LPUART_MODIR_REG(base)                   ((base)->MODIR)
#define LPUART_FIFO_REG(base)                    ((base)->FIFO)
#define LPUART_WATER_REG(base)                   ((base)->WATER)

/*!
 * @}
 */ /* end of group LPUART_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- LPUART Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPUART_Register_Masks LPUART Register Masks
 * @{
 */

/* BAUD Bit Fields */
#define LPUART_BAUD_SBR_MASK                     0x1FFFu
#define LPUART_BAUD_SBR_SHIFT                    0
#define LPUART_BAUD_SBR_WIDTH                    13
#define LPUART_BAUD_SBR(x)                       (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_SBR_SHIFT))&LPUART_BAUD_SBR_MASK)
#define LPUART_BAUD_SBNS_MASK                    0x2000u
#define LPUART_BAUD_SBNS_SHIFT                   13
#define LPUART_BAUD_SBNS_WIDTH                   1
#define LPUART_BAUD_SBNS(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_SBNS_SHIFT))&LPUART_BAUD_SBNS_MASK)
#define LPUART_BAUD_RXEDGIE_MASK                 0x4000u
#define LPUART_BAUD_RXEDGIE_SHIFT                14
#define LPUART_BAUD_RXEDGIE_WIDTH                1
#define LPUART_BAUD_RXEDGIE(x)                   (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_RXEDGIE_SHIFT))&LPUART_BAUD_RXEDGIE_MASK)
#define LPUART_BAUD_LBKDIE_MASK                  0x8000u
#define LPUART_BAUD_LBKDIE_SHIFT                 15
#define LPUART_BAUD_LBKDIE_WIDTH                 1
#define LPUART_BAUD_LBKDIE(x)                    (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_LBKDIE_SHIFT))&LPUART_BAUD_LBKDIE_MASK)
#define LPUART_BAUD_RESYNCDIS_MASK               0x10000u
#define LPUART_BAUD_RESYNCDIS_SHIFT              16
#define LPUART_BAUD_RESYNCDIS_WIDTH              1
#define LPUART_BAUD_RESYNCDIS(x)                 (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_RESYNCDIS_SHIFT))&LPUART_BAUD_RESYNCDIS_MASK)
#define LPUART_BAUD_BOTHEDGE_MASK                0x20000u
#define LPUART_BAUD_BOTHEDGE_SHIFT               17
#define LPUART_BAUD_BOTHEDGE_WIDTH               1
#define LPUART_BAUD_BOTHEDGE(x)                  (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_BOTHEDGE_SHIFT))&LPUART_BAUD_BOTHEDGE_MASK)
#define LPUART_BAUD_MATCFG_MASK                  0xC0000u
#define LPUART_BAUD_MATCFG_SHIFT                 18
#define LPUART_BAUD_MATCFG_WIDTH                 2
#define LPUART_BAUD_MATCFG(x)                    (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_MATCFG_SHIFT))&LPUART_BAUD_MATCFG_MASK)
#define LPUART_BAUD_RDMAE_MASK                   0x200000u
#define LPUART_BAUD_RDMAE_SHIFT                  21
#define LPUART_BAUD_RDMAE_WIDTH                  1
#define LPUART_BAUD_RDMAE(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_RDMAE_SHIFT))&LPUART_BAUD_RDMAE_MASK)
#define LPUART_BAUD_TDMAE_MASK                   0x800000u
#define LPUART_BAUD_TDMAE_SHIFT                  23
#define LPUART_BAUD_TDMAE_WIDTH                  1
#define LPUART_BAUD_TDMAE(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_TDMAE_SHIFT))&LPUART_BAUD_TDMAE_MASK)
#define LPUART_BAUD_OSR_MASK                     0x1F000000u
#define LPUART_BAUD_OSR_SHIFT                    24
#define LPUART_BAUD_OSR_WIDTH                    5
#define LPUART_BAUD_OSR(x)                       (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_OSR_SHIFT))&LPUART_BAUD_OSR_MASK)
#define LPUART_BAUD_M10_MASK                     0x20000000u
#define LPUART_BAUD_M10_SHIFT                    29
#define LPUART_BAUD_M10_WIDTH                    1
#define LPUART_BAUD_M10(x)                       (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_M10_SHIFT))&LPUART_BAUD_M10_MASK)
#define LPUART_BAUD_MAEN2_MASK                   0x40000000u
#define LPUART_BAUD_MAEN2_SHIFT                  30
#define LPUART_BAUD_MAEN2_WIDTH                  1
#define LPUART_BAUD_MAEN2(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_MAEN2_SHIFT))&LPUART_BAUD_MAEN2_MASK)
#define LPUART_BAUD_MAEN1_MASK                   0x80000000u
#define LPUART_BAUD_MAEN1_SHIFT                  31
#define LPUART_BAUD_MAEN1_WIDTH                  1
#define LPUART_BAUD_MAEN1(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_BAUD_MAEN1_SHIFT))&LPUART_BAUD_MAEN1_MASK)
/* STAT Bit Fields */
#define LPUART_STAT_MA2F_MASK                    0x4000u
#define LPUART_STAT_MA2F_SHIFT                   14
#define LPUART_STAT_MA2F_WIDTH                   1
#define LPUART_STAT_MA2F(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_MA2F_SHIFT))&LPUART_STAT_MA2F_MASK)
#define LPUART_STAT_MA1F_MASK                    0x8000u
#define LPUART_STAT_MA1F_SHIFT                   15
#define LPUART_STAT_MA1F_WIDTH                   1
#define LPUART_STAT_MA1F(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_MA1F_SHIFT))&LPUART_STAT_MA1F_MASK)
#define LPUART_STAT_PF_MASK                      0x10000u
#define LPUART_STAT_PF_SHIFT                     16
#define LPUART_STAT_PF_WIDTH                     1
#define LPUART_STAT_PF(x)                        (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_PF_SHIFT))&LPUART_STAT_PF_MASK)
#define LPUART_STAT_FE_MASK                      0x20000u
#define LPUART_STAT_FE_SHIFT                     17
#define LPUART_STAT_FE_WIDTH                     1
#define LPUART_STAT_FE(x)                        (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_FE_SHIFT))&LPUART_STAT_FE_MASK)
#define LPUART_STAT_NF_MASK                      0x40000u
#define LPUART_STAT_NF_SHIFT                     18
#define LPUART_STAT_NF_WIDTH                     1
#define LPUART_STAT_NF(x)                        (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_NF_SHIFT))&LPUART_STAT_NF_MASK)
#define LPUART_STAT_OR_MASK                      0x80000u
#define LPUART_STAT_OR_SHIFT                     19
#define LPUART_STAT_OR_WIDTH                     1
#define LPUART_STAT_OR(x)                        (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_OR_SHIFT))&LPUART_STAT_OR_MASK)
#define LPUART_STAT_IDLE_MASK                    0x100000u
#define LPUART_STAT_IDLE_SHIFT                   20
#define LPUART_STAT_IDLE_WIDTH                   1
#define LPUART_STAT_IDLE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_IDLE_SHIFT))&LPUART_STAT_IDLE_MASK)
#define LPUART_STAT_RDRF_MASK                    0x200000u
#define LPUART_STAT_RDRF_SHIFT                   21
#define LPUART_STAT_RDRF_WIDTH                   1
#define LPUART_STAT_RDRF(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_RDRF_SHIFT))&LPUART_STAT_RDRF_MASK)
#define LPUART_STAT_TC_MASK                      0x400000u
#define LPUART_STAT_TC_SHIFT                     22
#define LPUART_STAT_TC_WIDTH                     1
#define LPUART_STAT_TC(x)                        (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_TC_SHIFT))&LPUART_STAT_TC_MASK)
#define LPUART_STAT_TDRE_MASK                    0x800000u
#define LPUART_STAT_TDRE_SHIFT                   23
#define LPUART_STAT_TDRE_WIDTH                   1
#define LPUART_STAT_TDRE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_TDRE_SHIFT))&LPUART_STAT_TDRE_MASK)
#define LPUART_STAT_RAF_MASK                     0x1000000u
#define LPUART_STAT_RAF_SHIFT                    24
#define LPUART_STAT_RAF_WIDTH                    1
#define LPUART_STAT_RAF(x)                       (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_RAF_SHIFT))&LPUART_STAT_RAF_MASK)
#define LPUART_STAT_LBKDE_MASK                   0x2000000u
#define LPUART_STAT_LBKDE_SHIFT                  25
#define LPUART_STAT_LBKDE_WIDTH                  1
#define LPUART_STAT_LBKDE(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_LBKDE_SHIFT))&LPUART_STAT_LBKDE_MASK)
#define LPUART_STAT_BRK13_MASK                   0x4000000u
#define LPUART_STAT_BRK13_SHIFT                  26
#define LPUART_STAT_BRK13_WIDTH                  1
#define LPUART_STAT_BRK13(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_BRK13_SHIFT))&LPUART_STAT_BRK13_MASK)
#define LPUART_STAT_RWUID_MASK                   0x8000000u
#define LPUART_STAT_RWUID_SHIFT                  27
#define LPUART_STAT_RWUID_WIDTH                  1
#define LPUART_STAT_RWUID(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_RWUID_SHIFT))&LPUART_STAT_RWUID_MASK)
#define LPUART_STAT_RXINV_MASK                   0x10000000u
#define LPUART_STAT_RXINV_SHIFT                  28
#define LPUART_STAT_RXINV_WIDTH                  1
#define LPUART_STAT_RXINV(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_RXINV_SHIFT))&LPUART_STAT_RXINV_MASK)
#define LPUART_STAT_MSBF_MASK                    0x20000000u
#define LPUART_STAT_MSBF_SHIFT                   29
#define LPUART_STAT_MSBF_WIDTH                   1
#define LPUART_STAT_MSBF(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_MSBF_SHIFT))&LPUART_STAT_MSBF_MASK)
#define LPUART_STAT_RXEDGIF_MASK                 0x40000000u
#define LPUART_STAT_RXEDGIF_SHIFT                30
#define LPUART_STAT_RXEDGIF_WIDTH                1
#define LPUART_STAT_RXEDGIF(x)                   (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_RXEDGIF_SHIFT))&LPUART_STAT_RXEDGIF_MASK)
#define LPUART_STAT_LBKDIF_MASK                  0x80000000u
#define LPUART_STAT_LBKDIF_SHIFT                 31
#define LPUART_STAT_LBKDIF_WIDTH                 1
#define LPUART_STAT_LBKDIF(x)                    (((uint32_t)(((uint32_t)(x))<<LPUART_STAT_LBKDIF_SHIFT))&LPUART_STAT_LBKDIF_MASK)
/* CTRL Bit Fields */
#define LPUART_CTRL_PT_MASK                      0x1u
#define LPUART_CTRL_PT_SHIFT                     0
#define LPUART_CTRL_PT_WIDTH                     1
#define LPUART_CTRL_PT(x)                        (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_PT_SHIFT))&LPUART_CTRL_PT_MASK)
#define LPUART_CTRL_PE_MASK                      0x2u
#define LPUART_CTRL_PE_SHIFT                     1
#define LPUART_CTRL_PE_WIDTH                     1
#define LPUART_CTRL_PE(x)                        (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_PE_SHIFT))&LPUART_CTRL_PE_MASK)
#define LPUART_CTRL_ILT_MASK                     0x4u
#define LPUART_CTRL_ILT_SHIFT                    2
#define LPUART_CTRL_ILT_WIDTH                    1
#define LPUART_CTRL_ILT(x)                       (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_ILT_SHIFT))&LPUART_CTRL_ILT_MASK)
#define LPUART_CTRL_WAKE_MASK                    0x8u
#define LPUART_CTRL_WAKE_SHIFT                   3
#define LPUART_CTRL_WAKE_WIDTH                   1
#define LPUART_CTRL_WAKE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_WAKE_SHIFT))&LPUART_CTRL_WAKE_MASK)
#define LPUART_CTRL_M_MASK                       0x10u
#define LPUART_CTRL_M_SHIFT                      4
#define LPUART_CTRL_M_WIDTH                      1
#define LPUART_CTRL_M(x)                         (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_M_SHIFT))&LPUART_CTRL_M_MASK)
#define LPUART_CTRL_RSRC_MASK                    0x20u
#define LPUART_CTRL_RSRC_SHIFT                   5
#define LPUART_CTRL_RSRC_WIDTH                   1
#define LPUART_CTRL_RSRC(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_RSRC_SHIFT))&LPUART_CTRL_RSRC_MASK)
#define LPUART_CTRL_DOZEEN_MASK                  0x40u
#define LPUART_CTRL_DOZEEN_SHIFT                 6
#define LPUART_CTRL_DOZEEN_WIDTH                 1
#define LPUART_CTRL_DOZEEN(x)                    (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_DOZEEN_SHIFT))&LPUART_CTRL_DOZEEN_MASK)
#define LPUART_CTRL_LOOPS_MASK                   0x80u
#define LPUART_CTRL_LOOPS_SHIFT                  7
#define LPUART_CTRL_LOOPS_WIDTH                  1
#define LPUART_CTRL_LOOPS(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_LOOPS_SHIFT))&LPUART_CTRL_LOOPS_MASK)
#define LPUART_CTRL_IDLECFG_MASK                 0x700u
#define LPUART_CTRL_IDLECFG_SHIFT                8
#define LPUART_CTRL_IDLECFG_WIDTH                3
#define LPUART_CTRL_IDLECFG(x)                   (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_IDLECFG_SHIFT))&LPUART_CTRL_IDLECFG_MASK)
#define LPUART_CTRL_MA2IE_MASK                   0x4000u
#define LPUART_CTRL_MA2IE_SHIFT                  14
#define LPUART_CTRL_MA2IE_WIDTH                  1
#define LPUART_CTRL_MA2IE(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_MA2IE_SHIFT))&LPUART_CTRL_MA2IE_MASK)
#define LPUART_CTRL_MA1IE_MASK                   0x8000u
#define LPUART_CTRL_MA1IE_SHIFT                  15
#define LPUART_CTRL_MA1IE_WIDTH                  1
#define LPUART_CTRL_MA1IE(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_MA1IE_SHIFT))&LPUART_CTRL_MA1IE_MASK)
#define LPUART_CTRL_SBK_MASK                     0x10000u
#define LPUART_CTRL_SBK_SHIFT                    16
#define LPUART_CTRL_SBK_WIDTH                    1
#define LPUART_CTRL_SBK(x)                       (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_SBK_SHIFT))&LPUART_CTRL_SBK_MASK)
#define LPUART_CTRL_RWU_MASK                     0x20000u
#define LPUART_CTRL_RWU_SHIFT                    17
#define LPUART_CTRL_RWU_WIDTH                    1
#define LPUART_CTRL_RWU(x)                       (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_RWU_SHIFT))&LPUART_CTRL_RWU_MASK)
#define LPUART_CTRL_RE_MASK                      0x40000u
#define LPUART_CTRL_RE_SHIFT                     18
#define LPUART_CTRL_RE_WIDTH                     1
#define LPUART_CTRL_RE(x)                        (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_RE_SHIFT))&LPUART_CTRL_RE_MASK)
#define LPUART_CTRL_TE_MASK                      0x80000u
#define LPUART_CTRL_TE_SHIFT                     19
#define LPUART_CTRL_TE_WIDTH                     1
#define LPUART_CTRL_TE(x)                        (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_TE_SHIFT))&LPUART_CTRL_TE_MASK)
#define LPUART_CTRL_ILIE_MASK                    0x100000u
#define LPUART_CTRL_ILIE_SHIFT                   20
#define LPUART_CTRL_ILIE_WIDTH                   1
#define LPUART_CTRL_ILIE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_ILIE_SHIFT))&LPUART_CTRL_ILIE_MASK)
#define LPUART_CTRL_RIE_MASK                     0x200000u
#define LPUART_CTRL_RIE_SHIFT                    21
#define LPUART_CTRL_RIE_WIDTH                    1
#define LPUART_CTRL_RIE(x)                       (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_RIE_SHIFT))&LPUART_CTRL_RIE_MASK)
#define LPUART_CTRL_TCIE_MASK                    0x400000u
#define LPUART_CTRL_TCIE_SHIFT                   22
#define LPUART_CTRL_TCIE_WIDTH                   1
#define LPUART_CTRL_TCIE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_TCIE_SHIFT))&LPUART_CTRL_TCIE_MASK)
#define LPUART_CTRL_TIE_MASK                     0x800000u
#define LPUART_CTRL_TIE_SHIFT                    23
#define LPUART_CTRL_TIE_WIDTH                    1
#define LPUART_CTRL_TIE(x)                       (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_TIE_SHIFT))&LPUART_CTRL_TIE_MASK)
#define LPUART_CTRL_PEIE_MASK                    0x1000000u
#define LPUART_CTRL_PEIE_SHIFT                   24
#define LPUART_CTRL_PEIE_WIDTH                   1
#define LPUART_CTRL_PEIE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_PEIE_SHIFT))&LPUART_CTRL_PEIE_MASK)
#define LPUART_CTRL_FEIE_MASK                    0x2000000u
#define LPUART_CTRL_FEIE_SHIFT                   25
#define LPUART_CTRL_FEIE_WIDTH                   1
#define LPUART_CTRL_FEIE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_FEIE_SHIFT))&LPUART_CTRL_FEIE_MASK)
#define LPUART_CTRL_NEIE_MASK                    0x4000000u
#define LPUART_CTRL_NEIE_SHIFT                   26
#define LPUART_CTRL_NEIE_WIDTH                   1
#define LPUART_CTRL_NEIE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_NEIE_SHIFT))&LPUART_CTRL_NEIE_MASK)
#define LPUART_CTRL_ORIE_MASK                    0x8000000u
#define LPUART_CTRL_ORIE_SHIFT                   27
#define LPUART_CTRL_ORIE_WIDTH                   1
#define LPUART_CTRL_ORIE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_ORIE_SHIFT))&LPUART_CTRL_ORIE_MASK)
#define LPUART_CTRL_TXINV_MASK                   0x10000000u
#define LPUART_CTRL_TXINV_SHIFT                  28
#define LPUART_CTRL_TXINV_WIDTH                  1
#define LPUART_CTRL_TXINV(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_TXINV_SHIFT))&LPUART_CTRL_TXINV_MASK)
#define LPUART_CTRL_TXDIR_MASK                   0x20000000u
#define LPUART_CTRL_TXDIR_SHIFT                  29
#define LPUART_CTRL_TXDIR_WIDTH                  1
#define LPUART_CTRL_TXDIR(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_TXDIR_SHIFT))&LPUART_CTRL_TXDIR_MASK)
#define LPUART_CTRL_R9T8_MASK                    0x40000000u
#define LPUART_CTRL_R9T8_SHIFT                   30
#define LPUART_CTRL_R9T8_WIDTH                   1
#define LPUART_CTRL_R9T8(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_R9T8_SHIFT))&LPUART_CTRL_R9T8_MASK)
#define LPUART_CTRL_R8T9_MASK                    0x80000000u
#define LPUART_CTRL_R8T9_SHIFT                   31
#define LPUART_CTRL_R8T9_WIDTH                   1
#define LPUART_CTRL_R8T9(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_CTRL_R8T9_SHIFT))&LPUART_CTRL_R8T9_MASK)
/* DATA Bit Fields */
#define LPUART_DATA_R0T0_MASK                    0x1u
#define LPUART_DATA_R0T0_SHIFT                   0
#define LPUART_DATA_R0T0_WIDTH                   1
#define LPUART_DATA_R0T0(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_R0T0_SHIFT))&LPUART_DATA_R0T0_MASK)
#define LPUART_DATA_R1T1_MASK                    0x2u
#define LPUART_DATA_R1T1_SHIFT                   1
#define LPUART_DATA_R1T1_WIDTH                   1
#define LPUART_DATA_R1T1(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_R1T1_SHIFT))&LPUART_DATA_R1T1_MASK)
#define LPUART_DATA_R2T2_MASK                    0x4u
#define LPUART_DATA_R2T2_SHIFT                   2
#define LPUART_DATA_R2T2_WIDTH                   1
#define LPUART_DATA_R2T2(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_R2T2_SHIFT))&LPUART_DATA_R2T2_MASK)
#define LPUART_DATA_R3T3_MASK                    0x8u
#define LPUART_DATA_R3T3_SHIFT                   3
#define LPUART_DATA_R3T3_WIDTH                   1
#define LPUART_DATA_R3T3(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_R3T3_SHIFT))&LPUART_DATA_R3T3_MASK)
#define LPUART_DATA_R4T4_MASK                    0x10u
#define LPUART_DATA_R4T4_SHIFT                   4
#define LPUART_DATA_R4T4_WIDTH                   1
#define LPUART_DATA_R4T4(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_R4T4_SHIFT))&LPUART_DATA_R4T4_MASK)
#define LPUART_DATA_R5T5_MASK                    0x20u
#define LPUART_DATA_R5T5_SHIFT                   5
#define LPUART_DATA_R5T5_WIDTH                   1
#define LPUART_DATA_R5T5(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_R5T5_SHIFT))&LPUART_DATA_R5T5_MASK)
#define LPUART_DATA_R6T6_MASK                    0x40u
#define LPUART_DATA_R6T6_SHIFT                   6
#define LPUART_DATA_R6T6_WIDTH                   1
#define LPUART_DATA_R6T6(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_R6T6_SHIFT))&LPUART_DATA_R6T6_MASK)
#define LPUART_DATA_R7T7_MASK                    0x80u
#define LPUART_DATA_R7T7_SHIFT                   7
#define LPUART_DATA_R7T7_WIDTH                   1
#define LPUART_DATA_R7T7(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_R7T7_SHIFT))&LPUART_DATA_R7T7_MASK)
#define LPUART_DATA_R8T8_MASK                    0x100u
#define LPUART_DATA_R8T8_SHIFT                   8
#define LPUART_DATA_R8T8_WIDTH                   1
#define LPUART_DATA_R8T8(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_R8T8_SHIFT))&LPUART_DATA_R8T8_MASK)
#define LPUART_DATA_R9T9_MASK                    0x200u
#define LPUART_DATA_R9T9_SHIFT                   9
#define LPUART_DATA_R9T9_WIDTH                   1
#define LPUART_DATA_R9T9(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_R9T9_SHIFT))&LPUART_DATA_R9T9_MASK)
#define LPUART_DATA_IDLINE_MASK                  0x800u
#define LPUART_DATA_IDLINE_SHIFT                 11
#define LPUART_DATA_IDLINE_WIDTH                 1
#define LPUART_DATA_IDLINE(x)                    (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_IDLINE_SHIFT))&LPUART_DATA_IDLINE_MASK)
#define LPUART_DATA_RXEMPT_MASK                  0x1000u
#define LPUART_DATA_RXEMPT_SHIFT                 12
#define LPUART_DATA_RXEMPT_WIDTH                 1
#define LPUART_DATA_RXEMPT(x)                    (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_RXEMPT_SHIFT))&LPUART_DATA_RXEMPT_MASK)
#define LPUART_DATA_FRETSC_MASK                  0x2000u
#define LPUART_DATA_FRETSC_SHIFT                 13
#define LPUART_DATA_FRETSC_WIDTH                 1
#define LPUART_DATA_FRETSC(x)                    (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_FRETSC_SHIFT))&LPUART_DATA_FRETSC_MASK)
#define LPUART_DATA_PARITYE_MASK                 0x4000u
#define LPUART_DATA_PARITYE_SHIFT                14
#define LPUART_DATA_PARITYE_WIDTH                1
#define LPUART_DATA_PARITYE(x)                   (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_PARITYE_SHIFT))&LPUART_DATA_PARITYE_MASK)
#define LPUART_DATA_NOISY_MASK                   0x8000u
#define LPUART_DATA_NOISY_SHIFT                  15
#define LPUART_DATA_NOISY_WIDTH                  1
#define LPUART_DATA_NOISY(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_DATA_NOISY_SHIFT))&LPUART_DATA_NOISY_MASK)
/* MATCH Bit Fields */
#define LPUART_MATCH_MA1_MASK                    0x3FFu
#define LPUART_MATCH_MA1_SHIFT                   0
#define LPUART_MATCH_MA1_WIDTH                   10
#define LPUART_MATCH_MA1(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_MATCH_MA1_SHIFT))&LPUART_MATCH_MA1_MASK)
#define LPUART_MATCH_MA2_MASK                    0x3FF0000u
#define LPUART_MATCH_MA2_SHIFT                   16
#define LPUART_MATCH_MA2_WIDTH                   10
#define LPUART_MATCH_MA2(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_MATCH_MA2_SHIFT))&LPUART_MATCH_MA2_MASK)
/* MODIR Bit Fields */
#define LPUART_MODIR_TXCTSE_MASK                 0x1u
#define LPUART_MODIR_TXCTSE_SHIFT                0
#define LPUART_MODIR_TXCTSE_WIDTH                1
#define LPUART_MODIR_TXCTSE(x)                   (((uint32_t)(((uint32_t)(x))<<LPUART_MODIR_TXCTSE_SHIFT))&LPUART_MODIR_TXCTSE_MASK)
#define LPUART_MODIR_TXRTSE_MASK                 0x2u
#define LPUART_MODIR_TXRTSE_SHIFT                1
#define LPUART_MODIR_TXRTSE_WIDTH                1
#define LPUART_MODIR_TXRTSE(x)                   (((uint32_t)(((uint32_t)(x))<<LPUART_MODIR_TXRTSE_SHIFT))&LPUART_MODIR_TXRTSE_MASK)
#define LPUART_MODIR_TXRTSPOL_MASK               0x4u
#define LPUART_MODIR_TXRTSPOL_SHIFT              2
#define LPUART_MODIR_TXRTSPOL_WIDTH              1
#define LPUART_MODIR_TXRTSPOL(x)                 (((uint32_t)(((uint32_t)(x))<<LPUART_MODIR_TXRTSPOL_SHIFT))&LPUART_MODIR_TXRTSPOL_MASK)
#define LPUART_MODIR_RXRTSE_MASK                 0x8u
#define LPUART_MODIR_RXRTSE_SHIFT                3
#define LPUART_MODIR_RXRTSE_WIDTH                1
#define LPUART_MODIR_RXRTSE(x)                   (((uint32_t)(((uint32_t)(x))<<LPUART_MODIR_RXRTSE_SHIFT))&LPUART_MODIR_RXRTSE_MASK)
#define LPUART_MODIR_TXCTSC_MASK                 0x10u
#define LPUART_MODIR_TXCTSC_SHIFT                4
#define LPUART_MODIR_TXCTSC_WIDTH                1
#define LPUART_MODIR_TXCTSC(x)                   (((uint32_t)(((uint32_t)(x))<<LPUART_MODIR_TXCTSC_SHIFT))&LPUART_MODIR_TXCTSC_MASK)
#define LPUART_MODIR_TXCTSSRC_MASK               0x20u
#define LPUART_MODIR_TXCTSSRC_SHIFT              5
#define LPUART_MODIR_TXCTSSRC_WIDTH              1
#define LPUART_MODIR_TXCTSSRC(x)                 (((uint32_t)(((uint32_t)(x))<<LPUART_MODIR_TXCTSSRC_SHIFT))&LPUART_MODIR_TXCTSSRC_MASK)
#define LPUART_MODIR_RTSWATER_MASK               0xFF00u
#define LPUART_MODIR_RTSWATER_SHIFT              8
#define LPUART_MODIR_RTSWATER_WIDTH              8
#define LPUART_MODIR_RTSWATER(x)                 (((uint32_t)(((uint32_t)(x))<<LPUART_MODIR_RTSWATER_SHIFT))&LPUART_MODIR_RTSWATER_MASK)
#define LPUART_MODIR_TNP_MASK                    0x30000u
#define LPUART_MODIR_TNP_SHIFT                   16
#define LPUART_MODIR_TNP_WIDTH                   2
#define LPUART_MODIR_TNP(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_MODIR_TNP_SHIFT))&LPUART_MODIR_TNP_MASK)
#define LPUART_MODIR_IREN_MASK                   0x40000u
#define LPUART_MODIR_IREN_SHIFT                  18
#define LPUART_MODIR_IREN_WIDTH                  1
#define LPUART_MODIR_IREN(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_MODIR_IREN_SHIFT))&LPUART_MODIR_IREN_MASK)
/* FIFO Bit Fields */
#define LPUART_FIFO_RXFIFOSIZE_MASK              0x7u
#define LPUART_FIFO_RXFIFOSIZE_SHIFT             0
#define LPUART_FIFO_RXFIFOSIZE_WIDTH             3
#define LPUART_FIFO_RXFIFOSIZE(x)                (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_RXFIFOSIZE_SHIFT))&LPUART_FIFO_RXFIFOSIZE_MASK)
#define LPUART_FIFO_RXFE_MASK                    0x8u
#define LPUART_FIFO_RXFE_SHIFT                   3
#define LPUART_FIFO_RXFE_WIDTH                   1
#define LPUART_FIFO_RXFE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_RXFE_SHIFT))&LPUART_FIFO_RXFE_MASK)
#define LPUART_FIFO_TXFIFOSIZE_MASK              0x70u
#define LPUART_FIFO_TXFIFOSIZE_SHIFT             4
#define LPUART_FIFO_TXFIFOSIZE_WIDTH             3
#define LPUART_FIFO_TXFIFOSIZE(x)                (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_TXFIFOSIZE_SHIFT))&LPUART_FIFO_TXFIFOSIZE_MASK)
#define LPUART_FIFO_TXFE_MASK                    0x80u
#define LPUART_FIFO_TXFE_SHIFT                   7
#define LPUART_FIFO_TXFE_WIDTH                   1
#define LPUART_FIFO_TXFE(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_TXFE_SHIFT))&LPUART_FIFO_TXFE_MASK)
#define LPUART_FIFO_RXUFE_MASK                   0x100u
#define LPUART_FIFO_RXUFE_SHIFT                  8
#define LPUART_FIFO_RXUFE_WIDTH                  1
#define LPUART_FIFO_RXUFE(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_RXUFE_SHIFT))&LPUART_FIFO_RXUFE_MASK)
#define LPUART_FIFO_TXOFE_MASK                   0x200u
#define LPUART_FIFO_TXOFE_SHIFT                  9
#define LPUART_FIFO_TXOFE_WIDTH                  1
#define LPUART_FIFO_TXOFE(x)                     (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_TXOFE_SHIFT))&LPUART_FIFO_TXOFE_MASK)
#define LPUART_FIFO_RXIDEN_MASK                  0x1C00u
#define LPUART_FIFO_RXIDEN_SHIFT                 10
#define LPUART_FIFO_RXIDEN_WIDTH                 3
#define LPUART_FIFO_RXIDEN(x)                    (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_RXIDEN_SHIFT))&LPUART_FIFO_RXIDEN_MASK)
#define LPUART_FIFO_RXFLUSH_MASK                 0x4000u
#define LPUART_FIFO_RXFLUSH_SHIFT                14
#define LPUART_FIFO_RXFLUSH_WIDTH                1
#define LPUART_FIFO_RXFLUSH(x)                   (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_RXFLUSH_SHIFT))&LPUART_FIFO_RXFLUSH_MASK)
#define LPUART_FIFO_TXFLUSH_MASK                 0x8000u
#define LPUART_FIFO_TXFLUSH_SHIFT                15
#define LPUART_FIFO_TXFLUSH_WIDTH                1
#define LPUART_FIFO_TXFLUSH(x)                   (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_TXFLUSH_SHIFT))&LPUART_FIFO_TXFLUSH_MASK)
#define LPUART_FIFO_RXUF_MASK                    0x10000u
#define LPUART_FIFO_RXUF_SHIFT                   16
#define LPUART_FIFO_RXUF_WIDTH                   1
#define LPUART_FIFO_RXUF(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_RXUF_SHIFT))&LPUART_FIFO_RXUF_MASK)
#define LPUART_FIFO_TXOF_MASK                    0x20000u
#define LPUART_FIFO_TXOF_SHIFT                   17
#define LPUART_FIFO_TXOF_WIDTH                   1
#define LPUART_FIFO_TXOF(x)                      (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_TXOF_SHIFT))&LPUART_FIFO_TXOF_MASK)
#define LPUART_FIFO_RXEMPT_MASK                  0x400000u
#define LPUART_FIFO_RXEMPT_SHIFT                 22
#define LPUART_FIFO_RXEMPT_WIDTH                 1
#define LPUART_FIFO_RXEMPT(x)                    (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_RXEMPT_SHIFT))&LPUART_FIFO_RXEMPT_MASK)
#define LPUART_FIFO_TXEMPT_MASK                  0x800000u
#define LPUART_FIFO_TXEMPT_SHIFT                 23
#define LPUART_FIFO_TXEMPT_WIDTH                 1
#define LPUART_FIFO_TXEMPT(x)                    (((uint32_t)(((uint32_t)(x))<<LPUART_FIFO_TXEMPT_SHIFT))&LPUART_FIFO_TXEMPT_MASK)
/* WATER Bit Fields */
#define LPUART_WATER_TXWATER_MASK                0xFFu
#define LPUART_WATER_TXWATER_SHIFT               0
#define LPUART_WATER_TXWATER_WIDTH               8
#define LPUART_WATER_TXWATER(x)                  (((uint32_t)(((uint32_t)(x))<<LPUART_WATER_TXWATER_SHIFT))&LPUART_WATER_TXWATER_MASK)
#define LPUART_WATER_TXCOUNT_MASK                0xFF00u
#define LPUART_WATER_TXCOUNT_SHIFT               8
#define LPUART_WATER_TXCOUNT_WIDTH               8
#define LPUART_WATER_TXCOUNT(x)                  (((uint32_t)(((uint32_t)(x))<<LPUART_WATER_TXCOUNT_SHIFT))&LPUART_WATER_TXCOUNT_MASK)
#define LPUART_WATER_RXWATER_MASK                0xFF0000u
#define LPUART_WATER_RXWATER_SHIFT               16
#define LPUART_WATER_RXWATER_WIDTH               8
#define LPUART_WATER_RXWATER(x)                  (((uint32_t)(((uint32_t)(x))<<LPUART_WATER_RXWATER_SHIFT))&LPUART_WATER_RXWATER_MASK)
#define LPUART_WATER_RXCOUNT_MASK                0xFF000000u
#define LPUART_WATER_RXCOUNT_SHIFT               24
#define LPUART_WATER_RXCOUNT_WIDTH               8
#define LPUART_WATER_RXCOUNT(x)                  (((uint32_t)(((uint32_t)(x))<<LPUART_WATER_RXCOUNT_SHIFT))&LPUART_WATER_RXCOUNT_MASK)

/*!
 * @}
 */ /* end of group LPUART_Register_Masks */


/* LPUART - Peripheral instance base addresses */
/** Peripheral LPUART0 base address */
#define LPUART0_BASE                             (0x40054000u)
/** Peripheral LPUART0 base pointer */
#define LPUART0                                  ((LPUART_Type *)LPUART0_BASE)
#define LPUART0_BASE_PTR                         (LPUART0)
/** Peripheral LPUART1 base address */
#define LPUART1_BASE                             (0x40055000u)
/** Peripheral LPUART1 base pointer */
#define LPUART1                                  ((LPUART_Type *)LPUART1_BASE)
#define LPUART1_BASE_PTR                         (LPUART1)
/** Peripheral LPUART2 base address */
#define LPUART2_BASE                             (0x40056000u)
/** Peripheral LPUART2 base pointer */
#define LPUART2                                  ((LPUART_Type *)LPUART2_BASE)
#define LPUART2_BASE_PTR                         (LPUART2)
/** Array initializer of LPUART peripheral base addresses */
#define LPUART_BASE_ADDRS                        { LPUART0_BASE, LPUART1_BASE, LPUART2_BASE }
/** Array initializer of LPUART peripheral base pointers */
#define LPUART_BASE_PTRS                         { LPUART0, LPUART1, LPUART2 }

/* ----------------------------------------------------------------------------
   -- LPUART - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LPUART_Register_Accessor_Macros LPUART - Register accessor macros
 * @{
 */


/* LPUART - Register instance definitions */
/* LPUART0 */
#define LPUART0_BAUD                             LPUART_BAUD_REG(LPUART0)
#define LPUART0_STAT                             LPUART_STAT_REG(LPUART0)
#define LPUART0_CTRL                             LPUART_CTRL_REG(LPUART0)
#define LPUART0_DATA                             LPUART_DATA_REG(LPUART0)
#define LPUART0_MATCH                            LPUART_MATCH_REG(LPUART0)
#define LPUART0_MODIR                            LPUART_MODIR_REG(LPUART0)
#define LPUART0_FIFO                             LPUART_FIFO_REG(LPUART0)
#define LPUART0_WATER                            LPUART_WATER_REG(LPUART0)
/* LPUART1 */
#define LPUART1_BAUD                             LPUART_BAUD_REG(LPUART1)
#define LPUART1_STAT                             LPUART_STAT_REG(LPUART1)
#define LPUART1_CTRL                             LPUART_CTRL_REG(LPUART1)
#define LPUART1_DATA                             LPUART_DATA_REG(LPUART1)
#define LPUART1_MATCH                            LPUART_MATCH_REG(LPUART1)
#define LPUART1_MODIR                            LPUART_MODIR_REG(LPUART1)
#define LPUART1_FIFO                             LPUART_FIFO_REG(LPUART1)
#define LPUART1_WATER                            LPUART_WATER_REG(LPUART1)
/* LPUART2 */
#define LPUART2_BAUD                             LPUART_BAUD_REG(LPUART2)
#define LPUART2_STAT                             LPUART_STAT_REG(LPUART2)
#define LPUART2_CTRL                             LPUART_CTRL_REG(LPUART2)
#define LPUART2_DATA                             LPUART_DATA_REG(LPUART2)
#define LPUART2_MATCH                            LPUART_MATCH_REG(LPUART2)
#define LPUART2_MODIR                            LPUART_MODIR_REG(LPUART2)
#define LPUART2_FIFO                             LPUART_FIFO_REG(LPUART2)
#define LPUART2_WATER                            LPUART_WATER_REG(LPUART2)

/*!
 * @}
 */ /* end of group LPUART_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group LPUART_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- LTC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LTC_Peripheral_Access_Layer LTC Peripheral Access Layer
 * @{
 */

/** LTC - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    __IO uint32_t MD;                                /**< LTC Mode Register (non-PKHA/non-RNG use), offset: 0x0 */
    __IO uint32_t MDPK;                              /**< LTC Mode Register (PublicKey), offset: 0x0 */
  };
       uint8_t RESERVED_0[4];
  __IO uint32_t KS;                                /**< LTC Key Size Register, offset: 0x8 */
       uint8_t RESERVED_1[4];
  __IO uint32_t DS;                                /**< LTC Data Size Register, offset: 0x10 */
       uint8_t RESERVED_2[4];
  __IO uint32_t ICVS;                              /**< LTC ICV Size Register, offset: 0x18 */
       uint8_t RESERVED_3[20];
  __IO uint32_t COM;                               /**< LTC Command Register, offset: 0x30 */
  __IO uint32_t CTL;                               /**< LTC Control Register, offset: 0x34 */
       uint8_t RESERVED_4[8];
  __IO uint32_t CW;                                /**< LTC Clear Written Register, offset: 0x40 */
       uint8_t RESERVED_5[4];
  __IO uint32_t STA;                               /**< LTC Status Register, offset: 0x48 */
  __I  uint32_t ESTA;                              /**< LTC Error Status Register, offset: 0x4C */
       uint8_t RESERVED_6[8];
  __IO uint32_t AADSZ;                             /**< LTC AAD Size Register, offset: 0x58 */
       uint8_t RESERVED_7[4];
  __IO uint32_t IVSZ;                              /**< LTC IV Size Register, offset: 0x60 */
       uint8_t RESERVED_8[4];
  __O  uint32_t DPAMS;                             /**< LTC DPA Mask Seed Register, offset: 0x68 */
       uint8_t RESERVED_9[20];
  __IO uint32_t PKASZ;                             /**< LTC PKHA A Size Register, offset: 0x80 */
       uint8_t RESERVED_10[4];
  __IO uint32_t PKBSZ;                             /**< LTC PKHA B Size Register, offset: 0x88 */
       uint8_t RESERVED_11[4];
  __IO uint32_t PKNSZ;                             /**< LTC PKHA N Size Register, offset: 0x90 */
       uint8_t RESERVED_12[4];
  __IO uint32_t PKESZ;                             /**< LTC PKHA E Size Register, offset: 0x98 */
       uint8_t RESERVED_13[100];
  __IO uint32_t CTX[16];                           /**< LTC Context Register, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_14[192];
  __IO uint32_t KEY[8];                            /**< LTC Key Registers, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_15[720];
  __I  uint32_t VID1;                              /**< LTC Version ID Register, offset: 0x4F0 */
  __I  uint32_t VID2;                              /**< LTC Version ID 2 Register, offset: 0x4F4 */
  __I  uint32_t CHAVID;                            /**< LTC CHA Version ID Register, offset: 0x4F8 */
       uint8_t RESERVED_16[708];
  __I  uint32_t FIFOSTA;                           /**< LTC FIFO Status Register, offset: 0x7C0 */
       uint8_t RESERVED_17[28];
  __O  uint32_t IFIFO;                             /**< LTC Input Data FIFO, offset: 0x7E0 */
       uint8_t RESERVED_18[12];
  __I  uint32_t OFIFO;                             /**< LTC Output Data FIFO, offset: 0x7F0 */
       uint8_t RESERVED_19[12];
  union {                                          /* offset: 0x800 */
    __IO uint32_t PKA[64];                           /**< LTC PKHA A 0 Register..LTC PKHA A 63 Register, array offset: 0x800, array step: 0x4 */
    struct {                                         /* offset: 0x800 */
      __IO uint32_t PKA0[16];                          /**< LTC PKHA A0 0 Register..LTC PKHA A0 15 Register, array offset: 0x800, array step: 0x4 */
      __IO uint32_t PKA1[16];                          /**< LTC PKHA A1 0 Register..LTC PKHA A1 15 Register, array offset: 0x840, array step: 0x4 */
      __IO uint32_t PKA2[16];                          /**< LTC PKHA A2 0 Register..LTC PKHA A2 15 Register, array offset: 0x880, array step: 0x4 */
      __IO uint32_t PKA3[16];                          /**< LTC PKHA A3 0 Register..LTC PKHA A3 15 Register, array offset: 0x8C0, array step: 0x4 */
    } PKA_SHORT;
  };
       uint8_t RESERVED_20[256];
  union {                                          /* offset: 0xA00 */
    __IO uint32_t PKB[64];                           /**< LTC PKHA B 0 Register..LTC PKHA B 63 Register, array offset: 0xA00, array step: 0x4 */
    struct {                                         /* offset: 0xA00 */
      __IO uint32_t PKB0[16];                          /**< LTC PKHA B0 0 Register..LTC PKHA B0 15 Register, array offset: 0xA00, array step: 0x4 */
      __IO uint32_t PKB1[16];                          /**< LTC PKHA B1 0 Register..LTC PKHA B1 15 Register, array offset: 0xA40, array step: 0x4 */
      __IO uint32_t PKB2[16];                          /**< LTC PKHA B2 0 Register..LTC PKHA B2 15 Register, array offset: 0xA80, array step: 0x4 */
      __IO uint32_t PKB3[16];                          /**< LTC PKHA B3 0 Register..LTC PKHA B3 15 Register, array offset: 0xAC0, array step: 0x4 */
    } PKB_SHORT;
  };
       uint8_t RESERVED_21[256];
  union {                                          /* offset: 0xC00 */
    __IO uint32_t PKN[64];                           /**< LTC PKHA N 0 Register..LTC PKHA N 63 Register, array offset: 0xC00, array step: 0x4 */
    struct {                                         /* offset: 0xC00 */
      __IO uint32_t PKN0[16];                          /**< LTC PKHA N0 0 Register..LTC PKHA N0 15 Register, array offset: 0xC00, array step: 0x4 */
      __IO uint32_t PKN1[16];                          /**< LTC PKHA N1 0 Register..LTC PKHA N1 15 Register, array offset: 0xC40, array step: 0x4 */
      __IO uint32_t PKN2[16];                          /**< LTC PKHA N2 0 Register..LTC PKHA N2 15 Register, array offset: 0xC80, array step: 0x4 */
      __IO uint32_t PKN3[16];                          /**< LTC PKHA N3 0 Register..LTC PKHA N3 15 Register, array offset: 0xCC0, array step: 0x4 */
    } PKN_SHORT;
  };
       uint8_t RESERVED_22[256];
  union {                                          /* offset: 0xE00 */
    __IO uint32_t PKE[64];                           /**< LTC PKHA E 0 Register..LTC PKHA E 63 Register, array offset: 0xE00, array step: 0x4 */
    struct {                                         /* offset: 0xE00 */
      __IO uint32_t PKE0[16];                          /**< LTC PKHA E0 0 Register..LTC PKHA E0 15 Register, array offset: 0xE00, array step: 0x4 */
      __IO uint32_t PKE1[16];                          /**< LTC PKHA E1 0 Register..LTC PKHA E1 15 Register, array offset: 0xE40, array step: 0x4 */
      __IO uint32_t PKE2[16];                          /**< LTC PKHA E2 0 Register..LTC PKHA E2 15 Register, array offset: 0xE80, array step: 0x4 */
      __IO uint32_t PKE3[16];                          /**< LTC PKHA E3 0 Register..LTC PKHA E3 15 Register, array offset: 0xEC0, array step: 0x4 */
    } PKE_SHORT;
  };
} LTC_Type, *LTC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- LTC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LTC_Register_Accessor_Macros LTC - Register accessor macros
 * @{
 */


/* LTC - Register accessors */
#define LTC_MD_REG(base)                         ((base)->MD)
#define LTC_MDPK_REG(base)                       ((base)->MDPK)
#define LTC_KS_REG(base)                         ((base)->KS)
#define LTC_DS_REG(base)                         ((base)->DS)
#define LTC_ICVS_REG(base)                       ((base)->ICVS)
#define LTC_COM_REG(base)                        ((base)->COM)
#define LTC_CTL_REG(base)                        ((base)->CTL)
#define LTC_CW_REG(base)                         ((base)->CW)
#define LTC_STA_REG(base)                        ((base)->STA)
#define LTC_ESTA_REG(base)                       ((base)->ESTA)
#define LTC_AADSZ_REG(base)                      ((base)->AADSZ)
#define LTC_IVSZ_REG(base)                       ((base)->IVSZ)
#define LTC_DPAMS_REG(base)                      ((base)->DPAMS)
#define LTC_PKASZ_REG(base)                      ((base)->PKASZ)
#define LTC_PKBSZ_REG(base)                      ((base)->PKBSZ)
#define LTC_PKNSZ_REG(base)                      ((base)->PKNSZ)
#define LTC_PKESZ_REG(base)                      ((base)->PKESZ)
#define LTC_CTX_REG(base,index)                  ((base)->CTX[index])
#define LTC_CTX_COUNT                            16
#define LTC_KEY_REG(base,index)                  ((base)->KEY[index])
#define LTC_KEY_COUNT                            8
#define LTC_VID1_REG(base)                       ((base)->VID1)
#define LTC_VID2_REG(base)                       ((base)->VID2)
#define LTC_CHAVID_REG(base)                     ((base)->CHAVID)
#define LTC_FIFOSTA_REG(base)                    ((base)->FIFOSTA)
#define LTC_IFIFO_REG(base)                      ((base)->IFIFO)
#define LTC_OFIFO_REG(base)                      ((base)->OFIFO)
#define LTC_PKA_REG(base,index2)                 ((base)->PKA[index2])
#define LTC_PKA_COUNT                            64
#define LTC_PKA0_REG(base,index2)                ((base)->PKA_SHORT.PKA0[index2])
#define LTC_PKA0_COUNT                           16
#define LTC_PKA1_REG(base,index2)                ((base)->PKA_SHORT.PKA1[index2])
#define LTC_PKA1_COUNT                           16
#define LTC_PKA2_REG(base,index2)                ((base)->PKA_SHORT.PKA2[index2])
#define LTC_PKA2_COUNT                           16
#define LTC_PKA3_REG(base,index2)                ((base)->PKA_SHORT.PKA3[index2])
#define LTC_PKA3_COUNT                           16
#define LTC_PKB_REG(base,index2)                 ((base)->PKB[index2])
#define LTC_PKB_COUNT                            64
#define LTC_PKB0_REG(base,index2)                ((base)->PKB_SHORT.PKB0[index2])
#define LTC_PKB0_COUNT                           16
#define LTC_PKB1_REG(base,index2)                ((base)->PKB_SHORT.PKB1[index2])
#define LTC_PKB1_COUNT                           16
#define LTC_PKB2_REG(base,index2)                ((base)->PKB_SHORT.PKB2[index2])
#define LTC_PKB2_COUNT                           16
#define LTC_PKB3_REG(base,index2)                ((base)->PKB_SHORT.PKB3[index2])
#define LTC_PKB3_COUNT                           16
#define LTC_PKN_REG(base,index2)                 ((base)->PKN[index2])
#define LTC_PKN_COUNT                            64
#define LTC_PKN0_REG(base,index2)                ((base)->PKN_SHORT.PKN0[index2])
#define LTC_PKN0_COUNT                           16
#define LTC_PKN1_REG(base,index2)                ((base)->PKN_SHORT.PKN1[index2])
#define LTC_PKN1_COUNT                           16
#define LTC_PKN2_REG(base,index2)                ((base)->PKN_SHORT.PKN2[index2])
#define LTC_PKN2_COUNT                           16
#define LTC_PKN3_REG(base,index2)                ((base)->PKN_SHORT.PKN3[index2])
#define LTC_PKN3_COUNT                           16
#define LTC_PKE_REG(base,index2)                 ((base)->PKE[index2])
#define LTC_PKE_COUNT                            64
#define LTC_PKE0_REG(base,index2)                ((base)->PKE_SHORT.PKE0[index2])
#define LTC_PKE0_COUNT                           16
#define LTC_PKE1_REG(base,index2)                ((base)->PKE_SHORT.PKE1[index2])
#define LTC_PKE1_COUNT                           16
#define LTC_PKE2_REG(base,index2)                ((base)->PKE_SHORT.PKE2[index2])
#define LTC_PKE2_COUNT                           16
#define LTC_PKE3_REG(base,index2)                ((base)->PKE_SHORT.PKE3[index2])
#define LTC_PKE3_COUNT                           16

/*!
 * @}
 */ /* end of group LTC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- LTC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LTC_Register_Masks LTC Register Masks
 * @{
 */

/* MD Bit Fields */
#define LTC_MD_ENC_MASK                          0x1u
#define LTC_MD_ENC_SHIFT                         0
#define LTC_MD_ENC_WIDTH                         1
#define LTC_MD_ENC(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_MD_ENC_SHIFT))&LTC_MD_ENC_MASK)
#define LTC_MD_ICV_TEST_MASK                     0x2u
#define LTC_MD_ICV_TEST_SHIFT                    1
#define LTC_MD_ICV_TEST_WIDTH                    1
#define LTC_MD_ICV_TEST(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_MD_ICV_TEST_SHIFT))&LTC_MD_ICV_TEST_MASK)
#define LTC_MD_AS_MASK                           0xCu
#define LTC_MD_AS_SHIFT                          2
#define LTC_MD_AS_WIDTH                          2
#define LTC_MD_AS(x)                             (((uint32_t)(((uint32_t)(x))<<LTC_MD_AS_SHIFT))&LTC_MD_AS_MASK)
#define LTC_MD_AAI_MASK                          0x1FF0u
#define LTC_MD_AAI_SHIFT                         4
#define LTC_MD_AAI_WIDTH                         9
#define LTC_MD_AAI(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_MD_AAI_SHIFT))&LTC_MD_AAI_MASK)
#define LTC_MD_ALG_MASK                          0xFF0000u
#define LTC_MD_ALG_SHIFT                         16
#define LTC_MD_ALG_WIDTH                         8
#define LTC_MD_ALG(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_MD_ALG_SHIFT))&LTC_MD_ALG_MASK)
/* MDPK Bit Fields */
#define LTC_MDPK_PKHA_MODE_LS_MASK               0xFFFu
#define LTC_MDPK_PKHA_MODE_LS_SHIFT              0
#define LTC_MDPK_PKHA_MODE_LS_WIDTH              12
#define LTC_MDPK_PKHA_MODE_LS(x)                 (((uint32_t)(((uint32_t)(x))<<LTC_MDPK_PKHA_MODE_LS_SHIFT))&LTC_MDPK_PKHA_MODE_LS_MASK)
#define LTC_MDPK_PKHA_MODE_MS_MASK               0xF0000u
#define LTC_MDPK_PKHA_MODE_MS_SHIFT              16
#define LTC_MDPK_PKHA_MODE_MS_WIDTH              4
#define LTC_MDPK_PKHA_MODE_MS(x)                 (((uint32_t)(((uint32_t)(x))<<LTC_MDPK_PKHA_MODE_MS_SHIFT))&LTC_MDPK_PKHA_MODE_MS_MASK)
#define LTC_MDPK_ALG_MASK                        0xF00000u
#define LTC_MDPK_ALG_SHIFT                       20
#define LTC_MDPK_ALG_WIDTH                       4
#define LTC_MDPK_ALG(x)                          (((uint32_t)(((uint32_t)(x))<<LTC_MDPK_ALG_SHIFT))&LTC_MDPK_ALG_MASK)
/* KS Bit Fields */
#define LTC_KS_KS_MASK                           0x3Fu
#define LTC_KS_KS_SHIFT                          0
#define LTC_KS_KS_WIDTH                          6
#define LTC_KS_KS(x)                             (((uint32_t)(((uint32_t)(x))<<LTC_KS_KS_SHIFT))&LTC_KS_KS_MASK)
/* DS Bit Fields */
#define LTC_DS_DS_MASK                           0xFFFu
#define LTC_DS_DS_SHIFT                          0
#define LTC_DS_DS_WIDTH                          12
#define LTC_DS_DS(x)                             (((uint32_t)(((uint32_t)(x))<<LTC_DS_DS_SHIFT))&LTC_DS_DS_MASK)
/* ICVS Bit Fields */
#define LTC_ICVS_ICVS_MASK                       0x1Fu
#define LTC_ICVS_ICVS_SHIFT                      0
#define LTC_ICVS_ICVS_WIDTH                      5
#define LTC_ICVS_ICVS(x)                         (((uint32_t)(((uint32_t)(x))<<LTC_ICVS_ICVS_SHIFT))&LTC_ICVS_ICVS_MASK)
/* COM Bit Fields */
#define LTC_COM_ALL_MASK                         0x1u
#define LTC_COM_ALL_SHIFT                        0
#define LTC_COM_ALL_WIDTH                        1
#define LTC_COM_ALL(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_COM_ALL_SHIFT))&LTC_COM_ALL_MASK)
#define LTC_COM_AES_MASK                         0x2u
#define LTC_COM_AES_SHIFT                        1
#define LTC_COM_AES_WIDTH                        1
#define LTC_COM_AES(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_COM_AES_SHIFT))&LTC_COM_AES_MASK)
#define LTC_COM_DES_MASK                         0x4u
#define LTC_COM_DES_SHIFT                        2
#define LTC_COM_DES_WIDTH                        1
#define LTC_COM_DES(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_COM_DES_SHIFT))&LTC_COM_DES_MASK)
#define LTC_COM_PK_MASK                          0x40u
#define LTC_COM_PK_SHIFT                         6
#define LTC_COM_PK_WIDTH                         1
#define LTC_COM_PK(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_COM_PK_SHIFT))&LTC_COM_PK_MASK)
#define LTC_COM_MD_MASK                          0x80u
#define LTC_COM_MD_SHIFT                         7
#define LTC_COM_MD_WIDTH                         1
#define LTC_COM_MD(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_COM_MD_SHIFT))&LTC_COM_MD_MASK)
/* CTL Bit Fields */
#define LTC_CTL_IM_MASK                          0x1u
#define LTC_CTL_IM_SHIFT                         0
#define LTC_CTL_IM_WIDTH                         1
#define LTC_CTL_IM(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_CTL_IM_SHIFT))&LTC_CTL_IM_MASK)
#define LTC_CTL_PDE_MASK                         0x10u
#define LTC_CTL_PDE_SHIFT                        4
#define LTC_CTL_PDE_WIDTH                        1
#define LTC_CTL_PDE(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_PDE_SHIFT))&LTC_CTL_PDE_MASK)
#define LTC_CTL_IFE_MASK                         0x100u
#define LTC_CTL_IFE_SHIFT                        8
#define LTC_CTL_IFE_WIDTH                        1
#define LTC_CTL_IFE(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_IFE_SHIFT))&LTC_CTL_IFE_MASK)
#define LTC_CTL_IFR_MASK                         0x200u
#define LTC_CTL_IFR_SHIFT                        9
#define LTC_CTL_IFR_WIDTH                        1
#define LTC_CTL_IFR(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_IFR_SHIFT))&LTC_CTL_IFR_MASK)
#define LTC_CTL_OFE_MASK                         0x1000u
#define LTC_CTL_OFE_SHIFT                        12
#define LTC_CTL_OFE_WIDTH                        1
#define LTC_CTL_OFE(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_OFE_SHIFT))&LTC_CTL_OFE_MASK)
#define LTC_CTL_OFR_MASK                         0x2000u
#define LTC_CTL_OFR_SHIFT                        13
#define LTC_CTL_OFR_WIDTH                        1
#define LTC_CTL_OFR(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_OFR_SHIFT))&LTC_CTL_OFR_MASK)
#define LTC_CTL_IFS_MASK                         0x10000u
#define LTC_CTL_IFS_SHIFT                        16
#define LTC_CTL_IFS_WIDTH                        1
#define LTC_CTL_IFS(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_IFS_SHIFT))&LTC_CTL_IFS_MASK)
#define LTC_CTL_OFS_MASK                         0x20000u
#define LTC_CTL_OFS_SHIFT                        17
#define LTC_CTL_OFS_WIDTH                        1
#define LTC_CTL_OFS(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_OFS_SHIFT))&LTC_CTL_OFS_MASK)
#define LTC_CTL_KIS_MASK                         0x100000u
#define LTC_CTL_KIS_SHIFT                        20
#define LTC_CTL_KIS_WIDTH                        1
#define LTC_CTL_KIS(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_KIS_SHIFT))&LTC_CTL_KIS_MASK)
#define LTC_CTL_KOS_MASK                         0x200000u
#define LTC_CTL_KOS_SHIFT                        21
#define LTC_CTL_KOS_WIDTH                        1
#define LTC_CTL_KOS(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_KOS_SHIFT))&LTC_CTL_KOS_MASK)
#define LTC_CTL_CIS_MASK                         0x400000u
#define LTC_CTL_CIS_SHIFT                        22
#define LTC_CTL_CIS_WIDTH                        1
#define LTC_CTL_CIS(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_CIS_SHIFT))&LTC_CTL_CIS_MASK)
#define LTC_CTL_COS_MASK                         0x800000u
#define LTC_CTL_COS_SHIFT                        23
#define LTC_CTL_COS_WIDTH                        1
#define LTC_CTL_COS(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_COS_SHIFT))&LTC_CTL_COS_MASK)
#define LTC_CTL_KAL_MASK                         0x80000000u
#define LTC_CTL_KAL_SHIFT                        31
#define LTC_CTL_KAL_WIDTH                        1
#define LTC_CTL_KAL(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTL_KAL_SHIFT))&LTC_CTL_KAL_MASK)
/* CW Bit Fields */
#define LTC_CW_CM_MASK                           0x1u
#define LTC_CW_CM_SHIFT                          0
#define LTC_CW_CM_WIDTH                          1
#define LTC_CW_CM(x)                             (((uint32_t)(((uint32_t)(x))<<LTC_CW_CM_SHIFT))&LTC_CW_CM_MASK)
#define LTC_CW_CDS_MASK                          0x4u
#define LTC_CW_CDS_SHIFT                         2
#define LTC_CW_CDS_WIDTH                         1
#define LTC_CW_CDS(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_CW_CDS_SHIFT))&LTC_CW_CDS_MASK)
#define LTC_CW_CICV_MASK                         0x8u
#define LTC_CW_CICV_SHIFT                        3
#define LTC_CW_CICV_WIDTH                        1
#define LTC_CW_CICV(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CW_CICV_SHIFT))&LTC_CW_CICV_MASK)
#define LTC_CW_CCR_MASK                          0x20u
#define LTC_CW_CCR_SHIFT                         5
#define LTC_CW_CCR_WIDTH                         1
#define LTC_CW_CCR(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_CW_CCR_SHIFT))&LTC_CW_CCR_MASK)
#define LTC_CW_CKR_MASK                          0x40u
#define LTC_CW_CKR_SHIFT                         6
#define LTC_CW_CKR_WIDTH                         1
#define LTC_CW_CKR(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_CW_CKR_SHIFT))&LTC_CW_CKR_MASK)
#define LTC_CW_CPKA_MASK                         0x1000u
#define LTC_CW_CPKA_SHIFT                        12
#define LTC_CW_CPKA_WIDTH                        1
#define LTC_CW_CPKA(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CW_CPKA_SHIFT))&LTC_CW_CPKA_MASK)
#define LTC_CW_CPKB_MASK                         0x2000u
#define LTC_CW_CPKB_SHIFT                        13
#define LTC_CW_CPKB_WIDTH                        1
#define LTC_CW_CPKB(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CW_CPKB_SHIFT))&LTC_CW_CPKB_MASK)
#define LTC_CW_CPKN_MASK                         0x4000u
#define LTC_CW_CPKN_SHIFT                        14
#define LTC_CW_CPKN_WIDTH                        1
#define LTC_CW_CPKN(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CW_CPKN_SHIFT))&LTC_CW_CPKN_MASK)
#define LTC_CW_CPKE_MASK                         0x8000u
#define LTC_CW_CPKE_SHIFT                        15
#define LTC_CW_CPKE_WIDTH                        1
#define LTC_CW_CPKE(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CW_CPKE_SHIFT))&LTC_CW_CPKE_MASK)
#define LTC_CW_COF_MASK                          0x40000000u
#define LTC_CW_COF_SHIFT                         30
#define LTC_CW_COF_WIDTH                         1
#define LTC_CW_COF(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_CW_COF_SHIFT))&LTC_CW_COF_MASK)
#define LTC_CW_CIF_MASK                          0x80000000u
#define LTC_CW_CIF_SHIFT                         31
#define LTC_CW_CIF_WIDTH                         1
#define LTC_CW_CIF(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_CW_CIF_SHIFT))&LTC_CW_CIF_MASK)
/* STA Bit Fields */
#define LTC_STA_AB_MASK                          0x2u
#define LTC_STA_AB_SHIFT                         1
#define LTC_STA_AB_WIDTH                         1
#define LTC_STA_AB(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_STA_AB_SHIFT))&LTC_STA_AB_MASK)
#define LTC_STA_DB_MASK                          0x4u
#define LTC_STA_DB_SHIFT                         2
#define LTC_STA_DB_WIDTH                         1
#define LTC_STA_DB(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_STA_DB_SHIFT))&LTC_STA_DB_MASK)
#define LTC_STA_PB_MASK                          0x40u
#define LTC_STA_PB_SHIFT                         6
#define LTC_STA_PB_WIDTH                         1
#define LTC_STA_PB(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_STA_PB_SHIFT))&LTC_STA_PB_MASK)
#define LTC_STA_MB_MASK                          0x80u
#define LTC_STA_MB_SHIFT                         7
#define LTC_STA_MB_WIDTH                         1
#define LTC_STA_MB(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_STA_MB_SHIFT))&LTC_STA_MB_MASK)
#define LTC_STA_DI_MASK                          0x10000u
#define LTC_STA_DI_SHIFT                         16
#define LTC_STA_DI_WIDTH                         1
#define LTC_STA_DI(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_STA_DI_SHIFT))&LTC_STA_DI_MASK)
#define LTC_STA_EI_MASK                          0x100000u
#define LTC_STA_EI_SHIFT                         20
#define LTC_STA_EI_WIDTH                         1
#define LTC_STA_EI(x)                            (((uint32_t)(((uint32_t)(x))<<LTC_STA_EI_SHIFT))&LTC_STA_EI_MASK)
#define LTC_STA_DPARRN_MASK                      0x1000000u
#define LTC_STA_DPARRN_SHIFT                     24
#define LTC_STA_DPARRN_WIDTH                     1
#define LTC_STA_DPARRN(x)                        (((uint32_t)(((uint32_t)(x))<<LTC_STA_DPARRN_SHIFT))&LTC_STA_DPARRN_MASK)
#define LTC_STA_PKP_MASK                         0x10000000u
#define LTC_STA_PKP_SHIFT                        28
#define LTC_STA_PKP_WIDTH                        1
#define LTC_STA_PKP(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_STA_PKP_SHIFT))&LTC_STA_PKP_MASK)
#define LTC_STA_PKO_MASK                         0x20000000u
#define LTC_STA_PKO_SHIFT                        29
#define LTC_STA_PKO_WIDTH                        1
#define LTC_STA_PKO(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_STA_PKO_SHIFT))&LTC_STA_PKO_MASK)
#define LTC_STA_PKZ_MASK                         0x40000000u
#define LTC_STA_PKZ_SHIFT                        30
#define LTC_STA_PKZ_WIDTH                        1
#define LTC_STA_PKZ(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_STA_PKZ_SHIFT))&LTC_STA_PKZ_MASK)
/* ESTA Bit Fields */
#define LTC_ESTA_ERRID1_MASK                     0xFu
#define LTC_ESTA_ERRID1_SHIFT                    0
#define LTC_ESTA_ERRID1_WIDTH                    4
#define LTC_ESTA_ERRID1(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_ESTA_ERRID1_SHIFT))&LTC_ESTA_ERRID1_MASK)
#define LTC_ESTA_CL1_MASK                        0xF00u
#define LTC_ESTA_CL1_SHIFT                       8
#define LTC_ESTA_CL1_WIDTH                       4
#define LTC_ESTA_CL1(x)                          (((uint32_t)(((uint32_t)(x))<<LTC_ESTA_CL1_SHIFT))&LTC_ESTA_CL1_MASK)
/* AADSZ Bit Fields */
#define LTC_AADSZ_AADSZ_MASK                     0xFu
#define LTC_AADSZ_AADSZ_SHIFT                    0
#define LTC_AADSZ_AADSZ_WIDTH                    4
#define LTC_AADSZ_AADSZ(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_AADSZ_AADSZ_SHIFT))&LTC_AADSZ_AADSZ_MASK)
#define LTC_AADSZ_AL_MASK                        0x80000000u
#define LTC_AADSZ_AL_SHIFT                       31
#define LTC_AADSZ_AL_WIDTH                       1
#define LTC_AADSZ_AL(x)                          (((uint32_t)(((uint32_t)(x))<<LTC_AADSZ_AL_SHIFT))&LTC_AADSZ_AL_MASK)
/* IVSZ Bit Fields */
#define LTC_IVSZ_IVSZ_MASK                       0xFu
#define LTC_IVSZ_IVSZ_SHIFT                      0
#define LTC_IVSZ_IVSZ_WIDTH                      4
#define LTC_IVSZ_IVSZ(x)                         (((uint32_t)(((uint32_t)(x))<<LTC_IVSZ_IVSZ_SHIFT))&LTC_IVSZ_IVSZ_MASK)
#define LTC_IVSZ_IL_MASK                         0x80000000u
#define LTC_IVSZ_IL_SHIFT                        31
#define LTC_IVSZ_IL_WIDTH                        1
#define LTC_IVSZ_IL(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_IVSZ_IL_SHIFT))&LTC_IVSZ_IL_MASK)
/* DPAMS Bit Fields */
#define LTC_DPAMS_DPAMS_MASK                     0xFFFFFFFFu
#define LTC_DPAMS_DPAMS_SHIFT                    0
#define LTC_DPAMS_DPAMS_WIDTH                    32
#define LTC_DPAMS_DPAMS(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_DPAMS_DPAMS_SHIFT))&LTC_DPAMS_DPAMS_MASK)
/* PKASZ Bit Fields */
#define LTC_PKASZ_PKASZ_MASK                     0x1FFu
#define LTC_PKASZ_PKASZ_SHIFT                    0
#define LTC_PKASZ_PKASZ_WIDTH                    9
#define LTC_PKASZ_PKASZ(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_PKASZ_PKASZ_SHIFT))&LTC_PKASZ_PKASZ_MASK)
/* PKBSZ Bit Fields */
#define LTC_PKBSZ_PKBSZ_MASK                     0x1FFu
#define LTC_PKBSZ_PKBSZ_SHIFT                    0
#define LTC_PKBSZ_PKBSZ_WIDTH                    9
#define LTC_PKBSZ_PKBSZ(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_PKBSZ_PKBSZ_SHIFT))&LTC_PKBSZ_PKBSZ_MASK)
/* PKNSZ Bit Fields */
#define LTC_PKNSZ_PKNSZ_MASK                     0x1FFu
#define LTC_PKNSZ_PKNSZ_SHIFT                    0
#define LTC_PKNSZ_PKNSZ_WIDTH                    9
#define LTC_PKNSZ_PKNSZ(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_PKNSZ_PKNSZ_SHIFT))&LTC_PKNSZ_PKNSZ_MASK)
/* PKESZ Bit Fields */
#define LTC_PKESZ_PKESZ_MASK                     0x1FFu
#define LTC_PKESZ_PKESZ_SHIFT                    0
#define LTC_PKESZ_PKESZ_WIDTH                    9
#define LTC_PKESZ_PKESZ(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_PKESZ_PKESZ_SHIFT))&LTC_PKESZ_PKESZ_MASK)
/* CTX Bit Fields */
#define LTC_CTX_CTX_MASK                         0xFFFFFFFFu
#define LTC_CTX_CTX_SHIFT                        0
#define LTC_CTX_CTX_WIDTH                        32
#define LTC_CTX_CTX(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_CTX_CTX_SHIFT))&LTC_CTX_CTX_MASK)
/* KEY Bit Fields */
#define LTC_KEY_KEY_MASK                         0xFFFFFFFFu
#define LTC_KEY_KEY_SHIFT                        0
#define LTC_KEY_KEY_WIDTH                        32
#define LTC_KEY_KEY(x)                           (((uint32_t)(((uint32_t)(x))<<LTC_KEY_KEY_SHIFT))&LTC_KEY_KEY_MASK)
/* VID1 Bit Fields */
#define LTC_VID1_MIN_REV_MASK                    0xFFu
#define LTC_VID1_MIN_REV_SHIFT                   0
#define LTC_VID1_MIN_REV_WIDTH                   8
#define LTC_VID1_MIN_REV(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_VID1_MIN_REV_SHIFT))&LTC_VID1_MIN_REV_MASK)
#define LTC_VID1_MAJ_REV_MASK                    0xFF00u
#define LTC_VID1_MAJ_REV_SHIFT                   8
#define LTC_VID1_MAJ_REV_WIDTH                   8
#define LTC_VID1_MAJ_REV(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_VID1_MAJ_REV_SHIFT))&LTC_VID1_MAJ_REV_MASK)
#define LTC_VID1_IP_ID_MASK                      0xFFFF0000u
#define LTC_VID1_IP_ID_SHIFT                     16
#define LTC_VID1_IP_ID_WIDTH                     16
#define LTC_VID1_IP_ID(x)                        (((uint32_t)(((uint32_t)(x))<<LTC_VID1_IP_ID_SHIFT))&LTC_VID1_IP_ID_MASK)
/* VID2 Bit Fields */
#define LTC_VID2_ECO_REV_MASK                    0xFFu
#define LTC_VID2_ECO_REV_SHIFT                   0
#define LTC_VID2_ECO_REV_WIDTH                   8
#define LTC_VID2_ECO_REV(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_VID2_ECO_REV_SHIFT))&LTC_VID2_ECO_REV_MASK)
#define LTC_VID2_ARCH_ERA_MASK                   0xFF00u
#define LTC_VID2_ARCH_ERA_SHIFT                  8
#define LTC_VID2_ARCH_ERA_WIDTH                  8
#define LTC_VID2_ARCH_ERA(x)                     (((uint32_t)(((uint32_t)(x))<<LTC_VID2_ARCH_ERA_SHIFT))&LTC_VID2_ARCH_ERA_MASK)
/* CHAVID Bit Fields */
#define LTC_CHAVID_AESREV_MASK                   0xFu
#define LTC_CHAVID_AESREV_SHIFT                  0
#define LTC_CHAVID_AESREV_WIDTH                  4
#define LTC_CHAVID_AESREV(x)                     (((uint32_t)(((uint32_t)(x))<<LTC_CHAVID_AESREV_SHIFT))&LTC_CHAVID_AESREV_MASK)
#define LTC_CHAVID_AESVID_MASK                   0xF0u
#define LTC_CHAVID_AESVID_SHIFT                  4
#define LTC_CHAVID_AESVID_WIDTH                  4
#define LTC_CHAVID_AESVID(x)                     (((uint32_t)(((uint32_t)(x))<<LTC_CHAVID_AESVID_SHIFT))&LTC_CHAVID_AESVID_MASK)
#define LTC_CHAVID_DESREV_MASK                   0xF00u
#define LTC_CHAVID_DESREV_SHIFT                  8
#define LTC_CHAVID_DESREV_WIDTH                  4
#define LTC_CHAVID_DESREV(x)                     (((uint32_t)(((uint32_t)(x))<<LTC_CHAVID_DESREV_SHIFT))&LTC_CHAVID_DESREV_MASK)
#define LTC_CHAVID_DESVID_MASK                   0xF000u
#define LTC_CHAVID_DESVID_SHIFT                  12
#define LTC_CHAVID_DESVID_WIDTH                  4
#define LTC_CHAVID_DESVID(x)                     (((uint32_t)(((uint32_t)(x))<<LTC_CHAVID_DESVID_SHIFT))&LTC_CHAVID_DESVID_MASK)
#define LTC_CHAVID_PKHAREV_MASK                  0xF0000u
#define LTC_CHAVID_PKHAREV_SHIFT                 16
#define LTC_CHAVID_PKHAREV_WIDTH                 4
#define LTC_CHAVID_PKHAREV(x)                    (((uint32_t)(((uint32_t)(x))<<LTC_CHAVID_PKHAREV_SHIFT))&LTC_CHAVID_PKHAREV_MASK)
#define LTC_CHAVID_PKHAVID_MASK                  0xF00000u
#define LTC_CHAVID_PKHAVID_SHIFT                 20
#define LTC_CHAVID_PKHAVID_WIDTH                 4
#define LTC_CHAVID_PKHAVID(x)                    (((uint32_t)(((uint32_t)(x))<<LTC_CHAVID_PKHAVID_SHIFT))&LTC_CHAVID_PKHAVID_MASK)
#define LTC_CHAVID_MDHAREV_MASK                  0xF000000u
#define LTC_CHAVID_MDHAREV_SHIFT                 24
#define LTC_CHAVID_MDHAREV_WIDTH                 4
#define LTC_CHAVID_MDHAREV(x)                    (((uint32_t)(((uint32_t)(x))<<LTC_CHAVID_MDHAREV_SHIFT))&LTC_CHAVID_MDHAREV_MASK)
#define LTC_CHAVID_MDHAVID_MASK                  0xF0000000u
#define LTC_CHAVID_MDHAVID_SHIFT                 28
#define LTC_CHAVID_MDHAVID_WIDTH                 4
#define LTC_CHAVID_MDHAVID(x)                    (((uint32_t)(((uint32_t)(x))<<LTC_CHAVID_MDHAVID_SHIFT))&LTC_CHAVID_MDHAVID_MASK)
/* FIFOSTA Bit Fields */
#define LTC_FIFOSTA_IFL_MASK                     0x7Fu
#define LTC_FIFOSTA_IFL_SHIFT                    0
#define LTC_FIFOSTA_IFL_WIDTH                    7
#define LTC_FIFOSTA_IFL(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_FIFOSTA_IFL_SHIFT))&LTC_FIFOSTA_IFL_MASK)
#define LTC_FIFOSTA_IFF_MASK                     0x8000u
#define LTC_FIFOSTA_IFF_SHIFT                    15
#define LTC_FIFOSTA_IFF_WIDTH                    1
#define LTC_FIFOSTA_IFF(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_FIFOSTA_IFF_SHIFT))&LTC_FIFOSTA_IFF_MASK)
#define LTC_FIFOSTA_OFL_MASK                     0x7F0000u
#define LTC_FIFOSTA_OFL_SHIFT                    16
#define LTC_FIFOSTA_OFL_WIDTH                    7
#define LTC_FIFOSTA_OFL(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_FIFOSTA_OFL_SHIFT))&LTC_FIFOSTA_OFL_MASK)
#define LTC_FIFOSTA_OFF_MASK                     0x80000000u
#define LTC_FIFOSTA_OFF_SHIFT                    31
#define LTC_FIFOSTA_OFF_WIDTH                    1
#define LTC_FIFOSTA_OFF(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_FIFOSTA_OFF_SHIFT))&LTC_FIFOSTA_OFF_MASK)
/* IFIFO Bit Fields */
#define LTC_IFIFO_IFIFO_MASK                     0xFFFFFFFFu
#define LTC_IFIFO_IFIFO_SHIFT                    0
#define LTC_IFIFO_IFIFO_WIDTH                    32
#define LTC_IFIFO_IFIFO(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_IFIFO_IFIFO_SHIFT))&LTC_IFIFO_IFIFO_MASK)
/* OFIFO Bit Fields */
#define LTC_OFIFO_OFIFO_MASK                     0xFFFFFFFFu
#define LTC_OFIFO_OFIFO_SHIFT                    0
#define LTC_OFIFO_OFIFO_WIDTH                    32
#define LTC_OFIFO_OFIFO(x)                       (((uint32_t)(((uint32_t)(x))<<LTC_OFIFO_OFIFO_SHIFT))&LTC_OFIFO_OFIFO_MASK)
/* PKA0 Bit Fields */
#define LTC_PKA0_PKHA_A0_MASK                    0xFFFFFFFFu
#define LTC_PKA0_PKHA_A0_SHIFT                   0
#define LTC_PKA0_PKHA_A0_WIDTH                   32
#define LTC_PKA0_PKHA_A0(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKA0_PKHA_A0_SHIFT))&LTC_PKA0_PKHA_A0_MASK)
/* PKA1 Bit Fields */
#define LTC_PKA1_PKHA_A1_MASK                    0xFFFFFFFFu
#define LTC_PKA1_PKHA_A1_SHIFT                   0
#define LTC_PKA1_PKHA_A1_WIDTH                   32
#define LTC_PKA1_PKHA_A1(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKA1_PKHA_A1_SHIFT))&LTC_PKA1_PKHA_A1_MASK)
/* PKA2 Bit Fields */
#define LTC_PKA2_PKHA_A2_MASK                    0xFFFFFFFFu
#define LTC_PKA2_PKHA_A2_SHIFT                   0
#define LTC_PKA2_PKHA_A2_WIDTH                   32
#define LTC_PKA2_PKHA_A2(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKA2_PKHA_A2_SHIFT))&LTC_PKA2_PKHA_A2_MASK)
/* PKA3 Bit Fields */
#define LTC_PKA3_PKHA_A3_MASK                    0xFFFFFFFFu
#define LTC_PKA3_PKHA_A3_SHIFT                   0
#define LTC_PKA3_PKHA_A3_WIDTH                   32
#define LTC_PKA3_PKHA_A3(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKA3_PKHA_A3_SHIFT))&LTC_PKA3_PKHA_A3_MASK)
/* PKB0 Bit Fields */
#define LTC_PKB0_PKHA_B0_MASK                    0xFFFFFFFFu
#define LTC_PKB0_PKHA_B0_SHIFT                   0
#define LTC_PKB0_PKHA_B0_WIDTH                   32
#define LTC_PKB0_PKHA_B0(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKB0_PKHA_B0_SHIFT))&LTC_PKB0_PKHA_B0_MASK)
/* PKB1 Bit Fields */
#define LTC_PKB1_PKHA_B1_MASK                    0xFFFFFFFFu
#define LTC_PKB1_PKHA_B1_SHIFT                   0
#define LTC_PKB1_PKHA_B1_WIDTH                   32
#define LTC_PKB1_PKHA_B1(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKB1_PKHA_B1_SHIFT))&LTC_PKB1_PKHA_B1_MASK)
/* PKB2 Bit Fields */
#define LTC_PKB2_PKHA_B2_MASK                    0xFFFFFFFFu
#define LTC_PKB2_PKHA_B2_SHIFT                   0
#define LTC_PKB2_PKHA_B2_WIDTH                   32
#define LTC_PKB2_PKHA_B2(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKB2_PKHA_B2_SHIFT))&LTC_PKB2_PKHA_B2_MASK)
/* PKB3 Bit Fields */
#define LTC_PKB3_PKHA_B3_MASK                    0xFFFFFFFFu
#define LTC_PKB3_PKHA_B3_SHIFT                   0
#define LTC_PKB3_PKHA_B3_WIDTH                   32
#define LTC_PKB3_PKHA_B3(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKB3_PKHA_B3_SHIFT))&LTC_PKB3_PKHA_B3_MASK)
/* PKN0 Bit Fields */
#define LTC_PKN0_PKHA_N0_MASK                    0xFFFFFFFFu
#define LTC_PKN0_PKHA_N0_SHIFT                   0
#define LTC_PKN0_PKHA_N0_WIDTH                   32
#define LTC_PKN0_PKHA_N0(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKN0_PKHA_N0_SHIFT))&LTC_PKN0_PKHA_N0_MASK)
/* PKN1 Bit Fields */
#define LTC_PKN1_PKHA_N1_MASK                    0xFFFFFFFFu
#define LTC_PKN1_PKHA_N1_SHIFT                   0
#define LTC_PKN1_PKHA_N1_WIDTH                   32
#define LTC_PKN1_PKHA_N1(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKN1_PKHA_N1_SHIFT))&LTC_PKN1_PKHA_N1_MASK)
/* PKN2 Bit Fields */
#define LTC_PKN2_PKHA_N2_MASK                    0xFFFFFFFFu
#define LTC_PKN2_PKHA_N2_SHIFT                   0
#define LTC_PKN2_PKHA_N2_WIDTH                   32
#define LTC_PKN2_PKHA_N2(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKN2_PKHA_N2_SHIFT))&LTC_PKN2_PKHA_N2_MASK)
/* PKN3 Bit Fields */
#define LTC_PKN3_PKHA_N3_MASK                    0xFFFFFFFFu
#define LTC_PKN3_PKHA_N3_SHIFT                   0
#define LTC_PKN3_PKHA_N3_WIDTH                   32
#define LTC_PKN3_PKHA_N3(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKN3_PKHA_N3_SHIFT))&LTC_PKN3_PKHA_N3_MASK)
/* PKE0 Bit Fields */
#define LTC_PKE0_PKHA_E0_MASK                    0xFFFFFFFFu
#define LTC_PKE0_PKHA_E0_SHIFT                   0
#define LTC_PKE0_PKHA_E0_WIDTH                   32
#define LTC_PKE0_PKHA_E0(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKE0_PKHA_E0_SHIFT))&LTC_PKE0_PKHA_E0_MASK)
/* PKE1 Bit Fields */
#define LTC_PKE1_PKHA_E1_MASK                    0xFFFFFFFFu
#define LTC_PKE1_PKHA_E1_SHIFT                   0
#define LTC_PKE1_PKHA_E1_WIDTH                   32
#define LTC_PKE1_PKHA_E1(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKE1_PKHA_E1_SHIFT))&LTC_PKE1_PKHA_E1_MASK)
/* PKE2 Bit Fields */
#define LTC_PKE2_PKHA_E2_MASK                    0xFFFFFFFFu
#define LTC_PKE2_PKHA_E2_SHIFT                   0
#define LTC_PKE2_PKHA_E2_WIDTH                   32
#define LTC_PKE2_PKHA_E2(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKE2_PKHA_E2_SHIFT))&LTC_PKE2_PKHA_E2_MASK)
/* PKE3 Bit Fields */
#define LTC_PKE3_PKHA_E3_MASK                    0xFFFFFFFFu
#define LTC_PKE3_PKHA_E3_SHIFT                   0
#define LTC_PKE3_PKHA_E3_WIDTH                   32
#define LTC_PKE3_PKHA_E3(x)                      (((uint32_t)(((uint32_t)(x))<<LTC_PKE3_PKHA_E3_SHIFT))&LTC_PKE3_PKHA_E3_MASK)

/*!
 * @}
 */ /* end of group LTC_Register_Masks */


/* LTC - Peripheral instance base addresses */
/** Peripheral LTC0 base address */
#define LTC0_BASE                                (0x40051000u)
/** Peripheral LTC0 base pointer */
#define LTC0                                     ((LTC_Type *)LTC0_BASE)
#define LTC0_BASE_PTR                            (LTC0)
/** Array initializer of LTC peripheral base addresses */
#define LTC_BASE_ADDRS                           { LTC0_BASE }
/** Array initializer of LTC peripheral base pointers */
#define LTC_BASE_PTRS                            { LTC0 }

/* ----------------------------------------------------------------------------
   -- LTC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LTC_Register_Accessor_Macros LTC - Register accessor macros
 * @{
 */


/* LTC - Register instance definitions */
/* LTC0 */
#define LTC0_MD                                  LTC_MD_REG(LTC0)
#define LTC0_MDPK                                LTC_MDPK_REG(LTC0)
#define LTC0_KS                                  LTC_KS_REG(LTC0)
#define LTC0_DS                                  LTC_DS_REG(LTC0)
#define LTC0_ICVS                                LTC_ICVS_REG(LTC0)
#define LTC0_COM                                 LTC_COM_REG(LTC0)
#define LTC0_CTL                                 LTC_CTL_REG(LTC0)
#define LTC0_CW                                  LTC_CW_REG(LTC0)
#define LTC0_STA                                 LTC_STA_REG(LTC0)
#define LTC0_ESTA                                LTC_ESTA_REG(LTC0)
#define LTC0_AADSZ                               LTC_AADSZ_REG(LTC0)
#define LTC0_IVSZ                                LTC_IVSZ_REG(LTC0)
#define LTC0_DPAMS                               LTC_DPAMS_REG(LTC0)
#define LTC0_PKASZ                               LTC_PKASZ_REG(LTC0)
#define LTC0_PKBSZ                               LTC_PKBSZ_REG(LTC0)
#define LTC0_PKNSZ                               LTC_PKNSZ_REG(LTC0)
#define LTC0_PKESZ                               LTC_PKESZ_REG(LTC0)
#define LTC0_CTX_0                               LTC_CTX_REG(LTC0,0)
#define LTC0_CTX_1                               LTC_CTX_REG(LTC0,1)
#define LTC0_CTX_2                               LTC_CTX_REG(LTC0,2)
#define LTC0_CTX_3                               LTC_CTX_REG(LTC0,3)
#define LTC0_CTX_4                               LTC_CTX_REG(LTC0,4)
#define LTC0_CTX_5                               LTC_CTX_REG(LTC0,5)
#define LTC0_CTX_6                               LTC_CTX_REG(LTC0,6)
#define LTC0_CTX_7                               LTC_CTX_REG(LTC0,7)
#define LTC0_CTX_8                               LTC_CTX_REG(LTC0,8)
#define LTC0_CTX_9                               LTC_CTX_REG(LTC0,9)
#define LTC0_CTX_10                              LTC_CTX_REG(LTC0,10)
#define LTC0_CTX_11                              LTC_CTX_REG(LTC0,11)
#define LTC0_CTX_12                              LTC_CTX_REG(LTC0,12)
#define LTC0_CTX_13                              LTC_CTX_REG(LTC0,13)
#define LTC0_CTX_14                              LTC_CTX_REG(LTC0,14)
#define LTC0_CTX_15                              LTC_CTX_REG(LTC0,15)
#define LTC0_KEY_0                               LTC_KEY_REG(LTC0,0)
#define LTC0_KEY_1                               LTC_KEY_REG(LTC0,1)
#define LTC0_KEY_2                               LTC_KEY_REG(LTC0,2)
#define LTC0_KEY_3                               LTC_KEY_REG(LTC0,3)
#define LTC0_KEY_4                               LTC_KEY_REG(LTC0,4)
#define LTC0_KEY_5                               LTC_KEY_REG(LTC0,5)
#define LTC0_KEY_6                               LTC_KEY_REG(LTC0,6)
#define LTC0_KEY_7                               LTC_KEY_REG(LTC0,7)
#define LTC0_VID1                                LTC_VID1_REG(LTC0)
#define LTC0_VID2                                LTC_VID2_REG(LTC0)
#define LTC0_CHAVID                              LTC_CHAVID_REG(LTC0)
#define LTC0_FIFOSTA                             LTC_FIFOSTA_REG(LTC0)
#define LTC0_IFIFO                               LTC_IFIFO_REG(LTC0)
#define LTC0_OFIFO                               LTC_OFIFO_REG(LTC0)
#define LTC0_PKA0_0                              LTC_PKA0_REG(LTC0,0)
#define LTC0_PKA_0                               LTC_PKA_REG(LTC0,0)
#define LTC0_PKA0_1                              LTC_PKA0_REG(LTC0,1)
#define LTC0_PKA_1                               LTC_PKA_REG(LTC0,1)
#define LTC0_PKA0_2                              LTC_PKA0_REG(LTC0,2)
#define LTC0_PKA_2                               LTC_PKA_REG(LTC0,2)
#define LTC0_PKA0_3                              LTC_PKA0_REG(LTC0,3)
#define LTC0_PKA_3                               LTC_PKA_REG(LTC0,3)
#define LTC0_PKA0_4                              LTC_PKA0_REG(LTC0,4)
#define LTC0_PKA_4                               LTC_PKA_REG(LTC0,4)
#define LTC0_PKA0_5                              LTC_PKA0_REG(LTC0,5)
#define LTC0_PKA_5                               LTC_PKA_REG(LTC0,5)
#define LTC0_PKA0_6                              LTC_PKA0_REG(LTC0,6)
#define LTC0_PKA_6                               LTC_PKA_REG(LTC0,6)
#define LTC0_PKA0_7                              LTC_PKA0_REG(LTC0,7)
#define LTC0_PKA_7                               LTC_PKA_REG(LTC0,7)
#define LTC0_PKA0_8                              LTC_PKA0_REG(LTC0,8)
#define LTC0_PKA_8                               LTC_PKA_REG(LTC0,8)
#define LTC0_PKA0_9                              LTC_PKA0_REG(LTC0,9)
#define LTC0_PKA_9                               LTC_PKA_REG(LTC0,9)
#define LTC0_PKA0_10                             LTC_PKA0_REG(LTC0,10)
#define LTC0_PKA_10                              LTC_PKA_REG(LTC0,10)
#define LTC0_PKA0_11                             LTC_PKA0_REG(LTC0,11)
#define LTC0_PKA_11                              LTC_PKA_REG(LTC0,11)
#define LTC0_PKA0_12                             LTC_PKA0_REG(LTC0,12)
#define LTC0_PKA_12                              LTC_PKA_REG(LTC0,12)
#define LTC0_PKA0_13                             LTC_PKA0_REG(LTC0,13)
#define LTC0_PKA_13                              LTC_PKA_REG(LTC0,13)
#define LTC0_PKA0_14                             LTC_PKA0_REG(LTC0,14)
#define LTC0_PKA_14                              LTC_PKA_REG(LTC0,14)
#define LTC0_PKA0_15                             LTC_PKA0_REG(LTC0,15)
#define LTC0_PKA_15                              LTC_PKA_REG(LTC0,15)
#define LTC0_PKA1_0                              LTC_PKA1_REG(LTC0,0)
#define LTC0_PKA_16                              LTC_PKA_REG(LTC0,16)
#define LTC0_PKA1_1                              LTC_PKA1_REG(LTC0,1)
#define LTC0_PKA_17                              LTC_PKA_REG(LTC0,17)
#define LTC0_PKA1_2                              LTC_PKA1_REG(LTC0,2)
#define LTC0_PKA_18                              LTC_PKA_REG(LTC0,18)
#define LTC0_PKA1_3                              LTC_PKA1_REG(LTC0,3)
#define LTC0_PKA_19                              LTC_PKA_REG(LTC0,19)
#define LTC0_PKA1_4                              LTC_PKA1_REG(LTC0,4)
#define LTC0_PKA_20                              LTC_PKA_REG(LTC0,20)
#define LTC0_PKA1_5                              LTC_PKA1_REG(LTC0,5)
#define LTC0_PKA_21                              LTC_PKA_REG(LTC0,21)
#define LTC0_PKA1_6                              LTC_PKA1_REG(LTC0,6)
#define LTC0_PKA_22                              LTC_PKA_REG(LTC0,22)
#define LTC0_PKA1_7                              LTC_PKA1_REG(LTC0,7)
#define LTC0_PKA_23                              LTC_PKA_REG(LTC0,23)
#define LTC0_PKA1_8                              LTC_PKA1_REG(LTC0,8)
#define LTC0_PKA_24                              LTC_PKA_REG(LTC0,24)
#define LTC0_PKA1_9                              LTC_PKA1_REG(LTC0,9)
#define LTC0_PKA_25                              LTC_PKA_REG(LTC0,25)
#define LTC0_PKA1_10                             LTC_PKA1_REG(LTC0,10)
#define LTC0_PKA_26                              LTC_PKA_REG(LTC0,26)
#define LTC0_PKA1_11                             LTC_PKA1_REG(LTC0,11)
#define LTC0_PKA_27                              LTC_PKA_REG(LTC0,27)
#define LTC0_PKA1_12                             LTC_PKA1_REG(LTC0,12)
#define LTC0_PKA_28                              LTC_PKA_REG(LTC0,28)
#define LTC0_PKA1_13                             LTC_PKA1_REG(LTC0,13)
#define LTC0_PKA_29                              LTC_PKA_REG(LTC0,29)
#define LTC0_PKA1_14                             LTC_PKA1_REG(LTC0,14)
#define LTC0_PKA_30                              LTC_PKA_REG(LTC0,30)
#define LTC0_PKA1_15                             LTC_PKA1_REG(LTC0,15)
#define LTC0_PKA_31                              LTC_PKA_REG(LTC0,31)
#define LTC0_PKA2_0                              LTC_PKA2_REG(LTC0,0)
#define LTC0_PKA_32                              LTC_PKA_REG(LTC0,32)
#define LTC0_PKA2_1                              LTC_PKA2_REG(LTC0,1)
#define LTC0_PKA_33                              LTC_PKA_REG(LTC0,33)
#define LTC0_PKA2_2                              LTC_PKA2_REG(LTC0,2)
#define LTC0_PKA_34                              LTC_PKA_REG(LTC0,34)
#define LTC0_PKA2_3                              LTC_PKA2_REG(LTC0,3)
#define LTC0_PKA_35                              LTC_PKA_REG(LTC0,35)
#define LTC0_PKA2_4                              LTC_PKA2_REG(LTC0,4)
#define LTC0_PKA_36                              LTC_PKA_REG(LTC0,36)
#define LTC0_PKA2_5                              LTC_PKA2_REG(LTC0,5)
#define LTC0_PKA_37                              LTC_PKA_REG(LTC0,37)
#define LTC0_PKA2_6                              LTC_PKA2_REG(LTC0,6)
#define LTC0_PKA_38                              LTC_PKA_REG(LTC0,38)
#define LTC0_PKA2_7                              LTC_PKA2_REG(LTC0,7)
#define LTC0_PKA_39                              LTC_PKA_REG(LTC0,39)
#define LTC0_PKA2_8                              LTC_PKA2_REG(LTC0,8)
#define LTC0_PKA_40                              LTC_PKA_REG(LTC0,40)
#define LTC0_PKA2_9                              LTC_PKA2_REG(LTC0,9)
#define LTC0_PKA_41                              LTC_PKA_REG(LTC0,41)
#define LTC0_PKA2_10                             LTC_PKA2_REG(LTC0,10)
#define LTC0_PKA_42                              LTC_PKA_REG(LTC0,42)
#define LTC0_PKA2_11                             LTC_PKA2_REG(LTC0,11)
#define LTC0_PKA_43                              LTC_PKA_REG(LTC0,43)
#define LTC0_PKA2_12                             LTC_PKA2_REG(LTC0,12)
#define LTC0_PKA_44                              LTC_PKA_REG(LTC0,44)
#define LTC0_PKA2_13                             LTC_PKA2_REG(LTC0,13)
#define LTC0_PKA_45                              LTC_PKA_REG(LTC0,45)
#define LTC0_PKA2_14                             LTC_PKA2_REG(LTC0,14)
#define LTC0_PKA_46                              LTC_PKA_REG(LTC0,46)
#define LTC0_PKA2_15                             LTC_PKA2_REG(LTC0,15)
#define LTC0_PKA_47                              LTC_PKA_REG(LTC0,47)
#define LTC0_PKA3_0                              LTC_PKA3_REG(LTC0,0)
#define LTC0_PKA_48                              LTC_PKA_REG(LTC0,48)
#define LTC0_PKA3_1                              LTC_PKA3_REG(LTC0,1)
#define LTC0_PKA_49                              LTC_PKA_REG(LTC0,49)
#define LTC0_PKA3_2                              LTC_PKA3_REG(LTC0,2)
#define LTC0_PKA_50                              LTC_PKA_REG(LTC0,50)
#define LTC0_PKA3_3                              LTC_PKA3_REG(LTC0,3)
#define LTC0_PKA_51                              LTC_PKA_REG(LTC0,51)
#define LTC0_PKA3_4                              LTC_PKA3_REG(LTC0,4)
#define LTC0_PKA_52                              LTC_PKA_REG(LTC0,52)
#define LTC0_PKA3_5                              LTC_PKA3_REG(LTC0,5)
#define LTC0_PKA_53                              LTC_PKA_REG(LTC0,53)
#define LTC0_PKA3_6                              LTC_PKA3_REG(LTC0,6)
#define LTC0_PKA_54                              LTC_PKA_REG(LTC0,54)
#define LTC0_PKA3_7                              LTC_PKA3_REG(LTC0,7)
#define LTC0_PKA_55                              LTC_PKA_REG(LTC0,55)
#define LTC0_PKA3_8                              LTC_PKA3_REG(LTC0,8)
#define LTC0_PKA_56                              LTC_PKA_REG(LTC0,56)
#define LTC0_PKA3_9                              LTC_PKA3_REG(LTC0,9)
#define LTC0_PKA_57                              LTC_PKA_REG(LTC0,57)
#define LTC0_PKA3_10                             LTC_PKA3_REG(LTC0,10)
#define LTC0_PKA_58                              LTC_PKA_REG(LTC0,58)
#define LTC0_PKA3_11                             LTC_PKA3_REG(LTC0,11)
#define LTC0_PKA_59                              LTC_PKA_REG(LTC0,59)
#define LTC0_PKA3_12                             LTC_PKA3_REG(LTC0,12)
#define LTC0_PKA_60                              LTC_PKA_REG(LTC0,60)
#define LTC0_PKA3_13                             LTC_PKA3_REG(LTC0,13)
#define LTC0_PKA_61                              LTC_PKA_REG(LTC0,61)
#define LTC0_PKA3_14                             LTC_PKA3_REG(LTC0,14)
#define LTC0_PKA_62                              LTC_PKA_REG(LTC0,62)
#define LTC0_PKA3_15                             LTC_PKA3_REG(LTC0,15)
#define LTC0_PKA_63                              LTC_PKA_REG(LTC0,63)
#define LTC0_PKB0_0                              LTC_PKB0_REG(LTC0,0)
#define LTC0_PKB_0                               LTC_PKB_REG(LTC0,0)
#define LTC0_PKB0_1                              LTC_PKB0_REG(LTC0,1)
#define LTC0_PKB_1                               LTC_PKB_REG(LTC0,1)
#define LTC0_PKB0_2                              LTC_PKB0_REG(LTC0,2)
#define LTC0_PKB_2                               LTC_PKB_REG(LTC0,2)
#define LTC0_PKB0_3                              LTC_PKB0_REG(LTC0,3)
#define LTC0_PKB_3                               LTC_PKB_REG(LTC0,3)
#define LTC0_PKB0_4                              LTC_PKB0_REG(LTC0,4)
#define LTC0_PKB_4                               LTC_PKB_REG(LTC0,4)
#define LTC0_PKB0_5                              LTC_PKB0_REG(LTC0,5)
#define LTC0_PKB_5                               LTC_PKB_REG(LTC0,5)
#define LTC0_PKB0_6                              LTC_PKB0_REG(LTC0,6)
#define LTC0_PKB_6                               LTC_PKB_REG(LTC0,6)
#define LTC0_PKB0_7                              LTC_PKB0_REG(LTC0,7)
#define LTC0_PKB_7                               LTC_PKB_REG(LTC0,7)
#define LTC0_PKB0_8                              LTC_PKB0_REG(LTC0,8)
#define LTC0_PKB_8                               LTC_PKB_REG(LTC0,8)
#define LTC0_PKB0_9                              LTC_PKB0_REG(LTC0,9)
#define LTC0_PKB_9                               LTC_PKB_REG(LTC0,9)
#define LTC0_PKB0_10                             LTC_PKB0_REG(LTC0,10)
#define LTC0_PKB_10                              LTC_PKB_REG(LTC0,10)
#define LTC0_PKB0_11                             LTC_PKB0_REG(LTC0,11)
#define LTC0_PKB_11                              LTC_PKB_REG(LTC0,11)
#define LTC0_PKB0_12                             LTC_PKB0_REG(LTC0,12)
#define LTC0_PKB_12                              LTC_PKB_REG(LTC0,12)
#define LTC0_PKB0_13                             LTC_PKB0_REG(LTC0,13)
#define LTC0_PKB_13                              LTC_PKB_REG(LTC0,13)
#define LTC0_PKB0_14                             LTC_PKB0_REG(LTC0,14)
#define LTC0_PKB_14                              LTC_PKB_REG(LTC0,14)
#define LTC0_PKB0_15                             LTC_PKB0_REG(LTC0,15)
#define LTC0_PKB_15                              LTC_PKB_REG(LTC0,15)
#define LTC0_PKB1_0                              LTC_PKB1_REG(LTC0,0)
#define LTC0_PKB_16                              LTC_PKB_REG(LTC0,16)
#define LTC0_PKB1_1                              LTC_PKB1_REG(LTC0,1)
#define LTC0_PKB_17                              LTC_PKB_REG(LTC0,17)
#define LTC0_PKB1_2                              LTC_PKB1_REG(LTC0,2)
#define LTC0_PKB_18                              LTC_PKB_REG(LTC0,18)
#define LTC0_PKB1_3                              LTC_PKB1_REG(LTC0,3)
#define LTC0_PKB_19                              LTC_PKB_REG(LTC0,19)
#define LTC0_PKB1_4                              LTC_PKB1_REG(LTC0,4)
#define LTC0_PKB_20                              LTC_PKB_REG(LTC0,20)
#define LTC0_PKB1_5                              LTC_PKB1_REG(LTC0,5)
#define LTC0_PKB_21                              LTC_PKB_REG(LTC0,21)
#define LTC0_PKB1_6                              LTC_PKB1_REG(LTC0,6)
#define LTC0_PKB_22                              LTC_PKB_REG(LTC0,22)
#define LTC0_PKB1_7                              LTC_PKB1_REG(LTC0,7)
#define LTC0_PKB_23                              LTC_PKB_REG(LTC0,23)
#define LTC0_PKB1_8                              LTC_PKB1_REG(LTC0,8)
#define LTC0_PKB_24                              LTC_PKB_REG(LTC0,24)
#define LTC0_PKB1_9                              LTC_PKB1_REG(LTC0,9)
#define LTC0_PKB_25                              LTC_PKB_REG(LTC0,25)
#define LTC0_PKB1_10                             LTC_PKB1_REG(LTC0,10)
#define LTC0_PKB_26                              LTC_PKB_REG(LTC0,26)
#define LTC0_PKB1_11                             LTC_PKB1_REG(LTC0,11)
#define LTC0_PKB_27                              LTC_PKB_REG(LTC0,27)
#define LTC0_PKB1_12                             LTC_PKB1_REG(LTC0,12)
#define LTC0_PKB_28                              LTC_PKB_REG(LTC0,28)
#define LTC0_PKB1_13                             LTC_PKB1_REG(LTC0,13)
#define LTC0_PKB_29                              LTC_PKB_REG(LTC0,29)
#define LTC0_PKB1_14                             LTC_PKB1_REG(LTC0,14)
#define LTC0_PKB_30                              LTC_PKB_REG(LTC0,30)
#define LTC0_PKB1_15                             LTC_PKB1_REG(LTC0,15)
#define LTC0_PKB_31                              LTC_PKB_REG(LTC0,31)
#define LTC0_PKB2_0                              LTC_PKB2_REG(LTC0,0)
#define LTC0_PKB_32                              LTC_PKB_REG(LTC0,32)
#define LTC0_PKB2_1                              LTC_PKB2_REG(LTC0,1)
#define LTC0_PKB_33                              LTC_PKB_REG(LTC0,33)
#define LTC0_PKB2_2                              LTC_PKB2_REG(LTC0,2)
#define LTC0_PKB_34                              LTC_PKB_REG(LTC0,34)
#define LTC0_PKB2_3                              LTC_PKB2_REG(LTC0,3)
#define LTC0_PKB_35                              LTC_PKB_REG(LTC0,35)
#define LTC0_PKB2_4                              LTC_PKB2_REG(LTC0,4)
#define LTC0_PKB_36                              LTC_PKB_REG(LTC0,36)
#define LTC0_PKB2_5                              LTC_PKB2_REG(LTC0,5)
#define LTC0_PKB_37                              LTC_PKB_REG(LTC0,37)
#define LTC0_PKB2_6                              LTC_PKB2_REG(LTC0,6)
#define LTC0_PKB_38                              LTC_PKB_REG(LTC0,38)
#define LTC0_PKB2_7                              LTC_PKB2_REG(LTC0,7)
#define LTC0_PKB_39                              LTC_PKB_REG(LTC0,39)
#define LTC0_PKB2_8                              LTC_PKB2_REG(LTC0,8)
#define LTC0_PKB_40                              LTC_PKB_REG(LTC0,40)
#define LTC0_PKB2_9                              LTC_PKB2_REG(LTC0,9)
#define LTC0_PKB_41                              LTC_PKB_REG(LTC0,41)
#define LTC0_PKB2_10                             LTC_PKB2_REG(LTC0,10)
#define LTC0_PKB_42                              LTC_PKB_REG(LTC0,42)
#define LTC0_PKB2_11                             LTC_PKB2_REG(LTC0,11)
#define LTC0_PKB_43                              LTC_PKB_REG(LTC0,43)
#define LTC0_PKB2_12                             LTC_PKB2_REG(LTC0,12)
#define LTC0_PKB_44                              LTC_PKB_REG(LTC0,44)
#define LTC0_PKB2_13                             LTC_PKB2_REG(LTC0,13)
#define LTC0_PKB_45                              LTC_PKB_REG(LTC0,45)
#define LTC0_PKB2_14                             LTC_PKB2_REG(LTC0,14)
#define LTC0_PKB_46                              LTC_PKB_REG(LTC0,46)
#define LTC0_PKB2_15                             LTC_PKB2_REG(LTC0,15)
#define LTC0_PKB_47                              LTC_PKB_REG(LTC0,47)
#define LTC0_PKB3_0                              LTC_PKB3_REG(LTC0,0)
#define LTC0_PKB_48                              LTC_PKB_REG(LTC0,48)
#define LTC0_PKB3_1                              LTC_PKB3_REG(LTC0,1)
#define LTC0_PKB_49                              LTC_PKB_REG(LTC0,49)
#define LTC0_PKB3_2                              LTC_PKB3_REG(LTC0,2)
#define LTC0_PKB_50                              LTC_PKB_REG(LTC0,50)
#define LTC0_PKB3_3                              LTC_PKB3_REG(LTC0,3)
#define LTC0_PKB_51                              LTC_PKB_REG(LTC0,51)
#define LTC0_PKB3_4                              LTC_PKB3_REG(LTC0,4)
#define LTC0_PKB_52                              LTC_PKB_REG(LTC0,52)
#define LTC0_PKB3_5                              LTC_PKB3_REG(LTC0,5)
#define LTC0_PKB_53                              LTC_PKB_REG(LTC0,53)
#define LTC0_PKB3_6                              LTC_PKB3_REG(LTC0,6)
#define LTC0_PKB_54                              LTC_PKB_REG(LTC0,54)
#define LTC0_PKB3_7                              LTC_PKB3_REG(LTC0,7)
#define LTC0_PKB_55                              LTC_PKB_REG(LTC0,55)
#define LTC0_PKB3_8                              LTC_PKB3_REG(LTC0,8)
#define LTC0_PKB_56                              LTC_PKB_REG(LTC0,56)
#define LTC0_PKB3_9                              LTC_PKB3_REG(LTC0,9)
#define LTC0_PKB_57                              LTC_PKB_REG(LTC0,57)
#define LTC0_PKB3_10                             LTC_PKB3_REG(LTC0,10)
#define LTC0_PKB_58                              LTC_PKB_REG(LTC0,58)
#define LTC0_PKB3_11                             LTC_PKB3_REG(LTC0,11)
#define LTC0_PKB_59                              LTC_PKB_REG(LTC0,59)
#define LTC0_PKB3_12                             LTC_PKB3_REG(LTC0,12)
#define LTC0_PKB_60                              LTC_PKB_REG(LTC0,60)
#define LTC0_PKB3_13                             LTC_PKB3_REG(LTC0,13)
#define LTC0_PKB_61                              LTC_PKB_REG(LTC0,61)
#define LTC0_PKB3_14                             LTC_PKB3_REG(LTC0,14)
#define LTC0_PKB_62                              LTC_PKB_REG(LTC0,62)
#define LTC0_PKB3_15                             LTC_PKB3_REG(LTC0,15)
#define LTC0_PKB_63                              LTC_PKB_REG(LTC0,63)
#define LTC0_PKN0_0                              LTC_PKN0_REG(LTC0,0)
#define LTC0_PKN_0                               LTC_PKN_REG(LTC0,0)
#define LTC0_PKN0_1                              LTC_PKN0_REG(LTC0,1)
#define LTC0_PKN_1                               LTC_PKN_REG(LTC0,1)
#define LTC0_PKN0_2                              LTC_PKN0_REG(LTC0,2)
#define LTC0_PKN_2                               LTC_PKN_REG(LTC0,2)
#define LTC0_PKN0_3                              LTC_PKN0_REG(LTC0,3)
#define LTC0_PKN_3                               LTC_PKN_REG(LTC0,3)
#define LTC0_PKN0_4                              LTC_PKN0_REG(LTC0,4)
#define LTC0_PKN_4                               LTC_PKN_REG(LTC0,4)
#define LTC0_PKN0_5                              LTC_PKN0_REG(LTC0,5)
#define LTC0_PKN_5                               LTC_PKN_REG(LTC0,5)
#define LTC0_PKN0_6                              LTC_PKN0_REG(LTC0,6)
#define LTC0_PKN_6                               LTC_PKN_REG(LTC0,6)
#define LTC0_PKN0_7                              LTC_PKN0_REG(LTC0,7)
#define LTC0_PKN_7                               LTC_PKN_REG(LTC0,7)
#define LTC0_PKN0_8                              LTC_PKN0_REG(LTC0,8)
#define LTC0_PKN_8                               LTC_PKN_REG(LTC0,8)
#define LTC0_PKN0_9                              LTC_PKN0_REG(LTC0,9)
#define LTC0_PKN_9                               LTC_PKN_REG(LTC0,9)
#define LTC0_PKN0_10                             LTC_PKN0_REG(LTC0,10)
#define LTC0_PKN_10                              LTC_PKN_REG(LTC0,10)
#define LTC0_PKN0_11                             LTC_PKN0_REG(LTC0,11)
#define LTC0_PKN_11                              LTC_PKN_REG(LTC0,11)
#define LTC0_PKN0_12                             LTC_PKN0_REG(LTC0,12)
#define LTC0_PKN_12                              LTC_PKN_REG(LTC0,12)
#define LTC0_PKN0_13                             LTC_PKN0_REG(LTC0,13)
#define LTC0_PKN_13                              LTC_PKN_REG(LTC0,13)
#define LTC0_PKN0_14                             LTC_PKN0_REG(LTC0,14)
#define LTC0_PKN_14                              LTC_PKN_REG(LTC0,14)
#define LTC0_PKN0_15                             LTC_PKN0_REG(LTC0,15)
#define LTC0_PKN_15                              LTC_PKN_REG(LTC0,15)
#define LTC0_PKN1_0                              LTC_PKN1_REG(LTC0,0)
#define LTC0_PKN_16                              LTC_PKN_REG(LTC0,16)
#define LTC0_PKN1_1                              LTC_PKN1_REG(LTC0,1)
#define LTC0_PKN_17                              LTC_PKN_REG(LTC0,17)
#define LTC0_PKN1_2                              LTC_PKN1_REG(LTC0,2)
#define LTC0_PKN_18                              LTC_PKN_REG(LTC0,18)
#define LTC0_PKN1_3                              LTC_PKN1_REG(LTC0,3)
#define LTC0_PKN_19                              LTC_PKN_REG(LTC0,19)
#define LTC0_PKN1_4                              LTC_PKN1_REG(LTC0,4)
#define LTC0_PKN_20                              LTC_PKN_REG(LTC0,20)
#define LTC0_PKN1_5                              LTC_PKN1_REG(LTC0,5)
#define LTC0_PKN_21                              LTC_PKN_REG(LTC0,21)
#define LTC0_PKN1_6                              LTC_PKN1_REG(LTC0,6)
#define LTC0_PKN_22                              LTC_PKN_REG(LTC0,22)
#define LTC0_PKN1_7                              LTC_PKN1_REG(LTC0,7)
#define LTC0_PKN_23                              LTC_PKN_REG(LTC0,23)
#define LTC0_PKN1_8                              LTC_PKN1_REG(LTC0,8)
#define LTC0_PKN_24                              LTC_PKN_REG(LTC0,24)
#define LTC0_PKN1_9                              LTC_PKN1_REG(LTC0,9)
#define LTC0_PKN_25                              LTC_PKN_REG(LTC0,25)
#define LTC0_PKN1_10                             LTC_PKN1_REG(LTC0,10)
#define LTC0_PKN_26                              LTC_PKN_REG(LTC0,26)
#define LTC0_PKN1_11                             LTC_PKN1_REG(LTC0,11)
#define LTC0_PKN_27                              LTC_PKN_REG(LTC0,27)
#define LTC0_PKN1_12                             LTC_PKN1_REG(LTC0,12)
#define LTC0_PKN_28                              LTC_PKN_REG(LTC0,28)
#define LTC0_PKN1_13                             LTC_PKN1_REG(LTC0,13)
#define LTC0_PKN_29                              LTC_PKN_REG(LTC0,29)
#define LTC0_PKN1_14                             LTC_PKN1_REG(LTC0,14)
#define LTC0_PKN_30                              LTC_PKN_REG(LTC0,30)
#define LTC0_PKN1_15                             LTC_PKN1_REG(LTC0,15)
#define LTC0_PKN_31                              LTC_PKN_REG(LTC0,31)
#define LTC0_PKN2_0                              LTC_PKN2_REG(LTC0,0)
#define LTC0_PKN_32                              LTC_PKN_REG(LTC0,32)
#define LTC0_PKN2_1                              LTC_PKN2_REG(LTC0,1)
#define LTC0_PKN_33                              LTC_PKN_REG(LTC0,33)
#define LTC0_PKN2_2                              LTC_PKN2_REG(LTC0,2)
#define LTC0_PKN_34                              LTC_PKN_REG(LTC0,34)
#define LTC0_PKN2_3                              LTC_PKN2_REG(LTC0,3)
#define LTC0_PKN_35                              LTC_PKN_REG(LTC0,35)
#define LTC0_PKN2_4                              LTC_PKN2_REG(LTC0,4)
#define LTC0_PKN_36                              LTC_PKN_REG(LTC0,36)
#define LTC0_PKN2_5                              LTC_PKN2_REG(LTC0,5)
#define LTC0_PKN_37                              LTC_PKN_REG(LTC0,37)
#define LTC0_PKN2_6                              LTC_PKN2_REG(LTC0,6)
#define LTC0_PKN_38                              LTC_PKN_REG(LTC0,38)
#define LTC0_PKN2_7                              LTC_PKN2_REG(LTC0,7)
#define LTC0_PKN_39                              LTC_PKN_REG(LTC0,39)
#define LTC0_PKN2_8                              LTC_PKN2_REG(LTC0,8)
#define LTC0_PKN_40                              LTC_PKN_REG(LTC0,40)
#define LTC0_PKN2_9                              LTC_PKN2_REG(LTC0,9)
#define LTC0_PKN_41                              LTC_PKN_REG(LTC0,41)
#define LTC0_PKN2_10                             LTC_PKN2_REG(LTC0,10)
#define LTC0_PKN_42                              LTC_PKN_REG(LTC0,42)
#define LTC0_PKN2_11                             LTC_PKN2_REG(LTC0,11)
#define LTC0_PKN_43                              LTC_PKN_REG(LTC0,43)
#define LTC0_PKN2_12                             LTC_PKN2_REG(LTC0,12)
#define LTC0_PKN_44                              LTC_PKN_REG(LTC0,44)
#define LTC0_PKN2_13                             LTC_PKN2_REG(LTC0,13)
#define LTC0_PKN_45                              LTC_PKN_REG(LTC0,45)
#define LTC0_PKN2_14                             LTC_PKN2_REG(LTC0,14)
#define LTC0_PKN_46                              LTC_PKN_REG(LTC0,46)
#define LTC0_PKN2_15                             LTC_PKN2_REG(LTC0,15)
#define LTC0_PKN_47                              LTC_PKN_REG(LTC0,47)
#define LTC0_PKN3_0                              LTC_PKN3_REG(LTC0,0)
#define LTC0_PKN_48                              LTC_PKN_REG(LTC0,48)
#define LTC0_PKN3_1                              LTC_PKN3_REG(LTC0,1)
#define LTC0_PKN_49                              LTC_PKN_REG(LTC0,49)
#define LTC0_PKN3_2                              LTC_PKN3_REG(LTC0,2)
#define LTC0_PKN_50                              LTC_PKN_REG(LTC0,50)
#define LTC0_PKN3_3                              LTC_PKN3_REG(LTC0,3)
#define LTC0_PKN_51                              LTC_PKN_REG(LTC0,51)
#define LTC0_PKN3_4                              LTC_PKN3_REG(LTC0,4)
#define LTC0_PKN_52                              LTC_PKN_REG(LTC0,52)
#define LTC0_PKN3_5                              LTC_PKN3_REG(LTC0,5)
#define LTC0_PKN_53                              LTC_PKN_REG(LTC0,53)
#define LTC0_PKN3_6                              LTC_PKN3_REG(LTC0,6)
#define LTC0_PKN_54                              LTC_PKN_REG(LTC0,54)
#define LTC0_PKN3_7                              LTC_PKN3_REG(LTC0,7)
#define LTC0_PKN_55                              LTC_PKN_REG(LTC0,55)
#define LTC0_PKN3_8                              LTC_PKN3_REG(LTC0,8)
#define LTC0_PKN_56                              LTC_PKN_REG(LTC0,56)
#define LTC0_PKN3_9                              LTC_PKN3_REG(LTC0,9)
#define LTC0_PKN_57                              LTC_PKN_REG(LTC0,57)
#define LTC0_PKN3_10                             LTC_PKN3_REG(LTC0,10)
#define LTC0_PKN_58                              LTC_PKN_REG(LTC0,58)
#define LTC0_PKN3_11                             LTC_PKN3_REG(LTC0,11)
#define LTC0_PKN_59                              LTC_PKN_REG(LTC0,59)
#define LTC0_PKN3_12                             LTC_PKN3_REG(LTC0,12)
#define LTC0_PKN_60                              LTC_PKN_REG(LTC0,60)
#define LTC0_PKN3_13                             LTC_PKN3_REG(LTC0,13)
#define LTC0_PKN_61                              LTC_PKN_REG(LTC0,61)
#define LTC0_PKN3_14                             LTC_PKN3_REG(LTC0,14)
#define LTC0_PKN_62                              LTC_PKN_REG(LTC0,62)
#define LTC0_PKN3_15                             LTC_PKN3_REG(LTC0,15)
#define LTC0_PKN_63                              LTC_PKN_REG(LTC0,63)
#define LTC0_PKE0_0                              LTC_PKE0_REG(LTC0,0)
#define LTC0_PKE_0                               LTC_PKE_REG(LTC0,0)
#define LTC0_PKE0_1                              LTC_PKE0_REG(LTC0,1)
#define LTC0_PKE_1                               LTC_PKE_REG(LTC0,1)
#define LTC0_PKE0_2                              LTC_PKE0_REG(LTC0,2)
#define LTC0_PKE_2                               LTC_PKE_REG(LTC0,2)
#define LTC0_PKE0_3                              LTC_PKE0_REG(LTC0,3)
#define LTC0_PKE_3                               LTC_PKE_REG(LTC0,3)
#define LTC0_PKE0_4                              LTC_PKE0_REG(LTC0,4)
#define LTC0_PKE_4                               LTC_PKE_REG(LTC0,4)
#define LTC0_PKE0_5                              LTC_PKE0_REG(LTC0,5)
#define LTC0_PKE_5                               LTC_PKE_REG(LTC0,5)
#define LTC0_PKE0_6                              LTC_PKE0_REG(LTC0,6)
#define LTC0_PKE_6                               LTC_PKE_REG(LTC0,6)
#define LTC0_PKE0_7                              LTC_PKE0_REG(LTC0,7)
#define LTC0_PKE_7                               LTC_PKE_REG(LTC0,7)
#define LTC0_PKE0_8                              LTC_PKE0_REG(LTC0,8)
#define LTC0_PKE_8                               LTC_PKE_REG(LTC0,8)
#define LTC0_PKE0_9                              LTC_PKE0_REG(LTC0,9)
#define LTC0_PKE_9                               LTC_PKE_REG(LTC0,9)
#define LTC0_PKE0_10                             LTC_PKE0_REG(LTC0,10)
#define LTC0_PKE_10                              LTC_PKE_REG(LTC0,10)
#define LTC0_PKE0_11                             LTC_PKE0_REG(LTC0,11)
#define LTC0_PKE_11                              LTC_PKE_REG(LTC0,11)
#define LTC0_PKE0_12                             LTC_PKE0_REG(LTC0,12)
#define LTC0_PKE_12                              LTC_PKE_REG(LTC0,12)
#define LTC0_PKE0_13                             LTC_PKE0_REG(LTC0,13)
#define LTC0_PKE_13                              LTC_PKE_REG(LTC0,13)
#define LTC0_PKE0_14                             LTC_PKE0_REG(LTC0,14)
#define LTC0_PKE_14                              LTC_PKE_REG(LTC0,14)
#define LTC0_PKE0_15                             LTC_PKE0_REG(LTC0,15)
#define LTC0_PKE_15                              LTC_PKE_REG(LTC0,15)
#define LTC0_PKE1_0                              LTC_PKE1_REG(LTC0,0)
#define LTC0_PKE_16                              LTC_PKE_REG(LTC0,16)
#define LTC0_PKE1_1                              LTC_PKE1_REG(LTC0,1)
#define LTC0_PKE_17                              LTC_PKE_REG(LTC0,17)
#define LTC0_PKE1_2                              LTC_PKE1_REG(LTC0,2)
#define LTC0_PKE_18                              LTC_PKE_REG(LTC0,18)
#define LTC0_PKE1_3                              LTC_PKE1_REG(LTC0,3)
#define LTC0_PKE_19                              LTC_PKE_REG(LTC0,19)
#define LTC0_PKE1_4                              LTC_PKE1_REG(LTC0,4)
#define LTC0_PKE_20                              LTC_PKE_REG(LTC0,20)
#define LTC0_PKE1_5                              LTC_PKE1_REG(LTC0,5)
#define LTC0_PKE_21                              LTC_PKE_REG(LTC0,21)
#define LTC0_PKE1_6                              LTC_PKE1_REG(LTC0,6)
#define LTC0_PKE_22                              LTC_PKE_REG(LTC0,22)
#define LTC0_PKE1_7                              LTC_PKE1_REG(LTC0,7)
#define LTC0_PKE_23                              LTC_PKE_REG(LTC0,23)
#define LTC0_PKE1_8                              LTC_PKE1_REG(LTC0,8)
#define LTC0_PKE_24                              LTC_PKE_REG(LTC0,24)
#define LTC0_PKE1_9                              LTC_PKE1_REG(LTC0,9)
#define LTC0_PKE_25                              LTC_PKE_REG(LTC0,25)
#define LTC0_PKE1_10                             LTC_PKE1_REG(LTC0,10)
#define LTC0_PKE_26                              LTC_PKE_REG(LTC0,26)
#define LTC0_PKE1_11                             LTC_PKE1_REG(LTC0,11)
#define LTC0_PKE_27                              LTC_PKE_REG(LTC0,27)
#define LTC0_PKE1_12                             LTC_PKE1_REG(LTC0,12)
#define LTC0_PKE_28                              LTC_PKE_REG(LTC0,28)
#define LTC0_PKE1_13                             LTC_PKE1_REG(LTC0,13)
#define LTC0_PKE_29                              LTC_PKE_REG(LTC0,29)
#define LTC0_PKE1_14                             LTC_PKE1_REG(LTC0,14)
#define LTC0_PKE_30                              LTC_PKE_REG(LTC0,30)
#define LTC0_PKE1_15                             LTC_PKE1_REG(LTC0,15)
#define LTC0_PKE_31                              LTC_PKE_REG(LTC0,31)
#define LTC0_PKE2_0                              LTC_PKE2_REG(LTC0,0)
#define LTC0_PKE_32                              LTC_PKE_REG(LTC0,32)
#define LTC0_PKE2_1                              LTC_PKE2_REG(LTC0,1)
#define LTC0_PKE_33                              LTC_PKE_REG(LTC0,33)
#define LTC0_PKE2_2                              LTC_PKE2_REG(LTC0,2)
#define LTC0_PKE_34                              LTC_PKE_REG(LTC0,34)
#define LTC0_PKE2_3                              LTC_PKE2_REG(LTC0,3)
#define LTC0_PKE_35                              LTC_PKE_REG(LTC0,35)
#define LTC0_PKE2_4                              LTC_PKE2_REG(LTC0,4)
#define LTC0_PKE_36                              LTC_PKE_REG(LTC0,36)
#define LTC0_PKE2_5                              LTC_PKE2_REG(LTC0,5)
#define LTC0_PKE_37                              LTC_PKE_REG(LTC0,37)
#define LTC0_PKE2_6                              LTC_PKE2_REG(LTC0,6)
#define LTC0_PKE_38                              LTC_PKE_REG(LTC0,38)
#define LTC0_PKE2_7                              LTC_PKE2_REG(LTC0,7)
#define LTC0_PKE_39                              LTC_PKE_REG(LTC0,39)
#define LTC0_PKE2_8                              LTC_PKE2_REG(LTC0,8)
#define LTC0_PKE_40                              LTC_PKE_REG(LTC0,40)
#define LTC0_PKE2_9                              LTC_PKE2_REG(LTC0,9)
#define LTC0_PKE_41                              LTC_PKE_REG(LTC0,41)
#define LTC0_PKE2_10                             LTC_PKE2_REG(LTC0,10)
#define LTC0_PKE_42                              LTC_PKE_REG(LTC0,42)
#define LTC0_PKE2_11                             LTC_PKE2_REG(LTC0,11)
#define LTC0_PKE_43                              LTC_PKE_REG(LTC0,43)
#define LTC0_PKE2_12                             LTC_PKE2_REG(LTC0,12)
#define LTC0_PKE_44                              LTC_PKE_REG(LTC0,44)
#define LTC0_PKE2_13                             LTC_PKE2_REG(LTC0,13)
#define LTC0_PKE_45                              LTC_PKE_REG(LTC0,45)
#define LTC0_PKE2_14                             LTC_PKE2_REG(LTC0,14)
#define LTC0_PKE_46                              LTC_PKE_REG(LTC0,46)
#define LTC0_PKE2_15                             LTC_PKE2_REG(LTC0,15)
#define LTC0_PKE_47                              LTC_PKE_REG(LTC0,47)
#define LTC0_PKE3_0                              LTC_PKE3_REG(LTC0,0)
#define LTC0_PKE_48                              LTC_PKE_REG(LTC0,48)
#define LTC0_PKE3_1                              LTC_PKE3_REG(LTC0,1)
#define LTC0_PKE_49                              LTC_PKE_REG(LTC0,49)
#define LTC0_PKE3_2                              LTC_PKE3_REG(LTC0,2)
#define LTC0_PKE_50                              LTC_PKE_REG(LTC0,50)
#define LTC0_PKE3_3                              LTC_PKE3_REG(LTC0,3)
#define LTC0_PKE_51                              LTC_PKE_REG(LTC0,51)
#define LTC0_PKE3_4                              LTC_PKE3_REG(LTC0,4)
#define LTC0_PKE_52                              LTC_PKE_REG(LTC0,52)
#define LTC0_PKE3_5                              LTC_PKE3_REG(LTC0,5)
#define LTC0_PKE_53                              LTC_PKE_REG(LTC0,53)
#define LTC0_PKE3_6                              LTC_PKE3_REG(LTC0,6)
#define LTC0_PKE_54                              LTC_PKE_REG(LTC0,54)
#define LTC0_PKE3_7                              LTC_PKE3_REG(LTC0,7)
#define LTC0_PKE_55                              LTC_PKE_REG(LTC0,55)
#define LTC0_PKE3_8                              LTC_PKE3_REG(LTC0,8)
#define LTC0_PKE_56                              LTC_PKE_REG(LTC0,56)
#define LTC0_PKE3_9                              LTC_PKE3_REG(LTC0,9)
#define LTC0_PKE_57                              LTC_PKE_REG(LTC0,57)
#define LTC0_PKE3_10                             LTC_PKE3_REG(LTC0,10)
#define LTC0_PKE_58                              LTC_PKE_REG(LTC0,58)
#define LTC0_PKE3_11                             LTC_PKE3_REG(LTC0,11)
#define LTC0_PKE_59                              LTC_PKE_REG(LTC0,59)
#define LTC0_PKE3_12                             LTC_PKE3_REG(LTC0,12)
#define LTC0_PKE_60                              LTC_PKE_REG(LTC0,60)
#define LTC0_PKE3_13                             LTC_PKE3_REG(LTC0,13)
#define LTC0_PKE_61                              LTC_PKE_REG(LTC0,61)
#define LTC0_PKE3_14                             LTC_PKE3_REG(LTC0,14)
#define LTC0_PKE_62                              LTC_PKE_REG(LTC0,62)
#define LTC0_PKE3_15                             LTC_PKE3_REG(LTC0,15)
#define LTC0_PKE_63                              LTC_PKE_REG(LTC0,63)

/* LTC - Register array accessors */
#define LTC0_CTX(index)                          LTC_CTX_REG(LTC0,index)
#define LTC0_KEY(index)                          LTC_KEY_REG(LTC0,index)
#define LTC0_PKA(index2)                         LTC_PKA_REG(LTC0,index2)
#define LTC0_PKA0(index2)                        LTC_PKA0_REG(LTC0,index2)
#define LTC0_PKA1(index2)                        LTC_PKA1_REG(LTC0,index2)
#define LTC0_PKA2(index2)                        LTC_PKA2_REG(LTC0,index2)
#define LTC0_PKA3(index2)                        LTC_PKA3_REG(LTC0,index2)
#define LTC0_PKB(index2)                         LTC_PKB_REG(LTC0,index2)
#define LTC0_PKB0(index2)                        LTC_PKB0_REG(LTC0,index2)
#define LTC0_PKB1(index2)                        LTC_PKB1_REG(LTC0,index2)
#define LTC0_PKB2(index2)                        LTC_PKB2_REG(LTC0,index2)
#define LTC0_PKB3(index2)                        LTC_PKB3_REG(LTC0,index2)
#define LTC0_PKN(index2)                         LTC_PKN_REG(LTC0,index2)
#define LTC0_PKN0(index2)                        LTC_PKN0_REG(LTC0,index2)
#define LTC0_PKN1(index2)                        LTC_PKN1_REG(LTC0,index2)
#define LTC0_PKN2(index2)                        LTC_PKN2_REG(LTC0,index2)
#define LTC0_PKN3(index2)                        LTC_PKN3_REG(LTC0,index2)
#define LTC0_PKE(index2)                         LTC_PKE_REG(LTC0,index2)
#define LTC0_PKE0(index2)                        LTC_PKE0_REG(LTC0,index2)
#define LTC0_PKE1(index2)                        LTC_PKE1_REG(LTC0,index2)
#define LTC0_PKE2(index2)                        LTC_PKE2_REG(LTC0,index2)
#define LTC0_PKE3(index2)                        LTC_PKE3_REG(LTC0,index2)

/*!
 * @}
 */ /* end of group LTC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group LTC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MCG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Peripheral_Access_Layer MCG Peripheral Access Layer
 * @{
 */

/** MCG - Register Layout Typedef */
typedef struct {
  __IO uint8_t C1;                                 /**< MCG Control 1 Register, offset: 0x0 */
  __IO uint8_t C2;                                 /**< MCG Control 2 Register, offset: 0x1 */
  __IO uint8_t C3;                                 /**< MCG Control 3 Register, offset: 0x2 */
  __IO uint8_t C4;                                 /**< MCG Control 4 Register, offset: 0x3 */
  __IO uint8_t C5;                                 /**< MCG Control 5 Register, offset: 0x4 */
  __IO uint8_t C6;                                 /**< MCG Control 6 Register, offset: 0x5 */
  __IO uint8_t S;                                  /**< MCG Status Register, offset: 0x6 */
       uint8_t RESERVED_0[1];
  __IO uint8_t SC;                                 /**< MCG Status and Control Register, offset: 0x8 */
       uint8_t RESERVED_1[1];
  __IO uint8_t ATCVH;                              /**< MCG Auto Trim Compare Value High Register, offset: 0xA */
  __IO uint8_t ATCVL;                              /**< MCG Auto Trim Compare Value Low Register, offset: 0xB */
  __IO uint8_t C7;                                 /**< MCG Control 7 Register, offset: 0xC */
  __IO uint8_t C8;                                 /**< MCG Control 8 Register, offset: 0xD */
} MCG_Type, *MCG_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MCG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Register_Accessor_Macros MCG - Register accessor macros
 * @{
 */


/* MCG - Register accessors */
#define MCG_C1_REG(base)                         ((base)->C1)
#define MCG_C2_REG(base)                         ((base)->C2)
#define MCG_C3_REG(base)                         ((base)->C3)
#define MCG_C4_REG(base)                         ((base)->C4)
#define MCG_C5_REG(base)                         ((base)->C5)
#define MCG_C6_REG(base)                         ((base)->C6)
#define MCG_S_REG(base)                          ((base)->S)
#define MCG_SC_REG(base)                         ((base)->SC)
#define MCG_ATCVH_REG(base)                      ((base)->ATCVH)
#define MCG_ATCVL_REG(base)                      ((base)->ATCVL)
#define MCG_C7_REG(base)                         ((base)->C7)
#define MCG_C8_REG(base)                         ((base)->C8)

/*!
 * @}
 */ /* end of group MCG_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MCG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Register_Masks MCG Register Masks
 * @{
 */

/* C1 Bit Fields */
#define MCG_C1_IREFSTEN_MASK                     0x1u
#define MCG_C1_IREFSTEN_SHIFT                    0
#define MCG_C1_IREFSTEN_WIDTH                    1
#define MCG_C1_IREFSTEN(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_C1_IREFSTEN_SHIFT))&MCG_C1_IREFSTEN_MASK)
#define MCG_C1_IRCLKEN_MASK                      0x2u
#define MCG_C1_IRCLKEN_SHIFT                     1
#define MCG_C1_IRCLKEN_WIDTH                     1
#define MCG_C1_IRCLKEN(x)                        (((uint8_t)(((uint8_t)(x))<<MCG_C1_IRCLKEN_SHIFT))&MCG_C1_IRCLKEN_MASK)
#define MCG_C1_IREFS_MASK                        0x4u
#define MCG_C1_IREFS_SHIFT                       2
#define MCG_C1_IREFS_WIDTH                       1
#define MCG_C1_IREFS(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C1_IREFS_SHIFT))&MCG_C1_IREFS_MASK)
#define MCG_C1_FRDIV_MASK                        0x38u
#define MCG_C1_FRDIV_SHIFT                       3
#define MCG_C1_FRDIV_WIDTH                       3
#define MCG_C1_FRDIV(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C1_FRDIV_SHIFT))&MCG_C1_FRDIV_MASK)
#define MCG_C1_CLKS_MASK                         0xC0u
#define MCG_C1_CLKS_SHIFT                        6
#define MCG_C1_CLKS_WIDTH                        2
#define MCG_C1_CLKS(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C1_CLKS_SHIFT))&MCG_C1_CLKS_MASK)
/* C2 Bit Fields */
#define MCG_C2_IRCS_MASK                         0x1u
#define MCG_C2_IRCS_SHIFT                        0
#define MCG_C2_IRCS_WIDTH                        1
#define MCG_C2_IRCS(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C2_IRCS_SHIFT))&MCG_C2_IRCS_MASK)
#define MCG_C2_LP_MASK                           0x2u
#define MCG_C2_LP_SHIFT                          1
#define MCG_C2_LP_WIDTH                          1
#define MCG_C2_LP(x)                             (((uint8_t)(((uint8_t)(x))<<MCG_C2_LP_SHIFT))&MCG_C2_LP_MASK)
#define MCG_C2_EREFS_MASK                        0x4u
#define MCG_C2_EREFS_SHIFT                       2
#define MCG_C2_EREFS_WIDTH                       1
#define MCG_C2_EREFS(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C2_EREFS_SHIFT))&MCG_C2_EREFS_MASK)
#define MCG_C2_HGO_MASK                          0x8u
#define MCG_C2_HGO_SHIFT                         3
#define MCG_C2_HGO_WIDTH                         1
#define MCG_C2_HGO(x)                            (((uint8_t)(((uint8_t)(x))<<MCG_C2_HGO_SHIFT))&MCG_C2_HGO_MASK)
#define MCG_C2_RANGE_MASK                        0x30u
#define MCG_C2_RANGE_SHIFT                       4
#define MCG_C2_RANGE_WIDTH                       2
#define MCG_C2_RANGE(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C2_RANGE_SHIFT))&MCG_C2_RANGE_MASK)
#define MCG_C2_FCFTRIM_MASK                      0x40u
#define MCG_C2_FCFTRIM_SHIFT                     6
#define MCG_C2_FCFTRIM_WIDTH                     1
#define MCG_C2_FCFTRIM(x)                        (((uint8_t)(((uint8_t)(x))<<MCG_C2_FCFTRIM_SHIFT))&MCG_C2_FCFTRIM_MASK)
#define MCG_C2_LOCRE0_MASK                       0x80u
#define MCG_C2_LOCRE0_SHIFT                      7
#define MCG_C2_LOCRE0_WIDTH                      1
#define MCG_C2_LOCRE0(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C2_LOCRE0_SHIFT))&MCG_C2_LOCRE0_MASK)
/* C3 Bit Fields */
#define MCG_C3_SCTRIM_MASK                       0xFFu
#define MCG_C3_SCTRIM_SHIFT                      0
#define MCG_C3_SCTRIM_WIDTH                      8
#define MCG_C3_SCTRIM(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C3_SCTRIM_SHIFT))&MCG_C3_SCTRIM_MASK)
/* C4 Bit Fields */
#define MCG_C4_SCFTRIM_MASK                      0x1u
#define MCG_C4_SCFTRIM_SHIFT                     0
#define MCG_C4_SCFTRIM_WIDTH                     1
#define MCG_C4_SCFTRIM(x)                        (((uint8_t)(((uint8_t)(x))<<MCG_C4_SCFTRIM_SHIFT))&MCG_C4_SCFTRIM_MASK)
#define MCG_C4_FCTRIM_MASK                       0x1Eu
#define MCG_C4_FCTRIM_SHIFT                      1
#define MCG_C4_FCTRIM_WIDTH                      4
#define MCG_C4_FCTRIM(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C4_FCTRIM_SHIFT))&MCG_C4_FCTRIM_MASK)
#define MCG_C4_DRST_DRS_MASK                     0x60u
#define MCG_C4_DRST_DRS_SHIFT                    5
#define MCG_C4_DRST_DRS_WIDTH                    2
#define MCG_C4_DRST_DRS(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_C4_DRST_DRS_SHIFT))&MCG_C4_DRST_DRS_MASK)
#define MCG_C4_DMX32_MASK                        0x80u
#define MCG_C4_DMX32_SHIFT                       7
#define MCG_C4_DMX32_WIDTH                       1
#define MCG_C4_DMX32(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C4_DMX32_SHIFT))&MCG_C4_DMX32_MASK)
/* C5 Bit Fields */
#define MCG_C5_PRDIV_MASK                        0x7u
#define MCG_C5_PRDIV_SHIFT                       0
#define MCG_C5_PRDIV_WIDTH                       3
#define MCG_C5_PRDIV(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C5_PRDIV_SHIFT))&MCG_C5_PRDIV_MASK)
#define MCG_C5_PLLSTEN_MASK                      0x20u
#define MCG_C5_PLLSTEN_SHIFT                     5
#define MCG_C5_PLLSTEN_WIDTH                     1
#define MCG_C5_PLLSTEN(x)                        (((uint8_t)(((uint8_t)(x))<<MCG_C5_PLLSTEN_SHIFT))&MCG_C5_PLLSTEN_MASK)
#define MCG_C5_PLLCLKEN_MASK                     0x40u
#define MCG_C5_PLLCLKEN_SHIFT                    6
#define MCG_C5_PLLCLKEN_WIDTH                    1
#define MCG_C5_PLLCLKEN(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_C5_PLLCLKEN_SHIFT))&MCG_C5_PLLCLKEN_MASK)
/* C6 Bit Fields */
#define MCG_C6_VDIV_MASK                         0x1Fu
#define MCG_C6_VDIV_SHIFT                        0
#define MCG_C6_VDIV_WIDTH                        5
#define MCG_C6_VDIV(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C6_VDIV_SHIFT))&MCG_C6_VDIV_MASK)
#define MCG_C6_CME0_MASK                         0x20u
#define MCG_C6_CME0_SHIFT                        5
#define MCG_C6_CME0_WIDTH                        1
#define MCG_C6_CME0(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C6_CME0_SHIFT))&MCG_C6_CME0_MASK)
#define MCG_C6_PLLS_MASK                         0x40u
#define MCG_C6_PLLS_SHIFT                        6
#define MCG_C6_PLLS_WIDTH                        1
#define MCG_C6_PLLS(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C6_PLLS_SHIFT))&MCG_C6_PLLS_MASK)
#define MCG_C6_LOLIE0_MASK                       0x80u
#define MCG_C6_LOLIE0_SHIFT                      7
#define MCG_C6_LOLIE0_WIDTH                      1
#define MCG_C6_LOLIE0(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C6_LOLIE0_SHIFT))&MCG_C6_LOLIE0_MASK)
/* S Bit Fields */
#define MCG_S_IRCST_MASK                         0x1u
#define MCG_S_IRCST_SHIFT                        0
#define MCG_S_IRCST_WIDTH                        1
#define MCG_S_IRCST(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_S_IRCST_SHIFT))&MCG_S_IRCST_MASK)
#define MCG_S_OSCINIT0_MASK                      0x2u
#define MCG_S_OSCINIT0_SHIFT                     1
#define MCG_S_OSCINIT0_WIDTH                     1
#define MCG_S_OSCINIT0(x)                        (((uint8_t)(((uint8_t)(x))<<MCG_S_OSCINIT0_SHIFT))&MCG_S_OSCINIT0_MASK)
#define MCG_S_CLKST_MASK                         0xCu
#define MCG_S_CLKST_SHIFT                        2
#define MCG_S_CLKST_WIDTH                        2
#define MCG_S_CLKST(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_S_CLKST_SHIFT))&MCG_S_CLKST_MASK)
#define MCG_S_IREFST_MASK                        0x10u
#define MCG_S_IREFST_SHIFT                       4
#define MCG_S_IREFST_WIDTH                       1
#define MCG_S_IREFST(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_S_IREFST_SHIFT))&MCG_S_IREFST_MASK)
#define MCG_S_PLLST_MASK                         0x20u
#define MCG_S_PLLST_SHIFT                        5
#define MCG_S_PLLST_WIDTH                        1
#define MCG_S_PLLST(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_S_PLLST_SHIFT))&MCG_S_PLLST_MASK)
#define MCG_S_LOCK0_MASK                         0x40u
#define MCG_S_LOCK0_SHIFT                        6
#define MCG_S_LOCK0_WIDTH                        1
#define MCG_S_LOCK0(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_S_LOCK0_SHIFT))&MCG_S_LOCK0_MASK)
#define MCG_S_LOLS0_MASK                         0x80u
#define MCG_S_LOLS0_SHIFT                        7
#define MCG_S_LOLS0_WIDTH                        1
#define MCG_S_LOLS0(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_S_LOLS0_SHIFT))&MCG_S_LOLS0_MASK)
/* SC Bit Fields */
#define MCG_SC_LOCS0_MASK                        0x1u
#define MCG_SC_LOCS0_SHIFT                       0
#define MCG_SC_LOCS0_WIDTH                       1
#define MCG_SC_LOCS0(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_SC_LOCS0_SHIFT))&MCG_SC_LOCS0_MASK)
#define MCG_SC_FCRDIV_MASK                       0xEu
#define MCG_SC_FCRDIV_SHIFT                      1
#define MCG_SC_FCRDIV_WIDTH                      3
#define MCG_SC_FCRDIV(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_SC_FCRDIV_SHIFT))&MCG_SC_FCRDIV_MASK)
#define MCG_SC_FLTPRSRV_MASK                     0x10u
#define MCG_SC_FLTPRSRV_SHIFT                    4
#define MCG_SC_FLTPRSRV_WIDTH                    1
#define MCG_SC_FLTPRSRV(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_SC_FLTPRSRV_SHIFT))&MCG_SC_FLTPRSRV_MASK)
#define MCG_SC_ATMF_MASK                         0x20u
#define MCG_SC_ATMF_SHIFT                        5
#define MCG_SC_ATMF_WIDTH                        1
#define MCG_SC_ATMF(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_SC_ATMF_SHIFT))&MCG_SC_ATMF_MASK)
#define MCG_SC_ATMS_MASK                         0x40u
#define MCG_SC_ATMS_SHIFT                        6
#define MCG_SC_ATMS_WIDTH                        1
#define MCG_SC_ATMS(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_SC_ATMS_SHIFT))&MCG_SC_ATMS_MASK)
#define MCG_SC_ATME_MASK                         0x80u
#define MCG_SC_ATME_SHIFT                        7
#define MCG_SC_ATME_WIDTH                        1
#define MCG_SC_ATME(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_SC_ATME_SHIFT))&MCG_SC_ATME_MASK)
/* ATCVH Bit Fields */
#define MCG_ATCVH_ATCVH_MASK                     0xFFu
#define MCG_ATCVH_ATCVH_SHIFT                    0
#define MCG_ATCVH_ATCVH_WIDTH                    8
#define MCG_ATCVH_ATCVH(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_ATCVH_ATCVH_SHIFT))&MCG_ATCVH_ATCVH_MASK)
/* ATCVL Bit Fields */
#define MCG_ATCVL_ATCVL_MASK                     0xFFu
#define MCG_ATCVL_ATCVL_SHIFT                    0
#define MCG_ATCVL_ATCVL_WIDTH                    8
#define MCG_ATCVL_ATCVL(x)                       (((uint8_t)(((uint8_t)(x))<<MCG_ATCVL_ATCVL_SHIFT))&MCG_ATCVL_ATCVL_MASK)
/* C7 Bit Fields */
#define MCG_C7_OSCSEL_MASK                       0x3u
#define MCG_C7_OSCSEL_SHIFT                      0
#define MCG_C7_OSCSEL_WIDTH                      2
#define MCG_C7_OSCSEL(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C7_OSCSEL_SHIFT))&MCG_C7_OSCSEL_MASK)
/* C8 Bit Fields */
#define MCG_C8_LOCS1_MASK                        0x1u
#define MCG_C8_LOCS1_SHIFT                       0
#define MCG_C8_LOCS1_WIDTH                       1
#define MCG_C8_LOCS1(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C8_LOCS1_SHIFT))&MCG_C8_LOCS1_MASK)
#define MCG_C8_CME1_MASK                         0x20u
#define MCG_C8_CME1_SHIFT                        5
#define MCG_C8_CME1_WIDTH                        1
#define MCG_C8_CME1(x)                           (((uint8_t)(((uint8_t)(x))<<MCG_C8_CME1_SHIFT))&MCG_C8_CME1_MASK)
#define MCG_C8_LOLRE_MASK                        0x40u
#define MCG_C8_LOLRE_SHIFT                       6
#define MCG_C8_LOLRE_WIDTH                       1
#define MCG_C8_LOLRE(x)                          (((uint8_t)(((uint8_t)(x))<<MCG_C8_LOLRE_SHIFT))&MCG_C8_LOLRE_MASK)
#define MCG_C8_LOCRE1_MASK                       0x80u
#define MCG_C8_LOCRE1_SHIFT                      7
#define MCG_C8_LOCRE1_WIDTH                      1
#define MCG_C8_LOCRE1(x)                         (((uint8_t)(((uint8_t)(x))<<MCG_C8_LOCRE1_SHIFT))&MCG_C8_LOCRE1_MASK)

/*!
 * @}
 */ /* end of group MCG_Register_Masks */


/* MCG - Peripheral instance base addresses */
/** Peripheral MCG base address */
#define MCG_BASE                                 (0x40064000u)
/** Peripheral MCG base pointer */
#define MCG                                      ((MCG_Type *)MCG_BASE)
#define MCG_BASE_PTR                             (MCG)
/** Array initializer of MCG peripheral base addresses */
#define MCG_BASE_ADDRS                           { MCG_BASE }
/** Array initializer of MCG peripheral base pointers */
#define MCG_BASE_PTRS                            { MCG }

/* ----------------------------------------------------------------------------
   -- MCG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCG_Register_Accessor_Macros MCG - Register accessor macros
 * @{
 */


/* MCG - Register instance definitions */
/* MCG */
#define MCG_C1                                   MCG_C1_REG(MCG)
#define MCG_C2                                   MCG_C2_REG(MCG)
#define MCG_C3                                   MCG_C3_REG(MCG)
#define MCG_C4                                   MCG_C4_REG(MCG)
#define MCG_C5                                   MCG_C5_REG(MCG)
#define MCG_C6                                   MCG_C6_REG(MCG)
#define MCG_S                                    MCG_S_REG(MCG)
#define MCG_SC                                   MCG_SC_REG(MCG)
#define MCG_ATCVH                                MCG_ATCVH_REG(MCG)
#define MCG_ATCVL                                MCG_ATCVL_REG(MCG)
#define MCG_C7                                   MCG_C7_REG(MCG)
#define MCG_C8                                   MCG_C8_REG(MCG)

/*!
 * @}
 */ /* end of group MCG_Register_Accessor_Macros */

/* MCG C5[PLLCLKEN0] backward compatibility */
#define MCG_C5_PLLCLKEN0_MASK         (MCG_C5_PLLCLKEN_MASK)
#define MCG_C5_PLLCLKEN0_SHIFT        (MCG_C5_PLLCLKEN_SHIFT)
#define MCG_C5_PLLCLKEN0_WIDTH        (MCG_C5_PLLCLKEN_WIDTH)
#define MCG_C5_PLLCLKEN0(x)           (MCG_C5_PLLCLKEN(x))

/* MCG C5[PLLSTEN0] backward compatibility */
#define MCG_C5_PLLSTEN0_MASK         (MCG_C5_PLLSTEN_MASK)
#define MCG_C5_PLLSTEN0_SHIFT        (MCG_C5_PLLSTEN_SHIFT)
#define MCG_C5_PLLSTEN0_WIDTH        (MCG_C5_PLLSTEN_WIDTH)
#define MCG_C5_PLLSTEN0(x)           (MCG_C5_PLLSTEN(x))

/* MCG C5[PRDIV0] backward compatibility */
#define MCG_C5_PRDIV0_MASK         (MCG_C5_PRDIV_MASK)
#define MCG_C5_PRDIV0_SHIFT        (MCG_C5_PRDIV_SHIFT)
#define MCG_C5_PRDIV0_WIDTH        (MCG_C5_PRDIV_WIDTH)
#define MCG_C5_PRDIV0(x)           (MCG_C5_PRDIV(x))

/* MCG C6[VDIV0] backward compatibility */
#define MCG_C6_VDIV0_MASK         (MCG_C6_VDIV_MASK)
#define MCG_C6_VDIV0_SHIFT        (MCG_C6_VDIV_SHIFT)
#define MCG_C6_VDIV0_WIDTH        (MCG_C6_VDIV_WIDTH)
#define MCG_C6_VDIV0(x)           (MCG_C6_VDIV(x))


/*!
 * @}
 */ /* end of group MCG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MCM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Peripheral_Access_Layer MCM Peripheral Access Layer
 * @{
 */

/** MCM - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[8];
  __I  uint16_t PLASC;                             /**< Crossbar Switch (AXBS) Slave Configuration, offset: 0x8 */
  __I  uint16_t PLAMC;                             /**< Crossbar Switch (AXBS) Master Configuration, offset: 0xA */
  __IO uint32_t PLACR;                             /**< Platform Control Register, offset: 0xC */
       uint8_t RESERVED_1[48];
  __IO uint32_t CPO;                               /**< Compute Operation Control Register, offset: 0x40 */
} MCM_Type, *MCM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Register_Accessor_Macros MCM - Register accessor macros
 * @{
 */


/* MCM - Register accessors */
#define MCM_PLASC_REG(base)                      ((base)->PLASC)
#define MCM_PLAMC_REG(base)                      ((base)->PLAMC)
#define MCM_PLACR_REG(base)                      ((base)->PLACR)
#define MCM_CPO_REG(base)                        ((base)->CPO)

/*!
 * @}
 */ /* end of group MCM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Register_Masks MCM Register Masks
 * @{
 */

/* PLASC Bit Fields */
#define MCM_PLASC_ASC_MASK                       0xFFu
#define MCM_PLASC_ASC_SHIFT                      0
#define MCM_PLASC_ASC_WIDTH                      8
#define MCM_PLASC_ASC(x)                         (((uint16_t)(((uint16_t)(x))<<MCM_PLASC_ASC_SHIFT))&MCM_PLASC_ASC_MASK)
/* PLAMC Bit Fields */
#define MCM_PLAMC_AMC_MASK                       0xFFu
#define MCM_PLAMC_AMC_SHIFT                      0
#define MCM_PLAMC_AMC_WIDTH                      8
#define MCM_PLAMC_AMC(x)                         (((uint16_t)(((uint16_t)(x))<<MCM_PLAMC_AMC_SHIFT))&MCM_PLAMC_AMC_MASK)
/* PLACR Bit Fields */
#define MCM_PLACR_ARB_MASK                       0x200u
#define MCM_PLACR_ARB_SHIFT                      9
#define MCM_PLACR_ARB_WIDTH                      1
#define MCM_PLACR_ARB(x)                         (((uint32_t)(((uint32_t)(x))<<MCM_PLACR_ARB_SHIFT))&MCM_PLACR_ARB_MASK)
#define MCM_PLACR_CFCC_MASK                      0x400u
#define MCM_PLACR_CFCC_SHIFT                     10
#define MCM_PLACR_CFCC_WIDTH                     1
#define MCM_PLACR_CFCC(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_PLACR_CFCC_SHIFT))&MCM_PLACR_CFCC_MASK)
#define MCM_PLACR_DFCDA_MASK                     0x800u
#define MCM_PLACR_DFCDA_SHIFT                    11
#define MCM_PLACR_DFCDA_WIDTH                    1
#define MCM_PLACR_DFCDA(x)                       (((uint32_t)(((uint32_t)(x))<<MCM_PLACR_DFCDA_SHIFT))&MCM_PLACR_DFCDA_MASK)
#define MCM_PLACR_DFCIC_MASK                     0x1000u
#define MCM_PLACR_DFCIC_SHIFT                    12
#define MCM_PLACR_DFCIC_WIDTH                    1
#define MCM_PLACR_DFCIC(x)                       (((uint32_t)(((uint32_t)(x))<<MCM_PLACR_DFCIC_SHIFT))&MCM_PLACR_DFCIC_MASK)
#define MCM_PLACR_DFCC_MASK                      0x2000u
#define MCM_PLACR_DFCC_SHIFT                     13
#define MCM_PLACR_DFCC_WIDTH                     1
#define MCM_PLACR_DFCC(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_PLACR_DFCC_SHIFT))&MCM_PLACR_DFCC_MASK)
#define MCM_PLACR_EFDS_MASK                      0x4000u
#define MCM_PLACR_EFDS_SHIFT                     14
#define MCM_PLACR_EFDS_WIDTH                     1
#define MCM_PLACR_EFDS(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_PLACR_EFDS_SHIFT))&MCM_PLACR_EFDS_MASK)
#define MCM_PLACR_DFCS_MASK                      0x8000u
#define MCM_PLACR_DFCS_SHIFT                     15
#define MCM_PLACR_DFCS_WIDTH                     1
#define MCM_PLACR_DFCS(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_PLACR_DFCS_SHIFT))&MCM_PLACR_DFCS_MASK)
#define MCM_PLACR_ESFC_MASK                      0x10000u
#define MCM_PLACR_ESFC_SHIFT                     16
#define MCM_PLACR_ESFC_WIDTH                     1
#define MCM_PLACR_ESFC(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_PLACR_ESFC_SHIFT))&MCM_PLACR_ESFC_MASK)
/* CPO Bit Fields */
#define MCM_CPO_CPOREQ_MASK                      0x1u
#define MCM_CPO_CPOREQ_SHIFT                     0
#define MCM_CPO_CPOREQ_WIDTH                     1
#define MCM_CPO_CPOREQ(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_CPO_CPOREQ_SHIFT))&MCM_CPO_CPOREQ_MASK)
#define MCM_CPO_CPOACK_MASK                      0x2u
#define MCM_CPO_CPOACK_SHIFT                     1
#define MCM_CPO_CPOACK_WIDTH                     1
#define MCM_CPO_CPOACK(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_CPO_CPOACK_SHIFT))&MCM_CPO_CPOACK_MASK)
#define MCM_CPO_CPOWOI_MASK                      0x4u
#define MCM_CPO_CPOWOI_SHIFT                     2
#define MCM_CPO_CPOWOI_WIDTH                     1
#define MCM_CPO_CPOWOI(x)                        (((uint32_t)(((uint32_t)(x))<<MCM_CPO_CPOWOI_SHIFT))&MCM_CPO_CPOWOI_MASK)

/*!
 * @}
 */ /* end of group MCM_Register_Masks */


/* MCM - Peripheral instance base addresses */
/** Peripheral MCM base address */
#define MCM_BASE                                 (0xF0003000u)
/** Peripheral MCM base pointer */
#define MCM                                      ((MCM_Type *)MCM_BASE)
#define MCM_BASE_PTR                             (MCM)
/** Array initializer of MCM peripheral base addresses */
#define MCM_BASE_ADDRS                           { MCM_BASE }
/** Array initializer of MCM peripheral base pointers */
#define MCM_BASE_PTRS                            { MCM }

/* ----------------------------------------------------------------------------
   -- MCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MCM_Register_Accessor_Macros MCM - Register accessor macros
 * @{
 */


/* MCM - Register instance definitions */
/* MCM */
#define MCM_PLASC                                MCM_PLASC_REG(MCM)
#define MCM_PLAMC                                MCM_PLAMC_REG(MCM)
#define MCM_PLACR                                MCM_PLACR_REG(MCM)
#define MCM_CPO                                  MCM_CPO_REG(MCM)

/*!
 * @}
 */ /* end of group MCM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MCM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MPU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MPU_Peripheral_Access_Layer MPU Peripheral Access Layer
 * @{
 */

/** MPU - Register Layout Typedef */
typedef struct {
  __IO uint32_t CESR;                              /**< Control/Error Status Register, offset: 0x0 */
       uint8_t RESERVED_0[12];
  struct {                                         /* offset: 0x10, array step: 0x8 */
    __I  uint32_t EAR;                               /**< Error Address Register, slave port n, array offset: 0x10, array step: 0x8 */
    __I  uint32_t EDR;                               /**< Error Detail Register, slave port n, array offset: 0x14, array step: 0x8 */
  } SP[5];
       uint8_t RESERVED_1[968];
  __IO uint32_t WORD[8][4];                        /**< Region Descriptor n, Word 0..Region Descriptor n, Word 3, array offset: 0x400, array step: index*0x10, index2*0x4 */
       uint8_t RESERVED_2[896];
  __IO uint32_t RGDAAC[8];                         /**< Region Descriptor Alternate Access Control n, array offset: 0x800, array step: 0x4 */
} MPU_Type, *MPU_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MPU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MPU_Register_Accessor_Macros MPU - Register accessor macros
 * @{
 */


/* MPU - Register accessors */
#define MPU_CESR_REG(base)                       ((base)->CESR)
#define MPU_EAR_REG(base,index)                  ((base)->SP[index].EAR)
#define MPU_EAR_COUNT                            5
#define MPU_EDR_REG(base,index)                  ((base)->SP[index].EDR)
#define MPU_EDR_COUNT                            5
#define MPU_WORD_REG(base,index,index2)          ((base)->WORD[index][index2])
#define MPU_WORD_COUNT                           8
#define MPU_WORD_COUNT2                          4
#define MPU_RGDAAC_REG(base,index)               ((base)->RGDAAC[index])
#define MPU_RGDAAC_COUNT                         8

/*!
 * @}
 */ /* end of group MPU_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MPU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MPU_Register_Masks MPU Register Masks
 * @{
 */

/* CESR Bit Fields */
#define MPU_CESR_VLD_MASK                        0x1u
#define MPU_CESR_VLD_SHIFT                       0
#define MPU_CESR_VLD_WIDTH                       1
#define MPU_CESR_VLD(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_CESR_VLD_SHIFT))&MPU_CESR_VLD_MASK)
#define MPU_CESR_NRGD_MASK                       0xF00u
#define MPU_CESR_NRGD_SHIFT                      8
#define MPU_CESR_NRGD_WIDTH                      4
#define MPU_CESR_NRGD(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_CESR_NRGD_SHIFT))&MPU_CESR_NRGD_MASK)
#define MPU_CESR_NSP_MASK                        0xF000u
#define MPU_CESR_NSP_SHIFT                       12
#define MPU_CESR_NSP_WIDTH                       4
#define MPU_CESR_NSP(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_CESR_NSP_SHIFT))&MPU_CESR_NSP_MASK)
#define MPU_CESR_HRL_MASK                        0xF0000u
#define MPU_CESR_HRL_SHIFT                       16
#define MPU_CESR_HRL_WIDTH                       4
#define MPU_CESR_HRL(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_CESR_HRL_SHIFT))&MPU_CESR_HRL_MASK)
#define MPU_CESR_SPERR_MASK                      0xF8000000u
#define MPU_CESR_SPERR_SHIFT                     27
#define MPU_CESR_SPERR_WIDTH                     5
#define MPU_CESR_SPERR(x)                        (((uint32_t)(((uint32_t)(x))<<MPU_CESR_SPERR_SHIFT))&MPU_CESR_SPERR_MASK)
/* EAR Bit Fields */
#define MPU_EAR_EADDR_MASK                       0xFFFFFFFFu
#define MPU_EAR_EADDR_SHIFT                      0
#define MPU_EAR_EADDR_WIDTH                      32
#define MPU_EAR_EADDR(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_EAR_EADDR_SHIFT))&MPU_EAR_EADDR_MASK)
/* EDR Bit Fields */
#define MPU_EDR_ERW_MASK                         0x1u
#define MPU_EDR_ERW_SHIFT                        0
#define MPU_EDR_ERW_WIDTH                        1
#define MPU_EDR_ERW(x)                           (((uint32_t)(((uint32_t)(x))<<MPU_EDR_ERW_SHIFT))&MPU_EDR_ERW_MASK)
#define MPU_EDR_EATTR_MASK                       0xEu
#define MPU_EDR_EATTR_SHIFT                      1
#define MPU_EDR_EATTR_WIDTH                      3
#define MPU_EDR_EATTR(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_EDR_EATTR_SHIFT))&MPU_EDR_EATTR_MASK)
#define MPU_EDR_EMN_MASK                         0xF0u
#define MPU_EDR_EMN_SHIFT                        4
#define MPU_EDR_EMN_WIDTH                        4
#define MPU_EDR_EMN(x)                           (((uint32_t)(((uint32_t)(x))<<MPU_EDR_EMN_SHIFT))&MPU_EDR_EMN_MASK)
#define MPU_EDR_EPID_MASK                        0xFF00u
#define MPU_EDR_EPID_SHIFT                       8
#define MPU_EDR_EPID_WIDTH                       8
#define MPU_EDR_EPID(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_EDR_EPID_SHIFT))&MPU_EDR_EPID_MASK)
#define MPU_EDR_EACD_MASK                        0xFFFF0000u
#define MPU_EDR_EACD_SHIFT                       16
#define MPU_EDR_EACD_WIDTH                       16
#define MPU_EDR_EACD(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_EDR_EACD_SHIFT))&MPU_EDR_EACD_MASK)
/* WORD Bit Fields */
#define MPU_WORD_VLD_MASK                        0x1u
#define MPU_WORD_VLD_SHIFT                       0
#define MPU_WORD_VLD_WIDTH                       1
#define MPU_WORD_VLD(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_WORD_VLD_SHIFT))&MPU_WORD_VLD_MASK)
#define MPU_WORD_M0UM_MASK                       0x7u
#define MPU_WORD_M0UM_SHIFT                      0
#define MPU_WORD_M0UM_WIDTH                      3
#define MPU_WORD_M0UM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M0UM_SHIFT))&MPU_WORD_M0UM_MASK)
#define MPU_WORD_M0SM_MASK                       0x18u
#define MPU_WORD_M0SM_SHIFT                      3
#define MPU_WORD_M0SM_WIDTH                      2
#define MPU_WORD_M0SM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M0SM_SHIFT))&MPU_WORD_M0SM_MASK)
#define MPU_WORD_M0PE_MASK                       0x20u
#define MPU_WORD_M0PE_SHIFT                      5
#define MPU_WORD_M0PE_WIDTH                      1
#define MPU_WORD_M0PE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M0PE_SHIFT))&MPU_WORD_M0PE_MASK)
#define MPU_WORD_ENDADDR_MASK                    0xFFFFFFE0u
#define MPU_WORD_ENDADDR_SHIFT                   5
#define MPU_WORD_ENDADDR_WIDTH                   27
#define MPU_WORD_ENDADDR(x)                      (((uint32_t)(((uint32_t)(x))<<MPU_WORD_ENDADDR_SHIFT))&MPU_WORD_ENDADDR_MASK)
#define MPU_WORD_SRTADDR_MASK                    0xFFFFFFE0u
#define MPU_WORD_SRTADDR_SHIFT                   5
#define MPU_WORD_SRTADDR_WIDTH                   27
#define MPU_WORD_SRTADDR(x)                      (((uint32_t)(((uint32_t)(x))<<MPU_WORD_SRTADDR_SHIFT))&MPU_WORD_SRTADDR_MASK)
#define MPU_WORD_M1UM_MASK                       0x1C0u
#define MPU_WORD_M1UM_SHIFT                      6
#define MPU_WORD_M1UM_WIDTH                      3
#define MPU_WORD_M1UM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M1UM_SHIFT))&MPU_WORD_M1UM_MASK)
#define MPU_WORD_M1SM_MASK                       0x600u
#define MPU_WORD_M1SM_SHIFT                      9
#define MPU_WORD_M1SM_WIDTH                      2
#define MPU_WORD_M1SM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M1SM_SHIFT))&MPU_WORD_M1SM_MASK)
#define MPU_WORD_M1PE_MASK                       0x800u
#define MPU_WORD_M1PE_SHIFT                      11
#define MPU_WORD_M1PE_WIDTH                      1
#define MPU_WORD_M1PE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M1PE_SHIFT))&MPU_WORD_M1PE_MASK)
#define MPU_WORD_M2UM_MASK                       0x7000u
#define MPU_WORD_M2UM_SHIFT                      12
#define MPU_WORD_M2UM_WIDTH                      3
#define MPU_WORD_M2UM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M2UM_SHIFT))&MPU_WORD_M2UM_MASK)
#define MPU_WORD_M2SM_MASK                       0x18000u
#define MPU_WORD_M2SM_SHIFT                      15
#define MPU_WORD_M2SM_WIDTH                      2
#define MPU_WORD_M2SM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M2SM_SHIFT))&MPU_WORD_M2SM_MASK)
#define MPU_WORD_PIDMASK_MASK                    0xFF0000u
#define MPU_WORD_PIDMASK_SHIFT                   16
#define MPU_WORD_PIDMASK_WIDTH                   8
#define MPU_WORD_PIDMASK(x)                      (((uint32_t)(((uint32_t)(x))<<MPU_WORD_PIDMASK_SHIFT))&MPU_WORD_PIDMASK_MASK)
#define MPU_WORD_M2PE_MASK                       0x20000u
#define MPU_WORD_M2PE_SHIFT                      17
#define MPU_WORD_M2PE_WIDTH                      1
#define MPU_WORD_M2PE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M2PE_SHIFT))&MPU_WORD_M2PE_MASK)
#define MPU_WORD_M3UM_MASK                       0x1C0000u
#define MPU_WORD_M3UM_SHIFT                      18
#define MPU_WORD_M3UM_WIDTH                      3
#define MPU_WORD_M3UM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M3UM_SHIFT))&MPU_WORD_M3UM_MASK)
#define MPU_WORD_M3SM_MASK                       0x600000u
#define MPU_WORD_M3SM_SHIFT                      21
#define MPU_WORD_M3SM_WIDTH                      2
#define MPU_WORD_M3SM(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M3SM_SHIFT))&MPU_WORD_M3SM_MASK)
#define MPU_WORD_M3PE_MASK                       0x800000u
#define MPU_WORD_M3PE_SHIFT                      23
#define MPU_WORD_M3PE_WIDTH                      1
#define MPU_WORD_M3PE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M3PE_SHIFT))&MPU_WORD_M3PE_MASK)
#define MPU_WORD_PID_MASK                        0xFF000000u
#define MPU_WORD_PID_SHIFT                       24
#define MPU_WORD_PID_WIDTH                       8
#define MPU_WORD_PID(x)                          (((uint32_t)(((uint32_t)(x))<<MPU_WORD_PID_SHIFT))&MPU_WORD_PID_MASK)
#define MPU_WORD_M4WE_MASK                       0x1000000u
#define MPU_WORD_M4WE_SHIFT                      24
#define MPU_WORD_M4WE_WIDTH                      1
#define MPU_WORD_M4WE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M4WE_SHIFT))&MPU_WORD_M4WE_MASK)
#define MPU_WORD_M4RE_MASK                       0x2000000u
#define MPU_WORD_M4RE_SHIFT                      25
#define MPU_WORD_M4RE_WIDTH                      1
#define MPU_WORD_M4RE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M4RE_SHIFT))&MPU_WORD_M4RE_MASK)
#define MPU_WORD_M5WE_MASK                       0x4000000u
#define MPU_WORD_M5WE_SHIFT                      26
#define MPU_WORD_M5WE_WIDTH                      1
#define MPU_WORD_M5WE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M5WE_SHIFT))&MPU_WORD_M5WE_MASK)
#define MPU_WORD_M5RE_MASK                       0x8000000u
#define MPU_WORD_M5RE_SHIFT                      27
#define MPU_WORD_M5RE_WIDTH                      1
#define MPU_WORD_M5RE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M5RE_SHIFT))&MPU_WORD_M5RE_MASK)
#define MPU_WORD_M6WE_MASK                       0x10000000u
#define MPU_WORD_M6WE_SHIFT                      28
#define MPU_WORD_M6WE_WIDTH                      1
#define MPU_WORD_M6WE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M6WE_SHIFT))&MPU_WORD_M6WE_MASK)
#define MPU_WORD_M6RE_MASK                       0x20000000u
#define MPU_WORD_M6RE_SHIFT                      29
#define MPU_WORD_M6RE_WIDTH                      1
#define MPU_WORD_M6RE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M6RE_SHIFT))&MPU_WORD_M6RE_MASK)
#define MPU_WORD_M7WE_MASK                       0x40000000u
#define MPU_WORD_M7WE_SHIFT                      30
#define MPU_WORD_M7WE_WIDTH                      1
#define MPU_WORD_M7WE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M7WE_SHIFT))&MPU_WORD_M7WE_MASK)
#define MPU_WORD_M7RE_MASK                       0x80000000u
#define MPU_WORD_M7RE_SHIFT                      31
#define MPU_WORD_M7RE_WIDTH                      1
#define MPU_WORD_M7RE(x)                         (((uint32_t)(((uint32_t)(x))<<MPU_WORD_M7RE_SHIFT))&MPU_WORD_M7RE_MASK)
/* RGDAAC Bit Fields */
#define MPU_RGDAAC_M0UM_MASK                     0x7u
#define MPU_RGDAAC_M0UM_SHIFT                    0
#define MPU_RGDAAC_M0UM_WIDTH                    3
#define MPU_RGDAAC_M0UM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M0UM_SHIFT))&MPU_RGDAAC_M0UM_MASK)
#define MPU_RGDAAC_M0SM_MASK                     0x18u
#define MPU_RGDAAC_M0SM_SHIFT                    3
#define MPU_RGDAAC_M0SM_WIDTH                    2
#define MPU_RGDAAC_M0SM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M0SM_SHIFT))&MPU_RGDAAC_M0SM_MASK)
#define MPU_RGDAAC_M0PE_MASK                     0x20u
#define MPU_RGDAAC_M0PE_SHIFT                    5
#define MPU_RGDAAC_M0PE_WIDTH                    1
#define MPU_RGDAAC_M0PE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M0PE_SHIFT))&MPU_RGDAAC_M0PE_MASK)
#define MPU_RGDAAC_M1UM_MASK                     0x1C0u
#define MPU_RGDAAC_M1UM_SHIFT                    6
#define MPU_RGDAAC_M1UM_WIDTH                    3
#define MPU_RGDAAC_M1UM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M1UM_SHIFT))&MPU_RGDAAC_M1UM_MASK)
#define MPU_RGDAAC_M1SM_MASK                     0x600u
#define MPU_RGDAAC_M1SM_SHIFT                    9
#define MPU_RGDAAC_M1SM_WIDTH                    2
#define MPU_RGDAAC_M1SM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M1SM_SHIFT))&MPU_RGDAAC_M1SM_MASK)
#define MPU_RGDAAC_M1PE_MASK                     0x800u
#define MPU_RGDAAC_M1PE_SHIFT                    11
#define MPU_RGDAAC_M1PE_WIDTH                    1
#define MPU_RGDAAC_M1PE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M1PE_SHIFT))&MPU_RGDAAC_M1PE_MASK)
#define MPU_RGDAAC_M2UM_MASK                     0x7000u
#define MPU_RGDAAC_M2UM_SHIFT                    12
#define MPU_RGDAAC_M2UM_WIDTH                    3
#define MPU_RGDAAC_M2UM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M2UM_SHIFT))&MPU_RGDAAC_M2UM_MASK)
#define MPU_RGDAAC_M2SM_MASK                     0x18000u
#define MPU_RGDAAC_M2SM_SHIFT                    15
#define MPU_RGDAAC_M2SM_WIDTH                    2
#define MPU_RGDAAC_M2SM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M2SM_SHIFT))&MPU_RGDAAC_M2SM_MASK)
#define MPU_RGDAAC_M2PE_MASK                     0x20000u
#define MPU_RGDAAC_M2PE_SHIFT                    17
#define MPU_RGDAAC_M2PE_WIDTH                    1
#define MPU_RGDAAC_M2PE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M2PE_SHIFT))&MPU_RGDAAC_M2PE_MASK)
#define MPU_RGDAAC_M3UM_MASK                     0x1C0000u
#define MPU_RGDAAC_M3UM_SHIFT                    18
#define MPU_RGDAAC_M3UM_WIDTH                    3
#define MPU_RGDAAC_M3UM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M3UM_SHIFT))&MPU_RGDAAC_M3UM_MASK)
#define MPU_RGDAAC_M3SM_MASK                     0x600000u
#define MPU_RGDAAC_M3SM_SHIFT                    21
#define MPU_RGDAAC_M3SM_WIDTH                    2
#define MPU_RGDAAC_M3SM(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M3SM_SHIFT))&MPU_RGDAAC_M3SM_MASK)
#define MPU_RGDAAC_M3PE_MASK                     0x800000u
#define MPU_RGDAAC_M3PE_SHIFT                    23
#define MPU_RGDAAC_M3PE_WIDTH                    1
#define MPU_RGDAAC_M3PE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M3PE_SHIFT))&MPU_RGDAAC_M3PE_MASK)
#define MPU_RGDAAC_M4WE_MASK                     0x1000000u
#define MPU_RGDAAC_M4WE_SHIFT                    24
#define MPU_RGDAAC_M4WE_WIDTH                    1
#define MPU_RGDAAC_M4WE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M4WE_SHIFT))&MPU_RGDAAC_M4WE_MASK)
#define MPU_RGDAAC_M4RE_MASK                     0x2000000u
#define MPU_RGDAAC_M4RE_SHIFT                    25
#define MPU_RGDAAC_M4RE_WIDTH                    1
#define MPU_RGDAAC_M4RE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M4RE_SHIFT))&MPU_RGDAAC_M4RE_MASK)
#define MPU_RGDAAC_M5WE_MASK                     0x4000000u
#define MPU_RGDAAC_M5WE_SHIFT                    26
#define MPU_RGDAAC_M5WE_WIDTH                    1
#define MPU_RGDAAC_M5WE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M5WE_SHIFT))&MPU_RGDAAC_M5WE_MASK)
#define MPU_RGDAAC_M5RE_MASK                     0x8000000u
#define MPU_RGDAAC_M5RE_SHIFT                    27
#define MPU_RGDAAC_M5RE_WIDTH                    1
#define MPU_RGDAAC_M5RE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M5RE_SHIFT))&MPU_RGDAAC_M5RE_MASK)
#define MPU_RGDAAC_M6WE_MASK                     0x10000000u
#define MPU_RGDAAC_M6WE_SHIFT                    28
#define MPU_RGDAAC_M6WE_WIDTH                    1
#define MPU_RGDAAC_M6WE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M6WE_SHIFT))&MPU_RGDAAC_M6WE_MASK)
#define MPU_RGDAAC_M6RE_MASK                     0x20000000u
#define MPU_RGDAAC_M6RE_SHIFT                    29
#define MPU_RGDAAC_M6RE_WIDTH                    1
#define MPU_RGDAAC_M6RE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M6RE_SHIFT))&MPU_RGDAAC_M6RE_MASK)
#define MPU_RGDAAC_M7WE_MASK                     0x40000000u
#define MPU_RGDAAC_M7WE_SHIFT                    30
#define MPU_RGDAAC_M7WE_WIDTH                    1
#define MPU_RGDAAC_M7WE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M7WE_SHIFT))&MPU_RGDAAC_M7WE_MASK)
#define MPU_RGDAAC_M7RE_MASK                     0x80000000u
#define MPU_RGDAAC_M7RE_SHIFT                    31
#define MPU_RGDAAC_M7RE_WIDTH                    1
#define MPU_RGDAAC_M7RE(x)                       (((uint32_t)(((uint32_t)(x))<<MPU_RGDAAC_M7RE_SHIFT))&MPU_RGDAAC_M7RE_MASK)

/*!
 * @}
 */ /* end of group MPU_Register_Masks */


/* MPU - Peripheral instance base addresses */
/** Peripheral MPU base address */
#define MPU_BASE                                 (0x4000D000u)
/** Peripheral MPU base pointer */
#define MPU                                      ((MPU_Type *)MPU_BASE)
#define MPU_BASE_PTR                             (MPU)
/** Array initializer of MPU peripheral base addresses */
#define MPU_BASE_ADDRS                           { MPU_BASE }
/** Array initializer of MPU peripheral base pointers */
#define MPU_BASE_PTRS                            { MPU }

/* ----------------------------------------------------------------------------
   -- MPU - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MPU_Register_Accessor_Macros MPU - Register accessor macros
 * @{
 */


/* MPU - Register instance definitions */
/* MPU */
#define MPU_CESR                                 MPU_CESR_REG(MPU)
#define MPU_EAR0                                 MPU_EAR_REG(MPU,0)
#define MPU_EDR0                                 MPU_EDR_REG(MPU,0)
#define MPU_EAR1                                 MPU_EAR_REG(MPU,1)
#define MPU_EDR1                                 MPU_EDR_REG(MPU,1)
#define MPU_EAR2                                 MPU_EAR_REG(MPU,2)
#define MPU_EDR2                                 MPU_EDR_REG(MPU,2)
#define MPU_EAR3                                 MPU_EAR_REG(MPU,3)
#define MPU_EDR3                                 MPU_EDR_REG(MPU,3)
#define MPU_EAR4                                 MPU_EAR_REG(MPU,4)
#define MPU_EDR4                                 MPU_EDR_REG(MPU,4)
#define MPU_RGD0_WORD0                           MPU_WORD_REG(MPU,0,0)
#define MPU_RGD0_WORD1                           MPU_WORD_REG(MPU,0,1)
#define MPU_RGD0_WORD2                           MPU_WORD_REG(MPU,0,2)
#define MPU_RGD0_WORD3                           MPU_WORD_REG(MPU,0,3)
#define MPU_RGD1_WORD0                           MPU_WORD_REG(MPU,1,0)
#define MPU_RGD1_WORD1                           MPU_WORD_REG(MPU,1,1)
#define MPU_RGD1_WORD2                           MPU_WORD_REG(MPU,1,2)
#define MPU_RGD1_WORD3                           MPU_WORD_REG(MPU,1,3)
#define MPU_RGD2_WORD0                           MPU_WORD_REG(MPU,2,0)
#define MPU_RGD2_WORD1                           MPU_WORD_REG(MPU,2,1)
#define MPU_RGD2_WORD2                           MPU_WORD_REG(MPU,2,2)
#define MPU_RGD2_WORD3                           MPU_WORD_REG(MPU,2,3)
#define MPU_RGD3_WORD0                           MPU_WORD_REG(MPU,3,0)
#define MPU_RGD3_WORD1                           MPU_WORD_REG(MPU,3,1)
#define MPU_RGD3_WORD2                           MPU_WORD_REG(MPU,3,2)
#define MPU_RGD3_WORD3                           MPU_WORD_REG(MPU,3,3)
#define MPU_RGD4_WORD0                           MPU_WORD_REG(MPU,4,0)
#define MPU_RGD4_WORD1                           MPU_WORD_REG(MPU,4,1)
#define MPU_RGD4_WORD2                           MPU_WORD_REG(MPU,4,2)
#define MPU_RGD4_WORD3                           MPU_WORD_REG(MPU,4,3)
#define MPU_RGD5_WORD0                           MPU_WORD_REG(MPU,5,0)
#define MPU_RGD5_WORD1                           MPU_WORD_REG(MPU,5,1)
#define MPU_RGD5_WORD2                           MPU_WORD_REG(MPU,5,2)
#define MPU_RGD5_WORD3                           MPU_WORD_REG(MPU,5,3)
#define MPU_RGD6_WORD0                           MPU_WORD_REG(MPU,6,0)
#define MPU_RGD6_WORD1                           MPU_WORD_REG(MPU,6,1)
#define MPU_RGD6_WORD2                           MPU_WORD_REG(MPU,6,2)
#define MPU_RGD6_WORD3                           MPU_WORD_REG(MPU,6,3)
#define MPU_RGD7_WORD0                           MPU_WORD_REG(MPU,7,0)
#define MPU_RGD7_WORD1                           MPU_WORD_REG(MPU,7,1)
#define MPU_RGD7_WORD2                           MPU_WORD_REG(MPU,7,2)
#define MPU_RGD7_WORD3                           MPU_WORD_REG(MPU,7,3)
#define MPU_RGDAAC0                              MPU_RGDAAC_REG(MPU,0)
#define MPU_RGDAAC1                              MPU_RGDAAC_REG(MPU,1)
#define MPU_RGDAAC2                              MPU_RGDAAC_REG(MPU,2)
#define MPU_RGDAAC3                              MPU_RGDAAC_REG(MPU,3)
#define MPU_RGDAAC4                              MPU_RGDAAC_REG(MPU,4)
#define MPU_RGDAAC5                              MPU_RGDAAC_REG(MPU,5)
#define MPU_RGDAAC6                              MPU_RGDAAC_REG(MPU,6)
#define MPU_RGDAAC7                              MPU_RGDAAC_REG(MPU,7)

/* MPU - Register array accessors */
#define MPU_EAR(index)                           MPU_EAR_REG(MPU,index)
#define MPU_EDR(index)                           MPU_EDR_REG(MPU,index)
#define MPU_WORD(index,index2)                   MPU_WORD_REG(MPU,index,index2)
#define MPU_RGDAAC(index)                        MPU_RGDAAC_REG(MPU,index)

/*!
 * @}
 */ /* end of group MPU_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MPU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MTB Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTB_Peripheral_Access_Layer MTB Peripheral Access Layer
 * @{
 */

/** MTB - Register Layout Typedef */
typedef struct {
  __IO uint32_t POSITION;                          /**< MTB Position Register, offset: 0x0 */
  __IO uint32_t MASTER;                            /**< MTB Master Register, offset: 0x4 */
  __IO uint32_t FLOW;                              /**< MTB Flow Register, offset: 0x8 */
  __I  uint32_t BASE;                              /**< MTB Base Register, offset: 0xC */
       uint8_t RESERVED_0[3824];
  __I  uint32_t MODECTRL;                          /**< Integration Mode Control Register, offset: 0xF00 */
       uint8_t RESERVED_1[156];
  __I  uint32_t TAGSET;                            /**< Claim TAG Set Register, offset: 0xFA0 */
  __I  uint32_t TAGCLEAR;                          /**< Claim TAG Clear Register, offset: 0xFA4 */
       uint8_t RESERVED_2[8];
  __I  uint32_t LOCKACCESS;                        /**< Lock Access Register, offset: 0xFB0 */
  __I  uint32_t LOCKSTAT;                          /**< Lock Status Register, offset: 0xFB4 */
  __I  uint32_t AUTHSTAT;                          /**< Authentication Status Register, offset: 0xFB8 */
  __I  uint32_t DEVICEARCH;                        /**< Device Architecture Register, offset: 0xFBC */
       uint8_t RESERVED_3[8];
  __I  uint32_t DEVICECFG;                         /**< Device Configuration Register, offset: 0xFC8 */
  __I  uint32_t DEVICETYPID;                       /**< Device Type Identifier Register, offset: 0xFCC */
  __I  uint32_t PERIPHID[8];                       /**< Peripheral ID Register, array offset: 0xFD0, array step: 0x4 */
  __I  uint32_t COMPID[4];                         /**< Component ID Register, array offset: 0xFF0, array step: 0x4 */
} MTB_Type, *MTB_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MTB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTB_Register_Accessor_Macros MTB - Register accessor macros
 * @{
 */


/* MTB - Register accessors */
#define MTB_POSITION_REG(base)                   ((base)->POSITION)
#define MTB_MASTER_REG(base)                     ((base)->MASTER)
#define MTB_FLOW_REG(base)                       ((base)->FLOW)
#define MTB_BASE_REG(base)                       ((base)->BASE)
#define MTB_MODECTRL_REG(base)                   ((base)->MODECTRL)
#define MTB_TAGSET_REG(base)                     ((base)->TAGSET)
#define MTB_TAGCLEAR_REG(base)                   ((base)->TAGCLEAR)
#define MTB_LOCKACCESS_REG(base)                 ((base)->LOCKACCESS)
#define MTB_LOCKSTAT_REG(base)                   ((base)->LOCKSTAT)
#define MTB_AUTHSTAT_REG(base)                   ((base)->AUTHSTAT)
#define MTB_DEVICEARCH_REG(base)                 ((base)->DEVICEARCH)
#define MTB_DEVICECFG_REG(base)                  ((base)->DEVICECFG)
#define MTB_DEVICETYPID_REG(base)                ((base)->DEVICETYPID)
#define MTB_PERIPHID_REG(base,index)             ((base)->PERIPHID[index])
#define MTB_PERIPHID_COUNT                       8
#define MTB_COMPID_REG(base,index)               ((base)->COMPID[index])
#define MTB_COMPID_COUNT                         4

/*!
 * @}
 */ /* end of group MTB_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MTB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTB_Register_Masks MTB Register Masks
 * @{
 */

/* POSITION Bit Fields */
#define MTB_POSITION_WRAP_MASK                   0x4u
#define MTB_POSITION_WRAP_SHIFT                  2
#define MTB_POSITION_WRAP_WIDTH                  1
#define MTB_POSITION_WRAP(x)                     (((uint32_t)(((uint32_t)(x))<<MTB_POSITION_WRAP_SHIFT))&MTB_POSITION_WRAP_MASK)
#define MTB_POSITION_POINTER_MASK                0xFFFFFFF8u
#define MTB_POSITION_POINTER_SHIFT               3
#define MTB_POSITION_POINTER_WIDTH               29
#define MTB_POSITION_POINTER(x)                  (((uint32_t)(((uint32_t)(x))<<MTB_POSITION_POINTER_SHIFT))&MTB_POSITION_POINTER_MASK)
/* MASTER Bit Fields */
#define MTB_MASTER_MASK_MASK                     0x1Fu
#define MTB_MASTER_MASK_SHIFT                    0
#define MTB_MASTER_MASK_WIDTH                    5
#define MTB_MASTER_MASK(x)                       (((uint32_t)(((uint32_t)(x))<<MTB_MASTER_MASK_SHIFT))&MTB_MASTER_MASK_MASK)
#define MTB_MASTER_TSTARTEN_MASK                 0x20u
#define MTB_MASTER_TSTARTEN_SHIFT                5
#define MTB_MASTER_TSTARTEN_WIDTH                1
#define MTB_MASTER_TSTARTEN(x)                   (((uint32_t)(((uint32_t)(x))<<MTB_MASTER_TSTARTEN_SHIFT))&MTB_MASTER_TSTARTEN_MASK)
#define MTB_MASTER_TSTOPEN_MASK                  0x40u
#define MTB_MASTER_TSTOPEN_SHIFT                 6
#define MTB_MASTER_TSTOPEN_WIDTH                 1
#define MTB_MASTER_TSTOPEN(x)                    (((uint32_t)(((uint32_t)(x))<<MTB_MASTER_TSTOPEN_SHIFT))&MTB_MASTER_TSTOPEN_MASK)
#define MTB_MASTER_SFRWPRIV_MASK                 0x80u
#define MTB_MASTER_SFRWPRIV_SHIFT                7
#define MTB_MASTER_SFRWPRIV_WIDTH                1
#define MTB_MASTER_SFRWPRIV(x)                   (((uint32_t)(((uint32_t)(x))<<MTB_MASTER_SFRWPRIV_SHIFT))&MTB_MASTER_SFRWPRIV_MASK)
#define MTB_MASTER_RAMPRIV_MASK                  0x100u
#define MTB_MASTER_RAMPRIV_SHIFT                 8
#define MTB_MASTER_RAMPRIV_WIDTH                 1
#define MTB_MASTER_RAMPRIV(x)                    (((uint32_t)(((uint32_t)(x))<<MTB_MASTER_RAMPRIV_SHIFT))&MTB_MASTER_RAMPRIV_MASK)
#define MTB_MASTER_HALTREQ_MASK                  0x200u
#define MTB_MASTER_HALTREQ_SHIFT                 9
#define MTB_MASTER_HALTREQ_WIDTH                 1
#define MTB_MASTER_HALTREQ(x)                    (((uint32_t)(((uint32_t)(x))<<MTB_MASTER_HALTREQ_SHIFT))&MTB_MASTER_HALTREQ_MASK)
#define MTB_MASTER_EN_MASK                       0x80000000u
#define MTB_MASTER_EN_SHIFT                      31
#define MTB_MASTER_EN_WIDTH                      1
#define MTB_MASTER_EN(x)                         (((uint32_t)(((uint32_t)(x))<<MTB_MASTER_EN_SHIFT))&MTB_MASTER_EN_MASK)
/* FLOW Bit Fields */
#define MTB_FLOW_AUTOSTOP_MASK                   0x1u
#define MTB_FLOW_AUTOSTOP_SHIFT                  0
#define MTB_FLOW_AUTOSTOP_WIDTH                  1
#define MTB_FLOW_AUTOSTOP(x)                     (((uint32_t)(((uint32_t)(x))<<MTB_FLOW_AUTOSTOP_SHIFT))&MTB_FLOW_AUTOSTOP_MASK)
#define MTB_FLOW_AUTOHALT_MASK                   0x2u
#define MTB_FLOW_AUTOHALT_SHIFT                  1
#define MTB_FLOW_AUTOHALT_WIDTH                  1
#define MTB_FLOW_AUTOHALT(x)                     (((uint32_t)(((uint32_t)(x))<<MTB_FLOW_AUTOHALT_SHIFT))&MTB_FLOW_AUTOHALT_MASK)
#define MTB_FLOW_WATERMARK_MASK                  0xFFFFFFF8u
#define MTB_FLOW_WATERMARK_SHIFT                 3
#define MTB_FLOW_WATERMARK_WIDTH                 29
#define MTB_FLOW_WATERMARK(x)                    (((uint32_t)(((uint32_t)(x))<<MTB_FLOW_WATERMARK_SHIFT))&MTB_FLOW_WATERMARK_MASK)
/* BASE Bit Fields */
#define MTB_BASE_BASEADDR_MASK                   0xFFFFFFFFu
#define MTB_BASE_BASEADDR_SHIFT                  0
#define MTB_BASE_BASEADDR_WIDTH                  32
#define MTB_BASE_BASEADDR(x)                     (((uint32_t)(((uint32_t)(x))<<MTB_BASE_BASEADDR_SHIFT))&MTB_BASE_BASEADDR_MASK)
/* MODECTRL Bit Fields */
#define MTB_MODECTRL_MODECTRL_MASK               0xFFFFFFFFu
#define MTB_MODECTRL_MODECTRL_SHIFT              0
#define MTB_MODECTRL_MODECTRL_WIDTH              32
#define MTB_MODECTRL_MODECTRL(x)                 (((uint32_t)(((uint32_t)(x))<<MTB_MODECTRL_MODECTRL_SHIFT))&MTB_MODECTRL_MODECTRL_MASK)
/* TAGSET Bit Fields */
#define MTB_TAGSET_TAGSET_MASK                   0xFFFFFFFFu
#define MTB_TAGSET_TAGSET_SHIFT                  0
#define MTB_TAGSET_TAGSET_WIDTH                  32
#define MTB_TAGSET_TAGSET(x)                     (((uint32_t)(((uint32_t)(x))<<MTB_TAGSET_TAGSET_SHIFT))&MTB_TAGSET_TAGSET_MASK)
/* TAGCLEAR Bit Fields */
#define MTB_TAGCLEAR_TAGCLEAR_MASK               0xFFFFFFFFu
#define MTB_TAGCLEAR_TAGCLEAR_SHIFT              0
#define MTB_TAGCLEAR_TAGCLEAR_WIDTH              32
#define MTB_TAGCLEAR_TAGCLEAR(x)                 (((uint32_t)(((uint32_t)(x))<<MTB_TAGCLEAR_TAGCLEAR_SHIFT))&MTB_TAGCLEAR_TAGCLEAR_MASK)
/* LOCKACCESS Bit Fields */
#define MTB_LOCKACCESS_LOCKACCESS_MASK           0xFFFFFFFFu
#define MTB_LOCKACCESS_LOCKACCESS_SHIFT          0
#define MTB_LOCKACCESS_LOCKACCESS_WIDTH          32
#define MTB_LOCKACCESS_LOCKACCESS(x)             (((uint32_t)(((uint32_t)(x))<<MTB_LOCKACCESS_LOCKACCESS_SHIFT))&MTB_LOCKACCESS_LOCKACCESS_MASK)
/* LOCKSTAT Bit Fields */
#define MTB_LOCKSTAT_LOCKSTAT_MASK               0xFFFFFFFFu
#define MTB_LOCKSTAT_LOCKSTAT_SHIFT              0
#define MTB_LOCKSTAT_LOCKSTAT_WIDTH              32
#define MTB_LOCKSTAT_LOCKSTAT(x)                 (((uint32_t)(((uint32_t)(x))<<MTB_LOCKSTAT_LOCKSTAT_SHIFT))&MTB_LOCKSTAT_LOCKSTAT_MASK)
/* AUTHSTAT Bit Fields */
#define MTB_AUTHSTAT_BIT0_MASK                   0x1u
#define MTB_AUTHSTAT_BIT0_SHIFT                  0
#define MTB_AUTHSTAT_BIT0_WIDTH                  1
#define MTB_AUTHSTAT_BIT0(x)                     (((uint32_t)(((uint32_t)(x))<<MTB_AUTHSTAT_BIT0_SHIFT))&MTB_AUTHSTAT_BIT0_MASK)
#define MTB_AUTHSTAT_BIT2_MASK                   0x4u
#define MTB_AUTHSTAT_BIT2_SHIFT                  2
#define MTB_AUTHSTAT_BIT2_WIDTH                  1
#define MTB_AUTHSTAT_BIT2(x)                     (((uint32_t)(((uint32_t)(x))<<MTB_AUTHSTAT_BIT2_SHIFT))&MTB_AUTHSTAT_BIT2_MASK)
/* DEVICEARCH Bit Fields */
#define MTB_DEVICEARCH_DEVICEARCH_MASK           0xFFFFFFFFu
#define MTB_DEVICEARCH_DEVICEARCH_SHIFT          0
#define MTB_DEVICEARCH_DEVICEARCH_WIDTH          32
#define MTB_DEVICEARCH_DEVICEARCH(x)             (((uint32_t)(((uint32_t)(x))<<MTB_DEVICEARCH_DEVICEARCH_SHIFT))&MTB_DEVICEARCH_DEVICEARCH_MASK)
/* DEVICECFG Bit Fields */
#define MTB_DEVICECFG_DEVICECFG_MASK             0xFFFFFFFFu
#define MTB_DEVICECFG_DEVICECFG_SHIFT            0
#define MTB_DEVICECFG_DEVICECFG_WIDTH            32
#define MTB_DEVICECFG_DEVICECFG(x)               (((uint32_t)(((uint32_t)(x))<<MTB_DEVICECFG_DEVICECFG_SHIFT))&MTB_DEVICECFG_DEVICECFG_MASK)
/* DEVICETYPID Bit Fields */
#define MTB_DEVICETYPID_DEVICETYPID_MASK         0xFFFFFFFFu
#define MTB_DEVICETYPID_DEVICETYPID_SHIFT        0
#define MTB_DEVICETYPID_DEVICETYPID_WIDTH        32
#define MTB_DEVICETYPID_DEVICETYPID(x)           (((uint32_t)(((uint32_t)(x))<<MTB_DEVICETYPID_DEVICETYPID_SHIFT))&MTB_DEVICETYPID_DEVICETYPID_MASK)
/* PERIPHID Bit Fields */
#define MTB_PERIPHID_PERIPHID_MASK               0xFFFFFFFFu
#define MTB_PERIPHID_PERIPHID_SHIFT              0
#define MTB_PERIPHID_PERIPHID_WIDTH              32
#define MTB_PERIPHID_PERIPHID(x)                 (((uint32_t)(((uint32_t)(x))<<MTB_PERIPHID_PERIPHID_SHIFT))&MTB_PERIPHID_PERIPHID_MASK)
/* COMPID Bit Fields */
#define MTB_COMPID_COMPID_MASK                   0xFFFFFFFFu
#define MTB_COMPID_COMPID_SHIFT                  0
#define MTB_COMPID_COMPID_WIDTH                  32
#define MTB_COMPID_COMPID(x)                     (((uint32_t)(((uint32_t)(x))<<MTB_COMPID_COMPID_SHIFT))&MTB_COMPID_COMPID_MASK)

/*!
 * @}
 */ /* end of group MTB_Register_Masks */


/* MTB - Peripheral instance base addresses */
/** Peripheral MTB base address */
#define MTB_BASE                                 (0xF0000000u)
/** Peripheral MTB base pointer */
#define MTB                                      ((MTB_Type *)MTB_BASE)
#define MTB_BASE_PTR                             (MTB)
/** Array initializer of MTB peripheral base addresses */
#define MTB_BASE_ADDRS                           { MTB_BASE }
/** Array initializer of MTB peripheral base pointers */
#define MTB_BASE_PTRS                            { MTB }

/* ----------------------------------------------------------------------------
   -- MTB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTB_Register_Accessor_Macros MTB - Register accessor macros
 * @{
 */


/* MTB - Register instance definitions */
/* MTB */
#define MTB_POSITION                             MTB_POSITION_REG(MTB)
#define MTB_MASTER                               MTB_MASTER_REG(MTB)
#define MTB_FLOW                                 MTB_FLOW_REG(MTB)
#define MTB_BASEr                                MTB_BASE_REG(MTB)
#define MTB_MODECTRL                             MTB_MODECTRL_REG(MTB)
#define MTB_TAGSET                               MTB_TAGSET_REG(MTB)
#define MTB_TAGCLEAR                             MTB_TAGCLEAR_REG(MTB)
#define MTB_LOCKACCESS                           MTB_LOCKACCESS_REG(MTB)
#define MTB_LOCKSTAT                             MTB_LOCKSTAT_REG(MTB)
#define MTB_AUTHSTAT                             MTB_AUTHSTAT_REG(MTB)
#define MTB_DEVICEARCH                           MTB_DEVICEARCH_REG(MTB)
#define MTB_DEVICECFG                            MTB_DEVICECFG_REG(MTB)
#define MTB_DEVICETYPID                          MTB_DEVICETYPID_REG(MTB)
#define MTB_PERIPHID4                            MTB_PERIPHID_REG(MTB,0)
#define MTB_PERIPHID5                            MTB_PERIPHID_REG(MTB,1)
#define MTB_PERIPHID6                            MTB_PERIPHID_REG(MTB,2)
#define MTB_PERIPHID7                            MTB_PERIPHID_REG(MTB,3)
#define MTB_PERIPHID0                            MTB_PERIPHID_REG(MTB,4)
#define MTB_PERIPHID1                            MTB_PERIPHID_REG(MTB,5)
#define MTB_PERIPHID2                            MTB_PERIPHID_REG(MTB,6)
#define MTB_PERIPHID3                            MTB_PERIPHID_REG(MTB,7)
#define MTB_COMPID0                              MTB_COMPID_REG(MTB,0)
#define MTB_COMPID1                              MTB_COMPID_REG(MTB,1)
#define MTB_COMPID2                              MTB_COMPID_REG(MTB,2)
#define MTB_COMPID3                              MTB_COMPID_REG(MTB,3)

/* MTB - Register array accessors */
#define MTB_PERIPHID(index)                      MTB_PERIPHID_REG(MTB,index)
#define MTB_COMPID(index)                        MTB_COMPID_REG(MTB,index)

/*!
 * @}
 */ /* end of group MTB_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MTB_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MTBDWT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTBDWT_Peripheral_Access_Layer MTBDWT Peripheral Access Layer
 * @{
 */

/** MTBDWT - Register Layout Typedef */
typedef struct {
  __I  uint32_t CTRL;                              /**< MTB DWT Control Register, offset: 0x0 */
       uint8_t RESERVED_0[28];
  struct {                                         /* offset: 0x20, array step: 0x10 */
    __IO uint32_t COMP;                              /**< MTB_DWT Comparator Register, array offset: 0x20, array step: 0x10 */
    __IO uint32_t MASK;                              /**< MTB_DWT Comparator Mask Register, array offset: 0x24, array step: 0x10 */
    __IO uint32_t FCT;                               /**< MTB_DWT Comparator Function Register 0..MTB_DWT Comparator Function Register 1, array offset: 0x28, array step: 0x10 */
         uint8_t RESERVED_0[4];
  } COMPARATOR[2];
       uint8_t RESERVED_1[448];
  __IO uint32_t TBCTRL;                            /**< MTB_DWT Trace Buffer Control Register, offset: 0x200 */
       uint8_t RESERVED_2[3524];
  __I  uint32_t DEVICECFG;                         /**< Device Configuration Register, offset: 0xFC8 */
  __I  uint32_t DEVICETYPID;                       /**< Device Type Identifier Register, offset: 0xFCC */
  __I  uint32_t PERIPHID[8];                       /**< Peripheral ID Register, array offset: 0xFD0, array step: 0x4 */
  __I  uint32_t COMPID[4];                         /**< Component ID Register, array offset: 0xFF0, array step: 0x4 */
} MTBDWT_Type, *MTBDWT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- MTBDWT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTBDWT_Register_Accessor_Macros MTBDWT - Register accessor macros
 * @{
 */


/* MTBDWT - Register accessors */
#define MTBDWT_CTRL_REG(base)                    ((base)->CTRL)
#define MTBDWT_COMP_REG(base,index)              ((base)->COMPARATOR[index].COMP)
#define MTBDWT_COMP_COUNT                        2
#define MTBDWT_MASK_REG(base,index)              ((base)->COMPARATOR[index].MASK)
#define MTBDWT_MASK_COUNT                        2
#define MTBDWT_FCT_REG(base,index)               ((base)->COMPARATOR[index].FCT)
#define MTBDWT_FCT_COUNT                         2
#define MTBDWT_TBCTRL_REG(base)                  ((base)->TBCTRL)
#define MTBDWT_DEVICECFG_REG(base)               ((base)->DEVICECFG)
#define MTBDWT_DEVICETYPID_REG(base)             ((base)->DEVICETYPID)
#define MTBDWT_PERIPHID_REG(base,index)          ((base)->PERIPHID[index])
#define MTBDWT_PERIPHID_COUNT                    8
#define MTBDWT_COMPID_REG(base,index)            ((base)->COMPID[index])
#define MTBDWT_COMPID_COUNT                      4

/*!
 * @}
 */ /* end of group MTBDWT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- MTBDWT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTBDWT_Register_Masks MTBDWT Register Masks
 * @{
 */

/* CTRL Bit Fields */
#define MTBDWT_CTRL_DWTCFGCTRL_MASK              0xFFFFFFFu
#define MTBDWT_CTRL_DWTCFGCTRL_SHIFT             0
#define MTBDWT_CTRL_DWTCFGCTRL_WIDTH             28
#define MTBDWT_CTRL_DWTCFGCTRL(x)                (((uint32_t)(((uint32_t)(x))<<MTBDWT_CTRL_DWTCFGCTRL_SHIFT))&MTBDWT_CTRL_DWTCFGCTRL_MASK)
#define MTBDWT_CTRL_NUMCMP_MASK                  0xF0000000u
#define MTBDWT_CTRL_NUMCMP_SHIFT                 28
#define MTBDWT_CTRL_NUMCMP_WIDTH                 4
#define MTBDWT_CTRL_NUMCMP(x)                    (((uint32_t)(((uint32_t)(x))<<MTBDWT_CTRL_NUMCMP_SHIFT))&MTBDWT_CTRL_NUMCMP_MASK)
/* COMP Bit Fields */
#define MTBDWT_COMP_COMP_MASK                    0xFFFFFFFFu
#define MTBDWT_COMP_COMP_SHIFT                   0
#define MTBDWT_COMP_COMP_WIDTH                   32
#define MTBDWT_COMP_COMP(x)                      (((uint32_t)(((uint32_t)(x))<<MTBDWT_COMP_COMP_SHIFT))&MTBDWT_COMP_COMP_MASK)
/* MASK Bit Fields */
#define MTBDWT_MASK_MASK_MASK                    0x1Fu
#define MTBDWT_MASK_MASK_SHIFT                   0
#define MTBDWT_MASK_MASK_WIDTH                   5
#define MTBDWT_MASK_MASK(x)                      (((uint32_t)(((uint32_t)(x))<<MTBDWT_MASK_MASK_SHIFT))&MTBDWT_MASK_MASK_MASK)
/* FCT Bit Fields */
#define MTBDWT_FCT_FUNCTION_MASK                 0xFu
#define MTBDWT_FCT_FUNCTION_SHIFT                0
#define MTBDWT_FCT_FUNCTION_WIDTH                4
#define MTBDWT_FCT_FUNCTION(x)                   (((uint32_t)(((uint32_t)(x))<<MTBDWT_FCT_FUNCTION_SHIFT))&MTBDWT_FCT_FUNCTION_MASK)
#define MTBDWT_FCT_DATAVMATCH_MASK               0x100u
#define MTBDWT_FCT_DATAVMATCH_SHIFT              8
#define MTBDWT_FCT_DATAVMATCH_WIDTH              1
#define MTBDWT_FCT_DATAVMATCH(x)                 (((uint32_t)(((uint32_t)(x))<<MTBDWT_FCT_DATAVMATCH_SHIFT))&MTBDWT_FCT_DATAVMATCH_MASK)
#define MTBDWT_FCT_DATAVSIZE_MASK                0xC00u
#define MTBDWT_FCT_DATAVSIZE_SHIFT               10
#define MTBDWT_FCT_DATAVSIZE_WIDTH               2
#define MTBDWT_FCT_DATAVSIZE(x)                  (((uint32_t)(((uint32_t)(x))<<MTBDWT_FCT_DATAVSIZE_SHIFT))&MTBDWT_FCT_DATAVSIZE_MASK)
#define MTBDWT_FCT_DATAVADDR0_MASK               0xF000u
#define MTBDWT_FCT_DATAVADDR0_SHIFT              12
#define MTBDWT_FCT_DATAVADDR0_WIDTH              4
#define MTBDWT_FCT_DATAVADDR0(x)                 (((uint32_t)(((uint32_t)(x))<<MTBDWT_FCT_DATAVADDR0_SHIFT))&MTBDWT_FCT_DATAVADDR0_MASK)
#define MTBDWT_FCT_MATCHED_MASK                  0x1000000u
#define MTBDWT_FCT_MATCHED_SHIFT                 24
#define MTBDWT_FCT_MATCHED_WIDTH                 1
#define MTBDWT_FCT_MATCHED(x)                    (((uint32_t)(((uint32_t)(x))<<MTBDWT_FCT_MATCHED_SHIFT))&MTBDWT_FCT_MATCHED_MASK)
/* TBCTRL Bit Fields */
#define MTBDWT_TBCTRL_ACOMP0_MASK                0x1u
#define MTBDWT_TBCTRL_ACOMP0_SHIFT               0
#define MTBDWT_TBCTRL_ACOMP0_WIDTH               1
#define MTBDWT_TBCTRL_ACOMP0(x)                  (((uint32_t)(((uint32_t)(x))<<MTBDWT_TBCTRL_ACOMP0_SHIFT))&MTBDWT_TBCTRL_ACOMP0_MASK)
#define MTBDWT_TBCTRL_ACOMP1_MASK                0x2u
#define MTBDWT_TBCTRL_ACOMP1_SHIFT               1
#define MTBDWT_TBCTRL_ACOMP1_WIDTH               1
#define MTBDWT_TBCTRL_ACOMP1(x)                  (((uint32_t)(((uint32_t)(x))<<MTBDWT_TBCTRL_ACOMP1_SHIFT))&MTBDWT_TBCTRL_ACOMP1_MASK)
#define MTBDWT_TBCTRL_NUMCOMP_MASK               0xF0000000u
#define MTBDWT_TBCTRL_NUMCOMP_SHIFT              28
#define MTBDWT_TBCTRL_NUMCOMP_WIDTH              4
#define MTBDWT_TBCTRL_NUMCOMP(x)                 (((uint32_t)(((uint32_t)(x))<<MTBDWT_TBCTRL_NUMCOMP_SHIFT))&MTBDWT_TBCTRL_NUMCOMP_MASK)
/* DEVICECFG Bit Fields */
#define MTBDWT_DEVICECFG_DEVICECFG_MASK          0xFFFFFFFFu
#define MTBDWT_DEVICECFG_DEVICECFG_SHIFT         0
#define MTBDWT_DEVICECFG_DEVICECFG_WIDTH         32
#define MTBDWT_DEVICECFG_DEVICECFG(x)            (((uint32_t)(((uint32_t)(x))<<MTBDWT_DEVICECFG_DEVICECFG_SHIFT))&MTBDWT_DEVICECFG_DEVICECFG_MASK)
/* DEVICETYPID Bit Fields */
#define MTBDWT_DEVICETYPID_DEVICETYPID_MASK      0xFFFFFFFFu
#define MTBDWT_DEVICETYPID_DEVICETYPID_SHIFT     0
#define MTBDWT_DEVICETYPID_DEVICETYPID_WIDTH     32
#define MTBDWT_DEVICETYPID_DEVICETYPID(x)        (((uint32_t)(((uint32_t)(x))<<MTBDWT_DEVICETYPID_DEVICETYPID_SHIFT))&MTBDWT_DEVICETYPID_DEVICETYPID_MASK)
/* PERIPHID Bit Fields */
#define MTBDWT_PERIPHID_PERIPHID_MASK            0xFFFFFFFFu
#define MTBDWT_PERIPHID_PERIPHID_SHIFT           0
#define MTBDWT_PERIPHID_PERIPHID_WIDTH           32
#define MTBDWT_PERIPHID_PERIPHID(x)              (((uint32_t)(((uint32_t)(x))<<MTBDWT_PERIPHID_PERIPHID_SHIFT))&MTBDWT_PERIPHID_PERIPHID_MASK)
/* COMPID Bit Fields */
#define MTBDWT_COMPID_COMPID_MASK                0xFFFFFFFFu
#define MTBDWT_COMPID_COMPID_SHIFT               0
#define MTBDWT_COMPID_COMPID_WIDTH               32
#define MTBDWT_COMPID_COMPID(x)                  (((uint32_t)(((uint32_t)(x))<<MTBDWT_COMPID_COMPID_SHIFT))&MTBDWT_COMPID_COMPID_MASK)

/*!
 * @}
 */ /* end of group MTBDWT_Register_Masks */


/* MTBDWT - Peripheral instance base addresses */
/** Peripheral MTBDWT base address */
#define MTBDWT_BASE                              (0xF0001000u)
/** Peripheral MTBDWT base pointer */
#define MTBDWT                                   ((MTBDWT_Type *)MTBDWT_BASE)
#define MTBDWT_BASE_PTR                          (MTBDWT)
/** Array initializer of MTBDWT peripheral base addresses */
#define MTBDWT_BASE_ADDRS                        { MTBDWT_BASE }
/** Array initializer of MTBDWT peripheral base pointers */
#define MTBDWT_BASE_PTRS                         { MTBDWT }

/* ----------------------------------------------------------------------------
   -- MTBDWT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MTBDWT_Register_Accessor_Macros MTBDWT - Register accessor macros
 * @{
 */


/* MTBDWT - Register instance definitions */
/* MTBDWT */
#define MTBDWT_CTRL                              MTBDWT_CTRL_REG(MTBDWT)
#define MTBDWT_COMP0                             MTBDWT_COMP_REG(MTBDWT,0)
#define MTBDWT_MASK0                             MTBDWT_MASK_REG(MTBDWT,0)
#define MTBDWT_FCT0                              MTBDWT_FCT_REG(MTBDWT,0)
#define MTBDWT_COMP1                             MTBDWT_COMP_REG(MTBDWT,1)
#define MTBDWT_MASK1                             MTBDWT_MASK_REG(MTBDWT,1)
#define MTBDWT_FCT1                              MTBDWT_FCT_REG(MTBDWT,1)
#define MTBDWT_TBCTRL                            MTBDWT_TBCTRL_REG(MTBDWT)
#define MTBDWT_DEVICECFG                         MTBDWT_DEVICECFG_REG(MTBDWT)
#define MTBDWT_DEVICETYPID                       MTBDWT_DEVICETYPID_REG(MTBDWT)
#define MTBDWT_PERIPHID4                         MTBDWT_PERIPHID_REG(MTBDWT,0)
#define MTBDWT_PERIPHID5                         MTBDWT_PERIPHID_REG(MTBDWT,1)
#define MTBDWT_PERIPHID6                         MTBDWT_PERIPHID_REG(MTBDWT,2)
#define MTBDWT_PERIPHID7                         MTBDWT_PERIPHID_REG(MTBDWT,3)
#define MTBDWT_PERIPHID0                         MTBDWT_PERIPHID_REG(MTBDWT,4)
#define MTBDWT_PERIPHID1                         MTBDWT_PERIPHID_REG(MTBDWT,5)
#define MTBDWT_PERIPHID2                         MTBDWT_PERIPHID_REG(MTBDWT,6)
#define MTBDWT_PERIPHID3                         MTBDWT_PERIPHID_REG(MTBDWT,7)
#define MTBDWT_COMPID0                           MTBDWT_COMPID_REG(MTBDWT,0)
#define MTBDWT_COMPID1                           MTBDWT_COMPID_REG(MTBDWT,1)
#define MTBDWT_COMPID2                           MTBDWT_COMPID_REG(MTBDWT,2)
#define MTBDWT_COMPID3                           MTBDWT_COMPID_REG(MTBDWT,3)

/* MTBDWT - Register array accessors */
#define MTBDWT_COMP(index)                       MTBDWT_COMP_REG(MTBDWT,index)
#define MTBDWT_MASK(index)                       MTBDWT_MASK_REG(MTBDWT,index)
#define MTBDWT_FCT(index)                        MTBDWT_FCT_REG(MTBDWT,index)
#define MTBDWT_PERIPHID(index)                   MTBDWT_PERIPHID_REG(MTBDWT,index)
#define MTBDWT_COMPID(index)                     MTBDWT_COMPID_REG(MTBDWT,index)

/*!
 * @}
 */ /* end of group MTBDWT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group MTBDWT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- NV Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Peripheral_Access_Layer NV Peripheral Access Layer
 * @{
 */

/** NV - Register Layout Typedef */
typedef struct {
  __I  uint8_t BACKKEY3;                           /**< Backdoor Comparison Key 3., offset: 0x0 */
  __I  uint8_t BACKKEY2;                           /**< Backdoor Comparison Key 2., offset: 0x1 */
  __I  uint8_t BACKKEY1;                           /**< Backdoor Comparison Key 1., offset: 0x2 */
  __I  uint8_t BACKKEY0;                           /**< Backdoor Comparison Key 0., offset: 0x3 */
  __I  uint8_t BACKKEY7;                           /**< Backdoor Comparison Key 7., offset: 0x4 */
  __I  uint8_t BACKKEY6;                           /**< Backdoor Comparison Key 6., offset: 0x5 */
  __I  uint8_t BACKKEY5;                           /**< Backdoor Comparison Key 5., offset: 0x6 */
  __I  uint8_t BACKKEY4;                           /**< Backdoor Comparison Key 4., offset: 0x7 */
  __I  uint8_t FPROT3;                             /**< Non-volatile P-Flash Protection 1 - Low Register, offset: 0x8 */
  __I  uint8_t FPROT2;                             /**< Non-volatile P-Flash Protection 1 - High Register, offset: 0x9 */
  __I  uint8_t FPROT1;                             /**< Non-volatile P-Flash Protection 0 - Low Register, offset: 0xA */
  __I  uint8_t FPROT0;                             /**< Non-volatile P-Flash Protection 0 - High Register, offset: 0xB */
  __I  uint8_t FSEC;                               /**< Non-volatile Flash Security Register, offset: 0xC */
  __I  uint8_t FOPT;                               /**< Non-volatile Flash Option Register, offset: 0xD */
} NV_Type, *NV_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- NV - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Register_Accessor_Macros NV - Register accessor macros
 * @{
 */


/* NV - Register accessors */
#define NV_BACKKEY3_REG(base)                    ((base)->BACKKEY3)
#define NV_BACKKEY2_REG(base)                    ((base)->BACKKEY2)
#define NV_BACKKEY1_REG(base)                    ((base)->BACKKEY1)
#define NV_BACKKEY0_REG(base)                    ((base)->BACKKEY0)
#define NV_BACKKEY7_REG(base)                    ((base)->BACKKEY7)
#define NV_BACKKEY6_REG(base)                    ((base)->BACKKEY6)
#define NV_BACKKEY5_REG(base)                    ((base)->BACKKEY5)
#define NV_BACKKEY4_REG(base)                    ((base)->BACKKEY4)
#define NV_FPROT3_REG(base)                      ((base)->FPROT3)
#define NV_FPROT2_REG(base)                      ((base)->FPROT2)
#define NV_FPROT1_REG(base)                      ((base)->FPROT1)
#define NV_FPROT0_REG(base)                      ((base)->FPROT0)
#define NV_FSEC_REG(base)                        ((base)->FSEC)
#define NV_FOPT_REG(base)                        ((base)->FOPT)

/*!
 * @}
 */ /* end of group NV_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- NV Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Register_Masks NV Register Masks
 * @{
 */

/* BACKKEY3 Bit Fields */
#define NV_BACKKEY3_KEY_MASK                     0xFFu
#define NV_BACKKEY3_KEY_SHIFT                    0
#define NV_BACKKEY3_KEY_WIDTH                    8
#define NV_BACKKEY3_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY3_KEY_SHIFT))&NV_BACKKEY3_KEY_MASK)
/* BACKKEY2 Bit Fields */
#define NV_BACKKEY2_KEY_MASK                     0xFFu
#define NV_BACKKEY2_KEY_SHIFT                    0
#define NV_BACKKEY2_KEY_WIDTH                    8
#define NV_BACKKEY2_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY2_KEY_SHIFT))&NV_BACKKEY2_KEY_MASK)
/* BACKKEY1 Bit Fields */
#define NV_BACKKEY1_KEY_MASK                     0xFFu
#define NV_BACKKEY1_KEY_SHIFT                    0
#define NV_BACKKEY1_KEY_WIDTH                    8
#define NV_BACKKEY1_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY1_KEY_SHIFT))&NV_BACKKEY1_KEY_MASK)
/* BACKKEY0 Bit Fields */
#define NV_BACKKEY0_KEY_MASK                     0xFFu
#define NV_BACKKEY0_KEY_SHIFT                    0
#define NV_BACKKEY0_KEY_WIDTH                    8
#define NV_BACKKEY0_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY0_KEY_SHIFT))&NV_BACKKEY0_KEY_MASK)
/* BACKKEY7 Bit Fields */
#define NV_BACKKEY7_KEY_MASK                     0xFFu
#define NV_BACKKEY7_KEY_SHIFT                    0
#define NV_BACKKEY7_KEY_WIDTH                    8
#define NV_BACKKEY7_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY7_KEY_SHIFT))&NV_BACKKEY7_KEY_MASK)
/* BACKKEY6 Bit Fields */
#define NV_BACKKEY6_KEY_MASK                     0xFFu
#define NV_BACKKEY6_KEY_SHIFT                    0
#define NV_BACKKEY6_KEY_WIDTH                    8
#define NV_BACKKEY6_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY6_KEY_SHIFT))&NV_BACKKEY6_KEY_MASK)
/* BACKKEY5 Bit Fields */
#define NV_BACKKEY5_KEY_MASK                     0xFFu
#define NV_BACKKEY5_KEY_SHIFT                    0
#define NV_BACKKEY5_KEY_WIDTH                    8
#define NV_BACKKEY5_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY5_KEY_SHIFT))&NV_BACKKEY5_KEY_MASK)
/* BACKKEY4 Bit Fields */
#define NV_BACKKEY4_KEY_MASK                     0xFFu
#define NV_BACKKEY4_KEY_SHIFT                    0
#define NV_BACKKEY4_KEY_WIDTH                    8
#define NV_BACKKEY4_KEY(x)                       (((uint8_t)(((uint8_t)(x))<<NV_BACKKEY4_KEY_SHIFT))&NV_BACKKEY4_KEY_MASK)
/* FPROT3 Bit Fields */
#define NV_FPROT3_PROT_MASK                      0xFFu
#define NV_FPROT3_PROT_SHIFT                     0
#define NV_FPROT3_PROT_WIDTH                     8
#define NV_FPROT3_PROT(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FPROT3_PROT_SHIFT))&NV_FPROT3_PROT_MASK)
/* FPROT2 Bit Fields */
#define NV_FPROT2_PROT_MASK                      0xFFu
#define NV_FPROT2_PROT_SHIFT                     0
#define NV_FPROT2_PROT_WIDTH                     8
#define NV_FPROT2_PROT(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FPROT2_PROT_SHIFT))&NV_FPROT2_PROT_MASK)
/* FPROT1 Bit Fields */
#define NV_FPROT1_PROT_MASK                      0xFFu
#define NV_FPROT1_PROT_SHIFT                     0
#define NV_FPROT1_PROT_WIDTH                     8
#define NV_FPROT1_PROT(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FPROT1_PROT_SHIFT))&NV_FPROT1_PROT_MASK)
/* FPROT0 Bit Fields */
#define NV_FPROT0_PROT_MASK                      0xFFu
#define NV_FPROT0_PROT_SHIFT                     0
#define NV_FPROT0_PROT_WIDTH                     8
#define NV_FPROT0_PROT(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FPROT0_PROT_SHIFT))&NV_FPROT0_PROT_MASK)
/* FSEC Bit Fields */
#define NV_FSEC_SEC_MASK                         0x3u
#define NV_FSEC_SEC_SHIFT                        0
#define NV_FSEC_SEC_WIDTH                        2
#define NV_FSEC_SEC(x)                           (((uint8_t)(((uint8_t)(x))<<NV_FSEC_SEC_SHIFT))&NV_FSEC_SEC_MASK)
#define NV_FSEC_FSLACC_MASK                      0xCu
#define NV_FSEC_FSLACC_SHIFT                     2
#define NV_FSEC_FSLACC_WIDTH                     2
#define NV_FSEC_FSLACC(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FSEC_FSLACC_SHIFT))&NV_FSEC_FSLACC_MASK)
#define NV_FSEC_MEEN_MASK                        0x30u
#define NV_FSEC_MEEN_SHIFT                       4
#define NV_FSEC_MEEN_WIDTH                       2
#define NV_FSEC_MEEN(x)                          (((uint8_t)(((uint8_t)(x))<<NV_FSEC_MEEN_SHIFT))&NV_FSEC_MEEN_MASK)
#define NV_FSEC_KEYEN_MASK                       0xC0u
#define NV_FSEC_KEYEN_SHIFT                      6
#define NV_FSEC_KEYEN_WIDTH                      2
#define NV_FSEC_KEYEN(x)                         (((uint8_t)(((uint8_t)(x))<<NV_FSEC_KEYEN_SHIFT))&NV_FSEC_KEYEN_MASK)
/* FOPT Bit Fields */
#define NV_FOPT_LPBOOT_MASK                      0x1u
#define NV_FOPT_LPBOOT_SHIFT                     0
#define NV_FOPT_LPBOOT_WIDTH                     1
#define NV_FOPT_LPBOOT(x)                        (((uint8_t)(((uint8_t)(x))<<NV_FOPT_LPBOOT_SHIFT))&NV_FOPT_LPBOOT_MASK)
#define NV_FOPT_BOOTPIN_OPT_MASK                 0x2u
#define NV_FOPT_BOOTPIN_OPT_SHIFT                1
#define NV_FOPT_BOOTPIN_OPT_WIDTH                1
#define NV_FOPT_BOOTPIN_OPT(x)                   (((uint8_t)(((uint8_t)(x))<<NV_FOPT_BOOTPIN_OPT_SHIFT))&NV_FOPT_BOOTPIN_OPT_MASK)
#define NV_FOPT_NMI_DIS_MASK                     0x4u
#define NV_FOPT_NMI_DIS_SHIFT                    2
#define NV_FOPT_NMI_DIS_WIDTH                    1
#define NV_FOPT_NMI_DIS(x)                       (((uint8_t)(((uint8_t)(x))<<NV_FOPT_NMI_DIS_SHIFT))&NV_FOPT_NMI_DIS_MASK)
#define NV_FOPT_FAST_INIT_MASK                   0x20u
#define NV_FOPT_FAST_INIT_SHIFT                  5
#define NV_FOPT_FAST_INIT_WIDTH                  1
#define NV_FOPT_FAST_INIT(x)                     (((uint8_t)(((uint8_t)(x))<<NV_FOPT_FAST_INIT_SHIFT))&NV_FOPT_FAST_INIT_MASK)
#define NV_FOPT_BOOTSRC_SEL_MASK                 0xC0u
#define NV_FOPT_BOOTSRC_SEL_SHIFT                6
#define NV_FOPT_BOOTSRC_SEL_WIDTH                2
#define NV_FOPT_BOOTSRC_SEL(x)                   (((uint8_t)(((uint8_t)(x))<<NV_FOPT_BOOTSRC_SEL_SHIFT))&NV_FOPT_BOOTSRC_SEL_MASK)

/*!
 * @}
 */ /* end of group NV_Register_Masks */


/* NV - Peripheral instance base addresses */
/** Peripheral FTFA_FlashConfig base address */
#define FTFA_FlashConfig_BASE                    (0x400u)
/** Peripheral FTFA_FlashConfig base pointer */
#define FTFA_FlashConfig                         ((NV_Type *)FTFA_FlashConfig_BASE)
#define FTFA_FlashConfig_BASE_PTR                (FTFA_FlashConfig)
/** Array initializer of NV peripheral base addresses */
#define NV_BASE_ADDRS                            { FTFA_FlashConfig_BASE }
/** Array initializer of NV peripheral base pointers */
#define NV_BASE_PTRS                             { FTFA_FlashConfig }

/* ----------------------------------------------------------------------------
   -- NV - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup NV_Register_Accessor_Macros NV - Register accessor macros
 * @{
 */


/* NV - Register instance definitions */
/* FTFA_FlashConfig */
#define NV_BACKKEY3                              NV_BACKKEY3_REG(FTFA_FlashConfig)
#define NV_BACKKEY2                              NV_BACKKEY2_REG(FTFA_FlashConfig)
#define NV_BACKKEY1                              NV_BACKKEY1_REG(FTFA_FlashConfig)
#define NV_BACKKEY0                              NV_BACKKEY0_REG(FTFA_FlashConfig)
#define NV_BACKKEY7                              NV_BACKKEY7_REG(FTFA_FlashConfig)
#define NV_BACKKEY6                              NV_BACKKEY6_REG(FTFA_FlashConfig)
#define NV_BACKKEY5                              NV_BACKKEY5_REG(FTFA_FlashConfig)
#define NV_BACKKEY4                              NV_BACKKEY4_REG(FTFA_FlashConfig)
#define NV_FPROT3                                NV_FPROT3_REG(FTFA_FlashConfig)
#define NV_FPROT2                                NV_FPROT2_REG(FTFA_FlashConfig)
#define NV_FPROT1                                NV_FPROT1_REG(FTFA_FlashConfig)
#define NV_FPROT0                                NV_FPROT0_REG(FTFA_FlashConfig)
#define NV_FSEC                                  NV_FSEC_REG(FTFA_FlashConfig)
#define NV_FOPT                                  NV_FOPT_REG(FTFA_FlashConfig)

/*!
 * @}
 */ /* end of group NV_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group NV_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- OSC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSC_Peripheral_Access_Layer OSC Peripheral Access Layer
 * @{
 */

/** OSC - Register Layout Typedef */
typedef struct {
  __IO uint8_t CR;                                 /**< OSC Control Register, offset: 0x0 */
       uint8_t RESERVED_0[1];
  __IO uint8_t DIV;                                /**< OSC_DIV, offset: 0x2 */
} OSC_Type, *OSC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- OSC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSC_Register_Accessor_Macros OSC - Register accessor macros
 * @{
 */


/* OSC - Register accessors */
#define OSC_CR_REG(base)                         ((base)->CR)
#define OSC_DIV_REG(base)                        ((base)->DIV)

/*!
 * @}
 */ /* end of group OSC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- OSC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSC_Register_Masks OSC Register Masks
 * @{
 */

/* CR Bit Fields */
#define OSC_CR_SC16P_MASK                        0x1u
#define OSC_CR_SC16P_SHIFT                       0
#define OSC_CR_SC16P_WIDTH                       1
#define OSC_CR_SC16P(x)                          (((uint8_t)(((uint8_t)(x))<<OSC_CR_SC16P_SHIFT))&OSC_CR_SC16P_MASK)
#define OSC_CR_SC8P_MASK                         0x2u
#define OSC_CR_SC8P_SHIFT                        1
#define OSC_CR_SC8P_WIDTH                        1
#define OSC_CR_SC8P(x)                           (((uint8_t)(((uint8_t)(x))<<OSC_CR_SC8P_SHIFT))&OSC_CR_SC8P_MASK)
#define OSC_CR_SC4P_MASK                         0x4u
#define OSC_CR_SC4P_SHIFT                        2
#define OSC_CR_SC4P_WIDTH                        1
#define OSC_CR_SC4P(x)                           (((uint8_t)(((uint8_t)(x))<<OSC_CR_SC4P_SHIFT))&OSC_CR_SC4P_MASK)
#define OSC_CR_SC2P_MASK                         0x8u
#define OSC_CR_SC2P_SHIFT                        3
#define OSC_CR_SC2P_WIDTH                        1
#define OSC_CR_SC2P(x)                           (((uint8_t)(((uint8_t)(x))<<OSC_CR_SC2P_SHIFT))&OSC_CR_SC2P_MASK)
#define OSC_CR_EREFSTEN_MASK                     0x20u
#define OSC_CR_EREFSTEN_SHIFT                    5
#define OSC_CR_EREFSTEN_WIDTH                    1
#define OSC_CR_EREFSTEN(x)                       (((uint8_t)(((uint8_t)(x))<<OSC_CR_EREFSTEN_SHIFT))&OSC_CR_EREFSTEN_MASK)
#define OSC_CR_ERCLKEN_MASK                      0x80u
#define OSC_CR_ERCLKEN_SHIFT                     7
#define OSC_CR_ERCLKEN_WIDTH                     1
#define OSC_CR_ERCLKEN(x)                        (((uint8_t)(((uint8_t)(x))<<OSC_CR_ERCLKEN_SHIFT))&OSC_CR_ERCLKEN_MASK)
/* DIV Bit Fields */
#define OSC_DIV_ERPS_MASK                        0xC0u
#define OSC_DIV_ERPS_SHIFT                       6
#define OSC_DIV_ERPS_WIDTH                       2
#define OSC_DIV_ERPS(x)                          (((uint8_t)(((uint8_t)(x))<<OSC_DIV_ERPS_SHIFT))&OSC_DIV_ERPS_MASK)

/*!
 * @}
 */ /* end of group OSC_Register_Masks */


/* OSC - Peripheral instance base addresses */
/** Peripheral OSC base address */
#define OSC_BASE                                 (0x40065000u)
/** Peripheral OSC base pointer */
#define OSC                                      ((OSC_Type *)OSC_BASE)
#define OSC_BASE_PTR                             (OSC)
/** Array initializer of OSC peripheral base addresses */
#define OSC_BASE_ADDRS                           { OSC_BASE }
/** Array initializer of OSC peripheral base pointers */
#define OSC_BASE_PTRS                            { OSC }

/* ----------------------------------------------------------------------------
   -- OSC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSC_Register_Accessor_Macros OSC - Register accessor macros
 * @{
 */


/* OSC - Register instance definitions */
/* OSC */
#define OSC_CR                                   OSC_CR_REG(OSC)
#define OSC_DIV                                  OSC_DIV_REG(OSC)

/*!
 * @}
 */ /* end of group OSC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group OSC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PIT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Peripheral_Access_Layer PIT Peripheral Access Layer
 * @{
 */

/** PIT - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< PIT Module Control Register, offset: 0x0 */
       uint8_t RESERVED_0[220];
  __I  uint32_t LTMR64H;                           /**< PIT Upper Lifetime Timer Register, offset: 0xE0 */
  __I  uint32_t LTMR64L;                           /**< PIT Lower Lifetime Timer Register, offset: 0xE4 */
       uint8_t RESERVED_1[24];
  struct {                                         /* offset: 0x100, array step: 0x10 */
    __IO uint32_t LDVAL;                             /**< Timer Load Value Register, array offset: 0x100, array step: 0x10 */
    __I  uint32_t CVAL;                              /**< Current Timer Value Register, array offset: 0x104, array step: 0x10 */
    __IO uint32_t TCTRL;                             /**< Timer Control Register, array offset: 0x108, array step: 0x10 */
    __IO uint32_t TFLG;                              /**< Timer Flag Register, array offset: 0x10C, array step: 0x10 */
  } CHANNEL[4];
} PIT_Type, *PIT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PIT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Register_Accessor_Macros PIT - Register accessor macros
 * @{
 */


/* PIT - Register accessors */
#define PIT_MCR_REG(base)                        ((base)->MCR)
#define PIT_LTMR64H_REG(base)                    ((base)->LTMR64H)
#define PIT_LTMR64L_REG(base)                    ((base)->LTMR64L)
#define PIT_LDVAL_REG(base,index)                ((base)->CHANNEL[index].LDVAL)
#define PIT_LDVAL_COUNT                          4
#define PIT_CVAL_REG(base,index)                 ((base)->CHANNEL[index].CVAL)
#define PIT_CVAL_COUNT                           4
#define PIT_TCTRL_REG(base,index)                ((base)->CHANNEL[index].TCTRL)
#define PIT_TCTRL_COUNT                          4
#define PIT_TFLG_REG(base,index)                 ((base)->CHANNEL[index].TFLG)
#define PIT_TFLG_COUNT                           4

/*!
 * @}
 */ /* end of group PIT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PIT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Register_Masks PIT Register Masks
 * @{
 */

/* MCR Bit Fields */
#define PIT_MCR_FRZ_MASK                         0x1u
#define PIT_MCR_FRZ_SHIFT                        0
#define PIT_MCR_FRZ_WIDTH                        1
#define PIT_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x))<<PIT_MCR_FRZ_SHIFT))&PIT_MCR_FRZ_MASK)
#define PIT_MCR_MDIS_MASK                        0x2u
#define PIT_MCR_MDIS_SHIFT                       1
#define PIT_MCR_MDIS_WIDTH                       1
#define PIT_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x))<<PIT_MCR_MDIS_SHIFT))&PIT_MCR_MDIS_MASK)
/* LTMR64H Bit Fields */
#define PIT_LTMR64H_LTH_MASK                     0xFFFFFFFFu
#define PIT_LTMR64H_LTH_SHIFT                    0
#define PIT_LTMR64H_LTH_WIDTH                    32
#define PIT_LTMR64H_LTH(x)                       (((uint32_t)(((uint32_t)(x))<<PIT_LTMR64H_LTH_SHIFT))&PIT_LTMR64H_LTH_MASK)
/* LTMR64L Bit Fields */
#define PIT_LTMR64L_LTL_MASK                     0xFFFFFFFFu
#define PIT_LTMR64L_LTL_SHIFT                    0
#define PIT_LTMR64L_LTL_WIDTH                    32
#define PIT_LTMR64L_LTL(x)                       (((uint32_t)(((uint32_t)(x))<<PIT_LTMR64L_LTL_SHIFT))&PIT_LTMR64L_LTL_MASK)
/* LDVAL Bit Fields */
#define PIT_LDVAL_TSV_MASK                       0xFFFFFFFFu
#define PIT_LDVAL_TSV_SHIFT                      0
#define PIT_LDVAL_TSV_WIDTH                      32
#define PIT_LDVAL_TSV(x)                         (((uint32_t)(((uint32_t)(x))<<PIT_LDVAL_TSV_SHIFT))&PIT_LDVAL_TSV_MASK)
/* CVAL Bit Fields */
#define PIT_CVAL_TVL_MASK                        0xFFFFFFFFu
#define PIT_CVAL_TVL_SHIFT                       0
#define PIT_CVAL_TVL_WIDTH                       32
#define PIT_CVAL_TVL(x)                          (((uint32_t)(((uint32_t)(x))<<PIT_CVAL_TVL_SHIFT))&PIT_CVAL_TVL_MASK)
/* TCTRL Bit Fields */
#define PIT_TCTRL_TEN_MASK                       0x1u
#define PIT_TCTRL_TEN_SHIFT                      0
#define PIT_TCTRL_TEN_WIDTH                      1
#define PIT_TCTRL_TEN(x)                         (((uint32_t)(((uint32_t)(x))<<PIT_TCTRL_TEN_SHIFT))&PIT_TCTRL_TEN_MASK)
#define PIT_TCTRL_TIE_MASK                       0x2u
#define PIT_TCTRL_TIE_SHIFT                      1
#define PIT_TCTRL_TIE_WIDTH                      1
#define PIT_TCTRL_TIE(x)                         (((uint32_t)(((uint32_t)(x))<<PIT_TCTRL_TIE_SHIFT))&PIT_TCTRL_TIE_MASK)
#define PIT_TCTRL_CHN_MASK                       0x4u
#define PIT_TCTRL_CHN_SHIFT                      2
#define PIT_TCTRL_CHN_WIDTH                      1
#define PIT_TCTRL_CHN(x)                         (((uint32_t)(((uint32_t)(x))<<PIT_TCTRL_CHN_SHIFT))&PIT_TCTRL_CHN_MASK)
/* TFLG Bit Fields */
#define PIT_TFLG_TIF_MASK                        0x1u
#define PIT_TFLG_TIF_SHIFT                       0
#define PIT_TFLG_TIF_WIDTH                       1
#define PIT_TFLG_TIF(x)                          (((uint32_t)(((uint32_t)(x))<<PIT_TFLG_TIF_SHIFT))&PIT_TFLG_TIF_MASK)

/*!
 * @}
 */ /* end of group PIT_Register_Masks */


/* PIT - Peripheral instance base addresses */
/** Peripheral PIT0 base address */
#define PIT0_BASE                                (0x40037000u)
/** Peripheral PIT0 base pointer */
#define PIT0                                     ((PIT_Type *)PIT0_BASE)
#define PIT0_BASE_PTR                            (PIT0)
/** Array initializer of PIT peripheral base addresses */
#define PIT_BASE_ADDRS                           { PIT0_BASE }
/** Array initializer of PIT peripheral base pointers */
#define PIT_BASE_PTRS                            { PIT0 }

/* ----------------------------------------------------------------------------
   -- PIT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PIT_Register_Accessor_Macros PIT - Register accessor macros
 * @{
 */


/* PIT - Register instance definitions */
/* PIT0 */
#define PIT0_MCR                                 PIT_MCR_REG(PIT0)
#define PIT0_LTMR64H                             PIT_LTMR64H_REG(PIT0)
#define PIT0_LTMR64L                             PIT_LTMR64L_REG(PIT0)
#define PIT0_LDVAL0                              PIT_LDVAL_REG(PIT0,0)
#define PIT0_CVAL0                               PIT_CVAL_REG(PIT0,0)
#define PIT0_TCTRL0                              PIT_TCTRL_REG(PIT0,0)
#define PIT0_TFLG0                               PIT_TFLG_REG(PIT0,0)
#define PIT0_LDVAL1                              PIT_LDVAL_REG(PIT0,1)
#define PIT0_CVAL1                               PIT_CVAL_REG(PIT0,1)
#define PIT0_TCTRL1                              PIT_TCTRL_REG(PIT0,1)
#define PIT0_TFLG1                               PIT_TFLG_REG(PIT0,1)
#define PIT0_LDVAL2                              PIT_LDVAL_REG(PIT0,2)
#define PIT0_CVAL2                               PIT_CVAL_REG(PIT0,2)
#define PIT0_TCTRL2                              PIT_TCTRL_REG(PIT0,2)
#define PIT0_TFLG2                               PIT_TFLG_REG(PIT0,2)
#define PIT0_LDVAL3                              PIT_LDVAL_REG(PIT0,3)
#define PIT0_CVAL3                               PIT_CVAL_REG(PIT0,3)
#define PIT0_TCTRL3                              PIT_TCTRL_REG(PIT0,3)
#define PIT0_TFLG3                               PIT_TFLG_REG(PIT0,3)

/* PIT - Register array accessors */
#define PIT0_LDVAL(index)                        PIT_LDVAL_REG(PIT0,index)
#define PIT0_CVAL(index)                         PIT_CVAL_REG(PIT0,index)
#define PIT0_TCTRL(index)                        PIT_TCTRL_REG(PIT0,index)
#define PIT0_TFLG(index)                         PIT_TFLG_REG(PIT0,index)

/*!
 * @}
 */ /* end of group PIT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group PIT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Peripheral_Access_Layer PMC Peripheral Access Layer
 * @{
 */

/** PMC - Register Layout Typedef */
typedef struct {
  __IO uint8_t LVDSC1;                             /**< Low Voltage Detect Status And Control 1 register, offset: 0x0 */
  __IO uint8_t LVDSC2;                             /**< Low Voltage Detect Status And Control 2 register, offset: 0x1 */
  __IO uint8_t REGSC;                              /**< Regulator Status And Control register, offset: 0x2 */
       uint8_t RESERVED_0[8];
  __IO uint8_t HVDSC1;                             /**< High Voltage Detect Status And Control 1 register, offset: 0xB */
} PMC_Type, *PMC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Accessor_Macros PMC - Register accessor macros
 * @{
 */


/* PMC - Register accessors */
#define PMC_LVDSC1_REG(base)                     ((base)->LVDSC1)
#define PMC_LVDSC2_REG(base)                     ((base)->LVDSC2)
#define PMC_REGSC_REG(base)                      ((base)->REGSC)
#define PMC_HVDSC1_REG(base)                     ((base)->HVDSC1)

/*!
 * @}
 */ /* end of group PMC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Masks PMC Register Masks
 * @{
 */

/* LVDSC1 Bit Fields */
#define PMC_LVDSC1_LVDV_MASK                     0x3u
#define PMC_LVDSC1_LVDV_SHIFT                    0
#define PMC_LVDSC1_LVDV_WIDTH                    2
#define PMC_LVDSC1_LVDV(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC1_LVDV_SHIFT))&PMC_LVDSC1_LVDV_MASK)
#define PMC_LVDSC1_LVDRE_MASK                    0x10u
#define PMC_LVDSC1_LVDRE_SHIFT                   4
#define PMC_LVDSC1_LVDRE_WIDTH                   1
#define PMC_LVDSC1_LVDRE(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC1_LVDRE_SHIFT))&PMC_LVDSC1_LVDRE_MASK)
#define PMC_LVDSC1_LVDIE_MASK                    0x20u
#define PMC_LVDSC1_LVDIE_SHIFT                   5
#define PMC_LVDSC1_LVDIE_WIDTH                   1
#define PMC_LVDSC1_LVDIE(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC1_LVDIE_SHIFT))&PMC_LVDSC1_LVDIE_MASK)
#define PMC_LVDSC1_LVDACK_MASK                   0x40u
#define PMC_LVDSC1_LVDACK_SHIFT                  6
#define PMC_LVDSC1_LVDACK_WIDTH                  1
#define PMC_LVDSC1_LVDACK(x)                     (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC1_LVDACK_SHIFT))&PMC_LVDSC1_LVDACK_MASK)
#define PMC_LVDSC1_LVDF_MASK                     0x80u
#define PMC_LVDSC1_LVDF_SHIFT                    7
#define PMC_LVDSC1_LVDF_WIDTH                    1
#define PMC_LVDSC1_LVDF(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC1_LVDF_SHIFT))&PMC_LVDSC1_LVDF_MASK)
/* LVDSC2 Bit Fields */
#define PMC_LVDSC2_LVWV_MASK                     0x3u
#define PMC_LVDSC2_LVWV_SHIFT                    0
#define PMC_LVDSC2_LVWV_WIDTH                    2
#define PMC_LVDSC2_LVWV(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC2_LVWV_SHIFT))&PMC_LVDSC2_LVWV_MASK)
#define PMC_LVDSC2_LVWIE_MASK                    0x20u
#define PMC_LVDSC2_LVWIE_SHIFT                   5
#define PMC_LVDSC2_LVWIE_WIDTH                   1
#define PMC_LVDSC2_LVWIE(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC2_LVWIE_SHIFT))&PMC_LVDSC2_LVWIE_MASK)
#define PMC_LVDSC2_LVWACK_MASK                   0x40u
#define PMC_LVDSC2_LVWACK_SHIFT                  6
#define PMC_LVDSC2_LVWACK_WIDTH                  1
#define PMC_LVDSC2_LVWACK(x)                     (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC2_LVWACK_SHIFT))&PMC_LVDSC2_LVWACK_MASK)
#define PMC_LVDSC2_LVWF_MASK                     0x80u
#define PMC_LVDSC2_LVWF_SHIFT                    7
#define PMC_LVDSC2_LVWF_WIDTH                    1
#define PMC_LVDSC2_LVWF(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_LVDSC2_LVWF_SHIFT))&PMC_LVDSC2_LVWF_MASK)
/* REGSC Bit Fields */
#define PMC_REGSC_BGBE_MASK                      0x1u
#define PMC_REGSC_BGBE_SHIFT                     0
#define PMC_REGSC_BGBE_WIDTH                     1
#define PMC_REGSC_BGBE(x)                        (((uint8_t)(((uint8_t)(x))<<PMC_REGSC_BGBE_SHIFT))&PMC_REGSC_BGBE_MASK)
#define PMC_REGSC_REGONS_MASK                    0x4u
#define PMC_REGSC_REGONS_SHIFT                   2
#define PMC_REGSC_REGONS_WIDTH                   1
#define PMC_REGSC_REGONS(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_REGSC_REGONS_SHIFT))&PMC_REGSC_REGONS_MASK)
#define PMC_REGSC_ACKISO_MASK                    0x8u
#define PMC_REGSC_ACKISO_SHIFT                   3
#define PMC_REGSC_ACKISO_WIDTH                   1
#define PMC_REGSC_ACKISO(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_REGSC_ACKISO_SHIFT))&PMC_REGSC_ACKISO_MASK)
#define PMC_REGSC_BGEN_MASK                      0x10u
#define PMC_REGSC_BGEN_SHIFT                     4
#define PMC_REGSC_BGEN_WIDTH                     1
#define PMC_REGSC_BGEN(x)                        (((uint8_t)(((uint8_t)(x))<<PMC_REGSC_BGEN_SHIFT))&PMC_REGSC_BGEN_MASK)
#define PMC_REGSC_VLPO_MASK                      0x40u
#define PMC_REGSC_VLPO_SHIFT                     6
#define PMC_REGSC_VLPO_WIDTH                     1
#define PMC_REGSC_VLPO(x)                        (((uint8_t)(((uint8_t)(x))<<PMC_REGSC_VLPO_SHIFT))&PMC_REGSC_VLPO_MASK)
/* HVDSC1 Bit Fields */
#define PMC_HVDSC1_HVDV_MASK                     0x1u
#define PMC_HVDSC1_HVDV_SHIFT                    0
#define PMC_HVDSC1_HVDV_WIDTH                    1
#define PMC_HVDSC1_HVDV(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_HVDSC1_HVDV_SHIFT))&PMC_HVDSC1_HVDV_MASK)
#define PMC_HVDSC1_HVDRE_MASK                    0x10u
#define PMC_HVDSC1_HVDRE_SHIFT                   4
#define PMC_HVDSC1_HVDRE_WIDTH                   1
#define PMC_HVDSC1_HVDRE(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_HVDSC1_HVDRE_SHIFT))&PMC_HVDSC1_HVDRE_MASK)
#define PMC_HVDSC1_HVDIE_MASK                    0x20u
#define PMC_HVDSC1_HVDIE_SHIFT                   5
#define PMC_HVDSC1_HVDIE_WIDTH                   1
#define PMC_HVDSC1_HVDIE(x)                      (((uint8_t)(((uint8_t)(x))<<PMC_HVDSC1_HVDIE_SHIFT))&PMC_HVDSC1_HVDIE_MASK)
#define PMC_HVDSC1_HVDACK_MASK                   0x40u
#define PMC_HVDSC1_HVDACK_SHIFT                  6
#define PMC_HVDSC1_HVDACK_WIDTH                  1
#define PMC_HVDSC1_HVDACK(x)                     (((uint8_t)(((uint8_t)(x))<<PMC_HVDSC1_HVDACK_SHIFT))&PMC_HVDSC1_HVDACK_MASK)
#define PMC_HVDSC1_HVDF_MASK                     0x80u
#define PMC_HVDSC1_HVDF_SHIFT                    7
#define PMC_HVDSC1_HVDF_WIDTH                    1
#define PMC_HVDSC1_HVDF(x)                       (((uint8_t)(((uint8_t)(x))<<PMC_HVDSC1_HVDF_SHIFT))&PMC_HVDSC1_HVDF_MASK)

/*!
 * @}
 */ /* end of group PMC_Register_Masks */


/* PMC - Peripheral instance base addresses */
/** Peripheral PMC base address */
#define PMC_BASE                                 (0x4007D000u)
/** Peripheral PMC base pointer */
#define PMC                                      ((PMC_Type *)PMC_BASE)
#define PMC_BASE_PTR                             (PMC)
/** Array initializer of PMC peripheral base addresses */
#define PMC_BASE_ADDRS                           { PMC_BASE }
/** Array initializer of PMC peripheral base pointers */
#define PMC_BASE_PTRS                            { PMC }

/* ----------------------------------------------------------------------------
   -- PMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PMC_Register_Accessor_Macros PMC - Register accessor macros
 * @{
 */


/* PMC - Register instance definitions */
/* PMC */
#define PMC_LVDSC1                               PMC_LVDSC1_REG(PMC)
#define PMC_LVDSC2                               PMC_LVDSC2_REG(PMC)
#define PMC_REGSC                                PMC_REGSC_REG(PMC)
#define PMC_HVDSC1                               PMC_HVDSC1_REG(PMC)

/*!
 * @}
 */ /* end of group PMC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group PMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PORT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Peripheral_Access_Layer PORT Peripheral Access Layer
 * @{
 */

/** PORT - Register Layout Typedef */
typedef struct {
  __IO uint32_t PCR[32];                           /**< Pin Control Register n, array offset: 0x0, array step: 0x4 */
  __O  uint32_t GPCLR;                             /**< Global Pin Control Low Register, offset: 0x80 */
  __O  uint32_t GPCHR;                             /**< Global Pin Control High Register, offset: 0x84 */
  __O  uint32_t GICLR;                             /**< Global Interrupt Control Low Register, offset: 0x88 */
  __O  uint32_t GICHR;                             /**< Global Interrupt Control High Register, offset: 0x8C */
       uint8_t RESERVED_0[16];
  __IO uint32_t ISFR;                              /**< Interrupt Status Flag Register, offset: 0xA0 */
} PORT_Type, *PORT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- PORT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Register_Accessor_Macros PORT - Register accessor macros
 * @{
 */


/* PORT - Register accessors */
#define PORT_PCR_REG(base,index)                 ((base)->PCR[index])
#define PORT_PCR_COUNT                           32
#define PORT_GPCLR_REG(base)                     ((base)->GPCLR)
#define PORT_GPCHR_REG(base)                     ((base)->GPCHR)
#define PORT_GICLR_REG(base)                     ((base)->GICLR)
#define PORT_GICHR_REG(base)                     ((base)->GICHR)
#define PORT_ISFR_REG(base)                      ((base)->ISFR)

/*!
 * @}
 */ /* end of group PORT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- PORT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Register_Masks PORT Register Masks
 * @{
 */

/* PCR Bit Fields */
#define PORT_PCR_PS_MASK                         0x1u
#define PORT_PCR_PS_SHIFT                        0
#define PORT_PCR_PS_WIDTH                        1
#define PORT_PCR_PS(x)                           (((uint32_t)(((uint32_t)(x))<<PORT_PCR_PS_SHIFT))&PORT_PCR_PS_MASK)
#define PORT_PCR_PE_MASK                         0x2u
#define PORT_PCR_PE_SHIFT                        1
#define PORT_PCR_PE_WIDTH                        1
#define PORT_PCR_PE(x)                           (((uint32_t)(((uint32_t)(x))<<PORT_PCR_PE_SHIFT))&PORT_PCR_PE_MASK)
#define PORT_PCR_SRE_MASK                        0x4u
#define PORT_PCR_SRE_SHIFT                       2
#define PORT_PCR_SRE_WIDTH                       1
#define PORT_PCR_SRE(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_SRE_SHIFT))&PORT_PCR_SRE_MASK)
#define PORT_PCR_PFE_MASK                        0x10u
#define PORT_PCR_PFE_SHIFT                       4
#define PORT_PCR_PFE_WIDTH                       1
#define PORT_PCR_PFE(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_PFE_SHIFT))&PORT_PCR_PFE_MASK)
#define PORT_PCR_ODE_MASK                        0x20u
#define PORT_PCR_ODE_SHIFT                       5
#define PORT_PCR_ODE_WIDTH                       1
#define PORT_PCR_ODE(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_ODE_SHIFT))&PORT_PCR_ODE_MASK)
#define PORT_PCR_MUX_MASK                        0x700u
#define PORT_PCR_MUX_SHIFT                       8
#define PORT_PCR_MUX_WIDTH                       3
#define PORT_PCR_MUX(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_MUX_SHIFT))&PORT_PCR_MUX_MASK)
#define PORT_PCR_LK_MASK                         0x8000u
#define PORT_PCR_LK_SHIFT                        15
#define PORT_PCR_LK_WIDTH                        1
#define PORT_PCR_LK(x)                           (((uint32_t)(((uint32_t)(x))<<PORT_PCR_LK_SHIFT))&PORT_PCR_LK_MASK)
#define PORT_PCR_IRQC_MASK                       0xF0000u
#define PORT_PCR_IRQC_SHIFT                      16
#define PORT_PCR_IRQC_WIDTH                      4
#define PORT_PCR_IRQC(x)                         (((uint32_t)(((uint32_t)(x))<<PORT_PCR_IRQC_SHIFT))&PORT_PCR_IRQC_MASK)
#define PORT_PCR_ISF_MASK                        0x1000000u
#define PORT_PCR_ISF_SHIFT                       24
#define PORT_PCR_ISF_WIDTH                       1
#define PORT_PCR_ISF(x)                          (((uint32_t)(((uint32_t)(x))<<PORT_PCR_ISF_SHIFT))&PORT_PCR_ISF_MASK)
/* GPCLR Bit Fields */
#define PORT_GPCLR_GPWD_MASK                     0xFFFFu
#define PORT_GPCLR_GPWD_SHIFT                    0
#define PORT_GPCLR_GPWD_WIDTH                    16
#define PORT_GPCLR_GPWD(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GPCLR_GPWD_SHIFT))&PORT_GPCLR_GPWD_MASK)
#define PORT_GPCLR_GPWE_MASK                     0xFFFF0000u
#define PORT_GPCLR_GPWE_SHIFT                    16
#define PORT_GPCLR_GPWE_WIDTH                    16
#define PORT_GPCLR_GPWE(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GPCLR_GPWE_SHIFT))&PORT_GPCLR_GPWE_MASK)
/* GPCHR Bit Fields */
#define PORT_GPCHR_GPWD_MASK                     0xFFFFu
#define PORT_GPCHR_GPWD_SHIFT                    0
#define PORT_GPCHR_GPWD_WIDTH                    16
#define PORT_GPCHR_GPWD(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GPCHR_GPWD_SHIFT))&PORT_GPCHR_GPWD_MASK)
#define PORT_GPCHR_GPWE_MASK                     0xFFFF0000u
#define PORT_GPCHR_GPWE_SHIFT                    16
#define PORT_GPCHR_GPWE_WIDTH                    16
#define PORT_GPCHR_GPWE(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GPCHR_GPWE_SHIFT))&PORT_GPCHR_GPWE_MASK)
/* GICLR Bit Fields */
#define PORT_GICLR_GIWE_MASK                     0xFFFFu
#define PORT_GICLR_GIWE_SHIFT                    0
#define PORT_GICLR_GIWE_WIDTH                    16
#define PORT_GICLR_GIWE(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GICLR_GIWE_SHIFT))&PORT_GICLR_GIWE_MASK)
#define PORT_GICLR_GIWD_MASK                     0xFFFF0000u
#define PORT_GICLR_GIWD_SHIFT                    16
#define PORT_GICLR_GIWD_WIDTH                    16
#define PORT_GICLR_GIWD(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GICLR_GIWD_SHIFT))&PORT_GICLR_GIWD_MASK)
/* GICHR Bit Fields */
#define PORT_GICHR_GIWE_MASK                     0xFFFFu
#define PORT_GICHR_GIWE_SHIFT                    0
#define PORT_GICHR_GIWE_WIDTH                    16
#define PORT_GICHR_GIWE(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GICHR_GIWE_SHIFT))&PORT_GICHR_GIWE_MASK)
#define PORT_GICHR_GIWD_MASK                     0xFFFF0000u
#define PORT_GICHR_GIWD_SHIFT                    16
#define PORT_GICHR_GIWD_WIDTH                    16
#define PORT_GICHR_GIWD(x)                       (((uint32_t)(((uint32_t)(x))<<PORT_GICHR_GIWD_SHIFT))&PORT_GICHR_GIWD_MASK)
/* ISFR Bit Fields */
#define PORT_ISFR_ISF_MASK                       0xFFFFFFFFu
#define PORT_ISFR_ISF_SHIFT                      0
#define PORT_ISFR_ISF_WIDTH                      32
#define PORT_ISFR_ISF(x)                         (((uint32_t)(((uint32_t)(x))<<PORT_ISFR_ISF_SHIFT))&PORT_ISFR_ISF_MASK)

/*!
 * @}
 */ /* end of group PORT_Register_Masks */


/* PORT - Peripheral instance base addresses */
/** Peripheral PORTA base address */
#define PORTA_BASE                               (0x40049000u)
/** Peripheral PORTA base pointer */
#define PORTA                                    ((PORT_Type *)PORTA_BASE)
#define PORTA_BASE_PTR                           (PORTA)
/** Peripheral PORTB base address */
#define PORTB_BASE                               (0x4004A000u)
/** Peripheral PORTB base pointer */
#define PORTB                                    ((PORT_Type *)PORTB_BASE)
#define PORTB_BASE_PTR                           (PORTB)
/** Peripheral PORTC base address */
#define PORTC_BASE                               (0x4004B000u)
/** Peripheral PORTC base pointer */
#define PORTC                                    ((PORT_Type *)PORTC_BASE)
#define PORTC_BASE_PTR                           (PORTC)
/** Peripheral PORTD base address */
#define PORTD_BASE                               (0x4004C000u)
/** Peripheral PORTD base pointer */
#define PORTD                                    ((PORT_Type *)PORTD_BASE)
#define PORTD_BASE_PTR                           (PORTD)
/** Peripheral PORTE base address */
#define PORTE_BASE                               (0x4004D000u)
/** Peripheral PORTE base pointer */
#define PORTE                                    ((PORT_Type *)PORTE_BASE)
#define PORTE_BASE_PTR                           (PORTE)
/** Array initializer of PORT peripheral base addresses */
#define PORT_BASE_ADDRS                          { PORTA_BASE, PORTB_BASE, PORTC_BASE, PORTD_BASE, PORTE_BASE }
/** Array initializer of PORT peripheral base pointers */
#define PORT_BASE_PTRS                           { PORTA, PORTB, PORTC, PORTD, PORTE }

/* ----------------------------------------------------------------------------
   -- PORT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PORT_Register_Accessor_Macros PORT - Register accessor macros
 * @{
 */


/* PORT - Register instance definitions */
/* PORTA */
#define PORTA_PCR0                               PORT_PCR_REG(PORTA,0)
#define PORTA_PCR1                               PORT_PCR_REG(PORTA,1)
#define PORTA_PCR2                               PORT_PCR_REG(PORTA,2)
#define PORTA_PCR3                               PORT_PCR_REG(PORTA,3)
#define PORTA_PCR4                               PORT_PCR_REG(PORTA,4)
#define PORTA_PCR5                               PORT_PCR_REG(PORTA,5)
#define PORTA_PCR6                               PORT_PCR_REG(PORTA,6)
#define PORTA_PCR7                               PORT_PCR_REG(PORTA,7)
#define PORTA_PCR8                               PORT_PCR_REG(PORTA,8)
#define PORTA_PCR9                               PORT_PCR_REG(PORTA,9)
#define PORTA_PCR10                              PORT_PCR_REG(PORTA,10)
#define PORTA_PCR11                              PORT_PCR_REG(PORTA,11)
#define PORTA_PCR12                              PORT_PCR_REG(PORTA,12)
#define PORTA_PCR13                              PORT_PCR_REG(PORTA,13)
#define PORTA_PCR14                              PORT_PCR_REG(PORTA,14)
#define PORTA_PCR15                              PORT_PCR_REG(PORTA,15)
#define PORTA_PCR16                              PORT_PCR_REG(PORTA,16)
#define PORTA_PCR17                              PORT_PCR_REG(PORTA,17)
#define PORTA_PCR18                              PORT_PCR_REG(PORTA,18)
#define PORTA_PCR19                              PORT_PCR_REG(PORTA,19)
#define PORTA_PCR20                              PORT_PCR_REG(PORTA,20)
#define PORTA_PCR21                              PORT_PCR_REG(PORTA,21)
#define PORTA_PCR22                              PORT_PCR_REG(PORTA,22)
#define PORTA_PCR23                              PORT_PCR_REG(PORTA,23)
#define PORTA_PCR24                              PORT_PCR_REG(PORTA,24)
#define PORTA_PCR25                              PORT_PCR_REG(PORTA,25)
#define PORTA_PCR26                              PORT_PCR_REG(PORTA,26)
#define PORTA_PCR27                              PORT_PCR_REG(PORTA,27)
#define PORTA_PCR28                              PORT_PCR_REG(PORTA,28)
#define PORTA_PCR29                              PORT_PCR_REG(PORTA,29)
#define PORTA_PCR30                              PORT_PCR_REG(PORTA,30)
#define PORTA_PCR31                              PORT_PCR_REG(PORTA,31)
#define PORTA_GPCLR                              PORT_GPCLR_REG(PORTA)
#define PORTA_GPCHR                              PORT_GPCHR_REG(PORTA)
#define PORTA_GICLR                              PORT_GICLR_REG(PORTA)
#define PORTA_GICHR                              PORT_GICHR_REG(PORTA)
#define PORTA_ISFR                               PORT_ISFR_REG(PORTA)
/* PORTB */
#define PORTB_PCR0                               PORT_PCR_REG(PORTB,0)
#define PORTB_PCR1                               PORT_PCR_REG(PORTB,1)
#define PORTB_PCR2                               PORT_PCR_REG(PORTB,2)
#define PORTB_PCR3                               PORT_PCR_REG(PORTB,3)
#define PORTB_PCR4                               PORT_PCR_REG(PORTB,4)
#define PORTB_PCR5                               PORT_PCR_REG(PORTB,5)
#define PORTB_PCR6                               PORT_PCR_REG(PORTB,6)
#define PORTB_PCR7                               PORT_PCR_REG(PORTB,7)
#define PORTB_PCR8                               PORT_PCR_REG(PORTB,8)
#define PORTB_PCR9                               PORT_PCR_REG(PORTB,9)
#define PORTB_PCR10                              PORT_PCR_REG(PORTB,10)
#define PORTB_PCR11                              PORT_PCR_REG(PORTB,11)
#define PORTB_PCR12                              PORT_PCR_REG(PORTB,12)
#define PORTB_PCR13                              PORT_PCR_REG(PORTB,13)
#define PORTB_PCR14                              PORT_PCR_REG(PORTB,14)
#define PORTB_PCR15                              PORT_PCR_REG(PORTB,15)
#define PORTB_PCR16                              PORT_PCR_REG(PORTB,16)
#define PORTB_PCR17                              PORT_PCR_REG(PORTB,17)
#define PORTB_PCR18                              PORT_PCR_REG(PORTB,18)
#define PORTB_PCR19                              PORT_PCR_REG(PORTB,19)
#define PORTB_PCR20                              PORT_PCR_REG(PORTB,20)
#define PORTB_PCR21                              PORT_PCR_REG(PORTB,21)
#define PORTB_PCR22                              PORT_PCR_REG(PORTB,22)
#define PORTB_PCR23                              PORT_PCR_REG(PORTB,23)
#define PORTB_PCR24                              PORT_PCR_REG(PORTB,24)
#define PORTB_PCR25                              PORT_PCR_REG(PORTB,25)
#define PORTB_PCR26                              PORT_PCR_REG(PORTB,26)
#define PORTB_PCR27                              PORT_PCR_REG(PORTB,27)
#define PORTB_PCR28                              PORT_PCR_REG(PORTB,28)
#define PORTB_PCR29                              PORT_PCR_REG(PORTB,29)
#define PORTB_PCR30                              PORT_PCR_REG(PORTB,30)
#define PORTB_PCR31                              PORT_PCR_REG(PORTB,31)
#define PORTB_GPCLR                              PORT_GPCLR_REG(PORTB)
#define PORTB_GPCHR                              PORT_GPCHR_REG(PORTB)
#define PORTB_GICLR                              PORT_GICLR_REG(PORTB)
#define PORTB_GICHR                              PORT_GICHR_REG(PORTB)
#define PORTB_ISFR                               PORT_ISFR_REG(PORTB)
/* PORTC */
#define PORTC_PCR0                               PORT_PCR_REG(PORTC,0)
#define PORTC_PCR1                               PORT_PCR_REG(PORTC,1)
#define PORTC_PCR2                               PORT_PCR_REG(PORTC,2)
#define PORTC_PCR3                               PORT_PCR_REG(PORTC,3)
#define PORTC_PCR4                               PORT_PCR_REG(PORTC,4)
#define PORTC_PCR5                               PORT_PCR_REG(PORTC,5)
#define PORTC_PCR6                               PORT_PCR_REG(PORTC,6)
#define PORTC_PCR7                               PORT_PCR_REG(PORTC,7)
#define PORTC_PCR8                               PORT_PCR_REG(PORTC,8)
#define PORTC_PCR9                               PORT_PCR_REG(PORTC,9)
#define PORTC_PCR10                              PORT_PCR_REG(PORTC,10)
#define PORTC_PCR11                              PORT_PCR_REG(PORTC,11)
#define PORTC_PCR12                              PORT_PCR_REG(PORTC,12)
#define PORTC_PCR13                              PORT_PCR_REG(PORTC,13)
#define PORTC_PCR14                              PORT_PCR_REG(PORTC,14)
#define PORTC_PCR15                              PORT_PCR_REG(PORTC,15)
#define PORTC_PCR16                              PORT_PCR_REG(PORTC,16)
#define PORTC_PCR17                              PORT_PCR_REG(PORTC,17)
#define PORTC_PCR18                              PORT_PCR_REG(PORTC,18)
#define PORTC_PCR19                              PORT_PCR_REG(PORTC,19)
#define PORTC_PCR20                              PORT_PCR_REG(PORTC,20)
#define PORTC_PCR21                              PORT_PCR_REG(PORTC,21)
#define PORTC_PCR22                              PORT_PCR_REG(PORTC,22)
#define PORTC_PCR23                              PORT_PCR_REG(PORTC,23)
#define PORTC_PCR24                              PORT_PCR_REG(PORTC,24)
#define PORTC_PCR25                              PORT_PCR_REG(PORTC,25)
#define PORTC_PCR26                              PORT_PCR_REG(PORTC,26)
#define PORTC_PCR27                              PORT_PCR_REG(PORTC,27)
#define PORTC_PCR28                              PORT_PCR_REG(PORTC,28)
#define PORTC_PCR29                              PORT_PCR_REG(PORTC,29)
#define PORTC_PCR30                              PORT_PCR_REG(PORTC,30)
#define PORTC_PCR31                              PORT_PCR_REG(PORTC,31)
#define PORTC_GPCLR                              PORT_GPCLR_REG(PORTC)
#define PORTC_GPCHR                              PORT_GPCHR_REG(PORTC)
#define PORTC_GICLR                              PORT_GICLR_REG(PORTC)
#define PORTC_GICHR                              PORT_GICHR_REG(PORTC)
#define PORTC_ISFR                               PORT_ISFR_REG(PORTC)
/* PORTD */
#define PORTD_PCR0                               PORT_PCR_REG(PORTD,0)
#define PORTD_PCR1                               PORT_PCR_REG(PORTD,1)
#define PORTD_PCR2                               PORT_PCR_REG(PORTD,2)
#define PORTD_PCR3                               PORT_PCR_REG(PORTD,3)
#define PORTD_PCR4                               PORT_PCR_REG(PORTD,4)
#define PORTD_PCR5                               PORT_PCR_REG(PORTD,5)
#define PORTD_PCR6                               PORT_PCR_REG(PORTD,6)
#define PORTD_PCR7                               PORT_PCR_REG(PORTD,7)
#define PORTD_PCR8                               PORT_PCR_REG(PORTD,8)
#define PORTD_PCR9                               PORT_PCR_REG(PORTD,9)
#define PORTD_PCR10                              PORT_PCR_REG(PORTD,10)
#define PORTD_PCR11                              PORT_PCR_REG(PORTD,11)
#define PORTD_PCR12                              PORT_PCR_REG(PORTD,12)
#define PORTD_PCR13                              PORT_PCR_REG(PORTD,13)
#define PORTD_PCR14                              PORT_PCR_REG(PORTD,14)
#define PORTD_PCR15                              PORT_PCR_REG(PORTD,15)
#define PORTD_PCR16                              PORT_PCR_REG(PORTD,16)
#define PORTD_PCR17                              PORT_PCR_REG(PORTD,17)
#define PORTD_PCR18                              PORT_PCR_REG(PORTD,18)
#define PORTD_PCR19                              PORT_PCR_REG(PORTD,19)
#define PORTD_PCR20                              PORT_PCR_REG(PORTD,20)
#define PORTD_PCR21                              PORT_PCR_REG(PORTD,21)
#define PORTD_PCR22                              PORT_PCR_REG(PORTD,22)
#define PORTD_PCR23                              PORT_PCR_REG(PORTD,23)
#define PORTD_PCR24                              PORT_PCR_REG(PORTD,24)
#define PORTD_PCR25                              PORT_PCR_REG(PORTD,25)
#define PORTD_PCR26                              PORT_PCR_REG(PORTD,26)
#define PORTD_PCR27                              PORT_PCR_REG(PORTD,27)
#define PORTD_PCR28                              PORT_PCR_REG(PORTD,28)
#define PORTD_PCR29                              PORT_PCR_REG(PORTD,29)
#define PORTD_PCR30                              PORT_PCR_REG(PORTD,30)
#define PORTD_PCR31                              PORT_PCR_REG(PORTD,31)
#define PORTD_GPCLR                              PORT_GPCLR_REG(PORTD)
#define PORTD_GPCHR                              PORT_GPCHR_REG(PORTD)
#define PORTD_GICLR                              PORT_GICLR_REG(PORTD)
#define PORTD_GICHR                              PORT_GICHR_REG(PORTD)
#define PORTD_ISFR                               PORT_ISFR_REG(PORTD)
/* PORTE */
#define PORTE_PCR0                               PORT_PCR_REG(PORTE,0)
#define PORTE_PCR1                               PORT_PCR_REG(PORTE,1)
#define PORTE_PCR2                               PORT_PCR_REG(PORTE,2)
#define PORTE_PCR3                               PORT_PCR_REG(PORTE,3)
#define PORTE_PCR4                               PORT_PCR_REG(PORTE,4)
#define PORTE_PCR5                               PORT_PCR_REG(PORTE,5)
#define PORTE_PCR6                               PORT_PCR_REG(PORTE,6)
#define PORTE_PCR7                               PORT_PCR_REG(PORTE,7)
#define PORTE_PCR8                               PORT_PCR_REG(PORTE,8)
#define PORTE_PCR9                               PORT_PCR_REG(PORTE,9)
#define PORTE_PCR10                              PORT_PCR_REG(PORTE,10)
#define PORTE_PCR11                              PORT_PCR_REG(PORTE,11)
#define PORTE_PCR12                              PORT_PCR_REG(PORTE,12)
#define PORTE_PCR13                              PORT_PCR_REG(PORTE,13)
#define PORTE_PCR14                              PORT_PCR_REG(PORTE,14)
#define PORTE_PCR15                              PORT_PCR_REG(PORTE,15)
#define PORTE_PCR16                              PORT_PCR_REG(PORTE,16)
#define PORTE_PCR17                              PORT_PCR_REG(PORTE,17)
#define PORTE_PCR18                              PORT_PCR_REG(PORTE,18)
#define PORTE_PCR19                              PORT_PCR_REG(PORTE,19)
#define PORTE_PCR20                              PORT_PCR_REG(PORTE,20)
#define PORTE_PCR21                              PORT_PCR_REG(PORTE,21)
#define PORTE_PCR22                              PORT_PCR_REG(PORTE,22)
#define PORTE_PCR23                              PORT_PCR_REG(PORTE,23)
#define PORTE_PCR24                              PORT_PCR_REG(PORTE,24)
#define PORTE_PCR25                              PORT_PCR_REG(PORTE,25)
#define PORTE_PCR26                              PORT_PCR_REG(PORTE,26)
#define PORTE_PCR27                              PORT_PCR_REG(PORTE,27)
#define PORTE_PCR28                              PORT_PCR_REG(PORTE,28)
#define PORTE_PCR29                              PORT_PCR_REG(PORTE,29)
#define PORTE_PCR30                              PORT_PCR_REG(PORTE,30)
#define PORTE_PCR31                              PORT_PCR_REG(PORTE,31)
#define PORTE_GPCLR                              PORT_GPCLR_REG(PORTE)
#define PORTE_GPCHR                              PORT_GPCHR_REG(PORTE)
#define PORTE_GICLR                              PORT_GICLR_REG(PORTE)
#define PORTE_GICHR                              PORT_GICHR_REG(PORTE)
#define PORTE_ISFR                               PORT_ISFR_REG(PORTE)

/* PORT - Register array accessors */
#define PORTA_PCR(index)                         PORT_PCR_REG(PORTA,index)
#define PORTB_PCR(index)                         PORT_PCR_REG(PORTB,index)
#define PORTC_PCR(index)                         PORT_PCR_REG(PORTC,index)
#define PORTD_PCR(index)                         PORT_PCR_REG(PORTD,index)
#define PORTE_PCR(index)                         PORT_PCR_REG(PORTE,index)

/*!
 * @}
 */ /* end of group PORT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group PORT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- QuadSPI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup QuadSPI_Peripheral_Access_Layer QuadSPI Peripheral Access Layer
 * @{
 */

/** QuadSPI - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration Register, offset: 0x0 */
       uint8_t RESERVED_0[4];
  __IO uint32_t IPCR;                              /**< IP Configuration Register, offset: 0x8 */
  __IO uint32_t FLSHCR;                            /**< Flash Configuration Register, offset: 0xC */
  __IO uint32_t BUF0CR;                            /**< Buffer0 Configuration Register, offset: 0x10 */
  __IO uint32_t BUF1CR;                            /**< Buffer1 Configuration Register, offset: 0x14 */
  __IO uint32_t BUF2CR;                            /**< Buffer2 Configuration Register, offset: 0x18 */
  __IO uint32_t BUF3CR;                            /**< Buffer3 Configuration Register, offset: 0x1C */
  __IO uint32_t BFGENCR;                           /**< Buffer Generic Configuration Register, offset: 0x20 */
  __IO uint32_t SOCCR;                             /**< SOC Configuration Register, offset: 0x24 */
       uint8_t RESERVED_1[8];
  __IO uint32_t BUF0IND;                           /**< Buffer0 Top Index Register, offset: 0x30 */
  __IO uint32_t BUF1IND;                           /**< Buffer1 Top Index Register, offset: 0x34 */
  __IO uint32_t BUF2IND;                           /**< Buffer2 Top Index Register, offset: 0x38 */
       uint8_t RESERVED_2[196];
  __IO uint32_t SFAR;                              /**< Serial Flash Address Register, offset: 0x100 */
  __IO uint32_t SFACR;                             /**< Serial Flash Address Configuration Register, offset: 0x104 */
  __IO uint32_t SMPR;                              /**< Sampling Register, offset: 0x108 */
  __I  uint32_t RBSR;                              /**< RX Buffer Status Register, offset: 0x10C */
  __IO uint32_t RBCT;                              /**< RX Buffer Control Register, offset: 0x110 */
       uint8_t RESERVED_3[60];
  __I  uint32_t TBSR;                              /**< TX Buffer Status Register, offset: 0x150 */
  __IO uint32_t TBDR;                              /**< TX Buffer Data Register, offset: 0x154 */
  __IO uint32_t TBCT;                              /**< Tx Buffer Control Register, offset: 0x158 */
  __I  uint32_t SR;                                /**< Status Register, offset: 0x15C */
  __IO uint32_t FR;                                /**< Flag Register, offset: 0x160 */
  __IO uint32_t RSER;                              /**< Interrupt and DMA Request Select and Enable Register, offset: 0x164 */
  __I  uint32_t SPNDST;                            /**< Sequence Suspend Status Register, offset: 0x168 */
  __IO uint32_t SPTRCLR;                           /**< Sequence Pointer Clear Register, offset: 0x16C */
       uint8_t RESERVED_4[16];
  __IO uint32_t SFA1AD;                            /**< Serial Flash A1 Top Address, offset: 0x180 */
  __IO uint32_t SFA2AD;                            /**< Serial Flash A2 Top Address, offset: 0x184 */
  __IO uint32_t SFB1AD;                            /**< Serial Flash B1Top Address, offset: 0x188 */
  __IO uint32_t SFB2AD;                            /**< Serial Flash B2Top Address, offset: 0x18C */
  __IO uint32_t DLPR;                              /**< Data Learn Pattern Register, offset: 0x190 */
       uint8_t RESERVED_5[108];
  __I  uint32_t RBDR[16];                          /**< RX Buffer Data Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_6[192];
  __IO uint32_t LUTKEY;                            /**< LUT Key Register, offset: 0x300 */
  __IO uint32_t LCKCR;                             /**< LUT Lock Configuration Register, offset: 0x304 */
       uint8_t RESERVED_7[8];
  __IO uint32_t LUT[64];                           /**< Look-up Table register, array offset: 0x310, array step: 0x4 */
} QuadSPI_Type, *QuadSPI_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- QuadSPI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup QuadSPI_Register_Accessor_Macros QuadSPI - Register accessor macros
 * @{
 */


/* QuadSPI - Register accessors */
#define QuadSPI_MCR_REG(base)                    ((base)->MCR)
#define QuadSPI_IPCR_REG(base)                   ((base)->IPCR)
#define QuadSPI_FLSHCR_REG(base)                 ((base)->FLSHCR)
#define QuadSPI_BUF0CR_REG(base)                 ((base)->BUF0CR)
#define QuadSPI_BUF1CR_REG(base)                 ((base)->BUF1CR)
#define QuadSPI_BUF2CR_REG(base)                 ((base)->BUF2CR)
#define QuadSPI_BUF3CR_REG(base)                 ((base)->BUF3CR)
#define QuadSPI_BFGENCR_REG(base)                ((base)->BFGENCR)
#define QuadSPI_SOCCR_REG(base)                  ((base)->SOCCR)
#define QuadSPI_BUF0IND_REG(base)                ((base)->BUF0IND)
#define QuadSPI_BUF1IND_REG(base)                ((base)->BUF1IND)
#define QuadSPI_BUF2IND_REG(base)                ((base)->BUF2IND)
#define QuadSPI_SFAR_REG(base)                   ((base)->SFAR)
#define QuadSPI_SFACR_REG(base)                  ((base)->SFACR)
#define QuadSPI_SMPR_REG(base)                   ((base)->SMPR)
#define QuadSPI_RBSR_REG(base)                   ((base)->RBSR)
#define QuadSPI_RBCT_REG(base)                   ((base)->RBCT)
#define QuadSPI_TBSR_REG(base)                   ((base)->TBSR)
#define QuadSPI_TBDR_REG(base)                   ((base)->TBDR)
#define QuadSPI_TBCT_REG(base)                   ((base)->TBCT)
#define QuadSPI_SR_REG(base)                     ((base)->SR)
#define QuadSPI_FR_REG(base)                     ((base)->FR)
#define QuadSPI_RSER_REG(base)                   ((base)->RSER)
#define QuadSPI_SPNDST_REG(base)                 ((base)->SPNDST)
#define QuadSPI_SPTRCLR_REG(base)                ((base)->SPTRCLR)
#define QuadSPI_SFA1AD_REG(base)                 ((base)->SFA1AD)
#define QuadSPI_SFA2AD_REG(base)                 ((base)->SFA2AD)
#define QuadSPI_SFB1AD_REG(base)                 ((base)->SFB1AD)
#define QuadSPI_SFB2AD_REG(base)                 ((base)->SFB2AD)
#define QuadSPI_DLPR_REG(base)                   ((base)->DLPR)
#define QuadSPI_RBDR_REG(base,index)             ((base)->RBDR[index])
#define QuadSPI_RBDR_COUNT                       16
#define QuadSPI_LUTKEY_REG(base)                 ((base)->LUTKEY)
#define QuadSPI_LCKCR_REG(base)                  ((base)->LCKCR)
#define QuadSPI_LUT_REG(base,index)              ((base)->LUT[index])
#define QuadSPI_LUT_COUNT                        64

/*!
 * @}
 */ /* end of group QuadSPI_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- QuadSPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup QuadSPI_Register_Masks QuadSPI Register Masks
 * @{
 */

/* MCR Bit Fields */
#define QuadSPI_MCR_SWRSTSD_MASK                 0x1u
#define QuadSPI_MCR_SWRSTSD_SHIFT                0
#define QuadSPI_MCR_SWRSTSD_WIDTH                1
#define QuadSPI_MCR_SWRSTSD(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_MCR_SWRSTSD_SHIFT))&QuadSPI_MCR_SWRSTSD_MASK)
#define QuadSPI_MCR_SWRSTHD_MASK                 0x2u
#define QuadSPI_MCR_SWRSTHD_SHIFT                1
#define QuadSPI_MCR_SWRSTHD_WIDTH                1
#define QuadSPI_MCR_SWRSTHD(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_MCR_SWRSTHD_SHIFT))&QuadSPI_MCR_SWRSTHD_MASK)
#define QuadSPI_MCR_END_CFG_MASK                 0xCu
#define QuadSPI_MCR_END_CFG_SHIFT                2
#define QuadSPI_MCR_END_CFG_WIDTH                2
#define QuadSPI_MCR_END_CFG(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_MCR_END_CFG_SHIFT))&QuadSPI_MCR_END_CFG_MASK)
#define QuadSPI_MCR_DQS_LAT_EN_MASK              0x20u
#define QuadSPI_MCR_DQS_LAT_EN_SHIFT             5
#define QuadSPI_MCR_DQS_LAT_EN_WIDTH             1
#define QuadSPI_MCR_DQS_LAT_EN(x)                (((uint32_t)(((uint32_t)(x))<<QuadSPI_MCR_DQS_LAT_EN_SHIFT))&QuadSPI_MCR_DQS_LAT_EN_MASK)
#define QuadSPI_MCR_DQS_EN_MASK                  0x40u
#define QuadSPI_MCR_DQS_EN_SHIFT                 6
#define QuadSPI_MCR_DQS_EN_WIDTH                 1
#define QuadSPI_MCR_DQS_EN(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_MCR_DQS_EN_SHIFT))&QuadSPI_MCR_DQS_EN_MASK)
#define QuadSPI_MCR_DDR_EN_MASK                  0x80u
#define QuadSPI_MCR_DDR_EN_SHIFT                 7
#define QuadSPI_MCR_DDR_EN_WIDTH                 1
#define QuadSPI_MCR_DDR_EN(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_MCR_DDR_EN_SHIFT))&QuadSPI_MCR_DDR_EN_MASK)
#define QuadSPI_MCR_CLR_RXF_MASK                 0x400u
#define QuadSPI_MCR_CLR_RXF_SHIFT                10
#define QuadSPI_MCR_CLR_RXF_WIDTH                1
#define QuadSPI_MCR_CLR_RXF(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_MCR_CLR_RXF_SHIFT))&QuadSPI_MCR_CLR_RXF_MASK)
#define QuadSPI_MCR_CLR_TXF_MASK                 0x800u
#define QuadSPI_MCR_CLR_TXF_SHIFT                11
#define QuadSPI_MCR_CLR_TXF_WIDTH                1
#define QuadSPI_MCR_CLR_TXF(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_MCR_CLR_TXF_SHIFT))&QuadSPI_MCR_CLR_TXF_MASK)
#define QuadSPI_MCR_MDIS_MASK                    0x4000u
#define QuadSPI_MCR_MDIS_SHIFT                   14
#define QuadSPI_MCR_MDIS_WIDTH                   1
#define QuadSPI_MCR_MDIS(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_MCR_MDIS_SHIFT))&QuadSPI_MCR_MDIS_MASK)
#define QuadSPI_MCR_SCLKCFG_MASK                 0xFF000000u
#define QuadSPI_MCR_SCLKCFG_SHIFT                24
#define QuadSPI_MCR_SCLKCFG_WIDTH                8
#define QuadSPI_MCR_SCLKCFG(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_MCR_SCLKCFG_SHIFT))&QuadSPI_MCR_SCLKCFG_MASK)
/* IPCR Bit Fields */
#define QuadSPI_IPCR_IDATSZ_MASK                 0xFFFFu
#define QuadSPI_IPCR_IDATSZ_SHIFT                0
#define QuadSPI_IPCR_IDATSZ_WIDTH                16
#define QuadSPI_IPCR_IDATSZ(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_IPCR_IDATSZ_SHIFT))&QuadSPI_IPCR_IDATSZ_MASK)
#define QuadSPI_IPCR_PAR_EN_MASK                 0x10000u
#define QuadSPI_IPCR_PAR_EN_SHIFT                16
#define QuadSPI_IPCR_PAR_EN_WIDTH                1
#define QuadSPI_IPCR_PAR_EN(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_IPCR_PAR_EN_SHIFT))&QuadSPI_IPCR_PAR_EN_MASK)
#define QuadSPI_IPCR_SEQID_MASK                  0xF000000u
#define QuadSPI_IPCR_SEQID_SHIFT                 24
#define QuadSPI_IPCR_SEQID_WIDTH                 4
#define QuadSPI_IPCR_SEQID(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_IPCR_SEQID_SHIFT))&QuadSPI_IPCR_SEQID_MASK)
/* FLSHCR Bit Fields */
#define QuadSPI_FLSHCR_TCSS_MASK                 0xFu
#define QuadSPI_FLSHCR_TCSS_SHIFT                0
#define QuadSPI_FLSHCR_TCSS_WIDTH                4
#define QuadSPI_FLSHCR_TCSS(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_FLSHCR_TCSS_SHIFT))&QuadSPI_FLSHCR_TCSS_MASK)
#define QuadSPI_FLSHCR_TCSH_MASK                 0xF00u
#define QuadSPI_FLSHCR_TCSH_SHIFT                8
#define QuadSPI_FLSHCR_TCSH_WIDTH                4
#define QuadSPI_FLSHCR_TCSH(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_FLSHCR_TCSH_SHIFT))&QuadSPI_FLSHCR_TCSH_MASK)
#define QuadSPI_FLSHCR_TDH_MASK                  0x30000u
#define QuadSPI_FLSHCR_TDH_SHIFT                 16
#define QuadSPI_FLSHCR_TDH_WIDTH                 2
#define QuadSPI_FLSHCR_TDH(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_FLSHCR_TDH_SHIFT))&QuadSPI_FLSHCR_TDH_MASK)
/* BUF0CR Bit Fields */
#define QuadSPI_BUF0CR_MSTRID_MASK               0xFu
#define QuadSPI_BUF0CR_MSTRID_SHIFT              0
#define QuadSPI_BUF0CR_MSTRID_WIDTH              4
#define QuadSPI_BUF0CR_MSTRID(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF0CR_MSTRID_SHIFT))&QuadSPI_BUF0CR_MSTRID_MASK)
#define QuadSPI_BUF0CR_ADATSZ_MASK               0x7F00u
#define QuadSPI_BUF0CR_ADATSZ_SHIFT              8
#define QuadSPI_BUF0CR_ADATSZ_WIDTH              7
#define QuadSPI_BUF0CR_ADATSZ(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF0CR_ADATSZ_SHIFT))&QuadSPI_BUF0CR_ADATSZ_MASK)
#define QuadSPI_BUF0CR_HP_EN_MASK                0x80000000u
#define QuadSPI_BUF0CR_HP_EN_SHIFT               31
#define QuadSPI_BUF0CR_HP_EN_WIDTH               1
#define QuadSPI_BUF0CR_HP_EN(x)                  (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF0CR_HP_EN_SHIFT))&QuadSPI_BUF0CR_HP_EN_MASK)
/* BUF1CR Bit Fields */
#define QuadSPI_BUF1CR_MSTRID_MASK               0xFu
#define QuadSPI_BUF1CR_MSTRID_SHIFT              0
#define QuadSPI_BUF1CR_MSTRID_WIDTH              4
#define QuadSPI_BUF1CR_MSTRID(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF1CR_MSTRID_SHIFT))&QuadSPI_BUF1CR_MSTRID_MASK)
#define QuadSPI_BUF1CR_ADATSZ_MASK               0x7F00u
#define QuadSPI_BUF1CR_ADATSZ_SHIFT              8
#define QuadSPI_BUF1CR_ADATSZ_WIDTH              7
#define QuadSPI_BUF1CR_ADATSZ(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF1CR_ADATSZ_SHIFT))&QuadSPI_BUF1CR_ADATSZ_MASK)
/* BUF2CR Bit Fields */
#define QuadSPI_BUF2CR_MSTRID_MASK               0xFu
#define QuadSPI_BUF2CR_MSTRID_SHIFT              0
#define QuadSPI_BUF2CR_MSTRID_WIDTH              4
#define QuadSPI_BUF2CR_MSTRID(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF2CR_MSTRID_SHIFT))&QuadSPI_BUF2CR_MSTRID_MASK)
#define QuadSPI_BUF2CR_ADATSZ_MASK               0x7F00u
#define QuadSPI_BUF2CR_ADATSZ_SHIFT              8
#define QuadSPI_BUF2CR_ADATSZ_WIDTH              7
#define QuadSPI_BUF2CR_ADATSZ(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF2CR_ADATSZ_SHIFT))&QuadSPI_BUF2CR_ADATSZ_MASK)
/* BUF3CR Bit Fields */
#define QuadSPI_BUF3CR_MSTRID_MASK               0xFu
#define QuadSPI_BUF3CR_MSTRID_SHIFT              0
#define QuadSPI_BUF3CR_MSTRID_WIDTH              4
#define QuadSPI_BUF3CR_MSTRID(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF3CR_MSTRID_SHIFT))&QuadSPI_BUF3CR_MSTRID_MASK)
#define QuadSPI_BUF3CR_ADATSZ_MASK               0x7F00u
#define QuadSPI_BUF3CR_ADATSZ_SHIFT              8
#define QuadSPI_BUF3CR_ADATSZ_WIDTH              7
#define QuadSPI_BUF3CR_ADATSZ(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF3CR_ADATSZ_SHIFT))&QuadSPI_BUF3CR_ADATSZ_MASK)
#define QuadSPI_BUF3CR_ALLMST_MASK               0x80000000u
#define QuadSPI_BUF3CR_ALLMST_SHIFT              31
#define QuadSPI_BUF3CR_ALLMST_WIDTH              1
#define QuadSPI_BUF3CR_ALLMST(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF3CR_ALLMST_SHIFT))&QuadSPI_BUF3CR_ALLMST_MASK)
/* BFGENCR Bit Fields */
#define QuadSPI_BFGENCR_SEQID_MASK               0xF000u
#define QuadSPI_BFGENCR_SEQID_SHIFT              12
#define QuadSPI_BFGENCR_SEQID_WIDTH              4
#define QuadSPI_BFGENCR_SEQID(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_BFGENCR_SEQID_SHIFT))&QuadSPI_BFGENCR_SEQID_MASK)
#define QuadSPI_BFGENCR_PAR_EN_MASK              0x10000u
#define QuadSPI_BFGENCR_PAR_EN_SHIFT             16
#define QuadSPI_BFGENCR_PAR_EN_WIDTH             1
#define QuadSPI_BFGENCR_PAR_EN(x)                (((uint32_t)(((uint32_t)(x))<<QuadSPI_BFGENCR_PAR_EN_SHIFT))&QuadSPI_BFGENCR_PAR_EN_MASK)
/* SOCCR Bit Fields */
#define QuadSPI_SOCCR_QSPISRC_MASK               0x7u
#define QuadSPI_SOCCR_QSPISRC_SHIFT              0
#define QuadSPI_SOCCR_QSPISRC_WIDTH              3
#define QuadSPI_SOCCR_QSPISRC(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_SOCCR_QSPISRC_SHIFT))&QuadSPI_SOCCR_QSPISRC_MASK)
#define QuadSPI_SOCCR_DQSLPEN_MASK               0x100u
#define QuadSPI_SOCCR_DQSLPEN_SHIFT              8
#define QuadSPI_SOCCR_DQSLPEN_WIDTH              1
#define QuadSPI_SOCCR_DQSLPEN(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_SOCCR_DQSLPEN_SHIFT))&QuadSPI_SOCCR_DQSLPEN_MASK)
#define QuadSPI_SOCCR_DQSPADLPEN_MASK            0x200u
#define QuadSPI_SOCCR_DQSPADLPEN_SHIFT           9
#define QuadSPI_SOCCR_DQSPADLPEN_WIDTH           1
#define QuadSPI_SOCCR_DQSPADLPEN(x)              (((uint32_t)(((uint32_t)(x))<<QuadSPI_SOCCR_DQSPADLPEN_SHIFT))&QuadSPI_SOCCR_DQSPADLPEN_MASK)
#define QuadSPI_SOCCR_DQSPHASEL_MASK             0xC00u
#define QuadSPI_SOCCR_DQSPHASEL_SHIFT            10
#define QuadSPI_SOCCR_DQSPHASEL_WIDTH            2
#define QuadSPI_SOCCR_DQSPHASEL(x)               (((uint32_t)(((uint32_t)(x))<<QuadSPI_SOCCR_DQSPHASEL_SHIFT))&QuadSPI_SOCCR_DQSPHASEL_MASK)
#define QuadSPI_SOCCR_DQSINVSEL_MASK             0x1000u
#define QuadSPI_SOCCR_DQSINVSEL_SHIFT            12
#define QuadSPI_SOCCR_DQSINVSEL_WIDTH            1
#define QuadSPI_SOCCR_DQSINVSEL(x)               (((uint32_t)(((uint32_t)(x))<<QuadSPI_SOCCR_DQSINVSEL_SHIFT))&QuadSPI_SOCCR_DQSINVSEL_MASK)
#define QuadSPI_SOCCR_CK2EN_MASK                 0x2000u
#define QuadSPI_SOCCR_CK2EN_SHIFT                13
#define QuadSPI_SOCCR_CK2EN_WIDTH                1
#define QuadSPI_SOCCR_CK2EN(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_SOCCR_CK2EN_SHIFT))&QuadSPI_SOCCR_CK2EN_MASK)
#define QuadSPI_SOCCR_DIFFCKEN_MASK              0x4000u
#define QuadSPI_SOCCR_DIFFCKEN_SHIFT             14
#define QuadSPI_SOCCR_DIFFCKEN_WIDTH             1
#define QuadSPI_SOCCR_DIFFCKEN(x)                (((uint32_t)(((uint32_t)(x))<<QuadSPI_SOCCR_DIFFCKEN_SHIFT))&QuadSPI_SOCCR_DIFFCKEN_MASK)
#define QuadSPI_SOCCR_OCTEN_MASK                 0x8000u
#define QuadSPI_SOCCR_OCTEN_SHIFT                15
#define QuadSPI_SOCCR_OCTEN_WIDTH                1
#define QuadSPI_SOCCR_OCTEN(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_SOCCR_OCTEN_SHIFT))&QuadSPI_SOCCR_OCTEN_MASK)
#define QuadSPI_SOCCR_DLYTAPSELA_MASK            0x3F0000u
#define QuadSPI_SOCCR_DLYTAPSELA_SHIFT           16
#define QuadSPI_SOCCR_DLYTAPSELA_WIDTH           6
#define QuadSPI_SOCCR_DLYTAPSELA(x)              (((uint32_t)(((uint32_t)(x))<<QuadSPI_SOCCR_DLYTAPSELA_SHIFT))&QuadSPI_SOCCR_DLYTAPSELA_MASK)
#define QuadSPI_SOCCR_DLYTAPSELB_MASK            0x3F000000u
#define QuadSPI_SOCCR_DLYTAPSELB_SHIFT           24
#define QuadSPI_SOCCR_DLYTAPSELB_WIDTH           6
#define QuadSPI_SOCCR_DLYTAPSELB(x)              (((uint32_t)(((uint32_t)(x))<<QuadSPI_SOCCR_DLYTAPSELB_SHIFT))&QuadSPI_SOCCR_DLYTAPSELB_MASK)
/* BUF0IND Bit Fields */
#define QuadSPI_BUF0IND_TPINDX0_MASK             0xFFFFFFF8u
#define QuadSPI_BUF0IND_TPINDX0_SHIFT            3
#define QuadSPI_BUF0IND_TPINDX0_WIDTH            29
#define QuadSPI_BUF0IND_TPINDX0(x)               (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF0IND_TPINDX0_SHIFT))&QuadSPI_BUF0IND_TPINDX0_MASK)
/* BUF1IND Bit Fields */
#define QuadSPI_BUF1IND_TPINDX1_MASK             0xFFFFFFF8u
#define QuadSPI_BUF1IND_TPINDX1_SHIFT            3
#define QuadSPI_BUF1IND_TPINDX1_WIDTH            29
#define QuadSPI_BUF1IND_TPINDX1(x)               (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF1IND_TPINDX1_SHIFT))&QuadSPI_BUF1IND_TPINDX1_MASK)
/* BUF2IND Bit Fields */
#define QuadSPI_BUF2IND_TPINDX2_MASK             0xFFFFFFF8u
#define QuadSPI_BUF2IND_TPINDX2_SHIFT            3
#define QuadSPI_BUF2IND_TPINDX2_WIDTH            29
#define QuadSPI_BUF2IND_TPINDX2(x)               (((uint32_t)(((uint32_t)(x))<<QuadSPI_BUF2IND_TPINDX2_SHIFT))&QuadSPI_BUF2IND_TPINDX2_MASK)
/* SFAR Bit Fields */
#define QuadSPI_SFAR_SFADR_MASK                  0xFFFFFFFFu
#define QuadSPI_SFAR_SFADR_SHIFT                 0
#define QuadSPI_SFAR_SFADR_WIDTH                 32
#define QuadSPI_SFAR_SFADR(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SFAR_SFADR_SHIFT))&QuadSPI_SFAR_SFADR_MASK)
/* SFACR Bit Fields */
#define QuadSPI_SFACR_CAS_MASK                   0xFu
#define QuadSPI_SFACR_CAS_SHIFT                  0
#define QuadSPI_SFACR_CAS_WIDTH                  4
#define QuadSPI_SFACR_CAS(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SFACR_CAS_SHIFT))&QuadSPI_SFACR_CAS_MASK)
#define QuadSPI_SFACR_WA_MASK                    0x10000u
#define QuadSPI_SFACR_WA_SHIFT                   16
#define QuadSPI_SFACR_WA_WIDTH                   1
#define QuadSPI_SFACR_WA(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_SFACR_WA_SHIFT))&QuadSPI_SFACR_WA_MASK)
/* SMPR Bit Fields */
#define QuadSPI_SMPR_HSENA_MASK                  0x1u
#define QuadSPI_SMPR_HSENA_SHIFT                 0
#define QuadSPI_SMPR_HSENA_WIDTH                 1
#define QuadSPI_SMPR_HSENA(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SMPR_HSENA_SHIFT))&QuadSPI_SMPR_HSENA_MASK)
#define QuadSPI_SMPR_HSPHS_MASK                  0x2u
#define QuadSPI_SMPR_HSPHS_SHIFT                 1
#define QuadSPI_SMPR_HSPHS_WIDTH                 1
#define QuadSPI_SMPR_HSPHS(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SMPR_HSPHS_SHIFT))&QuadSPI_SMPR_HSPHS_MASK)
#define QuadSPI_SMPR_HSDLY_MASK                  0x4u
#define QuadSPI_SMPR_HSDLY_SHIFT                 2
#define QuadSPI_SMPR_HSDLY_WIDTH                 1
#define QuadSPI_SMPR_HSDLY(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SMPR_HSDLY_SHIFT))&QuadSPI_SMPR_HSDLY_MASK)
#define QuadSPI_SMPR_FSPHS_MASK                  0x20u
#define QuadSPI_SMPR_FSPHS_SHIFT                 5
#define QuadSPI_SMPR_FSPHS_WIDTH                 1
#define QuadSPI_SMPR_FSPHS(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SMPR_FSPHS_SHIFT))&QuadSPI_SMPR_FSPHS_MASK)
#define QuadSPI_SMPR_FSDLY_MASK                  0x40u
#define QuadSPI_SMPR_FSDLY_SHIFT                 6
#define QuadSPI_SMPR_FSDLY_WIDTH                 1
#define QuadSPI_SMPR_FSDLY(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SMPR_FSDLY_SHIFT))&QuadSPI_SMPR_FSDLY_MASK)
#define QuadSPI_SMPR_DDRSMP_MASK                 0x70000u
#define QuadSPI_SMPR_DDRSMP_SHIFT                16
#define QuadSPI_SMPR_DDRSMP_WIDTH                3
#define QuadSPI_SMPR_DDRSMP(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_SMPR_DDRSMP_SHIFT))&QuadSPI_SMPR_DDRSMP_MASK)
/* RBSR Bit Fields */
#define QuadSPI_RBSR_RDBFL_MASK                  0x1F00u
#define QuadSPI_RBSR_RDBFL_SHIFT                 8
#define QuadSPI_RBSR_RDBFL_WIDTH                 5
#define QuadSPI_RBSR_RDBFL(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RBSR_RDBFL_SHIFT))&QuadSPI_RBSR_RDBFL_MASK)
#define QuadSPI_RBSR_RDCTR_MASK                  0xFFFF0000u
#define QuadSPI_RBSR_RDCTR_SHIFT                 16
#define QuadSPI_RBSR_RDCTR_WIDTH                 16
#define QuadSPI_RBSR_RDCTR(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RBSR_RDCTR_SHIFT))&QuadSPI_RBSR_RDCTR_MASK)
/* RBCT Bit Fields */
#define QuadSPI_RBCT_WMRK_MASK                   0xFu
#define QuadSPI_RBCT_WMRK_SHIFT                  0
#define QuadSPI_RBCT_WMRK_WIDTH                  4
#define QuadSPI_RBCT_WMRK(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_RBCT_WMRK_SHIFT))&QuadSPI_RBCT_WMRK_MASK)
#define QuadSPI_RBCT_RXBRD_MASK                  0x100u
#define QuadSPI_RBCT_RXBRD_SHIFT                 8
#define QuadSPI_RBCT_RXBRD_WIDTH                 1
#define QuadSPI_RBCT_RXBRD(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RBCT_RXBRD_SHIFT))&QuadSPI_RBCT_RXBRD_MASK)
/* TBSR Bit Fields */
#define QuadSPI_TBSR_TRBFL_MASK                  0x1F00u
#define QuadSPI_TBSR_TRBFL_SHIFT                 8
#define QuadSPI_TBSR_TRBFL_WIDTH                 5
#define QuadSPI_TBSR_TRBFL(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_TBSR_TRBFL_SHIFT))&QuadSPI_TBSR_TRBFL_MASK)
#define QuadSPI_TBSR_TRCTR_MASK                  0xFFFF0000u
#define QuadSPI_TBSR_TRCTR_SHIFT                 16
#define QuadSPI_TBSR_TRCTR_WIDTH                 16
#define QuadSPI_TBSR_TRCTR(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_TBSR_TRCTR_SHIFT))&QuadSPI_TBSR_TRCTR_MASK)
/* TBDR Bit Fields */
#define QuadSPI_TBDR_TXDATA_MASK                 0xFFFFFFFFu
#define QuadSPI_TBDR_TXDATA_SHIFT                0
#define QuadSPI_TBDR_TXDATA_WIDTH                32
#define QuadSPI_TBDR_TXDATA(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_TBDR_TXDATA_SHIFT))&QuadSPI_TBDR_TXDATA_MASK)
/* TBCT Bit Fields */
#define QuadSPI_TBCT_WMRK_MASK                   0xFu
#define QuadSPI_TBCT_WMRK_SHIFT                  0
#define QuadSPI_TBCT_WMRK_WIDTH                  4
#define QuadSPI_TBCT_WMRK(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_TBCT_WMRK_SHIFT))&QuadSPI_TBCT_WMRK_MASK)
/* SR Bit Fields */
#define QuadSPI_SR_BUSY_MASK                     0x1u
#define QuadSPI_SR_BUSY_SHIFT                    0
#define QuadSPI_SR_BUSY_WIDTH                    1
#define QuadSPI_SR_BUSY(x)                       (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_BUSY_SHIFT))&QuadSPI_SR_BUSY_MASK)
#define QuadSPI_SR_IP_ACC_MASK                   0x2u
#define QuadSPI_SR_IP_ACC_SHIFT                  1
#define QuadSPI_SR_IP_ACC_WIDTH                  1
#define QuadSPI_SR_IP_ACC(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_IP_ACC_SHIFT))&QuadSPI_SR_IP_ACC_MASK)
#define QuadSPI_SR_AHB_ACC_MASK                  0x4u
#define QuadSPI_SR_AHB_ACC_SHIFT                 2
#define QuadSPI_SR_AHB_ACC_WIDTH                 1
#define QuadSPI_SR_AHB_ACC(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHB_ACC_SHIFT))&QuadSPI_SR_AHB_ACC_MASK)
#define QuadSPI_SR_AHBGNT_MASK                   0x20u
#define QuadSPI_SR_AHBGNT_SHIFT                  5
#define QuadSPI_SR_AHBGNT_WIDTH                  1
#define QuadSPI_SR_AHBGNT(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHBGNT_SHIFT))&QuadSPI_SR_AHBGNT_MASK)
#define QuadSPI_SR_AHBTRN_MASK                   0x40u
#define QuadSPI_SR_AHBTRN_SHIFT                  6
#define QuadSPI_SR_AHBTRN_WIDTH                  1
#define QuadSPI_SR_AHBTRN(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHBTRN_SHIFT))&QuadSPI_SR_AHBTRN_MASK)
#define QuadSPI_SR_AHB0NE_MASK                   0x80u
#define QuadSPI_SR_AHB0NE_SHIFT                  7
#define QuadSPI_SR_AHB0NE_WIDTH                  1
#define QuadSPI_SR_AHB0NE(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHB0NE_SHIFT))&QuadSPI_SR_AHB0NE_MASK)
#define QuadSPI_SR_AHB1NE_MASK                   0x100u
#define QuadSPI_SR_AHB1NE_SHIFT                  8
#define QuadSPI_SR_AHB1NE_WIDTH                  1
#define QuadSPI_SR_AHB1NE(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHB1NE_SHIFT))&QuadSPI_SR_AHB1NE_MASK)
#define QuadSPI_SR_AHB2NE_MASK                   0x200u
#define QuadSPI_SR_AHB2NE_SHIFT                  9
#define QuadSPI_SR_AHB2NE_WIDTH                  1
#define QuadSPI_SR_AHB2NE(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHB2NE_SHIFT))&QuadSPI_SR_AHB2NE_MASK)
#define QuadSPI_SR_AHB3NE_MASK                   0x400u
#define QuadSPI_SR_AHB3NE_SHIFT                  10
#define QuadSPI_SR_AHB3NE_WIDTH                  1
#define QuadSPI_SR_AHB3NE(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHB3NE_SHIFT))&QuadSPI_SR_AHB3NE_MASK)
#define QuadSPI_SR_AHB0FUL_MASK                  0x800u
#define QuadSPI_SR_AHB0FUL_SHIFT                 11
#define QuadSPI_SR_AHB0FUL_WIDTH                 1
#define QuadSPI_SR_AHB0FUL(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHB0FUL_SHIFT))&QuadSPI_SR_AHB0FUL_MASK)
#define QuadSPI_SR_AHB1FUL_MASK                  0x1000u
#define QuadSPI_SR_AHB1FUL_SHIFT                 12
#define QuadSPI_SR_AHB1FUL_WIDTH                 1
#define QuadSPI_SR_AHB1FUL(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHB1FUL_SHIFT))&QuadSPI_SR_AHB1FUL_MASK)
#define QuadSPI_SR_AHB2FUL_MASK                  0x2000u
#define QuadSPI_SR_AHB2FUL_SHIFT                 13
#define QuadSPI_SR_AHB2FUL_WIDTH                 1
#define QuadSPI_SR_AHB2FUL(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHB2FUL_SHIFT))&QuadSPI_SR_AHB2FUL_MASK)
#define QuadSPI_SR_AHB3FUL_MASK                  0x4000u
#define QuadSPI_SR_AHB3FUL_SHIFT                 14
#define QuadSPI_SR_AHB3FUL_WIDTH                 1
#define QuadSPI_SR_AHB3FUL(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_AHB3FUL_SHIFT))&QuadSPI_SR_AHB3FUL_MASK)
#define QuadSPI_SR_RXWE_MASK                     0x10000u
#define QuadSPI_SR_RXWE_SHIFT                    16
#define QuadSPI_SR_RXWE_WIDTH                    1
#define QuadSPI_SR_RXWE(x)                       (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_RXWE_SHIFT))&QuadSPI_SR_RXWE_MASK)
#define QuadSPI_SR_RXFULL_MASK                   0x80000u
#define QuadSPI_SR_RXFULL_SHIFT                  19
#define QuadSPI_SR_RXFULL_WIDTH                  1
#define QuadSPI_SR_RXFULL(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_RXFULL_SHIFT))&QuadSPI_SR_RXFULL_MASK)
#define QuadSPI_SR_RXDMA_MASK                    0x800000u
#define QuadSPI_SR_RXDMA_SHIFT                   23
#define QuadSPI_SR_RXDMA_WIDTH                   1
#define QuadSPI_SR_RXDMA(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_RXDMA_SHIFT))&QuadSPI_SR_RXDMA_MASK)
#define QuadSPI_SR_TXEDA_MASK                    0x1000000u
#define QuadSPI_SR_TXEDA_SHIFT                   24
#define QuadSPI_SR_TXEDA_WIDTH                   1
#define QuadSPI_SR_TXEDA(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_TXEDA_SHIFT))&QuadSPI_SR_TXEDA_MASK)
#define QuadSPI_SR_TXWA_MASK                     0x2000000u
#define QuadSPI_SR_TXWA_SHIFT                    25
#define QuadSPI_SR_TXWA_WIDTH                    1
#define QuadSPI_SR_TXWA(x)                       (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_TXWA_SHIFT))&QuadSPI_SR_TXWA_MASK)
#define QuadSPI_SR_TXDMA_MASK                    0x4000000u
#define QuadSPI_SR_TXDMA_SHIFT                   26
#define QuadSPI_SR_TXDMA_WIDTH                   1
#define QuadSPI_SR_TXDMA(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_TXDMA_SHIFT))&QuadSPI_SR_TXDMA_MASK)
#define QuadSPI_SR_TXFULL_MASK                   0x8000000u
#define QuadSPI_SR_TXFULL_SHIFT                  27
#define QuadSPI_SR_TXFULL_WIDTH                  1
#define QuadSPI_SR_TXFULL(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_TXFULL_SHIFT))&QuadSPI_SR_TXFULL_MASK)
#define QuadSPI_SR_DLPSMP_MASK                   0xE0000000u
#define QuadSPI_SR_DLPSMP_SHIFT                  29
#define QuadSPI_SR_DLPSMP_WIDTH                  3
#define QuadSPI_SR_DLPSMP(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_SR_DLPSMP_SHIFT))&QuadSPI_SR_DLPSMP_MASK)
/* FR Bit Fields */
#define QuadSPI_FR_TFF_MASK                      0x1u
#define QuadSPI_FR_TFF_SHIFT                     0
#define QuadSPI_FR_TFF_WIDTH                     1
#define QuadSPI_FR_TFF(x)                        (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_TFF_SHIFT))&QuadSPI_FR_TFF_MASK)
#define QuadSPI_FR_IPGEF_MASK                    0x10u
#define QuadSPI_FR_IPGEF_SHIFT                   4
#define QuadSPI_FR_IPGEF_WIDTH                   1
#define QuadSPI_FR_IPGEF(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_IPGEF_SHIFT))&QuadSPI_FR_IPGEF_MASK)
#define QuadSPI_FR_IPIEF_MASK                    0x40u
#define QuadSPI_FR_IPIEF_SHIFT                   6
#define QuadSPI_FR_IPIEF_WIDTH                   1
#define QuadSPI_FR_IPIEF(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_IPIEF_SHIFT))&QuadSPI_FR_IPIEF_MASK)
#define QuadSPI_FR_IPAEF_MASK                    0x80u
#define QuadSPI_FR_IPAEF_SHIFT                   7
#define QuadSPI_FR_IPAEF_WIDTH                   1
#define QuadSPI_FR_IPAEF(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_IPAEF_SHIFT))&QuadSPI_FR_IPAEF_MASK)
#define QuadSPI_FR_IUEF_MASK                     0x800u
#define QuadSPI_FR_IUEF_SHIFT                    11
#define QuadSPI_FR_IUEF_WIDTH                    1
#define QuadSPI_FR_IUEF(x)                       (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_IUEF_SHIFT))&QuadSPI_FR_IUEF_MASK)
#define QuadSPI_FR_ABOF_MASK                     0x1000u
#define QuadSPI_FR_ABOF_SHIFT                    12
#define QuadSPI_FR_ABOF_WIDTH                    1
#define QuadSPI_FR_ABOF(x)                       (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_ABOF_SHIFT))&QuadSPI_FR_ABOF_MASK)
#define QuadSPI_FR_AIBSEF_MASK                   0x2000u
#define QuadSPI_FR_AIBSEF_SHIFT                  13
#define QuadSPI_FR_AIBSEF_WIDTH                  1
#define QuadSPI_FR_AIBSEF(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_AIBSEF_SHIFT))&QuadSPI_FR_AIBSEF_MASK)
#define QuadSPI_FR_AITEF_MASK                    0x4000u
#define QuadSPI_FR_AITEF_SHIFT                   14
#define QuadSPI_FR_AITEF_WIDTH                   1
#define QuadSPI_FR_AITEF(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_AITEF_SHIFT))&QuadSPI_FR_AITEF_MASK)
#define QuadSPI_FR_ABSEF_MASK                    0x8000u
#define QuadSPI_FR_ABSEF_SHIFT                   15
#define QuadSPI_FR_ABSEF_WIDTH                   1
#define QuadSPI_FR_ABSEF(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_ABSEF_SHIFT))&QuadSPI_FR_ABSEF_MASK)
#define QuadSPI_FR_RBDF_MASK                     0x10000u
#define QuadSPI_FR_RBDF_SHIFT                    16
#define QuadSPI_FR_RBDF_WIDTH                    1
#define QuadSPI_FR_RBDF(x)                       (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_RBDF_SHIFT))&QuadSPI_FR_RBDF_MASK)
#define QuadSPI_FR_RBOF_MASK                     0x20000u
#define QuadSPI_FR_RBOF_SHIFT                    17
#define QuadSPI_FR_RBOF_WIDTH                    1
#define QuadSPI_FR_RBOF(x)                       (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_RBOF_SHIFT))&QuadSPI_FR_RBOF_MASK)
#define QuadSPI_FR_ILLINE_MASK                   0x800000u
#define QuadSPI_FR_ILLINE_SHIFT                  23
#define QuadSPI_FR_ILLINE_WIDTH                  1
#define QuadSPI_FR_ILLINE(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_ILLINE_SHIFT))&QuadSPI_FR_ILLINE_MASK)
#define QuadSPI_FR_TBUF_MASK                     0x4000000u
#define QuadSPI_FR_TBUF_SHIFT                    26
#define QuadSPI_FR_TBUF_WIDTH                    1
#define QuadSPI_FR_TBUF(x)                       (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_TBUF_SHIFT))&QuadSPI_FR_TBUF_MASK)
#define QuadSPI_FR_TBFF_MASK                     0x8000000u
#define QuadSPI_FR_TBFF_SHIFT                    27
#define QuadSPI_FR_TBFF_WIDTH                    1
#define QuadSPI_FR_TBFF(x)                       (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_TBFF_SHIFT))&QuadSPI_FR_TBFF_MASK)
#define QuadSPI_FR_DLPFF_MASK                    0x80000000u
#define QuadSPI_FR_DLPFF_SHIFT                   31
#define QuadSPI_FR_DLPFF_WIDTH                   1
#define QuadSPI_FR_DLPFF(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_FR_DLPFF_SHIFT))&QuadSPI_FR_DLPFF_MASK)
/* RSER Bit Fields */
#define QuadSPI_RSER_TFIE_MASK                   0x1u
#define QuadSPI_RSER_TFIE_SHIFT                  0
#define QuadSPI_RSER_TFIE_WIDTH                  1
#define QuadSPI_RSER_TFIE(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_TFIE_SHIFT))&QuadSPI_RSER_TFIE_MASK)
#define QuadSPI_RSER_IPGEIE_MASK                 0x10u
#define QuadSPI_RSER_IPGEIE_SHIFT                4
#define QuadSPI_RSER_IPGEIE_WIDTH                1
#define QuadSPI_RSER_IPGEIE(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_IPGEIE_SHIFT))&QuadSPI_RSER_IPGEIE_MASK)
#define QuadSPI_RSER_IPIEIE_MASK                 0x40u
#define QuadSPI_RSER_IPIEIE_SHIFT                6
#define QuadSPI_RSER_IPIEIE_WIDTH                1
#define QuadSPI_RSER_IPIEIE(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_IPIEIE_SHIFT))&QuadSPI_RSER_IPIEIE_MASK)
#define QuadSPI_RSER_IPAEIE_MASK                 0x80u
#define QuadSPI_RSER_IPAEIE_SHIFT                7
#define QuadSPI_RSER_IPAEIE_WIDTH                1
#define QuadSPI_RSER_IPAEIE(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_IPAEIE_SHIFT))&QuadSPI_RSER_IPAEIE_MASK)
#define QuadSPI_RSER_IUEIE_MASK                  0x800u
#define QuadSPI_RSER_IUEIE_SHIFT                 11
#define QuadSPI_RSER_IUEIE_WIDTH                 1
#define QuadSPI_RSER_IUEIE(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_IUEIE_SHIFT))&QuadSPI_RSER_IUEIE_MASK)
#define QuadSPI_RSER_ABOIE_MASK                  0x1000u
#define QuadSPI_RSER_ABOIE_SHIFT                 12
#define QuadSPI_RSER_ABOIE_WIDTH                 1
#define QuadSPI_RSER_ABOIE(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_ABOIE_SHIFT))&QuadSPI_RSER_ABOIE_MASK)
#define QuadSPI_RSER_AIBSIE_MASK                 0x2000u
#define QuadSPI_RSER_AIBSIE_SHIFT                13
#define QuadSPI_RSER_AIBSIE_WIDTH                1
#define QuadSPI_RSER_AIBSIE(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_AIBSIE_SHIFT))&QuadSPI_RSER_AIBSIE_MASK)
#define QuadSPI_RSER_AITIE_MASK                  0x4000u
#define QuadSPI_RSER_AITIE_SHIFT                 14
#define QuadSPI_RSER_AITIE_WIDTH                 1
#define QuadSPI_RSER_AITIE(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_AITIE_SHIFT))&QuadSPI_RSER_AITIE_MASK)
#define QuadSPI_RSER_ABSEIE_MASK                 0x8000u
#define QuadSPI_RSER_ABSEIE_SHIFT                15
#define QuadSPI_RSER_ABSEIE_WIDTH                1
#define QuadSPI_RSER_ABSEIE(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_ABSEIE_SHIFT))&QuadSPI_RSER_ABSEIE_MASK)
#define QuadSPI_RSER_RBDIE_MASK                  0x10000u
#define QuadSPI_RSER_RBDIE_SHIFT                 16
#define QuadSPI_RSER_RBDIE_WIDTH                 1
#define QuadSPI_RSER_RBDIE(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_RBDIE_SHIFT))&QuadSPI_RSER_RBDIE_MASK)
#define QuadSPI_RSER_RBOIE_MASK                  0x20000u
#define QuadSPI_RSER_RBOIE_SHIFT                 17
#define QuadSPI_RSER_RBOIE_WIDTH                 1
#define QuadSPI_RSER_RBOIE(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_RBOIE_SHIFT))&QuadSPI_RSER_RBOIE_MASK)
#define QuadSPI_RSER_RBDDE_MASK                  0x200000u
#define QuadSPI_RSER_RBDDE_SHIFT                 21
#define QuadSPI_RSER_RBDDE_WIDTH                 1
#define QuadSPI_RSER_RBDDE(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_RBDDE_SHIFT))&QuadSPI_RSER_RBDDE_MASK)
#define QuadSPI_RSER_ILLINIE_MASK                0x800000u
#define QuadSPI_RSER_ILLINIE_SHIFT               23
#define QuadSPI_RSER_ILLINIE_WIDTH               1
#define QuadSPI_RSER_ILLINIE(x)                  (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_ILLINIE_SHIFT))&QuadSPI_RSER_ILLINIE_MASK)
#define QuadSPI_RSER_TBFDE_MASK                  0x2000000u
#define QuadSPI_RSER_TBFDE_SHIFT                 25
#define QuadSPI_RSER_TBFDE_WIDTH                 1
#define QuadSPI_RSER_TBFDE(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_TBFDE_SHIFT))&QuadSPI_RSER_TBFDE_MASK)
#define QuadSPI_RSER_TBUIE_MASK                  0x4000000u
#define QuadSPI_RSER_TBUIE_SHIFT                 26
#define QuadSPI_RSER_TBUIE_WIDTH                 1
#define QuadSPI_RSER_TBUIE(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_TBUIE_SHIFT))&QuadSPI_RSER_TBUIE_MASK)
#define QuadSPI_RSER_TBFIE_MASK                  0x8000000u
#define QuadSPI_RSER_TBFIE_SHIFT                 27
#define QuadSPI_RSER_TBFIE_WIDTH                 1
#define QuadSPI_RSER_TBFIE(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_TBFIE_SHIFT))&QuadSPI_RSER_TBFIE_MASK)
#define QuadSPI_RSER_DLPFIE_MASK                 0x80000000u
#define QuadSPI_RSER_DLPFIE_SHIFT                31
#define QuadSPI_RSER_DLPFIE_WIDTH                1
#define QuadSPI_RSER_DLPFIE(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_RSER_DLPFIE_SHIFT))&QuadSPI_RSER_DLPFIE_MASK)
/* SPNDST Bit Fields */
#define QuadSPI_SPNDST_SUSPND_MASK               0x1u
#define QuadSPI_SPNDST_SUSPND_SHIFT              0
#define QuadSPI_SPNDST_SUSPND_WIDTH              1
#define QuadSPI_SPNDST_SUSPND(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_SPNDST_SUSPND_SHIFT))&QuadSPI_SPNDST_SUSPND_MASK)
#define QuadSPI_SPNDST_SPDBUF_MASK               0xC0u
#define QuadSPI_SPNDST_SPDBUF_SHIFT              6
#define QuadSPI_SPNDST_SPDBUF_WIDTH              2
#define QuadSPI_SPNDST_SPDBUF(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_SPNDST_SPDBUF_SHIFT))&QuadSPI_SPNDST_SPDBUF_MASK)
#define QuadSPI_SPNDST_DATLFT_MASK               0x7E00u
#define QuadSPI_SPNDST_DATLFT_SHIFT              9
#define QuadSPI_SPNDST_DATLFT_WIDTH              6
#define QuadSPI_SPNDST_DATLFT(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_SPNDST_DATLFT_SHIFT))&QuadSPI_SPNDST_DATLFT_MASK)
/* SPTRCLR Bit Fields */
#define QuadSPI_SPTRCLR_BFPTRC_MASK              0x1u
#define QuadSPI_SPTRCLR_BFPTRC_SHIFT             0
#define QuadSPI_SPTRCLR_BFPTRC_WIDTH             1
#define QuadSPI_SPTRCLR_BFPTRC(x)                (((uint32_t)(((uint32_t)(x))<<QuadSPI_SPTRCLR_BFPTRC_SHIFT))&QuadSPI_SPTRCLR_BFPTRC_MASK)
#define QuadSPI_SPTRCLR_IPPTRC_MASK              0x100u
#define QuadSPI_SPTRCLR_IPPTRC_SHIFT             8
#define QuadSPI_SPTRCLR_IPPTRC_WIDTH             1
#define QuadSPI_SPTRCLR_IPPTRC(x)                (((uint32_t)(((uint32_t)(x))<<QuadSPI_SPTRCLR_IPPTRC_SHIFT))&QuadSPI_SPTRCLR_IPPTRC_MASK)
/* SFA1AD Bit Fields */
#define QuadSPI_SFA1AD_TPADA1_MASK               0xFFFFFC00u
#define QuadSPI_SFA1AD_TPADA1_SHIFT              10
#define QuadSPI_SFA1AD_TPADA1_WIDTH              22
#define QuadSPI_SFA1AD_TPADA1(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_SFA1AD_TPADA1_SHIFT))&QuadSPI_SFA1AD_TPADA1_MASK)
/* SFA2AD Bit Fields */
#define QuadSPI_SFA2AD_TPADA2_MASK               0xFFFFFC00u
#define QuadSPI_SFA2AD_TPADA2_SHIFT              10
#define QuadSPI_SFA2AD_TPADA2_WIDTH              22
#define QuadSPI_SFA2AD_TPADA2(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_SFA2AD_TPADA2_SHIFT))&QuadSPI_SFA2AD_TPADA2_MASK)
/* SFB1AD Bit Fields */
#define QuadSPI_SFB1AD_TPADB1_MASK               0xFFFFFC00u
#define QuadSPI_SFB1AD_TPADB1_SHIFT              10
#define QuadSPI_SFB1AD_TPADB1_WIDTH              22
#define QuadSPI_SFB1AD_TPADB1(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_SFB1AD_TPADB1_SHIFT))&QuadSPI_SFB1AD_TPADB1_MASK)
/* SFB2AD Bit Fields */
#define QuadSPI_SFB2AD_TPADB2_MASK               0xFFFFFC00u
#define QuadSPI_SFB2AD_TPADB2_SHIFT              10
#define QuadSPI_SFB2AD_TPADB2_WIDTH              22
#define QuadSPI_SFB2AD_TPADB2(x)                 (((uint32_t)(((uint32_t)(x))<<QuadSPI_SFB2AD_TPADB2_SHIFT))&QuadSPI_SFB2AD_TPADB2_MASK)
/* DLPR Bit Fields */
#define QuadSPI_DLPR_DLPV_MASK                   0xFFFFFFFFu
#define QuadSPI_DLPR_DLPV_SHIFT                  0
#define QuadSPI_DLPR_DLPV_WIDTH                  32
#define QuadSPI_DLPR_DLPV(x)                     (((uint32_t)(((uint32_t)(x))<<QuadSPI_DLPR_DLPV_SHIFT))&QuadSPI_DLPR_DLPV_MASK)
/* RBDR Bit Fields */
#define QuadSPI_RBDR_RXDATA_MASK                 0xFFFFFFFFu
#define QuadSPI_RBDR_RXDATA_SHIFT                0
#define QuadSPI_RBDR_RXDATA_WIDTH                32
#define QuadSPI_RBDR_RXDATA(x)                   (((uint32_t)(((uint32_t)(x))<<QuadSPI_RBDR_RXDATA_SHIFT))&QuadSPI_RBDR_RXDATA_MASK)
/* LUTKEY Bit Fields */
#define QuadSPI_LUTKEY_KEY_MASK                  0xFFFFFFFFu
#define QuadSPI_LUTKEY_KEY_SHIFT                 0
#define QuadSPI_LUTKEY_KEY_WIDTH                 32
#define QuadSPI_LUTKEY_KEY(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_LUTKEY_KEY_SHIFT))&QuadSPI_LUTKEY_KEY_MASK)
/* LCKCR Bit Fields */
#define QuadSPI_LCKCR_LOCK_MASK                  0x1u
#define QuadSPI_LCKCR_LOCK_SHIFT                 0
#define QuadSPI_LCKCR_LOCK_WIDTH                 1
#define QuadSPI_LCKCR_LOCK(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_LCKCR_LOCK_SHIFT))&QuadSPI_LCKCR_LOCK_MASK)
#define QuadSPI_LCKCR_UNLOCK_MASK                0x2u
#define QuadSPI_LCKCR_UNLOCK_SHIFT               1
#define QuadSPI_LCKCR_UNLOCK_WIDTH               1
#define QuadSPI_LCKCR_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x))<<QuadSPI_LCKCR_UNLOCK_SHIFT))&QuadSPI_LCKCR_UNLOCK_MASK)
/* LUT Bit Fields */
#define QuadSPI_LUT_OPRND0_MASK                  0xFFu
#define QuadSPI_LUT_OPRND0_SHIFT                 0
#define QuadSPI_LUT_OPRND0_WIDTH                 8
#define QuadSPI_LUT_OPRND0(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_LUT_OPRND0_SHIFT))&QuadSPI_LUT_OPRND0_MASK)
#define QuadSPI_LUT_PAD0_MASK                    0x300u
#define QuadSPI_LUT_PAD0_SHIFT                   8
#define QuadSPI_LUT_PAD0_WIDTH                   2
#define QuadSPI_LUT_PAD0(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_LUT_PAD0_SHIFT))&QuadSPI_LUT_PAD0_MASK)
#define QuadSPI_LUT_INSTR0_MASK                  0xFC00u
#define QuadSPI_LUT_INSTR0_SHIFT                 10
#define QuadSPI_LUT_INSTR0_WIDTH                 6
#define QuadSPI_LUT_INSTR0(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_LUT_INSTR0_SHIFT))&QuadSPI_LUT_INSTR0_MASK)
#define QuadSPI_LUT_OPRND1_MASK                  0xFF0000u
#define QuadSPI_LUT_OPRND1_SHIFT                 16
#define QuadSPI_LUT_OPRND1_WIDTH                 8
#define QuadSPI_LUT_OPRND1(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_LUT_OPRND1_SHIFT))&QuadSPI_LUT_OPRND1_MASK)
#define QuadSPI_LUT_PAD1_MASK                    0x3000000u
#define QuadSPI_LUT_PAD1_SHIFT                   24
#define QuadSPI_LUT_PAD1_WIDTH                   2
#define QuadSPI_LUT_PAD1(x)                      (((uint32_t)(((uint32_t)(x))<<QuadSPI_LUT_PAD1_SHIFT))&QuadSPI_LUT_PAD1_MASK)
#define QuadSPI_LUT_INSTR1_MASK                  0xFC000000u
#define QuadSPI_LUT_INSTR1_SHIFT                 26
#define QuadSPI_LUT_INSTR1_WIDTH                 6
#define QuadSPI_LUT_INSTR1(x)                    (((uint32_t)(((uint32_t)(x))<<QuadSPI_LUT_INSTR1_SHIFT))&QuadSPI_LUT_INSTR1_MASK)

/*!
 * @}
 */ /* end of group QuadSPI_Register_Masks */


/* QuadSPI - Peripheral instance base addresses */
/** Peripheral QuadSPI0 base address */
#define QuadSPI0_BASE                            (0x4005A000u)
/** Peripheral QuadSPI0 base pointer */
#define QuadSPI0                                 ((QuadSPI_Type *)QuadSPI0_BASE)
#define QuadSPI0_BASE_PTR                        (QuadSPI0)
/** Array initializer of QuadSPI peripheral base addresses */
#define QuadSPI_BASE_ADDRS                       { QuadSPI0_BASE }
/** Array initializer of QuadSPI peripheral base pointers */
#define QuadSPI_BASE_PTRS                        { QuadSPI0 }

/* ----------------------------------------------------------------------------
   -- QuadSPI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup QuadSPI_Register_Accessor_Macros QuadSPI - Register accessor macros
 * @{
 */


/* QuadSPI - Register instance definitions */
/* QuadSPI0 */
#define QuadSPI0_MCR                             QuadSPI_MCR_REG(QuadSPI0)
#define QuadSPI0_IPCR                            QuadSPI_IPCR_REG(QuadSPI0)
#define QuadSPI0_FLSHCR                          QuadSPI_FLSHCR_REG(QuadSPI0)
#define QuadSPI0_BUF0CR                          QuadSPI_BUF0CR_REG(QuadSPI0)
#define QuadSPI0_BUF1CR                          QuadSPI_BUF1CR_REG(QuadSPI0)
#define QuadSPI0_BUF2CR                          QuadSPI_BUF2CR_REG(QuadSPI0)
#define QuadSPI0_BUF3CR                          QuadSPI_BUF3CR_REG(QuadSPI0)
#define QuadSPI0_BFGENCR                         QuadSPI_BFGENCR_REG(QuadSPI0)
#define QuadSPI0_SOCCR                           QuadSPI_SOCCR_REG(QuadSPI0)
#define QuadSPI0_BUF0IND                         QuadSPI_BUF0IND_REG(QuadSPI0)
#define QuadSPI0_BUF1IND                         QuadSPI_BUF1IND_REG(QuadSPI0)
#define QuadSPI0_BUF2IND                         QuadSPI_BUF2IND_REG(QuadSPI0)
#define QuadSPI0_SFAR                            QuadSPI_SFAR_REG(QuadSPI0)
#define QuadSPI0_SFACR                           QuadSPI_SFACR_REG(QuadSPI0)
#define QuadSPI0_SMPR                            QuadSPI_SMPR_REG(QuadSPI0)
#define QuadSPI0_RBSR                            QuadSPI_RBSR_REG(QuadSPI0)
#define QuadSPI0_RBCT                            QuadSPI_RBCT_REG(QuadSPI0)
#define QuadSPI0_TBSR                            QuadSPI_TBSR_REG(QuadSPI0)
#define QuadSPI0_TBDR                            QuadSPI_TBDR_REG(QuadSPI0)
#define QuadSPI0_TBCT                            QuadSPI_TBCT_REG(QuadSPI0)
#define QuadSPI0_SR                              QuadSPI_SR_REG(QuadSPI0)
#define QuadSPI0_FR                              QuadSPI_FR_REG(QuadSPI0)
#define QuadSPI0_RSER                            QuadSPI_RSER_REG(QuadSPI0)
#define QuadSPI0_SPNDST                          QuadSPI_SPNDST_REG(QuadSPI0)
#define QuadSPI0_SPTRCLR                         QuadSPI_SPTRCLR_REG(QuadSPI0)
#define QuadSPI0_SFA1AD                          QuadSPI_SFA1AD_REG(QuadSPI0)
#define QuadSPI0_SFA2AD                          QuadSPI_SFA2AD_REG(QuadSPI0)
#define QuadSPI0_SFB1AD                          QuadSPI_SFB1AD_REG(QuadSPI0)
#define QuadSPI0_SFB2AD                          QuadSPI_SFB2AD_REG(QuadSPI0)
#define QuadSPI0_DLPR                            QuadSPI_DLPR_REG(QuadSPI0)
#define QuadSPI0_RBDR0                           QuadSPI_RBDR_REG(QuadSPI0,0)
#define QuadSPI0_RBDR1                           QuadSPI_RBDR_REG(QuadSPI0,1)
#define QuadSPI0_RBDR2                           QuadSPI_RBDR_REG(QuadSPI0,2)
#define QuadSPI0_RBDR3                           QuadSPI_RBDR_REG(QuadSPI0,3)
#define QuadSPI0_RBDR4                           QuadSPI_RBDR_REG(QuadSPI0,4)
#define QuadSPI0_RBDR5                           QuadSPI_RBDR_REG(QuadSPI0,5)
#define QuadSPI0_RBDR6                           QuadSPI_RBDR_REG(QuadSPI0,6)
#define QuadSPI0_RBDR7                           QuadSPI_RBDR_REG(QuadSPI0,7)
#define QuadSPI0_RBDR8                           QuadSPI_RBDR_REG(QuadSPI0,8)
#define QuadSPI0_RBDR9                           QuadSPI_RBDR_REG(QuadSPI0,9)
#define QuadSPI0_RBDR10                          QuadSPI_RBDR_REG(QuadSPI0,10)
#define QuadSPI0_RBDR11                          QuadSPI_RBDR_REG(QuadSPI0,11)
#define QuadSPI0_RBDR12                          QuadSPI_RBDR_REG(QuadSPI0,12)
#define QuadSPI0_RBDR13                          QuadSPI_RBDR_REG(QuadSPI0,13)
#define QuadSPI0_RBDR14                          QuadSPI_RBDR_REG(QuadSPI0,14)
#define QuadSPI0_RBDR15                          QuadSPI_RBDR_REG(QuadSPI0,15)
#define QuadSPI0_LUTKEY                          QuadSPI_LUTKEY_REG(QuadSPI0)
#define QuadSPI0_LCKCR                           QuadSPI_LCKCR_REG(QuadSPI0)
#define QuadSPI0_LUT0                            QuadSPI_LUT_REG(QuadSPI0,0)
#define QuadSPI0_LUT1                            QuadSPI_LUT_REG(QuadSPI0,1)
#define QuadSPI0_LUT2                            QuadSPI_LUT_REG(QuadSPI0,2)
#define QuadSPI0_LUT3                            QuadSPI_LUT_REG(QuadSPI0,3)
#define QuadSPI0_LUT4                            QuadSPI_LUT_REG(QuadSPI0,4)
#define QuadSPI0_LUT5                            QuadSPI_LUT_REG(QuadSPI0,5)
#define QuadSPI0_LUT6                            QuadSPI_LUT_REG(QuadSPI0,6)
#define QuadSPI0_LUT7                            QuadSPI_LUT_REG(QuadSPI0,7)
#define QuadSPI0_LUT8                            QuadSPI_LUT_REG(QuadSPI0,8)
#define QuadSPI0_LUT9                            QuadSPI_LUT_REG(QuadSPI0,9)
#define QuadSPI0_LUT10                           QuadSPI_LUT_REG(QuadSPI0,10)
#define QuadSPI0_LUT11                           QuadSPI_LUT_REG(QuadSPI0,11)
#define QuadSPI0_LUT12                           QuadSPI_LUT_REG(QuadSPI0,12)
#define QuadSPI0_LUT13                           QuadSPI_LUT_REG(QuadSPI0,13)
#define QuadSPI0_LUT14                           QuadSPI_LUT_REG(QuadSPI0,14)
#define QuadSPI0_LUT15                           QuadSPI_LUT_REG(QuadSPI0,15)
#define QuadSPI0_LUT16                           QuadSPI_LUT_REG(QuadSPI0,16)
#define QuadSPI0_LUT17                           QuadSPI_LUT_REG(QuadSPI0,17)
#define QuadSPI0_LUT18                           QuadSPI_LUT_REG(QuadSPI0,18)
#define QuadSPI0_LUT19                           QuadSPI_LUT_REG(QuadSPI0,19)
#define QuadSPI0_LUT20                           QuadSPI_LUT_REG(QuadSPI0,20)
#define QuadSPI0_LUT21                           QuadSPI_LUT_REG(QuadSPI0,21)
#define QuadSPI0_LUT22                           QuadSPI_LUT_REG(QuadSPI0,22)
#define QuadSPI0_LUT23                           QuadSPI_LUT_REG(QuadSPI0,23)
#define QuadSPI0_LUT24                           QuadSPI_LUT_REG(QuadSPI0,24)
#define QuadSPI0_LUT25                           QuadSPI_LUT_REG(QuadSPI0,25)
#define QuadSPI0_LUT26                           QuadSPI_LUT_REG(QuadSPI0,26)
#define QuadSPI0_LUT27                           QuadSPI_LUT_REG(QuadSPI0,27)
#define QuadSPI0_LUT28                           QuadSPI_LUT_REG(QuadSPI0,28)
#define QuadSPI0_LUT29                           QuadSPI_LUT_REG(QuadSPI0,29)
#define QuadSPI0_LUT30                           QuadSPI_LUT_REG(QuadSPI0,30)
#define QuadSPI0_LUT31                           QuadSPI_LUT_REG(QuadSPI0,31)
#define QuadSPI0_LUT32                           QuadSPI_LUT_REG(QuadSPI0,32)
#define QuadSPI0_LUT33                           QuadSPI_LUT_REG(QuadSPI0,33)
#define QuadSPI0_LUT34                           QuadSPI_LUT_REG(QuadSPI0,34)
#define QuadSPI0_LUT35                           QuadSPI_LUT_REG(QuadSPI0,35)
#define QuadSPI0_LUT36                           QuadSPI_LUT_REG(QuadSPI0,36)
#define QuadSPI0_LUT37                           QuadSPI_LUT_REG(QuadSPI0,37)
#define QuadSPI0_LUT38                           QuadSPI_LUT_REG(QuadSPI0,38)
#define QuadSPI0_LUT39                           QuadSPI_LUT_REG(QuadSPI0,39)
#define QuadSPI0_LUT40                           QuadSPI_LUT_REG(QuadSPI0,40)
#define QuadSPI0_LUT41                           QuadSPI_LUT_REG(QuadSPI0,41)
#define QuadSPI0_LUT42                           QuadSPI_LUT_REG(QuadSPI0,42)
#define QuadSPI0_LUT43                           QuadSPI_LUT_REG(QuadSPI0,43)
#define QuadSPI0_LUT44                           QuadSPI_LUT_REG(QuadSPI0,44)
#define QuadSPI0_LUT45                           QuadSPI_LUT_REG(QuadSPI0,45)
#define QuadSPI0_LUT46                           QuadSPI_LUT_REG(QuadSPI0,46)
#define QuadSPI0_LUT47                           QuadSPI_LUT_REG(QuadSPI0,47)
#define QuadSPI0_LUT48                           QuadSPI_LUT_REG(QuadSPI0,48)
#define QuadSPI0_LUT49                           QuadSPI_LUT_REG(QuadSPI0,49)
#define QuadSPI0_LUT50                           QuadSPI_LUT_REG(QuadSPI0,50)
#define QuadSPI0_LUT51                           QuadSPI_LUT_REG(QuadSPI0,51)
#define QuadSPI0_LUT52                           QuadSPI_LUT_REG(QuadSPI0,52)
#define QuadSPI0_LUT53                           QuadSPI_LUT_REG(QuadSPI0,53)
#define QuadSPI0_LUT54                           QuadSPI_LUT_REG(QuadSPI0,54)
#define QuadSPI0_LUT55                           QuadSPI_LUT_REG(QuadSPI0,55)
#define QuadSPI0_LUT56                           QuadSPI_LUT_REG(QuadSPI0,56)
#define QuadSPI0_LUT57                           QuadSPI_LUT_REG(QuadSPI0,57)
#define QuadSPI0_LUT58                           QuadSPI_LUT_REG(QuadSPI0,58)
#define QuadSPI0_LUT59                           QuadSPI_LUT_REG(QuadSPI0,59)
#define QuadSPI0_LUT60                           QuadSPI_LUT_REG(QuadSPI0,60)
#define QuadSPI0_LUT61                           QuadSPI_LUT_REG(QuadSPI0,61)
#define QuadSPI0_LUT62                           QuadSPI_LUT_REG(QuadSPI0,62)
#define QuadSPI0_LUT63                           QuadSPI_LUT_REG(QuadSPI0,63)

/* QuadSPI - Register array accessors */
#define QuadSPI0_RBDR(index)                     QuadSPI_RBDR_REG(QuadSPI0,index)
#define QuadSPI0_LUT(index)                      QuadSPI_LUT_REG(QuadSPI0,index)

/*!
 * @}
 */ /* end of group QuadSPI_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group QuadSPI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RCM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RCM_Peripheral_Access_Layer RCM Peripheral Access Layer
 * @{
 */

/** RCM - Register Layout Typedef */
typedef struct {
  __I  uint8_t SRS0;                               /**< System Reset Status Register 0, offset: 0x0 */
  __I  uint8_t SRS1;                               /**< System Reset Status Register 1, offset: 0x1 */
       uint8_t RESERVED_0[2];
  __IO uint8_t RPFC;                               /**< Reset Pin Filter Control register, offset: 0x4 */
  __IO uint8_t RPFW;                               /**< Reset Pin Filter Width register, offset: 0x5 */
  __IO uint8_t FM;                                 /**< Force Mode Register, offset: 0x6 */
  __IO uint8_t MR;                                 /**< Mode Register, offset: 0x7 */
  __IO uint8_t SSRS0;                              /**< Sticky System Reset Status Register 0, offset: 0x8 */
  __IO uint8_t SSRS1;                              /**< Sticky System Reset Status Register 1, offset: 0x9 */
} RCM_Type, *RCM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- RCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RCM_Register_Accessor_Macros RCM - Register accessor macros
 * @{
 */


/* RCM - Register accessors */
#define RCM_SRS0_REG(base)                       ((base)->SRS0)
#define RCM_SRS1_REG(base)                       ((base)->SRS1)
#define RCM_RPFC_REG(base)                       ((base)->RPFC)
#define RCM_RPFW_REG(base)                       ((base)->RPFW)
#define RCM_FM_REG(base)                         ((base)->FM)
#define RCM_MR_REG(base)                         ((base)->MR)
#define RCM_SSRS0_REG(base)                      ((base)->SSRS0)
#define RCM_SSRS1_REG(base)                      ((base)->SSRS1)

/*!
 * @}
 */ /* end of group RCM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- RCM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RCM_Register_Masks RCM Register Masks
 * @{
 */

/* SRS0 Bit Fields */
#define RCM_SRS0_WAKEUP_MASK                     0x1u
#define RCM_SRS0_WAKEUP_SHIFT                    0
#define RCM_SRS0_WAKEUP_WIDTH                    1
#define RCM_SRS0_WAKEUP(x)                       (((uint8_t)(((uint8_t)(x))<<RCM_SRS0_WAKEUP_SHIFT))&RCM_SRS0_WAKEUP_MASK)
#define RCM_SRS0_LVD_MASK                        0x2u
#define RCM_SRS0_LVD_SHIFT                       1
#define RCM_SRS0_LVD_WIDTH                       1
#define RCM_SRS0_LVD(x)                          (((uint8_t)(((uint8_t)(x))<<RCM_SRS0_LVD_SHIFT))&RCM_SRS0_LVD_MASK)
#define RCM_SRS0_LOC_MASK                        0x4u
#define RCM_SRS0_LOC_SHIFT                       2
#define RCM_SRS0_LOC_WIDTH                       1
#define RCM_SRS0_LOC(x)                          (((uint8_t)(((uint8_t)(x))<<RCM_SRS0_LOC_SHIFT))&RCM_SRS0_LOC_MASK)
#define RCM_SRS0_LOL_MASK                        0x8u
#define RCM_SRS0_LOL_SHIFT                       3
#define RCM_SRS0_LOL_WIDTH                       1
#define RCM_SRS0_LOL(x)                          (((uint8_t)(((uint8_t)(x))<<RCM_SRS0_LOL_SHIFT))&RCM_SRS0_LOL_MASK)
#define RCM_SRS0_WDOG_MASK                       0x20u
#define RCM_SRS0_WDOG_SHIFT                      5
#define RCM_SRS0_WDOG_WIDTH                      1
#define RCM_SRS0_WDOG(x)                         (((uint8_t)(((uint8_t)(x))<<RCM_SRS0_WDOG_SHIFT))&RCM_SRS0_WDOG_MASK)
#define RCM_SRS0_PIN_MASK                        0x40u
#define RCM_SRS0_PIN_SHIFT                       6
#define RCM_SRS0_PIN_WIDTH                       1
#define RCM_SRS0_PIN(x)                          (((uint8_t)(((uint8_t)(x))<<RCM_SRS0_PIN_SHIFT))&RCM_SRS0_PIN_MASK)
#define RCM_SRS0_POR_MASK                        0x80u
#define RCM_SRS0_POR_SHIFT                       7
#define RCM_SRS0_POR_WIDTH                       1
#define RCM_SRS0_POR(x)                          (((uint8_t)(((uint8_t)(x))<<RCM_SRS0_POR_SHIFT))&RCM_SRS0_POR_MASK)
/* SRS1 Bit Fields */
#define RCM_SRS1_LOCKUP_MASK                     0x2u
#define RCM_SRS1_LOCKUP_SHIFT                    1
#define RCM_SRS1_LOCKUP_WIDTH                    1
#define RCM_SRS1_LOCKUP(x)                       (((uint8_t)(((uint8_t)(x))<<RCM_SRS1_LOCKUP_SHIFT))&RCM_SRS1_LOCKUP_MASK)
#define RCM_SRS1_SW_MASK                         0x4u
#define RCM_SRS1_SW_SHIFT                        2
#define RCM_SRS1_SW_WIDTH                        1
#define RCM_SRS1_SW(x)                           (((uint8_t)(((uint8_t)(x))<<RCM_SRS1_SW_SHIFT))&RCM_SRS1_SW_MASK)
#define RCM_SRS1_MDM_AP_MASK                     0x8u
#define RCM_SRS1_MDM_AP_SHIFT                    3
#define RCM_SRS1_MDM_AP_WIDTH                    1
#define RCM_SRS1_MDM_AP(x)                       (((uint8_t)(((uint8_t)(x))<<RCM_SRS1_MDM_AP_SHIFT))&RCM_SRS1_MDM_AP_MASK)
#define RCM_SRS1_SACKERR_MASK                    0x20u
#define RCM_SRS1_SACKERR_SHIFT                   5
#define RCM_SRS1_SACKERR_WIDTH                   1
#define RCM_SRS1_SACKERR(x)                      (((uint8_t)(((uint8_t)(x))<<RCM_SRS1_SACKERR_SHIFT))&RCM_SRS1_SACKERR_MASK)
/* RPFC Bit Fields */
#define RCM_RPFC_RSTFLTSRW_MASK                  0x3u
#define RCM_RPFC_RSTFLTSRW_SHIFT                 0
#define RCM_RPFC_RSTFLTSRW_WIDTH                 2
#define RCM_RPFC_RSTFLTSRW(x)                    (((uint8_t)(((uint8_t)(x))<<RCM_RPFC_RSTFLTSRW_SHIFT))&RCM_RPFC_RSTFLTSRW_MASK)
#define RCM_RPFC_RSTFLTSS_MASK                   0x4u
#define RCM_RPFC_RSTFLTSS_SHIFT                  2
#define RCM_RPFC_RSTFLTSS_WIDTH                  1
#define RCM_RPFC_RSTFLTSS(x)                     (((uint8_t)(((uint8_t)(x))<<RCM_RPFC_RSTFLTSS_SHIFT))&RCM_RPFC_RSTFLTSS_MASK)
/* RPFW Bit Fields */
#define RCM_RPFW_RSTFLTSEL_MASK                  0x1Fu
#define RCM_RPFW_RSTFLTSEL_SHIFT                 0
#define RCM_RPFW_RSTFLTSEL_WIDTH                 5
#define RCM_RPFW_RSTFLTSEL(x)                    (((uint8_t)(((uint8_t)(x))<<RCM_RPFW_RSTFLTSEL_SHIFT))&RCM_RPFW_RSTFLTSEL_MASK)
/* FM Bit Fields */
#define RCM_FM_FORCEROM_MASK                     0x6u
#define RCM_FM_FORCEROM_SHIFT                    1
#define RCM_FM_FORCEROM_WIDTH                    2
#define RCM_FM_FORCEROM(x)                       (((uint8_t)(((uint8_t)(x))<<RCM_FM_FORCEROM_SHIFT))&RCM_FM_FORCEROM_MASK)
/* MR Bit Fields */
#define RCM_MR_BOOTROM_MASK                      0x6u
#define RCM_MR_BOOTROM_SHIFT                     1
#define RCM_MR_BOOTROM_WIDTH                     2
#define RCM_MR_BOOTROM(x)                        (((uint8_t)(((uint8_t)(x))<<RCM_MR_BOOTROM_SHIFT))&RCM_MR_BOOTROM_MASK)
/* SSRS0 Bit Fields */
#define RCM_SSRS0_SWAKEUP_MASK                   0x1u
#define RCM_SSRS0_SWAKEUP_SHIFT                  0
#define RCM_SSRS0_SWAKEUP_WIDTH                  1
#define RCM_SSRS0_SWAKEUP(x)                     (((uint8_t)(((uint8_t)(x))<<RCM_SSRS0_SWAKEUP_SHIFT))&RCM_SSRS0_SWAKEUP_MASK)
#define RCM_SSRS0_SLVD_MASK                      0x2u
#define RCM_SSRS0_SLVD_SHIFT                     1
#define RCM_SSRS0_SLVD_WIDTH                     1
#define RCM_SSRS0_SLVD(x)                        (((uint8_t)(((uint8_t)(x))<<RCM_SSRS0_SLVD_SHIFT))&RCM_SSRS0_SLVD_MASK)
#define RCM_SSRS0_SLOC_MASK                      0x4u
#define RCM_SSRS0_SLOC_SHIFT                     2
#define RCM_SSRS0_SLOC_WIDTH                     1
#define RCM_SSRS0_SLOC(x)                        (((uint8_t)(((uint8_t)(x))<<RCM_SSRS0_SLOC_SHIFT))&RCM_SSRS0_SLOC_MASK)
#define RCM_SSRS0_SLOL_MASK                      0x8u
#define RCM_SSRS0_SLOL_SHIFT                     3
#define RCM_SSRS0_SLOL_WIDTH                     1
#define RCM_SSRS0_SLOL(x)                        (((uint8_t)(((uint8_t)(x))<<RCM_SSRS0_SLOL_SHIFT))&RCM_SSRS0_SLOL_MASK)
#define RCM_SSRS0_SWDOG_MASK                     0x20u
#define RCM_SSRS0_SWDOG_SHIFT                    5
#define RCM_SSRS0_SWDOG_WIDTH                    1
#define RCM_SSRS0_SWDOG(x)                       (((uint8_t)(((uint8_t)(x))<<RCM_SSRS0_SWDOG_SHIFT))&RCM_SSRS0_SWDOG_MASK)
#define RCM_SSRS0_SPIN_MASK                      0x40u
#define RCM_SSRS0_SPIN_SHIFT                     6
#define RCM_SSRS0_SPIN_WIDTH                     1
#define RCM_SSRS0_SPIN(x)                        (((uint8_t)(((uint8_t)(x))<<RCM_SSRS0_SPIN_SHIFT))&RCM_SSRS0_SPIN_MASK)
#define RCM_SSRS0_SPOR_MASK                      0x80u
#define RCM_SSRS0_SPOR_SHIFT                     7
#define RCM_SSRS0_SPOR_WIDTH                     1
#define RCM_SSRS0_SPOR(x)                        (((uint8_t)(((uint8_t)(x))<<RCM_SSRS0_SPOR_SHIFT))&RCM_SSRS0_SPOR_MASK)
/* SSRS1 Bit Fields */
#define RCM_SSRS1_SLOCKUP_MASK                   0x2u
#define RCM_SSRS1_SLOCKUP_SHIFT                  1
#define RCM_SSRS1_SLOCKUP_WIDTH                  1
#define RCM_SSRS1_SLOCKUP(x)                     (((uint8_t)(((uint8_t)(x))<<RCM_SSRS1_SLOCKUP_SHIFT))&RCM_SSRS1_SLOCKUP_MASK)
#define RCM_SSRS1_SSW_MASK                       0x4u
#define RCM_SSRS1_SSW_SHIFT                      2
#define RCM_SSRS1_SSW_WIDTH                      1
#define RCM_SSRS1_SSW(x)                         (((uint8_t)(((uint8_t)(x))<<RCM_SSRS1_SSW_SHIFT))&RCM_SSRS1_SSW_MASK)
#define RCM_SSRS1_SMDM_AP_MASK                   0x8u
#define RCM_SSRS1_SMDM_AP_SHIFT                  3
#define RCM_SSRS1_SMDM_AP_WIDTH                  1
#define RCM_SSRS1_SMDM_AP(x)                     (((uint8_t)(((uint8_t)(x))<<RCM_SSRS1_SMDM_AP_SHIFT))&RCM_SSRS1_SMDM_AP_MASK)
#define RCM_SSRS1_SSACKERR_MASK                  0x20u
#define RCM_SSRS1_SSACKERR_SHIFT                 5
#define RCM_SSRS1_SSACKERR_WIDTH                 1
#define RCM_SSRS1_SSACKERR(x)                    (((uint8_t)(((uint8_t)(x))<<RCM_SSRS1_SSACKERR_SHIFT))&RCM_SSRS1_SSACKERR_MASK)

/*!
 * @}
 */ /* end of group RCM_Register_Masks */


/* RCM - Peripheral instance base addresses */
/** Peripheral RCM base address */
#define RCM_BASE                                 (0x4007F000u)
/** Peripheral RCM base pointer */
#define RCM                                      ((RCM_Type *)RCM_BASE)
#define RCM_BASE_PTR                             (RCM)
/** Array initializer of RCM peripheral base addresses */
#define RCM_BASE_ADDRS                           { RCM_BASE }
/** Array initializer of RCM peripheral base pointers */
#define RCM_BASE_PTRS                            { RCM }

/* ----------------------------------------------------------------------------
   -- RCM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RCM_Register_Accessor_Macros RCM - Register accessor macros
 * @{
 */


/* RCM - Register instance definitions */
/* RCM */
#define RCM_SRS0                                 RCM_SRS0_REG(RCM)
#define RCM_SRS1                                 RCM_SRS1_REG(RCM)
#define RCM_RPFC                                 RCM_RPFC_REG(RCM)
#define RCM_RPFW                                 RCM_RPFW_REG(RCM)
#define RCM_FM                                   RCM_FM_REG(RCM)
#define RCM_MR                                   RCM_MR_REG(RCM)
#define RCM_SSRS0                                RCM_SSRS0_REG(RCM)
#define RCM_SSRS1                                RCM_SSRS1_REG(RCM)

/*!
 * @}
 */ /* end of group RCM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group RCM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RFSYS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RFSYS_Peripheral_Access_Layer RFSYS Peripheral Access Layer
 * @{
 */

/** RFSYS - Register Layout Typedef */
typedef struct {
  __IO uint32_t REG[8];                            /**< Register file register, array offset: 0x0, array step: 0x4 */
} RFSYS_Type, *RFSYS_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- RFSYS - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RFSYS_Register_Accessor_Macros RFSYS - Register accessor macros
 * @{
 */


/* RFSYS - Register accessors */
#define RFSYS_REG_REG(base,index)                ((base)->REG[index])
#define RFSYS_REG_COUNT                          8

/*!
 * @}
 */ /* end of group RFSYS_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- RFSYS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RFSYS_Register_Masks RFSYS Register Masks
 * @{
 */

/* REG Bit Fields */
#define RFSYS_REG_LL_MASK                        0xFFu
#define RFSYS_REG_LL_SHIFT                       0
#define RFSYS_REG_LL_WIDTH                       8
#define RFSYS_REG_LL(x)                          (((uint32_t)(((uint32_t)(x))<<RFSYS_REG_LL_SHIFT))&RFSYS_REG_LL_MASK)
#define RFSYS_REG_LH_MASK                        0xFF00u
#define RFSYS_REG_LH_SHIFT                       8
#define RFSYS_REG_LH_WIDTH                       8
#define RFSYS_REG_LH(x)                          (((uint32_t)(((uint32_t)(x))<<RFSYS_REG_LH_SHIFT))&RFSYS_REG_LH_MASK)
#define RFSYS_REG_HL_MASK                        0xFF0000u
#define RFSYS_REG_HL_SHIFT                       16
#define RFSYS_REG_HL_WIDTH                       8
#define RFSYS_REG_HL(x)                          (((uint32_t)(((uint32_t)(x))<<RFSYS_REG_HL_SHIFT))&RFSYS_REG_HL_MASK)
#define RFSYS_REG_HH_MASK                        0xFF000000u
#define RFSYS_REG_HH_SHIFT                       24
#define RFSYS_REG_HH_WIDTH                       8
#define RFSYS_REG_HH(x)                          (((uint32_t)(((uint32_t)(x))<<RFSYS_REG_HH_SHIFT))&RFSYS_REG_HH_MASK)

/*!
 * @}
 */ /* end of group RFSYS_Register_Masks */


/* RFSYS - Peripheral instance base addresses */
/** Peripheral RFSYS base address */
#define RFSYS_BASE                               (0x40041000u)
/** Peripheral RFSYS base pointer */
#define RFSYS                                    ((RFSYS_Type *)RFSYS_BASE)
#define RFSYS_BASE_PTR                           (RFSYS)
/** Array initializer of RFSYS peripheral base addresses */
#define RFSYS_BASE_ADDRS                         { RFSYS_BASE }
/** Array initializer of RFSYS peripheral base pointers */
#define RFSYS_BASE_PTRS                          { RFSYS }

/* ----------------------------------------------------------------------------
   -- RFSYS - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RFSYS_Register_Accessor_Macros RFSYS - Register accessor macros
 * @{
 */


/* RFSYS - Register instance definitions */
/* RFSYS */
#define RFSYS_REG0                               RFSYS_REG_REG(RFSYS,0)
#define RFSYS_REG1                               RFSYS_REG_REG(RFSYS,1)
#define RFSYS_REG2                               RFSYS_REG_REG(RFSYS,2)
#define RFSYS_REG3                               RFSYS_REG_REG(RFSYS,3)
#define RFSYS_REG4                               RFSYS_REG_REG(RFSYS,4)
#define RFSYS_REG5                               RFSYS_REG_REG(RFSYS,5)
#define RFSYS_REG6                               RFSYS_REG_REG(RFSYS,6)
#define RFSYS_REG7                               RFSYS_REG_REG(RFSYS,7)

/* RFSYS - Register array accessors */
#define RFSYS_REG(index)                         RFSYS_REG_REG(RFSYS,index)

/*!
 * @}
 */ /* end of group RFSYS_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group RFSYS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RFVBAT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RFVBAT_Peripheral_Access_Layer RFVBAT Peripheral Access Layer
 * @{
 */

/** RFVBAT - Register Layout Typedef */
typedef struct {
  __IO uint32_t REG[8];                            /**< VBAT register file register, array offset: 0x0, array step: 0x4 */
} RFVBAT_Type, *RFVBAT_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- RFVBAT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RFVBAT_Register_Accessor_Macros RFVBAT - Register accessor macros
 * @{
 */


/* RFVBAT - Register accessors */
#define RFVBAT_REG_REG(base,index)               ((base)->REG[index])
#define RFVBAT_REG_COUNT                         8

/*!
 * @}
 */ /* end of group RFVBAT_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- RFVBAT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RFVBAT_Register_Masks RFVBAT Register Masks
 * @{
 */

/* REG Bit Fields */
#define RFVBAT_REG_LL_MASK                       0xFFu
#define RFVBAT_REG_LL_SHIFT                      0
#define RFVBAT_REG_LL_WIDTH                      8
#define RFVBAT_REG_LL(x)                         (((uint32_t)(((uint32_t)(x))<<RFVBAT_REG_LL_SHIFT))&RFVBAT_REG_LL_MASK)
#define RFVBAT_REG_LH_MASK                       0xFF00u
#define RFVBAT_REG_LH_SHIFT                      8
#define RFVBAT_REG_LH_WIDTH                      8
#define RFVBAT_REG_LH(x)                         (((uint32_t)(((uint32_t)(x))<<RFVBAT_REG_LH_SHIFT))&RFVBAT_REG_LH_MASK)
#define RFVBAT_REG_HL_MASK                       0xFF0000u
#define RFVBAT_REG_HL_SHIFT                      16
#define RFVBAT_REG_HL_WIDTH                      8
#define RFVBAT_REG_HL(x)                         (((uint32_t)(((uint32_t)(x))<<RFVBAT_REG_HL_SHIFT))&RFVBAT_REG_HL_MASK)
#define RFVBAT_REG_HH_MASK                       0xFF000000u
#define RFVBAT_REG_HH_SHIFT                      24
#define RFVBAT_REG_HH_WIDTH                      8
#define RFVBAT_REG_HH(x)                         (((uint32_t)(((uint32_t)(x))<<RFVBAT_REG_HH_SHIFT))&RFVBAT_REG_HH_MASK)

/*!
 * @}
 */ /* end of group RFVBAT_Register_Masks */


/* RFVBAT - Peripheral instance base addresses */
/** Peripheral RFVBAT base address */
#define RFVBAT_BASE                              (0x4003E000u)
/** Peripheral RFVBAT base pointer */
#define RFVBAT                                   ((RFVBAT_Type *)RFVBAT_BASE)
#define RFVBAT_BASE_PTR                          (RFVBAT)
/** Array initializer of RFVBAT peripheral base addresses */
#define RFVBAT_BASE_ADDRS                        { RFVBAT_BASE }
/** Array initializer of RFVBAT peripheral base pointers */
#define RFVBAT_BASE_PTRS                         { RFVBAT }

/* ----------------------------------------------------------------------------
   -- RFVBAT - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RFVBAT_Register_Accessor_Macros RFVBAT - Register accessor macros
 * @{
 */


/* RFVBAT - Register instance definitions */
/* RFVBAT */
#define RFVBAT_REG0                              RFVBAT_REG_REG(RFVBAT,0)
#define RFVBAT_REG1                              RFVBAT_REG_REG(RFVBAT,1)
#define RFVBAT_REG2                              RFVBAT_REG_REG(RFVBAT,2)
#define RFVBAT_REG3                              RFVBAT_REG_REG(RFVBAT,3)
#define RFVBAT_REG4                              RFVBAT_REG_REG(RFVBAT,4)
#define RFVBAT_REG5                              RFVBAT_REG_REG(RFVBAT,5)
#define RFVBAT_REG6                              RFVBAT_REG_REG(RFVBAT,6)
#define RFVBAT_REG7                              RFVBAT_REG_REG(RFVBAT,7)

/* RFVBAT - Register array accessors */
#define RFVBAT_REG(index)                        RFVBAT_REG_REG(RFVBAT,index)

/*!
 * @}
 */ /* end of group RFVBAT_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group RFVBAT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ROM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ROM_Peripheral_Access_Layer ROM Peripheral Access Layer
 * @{
 */

/** ROM - Register Layout Typedef */
typedef struct {
  __I  uint32_t ENTRY[3];                          /**< Entry, array offset: 0x0, array step: 0x4 */
  __I  uint32_t TABLEMARK;                         /**< End of Table Marker Register, offset: 0xC */
       uint8_t RESERVED_0[4028];
  __I  uint32_t SYSACCESS;                         /**< System Access Register, offset: 0xFCC */
  __I  uint32_t PERIPHID4;                         /**< Peripheral ID Register, offset: 0xFD0 */
  __I  uint32_t PERIPHID5;                         /**< Peripheral ID Register, offset: 0xFD4 */
  __I  uint32_t PERIPHID6;                         /**< Peripheral ID Register, offset: 0xFD8 */
  __I  uint32_t PERIPHID7;                         /**< Peripheral ID Register, offset: 0xFDC */
  __I  uint32_t PERIPHID0;                         /**< Peripheral ID Register, offset: 0xFE0 */
  __I  uint32_t PERIPHID1;                         /**< Peripheral ID Register, offset: 0xFE4 */
  __I  uint32_t PERIPHID2;                         /**< Peripheral ID Register, offset: 0xFE8 */
  __I  uint32_t PERIPHID3;                         /**< Peripheral ID Register, offset: 0xFEC */
  __I  uint32_t COMPID[4];                         /**< Component ID Register, array offset: 0xFF0, array step: 0x4 */
} ROM_Type, *ROM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- ROM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ROM_Register_Accessor_Macros ROM - Register accessor macros
 * @{
 */


/* ROM - Register accessors */
#define ROM_ENTRY_REG(base,index)                ((base)->ENTRY[index])
#define ROM_ENTRY_COUNT                          3
#define ROM_TABLEMARK_REG(base)                  ((base)->TABLEMARK)
#define ROM_SYSACCESS_REG(base)                  ((base)->SYSACCESS)
#define ROM_PERIPHID4_REG(base)                  ((base)->PERIPHID4)
#define ROM_PERIPHID5_REG(base)                  ((base)->PERIPHID5)
#define ROM_PERIPHID6_REG(base)                  ((base)->PERIPHID6)
#define ROM_PERIPHID7_REG(base)                  ((base)->PERIPHID7)
#define ROM_PERIPHID0_REG(base)                  ((base)->PERIPHID0)
#define ROM_PERIPHID1_REG(base)                  ((base)->PERIPHID1)
#define ROM_PERIPHID2_REG(base)                  ((base)->PERIPHID2)
#define ROM_PERIPHID3_REG(base)                  ((base)->PERIPHID3)
#define ROM_COMPID_REG(base,index)               ((base)->COMPID[index])
#define ROM_COMPID_COUNT                         4

/*!
 * @}
 */ /* end of group ROM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- ROM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ROM_Register_Masks ROM Register Masks
 * @{
 */

/* ENTRY Bit Fields */
#define ROM_ENTRY_ENTRY_MASK                     0xFFFFFFFFu
#define ROM_ENTRY_ENTRY_SHIFT                    0
#define ROM_ENTRY_ENTRY_WIDTH                    32
#define ROM_ENTRY_ENTRY(x)                       (((uint32_t)(((uint32_t)(x))<<ROM_ENTRY_ENTRY_SHIFT))&ROM_ENTRY_ENTRY_MASK)
/* TABLEMARK Bit Fields */
#define ROM_TABLEMARK_MARK_MASK                  0xFFFFFFFFu
#define ROM_TABLEMARK_MARK_SHIFT                 0
#define ROM_TABLEMARK_MARK_WIDTH                 32
#define ROM_TABLEMARK_MARK(x)                    (((uint32_t)(((uint32_t)(x))<<ROM_TABLEMARK_MARK_SHIFT))&ROM_TABLEMARK_MARK_MASK)
/* SYSACCESS Bit Fields */
#define ROM_SYSACCESS_SYSACCESS_MASK             0xFFFFFFFFu
#define ROM_SYSACCESS_SYSACCESS_SHIFT            0
#define ROM_SYSACCESS_SYSACCESS_WIDTH            32
#define ROM_SYSACCESS_SYSACCESS(x)               (((uint32_t)(((uint32_t)(x))<<ROM_SYSACCESS_SYSACCESS_SHIFT))&ROM_SYSACCESS_SYSACCESS_MASK)
/* PERIPHID4 Bit Fields */
#define ROM_PERIPHID4_PERIPHID_MASK              0xFFFFFFFFu
#define ROM_PERIPHID4_PERIPHID_SHIFT             0
#define ROM_PERIPHID4_PERIPHID_WIDTH             32
#define ROM_PERIPHID4_PERIPHID(x)                (((uint32_t)(((uint32_t)(x))<<ROM_PERIPHID4_PERIPHID_SHIFT))&ROM_PERIPHID4_PERIPHID_MASK)
/* PERIPHID5 Bit Fields */
#define ROM_PERIPHID5_PERIPHID_MASK              0xFFFFFFFFu
#define ROM_PERIPHID5_PERIPHID_SHIFT             0
#define ROM_PERIPHID5_PERIPHID_WIDTH             32
#define ROM_PERIPHID5_PERIPHID(x)                (((uint32_t)(((uint32_t)(x))<<ROM_PERIPHID5_PERIPHID_SHIFT))&ROM_PERIPHID5_PERIPHID_MASK)
/* PERIPHID6 Bit Fields */
#define ROM_PERIPHID6_PERIPHID_MASK              0xFFFFFFFFu
#define ROM_PERIPHID6_PERIPHID_SHIFT             0
#define ROM_PERIPHID6_PERIPHID_WIDTH             32
#define ROM_PERIPHID6_PERIPHID(x)                (((uint32_t)(((uint32_t)(x))<<ROM_PERIPHID6_PERIPHID_SHIFT))&ROM_PERIPHID6_PERIPHID_MASK)
/* PERIPHID7 Bit Fields */
#define ROM_PERIPHID7_PERIPHID_MASK              0xFFFFFFFFu
#define ROM_PERIPHID7_PERIPHID_SHIFT             0
#define ROM_PERIPHID7_PERIPHID_WIDTH             32
#define ROM_PERIPHID7_PERIPHID(x)                (((uint32_t)(((uint32_t)(x))<<ROM_PERIPHID7_PERIPHID_SHIFT))&ROM_PERIPHID7_PERIPHID_MASK)
/* PERIPHID0 Bit Fields */
#define ROM_PERIPHID0_PERIPHID_MASK              0xFFFFFFFFu
#define ROM_PERIPHID0_PERIPHID_SHIFT             0
#define ROM_PERIPHID0_PERIPHID_WIDTH             32
#define ROM_PERIPHID0_PERIPHID(x)                (((uint32_t)(((uint32_t)(x))<<ROM_PERIPHID0_PERIPHID_SHIFT))&ROM_PERIPHID0_PERIPHID_MASK)
/* PERIPHID1 Bit Fields */
#define ROM_PERIPHID1_PERIPHID_MASK              0xFFFFFFFFu
#define ROM_PERIPHID1_PERIPHID_SHIFT             0
#define ROM_PERIPHID1_PERIPHID_WIDTH             32
#define ROM_PERIPHID1_PERIPHID(x)                (((uint32_t)(((uint32_t)(x))<<ROM_PERIPHID1_PERIPHID_SHIFT))&ROM_PERIPHID1_PERIPHID_MASK)
/* PERIPHID2 Bit Fields */
#define ROM_PERIPHID2_PERIPHID_MASK              0xFFFFFFFFu
#define ROM_PERIPHID2_PERIPHID_SHIFT             0
#define ROM_PERIPHID2_PERIPHID_WIDTH             32
#define ROM_PERIPHID2_PERIPHID(x)                (((uint32_t)(((uint32_t)(x))<<ROM_PERIPHID2_PERIPHID_SHIFT))&ROM_PERIPHID2_PERIPHID_MASK)
/* PERIPHID3 Bit Fields */
#define ROM_PERIPHID3_PERIPHID_MASK              0xFFFFFFFFu
#define ROM_PERIPHID3_PERIPHID_SHIFT             0
#define ROM_PERIPHID3_PERIPHID_WIDTH             32
#define ROM_PERIPHID3_PERIPHID(x)                (((uint32_t)(((uint32_t)(x))<<ROM_PERIPHID3_PERIPHID_SHIFT))&ROM_PERIPHID3_PERIPHID_MASK)
/* COMPID Bit Fields */
#define ROM_COMPID_COMPID_MASK                   0xFFFFFFFFu
#define ROM_COMPID_COMPID_SHIFT                  0
#define ROM_COMPID_COMPID_WIDTH                  32
#define ROM_COMPID_COMPID(x)                     (((uint32_t)(((uint32_t)(x))<<ROM_COMPID_COMPID_SHIFT))&ROM_COMPID_COMPID_MASK)

/*!
 * @}
 */ /* end of group ROM_Register_Masks */


/* ROM - Peripheral instance base addresses */
/** Peripheral ROM base address */
#define ROM_BASE                                 (0xF0002000u)
/** Peripheral ROM base pointer */
#define ROM                                      ((ROM_Type *)ROM_BASE)
#define ROM_BASE_PTR                             (ROM)
/** Array initializer of ROM peripheral base addresses */
#define ROM_BASE_ADDRS                           { ROM_BASE }
/** Array initializer of ROM peripheral base pointers */
#define ROM_BASE_PTRS                            { ROM }

/* ----------------------------------------------------------------------------
   -- ROM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ROM_Register_Accessor_Macros ROM - Register accessor macros
 * @{
 */


/* ROM - Register instance definitions */
/* ROM */
#define ROM_ENTRY0                               ROM_ENTRY_REG(ROM,0)
#define ROM_ENTRY1                               ROM_ENTRY_REG(ROM,1)
#define ROM_ENTRY2                               ROM_ENTRY_REG(ROM,2)
#define ROM_TABLEMARK                            ROM_TABLEMARK_REG(ROM)
#define ROM_SYSACCESS                            ROM_SYSACCESS_REG(ROM)
#define ROM_PERIPHID4                            ROM_PERIPHID4_REG(ROM)
#define ROM_PERIPHID5                            ROM_PERIPHID5_REG(ROM)
#define ROM_PERIPHID6                            ROM_PERIPHID6_REG(ROM)
#define ROM_PERIPHID7                            ROM_PERIPHID7_REG(ROM)
#define ROM_PERIPHID0                            ROM_PERIPHID0_REG(ROM)
#define ROM_PERIPHID1                            ROM_PERIPHID1_REG(ROM)
#define ROM_PERIPHID2                            ROM_PERIPHID2_REG(ROM)
#define ROM_PERIPHID3                            ROM_PERIPHID3_REG(ROM)
#define ROM_COMPID0                              ROM_COMPID_REG(ROM,0)
#define ROM_COMPID1                              ROM_COMPID_REG(ROM,1)
#define ROM_COMPID2                              ROM_COMPID_REG(ROM,2)
#define ROM_COMPID3                              ROM_COMPID_REG(ROM,3)

/* ROM - Register array accessors */
#define ROM_ENTRY(index)                         ROM_ENTRY_REG(ROM,index)
#define ROM_COMPID(index)                        ROM_COMPID_REG(ROM,index)

/*!
 * @}
 */ /* end of group ROM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group ROM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RTC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Peripheral_Access_Layer RTC Peripheral Access Layer
 * @{
 */

/** RTC - Register Layout Typedef */
typedef struct {
  __IO uint32_t TSR;                               /**< RTC Time Seconds Register, offset: 0x0 */
  __IO uint32_t TPR;                               /**< RTC Time Prescaler Register, offset: 0x4 */
  __IO uint32_t TAR;                               /**< RTC Time Alarm Register, offset: 0x8 */
  __IO uint32_t TCR;                               /**< RTC Time Compensation Register, offset: 0xC */
  __IO uint32_t CR;                                /**< RTC Control Register, offset: 0x10 */
  __IO uint32_t SR;                                /**< RTC Status Register, offset: 0x14 */
  __IO uint32_t LR;                                /**< RTC Lock Register, offset: 0x18 */
  __IO uint32_t IER;                               /**< RTC Interrupt Enable Register, offset: 0x1C */
       uint8_t RESERVED_0[2016];
  __IO uint32_t WAR;                               /**< RTC Write Access Register, offset: 0x800 */
  __IO uint32_t RAR;                               /**< RTC Read Access Register, offset: 0x804 */
} RTC_Type, *RTC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- RTC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Register_Accessor_Macros RTC - Register accessor macros
 * @{
 */


/* RTC - Register accessors */
#define RTC_TSR_REG(base)                        ((base)->TSR)
#define RTC_TPR_REG(base)                        ((base)->TPR)
#define RTC_TAR_REG(base)                        ((base)->TAR)
#define RTC_TCR_REG(base)                        ((base)->TCR)
#define RTC_CR_REG(base)                         ((base)->CR)
#define RTC_SR_REG(base)                         ((base)->SR)
#define RTC_LR_REG(base)                         ((base)->LR)
#define RTC_IER_REG(base)                        ((base)->IER)
#define RTC_WAR_REG(base)                        ((base)->WAR)
#define RTC_RAR_REG(base)                        ((base)->RAR)

/*!
 * @}
 */ /* end of group RTC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- RTC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Register_Masks RTC Register Masks
 * @{
 */

/* TSR Bit Fields */
#define RTC_TSR_TSR_MASK                         0xFFFFFFFFu
#define RTC_TSR_TSR_SHIFT                        0
#define RTC_TSR_TSR_WIDTH                        32
#define RTC_TSR_TSR(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_TSR_TSR_SHIFT))&RTC_TSR_TSR_MASK)
/* TPR Bit Fields */
#define RTC_TPR_TPR_MASK                         0xFFFFu
#define RTC_TPR_TPR_SHIFT                        0
#define RTC_TPR_TPR_WIDTH                        16
#define RTC_TPR_TPR(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_TPR_TPR_SHIFT))&RTC_TPR_TPR_MASK)
/* TAR Bit Fields */
#define RTC_TAR_TAR_MASK                         0xFFFFFFFFu
#define RTC_TAR_TAR_SHIFT                        0
#define RTC_TAR_TAR_WIDTH                        32
#define RTC_TAR_TAR(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_TAR_TAR_SHIFT))&RTC_TAR_TAR_MASK)
/* TCR Bit Fields */
#define RTC_TCR_TCR_MASK                         0xFFu
#define RTC_TCR_TCR_SHIFT                        0
#define RTC_TCR_TCR_WIDTH                        8
#define RTC_TCR_TCR(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_TCR_TCR_SHIFT))&RTC_TCR_TCR_MASK)
#define RTC_TCR_CIR_MASK                         0xFF00u
#define RTC_TCR_CIR_SHIFT                        8
#define RTC_TCR_CIR_WIDTH                        8
#define RTC_TCR_CIR(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_TCR_CIR_SHIFT))&RTC_TCR_CIR_MASK)
#define RTC_TCR_TCV_MASK                         0xFF0000u
#define RTC_TCR_TCV_SHIFT                        16
#define RTC_TCR_TCV_WIDTH                        8
#define RTC_TCR_TCV(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_TCR_TCV_SHIFT))&RTC_TCR_TCV_MASK)
#define RTC_TCR_CIC_MASK                         0xFF000000u
#define RTC_TCR_CIC_SHIFT                        24
#define RTC_TCR_CIC_WIDTH                        8
#define RTC_TCR_CIC(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_TCR_CIC_SHIFT))&RTC_TCR_CIC_MASK)
/* CR Bit Fields */
#define RTC_CR_SWR_MASK                          0x1u
#define RTC_CR_SWR_SHIFT                         0
#define RTC_CR_SWR_WIDTH                         1
#define RTC_CR_SWR(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_CR_SWR_SHIFT))&RTC_CR_SWR_MASK)
#define RTC_CR_WPE_MASK                          0x2u
#define RTC_CR_WPE_SHIFT                         1
#define RTC_CR_WPE_WIDTH                         1
#define RTC_CR_WPE(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_CR_WPE_SHIFT))&RTC_CR_WPE_MASK)
#define RTC_CR_SUP_MASK                          0x4u
#define RTC_CR_SUP_SHIFT                         2
#define RTC_CR_SUP_WIDTH                         1
#define RTC_CR_SUP(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_CR_SUP_SHIFT))&RTC_CR_SUP_MASK)
#define RTC_CR_UM_MASK                           0x8u
#define RTC_CR_UM_SHIFT                          3
#define RTC_CR_UM_WIDTH                          1
#define RTC_CR_UM(x)                             (((uint32_t)(((uint32_t)(x))<<RTC_CR_UM_SHIFT))&RTC_CR_UM_MASK)
#define RTC_CR_WPS_MASK                          0x10u
#define RTC_CR_WPS_SHIFT                         4
#define RTC_CR_WPS_WIDTH                         1
#define RTC_CR_WPS(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_CR_WPS_SHIFT))&RTC_CR_WPS_MASK)
#define RTC_CR_OSCE_MASK                         0x100u
#define RTC_CR_OSCE_SHIFT                        8
#define RTC_CR_OSCE_WIDTH                        1
#define RTC_CR_OSCE(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_CR_OSCE_SHIFT))&RTC_CR_OSCE_MASK)
#define RTC_CR_CLKO_MASK                         0x200u
#define RTC_CR_CLKO_SHIFT                        9
#define RTC_CR_CLKO_WIDTH                        1
#define RTC_CR_CLKO(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_CR_CLKO_SHIFT))&RTC_CR_CLKO_MASK)
#define RTC_CR_SC16P_MASK                        0x400u
#define RTC_CR_SC16P_SHIFT                       10
#define RTC_CR_SC16P_WIDTH                       1
#define RTC_CR_SC16P(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_CR_SC16P_SHIFT))&RTC_CR_SC16P_MASK)
#define RTC_CR_SC8P_MASK                         0x800u
#define RTC_CR_SC8P_SHIFT                        11
#define RTC_CR_SC8P_WIDTH                        1
#define RTC_CR_SC8P(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_CR_SC8P_SHIFT))&RTC_CR_SC8P_MASK)
#define RTC_CR_SC4P_MASK                         0x1000u
#define RTC_CR_SC4P_SHIFT                        12
#define RTC_CR_SC4P_WIDTH                        1
#define RTC_CR_SC4P(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_CR_SC4P_SHIFT))&RTC_CR_SC4P_MASK)
#define RTC_CR_SC2P_MASK                         0x2000u
#define RTC_CR_SC2P_SHIFT                        13
#define RTC_CR_SC2P_WIDTH                        1
#define RTC_CR_SC2P(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_CR_SC2P_SHIFT))&RTC_CR_SC2P_MASK)
/* SR Bit Fields */
#define RTC_SR_TIF_MASK                          0x1u
#define RTC_SR_TIF_SHIFT                         0
#define RTC_SR_TIF_WIDTH                         1
#define RTC_SR_TIF(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_SR_TIF_SHIFT))&RTC_SR_TIF_MASK)
#define RTC_SR_TOF_MASK                          0x2u
#define RTC_SR_TOF_SHIFT                         1
#define RTC_SR_TOF_WIDTH                         1
#define RTC_SR_TOF(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_SR_TOF_SHIFT))&RTC_SR_TOF_MASK)
#define RTC_SR_TAF_MASK                          0x4u
#define RTC_SR_TAF_SHIFT                         2
#define RTC_SR_TAF_WIDTH                         1
#define RTC_SR_TAF(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_SR_TAF_SHIFT))&RTC_SR_TAF_MASK)
#define RTC_SR_TCE_MASK                          0x10u
#define RTC_SR_TCE_SHIFT                         4
#define RTC_SR_TCE_WIDTH                         1
#define RTC_SR_TCE(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_SR_TCE_SHIFT))&RTC_SR_TCE_MASK)
/* LR Bit Fields */
#define RTC_LR_TCL_MASK                          0x8u
#define RTC_LR_TCL_SHIFT                         3
#define RTC_LR_TCL_WIDTH                         1
#define RTC_LR_TCL(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_LR_TCL_SHIFT))&RTC_LR_TCL_MASK)
#define RTC_LR_CRL_MASK                          0x10u
#define RTC_LR_CRL_SHIFT                         4
#define RTC_LR_CRL_WIDTH                         1
#define RTC_LR_CRL(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_LR_CRL_SHIFT))&RTC_LR_CRL_MASK)
#define RTC_LR_SRL_MASK                          0x20u
#define RTC_LR_SRL_SHIFT                         5
#define RTC_LR_SRL_WIDTH                         1
#define RTC_LR_SRL(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_LR_SRL_SHIFT))&RTC_LR_SRL_MASK)
#define RTC_LR_LRL_MASK                          0x40u
#define RTC_LR_LRL_SHIFT                         6
#define RTC_LR_LRL_WIDTH                         1
#define RTC_LR_LRL(x)                            (((uint32_t)(((uint32_t)(x))<<RTC_LR_LRL_SHIFT))&RTC_LR_LRL_MASK)
/* IER Bit Fields */
#define RTC_IER_TIIE_MASK                        0x1u
#define RTC_IER_TIIE_SHIFT                       0
#define RTC_IER_TIIE_WIDTH                       1
#define RTC_IER_TIIE(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_IER_TIIE_SHIFT))&RTC_IER_TIIE_MASK)
#define RTC_IER_TOIE_MASK                        0x2u
#define RTC_IER_TOIE_SHIFT                       1
#define RTC_IER_TOIE_WIDTH                       1
#define RTC_IER_TOIE(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_IER_TOIE_SHIFT))&RTC_IER_TOIE_MASK)
#define RTC_IER_TAIE_MASK                        0x4u
#define RTC_IER_TAIE_SHIFT                       2
#define RTC_IER_TAIE_WIDTH                       1
#define RTC_IER_TAIE(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_IER_TAIE_SHIFT))&RTC_IER_TAIE_MASK)
#define RTC_IER_TSIE_MASK                        0x10u
#define RTC_IER_TSIE_SHIFT                       4
#define RTC_IER_TSIE_WIDTH                       1
#define RTC_IER_TSIE(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_IER_TSIE_SHIFT))&RTC_IER_TSIE_MASK)
#define RTC_IER_WPON_MASK                        0x80u
#define RTC_IER_WPON_SHIFT                       7
#define RTC_IER_WPON_WIDTH                       1
#define RTC_IER_WPON(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_IER_WPON_SHIFT))&RTC_IER_WPON_MASK)
/* WAR Bit Fields */
#define RTC_WAR_TSRW_MASK                        0x1u
#define RTC_WAR_TSRW_SHIFT                       0
#define RTC_WAR_TSRW_WIDTH                       1
#define RTC_WAR_TSRW(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_WAR_TSRW_SHIFT))&RTC_WAR_TSRW_MASK)
#define RTC_WAR_TPRW_MASK                        0x2u
#define RTC_WAR_TPRW_SHIFT                       1
#define RTC_WAR_TPRW_WIDTH                       1
#define RTC_WAR_TPRW(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_WAR_TPRW_SHIFT))&RTC_WAR_TPRW_MASK)
#define RTC_WAR_TARW_MASK                        0x4u
#define RTC_WAR_TARW_SHIFT                       2
#define RTC_WAR_TARW_WIDTH                       1
#define RTC_WAR_TARW(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_WAR_TARW_SHIFT))&RTC_WAR_TARW_MASK)
#define RTC_WAR_TCRW_MASK                        0x8u
#define RTC_WAR_TCRW_SHIFT                       3
#define RTC_WAR_TCRW_WIDTH                       1
#define RTC_WAR_TCRW(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_WAR_TCRW_SHIFT))&RTC_WAR_TCRW_MASK)
#define RTC_WAR_CRW_MASK                         0x10u
#define RTC_WAR_CRW_SHIFT                        4
#define RTC_WAR_CRW_WIDTH                        1
#define RTC_WAR_CRW(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_WAR_CRW_SHIFT))&RTC_WAR_CRW_MASK)
#define RTC_WAR_SRW_MASK                         0x20u
#define RTC_WAR_SRW_SHIFT                        5
#define RTC_WAR_SRW_WIDTH                        1
#define RTC_WAR_SRW(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_WAR_SRW_SHIFT))&RTC_WAR_SRW_MASK)
#define RTC_WAR_LRW_MASK                         0x40u
#define RTC_WAR_LRW_SHIFT                        6
#define RTC_WAR_LRW_WIDTH                        1
#define RTC_WAR_LRW(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_WAR_LRW_SHIFT))&RTC_WAR_LRW_MASK)
#define RTC_WAR_IERW_MASK                        0x80u
#define RTC_WAR_IERW_SHIFT                       7
#define RTC_WAR_IERW_WIDTH                       1
#define RTC_WAR_IERW(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_WAR_IERW_SHIFT))&RTC_WAR_IERW_MASK)
/* RAR Bit Fields */
#define RTC_RAR_TSRR_MASK                        0x1u
#define RTC_RAR_TSRR_SHIFT                       0
#define RTC_RAR_TSRR_WIDTH                       1
#define RTC_RAR_TSRR(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_RAR_TSRR_SHIFT))&RTC_RAR_TSRR_MASK)
#define RTC_RAR_TPRR_MASK                        0x2u
#define RTC_RAR_TPRR_SHIFT                       1
#define RTC_RAR_TPRR_WIDTH                       1
#define RTC_RAR_TPRR(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_RAR_TPRR_SHIFT))&RTC_RAR_TPRR_MASK)
#define RTC_RAR_TARR_MASK                        0x4u
#define RTC_RAR_TARR_SHIFT                       2
#define RTC_RAR_TARR_WIDTH                       1
#define RTC_RAR_TARR(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_RAR_TARR_SHIFT))&RTC_RAR_TARR_MASK)
#define RTC_RAR_TCRR_MASK                        0x8u
#define RTC_RAR_TCRR_SHIFT                       3
#define RTC_RAR_TCRR_WIDTH                       1
#define RTC_RAR_TCRR(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_RAR_TCRR_SHIFT))&RTC_RAR_TCRR_MASK)
#define RTC_RAR_CRR_MASK                         0x10u
#define RTC_RAR_CRR_SHIFT                        4
#define RTC_RAR_CRR_WIDTH                        1
#define RTC_RAR_CRR(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_RAR_CRR_SHIFT))&RTC_RAR_CRR_MASK)
#define RTC_RAR_SRR_MASK                         0x20u
#define RTC_RAR_SRR_SHIFT                        5
#define RTC_RAR_SRR_WIDTH                        1
#define RTC_RAR_SRR(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_RAR_SRR_SHIFT))&RTC_RAR_SRR_MASK)
#define RTC_RAR_LRR_MASK                         0x40u
#define RTC_RAR_LRR_SHIFT                        6
#define RTC_RAR_LRR_WIDTH                        1
#define RTC_RAR_LRR(x)                           (((uint32_t)(((uint32_t)(x))<<RTC_RAR_LRR_SHIFT))&RTC_RAR_LRR_MASK)
#define RTC_RAR_IERR_MASK                        0x80u
#define RTC_RAR_IERR_SHIFT                       7
#define RTC_RAR_IERR_WIDTH                       1
#define RTC_RAR_IERR(x)                          (((uint32_t)(((uint32_t)(x))<<RTC_RAR_IERR_SHIFT))&RTC_RAR_IERR_MASK)

/*!
 * @}
 */ /* end of group RTC_Register_Masks */


/* RTC - Peripheral instance base addresses */
/** Peripheral RTC base address */
#define RTC_BASE                                 (0x4003D000u)
/** Peripheral RTC base pointer */
#define RTC                                      ((RTC_Type *)RTC_BASE)
#define RTC_BASE_PTR                             (RTC)
/** Array initializer of RTC peripheral base addresses */
#define RTC_BASE_ADDRS                           { RTC_BASE }
/** Array initializer of RTC peripheral base pointers */
#define RTC_BASE_PTRS                            { RTC }

/* ----------------------------------------------------------------------------
   -- RTC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RTC_Register_Accessor_Macros RTC - Register accessor macros
 * @{
 */


/* RTC - Register instance definitions */
/* RTC */
#define RTC_TSR                                  RTC_TSR_REG(RTC)
#define RTC_TPR                                  RTC_TPR_REG(RTC)
#define RTC_TAR                                  RTC_TAR_REG(RTC)
#define RTC_TCR                                  RTC_TCR_REG(RTC)
#define RTC_CR                                   RTC_CR_REG(RTC)
#define RTC_SR                                   RTC_SR_REG(RTC)
#define RTC_LR                                   RTC_LR_REG(RTC)
#define RTC_IER                                  RTC_IER_REG(RTC)
#define RTC_WAR                                  RTC_WAR_REG(RTC)
#define RTC_RAR                                  RTC_RAR_REG(RTC)

/*!
 * @}
 */ /* end of group RTC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group RTC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SIM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SIM_Peripheral_Access_Layer SIM Peripheral Access Layer
 * @{
 */

/** SIM - Register Layout Typedef */
typedef struct {
  __IO uint32_t SOPT1;                             /**< System Options Register 1, offset: 0x0 */
       uint8_t RESERVED_0[4096];
  __IO uint32_t SOPT2;                             /**< System Options Register 2, offset: 0x1004 */
       uint8_t RESERVED_1[8];
  __IO uint32_t SOPT5;                             /**< System Options Register 5, offset: 0x1010 */
       uint8_t RESERVED_2[4];
  __IO uint32_t SOPT7;                             /**< System Options Register 7, offset: 0x1018 */
       uint8_t RESERVED_3[4];
  __IO uint32_t SOPT9;                             /**< System Options Register 9, offset: 0x1020 */
  __I  uint32_t SDID;                              /**< System Device Identification Register, offset: 0x1024 */
       uint8_t RESERVED_4[12];
  __IO uint32_t SCGC4;                             /**< System Clock Gating Control Register 4, offset: 0x1034 */
  __IO uint32_t SCGC5;                             /**< System Clock Gating Control Register 5, offset: 0x1038 */
  __IO uint32_t SCGC6;                             /**< System Clock Gating Control Register 6, offset: 0x103C */
  __IO uint32_t SCGC7;                             /**< System Clock Gating Control Register 7, offset: 0x1040 */
  __IO uint32_t CLKDIV1;                           /**< System Clock Divider Register 1, offset: 0x1044 */
  __IO uint32_t CLKDIV2;                           /**< System Clock Divider Register 2, offset: 0x1048 */
  __IO uint32_t FCFG1;                             /**< Flash Configuration Register 1, offset: 0x104C */
  __I  uint32_t FCFG2;                             /**< Flash Configuration Register 2, offset: 0x1050 */
  __I  uint32_t UIDH;                              /**< Unique Identification Register High, offset: 0x1054 */
  __I  uint32_t UIDMH;                             /**< Unique Identification Register Mid-High, offset: 0x1058 */
  __I  uint32_t UIDML;                             /**< Unique Identification Register Mid Low, offset: 0x105C */
  __I  uint32_t UIDL;                              /**< Unique Identification Register Low, offset: 0x1060 */
  __IO uint32_t CLKDIV3;                           /**< System Clock Divider Register 3, offset: 0x1064 */
       uint8_t RESERVED_5[4];
  __IO uint32_t MISCCTRL;                          /**< Misc Control Register, offset: 0x106C */
       uint8_t RESERVED_6[32];
  __I  uint32_t SECKEY0;                           /**< Secure Key Register 0, offset: 0x1090 */
  __I  uint32_t SECKEY1;                           /**< Secure Key Register 1, offset: 0x1094 */
  __I  uint32_t SECKEY2;                           /**< Secure Key Register 2, offset: 0x1098 */
  __I  uint32_t SECKEY3;                           /**< Secure Key Register 3, offset: 0x109C */
} SIM_Type, *SIM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- SIM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SIM_Register_Accessor_Macros SIM - Register accessor macros
 * @{
 */


/* SIM - Register accessors */
#define SIM_SOPT1_REG(base)                      ((base)->SOPT1)
#define SIM_SOPT2_REG(base)                      ((base)->SOPT2)
#define SIM_SOPT5_REG(base)                      ((base)->SOPT5)
#define SIM_SOPT7_REG(base)                      ((base)->SOPT7)
#define SIM_SOPT9_REG(base)                      ((base)->SOPT9)
#define SIM_SDID_REG(base)                       ((base)->SDID)
#define SIM_SCGC4_REG(base)                      ((base)->SCGC4)
#define SIM_SCGC5_REG(base)                      ((base)->SCGC5)
#define SIM_SCGC6_REG(base)                      ((base)->SCGC6)
#define SIM_SCGC7_REG(base)                      ((base)->SCGC7)
#define SIM_CLKDIV1_REG(base)                    ((base)->CLKDIV1)
#define SIM_CLKDIV2_REG(base)                    ((base)->CLKDIV2)
#define SIM_FCFG1_REG(base)                      ((base)->FCFG1)
#define SIM_FCFG2_REG(base)                      ((base)->FCFG2)
#define SIM_UIDH_REG(base)                       ((base)->UIDH)
#define SIM_UIDMH_REG(base)                      ((base)->UIDMH)
#define SIM_UIDML_REG(base)                      ((base)->UIDML)
#define SIM_UIDL_REG(base)                       ((base)->UIDL)
#define SIM_CLKDIV3_REG(base)                    ((base)->CLKDIV3)
#define SIM_MISCCTRL_REG(base)                   ((base)->MISCCTRL)
#define SIM_SECKEY0_REG(base)                    ((base)->SECKEY0)
#define SIM_SECKEY1_REG(base)                    ((base)->SECKEY1)
#define SIM_SECKEY2_REG(base)                    ((base)->SECKEY2)
#define SIM_SECKEY3_REG(base)                    ((base)->SECKEY3)

/*!
 * @}
 */ /* end of group SIM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- SIM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SIM_Register_Masks SIM Register Masks
 * @{
 */

/* SOPT1 Bit Fields */
#define SIM_SOPT1_RAMSIZE_MASK                   0xF000u
#define SIM_SOPT1_RAMSIZE_SHIFT                  12
#define SIM_SOPT1_RAMSIZE_WIDTH                  4
#define SIM_SOPT1_RAMSIZE(x)                     (((uint32_t)(((uint32_t)(x))<<SIM_SOPT1_RAMSIZE_SHIFT))&SIM_SOPT1_RAMSIZE_MASK)
#define SIM_SOPT1_OSC32KSEL_MASK                 0xC0000u
#define SIM_SOPT1_OSC32KSEL_SHIFT                18
#define SIM_SOPT1_OSC32KSEL_WIDTH                2
#define SIM_SOPT1_OSC32KSEL(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_SOPT1_OSC32KSEL_SHIFT))&SIM_SOPT1_OSC32KSEL_MASK)
/* SOPT2 Bit Fields */
#define SIM_SOPT2_RTCCLKOUTS_MASK                0x10u
#define SIM_SOPT2_RTCCLKOUTS_SHIFT               4
#define SIM_SOPT2_RTCCLKOUTS_WIDTH               1
#define SIM_SOPT2_RTCCLKOUTS(x)                  (((uint32_t)(((uint32_t)(x))<<SIM_SOPT2_RTCCLKOUTS_SHIFT))&SIM_SOPT2_RTCCLKOUTS_MASK)
#define SIM_SOPT2_CLKOUT_MASK                    0xE0u
#define SIM_SOPT2_CLKOUT_SHIFT                   5
#define SIM_SOPT2_CLKOUT_WIDTH                   3
#define SIM_SOPT2_CLKOUT(x)                      (((uint32_t)(((uint32_t)(x))<<SIM_SOPT2_CLKOUT_SHIFT))&SIM_SOPT2_CLKOUT_MASK)
#define SIM_SOPT2_PLLFLLSEL_MASK                 0x30000u
#define SIM_SOPT2_PLLFLLSEL_SHIFT                16
#define SIM_SOPT2_PLLFLLSEL_WIDTH                2
#define SIM_SOPT2_PLLFLLSEL(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_SOPT2_PLLFLLSEL_SHIFT))&SIM_SOPT2_PLLFLLSEL_MASK)
#define SIM_SOPT2_USBSRC_MASK                    0x40000u
#define SIM_SOPT2_USBSRC_SHIFT                   18
#define SIM_SOPT2_USBSRC_WIDTH                   1
#define SIM_SOPT2_USBSRC(x)                      (((uint32_t)(((uint32_t)(x))<<SIM_SOPT2_USBSRC_SHIFT))&SIM_SOPT2_USBSRC_MASK)
#define SIM_SOPT2_FLEXIOSRC_MASK                 0xC00000u
#define SIM_SOPT2_FLEXIOSRC_SHIFT                22
#define SIM_SOPT2_FLEXIOSRC_WIDTH                2
#define SIM_SOPT2_FLEXIOSRC(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_SOPT2_FLEXIOSRC_SHIFT))&SIM_SOPT2_FLEXIOSRC_MASK)
#define SIM_SOPT2_TPMSRC_MASK                    0x3000000u
#define SIM_SOPT2_TPMSRC_SHIFT                   24
#define SIM_SOPT2_TPMSRC_WIDTH                   2
#define SIM_SOPT2_TPMSRC(x)                      (((uint32_t)(((uint32_t)(x))<<SIM_SOPT2_TPMSRC_SHIFT))&SIM_SOPT2_TPMSRC_MASK)
#define SIM_SOPT2_LPUARTSRC_MASK                 0xC000000u
#define SIM_SOPT2_LPUARTSRC_SHIFT                26
#define SIM_SOPT2_LPUARTSRC_WIDTH                2
#define SIM_SOPT2_LPUARTSRC(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_SOPT2_LPUARTSRC_SHIFT))&SIM_SOPT2_LPUARTSRC_MASK)
#define SIM_SOPT2_EMVSIMSRC_MASK                 0xC0000000u
#define SIM_SOPT2_EMVSIMSRC_SHIFT                30
#define SIM_SOPT2_EMVSIMSRC_WIDTH                2
#define SIM_SOPT2_EMVSIMSRC(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_SOPT2_EMVSIMSRC_SHIFT))&SIM_SOPT2_EMVSIMSRC_MASK)
/* SOPT5 Bit Fields */
#define SIM_SOPT5_LPUART0TXSRC_MASK              0x30000u
#define SIM_SOPT5_LPUART0TXSRC_SHIFT             16
#define SIM_SOPT5_LPUART0TXSRC_WIDTH             2
#define SIM_SOPT5_LPUART0TXSRC(x)                (((uint32_t)(((uint32_t)(x))<<SIM_SOPT5_LPUART0TXSRC_SHIFT))&SIM_SOPT5_LPUART0TXSRC_MASK)
#define SIM_SOPT5_LPUART0RXSRC_MASK              0xC0000u
#define SIM_SOPT5_LPUART0RXSRC_SHIFT             18
#define SIM_SOPT5_LPUART0RXSRC_WIDTH             2
#define SIM_SOPT5_LPUART0RXSRC(x)                (((uint32_t)(((uint32_t)(x))<<SIM_SOPT5_LPUART0RXSRC_SHIFT))&SIM_SOPT5_LPUART0RXSRC_MASK)
#define SIM_SOPT5_LPUART1TXSRC_MASK              0x300000u
#define SIM_SOPT5_LPUART1TXSRC_SHIFT             20
#define SIM_SOPT5_LPUART1TXSRC_WIDTH             2
#define SIM_SOPT5_LPUART1TXSRC(x)                (((uint32_t)(((uint32_t)(x))<<SIM_SOPT5_LPUART1TXSRC_SHIFT))&SIM_SOPT5_LPUART1TXSRC_MASK)
#define SIM_SOPT5_LPUART1RXSRC_MASK              0xC00000u
#define SIM_SOPT5_LPUART1RXSRC_SHIFT             22
#define SIM_SOPT5_LPUART1RXSRC_WIDTH             2
#define SIM_SOPT5_LPUART1RXSRC(x)                (((uint32_t)(((uint32_t)(x))<<SIM_SOPT5_LPUART1RXSRC_SHIFT))&SIM_SOPT5_LPUART1RXSRC_MASK)
/* SOPT7 Bit Fields */
#define SIM_SOPT7_ADC0TRGSEL_MASK                0xFu
#define SIM_SOPT7_ADC0TRGSEL_SHIFT               0
#define SIM_SOPT7_ADC0TRGSEL_WIDTH               4
#define SIM_SOPT7_ADC0TRGSEL(x)                  (((uint32_t)(((uint32_t)(x))<<SIM_SOPT7_ADC0TRGSEL_SHIFT))&SIM_SOPT7_ADC0TRGSEL_MASK)
#define SIM_SOPT7_ADC0PRETRGSEL_MASK             0x10u
#define SIM_SOPT7_ADC0PRETRGSEL_SHIFT            4
#define SIM_SOPT7_ADC0PRETRGSEL_WIDTH            1
#define SIM_SOPT7_ADC0PRETRGSEL(x)               (((uint32_t)(((uint32_t)(x))<<SIM_SOPT7_ADC0PRETRGSEL_SHIFT))&SIM_SOPT7_ADC0PRETRGSEL_MASK)
/* SOPT9 Bit Fields */
#define SIM_SOPT9_TPM1CH0SRC_MASK                0xC0000u
#define SIM_SOPT9_TPM1CH0SRC_SHIFT               18
#define SIM_SOPT9_TPM1CH0SRC_WIDTH               2
#define SIM_SOPT9_TPM1CH0SRC(x)                  (((uint32_t)(((uint32_t)(x))<<SIM_SOPT9_TPM1CH0SRC_SHIFT))&SIM_SOPT9_TPM1CH0SRC_MASK)
#define SIM_SOPT9_TPM2CH0SRC_MASK                0x300000u
#define SIM_SOPT9_TPM2CH0SRC_SHIFT               20
#define SIM_SOPT9_TPM2CH0SRC_WIDTH               2
#define SIM_SOPT9_TPM2CH0SRC(x)                  (((uint32_t)(((uint32_t)(x))<<SIM_SOPT9_TPM2CH0SRC_SHIFT))&SIM_SOPT9_TPM2CH0SRC_MASK)
#define SIM_SOPT9_TPM0CLKSEL_MASK                0x1000000u
#define SIM_SOPT9_TPM0CLKSEL_SHIFT               24
#define SIM_SOPT9_TPM0CLKSEL_WIDTH               1
#define SIM_SOPT9_TPM0CLKSEL(x)                  (((uint32_t)(((uint32_t)(x))<<SIM_SOPT9_TPM0CLKSEL_SHIFT))&SIM_SOPT9_TPM0CLKSEL_MASK)
#define SIM_SOPT9_TPM1CLKSEL_MASK                0x2000000u
#define SIM_SOPT9_TPM1CLKSEL_SHIFT               25
#define SIM_SOPT9_TPM1CLKSEL_WIDTH               1
#define SIM_SOPT9_TPM1CLKSEL(x)                  (((uint32_t)(((uint32_t)(x))<<SIM_SOPT9_TPM1CLKSEL_SHIFT))&SIM_SOPT9_TPM1CLKSEL_MASK)
#define SIM_SOPT9_TPM2CLKSEL_MASK                0x4000000u
#define SIM_SOPT9_TPM2CLKSEL_SHIFT               26
#define SIM_SOPT9_TPM2CLKSEL_WIDTH               1
#define SIM_SOPT9_TPM2CLKSEL(x)                  (((uint32_t)(((uint32_t)(x))<<SIM_SOPT9_TPM2CLKSEL_SHIFT))&SIM_SOPT9_TPM2CLKSEL_MASK)
/* SDID Bit Fields */
#define SIM_SDID_PINID_MASK                      0xFu
#define SIM_SDID_PINID_SHIFT                     0
#define SIM_SDID_PINID_WIDTH                     4
#define SIM_SDID_PINID(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SDID_PINID_SHIFT))&SIM_SDID_PINID_MASK)
#define SIM_SDID_FAMID_MASK                      0x70u
#define SIM_SDID_FAMID_SHIFT                     4
#define SIM_SDID_FAMID_WIDTH                     3
#define SIM_SDID_FAMID(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SDID_FAMID_SHIFT))&SIM_SDID_FAMID_MASK)
#define SIM_SDID_DIEID_MASK                      0xF80u
#define SIM_SDID_DIEID_SHIFT                     7
#define SIM_SDID_DIEID_WIDTH                     5
#define SIM_SDID_DIEID(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SDID_DIEID_SHIFT))&SIM_SDID_DIEID_MASK)
#define SIM_SDID_REVID_MASK                      0xF000u
#define SIM_SDID_REVID_SHIFT                     12
#define SIM_SDID_REVID_WIDTH                     4
#define SIM_SDID_REVID(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SDID_REVID_SHIFT))&SIM_SDID_REVID_MASK)
#define SIM_SDID_SUBFAMID_MASK                   0xF000000u
#define SIM_SDID_SUBFAMID_SHIFT                  24
#define SIM_SDID_SUBFAMID_WIDTH                  4
#define SIM_SDID_SUBFAMID(x)                     (((uint32_t)(((uint32_t)(x))<<SIM_SDID_SUBFAMID_SHIFT))&SIM_SDID_SUBFAMID_MASK)
#define SIM_SDID_FAMILYID_MASK                   0xF0000000u
#define SIM_SDID_FAMILYID_SHIFT                  28
#define SIM_SDID_FAMILYID_WIDTH                  4
#define SIM_SDID_FAMILYID(x)                     (((uint32_t)(((uint32_t)(x))<<SIM_SDID_FAMILYID_SHIFT))&SIM_SDID_FAMILYID_MASK)
/* SCGC4 Bit Fields */
#define SIM_SCGC4_EWM_MASK                       0x2u
#define SIM_SCGC4_EWM_SHIFT                      1
#define SIM_SCGC4_EWM_WIDTH                      1
#define SIM_SCGC4_EWM(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC4_EWM_SHIFT))&SIM_SCGC4_EWM_MASK)
#define SIM_SCGC4_I2C0_MASK                      0x40u
#define SIM_SCGC4_I2C0_SHIFT                     6
#define SIM_SCGC4_I2C0_WIDTH                     1
#define SIM_SCGC4_I2C0(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC4_I2C0_SHIFT))&SIM_SCGC4_I2C0_MASK)
#define SIM_SCGC4_I2C1_MASK                      0x80u
#define SIM_SCGC4_I2C1_SHIFT                     7
#define SIM_SCGC4_I2C1_WIDTH                     1
#define SIM_SCGC4_I2C1(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC4_I2C1_SHIFT))&SIM_SCGC4_I2C1_MASK)
#define SIM_SCGC4_USBOTG_MASK                    0x40000u
#define SIM_SCGC4_USBOTG_SHIFT                   18
#define SIM_SCGC4_USBOTG_WIDTH                   1
#define SIM_SCGC4_USBOTG(x)                      (((uint32_t)(((uint32_t)(x))<<SIM_SCGC4_USBOTG_SHIFT))&SIM_SCGC4_USBOTG_MASK)
#define SIM_SCGC4_CMP_MASK                       0x80000u
#define SIM_SCGC4_CMP_SHIFT                      19
#define SIM_SCGC4_CMP_WIDTH                      1
#define SIM_SCGC4_CMP(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC4_CMP_SHIFT))&SIM_SCGC4_CMP_MASK)
#define SIM_SCGC4_VREF_MASK                      0x100000u
#define SIM_SCGC4_VREF_SHIFT                     20
#define SIM_SCGC4_VREF_WIDTH                     1
#define SIM_SCGC4_VREF(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC4_VREF_SHIFT))&SIM_SCGC4_VREF_MASK)
/* SCGC5 Bit Fields */
#define SIM_SCGC5_LPTMR0_MASK                    0x1u
#define SIM_SCGC5_LPTMR0_SHIFT                   0
#define SIM_SCGC5_LPTMR0_WIDTH                   1
#define SIM_SCGC5_LPTMR0(x)                      (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_LPTMR0_SHIFT))&SIM_SCGC5_LPTMR0_MASK)
#define SIM_SCGC5_SECREG_MASK                    0x8u
#define SIM_SCGC5_SECREG_SHIFT                   3
#define SIM_SCGC5_SECREG_WIDTH                   1
#define SIM_SCGC5_SECREG(x)                      (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_SECREG_SHIFT))&SIM_SCGC5_SECREG_MASK)
#define SIM_SCGC5_LPTMR1_MASK                    0x10u
#define SIM_SCGC5_LPTMR1_SHIFT                   4
#define SIM_SCGC5_LPTMR1_WIDTH                   1
#define SIM_SCGC5_LPTMR1(x)                      (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_LPTMR1_SHIFT))&SIM_SCGC5_LPTMR1_MASK)
#define SIM_SCGC5_TSI_MASK                       0x20u
#define SIM_SCGC5_TSI_SHIFT                      5
#define SIM_SCGC5_TSI_WIDTH                      1
#define SIM_SCGC5_TSI(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_TSI_SHIFT))&SIM_SCGC5_TSI_MASK)
#define SIM_SCGC5_PTA_MASK                       0x200u
#define SIM_SCGC5_PTA_SHIFT                      9
#define SIM_SCGC5_PTA_WIDTH                      1
#define SIM_SCGC5_PTA(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_PTA_SHIFT))&SIM_SCGC5_PTA_MASK)
#define SIM_SCGC5_PTB_MASK                       0x400u
#define SIM_SCGC5_PTB_SHIFT                      10
#define SIM_SCGC5_PTB_WIDTH                      1
#define SIM_SCGC5_PTB(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_PTB_SHIFT))&SIM_SCGC5_PTB_MASK)
#define SIM_SCGC5_PTC_MASK                       0x800u
#define SIM_SCGC5_PTC_SHIFT                      11
#define SIM_SCGC5_PTC_WIDTH                      1
#define SIM_SCGC5_PTC(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_PTC_SHIFT))&SIM_SCGC5_PTC_MASK)
#define SIM_SCGC5_PTD_MASK                       0x1000u
#define SIM_SCGC5_PTD_SHIFT                      12
#define SIM_SCGC5_PTD_WIDTH                      1
#define SIM_SCGC5_PTD(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_PTD_SHIFT))&SIM_SCGC5_PTD_MASK)
#define SIM_SCGC5_PTE_MASK                       0x2000u
#define SIM_SCGC5_PTE_SHIFT                      13
#define SIM_SCGC5_PTE_WIDTH                      1
#define SIM_SCGC5_PTE(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_PTE_SHIFT))&SIM_SCGC5_PTE_MASK)
#define SIM_SCGC5_EMVSIM0_MASK                   0x4000u
#define SIM_SCGC5_EMVSIM0_SHIFT                  14
#define SIM_SCGC5_EMVSIM0_WIDTH                  1
#define SIM_SCGC5_EMVSIM0(x)                     (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_EMVSIM0_SHIFT))&SIM_SCGC5_EMVSIM0_MASK)
#define SIM_SCGC5_EMVSIM1_MASK                   0x8000u
#define SIM_SCGC5_EMVSIM1_SHIFT                  15
#define SIM_SCGC5_EMVSIM1_WIDTH                  1
#define SIM_SCGC5_EMVSIM1(x)                     (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_EMVSIM1_SHIFT))&SIM_SCGC5_EMVSIM1_MASK)
#define SIM_SCGC5_LTC_MASK                       0x20000u
#define SIM_SCGC5_LTC_SHIFT                      17
#define SIM_SCGC5_LTC_WIDTH                      1
#define SIM_SCGC5_LTC(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_LTC_SHIFT))&SIM_SCGC5_LTC_MASK)
#define SIM_SCGC5_LPUART0_MASK                   0x100000u
#define SIM_SCGC5_LPUART0_SHIFT                  20
#define SIM_SCGC5_LPUART0_WIDTH                  1
#define SIM_SCGC5_LPUART0(x)                     (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_LPUART0_SHIFT))&SIM_SCGC5_LPUART0_MASK)
#define SIM_SCGC5_LPUART1_MASK                   0x200000u
#define SIM_SCGC5_LPUART1_SHIFT                  21
#define SIM_SCGC5_LPUART1_WIDTH                  1
#define SIM_SCGC5_LPUART1(x)                     (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_LPUART1_SHIFT))&SIM_SCGC5_LPUART1_MASK)
#define SIM_SCGC5_LPUART2_MASK                   0x400000u
#define SIM_SCGC5_LPUART2_SHIFT                  22
#define SIM_SCGC5_LPUART2_WIDTH                  1
#define SIM_SCGC5_LPUART2(x)                     (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_LPUART2_SHIFT))&SIM_SCGC5_LPUART2_MASK)
#define SIM_SCGC5_QSPI0_MASK                     0x4000000u
#define SIM_SCGC5_QSPI0_SHIFT                    26
#define SIM_SCGC5_QSPI0_WIDTH                    1
#define SIM_SCGC5_QSPI0(x)                       (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_QSPI0_SHIFT))&SIM_SCGC5_QSPI0_MASK)
#define SIM_SCGC5_FLEXIO0_MASK                   0x80000000u
#define SIM_SCGC5_FLEXIO0_SHIFT                  31
#define SIM_SCGC5_FLEXIO0_WIDTH                  1
#define SIM_SCGC5_FLEXIO0(x)                     (((uint32_t)(((uint32_t)(x))<<SIM_SCGC5_FLEXIO0_SHIFT))&SIM_SCGC5_FLEXIO0_MASK)
/* SCGC6 Bit Fields */
#define SIM_SCGC6_NVM_MASK                       0x1u
#define SIM_SCGC6_NVM_SHIFT                      0
#define SIM_SCGC6_NVM_WIDTH                      1
#define SIM_SCGC6_NVM(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_NVM_SHIFT))&SIM_SCGC6_NVM_MASK)
#define SIM_SCGC6_DMACHMUX_MASK                  0x2u
#define SIM_SCGC6_DMACHMUX_SHIFT                 1
#define SIM_SCGC6_DMACHMUX_WIDTH                 1
#define SIM_SCGC6_DMACHMUX(x)                    (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_DMACHMUX_SHIFT))&SIM_SCGC6_DMACHMUX_MASK)
#define SIM_SCGC6_INTMUX0_MASK                   0x10u
#define SIM_SCGC6_INTMUX0_SHIFT                  4
#define SIM_SCGC6_INTMUX0_WIDTH                  1
#define SIM_SCGC6_INTMUX0(x)                     (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_INTMUX0_SHIFT))&SIM_SCGC6_INTMUX0_MASK)
#define SIM_SCGC6_TRNG_MASK                      0x20u
#define SIM_SCGC6_TRNG_SHIFT                     5
#define SIM_SCGC6_TRNG_WIDTH                     1
#define SIM_SCGC6_TRNG(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_TRNG_SHIFT))&SIM_SCGC6_TRNG_MASK)
#define SIM_SCGC6_SPI0_MASK                      0x1000u
#define SIM_SCGC6_SPI0_SHIFT                     12
#define SIM_SCGC6_SPI0_WIDTH                     1
#define SIM_SCGC6_SPI0(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_SPI0_SHIFT))&SIM_SCGC6_SPI0_MASK)
#define SIM_SCGC6_SPI1_MASK                      0x2000u
#define SIM_SCGC6_SPI1_SHIFT                     13
#define SIM_SCGC6_SPI1_WIDTH                     1
#define SIM_SCGC6_SPI1(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_SPI1_SHIFT))&SIM_SCGC6_SPI1_MASK)
#define SIM_SCGC6_CRC_MASK                       0x40000u
#define SIM_SCGC6_CRC_SHIFT                      18
#define SIM_SCGC6_CRC_WIDTH                      1
#define SIM_SCGC6_CRC(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_CRC_SHIFT))&SIM_SCGC6_CRC_MASK)
#define SIM_SCGC6_PIT0_MASK                      0x800000u
#define SIM_SCGC6_PIT0_SHIFT                     23
#define SIM_SCGC6_PIT0_WIDTH                     1
#define SIM_SCGC6_PIT0(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_PIT0_SHIFT))&SIM_SCGC6_PIT0_MASK)
#define SIM_SCGC6_TPM0_MASK                      0x1000000u
#define SIM_SCGC6_TPM0_SHIFT                     24
#define SIM_SCGC6_TPM0_WIDTH                     1
#define SIM_SCGC6_TPM0(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_TPM0_SHIFT))&SIM_SCGC6_TPM0_MASK)
#define SIM_SCGC6_TPM1_MASK                      0x2000000u
#define SIM_SCGC6_TPM1_SHIFT                     25
#define SIM_SCGC6_TPM1_WIDTH                     1
#define SIM_SCGC6_TPM1(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_TPM1_SHIFT))&SIM_SCGC6_TPM1_MASK)
#define SIM_SCGC6_TPM2_MASK                      0x4000000u
#define SIM_SCGC6_TPM2_SHIFT                     26
#define SIM_SCGC6_TPM2_WIDTH                     1
#define SIM_SCGC6_TPM2(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_TPM2_SHIFT))&SIM_SCGC6_TPM2_MASK)
#define SIM_SCGC6_ADC0_MASK                      0x8000000u
#define SIM_SCGC6_ADC0_SHIFT                     27
#define SIM_SCGC6_ADC0_WIDTH                     1
#define SIM_SCGC6_ADC0(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_ADC0_SHIFT))&SIM_SCGC6_ADC0_MASK)
#define SIM_SCGC6_RTC_MASK                       0x20000000u
#define SIM_SCGC6_RTC_SHIFT                      29
#define SIM_SCGC6_RTC_WIDTH                      1
#define SIM_SCGC6_RTC(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_RTC_SHIFT))&SIM_SCGC6_RTC_MASK)
#define SIM_SCGC6_RTC_RF_MASK                    0x40000000u
#define SIM_SCGC6_RTC_RF_SHIFT                   30
#define SIM_SCGC6_RTC_RF_WIDTH                   1
#define SIM_SCGC6_RTC_RF(x)                      (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_RTC_RF_SHIFT))&SIM_SCGC6_RTC_RF_MASK)
#define SIM_SCGC6_DAC0_MASK                      0x80000000u
#define SIM_SCGC6_DAC0_SHIFT                     31
#define SIM_SCGC6_DAC0_WIDTH                     1
#define SIM_SCGC6_DAC0(x)                        (((uint32_t)(((uint32_t)(x))<<SIM_SCGC6_DAC0_SHIFT))&SIM_SCGC6_DAC0_MASK)
/* SCGC7 Bit Fields */
#define SIM_SCGC7_DMA_MASK                       0x2u
#define SIM_SCGC7_DMA_SHIFT                      1
#define SIM_SCGC7_DMA_WIDTH                      1
#define SIM_SCGC7_DMA(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC7_DMA_SHIFT))&SIM_SCGC7_DMA_MASK)
#define SIM_SCGC7_MPU_MASK                       0x4u
#define SIM_SCGC7_MPU_SHIFT                      2
#define SIM_SCGC7_MPU_WIDTH                      1
#define SIM_SCGC7_MPU(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_SCGC7_MPU_SHIFT))&SIM_SCGC7_MPU_MASK)
/* CLKDIV1 Bit Fields */
#define SIM_CLKDIV1_OUTDIV5_MASK                 0xF000u
#define SIM_CLKDIV1_OUTDIV5_SHIFT                12
#define SIM_CLKDIV1_OUTDIV5_WIDTH                4
#define SIM_CLKDIV1_OUTDIV5(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_CLKDIV1_OUTDIV5_SHIFT))&SIM_CLKDIV1_OUTDIV5_MASK)
#define SIM_CLKDIV1_OUTDIV4_MASK                 0xF0000u
#define SIM_CLKDIV1_OUTDIV4_SHIFT                16
#define SIM_CLKDIV1_OUTDIV4_WIDTH                4
#define SIM_CLKDIV1_OUTDIV4(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_CLKDIV1_OUTDIV4_SHIFT))&SIM_CLKDIV1_OUTDIV4_MASK)
#define SIM_CLKDIV1_OUTDIV2_MASK                 0xF000000u
#define SIM_CLKDIV1_OUTDIV2_SHIFT                24
#define SIM_CLKDIV1_OUTDIV2_WIDTH                4
#define SIM_CLKDIV1_OUTDIV2(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_CLKDIV1_OUTDIV2_SHIFT))&SIM_CLKDIV1_OUTDIV2_MASK)
#define SIM_CLKDIV1_OUTDIV1_MASK                 0xF0000000u
#define SIM_CLKDIV1_OUTDIV1_SHIFT                28
#define SIM_CLKDIV1_OUTDIV1_WIDTH                4
#define SIM_CLKDIV1_OUTDIV1(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_CLKDIV1_OUTDIV1_SHIFT))&SIM_CLKDIV1_OUTDIV1_MASK)
/* CLKDIV2 Bit Fields */
#define SIM_CLKDIV2_USBFRAC_MASK                 0x1u
#define SIM_CLKDIV2_USBFRAC_SHIFT                0
#define SIM_CLKDIV2_USBFRAC_WIDTH                1
#define SIM_CLKDIV2_USBFRAC(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_CLKDIV2_USBFRAC_SHIFT))&SIM_CLKDIV2_USBFRAC_MASK)
#define SIM_CLKDIV2_USBDIV_MASK                  0xEu
#define SIM_CLKDIV2_USBDIV_SHIFT                 1
#define SIM_CLKDIV2_USBDIV_WIDTH                 3
#define SIM_CLKDIV2_USBDIV(x)                    (((uint32_t)(((uint32_t)(x))<<SIM_CLKDIV2_USBDIV_SHIFT))&SIM_CLKDIV2_USBDIV_MASK)
/* FCFG1 Bit Fields */
#define SIM_FCFG1_FLASHDIS_MASK                  0x1u
#define SIM_FCFG1_FLASHDIS_SHIFT                 0
#define SIM_FCFG1_FLASHDIS_WIDTH                 1
#define SIM_FCFG1_FLASHDIS(x)                    (((uint32_t)(((uint32_t)(x))<<SIM_FCFG1_FLASHDIS_SHIFT))&SIM_FCFG1_FLASHDIS_MASK)
#define SIM_FCFG1_FLASHDOZE_MASK                 0x2u
#define SIM_FCFG1_FLASHDOZE_SHIFT                1
#define SIM_FCFG1_FLASHDOZE_WIDTH                1
#define SIM_FCFG1_FLASHDOZE(x)                   (((uint32_t)(((uint32_t)(x))<<SIM_FCFG1_FLASHDOZE_SHIFT))&SIM_FCFG1_FLASHDOZE_MASK)
#define SIM_FCFG1_PFSIZE_MASK                    0xF000000u
#define SIM_FCFG1_PFSIZE_SHIFT                   24
#define SIM_FCFG1_PFSIZE_WIDTH                   4
#define SIM_FCFG1_PFSIZE(x)                      (((uint32_t)(((uint32_t)(x))<<SIM_FCFG1_PFSIZE_SHIFT))&SIM_FCFG1_PFSIZE_MASK)
/* FCFG2 Bit Fields */
#define SIM_FCFG2_MAXADDR0_MASK                  0x7F000000u
#define SIM_FCFG2_MAXADDR0_SHIFT                 24
#define SIM_FCFG2_MAXADDR0_WIDTH                 7
#define SIM_FCFG2_MAXADDR0(x)                    (((uint32_t)(((uint32_t)(x))<<SIM_FCFG2_MAXADDR0_SHIFT))&SIM_FCFG2_MAXADDR0_MASK)
/* UIDH Bit Fields */
#define SIM_UIDH_UID_MASK                        0xFFFFFFFFu
#define SIM_UIDH_UID_SHIFT                       0
#define SIM_UIDH_UID_WIDTH                       32
#define SIM_UIDH_UID(x)                          (((uint32_t)(((uint32_t)(x))<<SIM_UIDH_UID_SHIFT))&SIM_UIDH_UID_MASK)
/* UIDMH Bit Fields */
#define SIM_UIDMH_UID_MASK                       0xFFFFFFFFu
#define SIM_UIDMH_UID_SHIFT                      0
#define SIM_UIDMH_UID_WIDTH                      32
#define SIM_UIDMH_UID(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_UIDMH_UID_SHIFT))&SIM_UIDMH_UID_MASK)
/* UIDML Bit Fields */
#define SIM_UIDML_UID_MASK                       0xFFFFFFFFu
#define SIM_UIDML_UID_SHIFT                      0
#define SIM_UIDML_UID_WIDTH                      32
#define SIM_UIDML_UID(x)                         (((uint32_t)(((uint32_t)(x))<<SIM_UIDML_UID_SHIFT))&SIM_UIDML_UID_MASK)
/* UIDL Bit Fields */
#define SIM_UIDL_UID_MASK                        0xFFFFFFFFu
#define SIM_UIDL_UID_SHIFT                       0
#define SIM_UIDL_UID_WIDTH                       32
#define SIM_UIDL_UID(x)                          (((uint32_t)(((uint32_t)(x))<<SIM_UIDL_UID_SHIFT))&SIM_UIDL_UID_MASK)
/* CLKDIV3 Bit Fields */
#define SIM_CLKDIV3_PLLFLLFRAC_MASK              0x1u
#define SIM_CLKDIV3_PLLFLLFRAC_SHIFT             0
#define SIM_CLKDIV3_PLLFLLFRAC_WIDTH             1
#define SIM_CLKDIV3_PLLFLLFRAC(x)                (((uint32_t)(((uint32_t)(x))<<SIM_CLKDIV3_PLLFLLFRAC_SHIFT))&SIM_CLKDIV3_PLLFLLFRAC_MASK)
#define SIM_CLKDIV3_PLLFLLDIV_MASK               0xEu
#define SIM_CLKDIV3_PLLFLLDIV_SHIFT              1
#define SIM_CLKDIV3_PLLFLLDIV_WIDTH              3
#define SIM_CLKDIV3_PLLFLLDIV(x)                 (((uint32_t)(((uint32_t)(x))<<SIM_CLKDIV3_PLLFLLDIV_SHIFT))&SIM_CLKDIV3_PLLFLLDIV_MASK)
/* MISCCTRL Bit Fields */
#define SIM_MISCCTRL_DMAINTSEL0_MASK             0x1u
#define SIM_MISCCTRL_DMAINTSEL0_SHIFT            0
#define SIM_MISCCTRL_DMAINTSEL0_WIDTH            1
#define SIM_MISCCTRL_DMAINTSEL0(x)               (((uint32_t)(((uint32_t)(x))<<SIM_MISCCTRL_DMAINTSEL0_SHIFT))&SIM_MISCCTRL_DMAINTSEL0_MASK)
#define SIM_MISCCTRL_DMAINTSEL1_MASK             0x2u
#define SIM_MISCCTRL_DMAINTSEL1_SHIFT            1
#define SIM_MISCCTRL_DMAINTSEL1_WIDTH            1
#define SIM_MISCCTRL_DMAINTSEL1(x)               (((uint32_t)(((uint32_t)(x))<<SIM_MISCCTRL_DMAINTSEL1_SHIFT))&SIM_MISCCTRL_DMAINTSEL1_MASK)
#define SIM_MISCCTRL_DMAINTSEL2_MASK             0x4u
#define SIM_MISCCTRL_DMAINTSEL2_SHIFT            2
#define SIM_MISCCTRL_DMAINTSEL2_WIDTH            1
#define SIM_MISCCTRL_DMAINTSEL2(x)               (((uint32_t)(((uint32_t)(x))<<SIM_MISCCTRL_DMAINTSEL2_SHIFT))&SIM_MISCCTRL_DMAINTSEL2_MASK)
#define SIM_MISCCTRL_DMAINTSEL3_MASK             0x8u
#define SIM_MISCCTRL_DMAINTSEL3_SHIFT            3
#define SIM_MISCCTRL_DMAINTSEL3_WIDTH            1
#define SIM_MISCCTRL_DMAINTSEL3(x)               (((uint32_t)(((uint32_t)(x))<<SIM_MISCCTRL_DMAINTSEL3_SHIFT))&SIM_MISCCTRL_DMAINTSEL3_MASK)
#define SIM_MISCCTRL_LTCEN_MASK                  0x10000u
#define SIM_MISCCTRL_LTCEN_SHIFT                 16
#define SIM_MISCCTRL_LTCEN_WIDTH                 1
#define SIM_MISCCTRL_LTCEN(x)                    (((uint32_t)(((uint32_t)(x))<<SIM_MISCCTRL_LTCEN_SHIFT))&SIM_MISCCTRL_LTCEN_MASK)
/* SECKEY0 Bit Fields */
#define SIM_SECKEY0_SECKEY_MASK                  0xFFFFFFFFu
#define SIM_SECKEY0_SECKEY_SHIFT                 0
#define SIM_SECKEY0_SECKEY_WIDTH                 32
#define SIM_SECKEY0_SECKEY(x)                    (((uint32_t)(((uint32_t)(x))<<SIM_SECKEY0_SECKEY_SHIFT))&SIM_SECKEY0_SECKEY_MASK)
/* SECKEY1 Bit Fields */
#define SIM_SECKEY1_SECKEY_MASK                  0xFFFFFFFFu
#define SIM_SECKEY1_SECKEY_SHIFT                 0
#define SIM_SECKEY1_SECKEY_WIDTH                 32
#define SIM_SECKEY1_SECKEY(x)                    (((uint32_t)(((uint32_t)(x))<<SIM_SECKEY1_SECKEY_SHIFT))&SIM_SECKEY1_SECKEY_MASK)
/* SECKEY2 Bit Fields */
#define SIM_SECKEY2_SECKEY_MASK                  0xFFFFFFFFu
#define SIM_SECKEY2_SECKEY_SHIFT                 0
#define SIM_SECKEY2_SECKEY_WIDTH                 32
#define SIM_SECKEY2_SECKEY(x)                    (((uint32_t)(((uint32_t)(x))<<SIM_SECKEY2_SECKEY_SHIFT))&SIM_SECKEY2_SECKEY_MASK)
/* SECKEY3 Bit Fields */
#define SIM_SECKEY3_SECKEY_MASK                  0xFFFFFFFFu
#define SIM_SECKEY3_SECKEY_SHIFT                 0
#define SIM_SECKEY3_SECKEY_WIDTH                 32
#define SIM_SECKEY3_SECKEY(x)                    (((uint32_t)(((uint32_t)(x))<<SIM_SECKEY3_SECKEY_SHIFT))&SIM_SECKEY3_SECKEY_MASK)

/*!
 * @}
 */ /* end of group SIM_Register_Masks */


/* SIM - Peripheral instance base addresses */
/** Peripheral SIM base address */
#define SIM_BASE                                 (0x40047000u)
/** Peripheral SIM base pointer */
#define SIM                                      ((SIM_Type *)SIM_BASE)
#define SIM_BASE_PTR                             (SIM)
/** Array initializer of SIM peripheral base addresses */
#define SIM_BASE_ADDRS                           { SIM_BASE }
/** Array initializer of SIM peripheral base pointers */
#define SIM_BASE_PTRS                            { SIM }

/* ----------------------------------------------------------------------------
   -- SIM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SIM_Register_Accessor_Macros SIM - Register accessor macros
 * @{
 */


/* SIM - Register instance definitions */
/* SIM */
#define SIM_SOPT1                                SIM_SOPT1_REG(SIM)
#define SIM_SOPT2                                SIM_SOPT2_REG(SIM)
#define SIM_SOPT5                                SIM_SOPT5_REG(SIM)
#define SIM_SOPT7                                SIM_SOPT7_REG(SIM)
#define SIM_SOPT9                                SIM_SOPT9_REG(SIM)
#define SIM_SDID                                 SIM_SDID_REG(SIM)
#define SIM_SCGC4                                SIM_SCGC4_REG(SIM)
#define SIM_SCGC5                                SIM_SCGC5_REG(SIM)
#define SIM_SCGC6                                SIM_SCGC6_REG(SIM)
#define SIM_SCGC7                                SIM_SCGC7_REG(SIM)
#define SIM_CLKDIV1                              SIM_CLKDIV1_REG(SIM)
#define SIM_CLKDIV2                              SIM_CLKDIV2_REG(SIM)
#define SIM_FCFG1                                SIM_FCFG1_REG(SIM)
#define SIM_FCFG2                                SIM_FCFG2_REG(SIM)
#define SIM_UIDH                                 SIM_UIDH_REG(SIM)
#define SIM_UIDMH                                SIM_UIDMH_REG(SIM)
#define SIM_UIDML                                SIM_UIDML_REG(SIM)
#define SIM_UIDL                                 SIM_UIDL_REG(SIM)
#define SIM_CLKDIV3                              SIM_CLKDIV3_REG(SIM)
#define SIM_MISCCTRL                             SIM_MISCCTRL_REG(SIM)
#define SIM_SECKEY0                              SIM_SECKEY0_REG(SIM)
#define SIM_SECKEY1                              SIM_SECKEY1_REG(SIM)
#define SIM_SECKEY2                              SIM_SECKEY2_REG(SIM)
#define SIM_SECKEY3                              SIM_SECKEY3_REG(SIM)

/*!
 * @}
 */ /* end of group SIM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group SIM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMC_Peripheral_Access_Layer SMC Peripheral Access Layer
 * @{
 */

/** SMC - Register Layout Typedef */
typedef struct {
  __IO uint8_t PMPROT;                             /**< Power Mode Protection register, offset: 0x0 */
  __IO uint8_t PMCTRL;                             /**< Power Mode Control register, offset: 0x1 */
  __IO uint8_t STOPCTRL;                           /**< Stop Control Register, offset: 0x2 */
  __I  uint8_t PMSTAT;                             /**< Power Mode Status register, offset: 0x3 */
} SMC_Type, *SMC_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- SMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMC_Register_Accessor_Macros SMC - Register accessor macros
 * @{
 */


/* SMC - Register accessors */
#define SMC_PMPROT_REG(base)                     ((base)->PMPROT)
#define SMC_PMCTRL_REG(base)                     ((base)->PMCTRL)
#define SMC_STOPCTRL_REG(base)                   ((base)->STOPCTRL)
#define SMC_PMSTAT_REG(base)                     ((base)->PMSTAT)

/*!
 * @}
 */ /* end of group SMC_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- SMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMC_Register_Masks SMC Register Masks
 * @{
 */

/* PMPROT Bit Fields */
#define SMC_PMPROT_AVLLS_MASK                    0x2u
#define SMC_PMPROT_AVLLS_SHIFT                   1
#define SMC_PMPROT_AVLLS_WIDTH                   1
#define SMC_PMPROT_AVLLS(x)                      (((uint8_t)(((uint8_t)(x))<<SMC_PMPROT_AVLLS_SHIFT))&SMC_PMPROT_AVLLS_MASK)
#define SMC_PMPROT_ALLS_MASK                     0x8u
#define SMC_PMPROT_ALLS_SHIFT                    3
#define SMC_PMPROT_ALLS_WIDTH                    1
#define SMC_PMPROT_ALLS(x)                       (((uint8_t)(((uint8_t)(x))<<SMC_PMPROT_ALLS_SHIFT))&SMC_PMPROT_ALLS_MASK)
#define SMC_PMPROT_AVLP_MASK                     0x20u
#define SMC_PMPROT_AVLP_SHIFT                    5
#define SMC_PMPROT_AVLP_WIDTH                    1
#define SMC_PMPROT_AVLP(x)                       (((uint8_t)(((uint8_t)(x))<<SMC_PMPROT_AVLP_SHIFT))&SMC_PMPROT_AVLP_MASK)
#define SMC_PMPROT_AHSRUN_MASK                   0x80u
#define SMC_PMPROT_AHSRUN_SHIFT                  7
#define SMC_PMPROT_AHSRUN_WIDTH                  1
#define SMC_PMPROT_AHSRUN(x)                     (((uint8_t)(((uint8_t)(x))<<SMC_PMPROT_AHSRUN_SHIFT))&SMC_PMPROT_AHSRUN_MASK)
/* PMCTRL Bit Fields */
#define SMC_PMCTRL_STOPM_MASK                    0x7u
#define SMC_PMCTRL_STOPM_SHIFT                   0
#define SMC_PMCTRL_STOPM_WIDTH                   3
#define SMC_PMCTRL_STOPM(x)                      (((uint8_t)(((uint8_t)(x))<<SMC_PMCTRL_STOPM_SHIFT))&SMC_PMCTRL_STOPM_MASK)
#define SMC_PMCTRL_STOPA_MASK                    0x8u
#define SMC_PMCTRL_STOPA_SHIFT                   3
#define SMC_PMCTRL_STOPA_WIDTH                   1
#define SMC_PMCTRL_STOPA(x)                      (((uint8_t)(((uint8_t)(x))<<SMC_PMCTRL_STOPA_SHIFT))&SMC_PMCTRL_STOPA_MASK)
#define SMC_PMCTRL_RUNM_MASK                     0x60u
#define SMC_PMCTRL_RUNM_SHIFT                    5
#define SMC_PMCTRL_RUNM_WIDTH                    2
#define SMC_PMCTRL_RUNM(x)                       (((uint8_t)(((uint8_t)(x))<<SMC_PMCTRL_RUNM_SHIFT))&SMC_PMCTRL_RUNM_MASK)
/* STOPCTRL Bit Fields */
#define SMC_STOPCTRL_LLSM_MASK                   0x7u
#define SMC_STOPCTRL_LLSM_SHIFT                  0
#define SMC_STOPCTRL_LLSM_WIDTH                  3
#define SMC_STOPCTRL_LLSM(x)                     (((uint8_t)(((uint8_t)(x))<<SMC_STOPCTRL_LLSM_SHIFT))&SMC_STOPCTRL_LLSM_MASK)
#define SMC_STOPCTRL_LPOPO_MASK                  0x8u
#define SMC_STOPCTRL_LPOPO_SHIFT                 3
#define SMC_STOPCTRL_LPOPO_WIDTH                 1
#define SMC_STOPCTRL_LPOPO(x)                    (((uint8_t)(((uint8_t)(x))<<SMC_STOPCTRL_LPOPO_SHIFT))&SMC_STOPCTRL_LPOPO_MASK)
#define SMC_STOPCTRL_PORPO_MASK                  0x20u
#define SMC_STOPCTRL_PORPO_SHIFT                 5
#define SMC_STOPCTRL_PORPO_WIDTH                 1
#define SMC_STOPCTRL_PORPO(x)                    (((uint8_t)(((uint8_t)(x))<<SMC_STOPCTRL_PORPO_SHIFT))&SMC_STOPCTRL_PORPO_MASK)
#define SMC_STOPCTRL_PSTOPO_MASK                 0xC0u
#define SMC_STOPCTRL_PSTOPO_SHIFT                6
#define SMC_STOPCTRL_PSTOPO_WIDTH                2
#define SMC_STOPCTRL_PSTOPO(x)                   (((uint8_t)(((uint8_t)(x))<<SMC_STOPCTRL_PSTOPO_SHIFT))&SMC_STOPCTRL_PSTOPO_MASK)
/* PMSTAT Bit Fields */
#define SMC_PMSTAT_PMSTAT_MASK                   0xFFu
#define SMC_PMSTAT_PMSTAT_SHIFT                  0
#define SMC_PMSTAT_PMSTAT_WIDTH                  8
#define SMC_PMSTAT_PMSTAT(x)                     (((uint8_t)(((uint8_t)(x))<<SMC_PMSTAT_PMSTAT_SHIFT))&SMC_PMSTAT_PMSTAT_MASK)

/*!
 * @}
 */ /* end of group SMC_Register_Masks */


/* SMC - Peripheral instance base addresses */
/** Peripheral SMC base address */
#define SMC_BASE                                 (0x4007E000u)
/** Peripheral SMC base pointer */
#define SMC                                      ((SMC_Type *)SMC_BASE)
#define SMC_BASE_PTR                             (SMC)
/** Array initializer of SMC peripheral base addresses */
#define SMC_BASE_ADDRS                           { SMC_BASE }
/** Array initializer of SMC peripheral base pointers */
#define SMC_BASE_PTRS                            { SMC }

/* ----------------------------------------------------------------------------
   -- SMC - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SMC_Register_Accessor_Macros SMC - Register accessor macros
 * @{
 */


/* SMC - Register instance definitions */
/* SMC */
#define SMC_PMPROT                               SMC_PMPROT_REG(SMC)
#define SMC_PMCTRL                               SMC_PMCTRL_REG(SMC)
#define SMC_STOPCTRL                             SMC_STOPCTRL_REG(SMC)
#define SMC_PMSTAT                               SMC_PMSTAT_REG(SMC)

/*!
 * @}
 */ /* end of group SMC_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group SMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- SPI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Peripheral_Access_Layer SPI Peripheral Access Layer
 * @{
 */

/** SPI - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration Register, offset: 0x0 */
       uint8_t RESERVED_0[4];
  __IO uint32_t TCR;                               /**< Transfer Count Register, offset: 0x8 */
  union {                                          /* offset: 0xC */
    __IO uint32_t CTAR[2];                           /**< Clock and Transfer Attributes Register (In Master Mode), array offset: 0xC, array step: 0x4 */
    __IO uint32_t CTAR_SLAVE[1];                     /**< Clock and Transfer Attributes Register (In Slave Mode), array offset: 0xC, array step: 0x4 */
  };
       uint8_t RESERVED_1[24];
  __IO uint32_t SR;                                /**< Status Register, offset: 0x2C */
  __IO uint32_t RSER;                              /**< DMA/Interrupt Request Select and Enable Register, offset: 0x30 */
  union {                                          /* offset: 0x34 */
    __IO uint32_t PUSHR;                             /**< PUSH TX FIFO Register In Master Mode, offset: 0x34 */
    __IO uint32_t PUSHR_SLAVE;                       /**< PUSH TX FIFO Register In Slave Mode, offset: 0x34 */
  };
  __I  uint32_t POPR;                              /**< POP RX FIFO Register, offset: 0x38 */
  __I  uint32_t TXFR0;                             /**< Transmit FIFO Registers, offset: 0x3C */
  __I  uint32_t TXFR1;                             /**< Transmit FIFO Registers, offset: 0x40 */
  __I  uint32_t TXFR2;                             /**< Transmit FIFO Registers, offset: 0x44 */
  __I  uint32_t TXFR3;                             /**< Transmit FIFO Registers, offset: 0x48 */
       uint8_t RESERVED_2[48];
  __I  uint32_t RXFR0;                             /**< Receive FIFO Registers, offset: 0x7C */
  __I  uint32_t RXFR1;                             /**< Receive FIFO Registers, offset: 0x80 */
  __I  uint32_t RXFR2;                             /**< Receive FIFO Registers, offset: 0x84 */
  __I  uint32_t RXFR3;                             /**< Receive FIFO Registers, offset: 0x88 */
} SPI_Type, *SPI_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- SPI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Register_Accessor_Macros SPI - Register accessor macros
 * @{
 */


/* SPI - Register accessors */
#define SPI_MCR_REG(base)                        ((base)->MCR)
#define SPI_TCR_REG(base)                        ((base)->TCR)
#define SPI_CTAR_REG(base,index2)                ((base)->CTAR[index2])
#define SPI_CTAR_COUNT                           2
#define SPI_CTAR_SLAVE_REG(base,index2)          ((base)->CTAR_SLAVE[index2])
#define SPI_CTAR_SLAVE_COUNT                     1
#define SPI_SR_REG(base)                         ((base)->SR)
#define SPI_RSER_REG(base)                       ((base)->RSER)
#define SPI_PUSHR_REG(base)                      ((base)->PUSHR)
#define SPI_PUSHR_SLAVE_REG(base)                ((base)->PUSHR_SLAVE)
#define SPI_POPR_REG(base)                       ((base)->POPR)
#define SPI_TXFR0_REG(base)                      ((base)->TXFR0)
#define SPI_TXFR1_REG(base)                      ((base)->TXFR1)
#define SPI_TXFR2_REG(base)                      ((base)->TXFR2)
#define SPI_TXFR3_REG(base)                      ((base)->TXFR3)
#define SPI_RXFR0_REG(base)                      ((base)->RXFR0)
#define SPI_RXFR1_REG(base)                      ((base)->RXFR1)
#define SPI_RXFR2_REG(base)                      ((base)->RXFR2)
#define SPI_RXFR3_REG(base)                      ((base)->RXFR3)

/*!
 * @}
 */ /* end of group SPI_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- SPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Register_Masks SPI Register Masks
 * @{
 */

/* MCR Bit Fields */
#define SPI_MCR_HALT_MASK                        0x1u
#define SPI_MCR_HALT_SHIFT                       0
#define SPI_MCR_HALT_WIDTH                       1
#define SPI_MCR_HALT(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_MCR_HALT_SHIFT))&SPI_MCR_HALT_MASK)
#define SPI_MCR_SMPL_PT_MASK                     0x300u
#define SPI_MCR_SMPL_PT_SHIFT                    8
#define SPI_MCR_SMPL_PT_WIDTH                    2
#define SPI_MCR_SMPL_PT(x)                       (((uint32_t)(((uint32_t)(x))<<SPI_MCR_SMPL_PT_SHIFT))&SPI_MCR_SMPL_PT_MASK)
#define SPI_MCR_CLR_RXF_MASK                     0x400u
#define SPI_MCR_CLR_RXF_SHIFT                    10
#define SPI_MCR_CLR_RXF_WIDTH                    1
#define SPI_MCR_CLR_RXF(x)                       (((uint32_t)(((uint32_t)(x))<<SPI_MCR_CLR_RXF_SHIFT))&SPI_MCR_CLR_RXF_MASK)
#define SPI_MCR_CLR_TXF_MASK                     0x800u
#define SPI_MCR_CLR_TXF_SHIFT                    11
#define SPI_MCR_CLR_TXF_WIDTH                    1
#define SPI_MCR_CLR_TXF(x)                       (((uint32_t)(((uint32_t)(x))<<SPI_MCR_CLR_TXF_SHIFT))&SPI_MCR_CLR_TXF_MASK)
#define SPI_MCR_DIS_RXF_MASK                     0x1000u
#define SPI_MCR_DIS_RXF_SHIFT                    12
#define SPI_MCR_DIS_RXF_WIDTH                    1
#define SPI_MCR_DIS_RXF(x)                       (((uint32_t)(((uint32_t)(x))<<SPI_MCR_DIS_RXF_SHIFT))&SPI_MCR_DIS_RXF_MASK)
#define SPI_MCR_DIS_TXF_MASK                     0x2000u
#define SPI_MCR_DIS_TXF_SHIFT                    13
#define SPI_MCR_DIS_TXF_WIDTH                    1
#define SPI_MCR_DIS_TXF(x)                       (((uint32_t)(((uint32_t)(x))<<SPI_MCR_DIS_TXF_SHIFT))&SPI_MCR_DIS_TXF_MASK)
#define SPI_MCR_MDIS_MASK                        0x4000u
#define SPI_MCR_MDIS_SHIFT                       14
#define SPI_MCR_MDIS_WIDTH                       1
#define SPI_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_MCR_MDIS_SHIFT))&SPI_MCR_MDIS_MASK)
#define SPI_MCR_DOZE_MASK                        0x8000u
#define SPI_MCR_DOZE_SHIFT                       15
#define SPI_MCR_DOZE_WIDTH                       1
#define SPI_MCR_DOZE(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_MCR_DOZE_SHIFT))&SPI_MCR_DOZE_MASK)
#define SPI_MCR_PCSIS_MASK                       0x3F0000u
#define SPI_MCR_PCSIS_SHIFT                      16
#define SPI_MCR_PCSIS_WIDTH                      6
#define SPI_MCR_PCSIS(x)                         (((uint32_t)(((uint32_t)(x))<<SPI_MCR_PCSIS_SHIFT))&SPI_MCR_PCSIS_MASK)
#define SPI_MCR_ROOE_MASK                        0x1000000u
#define SPI_MCR_ROOE_SHIFT                       24
#define SPI_MCR_ROOE_WIDTH                       1
#define SPI_MCR_ROOE(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_MCR_ROOE_SHIFT))&SPI_MCR_ROOE_MASK)
#define SPI_MCR_PCSSE_MASK                       0x2000000u
#define SPI_MCR_PCSSE_SHIFT                      25
#define SPI_MCR_PCSSE_WIDTH                      1
#define SPI_MCR_PCSSE(x)                         (((uint32_t)(((uint32_t)(x))<<SPI_MCR_PCSSE_SHIFT))&SPI_MCR_PCSSE_MASK)
#define SPI_MCR_MTFE_MASK                        0x4000000u
#define SPI_MCR_MTFE_SHIFT                       26
#define SPI_MCR_MTFE_WIDTH                       1
#define SPI_MCR_MTFE(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_MCR_MTFE_SHIFT))&SPI_MCR_MTFE_MASK)
#define SPI_MCR_FRZ_MASK                         0x8000000u
#define SPI_MCR_FRZ_SHIFT                        27
#define SPI_MCR_FRZ_WIDTH                        1
#define SPI_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x))<<SPI_MCR_FRZ_SHIFT))&SPI_MCR_FRZ_MASK)
#define SPI_MCR_DCONF_MASK                       0x30000000u
#define SPI_MCR_DCONF_SHIFT                      28
#define SPI_MCR_DCONF_WIDTH                      2
#define SPI_MCR_DCONF(x)                         (((uint32_t)(((uint32_t)(x))<<SPI_MCR_DCONF_SHIFT))&SPI_MCR_DCONF_MASK)
#define SPI_MCR_CONT_SCKE_MASK                   0x40000000u
#define SPI_MCR_CONT_SCKE_SHIFT                  30
#define SPI_MCR_CONT_SCKE_WIDTH                  1
#define SPI_MCR_CONT_SCKE(x)                     (((uint32_t)(((uint32_t)(x))<<SPI_MCR_CONT_SCKE_SHIFT))&SPI_MCR_CONT_SCKE_MASK)
#define SPI_MCR_MSTR_MASK                        0x80000000u
#define SPI_MCR_MSTR_SHIFT                       31
#define SPI_MCR_MSTR_WIDTH                       1
#define SPI_MCR_MSTR(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_MCR_MSTR_SHIFT))&SPI_MCR_MSTR_MASK)
/* TCR Bit Fields */
#define SPI_TCR_SPI_TCNT_MASK                    0xFFFF0000u
#define SPI_TCR_SPI_TCNT_SHIFT                   16
#define SPI_TCR_SPI_TCNT_WIDTH                   16
#define SPI_TCR_SPI_TCNT(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_TCR_SPI_TCNT_SHIFT))&SPI_TCR_SPI_TCNT_MASK)
/* CTAR Bit Fields */
#define SPI_CTAR_BR_MASK                         0xFu
#define SPI_CTAR_BR_SHIFT                        0
#define SPI_CTAR_BR_WIDTH                        4
#define SPI_CTAR_BR(x)                           (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_BR_SHIFT))&SPI_CTAR_BR_MASK)
#define SPI_CTAR_DT_MASK                         0xF0u
#define SPI_CTAR_DT_SHIFT                        4
#define SPI_CTAR_DT_WIDTH                        4
#define SPI_CTAR_DT(x)                           (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_DT_SHIFT))&SPI_CTAR_DT_MASK)
#define SPI_CTAR_ASC_MASK                        0xF00u
#define SPI_CTAR_ASC_SHIFT                       8
#define SPI_CTAR_ASC_WIDTH                       4
#define SPI_CTAR_ASC(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_ASC_SHIFT))&SPI_CTAR_ASC_MASK)
#define SPI_CTAR_CSSCK_MASK                      0xF000u
#define SPI_CTAR_CSSCK_SHIFT                     12
#define SPI_CTAR_CSSCK_WIDTH                     4
#define SPI_CTAR_CSSCK(x)                        (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_CSSCK_SHIFT))&SPI_CTAR_CSSCK_MASK)
#define SPI_CTAR_PBR_MASK                        0x30000u
#define SPI_CTAR_PBR_SHIFT                       16
#define SPI_CTAR_PBR_WIDTH                       2
#define SPI_CTAR_PBR(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_PBR_SHIFT))&SPI_CTAR_PBR_MASK)
#define SPI_CTAR_PDT_MASK                        0xC0000u
#define SPI_CTAR_PDT_SHIFT                       18
#define SPI_CTAR_PDT_WIDTH                       2
#define SPI_CTAR_PDT(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_PDT_SHIFT))&SPI_CTAR_PDT_MASK)
#define SPI_CTAR_PASC_MASK                       0x300000u
#define SPI_CTAR_PASC_SHIFT                      20
#define SPI_CTAR_PASC_WIDTH                      2
#define SPI_CTAR_PASC(x)                         (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_PASC_SHIFT))&SPI_CTAR_PASC_MASK)
#define SPI_CTAR_PCSSCK_MASK                     0xC00000u
#define SPI_CTAR_PCSSCK_SHIFT                    22
#define SPI_CTAR_PCSSCK_WIDTH                    2
#define SPI_CTAR_PCSSCK(x)                       (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_PCSSCK_SHIFT))&SPI_CTAR_PCSSCK_MASK)
#define SPI_CTAR_LSBFE_MASK                      0x1000000u
#define SPI_CTAR_LSBFE_SHIFT                     24
#define SPI_CTAR_LSBFE_WIDTH                     1
#define SPI_CTAR_LSBFE(x)                        (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_LSBFE_SHIFT))&SPI_CTAR_LSBFE_MASK)
#define SPI_CTAR_CPHA_MASK                       0x2000000u
#define SPI_CTAR_CPHA_SHIFT                      25
#define SPI_CTAR_CPHA_WIDTH                      1
#define SPI_CTAR_CPHA(x)                         (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_CPHA_SHIFT))&SPI_CTAR_CPHA_MASK)
#define SPI_CTAR_CPOL_MASK                       0x4000000u
#define SPI_CTAR_CPOL_SHIFT                      26
#define SPI_CTAR_CPOL_WIDTH                      1
#define SPI_CTAR_CPOL(x)                         (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_CPOL_SHIFT))&SPI_CTAR_CPOL_MASK)
#define SPI_CTAR_FMSZ_MASK                       0x78000000u
#define SPI_CTAR_FMSZ_SHIFT                      27
#define SPI_CTAR_FMSZ_WIDTH                      4
#define SPI_CTAR_FMSZ(x)                         (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_FMSZ_SHIFT))&SPI_CTAR_FMSZ_MASK)
#define SPI_CTAR_DBR_MASK                        0x80000000u
#define SPI_CTAR_DBR_SHIFT                       31
#define SPI_CTAR_DBR_WIDTH                       1
#define SPI_CTAR_DBR(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_DBR_SHIFT))&SPI_CTAR_DBR_MASK)
/* CTAR_SLAVE Bit Fields */
#define SPI_CTAR_SLAVE_CPHA_MASK                 0x2000000u
#define SPI_CTAR_SLAVE_CPHA_SHIFT                25
#define SPI_CTAR_SLAVE_CPHA_WIDTH                1
#define SPI_CTAR_SLAVE_CPHA(x)                   (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_SLAVE_CPHA_SHIFT))&SPI_CTAR_SLAVE_CPHA_MASK)
#define SPI_CTAR_SLAVE_CPOL_MASK                 0x4000000u
#define SPI_CTAR_SLAVE_CPOL_SHIFT                26
#define SPI_CTAR_SLAVE_CPOL_WIDTH                1
#define SPI_CTAR_SLAVE_CPOL(x)                   (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_SLAVE_CPOL_SHIFT))&SPI_CTAR_SLAVE_CPOL_MASK)
#define SPI_CTAR_SLAVE_FMSZ_MASK                 0x78000000u
#define SPI_CTAR_SLAVE_FMSZ_SHIFT                27
#define SPI_CTAR_SLAVE_FMSZ_WIDTH                4
#define SPI_CTAR_SLAVE_FMSZ(x)                   (((uint32_t)(((uint32_t)(x))<<SPI_CTAR_SLAVE_FMSZ_SHIFT))&SPI_CTAR_SLAVE_FMSZ_MASK)
/* SR Bit Fields */
#define SPI_SR_POPNXTPTR_MASK                    0xFu
#define SPI_SR_POPNXTPTR_SHIFT                   0
#define SPI_SR_POPNXTPTR_WIDTH                   4
#define SPI_SR_POPNXTPTR(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_SR_POPNXTPTR_SHIFT))&SPI_SR_POPNXTPTR_MASK)
#define SPI_SR_RXCTR_MASK                        0xF0u
#define SPI_SR_RXCTR_SHIFT                       4
#define SPI_SR_RXCTR_WIDTH                       4
#define SPI_SR_RXCTR(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_SR_RXCTR_SHIFT))&SPI_SR_RXCTR_MASK)
#define SPI_SR_TXNXTPTR_MASK                     0xF00u
#define SPI_SR_TXNXTPTR_SHIFT                    8
#define SPI_SR_TXNXTPTR_WIDTH                    4
#define SPI_SR_TXNXTPTR(x)                       (((uint32_t)(((uint32_t)(x))<<SPI_SR_TXNXTPTR_SHIFT))&SPI_SR_TXNXTPTR_MASK)
#define SPI_SR_TXCTR_MASK                        0xF000u
#define SPI_SR_TXCTR_SHIFT                       12
#define SPI_SR_TXCTR_WIDTH                       4
#define SPI_SR_TXCTR(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_SR_TXCTR_SHIFT))&SPI_SR_TXCTR_MASK)
#define SPI_SR_RFDF_MASK                         0x20000u
#define SPI_SR_RFDF_SHIFT                        17
#define SPI_SR_RFDF_WIDTH                        1
#define SPI_SR_RFDF(x)                           (((uint32_t)(((uint32_t)(x))<<SPI_SR_RFDF_SHIFT))&SPI_SR_RFDF_MASK)
#define SPI_SR_RFOF_MASK                         0x80000u
#define SPI_SR_RFOF_SHIFT                        19
#define SPI_SR_RFOF_WIDTH                        1
#define SPI_SR_RFOF(x)                           (((uint32_t)(((uint32_t)(x))<<SPI_SR_RFOF_SHIFT))&SPI_SR_RFOF_MASK)
#define SPI_SR_TFFF_MASK                         0x2000000u
#define SPI_SR_TFFF_SHIFT                        25
#define SPI_SR_TFFF_WIDTH                        1
#define SPI_SR_TFFF(x)                           (((uint32_t)(((uint32_t)(x))<<SPI_SR_TFFF_SHIFT))&SPI_SR_TFFF_MASK)
#define SPI_SR_TFUF_MASK                         0x8000000u
#define SPI_SR_TFUF_SHIFT                        27
#define SPI_SR_TFUF_WIDTH                        1
#define SPI_SR_TFUF(x)                           (((uint32_t)(((uint32_t)(x))<<SPI_SR_TFUF_SHIFT))&SPI_SR_TFUF_MASK)
#define SPI_SR_EOQF_MASK                         0x10000000u
#define SPI_SR_EOQF_SHIFT                        28
#define SPI_SR_EOQF_WIDTH                        1
#define SPI_SR_EOQF(x)                           (((uint32_t)(((uint32_t)(x))<<SPI_SR_EOQF_SHIFT))&SPI_SR_EOQF_MASK)
#define SPI_SR_TXRXS_MASK                        0x40000000u
#define SPI_SR_TXRXS_SHIFT                       30
#define SPI_SR_TXRXS_WIDTH                       1
#define SPI_SR_TXRXS(x)                          (((uint32_t)(((uint32_t)(x))<<SPI_SR_TXRXS_SHIFT))&SPI_SR_TXRXS_MASK)
#define SPI_SR_TCF_MASK                          0x80000000u
#define SPI_SR_TCF_SHIFT                         31
#define SPI_SR_TCF_WIDTH                         1
#define SPI_SR_TCF(x)                            (((uint32_t)(((uint32_t)(x))<<SPI_SR_TCF_SHIFT))&SPI_SR_TCF_MASK)
/* RSER Bit Fields */
#define SPI_RSER_RFDF_DIRS_MASK                  0x10000u
#define SPI_RSER_RFDF_DIRS_SHIFT                 16
#define SPI_RSER_RFDF_DIRS_WIDTH                 1
#define SPI_RSER_RFDF_DIRS(x)                    (((uint32_t)(((uint32_t)(x))<<SPI_RSER_RFDF_DIRS_SHIFT))&SPI_RSER_RFDF_DIRS_MASK)
#define SPI_RSER_RFDF_RE_MASK                    0x20000u
#define SPI_RSER_RFDF_RE_SHIFT                   17
#define SPI_RSER_RFDF_RE_WIDTH                   1
#define SPI_RSER_RFDF_RE(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_RSER_RFDF_RE_SHIFT))&SPI_RSER_RFDF_RE_MASK)
#define SPI_RSER_RFOF_RE_MASK                    0x80000u
#define SPI_RSER_RFOF_RE_SHIFT                   19
#define SPI_RSER_RFOF_RE_WIDTH                   1
#define SPI_RSER_RFOF_RE(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_RSER_RFOF_RE_SHIFT))&SPI_RSER_RFOF_RE_MASK)
#define SPI_RSER_TFFF_DIRS_MASK                  0x1000000u
#define SPI_RSER_TFFF_DIRS_SHIFT                 24
#define SPI_RSER_TFFF_DIRS_WIDTH                 1
#define SPI_RSER_TFFF_DIRS(x)                    (((uint32_t)(((uint32_t)(x))<<SPI_RSER_TFFF_DIRS_SHIFT))&SPI_RSER_TFFF_DIRS_MASK)
#define SPI_RSER_TFFF_RE_MASK                    0x2000000u
#define SPI_RSER_TFFF_RE_SHIFT                   25
#define SPI_RSER_TFFF_RE_WIDTH                   1
#define SPI_RSER_TFFF_RE(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_RSER_TFFF_RE_SHIFT))&SPI_RSER_TFFF_RE_MASK)
#define SPI_RSER_TFUF_RE_MASK                    0x8000000u
#define SPI_RSER_TFUF_RE_SHIFT                   27
#define SPI_RSER_TFUF_RE_WIDTH                   1
#define SPI_RSER_TFUF_RE(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_RSER_TFUF_RE_SHIFT))&SPI_RSER_TFUF_RE_MASK)
#define SPI_RSER_EOQF_RE_MASK                    0x10000000u
#define SPI_RSER_EOQF_RE_SHIFT                   28
#define SPI_RSER_EOQF_RE_WIDTH                   1
#define SPI_RSER_EOQF_RE(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_RSER_EOQF_RE_SHIFT))&SPI_RSER_EOQF_RE_MASK)
#define SPI_RSER_TCF_RE_MASK                     0x80000000u
#define SPI_RSER_TCF_RE_SHIFT                    31
#define SPI_RSER_TCF_RE_WIDTH                    1
#define SPI_RSER_TCF_RE(x)                       (((uint32_t)(((uint32_t)(x))<<SPI_RSER_TCF_RE_SHIFT))&SPI_RSER_TCF_RE_MASK)
/* PUSHR Bit Fields */
#define SPI_PUSHR_TXDATA_MASK                    0xFFFFu
#define SPI_PUSHR_TXDATA_SHIFT                   0
#define SPI_PUSHR_TXDATA_WIDTH                   16
#define SPI_PUSHR_TXDATA(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_PUSHR_TXDATA_SHIFT))&SPI_PUSHR_TXDATA_MASK)
#define SPI_PUSHR_PCS_MASK                       0x3F0000u
#define SPI_PUSHR_PCS_SHIFT                      16
#define SPI_PUSHR_PCS_WIDTH                      6
#define SPI_PUSHR_PCS(x)                         (((uint32_t)(((uint32_t)(x))<<SPI_PUSHR_PCS_SHIFT))&SPI_PUSHR_PCS_MASK)
#define SPI_PUSHR_CTCNT_MASK                     0x4000000u
#define SPI_PUSHR_CTCNT_SHIFT                    26
#define SPI_PUSHR_CTCNT_WIDTH                    1
#define SPI_PUSHR_CTCNT(x)                       (((uint32_t)(((uint32_t)(x))<<SPI_PUSHR_CTCNT_SHIFT))&SPI_PUSHR_CTCNT_MASK)
#define SPI_PUSHR_EOQ_MASK                       0x8000000u
#define SPI_PUSHR_EOQ_SHIFT                      27
#define SPI_PUSHR_EOQ_WIDTH                      1
#define SPI_PUSHR_EOQ(x)                         (((uint32_t)(((uint32_t)(x))<<SPI_PUSHR_EOQ_SHIFT))&SPI_PUSHR_EOQ_MASK)
#define SPI_PUSHR_CTAS_MASK                      0x70000000u
#define SPI_PUSHR_CTAS_SHIFT                     28
#define SPI_PUSHR_CTAS_WIDTH                     3
#define SPI_PUSHR_CTAS(x)                        (((uint32_t)(((uint32_t)(x))<<SPI_PUSHR_CTAS_SHIFT))&SPI_PUSHR_CTAS_MASK)
#define SPI_PUSHR_CONT_MASK                      0x80000000u
#define SPI_PUSHR_CONT_SHIFT                     31
#define SPI_PUSHR_CONT_WIDTH                     1
#define SPI_PUSHR_CONT(x)                        (((uint32_t)(((uint32_t)(x))<<SPI_PUSHR_CONT_SHIFT))&SPI_PUSHR_CONT_MASK)
/* PUSHR_SLAVE Bit Fields */
#define SPI_PUSHR_SLAVE_TXDATA_MASK              0xFFFFu
#define SPI_PUSHR_SLAVE_TXDATA_SHIFT             0
#define SPI_PUSHR_SLAVE_TXDATA_WIDTH             16
#define SPI_PUSHR_SLAVE_TXDATA(x)                (((uint32_t)(((uint32_t)(x))<<SPI_PUSHR_SLAVE_TXDATA_SHIFT))&SPI_PUSHR_SLAVE_TXDATA_MASK)
/* POPR Bit Fields */
#define SPI_POPR_RXDATA_MASK                     0xFFFFFFFFu
#define SPI_POPR_RXDATA_SHIFT                    0
#define SPI_POPR_RXDATA_WIDTH                    32
#define SPI_POPR_RXDATA(x)                       (((uint32_t)(((uint32_t)(x))<<SPI_POPR_RXDATA_SHIFT))&SPI_POPR_RXDATA_MASK)
/* TXFR0 Bit Fields */
#define SPI_TXFR0_TXDATA_MASK                    0xFFFFu
#define SPI_TXFR0_TXDATA_SHIFT                   0
#define SPI_TXFR0_TXDATA_WIDTH                   16
#define SPI_TXFR0_TXDATA(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_TXFR0_TXDATA_SHIFT))&SPI_TXFR0_TXDATA_MASK)
#define SPI_TXFR0_TXCMD_TXDATA_MASK              0xFFFF0000u
#define SPI_TXFR0_TXCMD_TXDATA_SHIFT             16
#define SPI_TXFR0_TXCMD_TXDATA_WIDTH             16
#define SPI_TXFR0_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x))<<SPI_TXFR0_TXCMD_TXDATA_SHIFT))&SPI_TXFR0_TXCMD_TXDATA_MASK)
/* TXFR1 Bit Fields */
#define SPI_TXFR1_TXDATA_MASK                    0xFFFFu
#define SPI_TXFR1_TXDATA_SHIFT                   0
#define SPI_TXFR1_TXDATA_WIDTH                   16
#define SPI_TXFR1_TXDATA(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_TXFR1_TXDATA_SHIFT))&SPI_TXFR1_TXDATA_MASK)
#define SPI_TXFR1_TXCMD_TXDATA_MASK              0xFFFF0000u
#define SPI_TXFR1_TXCMD_TXDATA_SHIFT             16
#define SPI_TXFR1_TXCMD_TXDATA_WIDTH             16
#define SPI_TXFR1_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x))<<SPI_TXFR1_TXCMD_TXDATA_SHIFT))&SPI_TXFR1_TXCMD_TXDATA_MASK)
/* TXFR2 Bit Fields */
#define SPI_TXFR2_TXDATA_MASK                    0xFFFFu
#define SPI_TXFR2_TXDATA_SHIFT                   0
#define SPI_TXFR2_TXDATA_WIDTH                   16
#define SPI_TXFR2_TXDATA(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_TXFR2_TXDATA_SHIFT))&SPI_TXFR2_TXDATA_MASK)
#define SPI_TXFR2_TXCMD_TXDATA_MASK              0xFFFF0000u
#define SPI_TXFR2_TXCMD_TXDATA_SHIFT             16
#define SPI_TXFR2_TXCMD_TXDATA_WIDTH             16
#define SPI_TXFR2_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x))<<SPI_TXFR2_TXCMD_TXDATA_SHIFT))&SPI_TXFR2_TXCMD_TXDATA_MASK)
/* TXFR3 Bit Fields */
#define SPI_TXFR3_TXDATA_MASK                    0xFFFFu
#define SPI_TXFR3_TXDATA_SHIFT                   0
#define SPI_TXFR3_TXDATA_WIDTH                   16
#define SPI_TXFR3_TXDATA(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_TXFR3_TXDATA_SHIFT))&SPI_TXFR3_TXDATA_MASK)
#define SPI_TXFR3_TXCMD_TXDATA_MASK              0xFFFF0000u
#define SPI_TXFR3_TXCMD_TXDATA_SHIFT             16
#define SPI_TXFR3_TXCMD_TXDATA_WIDTH             16
#define SPI_TXFR3_TXCMD_TXDATA(x)                (((uint32_t)(((uint32_t)(x))<<SPI_TXFR3_TXCMD_TXDATA_SHIFT))&SPI_TXFR3_TXCMD_TXDATA_MASK)
/* RXFR0 Bit Fields */
#define SPI_RXFR0_RXDATA_MASK                    0xFFFFFFFFu
#define SPI_RXFR0_RXDATA_SHIFT                   0
#define SPI_RXFR0_RXDATA_WIDTH                   32
#define SPI_RXFR0_RXDATA(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_RXFR0_RXDATA_SHIFT))&SPI_RXFR0_RXDATA_MASK)
/* RXFR1 Bit Fields */
#define SPI_RXFR1_RXDATA_MASK                    0xFFFFFFFFu
#define SPI_RXFR1_RXDATA_SHIFT                   0
#define SPI_RXFR1_RXDATA_WIDTH                   32
#define SPI_RXFR1_RXDATA(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_RXFR1_RXDATA_SHIFT))&SPI_RXFR1_RXDATA_MASK)
/* RXFR2 Bit Fields */
#define SPI_RXFR2_RXDATA_MASK                    0xFFFFFFFFu
#define SPI_RXFR2_RXDATA_SHIFT                   0
#define SPI_RXFR2_RXDATA_WIDTH                   32
#define SPI_RXFR2_RXDATA(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_RXFR2_RXDATA_SHIFT))&SPI_RXFR2_RXDATA_MASK)
/* RXFR3 Bit Fields */
#define SPI_RXFR3_RXDATA_MASK                    0xFFFFFFFFu
#define SPI_RXFR3_RXDATA_SHIFT                   0
#define SPI_RXFR3_RXDATA_WIDTH                   32
#define SPI_RXFR3_RXDATA(x)                      (((uint32_t)(((uint32_t)(x))<<SPI_RXFR3_RXDATA_SHIFT))&SPI_RXFR3_RXDATA_MASK)

/*!
 * @}
 */ /* end of group SPI_Register_Masks */


/* SPI - Peripheral instance base addresses */
/** Peripheral SPI0 base address */
#define SPI0_BASE                                (0x4002C000u)
/** Peripheral SPI0 base pointer */
#define SPI0                                     ((SPI_Type *)SPI0_BASE)
#define SPI0_BASE_PTR                            (SPI0)
/** Peripheral SPI1 base address */
#define SPI1_BASE                                (0x4002D000u)
/** Peripheral SPI1 base pointer */
#define SPI1                                     ((SPI_Type *)SPI1_BASE)
#define SPI1_BASE_PTR                            (SPI1)
/** Array initializer of SPI peripheral base addresses */
#define SPI_BASE_ADDRS                           { SPI0_BASE, SPI1_BASE }
/** Array initializer of SPI peripheral base pointers */
#define SPI_BASE_PTRS                            { SPI0, SPI1 }

/* ----------------------------------------------------------------------------
   -- SPI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup SPI_Register_Accessor_Macros SPI - Register accessor macros
 * @{
 */


/* SPI - Register instance definitions */
/* SPI0 */
#define SPI0_MCR                                 SPI_MCR_REG(SPI0)
#define SPI0_TCR                                 SPI_TCR_REG(SPI0)
#define SPI0_CTAR0                               SPI_CTAR_REG(SPI0,0)
#define SPI0_CTAR0_SLAVE                         SPI_CTAR_SLAVE_REG(SPI0,0)
#define SPI0_CTAR1                               SPI_CTAR_REG(SPI0,1)
#define SPI0_SR                                  SPI_SR_REG(SPI0)
#define SPI0_RSER                                SPI_RSER_REG(SPI0)
#define SPI0_PUSHR                               SPI_PUSHR_REG(SPI0)
#define SPI0_PUSHR_SLAVE                         SPI_PUSHR_SLAVE_REG(SPI0)
#define SPI0_POPR                                SPI_POPR_REG(SPI0)
#define SPI0_TXFR0                               SPI_TXFR0_REG(SPI0)
#define SPI0_TXFR1                               SPI_TXFR1_REG(SPI0)
#define SPI0_TXFR2                               SPI_TXFR2_REG(SPI0)
#define SPI0_TXFR3                               SPI_TXFR3_REG(SPI0)
#define SPI0_RXFR0                               SPI_RXFR0_REG(SPI0)
#define SPI0_RXFR1                               SPI_RXFR1_REG(SPI0)
#define SPI0_RXFR2                               SPI_RXFR2_REG(SPI0)
#define SPI0_RXFR3                               SPI_RXFR3_REG(SPI0)
/* SPI1 */
#define SPI1_MCR                                 SPI_MCR_REG(SPI1)
#define SPI1_TCR                                 SPI_TCR_REG(SPI1)
#define SPI1_CTAR0                               SPI_CTAR_REG(SPI1,0)
#define SPI1_CTAR0_SLAVE                         SPI_CTAR_SLAVE_REG(SPI1,0)
#define SPI1_CTAR1                               SPI_CTAR_REG(SPI1,1)
#define SPI1_SR                                  SPI_SR_REG(SPI1)
#define SPI1_RSER                                SPI_RSER_REG(SPI1)
#define SPI1_PUSHR                               SPI_PUSHR_REG(SPI1)
#define SPI1_PUSHR_SLAVE                         SPI_PUSHR_SLAVE_REG(SPI1)
#define SPI1_POPR                                SPI_POPR_REG(SPI1)
#define SPI1_TXFR0                               SPI_TXFR0_REG(SPI1)
#define SPI1_TXFR1                               SPI_TXFR1_REG(SPI1)
#define SPI1_TXFR2                               SPI_TXFR2_REG(SPI1)
#define SPI1_TXFR3                               SPI_TXFR3_REG(SPI1)
#define SPI1_RXFR0                               SPI_RXFR0_REG(SPI1)
#define SPI1_RXFR1                               SPI_RXFR1_REG(SPI1)
#define SPI1_RXFR2                               SPI_RXFR2_REG(SPI1)
#define SPI1_RXFR3                               SPI_RXFR3_REG(SPI1)

/* SPI - Register array accessors */
#define SPI0_CTAR(index2)                        SPI_CTAR_REG(SPI0,index2)
#define SPI1_CTAR(index2)                        SPI_CTAR_REG(SPI1,index2)
#define SPI0_CTAR_SLAVE(index2)                  SPI_CTAR_SLAVE_REG(SPI0,index2)
#define SPI1_CTAR_SLAVE(index2)                  SPI_CTAR_SLAVE_REG(SPI1,index2)

/*!
 * @}
 */ /* end of group SPI_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group SPI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- TPM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TPM_Peripheral_Access_Layer TPM Peripheral Access Layer
 * @{
 */

/** TPM - Register Layout Typedef */
typedef struct {
  __IO uint32_t SC;                                /**< Status and Control, offset: 0x0 */
  __IO uint32_t CNT;                               /**< Counter, offset: 0x4 */
  __IO uint32_t MOD;                               /**< Modulo, offset: 0x8 */
  struct {                                         /* offset: 0xC, array step: 0x8 */
    __IO uint32_t CnSC;                              /**< Channel (n) Status and Control, array offset: 0xC, array step: 0x8 */
    __IO uint32_t CnV;                               /**< Channel (n) Value, array offset: 0x10, array step: 0x8 */
  } CONTROLS[6];
       uint8_t RESERVED_0[20];
  __IO uint32_t STATUS;                            /**< Capture and Compare Status, offset: 0x50 */
       uint8_t RESERVED_1[16];
  __IO uint32_t COMBINE;                           /**< Combine Channel Register, offset: 0x64 */
       uint8_t RESERVED_2[8];
  __IO uint32_t POL;                               /**< Channel Polarity, offset: 0x70 */
       uint8_t RESERVED_3[4];
  __IO uint32_t FILTER;                            /**< Filter Control, offset: 0x78 */
       uint8_t RESERVED_4[8];
  __IO uint32_t CONF;                              /**< Configuration, offset: 0x84 */
} TPM_Type, *TPM_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- TPM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TPM_Register_Accessor_Macros TPM - Register accessor macros
 * @{
 */


/* TPM - Register accessors */
#define TPM_SC_REG(base)                         ((base)->SC)
#define TPM_CNT_REG(base)                        ((base)->CNT)
#define TPM_MOD_REG(base)                        ((base)->MOD)
#define TPM_CnSC_REG(base,index)                 ((base)->CONTROLS[index].CnSC)
#define TPM_CnSC_COUNT                           6
#define TPM_CnV_REG(base,index)                  ((base)->CONTROLS[index].CnV)
#define TPM_CnV_COUNT                            6
#define TPM_STATUS_REG(base)                     ((base)->STATUS)
#define TPM_COMBINE_REG(base)                    ((base)->COMBINE)
#define TPM_POL_REG(base)                        ((base)->POL)
#define TPM_FILTER_REG(base)                     ((base)->FILTER)
#define TPM_CONF_REG(base)                       ((base)->CONF)

/*!
 * @}
 */ /* end of group TPM_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- TPM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TPM_Register_Masks TPM Register Masks
 * @{
 */

/* SC Bit Fields */
#define TPM_SC_PS_MASK                           0x7u
#define TPM_SC_PS_SHIFT                          0
#define TPM_SC_PS_WIDTH                          3
#define TPM_SC_PS(x)                             (((uint32_t)(((uint32_t)(x))<<TPM_SC_PS_SHIFT))&TPM_SC_PS_MASK)
#define TPM_SC_CMOD_MASK                         0x18u
#define TPM_SC_CMOD_SHIFT                        3
#define TPM_SC_CMOD_WIDTH                        2
#define TPM_SC_CMOD(x)                           (((uint32_t)(((uint32_t)(x))<<TPM_SC_CMOD_SHIFT))&TPM_SC_CMOD_MASK)
#define TPM_SC_CPWMS_MASK                        0x20u
#define TPM_SC_CPWMS_SHIFT                       5
#define TPM_SC_CPWMS_WIDTH                       1
#define TPM_SC_CPWMS(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_SC_CPWMS_SHIFT))&TPM_SC_CPWMS_MASK)
#define TPM_SC_TOIE_MASK                         0x40u
#define TPM_SC_TOIE_SHIFT                        6
#define TPM_SC_TOIE_WIDTH                        1
#define TPM_SC_TOIE(x)                           (((uint32_t)(((uint32_t)(x))<<TPM_SC_TOIE_SHIFT))&TPM_SC_TOIE_MASK)
#define TPM_SC_TOF_MASK                          0x80u
#define TPM_SC_TOF_SHIFT                         7
#define TPM_SC_TOF_WIDTH                         1
#define TPM_SC_TOF(x)                            (((uint32_t)(((uint32_t)(x))<<TPM_SC_TOF_SHIFT))&TPM_SC_TOF_MASK)
#define TPM_SC_DMA_MASK                          0x100u
#define TPM_SC_DMA_SHIFT                         8
#define TPM_SC_DMA_WIDTH                         1
#define TPM_SC_DMA(x)                            (((uint32_t)(((uint32_t)(x))<<TPM_SC_DMA_SHIFT))&TPM_SC_DMA_MASK)
/* CNT Bit Fields */
#define TPM_CNT_COUNT_MASK                       0xFFFFu
#define TPM_CNT_COUNT_SHIFT                      0
#define TPM_CNT_COUNT_WIDTH                      16
#define TPM_CNT_COUNT(x)                         (((uint32_t)(((uint32_t)(x))<<TPM_CNT_COUNT_SHIFT))&TPM_CNT_COUNT_MASK)
/* MOD Bit Fields */
#define TPM_MOD_MOD_MASK                         0xFFFFu
#define TPM_MOD_MOD_SHIFT                        0
#define TPM_MOD_MOD_WIDTH                        16
#define TPM_MOD_MOD(x)                           (((uint32_t)(((uint32_t)(x))<<TPM_MOD_MOD_SHIFT))&TPM_MOD_MOD_MASK)
/* CnSC Bit Fields */
#define TPM_CnSC_DMA_MASK                        0x1u
#define TPM_CnSC_DMA_SHIFT                       0
#define TPM_CnSC_DMA_WIDTH                       1
#define TPM_CnSC_DMA(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_CnSC_DMA_SHIFT))&TPM_CnSC_DMA_MASK)
#define TPM_CnSC_ELSA_MASK                       0x4u
#define TPM_CnSC_ELSA_SHIFT                      2
#define TPM_CnSC_ELSA_WIDTH                      1
#define TPM_CnSC_ELSA(x)                         (((uint32_t)(((uint32_t)(x))<<TPM_CnSC_ELSA_SHIFT))&TPM_CnSC_ELSA_MASK)
#define TPM_CnSC_ELSB_MASK                       0x8u
#define TPM_CnSC_ELSB_SHIFT                      3
#define TPM_CnSC_ELSB_WIDTH                      1
#define TPM_CnSC_ELSB(x)                         (((uint32_t)(((uint32_t)(x))<<TPM_CnSC_ELSB_SHIFT))&TPM_CnSC_ELSB_MASK)
#define TPM_CnSC_MSA_MASK                        0x10u
#define TPM_CnSC_MSA_SHIFT                       4
#define TPM_CnSC_MSA_WIDTH                       1
#define TPM_CnSC_MSA(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_CnSC_MSA_SHIFT))&TPM_CnSC_MSA_MASK)
#define TPM_CnSC_MSB_MASK                        0x20u
#define TPM_CnSC_MSB_SHIFT                       5
#define TPM_CnSC_MSB_WIDTH                       1
#define TPM_CnSC_MSB(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_CnSC_MSB_SHIFT))&TPM_CnSC_MSB_MASK)
#define TPM_CnSC_CHIE_MASK                       0x40u
#define TPM_CnSC_CHIE_SHIFT                      6
#define TPM_CnSC_CHIE_WIDTH                      1
#define TPM_CnSC_CHIE(x)                         (((uint32_t)(((uint32_t)(x))<<TPM_CnSC_CHIE_SHIFT))&TPM_CnSC_CHIE_MASK)
#define TPM_CnSC_CHF_MASK                        0x80u
#define TPM_CnSC_CHF_SHIFT                       7
#define TPM_CnSC_CHF_WIDTH                       1
#define TPM_CnSC_CHF(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_CnSC_CHF_SHIFT))&TPM_CnSC_CHF_MASK)
/* CnV Bit Fields */
#define TPM_CnV_VAL_MASK                         0xFFFFu
#define TPM_CnV_VAL_SHIFT                        0
#define TPM_CnV_VAL_WIDTH                        16
#define TPM_CnV_VAL(x)                           (((uint32_t)(((uint32_t)(x))<<TPM_CnV_VAL_SHIFT))&TPM_CnV_VAL_MASK)
/* STATUS Bit Fields */
#define TPM_STATUS_CH0F_MASK                     0x1u
#define TPM_STATUS_CH0F_SHIFT                    0
#define TPM_STATUS_CH0F_WIDTH                    1
#define TPM_STATUS_CH0F(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_STATUS_CH0F_SHIFT))&TPM_STATUS_CH0F_MASK)
#define TPM_STATUS_CH1F_MASK                     0x2u
#define TPM_STATUS_CH1F_SHIFT                    1
#define TPM_STATUS_CH1F_WIDTH                    1
#define TPM_STATUS_CH1F(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_STATUS_CH1F_SHIFT))&TPM_STATUS_CH1F_MASK)
#define TPM_STATUS_CH2F_MASK                     0x4u
#define TPM_STATUS_CH2F_SHIFT                    2
#define TPM_STATUS_CH2F_WIDTH                    1
#define TPM_STATUS_CH2F(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_STATUS_CH2F_SHIFT))&TPM_STATUS_CH2F_MASK)
#define TPM_STATUS_CH3F_MASK                     0x8u
#define TPM_STATUS_CH3F_SHIFT                    3
#define TPM_STATUS_CH3F_WIDTH                    1
#define TPM_STATUS_CH3F(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_STATUS_CH3F_SHIFT))&TPM_STATUS_CH3F_MASK)
#define TPM_STATUS_CH4F_MASK                     0x10u
#define TPM_STATUS_CH4F_SHIFT                    4
#define TPM_STATUS_CH4F_WIDTH                    1
#define TPM_STATUS_CH4F(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_STATUS_CH4F_SHIFT))&TPM_STATUS_CH4F_MASK)
#define TPM_STATUS_CH5F_MASK                     0x20u
#define TPM_STATUS_CH5F_SHIFT                    5
#define TPM_STATUS_CH5F_WIDTH                    1
#define TPM_STATUS_CH5F(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_STATUS_CH5F_SHIFT))&TPM_STATUS_CH5F_MASK)
#define TPM_STATUS_TOF_MASK                      0x100u
#define TPM_STATUS_TOF_SHIFT                     8
#define TPM_STATUS_TOF_WIDTH                     1
#define TPM_STATUS_TOF(x)                        (((uint32_t)(((uint32_t)(x))<<TPM_STATUS_TOF_SHIFT))&TPM_STATUS_TOF_MASK)
/* COMBINE Bit Fields */
#define TPM_COMBINE_COMBINE0_MASK                0x1u
#define TPM_COMBINE_COMBINE0_SHIFT               0
#define TPM_COMBINE_COMBINE0_WIDTH               1
#define TPM_COMBINE_COMBINE0(x)                  (((uint32_t)(((uint32_t)(x))<<TPM_COMBINE_COMBINE0_SHIFT))&TPM_COMBINE_COMBINE0_MASK)
#define TPM_COMBINE_COMSWAP0_MASK                0x2u
#define TPM_COMBINE_COMSWAP0_SHIFT               1
#define TPM_COMBINE_COMSWAP0_WIDTH               1
#define TPM_COMBINE_COMSWAP0(x)                  (((uint32_t)(((uint32_t)(x))<<TPM_COMBINE_COMSWAP0_SHIFT))&TPM_COMBINE_COMSWAP0_MASK)
#define TPM_COMBINE_COMBINE1_MASK                0x100u
#define TPM_COMBINE_COMBINE1_SHIFT               8
#define TPM_COMBINE_COMBINE1_WIDTH               1
#define TPM_COMBINE_COMBINE1(x)                  (((uint32_t)(((uint32_t)(x))<<TPM_COMBINE_COMBINE1_SHIFT))&TPM_COMBINE_COMBINE1_MASK)
#define TPM_COMBINE_COMSWAP1_MASK                0x200u
#define TPM_COMBINE_COMSWAP1_SHIFT               9
#define TPM_COMBINE_COMSWAP1_WIDTH               1
#define TPM_COMBINE_COMSWAP1(x)                  (((uint32_t)(((uint32_t)(x))<<TPM_COMBINE_COMSWAP1_SHIFT))&TPM_COMBINE_COMSWAP1_MASK)
#define TPM_COMBINE_COMBINE2_MASK                0x10000u
#define TPM_COMBINE_COMBINE2_SHIFT               16
#define TPM_COMBINE_COMBINE2_WIDTH               1
#define TPM_COMBINE_COMBINE2(x)                  (((uint32_t)(((uint32_t)(x))<<TPM_COMBINE_COMBINE2_SHIFT))&TPM_COMBINE_COMBINE2_MASK)
#define TPM_COMBINE_COMSWAP2_MASK                0x20000u
#define TPM_COMBINE_COMSWAP2_SHIFT               17
#define TPM_COMBINE_COMSWAP2_WIDTH               1
#define TPM_COMBINE_COMSWAP2(x)                  (((uint32_t)(((uint32_t)(x))<<TPM_COMBINE_COMSWAP2_SHIFT))&TPM_COMBINE_COMSWAP2_MASK)
/* POL Bit Fields */
#define TPM_POL_POL0_MASK                        0x1u
#define TPM_POL_POL0_SHIFT                       0
#define TPM_POL_POL0_WIDTH                       1
#define TPM_POL_POL0(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_POL_POL0_SHIFT))&TPM_POL_POL0_MASK)
#define TPM_POL_POL1_MASK                        0x2u
#define TPM_POL_POL1_SHIFT                       1
#define TPM_POL_POL1_WIDTH                       1
#define TPM_POL_POL1(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_POL_POL1_SHIFT))&TPM_POL_POL1_MASK)
#define TPM_POL_POL2_MASK                        0x4u
#define TPM_POL_POL2_SHIFT                       2
#define TPM_POL_POL2_WIDTH                       1
#define TPM_POL_POL2(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_POL_POL2_SHIFT))&TPM_POL_POL2_MASK)
#define TPM_POL_POL3_MASK                        0x8u
#define TPM_POL_POL3_SHIFT                       3
#define TPM_POL_POL3_WIDTH                       1
#define TPM_POL_POL3(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_POL_POL3_SHIFT))&TPM_POL_POL3_MASK)
#define TPM_POL_POL4_MASK                        0x10u
#define TPM_POL_POL4_SHIFT                       4
#define TPM_POL_POL4_WIDTH                       1
#define TPM_POL_POL4(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_POL_POL4_SHIFT))&TPM_POL_POL4_MASK)
#define TPM_POL_POL5_MASK                        0x20u
#define TPM_POL_POL5_SHIFT                       5
#define TPM_POL_POL5_WIDTH                       1
#define TPM_POL_POL5(x)                          (((uint32_t)(((uint32_t)(x))<<TPM_POL_POL5_SHIFT))&TPM_POL_POL5_MASK)
/* FILTER Bit Fields */
#define TPM_FILTER_CH0FVAL_MASK                  0xFu
#define TPM_FILTER_CH0FVAL_SHIFT                 0
#define TPM_FILTER_CH0FVAL_WIDTH                 4
#define TPM_FILTER_CH0FVAL(x)                    (((uint32_t)(((uint32_t)(x))<<TPM_FILTER_CH0FVAL_SHIFT))&TPM_FILTER_CH0FVAL_MASK)
#define TPM_FILTER_CH1FVAL_MASK                  0xF0u
#define TPM_FILTER_CH1FVAL_SHIFT                 4
#define TPM_FILTER_CH1FVAL_WIDTH                 4
#define TPM_FILTER_CH1FVAL(x)                    (((uint32_t)(((uint32_t)(x))<<TPM_FILTER_CH1FVAL_SHIFT))&TPM_FILTER_CH1FVAL_MASK)
#define TPM_FILTER_CH2FVAL_MASK                  0xF00u
#define TPM_FILTER_CH2FVAL_SHIFT                 8
#define TPM_FILTER_CH2FVAL_WIDTH                 4
#define TPM_FILTER_CH2FVAL(x)                    (((uint32_t)(((uint32_t)(x))<<TPM_FILTER_CH2FVAL_SHIFT))&TPM_FILTER_CH2FVAL_MASK)
#define TPM_FILTER_CH3FVAL_MASK                  0xF000u
#define TPM_FILTER_CH3FVAL_SHIFT                 12
#define TPM_FILTER_CH3FVAL_WIDTH                 4
#define TPM_FILTER_CH3FVAL(x)                    (((uint32_t)(((uint32_t)(x))<<TPM_FILTER_CH3FVAL_SHIFT))&TPM_FILTER_CH3FVAL_MASK)
#define TPM_FILTER_CH4FVAL_MASK                  0xF0000u
#define TPM_FILTER_CH4FVAL_SHIFT                 16
#define TPM_FILTER_CH4FVAL_WIDTH                 4
#define TPM_FILTER_CH4FVAL(x)                    (((uint32_t)(((uint32_t)(x))<<TPM_FILTER_CH4FVAL_SHIFT))&TPM_FILTER_CH4FVAL_MASK)
#define TPM_FILTER_CH5FVAL_MASK                  0xF00000u
#define TPM_FILTER_CH5FVAL_SHIFT                 20
#define TPM_FILTER_CH5FVAL_WIDTH                 4
#define TPM_FILTER_CH5FVAL(x)                    (((uint32_t)(((uint32_t)(x))<<TPM_FILTER_CH5FVAL_SHIFT))&TPM_FILTER_CH5FVAL_MASK)
/* CONF Bit Fields */
#define TPM_CONF_DOZEEN_MASK                     0x20u
#define TPM_CONF_DOZEEN_SHIFT                    5
#define TPM_CONF_DOZEEN_WIDTH                    1
#define TPM_CONF_DOZEEN(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_CONF_DOZEEN_SHIFT))&TPM_CONF_DOZEEN_MASK)
#define TPM_CONF_DBGMODE_MASK                    0xC0u
#define TPM_CONF_DBGMODE_SHIFT                   6
#define TPM_CONF_DBGMODE_WIDTH                   2
#define TPM_CONF_DBGMODE(x)                      (((uint32_t)(((uint32_t)(x))<<TPM_CONF_DBGMODE_SHIFT))&TPM_CONF_DBGMODE_MASK)
#define TPM_CONF_GTBSYNC_MASK                    0x100u
#define TPM_CONF_GTBSYNC_SHIFT                   8
#define TPM_CONF_GTBSYNC_WIDTH                   1
#define TPM_CONF_GTBSYNC(x)                      (((uint32_t)(((uint32_t)(x))<<TPM_CONF_GTBSYNC_SHIFT))&TPM_CONF_GTBSYNC_MASK)
#define TPM_CONF_GTBEEN_MASK                     0x200u
#define TPM_CONF_GTBEEN_SHIFT                    9
#define TPM_CONF_GTBEEN_WIDTH                    1
#define TPM_CONF_GTBEEN(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_CONF_GTBEEN_SHIFT))&TPM_CONF_GTBEEN_MASK)
#define TPM_CONF_CSOT_MASK                       0x10000u
#define TPM_CONF_CSOT_SHIFT                      16
#define TPM_CONF_CSOT_WIDTH                      1
#define TPM_CONF_CSOT(x)                         (((uint32_t)(((uint32_t)(x))<<TPM_CONF_CSOT_SHIFT))&TPM_CONF_CSOT_MASK)
#define TPM_CONF_CSOO_MASK                       0x20000u
#define TPM_CONF_CSOO_SHIFT                      17
#define TPM_CONF_CSOO_WIDTH                      1
#define TPM_CONF_CSOO(x)                         (((uint32_t)(((uint32_t)(x))<<TPM_CONF_CSOO_SHIFT))&TPM_CONF_CSOO_MASK)
#define TPM_CONF_CROT_MASK                       0x40000u
#define TPM_CONF_CROT_SHIFT                      18
#define TPM_CONF_CROT_WIDTH                      1
#define TPM_CONF_CROT(x)                         (((uint32_t)(((uint32_t)(x))<<TPM_CONF_CROT_SHIFT))&TPM_CONF_CROT_MASK)
#define TPM_CONF_CPOT_MASK                       0x80000u
#define TPM_CONF_CPOT_SHIFT                      19
#define TPM_CONF_CPOT_WIDTH                      1
#define TPM_CONF_CPOT(x)                         (((uint32_t)(((uint32_t)(x))<<TPM_CONF_CPOT_SHIFT))&TPM_CONF_CPOT_MASK)
#define TPM_CONF_TRGPOL_MASK                     0x400000u
#define TPM_CONF_TRGPOL_SHIFT                    22
#define TPM_CONF_TRGPOL_WIDTH                    1
#define TPM_CONF_TRGPOL(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_CONF_TRGPOL_SHIFT))&TPM_CONF_TRGPOL_MASK)
#define TPM_CONF_TRGSRC_MASK                     0x800000u
#define TPM_CONF_TRGSRC_SHIFT                    23
#define TPM_CONF_TRGSRC_WIDTH                    1
#define TPM_CONF_TRGSRC(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_CONF_TRGSRC_SHIFT))&TPM_CONF_TRGSRC_MASK)
#define TPM_CONF_TRGSEL_MASK                     0xF000000u
#define TPM_CONF_TRGSEL_SHIFT                    24
#define TPM_CONF_TRGSEL_WIDTH                    4
#define TPM_CONF_TRGSEL(x)                       (((uint32_t)(((uint32_t)(x))<<TPM_CONF_TRGSEL_SHIFT))&TPM_CONF_TRGSEL_MASK)

/*!
 * @}
 */ /* end of group TPM_Register_Masks */


/* TPM - Peripheral instance base addresses */
/** Peripheral TPM0 base address */
#define TPM0_BASE                                (0x40038000u)
/** Peripheral TPM0 base pointer */
#define TPM0                                     ((TPM_Type *)TPM0_BASE)
#define TPM0_BASE_PTR                            (TPM0)
/** Peripheral TPM1 base address */
#define TPM1_BASE                                (0x40039000u)
/** Peripheral TPM1 base pointer */
#define TPM1                                     ((TPM_Type *)TPM1_BASE)
#define TPM1_BASE_PTR                            (TPM1)
/** Peripheral TPM2 base address */
#define TPM2_BASE                                (0x4003A000u)
/** Peripheral TPM2 base pointer */
#define TPM2                                     ((TPM_Type *)TPM2_BASE)
#define TPM2_BASE_PTR                            (TPM2)
/** Array initializer of TPM peripheral base addresses */
#define TPM_BASE_ADDRS                           { TPM0_BASE, TPM1_BASE, TPM2_BASE }
/** Array initializer of TPM peripheral base pointers */
#define TPM_BASE_PTRS                            { TPM0, TPM1, TPM2 }

/* ----------------------------------------------------------------------------
   -- TPM - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TPM_Register_Accessor_Macros TPM - Register accessor macros
 * @{
 */


/* TPM - Register instance definitions */
/* TPM0 */
#define TPM0_SC                                  TPM_SC_REG(TPM0)
#define TPM0_CNT                                 TPM_CNT_REG(TPM0)
#define TPM0_MOD                                 TPM_MOD_REG(TPM0)
#define TPM0_C0SC                                TPM_CnSC_REG(TPM0,0)
#define TPM0_C0V                                 TPM_CnV_REG(TPM0,0)
#define TPM0_C1SC                                TPM_CnSC_REG(TPM0,1)
#define TPM0_C1V                                 TPM_CnV_REG(TPM0,1)
#define TPM0_C2SC                                TPM_CnSC_REG(TPM0,2)
#define TPM0_C2V                                 TPM_CnV_REG(TPM0,2)
#define TPM0_C3SC                                TPM_CnSC_REG(TPM0,3)
#define TPM0_C3V                                 TPM_CnV_REG(TPM0,3)
#define TPM0_C4SC                                TPM_CnSC_REG(TPM0,4)
#define TPM0_C4V                                 TPM_CnV_REG(TPM0,4)
#define TPM0_C5SC                                TPM_CnSC_REG(TPM0,5)
#define TPM0_C5V                                 TPM_CnV_REG(TPM0,5)
#define TPM0_STATUS                              TPM_STATUS_REG(TPM0)
#define TPM0_COMBINE                             TPM_COMBINE_REG(TPM0)
#define TPM0_POL                                 TPM_POL_REG(TPM0)
#define TPM0_FILTER                              TPM_FILTER_REG(TPM0)
#define TPM0_CONF                                TPM_CONF_REG(TPM0)
/* TPM1 */
#define TPM1_SC                                  TPM_SC_REG(TPM1)
#define TPM1_CNT                                 TPM_CNT_REG(TPM1)
#define TPM1_MOD                                 TPM_MOD_REG(TPM1)
#define TPM1_C0SC                                TPM_CnSC_REG(TPM1,0)
#define TPM1_C0V                                 TPM_CnV_REG(TPM1,0)
#define TPM1_C1SC                                TPM_CnSC_REG(TPM1,1)
#define TPM1_C1V                                 TPM_CnV_REG(TPM1,1)
#define TPM1_STATUS                              TPM_STATUS_REG(TPM1)
#define TPM1_COMBINE                             TPM_COMBINE_REG(TPM1)
#define TPM1_POL                                 TPM_POL_REG(TPM1)
#define TPM1_FILTER                              TPM_FILTER_REG(TPM1)
#define TPM1_CONF                                TPM_CONF_REG(TPM1)
/* TPM2 */
#define TPM2_SC                                  TPM_SC_REG(TPM2)
#define TPM2_CNT                                 TPM_CNT_REG(TPM2)
#define TPM2_MOD                                 TPM_MOD_REG(TPM2)
#define TPM2_C0SC                                TPM_CnSC_REG(TPM2,0)
#define TPM2_C0V                                 TPM_CnV_REG(TPM2,0)
#define TPM2_C1SC                                TPM_CnSC_REG(TPM2,1)
#define TPM2_C1V                                 TPM_CnV_REG(TPM2,1)
#define TPM2_STATUS                              TPM_STATUS_REG(TPM2)
#define TPM2_COMBINE                             TPM_COMBINE_REG(TPM2)
#define TPM2_POL                                 TPM_POL_REG(TPM2)
#define TPM2_FILTER                              TPM_FILTER_REG(TPM2)
#define TPM2_CONF                                TPM_CONF_REG(TPM2)

/* TPM - Register array accessors */
#define TPM0_CnSC(index)                         TPM_CnSC_REG(TPM0,index)
#define TPM1_CnSC(index)                         TPM_CnSC_REG(TPM1,index)
#define TPM2_CnSC(index)                         TPM_CnSC_REG(TPM2,index)
#define TPM0_CnV(index)                          TPM_CnV_REG(TPM0,index)
#define TPM1_CnV(index)                          TPM_CnV_REG(TPM1,index)
#define TPM2_CnV(index)                          TPM_CnV_REG(TPM2,index)

/*!
 * @}
 */ /* end of group TPM_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group TPM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- TRNG Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TRNG_Peripheral_Access_Layer TRNG Peripheral Access Layer
 * @{
 */

/** TRNG - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCTL;                              /**< TRNG0 Miscellaneous Control Register, offset: 0x0 */
  __IO uint32_t SCMISC;                            /**< TRNG0 Statistical Check Miscellaneous Register, offset: 0x4 */
  __IO uint32_t PKRRNG;                            /**< TRNG0 Poker Range Register, offset: 0x8 */
  union {                                          /* offset: 0xC */
    __IO uint32_t PKRMAX;                            /**< TRNG0 Poker Maximum Limit Register, offset: 0xC */
    __I  uint32_t PKRSQ;                             /**< TRNG0 Poker Square Calculation Result Register, offset: 0xC */
  };
  __IO uint32_t SDCTL;                             /**< TRNG0 Seed Control Register, offset: 0x10 */
  union {                                          /* offset: 0x14 */
    __IO uint32_t SBLIM;                             /**< TRNG0 Sparse Bit Limit Register, offset: 0x14 */
    __I  uint32_t TOTSAM;                            /**< TRNG0 Total Samples Register, offset: 0x14 */
  };
  __IO uint32_t FRQMIN;                            /**< TRNG0 Frequency Count Minimum Limit Register, offset: 0x18 */
  union {                                          /* offset: 0x1C */
    __I  uint32_t FRQCNT;                            /**< TRNG0 Frequency Count Register, offset: 0x1C */
    __IO uint32_t FRQMAX;                            /**< TRNG0 Frequency Count Maximum Limit Register, offset: 0x1C */
  };
  union {                                          /* offset: 0x20 */
    __I  uint32_t SCMC;                              /**< TRNG0 Statistical Check Monobit Count Register, offset: 0x20 */
    __IO uint32_t SCML;                              /**< TRNG0 Statistical Check Monobit Limit Register, offset: 0x20 */
  };
  union {                                          /* offset: 0x24 */
    __I  uint32_t SCR1C;                             /**< TRNG0 Statistical Check Run Length 1 Count Register, offset: 0x24 */
    __IO uint32_t SCR1L;                             /**< TRNG0 Statistical Check Run Length 1 Limit Register, offset: 0x24 */
  };
  union {                                          /* offset: 0x28 */
    __I  uint32_t SCR2C;                             /**< TRNG0 Statistical Check Run Length 2 Count Register, offset: 0x28 */
    __IO uint32_t SCR2L;                             /**< TRNG0 Statistical Check Run Length 2 Limit Register, offset: 0x28 */
  };
  union {                                          /* offset: 0x2C */
    __I  uint32_t SCR3C;                             /**< TRNG0 Statistical Check Run Length 3 Count Register, offset: 0x2C */
    __IO uint32_t SCR3L;                             /**< TRNG0 Statistical Check Run Length 3 Limit Register, offset: 0x2C */
  };
  union {                                          /* offset: 0x30 */
    __I  uint32_t SCR4C;                             /**< TRNG0 Statistical Check Run Length 4 Count Register, offset: 0x30 */
    __IO uint32_t SCR4L;                             /**< TRNG0 Statistical Check Run Length 4 Limit Register, offset: 0x30 */
  };
  union {                                          /* offset: 0x34 */
    __I  uint32_t SCR5C;                             /**< TRNG0 Statistical Check Run Length 5 Count Register, offset: 0x34 */
    __IO uint32_t SCR5L;                             /**< TRNG0 Statistical Check Run Length 5 Limit Register, offset: 0x34 */
  };
  union {                                          /* offset: 0x38 */
    __I  uint32_t SCR6PC;                            /**< TRNG0 Statistical Check Run Length 6+ Count Register, offset: 0x38 */
    __IO uint32_t SCR6PL;                            /**< TRNG0 Statistical Check Run Length 6+ Limit Register, offset: 0x38 */
  };
  __I  uint32_t STATUS;                            /**< TRNG0 Status Register, offset: 0x3C */
  __I  uint32_t ENT[16];                           /**< RNG TRNG Entropy Read Register, array offset: 0x40, array step: 0x4 */
  __I  uint32_t PKRCNT10;                          /**< TRNG0 Statistical Check Poker Count 1 and 0 Register, offset: 0x80 */
  __I  uint32_t PKRCNT32;                          /**< TRNG0 Statistical Check Poker Count 3 and 2 Register, offset: 0x84 */
  __I  uint32_t PKRCNT54;                          /**< TRNG0 Statistical Check Poker Count 5 and 4 Register, offset: 0x88 */
  __I  uint32_t PKRCNT76;                          /**< TRNG0 Statistical Check Poker Count 7 and 6 Register, offset: 0x8C */
  __I  uint32_t PKRCNT98;                          /**< TRNG0 Statistical Check Poker Count 9 and 8 Register, offset: 0x90 */
  __I  uint32_t PKRCNTBA;                          /**< TRNG0 Statistical Check Poker Count B and A Register, offset: 0x94 */
  __I  uint32_t PKRCNTDC;                          /**< TRNG0 Statistical Check Poker Count D and C Register, offset: 0x98 */
  __I  uint32_t PKRCNTFE;                          /**< TRNG0 Statistical Check Poker Count F and E Register, offset: 0x9C */
  __IO uint32_t SEC_CFG;                           /**< TRNG0 Security Configuration Register, offset: 0xA0 */
  __IO uint32_t INT_CTRL;                          /**< TRNG0 Interrupt Control Register, offset: 0xA4 */
  __IO uint32_t INT_MASK;                          /**< TRNG0 Mask Register, offset: 0xA8 */
  __IO uint32_t INT_STATUS;                        /**< TRNG0 Interrupt Status Register, offset: 0xAC */
       uint8_t RESERVED_0[64];
  __I  uint32_t VID1;                              /**< TRNG0 Version ID Register (MS), offset: 0xF0 */
  __I  uint32_t VID2;                              /**< TRNG0 Version ID Register (LS), offset: 0xF4 */
} TRNG_Type, *TRNG_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- TRNG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TRNG_Register_Accessor_Macros TRNG - Register accessor macros
 * @{
 */


/* TRNG - Register accessors */
#define TRNG_MCTL_REG(base)                      ((base)->MCTL)
#define TRNG_SCMISC_REG(base)                    ((base)->SCMISC)
#define TRNG_PKRRNG_REG(base)                    ((base)->PKRRNG)
#define TRNG_PKRMAX_REG(base)                    ((base)->PKRMAX)
#define TRNG_PKRSQ_REG(base)                     ((base)->PKRSQ)
#define TRNG_SDCTL_REG(base)                     ((base)->SDCTL)
#define TRNG_SBLIM_REG(base)                     ((base)->SBLIM)
#define TRNG_TOTSAM_REG(base)                    ((base)->TOTSAM)
#define TRNG_FRQMIN_REG(base)                    ((base)->FRQMIN)
#define TRNG_FRQCNT_REG(base)                    ((base)->FRQCNT)
#define TRNG_FRQMAX_REG(base)                    ((base)->FRQMAX)
#define TRNG_SCMC_REG(base)                      ((base)->SCMC)
#define TRNG_SCML_REG(base)                      ((base)->SCML)
#define TRNG_SCR1C_REG(base)                     ((base)->SCR1C)
#define TRNG_SCR1L_REG(base)                     ((base)->SCR1L)
#define TRNG_SCR2C_REG(base)                     ((base)->SCR2C)
#define TRNG_SCR2L_REG(base)                     ((base)->SCR2L)
#define TRNG_SCR3C_REG(base)                     ((base)->SCR3C)
#define TRNG_SCR3L_REG(base)                     ((base)->SCR3L)
#define TRNG_SCR4C_REG(base)                     ((base)->SCR4C)
#define TRNG_SCR4L_REG(base)                     ((base)->SCR4L)
#define TRNG_SCR5C_REG(base)                     ((base)->SCR5C)
#define TRNG_SCR5L_REG(base)                     ((base)->SCR5L)
#define TRNG_SCR6PC_REG(base)                    ((base)->SCR6PC)
#define TRNG_SCR6PL_REG(base)                    ((base)->SCR6PL)
#define TRNG_STATUS_REG(base)                    ((base)->STATUS)
#define TRNG_ENT_REG(base,index)                 ((base)->ENT[index])
#define TRNG_ENT_COUNT                           16
#define TRNG_PKRCNT10_REG(base)                  ((base)->PKRCNT10)
#define TRNG_PKRCNT32_REG(base)                  ((base)->PKRCNT32)
#define TRNG_PKRCNT54_REG(base)                  ((base)->PKRCNT54)
#define TRNG_PKRCNT76_REG(base)                  ((base)->PKRCNT76)
#define TRNG_PKRCNT98_REG(base)                  ((base)->PKRCNT98)
#define TRNG_PKRCNTBA_REG(base)                  ((base)->PKRCNTBA)
#define TRNG_PKRCNTDC_REG(base)                  ((base)->PKRCNTDC)
#define TRNG_PKRCNTFE_REG(base)                  ((base)->PKRCNTFE)
#define TRNG_SEC_CFG_REG(base)                   ((base)->SEC_CFG)
#define TRNG_INT_CTRL_REG(base)                  ((base)->INT_CTRL)
#define TRNG_INT_MASK_REG(base)                  ((base)->INT_MASK)
#define TRNG_INT_STATUS_REG(base)                ((base)->INT_STATUS)
#define TRNG_VID1_REG(base)                      ((base)->VID1)
#define TRNG_VID2_REG(base)                      ((base)->VID2)

/*!
 * @}
 */ /* end of group TRNG_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- TRNG Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TRNG_Register_Masks TRNG Register Masks
 * @{
 */

/* MCTL Bit Fields */
#define TRNG_MCTL_SAMP_MODE_MASK                 0x3u
#define TRNG_MCTL_SAMP_MODE_SHIFT                0
#define TRNG_MCTL_SAMP_MODE_WIDTH                2
#define TRNG_MCTL_SAMP_MODE(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_SAMP_MODE_SHIFT))&TRNG_MCTL_SAMP_MODE_MASK)
#define TRNG_MCTL_OSC_DIV_MASK                   0xCu
#define TRNG_MCTL_OSC_DIV_SHIFT                  2
#define TRNG_MCTL_OSC_DIV_WIDTH                  2
#define TRNG_MCTL_OSC_DIV(x)                     (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_OSC_DIV_SHIFT))&TRNG_MCTL_OSC_DIV_MASK)
#define TRNG_MCTL_UNUSED_MASK                    0x10u
#define TRNG_MCTL_UNUSED_SHIFT                   4
#define TRNG_MCTL_UNUSED_WIDTH                   1
#define TRNG_MCTL_UNUSED(x)                      (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_UNUSED_SHIFT))&TRNG_MCTL_UNUSED_MASK)
#define TRNG_MCTL_TRNG_ACC_MASK                  0x20u
#define TRNG_MCTL_TRNG_ACC_SHIFT                 5
#define TRNG_MCTL_TRNG_ACC_WIDTH                 1
#define TRNG_MCTL_TRNG_ACC(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_TRNG_ACC_SHIFT))&TRNG_MCTL_TRNG_ACC_MASK)
#define TRNG_MCTL_RST_DEF_MASK                   0x40u
#define TRNG_MCTL_RST_DEF_SHIFT                  6
#define TRNG_MCTL_RST_DEF_WIDTH                  1
#define TRNG_MCTL_RST_DEF(x)                     (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_RST_DEF_SHIFT))&TRNG_MCTL_RST_DEF_MASK)
#define TRNG_MCTL_FOR_SCLK_MASK                  0x80u
#define TRNG_MCTL_FOR_SCLK_SHIFT                 7
#define TRNG_MCTL_FOR_SCLK_WIDTH                 1
#define TRNG_MCTL_FOR_SCLK(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_FOR_SCLK_SHIFT))&TRNG_MCTL_FOR_SCLK_MASK)
#define TRNG_MCTL_FCT_FAIL_MASK                  0x100u
#define TRNG_MCTL_FCT_FAIL_SHIFT                 8
#define TRNG_MCTL_FCT_FAIL_WIDTH                 1
#define TRNG_MCTL_FCT_FAIL(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_FCT_FAIL_SHIFT))&TRNG_MCTL_FCT_FAIL_MASK)
#define TRNG_MCTL_FCT_VAL_MASK                   0x200u
#define TRNG_MCTL_FCT_VAL_SHIFT                  9
#define TRNG_MCTL_FCT_VAL_WIDTH                  1
#define TRNG_MCTL_FCT_VAL(x)                     (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_FCT_VAL_SHIFT))&TRNG_MCTL_FCT_VAL_MASK)
#define TRNG_MCTL_ENT_VAL_MASK                   0x400u
#define TRNG_MCTL_ENT_VAL_SHIFT                  10
#define TRNG_MCTL_ENT_VAL_WIDTH                  1
#define TRNG_MCTL_ENT_VAL(x)                     (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_ENT_VAL_SHIFT))&TRNG_MCTL_ENT_VAL_MASK)
#define TRNG_MCTL_TST_OUT_MASK                   0x800u
#define TRNG_MCTL_TST_OUT_SHIFT                  11
#define TRNG_MCTL_TST_OUT_WIDTH                  1
#define TRNG_MCTL_TST_OUT(x)                     (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_TST_OUT_SHIFT))&TRNG_MCTL_TST_OUT_MASK)
#define TRNG_MCTL_ERR_MASK                       0x1000u
#define TRNG_MCTL_ERR_SHIFT                      12
#define TRNG_MCTL_ERR_WIDTH                      1
#define TRNG_MCTL_ERR(x)                         (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_ERR_SHIFT))&TRNG_MCTL_ERR_MASK)
#define TRNG_MCTL_TSTOP_OK_MASK                  0x2000u
#define TRNG_MCTL_TSTOP_OK_SHIFT                 13
#define TRNG_MCTL_TSTOP_OK_WIDTH                 1
#define TRNG_MCTL_TSTOP_OK(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_TSTOP_OK_SHIFT))&TRNG_MCTL_TSTOP_OK_MASK)
#define TRNG_MCTL_PRGM_MASK                      0x10000u
#define TRNG_MCTL_PRGM_SHIFT                     16
#define TRNG_MCTL_PRGM_WIDTH                     1
#define TRNG_MCTL_PRGM(x)                        (((uint32_t)(((uint32_t)(x))<<TRNG_MCTL_PRGM_SHIFT))&TRNG_MCTL_PRGM_MASK)
/* SCMISC Bit Fields */
#define TRNG_SCMISC_LRUN_MAX_MASK                0xFFu
#define TRNG_SCMISC_LRUN_MAX_SHIFT               0
#define TRNG_SCMISC_LRUN_MAX_WIDTH               8
#define TRNG_SCMISC_LRUN_MAX(x)                  (((uint32_t)(((uint32_t)(x))<<TRNG_SCMISC_LRUN_MAX_SHIFT))&TRNG_SCMISC_LRUN_MAX_MASK)
#define TRNG_SCMISC_RTY_CT_MASK                  0xF0000u
#define TRNG_SCMISC_RTY_CT_SHIFT                 16
#define TRNG_SCMISC_RTY_CT_WIDTH                 4
#define TRNG_SCMISC_RTY_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCMISC_RTY_CT_SHIFT))&TRNG_SCMISC_RTY_CT_MASK)
/* PKRRNG Bit Fields */
#define TRNG_PKRRNG_PKR_RNG_MASK                 0xFFFFu
#define TRNG_PKRRNG_PKR_RNG_SHIFT                0
#define TRNG_PKRRNG_PKR_RNG_WIDTH                16
#define TRNG_PKRRNG_PKR_RNG(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_PKRRNG_PKR_RNG_SHIFT))&TRNG_PKRRNG_PKR_RNG_MASK)
/* PKRMAX Bit Fields */
#define TRNG_PKRMAX_PKR_MAX_MASK                 0xFFFFFFu
#define TRNG_PKRMAX_PKR_MAX_SHIFT                0
#define TRNG_PKRMAX_PKR_MAX_WIDTH                24
#define TRNG_PKRMAX_PKR_MAX(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_PKRMAX_PKR_MAX_SHIFT))&TRNG_PKRMAX_PKR_MAX_MASK)
/* PKRSQ Bit Fields */
#define TRNG_PKRSQ_PKR_SQ_MASK                   0xFFFFFFu
#define TRNG_PKRSQ_PKR_SQ_SHIFT                  0
#define TRNG_PKRSQ_PKR_SQ_WIDTH                  24
#define TRNG_PKRSQ_PKR_SQ(x)                     (((uint32_t)(((uint32_t)(x))<<TRNG_PKRSQ_PKR_SQ_SHIFT))&TRNG_PKRSQ_PKR_SQ_MASK)
/* SDCTL Bit Fields */
#define TRNG_SDCTL_SAMP_SIZE_MASK                0xFFFFu
#define TRNG_SDCTL_SAMP_SIZE_SHIFT               0
#define TRNG_SDCTL_SAMP_SIZE_WIDTH               16
#define TRNG_SDCTL_SAMP_SIZE(x)                  (((uint32_t)(((uint32_t)(x))<<TRNG_SDCTL_SAMP_SIZE_SHIFT))&TRNG_SDCTL_SAMP_SIZE_MASK)
#define TRNG_SDCTL_ENT_DLY_MASK                  0xFFFF0000u
#define TRNG_SDCTL_ENT_DLY_SHIFT                 16
#define TRNG_SDCTL_ENT_DLY_WIDTH                 16
#define TRNG_SDCTL_ENT_DLY(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SDCTL_ENT_DLY_SHIFT))&TRNG_SDCTL_ENT_DLY_MASK)
/* SBLIM Bit Fields */
#define TRNG_SBLIM_SB_LIM_MASK                   0x3FFu
#define TRNG_SBLIM_SB_LIM_SHIFT                  0
#define TRNG_SBLIM_SB_LIM_WIDTH                  10
#define TRNG_SBLIM_SB_LIM(x)                     (((uint32_t)(((uint32_t)(x))<<TRNG_SBLIM_SB_LIM_SHIFT))&TRNG_SBLIM_SB_LIM_MASK)
/* TOTSAM Bit Fields */
#define TRNG_TOTSAM_TOT_SAM_MASK                 0xFFFFFu
#define TRNG_TOTSAM_TOT_SAM_SHIFT                0
#define TRNG_TOTSAM_TOT_SAM_WIDTH                20
#define TRNG_TOTSAM_TOT_SAM(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_TOTSAM_TOT_SAM_SHIFT))&TRNG_TOTSAM_TOT_SAM_MASK)
/* FRQMIN Bit Fields */
#define TRNG_FRQMIN_FRQ_MIN_MASK                 0x3FFFFFu
#define TRNG_FRQMIN_FRQ_MIN_SHIFT                0
#define TRNG_FRQMIN_FRQ_MIN_WIDTH                22
#define TRNG_FRQMIN_FRQ_MIN(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_FRQMIN_FRQ_MIN_SHIFT))&TRNG_FRQMIN_FRQ_MIN_MASK)
/* FRQCNT Bit Fields */
#define TRNG_FRQCNT_FRQ_CT_MASK                  0x3FFFFFu
#define TRNG_FRQCNT_FRQ_CT_SHIFT                 0
#define TRNG_FRQCNT_FRQ_CT_WIDTH                 22
#define TRNG_FRQCNT_FRQ_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_FRQCNT_FRQ_CT_SHIFT))&TRNG_FRQCNT_FRQ_CT_MASK)
/* FRQMAX Bit Fields */
#define TRNG_FRQMAX_FRQ_MAX_MASK                 0x3FFFFFu
#define TRNG_FRQMAX_FRQ_MAX_SHIFT                0
#define TRNG_FRQMAX_FRQ_MAX_WIDTH                22
#define TRNG_FRQMAX_FRQ_MAX(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_FRQMAX_FRQ_MAX_SHIFT))&TRNG_FRQMAX_FRQ_MAX_MASK)
/* SCMC Bit Fields */
#define TRNG_SCMC_MONO_CT_MASK                   0xFFFFu
#define TRNG_SCMC_MONO_CT_SHIFT                  0
#define TRNG_SCMC_MONO_CT_WIDTH                  16
#define TRNG_SCMC_MONO_CT(x)                     (((uint32_t)(((uint32_t)(x))<<TRNG_SCMC_MONO_CT_SHIFT))&TRNG_SCMC_MONO_CT_MASK)
/* SCML Bit Fields */
#define TRNG_SCML_MONO_MAX_MASK                  0xFFFFu
#define TRNG_SCML_MONO_MAX_SHIFT                 0
#define TRNG_SCML_MONO_MAX_WIDTH                 16
#define TRNG_SCML_MONO_MAX(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCML_MONO_MAX_SHIFT))&TRNG_SCML_MONO_MAX_MASK)
#define TRNG_SCML_MONO_RNG_MASK                  0xFFFF0000u
#define TRNG_SCML_MONO_RNG_SHIFT                 16
#define TRNG_SCML_MONO_RNG_WIDTH                 16
#define TRNG_SCML_MONO_RNG(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCML_MONO_RNG_SHIFT))&TRNG_SCML_MONO_RNG_MASK)
/* SCR1C Bit Fields */
#define TRNG_SCR1C_R1_0_CT_MASK                  0x7FFFu
#define TRNG_SCR1C_R1_0_CT_SHIFT                 0
#define TRNG_SCR1C_R1_0_CT_WIDTH                 15
#define TRNG_SCR1C_R1_0_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCR1C_R1_0_CT_SHIFT))&TRNG_SCR1C_R1_0_CT_MASK)
#define TRNG_SCR1C_R1_1_CT_MASK                  0x7FFF0000u
#define TRNG_SCR1C_R1_1_CT_SHIFT                 16
#define TRNG_SCR1C_R1_1_CT_WIDTH                 15
#define TRNG_SCR1C_R1_1_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCR1C_R1_1_CT_SHIFT))&TRNG_SCR1C_R1_1_CT_MASK)
/* SCR1L Bit Fields */
#define TRNG_SCR1L_RUN1_MAX_MASK                 0x7FFFu
#define TRNG_SCR1L_RUN1_MAX_SHIFT                0
#define TRNG_SCR1L_RUN1_MAX_WIDTH                15
#define TRNG_SCR1L_RUN1_MAX(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SCR1L_RUN1_MAX_SHIFT))&TRNG_SCR1L_RUN1_MAX_MASK)
#define TRNG_SCR1L_RUN1_RNG_MASK                 0x7FFF0000u
#define TRNG_SCR1L_RUN1_RNG_SHIFT                16
#define TRNG_SCR1L_RUN1_RNG_WIDTH                15
#define TRNG_SCR1L_RUN1_RNG(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SCR1L_RUN1_RNG_SHIFT))&TRNG_SCR1L_RUN1_RNG_MASK)
/* SCR2C Bit Fields */
#define TRNG_SCR2C_R2_0_CT_MASK                  0x3FFFu
#define TRNG_SCR2C_R2_0_CT_SHIFT                 0
#define TRNG_SCR2C_R2_0_CT_WIDTH                 14
#define TRNG_SCR2C_R2_0_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCR2C_R2_0_CT_SHIFT))&TRNG_SCR2C_R2_0_CT_MASK)
#define TRNG_SCR2C_R2_1_CT_MASK                  0x3FFF0000u
#define TRNG_SCR2C_R2_1_CT_SHIFT                 16
#define TRNG_SCR2C_R2_1_CT_WIDTH                 14
#define TRNG_SCR2C_R2_1_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCR2C_R2_1_CT_SHIFT))&TRNG_SCR2C_R2_1_CT_MASK)
/* SCR2L Bit Fields */
#define TRNG_SCR2L_RUN2_MAX_MASK                 0x3FFFu
#define TRNG_SCR2L_RUN2_MAX_SHIFT                0
#define TRNG_SCR2L_RUN2_MAX_WIDTH                14
#define TRNG_SCR2L_RUN2_MAX(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SCR2L_RUN2_MAX_SHIFT))&TRNG_SCR2L_RUN2_MAX_MASK)
#define TRNG_SCR2L_RUN2_RNG_MASK                 0x3FFF0000u
#define TRNG_SCR2L_RUN2_RNG_SHIFT                16
#define TRNG_SCR2L_RUN2_RNG_WIDTH                14
#define TRNG_SCR2L_RUN2_RNG(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SCR2L_RUN2_RNG_SHIFT))&TRNG_SCR2L_RUN2_RNG_MASK)
/* SCR3C Bit Fields */
#define TRNG_SCR3C_R3_0_CT_MASK                  0x1FFFu
#define TRNG_SCR3C_R3_0_CT_SHIFT                 0
#define TRNG_SCR3C_R3_0_CT_WIDTH                 13
#define TRNG_SCR3C_R3_0_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCR3C_R3_0_CT_SHIFT))&TRNG_SCR3C_R3_0_CT_MASK)
#define TRNG_SCR3C_R3_1_CT_MASK                  0x1FFF0000u
#define TRNG_SCR3C_R3_1_CT_SHIFT                 16
#define TRNG_SCR3C_R3_1_CT_WIDTH                 13
#define TRNG_SCR3C_R3_1_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCR3C_R3_1_CT_SHIFT))&TRNG_SCR3C_R3_1_CT_MASK)
/* SCR3L Bit Fields */
#define TRNG_SCR3L_RUN3_MAX_MASK                 0x1FFFu
#define TRNG_SCR3L_RUN3_MAX_SHIFT                0
#define TRNG_SCR3L_RUN3_MAX_WIDTH                13
#define TRNG_SCR3L_RUN3_MAX(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SCR3L_RUN3_MAX_SHIFT))&TRNG_SCR3L_RUN3_MAX_MASK)
#define TRNG_SCR3L_RUN3_RNG_MASK                 0x1FFF0000u
#define TRNG_SCR3L_RUN3_RNG_SHIFT                16
#define TRNG_SCR3L_RUN3_RNG_WIDTH                13
#define TRNG_SCR3L_RUN3_RNG(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SCR3L_RUN3_RNG_SHIFT))&TRNG_SCR3L_RUN3_RNG_MASK)
/* SCR4C Bit Fields */
#define TRNG_SCR4C_R4_0_CT_MASK                  0xFFFu
#define TRNG_SCR4C_R4_0_CT_SHIFT                 0
#define TRNG_SCR4C_R4_0_CT_WIDTH                 12
#define TRNG_SCR4C_R4_0_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCR4C_R4_0_CT_SHIFT))&TRNG_SCR4C_R4_0_CT_MASK)
#define TRNG_SCR4C_R4_1_CT_MASK                  0xFFF0000u
#define TRNG_SCR4C_R4_1_CT_SHIFT                 16
#define TRNG_SCR4C_R4_1_CT_WIDTH                 12
#define TRNG_SCR4C_R4_1_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCR4C_R4_1_CT_SHIFT))&TRNG_SCR4C_R4_1_CT_MASK)
/* SCR4L Bit Fields */
#define TRNG_SCR4L_RUN4_MAX_MASK                 0xFFFu
#define TRNG_SCR4L_RUN4_MAX_SHIFT                0
#define TRNG_SCR4L_RUN4_MAX_WIDTH                12
#define TRNG_SCR4L_RUN4_MAX(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SCR4L_RUN4_MAX_SHIFT))&TRNG_SCR4L_RUN4_MAX_MASK)
#define TRNG_SCR4L_RUN4_RNG_MASK                 0xFFF0000u
#define TRNG_SCR4L_RUN4_RNG_SHIFT                16
#define TRNG_SCR4L_RUN4_RNG_WIDTH                12
#define TRNG_SCR4L_RUN4_RNG(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SCR4L_RUN4_RNG_SHIFT))&TRNG_SCR4L_RUN4_RNG_MASK)
/* SCR5C Bit Fields */
#define TRNG_SCR5C_R5_0_CT_MASK                  0x7FFu
#define TRNG_SCR5C_R5_0_CT_SHIFT                 0
#define TRNG_SCR5C_R5_0_CT_WIDTH                 11
#define TRNG_SCR5C_R5_0_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCR5C_R5_0_CT_SHIFT))&TRNG_SCR5C_R5_0_CT_MASK)
#define TRNG_SCR5C_R5_1_CT_MASK                  0x7FF0000u
#define TRNG_SCR5C_R5_1_CT_SHIFT                 16
#define TRNG_SCR5C_R5_1_CT_WIDTH                 11
#define TRNG_SCR5C_R5_1_CT(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_SCR5C_R5_1_CT_SHIFT))&TRNG_SCR5C_R5_1_CT_MASK)
/* SCR5L Bit Fields */
#define TRNG_SCR5L_RUN5_MAX_MASK                 0x7FFu
#define TRNG_SCR5L_RUN5_MAX_SHIFT                0
#define TRNG_SCR5L_RUN5_MAX_WIDTH                11
#define TRNG_SCR5L_RUN5_MAX(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SCR5L_RUN5_MAX_SHIFT))&TRNG_SCR5L_RUN5_MAX_MASK)
#define TRNG_SCR5L_RUN5_RNG_MASK                 0x7FF0000u
#define TRNG_SCR5L_RUN5_RNG_SHIFT                16
#define TRNG_SCR5L_RUN5_RNG_WIDTH                11
#define TRNG_SCR5L_RUN5_RNG(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SCR5L_RUN5_RNG_SHIFT))&TRNG_SCR5L_RUN5_RNG_MASK)
/* SCR6PC Bit Fields */
#define TRNG_SCR6PC_R6P_0_CT_MASK                0x7FFu
#define TRNG_SCR6PC_R6P_0_CT_SHIFT               0
#define TRNG_SCR6PC_R6P_0_CT_WIDTH               11
#define TRNG_SCR6PC_R6P_0_CT(x)                  (((uint32_t)(((uint32_t)(x))<<TRNG_SCR6PC_R6P_0_CT_SHIFT))&TRNG_SCR6PC_R6P_0_CT_MASK)
#define TRNG_SCR6PC_R6P_1_CT_MASK                0x7FF0000u
#define TRNG_SCR6PC_R6P_1_CT_SHIFT               16
#define TRNG_SCR6PC_R6P_1_CT_WIDTH               11
#define TRNG_SCR6PC_R6P_1_CT(x)                  (((uint32_t)(((uint32_t)(x))<<TRNG_SCR6PC_R6P_1_CT_SHIFT))&TRNG_SCR6PC_R6P_1_CT_MASK)
/* SCR6PL Bit Fields */
#define TRNG_SCR6PL_RUN6P_MAX_MASK               0x7FFu
#define TRNG_SCR6PL_RUN6P_MAX_SHIFT              0
#define TRNG_SCR6PL_RUN6P_MAX_WIDTH              11
#define TRNG_SCR6PL_RUN6P_MAX(x)                 (((uint32_t)(((uint32_t)(x))<<TRNG_SCR6PL_RUN6P_MAX_SHIFT))&TRNG_SCR6PL_RUN6P_MAX_MASK)
#define TRNG_SCR6PL_RUN6P_RNG_MASK               0x7FF0000u
#define TRNG_SCR6PL_RUN6P_RNG_SHIFT              16
#define TRNG_SCR6PL_RUN6P_RNG_WIDTH              11
#define TRNG_SCR6PL_RUN6P_RNG(x)                 (((uint32_t)(((uint32_t)(x))<<TRNG_SCR6PL_RUN6P_RNG_SHIFT))&TRNG_SCR6PL_RUN6P_RNG_MASK)
/* STATUS Bit Fields */
#define TRNG_STATUS_TF1BR0_MASK                  0x1u
#define TRNG_STATUS_TF1BR0_SHIFT                 0
#define TRNG_STATUS_TF1BR0_WIDTH                 1
#define TRNG_STATUS_TF1BR0(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF1BR0_SHIFT))&TRNG_STATUS_TF1BR0_MASK)
#define TRNG_STATUS_TF1BR1_MASK                  0x2u
#define TRNG_STATUS_TF1BR1_SHIFT                 1
#define TRNG_STATUS_TF1BR1_WIDTH                 1
#define TRNG_STATUS_TF1BR1(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF1BR1_SHIFT))&TRNG_STATUS_TF1BR1_MASK)
#define TRNG_STATUS_TF2BR0_MASK                  0x4u
#define TRNG_STATUS_TF2BR0_SHIFT                 2
#define TRNG_STATUS_TF2BR0_WIDTH                 1
#define TRNG_STATUS_TF2BR0(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF2BR0_SHIFT))&TRNG_STATUS_TF2BR0_MASK)
#define TRNG_STATUS_TF2BR1_MASK                  0x8u
#define TRNG_STATUS_TF2BR1_SHIFT                 3
#define TRNG_STATUS_TF2BR1_WIDTH                 1
#define TRNG_STATUS_TF2BR1(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF2BR1_SHIFT))&TRNG_STATUS_TF2BR1_MASK)
#define TRNG_STATUS_TF3BR0_MASK                  0x10u
#define TRNG_STATUS_TF3BR0_SHIFT                 4
#define TRNG_STATUS_TF3BR0_WIDTH                 1
#define TRNG_STATUS_TF3BR0(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF3BR0_SHIFT))&TRNG_STATUS_TF3BR0_MASK)
#define TRNG_STATUS_TF3BR1_MASK                  0x20u
#define TRNG_STATUS_TF3BR1_SHIFT                 5
#define TRNG_STATUS_TF3BR1_WIDTH                 1
#define TRNG_STATUS_TF3BR1(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF3BR1_SHIFT))&TRNG_STATUS_TF3BR1_MASK)
#define TRNG_STATUS_TF4BR0_MASK                  0x40u
#define TRNG_STATUS_TF4BR0_SHIFT                 6
#define TRNG_STATUS_TF4BR0_WIDTH                 1
#define TRNG_STATUS_TF4BR0(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF4BR0_SHIFT))&TRNG_STATUS_TF4BR0_MASK)
#define TRNG_STATUS_TF4BR1_MASK                  0x80u
#define TRNG_STATUS_TF4BR1_SHIFT                 7
#define TRNG_STATUS_TF4BR1_WIDTH                 1
#define TRNG_STATUS_TF4BR1(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF4BR1_SHIFT))&TRNG_STATUS_TF4BR1_MASK)
#define TRNG_STATUS_TF5BR0_MASK                  0x100u
#define TRNG_STATUS_TF5BR0_SHIFT                 8
#define TRNG_STATUS_TF5BR0_WIDTH                 1
#define TRNG_STATUS_TF5BR0(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF5BR0_SHIFT))&TRNG_STATUS_TF5BR0_MASK)
#define TRNG_STATUS_TF5BR1_MASK                  0x200u
#define TRNG_STATUS_TF5BR1_SHIFT                 9
#define TRNG_STATUS_TF5BR1_WIDTH                 1
#define TRNG_STATUS_TF5BR1(x)                    (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF5BR1_SHIFT))&TRNG_STATUS_TF5BR1_MASK)
#define TRNG_STATUS_TF6PBR0_MASK                 0x400u
#define TRNG_STATUS_TF6PBR0_SHIFT                10
#define TRNG_STATUS_TF6PBR0_WIDTH                1
#define TRNG_STATUS_TF6PBR0(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF6PBR0_SHIFT))&TRNG_STATUS_TF6PBR0_MASK)
#define TRNG_STATUS_TF6PBR1_MASK                 0x800u
#define TRNG_STATUS_TF6PBR1_SHIFT                11
#define TRNG_STATUS_TF6PBR1_WIDTH                1
#define TRNG_STATUS_TF6PBR1(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TF6PBR1_SHIFT))&TRNG_STATUS_TF6PBR1_MASK)
#define TRNG_STATUS_TFSB_MASK                    0x1000u
#define TRNG_STATUS_TFSB_SHIFT                   12
#define TRNG_STATUS_TFSB_WIDTH                   1
#define TRNG_STATUS_TFSB(x)                      (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TFSB_SHIFT))&TRNG_STATUS_TFSB_MASK)
#define TRNG_STATUS_TFLR_MASK                    0x2000u
#define TRNG_STATUS_TFLR_SHIFT                   13
#define TRNG_STATUS_TFLR_WIDTH                   1
#define TRNG_STATUS_TFLR(x)                      (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TFLR_SHIFT))&TRNG_STATUS_TFLR_MASK)
#define TRNG_STATUS_TFP_MASK                     0x4000u
#define TRNG_STATUS_TFP_SHIFT                    14
#define TRNG_STATUS_TFP_WIDTH                    1
#define TRNG_STATUS_TFP(x)                       (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TFP_SHIFT))&TRNG_STATUS_TFP_MASK)
#define TRNG_STATUS_TFMB_MASK                    0x8000u
#define TRNG_STATUS_TFMB_SHIFT                   15
#define TRNG_STATUS_TFMB_WIDTH                   1
#define TRNG_STATUS_TFMB(x)                      (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_TFMB_SHIFT))&TRNG_STATUS_TFMB_MASK)
#define TRNG_STATUS_RETRY_CT_MASK                0xF0000u
#define TRNG_STATUS_RETRY_CT_SHIFT               16
#define TRNG_STATUS_RETRY_CT_WIDTH               4
#define TRNG_STATUS_RETRY_CT(x)                  (((uint32_t)(((uint32_t)(x))<<TRNG_STATUS_RETRY_CT_SHIFT))&TRNG_STATUS_RETRY_CT_MASK)
/* ENT Bit Fields */
#define TRNG_ENT_ENT_MASK                        0xFFFFFFFFu
#define TRNG_ENT_ENT_SHIFT                       0
#define TRNG_ENT_ENT_WIDTH                       32
#define TRNG_ENT_ENT(x)                          (((uint32_t)(((uint32_t)(x))<<TRNG_ENT_ENT_SHIFT))&TRNG_ENT_ENT_MASK)
/* PKRCNT10 Bit Fields */
#define TRNG_PKRCNT10_PKR_0_CT_MASK              0xFFFFu
#define TRNG_PKRCNT10_PKR_0_CT_SHIFT             0
#define TRNG_PKRCNT10_PKR_0_CT_WIDTH             16
#define TRNG_PKRCNT10_PKR_0_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNT10_PKR_0_CT_SHIFT))&TRNG_PKRCNT10_PKR_0_CT_MASK)
#define TRNG_PKRCNT10_PKR_1_CT_MASK              0xFFFF0000u
#define TRNG_PKRCNT10_PKR_1_CT_SHIFT             16
#define TRNG_PKRCNT10_PKR_1_CT_WIDTH             16
#define TRNG_PKRCNT10_PKR_1_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNT10_PKR_1_CT_SHIFT))&TRNG_PKRCNT10_PKR_1_CT_MASK)
/* PKRCNT32 Bit Fields */
#define TRNG_PKRCNT32_PKR_2_CT_MASK              0xFFFFu
#define TRNG_PKRCNT32_PKR_2_CT_SHIFT             0
#define TRNG_PKRCNT32_PKR_2_CT_WIDTH             16
#define TRNG_PKRCNT32_PKR_2_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNT32_PKR_2_CT_SHIFT))&TRNG_PKRCNT32_PKR_2_CT_MASK)
#define TRNG_PKRCNT32_PKR_3_CT_MASK              0xFFFF0000u
#define TRNG_PKRCNT32_PKR_3_CT_SHIFT             16
#define TRNG_PKRCNT32_PKR_3_CT_WIDTH             16
#define TRNG_PKRCNT32_PKR_3_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNT32_PKR_3_CT_SHIFT))&TRNG_PKRCNT32_PKR_3_CT_MASK)
/* PKRCNT54 Bit Fields */
#define TRNG_PKRCNT54_PKR_4_CT_MASK              0xFFFFu
#define TRNG_PKRCNT54_PKR_4_CT_SHIFT             0
#define TRNG_PKRCNT54_PKR_4_CT_WIDTH             16
#define TRNG_PKRCNT54_PKR_4_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNT54_PKR_4_CT_SHIFT))&TRNG_PKRCNT54_PKR_4_CT_MASK)
#define TRNG_PKRCNT54_PKR_5_CT_MASK              0xFFFF0000u
#define TRNG_PKRCNT54_PKR_5_CT_SHIFT             16
#define TRNG_PKRCNT54_PKR_5_CT_WIDTH             16
#define TRNG_PKRCNT54_PKR_5_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNT54_PKR_5_CT_SHIFT))&TRNG_PKRCNT54_PKR_5_CT_MASK)
/* PKRCNT76 Bit Fields */
#define TRNG_PKRCNT76_PKR_6_CT_MASK              0xFFFFu
#define TRNG_PKRCNT76_PKR_6_CT_SHIFT             0
#define TRNG_PKRCNT76_PKR_6_CT_WIDTH             16
#define TRNG_PKRCNT76_PKR_6_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNT76_PKR_6_CT_SHIFT))&TRNG_PKRCNT76_PKR_6_CT_MASK)
#define TRNG_PKRCNT76_PKR_7_CT_MASK              0xFFFF0000u
#define TRNG_PKRCNT76_PKR_7_CT_SHIFT             16
#define TRNG_PKRCNT76_PKR_7_CT_WIDTH             16
#define TRNG_PKRCNT76_PKR_7_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNT76_PKR_7_CT_SHIFT))&TRNG_PKRCNT76_PKR_7_CT_MASK)
/* PKRCNT98 Bit Fields */
#define TRNG_PKRCNT98_PKR_8_CT_MASK              0xFFFFu
#define TRNG_PKRCNT98_PKR_8_CT_SHIFT             0
#define TRNG_PKRCNT98_PKR_8_CT_WIDTH             16
#define TRNG_PKRCNT98_PKR_8_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNT98_PKR_8_CT_SHIFT))&TRNG_PKRCNT98_PKR_8_CT_MASK)
#define TRNG_PKRCNT98_PKR_9_CT_MASK              0xFFFF0000u
#define TRNG_PKRCNT98_PKR_9_CT_SHIFT             16
#define TRNG_PKRCNT98_PKR_9_CT_WIDTH             16
#define TRNG_PKRCNT98_PKR_9_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNT98_PKR_9_CT_SHIFT))&TRNG_PKRCNT98_PKR_9_CT_MASK)
/* PKRCNTBA Bit Fields */
#define TRNG_PKRCNTBA_PKR_A_CT_MASK              0xFFFFu
#define TRNG_PKRCNTBA_PKR_A_CT_SHIFT             0
#define TRNG_PKRCNTBA_PKR_A_CT_WIDTH             16
#define TRNG_PKRCNTBA_PKR_A_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNTBA_PKR_A_CT_SHIFT))&TRNG_PKRCNTBA_PKR_A_CT_MASK)
#define TRNG_PKRCNTBA_PKR_B_CT_MASK              0xFFFF0000u
#define TRNG_PKRCNTBA_PKR_B_CT_SHIFT             16
#define TRNG_PKRCNTBA_PKR_B_CT_WIDTH             16
#define TRNG_PKRCNTBA_PKR_B_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNTBA_PKR_B_CT_SHIFT))&TRNG_PKRCNTBA_PKR_B_CT_MASK)
/* PKRCNTDC Bit Fields */
#define TRNG_PKRCNTDC_PKR_C_CT_MASK              0xFFFFu
#define TRNG_PKRCNTDC_PKR_C_CT_SHIFT             0
#define TRNG_PKRCNTDC_PKR_C_CT_WIDTH             16
#define TRNG_PKRCNTDC_PKR_C_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNTDC_PKR_C_CT_SHIFT))&TRNG_PKRCNTDC_PKR_C_CT_MASK)
#define TRNG_PKRCNTDC_PKR_D_CT_MASK              0xFFFF0000u
#define TRNG_PKRCNTDC_PKR_D_CT_SHIFT             16
#define TRNG_PKRCNTDC_PKR_D_CT_WIDTH             16
#define TRNG_PKRCNTDC_PKR_D_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNTDC_PKR_D_CT_SHIFT))&TRNG_PKRCNTDC_PKR_D_CT_MASK)
/* PKRCNTFE Bit Fields */
#define TRNG_PKRCNTFE_PKR_E_CT_MASK              0xFFFFu
#define TRNG_PKRCNTFE_PKR_E_CT_SHIFT             0
#define TRNG_PKRCNTFE_PKR_E_CT_WIDTH             16
#define TRNG_PKRCNTFE_PKR_E_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNTFE_PKR_E_CT_SHIFT))&TRNG_PKRCNTFE_PKR_E_CT_MASK)
#define TRNG_PKRCNTFE_PKR_F_CT_MASK              0xFFFF0000u
#define TRNG_PKRCNTFE_PKR_F_CT_SHIFT             16
#define TRNG_PKRCNTFE_PKR_F_CT_WIDTH             16
#define TRNG_PKRCNTFE_PKR_F_CT(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_PKRCNTFE_PKR_F_CT_SHIFT))&TRNG_PKRCNTFE_PKR_F_CT_MASK)
/* SEC_CFG Bit Fields */
#define TRNG_SEC_CFG_SH0_MASK                    0x1u
#define TRNG_SEC_CFG_SH0_SHIFT                   0
#define TRNG_SEC_CFG_SH0_WIDTH                   1
#define TRNG_SEC_CFG_SH0(x)                      (((uint32_t)(((uint32_t)(x))<<TRNG_SEC_CFG_SH0_SHIFT))&TRNG_SEC_CFG_SH0_MASK)
#define TRNG_SEC_CFG_NO_PRGM_MASK                0x2u
#define TRNG_SEC_CFG_NO_PRGM_SHIFT               1
#define TRNG_SEC_CFG_NO_PRGM_WIDTH               1
#define TRNG_SEC_CFG_NO_PRGM(x)                  (((uint32_t)(((uint32_t)(x))<<TRNG_SEC_CFG_NO_PRGM_SHIFT))&TRNG_SEC_CFG_NO_PRGM_MASK)
#define TRNG_SEC_CFG_SK_VAL_MASK                 0x4u
#define TRNG_SEC_CFG_SK_VAL_SHIFT                2
#define TRNG_SEC_CFG_SK_VAL_WIDTH                1
#define TRNG_SEC_CFG_SK_VAL(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_SEC_CFG_SK_VAL_SHIFT))&TRNG_SEC_CFG_SK_VAL_MASK)
/* INT_CTRL Bit Fields */
#define TRNG_INT_CTRL_HW_ERR_MASK                0x1u
#define TRNG_INT_CTRL_HW_ERR_SHIFT               0
#define TRNG_INT_CTRL_HW_ERR_WIDTH               1
#define TRNG_INT_CTRL_HW_ERR(x)                  (((uint32_t)(((uint32_t)(x))<<TRNG_INT_CTRL_HW_ERR_SHIFT))&TRNG_INT_CTRL_HW_ERR_MASK)
#define TRNG_INT_CTRL_ENT_VAL_MASK               0x2u
#define TRNG_INT_CTRL_ENT_VAL_SHIFT              1
#define TRNG_INT_CTRL_ENT_VAL_WIDTH              1
#define TRNG_INT_CTRL_ENT_VAL(x)                 (((uint32_t)(((uint32_t)(x))<<TRNG_INT_CTRL_ENT_VAL_SHIFT))&TRNG_INT_CTRL_ENT_VAL_MASK)
#define TRNG_INT_CTRL_FRQ_CT_FAIL_MASK           0x4u
#define TRNG_INT_CTRL_FRQ_CT_FAIL_SHIFT          2
#define TRNG_INT_CTRL_FRQ_CT_FAIL_WIDTH          1
#define TRNG_INT_CTRL_FRQ_CT_FAIL(x)             (((uint32_t)(((uint32_t)(x))<<TRNG_INT_CTRL_FRQ_CT_FAIL_SHIFT))&TRNG_INT_CTRL_FRQ_CT_FAIL_MASK)
#define TRNG_INT_CTRL_UNUSED_MASK                0xFFFFFFF8u
#define TRNG_INT_CTRL_UNUSED_SHIFT               3
#define TRNG_INT_CTRL_UNUSED_WIDTH               29
#define TRNG_INT_CTRL_UNUSED(x)                  (((uint32_t)(((uint32_t)(x))<<TRNG_INT_CTRL_UNUSED_SHIFT))&TRNG_INT_CTRL_UNUSED_MASK)
/* INT_MASK Bit Fields */
#define TRNG_INT_MASK_HW_ERR_MASK                0x1u
#define TRNG_INT_MASK_HW_ERR_SHIFT               0
#define TRNG_INT_MASK_HW_ERR_WIDTH               1
#define TRNG_INT_MASK_HW_ERR(x)                  (((uint32_t)(((uint32_t)(x))<<TRNG_INT_MASK_HW_ERR_SHIFT))&TRNG_INT_MASK_HW_ERR_MASK)
#define TRNG_INT_MASK_ENT_VAL_MASK               0x2u
#define TRNG_INT_MASK_ENT_VAL_SHIFT              1
#define TRNG_INT_MASK_ENT_VAL_WIDTH              1
#define TRNG_INT_MASK_ENT_VAL(x)                 (((uint32_t)(((uint32_t)(x))<<TRNG_INT_MASK_ENT_VAL_SHIFT))&TRNG_INT_MASK_ENT_VAL_MASK)
#define TRNG_INT_MASK_FRQ_CT_FAIL_MASK           0x4u
#define TRNG_INT_MASK_FRQ_CT_FAIL_SHIFT          2
#define TRNG_INT_MASK_FRQ_CT_FAIL_WIDTH          1
#define TRNG_INT_MASK_FRQ_CT_FAIL(x)             (((uint32_t)(((uint32_t)(x))<<TRNG_INT_MASK_FRQ_CT_FAIL_SHIFT))&TRNG_INT_MASK_FRQ_CT_FAIL_MASK)
/* INT_STATUS Bit Fields */
#define TRNG_INT_STATUS_HW_ERR_MASK              0x1u
#define TRNG_INT_STATUS_HW_ERR_SHIFT             0
#define TRNG_INT_STATUS_HW_ERR_WIDTH             1
#define TRNG_INT_STATUS_HW_ERR(x)                (((uint32_t)(((uint32_t)(x))<<TRNG_INT_STATUS_HW_ERR_SHIFT))&TRNG_INT_STATUS_HW_ERR_MASK)
#define TRNG_INT_STATUS_ENT_VAL_MASK             0x2u
#define TRNG_INT_STATUS_ENT_VAL_SHIFT            1
#define TRNG_INT_STATUS_ENT_VAL_WIDTH            1
#define TRNG_INT_STATUS_ENT_VAL(x)               (((uint32_t)(((uint32_t)(x))<<TRNG_INT_STATUS_ENT_VAL_SHIFT))&TRNG_INT_STATUS_ENT_VAL_MASK)
#define TRNG_INT_STATUS_FRQ_CT_FAIL_MASK         0x4u
#define TRNG_INT_STATUS_FRQ_CT_FAIL_SHIFT        2
#define TRNG_INT_STATUS_FRQ_CT_FAIL_WIDTH        1
#define TRNG_INT_STATUS_FRQ_CT_FAIL(x)           (((uint32_t)(((uint32_t)(x))<<TRNG_INT_STATUS_FRQ_CT_FAIL_SHIFT))&TRNG_INT_STATUS_FRQ_CT_FAIL_MASK)
/* VID1 Bit Fields */
#define TRNG_VID1_TRNG0_MIN_REV_MASK             0xFFu
#define TRNG_VID1_TRNG0_MIN_REV_SHIFT            0
#define TRNG_VID1_TRNG0_MIN_REV_WIDTH            8
#define TRNG_VID1_TRNG0_MIN_REV(x)               (((uint32_t)(((uint32_t)(x))<<TRNG_VID1_TRNG0_MIN_REV_SHIFT))&TRNG_VID1_TRNG0_MIN_REV_MASK)
#define TRNG_VID1_TRNG0_MAJ_REV_MASK             0xFF00u
#define TRNG_VID1_TRNG0_MAJ_REV_SHIFT            8
#define TRNG_VID1_TRNG0_MAJ_REV_WIDTH            8
#define TRNG_VID1_TRNG0_MAJ_REV(x)               (((uint32_t)(((uint32_t)(x))<<TRNG_VID1_TRNG0_MAJ_REV_SHIFT))&TRNG_VID1_TRNG0_MAJ_REV_MASK)
#define TRNG_VID1_TRNG0_IP_ID_MASK               0xFFFF0000u
#define TRNG_VID1_TRNG0_IP_ID_SHIFT              16
#define TRNG_VID1_TRNG0_IP_ID_WIDTH              16
#define TRNG_VID1_TRNG0_IP_ID(x)                 (((uint32_t)(((uint32_t)(x))<<TRNG_VID1_TRNG0_IP_ID_SHIFT))&TRNG_VID1_TRNG0_IP_ID_MASK)
/* VID2 Bit Fields */
#define TRNG_VID2_TRNG0_CONFIG_OPT_MASK          0xFFu
#define TRNG_VID2_TRNG0_CONFIG_OPT_SHIFT         0
#define TRNG_VID2_TRNG0_CONFIG_OPT_WIDTH         8
#define TRNG_VID2_TRNG0_CONFIG_OPT(x)            (((uint32_t)(((uint32_t)(x))<<TRNG_VID2_TRNG0_CONFIG_OPT_SHIFT))&TRNG_VID2_TRNG0_CONFIG_OPT_MASK)
#define TRNG_VID2_TRNG0_ECO_REV_MASK             0xFF00u
#define TRNG_VID2_TRNG0_ECO_REV_SHIFT            8
#define TRNG_VID2_TRNG0_ECO_REV_WIDTH            8
#define TRNG_VID2_TRNG0_ECO_REV(x)               (((uint32_t)(((uint32_t)(x))<<TRNG_VID2_TRNG0_ECO_REV_SHIFT))&TRNG_VID2_TRNG0_ECO_REV_MASK)
#define TRNG_VID2_TRNG0_INTG_OPT_MASK            0xFF0000u
#define TRNG_VID2_TRNG0_INTG_OPT_SHIFT           16
#define TRNG_VID2_TRNG0_INTG_OPT_WIDTH           8
#define TRNG_VID2_TRNG0_INTG_OPT(x)              (((uint32_t)(((uint32_t)(x))<<TRNG_VID2_TRNG0_INTG_OPT_SHIFT))&TRNG_VID2_TRNG0_INTG_OPT_MASK)
#define TRNG_VID2_TRNG0_ERA_MASK                 0xFF000000u
#define TRNG_VID2_TRNG0_ERA_SHIFT                24
#define TRNG_VID2_TRNG0_ERA_WIDTH                8
#define TRNG_VID2_TRNG0_ERA(x)                   (((uint32_t)(((uint32_t)(x))<<TRNG_VID2_TRNG0_ERA_SHIFT))&TRNG_VID2_TRNG0_ERA_MASK)

/*!
 * @}
 */ /* end of group TRNG_Register_Masks */


/* TRNG - Peripheral instance base addresses */
/** Peripheral TRNG0 base address */
#define TRNG0_BASE                               (0x40025000u)
/** Peripheral TRNG0 base pointer */
#define TRNG0                                    ((TRNG_Type *)TRNG0_BASE)
#define TRNG0_BASE_PTR                           (TRNG0)
/** Array initializer of TRNG peripheral base addresses */
#define TRNG_BASE_ADDRS                          { TRNG0_BASE }
/** Array initializer of TRNG peripheral base pointers */
#define TRNG_BASE_PTRS                           { TRNG0 }

/* ----------------------------------------------------------------------------
   -- TRNG - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TRNG_Register_Accessor_Macros TRNG - Register accessor macros
 * @{
 */


/* TRNG - Register instance definitions */
/* TRNG0 */
#define TRNG0_MCTL                               TRNG_MCTL_REG(TRNG0)
#define TRNG0_SCMISC                             TRNG_SCMISC_REG(TRNG0)
#define TRNG0_PKRRNG                             TRNG_PKRRNG_REG(TRNG0)
#define TRNG0_PKRMAX                             TRNG_PKRMAX_REG(TRNG0)
#define TRNG0_PKRSQ                              TRNG_PKRSQ_REG(TRNG0)
#define TRNG0_SDCTL                              TRNG_SDCTL_REG(TRNG0)
#define TRNG0_SBLIM                              TRNG_SBLIM_REG(TRNG0)
#define TRNG0_TOTSAM                             TRNG_TOTSAM_REG(TRNG0)
#define TRNG0_FRQMIN                             TRNG_FRQMIN_REG(TRNG0)
#define TRNG0_FRQCNT                             TRNG_FRQCNT_REG(TRNG0)
#define TRNG0_FRQMAX                             TRNG_FRQMAX_REG(TRNG0)
#define TRNG0_SCMC                               TRNG_SCMC_REG(TRNG0)
#define TRNG0_SCML                               TRNG_SCML_REG(TRNG0)
#define TRNG0_SCR1C                              TRNG_SCR1C_REG(TRNG0)
#define TRNG0_SCR1L                              TRNG_SCR1L_REG(TRNG0)
#define TRNG0_SCR2C                              TRNG_SCR2C_REG(TRNG0)
#define TRNG0_SCR2L                              TRNG_SCR2L_REG(TRNG0)
#define TRNG0_SCR3C                              TRNG_SCR3C_REG(TRNG0)
#define TRNG0_SCR3L                              TRNG_SCR3L_REG(TRNG0)
#define TRNG0_SCR4C                              TRNG_SCR4C_REG(TRNG0)
#define TRNG0_SCR4L                              TRNG_SCR4L_REG(TRNG0)
#define TRNG0_SCR5C                              TRNG_SCR5C_REG(TRNG0)
#define TRNG0_SCR5L                              TRNG_SCR5L_REG(TRNG0)
#define TRNG0_SCR6PC                             TRNG_SCR6PC_REG(TRNG0)
#define TRNG0_SCR6PL                             TRNG_SCR6PL_REG(TRNG0)
#define TRNG0_STATUS                             TRNG_STATUS_REG(TRNG0)
#define TRNG0_ENT0                               TRNG_ENT_REG(TRNG0,0)
#define TRNG0_ENT1                               TRNG_ENT_REG(TRNG0,1)
#define TRNG0_ENT2                               TRNG_ENT_REG(TRNG0,2)
#define TRNG0_ENT3                               TRNG_ENT_REG(TRNG0,3)
#define TRNG0_ENT4                               TRNG_ENT_REG(TRNG0,4)
#define TRNG0_ENT5                               TRNG_ENT_REG(TRNG0,5)
#define TRNG0_ENT6                               TRNG_ENT_REG(TRNG0,6)
#define TRNG0_ENT7                               TRNG_ENT_REG(TRNG0,7)
#define TRNG0_ENT8                               TRNG_ENT_REG(TRNG0,8)
#define TRNG0_ENT9                               TRNG_ENT_REG(TRNG0,9)
#define TRNG0_ENT10                              TRNG_ENT_REG(TRNG0,10)
#define TRNG0_ENT11                              TRNG_ENT_REG(TRNG0,11)
#define TRNG0_ENT12                              TRNG_ENT_REG(TRNG0,12)
#define TRNG0_ENT13                              TRNG_ENT_REG(TRNG0,13)
#define TRNG0_ENT14                              TRNG_ENT_REG(TRNG0,14)
#define TRNG0_ENT15                              TRNG_ENT_REG(TRNG0,15)
#define TRNG0_PKRCNT10                           TRNG_PKRCNT10_REG(TRNG0)
#define TRNG0_PKRCNT32                           TRNG_PKRCNT32_REG(TRNG0)
#define TRNG0_PKRCNT54                           TRNG_PKRCNT54_REG(TRNG0)
#define TRNG0_PKRCNT76                           TRNG_PKRCNT76_REG(TRNG0)
#define TRNG0_PKRCNT98                           TRNG_PKRCNT98_REG(TRNG0)
#define TRNG0_PKRCNTBA                           TRNG_PKRCNTBA_REG(TRNG0)
#define TRNG0_PKRCNTDC                           TRNG_PKRCNTDC_REG(TRNG0)
#define TRNG0_PKRCNTFE                           TRNG_PKRCNTFE_REG(TRNG0)
#define TRNG0_SEC_CFG                            TRNG_SEC_CFG_REG(TRNG0)
#define TRNG0_INT_CTRL                           TRNG_INT_CTRL_REG(TRNG0)
#define TRNG0_INT_MASK                           TRNG_INT_MASK_REG(TRNG0)
#define TRNG0_INT_STATUS                         TRNG_INT_STATUS_REG(TRNG0)
#define TRNG0_VID1                               TRNG_VID1_REG(TRNG0)
#define TRNG0_VID2                               TRNG_VID2_REG(TRNG0)

/* TRNG - Register array accessors */
#define TRNG0_ENT(index)                         TRNG_ENT_REG(TRNG0,index)

/*!
 * @}
 */ /* end of group TRNG_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group TRNG_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- TSI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TSI_Peripheral_Access_Layer TSI Peripheral Access Layer
 * @{
 */

/** TSI - Register Layout Typedef */
typedef struct {
  __IO uint32_t GENCS;                             /**< TSI General Control and Status Register, offset: 0x0 */
  __IO uint32_t DATA;                              /**< TSI DATA Register, offset: 0x4 */
  __IO uint32_t TSHD;                              /**< TSI Threshold Register, offset: 0x8 */
} TSI_Type, *TSI_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- TSI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TSI_Register_Accessor_Macros TSI - Register accessor macros
 * @{
 */


/* TSI - Register accessors */
#define TSI_GENCS_REG(base)                      ((base)->GENCS)
#define TSI_DATA_REG(base)                       ((base)->DATA)
#define TSI_TSHD_REG(base)                       ((base)->TSHD)

/*!
 * @}
 */ /* end of group TSI_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- TSI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TSI_Register_Masks TSI Register Masks
 * @{
 */

/* GENCS Bit Fields */
#define TSI_GENCS_EOSDMEO_MASK                   0x1u
#define TSI_GENCS_EOSDMEO_SHIFT                  0
#define TSI_GENCS_EOSDMEO_WIDTH                  1
#define TSI_GENCS_EOSDMEO(x)                     (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_EOSDMEO_SHIFT))&TSI_GENCS_EOSDMEO_MASK)
#define TSI_GENCS_CURSW_MASK                     0x2u
#define TSI_GENCS_CURSW_SHIFT                    1
#define TSI_GENCS_CURSW_WIDTH                    1
#define TSI_GENCS_CURSW(x)                       (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_CURSW_SHIFT))&TSI_GENCS_CURSW_MASK)
#define TSI_GENCS_EOSF_MASK                      0x4u
#define TSI_GENCS_EOSF_SHIFT                     2
#define TSI_GENCS_EOSF_WIDTH                     1
#define TSI_GENCS_EOSF(x)                        (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_EOSF_SHIFT))&TSI_GENCS_EOSF_MASK)
#define TSI_GENCS_SCNIP_MASK                     0x8u
#define TSI_GENCS_SCNIP_SHIFT                    3
#define TSI_GENCS_SCNIP_WIDTH                    1
#define TSI_GENCS_SCNIP(x)                       (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_SCNIP_SHIFT))&TSI_GENCS_SCNIP_MASK)
#define TSI_GENCS_STM_MASK                       0x10u
#define TSI_GENCS_STM_SHIFT                      4
#define TSI_GENCS_STM_WIDTH                      1
#define TSI_GENCS_STM(x)                         (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_STM_SHIFT))&TSI_GENCS_STM_MASK)
#define TSI_GENCS_STPE_MASK                      0x20u
#define TSI_GENCS_STPE_SHIFT                     5
#define TSI_GENCS_STPE_WIDTH                     1
#define TSI_GENCS_STPE(x)                        (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_STPE_SHIFT))&TSI_GENCS_STPE_MASK)
#define TSI_GENCS_TSIIEN_MASK                    0x40u
#define TSI_GENCS_TSIIEN_SHIFT                   6
#define TSI_GENCS_TSIIEN_WIDTH                   1
#define TSI_GENCS_TSIIEN(x)                      (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_TSIIEN_SHIFT))&TSI_GENCS_TSIIEN_MASK)
#define TSI_GENCS_TSIEN_MASK                     0x80u
#define TSI_GENCS_TSIEN_SHIFT                    7
#define TSI_GENCS_TSIEN_WIDTH                    1
#define TSI_GENCS_TSIEN(x)                       (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_TSIEN_SHIFT))&TSI_GENCS_TSIEN_MASK)
#define TSI_GENCS_NSCN_MASK                      0x1F00u
#define TSI_GENCS_NSCN_SHIFT                     8
#define TSI_GENCS_NSCN_WIDTH                     5
#define TSI_GENCS_NSCN(x)                        (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_NSCN_SHIFT))&TSI_GENCS_NSCN_MASK)
#define TSI_GENCS_PS_MASK                        0xE000u
#define TSI_GENCS_PS_SHIFT                       13
#define TSI_GENCS_PS_WIDTH                       3
#define TSI_GENCS_PS(x)                          (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_PS_SHIFT))&TSI_GENCS_PS_MASK)
#define TSI_GENCS_EXTCHRG_MASK                   0x70000u
#define TSI_GENCS_EXTCHRG_SHIFT                  16
#define TSI_GENCS_EXTCHRG_WIDTH                  3
#define TSI_GENCS_EXTCHRG(x)                     (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_EXTCHRG_SHIFT))&TSI_GENCS_EXTCHRG_MASK)
#define TSI_GENCS_DVOLT_MASK                     0x180000u
#define TSI_GENCS_DVOLT_SHIFT                    19
#define TSI_GENCS_DVOLT_WIDTH                    2
#define TSI_GENCS_DVOLT(x)                       (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_DVOLT_SHIFT))&TSI_GENCS_DVOLT_MASK)
#define TSI_GENCS_REFCHRG_MASK                   0xE00000u
#define TSI_GENCS_REFCHRG_SHIFT                  21
#define TSI_GENCS_REFCHRG_WIDTH                  3
#define TSI_GENCS_REFCHRG(x)                     (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_REFCHRG_SHIFT))&TSI_GENCS_REFCHRG_MASK)
#define TSI_GENCS_MODE_MASK                      0xF000000u
#define TSI_GENCS_MODE_SHIFT                     24
#define TSI_GENCS_MODE_WIDTH                     4
#define TSI_GENCS_MODE(x)                        (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_MODE_SHIFT))&TSI_GENCS_MODE_MASK)
#define TSI_GENCS_ESOR_MASK                      0x10000000u
#define TSI_GENCS_ESOR_SHIFT                     28
#define TSI_GENCS_ESOR_WIDTH                     1
#define TSI_GENCS_ESOR(x)                        (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_ESOR_SHIFT))&TSI_GENCS_ESOR_MASK)
#define TSI_GENCS_OUTRGF_MASK                    0x80000000u
#define TSI_GENCS_OUTRGF_SHIFT                   31
#define TSI_GENCS_OUTRGF_WIDTH                   1
#define TSI_GENCS_OUTRGF(x)                      (((uint32_t)(((uint32_t)(x))<<TSI_GENCS_OUTRGF_SHIFT))&TSI_GENCS_OUTRGF_MASK)
/* DATA Bit Fields */
#define TSI_DATA_TSICNT_MASK                     0xFFFFu
#define TSI_DATA_TSICNT_SHIFT                    0
#define TSI_DATA_TSICNT_WIDTH                    16
#define TSI_DATA_TSICNT(x)                       (((uint32_t)(((uint32_t)(x))<<TSI_DATA_TSICNT_SHIFT))&TSI_DATA_TSICNT_MASK)
#define TSI_DATA_SWTS_MASK                       0x400000u
#define TSI_DATA_SWTS_SHIFT                      22
#define TSI_DATA_SWTS_WIDTH                      1
#define TSI_DATA_SWTS(x)                         (((uint32_t)(((uint32_t)(x))<<TSI_DATA_SWTS_SHIFT))&TSI_DATA_SWTS_MASK)
#define TSI_DATA_DMAEN_MASK                      0x800000u
#define TSI_DATA_DMAEN_SHIFT                     23
#define TSI_DATA_DMAEN_WIDTH                     1
#define TSI_DATA_DMAEN(x)                        (((uint32_t)(((uint32_t)(x))<<TSI_DATA_DMAEN_SHIFT))&TSI_DATA_DMAEN_MASK)
#define TSI_DATA_TSICH_MASK                      0xF0000000u
#define TSI_DATA_TSICH_SHIFT                     28
#define TSI_DATA_TSICH_WIDTH                     4
#define TSI_DATA_TSICH(x)                        (((uint32_t)(((uint32_t)(x))<<TSI_DATA_TSICH_SHIFT))&TSI_DATA_TSICH_MASK)
/* TSHD Bit Fields */
#define TSI_TSHD_THRESL_MASK                     0xFFFFu
#define TSI_TSHD_THRESL_SHIFT                    0
#define TSI_TSHD_THRESL_WIDTH                    16
#define TSI_TSHD_THRESL(x)                       (((uint32_t)(((uint32_t)(x))<<TSI_TSHD_THRESL_SHIFT))&TSI_TSHD_THRESL_MASK)
#define TSI_TSHD_THRESH_MASK                     0xFFFF0000u
#define TSI_TSHD_THRESH_SHIFT                    16
#define TSI_TSHD_THRESH_WIDTH                    16
#define TSI_TSHD_THRESH(x)                       (((uint32_t)(((uint32_t)(x))<<TSI_TSHD_THRESH_SHIFT))&TSI_TSHD_THRESH_MASK)

/*!
 * @}
 */ /* end of group TSI_Register_Masks */


/* TSI - Peripheral instance base addresses */
/** Peripheral TSI0 base address */
#define TSI0_BASE                                (0x40045000u)
/** Peripheral TSI0 base pointer */
#define TSI0                                     ((TSI_Type *)TSI0_BASE)
#define TSI0_BASE_PTR                            (TSI0)
/** Array initializer of TSI peripheral base addresses */
#define TSI_BASE_ADDRS                           { TSI0_BASE }
/** Array initializer of TSI peripheral base pointers */
#define TSI_BASE_PTRS                            { TSI0 }

/* ----------------------------------------------------------------------------
   -- TSI - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup TSI_Register_Accessor_Macros TSI - Register accessor macros
 * @{
 */


/* TSI - Register instance definitions */
/* TSI0 */
#define TSI0_GENCS                               TSI_GENCS_REG(TSI0)
#define TSI0_DATA                                TSI_DATA_REG(TSI0)
#define TSI0_TSHD                                TSI_TSHD_REG(TSI0)

/*!
 * @}
 */ /* end of group TSI_Register_Accessor_Macros */


/*!
 * @}
 */ /* end of group TSI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- USB Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup USB_Peripheral_Access_Layer USB Peripheral Access Layer
 * @{
 */

/** USB - Register Layout Typedef */
typedef struct {
  __I  uint8_t PERID;                              /**< Peripheral ID register, offset: 0x0 */
       uint8_t RESERVED_0[3];
  __I  uint8_t IDCOMP;                             /**< Peripheral ID Complement register, offset: 0x4 */
       uint8_t RESERVED_1[3];
  __I  uint8_t REV;                                /**< Peripheral Revision register, offset: 0x8 */
       uint8_t RESERVED_2[3];
  __I  uint8_t ADDINFO;                            /**< Peripheral Additional Info register, offset: 0xC */
       uint8_t RESERVED_3[3];
  __IO uint8_t OTGISTAT;                           /**< OTG Interrupt Status register, offset: 0x10 */
       uint8_t RESERVED_4[3];
  __IO uint8_t OTGICR;                             /**< OTG Interrupt Control register, offset: 0x14 */
       uint8_t RESERVED_5[3];
  __IO uint8_t OTGSTAT;                            /**< OTG Status register, offset: 0x18 */
       uint8_t RESERVED_6[3];
  __IO uint8_t OTGCTL;                             /**< OTG Control register, offset: 0x1C */
       uint8_t RESERVED_7[99];
  __IO uint8_t ISTAT;                              /**< Interrupt Status register, offset: 0x80 */
       uint8_t RESERVED_8[3];
  __IO uint8_t INTEN;                              /**< Interrupt Enable register, offset: 0x84 */
       uint8_t RESERVED_9[3];
  __IO uint8_t ERRSTAT;                            /**< Error Interrupt Status register, offset: 0x88 */
       uint8_t RESERVED_10[3];
  __IO uint8_t ERREN;                              /**< Error Interrupt Enable register, offset: 0x8C */
       uint8_t RESERVED_11[3];
  __I  uint8_t STAT;                               /**< Status register, offset: 0x90 */
       uint8_t RESERVED_12[3];
  __IO uint8_t CTL;                                /**< Control register, offset: 0x94 */
       uint8_t RESERVED_13[3];
  __IO uint8_t ADDR;                               /**< Address register, offset: 0x98 */
       uint8_t RESERVED_14[3];
  __IO uint8_t BDTPAGE1;                           /**< BDT Page register 1, offset: 0x9C */
       uint8_t RESERVED_15[3];
  __IO uint8_t FRMNUML;                            /**< Frame Number register Low, offset: 0xA0 */
       uint8_t RESERVED_16[3];
  __IO uint8_t FRMNUMH;                            /**< Frame Number register High, offset: 0xA4 */
       uint8_t RESERVED_17[3];
  __IO uint8_t TOKEN;                              /**< Token register, offset: 0xA8 */
       uint8_t RESERVED_18[3];
  __IO uint8_t SOFTHLD;                            /**< SOF Threshold register, offset: 0xAC */
       uint8_t RESERVED_19[3];
  __IO uint8_t BDTPAGE2;                           /**< BDT Page Register 2, offset: 0xB0 */
       uint8_t RESERVED_20[3];
  __IO uint8_t BDTPAGE3;                           /**< BDT Page Register 3, offset: 0xB4 */
       uint8_t RESERVED_21[11];
  struct {                                         /* offset: 0xC0, array step: 0x4 */
    __IO uint8_t ENDPT;                              /**< Endpoint Control register, array offset: 0xC0, array step: 0x4 */
         uint8_t RESERVED_0[3];
  } ENDPOINT[16];
  __IO uint8_t USBCTRL;                            /**< USB Control register, offset: 0x100 */
       uint8_t RESERVED_22[3];
  __I  uint8_t OBSERVE;                            /**< USB OTG Observe register, offset: 0x104 */
       uint8_t RESERVED_23[3];
  __IO uint8_t CONTROL;                            /**< USB OTG Control register, offset: 0x108 */
       uint8_t RESERVED_24[3];
  __IO uint8_t USBTRC0;                            /**< USB Transceiver Control register 0, offset: 0x10C */
       uint8_t RESERVED_25[7];
  __IO uint8_t USBFRMADJUST;                       /**< Frame Adjust Register, offset: 0x114 */
       uint8_t RESERVED_26[15];
  __IO uint8_t KEEP_ALIVE_CTRL;                    /**< Keep Alive mode control, offset: 0x124 */
       uint8_t RESERVED_27[3];
  __IO uint8_t KEEP_ALIVE_WKCTRL;                  /**< Keep Alive mode wakeup control, offset: 0x128 */
       uint8_t RESERVED_28[3];
  __IO uint8_t MISCCTRL;                           /**< Miscellaneous Control register, offset: 0x12C */
       uint8_t RESERVED_29[3];
  __IO uint8_t STALL_IL_DIS;                       /**< Peripheral mode stall disable for endpoints 7 to 0 in IN direction, offset: 0x130 */
       uint8_t RESERVED_30[3];
  __IO uint8_t STALL_IH_DIS;                       /**< Peripheral mode stall disable for endpoints 15 to 8 in IN direction, offset: 0x134 */
       uint8_t RESERVED_31[3];
  __IO uint8_t STALL_OL_DIS;                       /**< Peripheral mode stall disable for endpoints 7 to 0 in OUT direction, offset: 0x138 */
       uint8_t RESERVED_32[3];
  __IO uint8_t STALL_OH_DIS;                       /**< Peripheral mode stall disable for endpoints 15 to 8 in OUT direction, offset: 0x13C */
       uint8_t RESERVED_33[3];
  __IO uint8_t CLK_RECOVER_CTRL;                   /**< USB Clock recovery control, offset: 0x140 */
       uint8_t RESERVED_34[3];
  __IO uint8_t CLK_RECOVER_IRC_EN;                 /**< IRC48M oscillator enable register, offset: 0x144 */
       uint8_t RESERVED_35[15];
  __IO uint8_t CLK_RECOVER_INT_EN;                 /**< Clock recovery combined interrupt enable, offset: 0x154 */
       uint8_t RESERVED_36[7];
  __IO uint8_t CLK_RECOVER_INT_STATUS;             /**< Clock recovery separated interrupt status, offset: 0x15C */
} USB_Type, *USB_MemMapPtr;

/* ----------------------------------------------------------------------------
   -- USB - Register accessor macros
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup USB_Register_Accessor_Macros USB - Register accessor macros
 * @{
 */


/* USB - Register accessors */
#define USB_PERID_REG(base)                      ((base)->PERID)
#define USB_IDCOMP_REG(base)                     ((base)->IDCOMP)
#define USB_REV_REG(base)                        ((base)->REV)
#define USB_ADDINFO_REG(base)                    ((base)->ADDINFO)
#define USB_OTGISTAT_REG(base)                   ((base)->OTGISTAT)
#define USB_OTGICR_REG(base)                     ((base)->OTGICR)
#define USB_OTGSTAT_REG(base)                    ((base)->OTGSTAT)
#define USB_OTGCTL_REG(base)                     ((base)->OTGCTL)
#define USB_ISTAT_REG(base)                      ((base)->ISTAT)
#define USB_INTEN_REG(base)                      ((base)->INTEN)
#define USB_ERRSTAT_REG(base)                    ((base)->ERRSTAT)
#define USB_ERREN_REG(base)                      ((base)->ERREN)
#define USB_STAT_REG(base)                       ((base)->STAT)
#define USB_CTL_REG(base)                        ((base)->CTL)
#define USB_ADDR_REG(base)                       ((base)->ADDR)
#define USB_BDTPAGE1_REG(base)                   ((base)->BDTPAGE1)
#define USB_FRMNUML_REG(base)                    ((base)->FRMNUML)
#define USB_FRMNUMH_REG(base)                    ((base)->FRMNUMH)
#define USB_TOKEN_REG(base)                      ((base)->TOKEN)
#define USB_SOFTHLD_REG(base)                    ((base)->SOFTHLD)
#define USB_BDTPAGE2_REG(base)                   ((base)->BDTPAGE2)
#define USB_BDTPAGE3_REG(base)                   ((base)->BDTPAGE3)
#define USB_ENDPT_REG(base,index)                ((base)->ENDPOINT[index].ENDPT)
#define USB_ENDPT_COUNT                          16
#define USB_USBCTRL_REG(base)                    ((base)->USBCTRL)
#define USB_OBSERVE_REG(base)                    ((base)->OBSERVE)
#define USB_CONTROL_REG(base)                    ((base)->CONTROL)
#define USB_USBTRC0_REG(base)                    ((base)->USBTRC0)
#define USB_USBFRMADJUST_REG(base)               ((base)->USBFRMADJUST)
#define USB_KEEP_ALIVE_CTRL_REG(base)            ((base)->KEEP_ALIVE_CTRL)
#define USB_KEEP_ALIVE_WKCTRL_REG(base)          ((base)->KEEP_ALIVE_WKCTRL)
#define USB_MISCCTRL_REG(base)                   ((base)->MISCCTRL)
#define USB_STALL_IL_DIS_REG(base)               ((base)->STALL_IL_DIS)
#define USB_STALL_IH_DIS_REG(base)               ((base)->STALL_IH_DIS)
#define USB_STALL_OL_DIS_REG(base)               ((base)->STALL_OL_DIS)
#define USB_STALL_OH_DIS_REG(base)               ((base)->STALL_OH_DIS)
#define USB_CLK_RECOVER_CTRL_REG(base)           ((base)->CLK_RECOVER_CTRL)
#define USB_CLK_RECOVER_IRC_EN_REG(base)         ((base)->CLK_RECOVER_IRC_EN)
#define USB_CLK_RECOVER_INT_EN_REG(base)         ((base)->CLK_RECOVER_INT_EN)
#define USB_CLK_RECOVER_INT_STATUS_REG(base)     ((base)->CLK_RECOVER_INT_STATUS)

/*!
 * @}
 */ /* end of group USB_Register_Accessor_Macros */


/* ----------------------------------------------------------------------------
   -- USB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup USB_Register_Masks USB Register Masks
 * @{
 */

/* PERID Bit Fields */
#define USB_PERID_ID_MASK                        0x3Fu
#define USB_PERID_ID_SHIFT                       0
#define USB_PERID_ID_WIDTH                       6
#define USB_PERID_ID(x)                          (((uint8_t)(((uint8_t)(x))<<USB_PERID_ID_SHIFT))&USB_PERID_ID_MASK)
/* IDCOMP Bit Fields */
#define USB_IDCOMP_NID_MASK                      0x3Fu
#define USB_IDCOMP_NID_SHIFT                     0
#define USB_IDCOMP_NID_WIDTH                     6
#define USB_IDCOMP_NID(x)                        (((uint8_t)(((uint8_t)(x))<<USB_IDCOMP_NID_SHIFT))&USB_IDCOMP_NID_MASK)
/* REV Bit Fields */
#define USB_REV_REV_MASK                         0xFFu
#define USB_REV_REV_SHIFT                        0
#define USB_REV_REV_WIDTH                        8
#define USB_REV_REV(x)                           (((uint8_t)(((uint8_t)(x))<<USB_REV_REV_SHIFT))&USB_REV_REV_MASK)
/* ADDINFO Bit Fields */
#define USB_ADDINFO_IEHOST_MASK                  0x1u
#define USB_ADDINFO_IEHOST_SHIFT                 0
#define USB_ADDINFO_IEHOST_WIDTH                 1
#define USB_ADDINFO_IEHOST(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ADDINFO_IEHOST_SHIFT))&USB_ADDINFO_IEHOST_MASK)
/* OTGISTAT Bit Fields */
#define USB_OTGISTAT_LINE_STATE_CHG_MASK         0x20u
#define USB_OTGISTAT_LINE_STATE_CHG_SHIFT        5
#define USB_OTGISTAT_LINE_STATE_CHG_WIDTH        1
#define USB_OTGISTAT_LINE_STATE_CHG(x)           (((uint8_t)(((uint8_t)(x))<<USB_OTGISTAT_LINE_STATE_CHG_SHIFT))&USB_OTGISTAT_LINE_STATE_CHG_MASK)
#define USB_OTGISTAT_ONEMSEC_MASK                0x40u
#define USB_OTGISTAT_ONEMSEC_SHIFT               6
#define USB_OTGISTAT_ONEMSEC_WIDTH               1
#define USB_OTGISTAT_ONEMSEC(x)                  (((uint8_t)(((uint8_t)(x))<<USB_OTGISTAT_ONEMSEC_SHIFT))&USB_OTGISTAT_ONEMSEC_MASK)
/* OTGICR Bit Fields */
#define USB_OTGICR_LINESTATEEN_MASK              0x20u
#define USB_OTGICR_LINESTATEEN_SHIFT             5
#define USB_OTGICR_LINESTATEEN_WIDTH             1
#define USB_OTGICR_LINESTATEEN(x)                (((uint8_t)(((uint8_t)(x))<<USB_OTGICR_LINESTATEEN_SHIFT))&USB_OTGICR_LINESTATEEN_MASK)
#define USB_OTGICR_ONEMSECEN_MASK                0x40u
#define USB_OTGICR_ONEMSECEN_SHIFT               6
#define USB_OTGICR_ONEMSECEN_WIDTH               1
#define USB_OTGICR_ONEMSECEN(x)                  (((uint8_t)(((uint8_t)(x))<<USB_OTGICR_ONEMSECEN_SHIFT))&USB_OTGICR_ONEMSECEN_MASK)
/* OTGSTAT Bit Fields */
#define USB_OTGSTAT_LINESTATESTABLE_MASK         0x20u
#define USB_OTGSTAT_LINESTATESTABLE_SHIFT        5
#define USB_OTGSTAT_LINESTATESTABLE_WIDTH        1
#define USB_OTGSTAT_LINESTATESTABLE(x)           (((uint8_t)(((uint8_t)(x))<<USB_OTGSTAT_LINESTATESTABLE_SHIFT))&USB_OTGSTAT_LINESTATESTABLE_MASK)
#define USB_OTGSTAT_ONEMSECEN_MASK               0x40u
#define USB_OTGSTAT_ONEMSECEN_SHIFT              6
#define USB_OTGSTAT_ONEMSECEN_WIDTH              1
#define USB_OTGSTAT_ONEMSECEN(x)                 (((uint8_t)(((uint8_t)(x))<<USB_OTGSTAT_ONEMSECEN_SHIFT))&USB_OTGSTAT_ONEMSECEN_MASK)
/* OTGCTL Bit Fields */
#define USB_OTGCTL_OTGEN_MASK                    0x4u
#define USB_OTGCTL_OTGEN_SHIFT                   2
#define USB_OTGCTL_OTGEN_WIDTH                   1
#define USB_OTGCTL_OTGEN(x)                      (((uint8_t)(((uint8_t)(x))<<USB_OTGCTL_OTGEN_SHIFT))&USB_OTGCTL_OTGEN_MASK)
#define USB_OTGCTL_DMLOW_MASK                    0x10u
#define USB_OTGCTL_DMLOW_SHIFT                   4
#define USB_OTGCTL_DMLOW_WIDTH                   1
#define USB_OTGCTL_DMLOW(x)                      (((uint8_t)(((uint8_t)(x))<<USB_OTGCTL_DMLOW_SHIFT))&USB_OTGCTL_DMLOW_MASK)
#define USB_OTGCTL_DPLOW_MASK                    0x20u
#define USB_OTGCTL_DPLOW_SHIFT                   5
#define USB_OTGCTL_DPLOW_WIDTH                   1
#define USB_OTGCTL_DPLOW(x)                      (((uint8_t)(((uint8_t)(x))<<USB_OTGCTL_DPLOW_SHIFT))&USB_OTGCTL_DPLOW_MASK)
#define USB_OTGCTL_DPHIGH_MASK                   0x80u
#define USB_OTGCTL_DPHIGH_SHIFT                  7
#define USB_OTGCTL_DPHIGH_WIDTH                  1
#define USB_OTGCTL_DPHIGH(x)                     (((uint8_t)(((uint8_t)(x))<<USB_OTGCTL_DPHIGH_SHIFT))&USB_OTGCTL_DPHIGH_MASK)
/* ISTAT Bit Fields */
#define USB_ISTAT_USBRST_MASK                    0x1u
#define USB_ISTAT_USBRST_SHIFT                   0
#define USB_ISTAT_USBRST_WIDTH                   1
#define USB_ISTAT_USBRST(x)                      (((uint8_t)(((uint8_t)(x))<<USB_ISTAT_USBRST_SHIFT))&USB_ISTAT_USBRST_MASK)
#define USB_ISTAT_ERROR_MASK                     0x2u
#define USB_ISTAT_ERROR_SHIFT                    1
#define USB_ISTAT_ERROR_WIDTH                    1
#define USB_ISTAT_ERROR(x)                       (((uint8_t)(((uint8_t)(x))<<USB_ISTAT_ERROR_SHIFT))&USB_ISTAT_ERROR_MASK)
#define USB_ISTAT_SOFTOK_MASK                    0x4u
#define USB_ISTAT_SOFTOK_SHIFT                   2
#define USB_ISTAT_SOFTOK_WIDTH                   1
#define USB_ISTAT_SOFTOK(x)                      (((uint8_t)(((uint8_t)(x))<<USB_ISTAT_SOFTOK_SHIFT))&USB_ISTAT_SOFTOK_MASK)
#define USB_ISTAT_TOKDNE_MASK                    0x8u
#define USB_ISTAT_TOKDNE_SHIFT                   3
#define USB_ISTAT_TOKDNE_WIDTH                   1
#define USB_ISTAT_TOKDNE(x)                      (((uint8_t)(((uint8_t)(x))<<USB_ISTAT_TOKDNE_SHIFT))&USB_ISTAT_TOKDNE_MASK)
#define USB_ISTAT_SLEEP_MASK                     0x10u
#define USB_ISTAT_SLEEP_SHIFT                    4
#define USB_ISTAT_SLEEP_WIDTH                    1
#define USB_ISTAT_SLEEP(x)                       (((uint8_t)(((uint8_t)(x))<<USB_ISTAT_SLEEP_SHIFT))&USB_ISTAT_SLEEP_MASK)
#define USB_ISTAT_RESUME_MASK                    0x20u
#define USB_ISTAT_RESUME_SHIFT                   5
#define USB_ISTAT_RESUME_WIDTH                   1
#define USB_ISTAT_RESUME(x)                      (((uint8_t)(((uint8_t)(x))<<USB_ISTAT_RESUME_SHIFT))&USB_ISTAT_RESUME_MASK)
#define USB_ISTAT_ATTACH_MASK                    0x40u
#define USB_ISTAT_ATTACH_SHIFT                   6
#define USB_ISTAT_ATTACH_WIDTH                   1
#define USB_ISTAT_ATTACH(x)                      (((uint8_t)(((uint8_t)(x))<<USB_ISTAT_ATTACH_SHIFT))&USB_ISTAT_ATTACH_MASK)
#define USB_ISTAT_STALL_MASK                     0x80u
#define USB_ISTAT_STALL_SHIFT                    7
#define USB_ISTAT_STALL_WIDTH                    1
#define USB_ISTAT_STALL(x)                       (((uint8_t)(((uint8_t)(x))<<USB_ISTAT_STALL_SHIFT))&USB_ISTAT_STALL_MASK)
/* INTEN Bit Fields */
#define USB_INTEN_USBRSTEN_MASK                  0x1u
#define USB_INTEN_USBRSTEN_SHIFT                 0
#define USB_INTEN_USBRSTEN_WIDTH                 1
#define USB_INTEN_USBRSTEN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_INTEN_USBRSTEN_SHIFT))&USB_INTEN_USBRSTEN_MASK)
#define USB_INTEN_ERROREN_MASK                   0x2u
#define USB_INTEN_ERROREN_SHIFT                  1
#define USB_INTEN_ERROREN_WIDTH                  1
#define USB_INTEN_ERROREN(x)                     (((uint8_t)(((uint8_t)(x))<<USB_INTEN_ERROREN_SHIFT))&USB_INTEN_ERROREN_MASK)
#define USB_INTEN_SOFTOKEN_MASK                  0x4u
#define USB_INTEN_SOFTOKEN_SHIFT                 2
#define USB_INTEN_SOFTOKEN_WIDTH                 1
#define USB_INTEN_SOFTOKEN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_INTEN_SOFTOKEN_SHIFT))&USB_INTEN_SOFTOKEN_MASK)
#define USB_INTEN_TOKDNEEN_MASK                  0x8u
#define USB_INTEN_TOKDNEEN_SHIFT                 3
#define USB_INTEN_TOKDNEEN_WIDTH                 1
#define USB_INTEN_TOKDNEEN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_INTEN_TOKDNEEN_SHIFT))&USB_INTEN_TOKDNEEN_MASK)
#define USB_INTEN_SLEEPEN_MASK                   0x10u
#define USB_INTEN_SLEEPEN_SHIFT                  4
#define USB_INTEN_SLEEPEN_WIDTH                  1
#define USB_INTEN_SLEEPEN(x)                     (((uint8_t)(((uint8_t)(x))<<USB_INTEN_SLEEPEN_SHIFT))&USB_INTEN_SLEEPEN_MASK)
#define USB_INTEN_RESUMEEN_MASK                  0x20u
#define USB_INTEN_RESUMEEN_SHIFT                 5
#define USB_INTEN_RESUMEEN_WIDTH                 1
#define USB_INTEN_RESUMEEN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_INTEN_RESUMEEN_SHIFT))&USB_INTEN_RESUMEEN_MASK)
#define USB_INTEN_ATTACHEN_MASK                  0x40u
#define USB_INTEN_ATTACHEN_SHIFT                 6
#define USB_INTEN_ATTACHEN_WIDTH                 1
#define USB_INTEN_ATTACHEN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_INTEN_ATTACHEN_SHIFT))&USB_INTEN_ATTACHEN_MASK)
#define USB_INTEN_STALLEN_MASK                   0x80u
#define USB_INTEN_STALLEN_SHIFT                  7
#define USB_INTEN_STALLEN_WIDTH                  1
#define USB_INTEN_STALLEN(x)                     (((uint8_t)(((uint8_t)(x))<<USB_INTEN_STALLEN_SHIFT))&USB_INTEN_STALLEN_MASK)
/* ERRSTAT Bit Fields */
#define USB_ERRSTAT_PIDERR_MASK                  0x1u
#define USB_ERRSTAT_PIDERR_SHIFT                 0
#define USB_ERRSTAT_PIDERR_WIDTH                 1
#define USB_ERRSTAT_PIDERR(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ERRSTAT_PIDERR_SHIFT))&USB_ERRSTAT_PIDERR_MASK)
#define USB_ERRSTAT_CRC5EOF_MASK                 0x2u
#define USB_ERRSTAT_CRC5EOF_SHIFT                1
#define USB_ERRSTAT_CRC5EOF_WIDTH                1
#define USB_ERRSTAT_CRC5EOF(x)                   (((uint8_t)(((uint8_t)(x))<<USB_ERRSTAT_CRC5EOF_SHIFT))&USB_ERRSTAT_CRC5EOF_MASK)
#define USB_ERRSTAT_CRC16_MASK                   0x4u
#define USB_ERRSTAT_CRC16_SHIFT                  2
#define USB_ERRSTAT_CRC16_WIDTH                  1
#define USB_ERRSTAT_CRC16(x)                     (((uint8_t)(((uint8_t)(x))<<USB_ERRSTAT_CRC16_SHIFT))&USB_ERRSTAT_CRC16_MASK)
#define USB_ERRSTAT_DFN8_MASK                    0x8u
#define USB_ERRSTAT_DFN8_SHIFT                   3
#define USB_ERRSTAT_DFN8_WIDTH                   1
#define USB_ERRSTAT_DFN8(x)                      (((uint8_t)(((uint8_t)(x))<<USB_ERRSTAT_DFN8_SHIFT))&USB_ERRSTAT_DFN8_MASK)
#define USB_ERRSTAT_BTOERR_MASK                  0x10u
#define USB_ERRSTAT_BTOERR_SHIFT                 4
#define USB_ERRSTAT_BTOERR_WIDTH                 1
#define USB_ERRSTAT_BTOERR(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ERRSTAT_BTOERR_SHIFT))&USB_ERRSTAT_BTOERR_MASK)
#define USB_ERRSTAT_DMAERR_MASK                  0x20u
#define USB_ERRSTAT_DMAERR_SHIFT                 5
#define USB_ERRSTAT_DMAERR_WIDTH                 1
#define USB_ERRSTAT_DMAERR(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ERRSTAT_DMAERR_SHIFT))&USB_ERRSTAT_DMAERR_MASK)
#define USB_ERRSTAT_OWNERR_MASK                  0x40u
#define USB_ERRSTAT_OWNERR_SHIFT                 6
#define USB_ERRSTAT_OWNERR_WIDTH                 1
#define USB_ERRSTAT_OWNERR(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ERRSTAT_OWNERR_SHIFT))&USB_ERRSTAT_OWNERR_MASK)
#define USB_ERRSTAT_BTSERR_MASK                  0x80u
#define USB_ERRSTAT_BTSERR_SHIFT                 7
#define USB_ERRSTAT_BTSERR_WIDTH                 1
#define USB_ERRSTAT_BTSERR(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ERRSTAT_BTSERR_SHIFT))&USB_ERRSTAT_BTSERR_MASK)
/* ERREN Bit Fields */
#define USB_ERREN_PIDERREN_MASK                  0x1u
#define USB_ERREN_PIDERREN_SHIFT                 0
#define USB_ERREN_PIDERREN_WIDTH                 1
#define USB_ERREN_PIDERREN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ERREN_PIDERREN_SHIFT))&USB_ERREN_PIDERREN_MASK)
#define USB_ERREN_CRC5EOFEN_MASK                 0x2u
#define USB_ERREN_CRC5EOFEN_SHIFT                1
#define USB_ERREN_CRC5EOFEN_WIDTH                1
#define USB_ERREN_CRC5EOFEN(x)                   (((uint8_t)(((uint8_t)(x))<<USB_ERREN_CRC5EOFEN_SHIFT))&USB_ERREN_CRC5EOFEN_MASK)
#define USB_ERREN_CRC16EN_MASK                   0x4u
#define USB_ERREN_CRC16EN_SHIFT                  2
#define USB_ERREN_CRC16EN_WIDTH                  1
#define USB_ERREN_CRC16EN(x)                     (((uint8_t)(((uint8_t)(x))<<USB_ERREN_CRC16EN_SHIFT))&USB_ERREN_CRC16EN_MASK)
#define USB_ERREN_DFN8EN_MASK                    0x8u
#define USB_ERREN_DFN8EN_SHIFT                   3
#define USB_ERREN_DFN8EN_WIDTH                   1
#define USB_ERREN_DFN8EN(x)                      (((uint8_t)(((uint8_t)(x))<<USB_ERREN_DFN8EN_SHIFT))&USB_ERREN_DFN8EN_MASK)
#define USB_ERREN_BTOERREN_MASK                  0x10u
#define USB_ERREN_BTOERREN_SHIFT                 4
#define USB_ERREN_BTOERREN_WIDTH                 1
#define USB_ERREN_BTOERREN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ERREN_BTOERREN_SHIFT))&USB_ERREN_BTOERREN_MASK)
#define USB_ERREN_DMAERREN_MASK                  0x20u
#define USB_ERREN_DMAERREN_SHIFT                 5
#define USB_ERREN_DMAERREN_WIDTH                 1
#define USB_ERREN_DMAERREN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ERREN_DMAERREN_SHIFT))&USB_ERREN_DMAERREN_MASK)
#define USB_ERREN_OWNERREN_MASK                  0x40u
#define USB_ERREN_OWNERREN_SHIFT                 6
#define USB_ERREN_OWNERREN_WIDTH                 1
#define USB_ERREN_OWNERREN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ERREN_OWNERREN_SHIFT))&USB_ERREN_OWNERREN_MASK)
#define USB_ERREN_BTSERREN_MASK                  0x80u
#define USB_ERREN_BTSERREN_SHIFT                 7
#define USB_ERREN_BTSERREN_WIDTH                 1
#define USB_ERREN_BTSERREN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ERREN_BTSERREN_SHIFT))&USB_ERREN_BTSERREN_MASK)
/* STAT Bit Fields */
#define USB_STAT_ODD_MASK                        0x4u
#define USB_STAT_ODD_SHIFT                       2
#define USB_STAT_ODD_WIDTH                       1
#define USB_STAT_ODD(x)                          (((uint8_t)(((uint8_t)(x))<<USB_STAT_ODD_SHIFT))&USB_STAT_ODD_MASK)
#define USB_STAT_TX_MASK                         0x8u
#define USB_STAT_TX_SHIFT                        3
#define USB_STAT_TX_WIDTH                        1
#define USB_STAT_TX(x)                           (((uint8_t)(((uint8_t)(x))<<USB_STAT_TX_SHIFT))&USB_STAT_TX_MASK)
#define USB_STAT_ENDP_MASK                       0xF0u
#define USB_STAT_ENDP_SHIFT                      4
#define USB_STAT_ENDP_WIDTH                      4
#define USB_STAT_ENDP(x)                         (((uint8_t)(((uint8_t)(x))<<USB_STAT_ENDP_SHIFT))&USB_STAT_ENDP_MASK)
/* CTL Bit Fields */
#define USB_CTL_USBENSOFEN_MASK                  0x1u
#define USB_CTL_USBENSOFEN_SHIFT                 0
#define USB_CTL_USBENSOFEN_WIDTH                 1
#define USB_CTL_USBENSOFEN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_CTL_USBENSOFEN_SHIFT))&USB_CTL_USBENSOFEN_MASK)
#define USB_CTL_ODDRST_MASK                      0x2u
#define USB_CTL_ODDRST_SHIFT                     1
#define USB_CTL_ODDRST_WIDTH                     1
#define USB_CTL_ODDRST(x)                        (((uint8_t)(((uint8_t)(x))<<USB_CTL_ODDRST_SHIFT))&USB_CTL_ODDRST_MASK)
#define USB_CTL_RESUME_MASK                      0x4u
#define USB_CTL_RESUME_SHIFT                     2
#define USB_CTL_RESUME_WIDTH                     1
#define USB_CTL_RESUME(x)                        (((uint8_t)(((uint8_t)(x))<<USB_CTL_RESUME_SHIFT))&USB_CTL_RESUME_MASK)
#define USB_CTL_HOSTMODEEN_MASK                  0x8u
#define USB_CTL_HOSTMODEEN_SHIFT                 3
#define USB_CTL_HOSTMODEEN_WIDTH                 1
#define USB_CTL_HOSTMODEEN(x)                    (((uint8_t)(((uint8_t)(x))<<USB_CTL_HOSTMODEEN_SHIFT))&USB_CTL_HOSTMODEEN_MASK)
#define USB_CTL_RESET_MASK                       0x10u
#define USB_CTL_RESET_SHIFT                      4
#define USB_CTL_RESET_WIDTH                      1
#define USB_CTL_RESET(x)                         (((uint8_t)(((uint8_t)(x))<<USB_CTL_RESET_SHIFT))&USB_CTL_RESET_MASK)
#define USB_CTL_TXSUSPENDTOKENBUSY_MASK          0x20u
#define USB_CTL_TXSUSPENDTOKENBUSY_SHIFT         5
#define USB_CTL_TXSUSPENDTOKENBUSY_WIDTH         1
#define USB_CTL_TXSUSPENDTOKENBUSY(x)            (((uint8_t)(((uint8_t)(x))<<USB_CTL_TXSUSPENDTOKENBUSY_SHIFT))&USB_CTL_TXSUSPENDTOKENBUSY_MASK)
#define USB_CTL_SE0_MASK                         0x40u
#define USB_CTL_SE0_SHIFT                        6
#define USB_CTL_SE0_WIDTH                        1
#define USB_CTL_SE0(x)                           (((uint8_t)(((uint8_t)(x))<<USB_CTL_SE0_SHIFT))&USB_CTL_SE0_MASK)
#define USB_CTL_JSTATE_MASK                      0x80u
#define USB_CTL_JSTATE_SHIFT                     7
#define USB_CTL_JSTATE_WIDTH                     1
#define USB_CTL_JSTATE(x)                        (((uint8_t)(((uint8_t)(x))<<USB_CTL_JSTATE_SHIFT))&USB_CTL_JSTATE_MASK)
/* ADDR Bit Fields */
#define USB_ADDR_ADDR_MASK                       0x7Fu
#define USB_ADDR_ADDR_SHIFT                      0
#define USB_ADDR_ADDR_WIDTH                      7
#define USB_ADDR_ADDR(x)                         (((uint8_t)(((uint8_t)(x))<<USB_ADDR_ADDR_SHIFT))&USB_ADDR_ADDR_MASK)
#define USB_ADDR_LSEN_MASK                       0x80u
#define USB_ADDR_LSEN_SHIFT                      7
#define USB_ADDR_LSEN_WIDTH                      1
#define USB_ADDR_LSEN(x)                         (((uint8_t)(((uint8_t)(x))<<USB_ADDR_LSEN_SHIFT))&USB_ADDR_LSEN_MASK)
/* BDTPAGE1 Bit Fields */
#define USB_BDTPAGE1_BDTBA_MASK                  0xFEu
#define USB_BDTPAGE1_BDTBA_SHIFT                 1
#define USB_BDTPAGE1_BDTBA_WIDTH                 7
#define USB_BDTPAGE1_BDTBA(x)                    (((uint8_t)(((uint8_t)(x))<<USB_BDTPAGE1_BDTBA_SHIFT))&USB_BDTPAGE1_BDTBA_MASK)
/* FRMNUML Bit Fields */
#define USB_FRMNUML_FRM_MASK                     0xFFu
#define USB_FRMNUML_FRM_SHIFT                    0
#define USB_FRMNUML_FRM_WIDTH                    8
#define USB_FRMNUML_FRM(x)                       (((uint8_t)(((uint8_t)(x))<<USB_FRMNUML_FRM_SHIFT))&USB_FRMNUML_FRM_MASK)
/* FRMNUMH Bit Fields */
#define USB_FRMNUMH_FRM_MASK                     0x7u
#define USB_FRMNUMH_FRM_SHIFT                    0
#define USB_FRMNUMH_FRM_WIDTH                    3
#define USB_FRMNUMH_FRM(x)                       (((uint8_t)(((uint8_t)(x))<<USB_FRMNUMH_FRM_SHIFT))&USB_FRMNUMH_FRM_MASK)
/* TOKEN Bit Fields */
#define USB_TOKEN_TOKENENDPT_MASK                0xFu
#define USB_TOKEN_TOKENENDPT_SHIFT               0
#define USB_TOKEN_TOKENENDPT_WIDTH               4
#define USB_TOKEN_TOKENENDPT(x)                  (((uint8_t)(((uint8_t)(x))<<USB_TOKEN_TOKENENDPT_SHIFT))&USB_TOKEN_TOKENENDPT_MASK)
#define USB_TOKEN_TOKENPID_MASK                  0xF0u
#define USB_TOKEN_TOKENPID_SHIFT                 4
#define USB_TOKEN_TOKENPID_WIDTH                 4
#define USB_TOKEN_TOKENPID(x)                    (((uint8_t)(((uint8_t)(x))<<USB_TOKEN_TOKENPID_SHIFT))&USB_TOKEN_TOKENPID_MASK)
/* SOFTHLD Bit Fields */
#define USB_SOFTHLD_CNT_MASK                     0xFFu
#define USB_SOFTHLD_CNT_SHIFT                    0
#define USB_SOFTHLD_CNT_WIDTH                    8
#define USB_SOFTHLD_CNT(x)                       (((uint8_t)(((uint8_t)(x))<<USB_SOFTHLD_CNT_SHIFT))&USB_SOFTHLD_CNT_MASK)
/* BDTPAGE2 Bit Fields */
#define USB_BDTPAGE2_BDTBA_MASK                  0xFFu
#define USB_BDTPAGE2_BDTBA_SHIFT                 0
#define USB_BDTPAGE2_BDTBA_WIDTH                 8
#define USB_BDTPAGE2_BDTBA(x)                    (((uint8_t)(((uint8_t)(x))<<USB_BDTPAGE2_BDTBA_SHIFT))&USB_BDTPAGE2_BDTBA_MASK)
/* BDTPAGE3 Bit Fields */
#define USB_BDTPAGE3_BDTBA_MASK                  0xFFu
#define USB_BDTPAGE3_BDTBA_SHIFT                 0
#define USB_BDTPAGE3_BDTBA_WIDTH                 8
#define USB_BDTPAGE3_BDTBA(x)                    (((uint8_t)(((uint8_t)(x))<<USB_BDTPAGE3_BDTBA_SHIFT))&USB_BDTPAGE3_BDTBA_MASK)
/* ENDPT Bit Fields */
#define USB_ENDPT_EPHSHK_MASK                    0x1u
#define USB_ENDPT_EPHSHK_SHIFT                   0
#define USB_ENDPT_EPHSHK_WIDTH                   1
#define USB_ENDPT_EPHSHK(x)                      (((uint8_t)(((uint8_t)(x))<<USB_ENDPT_EPHSHK_SHIFT))&USB_ENDPT_EPHSHK_MASK)
#define USB_ENDPT_EPSTALL_MASK                   0x2u
#define USB_ENDPT_EPSTALL_SHIFT                  1
#define USB_ENDPT_EPSTALL_WIDTH                  1
#define USB_ENDPT_EPSTALL(x)                     (((uint8_t)(((uint8_t)(x))<<USB_ENDPT_EPSTALL_SHIFT))&USB_ENDPT_EPSTALL_MASK)
#define USB_ENDPT_EPTXEN_MASK                    0x4u
#define USB_ENDPT_EPTXEN_SHIFT                   2
#define USB_ENDPT_EPTXEN_WIDTH                   1
#define USB_ENDPT_EPTXEN(x)                      (((uint8_t)(((uint8_t)(x))<<USB_ENDPT_EPTXEN_SHIFT))&USB_ENDPT_EPTXEN_MASK)
#define USB_ENDPT_EPRXEN_MASK                    0x8u
#define USB_ENDPT_EPRXEN_SHIFT                   3
#define USB_ENDPT_EPRXEN_WIDTH                   1
#define USB_ENDPT_EPRXEN(x)                      (((uint8_t)(((uint8_t)(x))<<USB_ENDPT_EPRXEN_SHIFT))&USB_ENDPT_EPRXEN_MASK)
#define USB_ENDPT_EPCTLDIS_MASK                  0x10u
#define USB_ENDPT_EPCTLDIS_SHIFT                 4
#define USB_ENDPT_EPCTLDIS_WIDTH                 1
#define USB_ENDPT_EPCTLDIS(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ENDPT_EPCTLDIS_SHIFT))&USB_ENDPT_EPCTLDIS_MASK)
#define USB_ENDPT_RETRYDIS_MASK                  0x40u
#define USB_ENDPT_RETRYDIS_SHIFT                 6
#define USB_ENDPT_RETRYDIS_WIDTH                 1
#define USB_ENDPT_RETRYDIS(x)                    (((uint8_t)(((uint8_t)(x))<<USB_ENDPT_RETRYDIS_SHIFT))&USB_ENDPT_RETRYDIS_MASK)
#define USB_ENDPT_HOSTWOHUB_MASK                 0x80u
#define USB_ENDPT_HOSTWOHUB_SHIFT                7
#define USB_ENDPT_HOSTWOHUB_WIDTH                1
#define USB_ENDPT_HOSTWOHUB(x)                   (((uint8_t)(((uint8_t)(x))<<USB_ENDPT_HOSTWOHUB_SHIFT))&USB_ENDPT_HOSTWOHUB_MASK)
/* USBCTRL Bit Fields */
#define USB_USBCTRL_UARTSEL_MASK                 0x10u
#define USB_USBCTRL_UARTSEL_SHIFT                4
#define USB_USBCTRL_UARTSEL_WIDTH                1
#define USB_USBCTRL_UARTSEL(x)                   (((uint8_t)(((uint8_t)(x))<<USB_USBCTRL_UARTSEL_SHIFT))&USB_USBCTRL_UARTSEL_MASK)
#define USB_USBCTRL_UARTCHLS_MASK                0x20u
#define USB_USBCTRL_UARTCHLS_SHIFT               5
#define USB_USBCTRL_UARTCHLS_WIDTH               1
#define USB_USBCTRL_UARTCHLS(x)                  (((uint8_t)(((uint8_t)(x))<<USB_USBCTRL_UARTCHLS_SHIFT))&USB_USBCTRL_UARTCHLS_MASK)
#define USB_USBCTRL_PDE_MASK                     0x40u
#define USB_USBCTRL_PDE_SHIFT                    6
#define USB_USBCTRL_PDE_WIDTH                    1
#define USB_USBCTRL_PDE(x)                       (((uint8_t)(((uint8_t)(x))<<USB_USBCTRL_PDE_SHIFT))&USB_USBCTRL_PDE_MASK)
#define USB_USBCTRL_SUSP_MASK                    0x80u
#define USB_USBCTRL_SUSP_SHIFT                   7
#define USB_USBCTRL_SUSP_WIDTH                   1
#define USB_USBCTRL_SUSP(x)                      (((uint8_t)(((uint8_t)(x))<<USB_USBCTRL_SUSP_SHIFT))&USB_USBCTRL_SUSP_MASK)
/* OBSERVE Bit Fields */
#define USB_OBSERVE_DMPD_MASK                    0x10u
#define USB_OBSERVE_DMPD_SHIFT                   4
#define USB_OBSERVE_DMPD_WIDTH                   1
#define USB_OBSERVE_DMPD(x)                      (((uint8_t)(((uint8_t)(x))<<USB_OBSERVE_DMPD_SHIFT))&USB_OBSERVE_DMPD_MASK)
#define USB_OBSERVE_DPPD_MASK                    0x40u
#define USB_OBSERVE_DPPD_SHIFT                   6
#define USB_OBSERVE_DPPD_WIDTH                   1
#define USB_OBSERVE_DPPD(x)                      (((uint8_t)(((uint8_t)(x))<<USB_OBSERVE_DPPD_SHIFT))&USB_OBSERVE_DPPD_MASK)
#define USB_OBSERVE_DPPU_MASK                    0x80u
#define USB_OBSERVE_DPPU_SHIFT                   7
#define USB_OBSERVE_DPPU_WIDTH                   1
#define USB_OBSERVE_DPPU(x)                      (((uint8_t)(((uint8_t)(x))<<USB_OBSERVE_DPPU_SHIFT))&USB_OBSERVE_DPPU_MASK)
/* CONTROL Bit Fields */
#define USB_CONTROL_DPPULLUPNONOTG_MASK          0x10u
#define USB_CONTROL_DPPULLUPNONOTG_SHIFT         4
#define USB_CONTROL_DPPULLUPNONOTG_WIDTH         1
#define USB_CONTROL_DPPULLUPNONOTG(x)            (((uint8_t)(((uint8_t)(x))<<USB_CONTROL_DPPULLUPNONOTG_SHIFT))&USB_CONTROL_DPPULLUPNONOTG_MASK)
/* USBTRC0 Bit Fields */
#define USB_USBTRC0_USB_RESUME_INT_MASK          0x1u
#define USB_USBTRC0_USB_RESUME_INT_SHIFT         0
#define USB_USBTRC0_USB_RESUME_INT_WIDTH         1
#define USB_USBTRC0_USB_RESUME_INT(x)            (((uint8_t)(((uint8_t)(x))<<USB_USBTRC0_USB_RESUME_INT_SHIFT))&USB_USBTRC0_USB_RESUME_INT_MASK)
#define USB_USBTRC0_SYNC_DET_MASK                0x2u
#define USB_USBTRC0_SYNC_DET_SHIFT               1
#define USB_USBTRC0_SYNC_DET_WIDTH               1
#define USB_USBTRC0_SYNC_DET(x)                  (((uint8_t)(((uint8_t)(x))<<USB_USBTRC0_SYNC_DET_SHIFT))&USB_USBTRC0_SYNC_DET_MASK)
#define USB_USBTRC0_USB_CLK_RECOVERY_INT_MASK    0x4u
#define USB_USBTRC0_USB_CLK_RECOVERY_INT_SHIFT   2
#define USB_USBTRC0_USB_CLK_RECOVERY_INT_WIDTH   1
#define USB_USBTRC0_USB_CLK_RECOVERY_INT(x)      (((uint8_t)(((uint8_t)(x))<<USB_USBTRC0_USB_CLK_RECOVERY_INT_SHIFT))&USB_USBTRC0_USB_CLK_RECOVERY_INT_MASK)
#define USB_USBTRC0_VREDG_DET_MASK               0x8u
#define USB_USBTRC0_VREDG_DET_SHIFT              3
#define USB_USBTRC0_VREDG_DET_WIDTH              1
#define USB_USBTRC0_VREDG_DET(x)                 (((uint8_t)(((uint8_t)(x))<<USB_USBTRC0_VREDG_DET_SHIFT))&USB_USBTRC0_VREDG_DET_MASK)
#define USB_USBTRC0_VFEDG_DET_MASK               0x10u
#define USB_USBTRC0_VFEDG_DET_SHIFT              4
#define USB_USBTRC0_VFEDG_DET_WIDTH              1
#define USB_USBTRC0_VFEDG_DET(x)                 (((uint8_t)(((uint8_t)(x))<<USB_USBTRC0_VFEDG_DET_SHIFT))&USB_USBTRC0_VFEDG_DET_MASK)
#define USB_USBTRC0_USBRESMEN_MASK               0x20u
#define USB_USBTRC0_USBRESMEN_SHIFT              5
#define USB_USBTRC0_USBRESMEN_WIDTH              1
#define USB_USBTRC0_USBRESMEN(x)                 (((uint8_t)(((uint8_t)(x))<<USB_USBTRC0_USBRESMEN_SHIFT))&USB_USBTRC0_USBRESMEN_MASK)
#define USB_USBTRC0_USBRESET_MASK                0x80u
#define USB_USBTRC0_USBRESET_SHIFT               7
#define USB_USBTRC0_USBRESET_WIDTH               1
#define USB_USBTRC0_USBRESET(x)                  (((uint8_t)(((uint8_t)(x))<<USB_USBTRC0_USBRESET_SHIFT))&USB_USBTRC0_USBRESET_MASK)
/* USBFRMADJUST Bit Fields */
#define USB_USBFRMADJUST_ADJ_MASK                0xFFu
#define USB_USBFRMADJUST_ADJ_SHIFT               0
#define USB_USBFRMADJUST_ADJ_WIDTH               8
#define USB_USBFRMADJUST_ADJ(x)                  (((uint8_t)(((uint8_t)(x))<<USB_USBFRMADJUST_ADJ_SHIFT))&USB_USBFRMADJUST_ADJ_MASK)
/* KEEP_ALIVE_CTRL Bit Fields */
#define USB_KEEP_ALIVE_CTRL_KEEP_ALIVE_EN_MASK   0x1u
#define USB_KEEP_ALIVE_CTRL_KEEP_ALIVE_EN_SHIFT  0
#define USB_KEEP_ALIVE_CTRL_KEEP_ALIVE_EN_WIDTH  1
#define USB_KEEP_ALIVE_CTRL_KEEP_ALIVE_EN(x)     (((uint8_t)(((uint8_t)(x))<<USB_KEEP_ALIVE_CTRL_KEEP_ALIVE_EN_SHIFT))&USB_KEEP_ALIVE_CTRL_KEEP_ALIVE_EN_MASK)
#define USB_KEEP_ALIVE_CTRL_OWN_OVERRD_EN_MASK   0x2u
#define USB_KEEP_ALIVE_CTRL_OWN_OVERRD_EN_SHIFT  1
#define USB_KEEP_ALIVE_CTRL_OWN_OVERRD_EN_WIDTH  1
#define USB_KEEP_ALIVE_CTRL_OWN_OVERRD_EN(x)     (((uint8_t)(((uint8_t)(x))<<USB_KEEP_ALIVE_CTRL_OWN_OVERRD_EN_SHIFT))&USB_KEEP_ALIVE_CTRL_OWN_OVERRD_EN_MASK)
#define USB_KEEP_ALIVE_CTRL_WAKE_REQ_EN_MASK     0x8u
#define USB_KEEP_ALIVE_CTRL_WAKE_REQ_EN_SHIFT    3
#define USB_KEEP_ALIVE_CTRL_WAKE_REQ_EN_WIDTH    1
#define USB_KEEP_ALIVE_CTRL_WAKE_REQ_EN(x)       (((uint8_t)(((uint8_t)(x))<<USB_KEEP_ALIVE_CTRL_WAKE_REQ_EN_SHIFT))&USB_KEEP_ALIVE_CTRL_WAKE_REQ_EN_MASK)
#define USB_KEEP_ALIVE_CTRL_WAKE_INT_EN_MASK     0x10u
#define USB_KEEP_ALIVE_CTRL_WAKE_INT_EN_SHIFT    4
#define USB_KEEP_ALIVE_CTRL_WAKE_INT_EN_WIDTH    1
#define USB_KEEP_ALIVE_CTRL_WAKE_INT_EN(x)       (((uint8_t)(((uint8_t)(x))<<USB_KEEP_ALIVE_CTRL_WAKE_INT_EN_SHIFT))&USB_KEEP_ALIVE_CTRL_WAKE_INT_EN_MASK)
#define USB_KEEP_ALIVE_CTRL_WAKE_INT_STS_MASK    0x80u
#define USB_KEEP_ALIVE_CTRL_WAKE_INT_STS_SHIFT   7
#define USB_KEEP_ALIVE_CTRL_WAKE_INT_STS_WIDTH   1
#define USB_KEEP_ALIVE_CTRL_WAKE_INT_STS(x)      (((uint8_t)(((uint8_t)(x))<<USB_KEEP_ALIVE_CTRL_WAKE_INT_STS_SHIFT))&USB_KEEP_ALIVE_CTRL_WAKE_INT_STS_MASK)
/* KEEP_ALIVE_WKCTRL Bit Fields */
#define USB_KEEP_ALIVE_WKCTRL_WAKE_ON_THIS_MASK  0xFu
#define USB_KEEP_ALIVE_WKCTRL_WAKE_ON_THIS_SHIFT 0
#define USB_KEEP_ALIVE_WKCTRL_WAKE_ON_THIS_WIDTH 4
#define USB_KEEP_ALIVE_WKCTRL_WAKE_ON_THIS(x)    (((uint8_t)(((uint8_t)(x))<<USB_KEEP_ALIVE_WKCTRL_WAKE_ON_THIS_SHIFT))&USB_KEEP_ALIVE_WKCTRL_WAKE_ON_THIS_MASK)
#define USB_KEEP_ALIVE_WKCTRL_WAKE_ENDPT_MASK    0xF0u
#define USB_KEEP_ALIVE_WKCTRL_WAKE_ENDPT_SHIFT   4
#define USB_KEEP_ALIVE_WKCTRL_WAKE_ENDPT_WIDTH   4
#define USB_KEEP_ALIVE_WKCTRL_WAKE_ENDPT(x)      (((uint8_t)(((uint8_t)(x))<<USB_KEEP_ALIVE_WKCTRL_WAKE_ENDPT_SHIFT))&USB_KEEP_ALIVE_WKCTRL_WAKE_ENDPT_MASK)
/* MISCCTRL Bit Fields */
#define USB_MISCCTRL_SOFDYNTHLD_MASK             0x1u
#define USB_MISCCTRL_SOFDYNTHLD_SHIFT            0
#define USB_MISCCTRL_SOFDYNTHLD_WIDTH            1
#define USB_MISCCTRL_SOFDYNTHLD(x)               (((uint8_t)(((uint8_t)(x))<<USB_MISCCTRL_SOFDYNTHLD_SHIFT))&USB_MISCCTRL_SOFDYNTHLD_MASK)
#define USB_MISCCTRL_SOFBUSSET_MASK              0x2u
#define USB_MISCCTRL_SOFBUSSET_SHIFT             1
#define USB_MISCCTRL_SOFBUSSET_WIDTH             1
#define USB_MISCCTRL_SOFBUSSET(x)                (((uint8_t)(((uint8_t)(x))<<USB_MISCCTRL_SOFBUSSET_SHIFT))&USB_MISCCTRL_SOFBUSSET_MASK)
#define USB_MISCCTRL_OWNERRISODIS_MASK           0x4u
#define USB_MISCCTRL_OWNERRISODIS_SHIFT          2
#define USB_MISCCTRL_OWNERRISODIS_WIDTH          1
#define USB_MISCCTRL_OWNERRISODIS(x)             (((uint8_t)(((uint8_t)(x))<<USB_MISCCTRL_OWNERRISODIS_SHIFT))&USB_MISCCTRL_OWNERRISODIS_MASK)
#define USB_MISCCTRL_VREDG_EN_MASK               0x8u
#define USB_MISCCTRL_VREDG_EN_SHIFT              3
#define USB_MISCCTRL_VREDG_EN_WIDTH              1
#define USB_MISCCTRL_VREDG_EN(x)                 (((uint8_t)(((uint8_t)(x))<<USB_MISCCTRL_VREDG_EN_SHIFT))&USB_MISCCTRL_VREDG_EN_MASK)
#define USB_MISCCTRL_VFEDG_EN_MASK               0x10u
#define USB_MISCCTRL_VFEDG_EN_SHIFT              4
#define USB_MISCCTRL_VFEDG_EN_WIDTH              1
#define USB_MISCCTRL_VFEDG_EN(x)                 (((uint8_t)(((uint8_t)(x))<<USB_MISCCTRL_VFEDG_EN_SHIFT))&USB_MISCCTRL_VFEDG_EN_MASK)
#define USB_MISCCTRL_STL_ADJ_EN_MASK             0x80u
#define USB_MISCCTRL_STL_ADJ_EN_SHIFT            7
#define USB_MISCCTRL_STL_ADJ_EN_WIDTH            1
#define USB_MISCCTRL_STL_ADJ_EN(x)               (((uint8_t)(((uint8_t)(x))<<USB_MISCCTRL_STL_ADJ_EN_SHIFT))&USB_MISCCTRL_STL_ADJ_EN_MASK)
/* STALL_IL_DIS Bit Fields */
#define USB_STALL_IL_DIS_STALL_I_DIS0_MASK       0x1u
#define USB_STALL_IL_DIS_STALL_I_DIS0_SHIFT      0
#define USB_STALL_IL_DIS_STALL_I_DIS0_WIDTH      1
#define USB_STALL_IL_DIS_STALL_I_DIS0(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_IL_DIS_STALL_I_DIS0_SHIFT))&USB_STALL_IL_DIS_STALL_I_DIS0_MASK)
#define USB_STALL_IL_DIS_STALL_I_DIS1_MASK       0x2u
#define USB_STALL_IL_DIS_STALL_I_DIS1_SHIFT      1
#define USB_STALL_IL_DIS_STALL_I_DIS1_WIDTH      1
#define USB_STALL_IL_DIS_STALL_I_DIS1(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_IL_DIS_STALL_I_DIS1_SHIFT))&USB_STALL_IL_DIS_STALL_I_DIS1_MASK)
#define USB_STALL_IL_DIS_STALL_I_DIS2_MASK       0x4u
#define USB_STALL_IL_DIS_STALL_I_DIS2_SHIFT      2
#define USB_STALL_IL_DIS_STALL_I_DIS2_WIDTH      1
#define USB_STALL_IL_DIS_STALL_I_DIS2(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_IL_DIS_STALL_I_DIS2_SHIFT))&USB_STALL_IL_DIS_STALL_I_DIS2_MASK)
#define USB_STALL_IL_DIS_STALL_I_DIS3_MASK       0x8u
#define USB_STALL_IL_DIS_STALL_I_DIS3_SHIFT      3
#define USB_STALL_IL_DIS_STALL_I_DIS3_WIDTH      1
#define USB_STALL_IL_DIS_STALL_I_DIS3(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_IL_DIS_STALL_I_DIS3_SHIFT))&USB_STALL_IL_DIS_STALL_I_DIS3_MASK)
#define USB_STALL_IL_DIS_STALL_I_DIS4_MASK       0x10u
#define USB_STALL_IL_DIS_STALL_I_DIS4_SHIFT      4
#define USB_STALL_IL_DIS_STALL_I_DIS4_WIDTH      1
#define USB_STALL_IL_DIS_STALL_I_DIS4(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_IL_DIS_STALL_I_DIS4_SHIFT))&USB_STALL_IL_DIS_STALL_I_DIS4_MASK)
#define USB_STALL_IL_DIS_STALL_I_DIS5_MASK       0x20u
#define USB_STALL_IL_DIS_STALL_I_DIS5_SHIFT      5
#define USB_STALL_IL_DIS_STALL_I_DIS5_WIDTH      1
#define USB_STALL_IL_DIS_STALL_I_DIS5(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_IL_DIS_STALL_I_DIS5_SHIFT))&USB_STALL_IL_DIS_STALL_I_DIS5_MASK)
#define USB_STALL_IL_DIS_STALL_I_DIS6_MASK       0x40u
#define USB_STALL_IL_DIS_STALL_I_DIS6_SHIFT      6
#define USB_STALL_IL_DIS_STALL_I_DIS6_WIDTH      1
#define USB_STALL_IL_DIS_STALL_I_DIS6(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_IL_DIS_STALL_I_DIS6_SHIFT))&USB_STALL_IL_DIS_STALL_I_DIS6_MASK)
#define USB_STALL_IL_DIS_STALL_I_DIS7_MASK       0x80u
#define USB_STALL_IL_DIS_STALL_I_DIS7_SHIFT      7
#define USB_STALL_IL_DIS_STALL_I_DIS7_WIDTH      1
#define USB_STALL_IL_DIS_STALL_I_DIS7(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_IL_DIS_STALL_I_DIS7_SHIFT))&USB_STALL_IL_DIS_STALL_I_DIS7_MASK)
/* STALL_IH_DIS Bit Fields */
#define USB_STALL_IH_DIS_STALL_I_DIS8_MASK       0x1u
#define USB_STALL_IH_DIS_STALL_I_DIS8_SHIFT      0
#define USB_STALL_IH_DIS_STALL_I_DIS8_WIDTH      1
#define USB_STALL_IH_DIS_STALL_I_DIS8(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_IH_DIS_STALL_I_DIS8_SHIFT))&USB_STALL_IH_DIS_STALL_I_DIS8_MASK)
#define USB_STALL_IH_DIS_STALL_I_DIS9_MASK       0x2u
#define USB_STALL_IH_DIS_STALL_I_DIS9_SHIFT      1
#define USB_STALL_IH_DIS_STALL_I_DIS9_WIDTH      1
#define USB_STALL_IH_DIS_STALL_I_DIS9(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_IH_DIS_STALL_I_DIS9_SHIFT))&USB_STALL_IH_DIS_STALL_I_DIS9_MASK)
#define USB_STALL_IH_DIS_STALL_I_DIS10_MASK      0x4u
#define USB_STALL_IH_DIS_STALL_I_DIS10_SHIFT     2
#define USB_STALL_IH_DIS_STALL_I_DIS10_WIDTH     1
#define USB_STALL_IH_DIS_STALL_I_DIS10(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_IH_DIS_STALL_I_DIS10_SHIFT))&USB_STALL_IH_DIS_STALL_I_DIS10_MASK)
#define USB_STALL_IH_DIS_STALL_I_DIS11_MASK      0x8u
#define USB_STALL_IH_DIS_STALL_I_DIS11_SHIFT     3
#define USB_STALL_IH_DIS_STALL_I_DIS11_WIDTH     1
#define USB_STALL_IH_DIS_STALL_I_DIS11(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_IH_DIS_STALL_I_DIS11_SHIFT))&USB_STALL_IH_DIS_STALL_I_DIS11_MASK)
#define USB_STALL_IH_DIS_STALL_I_DIS12_MASK      0x10u
#define USB_STALL_IH_DIS_STALL_I_DIS12_SHIFT     4
#define USB_STALL_IH_DIS_STALL_I_DIS12_WIDTH     1
#define USB_STALL_IH_DIS_STALL_I_DIS12(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_IH_DIS_STALL_I_DIS12_SHIFT))&USB_STALL_IH_DIS_STALL_I_DIS12_MASK)
#define USB_STALL_IH_DIS_STALL_I_DIS13_MASK      0x20u
#define USB_STALL_IH_DIS_STALL_I_DIS13_SHIFT     5
#define USB_STALL_IH_DIS_STALL_I_DIS13_WIDTH     1
#define USB_STALL_IH_DIS_STALL_I_DIS13(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_IH_DIS_STALL_I_DIS13_SHIFT))&USB_STALL_IH_DIS_STALL_I_DIS13_MASK)
#define USB_STALL_IH_DIS_STALL_I_DIS14_MASK      0x40u
#define USB_STALL_IH_DIS_STALL_I_DIS14_SHIFT     6
#define USB_STALL_IH_DIS_STALL_I_DIS14_WIDTH     1
#define USB_STALL_IH_DIS_STALL_I_DIS14(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_IH_DIS_STALL_I_DIS14_SHIFT))&USB_STALL_IH_DIS_STALL_I_DIS14_MASK)
#define USB_STALL_IH_DIS_STALL_I_DIS15_MASK      0x80u
#define USB_STALL_IH_DIS_STALL_I_DIS15_SHIFT     7
#define USB_STALL_IH_DIS_STALL_I_DIS15_WIDTH     1
#define USB_STALL_IH_DIS_STALL_I_DIS15(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_IH_DIS_STALL_I_DIS15_SHIFT))&USB_STALL_IH_DIS_STALL_I_DIS15_MASK)
/* STALL_OL_DIS Bit Fields */
#define USB_STALL_OL_DIS_STALL_O_DIS0_MASK       0x1u
#define USB_STALL_OL_DIS_STALL_O_DIS0_SHIFT      0
#define USB_STALL_OL_DIS_STALL_O_DIS0_WIDTH      1
#define USB_STALL_OL_DIS_STALL_O_DIS0(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_OL_DIS_STALL_O_DIS0_SHIFT))&USB_STALL_OL_DIS_STALL_O_DIS0_MASK)
#define USB_STALL_OL_DIS_STALL_O_DIS1_MASK       0x2u
#define USB_STALL_OL_DIS_STALL_O_DIS1_SHIFT      1
#define USB_STALL_OL_DIS_STALL_O_DIS1_WIDTH      1
#define USB_STALL_OL_DIS_STALL_O_DIS1(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_OL_DIS_STALL_O_DIS1_SHIFT))&USB_STALL_OL_DIS_STALL_O_DIS1_MASK)
#define USB_STALL_OL_DIS_STALL_O_DIS2_MASK       0x4u
#define USB_STALL_OL_DIS_STALL_O_DIS2_SHIFT      2
#define USB_STALL_OL_DIS_STALL_O_DIS2_WIDTH      1
#define USB_STALL_OL_DIS_STALL_O_DIS2(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_OL_DIS_STALL_O_DIS2_SHIFT))&USB_STALL_OL_DIS_STALL_O_DIS2_MASK)
#define USB_STALL_OL_DIS_STALL_O_DIS3_MASK       0x8u
#define USB_STALL_OL_DIS_STALL_O_DIS3_SHIFT      3
#define USB_STALL_OL_DIS_STALL_O_DIS3_WIDTH      1
#define USB_STALL_OL_DIS_STALL_O_DIS3(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_OL_DIS_STALL_O_DIS3_SHIFT))&USB_STALL_OL_DIS_STALL_O_DIS3_MASK)
#define USB_STALL_OL_DIS_STALL_O_DIS4_MASK       0x10u
#define USB_STALL_OL_DIS_STALL_O_DIS4_SHIFT      4
#define USB_STALL_OL_DIS_STALL_O_DIS4_WIDTH      1
#define USB_STALL_OL_DIS_STALL_O_DIS4(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_OL_DIS_STALL_O_DIS4_SHIFT))&USB_STALL_OL_DIS_STALL_O_DIS4_MASK)
#define USB_STALL_OL_DIS_STALL_O_DIS5_MASK       0x20u
#define USB_STALL_OL_DIS_STALL_O_DIS5_SHIFT      5
#define USB_STALL_OL_DIS_STALL_O_DIS5_WIDTH      1
#define USB_STALL_OL_DIS_STALL_O_DIS5(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_OL_DIS_STALL_O_DIS5_SHIFT))&USB_STALL_OL_DIS_STALL_O_DIS5_MASK)
#define USB_STALL_OL_DIS_STALL_O_DIS6_MASK       0x40u
#define USB_STALL_OL_DIS_STALL_O_DIS6_SHIFT      6
#define USB_STALL_OL_DIS_STALL_O_DIS6_WIDTH      1
#define USB_STALL_OL_DIS_STALL_O_DIS6(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_OL_DIS_STALL_O_DIS6_SHIFT))&USB_STALL_OL_DIS_STALL_O_DIS6_MASK)
#define USB_STALL_OL_DIS_STALL_O_DIS7_MASK       0x80u
#define USB_STALL_OL_DIS_STALL_O_DIS7_SHIFT      7
#define USB_STALL_OL_DIS_STALL_O_DIS7_WIDTH      1
#define USB_STALL_OL_DIS_STALL_O_DIS7(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_OL_DIS_STALL_O_DIS7_SHIFT))&USB_STALL_OL_DIS_STALL_O_DIS7_MASK)
/* STALL_OH_DIS Bit Fields */
#define USB_STALL_OH_DIS_STALL_O_DIS8_MASK       0x1u
#define USB_STALL_OH_DIS_STALL_O_DIS8_SHIFT      0
#define USB_STALL_OH_DIS_STALL_O_DIS8_WIDTH      1
#define USB_STALL_OH_DIS_STALL_O_DIS8(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_OH_DIS_STALL_O_DIS8_SHIFT))&USB_STALL_OH_DIS_STALL_O_DIS8_MASK)
#define USB_STALL_OH_DIS_STALL_O_DIS9_MASK       0x2u
#define USB_STALL_OH_DIS_STALL_O_DIS9_SHIFT      1
#define USB_STALL_OH_DIS_STALL_O_DIS9_WIDTH      1
#define USB_STALL_OH_DIS_STALL_O_DIS9(x)         (((uint8_t)(((uint8_t)(x))<<USB_STALL_OH_DIS_STALL_O_DIS9_SHIFT))&USB_STALL_OH_DIS_STALL_O_DIS9_MASK)
#define USB_STALL_OH_DIS_STALL_O_DIS10_MASK      0x4u
#define USB_STALL_OH_DIS_STALL_O_DIS10_SHIFT     2
#define USB_STALL_OH_DIS_STALL_O_DIS10_WIDTH     1
#define USB_STALL_OH_DIS_STALL_O_DIS10(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_OH_DIS_STALL_O_DIS10_SHIFT))&USB_STALL_OH_DIS_STALL_O_DIS10_MASK)
#define USB_STALL_OH_DIS_STALL_O_DIS11_MASK      0x8u
#define USB_STALL_OH_DIS_STALL_O_DIS11_SHIFT     3
#define USB_STALL_OH_DIS_STALL_O_DIS11_WIDTH     1
#define USB_STALL_OH_DIS_STALL_O_DIS11(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_OH_DIS_STALL_O_DIS11_SHIFT))&USB_STALL_OH_DIS_STALL_O_DIS11_MASK)
#define USB_STALL_OH_DIS_STALL_O_DIS12_MASK      0x10u
#define USB_STALL_OH_DIS_STALL_O_DIS12_SHIFT     4
#define USB_STALL_OH_DIS_STALL_O_DIS12_WIDTH     1
#define USB_STALL_OH_DIS_STALL_O_DIS12(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_OH_DIS_STALL_O_DIS12_SHIFT))&USB_STALL_OH_DIS_STALL_O_DIS12_MASK)
#define USB_STALL_OH_DIS_STALL_O_DIS13_MASK      0x20u
#define USB_STALL_OH_DIS_STALL_O_DIS13_SHIFT     5
#define USB_STALL_OH_DIS_STALL_O_DIS13_WIDTH     1
#define USB_STALL_OH_DIS_STALL_O_DIS13(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_OH_DIS_STALL_O_DIS13_SHIFT))&USB_STALL_OH_DIS_STALL_O_DIS13_MASK)
#define USB_STALL_OH_DIS_STALL_O_DIS14_MASK      0x40u
#define USB_STALL_OH_DIS_STALL_O_DIS14_SHIFT     6
#define USB_STALL_OH_DIS_STALL_O_DIS14_WIDTH     1
#define USB_STALL_OH_DIS_STALL_O_DIS14(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_OH_DIS_STALL_O_DIS14_SHIFT))&USB_STALL_OH_DIS_STALL_O_DIS14_MASK)
#define USB_STALL_OH_DIS_STALL_O_DIS15_MASK      0x80u
#define USB_STALL_OH_DIS_STALL_O_DIS15_SHIFT     7
#define USB_STALL_OH_DIS_STALL_O_DIS15_WIDTH     1
#define USB_STALL_OH_DIS_STALL_O_DIS15(x)        (((uint8_t)(((uint8_t)(x))<<USB_STALL_OH_DIS_STALL_O_DIS15_SHIFT))&USB_STALL_OH_DIS_STALL_O_DIS15_MASK)
/* CLK_RECOVER_CTRL Bit Fields */
#define USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN_MASK 0x20u
#define USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN_SHIFT 5
#define USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN_WIDTH 1
#define USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN(x) (((uint8_t)(((uint8_t)(x))<<USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN_SHIFT))&USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN_MASK)
#define USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN_MASK 0x40u
#define USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN_SHIFT 6
#define USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN_WIDTH 1
#define USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN(x) (((uint8_t)(((uint8_t)(x))<<USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN_SHIFT))&USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN_MASK)
#define USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN_MASK 0x80u
#define USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN_SHIFT 7
#define USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN_WIDTH 1
#define USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN(x) (((uint8_t)(((uint8_t)(x))<<USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN_SHIFT))&USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN_MASK)
/* CLK_RECOVER_IRC_EN Bit Fields */
#define USB_CLK_RECOVER_IRC_EN_REG_EN_MASK       0x1u
#define USB_CLK_RECOVER_IRC_EN_REG_EN_SHIFT      0
#define USB_CLK_RECOVER_IRC_EN_REG_EN_WIDTH      1
#define USB_CLK_RECOVER_IRC_EN_REG_EN(x)         (((uint8_t)(((uint8_t)(x))<<USB_CLK_RECOVER_IRC_EN_REG_EN_SHIFT))&USB_CLK_RECOVER_IRC_EN_REG_EN_MASK)
#define USB_CLK_RECOVER_IRC_E