/*
 * Copyright (c) 2009-2016 ARM Limited. All rights reserved.
 * 
 * SPDX-License-Identifier: Apache-2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @file     LPC8N04.h
 * @brief    CMSIS HeaderFile
 * @version  0.1
 * @date     05. December 2017
 * @note     Generated by SVDConv V3.3.12 on Tuesday, 05.12.2017 09:15:43
 *           from File 'LPC8N04.svd',
 *           last modified on Friday, 01.12.2017 08:08:44
 */
/*
 * modified by ARM 05.12.2017
 */



/** @addtogroup 
  * @{
  */


/** @addtogroup LPC8N04
  * @{
  */


#ifndef LPC8N04_H
#define LPC8N04_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M0+ Specific Interrupt Numbers  ======================================= */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ==========================================  LPC8N04 Specific Interrupt Numbers  =========================================== */
  PIO0_0_IRQn               =   0,              /*!< PIO0_0 Start Logic Interrupt */
  PIO0_1_IRQn               =   1,              /*!< PIO0_1 Start Logic Interrupt */
  PIO0_2_IRQn               =   2,              /*!< PIO0_2 Start Logic Interrupt */
  PIO0_3_IRQn               =   3,              /*!< PIO0_3 Start Logic Interrupt */
  PIO0_4_IRQn               =   4,              /*!< PIO0_4 Start Logic Interrupt */
  PIO0_5_IRQn               =   5,              /*!< PIO0_5 Start Logic Interrupt */
  PIO0_6_IRQn               =   6,              /*!< PIO0_6 Start Logic Interrupt */
  PIO0_7_IRQn               =   7,              /*!< PIO0_7 Start Logic Interrupt */
  PIO0_8_IRQn               =   8,              /*!< PIO0_8 Start Logic Interrupt */
  PIO0_9_IRQn               =   9,              /*!< PIO0_9 Start Logic Interrupt */
  PIO0_10_IRQn              =  10,              /*!< PIO0_10 Start Logic Interrupt */
  RFFIELD_IRQn              =  11,              /*!< NFC Access Start Logic Interrupt */
  RTCPWREQ_IRQn             =  12,              /*!< RTC Wakeup Request Start Logic Interrupt */
  NFC_IRQn                  =  13,              /*!< NFC Read/Write Interrupt */
  RTC_IRQn                  =  14,              /*!< RTC Wakeup Interrupt */
  I2C0_IRQn                 =  15,              /*!< I2C0 Interrupt */
  CT16B0_IRQn               =  16,              /*!< 16-bit Timer 0 Interrupt */
  PMUFLD_IRQn               =  17,              /*!< RF Power Detection Interrupt */
  CT32B0_IRQn               =  18,              /*!< 32-bit Timer 0 Interrupt */
  PMUBOD_IRQn               =  19,              /*!< Brown Out Detection Interrupt */
  SSP0_IRQn                 =  20,              /*!< SSP0 Interrupt */
  TSEN_IRQn                 =  21,              /*!< Temperature Sensor Interrupt */
  C2D_IRQn                  =  22,              /*!< Capacitance-to-Digital converter Interrupt */
  Reserved1_IRQn            =  23,              /*!< reserved */
  I2D_IRQn                  =  24,              /*!< Current-to-Digital converter Interrupt */
  ADCDAC_IRQn               =  25,              /*!< Analog-to-Digital/Digital-to-Analog converter Interrupt */
  WDT_IRQn                  =  26,              /*!< Watchdog Timer Interrupt */
  FLASH_IRQn                =  27,              /*!< FLASH memory Interrupt */
  EEPROM_IRQn               =  28,              /*!< EEPROM memory Interrupt */
  Reserved2_IRQn            =  29,              /*!< reserved */
  Reserved3_IRQn            =  30,              /*!< reserved */
  PIO0_IRQn                 =  31               /*!< GPIO Port 0 Interrupt */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ==========================  Configuration of the ARM Cortex-M0+ Processor and Core Peripherals  =========================== */
#define __CM0PLUS_REV                 0x0000U   /*!< CM0PLUS Core Revision                                                     */
#define __NVIC_PRIO_BITS               2        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __VTOR_PRESENT                 0        /*!< Set to 1 if CPU supports Vector Table Offset Register                     */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm0plus.h"                       /*!< ARM Cortex-M0+ processor and core peripherals                             */
#include "system_LPC8xx.h"                      /*!< LPC8N04 System                                                            */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                           I2C0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C Bus Controller 0 (I2C0)
  */

typedef struct {                                /*!< (@ 0x40000000) I2C0 Structure                                             */
  __IOM uint32_t  CONSET;                       /*!< (@ 0x00000000) I2C Control Set Register. When a one is written
                                                                    to a bit of this register, the corresponding
                                                                    bit in the I2C control register is set.
                                                                    Writing a zero has no effect on the corresponding
                                                                    bit in the I2C control register.                           */
  __IM  uint32_t  STAT;                         /*!< (@ 0x00000004) I2C Status Register. During I2C operation, this
                                                                    register provides detailed status codes
                                                                    that allow software to determine the next
                                                                    action needed.                                             */
  __IOM uint32_t  DAT;                          /*!< (@ 0x00000008) I2C Data Register. During master or slave transmit
                                                                    mode, data to be transmitted is written
                                                                    to this register. During master or slave
                                                                    receive mode, data that has been received
                                                                    may be read from this register.                            */
  __IOM uint32_t  ADR0;                         /*!< (@ 0x0000000C) I2C Slave Address Register 0. Contains the 7-bit
                                                                    slave address for operation of the I2C interface
                                                                    in slave mode, and is not used in master
                                                                    mode. The least significant bit determines
                                                                    whether a slave responds to the General
                                                                    Call address. This address is also used
                                                                    for device wakeup.                                         */
  __IOM uint32_t  SCLH;                         /*!< (@ 0x00000010) SCH Duty Cycle Register High Half Word. Determines
                                                                    the high time of the I2C clock.                            */
  __IOM uint32_t  SCLL;                         /*!< (@ 0x00000014) SCL Duty Cycle Register Low Half Word. Determines
                                                                    the low time of the I2C clock. I2nSCLL and
                                                                    I2nSCLH together determine the clock frequency
                                                                    generated by an I2C master and certain times
                                                                    used in slave mode.                                        */
  __OM  uint32_t  CONCLR;                       /*!< (@ 0x00000018) I2C Control Clear Register. When a one is written
                                                                    to a bit of this register, the corresponding
                                                                    bit in the I2C control register is cleared.
                                                                    Writing a zero has no effect on the corresponding
                                                                    bit in the I2C control register                            */
  __IOM uint32_t  MMCTRL;                       /*!< (@ 0x0000001C) Monitor mode control register                              */
  __IOM uint32_t  ADR1;                         /*!< (@ 0x00000020) I2C Slave Address Register 1. Contains the 7-bit
                                                                    slave address for operation of the I2C interface
                                                                    in slave mode, and is not used in master
                                                                    mode. The least significant bit determines
                                                                    whether a slave responds to the General
                                                                    Call address.                                              */
  __IOM uint32_t  ADR2;                         /*!< (@ 0x00000024) I2C Slave Address Register 2. Contains the 7-bit
                                                                    slave address for operation of the I2C interface
                                                                    in slave mode, and is not used in master
                                                                    mode. The least significant bit determines
                                                                    whether a slave responds to the General
                                                                    Call address                                               */
  __IOM uint32_t  ADR3;                         /*!< (@ 0x00000028) I2C Slave Address Register 3. Contains the 7-bit
                                                                    slave address for operation of the I2C interface
                                                                    in slave mode, and is not used in master
                                                                    mode. The least significant bit determines
                                                                    whether a slave responds to the General
                                                                    Call address                                               */
  __IM  uint32_t  DATA_BUFFER;                  /*!< (@ 0x0000002C) Data buffer register. The contents of the 8 MSBs
                                                                    of the DAT shift register will be transferred
                                                                    to the DATA_BUFFER automatically after every
                                                                    nine bits (8 bits of data plus ACK or NACK)
                                                                    has been received on the bus.                              */
  __IOM uint32_t  MASK0;                        /*!< (@ 0x00000030) I2C Slave address mask register 0. This mask
                                                                    register is associated with ADR0 to determine
                                                                    an address match. The mask register has
                                                                    no effect when comparing to the General
                                                                    Call address (0x0000000).                                  */
  __IOM uint32_t  MASK1;                        /*!< (@ 0x00000034) I2C Slave address mask register 1. This mask
                                                                    register is associated with ADR1 to determine
                                                                    an address match. The mask register has
                                                                    no effect when comparing to the General
                                                                    Call address (0x0000000).                                  */
  __IOM uint32_t  MASK2;                        /*!< (@ 0x00000038) I2C Slave address mask register 2. This mask
                                                                    register is associated with ADR2 to determine
                                                                    an address match. The mask register has
                                                                    no effect when comparing to the General
                                                                    Call address (0x0000000).                                  */
  __IOM uint32_t  MASK3;                        /*!< (@ 0x0000003C) I2C Slave address mask register 3. This mask
                                                                    register is associated with ADR3 to determine
                                                                    an address match. The mask register has
                                                                    no effect when comparing to the General
                                                                    Call address (0x0000000).                                  */
} I2C0_Type;                                    /*!< Size = 64 (0x40)                                                          */



/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Watchdog Timer (WDT)
  */

typedef struct {                                /*!< (@ 0x40004000) WDT Structure                                              */
  __IOM uint32_t  MOD;                          /*!< (@ 0x00000000) Watchdog mode register. This register contains
                                                                    the basic mode and status of the Watchdog
                                                                    Timer.                                                     */
  __IOM uint32_t  TC;                           /*!< (@ 0x00000004) Watchdog timer constant register. This register
                                                                    determines the time-out value.                             */
  __OM  uint32_t  FEED;                         /*!< (@ 0x00000008) Watchdog feed sequence register. Writing 0xAA
                                                                    followed by 0x55 to this register reloads
                                                                    the Watchdog timer with the value contained
                                                                    in WDTC.                                                   */
  __IM  uint32_t  TV;                           /*!< (@ 0x0000000C) Watchdog timer value register. This register
                                                                    reads out the current value of the Watchdog
                                                                    timer.                                                     */
} WDT_Type;                                     /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                         TIMER16_0                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 16-bit counter/timer 0 (TIMER16_0)
  */

typedef struct {                                /*!< (@ 0x4000C000) TIMER16_0 Structure                                        */
  __IOM uint32_t  IR;                           /*!< (@ 0x00000000) Interrupt register. The IR can be written to
                                                                    clear interrupts, and can be read to identify
                                                                    which of the five possible interrupt sources
                                                                    are pending.                                               */
  __IOM uint32_t  TCR;                          /*!< (@ 0x00000004) Timer control register. The TCR is used to control
                                                                    the timer counter functions. The TC can
                                                                    be disabled or reset through the TCR                       */
  __IOM uint32_t  TC;                           /*!< (@ 0x00000008) Timer Counter (TC). The 16-bit TC is incremented
                                                                    every PR+1 cycles of PCLK. The TC is controlled
                                                                    through the TCR.                                           */
  __IOM uint32_t  PR;                           /*!< (@ 0x0000000C) Prescale register. When the Prescale Counter
                                                                    (below) is equal to this value, the next
                                                                    clock increments the TC and clears the PC.                 */
  __IOM uint32_t  PC;                           /*!< (@ 0x00000010) Prescale Counter (PC). The 16-bit PC is a counter
                                                                    which is incremented to the value stored
                                                                    in PR. When the value in PR is reached,
                                                                    the TC is incremented and the PC is cleared.
                                                                    The PC is observable and controllable through
                                                                    the bus interface.                                         */
  __IOM uint32_t  MCR;                          /*!< (@ 0x00000014) Match Control Register (MCR). The MCR is used
                                                                    to control if an interrupt is generated
                                                                    and if the TC is reset when a Match occurs.                */
  __IOM uint32_t  MR0;                          /*!< (@ 0x00000018) Match Register 0 (MR0). MR0 can be enabled through
                                                                    the MCR to reset the TC, stop both the TC
                                                                    and PC, and/or generate an interrupt every
                                                                    time MR0 matches the TC.                                   */
  __IOM uint32_t  MR1;                          /*!< (@ 0x0000001C) Match Register 1 (MR1). See MR0 description.               */
  __IOM uint32_t  MR2;                          /*!< (@ 0x00000020) Match Register 2 (MR1). See MR0 description.               */
  __IOM uint32_t  MR3;                          /*!< (@ 0x00000024) Match Register 3 (MR1). See MR0 description.               */
  __IM  uint32_t  RESERVED[5];
  __IOM uint32_t  EMR;                          /*!< (@ 0x0000003C) External Match Register (EMR). The EMR controls
                                                                    the match function and the external match
                                                                    pins CT16B_MAT[1:0].                                       */
  __IM  uint32_t  RESERVED1[13];
  __IOM uint32_t  PWMC;                         /*!< (@ 0x00000074) PWM Control Register (PWMCON). The PWMCON enables
                                                                    PWM mode for the external match pins CT16B_MAT[1:0].       */
} TIMER16_0_Type;                               /*!< Size = 120 (0x78)                                                         */



/* =========================================================================================================================== */
/* ================                                         TIMER32_0                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief 32-bit counter/timer 0 (TIMER32_0)
  */

typedef struct {                                /*!< (@ 0x40014000) TIMER32_0 Structure                                        */
  __IOM uint32_t  IR;                           /*!< (@ 0x00000000) Interrupt register. The IR can be written to
                                                                    clear interrupts, and can be read to identify
                                                                    which of the five possible interrupt sources
                                                                    are pending.                                               */
  __IOM uint32_t  TCR;                          /*!< (@ 0x00000004) Timer control register. The TCR is used to control
                                                                    the timer counter functions. The TC can
                                                                    be disabled or reset through the TCR                       */
  __IOM uint32_t  TC;                           /*!< (@ 0x00000008) Timer Counter (TC). The 32-bit TC is incremented
                                                                    every PR+1 cycles of PCLK. The TC is controlled
                                                                    through the TCR.                                           */
  __IOM uint32_t  PR;                           /*!< (@ 0x0000000C) Prescale register. When the Prescale Counter
                                                                    (below) is equal to this value, the next
                                                                    clock increments the TC and clears the PC.                 */
  __IOM uint32_t  PC;                           /*!< (@ 0x00000010) Prescale Counter (PC). The 32-bit PC is a counter
                                                                    which is incremented to the value stored
                                                                    in PR. When the value in PR is reached,
                                                                    the TC is incremented and the PC is cleared.
                                                                    The PC is observable and controllable through
                                                                    the bus interface.                                         */
  __IOM uint32_t  MCR;                          /*!< (@ 0x00000014) Match Control Register (MCR). The MCR is used
                                                                    to control if an interrupt is generated
                                                                    and if the TC is reset when a Match occurs.                */
  __IOM uint32_t  MR0;                          /*!< (@ 0x00000018) Match Register 0 (MR0). MR0 can be enabled through
                                                                    the MCR to reset the TC, stop both the TC
                                                                    and PC, and/or generate an interrupt every
                                                                    time MR0 matches the TC.                                   */
  __IOM uint32_t  MR1;                          /*!< (@ 0x0000001C) Match Register 1 (MR1). See MR0 description.               */
  __IOM uint32_t  MR2;                          /*!< (@ 0x00000020) Match Register 2 (MR1). See MR0 description.               */
  __IOM uint32_t  MR3;                          /*!< (@ 0x00000024) Match Register 3 (MR1). See MR0 description.               */
  __IM  uint32_t  RESERVED[5];
  __IOM uint32_t  EMR;                          /*!< (@ 0x0000003C) External Match Register (EMR). The EMR controls
                                                                    the match function and the external match
                                                                    pins CT32B_MAT[1:0].                                       */
  __IM  uint32_t  RESERVED1[13];
  __IOM uint32_t  PWMC;                         /*!< (@ 0x00000074) PWM Control Register (PWMCON). The PWMCON enables
                                                                    PWM mode for the external match pins CT32B_MAT[1:0].       */
} TIMER32_0_Type;                               /*!< Size = 120 (0x78)                                                         */



/* =========================================================================================================================== */
/* ================                                          EEPROM                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief EEPROM controller (EEPROM)
  */

typedef struct {                                /*!< (@ 0x40034000) EEPROM Structure                                           */
  __IOM uint32_t  EECMD;                        /*!< (@ 0x00000000) EEPROM command register                                    */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  EERWSTATE;                    /*!< (@ 0x00000008) EEPROM read wait state register                            */
  __IOM uint32_t  EEPAUTOPROG;                  /*!< (@ 0x0000000C) EEPROM auto programming register                           */
  __IOM uint32_t  EEWSTATE;                     /*!< (@ 0x00000010) EEPROM wait state register                                 */
  __IOM uint32_t  EECLKDIV;                     /*!< (@ 0x00000014) EEPROM clock divider register                              */
  __IOM uint32_t  EEPWRDWN;                     /*!< (@ 0x00000018) EEPROM power-down register                                 */
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  EEMSSTART;                    /*!< (@ 0x00000020) EEPROM checksum start address register                     */
  __IOM uint32_t  EEMSSTOP;                     /*!< (@ 0x00000024) EEPROM checksum stop address register                      */
  __IM  uint32_t  EEMSDATASIG;                  /*!< (@ 0x00000028) EEPROM Data signature register                             */
  __IM  uint32_t  EEMSPARSIG;                   /*!< (@ 0x0000002C) EEPROM parity signature register                           */
  __IM  uint32_t  RESERVED2;
  __IM  uint32_t  EESTATUS;                     /*!< (@ 0x00000034) EEPROM device status register                              */
  __OM  uint32_t  ECCRSTERRCNT;                 /*!< (@ 0x00000038) Invalid flag and error corrected counter reset             */
  __IM  uint32_t  ECCERRCNT;                    /*!< (@ 0x0000003C) ECC status information                                     */
  __IM  uint32_t  RESERVED3[5];
  __IOM uint32_t  EECLKDIV1;                    /*!< (@ 0x00000054) EEPROM initial clock divider register                      */
  __IOM uint32_t  EECLKDIV2;                    /*!< (@ 0x00000058) EEPROM clock ramp duration register                        */
  __IM  uint32_t  RESERVED4[991];
  __OM  uint32_t  INT_CLR_ENABLE;               /*!< (@ 0x00000FD8) Clear interrupt enable bits                                */
  __OM  uint32_t  INT_SET_ENABLE;               /*!< (@ 0x00000FDC) Set interrupt enable bits                                  */
  __IM  uint32_t  INT_ENABLE;                   /*!< (@ 0x00000FE0) Interrupt enable bits                                      */
  __IM  uint32_t  INT_STATUS;                   /*!< (@ 0x00000FE4) Interrupt status bits                                      */
  __OM  uint32_t  INT_CLR_STATUS;               /*!< (@ 0x00000FE8) Clear interrupt status bits                                */
  __OM  uint32_t  INT_SET_STATUS;               /*!< (@ 0x00000FEC) Set interrupt status bits                                  */
  __IM  uint32_t  RESERVED5[3];
  __IM  uint32_t  MODULE_ID;                    /*!< (@ 0x00000FFC) Controller memory module identification                    */
} EEPROM_Type;                                  /*!< Size = 4096 (0x1000)                                                      */



/* =========================================================================================================================== */
/* ================                                            PMU                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Power Management Unit (PMU)
  */

typedef struct {                                /*!< (@ 0x40038000) PMU Structure                                              */
  __IOM uint32_t  PCON;                         /*!< (@ 0x00000000) Power control register                                     */
  __IOM uint32_t  GPREG0;                       /*!< (@ 0x00000004) General purpose register 0                                 */
  __IOM uint32_t  GPREG1;                       /*!< (@ 0x00000008) General purpose register 1                                 */
  __IOM uint32_t  GPREG2;                       /*!< (@ 0x0000000C) General purpose register 2                                 */
  __IOM uint32_t  GPREG3;                       /*!< (@ 0x00000010) General purpose register 3                                 */
  __IOM uint32_t  GPREG4;                       /*!< (@ 0x00000014) General purpose register 4                                 */
  __IM  uint32_t  PSTAT;                        /*!< (@ 0x00000018) Power management unit status register                      */
  __IM  uint32_t  RESERVED;
  __IM  uint32_t  ACCSTAT;                      /*!< (@ 0x00000020) Access status register                                     */
  __IOM uint32_t  LDO1V6;                       /*!< (@ 0x00000024) Analog 1.6 V LDO trimming                                  */
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  TMRCLKCTRL;                   /*!< (@ 0x0000002C) Timer clock control register                               */
} PMU_Type;                                     /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                           FLASH                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Flash controller (FLASH)
  */

typedef struct {                                /*!< (@ 0x4003C000) FLASH Structure                                            */
  __IOM uint32_t  FCTR;                         /*!< (@ 0x00000000) Flash Control register                                     */
  __IM  uint32_t  FSTAT;                        /*!< (@ 0x00000004) Flash status register                                      */
  __IOM uint32_t  FPTR;                         /*!< (@ 0x00000008) Flash program-time register                                */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  FBWST;                        /*!< (@ 0x00000010) Flash wait state register                                  */
  __IM  uint32_t  RESERVED1[2];
  __IOM uint32_t  FCRA;                         /*!< (@ 0x0000001C) Flash program clock divider                                */
  __IOM uint32_t  FMSSTART;                     /*!< (@ 0x00000020) Flash checksum start address register                      */
  __IOM uint32_t  FMSSTOP;                      /*!< (@ 0x00000024) Flash checksum stop address register                       */
  __IM  uint32_t  FMS16;                        /*!< (@ 0x00000028) Flash parity signature register                            */
  __IM  uint32_t  FMSW0;                        /*!< (@ 0x0000002C) Flash data signature register                              */
  __IM  uint32_t  RESERVED2[8];
  __IM  uint32_t  ECCERRCNT;                    /*!< (@ 0x00000050) ECC status information                                     */
  __IOM uint32_t  ECCRSTERRCNT;                 /*!< (@ 0x00000054) Invalid flag and error corrected counter reset             */
  __IM  uint32_t  RESERVED3[992];
  __OM  uint32_t  INT_CLR_ENABLE;               /*!< (@ 0x00000FD8) Clear interrupt enable bits                                */
  __OM  uint32_t  INT_SET_ENABLE;               /*!< (@ 0x00000FDC) Set interrupt enable bits                                  */
  __IM  uint32_t  INT_STATUS;                   /*!< (@ 0x00000FE0) Interrupt status bits                                      */
  __OM  uint32_t  INT_ENABLE;                   /*!< (@ 0x00000FE4) Interrupt enable bits                                      */
  __OM  uint32_t  INT_CLR_STATUS;               /*!< (@ 0x00000FE8) Clear interrupt status bits                                */
  __OM  uint32_t  INT_SET_STATUS;               /*!< (@ 0x00000FEC) Set interrupt status bits                                  */
  __IM  uint32_t  RESERVED4[3];
  __IM  uint32_t  MODULE_ID;                    /*!< (@ 0x00000FFC) Controller memory module identification                    */
} FLASH_Type;                                   /*!< Size = 4096 (0x1000)                                                      */



/* =========================================================================================================================== */
/* ================                                           SPI0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial Peripheral Interface (SPI) (SPI0)
  */

typedef struct {                                /*!< (@ 0x40040000) SPI0 Structure                                             */
  __IOM uint32_t  CR0;                          /*!< (@ 0x00000000) Control register 0. Selects the serial clock
                                                                    rate, bus type, and data size                              */
  __IOM uint32_t  CR1;                          /*!< (@ 0x00000004) Control register 1. Selects master/slave and
                                                                    other modes                                                */
  __IOM uint32_t  DR;                           /*!< (@ 0x00000008) Data register. Writes fill the transmit FIFO,
                                                                    and reads empty the receive FIFO                           */
  __IM  uint32_t  SR;                           /*!< (@ 0x0000000C) Status register                                            */
  __IOM uint32_t  CPSR;                         /*!< (@ 0x00000010) Clock Prescale register                                    */
  __IOM uint32_t  IMSC;                         /*!< (@ 0x00000014) Interrupt Mask Set and Clear Register                      */
  __IM  uint32_t  RIS;                          /*!< (@ 0x00000018) Raw Interrupt Status Register                              */
  __IM  uint32_t  MIS;                          /*!< (@ 0x0000001C) Masked Interrupt Status Register                           */
  __OM  uint32_t  ICR;                          /*!< (@ 0x00000020) Interrupt Clear Register                                   */
} SPI0_Type;                                    /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                           IOCON                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief IO configuration (IOCON)
  */

typedef struct {                                /*!< (@ 0x40044000) IOCON Structure                                            */
  __IOM uint32_t  PIO0_0;                       /*!< (@ 0x00000000) Pin PIO0_0 / WAKEUP (+ JTAG TCK)                           */
  __IOM uint32_t  PIO0_1;                       /*!< (@ 0x00000004) Pin PIO0_1 / CLKOUT (+ JTAG TMS)                           */
  __IOM uint32_t  PIO0_2;                       /*!< (@ 0x00000008) Pin PIO0_2 / SPI SSEL (+ JTAG TDI)                         */
  __IOM uint32_t  PIO0_3;                       /*!< (@ 0x0000000C) Pin PIO0_3 / CT16B_M0                                      */
  __IOM uint32_t  PIO0_4;                       /*!< (@ 0x00000010) Pin PIO0_4 / I2C SCL                                       */
  __IOM uint32_t  PIO0_5;                       /*!< (@ 0x00000014) Pin PIO0_5 / I2C SDA                                       */
  __IOM uint32_t  PIO0_6;                       /*!< (@ 0x00000018) Pin PIO0_6 / SPI SCLK (+ JTAG TDO)                         */
  __IOM uint32_t  PIO0_7;                       /*!< (@ 0x0000001C) Pin PIO0_7 / CT16B_M1                                      */
  __IOM uint32_t  PIO0_8;                       /*!< (@ 0x00000020) Pin PIO0_8 / SPI MISO (+ SCOUT1)                           */
  __IOM uint32_t  PIO0_9;                       /*!< (@ 0x00000024) Pin PIO0_9 / SPI MOSI (+ SCIN2)                            */
  __IOM uint32_t  PIO0_10;                      /*!< (@ 0x00000028) Pin PIO0_10 / CT32B_M0 / SWCLK (+ SCOUT2)                  */
  __IOM uint32_t  PIO0_11;                      /*!< (@ 0x0000002C) Pin PIO0_11 / CT32B_M1 / SWDIO (+ SCIN1)                   */
} IOCON_Type;                                   /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                          SYSCON                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief System Configuration (SYSCON)
  */

typedef struct {                                /*!< (@ 0x40048000) SYSCON Structure                                           */
  __IOM uint32_t  SYSMEMREMAP;                  /*!< (@ 0x00000000) System memory remap                                        */
  __IOM uint32_t  PRESETCTRL;                   /*!< (@ 0x00000004) Peripheral reset control                                   */
  __IM  uint32_t  RESERVED[6];
  __IOM uint32_t  SYSCLKCTRL;                   /*!< (@ 0x00000020) System clock control register                              */
  __IOM uint32_t  SYSCLKUEN;                    /*!< (@ 0x00000024) System clock update enable                                 */
  __IM  uint32_t  RESERVED1[2];
  __IOM uint32_t  SYSRSTSTAT;                   /*!< (@ 0x00000030) System reset status register                               */
  __IM  uint32_t  RESERVED2[19];
  __IOM uint32_t  SYSAHBCLKCTRL;                /*!< (@ 0x00000080) AHB clock control                                          */
  __IM  uint32_t  RESERVED3[4];
  __IOM uint32_t  SSPCLKDIV;                    /*!< (@ 0x00000094) SPI/SSP clock divider                                      */
  __IM  uint32_t  RESERVED4[14];
  __IOM uint32_t  WDTCLKSEL;                    /*!< (@ 0x000000D0) Watchdog timer clock selector                              */
  __IOM uint32_t  WDTCLKUEN;                    /*!< (@ 0x000000D4) Watchdog timer clock update enable                         */
  __IOM uint32_t  WDTCLKDIV;                    /*!< (@ 0x000000D8) Watchdog timer clock divider                               */
  __IM  uint32_t  RESERVED5[3];
  __IOM uint32_t  CLKOUTEN;                     /*!< (@ 0x000000E8) CLKOUT enable                                              */
  __IM  uint32_t  RESERVED6[26];
  __IOM uint32_t  SYSTCKCAL;                    /*!< (@ 0x00000154) System tick counter calibration                            */
  __IM  uint32_t  RESERVED7[42];
  __IOM uint32_t  STARTAPRP0;                   /*!< (@ 0x00000200) Start logic edge control register 0                        */
  __IOM uint32_t  STARTERP0;                    /*!< (@ 0x00000204) Start logic signal enable register 0                       */
  __OM  uint32_t  STARTRSRP0CLR;                /*!< (@ 0x00000208) Start logic reset register 0                               */
  __IM  uint32_t  STARTSRP0;                    /*!< (@ 0x0000020C) Start logic status register 0                              */
  __IM  uint32_t  RESERVED8[9];
  __IOM uint32_t  PDAWAKECFG;                   /*!< (@ 0x00000234) Power-down states after wake-up from deep-sleep
                                                                    mode                                                       */
  __IOM uint32_t  PDRUNCFG;                     /*!< (@ 0x00000238) power-down configuration register                          */
  __IM  uint32_t  RESERVED9[110];
  __IM  uint32_t  DEVICE_ID;                    /*!< (@ 0x000003F4) ...                                                        */
} SYSCON_Type;                                  /*!< Size = 1016 (0x3f8)                                                       */



/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Real time clock timer (RTC)
  */

typedef struct {                                /*!< (@ 0x40054000) RTC Structure                                              */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) RTC control register                                       */
  __IM  uint32_t  SR;                           /*!< (@ 0x00000004) RTC status register                                        */
  __IOM uint32_t  CAL;                          /*!< (@ 0x00000008) RTC calibration value                                      */
  __IOM uint32_t  SLEEPT;                       /*!< (@ 0x0000000C) RTC Sleep time                                             */
  __IM  uint32_t  VAL;                          /*!< (@ 0x00000010) Current RTC counter value                                  */
  __IOM uint32_t  IE;                           /*!< (@ 0x00000014) Interrupt mask register                                    */
  __IM  uint32_t  RIS;                          /*!< (@ 0x00000018) Raw Interrupt status register                              */
  __IM  uint32_t  MIS;                          /*!< (@ 0x0000001C) Masked interrupt status register                           */
  __OM  uint32_t  IC;                           /*!< (@ 0x00000020) Interrupt clear register                                   */
  __IM  uint32_t  STAT;                         /*!< (@ 0x00000024) Access status register                                     */
  __IM  uint32_t  RESERVED[2];
  __IOM uint32_t  TIME;                         /*!< (@ 0x00000030) RTC Time register                                          */
} RTC_Type;                                     /*!< Size = 52 (0x34)                                                          */



/* =========================================================================================================================== */
/* ================                                          RFIDNFC                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief RFID and NFC (RFIDNFC)
  */

typedef struct {                                /*!< (@ 0x40058000) RFIDNFC Structure                                          */
  __IOM uint32_t  CFG;                          /*!< (@ 0x00000000) RFID/NFC configuration register                            */
  __IM  uint32_t  SR;                           /*!< (@ 0x00000004) RFID/NFC status register                                   */
  __IM  uint32_t  RESERVED;
  __IM  uint32_t  CMDIN;                        /*!< (@ 0x0000000C) RFID/NFC incoming command                                  */
  __OM  uint32_t  CMDOUT;                       /*!< (@ 0x00000010) RFID/NFC outgoing command                                  */
  __IOM uint32_t  IE;                           /*!< (@ 0x00000014) Interrupt mask register                                    */
  __IM  uint32_t  RIS;                          /*!< (@ 0x00000018) Raw Interrupt status register                              */
  __IM  uint32_t  MIS;                          /*!< (@ 0x0000001C) Masked interrupt status register                           */
  __OM  uint32_t  IC;                           /*!< (@ 0x00000020) Interrupt clear register                                   */
} RFIDNFC_Type;                                 /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                           TSEN                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Temperature Sensor (TSEN)
  */

typedef struct {                                /*!< (@ 0x40060000) TSEN Structure                                             */
  __IOM uint32_t  CR;                           /*!< (@ 0x00000000) Control register                                           */
  __IM  uint32_t  DR;                           /*!< (@ 0x00000004) Data register. Contains result of conversion               */
  __IM  uint32_t  SR;                           /*!< (@ 0x00000008) Status register                                            */
  __IOM uint32_t  SP0;                          /*!< (@ 0x0000000C) Setup register 0: set ADC and operation modes              */
  __IOM uint32_t  SP1;                          /*!< (@ 0x00000010) Setup register 1: Calibration value ?A?                    */
  __IOM uint32_t  SP2;                          /*!< (@ 0x00000014) Setup register 2: Calibration value ?B?                    */
  __IOM uint32_t  SP3;                          /*!< (@ 0x00000018) Setup register 3: Calibration value ?alpha?                */
  __IOM uint32_t  TLO;                          /*!< (@ 0x0000001C) Low temperature threshold register                         */
  __IOM uint32_t  THI;                          /*!< (@ 0x00000020) High temperature threshold register                        */
  __IOM uint32_t  IMSC;                         /*!< (@ 0x00000024) Interrupt Mask Set and Clear Register                      */
  __IM  uint32_t  RIS;                          /*!< (@ 0x00000028) Raw Interrupt Status Register                              */
  __IM  uint32_t  MIS;                          /*!< (@ 0x0000002C) Masked Interrupt Status Register                           */
  __OM  uint32_t  ICR;                          /*!< (@ 0x00000030) Interrupt Clear Register                                   */
} TSEN_Type;                                    /*!< Size = 52 (0x34)                                                          */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose IO (GPIO)
  */

typedef struct {                                /*!< (@ 0x50008000) GPIO Structure                                             */
  __IOM uint32_t  DIR;                          /*!< (@ 0x00000000) Data direction register                                    */
  __IOM uint32_t  IS;                           /*!< (@ 0x00000004) Interrupt sense register                                   */
  __IOM uint32_t  IBE;                          /*!< (@ 0x00000008) Interrupt both edges register                              */
  __IOM uint32_t  IEV;                          /*!< (@ 0x0000000C) Interrupt event register                                   */
  __IOM uint32_t  IE;                           /*!< (@ 0x00000010) Interrupt mask register                                    */
  __IM  uint32_t  RIS;                          /*!< (@ 0x00000014) Raw Interrupt status register                              */
  __IM  uint32_t  MIS;                          /*!< (@ 0x00000018) Masked interrupt status register                           */
  __OM  uint32_t  IC;                           /*!< (@ 0x0000001C) Interrupt clear register                                   */
} GPIO_Type;                                    /*!< Size = 32 (0x20)                                                          */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define I2C0_BASE                   0x40000000UL
#define WDT_BASE                    0x40004000UL
#define TIMER16_0_BASE              0x4000C000UL
#define TIMER32_0_BASE              0x40014000UL
#define EEPROM_BASE                 0x40034000UL
#define PMU_BASE                    0x40038000UL
#define FLASH_BASE                  0x4003C000UL
#define SPI0_BASE                   0x40040000UL
#define IOCON_BASE                  0x40044000UL
#define SYSCON_BASE                 0x40048000UL
#define RTC_BASE                    0x40054000UL
#define RFIDNFC_BASE                0x40058000UL
#define TSEN_BASE                   0x40060000UL
#define GPIO_BASE                   0x50008000UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define I2C0                        ((I2C0_Type*)              I2C0_BASE)
#define WDT                         ((WDT_Type*)               WDT_BASE)
#define TIMER16_0                   ((TIMER16_0_Type*)         TIMER16_0_BASE)
#define TIMER32_0                   ((TIMER32_0_Type*)         TIMER32_0_BASE)
#define EEPROM                      ((EEPROM_Type*)            EEPROM_BASE)
#define PMU                         ((PMU_Type*)               PMU_BASE)
#define FLASH                       ((FLASH_Type*)             FLASH_BASE)
#define SPI0                        ((SPI0_Type*)              SPI0_BASE)
#define IOCON                       ((IOCON_Type*)             IOCON_BASE)
#define SYSCON                      ((SYSCON_Type*)            SYSCON_BASE)
#define RTC                         ((RTC_Type*)               RTC_BASE)
#define RFIDNFC                     ((RFIDNFC_Type*)           RFIDNFC_BASE)
#define TSEN                        ((TSEN_Type*)              TSEN_BASE)
#define GPIO                        ((GPIO_Type*)              GPIO_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


#ifdef __cplusplus
}
#endif

#endif /* LPC8N04_H */


/** @} */ /* End of group LPC8N04 */

/** @} */ /* End of group  */
