/*
 * Copyright (c) 2009-2016 ARM Limited. All rights reserved.
 * 
 * SPDX-License-Identifier: Apache-2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @file     LPC802.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     27. September 2017
 * @note     Generated by SVDConv V3.3.9 on Wednesday, 27.09.2017 09:31:02
 *           from File 'LPC802.svd',
 *           last modified on Wednesday, 27.09.2017 07:30:55
 */
/*
 * modified by ARM 27.09.2017
 */



/** @addtogroup NXP Semiconductors
  * @{
  */


/** @addtogroup LPC802
  * @{
  */


#ifndef LPC802_H
#define LPC802_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M0+ Specific Interrupt Numbers  ======================================= */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ===========================================  LPC802 Specific Interrupt Numbers  =========================================== */
  SPI0_IRQn                 =   0,              /*!< SPI0 interrupt */
  UART0_IRQn                =   3,              /*!< USART0 interrupt */
  UART1_IRQn                =   4,              /*!< USART1 interrupt */
  I2C0_IRQn                 =   8,              /*!< I2C0 interrupt */
  MRT_IRQn                  =  10,              /*!< Multi-rate timer interrupt */
  CMP_IRQn                  =  11,              /*!< Analog comparator interrupt */
  WDT_IRQn                  =  12,              /*!< Windowed watchdog timer interrupt */
  BOD_IRQn                  =  13,              /*!< BOD interrupts */
  FLASH_IRQn                =  14,              /*!< flash interrupt */
  WKT_IRQn                  =  15,              /*!< Self-wake-up timer interrupt */
  ADC_SEQA_IRQn             =  16,              /*!< ADC sequence A completion */
  ADC_SEQB_IRQn             =  17,              /*!< ADC sequence B completion */
  ADC_THCMP_IRQn            =  18,              /*!< ADC threshold compare */
  ADC_OVR_IRQn              =  19,              /*!< ADC overrun */
  CT32B0_IRQn               =  23,              /*!< Timer interrupt */
  PININT0_IRQn              =  24,              /*!< Pin interrupt 0 or pattern match engine slice 0 interrupt */
  PININT1_IRQn              =  25,              /*!< Pin interrupt 1 or pattern match engine slice 1 interrupt */
  PININT2_IRQn              =  26,              /*!< Pin interrupt 2 or pattern match engine slice 2 interrupt */
  PININT3_IRQn              =  27,              /*!< Pin interrupt 3 or pattern match engine slice 3 interrupt */
  PININT4_IRQn              =  28,              /*!< Pin interrupt 4 or pattern match engine slice 4 interrupt */
  PININT5_IRQn              =  29,              /*!< Pin interrupt 5 or pattern match engine slice 5 interrupt */
  PININT6_IRQn              =  30,              /*!< Pin interrupt 6 or pattern match engine slice 6 interrupt */
  PININT7_IRQn              =  31,              /*!< Pin interrupt 7 or pattern match engine slice 7 interrupt */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ==========================  Configuration of the ARM Cortex-M0+ Processor and Core Peripherals  =========================== */
#define __CM0PLUS_REV                 0x0000U   /*!< CM0PLUS Core Revision                                                     */
#define __NVIC_PRIO_BITS               2        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __VTOR_PRESENT                 0        /*!< Set to 1 if CPU supports Vector Table Offset Register                     */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm0plus.h"                       /*!< ARM Cortex-M0+ processor and core peripherals                             */
#include "system_LPC8xx.h"                      /*!< LPC802 System                                                             */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                              Device Specific Cluster Section                              ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_clusters
  * @{
  */


/**
  * @brief MRT0_CHANNEL [CHANNEL] (no description available)
  */
typedef struct {
  __IOM uint32_t  INTVAL;                       /*!< (@ 0x00000000) MRT Time interval value register. This value
                                                                    is loaded into the TIMER register.                         */
  __IM  uint32_t  TIMER;                        /*!< (@ 0x00000004) MRT Timer register. This register reads the value
                                                                    of the down-counter.                                       */
  __IOM uint32_t  CTRL;                         /*!< (@ 0x00000008) MRT Control register. This register controls
                                                                    the MRT modes.                                             */
  __IOM uint32_t  STAT;                         /*!< (@ 0x0000000C) MRT Status register.                                       */
} MRT0_CHANNEL_Type;                            /*!< Size = 16 (0x10)                                                          */


/** @} */ /* End of group Device_Peripheral_clusters */


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                        FLASH_CTRL                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm page flash controller (FLASH_CTRL)
  */

typedef struct {                                /*!< (@ 0x00040000) FLASH_CTRL Structure                                       */
  __IM  uint32_t  RESERVED[4];
  __IOM uint32_t  FLASHCFG;                     /*!< (@ 0x00000010) Flash configuration register                               */
} LPC_FLASH_CTRL_Type;                          /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                           WDT0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm Windowed Watchdog Timer (WWDT) (WDT0)
  */

typedef struct {                                /*!< (@ 0x40000000) WDT0 Structure                                             */
  __IOM uint32_t  MOD;                          /*!< (@ 0x00000000) Watchdog mode register. This register contains
                                                                    the basic mode and status of the Watchdog
                                                                    Timer.                                                     */
  __IOM uint32_t  TC;                           /*!< (@ 0x00000004) Watchdog timer constant register. This 24-bit
                                                                    register determines the time-out value.                    */
  __OM  uint32_t  FEED;                         /*!< (@ 0x00000008) Watchdog feed sequence register. Writing 0xAA
                                                                    followed by 0x55 to this register reloads
                                                                    the Watchdog timer with the value contained
                                                                    in TC.                                                     */
  __IM  uint32_t  TV;                           /*!< (@ 0x0000000C) Watchdog timer value register. This 24-bit register
                                                                    reads out the current value of the Watchdog
                                                                    timer.                                                     */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  WARNINT;                      /*!< (@ 0x00000014) Watchdog Warning Interrupt compare value.                  */
  __IOM uint32_t  WINDOW;                       /*!< (@ 0x00000018) Watchdog Window compare value.                             */
} LPC_WDT0_Type;                                /*!< Size = 28 (0x1c)                                                          */



/* =========================================================================================================================== */
/* ================                                           MRT0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm Multi-Rate Timer (MRT) (MRT0)
  */

typedef struct {                                /*!< (@ 0x40004000) MRT0 Structure                                             */
  __IOM MRT0_CHANNEL_Type CHANNEL[4];           /*!< (@ 0x00000000) no description available                                   */
  __IM  uint32_t  RESERVED[44];
  __IOM uint32_t  MODCFG;                       /*!< (@ 0x000000F0) Module Configuration register. This register
                                                                    provides information about this particular
                                                                    MRT instance.                                              */
  __IM  uint32_t  IDLE_CH;                      /*!< (@ 0x000000F4) Idle channel register. This register returns
                                                                    the number of the first idle channel.                      */
  __IOM uint32_t  IRQ_FLAG;                     /*!< (@ 0x000000F8) Global interrupt flag register                             */
} LPC_MRT0_Type;                                /*!< Size = 252 (0xfc)                                                         */



/* =========================================================================================================================== */
/* ================                                        WAKE_TIMER                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm Wake Up Timer(WKT) (WAKE_TIMER)
  */

typedef struct {                                /*!< (@ 0x40008000) WAKE_TIMER Structure                                       */
  __IOM uint32_t  CTRL;                         /*!< (@ 0x00000000) Self wake-up timer control register.                       */
  __IM  uint32_t  RESERVED[2];
  __IOM uint32_t  COUNT;                        /*!< (@ 0x0000000C) Counter register.                                          */
} LPC_WAKE_TIMER_Type;                          /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                           SWM0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm SWM (SWM0)
  */

typedef struct {                                /*!< (@ 0x4000C000) SWM0 Structure                                             */
  __IOM uint32_t  PINASSIGN0;                   /*!< (@ 0x00000000) Pin assign register 0. Assign movable functions
                                                                    U0_TXD, U0_RXD, U0_RTS, U0_CTS.                            */
  __IOM uint32_t  PINASSIGN1;                   /*!< (@ 0x00000004) Pin assign register 1. Assign movable functions
                                                                    U0_SCLK, U1_TXD, U1_RXD, U1_RTS.                           */
  __IOM uint32_t  PINASSIGN2;                   /*!< (@ 0x00000008) Pin assign register 2. Assign movable functions
                                                                    U1_CTS, U1_SCLK, U2_TXD, U2_RXD.                           */
  __IOM uint32_t  PINASSIGN3;                   /*!< (@ 0x0000000C) Pin assign register 3. Assign movable function
                                                                    U2_RTS, U2_CTS, U2_SCLK, SPI0_SCK.                         */
  __IOM uint32_t  PINASSIGN4;                   /*!< (@ 0x00000010) Pin assign register 4. Assign movable functions
                                                                    SPI0_MOSI, SPI0_MISO, SPI0_SSEL0, SPI0_SSEL1.              */
  __IOM uint32_t  PINASSIGN5;                   /*!< (@ 0x00000014) Pin assign register 5. Assign movable functions
                                                                    SPI0_SSEL2, SPI0_SSEL3, SPI1_SCK, SPI1_MOSI                */
  __IOM uint32_t  PINASSIGN6;                   /*!< (@ 0x00000018) Pin assign register 6. Assign movable functions
                                                                    SPI1_MISO, SPI1_SSEL0, SPI1_SSEL1, SCT0_IN0.               */
  __IOM uint32_t  PINASSIGN7;                   /*!< (@ 0x0000001C) Pin assign register 7. Assign movable functions
                                                                    SCT_IN1, SCT_IN2, SCT_IN3, SCT_OUT0.                       */
  __IOM uint32_t  PINASSIGN8;                   /*!< (@ 0x00000020) Pin assign register 8. Assign movable functions
                                                                    SCT_OUT1, SCT_OUT2, SCT_OUT3, SCT_OUT4.                    */
  __IOM uint32_t  PINASSIGN9;                   /*!< (@ 0x00000024) Pin assign register 9. Assign movable functions
                                                                    SCT_OUT5, SCT_OUT6, I2C1_SDA, I2C1_SCL.                    */
  __IOM uint32_t  PINASSIGN10;                  /*!< (@ 0x00000028) Pin assign register 10. Assign movable functions
                                                                    I2C2_SDA, I2C2_SCL, I2C3_SDA, I2C3_SCL,
                                                                    ADC_PINTRIG0.                                              */
  __IOM uint32_t  PINASSIGN11;                  /*!< (@ 0x0000002C) Pin assign register 11. Assign movable functions
                                                                    COMP0_OUT, CLKOUT, GPIOINT_BMATCH, UART3_TXD               */
  __IOM uint32_t  PINASSIGN12;                  /*!< (@ 0x00000030) Pin assign register 12. Assign movable functions
                                                                    UART3_RXD, UART3_SCLK, UART4_TXD, UART4_RXD.               */
  __IOM uint32_t  PINASSIGN13;                  /*!< (@ 0x00000034) Pin assign register 13. Assign movable functions
                                                                    UART4_SCLK, T0_MAT0, T0_MAT1, T0_MAT2.                     */
  __IOM uint32_t  PINASSIGN14;                  /*!< (@ 0x00000038) Pin assign register 14. Assign movable functions
                                                                    T0_MAT3, T0_CAP0, T0_CAP1, T0_CAP2.                        */
  __IM  uint32_t  RESERVED[97];
  __IOM uint32_t  PINENABLE0;                   /*!< (@ 0x000001C0) Pin enable register 0. Enables fixed-pin functions
                                                                    ACMP_I0, ACMP_I1, SWCLK, SWDIO, XTALIN,
                                                                    XTALOUT, RESET, CLKIN, VDDCMP and so on.                   */
  __IOM uint32_t  PINENABLE1;                   /*!< (@ 0x000001C4) Pin enable register 1. Enables fixed-pin functions
                                                                    CAPT_X4, CAPT_X5, CAPT_X6, CAPT_X7, CAPT_X8,
                                                                    CAPT_X4, CAPT_YL and CAPT_YH.                              */
} LPC_SWM0_Type;                                /*!< Size = 456 (0x1c8)                                                        */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm 12-bit ADC controller (ADC) (ADC)
  */

typedef struct {                                /*!< (@ 0x4001C000) ADC Structure                                              */
  __IOM uint32_t  CTRL;                         /*!< (@ 0x00000000) ADC Control register. Contains the clock divide
                                                                    value, resolution selection, sampling time
                                                                    selection, and mode controls.                              */
  __IOM uint32_t  INSEL;                        /*!< (@ 0x00000004) Input Select. Allows selection of the temperature
                                                                    sensor as an alternate input to ADC channel
                                                                    0.                                                         */
  __IOM uint32_t  SEQ_CTRLA;                    /*!< (@ 0x00000008) ADC Conversion Sequence-n control register: Controls
                                                                    triggering and channel selection for conversion
                                                                    sequence-n. Also specifies interrupt mode
                                                                    for sequence-n.                                            */
  __IOM uint32_t  SEQ_CTRLB;                    /*!< (@ 0x0000000C) ADC Conversion Sequence-n control register: Controls
                                                                    triggering and channel selection for conversion
                                                                    sequence-n. Also specifies interrupt mode
                                                                    for sequence-n.                                            */
  __IM  uint32_t  SEQ_GDATA;                    /*!< (@ 0x00000010) ADC Sequence-n Global Data register. This register
                                                                    contains the result of the most recent ADC
                                                                    conversion performed under sequence-n.                     */
  __IM  uint32_t  SEQ_GDATB;                    /*!< (@ 0x00000014) ADC Sequence-n Global Data register. This register
                                                                    contains the result of the most recent ADC
                                                                    conversion performed under sequence-n.                     */
  __IM  uint32_t  RESERVED[2];
  __IM  uint32_t  DAT[12];                      /*!< (@ 0x00000020) ADC Channel N Data register. This register contains
                                                                    the result of the most recent conversion
                                                                    completed on channel N.                                    */
  __IOM uint32_t  THR0_LOW;                     /*!< (@ 0x00000050) ADC Low Compare Threshold register 0: Contains
                                                                    the lower threshold level for automatic
                                                                    threshold comparison for any channels linked
                                                                    to threshold pair 0.                                       */
  __IOM uint32_t  THR1_LOW;                     /*!< (@ 0x00000054) ADC Low Compare Threshold register 1: Contains
                                                                    the lower threshold level for automatic
                                                                    threshold comparison for any channels linked
                                                                    to threshold pair 1.                                       */
  __IOM uint32_t  THR0_HIGH;                    /*!< (@ 0x00000058) ADC High Compare Threshold register 0: Contains
                                                                    the upper threshold level for automatic
                                                                    threshold comparison for any channels linked
                                                                    to threshold pair 0.                                       */
  __IOM uint32_t  THR1_HIGH;                    /*!< (@ 0x0000005C) ADC High Compare Threshold register 1: Contains
                                                                    the upper threshold level for automatic
                                                                    threshold comparison for any channels linked
                                                                    to threshold pair 1.                                       */
  __IOM uint32_t  CHAN_THRSEL;                  /*!< (@ 0x00000060) ADC Channel-Threshold Select register. Specifies
                                                                    which set of threshold compare registers
                                                                    are to be used for each channel                            */
  __IOM uint32_t  INTEN;                        /*!< (@ 0x00000064) ADC Interrupt Enable register. This register
                                                                    contains enable bits that enable the sequence-A,
                                                                    sequence-B, threshold compare and data overrun
                                                                    interrupts to be generated.                                */
  __IOM uint32_t  FLAGS;                        /*!< (@ 0x00000068) ADC Flags register. Contains the four interrupt/DMA
                                                                    trigger flags and the individual component
                                                                    overrun and threshold-compare flags. (The
                                                                    overrun bits replicate information stored
                                                                    in the result registers).                                  */
  __IOM uint32_t  ADTRIM;                       /*!< (@ 0x0000006C) ADC Startup register.                                      */
} LPC_ADC_Type;                                 /*!< Size = 112 (0x70)                                                         */



/* =========================================================================================================================== */
/* ================                                            PMU                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm PMU (PMU)
  */

typedef struct {                                /*!< (@ 0x40020000) PMU Structure                                              */
  __IOM uint32_t  PCON;                         /*!< (@ 0x00000000) Power control register                                     */
  __IOM uint32_t  GPREG[5];                     /*!< (@ 0x00000004) General purpose register N                                 */
  __IM  uint32_t  RESERVED[2];
  __IOM uint32_t  WUSRCREG;                     /*!< (@ 0x00000020) Pin wake-up source register                                */
  __IOM uint32_t  WUENAREG;                     /*!< (@ 0x00000024) Pin wake-up enable register                                */
} LPC_PMU_Type;                                 /*!< Size = 40 (0x28)                                                          */



/* =========================================================================================================================== */
/* ================                                           COMP                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm analog comparator (COMP)
  */

typedef struct {                                /*!< (@ 0x40024000) COMP Structure                                             */
  __IOM uint32_t  CTRL;                         /*!< (@ 0x00000000) Comparator control register                                */
  __IOM uint32_t  LAD;                          /*!< (@ 0x00000004) Voltage ladder register                                    */
} LPC_COMP_Type;                                /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                          CTIMER0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm Standard counter/timer (CTIMER0)
  */

typedef struct {                                /*!< (@ 0x40038000) CTIMER0 Structure                                          */
  __IOM uint32_t  IR;                           /*!< (@ 0x00000000) Interrupt Register. The IR can be written to
                                                                    clear interrupts. The IR can be read to
                                                                    identify which of eight possible interrupt
                                                                    sources are pending.                                       */
  __IOM uint32_t  TCR;                          /*!< (@ 0x00000004) Timer Control Register. The TCR is used to control
                                                                    the Timer Counter functions. The Timer Counter
                                                                    can be disabled or reset through the TCR.                  */
  __IOM uint32_t  TC;                           /*!< (@ 0x00000008) Timer Counter. The 32 bit TC is incremented every
                                                                    PR+1 cycles of the APB bus clock. The TC
                                                                    is controlled through the TCR.                             */
  __IOM uint32_t  PR;                           /*!< (@ 0x0000000C) Prescale Register. When the Prescale Counter
                                                                    (PC) is equal to this value, the next clock
                                                                    increments the TC and clears the PC.                       */
  __IOM uint32_t  PC;                           /*!< (@ 0x00000010) Prescale Counter. The 32 bit PC is a counter
                                                                    which is incremented to the value stored
                                                                    in PR. When the value in PR is reached,
                                                                    the TC is incremented and the PC is cleared.
                                                                    The PC is observable and controllable through
                                                                    the bus interface.                                         */
  __IOM uint32_t  MCR;                          /*!< (@ 0x00000014) Match Control Register. The MCR is used to control
                                                                    if an interrupt is generated and if the
                                                                    TC is reset when a Match occurs.                           */
  __IOM uint32_t  MR[4];                        /*!< (@ 0x00000018) Match Register . MR can be enabled through the
                                                                    MCR to reset the TC, stop both the TC and
                                                                    PC, and/or generate an interrupt every time
                                                                    MR matches the TC.                                         */
  __IOM uint32_t  CCR;                          /*!< (@ 0x00000028) Capture Control Register. The CCR controls which
                                                                    edges of the capture inputs are used to
                                                                    load the Capture Registers and whether or
                                                                    not an interrupt is generated when a capture
                                                                    takes place.                                               */
  __IM  uint32_t  CR[4];                        /*!< (@ 0x0000002C) Capture Register . CR is loaded with the value
                                                                    of TC when there is an event on the CAPn.
                                                                    input.                                                     */
  __IOM uint32_t  EMR;                          /*!< (@ 0x0000003C) External Match Register. The EMR controls the
                                                                    match function and the external match pins.                */
  __IM  uint32_t  RESERVED[12];
  __IOM uint32_t  CTCR;                         /*!< (@ 0x00000070) Count Control Register. The CTCR selects between
                                                                    Timer and Counter mode, and in Counter mode
                                                                    selects the signal and edge(s) for counting.               */
  __IOM uint32_t  PWMC;                         /*!< (@ 0x00000074) PWM Control Register. The PWMCON enables PWM
                                                                    mode for the external match pins.                          */
  __IOM uint32_t  MSR[4];                       /*!< (@ 0x00000078) Match Shadow Register . If enabled, the Match
                                                                    Register will be automatically reloaded
                                                                    with the contents of this register whenever
                                                                    the TC is reset to zero.                                   */
} LPC_CTIMER0_Type;                             /*!< Size = 136 (0x88)                                                         */



/* =========================================================================================================================== */
/* ================                                           IOCON                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm I/O pin configuration (IOCON) (IOCON)
  */

typedef struct {                                /*!< (@ 0x40044000) IOCON Structure                                            */
  __IOM uint32_t  PIO0_17;                      /*!< (@ 0x00000000) I/O configuration for pin PIO0_17/ADC_9/WAKEUP3            */
  __IOM uint32_t  PIO0_13;                      /*!< (@ 0x00000004) I/O configuration for pin PIO0_13/ADC_10/WAKEUP4           */
  __IOM uint32_t  PIO0_12;                      /*!< (@ 0x00000008) I/O configuration for pin PIO0_12                          */
  __IOM uint32_t  PIO0_5;                       /*!< (@ 0x0000000C) I/O configuration for pin PIO0_5/nRESET/WAKEUP5            */
  __IOM uint32_t  PIO0_4;                       /*!< (@ 0x00000010) I/O configuration for pin PIO0_4/ADC_11                    */
  __IOM uint32_t  PIO0_3;                       /*!< (@ 0x00000014) I/O configuration for pin PIO0_3/SWCLK                     */
  __IOM uint32_t  PIO0_2;                       /*!< (@ 0x00000018) I/O configuration for pin PIO0_2/SWDIO                     */
  __IOM uint32_t  PIO0_11;                      /*!< (@ 0x0000001C) I/O configuration for pin PIO0_11/ADC6/WKTCLKIN/WAKEUP6    */
  __IOM uint32_t  PIO0_10;                      /*!< (@ 0x00000020) I/O configuration for pin PIO0_10/ADC7/WAKEUP7             */
  __IOM uint32_t  PIO0_16;                      /*!< (@ 0x00000024) I/O configuration for pin PIO0_16/ACMP_I3/ADC3             */
  __IOM uint32_t  PIO0_15;                      /*!< (@ 0x00000028) I/O configuration for pin PIO0_15/ADC8/WAKEUP0             */
  __IOM uint32_t  PIO0_1;                       /*!< (@ 0x0000002C) I/O configuration for pin PIO0_1/ACMP_I1/CLKIN             */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  PIO0_9;                       /*!< (@ 0x00000034) I/O configuration for pin PIO0_9/ADC4/WAKEUP1              */
  __IOM uint32_t  PIO0_8;                       /*!< (@ 0x00000038) I/O configuration for pin PIO0_8/ADC5/WAKEUP2              */
  __IOM uint32_t  PIO0_7;                       /*!< (@ 0x0000003C) I/O configuration for pin PIO0_7/ADC_1/VDDCMP              */
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  PIO0_0;                       /*!< (@ 0x00000044) I/O configuration for pin PIO0_0/ACMP_I0                   */
  __IOM uint32_t  PIO0_14;                      /*!< (@ 0x00000048) I/O configuration for pin PIO0_14/ACMP_I2/ADC2             */
} LPC_IOCON_Type;                               /*!< Size = 76 (0x4c)                                                          */



/* =========================================================================================================================== */
/* ================                                          SYSCON                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm System configuration (SYSCON) (SYSCON)
  */

typedef struct {                                /*!< (@ 0x40048000) SYSCON Structure                                           */
  __IOM uint32_t  SYSMEMREMAP;                  /*!< (@ 0x00000000) System Remap register                                      */
  __IM  uint32_t  RESERVED[8];
  __IOM uint32_t  LPOSCCTRL;                    /*!< (@ 0x00000024) Watchdog oscillator control                                */
  __IM  uint32_t  RESERVED1[4];
  __IOM uint32_t  SYSRSTSTAT;                   /*!< (@ 0x00000038) System reset status register                               */
  __IM  uint32_t  RESERVED2[5];
  __IOM uint32_t  MAINCLKSEL;                   /*!< (@ 0x00000050) Main clock source select register                          */
  __IOM uint32_t  MAINCLKUEN;                   /*!< (@ 0x00000054) Main clock source update enable register                   */
  __IOM uint32_t  SYSAHBCLKDIV;                 /*!< (@ 0x00000058) System clock divider register                              */
  __IM  uint32_t  RESERVED3[2];
  __IOM uint32_t  ADCCLKSEL;                    /*!< (@ 0x00000064) ADC clock source select register                           */
  __IOM uint32_t  ADCCLKDIV;                    /*!< (@ 0x00000068) ADC clock divider register                                 */
  __IM  uint32_t  RESERVED4[4];
  __IOM uint32_t  LPOSCCLKEN;                   /*!< (@ 0x0000007C) External clock source select register                      */
  __IOM uint32_t  SYSAHBCLK0CTRL;               /*!< (@ 0x00000080) System clock group 0 control register                      */
  __IM  uint32_t  RESERVED5;
  __IOM uint32_t  PRESET0CTRL;                  /*!< (@ 0x00000088) Peripheral reset group 0 control register                  */
  __IOM uint32_t  PRESET1CTRL;                  /*!< (@ 0x0000008C) Peripheral reset group 1 control register                  */
  __IOM uint32_t  UART0CLKSEL;                  /*!< (@ 0x00000090) UART0 clock source                                         */
  __IOM uint32_t  UART1CLKSEL;                  /*!< (@ 0x00000094) UART1 clock source                                         */
  __IM  uint32_t  RESERVED6[3];
  __IOM uint32_t  I2C0CLKSEL;                   /*!< (@ 0x000000A4) I2C0 clock source                                          */
  __IM  uint32_t  RESERVED7[3];
  __IOM uint32_t  SPI0CLKSEL;                   /*!< (@ 0x000000B4) SPI0 clock source                                          */
  __IM  uint32_t  RESERVED8[14];
  __IOM uint32_t  CLKOUTSEL;                    /*!< (@ 0x000000F0) CLKOUT clock source select register                        */
  __IOM uint32_t  CLKOUTDIV;                    /*!< (@ 0x000000F4) CLKOUT clock divider registers                             */
  __IM  uint32_t  RESERVED9[2];
  __IOM uint32_t  PIOPORACP;                    /*!< (@ 0x00000100) POR captured PIO0 status 0                                 */
  __IM  uint32_t  RESERVED10[19];
  __IOM uint32_t  BODCTRL;                      /*!< (@ 0x00000150) BOD control register                                       */
  __IOM uint32_t  SYSTCKCAL;                    /*!< (@ 0x00000154) System tick timer calibration register                     */
  __IM  uint32_t  RESERVED11[6];
  __IOM uint32_t  IRQLATENCY;                   /*!< (@ 0x00000170) IRQ latency register                                       */
  __IOM uint32_t  NMISRC;                       /*!< (@ 0x00000174) NMI source selection register                              */
  __IOM uint32_t  PINTSEL[8];                   /*!< (@ 0x00000178) Pin interrupt select registers N                           */
  __IM  uint32_t  RESERVED12[27];
  __IOM uint32_t  STARTERP0;                    /*!< (@ 0x00000204) Start logic 0 pin wake-up enable register 0                */
  __IM  uint32_t  RESERVED13[3];
  __IOM uint32_t  STARTERP1;                    /*!< (@ 0x00000214) Start logic 0 pin wake-up enable register 1                */
  __IM  uint32_t  RESERVED14[6];
  __IOM uint32_t  PDSLEEPCFG;                   /*!< (@ 0x00000230) Deep-sleep configuration register                          */
  __IOM uint32_t  PDAWAKECFG;                   /*!< (@ 0x00000234) Wake-up configuration register                             */
  __IOM uint32_t  PDRUNCFG;                     /*!< (@ 0x00000238) Power configuration register                               */
} LPC_SYSCON_Type;                              /*!< Size = 572 (0x23c)                                                        */



/* =========================================================================================================================== */
/* ================                                           I2C0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm I2C-bus interfaces (I2C0)
  */

typedef struct {                                /*!< (@ 0x40050000) I2C0 Structure                                             */
  __IOM uint32_t  CFG;                          /*!< (@ 0x00000000) Configuration for shared functions.                        */
  __IOM uint32_t  STAT;                         /*!< (@ 0x00000004) Status register for Master, Slave, and Monitor
                                                                    functions.                                                 */
  __IOM uint32_t  INTENSET;                     /*!< (@ 0x00000008) Interrupt Enable Set and read register.                    */
  __OM  uint32_t  INTENCLR;                     /*!< (@ 0x0000000C) Interrupt Enable Clear register.                           */
  __IOM uint32_t  TIMEOUT;                      /*!< (@ 0x00000010) Time-out value register.                                   */
  __IOM uint32_t  CLKDIV;                       /*!< (@ 0x00000014) Clock pre-divider for the entire I2C interface.
                                                                    This determines what time increments are
                                                                    used for the MSTTIME register, and controls
                                                                    some timing of the Slave function.                         */
  __IM  uint32_t  INTSTAT;                      /*!< (@ 0x00000018) Interrupt Status register for Master, Slave,
                                                                    and Monitor functions.                                     */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  MSTCTL;                       /*!< (@ 0x00000020) Master control register.                                   */
  __IOM uint32_t  MSTTIME;                      /*!< (@ 0x00000024) Master timing configuration.                               */
  __IOM uint32_t  MSTDAT;                       /*!< (@ 0x00000028) Combined Master receiver and transmitter data
                                                                    register.                                                  */
  __IM  uint32_t  RESERVED1[5];
  __IOM uint32_t  SLVCTL;                       /*!< (@ 0x00000040) Slave control register.                                    */
  __IOM uint32_t  SLVDAT;                       /*!< (@ 0x00000044) Combined Slave receiver and transmitter data
                                                                    register.                                                  */
  __IOM uint32_t  SLVADR[4];                    /*!< (@ 0x00000048) Slave address register.                                    */
  __IOM uint32_t  SLVQUAL0;                     /*!< (@ 0x00000058) Slave Qualification for address 0.                         */
  __IM  uint32_t  RESERVED2[9];
  __IM  uint32_t  MONRXDAT;                     /*!< (@ 0x00000080) Monitor receiver data register.                            */
} LPC_I2C0_Type;                                /*!< Size = 132 (0x84)                                                         */



/* =========================================================================================================================== */
/* ================                                           SSP0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm Serial Peripheral Interfaces (SPI) (SSP0)
  */

typedef struct {                                /*!< (@ 0x40058000) SSP0 Structure                                             */
  __IOM uint32_t  CFG;                          /*!< (@ 0x00000000) SPI Configuration register                                 */
  __IOM uint32_t  DLY;                          /*!< (@ 0x00000004) SPI Delay register                                         */
  __IOM uint32_t  STAT;                         /*!< (@ 0x00000008) SPI Status. Some status flags can be cleared
                                                                    by writing a 1 to that bit position                        */
  __IOM uint32_t  INTENSET;                     /*!< (@ 0x0000000C) SPI Interrupt Enable read and Set. A complete
                                                                    value may be read from this register. Writing
                                                                    a 1 to any implemented bit position causes
                                                                    that bit to be set.                                        */
  __OM  uint32_t  INTENCLR;                     /*!< (@ 0x00000010) SPI Interrupt Enable Clear. Writing a 1 to any
                                                                    implemented bit position causes the corresponding
                                                                    bit in INTENSET to be cleared.                             */
  __IM  uint32_t  RXDAT;                        /*!< (@ 0x00000014) SPI Receive Data                                           */
  __IOM uint32_t  TXDATCTL;                     /*!< (@ 0x00000018) SPI Transmit Data with Control                             */
  __IOM uint32_t  TXDAT;                        /*!< (@ 0x0000001C) SPI Transmit Data.                                         */
  __IOM uint32_t  TXCTL;                        /*!< (@ 0x00000020) SPI Transmit Control                                       */
  __IOM uint32_t  DIV;                          /*!< (@ 0x00000024) SPI clock Divider                                          */
  __IOM uint32_t  INTSTAT;                      /*!< (@ 0x00000028) SPI Interrupt Status                                       */
} LPC_SSP0_Type;                                /*!< Size = 44 (0x2c)                                                          */



/* =========================================================================================================================== */
/* ================                                           UART0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm USARTs (UART0)
  */

typedef struct {                                /*!< (@ 0x40064000) UART0 Structure                                            */
  __IOM uint32_t  CFG;                          /*!< (@ 0x00000000) USART Configuration register. Basic USART configuration
                                                                    settings that typically are not changed
                                                                    during operation.                                          */
  __IOM uint32_t  CTL;                          /*!< (@ 0x00000004) USART Control register. USART control settings
                                                                    that are more likely to change during operation.           */
  __IOM uint32_t  STAT;                         /*!< (@ 0x00000008) USART Status register. The complete status value
                                                                    can be read here. Writing ones clears some
                                                                    bits in the register. Some bits can be cleared
                                                                    by writing a 1 to them.                                    */
  __IOM uint32_t  INTENSET;                     /*!< (@ 0x0000000C) Interrupt Enable read and Set register. Contains
                                                                    an individual interrupt enable bit for each
                                                                    potential USART interrupt. A complete value
                                                                    may be read from this register. Writing
                                                                    a 1 to any implemented bit position causes
                                                                    that bit to be set.                                        */
  __OM  uint32_t  INTENCLR;                     /*!< (@ 0x00000010) Interrupt Enable Clear register. Allows clearing
                                                                    any combination of bits in the INTENSET
                                                                    register. Writing a 1 to any implemented
                                                                    bit position causes the corresponding bit
                                                                    to be cleared.                                             */
  __IM  uint32_t  RXDAT;                        /*!< (@ 0x00000014) Receiver Data register. Contains the last character
                                                                    received.                                                  */
  __IM  uint32_t  RXDATSTAT;                    /*!< (@ 0x00000018) Receiver Data with Status register. Combines
                                                                    the last character received with the current
                                                                    USART receive status. Allows DMA or software
                                                                    to recover incoming data and status together.              */
  __IOM uint32_t  TXDAT;                        /*!< (@ 0x0000001C) Transmit Data register. Data to be transmitted
                                                                    is written here.                                           */
  __IOM uint32_t  BRG;                          /*!< (@ 0x00000020) Baud Rate Generator register. 16-bit integer
                                                                    baud rate divisor value.                                   */
  __IOM uint32_t  INTSTAT;                      /*!< (@ 0x00000024) Interrupt status register. Reflects interrupts
                                                                    that are currently enabled.                                */
  __IOM uint32_t  OSR;                          /*!< (@ 0x00000028) Oversample selection register for asynchronous
                                                                    communication.                                             */
  __IOM uint32_t  ADDR;                         /*!< (@ 0x0000002C) Address register for automatic address matching.           */
} LPC_USART_Type;                               /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                           UART1                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm USARTs (UART1)
  */

typedef struct {                                /*!< (@ 0x40068000) UART1 Structure                                            */
  __IOM uint32_t  CFG;                          /*!< (@ 0x00000000) USART Configuration register. Basic USART configuration
                                                                    settings that typically are not changed
                                                                    during operation.                                          */
  __IOM uint32_t  CTL;                          /*!< (@ 0x00000004) USART Control register. USART control settings
                                                                    that are more likely to change during operation.           */
  __IOM uint32_t  STAT;                         /*!< (@ 0x00000008) USART Status register. The complete status value
                                                                    can be read here. Writing ones clears some
                                                                    bits in the register. Some bits can be cleared
                                                                    by writing a 1 to them.                                    */
  __IOM uint32_t  INTENSET;                     /*!< (@ 0x0000000C) Interrupt Enable read and Set register. Contains
                                                                    an individual interrupt enable bit for each
                                                                    potential USART interrupt. A complete value
                                                                    may be read from this register. Writing
                                                                    a 1 to any implemented bit position causes
                                                                    that bit to be set.                                        */
  __OM  uint32_t  INTENCLR;                     /*!< (@ 0x00000010) Interrupt Enable Clear register. Allows clearing
                                                                    any combination of bits in the INTENSET
                                                                    register. Writing a 1 to any implemented
                                                                    bit position causes the corresponding bit
                                                                    to be cleared.                                             */
  __IM  uint32_t  RXDAT;                        /*!< (@ 0x00000014) Receiver Data register. Contains the last character
                                                                    received.                                                  */
  __IM  uint32_t  RXDATSTAT;                    /*!< (@ 0x00000018) Receiver Data with Status register. Combines
                                                                    the last character received with the current
                                                                    USART receive status. Allows DMA or software
                                                                    to recover incoming data and status together.              */
  __IOM uint32_t  TXDAT;                        /*!< (@ 0x0000001C) Transmit Data register. Data to be transmitted
                                                                    is written here.                                           */
  __IOM uint32_t  BRG;                          /*!< (@ 0x00000020) Baud Rate Generator register. 16-bit integer
                                                                    baud rate divisor value.                                   */
  __IOM uint32_t  INTSTAT;                      /*!< (@ 0x00000024) Interrupt status register. Reflects interrupts
                                                                    that are currently enabled.                                */
  __IOM uint32_t  OSR;                          /*!< (@ 0x00000028) Oversample selection register for asynchronous
                                                                    communication.                                             */
  __IOM uint32_t  ADDR;                         /*!< (@ 0x0000002C) Address register for automatic address matching.           */
} LPC_UART1_Type;                               /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                            CRC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm CRC engine (CRC)
  */

typedef struct {                                /*!< (@ 0x50000000) CRC Structure                                              */
  __IOM uint32_t  MODE;                         /*!< (@ 0x00000000) CRC mode register                                          */
  __IOM uint32_t  SEED;                         /*!< (@ 0x00000004) CRC seed register                                          */
  
  union {
    __IM  uint32_t SUM_SUM_WR_DATA;             /*!< (@ 0x00000008) CRC checksum register                                      */
    __OM  uint32_t WR_DATA_SUM_WR_DATA;         /*!< (@ 0x00000008) CRC data register                                          */
  };
} LPC_CRC_Type;                                 /*!< Size = 12 (0xc)                                                           */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm General Purpose I/O (GPIO) (GPIO)
  */

typedef struct {                                /*!< (@ 0xA0000000) GPIO Structure                                             */
  __IOM uint8_t   B[18];                        /*!< (@ 0x00000000) Byte pin registers for all port 0 and 1 GPIO
                                                                    pins                                                       */
  __IM  uint16_t  RESERVED;
  __IM  uint32_t  RESERVED1[1019];
  __IOM uint32_t  W[18];                        /*!< (@ 0x00001000) Word pin registers for all port 0 and 1 GPIO
                                                                    pins                                                       */
  __IM  uint32_t  RESERVED2[1006];
  __IOM uint32_t  DIR0;                         /*!< (@ 0x00002000) Direction registers                                        */
  __IM  uint32_t  RESERVED3[31];
  __IOM uint32_t  MASK0;                        /*!< (@ 0x00002080) Mask register                                              */
  __IM  uint32_t  RESERVED4[31];
  __IOM uint32_t  PIN0;                         /*!< (@ 0x00002100) Port pin register                                          */
  __IM  uint32_t  RESERVED5[31];
  __IOM uint32_t  MPIN0;                        /*!< (@ 0x00002180) Masked port register                                       */
  __IM  uint32_t  RESERVED6[31];
  __IOM uint32_t  SET0;                         /*!< (@ 0x00002200) Write: Set register for port Read: output bits
                                                                    for port                                                   */
  __IM  uint32_t  RESERVED7[31];
  __OM  uint32_t  CLR0;                         /*!< (@ 0x00002280) Clear port                                                 */
  __IM  uint32_t  RESERVED8[31];
  __OM  uint32_t  NOT0;                         /*!< (@ 0x00002300) Toggle port                                                */
  __IM  uint32_t  RESERVED9[31];
  __OM  uint32_t  DIRSET0;                      /*!< (@ 0x00002380) Set pin direction bits for port                            */
  __IM  uint32_t  RESERVED10[31];
  __OM  uint32_t  DIRCLR0;                      /*!< (@ 0x00002400) Clear pin direction bits for port                          */
  __IM  uint32_t  RESERVED11[31];
  __OM  uint32_t  DIRNOT0;                      /*!< (@ 0x00002480) Toggle pin direction bits for port                         */
} LPC_GPIO_Type;                                /*!< Size = 9348 (0x2484)                                                      */



/* =========================================================================================================================== */
/* ================                                         GPIO_INT                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief LPC80xm Pin interrupt and pattern match (PINT) (GPIO_INT)
  */

typedef struct {                                /*!< (@ 0xA0004000) GPIO_INT Structure                                         */
  __IOM uint32_t  ISEL;                         /*!< (@ 0x00000000) Pin Interrupt Mode register                                */
  __IOM uint32_t  IENR;                         /*!< (@ 0x00000004) Pin interrupt level or rising edge interrupt
                                                                    enable register                                            */
  __OM  uint32_t  SIENR;                        /*!< (@ 0x00000008) Pin interrupt level or rising edge interrupt
                                                                    set register                                               */
  __OM  uint32_t  CIENR;                        /*!< (@ 0x0000000C) Pin interrupt level (rising edge interrupt) clear
                                                                    register                                                   */
  __IOM uint32_t  IENF;                         /*!< (@ 0x00000010) Pin interrupt active level or falling edge interrupt
                                                                    enable register                                            */
  __OM  uint32_t  SIENF;                        /*!< (@ 0x00000014) Pin interrupt active level or falling edge interrupt
                                                                    set register                                               */
  __OM  uint32_t  CIENF;                        /*!< (@ 0x00000018) Pin interrupt active level or falling edge interrupt
                                                                    clear register                                             */
  __IOM uint32_t  RISE;                         /*!< (@ 0x0000001C) Pin interrupt rising edge register                         */
  __IOM uint32_t  FALL;                         /*!< (@ 0x00000020) Pin interrupt falling edge register                        */
  __IOM uint32_t  IST;                          /*!< (@ 0x00000024) Pin interrupt status register                              */
  __IOM uint32_t  PMCTRL;                       /*!< (@ 0x00000028) Pattern match interrupt control register                   */
  __IOM uint32_t  PMSRC;                        /*!< (@ 0x0000002C) Pattern match interrupt bit-slice source register          */
  __IOM uint32_t  PMCFG;                        /*!< (@ 0x00000030) Pattern match interrupt bit slice configuration
                                                                    register                                                   */
} LPC_GPIO_INT_Type;                            /*!< Size = 52 (0x34)                                                          */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define LPC_FLASH_CTRL_BASE         0x00040000UL
#define LPC_WDT0_BASE               0x40000000UL
#define LPC_MRT0_BASE               0x40004000UL
#define LPC_WAKE_TIMER_BASE         0x40008000UL
#define LPC_SWM0_BASE               0x4000C000UL
#define LPC_ADC_BASE                0x4001C000UL
#define LPC_PMU_BASE                0x40020000UL
#define LPC_COMP_BASE               0x40024000UL
#define LPC_CTIMER0_BASE            0x40038000UL
#define LPC_IOCON_BASE              0x40044000UL
#define LPC_SYSCON_BASE             0x40048000UL
#define LPC_I2C0_BASE               0x40050000UL
#define LPC_SSP0_BASE               0x40058000UL
#define LPC_UART0_BASE              0x40064000UL
#define LPC_UART1_BASE              0x40068000UL
#define LPC_CRC_BASE                0x50000000UL
#define LPC_GPIO_BASE               0xA0000000UL
#define LPC_GPIO_INT_BASE           0xA0004000UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define LPC_FLASH_CTRL              ((LPC_FLASH_CTRL_Type*)    LPC_FLASH_CTRL_BASE)
#define LPC_WDT0                    ((LPC_WDT0_Type*)          LPC_WDT0_BASE)
#define LPC_MRT0                    ((LPC_MRT0_Type*)          LPC_MRT0_BASE)
#define LPC_WAKE_TIMER              ((LPC_WAKE_TIMER_Type*)    LPC_WAKE_TIMER_BASE)
#define LPC_SWM0                    ((LPC_SWM0_Type*)          LPC_SWM0_BASE)
#define LPC_ADC                     ((LPC_ADC_Type*)           LPC_ADC_BASE)
#define LPC_PMU                     ((LPC_PMU_Type*)           LPC_PMU_BASE)
#define LPC_COMP                    ((LPC_COMP_Type*)          LPC_COMP_BASE)
#define LPC_CTIMER0                 ((LPC_CTIMER0_Type*)       LPC_CTIMER0_BASE)
#define LPC_IOCON                   ((LPC_IOCON_Type*)         LPC_IOCON_BASE)
#define LPC_SYSCON                  ((LPC_SYSCON_Type*)        LPC_SYSCON_BASE)
#define LPC_I2C0                    ((LPC_I2C0_Type*)          LPC_I2C0_BASE)
#define LPC_SSP0                    ((LPC_SSP0_Type*)          LPC_SSP0_BASE)
#define LPC_UART0                   ((LPC_USART_Type*)         LPC_UART0_BASE)
#define LPC_UART1                   ((LPC_UART1_Type*)         LPC_UART1_BASE)
#define LPC_CRC                     ((LPC_CRC_Type*)           LPC_CRC_BASE)
#define LPC_GPIO                    ((LPC_GPIO_Type*)          LPC_GPIO_BASE)
#define LPC_GPIO_INT                ((LPC_GPIO_INT_Type*)      LPC_GPIO_INT_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


#ifdef __cplusplus
}
#endif

#endif /* LPC802_H */


/** @} */ /* End of group LPC802 */

/** @} */ /* End of group NXP Semiconductors */
