/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2017 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak DMA0_DMA16_IRQHandler
  .thumb_set DMA0_DMA16_IRQHandler,Dummy_Handler

  .weak DMA1_DMA17_IRQHandler
  .thumb_set DMA1_DMA17_IRQHandler,Dummy_Handler

  .weak DMA2_DMA18_IRQHandler
  .thumb_set DMA2_DMA18_IRQHandler,Dummy_Handler

  .weak DMA3_DMA19_IRQHandler
  .thumb_set DMA3_DMA19_IRQHandler,Dummy_Handler

  .weak DMA4_DMA20_IRQHandler
  .thumb_set DMA4_DMA20_IRQHandler,Dummy_Handler

  .weak DMA5_DMA21_IRQHandler
  .thumb_set DMA5_DMA21_IRQHandler,Dummy_Handler

  .weak DMA6_DMA22_IRQHandler
  .thumb_set DMA6_DMA22_IRQHandler,Dummy_Handler

  .weak DMA7_DMA23_IRQHandler
  .thumb_set DMA7_DMA23_IRQHandler,Dummy_Handler

  .weak DMA8_DMA24_IRQHandler
  .thumb_set DMA8_DMA24_IRQHandler,Dummy_Handler

  .weak DMA9_DMA25_IRQHandler
  .thumb_set DMA9_DMA25_IRQHandler,Dummy_Handler

  .weak DMA10_DMA26_IRQHandler
  .thumb_set DMA10_DMA26_IRQHandler,Dummy_Handler

  .weak DMA11_DMA27_IRQHandler
  .thumb_set DMA11_DMA27_IRQHandler,Dummy_Handler

  .weak DMA12_DMA28_IRQHandler
  .thumb_set DMA12_DMA28_IRQHandler,Dummy_Handler

  .weak DMA13_DMA29_IRQHandler
  .thumb_set DMA13_DMA29_IRQHandler,Dummy_Handler

  .weak DMA14_DMA30_IRQHandler
  .thumb_set DMA14_DMA30_IRQHandler,Dummy_Handler

  .weak DMA15_DMA31_IRQHandler
  .thumb_set DMA15_DMA31_IRQHandler,Dummy_Handler

  .weak DMA_Error_IRQHandler
  .thumb_set DMA_Error_IRQHandler,Dummy_Handler

  .weak MCM_IRQHandler
  .thumb_set MCM_IRQHandler,Dummy_Handler

  .weak FTFA_IRQHandler
  .thumb_set FTFA_IRQHandler,Dummy_Handler

  .weak Read_Collision_IRQHandler
  .thumb_set Read_Collision_IRQHandler,Dummy_Handler

  .weak LVD_LVW_IRQHandler
  .thumb_set LVD_LVW_IRQHandler,Dummy_Handler

  .weak LLWU_IRQHandler
  .thumb_set LLWU_IRQHandler,Dummy_Handler

  .weak WDOG_EWM_IRQHandler
  .thumb_set WDOG_EWM_IRQHandler,Dummy_Handler

  .weak TRNG0_IRQHandler
  .thumb_set TRNG0_IRQHandler,Dummy_Handler

  .weak I2C0_IRQHandler
  .thumb_set I2C0_IRQHandler,Dummy_Handler

  .weak I2C1_IRQHandler
  .thumb_set I2C1_IRQHandler,Dummy_Handler

  .weak SPI0_IRQHandler
  .thumb_set SPI0_IRQHandler,Dummy_Handler

  .weak SPI1_IRQHandler
  .thumb_set SPI1_IRQHandler,Dummy_Handler

  .weak I2S0_Tx_IRQHandler
  .thumb_set I2S0_Tx_IRQHandler,Dummy_Handler

  .weak I2S0_Rx_IRQHandler
  .thumb_set I2S0_Rx_IRQHandler,Dummy_Handler

  .weak LPUART0_IRQHandler
  .thumb_set LPUART0_IRQHandler,Dummy_Handler

  .weak LPUART1_IRQHandler
  .thumb_set LPUART1_IRQHandler,Dummy_Handler

  .weak LPUART2_IRQHandler
  .thumb_set LPUART2_IRQHandler,Dummy_Handler

  .weak LPUART3_IRQHandler
  .thumb_set LPUART3_IRQHandler,Dummy_Handler

  .weak LPUART4_IRQHandler
  .thumb_set LPUART4_IRQHandler,Dummy_Handler

  .weak EMVSIM0_IRQHandler
  .thumb_set EMVSIM0_IRQHandler,Dummy_Handler

  .weak EMVSIM1_IRQHandler
  .thumb_set EMVSIM1_IRQHandler,Dummy_Handler

  .weak ADC0_IRQHandler
  .thumb_set ADC0_IRQHandler,Dummy_Handler

  .weak CMP0_IRQHandler
  .thumb_set CMP0_IRQHandler,Dummy_Handler

  .weak CMP1_IRQHandler
  .thumb_set CMP1_IRQHandler,Dummy_Handler

  .weak FTM0_IRQHandler
  .thumb_set FTM0_IRQHandler,Dummy_Handler

  .weak FTM1_IRQHandler
  .thumb_set FTM1_IRQHandler,Dummy_Handler

  .weak FTM2_IRQHandler
  .thumb_set FTM2_IRQHandler,Dummy_Handler

  .weak CMT_IRQHandler
  .thumb_set CMT_IRQHandler,Dummy_Handler

  .weak RTC_IRQHandler
  .thumb_set RTC_IRQHandler,Dummy_Handler

  .weak RTC_Seconds_IRQHandler
  .thumb_set RTC_Seconds_IRQHandler,Dummy_Handler

  .weak PIT0CH0_IRQHandler
  .thumb_set PIT0CH0_IRQHandler,Dummy_Handler

  .weak PIT0CH1_IRQHandler
  .thumb_set PIT0CH1_IRQHandler,Dummy_Handler

  .weak PIT0CH2_IRQHandler
  .thumb_set PIT0CH2_IRQHandler,Dummy_Handler

  .weak PIT0CH3_IRQHandler
  .thumb_set PIT0CH3_IRQHandler,Dummy_Handler

  .weak PDB0_IRQHandler
  .thumb_set PDB0_IRQHandler,Dummy_Handler

  .weak USB0_IRQHandler
  .thumb_set USB0_IRQHandler,Dummy_Handler

  .weak USBDCD_IRQHandler
  .thumb_set USBDCD_IRQHandler,Dummy_Handler

  .weak DAC0_IRQHandler
  .thumb_set DAC0_IRQHandler,Dummy_Handler

  .weak MCG_IRQHandler
  .thumb_set MCG_IRQHandler,Dummy_Handler

  .weak LPTMR0_LPTMR1_IRQHandler
  .thumb_set LPTMR0_LPTMR1_IRQHandler,Dummy_Handler

  .weak PORTA_IRQHandler
  .thumb_set PORTA_IRQHandler,Dummy_Handler

  .weak PORTB_IRQHandler
  .thumb_set PORTB_IRQHandler,Dummy_Handler

  .weak PORTC_IRQHandler
  .thumb_set PORTC_IRQHandler,Dummy_Handler

  .weak PORTD_IRQHandler
  .thumb_set PORTD_IRQHandler,Dummy_Handler

  .weak PORTE_IRQHandler
  .thumb_set PORTE_IRQHandler,Dummy_Handler

  .weak SPI2_IRQHandler
  .thumb_set SPI2_IRQHandler,Dummy_Handler

  .weak FLEXIO0_IRQHandler
  .thumb_set FLEXIO0_IRQHandler,Dummy_Handler

  .weak FTM3_IRQHandler
  .thumb_set FTM3_IRQHandler,Dummy_Handler

  .weak I2C2_IRQHandler
  .thumb_set I2C2_IRQHandler,Dummy_Handler

  .weak SDHC_IRQHandler
  .thumb_set SDHC_IRQHandler,Dummy_Handler

  .weak TSI0_IRQHandler
  .thumb_set TSI0_IRQHandler,Dummy_Handler

  .weak TPM1_IRQHandler
  .thumb_set TPM1_IRQHandler,Dummy_Handler

  .weak TPM2_IRQHandler
  .thumb_set TPM2_IRQHandler,Dummy_Handler

  .weak I2C3_IRQHandler
  .thumb_set I2C3_IRQHandler,Dummy_Handler

  .weak QuadSPI0_IRQHandler
  .thumb_set QuadSPI0_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak DMA0_DMA16_IRQHandler
DMA0_DMA16_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_DMA17_IRQHandler
DMA1_DMA17_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_DMA18_IRQHandler
DMA2_DMA18_IRQHandler:
  b .

  .thumb_func
  .weak DMA3_DMA19_IRQHandler
DMA3_DMA19_IRQHandler:
  b .

  .thumb_func
  .weak DMA4_DMA20_IRQHandler
DMA4_DMA20_IRQHandler:
  b .

  .thumb_func
  .weak DMA5_DMA21_IRQHandler
DMA5_DMA21_IRQHandler:
  b .

  .thumb_func
  .weak DMA6_DMA22_IRQHandler
DMA6_DMA22_IRQHandler:
  b .

  .thumb_func
  .weak DMA7_DMA23_IRQHandler
DMA7_DMA23_IRQHandler:
  b .

  .thumb_func
  .weak DMA8_DMA24_IRQHandler
DMA8_DMA24_IRQHandler:
  b .

  .thumb_func
  .weak DMA9_DMA25_IRQHandler
DMA9_DMA25_IRQHandler:
  b .

  .thumb_func
  .weak DMA10_DMA26_IRQHandler
DMA10_DMA26_IRQHandler:
  b .

  .thumb_func
  .weak DMA11_DMA27_IRQHandler
DMA11_DMA27_IRQHandler:
  b .

  .thumb_func
  .weak DMA12_DMA28_IRQHandler
DMA12_DMA28_IRQHandler:
  b .

  .thumb_func
  .weak DMA13_DMA29_IRQHandler
DMA13_DMA29_IRQHandler:
  b .

  .thumb_func
  .weak DMA14_DMA30_IRQHandler
DMA14_DMA30_IRQHandler:
  b .

  .thumb_func
  .weak DMA15_DMA31_IRQHandler
DMA15_DMA31_IRQHandler:
  b .

  .thumb_func
  .weak DMA_Error_IRQHandler
DMA_Error_IRQHandler:
  b .

  .thumb_func
  .weak MCM_IRQHandler
MCM_IRQHandler:
  b .

  .thumb_func
  .weak FTFA_IRQHandler
FTFA_IRQHandler:
  b .

  .thumb_func
  .weak Read_Collision_IRQHandler
Read_Collision_IRQHandler:
  b .

  .thumb_func
  .weak LVD_LVW_IRQHandler
LVD_LVW_IRQHandler:
  b .

  .thumb_func
  .weak LLWU_IRQHandler
LLWU_IRQHandler:
  b .

  .thumb_func
  .weak WDOG_EWM_IRQHandler
WDOG_EWM_IRQHandler:
  b .

  .thumb_func
  .weak TRNG0_IRQHandler
TRNG0_IRQHandler:
  b .

  .thumb_func
  .weak I2C0_IRQHandler
I2C0_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_IRQHandler
I2C1_IRQHandler:
  b .

  .thumb_func
  .weak SPI0_IRQHandler
SPI0_IRQHandler:
  b .

  .thumb_func
  .weak SPI1_IRQHandler
SPI1_IRQHandler:
  b .

  .thumb_func
  .weak I2S0_Tx_IRQHandler
I2S0_Tx_IRQHandler:
  b .

  .thumb_func
  .weak I2S0_Rx_IRQHandler
I2S0_Rx_IRQHandler:
  b .

  .thumb_func
  .weak LPUART0_IRQHandler
LPUART0_IRQHandler:
  b .

  .thumb_func
  .weak LPUART1_IRQHandler
LPUART1_IRQHandler:
  b .

  .thumb_func
  .weak LPUART2_IRQHandler
LPUART2_IRQHandler:
  b .

  .thumb_func
  .weak LPUART3_IRQHandler
LPUART3_IRQHandler:
  b .

  .thumb_func
  .weak LPUART4_IRQHandler
LPUART4_IRQHandler:
  b .

  .thumb_func
  .weak EMVSIM0_IRQHandler
EMVSIM0_IRQHandler:
  b .

  .thumb_func
  .weak EMVSIM1_IRQHandler
EMVSIM1_IRQHandler:
  b .

  .thumb_func
  .weak ADC0_IRQHandler
ADC0_IRQHandler:
  b .

  .thumb_func
  .weak CMP0_IRQHandler
CMP0_IRQHandler:
  b .

  .thumb_func
  .weak CMP1_IRQHandler
CMP1_IRQHandler:
  b .

  .thumb_func
  .weak FTM0_IRQHandler
FTM0_IRQHandler:
  b .

  .thumb_func
  .weak FTM1_IRQHandler
FTM1_IRQHandler:
  b .

  .thumb_func
  .weak FTM2_IRQHandler
FTM2_IRQHandler:
  b .

  .thumb_func
  .weak CMT_IRQHandler
CMT_IRQHandler:
  b .

  .thumb_func
  .weak RTC_IRQHandler
RTC_IRQHandler:
  b .

  .thumb_func
  .weak RTC_Seconds_IRQHandler
RTC_Seconds_IRQHandler:
  b .

  .thumb_func
  .weak PIT0CH0_IRQHandler
PIT0CH0_IRQHandler:
  b .

  .thumb_func
  .weak PIT0CH1_IRQHandler
PIT0CH1_IRQHandler:
  b .

  .thumb_func
  .weak PIT0CH2_IRQHandler
PIT0CH2_IRQHandler:
  b .

  .thumb_func
  .weak PIT0CH3_IRQHandler
PIT0CH3_IRQHandler:
  b .

  .thumb_func
  .weak PDB0_IRQHandler
PDB0_IRQHandler:
  b .

  .thumb_func
  .weak USB0_IRQHandler
USB0_IRQHandler:
  b .

  .thumb_func
  .weak USBDCD_IRQHandler
USBDCD_IRQHandler:
  b .

  .thumb_func
  .weak DAC0_IRQHandler
DAC0_IRQHandler:
  b .

  .thumb_func
  .weak MCG_IRQHandler
MCG_IRQHandler:
  b .

  .thumb_func
  .weak LPTMR0_LPTMR1_IRQHandler
LPTMR0_LPTMR1_IRQHandler:
  b .

  .thumb_func
  .weak PORTA_IRQHandler
PORTA_IRQHandler:
  b .

  .thumb_func
  .weak PORTB_IRQHandler
PORTB_IRQHandler:
  b .

  .thumb_func
  .weak PORTC_IRQHandler
PORTC_IRQHandler:
  b .

  .thumb_func
  .weak PORTD_IRQHandler
PORTD_IRQHandler:
  b .

  .thumb_func
  .weak PORTE_IRQHandler
PORTE_IRQHandler:
  b .

  .thumb_func
  .weak SPI2_IRQHandler
SPI2_IRQHandler:
  b .

  .thumb_func
  .weak FLEXIO0_IRQHandler
FLEXIO0_IRQHandler:
  b .

  .thumb_func
  .weak FTM3_IRQHandler
FTM3_IRQHandler:
  b .

  .thumb_func
  .weak I2C2_IRQHandler
I2C2_IRQHandler:
  b .

  .thumb_func
  .weak SDHC_IRQHandler
SDHC_IRQHandler:
  b .

  .thumb_func
  .weak TSI0_IRQHandler
TSI0_IRQHandler:
  b .

  .thumb_func
  .weak TPM1_IRQHandler
TPM1_IRQHandler:
  b .

  .thumb_func
  .weak TPM2_IRQHandler
TPM2_IRQHandler:
  b .

  .thumb_func
  .weak I2C3_IRQHandler
I2C3_IRQHandler:
  b .

  .thumb_func
  .weak QuadSPI0_IRQHandler
QuadSPI0_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word DMA0_DMA16_IRQHandler
  .word DMA1_DMA17_IRQHandler
  .word DMA2_DMA18_IRQHandler
  .word DMA3_DMA19_IRQHandler
  .word DMA4_DMA20_IRQHandler
  .word DMA5_DMA21_IRQHandler
  .word DMA6_DMA22_IRQHandler
  .word DMA7_DMA23_IRQHandler
  .word DMA8_DMA24_IRQHandler
  .word DMA9_DMA25_IRQHandler
  .word DMA10_DMA26_IRQHandler
  .word DMA11_DMA27_IRQHandler
  .word DMA12_DMA28_IRQHandler
  .word DMA13_DMA29_IRQHandler
  .word DMA14_DMA30_IRQHandler
  .word DMA15_DMA31_IRQHandler
  .word DMA_Error_IRQHandler
  .word MCM_IRQHandler
  .word FTFA_IRQHandler
  .word Read_Collision_IRQHandler
  .word LVD_LVW_IRQHandler
  .word LLWU_IRQHandler
  .word WDOG_EWM_IRQHandler
  .word TRNG0_IRQHandler
  .word I2C0_IRQHandler
  .word I2C1_IRQHandler
  .word SPI0_IRQHandler
  .word SPI1_IRQHandler
  .word I2S0_Tx_IRQHandler
  .word I2S0_Rx_IRQHandler
  .word LPUART0_IRQHandler
  .word LPUART1_IRQHandler
  .word LPUART2_IRQHandler
  .word LPUART3_IRQHandler
  .word LPUART4_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word EMVSIM0_IRQHandler
  .word EMVSIM1_IRQHandler
  .word ADC0_IRQHandler
  .word CMP0_IRQHandler
  .word CMP1_IRQHandler
  .word FTM0_IRQHandler
  .word FTM1_IRQHandler
  .word FTM2_IRQHandler
  .word CMT_IRQHandler
  .word RTC_IRQHandler
  .word RTC_Seconds_IRQHandler
  .word PIT0CH0_IRQHandler
  .word PIT0CH1_IRQHandler
  .word PIT0CH2_IRQHandler
  .word PIT0CH3_IRQHandler
  .word PDB0_IRQHandler
  .word USB0_IRQHandler
  .word USBDCD_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word DAC0_IRQHandler
  .word MCG_IRQHandler
  .word LPTMR0_LPTMR1_IRQHandler
  .word PORTA_IRQHandler
  .word PORTB_IRQHandler
  .word PORTC_IRQHandler
  .word PORTD_IRQHandler
  .word PORTE_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word SPI2_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word FLEXIO0_IRQHandler
  .word FTM3_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word I2C2_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word SDHC_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word TSI0_IRQHandler
  .word TPM1_IRQHandler
  .word TPM2_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word I2C3_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word QuadSPI0_IRQHandler
_vectors_end:

#if 1
  .section .vectors, "ax"
  // fill to 0x400 for the flash configuration field
  //.fill 0x400-(_vectors_end-_vectors), 1, 0xff
  .org 0x400, 0xFF
BackDoorKey:
  .byte 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
#if defined(E_SERIES)
RESERVED:
  .byte 0xff, 0xff, 0xff, 0xff
EEPROT:
  .byte 0xff
FPROT:
  .byte 0xff
FSEC:
  .byte 0xfe
FOPT:
  .byte 0xff
#else
FPROT:
  .byte 0xff, 0xff, 0xff, 0xff
FSEC:
  .byte 0xfe
FOPT:
#if defined(MKL03Z4) || defined(MKL17Z4) || defined(MKL17Z644) || defined(MKL27Z4)  || defined(MKL27Z644) || defined(MKL33Z4) || defined(MKL33Z644) || defined(MKL43Z4)
  .byte 0x3b
#else 
  .byte 0xff
#endif
FEPROT:
  .byte 0xff
FDPROT:
  .byte 0xff
#endif
#endif

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
