/*********************************************************************
*                    SEGGER Microcontroller GmbH                     *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*            (c) 2014 - 2020 SEGGER Microcontroller GmbH             *
*                                                                    *
*           www.segger.com     Support: support@segger.com           *
*                                                                    *
**********************************************************************
*                                                                    *
* All rights reserved.                                               *
*                                                                    *
* Redistribution and use in source and binary forms, with or         *
* without modification, are permitted provided that the following    *
* conditions are met:                                                *
*                                                                    *
* - Redistributions of source code must retain the above copyright   *
*   notice, this list of conditions and the following disclaimer.    *
*                                                                    *
* - Neither the name of SEGGER Microcontroller GmbH                  *
*   nor the names of its contributors may be used to endorse or      *
*   promote products derived from this software without specific     *
*   prior written permission.                                        *
*                                                                    *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND             *
* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,        *
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF           *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE           *
* DISCLAIMED.                                                        *
* IN NO EVENT SHALL SEGGER Microcontroller GmbH BE LIABLE FOR        *
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR           *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT  *
* OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;    *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      *
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT          *
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE  *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
* DAMAGE.                                                            *
*                                                                    *
*********************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 2

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL) 

  .weak DMA0_DMA16_IRQHandler
  .thumb_set DMA0_DMA16_IRQHandler,Dummy_Handler
  
  .weak DMA1_DMA17_IRQHandler
  .thumb_set DMA1_DMA17_IRQHandler,Dummy_Handler
  
  .weak DMA2_DMA18_IRQHandler
  .thumb_set DMA2_DMA18_IRQHandler,Dummy_Handler
  
  .weak DMA3_DMA19_IRQHandler
  .thumb_set DMA3_DMA19_IRQHandler,Dummy_Handler
  
  .weak DMA4_DMA20_IRQHandler
  .thumb_set DMA4_DMA20_IRQHandler,Dummy_Handler
  
  .weak DMA5_DMA21_IRQHandler
  .thumb_set DMA5_DMA21_IRQHandler,Dummy_Handler
  
  .weak DMA6_DMA22_IRQHandler
  .thumb_set DMA6_DMA22_IRQHandler,Dummy_Handler
  
  .weak DMA7_DMA23_IRQHandler
  .thumb_set DMA7_DMA23_IRQHandler,Dummy_Handler
  
  .weak DMA8_DMA24_IRQHandler
  .thumb_set DMA8_DMA24_IRQHandler,Dummy_Handler
  
  .weak DMA9_DMA25_IRQHandler
  .thumb_set DMA9_DMA25_IRQHandler,Dummy_Handler
  
  .weak DMA10_DMA26_IRQHandler
  .thumb_set DMA10_DMA26_IRQHandler,Dummy_Handler
  
  .weak DMA11_DMA27_IRQHandler
  .thumb_set DMA11_DMA27_IRQHandler,Dummy_Handler
  
  .weak DMA12_DMA28_IRQHandler
  .thumb_set DMA12_DMA28_IRQHandler,Dummy_Handler
  
  .weak DMA13_DMA29_IRQHandler
  .thumb_set DMA13_DMA29_IRQHandler,Dummy_Handler
  
  .weak DMA14_DMA30_IRQHandler
  .thumb_set DMA14_DMA30_IRQHandler,Dummy_Handler
  
  .weak DMA15_DMA31_IRQHandler
  .thumb_set DMA15_DMA31_IRQHandler,Dummy_Handler

  .weak DMA_ERROR_IRQHandler
  .thumb_set DMA_ERROR_IRQHandler,Dummy_Handler
  
  .weak CTI0_ERROR_IRQHandler
  .thumb_set CTI0_ERROR_IRQHandler,Dummy_Handler
  
  .weak CTI1_ERROR_IRQHandler
  .thumb_set CTI1_ERROR_IRQHandler,Dummy_Handler
  
  .weak CORE_IRQHandler
  .thumb_set CORE_IRQHandler,Dummy_Handler
  
  .weak LPUART1_IRQHandler
  .thumb_set LPUART1_IRQHandler,Dummy_Handler

  .weak LPUART2_IRQHandler
  .thumb_set LPUART2_IRQHandler,Dummy_Handler

  .weak LPUART3_IRQHandler
  .thumb_set LPUART3_IRQHandler,Dummy_Handler

  .weak LPUART4_IRQHandler
  .thumb_set LPUART4_IRQHandler,Dummy_Handler

  .weak LPUART5_IRQHandler
  .thumb_set LPUART5_IRQHandler,Dummy_Handler

  .weak LPUART6_IRQHandler
  .thumb_set LPUART6_IRQHandler,Dummy_Handler

  .weak LPUART7_IRQHandler
  .thumb_set LPUART7_IRQHandler,Dummy_Handler

  .weak LPUART8_IRQHandler
  .thumb_set LPUART8_IRQHandler,Dummy_Handler

  .weak LPUART9_IRQHandler
  .thumb_set LPUART9_IRQHandler,Dummy_Handler

  .weak LPUART10_IRQHandler
  .thumb_set LPUART10_IRQHandler,Dummy_Handler

  .weak LPUART11_IRQHandler
  .thumb_set LPUART11_IRQHandler,Dummy_Handler

  .weak LPUART12_IRQHandler
  .thumb_set LPUART12_IRQHandler,Dummy_Handler

  .weak LPI2C1_IRQHandler
  .thumb_set LPI2C1_IRQHandler,Dummy_Handler

  .weak LPI2C2_IRQHandler
  .thumb_set LPI2C2_IRQHandler,Dummy_Handler

  .weak LPI2C3_IRQHandler
  .thumb_set LPI2C3_IRQHandler,Dummy_Handler

  .weak LPI2C4_IRQHandler
  .thumb_set LPI2C4_IRQHandler,Dummy_Handler

  .weak LPI2C5_IRQHandler
  .thumb_set LPI2C5_IRQHandler,Dummy_Handler

  .weak LPI2C6_IRQHandler
  .thumb_set LPI2C6_IRQHandler,Dummy_Handler

  .weak LPSPI1_IRQHandler
  .thumb_set LPSPI1_IRQHandler,Dummy_Handler

  .weak LPSPI2_IRQHandler
  .thumb_set LPSPI2_IRQHandler,Dummy_Handler

  .weak LPSPI3_IRQHandler
  .thumb_set LPSPI3_IRQHandler,Dummy_Handler

  .weak LPSPI4_IRQHandler
  .thumb_set LPSPI4_IRQHandler,Dummy_Handler

  .weak LPSPI5_IRQHandler
  .thumb_set LPSPI5_IRQHandler,Dummy_Handler

  .weak LPSPI6_IRQHandler
  .thumb_set LPSPI6_IRQHandler,Dummy_Handler

  .weak CAN1_IRQHandler
  .thumb_set CAN1_IRQHandler,Dummy_Handler

  .weak CAN1_ERROR_IRQHandler
  .thumb_set CAN1_ERROR_IRQHandler,Dummy_Handler

  .weak CAN2_IRQHandler
  .thumb_set CAN2_IRQHandler,Dummy_Handler

  .weak CAN2_ERROR_IRQHandler
  .thumb_set CAN2_ERROR_IRQHandler,Dummy_Handler

  .weak CAN3_IRQHandler
  .thumb_set CAN3_IRQHandler,Dummy_Handler

  .weak CAN3_ERROR_IRQHandler
  .thumb_set CAN3_ERROR_IRQHandler,Dummy_Handler

  .weak FLEXRAM_IRQHandler
  .thumb_set FLEXRAM_IRQHandler,Dummy_Handler
  
  .weak KPP_IRQHandler
  .thumb_set KPP_IRQHandler,Dummy_Handler
  
  .weak GPR_IRQ_IRQHandler
  .thumb_set GPR_IRQ_IRQHandler,Dummy_Handler
  
  .weak LCDIF1_IRQHandler
  .thumb_set LCDIF1_IRQHandler,Dummy_Handler
  
  .weak LCDIF2_IRQHandler
  .thumb_set LCDIF2_IRQHandler,Dummy_Handler
  
  .weak CSI_IRQHandler
  .thumb_set CSI_IRQHandler,Dummy_Handler

  .weak PXP_IRQHandler
  .thumb_set PXP_IRQHandler,Dummy_Handler
  
  .weak MIPI_CSI_IRQHandler
  .thumb_set MIPI_CSI_IRQHandler,Dummy_Handler
  
  .weak MIPI_DSI_IRQHandler
  .thumb_set MIPI_DSI_IRQHandler,Dummy_Handler
  
  .weak GPU2D_IRQHandler
  .thumb_set GPU2D_IRQHandler,Dummy_Handler
  
  .weak GPIO6_Combined_0_15_IRQHandler
  .thumb_set GPIO6_Combined_0_15_IRQHandler,Dummy_Handler

  .weak GPIO6_Combined_16_31_IRQHandler
  .thumb_set GPIO6_Combined_16_31_IRQHandler,Dummy_Handler

  .weak DAC_IRQHandler
  .thumb_set DAC_IRQHandler,Dummy_Handler

  .weak WDOG2_IRQHandler
  .thumb_set WDOG2_IRQHandler,Dummy_Handler
  
  .weak SNVS_HP_WRAPPER_IRQHandler
  .thumb_set SNVS_HP_WRAPPER_IRQHandler,Dummy_Handler
  
  .weak SNVS_HP_WRAPPER_TZ_IRQHandler
  .thumb_set SNVS_HP_WRAPPER_TZ_IRQHandler,Dummy_Handler
  
  .weak SNVS_LP_WRAPPER_IRQHandler
  .thumb_set SNVS_LP_WRAPPER_IRQHandler,Dummy_Handler

  .weak SDIO_IRQHandler
  .thumb_set SDIO_IRQHandler,Dummy_Handler

  .weak SAI1_IRQHandler
  .thumb_set SAI1_IRQHandler,Dummy_Handler

  .weak SAI2_IRQHandler
  .thumb_set SAI2_IRQHandler,Dummy_Handler

  .weak SAI3_RX_IRQHandler
  .thumb_set SAI3_RX_IRQHandler,Dummy_Handler

  .weak SAI3_TX_IRQHandler
  .thumb_set SAI3_TX_IRQHandler,Dummy_Handler

  .weak SAI4_RX_IRQHandler
  .thumb_set SAI4_RX_IRQHandler,Dummy_Handler

  .weak SAI4_TX_IRQHandler
  .thumb_set SAI4_TX_IRQHandler,Dummy_Handler

  .weak SPDIF_IRQHandler
  .thumb_set SPDIF_IRQHandler,Dummy_Handler
  
  .weak ANATOP_TEMP_INT_IRQHandler
  .thumb_set ANATOP_TEMP_INT_IRQHandler,Dummy_Handler
  
  .weak ANATOP_TEMP_LOW_HIGH_IRQHandler
  .thumb_set ANATOP_TEMP_LOW_HIGH_IRQHandler,Dummy_Handler
  
  .weak ANATOP_TEMP_PANIC_IRQHandler
  .thumb_set ANATOP_TEMP_PANIC_IRQHandler,Dummy_Handler
  
  .weak ANATOP_LP8_BROWNOUT_IRQHandler
  .thumb_set ANATOP_LP8_BROWNOUT_IRQHandler,Dummy_Handler
  
  .weak ANATOP_LP0_BROWNOUT_IRQHandler
  .thumb_set ANATOP_LP0_BROWNOUT_IRQHandler,Dummy_Handler
  
  .weak ADC1_IRQHandler
  .thumb_set ADC1_IRQHandler,Dummy_Handler
  
  .weak ADC2_IRQHandler
  .thumb_set ADC2_IRQHandler,Dummy_Handler

  .weak USBPHY1_IRQHandler
  .thumb_set USBPHY1_IRQHandler,Dummy_Handler

  .weak USBPHY2_IRQHandler
  .thumb_set USBPHY2_IRQHandler,Dummy_Handler

  .weak RDC_IRQHandler
  .thumb_set RDC_IRQHandler,Dummy_Handler

  .weak GPIO13_Combined_0_31_IRQHandler
  .thumb_set GPIO13_Combined_0_31_IRQHandler,Dummy_Handler

  .weak SFA_IRQHandler
  .thumb_set SFA_IRQHandler,Dummy_Handler
  
  .weak DCIC1_IRQHandler
  .thumb_set DCIC1_IRQHandler,Dummy_Handler
  
  .weak DCIC2_IRQHandler
  .thumb_set DCIC2_IRQHandler,Dummy_Handler

  .weak ASRC_IRQHandler
  .thumb_set ASRC_IRQHandler,Dummy_Handler

  .weak FLEXRAM_ECC_IRQHandler
  .thumb_set FLEXRAM_ECC_IRQHandler,Dummy_Handler

  .weak CM7_GPIO2_3_IRQHandler
  .thumb_set CM7_GPIO2_3_IRQHandler,Dummy_Handler

  .weak GPIO1_Combined_0_15_IRQHandler
  .thumb_set GPIO1_Combined_0_15_IRQHandler,Dummy_Handler

  .weak GPIO1_Combined_16_31_IRQHandler
  .thumb_set GPIO1_Combined_16_31_IRQHandler,Dummy_Handler

  .weak GPIO2_Combined_0_15_IRQHandler
  .thumb_set GPIO2_Combined_0_15_IRQHandler,Dummy_Handler

  .weak GPIO2_Combined_16_31_IRQHandler
  .thumb_set GPIO2_Combined_16_31_IRQHandler,Dummy_Handler

  .weak GPIO3_Combined_0_15_IRQHandler
  .thumb_set GPIO3_Combined_0_15_IRQHandler,Dummy_Handler

  .weak GPIO3_Combined_16_31_IRQHandler
  .thumb_set GPIO3_Combined_16_31_IRQHandler,Dummy_Handler

  .weak GPIO4_Combined_0_15_IRQHandler
  .thumb_set GPIO4_Combined_0_15_IRQHandler,Dummy_Handler

  .weak GPIO4_Combined_16_31_IRQHandler
  .thumb_set GPIO4_Combined_16_31_IRQHandler,Dummy_Handler

  .weak GPIO5_Combined_0_15_IRQHandler
  .thumb_set GPIO5_Combined_0_15_IRQHandler,Dummy_Handler

  .weak GPIO5_Combined_16_31_IRQHandler
  .thumb_set GPIO5_Combined_16_31_IRQHandler,Dummy_Handler

  .weak FLEXIO1_IRQHandler
  .thumb_set FLEXIO1_IRQHandler,Dummy_Handler

  .weak FLEXIO2_IRQHandler
  .thumb_set FLEXIO2_IRQHandler,Dummy_Handler

  .weak WDOG1_IRQHandler
  .thumb_set WDOG1_IRQHandler,Dummy_Handler

  .weak RTWDOG3_IRQHandler
  .thumb_set RTWDOG3_IRQHandler,Dummy_Handler

  .weak EWM_IRQHandler
  .thumb_set EWM_IRQHandler,Dummy_Handler

  .weak OCOTP_READ_FUSE_ERROR_IRQHandler
  .thumb_set OCOTP_READ_FUSE_ERROR_IRQHandler,Dummy_Handler

  .weak OCOTP_READ_DONE_ERROR_IRQHandler
  .thumb_set OCOTP_READ_DONE_ERROR_IRQHandler,Dummy_Handler

  .weak MUA_IRQHandler
  .thumb_set MUA_IRQHandler,Dummy_Handler

  .weak GPT1_IRQHandler
  .thumb_set GPT1_IRQHandler,Dummy_Handler

  .weak GPT2_IRQHandler
  .thumb_set GPT2_IRQHandler,Dummy_Handler

  .weak GPT3_IRQHandler
  .thumb_set GPT3_IRQHandler,Dummy_Handler

  .weak GPT4_IRQHandler
  .thumb_set GPT4_IRQHandler,Dummy_Handler

  .weak GPT5_IRQHandler
  .thumb_set GPT5_IRQHandler,Dummy_Handler

  .weak GPT6_IRQHandler
  .thumb_set GPT6_IRQHandler,Dummy_Handler

  .weak PWM1_0_IRQHandler
  .thumb_set PWM1_0_IRQHandler,Dummy_Handler

  .weak PWM1_1_IRQHandler
  .thumb_set PWM1_1_IRQHandler,Dummy_Handler

  .weak PWM1_2_IRQHandler
  .thumb_set PWM1_2_IRQHandler,Dummy_Handler

  .weak PWM1_3_IRQHandler
  .thumb_set PWM1_3_IRQHandler,Dummy_Handler

  .weak PWM1_FAULT_IRQHandler
  .thumb_set PWM1_FAULT_IRQHandler,Dummy_Handler

  .weak FLEXSPI1_IRQHandler
  .thumb_set FLEXSPI1_IRQHandler,Dummy_Handler

  .weak FLEXSPI2_IRQHandler
  .thumb_set FLEXSPI2_IRQHandler,Dummy_Handler

  .weak SEMC_IRQHandler
  .thumb_set SEMC_IRQHandler,Dummy_Handler

  .weak USDHC1_IRQHandler
  .thumb_set USDHC1_IRQHandler,Dummy_Handler

  .weak USDHC2_IRQHandler
  .thumb_set USDHC2_IRQHandler,Dummy_Handler

  .weak USB_OTG2_IRQHandler
  .thumb_set USB_OTG2_IRQHandler,Dummy_Handler

  .weak USB_OTG1_IRQHandler
  .thumb_set USB_OTG1_IRQHandler,Dummy_Handler

  .weak ENET_IRQHandler
  .thumb_set ENET_IRQHandler,Dummy_Handler

  .weak ENET_1588_Timer_IRQHandler
  .thumb_set ENET_1588_Timer_IRQHandler,Dummy_Handler
  
  .weak XBAR1_IRQ_0_1_IRQHandler
  .thumb_set XBAR1_IRQ_0_1_IRQHandler,Dummy_Handler
  
  .weak XBAR1_IRQ_2_3_IRQHandler
  .thumb_set XBAR1_IRQ_2_3_IRQHandler,Dummy_Handler

  .weak ADC_ETC_IRQ0_IRQHandler
  .thumb_set ADC_ETC_IRQ0_IRQHandler,Dummy_Handler

  .weak ADC_ETC_IRQ1_IRQHandler
  .thumb_set ADC_ETC_IRQ1_IRQHandler,Dummy_Handler

  .weak ADC_ETC_IRQ2_IRQHandler
  .thumb_set ADC_ETC_IRQ2_IRQHandler,Dummy_Handler

  .weak ADC_ETC_IRQ3_IRQHandler
  .thumb_set ADC_ETC_IRQ3_IRQHandler,Dummy_Handler

  .weak ADC_ETC_ERROR_IRQHandler
  .thumb_set ADC_ETC_ERROR_IRQHandler,Dummy_Handler

  .weak PIT1_IRQHandler
  .thumb_set PIT1_IRQHandler,Dummy_Handler

  .weak PIT2_IRQHandler
  .thumb_set PIT2_IRQHandler,Dummy_Handler

  .weak ACMP1_IRQHandler
  .thumb_set ACMP1_IRQHandler,Dummy_Handler

  .weak ACMP2_IRQHandler
  .thumb_set ACMP2_IRQHandler,Dummy_Handler

  .weak ACMP3_IRQHandler
  .thumb_set ACMP3_IRQHandler,Dummy_Handler

  .weak ACMP4_IRQHandler
  .thumb_set ACMP4_IRQHandler,Dummy_Handler

  .weak ENC1_IRQHandler
  .thumb_set ENC1_IRQHandler,Dummy_Handler

  .weak ENC2_IRQHandler
  .thumb_set ENC2_IRQHandler,Dummy_Handler

  .weak ENC3_IRQHandler
  .thumb_set ENC3_IRQHandler,Dummy_Handler

  .weak ENC4_IRQHandler
  .thumb_set ENC4_IRQHandler,Dummy_Handler

  .weak TMR1_IRQHandler
  .thumb_set TMR1_IRQHandler,Dummy_Handler

  .weak TMR2_IRQHandler
  .thumb_set TMR2_IRQHandler,Dummy_Handler

  .weak TMR3_IRQHandler
  .thumb_set TMR3_IRQHandler,Dummy_Handler

  .weak TMR4_IRQHandler
  .thumb_set TMR4_IRQHandler,Dummy_Handler

  .weak SEMA4_CP0_IRQHandler
  .thumb_set SEMA4_CP0_IRQHandler,Dummy_Handler
  
  .weak SEMA4_CP1_IRQHandler
  .thumb_set SEMA4_CP1_IRQHandler,Dummy_Handler 
  
  .weak PWM2_0_IRQHandler
  .thumb_set PWM2_0_IRQHandler,Dummy_Handler

  .weak PWM2_1_IRQHandler
  .thumb_set PWM2_1_IRQHandler,Dummy_Handler

  .weak PWM2_2_IRQHandler
  .thumb_set PWM2_2_IRQHandler,Dummy_Handler

  .weak PWM2_3_IRQHandler
  .thumb_set PWM2_3_IRQHandler,Dummy_Handler

  .weak PWM2_FAULT_IRQHandler
  .thumb_set PWM2_FAULT_IRQHandler,Dummy_Handler

  .weak PWM3_0_IRQHandler
  .thumb_set PWM3_0_IRQHandler,Dummy_Handler

  .weak PWM3_1_IRQHandler
  .thumb_set PWM3_1_IRQHandler,Dummy_Handler

  .weak PWM3_2_IRQHandler
  .thumb_set PWM3_2_IRQHandler,Dummy_Handler

  .weak PWM3_3_IRQHandler
  .thumb_set PWM3_3_IRQHandler,Dummy_Handler

  .weak PWM3_FAULT_IRQHandler
  .thumb_set PWM3_FAULT_IRQHandler,Dummy_Handler

  .weak PWM4_0_IRQHandler
  .thumb_set PWM4_0_IRQHandler,Dummy_Handler

  .weak PWM4_1_IRQHandler
  .thumb_set PWM4_1_IRQHandler,Dummy_Handler

  .weak PWM4_2_IRQHandler
  .thumb_set PWM4_2_IRQHandler,Dummy_Handler

  .weak PWM4_3_IRQHandler
  .thumb_set PWM4_3_IRQHandler,Dummy_Handler

  .weak PWM4_FAULT_IRQHandler
  .thumb_set PWM4_FAULT_IRQHandler,Dummy_Handler
  
  .weak PDM_EVENT_IRQHandler
  .thumb_set PDM_EVENT_IRQHandler,Dummy_Handler
  
  .weak PDM_ERROR_IRQHandler
  .thumb_set PDM_ERROR_IRQHandler,Dummy_Handler
  
  .weak EMVSIM1_IRQHandler
  .thumb_set EMVSIM1_IRQHandler,Dummy_Handler

  .weak EMVSIM2_IRQHandler
  .thumb_set EMVSIM2_IRQHandler,Dummy_Handler

  .weak MECC1_INIT_IRQHandler
  .thumb_set MECC1_INIT_IRQHandler,Dummy_Handler

  .weak MECC1_FATAL_INIT_IRQHandler
  .thumb_set MECC1_FATAL_INIT_IRQHandler,Dummy_Handler

  .weak MECC2_INIT_IRQHandler
  .thumb_set MECC2_INIT_IRQHandler,Dummy_Handler

  .weak MECC2_FATAL_INIT_IRQHandler
  .thumb_set MECC2_FATAL_INIT_IRQHandler,Dummy_Handler

  .weak XECC_FLEXSPI1_INIT_IRQHandler
  .thumb_set XECC_FLEXSPI1_INIT_IRQHandler,Dummy_Handler
  
  .weak XECC_FLEXSPI1_FATAL_INIT_IRQHandler
  .thumb_set XECC_FLEXSPI1_FATAL_INIT_IRQHandler,Dummy_Handler
  
  .weak XECC_FLEXSPI2_INIT_IRQHandler
  .thumb_set XECC_FLEXSPI2_INIT_IRQHandler,Dummy_Handler
  
  .weak XECC_FLEXSPI2_FATAL_INIT_IRQHandler
  .thumb_set XECC_FLEXSPI2_FATAL_INIT_IRQHandler,Dummy_Handler
  
  .weak XECC_SEMC_INIT_IRQHandler
  .thumb_set XECC_SEMC_INIT_IRQHandler,Dummy_Handler
  
  .weak XECC_SEMC_FATAL_INIT_IRQHandler
  .thumb_set XECC_SEMC_FATAL_INIT_IRQHandler,Dummy_Handler
  
#else

  .thumb_func
  .weak DMA0_DMA16_IRQHandler
DMA0_DMA16_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA1_DMA17_IRQHandler
DMA1_DMA17_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA2_DMA18_IRQHandler
DMA2_DMA18_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA3_DMA19_IRQHandler
DMA3_DMA19_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA4_DMA20_IRQHandler
DMA4_DMA20_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA5_DMA21_IRQHandler
DMA5_DMA21_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA6_DMA22_IRQHandler
DMA6_DMA22_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA7_DMA23_IRQHandler
DMA7_DMA23_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA8_DMA24_IRQHandler
DMA8_DMA24_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA9_DMA25_IRQHandler
DMA9_DMA25_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA10_DMA26_IRQHandler
DMA10_DMA26_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA11_DMA27_IRQHandler
DMA11_DMA27_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA12_DMA28_IRQHandler
DMA12_DMA28_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA13_DMA29_IRQHandler
DMA13_DMA29_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA14_DMA30_IRQHandler
DMA14_DMA30_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA15_DMA31_IRQHandler
DMA15_DMA31_IRQHandler:
  b .
  
  .thumb_func
  .weak DMA_ERROR_IRQHandler
DMA_ERROR_IRQHandler:
  b .
  
  .thumb_func
  .weak CTI0_ERROR_IRQHandler
CTI0_ERROR_IRQHandler:
  b .
  
  .thumb_func
  .weak CTI1_ERROR_IRQHandler
CTI1_ERROR_IRQHandler:
  b .
  
  .thumb_func
  .weak CORE_IRQHandler
CORE_IRQHandler:
  b .

  .thumb_func
  .weak LPUART1_IRQHandler
LPUART1_IRQHandler:
  b .

  .thumb_func
  .weak LPUART2_IRQHandler
LPUART2_IRQHandler:
  b .

  .thumb_func
  .weak LPUART3_IRQHandler
LPUART3_IRQHandler:
  b .

  .thumb_func
  .weak LPUART4_IRQHandler
LPUART4_IRQHandler:
  b .

  .thumb_func
  .weak LPUART5_IRQHandler
LPUART5_IRQHandler:
  b .

  .thumb_func
  .weak LPUART6_IRQHandler
LPUART6_IRQHandler:
  b .

  .thumb_func
  .weak LPUART7_IRQHandler
LPUART7_IRQHandler:
  b .

  .thumb_func
  .weak LPUART8_IRQHandler
LPUART8_IRQHandler:
  b .

  .thumb_func
  .weak LPUART9_IRQHandler
LPUART9_IRQHandler:
  b .

  .thumb_func
  .weak LPUART10_IRQHandler
LPUART10_IRQHandler:
  b .

  .thumb_func
  .weak LPUART11_IRQHandler
LPUART11_IRQHandler:
  b .

  .thumb_func
  .weak LPUART12_IRQHandler
LPUART12_IRQHandler:
  b .

  .thumb_func
  .weak LPI2C1_IRQHandler
LPI2C1_IRQHandler:
  b .

  .thumb_func
  .weak LPI2C2_IRQHandler
LPI2C2_IRQHandler:
  b .

  .thumb_func
  .weak LPI2C3_IRQHandler
LPI2C3_IRQHandler:
  b .

  .thumb_func
  .weak LPI2C4_IRQHandler
LPI2C4_IRQHandler:
  b .

  .thumb_func
  .weak LPI2C5_IRQHandler
LPI2C5_IRQHandler:
  b .

  .thumb_func
  .weak LPI2C6_IRQHandler
LPI2C6_IRQHandler:
  b .

  .thumb_func
  .weak LPSPI1_IRQHandler
LPSPI1_IRQHandler:
  b .

  .thumb_func
  .weak LPSPI2_IRQHandler
LPSPI2_IRQHandler:
  b .

  .thumb_func
  .weak LPSPI3_IRQHandler
LPSPI3_IRQHandler:
  b .

  .thumb_func
  .weak LPSPI4_IRQHandler
LPSPI4_IRQHandler:
  b .

  .thumb_func
  .weak LPSPI5_IRQHandler
LPSPI5_IRQHandler:
  b .

  .thumb_func
  .weak LPSPI6_IRQHandler
LPSPI6_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_IRQHandler
CAN1_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_ERROR_IRQHandler
CAN1_ERROR_IRQHandler:
  b .

  .thumb_func
  .weak CAN2_IRQHandler
CAN2_IRQHandler:
  b .

  .thumb_func
  .weak CAN2_ERROR_IRQHandler
CAN2_ERROR_IRQHandler:
  b .

  .thumb_func
  .weak CAN3_IRQHandler
CAN3_IRQHandler:
  b .

  .thumb_func
  .weak CAN3_ERROR_IRQHandler
CAN3_ERROR_IRQHandler:
  b .
  
  .thumb_func
  .weak FLEXRAM_IRQHandler
FLEXRAM_IRQHandler:
  b .

  .thumb_func
  .weak KPP_IRQHandler
KPP_IRQHandler:
  b .
  
  .thumb_func
  .weak GPR_IRQ_IRQHandler
GPR_IRQ_IRQHandler:
  b .
  
  .thumb_func
  .weak LCDIF1_IRQHandler
LCDIF1_IRQHandler:
  b .
  
  .thumb_func
  .weak LCDIF2_IRQHandler
LCDIF2_IRQHandler:
  b .

  .thumb_func
  .weak CSI_IRQHandler
CSI_IRQHandler:
  b .

  .thumb_func
  .weak PXP_IRQHandler
PXP_IRQHandler:
  b .
  
  .thumb_func
  .weak MIPI_CSI_IRQHandler
MIPI_CSI_IRQHandler:
  b .
  
  .thumb_func
  .weak MIPI_DSI_IRQHandler
MIPI_DSI_IRQHandler:
  b .
  
  .thumb_func
  .weak GPU2D_IRQHandler
GPU2D_IRQHandler:
  b .
  
  .thumb_func
  .weak GPIO6_Combined_0_15_IRQHandler
GPIO6_Combined_0_15_IRQHandler:
  b .

  .thumb_func
  .weak GPIO6_Combined_16_31_IRQHandler
GPIO6_Combined_16_31_IRQHandler:
  b .

  .thumb_func
  .weak DAC_IRQHandler
DAC_IRQHandler:
  b .

  .thumb_func
  .weak WDOG2_IRQHandler
WDOG2_IRQHandler:
  b .
  
  .thumb_func
  .weak SNVS_HP_WRAPPER_IRQHandler
SNVS_HP_WRAPPER_IRQHandler:
  b .
  
  .thumb_func
  .weak SNVS_HP_WRAPPER_TZ_IRQHandler
SNVS_HP_WRAPPER_TZ_IRQHandler:
  b .
  
  .thumb_func
  .weak SNVS_LP_WRAPPER_IRQHandler
SNVS_LP_WRAPPER_IRQHandler:
  b .
  
  .thumb_func
  .weak SDIO_IRQHandler
SDIO_IRQHandler:
  b .

  .thumb_func
  .weak SAI1_IRQHandler
SAI1_IRQHandler:
  b .

  .thumb_func
  .weak SAI2_IRQHandler
SAI2_IRQHandler:
  b .

  .thumb_func
  .weak SAI3_RX_IRQHandler
SAI3_RX_IRQHandler:
  b .

  .thumb_func
  .weak SAI3_TX_IRQHandler
SAI3_TX_IRQHandler:
  b .

  .thumb_func
  .weak SAI4_RX_IRQHandler
SAI4_RX_IRQHandler:
  b .

  .thumb_func
  .weak SAI4_TX_IRQHandler
SAI4_TX_IRQHandler:
  b .

  .thumb_func
  .weak SPDIF_IRQHandler
SPDIF_IRQHandler:
  b .
  
  .thumb_func
  .weak ANATOP_TEMP_INT_IRQHandler
ANATOP_TEMP_INT_IRQHandler:
  b .
  
  .thumb_func
  .weak ANATOP_TEMP_LOW_HIGH_IRQHandler
ANATOP_TEMP_LOW_HIGH_IRQHandler:
  b .
  
  .thumb_func
  .weak ANATOP_TEMP_PANIC_IRQHandler
ANATOP_TEMP_PANIC_IRQHandler:
  b .
  
  .thumb_func
  .weak ANATOP_LP8_BROWNOUT_IRQHandler
ANATOP_LP8_BROWNOUT_IRQHandler:
  b .
  
  .thumb_func
  .weak ANATOP_LP0_BROWNOUT_IRQHandler
ANATOP_LP0_BROWNOUT_IRQHandler:
  b .
  
  .thumb_func
  .weak ADC1_IRQHandler
ADC1_IRQHandler:
  b .
  
  .thumb_func
  .weak ADC2_IRQHandler
ADC2_IRQHandler:
  b .
  
  .thumb_func
  .weak USBPHY1_IRQHandler
USBPHY1_IRQHandler:
  b .

  .thumb_func
  .weak USBPHY2_IRQHandler
USBPHY2_IRQHandler:
  b .

  .thumb_func
  .weak RDC_IRQHandler
RDC_IRQHandler:
  b .

  .thumb_func
  .weak GPIO13_Combined_0_31_IRQHandler
GPIO13_Combined_0_31_IRQHandler:
  b .

  .thumb_func
  .weak SFA_IRQHandler
SFA_IRQHandler:
  b .
  
  .thumb_func
  .weak DCIC1_IRQHandler
DCIC1_IRQHandler:
  b .
  
  .thumb_func
  .weak DCIC2_IRQHandler
DCIC2_IRQHandler:
  b .

  .thumb_func
  .weak ASRC_IRQHandler
ASRC_IRQHandler:
  b .

  .thumb_func
  .weak FLEXRAM_ECC_IRQHandler
FLEXRAM_ECC_IRQHandler:
  b .

  .thumb_func
  .weak CM7_GPIO2_3_IRQHandler
CM7_GPIO2_3_IRQHandler:
  b .

  .thumb_func
  .weak GPIO1_Combined_0_15_IRQHandler
GPIO1_Combined_0_15_IRQHandler:
  b .

  .thumb_func
  .weak GPIO1_Combined_16_31_IRQHandler
GPIO1_Combined_16_31_IRQHandler:
  b .

  .thumb_func
  .weak GPIO2_Combined_0_15_IRQHandler
GPIO2_Combined_0_15_IRQHandler:
  b .

  .thumb_func
  .weak GPIO2_Combined_16_31_IRQHandler
GPIO2_Combined_16_31_IRQHandler:
  b .

  .thumb_func
  .weak GPIO3_Combined_0_15_IRQHandler
GPIO3_Combined_0_15_IRQHandler:
  b .

  .thumb_func
  .weak GPIO3_Combined_16_31_IRQHandler
GPIO3_Combined_16_31_IRQHandler:
  b .

  .thumb_func
  .weak GPIO4_Combined_0_15_IRQHandler
GPIO4_Combined_0_15_IRQHandler:
  b .

  .thumb_func
  .weak GPIO4_Combined_16_31_IRQHandler
GPIO4_Combined_16_31_IRQHandler:
  b .

  .thumb_func
  .weak GPIO5_Combined_0_15_IRQHandler
GPIO5_Combined_0_15_IRQHandler:
  b .

  .thumb_func
  .weak GPIO5_Combined_16_31_IRQHandler
GPIO5_Combined_16_31_IRQHandler:
  b .

  .thumb_func
  .weak FLEXIO1_IRQHandler
FLEXIO1_IRQHandler:
  b .

  .thumb_func
  .weak FLEXIO2_IRQHandler
FLEXIO2_IRQHandler:
  b .

  .thumb_func
  .weak WDOG1_IRQHandler
WDOG1_IRQHandler:
  b .

  .thumb_func
  .weak RTWDOG3_IRQHandler
RTWDOG3_IRQHandler:
  b .

  .thumb_func
  .weak EWM_IRQHandler
EWM_IRQHandler:
  b .

  .thumb_func
  .weak OCOTP_READ_FUSE_ERROR_IRQHandler
OCOTP_READ_FUSE_ERROR_IRQHandler:
  b .

  .thumb_func
  .weak OCOTP_READ_DONE_ERROR_IRQHandler
OCOTP_READ_DONE_ERROR_IRQHandler:
  b .

  .thumb_func
  .weak MUA_IRQHandler
MUA_IRQHandler:
  b .

  .thumb_func
  .weak GPT1_IRQHandler
GPT1_IRQHandler:
  b .

  .thumb_func
  .weak GPT2_IRQHandler
GPT2_IRQHandler:
  b .

  .thumb_func
  .weak GPT3_IRQHandler
GPT3_IRQHandler:
  b .

  .thumb_func
  .weak GPT4_IRQHandler
GPT4_IRQHandler:
  b .

  .thumb_func
  .weak GPT5_IRQHandler
GPT5_IRQHandler:
  b .

  .thumb_func
  .weak GPT6_IRQHandler
GPT6_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_0_IRQHandler
PWM1_0_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_1_IRQHandler
PWM1_1_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_2_IRQHandler
PWM1_2_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_3_IRQHandler
PWM1_3_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_FAULT_IRQHandler
PWM1_FAULT_IRQHandler:
  b .

  .thumb_func
  .weak FLEXSPI1_IRQHandler
FLEXSPI1_IRQHandler:
  b .

  .thumb_func
  .weak FLEXSPI2_IRQHandler
FLEXSPI2_IRQHandler:
  b .

  .thumb_func
  .weak SEMC_IRQHandler
SEMC_IRQHandler:
  b .

  .thumb_func
  .weak USDHC1_IRQHandler
USDHC1_IRQHandler:
  b .

  .thumb_func
  .weak USDHC2_IRQHandler
USDHC2_IRQHandler:
  b .

  .thumb_func
  .weak USB_OTG2_IRQHandler
USB_OTG2_IRQHandler:
  b .

  .thumb_func
  .weak USB_OTG1_IRQHandler
USB_OTG1_IRQHandler:
  b .

  .thumb_func
  .weak ENET_IRQHandler
ENET_IRQHandler:
  b .

  .thumb_func
  .weak ENET_1588_Timer_IRQHandler
ENET_1588_Timer_IRQHandler:
  b .
  
  .thumb_func
  .weak XBAR1_IRQ_0_1_IRQHandler
XBAR1_IRQ_0_1_IRQHandler:
  b .
  
  .thumb_func
  .weak XBAR1_IRQ_2_3_IRQHandler
XBAR1_IRQ_2_3_IRQHandler:
  b .

  .thumb_func
  .weak ADC_ETC_IRQ0_IRQHandler
ADC_ETC_IRQ0_IRQHandler:
  b .

  .thumb_func
  .weak ADC_ETC_IRQ1_IRQHandler
ADC_ETC_IRQ1_IRQHandler:
  b .

  .thumb_func
  .weak ADC_ETC_IRQ2_IRQHandler
ADC_ETC_IRQ2_IRQHandler:
  b .

  .thumb_func
  .weak ADC_ETC_IRQ3_IRQHandler
ADC_ETC_IRQ3_IRQHandler:
  b .

  .thumb_func
  .weak ADC_ETC_ERROR_IRQHandler
ADC_ETC_ERROR_IRQHandler:
  b .

  .thumb_func
  .weak PIT1_IRQHandler
PIT1_IRQHandler:
  b .

  .thumb_func
  .weak PIT2_IRQHandler
PIT2_IRQHandler:
  b .

  .thumb_func
  .weak ACMP1_IRQHandler
ACMP1_IRQHandler:
  b .

  .thumb_func
  .weak ACMP2_IRQHandler
ACMP2_IRQHandler:
  b .

  .thumb_func
  .weak ACMP3_IRQHandler
ACMP3_IRQHandler:
  b .

  .thumb_func
  .weak ACMP4_IRQHandler
ACMP4_IRQHandler:
  b .

  .thumb_func
  .weak ENC1_IRQHandler
ENC1_IRQHandler:
  b .

  .thumb_func
  .weak ENC2_IRQHandler
ENC2_IRQHandler:
  b .

  .thumb_func
  .weak ENC3_IRQHandler
ENC3_IRQHandler:
  b .

  .thumb_func
  .weak ENC4_IRQHandler
ENC4_IRQHandler:
  b .

  .thumb_func
  .weak TMR1_IRQHandler
TMR1_IRQHandler:
  b .

  .thumb_func
  .weak TMR2_IRQHandler
TMR2_IRQHandler:
  b .

  .thumb_func
  .weak TMR3_IRQHandler
TMR3_IRQHandler:
  b .

  .thumb_func
  .weak TMR4_IRQHandler
TMR4_IRQHandler:
  b .
  
  .thumb_func
  .weak SEMA4_CP0_IRQHandler
SEMA4_CP0_IRQHandler:
  b .
  
  .thumb_func
  .weak SEMA4_CP1_IRQHandler
SEMA4_CP1_IRQHandler:
  b .
  
  .thumb_func
  .weak PWM2_0_IRQHandler
PWM2_0_IRQHandler:
  b .

  .thumb_func
  .weak PWM2_1_IRQHandler
PWM2_1_IRQHandler:
  b .

  .thumb_func
  .weak PWM2_2_IRQHandler
PWM2_2_IRQHandler:
  b .

  .thumb_func
  .weak PWM2_3_IRQHandler
PWM2_3_IRQHandler:
  b .

  .thumb_func
  .weak PWM2_FAULT_IRQHandler
PWM2_FAULT_IRQHandler:
  b .

  .thumb_func
  .weak PWM3_0_IRQHandler
PWM3_0_IRQHandler:
  b .

  .thumb_func
  .weak PWM3_1_IRQHandler
PWM3_1_IRQHandler:
  b .

  .thumb_func
  .weak PWM3_2_IRQHandler
PWM3_2_IRQHandler:
  b .

  .thumb_func
  .weak PWM3_3_IRQHandler
PWM3_3_IRQHandler:
  b .

  .thumb_func
  .weak PWM3_FAULT_IRQHandler
PWM3_FAULT_IRQHandler:
  b .

  .thumb_func
  .weak PWM4_0_IRQHandler
PWM4_0_IRQHandler:
  b .

  .thumb_func
  .weak PWM4_1_IRQHandler
PWM4_1_IRQHandler:
  b .

  .thumb_func
  .weak PWM4_2_IRQHandler
PWM4_2_IRQHandler:
  b .

  .thumb_func
  .weak PWM4_3_IRQHandler
PWM4_3_IRQHandler:
  b .

  .thumb_func
  .weak PWM4_FAULT_IRQHandler
PWM4_FAULT_IRQHandler:
  b .
  
  .thumb_func
  .weak PDM_EVENT_IRQHandler
PDM_EVENT_IRQHandler:
  b .
  
  .thumb_func
  .weak PDM_ERROR_IRQHandler
PDM_ERROR_IRQHandler:
  b .
  
  .thumb_func
  .weak EMVSIM1_IRQHandler
EMVSIM1_IRQHandler:
  b .

  .thumb_func
  .weak EMVSIM2_IRQHandler
EMVSIM2_IRQHandler:
  b .

  .thumb_func
  .weak MECC1_INIT_IRQHandler
MECC1_INIT_IRQHandler:
  b .

  .thumb_func
  .weak MECC1_FATAL_INIT_IRQHandler
MECC1_FATAL_INIT_IRQHandler:
  b .

  .thumb_func
  .weak MECC2_INIT_IRQHandler
MECC2_INIT_IRQHandler:
  b .

  .thumb_func
  .weak MECC2_FATAL_INIT_IRQHandler
MECC2_FATAL_INIT_IRQHandler:
  b .

  .thumb_func
  .weak XECC_FLEXSPI1_INIT_IRQHandler
XECC_FLEXSPI1_INIT_IRQHandler:
  b .
  
  .thumb_func
  .weak XECC_FLEXSPI1_FATAL_INIT_IRQHandler
XECC_FLEXSPI1_FATAL_INIT_IRQHandler:
  b .
  
  .thumb_func
  .weak XECC_FLEXSPI2_INIT_IRQHandler
XECC_FLEXSPI2_INIT_IRQHandler:
  b .
  
  .thumb_func
  .weak XECC_FLEXSPI2_FATAL_INIT_IRQHandler
XECC_FLEXSPI2_FATAL_INIT_IRQHandler:
  b .
  
  .thumb_func
  .weak XECC_SEMC_INIT_IRQHandler
XECC_SEMC_INIT_IRQHandler:
  b .
  
  .thumb_func
  .weak XECC_SEMC_FATAL_INIT_IRQHandler
XECC_SEMC_FATAL_INIT_IRQHandler:
  b .
  
#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .balign 1024
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word DMA0_DMA16_IRQHandler 
  .word DMA1_DMA17_IRQHandler 
  .word DMA2_DMA18_IRQHandler 
  .word DMA3_DMA19_IRQHandler 
  .word DMA4_DMA20_IRQHandler 
  .word DMA5_DMA21_IRQHandler 
  .word DMA6_DMA22_IRQHandler 
  .word DMA7_DMA23_IRQHandler 
  .word DMA8_DMA24_IRQHandler 
  .word DMA9_DMA25_IRQHandler 
  .word DMA10_DMA26_IRQHandler
  .word DMA11_DMA27_IRQHandler
  .word DMA12_DMA28_IRQHandler
  .word DMA13_DMA29_IRQHandler
  .word DMA14_DMA30_IRQHandler
  .word DMA15_DMA31_IRQHandler
  .word DMA_ERROR_IRQHandler  
  .word CTI0_ERROR_IRQHandler
  .word CTI1_ERROR_IRQHandler 
  .word CORE_IRQHandler       
  .word LPUART1_IRQHandler
  .word LPUART2_IRQHandler
  .word LPUART3_IRQHandler
  .word LPUART4_IRQHandler
  .word LPUART5_IRQHandler
  .word LPUART6_IRQHandler
  .word LPUART7_IRQHandler
  .word LPUART8_IRQHandler
  .word LPUART9_IRQHandler
  .word LPUART10_IRQHandler
  .word LPUART11_IRQHandler
  .word LPUART12_IRQHandler
  .word LPI2C1_IRQHandler
  .word LPI2C2_IRQHandler
  .word LPI2C3_IRQHandler
  .word LPI2C4_IRQHandler
  .word LPI2C5_IRQHandler
  .word LPI2C6_IRQHandler
  .word LPSPI1_IRQHandler
  .word LPSPI2_IRQHandler
  .word LPSPI3_IRQHandler
  .word LPSPI4_IRQHandler
  .word LPSPI5_IRQHandler
  .word LPSPI6_IRQHandler
  .word CAN1_IRQHandler
  .word CAN1_ERROR_IRQHandler
  .word CAN2_IRQHandler
  .word CAN2_ERROR_IRQHandler
  .word CAN3_IRQHandler
  .word CAN3_ERROR_IRQHandler
  .word FLEXRAM_IRQHandler
  .word KPP_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word GPR_IRQ_IRQHandler              
  .word LCDIF1_IRQHandler               
  .word LCDIF2_IRQHandler               
  .word CSI_IRQHandler                  
  .word PXP_IRQHandler                  
  .word MIPI_CSI_IRQHandler             
  .word MIPI_DSI_IRQHandler             
  .word GPU2D_IRQHandler                
  .word GPIO6_Combined_0_15_IRQHandler 
  .word GPIO6_Combined_16_31_IRQHandler
  .word DAC_IRQHandler                  
  .word Dummy_Handler /* Reserved */
  .word WDOG2_IRQHandler
  .word SNVS_HP_WRAPPER_IRQHandler   
  .word SNVS_HP_WRAPPER_TZ_IRQHandler
  .word SNVS_LP_WRAPPER_IRQHandler   
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word SDIO_IRQHandler
  .word SAI1_IRQHandler
  .word SAI2_IRQHandler
  .word SAI3_RX_IRQHandler
  .word SAI3_TX_IRQHandler
  .word SAI4_RX_IRQHandler
  .word SAI4_TX_IRQHandler
  .word SPDIF_IRQHandler
  .word ANATOP_TEMP_INT_IRQHandler     
  .word ANATOP_TEMP_LOW_HIGH_IRQHandler
  .word ANATOP_TEMP_PANIC_IRQHandler   
  .word ANATOP_LP8_BROWNOUT_IRQHandler 
  .word ANATOP_LP0_BROWNOUT_IRQHandler 
  .word ADC1_IRQHandler
  .word ADC2_IRQHandler
  .word USBPHY1_IRQHandler
  .word USBPHY2_IRQHandler
  .word RDC_IRQHandler
  .word GPIO13_Combined_0_31_IRQHandler
  .word SFA_IRQHandler
  .word DCIC1_IRQHandler
  .word DCIC2_IRQHandler
  .word ASRC_IRQHandler
  .word FLEXRAM_ECC_IRQHandler
  .word CM7_GPIO2_3_IRQHandler
  .word GPIO1_Combined_0_15_IRQHandler
  .word GPIO1_Combined_16_31_IRQHandler
  .word GPIO2_Combined_0_15_IRQHandler
  .word GPIO2_Combined_16_31_IRQHandler
  .word GPIO3_Combined_0_15_IRQHandler
  .word GPIO3_Combined_16_31_IRQHandler
  .word GPIO4_Combined_0_15_IRQHandler
  .word GPIO4_Combined_16_31_IRQHandler
  .word GPIO5_Combined_0_15_IRQHandler
  .word GPIO5_Combined_16_31_IRQHandler
  .word FLEXIO1_IRQHandler
  .word FLEXIO2_IRQHandler
  .word WDOG1_IRQHandler
  .word RTWDOG3_IRQHandler
  .word EWM_IRQHandler
  .word OCOTP_READ_FUSE_ERROR_IRQHandler
  .word OCOTP_READ_DONE_ERROR_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word MUA_IRQHandler
  .word GPT1_IRQHandler
  .word GPT2_IRQHandler
  .word GPT3_IRQHandler
  .word GPT4_IRQHandler
  .word GPT5_IRQHandler
  .word GPT6_IRQHandler
  .word PWM1_0_IRQHandler
  .word PWM1_1_IRQHandler
  .word PWM1_2_IRQHandler
  .word PWM1_3_IRQHandler
  .word PWM1_FAULT_IRQHandler
  .word FLEXSPI1_IRQHandler
  .word FLEXSPI2_IRQHandler
  .word SEMC_IRQHandler
  .word USDHC1_IRQHandler
  .word USDHC2_IRQHandler
  .word USB_OTG2_IRQHandler
  .word USB_OTG1_IRQHandler
  .word ENET_IRQHandler
  .word ENET_1588_Timer_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word XBAR1_IRQ_0_1_IRQHandler
  .word XBAR1_IRQ_2_3_IRQHandler
  .word ADC_ETC_IRQ0_IRQHandler
  .word ADC_ETC_IRQ1_IRQHandler
  .word ADC_ETC_IRQ2_IRQHandler
  .word ADC_ETC_IRQ3_IRQHandler
  .word ADC_ETC_ERROR_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word PIT1_IRQHandler
  .word PIT2_IRQHandler
  .word ACMP1_IRQHandler
  .word ACMP2_IRQHandler
  .word ACMP3_IRQHandler
  .word ACMP4_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word ENC1_IRQHandler
  .word ENC2_IRQHandler
  .word ENC3_IRQHandler
  .word ENC4_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word TMR1_IRQHandler
  .word TMR2_IRQHandler
  .word TMR3_IRQHandler
  .word TMR4_IRQHandler
  .word SEMA4_CP0_IRQHandler
  .word SEMA4_CP1_IRQHandler
  .word PWM2_0_IRQHandler
  .word PWM2_1_IRQHandler
  .word PWM2_2_IRQHandler
  .word PWM2_3_IRQHandler
  .word PWM2_FAULT_IRQHandler
  .word PWM3_0_IRQHandler
  .word PWM3_1_IRQHandler
  .word PWM3_2_IRQHandler
  .word PWM3_3_IRQHandler
  .word PWM3_FAULT_IRQHandler
  .word PWM4_0_IRQHandler
  .word PWM4_1_IRQHandler
  .word PWM4_2_IRQHandler
  .word PWM4_3_IRQHandler
  .word PWM4_FAULT_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word PDM_EVENT_IRQHandler
  .word PDM_ERROR_IRQHandler
  .word EMVSIM1_IRQHandler
  .word EMVSIM2_IRQHandler
  .word MECC1_INIT_IRQHandler
  .word MECC1_FATAL_INIT_IRQHandler
  .word MECC2_INIT_IRQHandler
  .word MECC2_FATAL_INIT_IRQHandler
  .word XECC_FLEXSPI1_INIT_IRQHandler      
  .word XECC_FLEXSPI1_FATAL_INIT_IRQHandler
  .word XECC_FLEXSPI2_INIT_IRQHandler      
  .word XECC_FLEXSPI2_FATAL_INIT_IRQHandler
  .word XECC_SEMC_INIT_IRQHandler          
  .word XECC_SEMC_FATAL_INIT_IRQHandler    
  .word Dummy_Handler /* Reserved */             
  .word Dummy_Handler /* Reserved */             
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .balign 1024
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
