/**
 *******************************************************************************
 * @file    TMPM462.h
 * @brief   CMSIS Cortex-M4 Core Peripheral Access Layer Header File for the
 *          TOSHIBA 'TMPM462' Device Series
 * @version V2.0.2.3 (Tentative)
 * @date    2013/08/12
 * 
 * THE SOURCE CODE AND ITS RELATED DOCUMENTATION IS PROVIDED "AS IS". TOSHIBA
 * CORPORATION MAKES NO OTHER WARRANTY OF ANY KIND, WHETHER EXPRESS, IMPLIED OR,
 * STATUTORY AND DISCLAIMS ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * SATISFACTORY QUALITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * THE SOURCE CODE AND DOCUMENTATION MAY INCLUDE ERRORS. TOSHIBA CORPORATION
 * RESERVES THE RIGHT TO INCORPORATE MODIFICATIONS TO THE SOURCE CODE IN LATER
 * REVISIONS OF IT, AND TO MAKE IMPROVEMENTS OR CHANGES IN THE DOCUMENTATION OR
 * THE PRODUCTS OR TECHNOLOGIES DESCRIBED THEREIN AT ANY TIME.
 * 
 * TOSHIBA CORPORATION SHALL NOT BE LIABLE FOR ANY DIRECT, INDIRECT OR
 * CONSEQUENTIAL DAMAGE OR LIABILITY ARISING FROM YOUR USE OF THE SOURCE CODE OR
 * ANY DOCUMENTATION, INCLUDING BUT NOT LIMITED TO, LOST REVENUES, DATA OR
 * PROFITS, DAMAGES OF ANY SPECIAL, INCIDENTAL OR CONSEQUENTIAL NATURE, PUNITIVE
 * DAMAGES, LOSS OF PROPERTY OR LOSS OF PROFITS ARISING OUT OF OR IN CONNECTION
 * WITH THIS AGREEMENT, OR BEING UNUSABLE, EVEN IF ADVISED OF THE POSSIBILITY OR
 * PROBABILITY OF SUCH DAMAGES AND WHETHER A CLAIM FOR SUCH DAMAGE IS BASED UPON
 * WARRANTY, CONTRACT, TORT, NEGLIGENCE OR OTHERWISE.
 * 
 * (C)Copyright TOSHIBA CORPORATION 2013 All rights reserved
 *******************************************************************************
 */

/** @addtogroup TOSHIBA_TX04_MICROCONTROLLER
  * @{
  */
  
/** @addtogroup TMPM462
  * @{
  */

#ifndef __TMPM462_H__
#define __TMPM462_H__

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup Configuration_of_CMSIS
  * @{
  */

/** Interrupt Number Definition */
typedef enum IRQn
{
/******  Cortex-M4 Processor Exceptions Numbers ***************************************************************/
  NonMaskableInt_IRQn           = -14,       /*!< 2 Non Maskable Interrupt                                    */
  HardFault_IRQn                = -13,       /*!< 3 Cortex-M4 Hard Fault Interrupt                            */
  MemoryManagement_IRQn         = -12,       /*!< 4 Cortex-M4 Memory Management Interrupt                     */
  BusFault_IRQn                 = -11,       /*!< 5 Cortex-M4 Bus Fault Interrupt                             */
  UsageFault_IRQn               = -10,       /*!< 6 Cortex-M4 Usage Fault Interrupt                           */
  SVCall_IRQn                   = -5,        /*!< 11 Cortex-M4 SV Call Interrupt                              */
  DebugMonitor_IRQn             = -4,        /*!< 12 Cortex-M4 Debug Monitor Interrupt                        */
  PendSV_IRQn                   = -2,        /*!< 14 Cortex-M4 Pend SV Interrupt                              */
  SysTick_IRQn                  = -1,        /*!< 15 Cortex-M4 System Tick Interrupt                          */

/******  TMPM462 Specific Interrupt Numbers *******************************************************************/
  INT0_IRQn                     = 0,         /*!< Interrupt pin 0                                             */
  INT1_IRQn                     = 1,         /*!< Interrupt pin 1                                             */
  INT2_IRQn                     = 2,         /*!< Interrupt pin 2                                             */
  INT3_IRQn                     = 3,         /*!< Interrupt pin 3                                             */
  INT4_IRQn                     = 4,         /*!< Interrupt pin 4                                             */
  INT5_IRQn                     = 5,         /*!< Interrupt pin 5                                             */
  INT6_IRQn                     = 6,         /*!< Interrupt pin 6                                             */
  INT7_IRQn                     = 7,         /*!< Interrupt pin 7                                             */
  INT8_IRQn                     = 8,         /*!< Interrupt pin 8                                             */
  INT9_IRQn                     = 9,         /*!< Interrupt pin 9                                             */
  INTA_IRQn                     = 10,        /*!< Interrupt pin A                                             */
  INTB_IRQn                     = 11,        /*!< Interrupt pin B                                             */
  INTC_IRQn                     = 12,        /*!< Interrupt pin C                                             */
  INTD_IRQn                     = 13,        /*!< Interrupt pin D                                             */
  INTE_IRQn                     = 14,        /*!< Interrupt pin E                                             */
  INTF_IRQn                     = 15,        /*!< Interrupt pin F                                             */
  INTRX0_IRQn                   = 16,        /*!< Serial0 reception interrupt                                 */
  INTTX0_IRQn                   = 17,        /*!< Serial0 transmission interrupt                              */
  INTRX1_IRQn                   = 18,        /*!< Serial1 reception interrupt                                 */
  INTTX1_IRQn                   = 19,        /*!< Serial1 transmission interrupt                              */
  INTRX2_IRQn                   = 20,        /*!< Serial2 reception interrupt                                 */
  INTTX2_IRQn                   = 21,        /*!< Serial2 transmission interrupt                              */
  INTRX3_IRQn                   = 22,        /*!< Serial3 reception interrupt                                 */
  INTTX3_IRQn                   = 23,        /*!< Serial3 transmission interrupt                              */
  INTRX4_IRQn                   = 24,        /*!< Serial4 reception interrupt                                 */
  INTTX4_IRQn                   = 25,        /*!< Serial4 transmission interrupt                              */
  INTRX5_IRQn                   = 26,        /*!< Serial5 reception interrupt                                 */
  INTTX5_IRQn                   = 27,        /*!< Serial5 transmission interrupt                              */
  INTUART0_IRQn                 = 28,        /*!< Full UART0 transmission and reception interrupt             */
  INTUART1_IRQn                 = 29,        /*!< Full UART1 transmission and reception interrupt             */
  INTI2C0_IRQn                  = 30,        /*!< I2C0 transmission and reception interrupt                   */
  INTI2C1_IRQn                  = 31,        /*!< I2C1 transmission and reception interrupt                   */
  INTI2C2_IRQn                  = 32,        /*!< I2C2 transmission and reception interrupt                   */
  INTI2C3_IRQn                  = 33,        /*!< I2C3 transmission and reception interrupt                   */
  INTI2C4_IRQn                  = 34,        /*!< I2C4 transmission and reception interrupt                   */
  INTSSP0_IRQn                  = 35,        /*!< SSP(SPI) Serial interface 0 interrupt                       */
  INTSSP1_IRQn                  = 36,        /*!< SSP(SPI) Serial interface 1 interrupt                       */
  INTSSP2_IRQn                  = 37,        /*!< SSP(SPI) Serial interface 2 interrupt                       */
  INTCECRX_IRQn                 = 38,        /*!< CEC reception interrupt                                     */
  INTCECTX_IRQn                 = 39,        /*!< CEC transmission interrupt                                  */
  INTRMCRX0_IRQn                = 40,        /*!< Remote control rececptio 0 interrupt                        */
  INTADHP_IRQn                  = 41,        /*!< High Priority AD conversion interrupt                       */
  INTADM0_IRQn                  = 42,        /*!< AD conversion monitor interrupt 0                           */
  INTADM1_IRQn                  = 43,        /*!< AD conversion monitor interrupt 1                           */
  INTAD_IRQn                    = 44,        /*!< AD conversion interrupt                                     */
  INTRTC_IRQn                   = 45,        /*!< Real time clock interrupt                                   */
  INTMTEMG0_IRQn                = 46,        /*!< MPT0 EMG interrupt                                          */
  INTMTPTB00_IRQn               = 47,        /*!< MPT0 compare match0/overflow,IGBT cycle interrupt           */
  INTMTPTB01_IRQn               = 48,        /*!< MPT0 compare match1/overflow,IGBT cycle interrupt           */
  INTMTCAP00_IRQn               = 49,        /*!< MPT0 input capture0 interrupt                               */
  INTMTCAP01_IRQn               = 50,        /*!< MPT0 input capture1 interrupt                               */
  INTMTEMG1_IRQn                = 51,        /*!< MPT1 EMG interrupt                                          */
  INTMTPTB10_IRQn               = 52,        /*!< MPT1 compare match0/overflow,IGBT cycle interrupt           */
  INTMTPTB11_IRQn               = 53,        /*!< MPT1 compare match1/overflow,IGBT cycle interrupt           */
  INTMTCAP10_IRQn               = 54,        /*!< MPT1 input capture0 interrupt                               */
  INTMTCAP11_IRQn               = 55,        /*!< MPT1 input capture1 interrupt                               */
  INTTB0_IRQn                   = 56,        /*!< TMRB0 compare match detection interrupt                     */
  INTTB1_IRQn                   = 57,        /*!< TMRB1 compare match detection interrupt                     */
  INTTB2_IRQn                   = 58,        /*!< TMRB2 compare match detection interrupt                     */
  INTTB3_IRQn                   = 59,        /*!< TMRB3 compare match detection interrupt                     */
  INTTB4_IRQn                   = 60,        /*!< TMRB4 compare match detection interrupt                     */
  INTTB5_IRQn                   = 61,        /*!< TMRB5 compare match detection interrupt                     */
  INTTB6_IRQn                   = 62,        /*!< TMRB6 compare match detection interrupt                     */
  INTTB7_IRQn                   = 63,        /*!< TMRB7 compare match detection interrupt                     */
  INTTB8_IRQn                   = 64,        /*!< TMRB8 compare match detection interrupt                     */
  INTTB9_IRQn                   = 65,        /*!< TMRB9 compare match detection interrupt                     */
  INTTBA_IRQn                   = 66,        /*!< TMRBA compare match detection interrupt                     */
  INTTBB_IRQn                   = 67,        /*!< TMRBB compare match detection interrupt                     */
  INTTBC_IRQn                   = 68,        /*!< TMRBC compare match detection interrupt                     */
  INTTBD_IRQn                   = 69,        /*!< TMRBD compare match detection interrupt                     */
  INTTBE_IRQn                   = 70,        /*!< TMRBE compare match detection interrupt                     */
  INTTBF_IRQn                   = 71,        /*!< TMRBF compare match detection interrupt                     */
  INTCAP00_IRQn                 = 72,        /*!< TMRB0 input capture 0 interrupt                             */
  INTCAP01_IRQn                 = 73,        /*!< TMRB0 input capture 1 interrupt                             */
  INTCAP10_IRQn                 = 74,        /*!< TMRB1 input capture 0 interrupt                             */
  INTCAP11_IRQn                 = 75,        /*!< TMRB1 input capture 1 interrupt                             */
  INTCAP20_IRQn                 = 76,        /*!< TMRB2 input capture 0 interrupt                             */
  INTCAP21_IRQn                 = 77,        /*!< TMRB2 input capture 1 interrupt                             */
  INTCAP30_IRQn                 = 78,        /*!< TMRB3 input capture 0 interrupt                             */
  INTCAP31_IRQn                 = 79,        /*!< TMRB3 input capture 1 interrupt                             */
  INTCAP40_IRQn                 = 80,        /*!< TMRB4 input capture 0 interrupt                             */
  INTCAP41_IRQn                 = 81,        /*!< TMRB4 input capture 1 interrupt                             */
  INTCAP50_IRQn                 = 82,        /*!< TMRB5 input capture 0 interrupt                             */
  INTCAP51_IRQn                 = 83,        /*!< TMRB5 input capture 1 interrupt                             */
  INTCAP60_IRQn                 = 84,        /*!< TMRB6 input capture 0 interrupt                             */
  INTCAP61_IRQn                 = 85,        /*!< TMRB6 input capture 1 interrupt                             */
  INTCAP70_IRQn                 = 86,        /*!< TMRB7 input capture 0 interrupt                             */
  INTCAP71_IRQn                 = 87,        /*!< TMRB7 input capture 1 interrupt                             */
  INTCAP80_IRQn                 = 88,        /*!< TMRB8 input capture 0 interrupt                             */
  INTCAP81_IRQn                 = 89,        /*!< TMRB8 input capture 1 interrupt                             */
  INTCAP90_IRQn                 = 90,        /*!< TMRB9 input capture 0 interrupt                             */
  INTCAP91_IRQn                 = 91,        /*!< TMRB9 input capture 1 interrupt                             */
  INTCAPA0_IRQn                 = 92,        /*!< TMRBA input capture 0 interrupt                             */
  INTCAPA1_IRQn                 = 93,        /*!< TMRBA input capture 1 interrupt                             */
  INTCAPB0_IRQn                 = 94,        /*!< TMRBB input capture 0 interrupt                             */
  INTCAPB1_IRQn                 = 95,        /*!< TMRBB input capture 1 interrupt                             */
  INTCAPC0_IRQn                 = 96,        /*!< TMRBC input capture 0 interrupt                             */
  INTCAPC1_IRQn                 = 97,        /*!< TMRBC input capture 1 interrupt                             */
  INTCAPD0_IRQn                 = 98,        /*!< TMRBD input capture 0 interrupt                             */
  INTCAPD1_IRQn                 = 99,        /*!< TMRBD input capture 1 interrupt                             */
  INTCAPE0_IRQn                 = 100,       /*!< TMRBE input capture 0 interrupt                             */
  INTCAPE1_IRQn                 = 101,       /*!< TMRBE input capture 1 interrupt                             */
  INTCAPF0_IRQn                 = 102,       /*!< TMRBF input capture 0 interrupt                             */
  INTCAPF1_IRQn                 = 103,       /*!< TMRBF input capture 1 interrupt                             */
  INTDMAA_IRQn                  = 104,       /*!< DMAC transmission completion interrupt(unitA)               */
  INTDMAB_IRQn                  = 105,       /*!< DMAC transmission completion interrupt(unitB)               */
  INTDMAC_IRQn                  = 106,       /*!< DMAC transmission completion interrupt(unitC)               */
  INTDMAAERR_IRQn               = 107,       /*!< DMAC transmission error interrupt(unitA)                    */
  INTDMABERR_IRQn               = 108,       /*!< DMAC transmission error interrupt(unitB)                    */
  INTDMACERR_IRQn               = 109,       /*!< DMAC transmission error interrupt(unitC)                    */
  INTFLRDY_IRQn                 = 110,       /*!< Flash Ready interrupt                                       */
  INTRX6_IRQn                   = 111,       /*!< Serial6 reception interrupt                                 */
  INTTX6_IRQn                   = 112,       /*!< Serial6 transmission interrupt                              */
  INTRX7_IRQn                   = 113,       /*!< Serial7 reception interrupt                                 */
  INTTX7_IRQn                   = 114,       /*!< Serial7 transmission interrupt                              */
  INTRX8_IRQn                   = 115,       /*!< Serial8 reception interrupt                                 */
  INTTX8_IRQn                   = 116,       /*!< Serial8 transmission interrupt                              */
  INTRX9_IRQn                   = 117,       /*!< Serial9 reception interrupt                                 */
  INTTX9_IRQn                   = 118,       /*!< Serial9 transmission interrupt                              */
  INTRMCRX1_IRQn                = 119        /*!< Remote control rececptio 1 interrupt                        */
} IRQn_Type;

/** Processor and Core Peripheral Section */

/* Configuration of the Cortex-M4 Processor and Core Peripherals */
#define __CM4_REV              0x0001       /*!< Cortex-M4 Core Revision                           */
#define __MPU_PRESENT             0         /*!< MPU present or not                                */
#define __NVIC_PRIO_BITS          3         /*!< Number of Bits used for Priority Levels           */
#define __Vendor_SysTickConfig    0         /*!< Set to 1 if different SysTick Config is used      */
#define __FPU_PRESENT             1         /*!< FPU present or not                                */

/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                       /* Cortex-M4 processor and core peripherals            */
#include "system_TMPM462.h"                 /* TMPM462 System                                      */

/** @addtogroup Device_Peripheral_registers
  * @{
  */

/** Device Specific Peripheral registers structures */

/**
  * @brief Synchronous Serial Port
  */
typedef struct
{
  __IO uint32_t CR0;               /*!< SSP Control Register 0                       */
  __IO uint32_t CR1;               /*!< SSP Control Register 1                       */
  __IO uint32_t DR;                /*!< SSP Data Register                            */
  __I  uint32_t SR;                /*!< SSP Status Register                          */
  __IO uint32_t CPSR;              /*!< SSP Clock Prescaler Register                 */
  __IO uint32_t IMSC;              /*!< SSP Interrupt Mask Set and Clear Register    */
  __I  uint32_t RIS;               /*!< SSP Raw Interrupt Status Register            */
  __I  uint32_t MIS;               /*!< SSP Masked Interrupt Status Register         */
  __O  uint32_t ICR;               /*!< SSP Interrupt Clear Register                 */
  __IO uint32_t DMACR;             /*!< SSP DMA Control Register                     */
} TSB_SSP_TypeDef;

#if defined ( __CC_ARM   )           /* RealView Compiler */
#pragma anon_unions
#elif (defined (__ICCARM__))         /*  ICC Compiler     */
#pragma language=extended
#endif

/**
  * @brief UART
  */
typedef struct
{
  __IO uint32_t DR;                /*!< Data Register                                */
union {
  __I  uint32_t RSR;               /*!< Receive Status Register                      */
  __O  uint32_t ECR;               /*!< Error Clear Register                         */
  };
       uint32_t RESERVED0[4];
  __I  uint32_t FR;                /*!< Flag Register                                */
       uint32_t RESERVED1;
  __IO uint32_t ILPR;              /*!< IrDA low-power counter Register              */
  __IO uint32_t IBRD;              /*!< Integer Baud Rate Register                   */
  __IO uint32_t FBRD;              /*!< Fractional Baud Rate Register                */
  __IO uint32_t LCR_H;             /*!< Line Control Register                        */
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t IFLS;              /*!< Interrupt FIFO Level Select Register         */
  __IO uint32_t IMSC;              /*!< Interrupt Mask Set/Clear Register            */
  __I  uint32_t RIS;               /*!< Raw Interrupt Status Register                */
  __I  uint32_t MIS;               /*!< Masked Interrupt Status Register             */
  __O  uint32_t ICR;               /*!< Interrupt Clear Register                     */
  __IO uint32_t DMACR;             /*!< DMA Control Register                         */
} TSB_UART_TypeDef;

/**
  * @brief DMA Controller
  */
typedef struct
{
  __I  uint32_t STATUS;            /*!< DMA Status Register                          */
  __O  uint32_t CFG;               /*!< DMA Configuration Register                   */
  __IO uint32_t CTRLBASEPTR;       /*!< DMA Control Data Base Pointer Register       */
  __I  uint32_t ALTCTRLBASEPTR;    /*!< DMA Channel Alternate Control Data Base Pointer Register*/
       uint32_t RESERVED0;
  __O  uint32_t CHNLSWREQUEST;     /*!< DMA Channel Software Request Register        */
  __IO uint32_t CHNLUSEBURSTSET;   /*!< DMA Channel Useburst Set Register            */
  __O  uint32_t CHNLUSEBURSTCLR;   /*!< DMA Channel Useburst Clear Register          */
  __IO uint32_t CHNLREQMASKSET;    /*!< DMA Channel Request Mask Set Register        */
  __O  uint32_t CHNLREQMASKCLR;    /*!< DMA Channel Request Mask Clear Register      */
  __IO uint32_t CHNLENABLESET;     /*!< DMA Channel Enable Set Register              */
  __O  uint32_t CHNLENABLECLR;     /*!< DMA Channel Enable Clear Register            */
  __IO uint32_t CHNLPRIALTSET;     /*!< DMA Channel Primary-Alternate Set Register   */
  __O  uint32_t CHNLPRIALTCLR;     /*!< DMA Channel Primary-Alternate Clear Register */
  __IO uint32_t CHNLPRIORITYSET;   /*!< DMA Channel Priority Set Register            */
  __O  uint32_t CHNLPRIORITYCLR;   /*!< DMA Channel Priority Clear Register          */
       uint32_t RESERVED1[3];
  __IO uint32_t ERRCLR;            /*!< DMA Bus Error Clear Register                 */
} TSB_DMA_TypeDef;

/**
  * @brief DMA Interrupt Flag
  */
typedef struct
{
  __I  uint32_t FLGA;              /*!< DMA Flag Register A                          */
  __I  uint32_t FLGB;              /*!< DMA Flag Register B                          */
  __I  uint32_t FLGC;              /*!< DMA Flag Register C                          */
} TSB_DMAIF_TypeDef;

/**
  * @brief 12bit A/D Converter
  */
typedef struct
{
  __IO uint32_t CLK;               /*!< Conversion Clock Setting Register            */
  __O  uint32_t MOD0;              /*!< Mode Control Register0                       */
  __IO uint32_t MOD1;              /*!< Mode Control Register1                       */
  __IO uint32_t MOD2;              /*!< Mode Control Register2                       */
  __IO uint32_t MOD3;              /*!< Mode Control Register3                       */
  __IO uint32_t MOD4;              /*!< Mode Control Register4                       */
  __I  uint32_t MOD5;              /*!< Mode Control Register5                       */
  __O  uint32_t MOD6;              /*!< Mode Control Register6                       */
       uint32_t RESERVED0;
  __IO uint32_t CMPCR0;            /*!< Monitoring Interrupt Control Register0       */
  __IO uint32_t CMPCR1;            /*!< Monitoring Interrupt Control Register1       */
  __IO uint32_t CMP0;              /*!< Conversion Result Compare Register0          */
  __IO uint32_t CMP1;              /*!< Conversion Result Compare Register1          */
  __I  uint32_t REG00;             /*!< Conversion Result Store Register0            */
  __I  uint32_t REG01;             /*!< Conversion Result Store Register1            */
  __I  uint32_t REG02;             /*!< Conversion Result Store Register2            */
  __I  uint32_t REG03;             /*!< Conversion Result Store Register3            */
  __I  uint32_t REG04;             /*!< Conversion Result Store Register4            */
  __I  uint32_t REG05;             /*!< Conversion Result Store Register5            */
  __I  uint32_t REG06;             /*!< Conversion Result Store Register6            */
  __I  uint32_t REG07;             /*!< Conversion Result Store Register7            */
  __I  uint32_t REG08;             /*!< Conversion Result Store Register8            */
  __I  uint32_t REG09;             /*!< Conversion Result Store Register9            */
  __I  uint32_t REG10;             /*!< Conversion Result Store Register10           */
  __I  uint32_t REG11;             /*!< Conversion Result Store Register11           */
  __I  uint32_t REG12;             /*!< Conversion Result Store Register12           */
  __I  uint32_t REG13;             /*!< Conversion Result Store Register13           */
  __I  uint32_t REG14;             /*!< Conversion Result Store Register14           */
  __I  uint32_t REG15;             /*!< Conversion Result Store Register15           */
  __I  uint32_t REGSP;             /*!< Highest Priority Conversion Result Store Register*/
} TSB_AD_TypeDef;

/**
  * @brief External Bus Interface(EXB)
  */
typedef struct
{
  __IO uint32_t MOD;               /*!< External Bus Mode Register                   */
       uint32_t RESERVED0[3];
  __IO uint32_t AS0;               /*!< External Bus Base Address and CS Space setting Register 0*/
  __IO uint32_t AS1;               /*!< External Bus Base Address and CS Space setting Register 1 */
  __IO uint32_t AS2;               /*!< External Bus Base Address and CS Space setting Register 2*/
  __IO uint32_t AS3;               /*!< External Bus Base Address and CS Space setting Register 3*/
       uint32_t RESERVED1[8];
  __IO uint32_t CS0;               /*!< Chip Select and Wait Controller Register 0   */
  __IO uint32_t CS1;               /*!< Chip Select and Wait Controller Register 1   */
  __IO uint32_t CS2;               /*!< Chip Select and Wait Controller Register 2   */
  __IO uint32_t CS3;               /*!< Chip Select and Wait Controller Register 3   */
       uint32_t RESERVED2[4];
  __IO uint32_t CLKCTL;            /*!< Clock output controlRegister                 */
} TSB_EXB_TypeDef;

/**
  * @brief ADC infterface Register
  */
typedef struct
{
       uint32_t RESERVED0[4];
  __IO uint32_t TRGSEL;            /*!< Trigger Selection Register                   */
       uint32_t RESERVED1[3];
  __IO uint32_t EXCR;              /*!< Extencion channel setting Register           */
} TSB_ADILV_TypeDef;

/**
  * @brief I2C Bus Interface (I2C)
  */
typedef struct
{
  __IO uint32_t CR1;               /*!< I2C Control Register 1                       */
  __IO uint32_t DBR;               /*!< Data Buffer Register                         */
  __IO uint32_t AR;                /*!< Bus address Register                         */
union {
  __O  uint32_t CR2;               /*!<  Control Register 1                          */
  __I  uint32_t SR;                /*!< Status Register                              */
  };
  __IO uint32_t PRS;               /*!< Prescaler clcok setting Register             */
  __IO uint32_t IE;                /*!< Interrupt Enable Register                    */
  __IO uint32_t IR;                /*!< Interrupt Register                           */
} TSB_I2C_TypeDef;

/**
  * @brief 16-bit Timer/Event Counter (TB)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< TB Enable Register                           */
  __IO uint32_t RUN;               /*!< TB RUN Register                              */
  __IO uint32_t CR;                /*!< TB Control Register                          */
  __IO uint32_t MOD;               /*!< TB Mode Register                             */
  __IO uint32_t FFCR;              /*!< TB Flip-Flop Control Register                */
  __I  uint32_t ST;                /*!< TB Status Register                           */
  __IO uint32_t IM;                /*!< TB Interrupt Mask Register                   */
  __I  uint32_t UC;                /*!< TB Read Capture Register                     */
  __IO uint32_t RG0;               /*!< TB RG0 Timer Register                        */
  __IO uint32_t RG1;               /*!< TB RG1 Timer Register                        */
  __I  uint32_t CP0;               /*!< TB CP0 Capture Register                      */
  __I  uint32_t CP1;               /*!< TB CP1 Capture Register                      */
} TSB_TB_TypeDef;

/**
  * @brief Serial Channel (SC)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< SC Enable Register                           */
  __IO uint32_t BUF;               /*!< SC Buffer Register                           */
  __IO uint32_t CR;                /*!< SC Control Register                          */
  __IO uint32_t MOD0;              /*!< SC Mode Control Register 0                   */
  __IO uint32_t BRCR;              /*!< SC Baud Rate Generator Control Register      */
  __IO uint32_t BRADD;             /*!< SC Baud Rate Generator Control Register 2    */
  __IO uint32_t MOD1;              /*!< SC Mode Control Register 1                   */
  __IO uint32_t MOD2;              /*!< SC Mode Control Register 2                   */
  __IO uint32_t RFC;               /*!< SC RX FIFO Configuration Register            */
  __IO uint32_t TFC;               /*!< SC TX FIFO Configuration Register            */
  __I  uint32_t RST;               /*!< SC RX FIFO Status Register                   */
  __I  uint32_t TST;               /*!< SC TX FIFO Status Register                   */
  __IO uint32_t FCNF;              /*!< SC FIFO Configuration Register               */
} TSB_SC_TypeDef;

/**
  * @brief Port A
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port A Data Register                         */
  __IO uint32_t CR;                /*!< Port A Output Control Register               */
  __IO uint32_t FR1;               /*!< Port A Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port A Function Register 2                   */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;                /*!< Port A Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port A Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port A Input Control Register                */
} TSB_PA_TypeDef;

/**
  * @brief Port B
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port B Data Register                         */
  __IO uint32_t CR;                /*!< Port B Output Control Register               */
  __IO uint32_t FR1;               /*!< Port B Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port B Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port B Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port B Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port B Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port B Input Control Register                */
} TSB_PB_TypeDef;

/**
  * @brief Port C
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port C Data Register                         */
  __IO uint32_t CR;                /*!< Port C Output Control Register               */
  __IO uint32_t FR1;               /*!< Port C Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port C Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port C Function Register 3                   */
  __IO uint32_t FR4;               /*!< Port C Function Register 4                   */
       uint32_t RESERVED0[4];
  __IO uint32_t OD;                /*!< Port C Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port C Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port C Input Control Register                */
} TSB_PC_TypeDef;

/**
  * @brief Port D
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port D Data Register                         */
  __IO uint32_t CR;                /*!< Port D Output Control Register               */
  __IO uint32_t FR1;               /*!< Port D Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port D Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port D Function Register 3                   */
  __IO uint32_t FR4;               /*!< Port D Function Register 4                   */
  __IO uint32_t FR5;               /*!< Port D Function Register 5                   */
       uint32_t RESERVED0[3];
  __IO uint32_t OD;                /*!< Port D Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port D Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port D Input Control Register                */
} TSB_PD_TypeDef;

/**
  * @brief Port E
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port E Data Register                         */
  __IO uint32_t CR;                /*!< Port E Output Control Register               */
  __IO uint32_t FR1;               /*!< Port E Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port E Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port E Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port E Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port E Pull-up Control Register              */
  __IO uint32_t PDN;               /*!< Port E Pull-down Control Register            */
       uint32_t RESERVED1;
  __IO uint32_t IE;                /*!< Port E Input Control Register                */
} TSB_PE_TypeDef;

/**
  * @brief Port F
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port F Data Register                         */
  __IO uint32_t CR;                /*!< Port F Output Control Register               */
  __IO uint32_t FR1;               /*!< Port F Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port F Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port F Function Register 3                   */
  __IO uint32_t FR4;               /*!< Port F Function Register 4                   */
       uint32_t RESERVED0[4];
  __IO uint32_t OD;                /*!< Port F Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port E Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port F Input Control Register                */
} TSB_PF_TypeDef;

/**
  * @brief Port G
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port G Data Register                         */
  __IO uint32_t CR;                /*!< Port G Output Control Register               */
  __IO uint32_t FR1;               /*!< Port G Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port G Function Register 2                   */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;                /*!< Port G Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port G Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port G Input Control Register                */
} TSB_PG_TypeDef;

/**
  * @brief Port H
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port H Data Register                         */
  __IO uint32_t CR;                /*!< Port H Output Control Register               */
       uint32_t RESERVED0[9];
  __IO uint32_t PUP;               /*!< Port H Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port H Input Control Register                */
} TSB_PH_TypeDef;

/**
  * @brief Port J
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port J Data Register                         */
  __IO uint32_t CR;                /*!< Port J Output Control Register               */
  __IO uint32_t FR1;               /*!< Port J Function Register 1                   */
       uint32_t RESERVED0[8];
  __IO uint32_t PUP;               /*!< Port J Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port J Input Control Register                */
} TSB_PJ_TypeDef;

/**
  * @brief Port K
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port K Data Register                         */
  __IO uint32_t CR;                /*!< Port K Output Control Register               */
  __IO uint32_t FR1;               /*!< Port K Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port K Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port K Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port K Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port K Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port K Input Control Register                */
} TSB_PK_TypeDef;

/**
  * @brief Port L
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port L Data Register                         */
  __IO uint32_t CR;                /*!< Port L Output Control Register               */
  __IO uint32_t FR1;               /*!< Port L Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port L Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port L Function Register 3                   */
  __IO uint32_t FR4;               /*!< Port L Function Register 4                   */
       uint32_t RESERVED0[4];
  __IO uint32_t OD;                /*!< Port L Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port L Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port L Input Control Register                */
} TSB_PL_TypeDef;

/**
  * @brief Port M
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port M Data Register                         */
  __IO uint32_t CR;                /*!< Port M Output Control Register               */
  __IO uint32_t FR1;               /*!< Port M Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port M Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port M Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port M Open Drain Register                   */
  __IO uint32_t PUP;               /*!< Port M Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port M Input Control Register                */
} TSB_PM_TypeDef;

/**
  * @brief Port N
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port N Data Register                         */
  __IO uint32_t CR;                /*!< Port N Output Control Register               */
  __IO uint32_t FR1;               /*!< Port N Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port N Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port N Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port N Open Drain Register                   */
  __IO uint32_t PUP;               /*!< Port N Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port N Input Control Register                */
} TSB_PN_TypeDef;

/**
  * @brief 16-bit Multi-Purpose Timer (MPT-TMR/IGBT)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< MPT Enable Register                          */
  __IO uint32_t RUN;               /*!< MPT RUN Register                             */
  __IO uint32_t TBCR;              /*!< MPT Control Register                         */
  __IO uint32_t TBMOD;             /*!< MPT Mode Register                            */
  __IO uint32_t TBFFCR;            /*!< MPT Flip-Flop Control Register               */
  __I  uint32_t TBST;              /*!< MPT Status Register                          */
  __IO uint32_t TBIM;              /*!< MPT Interrupt Mask Register                  */
  __I  uint32_t TBUC;              /*!< MPT Read Capture Register                    */
  __IO uint32_t RG0;               /*!< MPT RG0 Timer Register                       */
  __IO uint32_t RG1;               /*!< MPT RG1 Timer Register                       */
  __I  uint32_t CP0;               /*!< MPT CP0 Capture Register                     */
  __I  uint32_t CP1;               /*!< MPT CP1 Capture Register                     */
  __IO uint32_t IGCR;              /*!< IGBT Control Register                        */
  __O  uint32_t IGRESTA;           /*!< IGBT Timer Restart Register                  */
  __I  uint32_t IGST;              /*!< IGBT Timer Status Register                   */
  __IO uint32_t IGICR;             /*!< IGBT Input Control Register                  */
  __IO uint32_t IGOCR;             /*!< IGBT Output Control Register                 */
  __IO uint32_t IGRG2;             /*!< IGBT RG2 Timer Register                      */
  __IO uint32_t IGRG3;             /*!< IGBT RG3 Timer Register                      */
  __IO uint32_t IGRG4;             /*!< IGBT RG4 Timer Register                      */
  __IO uint32_t IGEMGCR;           /*!< IGBT EMG Control Register                    */
  __I  uint32_t IGEMGST;           /*!< IGBT EMG Status Register                     */
  __IO uint32_t IGTRG;             /*!< IGBT Trigger Status Register                 */
} TSB_MT_TypeDef;

/**
  * @brief Oscillation Frequency Detector (OFD)
  */
typedef struct
{
  __IO uint32_t CR1;               /*!< OFD Control Register 1                       */
  __IO uint32_t CR2;               /*!< OFD Control Register 2                       */
  __IO uint32_t MN0;               /*!< OFD Lower Detection Frequency Setting Register*/
  __IO uint32_t MN1;               /*!< OFD Lower Detection Frequency Setting Register*/
  __IO uint32_t MX0;               /*!< OFD Higher Detection Frequency Setting Register*/
  __IO uint32_t MX1;               /*!< OFD Higher Detection Frequency Setting Register*/
  __IO uint32_t RST;               /*!< OFD Reset Enable Control Register            */
  __I  uint32_t STAT;              /*!< OFD Status Register                          */
  __IO uint32_t MON;               /*!< OFD                                          */
} TSB_OFD_TypeDef;

/**
  * @brief Watchdog Timer (WD)
  */
typedef struct
{
  __IO uint32_t MOD;               /*!< WD Mode Register                             */
  __O  uint32_t CR;                /*!< WD Control Register                          */
} TSB_WD_TypeDef;

/**
  * @brief Real Time Clock (RTC)
  */
typedef struct
{
  __IO uint8_t  SECR;              /*!< RTC Sec setting register                     */
  __IO uint8_t  MINR;              /*!< RTC Min settging register                    */
  __IO uint8_t  HOURR;             /*!< RTC Hour setting register                    */
       uint8_t  RESERVED0;
  __IO uint8_t  DAYR;              /*!< RTC Day setting register                     */
  __IO uint8_t  DATER;             /*!< RTC Date setting register                    */
  __IO uint8_t  MONTHR;            /*!< RTC Month settging register PAGE0            */
  __IO uint8_t  YEARR;             /*!< RTC Year setting register PAGE0              */
  __IO uint8_t  PAGER;             /*!< RTC Page register                            */
       uint8_t  RESERVED1[3];
  __IO uint8_t  RESTR;             /*!< RTC Reset register                           */
       uint8_t  RESERVED2;
  __IO uint8_t  PROTECT;           /*!< RTC clock adjust control register            */
  __IO uint8_t  ADJCTL;            /*!< RTC protect register                         */
  __IO uint16_t ADJDAT;            /*!< RTC clock adjust data register               */
} TSB_RTC_TypeDef;

/**
  * @brief Consumer Electronics Control (CEC)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< CEC Enable Register                          */
  __IO uint32_t ADD;               /*!< CEC Logical Address Register                 */
  __O  uint32_t RESET;             /*!< CEC Software Reset Register                  */
  __IO uint32_t REN;               /*!< CEC Receive Enable Register                  */
  __I  uint32_t RBUF;              /*!< CEC Receive Buffer Register                  */
  __IO uint32_t RCR1;              /*!< CEC Receive Control Register 1               */
  __IO uint32_t RCR2;              /*!< CEC Receive Control Register 2               */
  __IO uint32_t RCR3;              /*!< CEC Receive Control Register 3               */
  __IO uint32_t TEN;               /*!< CEC Transmit Enable Register                 */
  __IO uint32_t TBUF;              /*!< CEC Transmit Buffer Register                 */
  __IO uint32_t TCR;               /*!< CEC Transmit Control Register                */
  __I  uint32_t RSTAT;             /*!< CEC Receive Interrupt Status Register        */
  __I  uint32_t TSTAT;             /*!< CEC Transmit Interrupt Status Register       */
  __IO uint32_t FSSEL;             /*!< CEC sampling clock selection Register        */
} TSB_CEC_TypeDef;

/**
  * @brief Remote Control Signal Preprocessor (RMC)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< RMC Enable Register                          */
  __IO uint32_t REN;               /*!< RMC Receive Enable Register                  */
  __I  uint32_t RBUF1;             /*!< RMC Receive Data Buffer Register 1           */
  __I  uint32_t RBUF2;             /*!< RMC Receive Data Buffer Register 2           */
  __I  uint32_t RBUF3;             /*!< RMC Receive Data Buffer Register 3           */
  __IO uint32_t RCR1;              /*!< RMC Receive Control Register 1               */
  __IO uint32_t RCR2;              /*!< RMC Receive Control Register 2               */
  __IO uint32_t RCR3;              /*!< RMC Receive Control Register 3               */
  __IO uint32_t RCR4;              /*!< RMC Receive Control Register 4               */
  __I  uint32_t RSTAT;             /*!< RMC Receive Status Register                  */
  __IO uint32_t END1;              /*!< RMC Receive End Bit Number Register 1        */
  __IO uint32_t END2;              /*!< RMC Receive End Bit Number Register 2        */
  __IO uint32_t END3;              /*!< RMC Receive End Bit Number Register 3        */
  __IO uint32_t FSSEL;             /*!< RMC Frequency Selection Register             */
} TSB_RMC_TypeDef;

/**
  * @brief Clock Generator (CG)
  */
typedef struct
{
  __IO uint32_t SYSCR;             /*!< System Control Register                      */
  __IO uint32_t OSCCR;             /*!< Oscillation Control Register                 */
  __IO uint32_t STBYCR;            /*!< Standby Control Register                     */
  __IO uint32_t PLLSEL;            /*!< PLL Selection Register                       */
       uint32_t RESERVED0[4];
  __IO uint32_t FSYSMSKA;          /*!< fclk Supply Stop Register A                  */
  __IO uint32_t FSYSMSKB;          /*!< fclk Supply Stop Register B                  */
       uint32_t RESERVED1[5];
  __IO uint32_t PROTECT;           /*!< Protect Register                             */
  __IO uint32_t IMCGA;             /*!< CG Interrupt Mode Control Register A         */
  __IO uint32_t IMCGB;             /*!< CG Interrupt Mode Control Register B         */
  __IO uint32_t IMCGC;             /*!< CG Interrupt Mode Control Register C         */
  __IO uint32_t IMCGD;             /*!< CG Interrupt Mode Control Register D         */
  __IO uint32_t IMCGE;             /*!< CG Interrupt Mode Control Register E         */
  __IO uint32_t IMCGF;             /*!< CG Interrupt Mode Control Register F         */
       uint32_t RESERVED2[2];
  __O  uint32_t ICRCG;             /*!< CG Interrupt Request Clear Register          */
  __IO uint32_t RSTFLG;            /*!< Reset Flag Register                          */
  __I  uint32_t NMIFLG;            /*!< NMI Flag Register                            */
} TSB_CG_TypeDef;

/**
  * @brief Low voltage detecter
  */
typedef struct
{
  __IO uint32_t CR0;               /*!< LVD-RVDD3 detection control register0(1.5V)  */
  __IO uint32_t CR1;               /*!< LVD-RVDD3 detection control register1(3V)    */
} TSB_LVD_TypeDef;

/**
  * @brief Flash Control (FC)
  */
typedef struct
{
       uint32_t RESERVED0[4];
  __IO uint32_t SECBIT;            /*!< Security Bit Register                        */
       uint32_t RESERVED1[3];
  __I  uint32_t PSR0;              /*!< Protect Status Register 0                    */
       uint32_t RESERVED2[3];
  __I  uint32_t PSR1;              /*!< Protect Status Register 1                    */
       uint32_t RESERVED3[3];
  __I  uint32_t PSR2;              /*!< Protect Status Register 2                    */
       uint32_t RESERVED4[47];
  __I  uint32_t SR;                /*!< Status Register                              */
  __I  uint32_t SWPSR;             /*!< Swap Status Register                         */
       uint32_t RESERVED5[14];
  __IO uint32_t AREASEL;           /*!< Area Selection Register                      */
       uint32_t RESERVED6;
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t STSCLR;            /*!< Status Clear Register                        */
  __IO uint32_t WCLKCR;            /*!< WCLK Configuration Register                  */
  __IO uint32_t PROGCR;            /*!< Program Counter Configuration Register       */
  __IO uint32_t ERASECR;           /*!< Erase Counter Configuration Register         */
} TSB_FC_TypeDef;


/* Memory map */
#define FLASH_BASE            (0x00000000UL)
#define RAM_BASE              (0x20000000UL)
#define PERI_BASE             (0x40000000UL)


#define TSB_SSP0_BASE              (PERI_BASE  + 0x0040000UL)
#define TSB_SSP1_BASE              (PERI_BASE  + 0x0041000UL)
#define TSB_SSP2_BASE              (PERI_BASE  + 0x0042000UL)
#define TSB_UART0_BASE             (PERI_BASE  + 0x0048000UL)
#define TSB_UART1_BASE             (PERI_BASE  + 0x0049000UL)
#define TSB_DMAA_BASE              (PERI_BASE  + 0x004C000UL)
#define TSB_DMAB_BASE              (PERI_BASE  + 0x004D000UL)
#define TSB_DMAC_BASE              (PERI_BASE  + 0x004E000UL)
#define TSB_DMAIF_BASE             (PERI_BASE  + 0x005F000UL)
#define TSB_AD_BASE                (PERI_BASE  + 0x0050000UL)
#define TSB_EXB_BASE               (PERI_BASE  + 0x005C000UL)
#define TSB_ADILV_BASE             (PERI_BASE  + 0x0066000UL)
#define TSB_I2C0_BASE              (PERI_BASE  + 0x00A0000UL)
#define TSB_I2C1_BASE              (PERI_BASE  + 0x00A1000UL)
#define TSB_I2C2_BASE              (PERI_BASE  + 0x00A2000UL)
#define TSB_I2C3_BASE              (PERI_BASE  + 0x00A3000UL)
#define TSB_I2C4_BASE              (PERI_BASE  + 0x00A4000UL)
#define TSB_TB0_BASE               (PERI_BASE  + 0x00C4000UL)
#define TSB_TB1_BASE               (PERI_BASE  + 0x00C4100UL)
#define TSB_TB2_BASE               (PERI_BASE  + 0x00C4200UL)
#define TSB_TB3_BASE               (PERI_BASE  + 0x00C4300UL)
#define TSB_TB4_BASE               (PERI_BASE  + 0x00C4400UL)
#define TSB_TB5_BASE               (PERI_BASE  + 0x00C4500UL)
#define TSB_TB6_BASE               (PERI_BASE  + 0x00C4600UL)
#define TSB_TB7_BASE               (PERI_BASE  + 0x00C4700UL)
#define TSB_TB8_BASE               (PERI_BASE  + 0x01C4800UL)
#define TSB_TB9_BASE               (PERI_BASE  + 0x01C4900UL)
#define TSB_TBA_BASE               (PERI_BASE  + 0x01C4A00UL)
#define TSB_TBB_BASE               (PERI_BASE  + 0x01C4B00UL)
#define TSB_TBC_BASE               (PERI_BASE  + 0x01C4C00UL)
#define TSB_TBD_BASE               (PERI_BASE  + 0x01C4D00UL)
#define TSB_TBE_BASE               (PERI_BASE  + 0x01C4E00UL)
#define TSB_TBF_BASE               (PERI_BASE  + 0x01C4F00UL)
#define TSB_SC0_BASE               (PERI_BASE  + 0x00E1000UL)
#define TSB_SC1_BASE               (PERI_BASE  + 0x00E1100UL)
#define TSB_SC2_BASE               (PERI_BASE  + 0x00E1200UL)
#define TSB_SC6_BASE               (PERI_BASE  + 0x00E1600UL)
#define TSB_SC7_BASE               (PERI_BASE  + 0x00E1700UL)
#define TSB_SC3_BASE               (PERI_BASE  + 0x01E1300UL)
#define TSB_SC4_BASE               (PERI_BASE  + 0x01E1400UL)
#define TSB_SC5_BASE               (PERI_BASE  + 0x01E1500UL)
#define TSB_SC8_BASE               (PERI_BASE  + 0x01E1800UL)
#define TSB_SC9_BASE               (PERI_BASE  + 0x01E1900UL)
#define TSB_PA_BASE                (PERI_BASE  + 0x02C0000UL)
#define TSB_PB_BASE                (PERI_BASE  + 0x02C0100UL)
#define TSB_PC_BASE                (PERI_BASE  + 0x02C0200UL)
#define TSB_PD_BASE                (PERI_BASE  + 0x02C0300UL)
#define TSB_PE_BASE                (PERI_BASE  + 0x02C0400UL)
#define TSB_PF_BASE                (PERI_BASE  + 0x02C0500UL)
#define TSB_PG_BASE                (PERI_BASE  + 0x02C0600UL)
#define TSB_PH_BASE                (PERI_BASE  + 0x02C0700UL)
#define TSB_PJ_BASE                (PERI_BASE  + 0x02C0800UL)
#define TSB_PK_BASE                (PERI_BASE  + 0x02C0900UL)
#define TSB_PL_BASE                (PERI_BASE  + 0x02C0A00UL)
#define TSB_PM_BASE                (PERI_BASE  + 0x02C0B00UL)
#define TSB_PN_BASE                (PERI_BASE  + 0x02C0C00UL)
#define TSB_MT0_BASE               (PERI_BASE  + 0x02C7000UL)
#define TSB_MT1_BASE               (PERI_BASE  + 0x02C7100UL)
#define TSB_OFD_BASE               (PERI_BASE  + 0x02F1000UL)
#define TSB_WD_BASE                (PERI_BASE  + 0x02F2000UL)
#define TSB_RTC_BASE               (PERI_BASE  + 0x03CC000UL)
#define TSB_CEC_BASE               (PERI_BASE  + 0x03E6000UL)
#define TSB_RMC0_BASE              (PERI_BASE  + 0x03E7000UL)
#define TSB_RMC1_BASE              (PERI_BASE  + 0x03E7100UL)
#define TSB_CG_BASE                (PERI_BASE  + 0x03F3000UL)
#define TSB_LVD_BASE               (PERI_BASE  + 0x03F4000UL)
#define TSB_FC_BASE                (PERI_BASE  + 0x1FFF000UL)


/* Peripheral declaration */
#define TSB_SSP0                   ((    TSB_SSP_TypeDef *)  TSB_SSP0_BASE)
#define TSB_SSP1                   ((    TSB_SSP_TypeDef *)  TSB_SSP1_BASE)
#define TSB_SSP2                   ((    TSB_SSP_TypeDef *)  TSB_SSP2_BASE)
#define TSB_UART0                  ((   TSB_UART_TypeDef *) TSB_UART0_BASE)
#define TSB_UART1                  ((   TSB_UART_TypeDef *) TSB_UART1_BASE)
#define TSB_DMAA                   ((    TSB_DMA_TypeDef *)  TSB_DMAA_BASE)
#define TSB_DMAB                   ((    TSB_DMA_TypeDef *)  TSB_DMAB_BASE)
#define TSB_DMAC                   ((    TSB_DMA_TypeDef *)  TSB_DMAC_BASE)
#define TSB_DMAIF                  ((  TSB_DMAIF_TypeDef *) TSB_DMAIF_BASE)
#define TSB_AD                     ((     TSB_AD_TypeDef *)    TSB_AD_BASE)
#define TSB_EXB                    ((    TSB_EXB_TypeDef *)   TSB_EXB_BASE)
#define TSB_ADILV                  ((  TSB_ADILV_TypeDef *) TSB_ADILV_BASE)
#define TSB_I2C0                   ((    TSB_I2C_TypeDef *)  TSB_I2C0_BASE)
#define TSB_I2C1                   ((    TSB_I2C_TypeDef *)  TSB_I2C1_BASE)
#define TSB_I2C2                   ((    TSB_I2C_TypeDef *)  TSB_I2C2_BASE)
#define TSB_I2C3                   ((    TSB_I2C_TypeDef *)  TSB_I2C3_BASE)
#define TSB_I2C4                   ((    TSB_I2C_TypeDef *)  TSB_I2C4_BASE)
#define TSB_TB0                    ((     TSB_TB_TypeDef *)   TSB_TB0_BASE)
#define TSB_TB1                    ((     TSB_TB_TypeDef *)   TSB_TB1_BASE)
#define TSB_TB2                    ((     TSB_TB_TypeDef *)   TSB_TB2_BASE)
#define TSB_TB3                    ((     TSB_TB_TypeDef *)   TSB_TB3_BASE)
#define TSB_TB4                    ((     TSB_TB_TypeDef *)   TSB_TB4_BASE)
#define TSB_TB5                    ((     TSB_TB_TypeDef *)   TSB_TB5_BASE)
#define TSB_TB6                    ((     TSB_TB_TypeDef *)   TSB_TB6_BASE)
#define TSB_TB7                    ((     TSB_TB_TypeDef *)   TSB_TB7_BASE)
#define TSB_TB8                    ((     TSB_TB_TypeDef *)   TSB_TB8_BASE)
#define TSB_TB9                    ((     TSB_TB_TypeDef *)   TSB_TB9_BASE)
#define TSB_TBA                    ((     TSB_TB_TypeDef *)   TSB_TBA_BASE)
#define TSB_TBB                    ((     TSB_TB_TypeDef *)   TSB_TBB_BASE)
#define TSB_TBC                    ((     TSB_TB_TypeDef *)   TSB_TBC_BASE)
#define TSB_TBD                    ((     TSB_TB_TypeDef *)   TSB_TBD_BASE)
#define TSB_TBE                    ((     TSB_TB_TypeDef *)   TSB_TBE_BASE)
#define TSB_TBF                    ((     TSB_TB_TypeDef *)   TSB_TBF_BASE)
#define TSB_SC0                    ((     TSB_SC_TypeDef *)   TSB_SC0_BASE)
#define TSB_SC1                    ((     TSB_SC_TypeDef *)   TSB_SC1_BASE)
#define TSB_SC2                    ((     TSB_SC_TypeDef *)   TSB_SC2_BASE)
#define TSB_SC6                    ((     TSB_SC_TypeDef *)   TSB_SC6_BASE)
#define TSB_SC7                    ((     TSB_SC_TypeDef *)   TSB_SC7_BASE)
#define TSB_SC3                    ((     TSB_SC_TypeDef *)   TSB_SC3_BASE)
#define TSB_SC4                    ((     TSB_SC_TypeDef *)   TSB_SC4_BASE)
#define TSB_SC5                    ((     TSB_SC_TypeDef *)   TSB_SC5_BASE)
#define TSB_SC8                    ((     TSB_SC_TypeDef *)   TSB_SC8_BASE)
#define TSB_SC9                    ((     TSB_SC_TypeDef *)   TSB_SC9_BASE)
#define TSB_PA                     ((     TSB_PA_TypeDef *)    TSB_PA_BASE)
#define TSB_PB                     ((     TSB_PB_TypeDef *)    TSB_PB_BASE)
#define TSB_PC                     ((     TSB_PC_TypeDef *)    TSB_PC_BASE)
#define TSB_PD                     ((     TSB_PD_TypeDef *)    TSB_PD_BASE)
#define TSB_PE                     ((     TSB_PE_TypeDef *)    TSB_PE_BASE)
#define TSB_PF                     ((     TSB_PF_TypeDef *)    TSB_PF_BASE)
#define TSB_PG                     ((     TSB_PG_TypeDef *)    TSB_PG_BASE)
#define TSB_PH                     ((     TSB_PH_TypeDef *)    TSB_PH_BASE)
#define TSB_PJ                     ((     TSB_PJ_TypeDef *)    TSB_PJ_BASE)
#define TSB_PK                     ((     TSB_PK_TypeDef *)    TSB_PK_BASE)
#define TSB_PL                     ((     TSB_PL_TypeDef *)    TSB_PL_BASE)
#define TSB_PM                     ((     TSB_PM_TypeDef *)    TSB_PM_BASE)
#define TSB_PN                     ((     TSB_PN_TypeDef *)    TSB_PN_BASE)
#define TSB_MT0                    ((     TSB_MT_TypeDef *)   TSB_MT0_BASE)
#define TSB_MT1                    ((     TSB_MT_TypeDef *)   TSB_MT1_BASE)
#define TSB_OFD                    ((    TSB_OFD_TypeDef *)   TSB_OFD_BASE)
#define TSB_WD                     ((     TSB_WD_TypeDef *)    TSB_WD_BASE)
#define TSB_RTC                    ((    TSB_RTC_TypeDef *)   TSB_RTC_BASE)
#define TSB_CEC                    ((    TSB_CEC_TypeDef *)   TSB_CEC_BASE)
#define TSB_RMC0                   ((    TSB_RMC_TypeDef *)  TSB_RMC0_BASE)
#define TSB_RMC1                   ((    TSB_RMC_TypeDef *)  TSB_RMC1_BASE)
#define TSB_CG                     ((     TSB_CG_TypeDef *)    TSB_CG_BASE)
#define TSB_LVD                    ((    TSB_LVD_TypeDef *)   TSB_LVD_BASE)
#define TSB_FC                     ((     TSB_FC_TypeDef *)    TSB_FC_BASE)


/* Bit-Band for Device Specific Peripheral Registers */
#define BITBAND_OFFSET (0x02000000UL)
#define BITBAND_PERI_BASE (PERI_BASE + BITBAND_OFFSET)
#define BITBAND_PERI(addr, bitnum) (BITBAND_PERI_BASE + (((uint32_t)(addr) - PERI_BASE) << 5) + ((uint32_t)(bitnum) << 2))



/* Synchronous Serial Port */
#define TSB_SSP0_CR0_SPO                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR0,6)))
#define TSB_SSP0_CR0_SPH                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR0,7)))
#define TSB_SSP0_CR1_LBM                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,0)))
#define TSB_SSP0_CR1_SSE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,1)))
#define TSB_SSP0_CR1_MS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,2)))
#define TSB_SSP0_CR1_SOD                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,3)))
#define TSB_SSP0_SR_TFE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR,0)))
#define TSB_SSP0_SR_TNF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR,1)))
#define TSB_SSP0_SR_RNE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR,2)))
#define TSB_SSP0_SR_RFF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR,3)))
#define TSB_SSP0_SR_BSY                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR,4)))
#define TSB_SSP0_IMSC_RORIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,0)))
#define TSB_SSP0_IMSC_RTIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,1)))
#define TSB_SSP0_IMSC_RXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,2)))
#define TSB_SSP0_IMSC_TXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,3)))
#define TSB_SSP0_RIS_RORRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,0)))
#define TSB_SSP0_RIS_RTRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,1)))
#define TSB_SSP0_RIS_RXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,2)))
#define TSB_SSP0_RIS_TXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,3)))
#define TSB_SSP0_MIS_RORMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,0)))
#define TSB_SSP0_MIS_RTMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,1)))
#define TSB_SSP0_MIS_RXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,2)))
#define TSB_SSP0_MIS_TXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,3)))
#define TSB_SSP0_ICR_RORIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP0->ICR,0)))
#define TSB_SSP0_ICR_RTIC                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP0->ICR,1)))
#define TSB_SSP0_DMACR_RXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->DMACR,0)))
#define TSB_SSP0_DMACR_TXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->DMACR,1)))

#define TSB_SSP1_CR0_SPO                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR0,6)))
#define TSB_SSP1_CR0_SPH                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR0,7)))
#define TSB_SSP1_CR1_LBM                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,0)))
#define TSB_SSP1_CR1_SSE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,1)))
#define TSB_SSP1_CR1_MS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,2)))
#define TSB_SSP1_CR1_SOD                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,3)))
#define TSB_SSP1_SR_TFE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR,0)))
#define TSB_SSP1_SR_TNF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR,1)))
#define TSB_SSP1_SR_RNE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR,2)))
#define TSB_SSP1_SR_RFF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR,3)))
#define TSB_SSP1_SR_BSY                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR,4)))
#define TSB_SSP1_IMSC_RORIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,0)))
#define TSB_SSP1_IMSC_RTIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,1)))
#define TSB_SSP1_IMSC_RXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,2)))
#define TSB_SSP1_IMSC_TXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,3)))
#define TSB_SSP1_RIS_RORRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,0)))
#define TSB_SSP1_RIS_RTRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,1)))
#define TSB_SSP1_RIS_RXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,2)))
#define TSB_SSP1_RIS_TXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,3)))
#define TSB_SSP1_MIS_RORMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,0)))
#define TSB_SSP1_MIS_RTMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,1)))
#define TSB_SSP1_MIS_RXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,2)))
#define TSB_SSP1_MIS_TXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,3)))
#define TSB_SSP1_ICR_RORIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP1->ICR,0)))
#define TSB_SSP1_ICR_RTIC                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP1->ICR,1)))
#define TSB_SSP1_DMACR_RXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->DMACR,0)))
#define TSB_SSP1_DMACR_TXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->DMACR,1)))

#define TSB_SSP2_CR0_SPO                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR0,6)))
#define TSB_SSP2_CR0_SPH                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR0,7)))
#define TSB_SSP2_CR1_LBM                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR1,0)))
#define TSB_SSP2_CR1_SSE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR1,1)))
#define TSB_SSP2_CR1_MS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR1,2)))
#define TSB_SSP2_CR1_SOD                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR1,3)))
#define TSB_SSP2_SR_TFE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->SR,0)))
#define TSB_SSP2_SR_TNF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->SR,1)))
#define TSB_SSP2_SR_RNE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->SR,2)))
#define TSB_SSP2_SR_RFF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->SR,3)))
#define TSB_SSP2_SR_BSY                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->SR,4)))
#define TSB_SSP2_IMSC_RORIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->IMSC,0)))
#define TSB_SSP2_IMSC_RTIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->IMSC,1)))
#define TSB_SSP2_IMSC_RXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->IMSC,2)))
#define TSB_SSP2_IMSC_TXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->IMSC,3)))
#define TSB_SSP2_RIS_RORRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->RIS,0)))
#define TSB_SSP2_RIS_RTRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->RIS,1)))
#define TSB_SSP2_RIS_RXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->RIS,2)))
#define TSB_SSP2_RIS_TXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->RIS,3)))
#define TSB_SSP2_MIS_RORMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->MIS,0)))
#define TSB_SSP2_MIS_RTMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->MIS,1)))
#define TSB_SSP2_MIS_RXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->MIS,2)))
#define TSB_SSP2_MIS_TXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->MIS,3)))
#define TSB_SSP2_ICR_RORIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP2->ICR,0)))
#define TSB_SSP2_ICR_RTIC                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP2->ICR,1)))
#define TSB_SSP2_DMACR_RXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->DMACR,0)))
#define TSB_SSP2_DMACR_TXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->DMACR,1)))


/* UART */
#define TSB_UART0_DR_FE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,8)))
#define TSB_UART0_DR_PE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,9)))
#define TSB_UART0_DR_BE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,10)))
#define TSB_UART0_DR_OE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,11)))
#define TSB_UART0_RSR_FE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,0)))
#define TSB_UART0_RSR_PE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,1)))
#define TSB_UART0_RSR_BE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,2)))
#define TSB_UART0_RSR_OE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,3)))
#define TSB_UART0_ECR_FE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,0)))
#define TSB_UART0_ECR_PE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,1)))
#define TSB_UART0_ECR_BE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,2)))
#define TSB_UART0_ECR_OE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,3)))
#define TSB_UART0_FR_CTS                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,0)))
#define TSB_UART0_FR_DSR                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,1)))
#define TSB_UART0_FR_DCD                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,2)))
#define TSB_UART0_FR_BUSY                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,3)))
#define TSB_UART0_FR_RXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,4)))
#define TSB_UART0_FR_TXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,5)))
#define TSB_UART0_FR_RXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,6)))
#define TSB_UART0_FR_TXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,7)))
#define TSB_UART0_FR_RI                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,8)))
#define TSB_UART0_LCR_H_BRK                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,0)))
#define TSB_UART0_LCR_H_PEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,1)))
#define TSB_UART0_LCR_H_EPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,2)))
#define TSB_UART0_LCR_H_STP2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,3)))
#define TSB_UART0_LCR_H_FEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,4)))
#define TSB_UART0_LCR_H_SPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,7)))
#define TSB_UART0_CR_UARTEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,0)))
#define TSB_UART0_CR_SIREN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,1)))
#define TSB_UART0_CR_SIRLP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,2)))
#define TSB_UART0_CR_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,8)))
#define TSB_UART0_CR_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,9)))
#define TSB_UART0_CR_DTR                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,10)))
#define TSB_UART0_CR_RTS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,11)))
#define TSB_UART0_CR_RTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,14)))
#define TSB_UART0_CR_CTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,15)))
#define TSB_UART0_IMSC_RIMIM                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,0)))
#define TSB_UART0_IMSC_CTSMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,1)))
#define TSB_UART0_IMSC_DCDMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,2)))
#define TSB_UART0_IMSC_DSRMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,3)))
#define TSB_UART0_IMSC_RXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,4)))
#define TSB_UART0_IMSC_TXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,5)))
#define TSB_UART0_IMSC_RTIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,6)))
#define TSB_UART0_IMSC_FEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,7)))
#define TSB_UART0_IMSC_PEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,8)))
#define TSB_UART0_IMSC_BEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,9)))
#define TSB_UART0_IMSC_OEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,10)))
#define TSB_UART0_RIS_RIRMIS                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,0)))
#define TSB_UART0_RIS_CTSRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,1)))
#define TSB_UART0_RIS_DCDRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,2)))
#define TSB_UART0_RIS_DSRRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,3)))
#define TSB_UART0_RIS_RXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,4)))
#define TSB_UART0_RIS_TXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,5)))
#define TSB_UART0_RIS_RTRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,6)))
#define TSB_UART0_RIS_FERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,7)))
#define TSB_UART0_RIS_PERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,8)))
#define TSB_UART0_RIS_BERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,9)))
#define TSB_UART0_RIS_OERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,10)))
#define TSB_UART0_MIS_RIMMIS                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,0)))
#define TSB_UART0_MIS_CTSMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,1)))
#define TSB_UART0_MIS_DCDMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,2)))
#define TSB_UART0_MIS_DSRMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,3)))
#define TSB_UART0_MIS_RXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,4)))
#define TSB_UART0_MIS_TXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,5)))
#define TSB_UART0_MIS_RTMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,6)))
#define TSB_UART0_MIS_FEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,7)))
#define TSB_UART0_MIS_PEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,8)))
#define TSB_UART0_MIS_BEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,9)))
#define TSB_UART0_MIS_OEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,10)))
#define TSB_UART0_ICR_RIMIC                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,0)))
#define TSB_UART0_ICR_CTSMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,1)))
#define TSB_UART0_ICR_DCDMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,2)))
#define TSB_UART0_ICR_DSRMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,3)))
#define TSB_UART0_ICR_RXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,4)))
#define TSB_UART0_ICR_TXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,5)))
#define TSB_UART0_ICR_RTIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,6)))
#define TSB_UART0_ICR_FEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,7)))
#define TSB_UART0_ICR_PEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,8)))
#define TSB_UART0_ICR_BEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,9)))
#define TSB_UART0_ICR_OEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,10)))
#define TSB_UART0_DMACR_RXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->DMACR,0)))
#define TSB_UART0_DMACR_TXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->DMACR,1)))
#define TSB_UART0_DMACR_DMAONERR                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->DMACR,2)))

#define TSB_UART1_DR_FE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,8)))
#define TSB_UART1_DR_PE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,9)))
#define TSB_UART1_DR_BE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,10)))
#define TSB_UART1_DR_OE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,11)))
#define TSB_UART1_RSR_FE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,0)))
#define TSB_UART1_RSR_PE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,1)))
#define TSB_UART1_RSR_BE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,2)))
#define TSB_UART1_RSR_OE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,3)))
#define TSB_UART1_ECR_FE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,0)))
#define TSB_UART1_ECR_PE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,1)))
#define TSB_UART1_ECR_BE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,2)))
#define TSB_UART1_ECR_OE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,3)))
#define TSB_UART1_FR_CTS                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,0)))
#define TSB_UART1_FR_DSR                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,1)))
#define TSB_UART1_FR_DCD                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,2)))
#define TSB_UART1_FR_BUSY                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,3)))
#define TSB_UART1_FR_RXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,4)))
#define TSB_UART1_FR_TXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,5)))
#define TSB_UART1_FR_RXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,6)))
#define TSB_UART1_FR_TXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,7)))
#define TSB_UART1_FR_RI                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,8)))
#define TSB_UART1_LCR_H_BRK                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,0)))
#define TSB_UART1_LCR_H_PEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,1)))
#define TSB_UART1_LCR_H_EPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,2)))
#define TSB_UART1_LCR_H_STP2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,3)))
#define TSB_UART1_LCR_H_FEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,4)))
#define TSB_UART1_LCR_H_SPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,7)))
#define TSB_UART1_CR_UARTEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,0)))
#define TSB_UART1_CR_SIREN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,1)))
#define TSB_UART1_CR_SIRLP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,2)))
#define TSB_UART1_CR_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,8)))
#define TSB_UART1_CR_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,9)))
#define TSB_UART1_CR_DTR                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,10)))
#define TSB_UART1_CR_RTS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,11)))
#define TSB_UART1_CR_RTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,14)))
#define TSB_UART1_CR_CTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,15)))
#define TSB_UART1_IMSC_RIMIM                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,0)))
#define TSB_UART1_IMSC_CTSMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,1)))
#define TSB_UART1_IMSC_DCDMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,2)))
#define TSB_UART1_IMSC_DSRMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,3)))
#define TSB_UART1_IMSC_RXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,4)))
#define TSB_UART1_IMSC_TXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,5)))
#define TSB_UART1_IMSC_RTIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,6)))
#define TSB_UART1_IMSC_FEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,7)))
#define TSB_UART1_IMSC_PEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,8)))
#define TSB_UART1_IMSC_BEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,9)))
#define TSB_UART1_IMSC_OEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,10)))
#define TSB_UART1_RIS_RIRMIS                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,0)))
#define TSB_UART1_RIS_CTSRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,1)))
#define TSB_UART1_RIS_DCDRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,2)))
#define TSB_UART1_RIS_DSRRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,3)))
#define TSB_UART1_RIS_RXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,4)))
#define TSB_UART1_RIS_TXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,5)))
#define TSB_UART1_RIS_RTRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,6)))
#define TSB_UART1_RIS_FERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,7)))
#define TSB_UART1_RIS_PERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,8)))
#define TSB_UART1_RIS_BERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,9)))
#define TSB_UART1_RIS_OERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,10)))
#define TSB_UART1_MIS_RIMMIS                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,0)))
#define TSB_UART1_MIS_CTSMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,1)))
#define TSB_UART1_MIS_DCDMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,2)))
#define TSB_UART1_MIS_DSRMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,3)))
#define TSB_UART1_MIS_RXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,4)))
#define TSB_UART1_MIS_TXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,5)))
#define TSB_UART1_MIS_RTMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,6)))
#define TSB_UART1_MIS_FEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,7)))
#define TSB_UART1_MIS_PEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,8)))
#define TSB_UART1_MIS_BEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,9)))
#define TSB_UART1_MIS_OEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,10)))
#define TSB_UART1_ICR_RIMIC                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,0)))
#define TSB_UART1_ICR_CTSMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,1)))
#define TSB_UART1_ICR_DCDMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,2)))
#define TSB_UART1_ICR_DSRMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,3)))
#define TSB_UART1_ICR_RXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,4)))
#define TSB_UART1_ICR_TXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,5)))
#define TSB_UART1_ICR_RTIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,6)))
#define TSB_UART1_ICR_FEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,7)))
#define TSB_UART1_ICR_PEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,8)))
#define TSB_UART1_ICR_BEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,9)))
#define TSB_UART1_ICR_OEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,10)))
#define TSB_UART1_DMACR_RXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->DMACR,0)))
#define TSB_UART1_DMACR_TXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->DMACR,1)))
#define TSB_UART1_DMACR_DMAONERR                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->DMACR,2)))


/* DMA Controller */
#define TSB_DMAA_STATUS_MASTER_ENABLE             (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAA->STATUS,0)))
#define TSB_DMAA_CFG_MASTER_ENABLE                (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAA->CFG,0)))
#define TSB_DMAA_ERRCLR_ERR_CLR                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAA->ERRCLR,0)))

#define TSB_DMAB_STATUS_MASTER_ENABLE             (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAB->STATUS,0)))
#define TSB_DMAB_CFG_MASTER_ENABLE                (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAB->CFG,0)))
#define TSB_DMAB_ERRCLR_ERR_CLR                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAB->ERRCLR,0)))

#define TSB_DMAC_STATUS_MASTER_ENABLE             (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->STATUS,0)))
#define TSB_DMAC_CFG_MASTER_ENABLE                (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAC->CFG,0)))
#define TSB_DMAC_ERRCLR_ERR_CLR                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->ERRCLR,0)))


/* 12bit A/D Converter */
#define TSB_AD_MOD0_ADS                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_AD->MOD0,0)))
#define TSB_AD_MOD0_HPADS                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_AD->MOD0,1)))
#define TSB_AD_MOD1_ADHWE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD1,0)))
#define TSB_AD_MOD1_ADHWS                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD1,1)))
#define TSB_AD_MOD1_HPADHWE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD1,2)))
#define TSB_AD_MOD1_HPADHWS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD1,3)))
#define TSB_AD_MOD1_RCUT                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD1,5)))
#define TSB_AD_MOD1_I2AD                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD1,6)))
#define TSB_AD_MOD1_DACON                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD1,7)))
#define TSB_AD_MOD3_SCAN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD3,0)))
#define TSB_AD_MOD3_REPEAT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->MOD3,1)))
#define TSB_AD_MOD5_ADBF                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->MOD5,0)))
#define TSB_AD_MOD5_HPADBF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD->MOD5,2)))
#define TSB_AD_CMPCR0_ADBIG0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->CMPCR0,4)))
#define TSB_AD_CMPCR0_CMPCOND0                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->CMPCR0,5)))
#define TSB_AD_CMPCR0_CMP0EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->CMPCR0,7)))
#define TSB_AD_CMPCR1_ADBIG1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->CMPCR1,4)))
#define TSB_AD_CMPCR1_CMPCOND1                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->CMPCR1,5)))
#define TSB_AD_CMPCR1_CMP1EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_AD->CMPCR1,7)))


/* External Bus Interface(EXB) */
#define TSB_EXB_MOD_EXBSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->MOD,0)))
#define TSB_EXB_CS0_CSW0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS0,0)))
#define TSB_EXB_CS0_WAIT                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS0,12)))
#define TSB_EXB_CS0_WSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS0,13)))
#define TSB_EXB_CS1_CSW0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS1,0)))
#define TSB_EXB_CS1_WAIT                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS1,12)))
#define TSB_EXB_CS1_WSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS1,13)))
#define TSB_EXB_CS2_CSW0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS2,0)))
#define TSB_EXB_CS2_WAIT                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS2,12)))
#define TSB_EXB_CS2_WSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS2,13)))
#define TSB_EXB_CS3_CSW0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS3,0)))
#define TSB_EXB_CS3_WAIT                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS3,12)))
#define TSB_EXB_CS3_WSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS3,13)))
#define TSB_EXB_CLKCTL_CLKEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CLKCTL,0)))


/* ADC infterface Register */
#define TSB_ADILV_TRGSEL_TRGSELEN                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADILV->TRGSEL,0)))
#define TSB_ADILV_EXCR_EXEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADILV->EXCR,0)))
#define TSB_ADILV_EXCR_EXCR0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADILV->EXCR,4)))
#define TSB_ADILV_EXCR_EXCR1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADILV->EXCR,5)))


/* I2C Bus Interface (I2C) */
#define TSB_I2C0_CR1_NOACK                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR1,3)))
#define TSB_I2C0_CR1_ACK                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C0->CR1,4)))
#define TSB_I2C0_AR_ALS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C0->AR,0)))
#define TSB_I2C0_CR2_I2CM                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR2,3)))
#define TSB_I2C0_CR2_PIN                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR2,4)))
#define TSB_I2C0_CR2_BB                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR2,5)))
#define TSB_I2C0_CR2_TRX                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR2,6)))
#define TSB_I2C0_CR2_MST                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR2,7)))
#define TSB_I2C0_SR_LRB                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,0)))
#define TSB_I2C0_SR_ADO                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,1)))
#define TSB_I2C0_SR_AAS                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,2)))
#define TSB_I2C0_SR_AL                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,3)))
#define TSB_I2C0_SR_PIN                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,4)))
#define TSB_I2C0_SR_BB                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,5)))
#define TSB_I2C0_SR_TRX                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,6)))
#define TSB_I2C0_SR_MST                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,7)))
#define TSB_I2C0_IE_IE                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C0->IE,0)))
#define TSB_I2C0_IR_ISIC                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C0->IR,0)))

#define TSB_I2C1_CR1_NOACK                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C1->CR1,3)))
#define TSB_I2C1_CR1_ACK                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C1->CR1,4)))
#define TSB_I2C1_AR_ALS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C1->AR,0)))
#define TSB_I2C1_CR2_I2CM                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C1->CR2,3)))
#define TSB_I2C1_CR2_PIN                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C1->CR2,4)))
#define TSB_I2C1_CR2_BB                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C1->CR2,5)))
#define TSB_I2C1_CR2_TRX                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C1->CR2,6)))
#define TSB_I2C1_CR2_MST                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C1->CR2,7)))
#define TSB_I2C1_SR_LRB                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C1->SR,0)))
#define TSB_I2C1_SR_ADO                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C1->SR,1)))
#define TSB_I2C1_SR_AAS                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C1->SR,2)))
#define TSB_I2C1_SR_AL                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C1->SR,3)))
#define TSB_I2C1_SR_PIN                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C1->SR,4)))
#define TSB_I2C1_SR_BB                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C1->SR,5)))
#define TSB_I2C1_SR_TRX                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C1->SR,6)))
#define TSB_I2C1_SR_MST                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C1->SR,7)))
#define TSB_I2C1_IE_IE                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C1->IE,0)))
#define TSB_I2C1_IR_ISIC                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C1->IR,0)))

#define TSB_I2C2_CR1_NOACK                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C2->CR1,3)))
#define TSB_I2C2_CR1_ACK                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C2->CR1,4)))
#define TSB_I2C2_AR_ALS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C2->AR,0)))
#define TSB_I2C2_CR2_I2CM                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C2->CR2,3)))
#define TSB_I2C2_CR2_PIN                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C2->CR2,4)))
#define TSB_I2C2_CR2_BB                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C2->CR2,5)))
#define TSB_I2C2_CR2_TRX                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C2->CR2,6)))
#define TSB_I2C2_CR2_MST                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C2->CR2,7)))
#define TSB_I2C2_SR_LRB                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C2->SR,0)))
#define TSB_I2C2_SR_ADO                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C2->SR,1)))
#define TSB_I2C2_SR_AAS                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C2->SR,2)))
#define TSB_I2C2_SR_AL                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C2->SR,3)))
#define TSB_I2C2_SR_PIN                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C2->SR,4)))
#define TSB_I2C2_SR_BB                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C2->SR,5)))
#define TSB_I2C2_SR_TRX                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C2->SR,6)))
#define TSB_I2C2_SR_MST                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C2->SR,7)))
#define TSB_I2C2_IE_IE                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C2->IE,0)))
#define TSB_I2C2_IR_ISIC                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C2->IR,0)))

#define TSB_I2C3_CR1_NOACK                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C3->CR1,3)))
#define TSB_I2C3_CR1_ACK                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C3->CR1,4)))
#define TSB_I2C3_AR_ALS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C3->AR,0)))
#define TSB_I2C3_CR2_I2CM                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C3->CR2,3)))
#define TSB_I2C3_CR2_PIN                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C3->CR2,4)))
#define TSB_I2C3_CR2_BB                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C3->CR2,5)))
#define TSB_I2C3_CR2_TRX                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C3->CR2,6)))
#define TSB_I2C3_CR2_MST                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C3->CR2,7)))
#define TSB_I2C3_SR_LRB                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C3->SR,0)))
#define TSB_I2C3_SR_ADO                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C3->SR,1)))
#define TSB_I2C3_SR_AAS                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C3->SR,2)))
#define TSB_I2C3_SR_AL                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C3->SR,3)))
#define TSB_I2C3_SR_PIN                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C3->SR,4)))
#define TSB_I2C3_SR_BB                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C3->SR,5)))
#define TSB_I2C3_SR_TRX                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C3->SR,6)))
#define TSB_I2C3_SR_MST                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C3->SR,7)))
#define TSB_I2C3_IE_IE                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C3->IE,0)))
#define TSB_I2C3_IR_ISIC                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C3->IR,0)))

#define TSB_I2C4_CR1_NOACK                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C4->CR1,3)))
#define TSB_I2C4_CR1_ACK                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C4->CR1,4)))
#define TSB_I2C4_AR_ALS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C4->AR,0)))
#define TSB_I2C4_CR2_I2CM                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C4->CR2,3)))
#define TSB_I2C4_CR2_PIN                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C4->CR2,4)))
#define TSB_I2C4_CR2_BB                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C4->CR2,5)))
#define TSB_I2C4_CR2_TRX                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C4->CR2,6)))
#define TSB_I2C4_CR2_MST                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C4->CR2,7)))
#define TSB_I2C4_SR_LRB                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C4->SR,0)))
#define TSB_I2C4_SR_ADO                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C4->SR,1)))
#define TSB_I2C4_SR_AAS                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C4->SR,2)))
#define TSB_I2C4_SR_AL                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C4->SR,3)))
#define TSB_I2C4_SR_PIN                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C4->SR,4)))
#define TSB_I2C4_SR_BB                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C4->SR,5)))
#define TSB_I2C4_SR_TRX                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C4->SR,6)))
#define TSB_I2C4_SR_MST                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C4->SR,7)))
#define TSB_I2C4_IE_IE                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C4->IE,0)))
#define TSB_I2C4_IR_ISIC                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C4->IR,0)))


/* 16-bit Timer/Event Counter (TB) */
#define TSB_TB0_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->EN,6)))
#define TSB_TB0_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->EN,7)))
#define TSB_TB0_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->RUN,0)))
#define TSB_TB0_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->RUN,2)))
#define TSB_TB0_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,0)))
#define TSB_TB0_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,1)))
#define TSB_TB0_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,3)))
#define TSB_TB0_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,5)))
#define TSB_TB0_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,7)))
#define TSB_TB0_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->MOD,3)))
#define TSB_TB0_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB0->MOD,6)))
#define TSB_TB0_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,2)))
#define TSB_TB0_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,3)))
#define TSB_TB0_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,4)))
#define TSB_TB0_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,5)))
#define TSB_TB0_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,0)))
#define TSB_TB0_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,1)))
#define TSB_TB0_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,2)))

#define TSB_TB1_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->EN,6)))
#define TSB_TB1_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->EN,7)))
#define TSB_TB1_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->RUN,0)))
#define TSB_TB1_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->RUN,2)))
#define TSB_TB1_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,0)))
#define TSB_TB1_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,1)))
#define TSB_TB1_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,3)))
#define TSB_TB1_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,5)))
#define TSB_TB1_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,7)))
#define TSB_TB1_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->MOD,3)))
#define TSB_TB1_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB1->MOD,6)))
#define TSB_TB1_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,2)))
#define TSB_TB1_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,3)))
#define TSB_TB1_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,4)))
#define TSB_TB1_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,5)))
#define TSB_TB1_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,0)))
#define TSB_TB1_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,1)))
#define TSB_TB1_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,2)))

#define TSB_TB2_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->EN,6)))
#define TSB_TB2_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->EN,7)))
#define TSB_TB2_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->RUN,0)))
#define TSB_TB2_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->RUN,2)))
#define TSB_TB2_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,0)))
#define TSB_TB2_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,1)))
#define TSB_TB2_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,3)))
#define TSB_TB2_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,5)))
#define TSB_TB2_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,7)))
#define TSB_TB2_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->MOD,3)))
#define TSB_TB2_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB2->MOD,6)))
#define TSB_TB2_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,2)))
#define TSB_TB2_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,3)))
#define TSB_TB2_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,4)))
#define TSB_TB2_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,5)))
#define TSB_TB2_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,0)))
#define TSB_TB2_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,1)))
#define TSB_TB2_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,2)))

#define TSB_TB3_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->EN,6)))
#define TSB_TB3_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->EN,7)))
#define TSB_TB3_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->RUN,0)))
#define TSB_TB3_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->RUN,2)))
#define TSB_TB3_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,0)))
#define TSB_TB3_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,1)))
#define TSB_TB3_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,3)))
#define TSB_TB3_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,5)))
#define TSB_TB3_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,7)))
#define TSB_TB3_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->MOD,3)))
#define TSB_TB3_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB3->MOD,6)))
#define TSB_TB3_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,2)))
#define TSB_TB3_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,3)))
#define TSB_TB3_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,4)))
#define TSB_TB3_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,5)))
#define TSB_TB3_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,0)))
#define TSB_TB3_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,1)))
#define TSB_TB3_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,2)))

#define TSB_TB4_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->EN,6)))
#define TSB_TB4_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->EN,7)))
#define TSB_TB4_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->RUN,0)))
#define TSB_TB4_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->RUN,2)))
#define TSB_TB4_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,0)))
#define TSB_TB4_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,1)))
#define TSB_TB4_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,3)))
#define TSB_TB4_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,5)))
#define TSB_TB4_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,7)))
#define TSB_TB4_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->MOD,3)))
#define TSB_TB4_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB4->MOD,6)))
#define TSB_TB4_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,2)))
#define TSB_TB4_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,3)))
#define TSB_TB4_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,4)))
#define TSB_TB4_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,5)))
#define TSB_TB4_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,0)))
#define TSB_TB4_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,1)))
#define TSB_TB4_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,2)))

#define TSB_TB5_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->EN,6)))
#define TSB_TB5_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->EN,7)))
#define TSB_TB5_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->RUN,0)))
#define TSB_TB5_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->RUN,2)))
#define TSB_TB5_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,0)))
#define TSB_TB5_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,1)))
#define TSB_TB5_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,3)))
#define TSB_TB5_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,5)))
#define TSB_TB5_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,7)))
#define TSB_TB5_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->MOD,3)))
#define TSB_TB5_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB5->MOD,6)))
#define TSB_TB5_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,2)))
#define TSB_TB5_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,3)))
#define TSB_TB5_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,4)))
#define TSB_TB5_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,5)))
#define TSB_TB5_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->IM,0)))
#define TSB_TB5_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->IM,1)))
#define TSB_TB5_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->IM,2)))

#define TSB_TB6_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->EN,6)))
#define TSB_TB6_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->EN,7)))
#define TSB_TB6_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->RUN,0)))
#define TSB_TB6_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->RUN,2)))
#define TSB_TB6_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,0)))
#define TSB_TB6_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,1)))
#define TSB_TB6_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,3)))
#define TSB_TB6_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,5)))
#define TSB_TB6_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,7)))
#define TSB_TB6_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->MOD,3)))
#define TSB_TB6_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB6->MOD,6)))
#define TSB_TB6_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,2)))
#define TSB_TB6_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,3)))
#define TSB_TB6_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,4)))
#define TSB_TB6_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,5)))
#define TSB_TB6_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->IM,0)))
#define TSB_TB6_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->IM,1)))
#define TSB_TB6_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->IM,2)))

#define TSB_TB7_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->EN,6)))
#define TSB_TB7_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->EN,7)))
#define TSB_TB7_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->RUN,0)))
#define TSB_TB7_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->RUN,2)))
#define TSB_TB7_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,0)))
#define TSB_TB7_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,1)))
#define TSB_TB7_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,3)))
#define TSB_TB7_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,5)))
#define TSB_TB7_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,7)))
#define TSB_TB7_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->MOD,3)))
#define TSB_TB7_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB7->MOD,6)))
#define TSB_TB7_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,2)))
#define TSB_TB7_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,3)))
#define TSB_TB7_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,4)))
#define TSB_TB7_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,5)))
#define TSB_TB7_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->IM,0)))
#define TSB_TB7_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->IM,1)))
#define TSB_TB7_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->IM,2)))


/* Serial Channel (SC) */
#define TSB_SC0_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->EN,0)))
#define TSB_SC0_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->EN,1)))
#define TSB_SC0_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->CR,0)))
#define TSB_SC0_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->CR,1)))
#define TSB_SC0_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->CR,5)))
#define TSB_SC0_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->CR,6)))
#define TSB_SC0_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->CR,7)))
#define TSB_SC0_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->CR,10)))
#define TSB_SC0_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,4)))
#define TSB_SC0_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,5)))
#define TSB_SC0_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,6)))
#define TSB_SC0_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,7)))
#define TSB_SC0_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->BRCR,6)))
#define TSB_SC0_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD1,4)))
#define TSB_SC0_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD1,7)))
#define TSB_SC0_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,2)))
#define TSB_SC0_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,3)))
#define TSB_SC0_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,4)))
#define TSB_SC0_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,5)))
#define TSB_SC0_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,6)))
#define TSB_SC0_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,7)))
#define TSB_SC0_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->RFC,6)))
#define TSB_SC0_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->TFC,6)))
#define TSB_SC0_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->RST,7)))
#define TSB_SC0_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->TST,7)))
#define TSB_SC0_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,0)))
#define TSB_SC0_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,1)))
#define TSB_SC0_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,2)))
#define TSB_SC0_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,3)))
#define TSB_SC0_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,4)))

#define TSB_SC1_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->EN,0)))
#define TSB_SC1_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->EN,1)))
#define TSB_SC1_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->CR,0)))
#define TSB_SC1_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->CR,1)))
#define TSB_SC1_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->CR,5)))
#define TSB_SC1_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->CR,6)))
#define TSB_SC1_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->CR,7)))
#define TSB_SC1_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->CR,10)))
#define TSB_SC1_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,4)))
#define TSB_SC1_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,5)))
#define TSB_SC1_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,6)))
#define TSB_SC1_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,7)))
#define TSB_SC1_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->BRCR,6)))
#define TSB_SC1_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD1,4)))
#define TSB_SC1_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD1,7)))
#define TSB_SC1_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,2)))
#define TSB_SC1_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,3)))
#define TSB_SC1_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,4)))
#define TSB_SC1_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,5)))
#define TSB_SC1_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,6)))
#define TSB_SC1_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,7)))
#define TSB_SC1_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->RFC,6)))
#define TSB_SC1_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->TFC,6)))
#define TSB_SC1_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->RST,7)))
#define TSB_SC1_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->TST,7)))
#define TSB_SC1_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,0)))
#define TSB_SC1_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,1)))
#define TSB_SC1_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,2)))
#define TSB_SC1_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,3)))
#define TSB_SC1_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,4)))

#define TSB_SC2_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->EN,0)))
#define TSB_SC2_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->EN,1)))
#define TSB_SC2_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->CR,0)))
#define TSB_SC2_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->CR,1)))
#define TSB_SC2_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->CR,5)))
#define TSB_SC2_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->CR,6)))
#define TSB_SC2_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->CR,7)))
#define TSB_SC2_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->CR,10)))
#define TSB_SC2_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,4)))
#define TSB_SC2_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,5)))
#define TSB_SC2_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,6)))
#define TSB_SC2_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,7)))
#define TSB_SC2_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->BRCR,6)))
#define TSB_SC2_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD1,4)))
#define TSB_SC2_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD1,7)))
#define TSB_SC2_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,2)))
#define TSB_SC2_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,3)))
#define TSB_SC2_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,4)))
#define TSB_SC2_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,5)))
#define TSB_SC2_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,6)))
#define TSB_SC2_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,7)))
#define TSB_SC2_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->RFC,6)))
#define TSB_SC2_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->TFC,6)))
#define TSB_SC2_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->RST,7)))
#define TSB_SC2_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->TST,7)))
#define TSB_SC2_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,0)))
#define TSB_SC2_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,1)))
#define TSB_SC2_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,2)))
#define TSB_SC2_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,3)))
#define TSB_SC2_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,4)))

#define TSB_SC6_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->EN,0)))
#define TSB_SC6_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->EN,1)))
#define TSB_SC6_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->CR,0)))
#define TSB_SC6_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->CR,1)))
#define TSB_SC6_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->CR,5)))
#define TSB_SC6_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->CR,6)))
#define TSB_SC6_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC6->CR,7)))
#define TSB_SC6_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->CR,10)))
#define TSB_SC6_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->MOD0,4)))
#define TSB_SC6_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->MOD0,5)))
#define TSB_SC6_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->MOD0,6)))
#define TSB_SC6_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->MOD0,7)))
#define TSB_SC6_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->BRCR,6)))
#define TSB_SC6_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->MOD1,4)))
#define TSB_SC6_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->MOD1,7)))
#define TSB_SC6_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->MOD2,2)))
#define TSB_SC6_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->MOD2,3)))
#define TSB_SC6_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->MOD2,4)))
#define TSB_SC6_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC6->MOD2,5)))
#define TSB_SC6_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC6->MOD2,6)))
#define TSB_SC6_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC6->MOD2,7)))
#define TSB_SC6_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->RFC,6)))
#define TSB_SC6_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->TFC,6)))
#define TSB_SC6_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC6->RST,7)))
#define TSB_SC6_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC6->TST,7)))
#define TSB_SC6_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->FCNF,0)))
#define TSB_SC6_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->FCNF,1)))
#define TSB_SC6_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->FCNF,2)))
#define TSB_SC6_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->FCNF,3)))
#define TSB_SC6_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC6->FCNF,4)))

#define TSB_SC7_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->EN,0)))
#define TSB_SC7_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->EN,1)))
#define TSB_SC7_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->CR,0)))
#define TSB_SC7_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->CR,1)))
#define TSB_SC7_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->CR,5)))
#define TSB_SC7_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->CR,6)))
#define TSB_SC7_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC7->CR,7)))
#define TSB_SC7_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->CR,10)))
#define TSB_SC7_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->MOD0,4)))
#define TSB_SC7_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->MOD0,5)))
#define TSB_SC7_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->MOD0,6)))
#define TSB_SC7_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->MOD0,7)))
#define TSB_SC7_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->BRCR,6)))
#define TSB_SC7_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->MOD1,4)))
#define TSB_SC7_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->MOD1,7)))
#define TSB_SC7_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->MOD2,2)))
#define TSB_SC7_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->MOD2,3)))
#define TSB_SC7_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->MOD2,4)))
#define TSB_SC7_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC7->MOD2,5)))
#define TSB_SC7_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC7->MOD2,6)))
#define TSB_SC7_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC7->MOD2,7)))
#define TSB_SC7_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->RFC,6)))
#define TSB_SC7_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->TFC,6)))
#define TSB_SC7_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC7->RST,7)))
#define TSB_SC7_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC7->TST,7)))
#define TSB_SC7_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->FCNF,0)))
#define TSB_SC7_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->FCNF,1)))
#define TSB_SC7_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->FCNF,2)))
#define TSB_SC7_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->FCNF,3)))
#define TSB_SC7_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC7->FCNF,4)))


/** @} */ /* End of group Device_Peripheral_registers */

#ifdef __cplusplus
}
#endif

#endif  /* __TMPM462_H__ */

/** @} */ /* End of group TMPM462 */
/** @} */ /* End of group TOSHIBA_TX04_MICROCONTROLLER */
