/**
 *******************************************************************************
 * @file    TMPM411_unitB.h
 * @brief   CMSIS Cortex-M4 Core Peripheral Access Layer Header File for the
 *          TOSHIBA 'TMPM411_unitB' Device Series
 * @version V2.0.2.2 (Tentative)
 * @date    2014/07/23
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LISENCE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA CORPORATION 2014 All rights reserved
 *******************************************************************************
 */

/** @addtogroup TOSHIBA_TX04_MICROCONTROLLER
  * @{
  */
  
/** @addtogroup TMPM411_unitB
  * @{
  */

#ifndef __TMPM411_unitB_H__
#define __TMPM411_unitB_H__

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup Configuration_of_CMSIS
  * @{
  */

/** Interrupt Number Definition */
typedef enum IRQn
{
/******  Cortex-M4 Processor Exceptions Numbers ***************************************************************/
  NonMaskableInt_IRQn           = -14,       /*!< 2 Non Maskable Interrupt                                    */
  HardFault_IRQn                = -13,       /*!< 3 Cortex-M4 Hard Fault Interrupt                            */
  MemoryManagement_IRQn         = -12,       /*!< 4 Cortex-M4 Memory Management Interrupt                     */
  BusFault_IRQn                 = -11,       /*!< 5 Cortex-M4 Bus Fault Interrupt                             */
  UsageFault_IRQn               = -10,       /*!< 6 Cortex-M4 Usage Fault Interrupt                           */
  SVCall_IRQn                   = -5,        /*!< 11 Cortex-M4 SV Call Interrupt                              */
  DebugMonitor_IRQn             = -4,        /*!< 12 Cortex-M4 Debug Monitor Interrupt                        */
  PendSV_IRQn                   = -2,        /*!< 14 Cortex-M4 Pend SV Interrupt                              */
  SysTick_IRQn                  = -1,        /*!< 15 Cortex-M4 System Tick Interrupt                          */

/******  TMPM411_unitB Specific Interrupt Numbers *******************************************************************/
  INTPWRDETF_IRQn               = 0,         /*!< INT_PWRDET pin Interrupt (Falling edge)                     */
  INTPWRDETR_IRQn               = 1,         /*!< INT_PWRDET pin Interrupt (Rising edge)                      */
  INT5_IRQn                     = 2,         /*!< Interrupt pin 5                                             */
  INT6_IRQn                     = 3,         /*!< Interrupt pin 6                                             */
  INT7_IRQn                     = 4,         /*!< Interrupt pin 7                                             */
  INT8_IRQn                     = 5,         /*!< Interrupt pin 8                                             */
  INTCPUIF1_IRQn                = 6,         /*!< CPU Interface 1 Interrupt                                   */
  INTRX2_IRQn                   = 7,         /*!< Serial2 reception interrupt                                 */
  INTTX2_IRQn                   = 8,         /*!< Serial2 transmission interrupt                              */
  INTRX3_IRQn                   = 9,         /*!< Serial3 reception interrupt                                 */
  INTTX3_IRQn                   = 10,        /*!< Serial3 transmission interrupt                              */
  INTRX4_IRQn                   = 11,        /*!< Serial4 reception interrupt                                 */
  INTTX4_IRQn                   = 12,        /*!< Serial4 transmission interrupt                              */
  INTRX5_IRQn                   = 13,        /*!< Serial5 reception interrupt                                 */
  INTTX5_IRQn                   = 14,        /*!< Serial5 transmission interrupt                              */
  INTUART1_IRQn                 = 15,        /*!< Full UART1 transmission and reception interrupt             */
  INTSSP3_IRQn                  = 16,        /*!< SSP3 interrupt                                              */
  INTADBHP_IRQn                 = 17,        /*!< High Priority AD conversion interrupt (unitB)               */
  INTADBM0_IRQn                 = 18,        /*!< AD conversion monitor 0 interrupt (unitB)                   */
  INTADBM1_IRQn                 = 19,        /*!< AD conversion monitor 1 interrupt (unitB)                   */
  INTADB_IRQn                   = 20,        /*!< Nornal AD conversion interrupt (unitB)                      */
  INTAES_IRQn                   = 21,        /*!< AES completion interrupt                                    */
  INTSHA_IRQn                   = 22,        /*!< SHA completion interrupt                                    */
  INTMLA_IRQn                   = 23,        /*!< MLA completion interrupt                                    */
  INTESG_IRQn                   = 24,        /*!< ESG completion interrupt                                    */
  INTTB3_IRQn                   = 25,        /*!< 16-bit TMRB3 compare match detection interrupt              */
  INTCAP30_IRQn                 = 26,        /*!< 16-bit TMRB3 input capture 0 detection interrupt            */
  INTCAP31_IRQn                 = 27,        /*!< 16-bit TMRB3 input capture 1 detection interrupt            */
  INTTB4_IRQn                   = 28,        /*!< 16-bit TMRB4 compare match detection interrupt              */
  INTCAP40_IRQn                 = 29,        /*!< 16-bit TMRB4 input capture 0 detection interrupt            */
  INTCAP41_IRQn                 = 30,        /*!< 16-bit TMRB4 input capture 1 detection interrupt            */
  INTT16A2_IRQn                 = 31,        /*!< 16-bit TMR16A2 match detection                              */
  INTT16A3_IRQn                 = 32,        /*!< 16-bit TMR16A3 match detection                              */
  INTDMABTC0_IRQn               = 33,        /*!< DMAC0 transmission completion interrupt (unitB)             */
  INTDMABTC1_IRQn               = 34,        /*!< DMAC1 transmission completion interrupt (unitB)             */
  INTDMABTC2_IRQn               = 35,        /*!< DMAC2 transmission completion interrupt (unitB)             */
  INTDMABTC3_IRQn               = 36,        /*!< DMAC3 transmission completion interrupt (unitB)             */
  INTDMABTC4_IRQn               = 37,        /*!< DMAC4 transmission completion interrupt (unitB)             */
  INTDMABTC5_IRQn               = 38,        /*!< DMAC5 transmission completion interrupt (unitB)             */
  INTDMABTC6_IRQn               = 39,        /*!< DMAC6 transmission completion interrupt (unitB)             */
  INTDMABTC7_IRQn               = 40,        /*!< DMAC7 transmission completion interrupt (unitB)             */
  INTDMABTC8_IRQn               = 41,        /*!< DMAC8 transmission completion interrupt (unitB)             */
  INTDMABTC9_IRQn               = 42,        /*!< DMAC9 transmission completion interrupt (unitB)             */
  INTDMABTC10_IRQn              = 43,        /*!< DMAC10 transmission completion interrupt (unitB)            */
  INTDMABTC11_IRQn              = 44,        /*!< DMAC11 transmission completion interrupt (unitB)            */
  INTDMABTC12_IRQn              = 45,        /*!< DMAC12 transmission completion interrupt (unitB)            */
  INTDMABTC13_IRQn              = 46,        /*!< DMAC13 transmission completion interrupt (unitB)            */
  INTDMABTC14_IRQn              = 47,        /*!< DMAC14 transmission completion interrupt (unitB)            */
  INTDMABTC15_IRQn              = 48,        /*!< DMAC15 transmission completion interrupt (unitB)            */
  INTDMABTC16_IRQn              = 49,        /*!< DMAC16 transmission completion interrupt (unitB)            */
  INTDMABTC17_IRQn              = 50,        /*!< DMAC17 transmission completion interrupt (unitB)            */
  INTDMABERR_IRQn               = 51,        /*!< DMAC transmissioni error interrupt (unitB)                  */
  INTFLRDY_IRQn                 = 52         /*!< Flash Ready interrupt                                       */
} IRQn_Type;

/** Processor and Core Peripheral Section */

/* Configuration of the Cortex-M4 Processor and Core Peripherals */
#define __CM4_REV              0x0001       /*!< Cortex-M4 Core Revision                           */
#define __MPU_PRESENT             0         /*!< MPU present or not                                */
#define __NVIC_PRIO_BITS          3         /*!< Number of Bits used for Priority Levels           */
#define __Vendor_SysTickConfig    0         /*!< Set to 1 if different SysTick Config is used      */
#define __FPU_PRESENT							1					/*!< FPU present or not                                */

/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                       /* Cortex-M4 processor and core peripherals            */
#include "system_TMPM411_unitB.h"                 /* TMPM411_unitB System                                      */

/** @addtogroup Device_Peripheral_registers
  * @{
  */

/** Device Specific Peripheral registers structures */

/**
  * @brief Synchronous Serial Port (SSP)
  */
typedef struct
{
  __IO uint32_t CR0;               /*!< SSP Control Register 0                       */
  __IO uint32_t CR1;               /*!< SSP Control Register 1                       */
  __IO uint32_t DR;                /*!< SSP Data Register                            */
  __I  uint32_t SR;                /*!< SSP Status Register                          */
  __IO uint32_t CPSR;              /*!< SSP Clock Prescaler Register                 */
  __IO uint32_t IMSC;              /*!< SSP Interrupt Mask Set and Clear Register    */
  __I  uint32_t RIS;               /*!< SSP Raw Interrupt Status Register            */
  __I  uint32_t MIS;               /*!< SSP Masked Interrupt Status Register         */
  __O  uint32_t ICR;               /*!< SSP Interrupt Clear Register                 */
  __IO uint32_t DMACR;             /*!< SSP DMA Control Register                     */
} TSB_SSP_TypeDef;

#if defined ( __CC_ARM   )           /* RealView Compiler */
#pragma anon_unions
#elif (defined (__ICCARM__))         /*  ICC Compiler     */
#pragma language=extended
#endif

/**
  * @brief UART (Full UART)
  */
typedef struct
{
  __IO uint32_t DR;                /*!< Data Register                                */
union {
  __I  uint32_t RSR;               /*!< Receive Status Register                      */
  __O  uint32_t ECR;               /*!< Error Clear Register                         */
  };
       uint32_t RESERVED0[4];
  __I  uint32_t FR;                /*!< Flag Register                                */
       uint32_t RESERVED1;
  __IO uint32_t ILPR;              /*!< IrDA low-power counter Register              */
  __IO uint32_t IBRD;              /*!< Integer Baud Rate Register                   */
  __IO uint32_t FBRD;              /*!< Fractional Baud Rate Register                */
  __IO uint32_t LCR_H;             /*!< Line Control Register                        */
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t IFLS;              /*!< Interrupt FIFO Level Select Register         */
  __IO uint32_t IMSC;              /*!< Interrupt Mask Set/Clear Register            */
  __I  uint32_t RIS;               /*!< Raw Interrupt Status Register                */
  __I  uint32_t MIS;               /*!< Masked Interrupt Status Register             */
  __O  uint32_t ICR;               /*!< Interrupt Clear Register                     */
  __IO uint32_t DMACR;             /*!< DMA Control Register                         */
} TSB_UART_TypeDef;

/**
  * @brief DMA Controller (DMA)
  */
typedef struct
{
  __I  uint32_t STATUS;            /*!< DMA Status Register                          */
  __O  uint32_t CFG;               /*!< DMA Configuration Register                   */
  __IO uint32_t CTRLBASEPTR;       /*!< DMA Control Data Base Pointer Register       */
  __I  uint32_t ALTCTRLBASEPTR;    /*!< DMA Channel Alternate Control Data Base Pointer Register*/
       uint32_t RESERVED0;
  __O  uint32_t CHNLSWREQUEST;     /*!< DMA Channel Software Request Register        */
  __IO uint32_t CHNLUSEBURSTSET;   /*!< DMA Channel Useburst Set Register            */
  __O  uint32_t CHNLUSEBURSTCLR;   /*!< DMA Channel Useburst Clear Register          */
  __IO uint32_t CHNLREQMASKSET;    /*!< DMA Channel Request Mask Set Register        */
  __O  uint32_t CHNLREQMASKCLR;    /*!< DMA Channel Request Mask Clear Register      */
  __IO uint32_t CHNLENABLESET;     /*!< DMA Channel Enable Set Register              */
  __O  uint32_t CHNLENABLECLR;     /*!< DMA Channel Enable Clear Register            */
  __IO uint32_t CHNLPRIALTSET;     /*!< DMA Channel Primary-Alternate Set Register   */
  __O  uint32_t CHNLPRIALTCLR;     /*!< DMA Channel Primary-Alternate Clear Register */
  __IO uint32_t CHNLPRIORITYSET;   /*!< DMA Channel Priority Set Register            */
  __O  uint32_t CHNLPRIORITYCLR;   /*!< DMA Channel Priority Clear Register          */
       uint32_t RESERVED1[3];
  __IO uint32_t ERRCLR;            /*!< DMA Bus Error Clear Register                 */
} TSB_DMA_TypeDef;

/**
  * @brief 12bit A/D Converter (AD)
  */
typedef struct
{
  __IO uint32_t CLK;               /*!< Conversion Clock Setting Register            */
  __O  uint32_t MOD0;              /*!< Mode Control Register0                       */
  __IO uint32_t MOD1;              /*!< Mode Control Register1                       */
  __IO uint32_t MOD2;              /*!< Mode Control Register2                       */
  __IO uint32_t MOD3;              /*!< Mode Control Register3                       */
  __IO uint32_t MOD4;              /*!< Mode Control Register4                       */
  __I  uint32_t MOD5;              /*!< Mode Control Register5                       */
  __O  uint32_t MOD6;              /*!< Mode Control Register6                       */
       uint32_t RESERVED0;
  __IO uint32_t CMPCR0;            /*!< Monitoring Interrupt Control Register0       */
  __IO uint32_t CMPCR1;            /*!< Monitoring Interrupt Control Register1       */
  __IO uint32_t CMP0;              /*!< Conversion Result Compare Register0          */
  __IO uint32_t CMP1;              /*!< Conversion Result Compare Register1          */
  __I  uint32_t REG00;             /*!< Conversion Result Store Register0            */
  __I  uint32_t REG01;             /*!< Conversion Result Store Register1            */
  __I  uint32_t REG02;             /*!< Conversion Result Store Register2            */
  __I  uint32_t REG03;             /*!< Conversion Result Store Register3            */
  __I  uint32_t REG04;             /*!< Conversion Result Store Register4            */
  __I  uint32_t REG05;             /*!< Conversion Result Store Register5            */
  __I  uint32_t REG06;             /*!< Conversion Result Store Register6            */
  __I  uint32_t REG07;             /*!< Conversion Result Store Register7            */
  __I  uint32_t REG08;             /*!< Conversion Result Store Register8            */
  __I  uint32_t REG09;             /*!< Conversion Result Store Register9            */
  __I  uint32_t REG10;             /*!< Conversion Result Store Register10           */
  __I  uint32_t REG11;             /*!< Conversion Result Store Register11           */
  __I  uint32_t REG12;             /*!< Conversion Result Store Register12           */
  __I  uint32_t REG13;             /*!< Conversion Result Store Register13           */
  __I  uint32_t REG14;             /*!< Conversion Result Store Register14           */
  __I  uint32_t REG15;             /*!< Conversion Result Store Register15           */
  __I  uint32_t REGSP;             /*!< Highest Priority Conversion Result Store Register*/
} TSB_AD_TypeDef;

/**
  * @brief 16-bit TimerA (T16A)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< Enable Register                              */
  __IO uint32_t RUN;               /*!< RUN Register                                 */
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t RG;                /*!< Timer Register                               */
  __I  uint32_t CP;                /*!< Capture Register                             */
} TSB_T16A_TypeDef;

/**
  * @brief Interrupt Controller (INT)
  */
typedef struct
{
  __IO uint32_t CR0;               /*!< Control Register 0                           */
  __IO uint32_t CR1;               /*!< Control Register 1                           */
  __IO uint32_t CR2;               /*!< Control Register 2                           */
  __IO uint32_t CR3;               /*!< Control Register 3                           */
  __IO uint32_t CR4;               /*!< Control Register 4                           */
  __IO uint32_t CR5;               /*!< Control Register 5                           */
  __IO uint32_t CR6;               /*!< Control Register 6                           */
  __IO uint32_t CR7;               /*!< Control Register 7                           */
  __IO uint32_t CR8;               /*!< Control Register 8                           */
  __IO uint32_t CR9;               /*!< Control Register 9                           */
  __IO uint32_t CR10;              /*!< Control Register 10                          */
  __IO uint32_t CR11;              /*!< Control Register 11                          */
  __IO uint32_t CR12;              /*!< Control Register 12                          */
  __IO uint32_t CR13;              /*!< Control Register 13                          */
  __IO uint32_t CR14;              /*!< Control Register 14                          */
  __IO uint32_t CR15;              /*!< Control Register 15                          */
  __IO uint32_t EN;                /*!< STOP1 Mode Release Setting Register          */
  __O  uint32_t CLR;               /*!< Interrupt Request Clear Register             */
  __IO uint32_t RESETF;            /*!< Reset Flag Register                          */
  __I  uint32_t NMIF;              /*!< NMI Flag Register                            */
       uint32_t RESERVED0[2];
  __IO uint32_t IPRST;             /*!< Peripheral Function Reset Register           */
} TSB_INT_TypeDef;

/**
  * @brief Advanced Encryption Standard (AES)
  */
typedef struct
{
  __O  uint32_t DT;                /*!< Plaintext/encrypted text data Register       */
  __IO uint32_t KEY7;              /*!< Input Key Data Register (bit 31 - 0)         */
  __IO uint32_t KEY6;              /*!< Input Key Data Register (bit 63 - 32)        */
  __IO uint32_t KEY5;              /*!< Input Key Data Register (bit 95 - 64)        */
  __IO uint32_t KEY4;              /*!< Input Key Data Register (bit 127 - 96)       */
  __IO uint32_t KEY3;              /*!< Input Key Data Register (bit 159 - 128)      */
  __IO uint32_t KEY2;              /*!< Input Key Data Register (bit 191 - 160)      */
  __IO uint32_t KEY1;              /*!< Input Key Data Register (bit 223 - 192)      */
  __IO uint32_t KEY0;              /*!< Input Key Data Register (bit 255 - 224)      */
  __IO uint32_t CNT3;              /*!< Counter Initial Value Register (bit 31 - 0)  */
  __IO uint32_t CNT2;              /*!< Counter Initial Value Register (bit 63 - 32) */
  __IO uint32_t CNT1;              /*!< Counter Initial Value Register (bit 95 - 64) */
  __IO uint32_t CNT0;              /*!< Counter Initial Value Register (bit 127 - 96)*/
  __IO uint32_t IV3;               /*!< Initial Vector Register (bit 31 - 0)         */
  __IO uint32_t IV2;               /*!< Initial Vector Register (bit 63 - 32)        */
  __IO uint32_t IV1;               /*!< Initial Vector Register (bit 95 - 64)        */
  __IO uint32_t IV0;               /*!< Initial Vector Register (bit 127 - 96)       */
  __I  uint32_t ODT;               /*!< Calculation Result Store Register            */
  __I  uint32_t RKEY7;             /*!< Output Key Store Register (bit 31 - 0)       */
  __I  uint32_t RKEY6;             /*!< Output Key Store Register (bit 63 - 32)      */
  __I  uint32_t RKEY5;             /*!< Output Key Store Register (bit 95 - 64)      */
  __I  uint32_t RKEY4;             /*!< Output Key Store Register (bit 127 - 96)     */
  __I  uint32_t RKEY3;             /*!< Output Key Store Register (bit 159 - 128)    */
  __I  uint32_t RKEY2;             /*!< Output Key Store Register (bit 191 - 160)    */
  __I  uint32_t RKEY1;             /*!< Output Key Store Register (bit 223 - 192)    */
  __I  uint32_t RKEY0;             /*!< Output Key Store Register (bit 255 - 224)    */
  __O  uint32_t CLR;               /*!< FIFO Clear Register                          */
  __IO uint32_t MOD;               /*!< Mode Setting Register                        */
  __I  uint32_t STATUS;            /*!< Status Register                              */
} TSB_AES_TypeDef;

/**
  * @brief Secure Hash Algorithm Processor (SHA)
  */
typedef struct
{
  __O  uint32_t START;             /*!< Process Start Register                       */
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t DMAEN;             /*!< DMA Enable Register                          */
  __IO uint32_t MSGLEN0;           /*!< Whole Message Length Register (bit 31 - 0)   */
  __IO uint32_t MSGLEN1;           /*!< Whole Message Length Register (bit 60 - 32)  */
  __IO uint32_t REMAIN0;           /*!< Unhandled Message Length Register (bit 31 - 0)*/
  __IO uint32_t REMAIN1;           /*!< Unhandled Message Length Register (bit 60 - 32)*/
  __IO uint32_t MSG00;             /*!< Message Register (bit 31 - 0)                */
  __IO uint32_t MSG01;             /*!< Message Register (bit 63 - 32)               */
  __IO uint32_t MSG02;             /*!< Message Register (bit 95 - 64)               */
  __IO uint32_t MSG03;             /*!< Message Register (bit 127 - 96)              */
  __IO uint32_t MSG04;             /*!< Message Register (bit 159 - 128)             */
  __IO uint32_t MSG05;             /*!< Message Register (bit 191 - 160)             */
  __IO uint32_t MSG06;             /*!< Message Register (bit 223 - 192)             */
  __IO uint32_t MSG07;             /*!< Message Register (bit 255 - 224)             */
  __IO uint32_t MSG08;             /*!< Message Register (bit 287 - 256)             */
  __IO uint32_t MSG09;             /*!< Message Register (bit 319 - 288)             */
  __IO uint32_t MSG10;             /*!< Message Register (bit 351 - 320)             */
  __IO uint32_t MSG11;             /*!< Message Register (bit 383 - 352)             */
  __IO uint32_t MSG12;             /*!< Message Register (bit 415 - 384)             */
  __IO uint32_t MSG13;             /*!< Message Register (bit 447 - 416)             */
  __IO uint32_t MSG14;             /*!< Message Register (bit 479 - 448)             */
  __IO uint32_t MSG15;             /*!< Message Register (bit 511 - 480)             */
  __IO uint32_t INIT0;             /*!< Hash Initial Value Register (bit 31 - 0)     */
  __IO uint32_t INIT1;             /*!< Hash Initial Value Register (bit 63 - 32)    */
  __IO uint32_t INIT2;             /*!< Hash Initial Value Register (bit 95 - 64)    */
  __IO uint32_t INIT3;             /*!< Hash Initial Value Register (bit 127 - 96)   */
  __IO uint32_t INIT4;             /*!< Hash Initial Value Register (bit 159 - 128)  */
  __IO uint32_t INIT5;             /*!< Hash Initial Value Register (bit 191 - 160)  */
  __IO uint32_t INIT6;             /*!< Hash Initial Value Register (bit 223 - 192)  */
  __IO uint32_t INIT7;             /*!< Hash Initial Value Register (bit 255 - 224)  */
  __I  uint32_t RESULT0;           /*!< Calculation Result Register (bit 31 - 0)     */
  __I  uint32_t RESULT1;           /*!< Calculation Result Register (bit 63 - 32)    */
  __I  uint32_t RESULT2;           /*!< Calculation Result Register (bit 95 - 64)    */
  __I  uint32_t RESULT3;           /*!< Calculation Result Register (bit 127 - 96)   */
  __I  uint32_t RESULT4;           /*!< Calculation Result Register (bit 159 - 128)  */
  __I  uint32_t RESULT5;           /*!< Calculation Result Register (bit 191 - 160)  */
  __I  uint32_t RESULT6;           /*!< Calculation Result Register (bit 223 - 192)  */
  __I  uint32_t RESULT7;           /*!< Calculation Result Register (bit 255 - 224)  */
  __I  uint32_t STATUS;            /*!< Status Register                              */
} TSB_SHA_TypeDef;

/**
  * @brief Entropy Seed Generator (ESG)
  */
typedef struct
{
  __O  uint32_t CR;                /*!< Control Register                             */
  __I  uint32_t ST;                /*!< Status Register                              */
  __IO uint32_t OUTCR;             /*!< Output Control Register                      */
  __IO uint32_t INT;               /*!< Interrupt Status Register                    */
  __I  uint32_t BLK00;             /*!< Entropy Seed Store Block 00                  */
  __I  uint32_t BLK01;             /*!< Entropy Seed Store Block 01                  */
  __I  uint32_t BLK02;             /*!< Entropy Seed Store Block 02                  */
  __I  uint32_t BLK03;             /*!< Entropy Seed Store Block 03                  */
  __I  uint32_t BLK04;             /*!< Entropy Seed Store Block 04                  */
  __I  uint32_t BLK05;             /*!< Entropy Seed Store Block 05                  */
  __I  uint32_t BLK06;             /*!< Entropy Seed Store Block 06                  */
  __I  uint32_t BLK07;             /*!< Entropy Seed Store Block 07                  */
  __I  uint32_t BLK08;             /*!< Entropy Seed Store Block 08                  */
  __I  uint32_t BLK09;             /*!< Entropy Seed Store Block 09                  */
  __I  uint32_t BLK10;             /*!< Entropy Seed Store Block 10                  */
  __I  uint32_t BLK11;             /*!< Entropy Seed Store Block 11                  */
  __I  uint32_t BLK12;             /*!< Entropy Seed Store Block 12                  */
  __I  uint32_t BLK13;             /*!< Entropy Seed Store Block 13                  */
  __I  uint32_t BLK14;             /*!< Entropy Seed Store Block 14                  */
  __I  uint32_t BLK15;             /*!< Entropy Seed Store Block 15                  */
} TSB_ESG_TypeDef;

/**
  * @brief Multiple Length Arithmetic Coprocessor (MLA)
  */
typedef struct
{
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t ST;                /*!< Status Register                              */
       uint32_t RESERVED0;
  __IO uint32_t PARA;              /*!< Montgomery Parameter Register                */
  __IO uint32_t BLK1_0;            /*!< General-purpose Register Block 1 (bit 31 - 0)*/
  __IO uint32_t BLK1_1;            /*!< General-purpose Register Block 1 (bit 63 - 32)*/
  __IO uint32_t BLK1_2;            /*!< General-purpose Register Block 1 (bit 95 - 64)*/
  __IO uint32_t BLK1_3;            /*!< General-purpose Register Block 1 (bit 127 - 96)*/
  __IO uint32_t BLK1_4;            /*!< General-purpose Register Block 1 (bit 159 - 128)*/
  __IO uint32_t BLK1_5;            /*!< General-purpose Register Block 1 (bit 191 - 160)*/
  __IO uint32_t BLK1_6;            /*!< General-purpose Register Block 1 (bit 223 - 192)*/
  __IO uint32_t BLK1_7;            /*!< General-purpose Register Block 1 (bit 255 - 224)*/
  __IO uint32_t BLK2_0;            /*!< General-purpose Register Block 2 (bit 31 - 0)*/
  __IO uint32_t BLK2_1;            /*!< General-purpose Register Block 2 (bit 63 - 32)*/
  __IO uint32_t BLK2_2;            /*!< General-purpose Register Block 2 (bit 95 - 64)*/
  __IO uint32_t BLK2_3;            /*!< General-purpose Register Block 2 (bit 127 - 96)*/
  __IO uint32_t BLK2_4;            /*!< General-purpose Register Block 2 (bit 159 - 128)*/
  __IO uint32_t BLK2_5;            /*!< General-purpose Register Block 2 (bit 191 - 160)*/
  __IO uint32_t BLK2_6;            /*!< General-purpose Register Block 2 (bit 223 - 192)*/
  __IO uint32_t BLK2_7;            /*!< General-purpose Register Block 2 (bit 255 - 224)*/
  __IO uint32_t BLK3_0;            /*!< General-purpose Register Block 3 (bit 31 - 0)*/
  __IO uint32_t BLK3_1;            /*!< General-purpose Register Block 3 (bit 63 - 32)*/
  __IO uint32_t BLK3_2;            /*!< General-purpose Register Block 3 (bit 95 - 64)*/
  __IO uint32_t BLK3_3;            /*!< General-purpose Register Block 3 (bit 127 - 96)*/
  __IO uint32_t BLK3_4;            /*!< General-purpose Register Block 3 (bit 159 - 128)*/
  __IO uint32_t BLK3_5;            /*!< General-purpose Register Block 3 (bit 191 - 160)*/
  __IO uint32_t BLK3_6;            /*!< General-purpose Register Block 3 (bit 223 - 192)*/
  __IO uint32_t BLK3_7;            /*!< General-purpose Register Block 3 (bit 255 - 224)*/
  __IO uint32_t BLK4_0;            /*!< General-purpose Register Block 4 (bit 31 - 0)*/
  __IO uint32_t BLK4_1;            /*!< General-purpose Register Block 4 (bit 63 - 32)*/
  __IO uint32_t BLK4_2;            /*!< General-purpose Register Block 4 (bit 95 - 64)*/
  __IO uint32_t BLK4_3;            /*!< General-purpose Register Block 4 (bit 127 - 96)*/
  __IO uint32_t BLK4_4;            /*!< General-purpose Register Block 4 (bit 159 - 128)*/
  __IO uint32_t BLK4_5;            /*!< General-purpose Register Block 4 (bit 191 - 160)*/
  __IO uint32_t BLK4_6;            /*!< General-purpose Register Block 4 (bit 223 - 192)*/
  __IO uint32_t BLK4_7;            /*!< General-purpose Register Block 4 (bit 255 - 224)*/
  __IO uint32_t BLK5_0;            /*!< General-purpose Register Block 5 (bit 31 - 0)*/
  __IO uint32_t BLK5_1;            /*!< General-purpose Register Block 5 (bit 63 - 32)*/
  __IO uint32_t BLK5_2;            /*!< General-purpose Register Block 5 (bit 95 - 64)*/
  __IO uint32_t BLK5_3;            /*!< General-purpose Register Block 5 (bit 127 - 96)*/
  __IO uint32_t BLK5_4;            /*!< General-purpose Register Block 5 (bit 159 - 128)*/
  __IO uint32_t BLK5_5;            /*!< General-purpose Register Block 5 (bit 191 - 160)*/
  __IO uint32_t BLK5_6;            /*!< General-purpose Register Block 5 (bit 223 - 192)*/
  __IO uint32_t BLK5_7;            /*!< General-purpose Register Block 5 (bit 255 - 224)*/
  __IO uint32_t BLK6_0;            /*!< General-purpose Register Block 6 (bit 31 - 0)*/
  __IO uint32_t BLK6_1;            /*!< General-purpose Register Block 6 (bit 63 - 32)*/
  __IO uint32_t BLK6_2;            /*!< General-purpose Register Block 6 (bit 95 - 64)*/
  __IO uint32_t BLK6_3;            /*!< General-purpose Register Block 6 (bit 127 - 96)*/
  __IO uint32_t BLK6_4;            /*!< General-purpose Register Block 6 (bit 159 - 128)*/
  __IO uint32_t BLK6_5;            /*!< General-purpose Register Block 6 (bit 191 - 160)*/
  __IO uint32_t BLK6_6;            /*!< General-purpose Register Block 6 (bit 223 - 192)*/
  __IO uint32_t BLK6_7;            /*!< General-purpose Register Block 6 (bit 255 - 224)*/
  __IO uint32_t BLK7_0;            /*!< General-purpose Register Block 7 (bit 31 - 0)*/
  __IO uint32_t BLK7_1;            /*!< General-purpose Register Block 7 (bit 63 - 32)*/
  __IO uint32_t BLK7_2;            /*!< General-purpose Register Block 7 (bit 95 - 64)*/
  __IO uint32_t BLK7_3;            /*!< General-purpose Register Block 7 (bit 127 - 96)*/
  __IO uint32_t BLK7_4;            /*!< General-purpose Register Block 7 (bit 159 - 128)*/
  __IO uint32_t BLK7_5;            /*!< General-purpose Register Block 7 (bit 191 - 160)*/
  __IO uint32_t BLK7_6;            /*!< General-purpose Register Block 7 (bit 223 - 192)*/
  __IO uint32_t BLK7_7;            /*!< General-purpose Register Block 7 (bit 255 - 224)*/
  __IO uint32_t BLK8_0;            /*!< General-purpose Register Block 8 (bit 31 - 0)*/
  __IO uint32_t BLK8_1;            /*!< General-purpose Register Block 8 (bit 63 - 32)*/
  __IO uint32_t BLK8_2;            /*!< General-purpose Register Block 8 (bit 95 - 64)*/
  __IO uint32_t BLK8_3;            /*!< General-purpose Register Block 8 (bit 127 - 96)*/
  __IO uint32_t BLK8_4;            /*!< General-purpose Register Block 8 (bit 159 - 128)*/
  __IO uint32_t BLK8_5;            /*!< General-purpose Register Block 8 (bit 191 - 160)*/
  __IO uint32_t BLK8_6;            /*!< General-purpose Register Block 8 (bit 223 - 192)*/
  __IO uint32_t BLK8_7;            /*!< General-purpose Register Block 8 (bit 255 - 224)*/
  __IO uint32_t BLK9_0;            /*!< General-purpose Register Block 9 (bit 31 - 0)*/
  __IO uint32_t BLK9_1;            /*!< General-purpose Register Block 9 (bit 63 - 32)*/
  __IO uint32_t BLK9_2;            /*!< General-purpose Register Block 9 (bit 95 - 64)*/
  __IO uint32_t BLK9_3;            /*!< General-purpose Register Block 9 (bit 127 - 96)*/
  __IO uint32_t BLK9_4;            /*!< General-purpose Register Block 9 (bit 159 - 128)*/
  __IO uint32_t BLK9_5;            /*!< General-purpose Register Block 9 (bit 191 - 160)*/
  __IO uint32_t BLK9_6;            /*!< General-purpose Register Block 9 (bit 223 - 192)*/
  __IO uint32_t BLK9_7;            /*!< General-purpose Register Block 9 (bit 255 - 224)*/
  __IO uint32_t BLK10_0;           /*!< General-purpose Register Block 10 (bit 31 - 0)*/
  __IO uint32_t BLK10_1;           /*!< General-purpose Register Block 10 (bit 63 - 32)*/
  __IO uint32_t BLK10_2;           /*!< General-purpose Register Block 10 (bit 95 - 64)*/
  __IO uint32_t BLK10_3;           /*!< General-purpose Register Block 10 (bit 127 - 96)*/
  __IO uint32_t BLK10_4;           /*!< General-purpose Register Block 10 (bit 159 - 128)*/
  __IO uint32_t BLK10_5;           /*!< General-purpose Register Block 10 (bit 191 - 160)*/
  __IO uint32_t BLK10_6;           /*!< General-purpose Register Block 10 (bit 223 - 192)*/
  __IO uint32_t BLK10_7;           /*!< General-purpose Register Block 10 (bit 255 - 224)*/
  __IO uint32_t BLK11_0;           /*!< General-purpose Register Block 11 (bit 31 - 0)*/
  __IO uint32_t BLK11_1;           /*!< General-purpose Register Block 11 (bit 63 - 32)*/
  __IO uint32_t BLK11_2;           /*!< General-purpose Register Block 11 (bit 95 - 64)*/
  __IO uint32_t BLK11_3;           /*!< General-purpose Register Block 11 (bit 127 - 96)*/
  __IO uint32_t BLK11_4;           /*!< General-purpose Register Block 11 (bit 159 - 128)*/
  __IO uint32_t BLK11_5;           /*!< General-purpose Register Block 11 (bit 191 - 160)*/
  __IO uint32_t BLK11_6;           /*!< General-purpose Register Block 11 (bit 223 - 192)*/
  __IO uint32_t BLK11_7;           /*!< General-purpose Register Block 11 (bit 255 - 224)*/
  __IO uint32_t BLK12_0;           /*!< General-purpose Register Block 12 (bit 31 - 0)*/
  __IO uint32_t BLK12_1;           /*!< General-purpose Register Block 12 (bit 63 - 32)*/
  __IO uint32_t BLK12_2;           /*!< General-purpose Register Block 12 (bit 95 - 64)*/
  __IO uint32_t BLK12_3;           /*!< General-purpose Register Block 12 (bit 127 - 96)*/
  __IO uint32_t BLK12_4;           /*!< General-purpose Register Block 12 (bit 159 - 128)*/
  __IO uint32_t BLK12_5;           /*!< General-purpose Register Block 12 (bit 191 - 160)*/
  __IO uint32_t BLK12_6;           /*!< General-purpose Register Block 12 (bit 223 - 192)*/
  __IO uint32_t BLK12_7;           /*!< General-purpose Register Block 12 (bit 255 - 224)*/
  __IO uint32_t BLK13_0;           /*!< General-purpose Register Block 13 (bit 31 - 0)*/
  __IO uint32_t BLK13_1;           /*!< General-purpose Register Block 13 (bit 63 - 32)*/
  __IO uint32_t BLK13_2;           /*!< General-purpose Register Block 13 (bit 95 - 64)*/
  __IO uint32_t BLK13_3;           /*!< General-purpose Register Block 13 (bit 127 - 96)*/
  __IO uint32_t BLK13_4;           /*!< General-purpose Register Block 13 (bit 159 - 128)*/
  __IO uint32_t BLK13_5;           /*!< General-purpose Register Block 13 (bit 191 - 160)*/
  __IO uint32_t BLK13_6;           /*!< General-purpose Register Block 13 (bit 223 - 192)*/
  __IO uint32_t BLK13_7;           /*!< General-purpose Register Block 13 (bit 255 - 224)*/
  __IO uint32_t BLK14_0;           /*!< General-purpose Register Block 14 (bit 31 - 0)*/
  __IO uint32_t BLK14_1;           /*!< General-purpose Register Block 14 (bit 63 - 32)*/
  __IO uint32_t BLK14_2;           /*!< General-purpose Register Block 14 (bit 95 - 64)*/
  __IO uint32_t BLK14_3;           /*!< General-purpose Register Block 14 (bit 127 - 96)*/
  __IO uint32_t BLK14_4;           /*!< General-purpose Register Block 14 (bit 159 - 128)*/
  __IO uint32_t BLK14_5;           /*!< General-purpose Register Block 14 (bit 191 - 160)*/
  __IO uint32_t BLK14_6;           /*!< General-purpose Register Block 14 (bit 223 - 192)*/
  __IO uint32_t BLK14_7;           /*!< General-purpose Register Block 14 (bit 255 - 224)*/
  __IO uint32_t BLK15_0;           /*!< General-purpose Register Block 15 (bit 31 - 0)*/
  __IO uint32_t BLK15_1;           /*!< General-purpose Register Block 15 (bit 63 - 32)*/
  __IO uint32_t BLK15_2;           /*!< General-purpose Register Block 15 (bit 95 - 64)*/
  __IO uint32_t BLK15_3;           /*!< General-purpose Register Block 15 (bit 127 - 96)*/
  __IO uint32_t BLK15_4;           /*!< General-purpose Register Block 15 (bit 159 - 128)*/
  __IO uint32_t BLK15_5;           /*!< General-purpose Register Block 15 (bit 191 - 160)*/
  __IO uint32_t BLK15_6;           /*!< General-purpose Register Block 15 (bit 223 - 192)*/
  __IO uint32_t BLK15_7;           /*!< General-purpose Register Block 15 (bit 255 - 224)*/
  __IO uint32_t BLK16_0;           /*!< General-purpose Register Block 16 (bit 31 - 0)*/
  __IO uint32_t BLK16_1;           /*!< General-purpose Register Block 16 (bit 63 - 32)*/
  __IO uint32_t BLK16_2;           /*!< General-purpose Register Block 16 (bit 95 - 64)*/
  __IO uint32_t BLK16_3;           /*!< General-purpose Register Block 16 (bit 127 - 96)*/
  __IO uint32_t BLK16_4;           /*!< General-purpose Register Block 16 (bit 159 - 128)*/
  __IO uint32_t BLK16_5;           /*!< General-purpose Register Block 16 (bit 191 - 160)*/
  __IO uint32_t BLK16_6;           /*!< General-purpose Register Block 16 (bit 223 - 192)*/
  __IO uint32_t BLK16_7;           /*!< General-purpose Register Block 16 (bit 255 - 224)*/
  __IO uint32_t BLK17_0;           /*!< General-purpose Register Block 17 (bit 31 - 0)*/
  __IO uint32_t BLK17_1;           /*!< General-purpose Register Block 17 (bit 63 - 32)*/
  __IO uint32_t BLK17_2;           /*!< General-purpose Register Block 17 (bit 95 - 64)*/
  __IO uint32_t BLK17_3;           /*!< General-purpose Register Block 17 (bit 127 - 96)*/
  __IO uint32_t BLK17_4;           /*!< General-purpose Register Block 17 (bit 159 - 128)*/
  __IO uint32_t BLK17_5;           /*!< General-purpose Register Block 17 (bit 191 - 160)*/
  __IO uint32_t BLK17_6;           /*!< General-purpose Register Block 17 (bit 223 - 192)*/
  __IO uint32_t BLK17_7;           /*!< General-purpose Register Block 17 (bit 255 - 224)*/
  __IO uint32_t BLK18_0;           /*!< General-purpose Register Block 18 (bit 31 - 0)*/
  __IO uint32_t BLK18_1;           /*!< General-purpose Register Block 18 (bit 63 - 32)*/
  __IO uint32_t BLK18_2;           /*!< General-purpose Register Block 18 (bit 95 - 64)*/
  __IO uint32_t BLK18_3;           /*!< General-purpose Register Block 18 (bit 127 - 96)*/
  __IO uint32_t BLK18_4;           /*!< General-purpose Register Block 18 (bit 159 - 128)*/
  __IO uint32_t BLK18_5;           /*!< General-purpose Register Block 18 (bit 191 - 160)*/
  __IO uint32_t BLK18_6;           /*!< General-purpose Register Block 18 (bit 223 - 192)*/
  __IO uint32_t BLK18_7;           /*!< General-purpose Register Block 18 (bit 255 - 224)*/
  __IO uint32_t BLK19_0;           /*!< General-purpose Register Block 19 (bit 31 - 0)*/
  __IO uint32_t BLK19_1;           /*!< General-purpose Register Block 19 (bit 63 - 32)*/
  __IO uint32_t BLK19_2;           /*!< General-purpose Register Block 19 (bit 95 - 64)*/
  __IO uint32_t BLK19_3;           /*!< General-purpose Register Block 19 (bit 127 - 96)*/
  __IO uint32_t BLK19_4;           /*!< General-purpose Register Block 19 (bit 159 - 128)*/
  __IO uint32_t BLK19_5;           /*!< General-purpose Register Block 19 (bit 191 - 160)*/
  __IO uint32_t BLK19_6;           /*!< General-purpose Register Block 19 (bit 223 - 192)*/
  __IO uint32_t BLK19_7;           /*!< General-purpose Register Block 19 (bit 255 - 224)*/
  __IO uint32_t BLK20_0;           /*!< General-purpose Register Block 20 (bit 31 - 0)*/
  __IO uint32_t BLK20_1;           /*!< General-purpose Register Block 20 (bit 63 - 32)*/
  __IO uint32_t BLK20_2;           /*!< General-purpose Register Block 20 (bit 95 - 64)*/
  __IO uint32_t BLK20_3;           /*!< General-purpose Register Block 20 (bit 127 - 96)*/
  __IO uint32_t BLK20_4;           /*!< General-purpose Register Block 20 (bit 159 - 128)*/
  __IO uint32_t BLK20_5;           /*!< General-purpose Register Block 20 (bit 191 - 160)*/
  __IO uint32_t BLK20_6;           /*!< General-purpose Register Block 20 (bit 223 - 192)*/
  __IO uint32_t BLK20_7;           /*!< General-purpose Register Block 20 (bit 255 - 224)*/
  __IO uint32_t BLK21_0;           /*!< General-purpose Register Block 21 (bit 31 - 0)*/
  __IO uint32_t BLK21_1;           /*!< General-purpose Register Block 21 (bit 63 - 32)*/
  __IO uint32_t BLK21_2;           /*!< General-purpose Register Block 21 (bit 95 - 64)*/
  __IO uint32_t BLK21_3;           /*!< General-purpose Register Block 21 (bit 127 - 96)*/
  __IO uint32_t BLK21_4;           /*!< General-purpose Register Block 21 (bit 159 - 128)*/
  __IO uint32_t BLK21_5;           /*!< General-purpose Register Block 21 (bit 191 - 160)*/
  __IO uint32_t BLK21_6;           /*!< General-purpose Register Block 21 (bit 223 - 192)*/
  __IO uint32_t BLK21_7;           /*!< General-purpose Register Block 21 (bit 255 - 224)*/
  __IO uint32_t BLK22_0;           /*!< General-purpose Register Block 22 (bit 31 - 0)*/
  __IO uint32_t BLK22_1;           /*!< General-purpose Register Block 22 (bit 63 - 32)*/
  __IO uint32_t BLK22_2;           /*!< General-purpose Register Block 22 (bit 95 - 64)*/
  __IO uint32_t BLK22_3;           /*!< General-purpose Register Block 22 (bit 127 - 96)*/
  __IO uint32_t BLK22_4;           /*!< General-purpose Register Block 22 (bit 159 - 128)*/
  __IO uint32_t BLK22_5;           /*!< General-purpose Register Block 22 (bit 191 - 160)*/
  __IO uint32_t BLK22_6;           /*!< General-purpose Register Block 22 (bit 223 - 192)*/
  __IO uint32_t BLK22_7;           /*!< General-purpose Register Block 22 (bit 255 - 224)*/
  __IO uint32_t BLK23_0;           /*!< General-purpose Register Block 23 (bit 31 - 0)*/
  __IO uint32_t BLK23_1;           /*!< General-purpose Register Block 23 (bit 63 - 32)*/
  __IO uint32_t BLK23_2;           /*!< General-purpose Register Block 23 (bit 95 - 64)*/
  __IO uint32_t BLK23_3;           /*!< General-purpose Register Block 23 (bit 127 - 96)*/
  __IO uint32_t BLK23_4;           /*!< General-purpose Register Block 23 (bit 159 - 128)*/
  __IO uint32_t BLK23_5;           /*!< General-purpose Register Block 23 (bit 191 - 160)*/
  __IO uint32_t BLK23_6;           /*!< General-purpose Register Block 23 (bit 223 - 192)*/
  __IO uint32_t BLK23_7;           /*!< General-purpose Register Block 23 (bit 255 - 224)*/
  __IO uint32_t BLK24_0;           /*!< General-purpose Register Block 24 (bit 31 - 0)*/
  __IO uint32_t BLK24_1;           /*!< General-purpose Register Block 24 (bit 63 - 32)*/
  __IO uint32_t BLK24_2;           /*!< General-purpose Register Block 24 (bit 95 - 64)*/
  __IO uint32_t BLK24_3;           /*!< General-purpose Register Block 24 (bit 127 - 96)*/
  __IO uint32_t BLK24_4;           /*!< General-purpose Register Block 24 (bit 159 - 128)*/
  __IO uint32_t BLK24_5;           /*!< General-purpose Register Block 24 (bit 191 - 160)*/
  __IO uint32_t BLK24_6;           /*!< General-purpose Register Block 24 (bit 223 - 192)*/
  __IO uint32_t BLK24_7;           /*!< General-purpose Register Block 24 (bit 255 - 224)*/
  __IO uint32_t BLK25_0;           /*!< General-purpose Register Block 25 (bit 31 - 0)*/
  __IO uint32_t BLK25_1;           /*!< General-purpose Register Block 25 (bit 63 - 32)*/
  __IO uint32_t BLK25_2;           /*!< General-purpose Register Block 25 (bit 95 - 64)*/
  __IO uint32_t BLK25_3;           /*!< General-purpose Register Block 25 (bit 127 - 96)*/
  __IO uint32_t BLK25_4;           /*!< General-purpose Register Block 25 (bit 159 - 128)*/
  __IO uint32_t BLK25_5;           /*!< General-purpose Register Block 25 (bit 191 - 160)*/
  __IO uint32_t BLK25_6;           /*!< General-purpose Register Block 25 (bit 223 - 192)*/
  __IO uint32_t BLK25_7;           /*!< General-purpose Register Block 25 (bit 255 - 224)*/
  __IO uint32_t BLK26_0;           /*!< General-purpose Register Block 26 (bit 31 - 0)*/
  __IO uint32_t BLK26_1;           /*!< General-purpose Register Block 26 (bit 63 - 32)*/
  __IO uint32_t BLK26_2;           /*!< General-purpose Register Block 26 (bit 95 - 64)*/
  __IO uint32_t BLK26_3;           /*!< General-purpose Register Block 26 (bit 127 - 96)*/
  __IO uint32_t BLK26_4;           /*!< General-purpose Register Block 26 (bit 159 - 128)*/
  __IO uint32_t BLK26_5;           /*!< General-purpose Register Block 26 (bit 191 - 160)*/
  __IO uint32_t BLK26_6;           /*!< General-purpose Register Block 26 (bit 223 - 192)*/
  __IO uint32_t BLK26_7;           /*!< General-purpose Register Block 26 (bit 255 - 224)*/
  __IO uint32_t BLK27_0;           /*!< General-purpose Register Block 27 (bit 31 - 0)*/
  __IO uint32_t BLK27_1;           /*!< General-purpose Register Block 27 (bit 63 - 32)*/
  __IO uint32_t BLK27_2;           /*!< General-purpose Register Block 27 (bit 95 - 64)*/
  __IO uint32_t BLK27_3;           /*!< General-purpose Register Block 27 (bit 127 - 96)*/
  __IO uint32_t BLK27_4;           /*!< General-purpose Register Block 27 (bit 159 - 128)*/
  __IO uint32_t BLK27_5;           /*!< General-purpose Register Block 27 (bit 191 - 160)*/
  __IO uint32_t BLK27_6;           /*!< General-purpose Register Block 27 (bit 223 - 192)*/
  __IO uint32_t BLK27_7;           /*!< General-purpose Register Block 27 (bit 255 - 224)*/
  __IO uint32_t BLK28_0;           /*!< General-purpose Register Block 28 (bit 31 - 0)*/
  __IO uint32_t BLK28_1;           /*!< General-purpose Register Block 28 (bit 63 - 32)*/
  __IO uint32_t BLK28_2;           /*!< General-purpose Register Block 28 (bit 95 - 64)*/
  __IO uint32_t BLK28_3;           /*!< General-purpose Register Block 28 (bit 127 - 96)*/
  __IO uint32_t BLK28_4;           /*!< General-purpose Register Block 28 (bit 159 - 128)*/
  __IO uint32_t BLK28_5;           /*!< General-purpose Register Block 28 (bit 191 - 160)*/
  __IO uint32_t BLK28_6;           /*!< General-purpose Register Block 28 (bit 223 - 192)*/
  __IO uint32_t BLK28_7;           /*!< General-purpose Register Block 28 (bit 255 - 224)*/
  __IO uint32_t BLK29_0;           /*!< General-purpose Register Block 29 (bit 31 - 0)*/
  __IO uint32_t BLK29_1;           /*!< General-purpose Register Block 29 (bit 63 - 32)*/
  __IO uint32_t BLK29_2;           /*!< General-purpose Register Block 29 (bit 95 - 64)*/
  __IO uint32_t BLK29_3;           /*!< General-purpose Register Block 29 (bit 127 - 96)*/
  __IO uint32_t BLK29_4;           /*!< General-purpose Register Block 29 (bit 159 - 128)*/
  __IO uint32_t BLK29_5;           /*!< General-purpose Register Block 29 (bit 191 - 160)*/
  __IO uint32_t BLK29_6;           /*!< General-purpose Register Block 29 (bit 223 - 192)*/
  __IO uint32_t BLK29_7;           /*!< General-purpose Register Block 29 (bit 255 - 224)*/
  __IO uint32_t BLK30_0;           /*!< General-purpose Register Block 30 (bit 31 - 0)*/
  __IO uint32_t BLK30_1;           /*!< General-purpose Register Block 30 (bit 63 - 32)*/
  __IO uint32_t BLK30_2;           /*!< General-purpose Register Block 30 (bit 95 - 64)*/
  __IO uint32_t BLK30_3;           /*!< General-purpose Register Block 30 (bit 127 - 96)*/
  __IO uint32_t BLK30_4;           /*!< General-purpose Register Block 30 (bit 159 - 128)*/
  __IO uint32_t BLK30_5;           /*!< General-purpose Register Block 30 (bit 191 - 160)*/
  __IO uint32_t BLK30_6;           /*!< General-purpose Register Block 30 (bit 223 - 192)*/
  __IO uint32_t BLK30_7;           /*!< General-purpose Register Block 30 (bit 255 - 224)*/
  __IO uint32_t BLK31_0;           /*!< General-purpose Register Block 31 (bit 31 - 0)*/
  __IO uint32_t BLK31_1;           /*!< General-purpose Register Block 31 (bit 63 - 32)*/
  __IO uint32_t BLK31_2;           /*!< General-purpose Register Block 31 (bit 95 - 64)*/
  __IO uint32_t BLK31_3;           /*!< General-purpose Register Block 31 (bit 127 - 96)*/
  __IO uint32_t BLK31_4;           /*!< General-purpose Register Block 31 (bit 159 - 128)*/
  __IO uint32_t BLK31_5;           /*!< General-purpose Register Block 31 (bit 191 - 160)*/
  __IO uint32_t BLK31_6;           /*!< General-purpose Register Block 31 (bit 223 - 192)*/
  __IO uint32_t BLK31_7;           /*!< General-purpose Register Block 31 (bit 255 - 224)*/
       uint32_t RESERVED1[260];
  __IO uint32_t BLK0_0;            /*!< General-purpose Register Block 0 (bit 31 - 0)*/
  __IO uint32_t BLK0_1;            /*!< General-purpose Register Block 0 (bit 63 - 32)*/
  __IO uint32_t BLK0_2;            /*!< General-purpose Register Block 0 (bit 95 - 64)*/
  __IO uint32_t BLK0_3;            /*!< General-purpose Register Block 0 (bit 127 - 96)*/
  __IO uint32_t BLK0_4;            /*!< General-purpose Register Block 0 (bit 159 - 128)*/
  __IO uint32_t BLK0_5;            /*!< General-purpose Register Block 0 (bit 191 - 160)*/
  __IO uint32_t BLK0_6;            /*!< General-purpose Register Block 0 (bit 223 - 192)*/
  __IO uint32_t BLK0_7;            /*!< General-purpose Register Block 0 (bit 255 - 224)*/
} TSB_MLA_TypeDef;

/**
  * @brief CPU Interface (CPUIF)
  */
typedef struct
{
  __IO uint32_t INTCR;             /*!< Interrupt Control Regiser                    */
  __IO uint32_t INTCLR;            /*!< Interrupt Clear Register                     */
  __IO uint32_t INFOW;             /*!< Transmit Data Register                       */
  __I  uint32_t INFOR;             /*!< Receive Data Register                        */
} TSB_CPUIF_TypeDef;

/**
  * @brief Port H (PH)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port H Data Register                         */
  __IO uint32_t CR;                /*!< Port H Output Control Register               */
  __IO uint32_t FR1;               /*!< Port H Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port H Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port H Pull-up Control Register              */
  __IO uint32_t PDN;               /*!< Port H Pull-down Control Register            */
       uint32_t RESERVED1;
  __IO uint32_t IE;                /*!< Port H Input Control Register                */
} TSB_PH_TypeDef;

/**
  * @brief Port J (PJ)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port J Data Register                         */
  __IO uint32_t CR;                /*!< Port J Output Control Register               */
  __IO uint32_t FR1;               /*!< Port J Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port J Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port J Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port J Input Control Register                */
} TSB_PJ_TypeDef;

/**
  * @brief Port K (PK)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port K Data Register                         */
  __IO uint32_t CR;                /*!< Port K Output Control Register               */
  __IO uint32_t FR1;               /*!< Port K Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port K Function Register 2                   */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;                /*!< Port K Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port K Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port K Input Control Register                */
} TSB_PK_TypeDef;

/**
  * @brief Port L (PL)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port L Data Register                         */
  __IO uint32_t CR;                /*!< Port L Output Control Register               */
  __IO uint32_t FR1;               /*!< Port L Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port L Function Register 2                   */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;                /*!< Port L Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port L Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port L Input Control Register                */
} TSB_PL_TypeDef;

/**
  * @brief Port M (PM)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port M Data Register                         */
  __IO uint32_t CR;                /*!< Port M Output Control Register               */
  __IO uint32_t FR1;               /*!< Port M Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port M Function Register 2                   */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;                /*!< Port M Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port M Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port M Input Control Register                */
} TSB_PM_TypeDef;

/**
  * @brief Port N (PN)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port N Data Register                         */
  __IO uint32_t CR;                /*!< Port N Output Control Register               */
       uint32_t RESERVED0[9];
  __IO uint32_t PUP;               /*!< Port N Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port N Input Control Register                */
} TSB_PN_TypeDef;

/**
  * @brief 16-bit Timer/Event Counter (TB)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< TB Enable Register                           */
  __IO uint32_t RUN;               /*!< TB RUN Register                              */
  __IO uint32_t CR;                /*!< TB Control Register                          */
  __IO uint32_t MOD;               /*!< TB Mode Register                             */
  __IO uint32_t FFCR;              /*!< TB Flip-Flop Control Register                */
  __I  uint32_t ST;                /*!< TB Status Register                           */
  __IO uint32_t IM;                /*!< TB Interrupt Mask Register                   */
  __I  uint32_t UC;                /*!< TB Up-counter Capture Register               */
  __IO uint32_t RG0;               /*!< TB RG0 Timer Register                        */
  __IO uint32_t RG1;               /*!< TB RG1 Timer Register                        */
  __I  uint32_t CP0;               /*!< TB CP0 Capture Register                      */
  __I  uint32_t CP1;               /*!< TB CP1 Capture Register                      */
} TSB_TB_TypeDef;

/**
  * @brief SIO/UART (SC)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< SC Enable Register                           */
  __IO uint32_t BUF;               /*!< SC Buffer Register                           */
  __IO uint32_t CR;                /*!< SC Control Register                          */
  __IO uint32_t MOD0;              /*!< SC Mode Control Register 0                   */
  __IO uint32_t BRCR;              /*!< SC Baud Rate Generator Control Register      */
  __IO uint32_t BRADD;             /*!< SC Baud Rate Generator Control Register 2    */
  __IO uint32_t MOD1;              /*!< SC Mode Control Register 1                   */
  __IO uint32_t MOD2;              /*!< SC Mode Control Register 2                   */
  __IO uint32_t RFC;               /*!< SC RX FIFO Configuration Register            */
  __IO uint32_t TFC;               /*!< SC TX FIFO Configuration Register            */
  __I  uint32_t RST;               /*!< SC RX FIFO Status Register                   */
  __I  uint32_t TST;               /*!< SC TX FIFO Status Register                   */
  __IO uint32_t FCNF;              /*!< SC FIFO Configuration Register               */
} TSB_SC_TypeDef;

/**
  * @brief Watchdog Timer (WD)
  */
typedef struct
{
  __IO uint32_t MOD;               /*!< Mode Register                                */
  __O  uint32_t CR;                /*!< Control Register                             */
  __I  uint32_t FLG;               /*!< Flag Register                                */
} TSB_WD_TypeDef;

/**
  * @brief Clock Control (CG)
  */
typedef struct
{
  __IO uint32_t PROTECT;           /*!< Protect Register                             */
  __IO uint32_t OSCSEL;            /*!< High-speed oscillation select Register       */
  __I  uint32_t OSCSTF;            /*!< High-speed oscillation status Register       */
  __IO uint32_t CLKCR;             /*!< Clock Control Register                       */
  __IO uint32_t STBYCR;            /*!< Standby Control Register                     */
  __IO uint32_t CLKMSK;            /*!< Clock supply control Register                */
} TSB_CG_TypeDef;

/**
  * @brief Flash Control (FC)
  */
typedef struct
{
       uint32_t RESERVED0[4];
  __IO uint32_t SECBIT;            /*!< Security Bit Register                        */
       uint32_t RESERVED1[3];
  __I  uint32_t PSR0;              /*!< Protect Status Register 0                    */
       uint32_t RESERVED2[3];
  __I  uint32_t PSR1;              /*!< Protect Status Register 1                    */
       uint32_t RESERVED3[3];
  __I  uint32_t PSR2;              /*!< Protect Status Register 2                    */
       uint32_t RESERVED4[47];
  __I  uint32_t SR;                /*!< Status Register                              */
  __I  uint32_t SWPSR;             /*!< Swap Status Register                         */
       uint32_t RESERVED5[14];
  __IO uint32_t AREASEL;           /*!< Area Selection Register                      */
       uint32_t RESERVED6;
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t STSCLR;            /*!< Status Clear Register                        */
  __IO uint32_t WCLKCR;            /*!< WCLK Configuration Register                  */
  __IO uint32_t PROGCR;            /*!< Program Counter Configuration Register       */
  __IO uint32_t ERASECR;           /*!< Erase Counter Configuration Register         */
} TSB_FC_TypeDef;


/* Memory map */
#define FLASH_BASE            (0x00000000UL)
#define RAM_BASE              (0x20000000UL)
#define PERI_BASE             (0x40000000UL)


#define TSB_SSP3_BASE              (PERI_BASE  + 0x0043000UL)
#define TSB_UART1_BASE             (PERI_BASE  + 0x0049000UL)
#define TSB_DMAB_BASE              (PERI_BASE  + 0x004D000UL)
#define TSB_ADB_BASE               (PERI_BASE  + 0x0051000UL)
#define TSB_T16A2_BASE             (PERI_BASE  + 0x008F000UL)
#define TSB_T16A3_BASE             (PERI_BASE  + 0x0090000UL)
#define TSB_INT1_BASE              (PERI_BASE  + 0x00B8100UL)
#define TSB_AES_BASE               (PERI_BASE  + 0x00B8200UL)
#define TSB_SHA_BASE               (PERI_BASE  + 0x00B8300UL)
#define TSB_ESG_BASE               (PERI_BASE  + 0x00B8400UL)
#define TSB_MLA_BASE               (PERI_BASE  + 0x00B9000UL)
#define TSB_CPUIF1_BASE            (PERI_BASE  + 0x00BC100UL)
#define TSB_PH_BASE                (PERI_BASE  + 0x00C0700UL)
#define TSB_PJ_BASE                (PERI_BASE  + 0x00C0800UL)
#define TSB_PK_BASE                (PERI_BASE  + 0x00C0900UL)
#define TSB_PL_BASE                (PERI_BASE  + 0x00C0A00UL)
#define TSB_PM_BASE                (PERI_BASE  + 0x00C0B00UL)
#define TSB_PN_BASE                (PERI_BASE  + 0x00C0C00UL)
#define TSB_TB3_BASE               (PERI_BASE  + 0x00C4300UL)
#define TSB_TB4_BASE               (PERI_BASE  + 0x00C4400UL)
#define TSB_SC2_BASE               (PERI_BASE  + 0x00E1200UL)
#define TSB_SC3_BASE               (PERI_BASE  + 0x00E1300UL)
#define TSB_SC4_BASE               (PERI_BASE  + 0x00E1400UL)
#define TSB_SC5_BASE               (PERI_BASE  + 0x00E1500UL)
#define TSB_WD1_BASE               (PERI_BASE  + 0x00F2100UL)
#define TSB_CG1_BASE               (PERI_BASE  + 0x00F3100UL)
#define TSB_FC_BASE                (PERI_BASE  + 0x1DFF0000UL)


/* Peripheral declaration */
#define TSB_SSP3                   ((    TSB_SSP_TypeDef *)  TSB_SSP3_BASE)
#define TSB_UART1                  ((   TSB_UART_TypeDef *) TSB_UART1_BASE)
#define TSB_DMAB                   ((    TSB_DMA_TypeDef *)  TSB_DMAB_BASE)
#define TSB_ADB                    ((     TSB_AD_TypeDef *)   TSB_ADB_BASE)
#define TSB_T16A2                  ((   TSB_T16A_TypeDef *) TSB_T16A2_BASE)
#define TSB_T16A3                  ((   TSB_T16A_TypeDef *) TSB_T16A3_BASE)
#define TSB_INT1                   ((    TSB_INT_TypeDef *)  TSB_INT1_BASE)
#define TSB_AES                    ((    TSB_AES_TypeDef *)   TSB_AES_BASE)
#define TSB_SHA                    ((    TSB_SHA_TypeDef *)   TSB_SHA_BASE)
#define TSB_ESG                    ((    TSB_ESG_TypeDef *)   TSB_ESG_BASE)
#define TSB_MLA                    ((    TSB_MLA_TypeDef *)   TSB_MLA_BASE)
#define TSB_CPUIF1                 ((  TSB_CPUIF_TypeDef *)TSB_CPUIF1_BASE)
#define TSB_PH                     ((     TSB_PH_TypeDef *)    TSB_PH_BASE)
#define TSB_PJ                     ((     TSB_PJ_TypeDef *)    TSB_PJ_BASE)
#define TSB_PK                     ((     TSB_PK_TypeDef *)    TSB_PK_BASE)
#define TSB_PL                     ((     TSB_PL_TypeDef *)    TSB_PL_BASE)
#define TSB_PM                     ((     TSB_PM_TypeDef *)    TSB_PM_BASE)
#define TSB_PN                     ((     TSB_PN_TypeDef *)    TSB_PN_BASE)
#define TSB_TB3                    ((     TSB_TB_TypeDef *)   TSB_TB3_BASE)
#define TSB_TB4                    ((     TSB_TB_TypeDef *)   TSB_TB4_BASE)
#define TSB_SC2                    ((     TSB_SC_TypeDef *)   TSB_SC2_BASE)
#define TSB_SC3                    ((     TSB_SC_TypeDef *)   TSB_SC3_BASE)
#define TSB_SC4                    ((     TSB_SC_TypeDef *)   TSB_SC4_BASE)
#define TSB_SC5                    ((     TSB_SC_TypeDef *)   TSB_SC5_BASE)
#define TSB_WD1                    ((     TSB_WD_TypeDef *)   TSB_WD1_BASE)
#define TSB_CG1                    ((     TSB_CG_TypeDef *)   TSB_CG1_BASE)
#define TSB_FC                     ((     TSB_FC_TypeDef *)    TSB_FC_BASE)


/* Bit-Band for Device Specific Peripheral Registers */
#define BITBAND_OFFSET (0x02000000UL)
#define BITBAND_PERI_BASE (PERI_BASE + BITBAND_OFFSET)
#define BITBAND_PERI(addr, bitnum) (BITBAND_PERI_BASE + (((uint32_t)(addr) - PERI_BASE) << 5) + ((uint32_t)(bitnum) << 2))



/* Synchronous Serial Port (SSP) */
#define TSB_SSP3_CR0_SPO                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->CR0,6)))
#define TSB_SSP3_CR0_SPH                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->CR0,7)))
#define TSB_SSP3_CR1_LBM                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->CR1,0)))
#define TSB_SSP3_CR1_SSE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->CR1,1)))
#define TSB_SSP3_CR1_MS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->CR1,2)))
#define TSB_SSP3_CR1_SOD                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->CR1,3)))
#define TSB_SSP3_SR_TFE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->SR,0)))
#define TSB_SSP3_SR_TNF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->SR,1)))
#define TSB_SSP3_SR_RNE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->SR,2)))
#define TSB_SSP3_SR_RFF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->SR,3)))
#define TSB_SSP3_SR_BSY                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->SR,4)))
#define TSB_SSP3_IMSC_RORIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->IMSC,0)))
#define TSB_SSP3_IMSC_RTIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->IMSC,1)))
#define TSB_SSP3_IMSC_RXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->IMSC,2)))
#define TSB_SSP3_IMSC_TXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->IMSC,3)))
#define TSB_SSP3_RIS_RORRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->RIS,0)))
#define TSB_SSP3_RIS_RTRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->RIS,1)))
#define TSB_SSP3_RIS_RXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->RIS,2)))
#define TSB_SSP3_RIS_TXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->RIS,3)))
#define TSB_SSP3_MIS_RORMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->MIS,0)))
#define TSB_SSP3_MIS_RTMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->MIS,1)))
#define TSB_SSP3_MIS_RXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->MIS,2)))
#define TSB_SSP3_MIS_TXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP3->MIS,3)))
#define TSB_SSP3_ICR_RORIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP3->ICR,0)))
#define TSB_SSP3_ICR_RTIC                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP3->ICR,1)))
#define TSB_SSP3_DMACR_RXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->DMACR,0)))
#define TSB_SSP3_DMACR_TXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP3->DMACR,1)))


/* UART (Full UART) */
#define TSB_UART1_DR_FE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,8)))
#define TSB_UART1_DR_PE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,9)))
#define TSB_UART1_DR_BE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,10)))
#define TSB_UART1_DR_OE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,11)))
#define TSB_UART1_RSR_FE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,0)))
#define TSB_UART1_RSR_PE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,1)))
#define TSB_UART1_RSR_BE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,2)))
#define TSB_UART1_RSR_OE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,3)))
#define TSB_UART1_ECR_FE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,0)))
#define TSB_UART1_ECR_PE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,1)))
#define TSB_UART1_ECR_BE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,2)))
#define TSB_UART1_ECR_OE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,3)))
#define TSB_UART1_FR_CTS                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,0)))
#define TSB_UART1_FR_DSR                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,1)))
#define TSB_UART1_FR_DCD                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,2)))
#define TSB_UART1_FR_BUSY                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,3)))
#define TSB_UART1_FR_RXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,4)))
#define TSB_UART1_FR_TXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,5)))
#define TSB_UART1_FR_RXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,6)))
#define TSB_UART1_FR_TXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,7)))
#define TSB_UART1_FR_RI                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,8)))
#define TSB_UART1_LCR_H_BRK                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,0)))
#define TSB_UART1_LCR_H_PEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,1)))
#define TSB_UART1_LCR_H_EPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,2)))
#define TSB_UART1_LCR_H_STP2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,3)))
#define TSB_UART1_LCR_H_FEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,4)))
#define TSB_UART1_LCR_H_SPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,7)))
#define TSB_UART1_CR_UARTEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,0)))
#define TSB_UART1_CR_SIREN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,1)))
#define TSB_UART1_CR_SIRLP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,2)))
#define TSB_UART1_CR_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,8)))
#define TSB_UART1_CR_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,9)))
#define TSB_UART1_CR_DTR                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,10)))
#define TSB_UART1_CR_RTS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,11)))
#define TSB_UART1_CR_RTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,14)))
#define TSB_UART1_CR_CTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,15)))
#define TSB_UART1_IMSC_RIMIM                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,0)))
#define TSB_UART1_IMSC_CTSMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,1)))
#define TSB_UART1_IMSC_DCDMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,2)))
#define TSB_UART1_IMSC_DSRMIN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,3)))
#define TSB_UART1_IMSC_RXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,4)))
#define TSB_UART1_IMSC_TXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,5)))
#define TSB_UART1_IMSC_RTIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,6)))
#define TSB_UART1_IMSC_FEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,7)))
#define TSB_UART1_IMSC_PEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,8)))
#define TSB_UART1_IMSC_BEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,9)))
#define TSB_UART1_IMSC_OEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,10)))
#define TSB_UART1_RIS_RIRMIS                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,0)))
#define TSB_UART1_RIS_CTSRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,1)))
#define TSB_UART1_RIS_DCDRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,2)))
#define TSB_UART1_RIS_DSRRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,3)))
#define TSB_UART1_RIS_RXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,4)))
#define TSB_UART1_RIS_TXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,5)))
#define TSB_UART1_RIS_RTRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,6)))
#define TSB_UART1_RIS_FERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,7)))
#define TSB_UART1_RIS_PERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,8)))
#define TSB_UART1_RIS_BERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,9)))
#define TSB_UART1_RIS_OERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,10)))
#define TSB_UART1_MIS_RIMMIS                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,0)))
#define TSB_UART1_MIS_CTSMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,1)))
#define TSB_UART1_MIS_DCDMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,2)))
#define TSB_UART1_MIS_DSRMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,3)))
#define TSB_UART1_MIS_RXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,4)))
#define TSB_UART1_MIS_TXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,5)))
#define TSB_UART1_MIS_RTMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,6)))
#define TSB_UART1_MIS_FEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,7)))
#define TSB_UART1_MIS_PEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,8)))
#define TSB_UART1_MIS_BEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,9)))
#define TSB_UART1_MIS_OEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,10)))
#define TSB_UART1_ICR_RIMIC                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,0)))
#define TSB_UART1_ICR_CTSMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,1)))
#define TSB_UART1_ICR_DCDMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,2)))
#define TSB_UART1_ICR_DSRMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,3)))
#define TSB_UART1_ICR_RXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,4)))
#define TSB_UART1_ICR_TXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,5)))
#define TSB_UART1_ICR_RTIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,6)))
#define TSB_UART1_ICR_FEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,7)))
#define TSB_UART1_ICR_PEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,8)))
#define TSB_UART1_ICR_BEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,9)))
#define TSB_UART1_ICR_OEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,10)))
#define TSB_UART1_DMACR_RXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->DMACR,0)))
#define TSB_UART1_DMACR_TXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->DMACR,1)))
#define TSB_UART1_DMACR_DMAONERR                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->DMACR,2)))


/* DMA Controller (DMA) */
#define TSB_DMAB_STATUS_MASTER_ENABLE             (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAB->STATUS,0)))
#define TSB_DMAB_CFG_MASTER_ENABLE                (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAB->CFG,0)))
#define TSB_DMAB_ERRCLR_ERR_CLR                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAB->ERRCLR,0)))


/* 12bit A/D Converter (AD) */
#define TSB_ADB_MOD0_ADS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_ADB->MOD0,0)))
#define TSB_ADB_MOD0_HPADS                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_ADB->MOD0,1)))
#define TSB_ADB_MOD1_ADHWE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,0)))
#define TSB_ADB_MOD1_HPADHWE                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,2)))
#define TSB_ADB_MOD1_RCUT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,5)))
#define TSB_ADB_MOD1_I2AD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,6)))
#define TSB_ADB_MOD1_DACON                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,7)))
#define TSB_ADB_MOD3_SCAN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD3,0)))
#define TSB_ADB_MOD3_REPEAT                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD3,1)))
#define TSB_ADB_CMPCR0_ADBIG0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR0,4)))
#define TSB_ADB_CMPCR0_CMPCOND0                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR0,5)))
#define TSB_ADB_CMPCR0_CMP0EN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR0,7)))
#define TSB_ADB_CMPCR1_ADBIG1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR1,4)))
#define TSB_ADB_CMPCR1_CMPCOND1                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR1,5)))
#define TSB_ADB_CMPCR1_CMP1EN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR1,7)))


/* 16-bit TimerA (T16A) */
#define TSB_T16A2_EN_I2T16A                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A2->EN,0)))
#define TSB_T16A2_EN_HALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A2->EN,1)))
#define TSB_T16A2_RUN_RUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A2->RUN,0)))
#define TSB_T16A2_CR_CLK                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A2->CR,0)))
#define TSB_T16A2_CR_FFEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A2->CR,7)))

#define TSB_T16A3_EN_I2T16A                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A3->EN,0)))
#define TSB_T16A3_EN_HALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A3->EN,1)))
#define TSB_T16A3_RUN_RUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A3->RUN,0)))
#define TSB_T16A3_CR_CLK                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A3->CR,0)))
#define TSB_T16A3_CR_FFEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A3->CR,7)))


/* Interrupt Controller (INT) */
#define TSB_INT1_EN_EN0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->EN,0)))
#define TSB_INT1_EN_EN1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->EN,1)))
#define TSB_INT1_EN_EN2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->EN,2)))
#define TSB_INT1_EN_EN3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->EN,3)))
#define TSB_INT1_EN_EN4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->EN,4)))
#define TSB_INT1_EN_EN5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->EN,5)))
#define TSB_INT1_EN_EN6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->EN,6)))
#define TSB_INT1_EN_EN7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->EN,7)))
#define TSB_INT1_RESETF_RSTF3                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->RESETF,3)))
#define TSB_INT1_RESETF_RSTF4                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->RESETF,4)))
#define TSB_INT1_RESETF_RSTF5                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->RESETF,5)))
#define TSB_INT1_IPRST_IPRST0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->IPRST,0)))
#define TSB_INT1_IPRST_IPRST1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->IPRST,1)))
#define TSB_INT1_IPRST_IPRST2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->IPRST,2)))
#define TSB_INT1_IPRST_IPRST3                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT1->IPRST,3)))


/* Advanced Encryption Standard (AES) */
#define TSB_AES_CLR_FIFOCLR                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_AES->CLR,0)))
#define TSB_AES_MOD_OP                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_AES->MOD,0)))
#define TSB_AES_MOD_DMAEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_AES->MOD,1)))
#define TSB_AES_STATUS_BUSY                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_AES->STATUS,0)))
#define TSB_AES_STATUS_WFIFOST                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AES->STATUS,1)))
#define TSB_AES_STATUS_RFIFOST                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AES->STATUS,2)))


/* Secure Hash Algorithm Processor (SHA) */
#define TSB_SHA_START_START                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_SHA->START,0)))
#define TSB_SHA_CR_INTEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SHA->CR,3)))
#define TSB_SHA_DMAEN_DMAEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SHA->DMAEN,0)))
#define TSB_SHA_STATUS_BUSY                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SHA->STATUS,0)))


/* Entropy Seed Generator (ESG) */
#define TSB_ESG_CR_START                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_ESG->CR,0)))
#define TSB_ESG_ST_BUSY                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESG->ST,0)))
#define TSB_ESG_INT_INT                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESG->INT,0)))


/* Multiple Length Arithmetic Coprocessor (MLA) */
#define TSB_MLA_ST_CABO                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MLA->ST,0)))
#define TSB_MLA_ST_BUSY                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_MLA->ST,1)))


/* CPU Interface (CPUIF) */
#define TSB_CPUIF1_INTCR_INT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CPUIF1->INTCR,0)))
#define TSB_CPUIF1_INTCLR_CLR                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CPUIF1->INTCLR,0)))


/* Port H (PH) */
#define TSB_PH_DATA_PH0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,0)))
#define TSB_PH_DATA_PH1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,1)))
#define TSB_PH_DATA_PH2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,2)))
#define TSB_PH_DATA_PH3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,3)))
#define TSB_PH_DATA_PH4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,4)))
#define TSB_PH_DATA_PH5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,5)))
#define TSB_PH_DATA_PH6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,6)))
#define TSB_PH_DATA_PH7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,7)))
#define TSB_PH_CR_PH0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,0)))
#define TSB_PH_CR_PH1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,1)))
#define TSB_PH_CR_PH2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,2)))
#define TSB_PH_CR_PH3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,3)))
#define TSB_PH_CR_PH4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,4)))
#define TSB_PH_CR_PH5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,5)))
#define TSB_PH_CR_PH6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,6)))
#define TSB_PH_CR_PH7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,7)))
#define TSB_PH_FR1_PH1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,1)))
#define TSB_PH_FR1_PH2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,2)))
#define TSB_PH_FR1_PH3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,3)))
#define TSB_PH_FR1_PH4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,4)))
#define TSB_PH_FR1_PH5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,5)))
#define TSB_PH_FR1_PH6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,6)))
#define TSB_PH_FR1_PH7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,7)))
#define TSB_PH_OD_PH0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,0)))
#define TSB_PH_OD_PH1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,1)))
#define TSB_PH_OD_PH2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,2)))
#define TSB_PH_OD_PH3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,3)))
#define TSB_PH_OD_PH4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,4)))
#define TSB_PH_OD_PH5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,5)))
#define TSB_PH_OD_PH6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,6)))
#define TSB_PH_OD_PH7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,7)))
#define TSB_PH_PUP_PH0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,0)))
#define TSB_PH_PUP_PH1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,1)))
#define TSB_PH_PUP_PH2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,2)))
#define TSB_PH_PUP_PH3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,3)))
#define TSB_PH_PUP_PH5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,5)))
#define TSB_PH_PUP_PH6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,6)))
#define TSB_PH_PUP_PH7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,7)))
#define TSB_PH_PDN_PH4DN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PDN,4)))
#define TSB_PH_IE_PH0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,0)))
#define TSB_PH_IE_PH1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,1)))
#define TSB_PH_IE_PH2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,2)))
#define TSB_PH_IE_PH3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,3)))
#define TSB_PH_IE_PH4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,4)))
#define TSB_PH_IE_PH5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,5)))
#define TSB_PH_IE_PH6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,6)))
#define TSB_PH_IE_PH7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,7)))


/* Port J (PJ) */
#define TSB_PJ_DATA_PJ0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,0)))
#define TSB_PJ_DATA_PJ1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,1)))
#define TSB_PJ_DATA_PJ2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,2)))
#define TSB_PJ_DATA_PJ3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,3)))
#define TSB_PJ_DATA_PJ4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,4)))
#define TSB_PJ_DATA_PJ5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,5)))
#define TSB_PJ_DATA_PJ6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,6)))
#define TSB_PJ_DATA_PJ7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,7)))
#define TSB_PJ_CR_PJ0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,0)))
#define TSB_PJ_CR_PJ1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,1)))
#define TSB_PJ_CR_PJ2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,2)))
#define TSB_PJ_CR_PJ3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,3)))
#define TSB_PJ_CR_PJ4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,4)))
#define TSB_PJ_CR_PJ5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,5)))
#define TSB_PJ_CR_PJ6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,6)))
#define TSB_PJ_CR_PJ7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,7)))
#define TSB_PJ_FR1_PJ0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,0)))
#define TSB_PJ_FR1_PJ1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,1)))
#define TSB_PJ_FR1_PJ2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,2)))
#define TSB_PJ_FR1_PJ3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,3)))
#define TSB_PJ_FR1_PJ4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,4)))
#define TSB_PJ_FR1_PJ5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,5)))
#define TSB_PJ_FR1_PJ6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,6)))
#define TSB_PJ_FR1_PJ7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,7)))
#define TSB_PJ_OD_PH0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,0)))
#define TSB_PJ_OD_PH1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,1)))
#define TSB_PJ_OD_PH2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,2)))
#define TSB_PJ_OD_PH3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,3)))
#define TSB_PJ_OD_PH4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,4)))
#define TSB_PJ_OD_PH5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,5)))
#define TSB_PJ_OD_PH6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,6)))
#define TSB_PJ_OD_PH7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,7)))
#define TSB_PJ_PUP_PJ0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,0)))
#define TSB_PJ_PUP_PJ1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,1)))
#define TSB_PJ_PUP_PJ2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,2)))
#define TSB_PJ_PUP_PJ3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,3)))
#define TSB_PJ_PUP_PJ4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,4)))
#define TSB_PJ_PUP_PJ5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,5)))
#define TSB_PJ_PUP_PJ6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,6)))
#define TSB_PJ_PUP_PJ7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,7)))
#define TSB_PJ_IE_PJ0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,0)))
#define TSB_PJ_IE_PJ1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,1)))
#define TSB_PJ_IE_PJ2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,2)))
#define TSB_PJ_IE_PJ3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,3)))
#define TSB_PJ_IE_PJ4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,4)))
#define TSB_PJ_IE_PJ5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,5)))
#define TSB_PJ_IE_PJ6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,6)))
#define TSB_PJ_IE_PJ7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,7)))


/* Port K (PK) */
#define TSB_PK_DATA_PK0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,0)))
#define TSB_PK_DATA_PK1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,1)))
#define TSB_PK_DATA_PK2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,2)))
#define TSB_PK_DATA_PK3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,3)))
#define TSB_PK_DATA_PK4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,4)))
#define TSB_PK_DATA_PK5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,5)))
#define TSB_PK_DATA_PK6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,6)))
#define TSB_PK_DATA_PK7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,7)))
#define TSB_PK_CR_PK0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,0)))
#define TSB_PK_CR_PK1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,1)))
#define TSB_PK_CR_PK2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,2)))
#define TSB_PK_CR_PK3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,3)))
#define TSB_PK_CR_PK4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,4)))
#define TSB_PK_CR_PK5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,5)))
#define TSB_PK_CR_PK6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,6)))
#define TSB_PK_CR_PK7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,7)))
#define TSB_PK_FR1_PK0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,0)))
#define TSB_PK_FR1_PK1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,1)))
#define TSB_PK_FR1_PK2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,2)))
#define TSB_PK_FR1_PK3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,3)))
#define TSB_PK_FR1_PK4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,4)))
#define TSB_PK_FR1_PK5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,5)))
#define TSB_PK_FR1_PK6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,6)))
#define TSB_PK_FR1_PK7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,7)))
#define TSB_PK_FR2_PK0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,0)))
#define TSB_PK_FR2_PK1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,1)))
#define TSB_PK_FR2_PK5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,5)))
#define TSB_PK_OD_PK0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,0)))
#define TSB_PK_OD_PK1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,1)))
#define TSB_PK_OD_PK2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,2)))
#define TSB_PK_OD_PK3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,3)))
#define TSB_PK_OD_PK4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,4)))
#define TSB_PK_OD_PK5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,5)))
#define TSB_PK_OD_PK6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,6)))
#define TSB_PK_OD_PK7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,7)))
#define TSB_PK_PUP_PK0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,0)))
#define TSB_PK_PUP_PK1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,1)))
#define TSB_PK_PUP_PK2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,2)))
#define TSB_PK_PUP_PK3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,3)))
#define TSB_PK_PUP_PK4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,4)))
#define TSB_PK_PUP_PK5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,5)))
#define TSB_PK_PUP_PK6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,6)))
#define TSB_PK_PUP_PK7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,7)))
#define TSB_PK_IE_PK0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,0)))
#define TSB_PK_IE_PK1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,1)))
#define TSB_PK_IE_PK2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,2)))
#define TSB_PK_IE_PK3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,3)))
#define TSB_PK_IE_PK4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,4)))
#define TSB_PK_IE_PK5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,5)))
#define TSB_PK_IE_PK6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,6)))
#define TSB_PK_IE_PK7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,7)))


/* Port L (PL) */
#define TSB_PL_DATA_PL0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,0)))
#define TSB_PL_DATA_PL1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,1)))
#define TSB_PL_DATA_PL2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,2)))
#define TSB_PL_DATA_PL3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,3)))
#define TSB_PL_DATA_PL4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,4)))
#define TSB_PL_DATA_PL5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,5)))
#define TSB_PL_DATA_PL6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,6)))
#define TSB_PL_DATA_PL7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,7)))
#define TSB_PL_CR_PL0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,0)))
#define TSB_PL_CR_PL1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,1)))
#define TSB_PL_CR_PL2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,2)))
#define TSB_PL_CR_PL3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,3)))
#define TSB_PL_CR_PL4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,4)))
#define TSB_PL_CR_PL5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,5)))
#define TSB_PL_CR_PL6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,6)))
#define TSB_PL_CR_PL7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,7)))
#define TSB_PL_FR1_PL1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,1)))
#define TSB_PL_FR1_PL2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,2)))
#define TSB_PL_FR1_PL3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,3)))
#define TSB_PL_FR1_PL4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,4)))
#define TSB_PL_FR1_PL5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,5)))
#define TSB_PL_FR1_PL6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,6)))
#define TSB_PL_FR1_PL7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,7)))
#define TSB_PL_FR2_PL7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR2,7)))
#define TSB_PL_OD_PL0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,0)))
#define TSB_PL_OD_PL1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,1)))
#define TSB_PL_OD_PL2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,2)))
#define TSB_PL_OD_PL3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,3)))
#define TSB_PL_OD_PL4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,4)))
#define TSB_PL_OD_PL5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,5)))
#define TSB_PL_OD_PL6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,6)))
#define TSB_PL_OD_PL7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,7)))
#define TSB_PL_PUP_PL0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,0)))
#define TSB_PL_PUP_PL1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,1)))
#define TSB_PL_PUP_PL2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,2)))
#define TSB_PL_PUP_PL3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,3)))
#define TSB_PL_PUP_PL4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,4)))
#define TSB_PL_PUP_PL5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,5)))
#define TSB_PL_PUP_PL6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,6)))
#define TSB_PL_PUP_PL7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,7)))
#define TSB_PL_IE_PL0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,0)))
#define TSB_PL_IE_PL1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,1)))
#define TSB_PL_IE_PL2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,2)))
#define TSB_PL_IE_PL3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,3)))
#define TSB_PL_IE_PL4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,4)))
#define TSB_PL_IE_PL5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,5)))
#define TSB_PL_IE_PL6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,6)))
#define TSB_PL_IE_PL7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,7)))


/* Port M (PM) */
#define TSB_PM_DATA_PM0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,0)))
#define TSB_PM_DATA_PM1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,1)))
#define TSB_PM_DATA_PM2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,2)))
#define TSB_PM_DATA_PM3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,3)))
#define TSB_PM_DATA_PM4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,4)))
#define TSB_PM_DATA_PM5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,5)))
#define TSB_PM_CR_PM0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,0)))
#define TSB_PM_CR_PM1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,1)))
#define TSB_PM_CR_PM2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,2)))
#define TSB_PM_CR_PM3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,3)))
#define TSB_PM_CR_PM4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,4)))
#define TSB_PM_CR_PM5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,5)))
#define TSB_PM_FR1_PM0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,0)))
#define TSB_PM_FR1_PM1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,1)))
#define TSB_PM_FR1_PM2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,2)))
#define TSB_PM_FR1_PM3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,3)))
#define TSB_PM_FR1_PM4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,4)))
#define TSB_PM_FR1_PM5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,5)))
#define TSB_PM_FR2_PM2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR2,2)))
#define TSB_PM_FR2_PM5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR2,5)))
#define TSB_PM_OD_PM0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,0)))
#define TSB_PM_OD_PM1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,1)))
#define TSB_PM_OD_PM2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,2)))
#define TSB_PM_OD_PM3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,3)))
#define TSB_PM_OD_PM4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,4)))
#define TSB_PM_OD_PM5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,5)))
#define TSB_PM_PUP_PM0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,0)))
#define TSB_PM_PUP_PM1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,1)))
#define TSB_PM_PUP_PM2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,2)))
#define TSB_PM_PUP_PM3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,3)))
#define TSB_PM_PUP_PM4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,4)))
#define TSB_PM_PUP_PM5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,5)))
#define TSB_PM_IE_PM0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,0)))
#define TSB_PM_IE_PM1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,1)))
#define TSB_PM_IE_PM2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,2)))
#define TSB_PM_IE_PM3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,3)))
#define TSB_PM_IE_PM4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,4)))
#define TSB_PM_IE_PM5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,5)))


/* Port N (PN) */
#define TSB_PN_DATA_PN0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,0)))
#define TSB_PN_DATA_PN1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,1)))
#define TSB_PN_DATA_PN2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,2)))
#define TSB_PN_DATA_PN3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,3)))
#define TSB_PN_DATA_PN4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,4)))
#define TSB_PN_CR_PN0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,0)))
#define TSB_PN_CR_PN1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,1)))
#define TSB_PN_CR_PN2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,2)))
#define TSB_PN_CR_PN3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,3)))
#define TSB_PN_CR_PN4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,4)))
#define TSB_PN_PUP_PN0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,0)))
#define TSB_PN_PUP_PN1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,1)))
#define TSB_PN_PUP_PN2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,2)))
#define TSB_PN_PUP_PN3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,3)))
#define TSB_PN_PUP_PN4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,4)))
#define TSB_PN_IE_PN0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,0)))
#define TSB_PN_IE_PN1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,1)))
#define TSB_PN_IE_PN2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,2)))
#define TSB_PN_IE_PN3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,3)))
#define TSB_PN_IE_PN4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,4)))


/* 16-bit Timer/Event Counter (TB) */
#define TSB_TB3_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->EN,6)))
#define TSB_TB3_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->EN,7)))
#define TSB_TB3_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->RUN,0)))
#define TSB_TB3_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->RUN,2)))
#define TSB_TB3_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,0)))
#define TSB_TB3_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,1)))
#define TSB_TB3_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,3)))
#define TSB_TB3_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,5)))
#define TSB_TB3_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,7)))
#define TSB_TB3_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->MOD,3)))
#define TSB_TB3_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB3->MOD,6)))
#define TSB_TB3_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,2)))
#define TSB_TB3_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,3)))
#define TSB_TB3_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,4)))
#define TSB_TB3_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,5)))
#define TSB_TB3_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,0)))
#define TSB_TB3_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,1)))
#define TSB_TB3_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,2)))

#define TSB_TB4_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->EN,6)))
#define TSB_TB4_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->EN,7)))
#define TSB_TB4_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->RUN,0)))
#define TSB_TB4_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->RUN,2)))
#define TSB_TB4_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,0)))
#define TSB_TB4_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,1)))
#define TSB_TB4_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,3)))
#define TSB_TB4_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,5)))
#define TSB_TB4_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,7)))
#define TSB_TB4_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->MOD,3)))
#define TSB_TB4_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB4->MOD,6)))
#define TSB_TB4_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,2)))
#define TSB_TB4_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,3)))
#define TSB_TB4_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,4)))
#define TSB_TB4_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,5)))
#define TSB_TB4_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,0)))
#define TSB_TB4_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,1)))
#define TSB_TB4_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,2)))


/* SIO/UART (SC) */
#define TSB_SC2_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->EN,0)))
#define TSB_SC2_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->EN,1)))
#define TSB_SC2_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,4)))
#define TSB_SC2_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,5)))
#define TSB_SC2_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,6)))
#define TSB_SC2_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,7)))
#define TSB_SC2_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->BRCR,6)))
#define TSB_SC2_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD1,4)))
#define TSB_SC2_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD1,7)))
#define TSB_SC2_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,2)))
#define TSB_SC2_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,3)))
#define TSB_SC2_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,4)))
#define TSB_SC2_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,5)))
#define TSB_SC2_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,6)))
#define TSB_SC2_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,7)))
#define TSB_SC2_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->TST,7)))
#define TSB_SC2_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,0)))
#define TSB_SC2_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,1)))
#define TSB_SC2_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,2)))
#define TSB_SC2_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,3)))
#define TSB_SC2_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,4)))

#define TSB_SC3_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->EN,0)))
#define TSB_SC3_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->EN,1)))
#define TSB_SC3_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,4)))
#define TSB_SC3_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,5)))
#define TSB_SC3_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,6)))
#define TSB_SC3_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,7)))
#define TSB_SC3_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->BRCR,6)))
#define TSB_SC3_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD1,4)))
#define TSB_SC3_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD1,7)))
#define TSB_SC3_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,2)))
#define TSB_SC3_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,3)))
#define TSB_SC3_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,4)))
#define TSB_SC3_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,5)))
#define TSB_SC3_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,6)))
#define TSB_SC3_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,7)))
#define TSB_SC3_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->TST,7)))
#define TSB_SC3_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,0)))
#define TSB_SC3_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,1)))
#define TSB_SC3_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,2)))
#define TSB_SC3_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,3)))
#define TSB_SC3_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,4)))

#define TSB_SC4_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->EN,0)))
#define TSB_SC4_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->EN,1)))
#define TSB_SC4_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,4)))
#define TSB_SC4_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,5)))
#define TSB_SC4_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,6)))
#define TSB_SC4_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,7)))
#define TSB_SC4_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->BRCR,6)))
#define TSB_SC4_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD1,4)))
#define TSB_SC4_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD1,7)))
#define TSB_SC4_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,2)))
#define TSB_SC4_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,3)))
#define TSB_SC4_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,4)))
#define TSB_SC4_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,5)))
#define TSB_SC4_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,6)))
#define TSB_SC4_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,7)))
#define TSB_SC4_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->TST,7)))
#define TSB_SC4_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,0)))
#define TSB_SC4_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,1)))
#define TSB_SC4_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,2)))
#define TSB_SC4_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,3)))
#define TSB_SC4_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,4)))

#define TSB_SC5_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->EN,0)))
#define TSB_SC5_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->EN,1)))
#define TSB_SC5_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD0,4)))
#define TSB_SC5_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD0,5)))
#define TSB_SC5_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD0,6)))
#define TSB_SC5_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD0,7)))
#define TSB_SC5_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->BRCR,6)))
#define TSB_SC5_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD1,4)))
#define TSB_SC5_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD1,7)))
#define TSB_SC5_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,2)))
#define TSB_SC5_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,3)))
#define TSB_SC5_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,4)))
#define TSB_SC5_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,5)))
#define TSB_SC5_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,6)))
#define TSB_SC5_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,7)))
#define TSB_SC5_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC5->TST,7)))
#define TSB_SC5_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->FCNF,0)))
#define TSB_SC5_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->FCNF,1)))
#define TSB_SC5_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->FCNF,2)))
#define TSB_SC5_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->FCNF,3)))
#define TSB_SC5_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->FCNF,4)))


/* Watchdog Timer (WD) */
#define TSB_WD1_MOD_RESCR                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD1->MOD,1)))
#define TSB_WD1_MOD_I2WDT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD1->MOD,2)))
#define TSB_WD1_MOD_WDTE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD1->MOD,7)))
#define TSB_WD1_FLG_FLG                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_WD1->FLG,0)))


/* Clock Control (CG) */
#define TSB_CG1_CLKCR_FPSEL                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKCR,6)))
#define TSB_CG1_CLKCR_STICK                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKCR,7)))
#define TSB_CG1_CLKMSK_ADCB                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKMSK,0)))
#define TSB_CG1_CLKMSK_DMACB                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKMSK,1)))
#define TSB_CG1_CLKMSK_UART1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKMSK,2)))
#define TSB_CG1_CLKMSK_SSP3                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKMSK,3)))
#define TSB_CG1_CLKMSK_AES                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKMSK,4)))
#define TSB_CG1_CLKMSK_SHA                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKMSK,5)))
#define TSB_CG1_CLKMSK_ESG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKMSK,6)))
#define TSB_CG1_CLKMSK_MLA                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKMSK,7)))
#define TSB_CG1_CLKMSK_TRACECLK                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG1->CLKMSK,8)))

/** @} */ /* End of group Device_Peripheral_registers */

#ifdef __cplusplus
}
#endif

#endif  /* __TMPM411_unitB_H__ */

/** @} */ /* End of group TMPM411_unitB */
/** @} */ /* End of group TOSHIBA_TX04_MICROCONTROLLER */
