/**
 *******************************************************************************
 * @file    TMPM411_unitA.h
 * @brief   CMSIS Cortex-M4 Core Peripheral Access Layer Header File for the
 *          TOSHIBA 'TMPM411_unitA' Device Series
 * @version V2.0.2.2 (Tentative)
 * @date    2014/07/23
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LISENCE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA CORPORATION 2014 All rights reserved
 *******************************************************************************
 */

/** @addtogroup TOSHIBA_TX04_MICROCONTROLLER
  * @{
  */
  
/** @addtogroup TMPM411_unitA
  * @{
  */

#ifndef __TMPM411_unitA_H__
#define __TMPM411_unitA_H__

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup Configuration_of_CMSIS
  * @{
  */

/** Interrupt Number Definition */
typedef enum IRQn
{
/******  Cortex-M4 Processor Exceptions Numbers ***************************************************************/
  NonMaskableInt_IRQn           = -14,       /*!< 2 Non Maskable Interrupt                                    */
  HardFault_IRQn                = -13,       /*!< 3 Cortex-M4 Hard Fault Interrupt                            */
  MemoryManagement_IRQn         = -12,       /*!< 4 Cortex-M4 Memory Management Interrupt                     */
  BusFault_IRQn                 = -11,       /*!< 5 Cortex-M4 Bus Fault Interrupt                             */
  UsageFault_IRQn               = -10,       /*!< 6 Cortex-M4 Usage Fault Interrupt                           */
  SVCall_IRQn                   = -5,        /*!< 11 Cortex-M4 SV Call Interrupt                              */
  DebugMonitor_IRQn             = -4,        /*!< 12 Cortex-M4 Debug Monitor Interrupt                        */
  PendSV_IRQn                   = -2,        /*!< 14 Cortex-M4 Pend SV Interrupt                              */
  SysTick_IRQn                  = -1,        /*!< 15 Cortex-M4 System Tick Interrupt                          */

/******  TMPM411_unitA Specific Interrupt Numbers *******************************************************************/
  INTPWRDETF_IRQn               = 0,         /*!< INT_PWRDET pin Interrupt (Falling edge)                     */
  INTPWRDETR_IRQn               = 1,         /*!< INT_PWRDET pin Interrupt (Rising edge)                      */
  INT0_IRQn                     = 2,         /*!< Interrupt pin 0                                             */
  INT1_IRQn                     = 3,         /*!< Interrupt pin 1                                             */
  INT2_IRQn                     = 4,         /*!< Interrupt pin 2                                             */
  INT3_IRQn                     = 5,         /*!< Interrupt pin 3                                             */
  INT4_IRQn                     = 6,         /*!< Interrupt pin 4                                             */
  INTCPUIF0_IRQn                = 7,         /*!< CPU Interface 0 Interrupt                                   */
  INTEVENT_IRQn                 = 8,         /*!< INT_EVENT pin Interrupt (Rising edge)                       */
  INTDISPRQ_IRQn                = 9,         /*!< INT_DISPRQ pin Interrupt (Rising edge)                      */
  INTRX0_IRQn                   = 10,        /*!< Serial0 reception interrupt                                 */
  INTTX0_IRQn                   = 11,        /*!< Serial0 transmission interrupt                              */
  INTRX1_IRQn                   = 12,        /*!< Serial1 reception interrupt                                 */
  INTTX1_IRQn                   = 13,        /*!< Serial1 transmission interrupt                              */
  INTUART0_IRQn                 = 14,        /*!< Full UART0 transmission and reception interrupt             */
  INTI2C0_IRQn                  = 15,        /*!< I2C0 interrupt                                              */
  INTSSP0_IRQn                  = 16,        /*!< SSP0 interrupt                                              */
  INTSSP1_IRQn                  = 17,        /*!< SSP1 interrupt                                              */
  INTSSP2_IRQn                  = 18,        /*!< SSP2 interrupt                                              */
  INTADAHP_IRQn                 = 19,        /*!< High Priority AD conversion interrupt (unitA)               */
  INTADAM0_IRQn                 = 20,        /*!< AD conversion monitor 0 interrupt (unitA)                   */
  INTADAM1_IRQn                 = 21,        /*!< AD conversion monitor 1 interrupt (unitA)                   */
  INTADA_IRQn                   = 22,        /*!< Nornal AD conversion interrupt (unitA)                      */
  INTTB0_IRQn                   = 23,        /*!< 16-bit TMRB0 compare match detection interrupt              */
  INTCAP00_IRQn                 = 24,        /*!< 16-bit TMRB0 input capture 0 detection interrupt            */
  INTCAP01_IRQn                 = 25,        /*!< 16-bit TMRB0 input capture 1 detection interrupt            */
  INTTB1_IRQn                   = 26,        /*!< 16-bit TMRB1 compare match detection interrupt              */
  INTCAP10_IRQn                 = 27,        /*!< 16-bit TMRB1 input capture 0 detection interrupt            */
  INTCAP11_IRQn                 = 28,        /*!< 16-bit TMRB1 input capture 1 detection interrupt            */
  INTTB2_IRQn                   = 29,        /*!< 16-bit TMRB2 compare match detection interrupt              */
  INTCAP20_IRQn                 = 30,        /*!< 16-bit TMRB2 input capture 0 detection interrupt            */
  INTCAP21_IRQn                 = 31,        /*!< 16-bit TMRB2 input capture 1 detection interrupt            */
  INTT16A0_IRQn                 = 32,        /*!< 16-bit TMR16A0 match detection                              */
  INTT16A1_IRQn                 = 33,        /*!< 16-bit TMR16A1 match detection                              */
  INTSDALM_IRQn                 = 34,        /*!< Alarm interrupt                                             */
  INTRTC_IRQn                   = 35,        /*!< Real time counter interupt                                  */
  INTDMAATC0_IRQn               = 36,        /*!< DMAC 0 transmission completion interrupt (unitA)            */
  INTDMAATC1_IRQn               = 37,        /*!< DMAC 1 transmission completion interrupt (unitA)            */
  INTDMAATC2_IRQn               = 38,        /*!< DMAC 2 transmission completion interrupt (unitA)            */
  INTDMAATC3_IRQn               = 39,        /*!< DMAC 3 transmission completion interrupt (unitA)            */
  INTDMAATC4_IRQn               = 40,        /*!< DMAC 4 transmission completion interrupt (unitA)            */
  INTDMAATC5_IRQn               = 41,        /*!< DMAC 5 transmission completion interrupt (unitA)            */
  INTDMAATC6_IRQn               = 42,        /*!< DMAC 6 transmission completion interrupt (unitA)            */
  INTDMAATC7_IRQn               = 43,        /*!< DMAC 7 transmission completion interrupt (unitA)            */
  INTDMAATC8_IRQn               = 44,        /*!< DMAC 8 transmission completion interrupt (unitA)            */
  INTDMAATC9_IRQn               = 45,        /*!< DMAC 9 transmission completion interrupt (unitA)            */
  INTDMAATC10_IRQn              = 46,        /*!< DMAC 10 transmission completion interrupt (unitA)           */
  INTDMAATC11_IRQn              = 47,        /*!< DMAC 11 transmission completion interrupt (unitA)           */
  INTDMAATC12_IRQn              = 48,        /*!< DMAC 12 transmission completion interrupt (unitA)           */
  INTDMAATC13_IRQn              = 49,        /*!< DMAC 13 transmission completion interrupt (unitA)           */
  INTDMAATC14_IRQn              = 50,        /*!< DMAC 14 transmission completion interrupt (unitA)           */
  INTDMAATC15_IRQn              = 51,        /*!< DMAC 15 transmission completion interrupt (unitA)           */
  INTDMAATC16_IRQn              = 52,        /*!< DMAC 16 transmission completion interrupt (unitA)           */
  INTDMAAERR_IRQn               = 53,        /*!< DMAC transmissioni error interrupt (unitA)                  */
  INTFLRDY_IRQn                 = 54         /*!< Flash Ready interrupt                                       */
} IRQn_Type;

/** Processor and Core Peripheral Section */

/* Configuration of the Cortex-M4 Processor and Core Peripherals */
#define __CM4_REV              0x0001       /*!< Cortex-M4 Core Revision                           */
#define __MPU_PRESENT             0         /*!< MPU present or not                                */
#define __NVIC_PRIO_BITS          3         /*!< Number of Bits used for Priority Levels           */
#define __Vendor_SysTickConfig    0         /*!< Set to 1 if different SysTick Config is used      */
#define __FPU_PRESENT							1					/*!< FPU present or not                                */

/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                       /* Cortex-M4 processor and core peripherals            */
#include "system_TMPM411_unitA.h"                 /* TMPM411_unitA System                                      */

/** @addtogroup Device_Peripheral_registers
  * @{
  */

/** Device Specific Peripheral registers structures */

/**
  * @brief LCD Driver (LCD)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< Enable Register                              */
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t BUF00;             /*!< Buffer Register 00                           */
  __IO uint32_t BUF01;             /*!< Buffer Register 01                           */
  __IO uint32_t BUF02;             /*!< Buffer Register 02                           */
  __IO uint32_t BUF03;             /*!< Buffer Register 03                           */
  __IO uint32_t BUF04;             /*!< Buffer Register 04                           */
  __IO uint32_t BUF05;             /*!< Buffer Register 05                           */
  __IO uint32_t BUF06;             /*!< Buffer Register 06                           */
  __IO uint32_t BUF07;             /*!< Buffer Register 07                           */
  __IO uint32_t BUF08;             /*!< Buffer Register 08                           */
  __IO uint32_t BUF09;             /*!< Buffer Register 09                           */
  __IO uint32_t BUF10;             /*!< Buffer Register 10                           */
  __IO uint32_t BUF11;             /*!< Buffer Register 11                           */
  __IO uint32_t BUF12;             /*!< Buffer Register 12                           */
  __IO uint32_t BUF13;             /*!< Buffer Register 13                           */
  __IO uint32_t BUF14;             /*!< Buffer Register 14                           */
  __IO uint32_t BUF15;             /*!< Buffer Register 15                           */
} TSB_LCD_TypeDef;

/**
  * @brief Alyays On (AO)
  */
typedef struct
{
  __IO uint8_t  CR0;               /*!< Display Selection Register                   */
  __IO uint8_t  CR1;               /*!< Configuration Register                       */
  __IO uint8_t  CR2;               /*!< Display Screen Register                      */
  __IO uint8_t  CR3;               /*!< Total Display Time Register                  */
  __IO uint8_t  CR4;               /*!< Screen Switch Time Register                  */
  __IO uint8_t  CR5;               /*!< Response Count Register                      */
  __IO uint8_t  CR6;               /*!< Display Reponse Register                     */
       uint8_t  RESERVED0;
  __I  uint8_t  CR8;               /*!< Display Start Time Register (Second)         */
  __I  uint8_t  CR9;               /*!< Display Start Time Register (Minutes)        */
  __I  uint8_t  CR10;              /*!< Display Start Time Register (Hour)           */
  __I  uint8_t  CR11;              /*!< Display Start Time Register (Day)            */
  __I  uint8_t  CR12;              /*!< Display Start Time Register (Month)          */
  __I  uint8_t  CR13;              /*!< Display Start Time Register (Year)           */
  __IO uint8_t  CR14;              /*!< Low-speec Clock Control Register             */
} TSB_AO_TypeDef;

/**
  * @brief Synchronous Serial Port (SSP)
  */
typedef struct
{
  __IO uint32_t CR0;               /*!< SSP Control Register 0                       */
  __IO uint32_t CR1;               /*!< SSP Control Register 1                       */
  __IO uint32_t DR;                /*!< SSP Data Register                            */
  __I  uint32_t SR;                /*!< SSP Status Register                          */
  __IO uint32_t CPSR;              /*!< SSP Clock Prescaler Register                 */
  __IO uint32_t IMSC;              /*!< SSP Interrupt Mask Set and Clear Register    */
  __I  uint32_t RIS;               /*!< SSP Raw Interrupt Status Register            */
  __I  uint32_t MIS;               /*!< SSP Masked Interrupt Status Register         */
  __O  uint32_t ICR;               /*!< SSP Interrupt Clear Register                 */
  __IO uint32_t DMACR;             /*!< SSP DMA Control Register                     */
} TSB_SSP_TypeDef;

#if defined ( __CC_ARM   )           /* RealView Compiler */
#pragma anon_unions
#elif (defined (__ICCARM__))         /*  ICC Compiler     */
#pragma language=extended
#endif

/**
  * @brief UART (Full UART)
  */
typedef struct
{
  __IO uint32_t DR;                /*!< Data Register                                */
union {
  __I  uint32_t RSR;               /*!< Receive Status Register                      */
  __O  uint32_t ECR;               /*!< Error Clear Register                         */
  };
       uint32_t RESERVED0[4];
  __I  uint32_t FR;                /*!< Flag Register                                */
       uint32_t RESERVED1;
  __IO uint32_t ILPR;              /*!< IrDA low-power counter Register              */
  __IO uint32_t IBRD;              /*!< Integer Baud Rate Register                   */
  __IO uint32_t FBRD;              /*!< Fractional Baud Rate Register                */
  __IO uint32_t LCR_H;             /*!< Line Control Register                        */
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t IFLS;              /*!< Interrupt FIFO Level Select Register         */
  __IO uint32_t IMSC;              /*!< Interrupt Mask Set/Clear Register            */
  __I  uint32_t RIS;               /*!< Raw Interrupt Status Register                */
  __I  uint32_t MIS;               /*!< Masked Interrupt Status Register             */
  __O  uint32_t ICR;               /*!< Interrupt Clear Register                     */
  __IO uint32_t DMACR;             /*!< DMA Control Register                         */
} TSB_UART_TypeDef;

/**
  * @brief DMA Controller (DMA)
  */
typedef struct
{
  __I  uint32_t STATUS;            /*!< DMA Status Register                          */
  __O  uint32_t CFG;               /*!< DMA Configuration Register                   */
  __IO uint32_t CTRLBASEPTR;       /*!< DMA Control Data Base Pointer Register       */
  __I  uint32_t ALTCTRLBASEPTR;    /*!< DMA Channel Alternate Control Data Base Pointer Register*/
       uint32_t RESERVED0;
  __O  uint32_t CHNLSWREQUEST;     /*!< DMA Channel Software Request Register        */
  __IO uint32_t CHNLUSEBURSTSET;   /*!< DMA Channel Useburst Set Register            */
  __O  uint32_t CHNLUSEBURSTCLR;   /*!< DMA Channel Useburst Clear Register          */
  __IO uint32_t CHNLREQMASKSET;    /*!< DMA Channel Request Mask Set Register        */
  __O  uint32_t CHNLREQMASKCLR;    /*!< DMA Channel Request Mask Clear Register      */
  __IO uint32_t CHNLENABLESET;     /*!< DMA Channel Enable Set Register              */
  __O  uint32_t CHNLENABLECLR;     /*!< DMA Channel Enable Clear Register            */
  __IO uint32_t CHNLPRIALTSET;     /*!< DMA Channel Primary-Alternate Set Register   */
  __O  uint32_t CHNLPRIALTCLR;     /*!< DMA Channel Primary-Alternate Clear Register */
  __IO uint32_t CHNLPRIORITYSET;   /*!< DMA Channel Priority Set Register            */
  __O  uint32_t CHNLPRIORITYCLR;   /*!< DMA Channel Priority Clear Register          */
       uint32_t RESERVED1[3];
  __IO uint32_t ERRCLR;            /*!< DMA Bus Error Clear Register                 */
} TSB_DMA_TypeDef;

/**
  * @brief 12bit A/D Converter (AD)
  */
typedef struct
{
  __IO uint32_t CLK;               /*!< Conversion Clock Setting Register            */
  __O  uint32_t MOD0;              /*!< Mode Control Register0                       */
  __IO uint32_t MOD1;              /*!< Mode Control Register1                       */
  __IO uint32_t MOD2;              /*!< Mode Control Register2                       */
  __IO uint32_t MOD3;              /*!< Mode Control Register3                       */
  __IO uint32_t MOD4;              /*!< Mode Control Register4                       */
  __I  uint32_t MOD5;              /*!< Mode Control Register5                       */
  __O  uint32_t MOD6;              /*!< Mode Control Register6                       */
       uint32_t RESERVED0;
  __IO uint32_t CMPCR0;            /*!< Monitoring Interrupt Control Register0       */
  __IO uint32_t CMPCR1;            /*!< Monitoring Interrupt Control Register1       */
  __IO uint32_t CMP0;              /*!< Conversion Result Compare Register0          */
  __IO uint32_t CMP1;              /*!< Conversion Result Compare Register1          */
  __I  uint32_t REG00;             /*!< Conversion Result Store Register0            */
  __I  uint32_t REG01;             /*!< Conversion Result Store Register1            */
  __I  uint32_t REG02;             /*!< Conversion Result Store Register2            */
  __I  uint32_t REG03;             /*!< Conversion Result Store Register3            */
  __I  uint32_t REG04;             /*!< Conversion Result Store Register4            */
  __I  uint32_t REG05;             /*!< Conversion Result Store Register5            */
  __I  uint32_t REG06;             /*!< Conversion Result Store Register6            */
  __I  uint32_t REG07;             /*!< Conversion Result Store Register7            */
  __I  uint32_t REG08;             /*!< Conversion Result Store Register8            */
  __I  uint32_t REG09;             /*!< Conversion Result Store Register9            */
  __I  uint32_t REG10;             /*!< Conversion Result Store Register10           */
  __I  uint32_t REG11;             /*!< Conversion Result Store Register11           */
  __I  uint32_t REG12;             /*!< Conversion Result Store Register12           */
  __I  uint32_t REG13;             /*!< Conversion Result Store Register13           */
  __I  uint32_t REG14;             /*!< Conversion Result Store Register14           */
  __I  uint32_t REG15;             /*!< Conversion Result Store Register15           */
  __I  uint32_t REGSP;             /*!< Highest Priority Conversion Result Store Register*/
} TSB_AD_TypeDef;

/**
  * @brief 16-bit TimerA (T16A)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< Enable Register                              */
  __IO uint32_t RUN;               /*!< RUN Register                                 */
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t RG;                /*!< Timer Register                               */
  __I  uint32_t CP;                /*!< Capture Register                             */
} TSB_T16A_TypeDef;

/**
  * @brief I2C Bus Interface (I2C)
  */
typedef struct
{
  __IO uint32_t CR1;               /*!< I2C Control Register 1                       */
  __IO uint32_t DBR;               /*!< Data Buffer Register                         */
  __IO uint32_t AR;                /*!< Bus address Register                         */
union {
  __O  uint32_t CR2;               /*!<  Control Register 1                          */
  __I  uint32_t SR;                /*!< Status Register                              */
  };
  __IO uint32_t PRS;               /*!< Prescaler clcok setting Register             */
  __IO uint32_t IE;                /*!< Interrupt Enable Register                    */
  __IO uint32_t IR;                /*!< Interrupt Register                           */
} TSB_I2C_TypeDef;

/**
  * @brief Interrupt Controller (INT)
  */
typedef struct
{
  __IO uint32_t CR0;               /*!< Control Register 0                           */
  __IO uint32_t CR1;               /*!< Control Register 1                           */
  __IO uint32_t CR2;               /*!< Control Register 2                           */
  __IO uint32_t CR3;               /*!< Control Register 3                           */
  __IO uint32_t CR4;               /*!< Control Register 4                           */
  __IO uint32_t CR5;               /*!< Control Register 5                           */
  __IO uint32_t CR6;               /*!< Control Register 6                           */
  __IO uint32_t CR7;               /*!< Control Register 7                           */
  __IO uint32_t CR8;               /*!< Control Register 8                           */
  __IO uint32_t CR9;               /*!< Control Register 9                           */
  __IO uint32_t CR10;              /*!< Control Register 10                          */
  __IO uint32_t CR11;              /*!< Control Register 11                          */
  __IO uint32_t CR12;              /*!< Control Register 12                          */
  __IO uint32_t CR13;              /*!< Control Register 13                          */
  __IO uint32_t CR14;              /*!< Control Register 14                          */
  __IO uint32_t CR15;              /*!< Control Register 15                          */
  __IO uint32_t EN;                /*!< STOP1 Mode Release Setting Register          */
  __O  uint32_t CLR;               /*!< Interrupt Request Clear Register             */
  __IO uint32_t RESETF;            /*!< Reset Flag Register                          */
  __I  uint32_t NMIF;              /*!< NMI Flag Register                            */
  __IO uint32_t RETF;              /*!< STOP2/STOP3 Release Flag Register            */
  __I  uint32_t LVDST;             /*!< SD2 Area Voltage Status Register             */
} TSB_INT_TypeDef;

/**
  * @brief CPU Interface (CPUIF)
  */
typedef struct
{
  __IO uint32_t INTCR;             /*!< Interrupt Control Regiser                    */
  __IO uint32_t INTCLR;            /*!< Interrupt Clear Register                     */
  __IO uint32_t INFOW;             /*!< Transmit Data Register                       */
  __I  uint32_t INFOR;             /*!< Receive Data Register                        */
  __IO uint32_t CKCR;              /*!< Clock Control Register for Unit B            */
  __IO uint32_t RSTCR;             /*!< Reset Control Register for Unit B            */
} TSB_CPUIF_TypeDef;

/**
  * @brief Port A (PA)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port A Data Register                         */
  __IO uint32_t CR;                /*!< Port A Output Control Register               */
  __IO uint32_t FR1;               /*!< Port A Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port A Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port A Pull-up Control Register              */
  __IO uint32_t PDN;               /*!< Port A Pull-down Control Register            */
       uint32_t RESERVED1;
  __IO uint32_t IE;                /*!< Port A Input Control Register                */
} TSB_PA_TypeDef;

/**
  * @brief Port B (PB)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port B Data Register                         */
  __IO uint32_t CR;                /*!< Port B Output Control Register               */
  __IO uint32_t FR1;               /*!< Port B Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port B Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port B Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port B Input Control Register                */
} TSB_PB_TypeDef;

/**
  * @brief Port C (PC)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port C Data Register                         */
  __IO uint32_t CR;                /*!< Port C Output Control Register               */
  __IO uint32_t FR1;               /*!< Port C Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port C Function Register 2                   */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;                /*!< Port C Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port C Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port C Input Control Register                */
} TSB_PC_TypeDef;

/**
  * @brief Port D (PD)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port D Data Register                         */
  __IO uint32_t CR;                /*!< Port D Output Control Register               */
  __IO uint32_t FR1;               /*!< Port D Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port D Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port D Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port D Input Control Register                */
} TSB_PD_TypeDef;

/**
  * @brief Port E (PE)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port E Data Register                         */
  __IO uint32_t CR;                /*!< Port E Output Control Register               */
  __IO uint32_t FR1;               /*!< Port E Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port E Function Register 2                   */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;                /*!< Port E Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port E Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port E Input Control Register                */
} TSB_PE_TypeDef;

/**
  * @brief Port F (PF)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port F Data Register                         */
  __IO uint32_t CR;                /*!< Port F Output Control Register               */
  __IO uint32_t FR1;               /*!< Port F Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port F Open-drain Control Register           */
  __IO uint32_t PUP;               /*!< Port F Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port F Input Control Register                */
} TSB_PF_TypeDef;

/**
  * @brief Port G (PG)
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port G Data Register                         */
  __IO uint32_t CR;                /*!< Port G Output Control Register               */
       uint32_t RESERVED0[9];
  __IO uint32_t PUP;               /*!< Port G Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port G Input Control Register                */
} TSB_PG_TypeDef;

/**
  * @brief 16-bit Timer/Event Counter (TB)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< TB Enable Register                           */
  __IO uint32_t RUN;               /*!< TB RUN Register                              */
  __IO uint32_t CR;                /*!< TB Control Register                          */
  __IO uint32_t MOD;               /*!< TB Mode Register                             */
  __IO uint32_t FFCR;              /*!< TB Flip-Flop Control Register                */
  __I  uint32_t ST;                /*!< TB Status Register                           */
  __IO uint32_t IM;                /*!< TB Interrupt Mask Register                   */
  __I  uint32_t UC;                /*!< TB Up-counter Capture Register               */
  __IO uint32_t RG0;               /*!< TB RG0 Timer Register                        */
  __IO uint32_t RG1;               /*!< TB RG1 Timer Register                        */
  __I  uint32_t CP0;               /*!< TB CP0 Capture Register                      */
  __I  uint32_t CP1;               /*!< TB CP1 Capture Register                      */
} TSB_TB_TypeDef;

/**
  * @brief Real Time Clock (RTC)
  */
typedef struct
{
  __IO uint8_t  SECR;              /*!< RTC Second Column Register                   */
  __IO uint8_t  MINR;              /*!< RTC Minute Column Register                   */
  __IO uint8_t  HOURR;             /*!< RTC Hour Column Register                     */
       uint8_t  RESERVED0;
  __IO uint8_t  DAYR;              /*!< RTC Day of the Week Column Register          */
  __IO uint8_t  DATER;             /*!< RTC Day Column Register                      */
  __IO uint8_t  MONTHR;            /*!< RTC Month Column Register                    */
  __IO uint8_t  YEARR;             /*!< RTC Year Column Register                     */
  __IO uint8_t  TPROD;             /*!< RTC (AM/PM) Selection Register               */
  __IO uint8_t  LEAPR;             /*!< RTC Leap Year Register                       */
       uint8_t  RESERVED1[2];
  __IO uint8_t  RESTR;             /*!< RTC Reset Register                           */
  __IO uint8_t  ENCR;              /*!<                                              */
  __IO uint8_t  PROTECT;           /*!< RTC protect register                         */
  __IO uint8_t  ADJCTL;            /*!< Clock Correction Function Control Register   */
  __IO uint16_t ADJDAT;            /*!< Clock Correction Value Register              */
  __IO uint8_t  CLKCR;             /*!< Clock Control Register                       */
  __IO uint8_t  STA;               /*!< Transfer Enable Register                     */
       uint8_t  RESERVED2[12];
  __IO uint8_t  ASECR;             /*!< Alarm Second Column Register                 */
  __IO uint8_t  AMINR;             /*!< Alarm Minute Column Register                 */
  __IO uint8_t  AHOURR;            /*!< Alarm Hour Column Register                   */
       uint8_t  RESERVED3;
  __IO uint8_t  ADAYR;             /*!< Alarm Day of the Week Column Register        */
  __IO uint8_t  ADATER;            /*!< Alarm Day Column Register                    */
} TSB_RTC_TypeDef;

/**
  * @brief SIO/UART (SC)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< SC Enable Register                           */
  __IO uint32_t BUF;               /*!< SC Buffer Register                           */
  __IO uint32_t CR;                /*!< SC Control Register                          */
  __IO uint32_t MOD0;              /*!< SC Mode Control Register 0                   */
  __IO uint32_t BRCR;              /*!< SC Baud Rate Generator Control Register      */
  __IO uint32_t BRADD;             /*!< SC Baud Rate Generator Control Register 2    */
  __IO uint32_t MOD1;              /*!< SC Mode Control Register 1                   */
  __IO uint32_t MOD2;              /*!< SC Mode Control Register 2                   */
  __IO uint32_t RFC;               /*!< SC RX FIFO Configuration Register            */
  __IO uint32_t TFC;               /*!< SC TX FIFO Configuration Register            */
  __I  uint32_t RST;               /*!< SC RX FIFO Status Register                   */
  __I  uint32_t TST;               /*!< SC TX FIFO Status Register                   */
  __IO uint32_t FCNF;              /*!< SC FIFO Configuration Register               */
} TSB_SC_TypeDef;

/**
  * @brief Watchdog Timer (WD)
  */
typedef struct
{
  __IO uint32_t MOD;               /*!< Mode Register                                */
  __O  uint32_t CR;                /*!< Control Register                             */
  __I  uint32_t FLG;               /*!< Flag Register                                */
} TSB_WD_TypeDef;

/**
  * @brief Clock Control (CG)
  */
typedef struct
{
  __IO uint32_t PROTECT;           /*!< Protect Register                             */
  __IO uint32_t OSCSEL;            /*!< High-speed oscillation select Register       */
  __I  uint32_t OSCSTF;            /*!< High-speed oscillation status Register       */
  __IO uint32_t CLKCR;             /*!< Clock Control Register                       */
  __IO uint32_t STBYCR;            /*!< Standby Control Register                     */
  __IO uint32_t CLKMSK;            /*!< Clock supply control Register                */
  __IO uint32_t OSCEN;             /*!< Oscillation enable Register                  */
  __IO uint32_t PLLSET;            /*!< PLL setting Register                         */
  __IO uint32_t PLLEN;             /*!< PLL enable Register                          */
  __IO uint32_t WUHCR;             /*!< High-speed oscillation warm-up Control Register*/
  __IO uint32_t WULCR;             /*!< Low-speed oscillation warm-up Control Register*/
  __IO uint32_t SCOCR;             /*!< SCOUT Control Register                       */
} TSB_CG_TypeDef;

/**
  * @brief Flash Control (FC)
  */
typedef struct
{
       uint32_t RESERVED0[4];
  __IO uint32_t SECBIT;            /*!< Security Bit Register                        */
       uint32_t RESERVED1[3];
  __I  uint32_t PSR0;              /*!< Protect Status Register 0                    */
       uint32_t RESERVED2[55];
  __I  uint32_t SR;                /*!< Status Register                              */
  __I  uint32_t SWPSR;             /*!< Swap Status Register                         */
       uint32_t RESERVED3[14];
  __IO uint32_t AREASEL;           /*!< Area Selection Register                      */
       uint32_t RESERVED4;
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t STSCLR;            /*!< Status Clear Register                        */
  __IO uint32_t WCLKCR;            /*!< WCLK Configuration Register                  */
  __IO uint32_t PROGCR;            /*!< Program Counter Configuration Register       */
  __IO uint32_t ERASECR;           /*!< Erase Counter Configuration Register         */
} TSB_FC_TypeDef;


/* Memory map */
#define FLASH_BASE            (0x00000000UL)
#define RAM_BASE              (0x20000000UL)
#define PERI_BASE             (0x40000000UL)


#define TSB_LCD_BASE               (PERI_BASE  + 0x003C000UL)
#define TSB_AO_BASE                (PERI_BASE  + 0x003C480UL)
#define TSB_SSP0_BASE              (PERI_BASE  + 0x0040000UL)
#define TSB_SSP1_BASE              (PERI_BASE  + 0x0041000UL)
#define TSB_SSP2_BASE              (PERI_BASE  + 0x0042000UL)
#define TSB_UART0_BASE             (PERI_BASE  + 0x0048000UL)
#define TSB_DMAA_BASE              (PERI_BASE  + 0x004C000UL)
#define TSB_ADA_BASE               (PERI_BASE  + 0x0050000UL)
#define TSB_T16A0_BASE             (PERI_BASE  + 0x008D000UL)
#define TSB_T16A1_BASE             (PERI_BASE  + 0x008E000UL)
#define TSB_I2C0_BASE              (PERI_BASE  + 0x00A0000UL)
#define TSB_INT0_BASE              (PERI_BASE  + 0x00B8000UL)
#define TSB_CPUIF0_BASE            (PERI_BASE  + 0x00BC000UL)
#define TSB_PA_BASE                (PERI_BASE  + 0x00C0000UL)
#define TSB_PB_BASE                (PERI_BASE  + 0x00C0100UL)
#define TSB_PC_BASE                (PERI_BASE  + 0x00C0200UL)
#define TSB_PD_BASE                (PERI_BASE  + 0x00C0300UL)
#define TSB_PE_BASE                (PERI_BASE  + 0x00C0400UL)
#define TSB_PF_BASE                (PERI_BASE  + 0x00C0500UL)
#define TSB_PG_BASE                (PERI_BASE  + 0x00C0600UL)
#define TSB_TB0_BASE               (PERI_BASE  + 0x00C4000UL)
#define TSB_TB1_BASE               (PERI_BASE  + 0x00C4100UL)
#define TSB_TB2_BASE               (PERI_BASE  + 0x00C4200UL)
#define TSB_RTC_BASE               (PERI_BASE  + 0x00CC000UL)
#define TSB_SC0_BASE               (PERI_BASE  + 0x00E1000UL)
#define TSB_SC1_BASE               (PERI_BASE  + 0x00E1100UL)
#define TSB_WD0_BASE               (PERI_BASE  + 0x00F2000UL)
#define TSB_CG0_BASE               (PERI_BASE  + 0x00F3000UL)
#define TSB_FC_BASE                (PERI_BASE  + 0x1DFF0000UL)


/* Peripheral declaration */
#define TSB_LCD                    ((    TSB_LCD_TypeDef *)   TSB_LCD_BASE)
#define TSB_AO                     ((     TSB_AO_TypeDef *)    TSB_AO_BASE)
#define TSB_SSP0                   ((    TSB_SSP_TypeDef *)  TSB_SSP0_BASE)
#define TSB_SSP1                   ((    TSB_SSP_TypeDef *)  TSB_SSP1_BASE)
#define TSB_SSP2                   ((    TSB_SSP_TypeDef *)  TSB_SSP2_BASE)
#define TSB_UART0                  ((   TSB_UART_TypeDef *) TSB_UART0_BASE)
#define TSB_DMAA                   ((    TSB_DMA_TypeDef *)  TSB_DMAA_BASE)
#define TSB_ADA                    ((     TSB_AD_TypeDef *)   TSB_ADA_BASE)
#define TSB_T16A0                  ((   TSB_T16A_TypeDef *) TSB_T16A0_BASE)
#define TSB_T16A1                  ((   TSB_T16A_TypeDef *) TSB_T16A1_BASE)
#define TSB_I2C0                   ((    TSB_I2C_TypeDef *)  TSB_I2C0_BASE)
#define TSB_INT0                   ((    TSB_INT_TypeDef *)  TSB_INT0_BASE)
#define TSB_CPUIF0                 ((  TSB_CPUIF_TypeDef *)TSB_CPUIF0_BASE)
#define TSB_PA                     ((     TSB_PA_TypeDef *)    TSB_PA_BASE)
#define TSB_PB                     ((     TSB_PB_TypeDef *)    TSB_PB_BASE)
#define TSB_PC                     ((     TSB_PC_TypeDef *)    TSB_PC_BASE)
#define TSB_PD                     ((     TSB_PD_TypeDef *)    TSB_PD_BASE)
#define TSB_PE                     ((     TSB_PE_TypeDef *)    TSB_PE_BASE)
#define TSB_PF                     ((     TSB_PF_TypeDef *)    TSB_PF_BASE)
#define TSB_PG                     ((     TSB_PG_TypeDef *)    TSB_PG_BASE)
#define TSB_TB0                    ((     TSB_TB_TypeDef *)   TSB_TB0_BASE)
#define TSB_TB1                    ((     TSB_TB_TypeDef *)   TSB_TB1_BASE)
#define TSB_TB2                    ((     TSB_TB_TypeDef *)   TSB_TB2_BASE)
#define TSB_RTC                    ((    TSB_RTC_TypeDef *)   TSB_RTC_BASE)
#define TSB_SC0                    ((     TSB_SC_TypeDef *)   TSB_SC0_BASE)
#define TSB_SC1                    ((     TSB_SC_TypeDef *)   TSB_SC1_BASE)
#define TSB_WD0                    ((     TSB_WD_TypeDef *)   TSB_WD0_BASE)
#define TSB_CG0                    ((     TSB_CG_TypeDef *)   TSB_CG0_BASE)
#define TSB_FC                     ((     TSB_FC_TypeDef *)    TSB_FC_BASE)


/* Bit-Band for Device Specific Peripheral Registers */
#define BITBAND_OFFSET (0x02000000UL)
#define BITBAND_PERI_BASE (PERI_BASE + BITBAND_OFFSET)
#define BITBAND_PERI(addr, bitnum) (BITBAND_PERI_BASE + (((uint32_t)(addr) - PERI_BASE) << 5) + ((uint32_t)(bitnum) << 2))



/* LCD Driver (LCD) */
#define TSB_LCD_EN_LEDE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_LCD->EN,0)))
#define TSB_LCD_CR_LCDCLK                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_LCD->CR,0)))
#define TSB_LCD_CR_CPEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_LCD->CR,7)))
#define TSB_LCD_CR_EDSP                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_LCD->CR,8)))


/* Alyays On (AO) */
#define TSB_AO_CR0_MODE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_AO->CR0,0)))
#define TSB_AO_CR1_CPEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_AO->CR1,7)))
#define TSB_AO_CR10_HSEL                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_AO->CR10,6)))
#define TSB_AO_CR14_DRVOSCL                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_AO->CR14,0)))
#define TSB_AO_CR14_AOCKSEL                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_AO->CR14,1)))
#define TSB_AO_CR14_AOCKF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_AO->CR14,2)))


/* Synchronous Serial Port (SSP) */
#define TSB_SSP0_CR0_SPO                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR0,6)))
#define TSB_SSP0_CR0_SPH                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR0,7)))
#define TSB_SSP0_CR1_LBM                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,0)))
#define TSB_SSP0_CR1_SSE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,1)))
#define TSB_SSP0_CR1_MS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,2)))
#define TSB_SSP0_CR1_SOD                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->CR1,3)))
#define TSB_SSP0_SR_TFE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR,0)))
#define TSB_SSP0_SR_TNF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR,1)))
#define TSB_SSP0_SR_RNE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR,2)))
#define TSB_SSP0_SR_RFF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR,3)))
#define TSB_SSP0_SR_BSY                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->SR,4)))
#define TSB_SSP0_IMSC_RORIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,0)))
#define TSB_SSP0_IMSC_RTIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,1)))
#define TSB_SSP0_IMSC_RXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,2)))
#define TSB_SSP0_IMSC_TXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->IMSC,3)))
#define TSB_SSP0_RIS_RORRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,0)))
#define TSB_SSP0_RIS_RTRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,1)))
#define TSB_SSP0_RIS_RXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,2)))
#define TSB_SSP0_RIS_TXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->RIS,3)))
#define TSB_SSP0_MIS_RORMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,0)))
#define TSB_SSP0_MIS_RTMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,1)))
#define TSB_SSP0_MIS_RXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,2)))
#define TSB_SSP0_MIS_TXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP0->MIS,3)))
#define TSB_SSP0_ICR_RORIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP0->ICR,0)))
#define TSB_SSP0_ICR_RTIC                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP0->ICR,1)))
#define TSB_SSP0_DMACR_RXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->DMACR,0)))
#define TSB_SSP0_DMACR_TXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP0->DMACR,1)))

#define TSB_SSP1_CR0_SPO                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR0,6)))
#define TSB_SSP1_CR0_SPH                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR0,7)))
#define TSB_SSP1_CR1_LBM                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,0)))
#define TSB_SSP1_CR1_SSE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,1)))
#define TSB_SSP1_CR1_MS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,2)))
#define TSB_SSP1_CR1_SOD                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->CR1,3)))
#define TSB_SSP1_SR_TFE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR,0)))
#define TSB_SSP1_SR_TNF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR,1)))
#define TSB_SSP1_SR_RNE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR,2)))
#define TSB_SSP1_SR_RFF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR,3)))
#define TSB_SSP1_SR_BSY                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->SR,4)))
#define TSB_SSP1_IMSC_RORIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,0)))
#define TSB_SSP1_IMSC_RTIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,1)))
#define TSB_SSP1_IMSC_RXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,2)))
#define TSB_SSP1_IMSC_TXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->IMSC,3)))
#define TSB_SSP1_RIS_RORRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,0)))
#define TSB_SSP1_RIS_RTRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,1)))
#define TSB_SSP1_RIS_RXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,2)))
#define TSB_SSP1_RIS_TXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->RIS,3)))
#define TSB_SSP1_MIS_RORMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,0)))
#define TSB_SSP1_MIS_RTMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,1)))
#define TSB_SSP1_MIS_RXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,2)))
#define TSB_SSP1_MIS_TXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP1->MIS,3)))
#define TSB_SSP1_ICR_RORIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP1->ICR,0)))
#define TSB_SSP1_ICR_RTIC                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP1->ICR,1)))
#define TSB_SSP1_DMACR_RXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->DMACR,0)))
#define TSB_SSP1_DMACR_TXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP1->DMACR,1)))

#define TSB_SSP2_CR0_SPO                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR0,6)))
#define TSB_SSP2_CR0_SPH                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR0,7)))
#define TSB_SSP2_CR1_LBM                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR1,0)))
#define TSB_SSP2_CR1_SSE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR1,1)))
#define TSB_SSP2_CR1_MS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR1,2)))
#define TSB_SSP2_CR1_SOD                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->CR1,3)))
#define TSB_SSP2_SR_TFE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->SR,0)))
#define TSB_SSP2_SR_TNF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->SR,1)))
#define TSB_SSP2_SR_RNE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->SR,2)))
#define TSB_SSP2_SR_RFF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->SR,3)))
#define TSB_SSP2_SR_BSY                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->SR,4)))
#define TSB_SSP2_IMSC_RORIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->IMSC,0)))
#define TSB_SSP2_IMSC_RTIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->IMSC,1)))
#define TSB_SSP2_IMSC_RXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->IMSC,2)))
#define TSB_SSP2_IMSC_TXIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->IMSC,3)))
#define TSB_SSP2_RIS_RORRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->RIS,0)))
#define TSB_SSP2_RIS_RTRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->RIS,1)))
#define TSB_SSP2_RIS_RXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->RIS,2)))
#define TSB_SSP2_RIS_TXRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->RIS,3)))
#define TSB_SSP2_MIS_RORMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->MIS,0)))
#define TSB_SSP2_MIS_RTMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->MIS,1)))
#define TSB_SSP2_MIS_RXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->MIS,2)))
#define TSB_SSP2_MIS_TXMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP2->MIS,3)))
#define TSB_SSP2_ICR_RORIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP2->ICR,0)))
#define TSB_SSP2_ICR_RTIC                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP2->ICR,1)))
#define TSB_SSP2_DMACR_RXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->DMACR,0)))
#define TSB_SSP2_DMACR_TXDMAE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP2->DMACR,1)))


/* UART (Full UART) */
#define TSB_UART0_DR_FE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,8)))
#define TSB_UART0_DR_PE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,9)))
#define TSB_UART0_DR_BE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,10)))
#define TSB_UART0_DR_OE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,11)))
#define TSB_UART0_RSR_FE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,0)))
#define TSB_UART0_RSR_PE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,1)))
#define TSB_UART0_RSR_BE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,2)))
#define TSB_UART0_RSR_OE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,3)))
#define TSB_UART0_ECR_FE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,0)))
#define TSB_UART0_ECR_PE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,1)))
#define TSB_UART0_ECR_BE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,2)))
#define TSB_UART0_ECR_OE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,3)))
#define TSB_UART0_FR_CTS                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,0)))
#define TSB_UART0_FR_DSR                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,1)))
#define TSB_UART0_FR_DCD                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,2)))
#define TSB_UART0_FR_BUSY                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,3)))
#define TSB_UART0_FR_RXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,4)))
#define TSB_UART0_FR_TXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,5)))
#define TSB_UART0_FR_RXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,6)))
#define TSB_UART0_FR_TXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,7)))
#define TSB_UART0_FR_RI                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,8)))
#define TSB_UART0_LCR_H_BRK                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,0)))
#define TSB_UART0_LCR_H_PEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,1)))
#define TSB_UART0_LCR_H_EPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,2)))
#define TSB_UART0_LCR_H_STP2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,3)))
#define TSB_UART0_LCR_H_FEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,4)))
#define TSB_UART0_LCR_H_SPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,7)))
#define TSB_UART0_CR_UARTEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,0)))
#define TSB_UART0_CR_SIREN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,1)))
#define TSB_UART0_CR_SIRLP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,2)))
#define TSB_UART0_CR_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,8)))
#define TSB_UART0_CR_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,9)))
#define TSB_UART0_CR_DTR                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,10)))
#define TSB_UART0_CR_RTS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,11)))
#define TSB_UART0_CR_RTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,14)))
#define TSB_UART0_CR_CTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,15)))
#define TSB_UART0_IMSC_RIMIM                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,0)))
#define TSB_UART0_IMSC_CTSMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,1)))
#define TSB_UART0_IMSC_DCDMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,2)))
#define TSB_UART0_IMSC_DSRMIN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,3)))
#define TSB_UART0_IMSC_RXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,4)))
#define TSB_UART0_IMSC_TXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,5)))
#define TSB_UART0_IMSC_RTIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,6)))
#define TSB_UART0_IMSC_FEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,7)))
#define TSB_UART0_IMSC_PEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,8)))
#define TSB_UART0_IMSC_BEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,9)))
#define TSB_UART0_IMSC_OEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,10)))
#define TSB_UART0_RIS_RIRMIS                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,0)))
#define TSB_UART0_RIS_CTSRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,1)))
#define TSB_UART0_RIS_DCDRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,2)))
#define TSB_UART0_RIS_DSRRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,3)))
#define TSB_UART0_RIS_RXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,4)))
#define TSB_UART0_RIS_TXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,5)))
#define TSB_UART0_RIS_RTRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,6)))
#define TSB_UART0_RIS_FERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,7)))
#define TSB_UART0_RIS_PERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,8)))
#define TSB_UART0_RIS_BERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,9)))
#define TSB_UART0_RIS_OERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,10)))
#define TSB_UART0_MIS_RIMMIS                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,0)))
#define TSB_UART0_MIS_CTSMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,1)))
#define TSB_UART0_MIS_DCDMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,2)))
#define TSB_UART0_MIS_DSRMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,3)))
#define TSB_UART0_MIS_RXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,4)))
#define TSB_UART0_MIS_TXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,5)))
#define TSB_UART0_MIS_RTMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,6)))
#define TSB_UART0_MIS_FEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,7)))
#define TSB_UART0_MIS_PEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,8)))
#define TSB_UART0_MIS_BEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,9)))
#define TSB_UART0_MIS_OEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,10)))
#define TSB_UART0_ICR_RIMIC                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,0)))
#define TSB_UART0_ICR_CTSMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,1)))
#define TSB_UART0_ICR_DCDMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,2)))
#define TSB_UART0_ICR_DSRMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,3)))
#define TSB_UART0_ICR_RXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,4)))
#define TSB_UART0_ICR_TXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,5)))
#define TSB_UART0_ICR_RTIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,6)))
#define TSB_UART0_ICR_FEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,7)))
#define TSB_UART0_ICR_PEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,8)))
#define TSB_UART0_ICR_BEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,9)))
#define TSB_UART0_ICR_OEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,10)))
#define TSB_UART0_DMACR_RXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->DMACR,0)))
#define TSB_UART0_DMACR_TXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->DMACR,1)))
#define TSB_UART0_DMACR_DMAONERR                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->DMACR,2)))


/* DMA Controller (DMA) */
#define TSB_DMAA_STATUS_MASTER_ENABLE             (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAA->STATUS,0)))
#define TSB_DMAA_CFG_MASTER_ENABLE                (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAA->CFG,0)))
#define TSB_DMAA_ERRCLR_ERR_CLR                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAA->ERRCLR,0)))


/* 12bit A/D Converter (AD) */
#define TSB_ADA_MOD0_ADS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_ADA->MOD0,0)))
#define TSB_ADA_MOD0_HPADS                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_ADA->MOD0,1)))
#define TSB_ADA_MOD1_ADHWE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,0)))
#define TSB_ADA_MOD1_HPADHWE                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,2)))
#define TSB_ADA_MOD1_RCUT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,5)))
#define TSB_ADA_MOD1_I2AD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,6)))
#define TSB_ADA_MOD1_DACON                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,7)))
#define TSB_ADA_MOD3_SCAN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD3,0)))
#define TSB_ADA_MOD3_REPEAT                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD3,1)))
#define TSB_ADA_CMPCR0_ADBIG0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR0,4)))
#define TSB_ADA_CMPCR0_CMPCOND0                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR0,5)))
#define TSB_ADA_CMPCR0_CMP0EN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR0,7)))
#define TSB_ADA_CMPCR1_ADBIG1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR1,4)))
#define TSB_ADA_CMPCR1_CMPCOND1                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR1,5)))
#define TSB_ADA_CMPCR1_CMP1EN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR1,7)))


/* 16-bit TimerA (T16A) */
#define TSB_T16A0_EN_I2T16A                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A0->EN,0)))
#define TSB_T16A0_EN_HALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A0->EN,1)))
#define TSB_T16A0_RUN_RUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A0->RUN,0)))
#define TSB_T16A0_CR_CLK                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A0->CR,0)))
#define TSB_T16A0_CR_FFEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A0->CR,7)))

#define TSB_T16A1_EN_I2T16A                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A1->EN,0)))
#define TSB_T16A1_EN_HALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A1->EN,1)))
#define TSB_T16A1_RUN_RUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A1->RUN,0)))
#define TSB_T16A1_CR_CLK                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A1->CR,0)))
#define TSB_T16A1_CR_FFEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_T16A1->CR,7)))


/* I2C Bus Interface (I2C) */
#define TSB_I2C0_CR1_NOACK                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR1,3)))
#define TSB_I2C0_CR1_ACK                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C0->CR1,4)))
#define TSB_I2C0_AR_ALS                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C0->AR,0)))
#define TSB_I2C0_CR2_I2CM                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR2,3)))
#define TSB_I2C0_CR2_PIN                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR2,4)))
#define TSB_I2C0_CR2_BB                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR2,5)))
#define TSB_I2C0_CR2_TRX                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR2,6)))
#define TSB_I2C0_CR2_MST                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_I2C0->CR2,7)))
#define TSB_I2C0_SR_LRB                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,0)))
#define TSB_I2C0_SR_AD0                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,1)))
#define TSB_I2C0_SR_AAS                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,2)))
#define TSB_I2C0_SR_AL                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,3)))
#define TSB_I2C0_SR_PIN                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,4)))
#define TSB_I2C0_SR_BB                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,5)))
#define TSB_I2C0_SR_TRX                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,6)))
#define TSB_I2C0_SR_MST                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_I2C0->SR,7)))
#define TSB_I2C0_IE_IE                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C0->IE,0)))
#define TSB_I2C0_IR_ISIC                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_I2C0->IR,0)))


/* Interrupt Controller (INT) */
#define TSB_INT0_EN_EN0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,0)))
#define TSB_INT0_EN_EN1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,1)))
#define TSB_INT0_EN_EN2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,2)))
#define TSB_INT0_EN_EN3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,3)))
#define TSB_INT0_EN_EN4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,4)))
#define TSB_INT0_EN_EN5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,5)))
#define TSB_INT0_EN_EN6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,6)))
#define TSB_INT0_EN_EN7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,7)))
#define TSB_INT0_EN_EN8                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,8)))
#define TSB_INT0_EN_EN9                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,9)))
#define TSB_INT0_EN_EN10                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,10)))
#define TSB_INT0_EN_EN11                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,11)))
#define TSB_INT0_EN_EN12                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->EN,12)))
#define TSB_INT0_RESETF_RSTF0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->RESETF,0)))
#define TSB_INT0_RESETF_RSTF1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->RESETF,1)))
#define TSB_INT0_RESETF_RSTF2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->RESETF,2)))
#define TSB_INT0_RESETF_RSTF3                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->RESETF,3)))
#define TSB_INT0_RESETF_RSTF4                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->RESETF,4)))
#define TSB_INT0_RETF_RETF0                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->RETF,0)))
#define TSB_INT0_RETF_RETF1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->RETF,1)))
#define TSB_INT0_RETF_RETF2                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->RETF,2)))
#define TSB_INT0_RETF_RETF3                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_INT0->RETF,3)))
#define TSB_INT0_LVDST_LVDST                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_INT0->LVDST,0)))


/* CPU Interface (CPUIF) */
#define TSB_CPUIF0_INTCR_INT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CPUIF0->INTCR,0)))
#define TSB_CPUIF0_INTCLR_CLR                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CPUIF0->INTCLR,0)))
#define TSB_CPUIF0_CKCR_CK                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CPUIF0->CKCR,0)))
#define TSB_CPUIF0_RSTCR_RSTREL                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_CPUIF0->RSTCR,0)))


/* Port A (PA) */
#define TSB_PA_DATA_PA0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,0)))
#define TSB_PA_DATA_PA1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,1)))
#define TSB_PA_DATA_PA2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,2)))
#define TSB_PA_DATA_PA3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,3)))
#define TSB_PA_DATA_PA4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,4)))
#define TSB_PA_DATA_PA5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,5)))
#define TSB_PA_DATA_PA6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,6)))
#define TSB_PA_DATA_PA7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,7)))
#define TSB_PA_CR_PA0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,0)))
#define TSB_PA_CR_PA1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,1)))
#define TSB_PA_CR_PA2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,2)))
#define TSB_PA_CR_PA3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,3)))
#define TSB_PA_CR_PA4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,4)))
#define TSB_PA_CR_PA5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,5)))
#define TSB_PA_CR_PA6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,6)))
#define TSB_PA_CR_PA7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,7)))
#define TSB_PA_FR1_PA1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,1)))
#define TSB_PA_FR1_PA2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,2)))
#define TSB_PA_FR1_PA3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,3)))
#define TSB_PA_FR1_PA4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,4)))
#define TSB_PA_FR1_PA5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,5)))
#define TSB_PA_FR1_PA6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,6)))
#define TSB_PA_FR1_PA7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,7)))
#define TSB_PA_OD_PA0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,0)))
#define TSB_PA_OD_PA1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,1)))
#define TSB_PA_OD_PA2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,2)))
#define TSB_PA_OD_PA3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,3)))
#define TSB_PA_OD_PA4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,4)))
#define TSB_PA_OD_PA5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,5)))
#define TSB_PA_OD_PA6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,6)))
#define TSB_PA_OD_PA7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,7)))
#define TSB_PA_PUP_PA0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,0)))
#define TSB_PA_PUP_PA1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,1)))
#define TSB_PA_PUP_PA2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,2)))
#define TSB_PA_PUP_PA3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,3)))
#define TSB_PA_PUP_PA5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,5)))
#define TSB_PA_PUP_PA6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,6)))
#define TSB_PA_PUP_PA7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,7)))
#define TSB_PA_PDN_PA4DN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PDN,4)))
#define TSB_PA_IE_PA0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,0)))
#define TSB_PA_IE_PA1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,1)))
#define TSB_PA_IE_PA2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,2)))
#define TSB_PA_IE_PA3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,3)))
#define TSB_PA_IE_PA4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,4)))
#define TSB_PA_IE_PA5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,5)))
#define TSB_PA_IE_PA6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,6)))
#define TSB_PA_IE_PA7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,7)))


/* Port B (PB) */
#define TSB_PB_DATA_PB0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,0)))
#define TSB_PB_DATA_PB1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,1)))
#define TSB_PB_DATA_PB2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,2)))
#define TSB_PB_DATA_PB3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,3)))
#define TSB_PB_DATA_PB4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,4)))
#define TSB_PB_DATA_PB5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,5)))
#define TSB_PB_DATA_PB6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,6)))
#define TSB_PB_DATA_PB7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,7)))
#define TSB_PB_CR_PB0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,0)))
#define TSB_PB_CR_PB1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,1)))
#define TSB_PB_CR_PB2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,2)))
#define TSB_PB_CR_PB3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,3)))
#define TSB_PB_CR_PB4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,4)))
#define TSB_PB_CR_PB5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,5)))
#define TSB_PB_CR_PB6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,6)))
#define TSB_PB_CR_PB7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,7)))
#define TSB_PB_FR1_PB0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,0)))
#define TSB_PB_FR1_PB1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,1)))
#define TSB_PB_FR1_PB2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,2)))
#define TSB_PB_FR1_PB3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,3)))
#define TSB_PB_FR1_PB4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,4)))
#define TSB_PB_FR1_PB5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,5)))
#define TSB_PB_FR1_PB6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,6)))
#define TSB_PB_FR1_PB7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,7)))
#define TSB_PB_OD_PB0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,0)))
#define TSB_PB_OD_PB1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,1)))
#define TSB_PB_OD_PB2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,2)))
#define TSB_PB_OD_PB3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,3)))
#define TSB_PB_OD_PB4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,4)))
#define TSB_PB_OD_PB5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,5)))
#define TSB_PB_OD_PB6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,6)))
#define TSB_PB_OD_PB7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,7)))
#define TSB_PB_PUP_PB0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,0)))
#define TSB_PB_PUP_PB1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,1)))
#define TSB_PB_PUP_PB2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,2)))
#define TSB_PB_PUP_PB3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,3)))
#define TSB_PB_PUP_PB4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,4)))
#define TSB_PB_PUP_PB5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,5)))
#define TSB_PB_PUP_PB6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,6)))
#define TSB_PB_PUP_PB7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,7)))
#define TSB_PB_IE_PB0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,0)))
#define TSB_PB_IE_PB1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,1)))
#define TSB_PB_IE_PB2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,2)))
#define TSB_PB_IE_PB3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,3)))
#define TSB_PB_IE_PB4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,4)))
#define TSB_PB_IE_PB5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,5)))
#define TSB_PB_IE_PB6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,6)))
#define TSB_PB_IE_PB7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,7)))


/* Port C (PC) */
#define TSB_PC_DATA_PC0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,0)))
#define TSB_PC_DATA_PC1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,1)))
#define TSB_PC_DATA_PC2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,2)))
#define TSB_PC_DATA_PC3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,3)))
#define TSB_PC_DATA_PC4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,4)))
#define TSB_PC_DATA_PC5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,5)))
#define TSB_PC_DATA_PC6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,6)))
#define TSB_PC_DATA_PC7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,7)))
#define TSB_PC_CR_PC0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,0)))
#define TSB_PC_CR_PC1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,1)))
#define TSB_PC_CR_PC2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,2)))
#define TSB_PC_CR_PC3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,3)))
#define TSB_PC_CR_PC4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,4)))
#define TSB_PC_CR_PC5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,5)))
#define TSB_PC_CR_PC6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,6)))
#define TSB_PC_CR_PC7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,7)))
#define TSB_PC_FR1_PC0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,0)))
#define TSB_PC_FR1_PC1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,1)))
#define TSB_PC_FR1_PC2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,2)))
#define TSB_PC_FR1_PC3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,3)))
#define TSB_PC_FR1_PC4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,4)))
#define TSB_PC_FR1_PC5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,5)))
#define TSB_PC_FR1_PC6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,6)))
#define TSB_PC_FR1_PC7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,7)))
#define TSB_PC_FR2_PC0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,0)))
#define TSB_PC_FR2_PC1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,1)))
#define TSB_PC_FR2_PC4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,4)))
#define TSB_PC_OD_PC0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,0)))
#define TSB_PC_OD_PC1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,1)))
#define TSB_PC_OD_PC2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,2)))
#define TSB_PC_OD_PC3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,3)))
#define TSB_PC_OD_PC4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,4)))
#define TSB_PC_OD_PC5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,5)))
#define TSB_PC_OD_PC6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,6)))
#define TSB_PC_OD_PC7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,7)))
#define TSB_PC_PUP_PC0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,0)))
#define TSB_PC_PUP_PC1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,1)))
#define TSB_PC_PUP_PC2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,2)))
#define TSB_PC_PUP_PC3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,3)))
#define TSB_PC_PUP_PC4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,4)))
#define TSB_PC_PUP_PC5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,5)))
#define TSB_PC_PUP_PC6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,6)))
#define TSB_PC_PUP_PC7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,7)))
#define TSB_PC_IE_PC0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,0)))
#define TSB_PC_IE_PC1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,1)))
#define TSB_PC_IE_PC2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,2)))
#define TSB_PC_IE_PC3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,3)))
#define TSB_PC_IE_PC4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,4)))
#define TSB_PC_IE_PC5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,5)))
#define TSB_PC_IE_PC6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,6)))
#define TSB_PC_IE_PC7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,7)))


/* Port D (PD) */
#define TSB_PD_DATA_PD0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,0)))
#define TSB_PD_DATA_PD1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,1)))
#define TSB_PD_DATA_PD2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,2)))
#define TSB_PD_DATA_PD3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,3)))
#define TSB_PD_DATA_PD4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,4)))
#define TSB_PD_DATA_PD5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,5)))
#define TSB_PD_DATA_PD6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,6)))
#define TSB_PD_DATA_PD7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,7)))
#define TSB_PD_CR_PD0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,0)))
#define TSB_PD_CR_PD1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,1)))
#define TSB_PD_CR_PD2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,2)))
#define TSB_PD_CR_PD3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,3)))
#define TSB_PD_CR_PD4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,4)))
#define TSB_PD_CR_PD5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,5)))
#define TSB_PD_CR_PD6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,6)))
#define TSB_PD_CR_PD7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,7)))
#define TSB_PD_FR1_PD0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,0)))
#define TSB_PD_FR1_PD1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,1)))
#define TSB_PD_FR1_PD2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,2)))
#define TSB_PD_FR1_PD3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,3)))
#define TSB_PD_FR1_PD4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,4)))
#define TSB_PD_FR1_PD5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,5)))
#define TSB_PD_FR1_PD6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,6)))
#define TSB_PD_FR1_PD7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,7)))
#define TSB_PD_OD_PD0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,0)))
#define TSB_PD_OD_PD1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,1)))
#define TSB_PD_OD_PD2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,2)))
#define TSB_PD_OD_PD3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,3)))
#define TSB_PD_OD_PD4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,4)))
#define TSB_PD_OD_PD5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,5)))
#define TSB_PD_OD_PD6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,6)))
#define TSB_PD_OD_PD7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,7)))
#define TSB_PD_PUP_PD0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,0)))
#define TSB_PD_PUP_PD1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,1)))
#define TSB_PD_PUP_PD2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,2)))
#define TSB_PD_PUP_PD3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,3)))
#define TSB_PD_PUP_PD4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,4)))
#define TSB_PD_PUP_PD5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,5)))
#define TSB_PD_PUP_PD6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,6)))
#define TSB_PD_PUP_PD7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,7)))
#define TSB_PD_IE_PD0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,0)))
#define TSB_PD_IE_PD1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,1)))
#define TSB_PD_IE_PD2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,2)))
#define TSB_PD_IE_PD3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,3)))
#define TSB_PD_IE_PD4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,4)))
#define TSB_PD_IE_PD5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,5)))
#define TSB_PD_IE_PD6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,6)))
#define TSB_PD_IE_PD7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,7)))


/* Port E (PE) */
#define TSB_PE_DATA_PE0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,0)))
#define TSB_PE_DATA_PE1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,1)))
#define TSB_PE_DATA_PE2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,2)))
#define TSB_PE_DATA_PE3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,3)))
#define TSB_PE_DATA_PE4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,4)))
#define TSB_PE_DATA_PE5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,5)))
#define TSB_PE_DATA_PE6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,6)))
#define TSB_PE_DATA_PE7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,7)))
#define TSB_PE_CR_PE0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,0)))
#define TSB_PE_CR_PE1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,1)))
#define TSB_PE_CR_PE2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,2)))
#define TSB_PE_CR_PE3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,3)))
#define TSB_PE_CR_PE4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,4)))
#define TSB_PE_CR_PE5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,5)))
#define TSB_PE_CR_PE6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,6)))
#define TSB_PE_CR_PE7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,7)))
#define TSB_PE_FR1_PE0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,0)))
#define TSB_PE_FR1_PE1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,1)))
#define TSB_PE_FR1_PE2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,2)))
#define TSB_PE_FR1_PE3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,3)))
#define TSB_PE_FR1_PE4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,4)))
#define TSB_PE_FR1_PE5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,5)))
#define TSB_PE_FR1_PE6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,6)))
#define TSB_PE_FR1_PE7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,7)))
#define TSB_PE_FR2_PE6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,6)))
#define TSB_PE_OD_PE0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,0)))
#define TSB_PE_OD_PE1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,1)))
#define TSB_PE_OD_PE2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,2)))
#define TSB_PE_OD_PE3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,3)))
#define TSB_PE_OD_PE4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,4)))
#define TSB_PE_OD_PE5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,5)))
#define TSB_PE_OD_PE6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,6)))
#define TSB_PE_OD_PE7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,7)))
#define TSB_PE_PUP_PE0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,0)))
#define TSB_PE_PUP_PE1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,1)))
#define TSB_PE_PUP_PE2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,2)))
#define TSB_PE_PUP_PE3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,3)))
#define TSB_PE_PUP_PE4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,4)))
#define TSB_PE_PUP_PE5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,5)))
#define TSB_PE_PUP_PE6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,6)))
#define TSB_PE_PUP_PE7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,7)))
#define TSB_PE_IE_PE0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,0)))
#define TSB_PE_IE_PE1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,1)))
#define TSB_PE_IE_PE2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,2)))
#define TSB_PE_IE_PE3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,3)))
#define TSB_PE_IE_PE4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,4)))
#define TSB_PE_IE_PE5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,5)))
#define TSB_PE_IE_PE6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,6)))
#define TSB_PE_IE_PE7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,7)))


/* Port F (PF) */
#define TSB_PF_DATA_PF0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,0)))
#define TSB_PF_DATA_PF1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,1)))
#define TSB_PF_DATA_PF2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,2)))
#define TSB_PF_DATA_PF3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,3)))
#define TSB_PF_DATA_PF4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,4)))
#define TSB_PF_DATA_PF5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,5)))
#define TSB_PF_CR_PF0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,0)))
#define TSB_PF_CR_PF1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,1)))
#define TSB_PF_CR_PF2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,2)))
#define TSB_PF_CR_PF3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,3)))
#define TSB_PF_CR_PF4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,4)))
#define TSB_PF_CR_PF5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,5)))
#define TSB_PF_FR1_PF0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,0)))
#define TSB_PF_FR1_PF1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,1)))
#define TSB_PF_FR1_PF2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,2)))
#define TSB_PF_FR1_PF3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,3)))
#define TSB_PF_FR1_PF4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,4)))
#define TSB_PF_FR1_PF5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,5)))
#define TSB_PF_OD_PE0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,0)))
#define TSB_PF_OD_PE1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,1)))
#define TSB_PF_OD_PE2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,2)))
#define TSB_PF_OD_PE3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,3)))
#define TSB_PF_OD_PE4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,4)))
#define TSB_PF_OD_PE5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,5)))
#define TSB_PF_PUP_PF0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,0)))
#define TSB_PF_PUP_PF1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,1)))
#define TSB_PF_PUP_PF2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,2)))
#define TSB_PF_PUP_PF3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,3)))
#define TSB_PF_PUP_PF4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,4)))
#define TSB_PF_PUP_PF5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,5)))
#define TSB_PF_IE_PF0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,0)))
#define TSB_PF_IE_PF1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,1)))
#define TSB_PF_IE_PF2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,2)))
#define TSB_PF_IE_PF3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,3)))
#define TSB_PF_IE_PF4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,4)))
#define TSB_PF_IE_PF5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,5)))


/* Port G (PG) */
#define TSB_PG_DATA_PG0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,0)))
#define TSB_PG_DATA_PG1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,1)))
#define TSB_PG_DATA_PG2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,2)))
#define TSB_PG_DATA_PG3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,3)))
#define TSB_PG_CR_PG0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,0)))
#define TSB_PG_CR_PG1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,1)))
#define TSB_PG_CR_PG2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,2)))
#define TSB_PG_CR_PG3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,3)))
#define TSB_PG_PUP_PG0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,0)))
#define TSB_PG_PUP_PG1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,1)))
#define TSB_PG_PUP_PG2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,2)))
#define TSB_PG_PUP_PG3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,3)))
#define TSB_PG_IE_PG0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,0)))
#define TSB_PG_IE_PG1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,1)))
#define TSB_PG_IE_PG2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,2)))
#define TSB_PG_IE_PG3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,3)))


/* 16-bit Timer/Event Counter (TB) */
#define TSB_TB0_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->EN,6)))
#define TSB_TB0_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->EN,7)))
#define TSB_TB0_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->RUN,0)))
#define TSB_TB0_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->RUN,2)))
#define TSB_TB0_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,0)))
#define TSB_TB0_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,1)))
#define TSB_TB0_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,3)))
#define TSB_TB0_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,5)))
#define TSB_TB0_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,7)))
#define TSB_TB0_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->MOD,3)))
#define TSB_TB0_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB0->MOD,6)))
#define TSB_TB0_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,2)))
#define TSB_TB0_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,3)))
#define TSB_TB0_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,4)))
#define TSB_TB0_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,5)))
#define TSB_TB0_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,0)))
#define TSB_TB0_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,1)))
#define TSB_TB0_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,2)))

#define TSB_TB1_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->EN,6)))
#define TSB_TB1_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->EN,7)))
#define TSB_TB1_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->RUN,0)))
#define TSB_TB1_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->RUN,2)))
#define TSB_TB1_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,0)))
#define TSB_TB1_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,1)))
#define TSB_TB1_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,3)))
#define TSB_TB1_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,5)))
#define TSB_TB1_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,7)))
#define TSB_TB1_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->MOD,3)))
#define TSB_TB1_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB1->MOD,6)))
#define TSB_TB1_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,2)))
#define TSB_TB1_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,3)))
#define TSB_TB1_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,4)))
#define TSB_TB1_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,5)))
#define TSB_TB1_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,0)))
#define TSB_TB1_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,1)))
#define TSB_TB1_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,2)))

#define TSB_TB2_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->EN,6)))
#define TSB_TB2_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->EN,7)))
#define TSB_TB2_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->RUN,0)))
#define TSB_TB2_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->RUN,2)))
#define TSB_TB2_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,0)))
#define TSB_TB2_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,1)))
#define TSB_TB2_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,3)))
#define TSB_TB2_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,5)))
#define TSB_TB2_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,7)))
#define TSB_TB2_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->MOD,3)))
#define TSB_TB2_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB2->MOD,6)))
#define TSB_TB2_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,2)))
#define TSB_TB2_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,3)))
#define TSB_TB2_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,4)))
#define TSB_TB2_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,5)))
#define TSB_TB2_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,0)))
#define TSB_TB2_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,1)))
#define TSB_TB2_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,2)))


/* Real Time Clock (RTC) */
#define TSB_RTC_TPROD_MO0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_RTC->TPROD,0)))
#define TSB_RTC_ADJCTL_AJEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_RTC->ADJCTL,0)))
#define TSB_RTC_CLKCR_CLKSEL                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_RTC->CLKCR,0)))
#define TSB_RTC_CLKCR_ACCLKSEL                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_RTC->CLKCR,1)))


/* SIO/UART (SC) */
#define TSB_SC0_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->EN,0)))
#define TSB_SC0_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->EN,1)))
#define TSB_SC0_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,4)))
#define TSB_SC0_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,5)))
#define TSB_SC0_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,6)))
#define TSB_SC0_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,7)))
#define TSB_SC0_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->BRCR,6)))
#define TSB_SC0_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD1,4)))
#define TSB_SC0_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD1,7)))
#define TSB_SC0_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,2)))
#define TSB_SC0_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,3)))
#define TSB_SC0_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,4)))
#define TSB_SC0_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,5)))
#define TSB_SC0_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,6)))
#define TSB_SC0_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,7)))
#define TSB_SC0_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->TST,7)))
#define TSB_SC0_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,0)))
#define TSB_SC0_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,1)))
#define TSB_SC0_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,2)))
#define TSB_SC0_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,3)))
#define TSB_SC0_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,4)))

#define TSB_SC1_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->EN,0)))
#define TSB_SC1_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->EN,1)))
#define TSB_SC1_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,4)))
#define TSB_SC1_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,5)))
#define TSB_SC1_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,6)))
#define TSB_SC1_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,7)))
#define TSB_SC1_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->BRCR,6)))
#define TSB_SC1_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD1,4)))
#define TSB_SC1_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD1,7)))
#define TSB_SC1_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,2)))
#define TSB_SC1_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,3)))
#define TSB_SC1_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,4)))
#define TSB_SC1_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,5)))
#define TSB_SC1_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,6)))
#define TSB_SC1_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,7)))
#define TSB_SC1_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->TST,7)))
#define TSB_SC1_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,0)))
#define TSB_SC1_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,1)))
#define TSB_SC1_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,2)))
#define TSB_SC1_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,3)))
#define TSB_SC1_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,4)))


/* Watchdog Timer (WD) */
#define TSB_WD0_MOD_RESCR                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD0->MOD,1)))
#define TSB_WD0_MOD_I2WDT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD0->MOD,2)))
#define TSB_WD0_MOD_WDTE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD0->MOD,7)))
#define TSB_WD0_FLG_FLG                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_WD0->FLG,0)))


/* Clock Control (CG) */
#define TSB_CG0_CLKCR_FPSEL                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->CLKCR,6)))
#define TSB_CG0_CLKCR_STICK                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->CLKCR,7)))
#define TSB_CG0_CLKMSK_ADCA                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->CLKMSK,0)))
#define TSB_CG0_CLKMSK_DMACA                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->CLKMSK,1)))
#define TSB_CG0_CLKMSK_UART0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->CLKMSK,2)))
#define TSB_CG0_CLKMSK_SSP0                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->CLKMSK,3)))
#define TSB_CG0_CLKMSK_SSP1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->CLKMSK,4)))
#define TSB_CG0_CLKMSK_SSP2                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->CLKMSK,5)))
#define TSB_CG0_CLKMSK_TRACECLK                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->CLKMSK,6)))
#define TSB_CG0_OSCEN_IHOSCEN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->OSCEN,0)))
#define TSB_CG0_PLLEN_PLLON                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->PLLEN,0)))
#define TSB_CG0_WUHCR_WUON                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_CG0->WUHCR,0)))
#define TSB_CG0_WUHCR_WUEF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_CG0->WUHCR,1)))
#define TSB_CG0_WUHCR_WUCLK                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG0->WUHCR,8)))
#define TSB_CG0_WULCR_WULON                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_CG0->WULCR,0)))
#define TSB_CG0_WULCR_WULEF                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_CG0->WULCR,1)))

/** @} */ /* End of group Device_Peripheral_registers */

#ifdef __cplusplus
}
#endif

#endif  /* __TMPM411_unitA_H__ */

/** @} */ /* End of group TMPM411_unitA */
/** @} */ /* End of group TOSHIBA_TX04_MICROCONTROLLER */
