/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2017 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak DMA0_DMA16_IRQHandler
  .thumb_set DMA0_DMA16_IRQHandler,Dummy_Handler

  .weak DMA1_DMA17_IRQHandler
  .thumb_set DMA1_DMA17_IRQHandler,Dummy_Handler

  .weak DMA2_DMA18_IRQHandler
  .thumb_set DMA2_DMA18_IRQHandler,Dummy_Handler

  .weak DMA3_DMA19_IRQHandler
  .thumb_set DMA3_DMA19_IRQHandler,Dummy_Handler

  .weak DMA4_DMA20_IRQHandler
  .thumb_set DMA4_DMA20_IRQHandler,Dummy_Handler

  .weak DMA5_DMA21_IRQHandler
  .thumb_set DMA5_DMA21_IRQHandler,Dummy_Handler

  .weak DMA6_DMA22_IRQHandler
  .thumb_set DMA6_DMA22_IRQHandler,Dummy_Handler

  .weak DMA7_DMA23_IRQHandler
  .thumb_set DMA7_DMA23_IRQHandler,Dummy_Handler

  .weak DMA8_DMA24_IRQHandler
  .thumb_set DMA8_DMA24_IRQHandler,Dummy_Handler

  .weak DMA9_DMA25_IRQHandler
  .thumb_set DMA9_DMA25_IRQHandler,Dummy_Handler

  .weak DMA10_DMA26_IRQHandler
  .thumb_set DMA10_DMA26_IRQHandler,Dummy_Handler

  .weak DMA11_DMA27_IRQHandler
  .thumb_set DMA11_DMA27_IRQHandler,Dummy_Handler

  .weak DMA12_DMA28_IRQHandler
  .thumb_set DMA12_DMA28_IRQHandler,Dummy_Handler

  .weak DMA13_DMA29_IRQHandler
  .thumb_set DMA13_DMA29_IRQHandler,Dummy_Handler

  .weak DMA14_DMA30_IRQHandler
  .thumb_set DMA14_DMA30_IRQHandler,Dummy_Handler

  .weak DMA15_DMA31_IRQHandler
  .thumb_set DMA15_DMA31_IRQHandler,Dummy_Handler

  .weak DMA_Error_IRQHandler
  .thumb_set DMA_Error_IRQHandler,Dummy_Handler

  .weak MCM_IRQHandler
  .thumb_set MCM_IRQHandler,Dummy_Handler

  .weak FTFE_IRQHandler
  .thumb_set FTFE_IRQHandler,Dummy_Handler

  .weak Read_Collision_IRQHandler
  .thumb_set Read_Collision_IRQHandler,Dummy_Handler

  .weak PMC_IRQHandler
  .thumb_set PMC_IRQHandler,Dummy_Handler

  .weak LLWU_IRQHandler
  .thumb_set LLWU_IRQHandler,Dummy_Handler

  .weak WDOG_EWM_IRQHandler
  .thumb_set WDOG_EWM_IRQHandler,Dummy_Handler

  .weak TRNG0_IRQHandler
  .thumb_set TRNG0_IRQHandler,Dummy_Handler

  .weak I2C0_IRQHandler
  .thumb_set I2C0_IRQHandler,Dummy_Handler

  .weak I2C1_IRQHandler
  .thumb_set I2C1_IRQHandler,Dummy_Handler

  .weak SPI0_IRQHandler
  .thumb_set SPI0_IRQHandler,Dummy_Handler

  .weak SPI1_IRQHandler
  .thumb_set SPI1_IRQHandler,Dummy_Handler

  .weak UART5_RX_TX_IRQHandler
  .thumb_set UART5_RX_TX_IRQHandler,Dummy_Handler

  .weak UART5_ERR_IRQHandler
  .thumb_set UART5_ERR_IRQHandler,Dummy_Handler

  .weak UART0_RX_TX_IRQHandler
  .thumb_set UART0_RX_TX_IRQHandler,Dummy_Handler

  .weak UART0_ERR_IRQHandler
  .thumb_set UART0_ERR_IRQHandler,Dummy_Handler

  .weak UART1_RX_TX_IRQHandler
  .thumb_set UART1_RX_TX_IRQHandler,Dummy_Handler

  .weak UART1_ERR_IRQHandler
  .thumb_set UART1_ERR_IRQHandler,Dummy_Handler

  .weak UART2_RX_TX_IRQHandler
  .thumb_set UART2_RX_TX_IRQHandler,Dummy_Handler

  .weak UART2_ERR_IRQHandler
  .thumb_set UART2_ERR_IRQHandler,Dummy_Handler

  .weak ADC0_IRQHandler
  .thumb_set ADC0_IRQHandler,Dummy_Handler

  .weak HSADC_ERR_IRQHandler
  .thumb_set HSADC_ERR_IRQHandler,Dummy_Handler

  .weak HSADC0_CCA_IRQHandler
  .thumb_set HSADC0_CCA_IRQHandler,Dummy_Handler

  .weak CMP0_IRQHandler
  .thumb_set CMP0_IRQHandler,Dummy_Handler

  .weak CMP1_IRQHandler
  .thumb_set CMP1_IRQHandler,Dummy_Handler

  .weak FTM0_IRQHandler
  .thumb_set FTM0_IRQHandler,Dummy_Handler

  .weak FTM1_IRQHandler
  .thumb_set FTM1_IRQHandler,Dummy_Handler

  .weak UART3_RX_TX_IRQHandler
  .thumb_set UART3_RX_TX_IRQHandler,Dummy_Handler

  .weak UART3_ERR_IRQHandler
  .thumb_set UART3_ERR_IRQHandler,Dummy_Handler

  .weak UART4_RX_TX_IRQHandler
  .thumb_set UART4_RX_TX_IRQHandler,Dummy_Handler

  .weak UART4_ERR_IRQHandler
  .thumb_set UART4_ERR_IRQHandler,Dummy_Handler

  .weak PIT0_IRQHandler
  .thumb_set PIT0_IRQHandler,Dummy_Handler

  .weak PIT1_IRQHandler
  .thumb_set PIT1_IRQHandler,Dummy_Handler

  .weak PIT2_IRQHandler
  .thumb_set PIT2_IRQHandler,Dummy_Handler

  .weak PIT3_IRQHandler
  .thumb_set PIT3_IRQHandler,Dummy_Handler

  .weak PDB0_IRQHandler
  .thumb_set PDB0_IRQHandler,Dummy_Handler

  .weak FTM2_IRQHandler
  .thumb_set FTM2_IRQHandler,Dummy_Handler

  .weak XBARA_IRQHandler
  .thumb_set XBARA_IRQHandler,Dummy_Handler

  .weak PDB1_IRQHandler
  .thumb_set PDB1_IRQHandler,Dummy_Handler

  .weak DAC0_IRQHandler
  .thumb_set DAC0_IRQHandler,Dummy_Handler

  .weak MCG_IRQHandler
  .thumb_set MCG_IRQHandler,Dummy_Handler

  .weak LPTMR0_IRQHandler
  .thumb_set LPTMR0_IRQHandler,Dummy_Handler

  .weak PORTA_IRQHandler
  .thumb_set PORTA_IRQHandler,Dummy_Handler

  .weak PORTB_IRQHandler
  .thumb_set PORTB_IRQHandler,Dummy_Handler

  .weak PORTC_IRQHandler
  .thumb_set PORTC_IRQHandler,Dummy_Handler

  .weak PORTD_IRQHandler
  .thumb_set PORTD_IRQHandler,Dummy_Handler

  .weak PORTE_IRQHandler
  .thumb_set PORTE_IRQHandler,Dummy_Handler

  .weak SPI2_IRQHandler
  .thumb_set SPI2_IRQHandler,Dummy_Handler

  .weak ENC_COMPARE_IRQHandler
  .thumb_set ENC_COMPARE_IRQHandler,Dummy_Handler

  .weak ENC_HOME_IRQHandler
  .thumb_set ENC_HOME_IRQHandler,Dummy_Handler

  .weak ENC_WDOG_SAB_IRQHandler
  .thumb_set ENC_WDOG_SAB_IRQHandler,Dummy_Handler

  .weak ENC_INDEX_IRQHandler
  .thumb_set ENC_INDEX_IRQHandler,Dummy_Handler

  .weak CMP2_IRQHandler
  .thumb_set CMP2_IRQHandler,Dummy_Handler

  .weak FTM3_IRQHandler
  .thumb_set FTM3_IRQHandler,Dummy_Handler

  .weak HSADC0_CCB_IRQHandler
  .thumb_set HSADC0_CCB_IRQHandler,Dummy_Handler

  .weak HSADC1_CCA_IRQHandler
  .thumb_set HSADC1_CCA_IRQHandler,Dummy_Handler

  .weak CAN0_ORed_Message_buffer_IRQHandler
  .thumb_set CAN0_ORed_Message_buffer_IRQHandler,Dummy_Handler

  .weak CAN0_Bus_Off_IRQHandler
  .thumb_set CAN0_Bus_Off_IRQHandler,Dummy_Handler

  .weak CAN0_Error_IRQHandler
  .thumb_set CAN0_Error_IRQHandler,Dummy_Handler

  .weak CAN0_Tx_Warning_IRQHandler
  .thumb_set CAN0_Tx_Warning_IRQHandler,Dummy_Handler

  .weak CAN0_Rx_Warning_IRQHandler
  .thumb_set CAN0_Rx_Warning_IRQHandler,Dummy_Handler

  .weak CAN0_Wake_Up_IRQHandler
  .thumb_set CAN0_Wake_Up_IRQHandler,Dummy_Handler

  .weak PWM0_CMP0_IRQHandler
  .thumb_set PWM0_CMP0_IRQHandler,Dummy_Handler

  .weak PWM0_RELOAD0_IRQHandler
  .thumb_set PWM0_RELOAD0_IRQHandler,Dummy_Handler

  .weak PWM0_CMP1_IRQHandler
  .thumb_set PWM0_CMP1_IRQHandler,Dummy_Handler

  .weak PWM0_RELOAD1_IRQHandler
  .thumb_set PWM0_RELOAD1_IRQHandler,Dummy_Handler

  .weak PWM0_CMP2_IRQHandler
  .thumb_set PWM0_CMP2_IRQHandler,Dummy_Handler

  .weak PWM0_RELOAD2_IRQHandler
  .thumb_set PWM0_RELOAD2_IRQHandler,Dummy_Handler

  .weak PWM0_CMP3_IRQHandler
  .thumb_set PWM0_CMP3_IRQHandler,Dummy_Handler

  .weak PWM0_RELOAD3_IRQHandler
  .thumb_set PWM0_RELOAD3_IRQHandler,Dummy_Handler

  .weak PWM0_CAP_IRQHandler
  .thumb_set PWM0_CAP_IRQHandler,Dummy_Handler

  .weak PWM0_RERR_IRQHandler
  .thumb_set PWM0_RERR_IRQHandler,Dummy_Handler

  .weak PWM0_FAULT_IRQHandler
  .thumb_set PWM0_FAULT_IRQHandler,Dummy_Handler

  .weak CMP3_IRQHandler
  .thumb_set CMP3_IRQHandler,Dummy_Handler

  .weak HSADC1_CCB_IRQHandler
  .thumb_set HSADC1_CCB_IRQHandler,Dummy_Handler

  .weak CAN1_ORed_Message_buffer_IRQHandler
  .thumb_set CAN1_ORed_Message_buffer_IRQHandler,Dummy_Handler

  .weak CAN1_Bus_Off_IRQHandler
  .thumb_set CAN1_Bus_Off_IRQHandler,Dummy_Handler

  .weak CAN1_Error_IRQHandler
  .thumb_set CAN1_Error_IRQHandler,Dummy_Handler

  .weak CAN1_Tx_Warning_IRQHandler
  .thumb_set CAN1_Tx_Warning_IRQHandler,Dummy_Handler

  .weak CAN1_Rx_Warning_IRQHandler
  .thumb_set CAN1_Rx_Warning_IRQHandler,Dummy_Handler

  .weak CAN1_Wake_Up_IRQHandler
  .thumb_set CAN1_Wake_Up_IRQHandler,Dummy_Handler

  .weak ENET_1588_Timer_IRQHandler
  .thumb_set ENET_1588_Timer_IRQHandler,Dummy_Handler

  .weak ENET_Transmit_IRQHandler
  .thumb_set ENET_Transmit_IRQHandler,Dummy_Handler

  .weak ENET_Receive_IRQHandler
  .thumb_set ENET_Receive_IRQHandler,Dummy_Handler

  .weak ENET_Error_IRQHandler
  .thumb_set ENET_Error_IRQHandler,Dummy_Handler

  .weak PWM1_CMP0_IRQHandler
  .thumb_set PWM1_CMP0_IRQHandler,Dummy_Handler

  .weak PWM1_RELOAD0_IRQHandler
  .thumb_set PWM1_RELOAD0_IRQHandler,Dummy_Handler

  .weak PWM1_CMP1_IRQHandler
  .thumb_set PWM1_CMP1_IRQHandler,Dummy_Handler

  .weak PWM1_RELOAD1_IRQHandler
  .thumb_set PWM1_RELOAD1_IRQHandler,Dummy_Handler

  .weak PWM1_CMP2_IRQHandler
  .thumb_set PWM1_CMP2_IRQHandler,Dummy_Handler

  .weak PWM1_RELOAD2_IRQHandler
  .thumb_set PWM1_RELOAD2_IRQHandler,Dummy_Handler

  .weak PWM1_CMP3_IRQHandler
  .thumb_set PWM1_CMP3_IRQHandler,Dummy_Handler

  .weak PWM1_RELOAD3_IRQHandler
  .thumb_set PWM1_RELOAD3_IRQHandler,Dummy_Handler

  .weak PWM1_CAP_IRQHandler
  .thumb_set PWM1_CAP_IRQHandler,Dummy_Handler

  .weak PWM1_RERR_IRQHandler
  .thumb_set PWM1_RERR_IRQHandler,Dummy_Handler

  .weak PWM1_FAULT_IRQHandler
  .thumb_set PWM1_FAULT_IRQHandler,Dummy_Handler

  .weak CAN2_ORed_Message_buffer_IRQHandler
  .thumb_set CAN2_ORed_Message_buffer_IRQHandler,Dummy_Handler

  .weak CAN2_Bus_Off_IRQHandler
  .thumb_set CAN2_Bus_Off_IRQHandler,Dummy_Handler

  .weak CAN2_Error_IRQHandler
  .thumb_set CAN2_Error_IRQHandler,Dummy_Handler

  .weak CAN2_Tx_Warning_IRQHandler
  .thumb_set CAN2_Tx_Warning_IRQHandler,Dummy_Handler

  .weak CAN2_Rx_Warning_IRQHandler
  .thumb_set CAN2_Rx_Warning_IRQHandler,Dummy_Handler

  .weak CAN2_Wake_Up_IRQHandler
  .thumb_set CAN2_Wake_Up_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak DMA0_DMA16_IRQHandler
DMA0_DMA16_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_DMA17_IRQHandler
DMA1_DMA17_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_DMA18_IRQHandler
DMA2_DMA18_IRQHandler:
  b .

  .thumb_func
  .weak DMA3_DMA19_IRQHandler
DMA3_DMA19_IRQHandler:
  b .

  .thumb_func
  .weak DMA4_DMA20_IRQHandler
DMA4_DMA20_IRQHandler:
  b .

  .thumb_func
  .weak DMA5_DMA21_IRQHandler
DMA5_DMA21_IRQHandler:
  b .

  .thumb_func
  .weak DMA6_DMA22_IRQHandler
DMA6_DMA22_IRQHandler:
  b .

  .thumb_func
  .weak DMA7_DMA23_IRQHandler
DMA7_DMA23_IRQHandler:
  b .

  .thumb_func
  .weak DMA8_DMA24_IRQHandler
DMA8_DMA24_IRQHandler:
  b .

  .thumb_func
  .weak DMA9_DMA25_IRQHandler
DMA9_DMA25_IRQHandler:
  b .

  .thumb_func
  .weak DMA10_DMA26_IRQHandler
DMA10_DMA26_IRQHandler:
  b .

  .thumb_func
  .weak DMA11_DMA27_IRQHandler
DMA11_DMA27_IRQHandler:
  b .

  .thumb_func
  .weak DMA12_DMA28_IRQHandler
DMA12_DMA28_IRQHandler:
  b .

  .thumb_func
  .weak DMA13_DMA29_IRQHandler
DMA13_DMA29_IRQHandler:
  b .

  .thumb_func
  .weak DMA14_DMA30_IRQHandler
DMA14_DMA30_IRQHandler:
  b .

  .thumb_func
  .weak DMA15_DMA31_IRQHandler
DMA15_DMA31_IRQHandler:
  b .

  .thumb_func
  .weak DMA_Error_IRQHandler
DMA_Error_IRQHandler:
  b .

  .thumb_func
  .weak MCM_IRQHandler
MCM_IRQHandler:
  b .

  .thumb_func
  .weak FTFE_IRQHandler
FTFE_IRQHandler:
  b .

  .thumb_func
  .weak Read_Collision_IRQHandler
Read_Collision_IRQHandler:
  b .

  .thumb_func
  .weak PMC_IRQHandler
PMC_IRQHandler:
  b .

  .thumb_func
  .weak LLWU_IRQHandler
LLWU_IRQHandler:
  b .

  .thumb_func
  .weak WDOG_EWM_IRQHandler
WDOG_EWM_IRQHandler:
  b .

  .thumb_func
  .weak TRNG0_IRQHandler
TRNG0_IRQHandler:
  b .

  .thumb_func
  .weak I2C0_IRQHandler
I2C0_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_IRQHandler
I2C1_IRQHandler:
  b .

  .thumb_func
  .weak SPI0_IRQHandler
SPI0_IRQHandler:
  b .

  .thumb_func
  .weak SPI1_IRQHandler
SPI1_IRQHandler:
  b .

  .thumb_func
  .weak UART5_RX_TX_IRQHandler
UART5_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART5_ERR_IRQHandler
UART5_ERR_IRQHandler:
  b .

  .thumb_func
  .weak UART0_RX_TX_IRQHandler
UART0_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART0_ERR_IRQHandler
UART0_ERR_IRQHandler:
  b .

  .thumb_func
  .weak UART1_RX_TX_IRQHandler
UART1_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART1_ERR_IRQHandler
UART1_ERR_IRQHandler:
  b .

  .thumb_func
  .weak UART2_RX_TX_IRQHandler
UART2_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART2_ERR_IRQHandler
UART2_ERR_IRQHandler:
  b .

  .thumb_func
  .weak ADC0_IRQHandler
ADC0_IRQHandler:
  b .

  .thumb_func
  .weak HSADC_ERR_IRQHandler
HSADC_ERR_IRQHandler:
  b .

  .thumb_func
  .weak HSADC0_CCA_IRQHandler
HSADC0_CCA_IRQHandler:
  b .

  .thumb_func
  .weak CMP0_IRQHandler
CMP0_IRQHandler:
  b .

  .thumb_func
  .weak CMP1_IRQHandler
CMP1_IRQHandler:
  b .

  .thumb_func
  .weak FTM0_IRQHandler
FTM0_IRQHandler:
  b .

  .thumb_func
  .weak FTM1_IRQHandler
FTM1_IRQHandler:
  b .

  .thumb_func
  .weak UART3_RX_TX_IRQHandler
UART3_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART3_ERR_IRQHandler
UART3_ERR_IRQHandler:
  b .

  .thumb_func
  .weak UART4_RX_TX_IRQHandler
UART4_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART4_ERR_IRQHandler
UART4_ERR_IRQHandler:
  b .

  .thumb_func
  .weak PIT0_IRQHandler
PIT0_IRQHandler:
  b .

  .thumb_func
  .weak PIT1_IRQHandler
PIT1_IRQHandler:
  b .

  .thumb_func
  .weak PIT2_IRQHandler
PIT2_IRQHandler:
  b .

  .thumb_func
  .weak PIT3_IRQHandler
PIT3_IRQHandler:
  b .

  .thumb_func
  .weak PDB0_IRQHandler
PDB0_IRQHandler:
  b .

  .thumb_func
  .weak FTM2_IRQHandler
FTM2_IRQHandler:
  b .

  .thumb_func
  .weak XBARA_IRQHandler
XBARA_IRQHandler:
  b .

  .thumb_func
  .weak PDB1_IRQHandler
PDB1_IRQHandler:
  b .

  .thumb_func
  .weak DAC0_IRQHandler
DAC0_IRQHandler:
  b .

  .thumb_func
  .weak MCG_IRQHandler
MCG_IRQHandler:
  b .

  .thumb_func
  .weak LPTMR0_IRQHandler
LPTMR0_IRQHandler:
  b .

  .thumb_func
  .weak PORTA_IRQHandler
PORTA_IRQHandler:
  b .

  .thumb_func
  .weak PORTB_IRQHandler
PORTB_IRQHandler:
  b .

  .thumb_func
  .weak PORTC_IRQHandler
PORTC_IRQHandler:
  b .

  .thumb_func
  .weak PORTD_IRQHandler
PORTD_IRQHandler:
  b .

  .thumb_func
  .weak PORTE_IRQHandler
PORTE_IRQHandler:
  b .

  .thumb_func
  .weak SPI2_IRQHandler
SPI2_IRQHandler:
  b .

  .thumb_func
  .weak ENC_COMPARE_IRQHandler
ENC_COMPARE_IRQHandler:
  b .

  .thumb_func
  .weak ENC_HOME_IRQHandler
ENC_HOME_IRQHandler:
  b .

  .thumb_func
  .weak ENC_WDOG_SAB_IRQHandler
ENC_WDOG_SAB_IRQHandler:
  b .

  .thumb_func
  .weak ENC_INDEX_IRQHandler
ENC_INDEX_IRQHandler:
  b .

  .thumb_func
  .weak CMP2_IRQHandler
CMP2_IRQHandler:
  b .

  .thumb_func
  .weak FTM3_IRQHandler
FTM3_IRQHandler:
  b .

  .thumb_func
  .weak HSADC0_CCB_IRQHandler
HSADC0_CCB_IRQHandler:
  b .

  .thumb_func
  .weak HSADC1_CCA_IRQHandler
HSADC1_CCA_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_ORed_Message_buffer_IRQHandler
CAN0_ORed_Message_buffer_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_Bus_Off_IRQHandler
CAN0_Bus_Off_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_Error_IRQHandler
CAN0_Error_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_Tx_Warning_IRQHandler
CAN0_Tx_Warning_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_Rx_Warning_IRQHandler
CAN0_Rx_Warning_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_Wake_Up_IRQHandler
CAN0_Wake_Up_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_CMP0_IRQHandler
PWM0_CMP0_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_RELOAD0_IRQHandler
PWM0_RELOAD0_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_CMP1_IRQHandler
PWM0_CMP1_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_RELOAD1_IRQHandler
PWM0_RELOAD1_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_CMP2_IRQHandler
PWM0_CMP2_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_RELOAD2_IRQHandler
PWM0_RELOAD2_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_CMP3_IRQHandler
PWM0_CMP3_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_RELOAD3_IRQHandler
PWM0_RELOAD3_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_CAP_IRQHandler
PWM0_CAP_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_RERR_IRQHandler
PWM0_RERR_IRQHandler:
  b .

  .thumb_func
  .weak PWM0_FAULT_IRQHandler
PWM0_FAULT_IRQHandler:
  b .

  .thumb_func
  .weak CMP3_IRQHandler
CMP3_IRQHandler:
  b .

  .thumb_func
  .weak HSADC1_CCB_IRQHandler
HSADC1_CCB_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_ORed_Message_buffer_IRQHandler
CAN1_ORed_Message_buffer_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_Bus_Off_IRQHandler
CAN1_Bus_Off_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_Error_IRQHandler
CAN1_Error_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_Tx_Warning_IRQHandler
CAN1_Tx_Warning_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_Rx_Warning_IRQHandler
CAN1_Rx_Warning_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_Wake_Up_IRQHandler
CAN1_Wake_Up_IRQHandler:
  b .

  .thumb_func
  .weak ENET_1588_Timer_IRQHandler
ENET_1588_Timer_IRQHandler:
  b .

  .thumb_func
  .weak ENET_Transmit_IRQHandler
ENET_Transmit_IRQHandler:
  b .

  .thumb_func
  .weak ENET_Receive_IRQHandler
ENET_Receive_IRQHandler:
  b .

  .thumb_func
  .weak ENET_Error_IRQHandler
ENET_Error_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_CMP0_IRQHandler
PWM1_CMP0_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_RELOAD0_IRQHandler
PWM1_RELOAD0_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_CMP1_IRQHandler
PWM1_CMP1_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_RELOAD1_IRQHandler
PWM1_RELOAD1_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_CMP2_IRQHandler
PWM1_CMP2_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_RELOAD2_IRQHandler
PWM1_RELOAD2_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_CMP3_IRQHandler
PWM1_CMP3_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_RELOAD3_IRQHandler
PWM1_RELOAD3_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_CAP_IRQHandler
PWM1_CAP_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_RERR_IRQHandler
PWM1_RERR_IRQHandler:
  b .

  .thumb_func
  .weak PWM1_FAULT_IRQHandler
PWM1_FAULT_IRQHandler:
  b .

  .thumb_func
  .weak CAN2_ORed_Message_buffer_IRQHandler
CAN2_ORed_Message_buffer_IRQHandler:
  b .

  .thumb_func
  .weak CAN2_Bus_Off_IRQHandler
CAN2_Bus_Off_IRQHandler:
  b .

  .thumb_func
  .weak CAN2_Error_IRQHandler
CAN2_Error_IRQHandler:
  b .

  .thumb_func
  .weak CAN2_Tx_Warning_IRQHandler
CAN2_Tx_Warning_IRQHandler:
  b .

  .thumb_func
  .weak CAN2_Rx_Warning_IRQHandler
CAN2_Rx_Warning_IRQHandler:
  b .

  .thumb_func
  .weak CAN2_Wake_Up_IRQHandler
CAN2_Wake_Up_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word DMA0_DMA16_IRQHandler
  .word DMA1_DMA17_IRQHandler
  .word DMA2_DMA18_IRQHandler
  .word DMA3_DMA19_IRQHandler
  .word DMA4_DMA20_IRQHandler
  .word DMA5_DMA21_IRQHandler
  .word DMA6_DMA22_IRQHandler
  .word DMA7_DMA23_IRQHandler
  .word DMA8_DMA24_IRQHandler
  .word DMA9_DMA25_IRQHandler
  .word DMA10_DMA26_IRQHandler
  .word DMA11_DMA27_IRQHandler
  .word DMA12_DMA28_IRQHandler
  .word DMA13_DMA29_IRQHandler
  .word DMA14_DMA30_IRQHandler
  .word DMA15_DMA31_IRQHandler
  .word DMA_Error_IRQHandler
  .word MCM_IRQHandler
  .word FTFE_IRQHandler
  .word Read_Collision_IRQHandler
  .word PMC_IRQHandler
  .word LLWU_IRQHandler
  .word WDOG_EWM_IRQHandler
  .word TRNG0_IRQHandler
  .word I2C0_IRQHandler
  .word I2C1_IRQHandler
  .word SPI0_IRQHandler
  .word SPI1_IRQHandler
  .word UART5_RX_TX_IRQHandler
  .word UART5_ERR_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word UART0_RX_TX_IRQHandler
  .word UART0_ERR_IRQHandler
  .word UART1_RX_TX_IRQHandler
  .word UART1_ERR_IRQHandler
  .word UART2_RX_TX_IRQHandler
  .word UART2_ERR_IRQHandler
  .word ADC0_IRQHandler
  .word HSADC_ERR_IRQHandler
  .word HSADC0_CCA_IRQHandler
  .word CMP0_IRQHandler
  .word CMP1_IRQHandler
  .word FTM0_IRQHandler
  .word FTM1_IRQHandler
  .word UART3_RX_TX_IRQHandler
  .word UART3_ERR_IRQHandler
  .word UART4_RX_TX_IRQHandler
  .word UART4_ERR_IRQHandler
  .word PIT0_IRQHandler
  .word PIT1_IRQHandler
  .word PIT2_IRQHandler
  .word PIT3_IRQHandler
  .word PDB0_IRQHandler
  .word FTM2_IRQHandler
  .word XBARA_IRQHandler
  .word PDB1_IRQHandler
  .word DAC0_IRQHandler
  .word MCG_IRQHandler
  .word LPTMR0_IRQHandler
  .word PORTA_IRQHandler
  .word PORTB_IRQHandler
  .word PORTC_IRQHandler
  .word PORTD_IRQHandler
  .word PORTE_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word SPI2_IRQHandler
  .word ENC_COMPARE_IRQHandler
  .word ENC_HOME_IRQHandler
  .word ENC_WDOG_SAB_IRQHandler
  .word ENC_INDEX_IRQHandler
  .word CMP2_IRQHandler
  .word FTM3_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word HSADC0_CCB_IRQHandler
  .word HSADC1_CCA_IRQHandler
  .word CAN0_ORed_Message_buffer_IRQHandler
  .word CAN0_Bus_Off_IRQHandler
  .word CAN0_Error_IRQHandler
  .word CAN0_Tx_Warning_IRQHandler
  .word CAN0_Rx_Warning_IRQHandler
  .word CAN0_Wake_Up_IRQHandler
  .word PWM0_CMP0_IRQHandler
  .word PWM0_RELOAD0_IRQHandler
  .word PWM0_CMP1_IRQHandler
  .word PWM0_RELOAD1_IRQHandler
  .word PWM0_CMP2_IRQHandler
  .word PWM0_RELOAD2_IRQHandler
  .word PWM0_CMP3_IRQHandler
  .word PWM0_RELOAD3_IRQHandler
  .word PWM0_CAP_IRQHandler
  .word PWM0_RERR_IRQHandler
  .word PWM0_FAULT_IRQHandler
  .word CMP3_IRQHandler
  .word HSADC1_CCB_IRQHandler
  .word CAN1_ORed_Message_buffer_IRQHandler
  .word CAN1_Bus_Off_IRQHandler
  .word CAN1_Error_IRQHandler
  .word CAN1_Tx_Warning_IRQHandler
  .word CAN1_Rx_Warning_IRQHandler
  .word CAN1_Wake_Up_IRQHandler
  .word ENET_1588_Timer_IRQHandler
  .word ENET_Transmit_IRQHandler
  .word ENET_Receive_IRQHandler
  .word ENET_Error_IRQHandler
  .word PWM1_CMP0_IRQHandler
  .word PWM1_RELOAD0_IRQHandler
  .word PWM1_CMP1_IRQHandler
  .word PWM1_RELOAD1_IRQHandler
  .word PWM1_CMP2_IRQHandler
  .word PWM1_RELOAD2_IRQHandler
  .word PWM1_CMP3_IRQHandler
  .word PWM1_RELOAD3_IRQHandler
  .word PWM1_CAP_IRQHandler
  .word PWM1_RERR_IRQHandler
  .word PWM1_FAULT_IRQHandler
  .word CAN2_ORed_Message_buffer_IRQHandler
  .word CAN2_Bus_Off_IRQHandler
  .word CAN2_Error_IRQHandler
  .word CAN2_Tx_Warning_IRQHandler
  .word CAN2_Rx_Warning_IRQHandler
  .word CAN2_Wake_Up_IRQHandler
_vectors_end:

#if 1
  .section .vectors, "ax"
  // fill to 0x400 for the flash configuration field
  //.fill 0x400-(_vectors_end-_vectors), 1, 0xff
  .org 0x400, 0xFF
BackDoorKey:
  .byte 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
#if defined(E_SERIES)
RESERVED:
  .byte 0xff, 0xff, 0xff, 0xff
EEPROT:
  .byte 0xff
FPROT:
  .byte 0xff
FSEC:
  .byte 0xfe
FOPT:
  .byte 0xff
#else
FPROT:
  .byte 0xff, 0xff, 0xff, 0xff
FSEC:
  .byte 0xfe
FOPT:
#if defined(MKL03Z4) || defined(MKL17Z4) || defined(MKL17Z644) || defined(MKL27Z4)  || defined(MKL27Z644) || defined(MKL33Z4) || defined(MKL33Z644) || defined(MKL43Z4)
  .byte 0x3b
#else 
  .byte 0xff
#endif
FEPROT:
  .byte 0xff
FDPROT:
  .byte 0xff
#endif
#endif

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
